// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An activity that performs a transformation on a message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineActivity {
    /// <p>Determines the source of the messages to be processed.</p>
    pub channel: std::option::Option<crate::model::ChannelActivity>,
    /// <p>Runs a Lambda function to modify the message.</p>
    pub lambda: std::option::Option<crate::model::LambdaActivity>,
    /// <p>Specifies where to store the processed message data.</p>
    pub datastore: std::option::Option<crate::model::DatastoreActivity>,
    /// <p>Adds other attributes based on existing attributes in the message.</p>
    pub add_attributes: std::option::Option<crate::model::AddAttributesActivity>,
    /// <p>Removes attributes from a message.</p>
    pub remove_attributes: std::option::Option<crate::model::RemoveAttributesActivity>,
    /// <p>Used to create a new message using only the specified attributes from the original message. </p>
    pub select_attributes: std::option::Option<crate::model::SelectAttributesActivity>,
    /// <p>Filters a message based on its attributes.</p>
    pub filter: std::option::Option<crate::model::FilterActivity>,
    /// <p>Computes an arithmetic expression using the message's attributes and adds it to the message.</p>
    pub math: std::option::Option<crate::model::MathActivity>,
    /// <p>Adds data from the IoT device registry to your message.</p>
    pub device_registry_enrich: std::option::Option<crate::model::DeviceRegistryEnrichActivity>,
    /// <p>Adds information from the IoT Device Shadow service to a message.</p>
    pub device_shadow_enrich: std::option::Option<crate::model::DeviceShadowEnrichActivity>,
}
impl PipelineActivity {
    /// <p>Determines the source of the messages to be processed.</p>
    pub fn channel(&self) -> std::option::Option<&crate::model::ChannelActivity> {
        self.channel.as_ref()
    }
    /// <p>Runs a Lambda function to modify the message.</p>
    pub fn lambda(&self) -> std::option::Option<&crate::model::LambdaActivity> {
        self.lambda.as_ref()
    }
    /// <p>Specifies where to store the processed message data.</p>
    pub fn datastore(&self) -> std::option::Option<&crate::model::DatastoreActivity> {
        self.datastore.as_ref()
    }
    /// <p>Adds other attributes based on existing attributes in the message.</p>
    pub fn add_attributes(&self) -> std::option::Option<&crate::model::AddAttributesActivity> {
        self.add_attributes.as_ref()
    }
    /// <p>Removes attributes from a message.</p>
    pub fn remove_attributes(
        &self,
    ) -> std::option::Option<&crate::model::RemoveAttributesActivity> {
        self.remove_attributes.as_ref()
    }
    /// <p>Used to create a new message using only the specified attributes from the original message. </p>
    pub fn select_attributes(
        &self,
    ) -> std::option::Option<&crate::model::SelectAttributesActivity> {
        self.select_attributes.as_ref()
    }
    /// <p>Filters a message based on its attributes.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::FilterActivity> {
        self.filter.as_ref()
    }
    /// <p>Computes an arithmetic expression using the message's attributes and adds it to the message.</p>
    pub fn math(&self) -> std::option::Option<&crate::model::MathActivity> {
        self.math.as_ref()
    }
    /// <p>Adds data from the IoT device registry to your message.</p>
    pub fn device_registry_enrich(
        &self,
    ) -> std::option::Option<&crate::model::DeviceRegistryEnrichActivity> {
        self.device_registry_enrich.as_ref()
    }
    /// <p>Adds information from the IoT Device Shadow service to a message.</p>
    pub fn device_shadow_enrich(
        &self,
    ) -> std::option::Option<&crate::model::DeviceShadowEnrichActivity> {
        self.device_shadow_enrich.as_ref()
    }
}
impl std::fmt::Debug for PipelineActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineActivity");
        formatter.field("channel", &self.channel);
        formatter.field("lambda", &self.lambda);
        formatter.field("datastore", &self.datastore);
        formatter.field("add_attributes", &self.add_attributes);
        formatter.field("remove_attributes", &self.remove_attributes);
        formatter.field("select_attributes", &self.select_attributes);
        formatter.field("filter", &self.filter);
        formatter.field("math", &self.math);
        formatter.field("device_registry_enrich", &self.device_registry_enrich);
        formatter.field("device_shadow_enrich", &self.device_shadow_enrich);
        formatter.finish()
    }
}
/// See [`PipelineActivity`](crate::model::PipelineActivity)
pub mod pipeline_activity {
    /// A builder for [`PipelineActivity`](crate::model::PipelineActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel: std::option::Option<crate::model::ChannelActivity>,
        pub(crate) lambda: std::option::Option<crate::model::LambdaActivity>,
        pub(crate) datastore: std::option::Option<crate::model::DatastoreActivity>,
        pub(crate) add_attributes: std::option::Option<crate::model::AddAttributesActivity>,
        pub(crate) remove_attributes: std::option::Option<crate::model::RemoveAttributesActivity>,
        pub(crate) select_attributes: std::option::Option<crate::model::SelectAttributesActivity>,
        pub(crate) filter: std::option::Option<crate::model::FilterActivity>,
        pub(crate) math: std::option::Option<crate::model::MathActivity>,
        pub(crate) device_registry_enrich:
            std::option::Option<crate::model::DeviceRegistryEnrichActivity>,
        pub(crate) device_shadow_enrich:
            std::option::Option<crate::model::DeviceShadowEnrichActivity>,
    }
    impl Builder {
        /// <p>Determines the source of the messages to be processed.</p>
        pub fn channel(mut self, input: crate::model::ChannelActivity) -> Self {
            self.channel = Some(input);
            self
        }
        /// <p>Determines the source of the messages to be processed.</p>
        pub fn set_channel(
            mut self,
            input: std::option::Option<crate::model::ChannelActivity>,
        ) -> Self {
            self.channel = input;
            self
        }
        /// <p>Runs a Lambda function to modify the message.</p>
        pub fn lambda(mut self, input: crate::model::LambdaActivity) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>Runs a Lambda function to modify the message.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::LambdaActivity>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// <p>Specifies where to store the processed message data.</p>
        pub fn datastore(mut self, input: crate::model::DatastoreActivity) -> Self {
            self.datastore = Some(input);
            self
        }
        /// <p>Specifies where to store the processed message data.</p>
        pub fn set_datastore(
            mut self,
            input: std::option::Option<crate::model::DatastoreActivity>,
        ) -> Self {
            self.datastore = input;
            self
        }
        /// <p>Adds other attributes based on existing attributes in the message.</p>
        pub fn add_attributes(mut self, input: crate::model::AddAttributesActivity) -> Self {
            self.add_attributes = Some(input);
            self
        }
        /// <p>Adds other attributes based on existing attributes in the message.</p>
        pub fn set_add_attributes(
            mut self,
            input: std::option::Option<crate::model::AddAttributesActivity>,
        ) -> Self {
            self.add_attributes = input;
            self
        }
        /// <p>Removes attributes from a message.</p>
        pub fn remove_attributes(mut self, input: crate::model::RemoveAttributesActivity) -> Self {
            self.remove_attributes = Some(input);
            self
        }
        /// <p>Removes attributes from a message.</p>
        pub fn set_remove_attributes(
            mut self,
            input: std::option::Option<crate::model::RemoveAttributesActivity>,
        ) -> Self {
            self.remove_attributes = input;
            self
        }
        /// <p>Used to create a new message using only the specified attributes from the original message. </p>
        pub fn select_attributes(mut self, input: crate::model::SelectAttributesActivity) -> Self {
            self.select_attributes = Some(input);
            self
        }
        /// <p>Used to create a new message using only the specified attributes from the original message. </p>
        pub fn set_select_attributes(
            mut self,
            input: std::option::Option<crate::model::SelectAttributesActivity>,
        ) -> Self {
            self.select_attributes = input;
            self
        }
        /// <p>Filters a message based on its attributes.</p>
        pub fn filter(mut self, input: crate::model::FilterActivity) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters a message based on its attributes.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::FilterActivity>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Computes an arithmetic expression using the message's attributes and adds it to the message.</p>
        pub fn math(mut self, input: crate::model::MathActivity) -> Self {
            self.math = Some(input);
            self
        }
        /// <p>Computes an arithmetic expression using the message's attributes and adds it to the message.</p>
        pub fn set_math(mut self, input: std::option::Option<crate::model::MathActivity>) -> Self {
            self.math = input;
            self
        }
        /// <p>Adds data from the IoT device registry to your message.</p>
        pub fn device_registry_enrich(
            mut self,
            input: crate::model::DeviceRegistryEnrichActivity,
        ) -> Self {
            self.device_registry_enrich = Some(input);
            self
        }
        /// <p>Adds data from the IoT device registry to your message.</p>
        pub fn set_device_registry_enrich(
            mut self,
            input: std::option::Option<crate::model::DeviceRegistryEnrichActivity>,
        ) -> Self {
            self.device_registry_enrich = input;
            self
        }
        /// <p>Adds information from the IoT Device Shadow service to a message.</p>
        pub fn device_shadow_enrich(
            mut self,
            input: crate::model::DeviceShadowEnrichActivity,
        ) -> Self {
            self.device_shadow_enrich = Some(input);
            self
        }
        /// <p>Adds information from the IoT Device Shadow service to a message.</p>
        pub fn set_device_shadow_enrich(
            mut self,
            input: std::option::Option<crate::model::DeviceShadowEnrichActivity>,
        ) -> Self {
            self.device_shadow_enrich = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineActivity`](crate::model::PipelineActivity)
        pub fn build(self) -> crate::model::PipelineActivity {
            crate::model::PipelineActivity {
                channel: self.channel,
                lambda: self.lambda,
                datastore: self.datastore,
                add_attributes: self.add_attributes,
                remove_attributes: self.remove_attributes,
                select_attributes: self.select_attributes,
                filter: self.filter,
                math: self.math,
                device_registry_enrich: self.device_registry_enrich,
                device_shadow_enrich: self.device_shadow_enrich,
            }
        }
    }
}
impl PipelineActivity {
    /// Creates a new builder-style object to manufacture [`PipelineActivity`](crate::model::PipelineActivity)
    pub fn builder() -> crate::model::pipeline_activity::Builder {
        crate::model::pipeline_activity::Builder::default()
    }
}

/// <p>An activity that adds information from the IoT Device Shadow service to a message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceShadowEnrichActivity {
    /// <p>The name of the <code>deviceShadowEnrich</code> activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the attribute that is added to the message.</p>
    pub attribute: std::option::Option<std::string::String>,
    /// <p>The name of the IoT device whose shadow information is added to the message.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that allows access to the device's shadow.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl DeviceShadowEnrichActivity {
    /// <p>The name of the <code>deviceShadowEnrich</code> activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the attribute that is added to the message.</p>
    pub fn attribute(&self) -> std::option::Option<&str> {
        self.attribute.as_deref()
    }
    /// <p>The name of the IoT device whose shadow information is added to the message.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The ARN of the role that allows access to the device's shadow.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for DeviceShadowEnrichActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceShadowEnrichActivity");
        formatter.field("name", &self.name);
        formatter.field("attribute", &self.attribute);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`DeviceShadowEnrichActivity`](crate::model::DeviceShadowEnrichActivity)
pub mod device_shadow_enrich_activity {
    /// A builder for [`DeviceShadowEnrichActivity`](crate::model::DeviceShadowEnrichActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attribute: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>deviceShadowEnrich</code> activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>deviceShadowEnrich</code> activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the attribute that is added to the message.</p>
        pub fn attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute = Some(input.into());
            self
        }
        /// <p>The name of the attribute that is added to the message.</p>
        pub fn set_attribute(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The name of the IoT device whose shadow information is added to the message.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT device whose shadow information is added to the message.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ARN of the role that allows access to the device's shadow.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that allows access to the device's shadow.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceShadowEnrichActivity`](crate::model::DeviceShadowEnrichActivity)
        pub fn build(self) -> crate::model::DeviceShadowEnrichActivity {
            crate::model::DeviceShadowEnrichActivity {
                name: self.name,
                attribute: self.attribute,
                thing_name: self.thing_name,
                role_arn: self.role_arn,
                next: self.next,
            }
        }
    }
}
impl DeviceShadowEnrichActivity {
    /// Creates a new builder-style object to manufacture [`DeviceShadowEnrichActivity`](crate::model::DeviceShadowEnrichActivity)
    pub fn builder() -> crate::model::device_shadow_enrich_activity::Builder {
        crate::model::device_shadow_enrich_activity::Builder::default()
    }
}

/// <p>An activity that adds data from the IoT device registry to your message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceRegistryEnrichActivity {
    /// <p>The name of the <code>deviceRegistryEnrich</code> activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the attribute that is added to the message.</p>
    pub attribute: std::option::Option<std::string::String>,
    /// <p>The name of the IoT device whose registry information is added to the message.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that allows access to the device's registry information.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl DeviceRegistryEnrichActivity {
    /// <p>The name of the <code>deviceRegistryEnrich</code> activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the attribute that is added to the message.</p>
    pub fn attribute(&self) -> std::option::Option<&str> {
        self.attribute.as_deref()
    }
    /// <p>The name of the IoT device whose registry information is added to the message.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The ARN of the role that allows access to the device's registry information.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for DeviceRegistryEnrichActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceRegistryEnrichActivity");
        formatter.field("name", &self.name);
        formatter.field("attribute", &self.attribute);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`DeviceRegistryEnrichActivity`](crate::model::DeviceRegistryEnrichActivity)
pub mod device_registry_enrich_activity {
    /// A builder for [`DeviceRegistryEnrichActivity`](crate::model::DeviceRegistryEnrichActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attribute: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>deviceRegistryEnrich</code> activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>deviceRegistryEnrich</code> activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the attribute that is added to the message.</p>
        pub fn attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute = Some(input.into());
            self
        }
        /// <p>The name of the attribute that is added to the message.</p>
        pub fn set_attribute(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The name of the IoT device whose registry information is added to the message.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT device whose registry information is added to the message.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ARN of the role that allows access to the device's registry information.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that allows access to the device's registry information.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceRegistryEnrichActivity`](crate::model::DeviceRegistryEnrichActivity)
        pub fn build(self) -> crate::model::DeviceRegistryEnrichActivity {
            crate::model::DeviceRegistryEnrichActivity {
                name: self.name,
                attribute: self.attribute,
                thing_name: self.thing_name,
                role_arn: self.role_arn,
                next: self.next,
            }
        }
    }
}
impl DeviceRegistryEnrichActivity {
    /// Creates a new builder-style object to manufacture [`DeviceRegistryEnrichActivity`](crate::model::DeviceRegistryEnrichActivity)
    pub fn builder() -> crate::model::device_registry_enrich_activity::Builder {
        crate::model::device_registry_enrich_activity::Builder::default()
    }
}

/// <p>An activity that computes an arithmetic expression using the message's attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MathActivity {
    /// <p>The name of the math activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the attribute that contains the result of the math operation.</p>
    pub attribute: std::option::Option<std::string::String>,
    /// <p>An expression that uses one or more existing attributes and must return an integer value.</p>
    pub math: std::option::Option<std::string::String>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl MathActivity {
    /// <p>The name of the math activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the attribute that contains the result of the math operation.</p>
    pub fn attribute(&self) -> std::option::Option<&str> {
        self.attribute.as_deref()
    }
    /// <p>An expression that uses one or more existing attributes and must return an integer value.</p>
    pub fn math(&self) -> std::option::Option<&str> {
        self.math.as_deref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for MathActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MathActivity");
        formatter.field("name", &self.name);
        formatter.field("attribute", &self.attribute);
        formatter.field("math", &self.math);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`MathActivity`](crate::model::MathActivity)
pub mod math_activity {
    /// A builder for [`MathActivity`](crate::model::MathActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attribute: std::option::Option<std::string::String>,
        pub(crate) math: std::option::Option<std::string::String>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the math activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the math activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the attribute that contains the result of the math operation.</p>
        pub fn attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute = Some(input.into());
            self
        }
        /// <p>The name of the attribute that contains the result of the math operation.</p>
        pub fn set_attribute(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attribute = input;
            self
        }
        /// <p>An expression that uses one or more existing attributes and must return an integer value.</p>
        pub fn math(mut self, input: impl Into<std::string::String>) -> Self {
            self.math = Some(input.into());
            self
        }
        /// <p>An expression that uses one or more existing attributes and must return an integer value.</p>
        pub fn set_math(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.math = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`MathActivity`](crate::model::MathActivity)
        pub fn build(self) -> crate::model::MathActivity {
            crate::model::MathActivity {
                name: self.name,
                attribute: self.attribute,
                math: self.math,
                next: self.next,
            }
        }
    }
}
impl MathActivity {
    /// Creates a new builder-style object to manufacture [`MathActivity`](crate::model::MathActivity)
    pub fn builder() -> crate::model::math_activity::Builder {
        crate::model::math_activity::Builder::default()
    }
}

/// <p>An activity that filters a message based on its attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterActivity {
    /// <p>The name of the filter activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that satisfy the condition are passed to the next activity. </p>
    pub filter: std::option::Option<std::string::String>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl FilterActivity {
    /// <p>The name of the filter activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that satisfy the condition are passed to the next activity. </p>
    pub fn filter(&self) -> std::option::Option<&str> {
        self.filter.as_deref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for FilterActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterActivity");
        formatter.field("name", &self.name);
        formatter.field("filter", &self.filter);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`FilterActivity`](crate::model::FilterActivity)
pub mod filter_activity {
    /// A builder for [`FilterActivity`](crate::model::FilterActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<std::string::String>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that satisfy the condition are passed to the next activity. </p>
        pub fn filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter = Some(input.into());
            self
        }
        /// <p>An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that satisfy the condition are passed to the next activity. </p>
        pub fn set_filter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterActivity`](crate::model::FilterActivity)
        pub fn build(self) -> crate::model::FilterActivity {
            crate::model::FilterActivity {
                name: self.name,
                filter: self.filter,
                next: self.next,
            }
        }
    }
}
impl FilterActivity {
    /// Creates a new builder-style object to manufacture [`FilterActivity`](crate::model::FilterActivity)
    pub fn builder() -> crate::model::filter_activity::Builder {
        crate::model::filter_activity::Builder::default()
    }
}

/// <p>Used to create a new message using only the specified attributes from the original message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelectAttributesActivity {
    /// <p>The name of the <code>selectAttributes</code> activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the attributes to select from the message.</p>
    pub attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl SelectAttributesActivity {
    /// <p>The name of the <code>selectAttributes</code> activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the attributes to select from the message.</p>
    pub fn attributes(&self) -> std::option::Option<&[std::string::String]> {
        self.attributes.as_deref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for SelectAttributesActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectAttributesActivity");
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`SelectAttributesActivity`](crate::model::SelectAttributesActivity)
pub mod select_attributes_activity {
    /// A builder for [`SelectAttributesActivity`](crate::model::SelectAttributesActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>selectAttributes</code> activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>selectAttributes</code> activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of the attributes to select from the message.</p>
        pub fn attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>A list of the attributes to select from the message.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectAttributesActivity`](crate::model::SelectAttributesActivity)
        pub fn build(self) -> crate::model::SelectAttributesActivity {
            crate::model::SelectAttributesActivity {
                name: self.name,
                attributes: self.attributes,
                next: self.next,
            }
        }
    }
}
impl SelectAttributesActivity {
    /// Creates a new builder-style object to manufacture [`SelectAttributesActivity`](crate::model::SelectAttributesActivity)
    pub fn builder() -> crate::model::select_attributes_activity::Builder {
        crate::model::select_attributes_activity::Builder::default()
    }
}

/// <p>An activity that removes attributes from a message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAttributesActivity {
    /// <p>The name of the <code>removeAttributes</code> activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of 1-50 attributes to remove from the message.</p>
    pub attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl RemoveAttributesActivity {
    /// <p>The name of the <code>removeAttributes</code> activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of 1-50 attributes to remove from the message.</p>
    pub fn attributes(&self) -> std::option::Option<&[std::string::String]> {
        self.attributes.as_deref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for RemoveAttributesActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAttributesActivity");
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`RemoveAttributesActivity`](crate::model::RemoveAttributesActivity)
pub mod remove_attributes_activity {
    /// A builder for [`RemoveAttributesActivity`](crate::model::RemoveAttributesActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>removeAttributes</code> activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>removeAttributes</code> activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of 1-50 attributes to remove from the message.</p>
        pub fn attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>A list of 1-50 attributes to remove from the message.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAttributesActivity`](crate::model::RemoveAttributesActivity)
        pub fn build(self) -> crate::model::RemoveAttributesActivity {
            crate::model::RemoveAttributesActivity {
                name: self.name,
                attributes: self.attributes,
                next: self.next,
            }
        }
    }
}
impl RemoveAttributesActivity {
    /// Creates a new builder-style object to manufacture [`RemoveAttributesActivity`](crate::model::RemoveAttributesActivity)
    pub fn builder() -> crate::model::remove_attributes_activity::Builder {
        crate::model::remove_attributes_activity::Builder::default()
    }
}

/// <p>An activity that adds other attributes based on existing attributes in the message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddAttributesActivity {
    /// <p>The name of the addAttributes activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of 1-50 <code>AttributeNameMapping</code> objects that map an existing attribute to a new attribute.</p> <note>
    /// <p>The existing attributes remain in the message, so if you want to remove the originals, use <code>RemoveAttributeActivity</code>.</p>
    /// </note>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl AddAttributesActivity {
    /// <p>The name of the addAttributes activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of 1-50 <code>AttributeNameMapping</code> objects that map an existing attribute to a new attribute.</p> <note>
    /// <p>The existing attributes remain in the message, so if you want to remove the originals, use <code>RemoveAttributeActivity</code>.</p>
    /// </note>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for AddAttributesActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddAttributesActivity");
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`AddAttributesActivity`](crate::model::AddAttributesActivity)
pub mod add_attributes_activity {
    /// A builder for [`AddAttributesActivity`](crate::model::AddAttributesActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the addAttributes activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the addAttributes activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of 1-50 <code>AttributeNameMapping</code> objects that map an existing attribute to a new attribute.</p> <note>
        /// <p>The existing attributes remain in the message, so if you want to remove the originals, use <code>RemoveAttributeActivity</code>.</p>
        /// </note>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A list of 1-50 <code>AttributeNameMapping</code> objects that map an existing attribute to a new attribute.</p> <note>
        /// <p>The existing attributes remain in the message, so if you want to remove the originals, use <code>RemoveAttributeActivity</code>.</p>
        /// </note>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`AddAttributesActivity`](crate::model::AddAttributesActivity)
        pub fn build(self) -> crate::model::AddAttributesActivity {
            crate::model::AddAttributesActivity {
                name: self.name,
                attributes: self.attributes,
                next: self.next,
            }
        }
    }
}
impl AddAttributesActivity {
    /// Creates a new builder-style object to manufacture [`AddAttributesActivity`](crate::model::AddAttributesActivity)
    pub fn builder() -> crate::model::add_attributes_activity::Builder {
        crate::model::add_attributes_activity::Builder::default()
    }
}

/// <p>The datastore activity that specifies where to store the processed data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreActivity {
    /// <p>The name of the datastore activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the data store where processed messages are stored.</p>
    pub datastore_name: std::option::Option<std::string::String>,
}
impl DatastoreActivity {
    /// <p>The name of the datastore activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the data store where processed messages are stored.</p>
    pub fn datastore_name(&self) -> std::option::Option<&str> {
        self.datastore_name.as_deref()
    }
}
impl std::fmt::Debug for DatastoreActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreActivity");
        formatter.field("name", &self.name);
        formatter.field("datastore_name", &self.datastore_name);
        formatter.finish()
    }
}
/// See [`DatastoreActivity`](crate::model::DatastoreActivity)
pub mod datastore_activity {
    /// A builder for [`DatastoreActivity`](crate::model::DatastoreActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) datastore_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the datastore activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the datastore activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the data store where processed messages are stored.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_name = Some(input.into());
            self
        }
        /// <p>The name of the data store where processed messages are stored.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreActivity`](crate::model::DatastoreActivity)
        pub fn build(self) -> crate::model::DatastoreActivity {
            crate::model::DatastoreActivity {
                name: self.name,
                datastore_name: self.datastore_name,
            }
        }
    }
}
impl DatastoreActivity {
    /// Creates a new builder-style object to manufacture [`DatastoreActivity`](crate::model::DatastoreActivity)
    pub fn builder() -> crate::model::datastore_activity::Builder {
        crate::model::datastore_activity::Builder::default()
    }
}

/// <p>An activity that runs a Lambda function to modify the message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaActivity {
    /// <p>The name of the lambda activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function that is run on the message.</p>
    pub lambda_name: std::option::Option<std::string::String>,
    /// <p>The number of messages passed to the Lambda function for processing.</p>
    /// <p>The Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.</p>
    pub batch_size: std::option::Option<i32>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl LambdaActivity {
    /// <p>The name of the lambda activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the Lambda function that is run on the message.</p>
    pub fn lambda_name(&self) -> std::option::Option<&str> {
        self.lambda_name.as_deref()
    }
    /// <p>The number of messages passed to the Lambda function for processing.</p>
    /// <p>The Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.</p>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for LambdaActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaActivity");
        formatter.field("name", &self.name);
        formatter.field("lambda_name", &self.lambda_name);
        formatter.field("batch_size", &self.batch_size);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`LambdaActivity`](crate::model::LambdaActivity)
pub mod lambda_activity {
    /// A builder for [`LambdaActivity`](crate::model::LambdaActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) lambda_name: std::option::Option<std::string::String>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lambda activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the lambda activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the Lambda function that is run on the message.</p>
        pub fn lambda_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function that is run on the message.</p>
        pub fn set_lambda_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_name = input;
            self
        }
        /// <p>The number of messages passed to the Lambda function for processing.</p>
        /// <p>The Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The number of messages passed to the Lambda function for processing.</p>
        /// <p>The Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaActivity`](crate::model::LambdaActivity)
        pub fn build(self) -> crate::model::LambdaActivity {
            crate::model::LambdaActivity {
                name: self.name,
                lambda_name: self.lambda_name,
                batch_size: self.batch_size,
                next: self.next,
            }
        }
    }
}
impl LambdaActivity {
    /// Creates a new builder-style object to manufacture [`LambdaActivity`](crate::model::LambdaActivity)
    pub fn builder() -> crate::model::lambda_activity::Builder {
        crate::model::lambda_activity::Builder::default()
    }
}

/// <p>The activity that determines the source of the messages to be processed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelActivity {
    /// <p>The name of the channel activity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the channel from which the messages are processed.</p>
    pub channel_name: std::option::Option<std::string::String>,
    /// <p>The next activity in the pipeline.</p>
    pub next: std::option::Option<std::string::String>,
}
impl ChannelActivity {
    /// <p>The name of the channel activity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the channel from which the messages are processed.</p>
    pub fn channel_name(&self) -> std::option::Option<&str> {
        self.channel_name.as_deref()
    }
    /// <p>The next activity in the pipeline.</p>
    pub fn next(&self) -> std::option::Option<&str> {
        self.next.as_deref()
    }
}
impl std::fmt::Debug for ChannelActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelActivity");
        formatter.field("name", &self.name);
        formatter.field("channel_name", &self.channel_name);
        formatter.field("next", &self.next);
        formatter.finish()
    }
}
/// See [`ChannelActivity`](crate::model::ChannelActivity)
pub mod channel_activity {
    /// A builder for [`ChannelActivity`](crate::model::ChannelActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) channel_name: std::option::Option<std::string::String>,
        pub(crate) next: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the channel activity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel activity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the channel from which the messages are processed.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_name = Some(input.into());
            self
        }
        /// <p>The name of the channel from which the messages are processed.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_name = input;
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn next(mut self, input: impl Into<std::string::String>) -> Self {
            self.next = Some(input.into());
            self
        }
        /// <p>The next activity in the pipeline.</p>
        pub fn set_next(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelActivity`](crate::model::ChannelActivity)
        pub fn build(self) -> crate::model::ChannelActivity {
            crate::model::ChannelActivity {
                name: self.name,
                channel_name: self.channel_name,
                next: self.next,
            }
        }
    }
}
impl ChannelActivity {
    /// Creates a new builder-style object to manufacture [`ChannelActivity`](crate::model::ChannelActivity)
    pub fn builder() -> crate::model::channel_activity::Builder {
        crate::model::channel_activity::Builder::default()
    }
}

/// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
/// <p>The default file format is JSON. You can specify only one format.</p>
/// <p>You can't change the file format after you create the data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileFormatConfiguration {
    /// <p>Contains the configuration information of the JSON format.</p>
    pub json_configuration: std::option::Option<crate::model::JsonConfiguration>,
    /// <p>Contains the configuration information of the Parquet format.</p>
    pub parquet_configuration: std::option::Option<crate::model::ParquetConfiguration>,
}
impl FileFormatConfiguration {
    /// <p>Contains the configuration information of the JSON format.</p>
    pub fn json_configuration(&self) -> std::option::Option<&crate::model::JsonConfiguration> {
        self.json_configuration.as_ref()
    }
    /// <p>Contains the configuration information of the Parquet format.</p>
    pub fn parquet_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ParquetConfiguration> {
        self.parquet_configuration.as_ref()
    }
}
impl std::fmt::Debug for FileFormatConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileFormatConfiguration");
        formatter.field("json_configuration", &self.json_configuration);
        formatter.field("parquet_configuration", &self.parquet_configuration);
        formatter.finish()
    }
}
/// See [`FileFormatConfiguration`](crate::model::FileFormatConfiguration)
pub mod file_format_configuration {
    /// A builder for [`FileFormatConfiguration`](crate::model::FileFormatConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) json_configuration: std::option::Option<crate::model::JsonConfiguration>,
        pub(crate) parquet_configuration: std::option::Option<crate::model::ParquetConfiguration>,
    }
    impl Builder {
        /// <p>Contains the configuration information of the JSON format.</p>
        pub fn json_configuration(mut self, input: crate::model::JsonConfiguration) -> Self {
            self.json_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of the JSON format.</p>
        pub fn set_json_configuration(
            mut self,
            input: std::option::Option<crate::model::JsonConfiguration>,
        ) -> Self {
            self.json_configuration = input;
            self
        }
        /// <p>Contains the configuration information of the Parquet format.</p>
        pub fn parquet_configuration(mut self, input: crate::model::ParquetConfiguration) -> Self {
            self.parquet_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of the Parquet format.</p>
        pub fn set_parquet_configuration(
            mut self,
            input: std::option::Option<crate::model::ParquetConfiguration>,
        ) -> Self {
            self.parquet_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`FileFormatConfiguration`](crate::model::FileFormatConfiguration)
        pub fn build(self) -> crate::model::FileFormatConfiguration {
            crate::model::FileFormatConfiguration {
                json_configuration: self.json_configuration,
                parquet_configuration: self.parquet_configuration,
            }
        }
    }
}
impl FileFormatConfiguration {
    /// Creates a new builder-style object to manufacture [`FileFormatConfiguration`](crate::model::FileFormatConfiguration)
    pub fn builder() -> crate::model::file_format_configuration::Builder {
        crate::model::file_format_configuration::Builder::default()
    }
}

/// <p>Contains the configuration information of the Parquet format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParquetConfiguration {
    /// <p>Information needed to define a schema.</p>
    pub schema_definition: std::option::Option<crate::model::SchemaDefinition>,
}
impl ParquetConfiguration {
    /// <p>Information needed to define a schema.</p>
    pub fn schema_definition(&self) -> std::option::Option<&crate::model::SchemaDefinition> {
        self.schema_definition.as_ref()
    }
}
impl std::fmt::Debug for ParquetConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParquetConfiguration");
        formatter.field("schema_definition", &self.schema_definition);
        formatter.finish()
    }
}
/// See [`ParquetConfiguration`](crate::model::ParquetConfiguration)
pub mod parquet_configuration {
    /// A builder for [`ParquetConfiguration`](crate::model::ParquetConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_definition: std::option::Option<crate::model::SchemaDefinition>,
    }
    impl Builder {
        /// <p>Information needed to define a schema.</p>
        pub fn schema_definition(mut self, input: crate::model::SchemaDefinition) -> Self {
            self.schema_definition = Some(input);
            self
        }
        /// <p>Information needed to define a schema.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<crate::model::SchemaDefinition>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`ParquetConfiguration`](crate::model::ParquetConfiguration)
        pub fn build(self) -> crate::model::ParquetConfiguration {
            crate::model::ParquetConfiguration {
                schema_definition: self.schema_definition,
            }
        }
    }
}
impl ParquetConfiguration {
    /// Creates a new builder-style object to manufacture [`ParquetConfiguration`](crate::model::ParquetConfiguration)
    pub fn builder() -> crate::model::parquet_configuration::Builder {
        crate::model::parquet_configuration::Builder::default()
    }
}

/// <p>Information needed to define a schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaDefinition {
    /// <p>Specifies one or more columns that store your data.</p>
    /// <p>Each schema can have up to 100 columns. Each column can have up to 100 nested types.</p>
    pub columns: std::option::Option<std::vec::Vec<crate::model::Column>>,
}
impl SchemaDefinition {
    /// <p>Specifies one or more columns that store your data.</p>
    /// <p>Each schema can have up to 100 columns. Each column can have up to 100 nested types.</p>
    pub fn columns(&self) -> std::option::Option<&[crate::model::Column]> {
        self.columns.as_deref()
    }
}
impl std::fmt::Debug for SchemaDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaDefinition");
        formatter.field("columns", &self.columns);
        formatter.finish()
    }
}
/// See [`SchemaDefinition`](crate::model::SchemaDefinition)
pub mod schema_definition {
    /// A builder for [`SchemaDefinition`](crate::model::SchemaDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) columns: std::option::Option<std::vec::Vec<crate::model::Column>>,
    }
    impl Builder {
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>Specifies one or more columns that store your data.</p>
        /// <p>Each schema can have up to 100 columns. Each column can have up to 100 nested types.</p>
        pub fn columns(mut self, input: crate::model::Column) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input);
            self.columns = Some(v);
            self
        }
        /// <p>Specifies one or more columns that store your data.</p>
        /// <p>Each schema can have up to 100 columns. Each column can have up to 100 nested types.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Column>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaDefinition`](crate::model::SchemaDefinition)
        pub fn build(self) -> crate::model::SchemaDefinition {
            crate::model::SchemaDefinition {
                columns: self.columns,
            }
        }
    }
}
impl SchemaDefinition {
    /// Creates a new builder-style object to manufacture [`SchemaDefinition`](crate::model::SchemaDefinition)
    pub fn builder() -> crate::model::schema_definition::Builder {
        crate::model::schema_definition::Builder::default()
    }
}

/// <p>Contains information about a column that stores your data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Column {
    /// <p>The name of the column.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of data. For more information about the supported data types, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html">Common data types</a> in the <i>Glue Developer Guide</i>.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl Column {
    /// <p>The name of the column.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of data. For more information about the supported data types, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html">Common data types</a> in the <i>Glue Developer Guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for Column {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Column");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Column`](crate::model::Column)
pub mod column {
    /// A builder for [`Column`](crate::model::Column)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of data. For more information about the supported data types, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html">Common data types</a> in the <i>Glue Developer Guide</i>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of data. For more information about the supported data types, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html">Common data types</a> in the <i>Glue Developer Guide</i>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Column`](crate::model::Column)
        pub fn build(self) -> crate::model::Column {
            crate::model::Column {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl Column {
    /// Creates a new builder-style object to manufacture [`Column`](crate::model::Column)
    pub fn builder() -> crate::model::column::Builder {
        crate::model::column::Builder::default()
    }
}

/// <p>Contains the configuration information of the JSON format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonConfiguration {}
impl std::fmt::Debug for JsonConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonConfiguration");
        formatter.finish()
    }
}
/// See [`JsonConfiguration`](crate::model::JsonConfiguration)
pub mod json_configuration {
    /// A builder for [`JsonConfiguration`](crate::model::JsonConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`JsonConfiguration`](crate::model::JsonConfiguration)
        pub fn build(self) -> crate::model::JsonConfiguration {
            crate::model::JsonConfiguration {}
        }
    }
}
impl JsonConfiguration {
    /// Creates a new builder-style object to manufacture [`JsonConfiguration`](crate::model::JsonConfiguration)
    pub fn builder() -> crate::model::json_configuration::Builder {
        crate::model::json_configuration::Builder::default()
    }
}

/// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum DatastoreStorage {
    /// <p>S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of Amazon S3 storage after your data store is created. </p>
    CustomerManagedS3(crate::model::CustomerManagedDatastoreS3Storage),
    /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of Amazon S3 storage after your data store is created. </p>
    IotSiteWiseMultiLayerStorage(crate::model::DatastoreIotSiteWiseMultiLayerStorage),
    /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3 storage after your data store is created. </p>
    ServiceManagedS3(crate::model::ServiceManagedDatastoreS3Storage),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl DatastoreStorage {
    /// Tries to convert the enum instance into [`CustomerManagedS3`](crate::model::DatastoreStorage::CustomerManagedS3), extracting the inner [`CustomerManagedDatastoreS3Storage`](crate::model::CustomerManagedDatastoreS3Storage).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_customer_managed_s3(
        &self,
    ) -> std::result::Result<&crate::model::CustomerManagedDatastoreS3Storage, &Self> {
        if let DatastoreStorage::CustomerManagedS3(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`CustomerManagedS3`](crate::model::DatastoreStorage::CustomerManagedS3).
    pub fn is_customer_managed_s3(&self) -> bool {
        self.as_customer_managed_s3().is_ok()
    }
    /// Tries to convert the enum instance into [`IotSiteWiseMultiLayerStorage`](crate::model::DatastoreStorage::IotSiteWiseMultiLayerStorage), extracting the inner [`DatastoreIotSiteWiseMultiLayerStorage`](crate::model::DatastoreIotSiteWiseMultiLayerStorage).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_iot_site_wise_multi_layer_storage(
        &self,
    ) -> std::result::Result<&crate::model::DatastoreIotSiteWiseMultiLayerStorage, &Self> {
        if let DatastoreStorage::IotSiteWiseMultiLayerStorage(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`IotSiteWiseMultiLayerStorage`](crate::model::DatastoreStorage::IotSiteWiseMultiLayerStorage).
    pub fn is_iot_site_wise_multi_layer_storage(&self) -> bool {
        self.as_iot_site_wise_multi_layer_storage().is_ok()
    }
    /// Tries to convert the enum instance into [`ServiceManagedS3`](crate::model::DatastoreStorage::ServiceManagedS3), extracting the inner [`ServiceManagedDatastoreS3Storage`](crate::model::ServiceManagedDatastoreS3Storage).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_service_managed_s3(
        &self,
    ) -> std::result::Result<&crate::model::ServiceManagedDatastoreS3Storage, &Self> {
        if let DatastoreStorage::ServiceManagedS3(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ServiceManagedS3`](crate::model::DatastoreStorage::ServiceManagedS3).
    pub fn is_service_managed_s3(&self) -> bool {
        self.as_service_managed_s3().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of Amazon S3 storage after your data store is created. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreIotSiteWiseMultiLayerStorage {
    /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
    pub customer_managed_s3_storage:
        std::option::Option<crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage>,
}
impl DatastoreIotSiteWiseMultiLayerStorage {
    /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
    pub fn customer_managed_s3_storage(
        &self,
    ) -> std::option::Option<&crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage> {
        self.customer_managed_s3_storage.as_ref()
    }
}
impl std::fmt::Debug for DatastoreIotSiteWiseMultiLayerStorage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreIotSiteWiseMultiLayerStorage");
        formatter.field(
            "customer_managed_s3_storage",
            &self.customer_managed_s3_storage,
        );
        formatter.finish()
    }
}
/// See [`DatastoreIotSiteWiseMultiLayerStorage`](crate::model::DatastoreIotSiteWiseMultiLayerStorage)
pub mod datastore_iot_site_wise_multi_layer_storage {
    /// A builder for [`DatastoreIotSiteWiseMultiLayerStorage`](crate::model::DatastoreIotSiteWiseMultiLayerStorage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_managed_s3_storage:
            std::option::Option<crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage>,
    }
    impl Builder {
        /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
        pub fn customer_managed_s3_storage(
            mut self,
            input: crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage,
        ) -> Self {
            self.customer_managed_s3_storage = Some(input);
            self
        }
        /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
        pub fn set_customer_managed_s3_storage(
            mut self,
            input: std::option::Option<crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage>,
        ) -> Self {
            self.customer_managed_s3_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreIotSiteWiseMultiLayerStorage`](crate::model::DatastoreIotSiteWiseMultiLayerStorage)
        pub fn build(self) -> crate::model::DatastoreIotSiteWiseMultiLayerStorage {
            crate::model::DatastoreIotSiteWiseMultiLayerStorage {
                customer_managed_s3_storage: self.customer_managed_s3_storage,
            }
        }
    }
}
impl DatastoreIotSiteWiseMultiLayerStorage {
    /// Creates a new builder-style object to manufacture [`DatastoreIotSiteWiseMultiLayerStorage`](crate::model::DatastoreIotSiteWiseMultiLayerStorage)
    pub fn builder() -> crate::model::datastore_iot_site_wise_multi_layer_storage::Builder {
        crate::model::datastore_iot_site_wise_multi_layer_storage::Builder::default()
    }
}

/// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of Amazon S3 storage after your data store is created. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotSiteWiseCustomerManagedDatastoreS3Storage {
    /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
    pub key_prefix: std::option::Option<std::string::String>,
}
impl IotSiteWiseCustomerManagedDatastoreS3Storage {
    /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
}
impl std::fmt::Debug for IotSiteWiseCustomerManagedDatastoreS3Storage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotSiteWiseCustomerManagedDatastoreS3Storage");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.finish()
    }
}
/// See [`IotSiteWiseCustomerManagedDatastoreS3Storage`](crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage)
pub mod iot_site_wise_customer_managed_datastore_s3_storage {
    /// A builder for [`IotSiteWiseCustomerManagedDatastoreS3Storage`](crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`IotSiteWiseCustomerManagedDatastoreS3Storage`](crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage)
        pub fn build(self) -> crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage {
            crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
            }
        }
    }
}
impl IotSiteWiseCustomerManagedDatastoreS3Storage {
    /// Creates a new builder-style object to manufacture [`IotSiteWiseCustomerManagedDatastoreS3Storage`](crate::model::IotSiteWiseCustomerManagedDatastoreS3Storage)
    pub fn builder() -> crate::model::iot_site_wise_customer_managed_datastore_s3_storage::Builder {
        crate::model::iot_site_wise_customer_managed_datastore_s3_storage::Builder::default()
    }
}

/// <p>S3-customer-managed; When you choose customer-managed storage, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of Amazon S3 storage after your data store is created. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerManagedDatastoreS3Storage {
    /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
    pub key_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CustomerManagedDatastoreS3Storage {
    /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomerManagedDatastoreS3Storage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerManagedDatastoreS3Storage");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CustomerManagedDatastoreS3Storage`](crate::model::CustomerManagedDatastoreS3Storage)
pub mod customer_managed_datastore_s3_storage {
    /// A builder for [`CustomerManagedDatastoreS3Storage`](crate::model::CustomerManagedDatastoreS3Storage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerManagedDatastoreS3Storage`](crate::model::CustomerManagedDatastoreS3Storage)
        pub fn build(self) -> crate::model::CustomerManagedDatastoreS3Storage {
            crate::model::CustomerManagedDatastoreS3Storage {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CustomerManagedDatastoreS3Storage {
    /// Creates a new builder-style object to manufacture [`CustomerManagedDatastoreS3Storage`](crate::model::CustomerManagedDatastoreS3Storage)
    pub fn builder() -> crate::model::customer_managed_datastore_s3_storage::Builder {
        crate::model::customer_managed_datastore_s3_storage::Builder::default()
    }
}

/// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics. You can't change the choice of Amazon S3 storage after your data store is created. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceManagedDatastoreS3Storage {}
impl std::fmt::Debug for ServiceManagedDatastoreS3Storage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceManagedDatastoreS3Storage");
        formatter.finish()
    }
}
/// See [`ServiceManagedDatastoreS3Storage`](crate::model::ServiceManagedDatastoreS3Storage)
pub mod service_managed_datastore_s3_storage {
    /// A builder for [`ServiceManagedDatastoreS3Storage`](crate::model::ServiceManagedDatastoreS3Storage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ServiceManagedDatastoreS3Storage`](crate::model::ServiceManagedDatastoreS3Storage)
        pub fn build(self) -> crate::model::ServiceManagedDatastoreS3Storage {
            crate::model::ServiceManagedDatastoreS3Storage {}
        }
    }
}
impl ServiceManagedDatastoreS3Storage {
    /// Creates a new builder-style object to manufacture [`ServiceManagedDatastoreS3Storage`](crate::model::ServiceManagedDatastoreS3Storage)
    pub fn builder() -> crate::model::service_managed_datastore_s3_storage::Builder {
        crate::model::service_managed_datastore_s3_storage::Builder::default()
    }
}

/// <p>How long, in days, message data is kept.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetentionPeriod {
    /// <p>If true, message data is kept indefinitely.</p>
    pub unlimited: bool,
    /// <p>The number of days that message data is kept. The <code>unlimited</code> parameter must be false.</p>
    pub number_of_days: std::option::Option<i32>,
}
impl RetentionPeriod {
    /// <p>If true, message data is kept indefinitely.</p>
    pub fn unlimited(&self) -> bool {
        self.unlimited
    }
    /// <p>The number of days that message data is kept. The <code>unlimited</code> parameter must be false.</p>
    pub fn number_of_days(&self) -> std::option::Option<i32> {
        self.number_of_days
    }
}
impl std::fmt::Debug for RetentionPeriod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetentionPeriod");
        formatter.field("unlimited", &self.unlimited);
        formatter.field("number_of_days", &self.number_of_days);
        formatter.finish()
    }
}
/// See [`RetentionPeriod`](crate::model::RetentionPeriod)
pub mod retention_period {
    /// A builder for [`RetentionPeriod`](crate::model::RetentionPeriod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unlimited: std::option::Option<bool>,
        pub(crate) number_of_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If true, message data is kept indefinitely.</p>
        pub fn unlimited(mut self, input: bool) -> Self {
            self.unlimited = Some(input);
            self
        }
        /// <p>If true, message data is kept indefinitely.</p>
        pub fn set_unlimited(mut self, input: std::option::Option<bool>) -> Self {
            self.unlimited = input;
            self
        }
        /// <p>The number of days that message data is kept. The <code>unlimited</code> parameter must be false.</p>
        pub fn number_of_days(mut self, input: i32) -> Self {
            self.number_of_days = Some(input);
            self
        }
        /// <p>The number of days that message data is kept. The <code>unlimited</code> parameter must be false.</p>
        pub fn set_number_of_days(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_days = input;
            self
        }
        /// Consumes the builder and constructs a [`RetentionPeriod`](crate::model::RetentionPeriod)
        pub fn build(self) -> crate::model::RetentionPeriod {
            crate::model::RetentionPeriod {
                unlimited: self.unlimited.unwrap_or_default(),
                number_of_days: self.number_of_days,
            }
        }
    }
}
impl RetentionPeriod {
    /// Creates a new builder-style object to manufacture [`RetentionPeriod`](crate::model::RetentionPeriod)
    pub fn builder() -> crate::model::retention_period::Builder {
        crate::model::retention_period::Builder::default()
    }
}

/// <p>A structure that contains the name and configuration information of a late data rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LateDataRule {
    /// <p>The name of the late data rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The information needed to configure the late data rule.</p>
    pub rule_configuration: std::option::Option<crate::model::LateDataRuleConfiguration>,
}
impl LateDataRule {
    /// <p>The name of the late data rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The information needed to configure the late data rule.</p>
    pub fn rule_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LateDataRuleConfiguration> {
        self.rule_configuration.as_ref()
    }
}
impl std::fmt::Debug for LateDataRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LateDataRule");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("rule_configuration", &self.rule_configuration);
        formatter.finish()
    }
}
/// See [`LateDataRule`](crate::model::LateDataRule)
pub mod late_data_rule {
    /// A builder for [`LateDataRule`](crate::model::LateDataRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) rule_configuration: std::option::Option<crate::model::LateDataRuleConfiguration>,
    }
    impl Builder {
        /// <p>The name of the late data rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the late data rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The information needed to configure the late data rule.</p>
        pub fn rule_configuration(
            mut self,
            input: crate::model::LateDataRuleConfiguration,
        ) -> Self {
            self.rule_configuration = Some(input);
            self
        }
        /// <p>The information needed to configure the late data rule.</p>
        pub fn set_rule_configuration(
            mut self,
            input: std::option::Option<crate::model::LateDataRuleConfiguration>,
        ) -> Self {
            self.rule_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`LateDataRule`](crate::model::LateDataRule)
        pub fn build(self) -> crate::model::LateDataRule {
            crate::model::LateDataRule {
                rule_name: self.rule_name,
                rule_configuration: self.rule_configuration,
            }
        }
    }
}
impl LateDataRule {
    /// Creates a new builder-style object to manufacture [`LateDataRule`](crate::model::LateDataRule)
    pub fn builder() -> crate::model::late_data_rule::Builder {
        crate::model::late_data_rule::Builder::default()
    }
}

/// <p>The information needed to configure a delta time session window.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LateDataRuleConfiguration {
    /// <p>The information needed to configure a delta time session window.</p>
    pub delta_time_session_window_configuration:
        std::option::Option<crate::model::DeltaTimeSessionWindowConfiguration>,
}
impl LateDataRuleConfiguration {
    /// <p>The information needed to configure a delta time session window.</p>
    pub fn delta_time_session_window_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeltaTimeSessionWindowConfiguration> {
        self.delta_time_session_window_configuration.as_ref()
    }
}
impl std::fmt::Debug for LateDataRuleConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LateDataRuleConfiguration");
        formatter.field(
            "delta_time_session_window_configuration",
            &self.delta_time_session_window_configuration,
        );
        formatter.finish()
    }
}
/// See [`LateDataRuleConfiguration`](crate::model::LateDataRuleConfiguration)
pub mod late_data_rule_configuration {
    /// A builder for [`LateDataRuleConfiguration`](crate::model::LateDataRuleConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delta_time_session_window_configuration:
            std::option::Option<crate::model::DeltaTimeSessionWindowConfiguration>,
    }
    impl Builder {
        /// <p>The information needed to configure a delta time session window.</p>
        pub fn delta_time_session_window_configuration(
            mut self,
            input: crate::model::DeltaTimeSessionWindowConfiguration,
        ) -> Self {
            self.delta_time_session_window_configuration = Some(input);
            self
        }
        /// <p>The information needed to configure a delta time session window.</p>
        pub fn set_delta_time_session_window_configuration(
            mut self,
            input: std::option::Option<crate::model::DeltaTimeSessionWindowConfiguration>,
        ) -> Self {
            self.delta_time_session_window_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`LateDataRuleConfiguration`](crate::model::LateDataRuleConfiguration)
        pub fn build(self) -> crate::model::LateDataRuleConfiguration {
            crate::model::LateDataRuleConfiguration {
                delta_time_session_window_configuration: self
                    .delta_time_session_window_configuration,
            }
        }
    }
}
impl LateDataRuleConfiguration {
    /// Creates a new builder-style object to manufacture [`LateDataRuleConfiguration`](crate::model::LateDataRuleConfiguration)
    pub fn builder() -> crate::model::late_data_rule_configuration::Builder {
        crate::model::late_data_rule_configuration::Builder::default()
    }
}

/// <p>A structure that contains the configuration information of a delta time session window.</p>
/// <p> <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html"> <code>DeltaTime</code> </a> specifies a time interval. You can use <code>DeltaTime</code> to create dataset contents with data that has arrived in the data store since the last execution. For an example of <code>DeltaTime</code>, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/automate-create-dataset.html#automate-example6"> Creating a SQL dataset with a delta window (CLI)</a> in the <i>IoT Analytics User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeltaTimeSessionWindowConfiguration {
    /// <p>A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late data notifications that have been generated since the last execution. IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.</p>
    /// <p>For more information about how to write a timestamp expression, see <a href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and Operators</a>, in the <i>Presto 0.172 Documentation</i>.</p>
    pub timeout_in_minutes: std::option::Option<i32>,
}
impl DeltaTimeSessionWindowConfiguration {
    /// <p>A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late data notifications that have been generated since the last execution. IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.</p>
    /// <p>For more information about how to write a timestamp expression, see <a href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and Operators</a>, in the <i>Presto 0.172 Documentation</i>.</p>
    pub fn timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.timeout_in_minutes
    }
}
impl std::fmt::Debug for DeltaTimeSessionWindowConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeltaTimeSessionWindowConfiguration");
        formatter.field("timeout_in_minutes", &self.timeout_in_minutes);
        formatter.finish()
    }
}
/// See [`DeltaTimeSessionWindowConfiguration`](crate::model::DeltaTimeSessionWindowConfiguration)
pub mod delta_time_session_window_configuration {
    /// A builder for [`DeltaTimeSessionWindowConfiguration`](crate::model::DeltaTimeSessionWindowConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late data notifications that have been generated since the last execution. IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.</p>
        /// <p>For more information about how to write a timestamp expression, see <a href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and Operators</a>, in the <i>Presto 0.172 Documentation</i>.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.timeout_in_minutes = Some(input);
            self
        }
        /// <p>A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late data notifications that have been generated since the last execution. IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.</p>
        /// <p>For more information about how to write a timestamp expression, see <a href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and Operators</a>, in the <i>Presto 0.172 Documentation</i>.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`DeltaTimeSessionWindowConfiguration`](crate::model::DeltaTimeSessionWindowConfiguration)
        pub fn build(self) -> crate::model::DeltaTimeSessionWindowConfiguration {
            crate::model::DeltaTimeSessionWindowConfiguration {
                timeout_in_minutes: self.timeout_in_minutes,
            }
        }
    }
}
impl DeltaTimeSessionWindowConfiguration {
    /// Creates a new builder-style object to manufacture [`DeltaTimeSessionWindowConfiguration`](crate::model::DeltaTimeSessionWindowConfiguration)
    pub fn builder() -> crate::model::delta_time_session_window_configuration::Builder {
        crate::model::delta_time_session_window_configuration::Builder::default()
    }
}

/// <p>Information about the versioning of dataset contents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersioningConfiguration {
    /// <p>If true, unlimited versions of dataset contents are kept.</p>
    pub unlimited: bool,
    /// <p>How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be <code>false</code>.</p>
    pub max_versions: std::option::Option<i32>,
}
impl VersioningConfiguration {
    /// <p>If true, unlimited versions of dataset contents are kept.</p>
    pub fn unlimited(&self) -> bool {
        self.unlimited
    }
    /// <p>How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be <code>false</code>.</p>
    pub fn max_versions(&self) -> std::option::Option<i32> {
        self.max_versions
    }
}
impl std::fmt::Debug for VersioningConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersioningConfiguration");
        formatter.field("unlimited", &self.unlimited);
        formatter.field("max_versions", &self.max_versions);
        formatter.finish()
    }
}
/// See [`VersioningConfiguration`](crate::model::VersioningConfiguration)
pub mod versioning_configuration {
    /// A builder for [`VersioningConfiguration`](crate::model::VersioningConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unlimited: std::option::Option<bool>,
        pub(crate) max_versions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If true, unlimited versions of dataset contents are kept.</p>
        pub fn unlimited(mut self, input: bool) -> Self {
            self.unlimited = Some(input);
            self
        }
        /// <p>If true, unlimited versions of dataset contents are kept.</p>
        pub fn set_unlimited(mut self, input: std::option::Option<bool>) -> Self {
            self.unlimited = input;
            self
        }
        /// <p>How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be <code>false</code>.</p>
        pub fn max_versions(mut self, input: i32) -> Self {
            self.max_versions = Some(input);
            self
        }
        /// <p>How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be <code>false</code>.</p>
        pub fn set_max_versions(mut self, input: std::option::Option<i32>) -> Self {
            self.max_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`VersioningConfiguration`](crate::model::VersioningConfiguration)
        pub fn build(self) -> crate::model::VersioningConfiguration {
            crate::model::VersioningConfiguration {
                unlimited: self.unlimited.unwrap_or_default(),
                max_versions: self.max_versions,
            }
        }
    }
}
impl VersioningConfiguration {
    /// Creates a new builder-style object to manufacture [`VersioningConfiguration`](crate::model::VersioningConfiguration)
    pub fn builder() -> crate::model::versioning_configuration::Builder {
        crate::model::versioning_configuration::Builder::default()
    }
}

/// <p>When dataset contents are created, they are delivered to destination specified here.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetContentDeliveryRule {
    /// <p>The name of the dataset content delivery rules entry.</p>
    pub entry_name: std::option::Option<std::string::String>,
    /// <p>The destination to which dataset contents are delivered.</p>
    pub destination: std::option::Option<crate::model::DatasetContentDeliveryDestination>,
}
impl DatasetContentDeliveryRule {
    /// <p>The name of the dataset content delivery rules entry.</p>
    pub fn entry_name(&self) -> std::option::Option<&str> {
        self.entry_name.as_deref()
    }
    /// <p>The destination to which dataset contents are delivered.</p>
    pub fn destination(
        &self,
    ) -> std::option::Option<&crate::model::DatasetContentDeliveryDestination> {
        self.destination.as_ref()
    }
}
impl std::fmt::Debug for DatasetContentDeliveryRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetContentDeliveryRule");
        formatter.field("entry_name", &self.entry_name);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`DatasetContentDeliveryRule`](crate::model::DatasetContentDeliveryRule)
pub mod dataset_content_delivery_rule {
    /// A builder for [`DatasetContentDeliveryRule`](crate::model::DatasetContentDeliveryRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_name: std::option::Option<std::string::String>,
        pub(crate) destination:
            std::option::Option<crate::model::DatasetContentDeliveryDestination>,
    }
    impl Builder {
        /// <p>The name of the dataset content delivery rules entry.</p>
        pub fn entry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset content delivery rules entry.</p>
        pub fn set_entry_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_name = input;
            self
        }
        /// <p>The destination to which dataset contents are delivered.</p>
        pub fn destination(
            mut self,
            input: crate::model::DatasetContentDeliveryDestination,
        ) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination to which dataset contents are delivered.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::DatasetContentDeliveryDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetContentDeliveryRule`](crate::model::DatasetContentDeliveryRule)
        pub fn build(self) -> crate::model::DatasetContentDeliveryRule {
            crate::model::DatasetContentDeliveryRule {
                entry_name: self.entry_name,
                destination: self.destination,
            }
        }
    }
}
impl DatasetContentDeliveryRule {
    /// Creates a new builder-style object to manufacture [`DatasetContentDeliveryRule`](crate::model::DatasetContentDeliveryRule)
    pub fn builder() -> crate::model::dataset_content_delivery_rule::Builder {
        crate::model::dataset_content_delivery_rule::Builder::default()
    }
}

/// <p>The destination to which dataset contents are delivered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetContentDeliveryDestination {
    /// <p>Configuration information for delivery of dataset contents to IoT Events.</p>
    pub iot_events_destination_configuration:
        std::option::Option<crate::model::IotEventsDestinationConfiguration>,
    /// <p>Configuration information for delivery of dataset contents to Amazon S3.</p>
    pub s3_destination_configuration: std::option::Option<crate::model::S3DestinationConfiguration>,
}
impl DatasetContentDeliveryDestination {
    /// <p>Configuration information for delivery of dataset contents to IoT Events.</p>
    pub fn iot_events_destination_configuration(
        &self,
    ) -> std::option::Option<&crate::model::IotEventsDestinationConfiguration> {
        self.iot_events_destination_configuration.as_ref()
    }
    /// <p>Configuration information for delivery of dataset contents to Amazon S3.</p>
    pub fn s3_destination_configuration(
        &self,
    ) -> std::option::Option<&crate::model::S3DestinationConfiguration> {
        self.s3_destination_configuration.as_ref()
    }
}
impl std::fmt::Debug for DatasetContentDeliveryDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetContentDeliveryDestination");
        formatter.field(
            "iot_events_destination_configuration",
            &self.iot_events_destination_configuration,
        );
        formatter.field(
            "s3_destination_configuration",
            &self.s3_destination_configuration,
        );
        formatter.finish()
    }
}
/// See [`DatasetContentDeliveryDestination`](crate::model::DatasetContentDeliveryDestination)
pub mod dataset_content_delivery_destination {
    /// A builder for [`DatasetContentDeliveryDestination`](crate::model::DatasetContentDeliveryDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iot_events_destination_configuration:
            std::option::Option<crate::model::IotEventsDestinationConfiguration>,
        pub(crate) s3_destination_configuration:
            std::option::Option<crate::model::S3DestinationConfiguration>,
    }
    impl Builder {
        /// <p>Configuration information for delivery of dataset contents to IoT Events.</p>
        pub fn iot_events_destination_configuration(
            mut self,
            input: crate::model::IotEventsDestinationConfiguration,
        ) -> Self {
            self.iot_events_destination_configuration = Some(input);
            self
        }
        /// <p>Configuration information for delivery of dataset contents to IoT Events.</p>
        pub fn set_iot_events_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::IotEventsDestinationConfiguration>,
        ) -> Self {
            self.iot_events_destination_configuration = input;
            self
        }
        /// <p>Configuration information for delivery of dataset contents to Amazon S3.</p>
        pub fn s3_destination_configuration(
            mut self,
            input: crate::model::S3DestinationConfiguration,
        ) -> Self {
            self.s3_destination_configuration = Some(input);
            self
        }
        /// <p>Configuration information for delivery of dataset contents to Amazon S3.</p>
        pub fn set_s3_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::S3DestinationConfiguration>,
        ) -> Self {
            self.s3_destination_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetContentDeliveryDestination`](crate::model::DatasetContentDeliveryDestination)
        pub fn build(self) -> crate::model::DatasetContentDeliveryDestination {
            crate::model::DatasetContentDeliveryDestination {
                iot_events_destination_configuration: self.iot_events_destination_configuration,
                s3_destination_configuration: self.s3_destination_configuration,
            }
        }
    }
}
impl DatasetContentDeliveryDestination {
    /// Creates a new builder-style object to manufacture [`DatasetContentDeliveryDestination`](crate::model::DatasetContentDeliveryDestination)
    pub fn builder() -> crate::model::dataset_content_delivery_destination::Builder {
        crate::model::dataset_content_delivery_destination::Builder::default()
    }
}

/// <p>Configuration information for delivery of dataset contents to Amazon Simple Storage Service (Amazon S3).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DestinationConfiguration {
    /// <p>The name of the S3 bucket to which dataset contents are delivered.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.</p>
    /// <p>You can create a unique key with the following options:</p>
    /// <ul>
    /// <li> <p>Use <code>!{iotanalytics:scheduleTime}</code> to insert the time of a scheduled SQL query run.</p> </li>
    /// <li> <p>Use <code>!{iotanalytics:versionId}</code> to insert a unique hash that identifies a dataset content.</p> </li>
    /// <li> <p>Use <code>!{iotanalytics:creationTime}</code> to insert the creation time of a dataset content.</p> </li>
    /// </ul>
    /// <p>The following example creates a unique key for a CSV file: <code>dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv</code> </p> <note>
    /// <p>If you don't use <code>!{iotanalytics:versionId}</code> to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same <code>scheduleTime</code> but different <code>versionId</code>s. This means that one dataset content overwrites the other. </p>
    /// </note>
    pub key: std::option::Option<std::string::String>,
    /// <p>Configuration information for coordination with Glue, a fully managed extract, transform and load (ETL) service.</p>
    pub glue_configuration: std::option::Option<crate::model::GlueConfiguration>,
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue resources.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl S3DestinationConfiguration {
    /// <p>The name of the S3 bucket to which dataset contents are delivered.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.</p>
    /// <p>You can create a unique key with the following options:</p>
    /// <ul>
    /// <li> <p>Use <code>!{iotanalytics:scheduleTime}</code> to insert the time of a scheduled SQL query run.</p> </li>
    /// <li> <p>Use <code>!{iotanalytics:versionId}</code> to insert a unique hash that identifies a dataset content.</p> </li>
    /// <li> <p>Use <code>!{iotanalytics:creationTime}</code> to insert the creation time of a dataset content.</p> </li>
    /// </ul>
    /// <p>The following example creates a unique key for a CSV file: <code>dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv</code> </p> <note>
    /// <p>If you don't use <code>!{iotanalytics:versionId}</code> to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same <code>scheduleTime</code> but different <code>versionId</code>s. This means that one dataset content overwrites the other. </p>
    /// </note>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Configuration information for coordination with Glue, a fully managed extract, transform and load (ETL) service.</p>
    pub fn glue_configuration(&self) -> std::option::Option<&crate::model::GlueConfiguration> {
        self.glue_configuration.as_ref()
    }
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue resources.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for S3DestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DestinationConfiguration");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("glue_configuration", &self.glue_configuration);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
pub mod s3_destination_configuration {
    /// A builder for [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) glue_configuration: std::option::Option<crate::model::GlueConfiguration>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket to which dataset contents are delivered.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket to which dataset contents are delivered.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.</p>
        /// <p>You can create a unique key with the following options:</p>
        /// <ul>
        /// <li> <p>Use <code>!{iotanalytics:scheduleTime}</code> to insert the time of a scheduled SQL query run.</p> </li>
        /// <li> <p>Use <code>!{iotanalytics:versionId}</code> to insert a unique hash that identifies a dataset content.</p> </li>
        /// <li> <p>Use <code>!{iotanalytics:creationTime}</code> to insert the creation time of a dataset content.</p> </li>
        /// </ul>
        /// <p>The following example creates a unique key for a CSV file: <code>dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv</code> </p> <note>
        /// <p>If you don't use <code>!{iotanalytics:versionId}</code> to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same <code>scheduleTime</code> but different <code>versionId</code>s. This means that one dataset content overwrites the other. </p>
        /// </note>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.</p>
        /// <p>You can create a unique key with the following options:</p>
        /// <ul>
        /// <li> <p>Use <code>!{iotanalytics:scheduleTime}</code> to insert the time of a scheduled SQL query run.</p> </li>
        /// <li> <p>Use <code>!{iotanalytics:versionId}</code> to insert a unique hash that identifies a dataset content.</p> </li>
        /// <li> <p>Use <code>!{iotanalytics:creationTime}</code> to insert the creation time of a dataset content.</p> </li>
        /// </ul>
        /// <p>The following example creates a unique key for a CSV file: <code>dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv</code> </p> <note>
        /// <p>If you don't use <code>!{iotanalytics:versionId}</code> to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same <code>scheduleTime</code> but different <code>versionId</code>s. This means that one dataset content overwrites the other. </p>
        /// </note>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Configuration information for coordination with Glue, a fully managed extract, transform and load (ETL) service.</p>
        pub fn glue_configuration(mut self, input: crate::model::GlueConfiguration) -> Self {
            self.glue_configuration = Some(input);
            self
        }
        /// <p>Configuration information for coordination with Glue, a fully managed extract, transform and load (ETL) service.</p>
        pub fn set_glue_configuration(
            mut self,
            input: std::option::Option<crate::model::GlueConfiguration>,
        ) -> Self {
            self.glue_configuration = input;
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
        pub fn build(self) -> crate::model::S3DestinationConfiguration {
            crate::model::S3DestinationConfiguration {
                bucket: self.bucket,
                key: self.key,
                glue_configuration: self.glue_configuration,
                role_arn: self.role_arn,
            }
        }
    }
}
impl S3DestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`S3DestinationConfiguration`](crate::model::S3DestinationConfiguration)
    pub fn builder() -> crate::model::s3_destination_configuration::Builder {
        crate::model::s3_destination_configuration::Builder::default()
    }
}

/// <p>Configuration information for coordination with Glue, a fully managed extract, transform and load (ETL) service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlueConfiguration {
    /// <p>The name of the table in your Glue Data Catalog that is used to perform the ETL operations. An Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of the database in your Glue Data Catalog in which the table is located. An Glue Data Catalog database contains metadata tables.</p>
    pub database_name: std::option::Option<std::string::String>,
}
impl GlueConfiguration {
    /// <p>The name of the table in your Glue Data Catalog that is used to perform the ETL operations. An Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of the database in your Glue Data Catalog in which the table is located. An Glue Data Catalog database contains metadata tables.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
}
impl std::fmt::Debug for GlueConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlueConfiguration");
        formatter.field("table_name", &self.table_name);
        formatter.field("database_name", &self.database_name);
        formatter.finish()
    }
}
/// See [`GlueConfiguration`](crate::model::GlueConfiguration)
pub mod glue_configuration {
    /// A builder for [`GlueConfiguration`](crate::model::GlueConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table in your Glue Data Catalog that is used to perform the ETL operations. An Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table in your Glue Data Catalog that is used to perform the ETL operations. An Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of the database in your Glue Data Catalog in which the table is located. An Glue Data Catalog database contains metadata tables.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database in your Glue Data Catalog in which the table is located. An Glue Data Catalog database contains metadata tables.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GlueConfiguration`](crate::model::GlueConfiguration)
        pub fn build(self) -> crate::model::GlueConfiguration {
            crate::model::GlueConfiguration {
                table_name: self.table_name,
                database_name: self.database_name,
            }
        }
    }
}
impl GlueConfiguration {
    /// Creates a new builder-style object to manufacture [`GlueConfiguration`](crate::model::GlueConfiguration)
    pub fn builder() -> crate::model::glue_configuration::Builder {
        crate::model::glue_configuration::Builder::default()
    }
}

/// <p>Configuration information for delivery of dataset contents to IoT Events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotEventsDestinationConfiguration {
    /// <p>The name of the IoT Events input to which dataset contents are delivered.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events input.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl IotEventsDestinationConfiguration {
    /// <p>The name of the IoT Events input to which dataset contents are delivered.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events input.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for IotEventsDestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotEventsDestinationConfiguration");
        formatter.field("input_name", &self.input_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`IotEventsDestinationConfiguration`](crate::model::IotEventsDestinationConfiguration)
pub mod iot_events_destination_configuration {
    /// A builder for [`IotEventsDestinationConfiguration`](crate::model::IotEventsDestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IoT Events input to which dataset contents are delivered.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT Events input to which dataset contents are delivered.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events input.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events input.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`IotEventsDestinationConfiguration`](crate::model::IotEventsDestinationConfiguration)
        pub fn build(self) -> crate::model::IotEventsDestinationConfiguration {
            crate::model::IotEventsDestinationConfiguration {
                input_name: self.input_name,
                role_arn: self.role_arn,
            }
        }
    }
}
impl IotEventsDestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`IotEventsDestinationConfiguration`](crate::model::IotEventsDestinationConfiguration)
    pub fn builder() -> crate::model::iot_events_destination_configuration::Builder {
        crate::model::iot_events_destination_configuration::Builder::default()
    }
}

/// <p>The <code>DatasetTrigger</code> that specifies when the dataset is automatically updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetTrigger {
    /// <p>The Schedule when the trigger is initiated.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>The dataset whose content creation triggers the creation of this dataset's contents.</p>
    pub dataset: std::option::Option<crate::model::TriggeringDataset>,
}
impl DatasetTrigger {
    /// <p>The Schedule when the trigger is initiated.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::Schedule> {
        self.schedule.as_ref()
    }
    /// <p>The dataset whose content creation triggers the creation of this dataset's contents.</p>
    pub fn dataset(&self) -> std::option::Option<&crate::model::TriggeringDataset> {
        self.dataset.as_ref()
    }
}
impl std::fmt::Debug for DatasetTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetTrigger");
        formatter.field("schedule", &self.schedule);
        formatter.field("dataset", &self.dataset);
        formatter.finish()
    }
}
/// See [`DatasetTrigger`](crate::model::DatasetTrigger)
pub mod dataset_trigger {
    /// A builder for [`DatasetTrigger`](crate::model::DatasetTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) dataset: std::option::Option<crate::model::TriggeringDataset>,
    }
    impl Builder {
        /// <p>The Schedule when the trigger is initiated.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The Schedule when the trigger is initiated.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The dataset whose content creation triggers the creation of this dataset's contents.</p>
        pub fn dataset(mut self, input: crate::model::TriggeringDataset) -> Self {
            self.dataset = Some(input);
            self
        }
        /// <p>The dataset whose content creation triggers the creation of this dataset's contents.</p>
        pub fn set_dataset(
            mut self,
            input: std::option::Option<crate::model::TriggeringDataset>,
        ) -> Self {
            self.dataset = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetTrigger`](crate::model::DatasetTrigger)
        pub fn build(self) -> crate::model::DatasetTrigger {
            crate::model::DatasetTrigger {
                schedule: self.schedule,
                dataset: self.dataset,
            }
        }
    }
}
impl DatasetTrigger {
    /// Creates a new builder-style object to manufacture [`DatasetTrigger`](crate::model::DatasetTrigger)
    pub fn builder() -> crate::model::dataset_trigger::Builder {
        crate::model::dataset_trigger::Builder::default()
    }
}

/// <p>Information about the dataset whose content generation triggers the new dataset content generation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggeringDataset {
    /// <p>The name of the dataset whose content generation triggers the new dataset content generation.</p>
    pub name: std::option::Option<std::string::String>,
}
impl TriggeringDataset {
    /// <p>The name of the dataset whose content generation triggers the new dataset content generation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for TriggeringDataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggeringDataset");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`TriggeringDataset`](crate::model::TriggeringDataset)
pub mod triggering_dataset {
    /// A builder for [`TriggeringDataset`](crate::model::TriggeringDataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset whose content generation triggers the new dataset content generation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset whose content generation triggers the new dataset content generation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggeringDataset`](crate::model::TriggeringDataset)
        pub fn build(self) -> crate::model::TriggeringDataset {
            crate::model::TriggeringDataset { name: self.name }
        }
    }
}
impl TriggeringDataset {
    /// Creates a new builder-style object to manufacture [`TriggeringDataset`](crate::model::TriggeringDataset)
    pub fn builder() -> crate::model::triggering_dataset::Builder {
        crate::model::triggering_dataset::Builder::default()
    }
}

/// <p>The schedule for when to trigger an update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Schedule {
    /// <p>The expression that defines when to trigger an update. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub expression: std::option::Option<std::string::String>,
}
impl Schedule {
    /// <p>The expression that defines when to trigger an update. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
}
impl std::fmt::Debug for Schedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Schedule");
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`Schedule`](crate::model::Schedule)
pub mod schedule {
    /// A builder for [`Schedule`](crate::model::Schedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The expression that defines when to trigger an update. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The expression that defines when to trigger an update. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`Schedule`](crate::model::Schedule)
        pub fn build(self) -> crate::model::Schedule {
            crate::model::Schedule {
                expression: self.expression,
            }
        }
    }
}
impl Schedule {
    /// Creates a new builder-style object to manufacture [`Schedule`](crate::model::Schedule)
    pub fn builder() -> crate::model::schedule::Builder {
        crate::model::schedule::Builder::default()
    }
}

/// <p>A <code>DatasetAction</code> object that specifies how dataset contents are automatically created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetAction {
    /// <p>The name of the dataset action by which dataset contents are automatically created.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>An <code>SqlQueryDatasetAction</code> object that uses an SQL query to automatically create dataset contents.</p>
    pub query_action: std::option::Option<crate::model::SqlQueryDatasetAction>,
    /// <p>Information that allows the system to run a containerized application to create the dataset contents. The application must be in a Docker container along with any required support libraries.</p>
    pub container_action: std::option::Option<crate::model::ContainerDatasetAction>,
}
impl DatasetAction {
    /// <p>The name of the dataset action by which dataset contents are automatically created.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>An <code>SqlQueryDatasetAction</code> object that uses an SQL query to automatically create dataset contents.</p>
    pub fn query_action(&self) -> std::option::Option<&crate::model::SqlQueryDatasetAction> {
        self.query_action.as_ref()
    }
    /// <p>Information that allows the system to run a containerized application to create the dataset contents. The application must be in a Docker container along with any required support libraries.</p>
    pub fn container_action(&self) -> std::option::Option<&crate::model::ContainerDatasetAction> {
        self.container_action.as_ref()
    }
}
impl std::fmt::Debug for DatasetAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetAction");
        formatter.field("action_name", &self.action_name);
        formatter.field("query_action", &self.query_action);
        formatter.field("container_action", &self.container_action);
        formatter.finish()
    }
}
/// See [`DatasetAction`](crate::model::DatasetAction)
pub mod dataset_action {
    /// A builder for [`DatasetAction`](crate::model::DatasetAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) query_action: std::option::Option<crate::model::SqlQueryDatasetAction>,
        pub(crate) container_action: std::option::Option<crate::model::ContainerDatasetAction>,
    }
    impl Builder {
        /// <p>The name of the dataset action by which dataset contents are automatically created.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset action by which dataset contents are automatically created.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>An <code>SqlQueryDatasetAction</code> object that uses an SQL query to automatically create dataset contents.</p>
        pub fn query_action(mut self, input: crate::model::SqlQueryDatasetAction) -> Self {
            self.query_action = Some(input);
            self
        }
        /// <p>An <code>SqlQueryDatasetAction</code> object that uses an SQL query to automatically create dataset contents.</p>
        pub fn set_query_action(
            mut self,
            input: std::option::Option<crate::model::SqlQueryDatasetAction>,
        ) -> Self {
            self.query_action = input;
            self
        }
        /// <p>Information that allows the system to run a containerized application to create the dataset contents. The application must be in a Docker container along with any required support libraries.</p>
        pub fn container_action(mut self, input: crate::model::ContainerDatasetAction) -> Self {
            self.container_action = Some(input);
            self
        }
        /// <p>Information that allows the system to run a containerized application to create the dataset contents. The application must be in a Docker container along with any required support libraries.</p>
        pub fn set_container_action(
            mut self,
            input: std::option::Option<crate::model::ContainerDatasetAction>,
        ) -> Self {
            self.container_action = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetAction`](crate::model::DatasetAction)
        pub fn build(self) -> crate::model::DatasetAction {
            crate::model::DatasetAction {
                action_name: self.action_name,
                query_action: self.query_action,
                container_action: self.container_action,
            }
        }
    }
}
impl DatasetAction {
    /// Creates a new builder-style object to manufacture [`DatasetAction`](crate::model::DatasetAction)
    pub fn builder() -> crate::model::dataset_action::Builder {
        crate::model::dataset_action::Builder::default()
    }
}

/// <p>Information required to run the <code>containerAction</code> to produce dataset contents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerDatasetAction {
    /// <p>The ARN of the Docker container stored in your account. The Docker container contains an application and required support libraries and is used to generate dataset contents.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that gives permission to the system to access required resources to run the <code>containerAction</code>. This includes, at minimum, permission to retrieve the dataset contents that are the input to the containerized application.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>Configuration of the resource that executes the <code>containerAction</code>.</p>
    pub resource_configuration: std::option::Option<crate::model::ResourceConfiguration>,
    /// <p>The values of variables used in the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of <code>stringValue</code>, <code>datasetContentVersionValue</code>, or <code>outputFileUriValue</code>.</p>
    pub variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
}
impl ContainerDatasetAction {
    /// <p>The ARN of the Docker container stored in your account. The Docker container contains an application and required support libraries and is used to generate dataset contents.</p>
    pub fn image(&self) -> std::option::Option<&str> {
        self.image.as_deref()
    }
    /// <p>The ARN of the role that gives permission to the system to access required resources to run the <code>containerAction</code>. This includes, at minimum, permission to retrieve the dataset contents that are the input to the containerized application.</p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>Configuration of the resource that executes the <code>containerAction</code>.</p>
    pub fn resource_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ResourceConfiguration> {
        self.resource_configuration.as_ref()
    }
    /// <p>The values of variables used in the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of <code>stringValue</code>, <code>datasetContentVersionValue</code>, or <code>outputFileUriValue</code>.</p>
    pub fn variables(&self) -> std::option::Option<&[crate::model::Variable]> {
        self.variables.as_deref()
    }
}
impl std::fmt::Debug for ContainerDatasetAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerDatasetAction");
        formatter.field("image", &self.image);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("resource_configuration", &self.resource_configuration);
        formatter.field("variables", &self.variables);
        formatter.finish()
    }
}
/// See [`ContainerDatasetAction`](crate::model::ContainerDatasetAction)
pub mod container_dataset_action {
    /// A builder for [`ContainerDatasetAction`](crate::model::ContainerDatasetAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) resource_configuration: std::option::Option<crate::model::ResourceConfiguration>,
        pub(crate) variables: std::option::Option<std::vec::Vec<crate::model::Variable>>,
    }
    impl Builder {
        /// <p>The ARN of the Docker container stored in your account. The Docker container contains an application and required support libraries and is used to generate dataset contents.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The ARN of the Docker container stored in your account. The Docker container contains an application and required support libraries and is used to generate dataset contents.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>The ARN of the role that gives permission to the system to access required resources to run the <code>containerAction</code>. This includes, at minimum, permission to retrieve the dataset contents that are the input to the containerized application.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that gives permission to the system to access required resources to run the <code>containerAction</code>. This includes, at minimum, permission to retrieve the dataset contents that are the input to the containerized application.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>Configuration of the resource that executes the <code>containerAction</code>.</p>
        pub fn resource_configuration(
            mut self,
            input: crate::model::ResourceConfiguration,
        ) -> Self {
            self.resource_configuration = Some(input);
            self
        }
        /// <p>Configuration of the resource that executes the <code>containerAction</code>.</p>
        pub fn set_resource_configuration(
            mut self,
            input: std::option::Option<crate::model::ResourceConfiguration>,
        ) -> Self {
            self.resource_configuration = input;
            self
        }
        /// Appends an item to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>The values of variables used in the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of <code>stringValue</code>, <code>datasetContentVersionValue</code>, or <code>outputFileUriValue</code>.</p>
        pub fn variables(mut self, input: crate::model::Variable) -> Self {
            let mut v = self.variables.unwrap_or_default();
            v.push(input);
            self.variables = Some(v);
            self
        }
        /// <p>The values of variables used in the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of <code>stringValue</code>, <code>datasetContentVersionValue</code>, or <code>outputFileUriValue</code>.</p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Variable>>,
        ) -> Self {
            self.variables = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerDatasetAction`](crate::model::ContainerDatasetAction)
        pub fn build(self) -> crate::model::ContainerDatasetAction {
            crate::model::ContainerDatasetAction {
                image: self.image,
                execution_role_arn: self.execution_role_arn,
                resource_configuration: self.resource_configuration,
                variables: self.variables,
            }
        }
    }
}
impl ContainerDatasetAction {
    /// Creates a new builder-style object to manufacture [`ContainerDatasetAction`](crate::model::ContainerDatasetAction)
    pub fn builder() -> crate::model::container_dataset_action::Builder {
        crate::model::container_dataset_action::Builder::default()
    }
}

/// <p>An instance of a variable to be passed to the <code>containerAction</code> execution. Each variable must have a name and a value given by one of <code>stringValue</code>, <code>datasetContentVersionValue</code>, or <code>outputFileUriValue</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Variable {
    /// <p>The name of the variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the variable as a string.</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>The value of the variable as a double (numeric).</p>
    pub double_value: std::option::Option<f64>,
    /// <p>The value of the variable as a structure that specifies a dataset content version.</p>
    pub dataset_content_version_value:
        std::option::Option<crate::model::DatasetContentVersionValue>,
    /// <p>The value of the variable as a structure that specifies an output file URI.</p>
    pub output_file_uri_value: std::option::Option<crate::model::OutputFileUriValue>,
}
impl Variable {
    /// <p>The name of the variable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the variable as a string.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>The value of the variable as a double (numeric).</p>
    pub fn double_value(&self) -> std::option::Option<f64> {
        self.double_value
    }
    /// <p>The value of the variable as a structure that specifies a dataset content version.</p>
    pub fn dataset_content_version_value(
        &self,
    ) -> std::option::Option<&crate::model::DatasetContentVersionValue> {
        self.dataset_content_version_value.as_ref()
    }
    /// <p>The value of the variable as a structure that specifies an output file URI.</p>
    pub fn output_file_uri_value(&self) -> std::option::Option<&crate::model::OutputFileUriValue> {
        self.output_file_uri_value.as_ref()
    }
}
impl std::fmt::Debug for Variable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Variable");
        formatter.field("name", &self.name);
        formatter.field("string_value", &self.string_value);
        formatter.field("double_value", &self.double_value);
        formatter.field(
            "dataset_content_version_value",
            &self.dataset_content_version_value,
        );
        formatter.field("output_file_uri_value", &self.output_file_uri_value);
        formatter.finish()
    }
}
/// See [`Variable`](crate::model::Variable)
pub mod variable {
    /// A builder for [`Variable`](crate::model::Variable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) double_value: std::option::Option<f64>,
        pub(crate) dataset_content_version_value:
            std::option::Option<crate::model::DatasetContentVersionValue>,
        pub(crate) output_file_uri_value: std::option::Option<crate::model::OutputFileUriValue>,
    }
    impl Builder {
        /// <p>The name of the variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the variable as a string.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>The value of the variable as a string.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// <p>The value of the variable as a double (numeric).</p>
        pub fn double_value(mut self, input: f64) -> Self {
            self.double_value = Some(input);
            self
        }
        /// <p>The value of the variable as a double (numeric).</p>
        pub fn set_double_value(mut self, input: std::option::Option<f64>) -> Self {
            self.double_value = input;
            self
        }
        /// <p>The value of the variable as a structure that specifies a dataset content version.</p>
        pub fn dataset_content_version_value(
            mut self,
            input: crate::model::DatasetContentVersionValue,
        ) -> Self {
            self.dataset_content_version_value = Some(input);
            self
        }
        /// <p>The value of the variable as a structure that specifies a dataset content version.</p>
        pub fn set_dataset_content_version_value(
            mut self,
            input: std::option::Option<crate::model::DatasetContentVersionValue>,
        ) -> Self {
            self.dataset_content_version_value = input;
            self
        }
        /// <p>The value of the variable as a structure that specifies an output file URI.</p>
        pub fn output_file_uri_value(mut self, input: crate::model::OutputFileUriValue) -> Self {
            self.output_file_uri_value = Some(input);
            self
        }
        /// <p>The value of the variable as a structure that specifies an output file URI.</p>
        pub fn set_output_file_uri_value(
            mut self,
            input: std::option::Option<crate::model::OutputFileUriValue>,
        ) -> Self {
            self.output_file_uri_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Variable`](crate::model::Variable)
        pub fn build(self) -> crate::model::Variable {
            crate::model::Variable {
                name: self.name,
                string_value: self.string_value,
                double_value: self.double_value,
                dataset_content_version_value: self.dataset_content_version_value,
                output_file_uri_value: self.output_file_uri_value,
            }
        }
    }
}
impl Variable {
    /// Creates a new builder-style object to manufacture [`Variable`](crate::model::Variable)
    pub fn builder() -> crate::model::variable::Builder {
        crate::model::variable::Builder::default()
    }
}

/// <p>The value of the variable as a structure that specifies an output file URI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputFileUriValue {
    /// <p>The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.</p>
    pub file_name: std::option::Option<std::string::String>,
}
impl OutputFileUriValue {
    /// <p>The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.</p>
    pub fn file_name(&self) -> std::option::Option<&str> {
        self.file_name.as_deref()
    }
}
impl std::fmt::Debug for OutputFileUriValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputFileUriValue");
        formatter.field("file_name", &self.file_name);
        formatter.finish()
    }
}
/// See [`OutputFileUriValue`](crate::model::OutputFileUriValue)
pub mod output_file_uri_value {
    /// A builder for [`OutputFileUriValue`](crate::model::OutputFileUriValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.</p>
        pub fn file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_name = Some(input.into());
            self
        }
        /// <p>The URI of the location where dataset contents are stored, usually the URI of a file in an S3 bucket.</p>
        pub fn set_file_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_name = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputFileUriValue`](crate::model::OutputFileUriValue)
        pub fn build(self) -> crate::model::OutputFileUriValue {
            crate::model::OutputFileUriValue {
                file_name: self.file_name,
            }
        }
    }
}
impl OutputFileUriValue {
    /// Creates a new builder-style object to manufacture [`OutputFileUriValue`](crate::model::OutputFileUriValue)
    pub fn builder() -> crate::model::output_file_uri_value::Builder {
        crate::model::output_file_uri_value::Builder::default()
    }
}

/// <p>The dataset whose latest contents are used as input to the notebook or application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetContentVersionValue {
    /// <p>The name of the dataset whose latest contents are used as input to the notebook or application.</p>
    pub dataset_name: std::option::Option<std::string::String>,
}
impl DatasetContentVersionValue {
    /// <p>The name of the dataset whose latest contents are used as input to the notebook or application.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
}
impl std::fmt::Debug for DatasetContentVersionValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetContentVersionValue");
        formatter.field("dataset_name", &self.dataset_name);
        formatter.finish()
    }
}
/// See [`DatasetContentVersionValue`](crate::model::DatasetContentVersionValue)
pub mod dataset_content_version_value {
    /// A builder for [`DatasetContentVersionValue`](crate::model::DatasetContentVersionValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset whose latest contents are used as input to the notebook or application.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset whose latest contents are used as input to the notebook or application.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetContentVersionValue`](crate::model::DatasetContentVersionValue)
        pub fn build(self) -> crate::model::DatasetContentVersionValue {
            crate::model::DatasetContentVersionValue {
                dataset_name: self.dataset_name,
            }
        }
    }
}
impl DatasetContentVersionValue {
    /// Creates a new builder-style object to manufacture [`DatasetContentVersionValue`](crate::model::DatasetContentVersionValue)
    pub fn builder() -> crate::model::dataset_content_version_value::Builder {
        crate::model::dataset_content_version_value::Builder::default()
    }
}

/// <p>The configuration of the resource used to execute the <code>containerAction</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceConfiguration {
    /// <p>The type of the compute resource used to execute the <code>containerAction</code>. Possible values are: <code>ACU_1</code> (vCPU=4, memory=16 GiB) or <code>ACU_2</code> (vCPU=8, memory=32 GiB).</p>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
    /// <p>The size, in GB, of the persistent storage available to the resource instance used to execute the <code>containerAction</code> (min: 1, max: 50).</p>
    pub volume_size_in_gb: i32,
}
impl ResourceConfiguration {
    /// <p>The type of the compute resource used to execute the <code>containerAction</code>. Possible values are: <code>ACU_1</code> (vCPU=4, memory=16 GiB) or <code>ACU_2</code> (vCPU=8, memory=32 GiB).</p>
    pub fn compute_type(&self) -> std::option::Option<&crate::model::ComputeType> {
        self.compute_type.as_ref()
    }
    /// <p>The size, in GB, of the persistent storage available to the resource instance used to execute the <code>containerAction</code> (min: 1, max: 50).</p>
    pub fn volume_size_in_gb(&self) -> i32 {
        self.volume_size_in_gb
    }
}
impl std::fmt::Debug for ResourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceConfiguration");
        formatter.field("compute_type", &self.compute_type);
        formatter.field("volume_size_in_gb", &self.volume_size_in_gb);
        formatter.finish()
    }
}
/// See [`ResourceConfiguration`](crate::model::ResourceConfiguration)
pub mod resource_configuration {
    /// A builder for [`ResourceConfiguration`](crate::model::ResourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
        pub(crate) volume_size_in_gb: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of the compute resource used to execute the <code>containerAction</code>. Possible values are: <code>ACU_1</code> (vCPU=4, memory=16 GiB) or <code>ACU_2</code> (vCPU=8, memory=32 GiB).</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>The type of the compute resource used to execute the <code>containerAction</code>. Possible values are: <code>ACU_1</code> (vCPU=4, memory=16 GiB) or <code>ACU_2</code> (vCPU=8, memory=32 GiB).</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// <p>The size, in GB, of the persistent storage available to the resource instance used to execute the <code>containerAction</code> (min: 1, max: 50).</p>
        pub fn volume_size_in_gb(mut self, input: i32) -> Self {
            self.volume_size_in_gb = Some(input);
            self
        }
        /// <p>The size, in GB, of the persistent storage available to the resource instance used to execute the <code>containerAction</code> (min: 1, max: 50).</p>
        pub fn set_volume_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size_in_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceConfiguration`](crate::model::ResourceConfiguration)
        pub fn build(self) -> crate::model::ResourceConfiguration {
            crate::model::ResourceConfiguration {
                compute_type: self.compute_type,
                volume_size_in_gb: self.volume_size_in_gb.unwrap_or_default(),
            }
        }
    }
}
impl ResourceConfiguration {
    /// Creates a new builder-style object to manufacture [`ResourceConfiguration`](crate::model::ResourceConfiguration)
    pub fn builder() -> crate::model::resource_configuration::Builder {
        crate::model::resource_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputeType {
    #[allow(missing_docs)] // documentation missing in model
    Acu1,
    #[allow(missing_docs)] // documentation missing in model
    Acu2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputeType {
    fn from(s: &str) -> Self {
        match s {
            "ACU_1" => ComputeType::Acu1,
            "ACU_2" => ComputeType::Acu2,
            other => ComputeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputeType::from(s))
    }
}
impl ComputeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputeType::Acu1 => "ACU_1",
            ComputeType::Acu2 => "ACU_2",
            ComputeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACU_1", "ACU_2"]
    }
}
impl AsRef<str> for ComputeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The SQL query to modify the message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlQueryDatasetAction {
    /// <p>A SQL query string.</p>
    pub sql_query: std::option::Option<std::string::String>,
    /// <p>Prefilters applied to message data.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::QueryFilter>>,
}
impl SqlQueryDatasetAction {
    /// <p>A SQL query string.</p>
    pub fn sql_query(&self) -> std::option::Option<&str> {
        self.sql_query.as_deref()
    }
    /// <p>Prefilters applied to message data.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::QueryFilter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for SqlQueryDatasetAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlQueryDatasetAction");
        formatter.field("sql_query", &self.sql_query);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}
/// See [`SqlQueryDatasetAction`](crate::model::SqlQueryDatasetAction)
pub mod sql_query_dataset_action {
    /// A builder for [`SqlQueryDatasetAction`](crate::model::SqlQueryDatasetAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sql_query: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::QueryFilter>>,
    }
    impl Builder {
        /// <p>A SQL query string.</p>
        pub fn sql_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql_query = Some(input.into());
            self
        }
        /// <p>A SQL query string.</p>
        pub fn set_sql_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql_query = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Prefilters applied to message data.</p>
        pub fn filters(mut self, input: crate::model::QueryFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Prefilters applied to message data.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueryFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlQueryDatasetAction`](crate::model::SqlQueryDatasetAction)
        pub fn build(self) -> crate::model::SqlQueryDatasetAction {
            crate::model::SqlQueryDatasetAction {
                sql_query: self.sql_query,
                filters: self.filters,
            }
        }
    }
}
impl SqlQueryDatasetAction {
    /// Creates a new builder-style object to manufacture [`SqlQueryDatasetAction`](crate::model::SqlQueryDatasetAction)
    pub fn builder() -> crate::model::sql_query_dataset_action::Builder {
        crate::model::sql_query_dataset_action::Builder::default()
    }
}

/// <p>Information that is used to filter message data, to segregate it according to the timeframe in which it arrives.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryFilter {
    /// <p>Used to limit data to that which has arrived since the last execution of the action.</p>
    pub delta_time: std::option::Option<crate::model::DeltaTime>,
}
impl QueryFilter {
    /// <p>Used to limit data to that which has arrived since the last execution of the action.</p>
    pub fn delta_time(&self) -> std::option::Option<&crate::model::DeltaTime> {
        self.delta_time.as_ref()
    }
}
impl std::fmt::Debug for QueryFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryFilter");
        formatter.field("delta_time", &self.delta_time);
        formatter.finish()
    }
}
/// See [`QueryFilter`](crate::model::QueryFilter)
pub mod query_filter {
    /// A builder for [`QueryFilter`](crate::model::QueryFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delta_time: std::option::Option<crate::model::DeltaTime>,
    }
    impl Builder {
        /// <p>Used to limit data to that which has arrived since the last execution of the action.</p>
        pub fn delta_time(mut self, input: crate::model::DeltaTime) -> Self {
            self.delta_time = Some(input);
            self
        }
        /// <p>Used to limit data to that which has arrived since the last execution of the action.</p>
        pub fn set_delta_time(
            mut self,
            input: std::option::Option<crate::model::DeltaTime>,
        ) -> Self {
            self.delta_time = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryFilter`](crate::model::QueryFilter)
        pub fn build(self) -> crate::model::QueryFilter {
            crate::model::QueryFilter {
                delta_time: self.delta_time,
            }
        }
    }
}
impl QueryFilter {
    /// Creates a new builder-style object to manufacture [`QueryFilter`](crate::model::QueryFilter)
    pub fn builder() -> crate::model::query_filter::Builder {
        crate::model::query_filter::Builder::default()
    }
}

/// <p>Used to limit data to that which has arrived since the last execution of the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeltaTime {
    /// <p>The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.</p>
    pub offset_seconds: std::option::Option<i32>,
    /// <p>An expression by which the time of the message data might be determined. This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.</p>
    pub time_expression: std::option::Option<std::string::String>,
}
impl DeltaTime {
    /// <p>The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.</p>
    pub fn offset_seconds(&self) -> std::option::Option<i32> {
        self.offset_seconds
    }
    /// <p>An expression by which the time of the message data might be determined. This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.</p>
    pub fn time_expression(&self) -> std::option::Option<&str> {
        self.time_expression.as_deref()
    }
}
impl std::fmt::Debug for DeltaTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeltaTime");
        formatter.field("offset_seconds", &self.offset_seconds);
        formatter.field("time_expression", &self.time_expression);
        formatter.finish()
    }
}
/// See [`DeltaTime`](crate::model::DeltaTime)
pub mod delta_time {
    /// A builder for [`DeltaTime`](crate::model::DeltaTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offset_seconds: std::option::Option<i32>,
        pub(crate) time_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.</p>
        pub fn offset_seconds(mut self, input: i32) -> Self {
            self.offset_seconds = Some(input);
            self
        }
        /// <p>The number of seconds of estimated in-flight lag time of message data. When you create dataset contents using message data from a specified timeframe, some message data might still be in flight when processing begins, and so do not arrive in time to be processed. Use this field to make allowances for the in flight time of your message data, so that data not processed from a previous timeframe is included with the next timeframe. Otherwise, missed message data would be excluded from processing during the next timeframe too, because its timestamp places it within the previous timeframe.</p>
        pub fn set_offset_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.offset_seconds = input;
            self
        }
        /// <p>An expression by which the time of the message data might be determined. This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.</p>
        pub fn time_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_expression = Some(input.into());
            self
        }
        /// <p>An expression by which the time of the message data might be determined. This can be the name of a timestamp field or a SQL expression that is used to derive the time the message data was generated.</p>
        pub fn set_time_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`DeltaTime`](crate::model::DeltaTime)
        pub fn build(self) -> crate::model::DeltaTime {
            crate::model::DeltaTime {
                offset_seconds: self.offset_seconds,
                time_expression: self.time_expression,
            }
        }
    }
}
impl DeltaTime {
    /// Creates a new builder-style object to manufacture [`DeltaTime`](crate::model::DeltaTime)
    pub fn builder() -> crate::model::delta_time::Builder {
        crate::model::delta_time::Builder::default()
    }
}

/// <p>Where channel data is stored. You may choose one of <code>serviceManagedS3</code>, <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. This can't be changed after creation of the channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelStorage {
    /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics. You can't change the choice of S3 storage after the data store is created.</p>
    pub service_managed_s3: std::option::Option<crate::model::ServiceManagedChannelS3Storage>,
    /// <p>Used to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of S3 storage after the data store is created.</p>
    pub customer_managed_s3: std::option::Option<crate::model::CustomerManagedChannelS3Storage>,
}
impl ChannelStorage {
    /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics. You can't change the choice of S3 storage after the data store is created.</p>
    pub fn service_managed_s3(
        &self,
    ) -> std::option::Option<&crate::model::ServiceManagedChannelS3Storage> {
        self.service_managed_s3.as_ref()
    }
    /// <p>Used to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of S3 storage after the data store is created.</p>
    pub fn customer_managed_s3(
        &self,
    ) -> std::option::Option<&crate::model::CustomerManagedChannelS3Storage> {
        self.customer_managed_s3.as_ref()
    }
}
impl std::fmt::Debug for ChannelStorage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelStorage");
        formatter.field("service_managed_s3", &self.service_managed_s3);
        formatter.field("customer_managed_s3", &self.customer_managed_s3);
        formatter.finish()
    }
}
/// See [`ChannelStorage`](crate::model::ChannelStorage)
pub mod channel_storage {
    /// A builder for [`ChannelStorage`](crate::model::ChannelStorage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_managed_s3:
            std::option::Option<crate::model::ServiceManagedChannelS3Storage>,
        pub(crate) customer_managed_s3:
            std::option::Option<crate::model::CustomerManagedChannelS3Storage>,
    }
    impl Builder {
        /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics. You can't change the choice of S3 storage after the data store is created.</p>
        pub fn service_managed_s3(
            mut self,
            input: crate::model::ServiceManagedChannelS3Storage,
        ) -> Self {
            self.service_managed_s3 = Some(input);
            self
        }
        /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics. You can't change the choice of S3 storage after the data store is created.</p>
        pub fn set_service_managed_s3(
            mut self,
            input: std::option::Option<crate::model::ServiceManagedChannelS3Storage>,
        ) -> Self {
            self.service_managed_s3 = input;
            self
        }
        /// <p>Used to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of S3 storage after the data store is created.</p>
        pub fn customer_managed_s3(
            mut self,
            input: crate::model::CustomerManagedChannelS3Storage,
        ) -> Self {
            self.customer_managed_s3 = Some(input);
            self
        }
        /// <p>Used to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of S3 storage after the data store is created.</p>
        pub fn set_customer_managed_s3(
            mut self,
            input: std::option::Option<crate::model::CustomerManagedChannelS3Storage>,
        ) -> Self {
            self.customer_managed_s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelStorage`](crate::model::ChannelStorage)
        pub fn build(self) -> crate::model::ChannelStorage {
            crate::model::ChannelStorage {
                service_managed_s3: self.service_managed_s3,
                customer_managed_s3: self.customer_managed_s3,
            }
        }
    }
}
impl ChannelStorage {
    /// Creates a new builder-style object to manufacture [`ChannelStorage`](crate::model::ChannelStorage)
    pub fn builder() -> crate::model::channel_storage::Builder {
        crate::model::channel_storage::Builder::default()
    }
}

/// <p>Used to store channel data in an S3 bucket that you manage. If customer-managed storage is selected, the <code>retentionPeriod</code> parameter is ignored. You can't change the choice of S3 storage after the data store is created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerManagedChannelS3Storage {
    /// <p>The name of the S3 bucket in which channel data is stored.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
    pub key_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CustomerManagedChannelS3Storage {
    /// <p>The name of the S3 bucket in which channel data is stored.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomerManagedChannelS3Storage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerManagedChannelS3Storage");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CustomerManagedChannelS3Storage`](crate::model::CustomerManagedChannelS3Storage)
pub mod customer_managed_channel_s3_storage {
    /// A builder for [`CustomerManagedChannelS3Storage`](crate::model::CustomerManagedChannelS3Storage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket in which channel data is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket in which channel data is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerManagedChannelS3Storage`](crate::model::CustomerManagedChannelS3Storage)
        pub fn build(self) -> crate::model::CustomerManagedChannelS3Storage {
            crate::model::CustomerManagedChannelS3Storage {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CustomerManagedChannelS3Storage {
    /// Creates a new builder-style object to manufacture [`CustomerManagedChannelS3Storage`](crate::model::CustomerManagedChannelS3Storage)
    pub fn builder() -> crate::model::customer_managed_channel_s3_storage::Builder {
        crate::model::customer_managed_channel_s3_storage::Builder::default()
    }
}

/// <p>Used to store channel data in an S3 bucket managed by IoT Analytics. You can't change the choice of S3 storage after the data store is created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceManagedChannelS3Storage {}
impl std::fmt::Debug for ServiceManagedChannelS3Storage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceManagedChannelS3Storage");
        formatter.finish()
    }
}
/// See [`ServiceManagedChannelS3Storage`](crate::model::ServiceManagedChannelS3Storage)
pub mod service_managed_channel_s3_storage {
    /// A builder for [`ServiceManagedChannelS3Storage`](crate::model::ServiceManagedChannelS3Storage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ServiceManagedChannelS3Storage`](crate::model::ServiceManagedChannelS3Storage)
        pub fn build(self) -> crate::model::ServiceManagedChannelS3Storage {
            crate::model::ServiceManagedChannelS3Storage {}
        }
    }
}
impl ServiceManagedChannelS3Storage {
    /// Creates a new builder-style object to manufacture [`ServiceManagedChannelS3Storage`](crate::model::ServiceManagedChannelS3Storage)
    pub fn builder() -> crate::model::service_managed_channel_s3_storage::Builder {
        crate::model::service_managed_channel_s3_storage::Builder::default()
    }
}

/// <p>A set of key-value pairs that are used to manage the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag's key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag's key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag's key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag's key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Specifies one or more sets of channel messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelMessages {
    /// <p>Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save your channel messages.</p>
    /// <p>You must use the full path for the key.</p>
    /// <p>Example path: <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code> </p>
    pub s3_paths: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ChannelMessages {
    /// <p>Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save your channel messages.</p>
    /// <p>You must use the full path for the key.</p>
    /// <p>Example path: <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code> </p>
    pub fn s3_paths(&self) -> std::option::Option<&[std::string::String]> {
        self.s3_paths.as_deref()
    }
}
impl std::fmt::Debug for ChannelMessages {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelMessages");
        formatter.field("s3_paths", &self.s3_paths);
        formatter.finish()
    }
}
/// See [`ChannelMessages`](crate::model::ChannelMessages)
pub mod channel_messages {
    /// A builder for [`ChannelMessages`](crate::model::ChannelMessages)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_paths: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `s3_paths`.
        ///
        /// To override the contents of this collection use [`set_s3_paths`](Self::set_s3_paths).
        ///
        /// <p>Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save your channel messages.</p>
        /// <p>You must use the full path for the key.</p>
        /// <p>Example path: <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code> </p>
        pub fn s3_paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.s3_paths.unwrap_or_default();
            v.push(input.into());
            self.s3_paths = Some(v);
            self
        }
        /// <p>Specifies one or more keys that identify the Amazon Simple Storage Service (Amazon S3) objects that save your channel messages.</p>
        /// <p>You must use the full path for the key.</p>
        /// <p>Example path: <code>channel/mychannel/__dt=2020-02-29 00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz</code> </p>
        pub fn set_s3_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.s3_paths = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelMessages`](crate::model::ChannelMessages)
        pub fn build(self) -> crate::model::ChannelMessages {
            crate::model::ChannelMessages {
                s3_paths: self.s3_paths,
            }
        }
    }
}
impl ChannelMessages {
    /// Creates a new builder-style object to manufacture [`ChannelMessages`](crate::model::ChannelMessages)
    pub fn builder() -> crate::model::channel_messages::Builder {
        crate::model::channel_messages::Builder::default()
    }
}

/// <p>Information about logging options.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingOptions {
    /// <p>The ARN of the role that grants permission to IoT Analytics to perform logging.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The logging level. Currently, only ERROR is supported.</p>
    pub level: std::option::Option<crate::model::LoggingLevel>,
    /// <p>If true, logging is enabled for IoT Analytics.</p>
    pub enabled: bool,
}
impl LoggingOptions {
    /// <p>The ARN of the role that grants permission to IoT Analytics to perform logging.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The logging level. Currently, only ERROR is supported.</p>
    pub fn level(&self) -> std::option::Option<&crate::model::LoggingLevel> {
        self.level.as_ref()
    }
    /// <p>If true, logging is enabled for IoT Analytics.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for LoggingOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingOptions");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("level", &self.level);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`LoggingOptions`](crate::model::LoggingOptions)
pub mod logging_options {
    /// A builder for [`LoggingOptions`](crate::model::LoggingOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) level: std::option::Option<crate::model::LoggingLevel>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the role that grants permission to IoT Analytics to perform logging.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to IoT Analytics to perform logging.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The logging level. Currently, only ERROR is supported.</p>
        pub fn level(mut self, input: crate::model::LoggingLevel) -> Self {
            self.level = Some(input);
            self
        }
        /// <p>The logging level. Currently, only ERROR is supported.</p>
        pub fn set_level(mut self, input: std::option::Option<crate::model::LoggingLevel>) -> Self {
            self.level = input;
            self
        }
        /// <p>If true, logging is enabled for IoT Analytics.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If true, logging is enabled for IoT Analytics.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingOptions`](crate::model::LoggingOptions)
        pub fn build(self) -> crate::model::LoggingOptions {
            crate::model::LoggingOptions {
                role_arn: self.role_arn,
                level: self.level,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl LoggingOptions {
    /// Creates a new builder-style object to manufacture [`LoggingOptions`](crate::model::LoggingOptions)
    pub fn builder() -> crate::model::logging_options::Builder {
        crate::model::logging_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggingLevel {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggingLevel {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => LoggingLevel::Error,
            other => LoggingLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggingLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggingLevel::from(s))
    }
}
impl LoggingLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggingLevel::Error => "ERROR",
            LoggingLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR"]
    }
}
impl AsRef<str> for LoggingLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of information about a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineSummary {
    /// <p>The name of the pipeline.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>A summary of information about the pipeline reprocessing.</p>
    pub reprocessing_summaries:
        std::option::Option<std::vec::Vec<crate::model::ReprocessingSummary>>,
    /// <p>When the pipeline was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the pipeline was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PipelineSummary {
    /// <p>The name of the pipeline.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>A summary of information about the pipeline reprocessing.</p>
    pub fn reprocessing_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ReprocessingSummary]> {
        self.reprocessing_summaries.as_deref()
    }
    /// <p>When the pipeline was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>When the pipeline was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for PipelineSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineSummary");
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("reprocessing_summaries", &self.reprocessing_summaries);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`PipelineSummary`](crate::model::PipelineSummary)
pub mod pipeline_summary {
    /// A builder for [`PipelineSummary`](crate::model::PipelineSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) reprocessing_summaries:
            std::option::Option<std::vec::Vec<crate::model::ReprocessingSummary>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the pipeline.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// Appends an item to `reprocessing_summaries`.
        ///
        /// To override the contents of this collection use [`set_reprocessing_summaries`](Self::set_reprocessing_summaries).
        ///
        /// <p>A summary of information about the pipeline reprocessing.</p>
        pub fn reprocessing_summaries(mut self, input: crate::model::ReprocessingSummary) -> Self {
            let mut v = self.reprocessing_summaries.unwrap_or_default();
            v.push(input);
            self.reprocessing_summaries = Some(v);
            self
        }
        /// <p>A summary of information about the pipeline reprocessing.</p>
        pub fn set_reprocessing_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReprocessingSummary>>,
        ) -> Self {
            self.reprocessing_summaries = input;
            self
        }
        /// <p>When the pipeline was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the pipeline was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>When the pipeline was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>When the pipeline was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineSummary`](crate::model::PipelineSummary)
        pub fn build(self) -> crate::model::PipelineSummary {
            crate::model::PipelineSummary {
                pipeline_name: self.pipeline_name,
                reprocessing_summaries: self.reprocessing_summaries,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl PipelineSummary {
    /// Creates a new builder-style object to manufacture [`PipelineSummary`](crate::model::PipelineSummary)
    pub fn builder() -> crate::model::pipeline_summary::Builder {
        crate::model::pipeline_summary::Builder::default()
    }
}

/// <p>Information about pipeline reprocessing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReprocessingSummary {
    /// <p>The <code>reprocessingId</code> returned by <code>StartPipelineReprocessing</code>.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The status of the pipeline reprocessing.</p>
    pub status: std::option::Option<crate::model::ReprocessingStatus>,
    /// <p>The time the pipeline reprocessing was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ReprocessingSummary {
    /// <p>The <code>reprocessingId</code> returned by <code>StartPipelineReprocessing</code>.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The status of the pipeline reprocessing.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReprocessingStatus> {
        self.status.as_ref()
    }
    /// <p>The time the pipeline reprocessing was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for ReprocessingSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReprocessingSummary");
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`ReprocessingSummary`](crate::model::ReprocessingSummary)
pub mod reprocessing_summary {
    /// A builder for [`ReprocessingSummary`](crate::model::ReprocessingSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ReprocessingStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The <code>reprocessingId</code> returned by <code>StartPipelineReprocessing</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The <code>reprocessingId</code> returned by <code>StartPipelineReprocessing</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The status of the pipeline reprocessing.</p>
        pub fn status(mut self, input: crate::model::ReprocessingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the pipeline reprocessing.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReprocessingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time the pipeline reprocessing was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the pipeline reprocessing was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ReprocessingSummary`](crate::model::ReprocessingSummary)
        pub fn build(self) -> crate::model::ReprocessingSummary {
            crate::model::ReprocessingSummary {
                id: self.id,
                status: self.status,
                creation_time: self.creation_time,
            }
        }
    }
}
impl ReprocessingSummary {
    /// Creates a new builder-style object to manufacture [`ReprocessingSummary`](crate::model::ReprocessingSummary)
    pub fn builder() -> crate::model::reprocessing_summary::Builder {
        crate::model::reprocessing_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReprocessingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReprocessingStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => ReprocessingStatus::Cancelled,
            "FAILED" => ReprocessingStatus::Failed,
            "RUNNING" => ReprocessingStatus::Running,
            "SUCCEEDED" => ReprocessingStatus::Succeeded,
            other => ReprocessingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReprocessingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReprocessingStatus::from(s))
    }
}
impl ReprocessingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReprocessingStatus::Cancelled => "CANCELLED",
            ReprocessingStatus::Failed => "FAILED",
            ReprocessingStatus::Running => "RUNNING",
            ReprocessingStatus::Succeeded => "SUCCEEDED",
            ReprocessingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "FAILED", "RUNNING", "SUCCEEDED"]
    }
}
impl AsRef<str> for ReprocessingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of information about a data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreSummary {
    /// <p>The name of the data store.</p>
    pub datastore_name: std::option::Option<std::string::String>,
    /// <p>Where data in a data store is stored.</p>
    pub datastore_storage: std::option::Option<crate::model::DatastoreStorageSummary>,
    /// <p>The status of the data store.</p>
    pub status: std::option::Option<crate::model::DatastoreStatus>,
    /// <p>When the data store was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the data store was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when a new message arrived in the data store.</p>
    /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The file format of the data in the data store.</p>
    pub file_format_type: std::option::Option<crate::model::FileFormatType>,
    /// <p> Contains information about the partition dimensions in a data store. </p>
    pub datastore_partitions: std::option::Option<crate::model::DatastorePartitions>,
}
impl DatastoreSummary {
    /// <p>The name of the data store.</p>
    pub fn datastore_name(&self) -> std::option::Option<&str> {
        self.datastore_name.as_deref()
    }
    /// <p>Where data in a data store is stored.</p>
    pub fn datastore_storage(&self) -> std::option::Option<&crate::model::DatastoreStorageSummary> {
        self.datastore_storage.as_ref()
    }
    /// <p>The status of the data store.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DatastoreStatus> {
        self.status.as_ref()
    }
    /// <p>When the data store was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the data store was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The last time when a new message arrived in the data store.</p>
    /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub fn last_message_arrival_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_message_arrival_time.as_ref()
    }
    /// <p>The file format of the data in the data store.</p>
    pub fn file_format_type(&self) -> std::option::Option<&crate::model::FileFormatType> {
        self.file_format_type.as_ref()
    }
    /// <p> Contains information about the partition dimensions in a data store. </p>
    pub fn datastore_partitions(&self) -> std::option::Option<&crate::model::DatastorePartitions> {
        self.datastore_partitions.as_ref()
    }
}
impl std::fmt::Debug for DatastoreSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreSummary");
        formatter.field("datastore_name", &self.datastore_name);
        formatter.field("datastore_storage", &self.datastore_storage);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("last_message_arrival_time", &self.last_message_arrival_time);
        formatter.field("file_format_type", &self.file_format_type);
        formatter.field("datastore_partitions", &self.datastore_partitions);
        formatter.finish()
    }
}
/// See [`DatastoreSummary`](crate::model::DatastoreSummary)
pub mod datastore_summary {
    /// A builder for [`DatastoreSummary`](crate::model::DatastoreSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_name: std::option::Option<std::string::String>,
        pub(crate) datastore_storage: std::option::Option<crate::model::DatastoreStorageSummary>,
        pub(crate) status: std::option::Option<crate::model::DatastoreStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) file_format_type: std::option::Option<crate::model::FileFormatType>,
        pub(crate) datastore_partitions: std::option::Option<crate::model::DatastorePartitions>,
    }
    impl Builder {
        /// <p>The name of the data store.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_name = Some(input.into());
            self
        }
        /// <p>The name of the data store.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_name = input;
            self
        }
        /// <p>Where data in a data store is stored.</p>
        pub fn datastore_storage(mut self, input: crate::model::DatastoreStorageSummary) -> Self {
            self.datastore_storage = Some(input);
            self
        }
        /// <p>Where data in a data store is stored.</p>
        pub fn set_datastore_storage(
            mut self,
            input: std::option::Option<crate::model::DatastoreStorageSummary>,
        ) -> Self {
            self.datastore_storage = input;
            self
        }
        /// <p>The status of the data store.</p>
        pub fn status(mut self, input: crate::model::DatastoreStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the data store.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatastoreStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>When the data store was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the data store was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the data store was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the data store was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The last time when a new message arrived in the data store.</p>
        /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn last_message_arrival_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_message_arrival_time = Some(input);
            self
        }
        /// <p>The last time when a new message arrived in the data store.</p>
        /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn set_last_message_arrival_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_message_arrival_time = input;
            self
        }
        /// <p>The file format of the data in the data store.</p>
        pub fn file_format_type(mut self, input: crate::model::FileFormatType) -> Self {
            self.file_format_type = Some(input);
            self
        }
        /// <p>The file format of the data in the data store.</p>
        pub fn set_file_format_type(
            mut self,
            input: std::option::Option<crate::model::FileFormatType>,
        ) -> Self {
            self.file_format_type = input;
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn datastore_partitions(mut self, input: crate::model::DatastorePartitions) -> Self {
            self.datastore_partitions = Some(input);
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn set_datastore_partitions(
            mut self,
            input: std::option::Option<crate::model::DatastorePartitions>,
        ) -> Self {
            self.datastore_partitions = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreSummary`](crate::model::DatastoreSummary)
        pub fn build(self) -> crate::model::DatastoreSummary {
            crate::model::DatastoreSummary {
                datastore_name: self.datastore_name,
                datastore_storage: self.datastore_storage,
                status: self.status,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                last_message_arrival_time: self.last_message_arrival_time,
                file_format_type: self.file_format_type,
                datastore_partitions: self.datastore_partitions,
            }
        }
    }
}
impl DatastoreSummary {
    /// Creates a new builder-style object to manufacture [`DatastoreSummary`](crate::model::DatastoreSummary)
    pub fn builder() -> crate::model::datastore_summary::Builder {
        crate::model::datastore_summary::Builder::default()
    }
}

/// <p> Contains information about the partition dimensions in a data store. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastorePartitions {
    /// <p> A list of partition dimensions in a data store. </p>
    pub partitions: std::option::Option<std::vec::Vec<crate::model::DatastorePartition>>,
}
impl DatastorePartitions {
    /// <p> A list of partition dimensions in a data store. </p>
    pub fn partitions(&self) -> std::option::Option<&[crate::model::DatastorePartition]> {
        self.partitions.as_deref()
    }
}
impl std::fmt::Debug for DatastorePartitions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastorePartitions");
        formatter.field("partitions", &self.partitions);
        formatter.finish()
    }
}
/// See [`DatastorePartitions`](crate::model::DatastorePartitions)
pub mod datastore_partitions {
    /// A builder for [`DatastorePartitions`](crate::model::DatastorePartitions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partitions: std::option::Option<std::vec::Vec<crate::model::DatastorePartition>>,
    }
    impl Builder {
        /// Appends an item to `partitions`.
        ///
        /// To override the contents of this collection use [`set_partitions`](Self::set_partitions).
        ///
        /// <p> A list of partition dimensions in a data store. </p>
        pub fn partitions(mut self, input: crate::model::DatastorePartition) -> Self {
            let mut v = self.partitions.unwrap_or_default();
            v.push(input);
            self.partitions = Some(v);
            self
        }
        /// <p> A list of partition dimensions in a data store. </p>
        pub fn set_partitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatastorePartition>>,
        ) -> Self {
            self.partitions = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastorePartitions`](crate::model::DatastorePartitions)
        pub fn build(self) -> crate::model::DatastorePartitions {
            crate::model::DatastorePartitions {
                partitions: self.partitions,
            }
        }
    }
}
impl DatastorePartitions {
    /// Creates a new builder-style object to manufacture [`DatastorePartitions`](crate::model::DatastorePartitions)
    pub fn builder() -> crate::model::datastore_partitions::Builder {
        crate::model::datastore_partitions::Builder::default()
    }
}

/// <p> A single dimension to partition a data store. The dimension must be an <code>AttributePartition</code> or a <code>TimestampPartition</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastorePartition {
    /// <p> A partition dimension defined by an <code>attributeName</code>. </p>
    pub attribute_partition: std::option::Option<crate::model::Partition>,
    /// <p> A partition dimension defined by a timestamp attribute. </p>
    pub timestamp_partition: std::option::Option<crate::model::TimestampPartition>,
}
impl DatastorePartition {
    /// <p> A partition dimension defined by an <code>attributeName</code>. </p>
    pub fn attribute_partition(&self) -> std::option::Option<&crate::model::Partition> {
        self.attribute_partition.as_ref()
    }
    /// <p> A partition dimension defined by a timestamp attribute. </p>
    pub fn timestamp_partition(&self) -> std::option::Option<&crate::model::TimestampPartition> {
        self.timestamp_partition.as_ref()
    }
}
impl std::fmt::Debug for DatastorePartition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastorePartition");
        formatter.field("attribute_partition", &self.attribute_partition);
        formatter.field("timestamp_partition", &self.timestamp_partition);
        formatter.finish()
    }
}
/// See [`DatastorePartition`](crate::model::DatastorePartition)
pub mod datastore_partition {
    /// A builder for [`DatastorePartition`](crate::model::DatastorePartition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_partition: std::option::Option<crate::model::Partition>,
        pub(crate) timestamp_partition: std::option::Option<crate::model::TimestampPartition>,
    }
    impl Builder {
        /// <p> A partition dimension defined by an <code>attributeName</code>. </p>
        pub fn attribute_partition(mut self, input: crate::model::Partition) -> Self {
            self.attribute_partition = Some(input);
            self
        }
        /// <p> A partition dimension defined by an <code>attributeName</code>. </p>
        pub fn set_attribute_partition(
            mut self,
            input: std::option::Option<crate::model::Partition>,
        ) -> Self {
            self.attribute_partition = input;
            self
        }
        /// <p> A partition dimension defined by a timestamp attribute. </p>
        pub fn timestamp_partition(mut self, input: crate::model::TimestampPartition) -> Self {
            self.timestamp_partition = Some(input);
            self
        }
        /// <p> A partition dimension defined by a timestamp attribute. </p>
        pub fn set_timestamp_partition(
            mut self,
            input: std::option::Option<crate::model::TimestampPartition>,
        ) -> Self {
            self.timestamp_partition = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastorePartition`](crate::model::DatastorePartition)
        pub fn build(self) -> crate::model::DatastorePartition {
            crate::model::DatastorePartition {
                attribute_partition: self.attribute_partition,
                timestamp_partition: self.timestamp_partition,
            }
        }
    }
}
impl DatastorePartition {
    /// Creates a new builder-style object to manufacture [`DatastorePartition`](crate::model::DatastorePartition)
    pub fn builder() -> crate::model::datastore_partition::Builder {
        crate::model::datastore_partition::Builder::default()
    }
}

/// <p> A partition dimension defined by a timestamp attribute. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestampPartition {
    /// <p> The attribute name of the partition defined by a timestamp. </p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p> The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1, 1970 at midnight UTC time). </p>
    pub timestamp_format: std::option::Option<std::string::String>,
}
impl TimestampPartition {
    /// <p> The attribute name of the partition defined by a timestamp. </p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p> The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1, 1970 at midnight UTC time). </p>
    pub fn timestamp_format(&self) -> std::option::Option<&str> {
        self.timestamp_format.as_deref()
    }
}
impl std::fmt::Debug for TimestampPartition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestampPartition");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("timestamp_format", &self.timestamp_format);
        formatter.finish()
    }
}
/// See [`TimestampPartition`](crate::model::TimestampPartition)
pub mod timestamp_partition {
    /// A builder for [`TimestampPartition`](crate::model::TimestampPartition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) timestamp_format: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The attribute name of the partition defined by a timestamp. </p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p> The attribute name of the partition defined by a timestamp. </p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p> The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1, 1970 at midnight UTC time). </p>
        pub fn timestamp_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp_format = Some(input.into());
            self
        }
        /// <p> The timestamp format of a partition defined by a timestamp. The default format is seconds since epoch (January 1, 1970 at midnight UTC time). </p>
        pub fn set_timestamp_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timestamp_format = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestampPartition`](crate::model::TimestampPartition)
        pub fn build(self) -> crate::model::TimestampPartition {
            crate::model::TimestampPartition {
                attribute_name: self.attribute_name,
                timestamp_format: self.timestamp_format,
            }
        }
    }
}
impl TimestampPartition {
    /// Creates a new builder-style object to manufacture [`TimestampPartition`](crate::model::TimestampPartition)
    pub fn builder() -> crate::model::timestamp_partition::Builder {
        crate::model::timestamp_partition::Builder::default()
    }
}

/// <p> A partition dimension defined by an attribute. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Partition {
    /// <p> The name of the attribute that defines a partition dimension. </p>
    pub attribute_name: std::option::Option<std::string::String>,
}
impl Partition {
    /// <p> The name of the attribute that defines a partition dimension. </p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
}
impl std::fmt::Debug for Partition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Partition");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.finish()
    }
}
/// See [`Partition`](crate::model::Partition)
pub mod partition {
    /// A builder for [`Partition`](crate::model::Partition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the attribute that defines a partition dimension. </p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p> The name of the attribute that defines a partition dimension. </p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Partition`](crate::model::Partition)
        pub fn build(self) -> crate::model::Partition {
            crate::model::Partition {
                attribute_name: self.attribute_name,
            }
        }
    }
}
impl Partition {
    /// Creates a new builder-style object to manufacture [`Partition`](crate::model::Partition)
    pub fn builder() -> crate::model::partition::Builder {
        crate::model::partition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileFormatType {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileFormatType {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => FileFormatType::Json,
            "PARQUET" => FileFormatType::Parquet,
            other => FileFormatType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileFormatType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileFormatType::from(s))
    }
}
impl FileFormatType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileFormatType::Json => "JSON",
            FileFormatType::Parquet => "PARQUET",
            FileFormatType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "PARQUET"]
    }
}
impl AsRef<str> for FileFormatType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatastoreStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatastoreStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DatastoreStatus::Active,
            "CREATING" => DatastoreStatus::Creating,
            "DELETING" => DatastoreStatus::Deleting,
            other => DatastoreStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatastoreStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatastoreStatus::from(s))
    }
}
impl DatastoreStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatastoreStatus::Active => "ACTIVE",
            DatastoreStatus::Creating => "CREATING",
            DatastoreStatus::Deleting => "DELETING",
            DatastoreStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for DatastoreStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about your data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreStorageSummary {
    /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
    pub service_managed_s3:
        std::option::Option<crate::model::ServiceManagedDatastoreS3StorageSummary>,
    /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
    pub customer_managed_s3:
        std::option::Option<crate::model::CustomerManagedDatastoreS3StorageSummary>,
    /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
    pub iot_site_wise_multi_layer_storage:
        std::option::Option<crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary>,
}
impl DatastoreStorageSummary {
    /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
    pub fn service_managed_s3(
        &self,
    ) -> std::option::Option<&crate::model::ServiceManagedDatastoreS3StorageSummary> {
        self.service_managed_s3.as_ref()
    }
    /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
    pub fn customer_managed_s3(
        &self,
    ) -> std::option::Option<&crate::model::CustomerManagedDatastoreS3StorageSummary> {
        self.customer_managed_s3.as_ref()
    }
    /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
    pub fn iot_site_wise_multi_layer_storage(
        &self,
    ) -> std::option::Option<&crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary> {
        self.iot_site_wise_multi_layer_storage.as_ref()
    }
}
impl std::fmt::Debug for DatastoreStorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreStorageSummary");
        formatter.field("service_managed_s3", &self.service_managed_s3);
        formatter.field("customer_managed_s3", &self.customer_managed_s3);
        formatter.field(
            "iot_site_wise_multi_layer_storage",
            &self.iot_site_wise_multi_layer_storage,
        );
        formatter.finish()
    }
}
/// See [`DatastoreStorageSummary`](crate::model::DatastoreStorageSummary)
pub mod datastore_storage_summary {
    /// A builder for [`DatastoreStorageSummary`](crate::model::DatastoreStorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_managed_s3:
            std::option::Option<crate::model::ServiceManagedDatastoreS3StorageSummary>,
        pub(crate) customer_managed_s3:
            std::option::Option<crate::model::CustomerManagedDatastoreS3StorageSummary>,
        pub(crate) iot_site_wise_multi_layer_storage:
            std::option::Option<crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary>,
    }
    impl Builder {
        /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
        pub fn service_managed_s3(
            mut self,
            input: crate::model::ServiceManagedDatastoreS3StorageSummary,
        ) -> Self {
            self.service_managed_s3 = Some(input);
            self
        }
        /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
        pub fn set_service_managed_s3(
            mut self,
            input: std::option::Option<crate::model::ServiceManagedDatastoreS3StorageSummary>,
        ) -> Self {
            self.service_managed_s3 = input;
            self
        }
        /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
        pub fn customer_managed_s3(
            mut self,
            input: crate::model::CustomerManagedDatastoreS3StorageSummary,
        ) -> Self {
            self.customer_managed_s3 = Some(input);
            self
        }
        /// <p>Used to store data in an Amazon S3 bucket managed by IoT Analytics.</p>
        pub fn set_customer_managed_s3(
            mut self,
            input: std::option::Option<crate::model::CustomerManagedDatastoreS3StorageSummary>,
        ) -> Self {
            self.customer_managed_s3 = input;
            self
        }
        /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
        pub fn iot_site_wise_multi_layer_storage(
            mut self,
            input: crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary,
        ) -> Self {
            self.iot_site_wise_multi_layer_storage = Some(input);
            self
        }
        /// <p> Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. </p>
        pub fn set_iot_site_wise_multi_layer_storage(
            mut self,
            input: std::option::Option<crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary>,
        ) -> Self {
            self.iot_site_wise_multi_layer_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreStorageSummary`](crate::model::DatastoreStorageSummary)
        pub fn build(self) -> crate::model::DatastoreStorageSummary {
            crate::model::DatastoreStorageSummary {
                service_managed_s3: self.service_managed_s3,
                customer_managed_s3: self.customer_managed_s3,
                iot_site_wise_multi_layer_storage: self.iot_site_wise_multi_layer_storage,
            }
        }
    }
}
impl DatastoreStorageSummary {
    /// Creates a new builder-style object to manufacture [`DatastoreStorageSummary`](crate::model::DatastoreStorageSummary)
    pub fn builder() -> crate::model::datastore_storage_summary::Builder {
        crate::model::datastore_storage_summary::Builder::default()
    }
}

/// <p> Contains information about the data store that you manage, which stores data used by IoT SiteWise. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreIotSiteWiseMultiLayerStorageSummary {
    /// <p>Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.</p>
    pub customer_managed_s3_storage:
        std::option::Option<crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary>,
}
impl DatastoreIotSiteWiseMultiLayerStorageSummary {
    /// <p>Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.</p>
    pub fn customer_managed_s3_storage(
        &self,
    ) -> std::option::Option<&crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary>
    {
        self.customer_managed_s3_storage.as_ref()
    }
}
impl std::fmt::Debug for DatastoreIotSiteWiseMultiLayerStorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreIotSiteWiseMultiLayerStorageSummary");
        formatter.field(
            "customer_managed_s3_storage",
            &self.customer_managed_s3_storage,
        );
        formatter.finish()
    }
}
/// See [`DatastoreIotSiteWiseMultiLayerStorageSummary`](crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary)
pub mod datastore_iot_site_wise_multi_layer_storage_summary {
    /// A builder for [`DatastoreIotSiteWiseMultiLayerStorageSummary`](crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_managed_s3_storage:
            std::option::Option<crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary>,
    }
    impl Builder {
        /// <p>Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.</p>
        pub fn customer_managed_s3_storage(
            mut self,
            input: crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary,
        ) -> Self {
            self.customer_managed_s3_storage = Some(input);
            self
        }
        /// <p>Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.</p>
        pub fn set_customer_managed_s3_storage(
            mut self,
            input: std::option::Option<
                crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary,
            >,
        ) -> Self {
            self.customer_managed_s3_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreIotSiteWiseMultiLayerStorageSummary`](crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary)
        pub fn build(self) -> crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary {
            crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary {
                customer_managed_s3_storage: self.customer_managed_s3_storage,
            }
        }
    }
}
impl DatastoreIotSiteWiseMultiLayerStorageSummary {
    /// Creates a new builder-style object to manufacture [`DatastoreIotSiteWiseMultiLayerStorageSummary`](crate::model::DatastoreIotSiteWiseMultiLayerStorageSummary)
    pub fn builder() -> crate::model::datastore_iot_site_wise_multi_layer_storage_summary::Builder {
        crate::model::datastore_iot_site_wise_multi_layer_storage_summary::Builder::default()
    }
}

/// <p> Contains information about the data store that you manage, which stores data used by IoT SiteWise. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotSiteWiseCustomerManagedDatastoreS3StorageSummary {
    /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
    pub key_prefix: std::option::Option<std::string::String>,
}
impl IotSiteWiseCustomerManagedDatastoreS3StorageSummary {
    /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
}
impl std::fmt::Debug for IotSiteWiseCustomerManagedDatastoreS3StorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotSiteWiseCustomerManagedDatastoreS3StorageSummary");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.finish()
    }
}
/// See [`IotSiteWiseCustomerManagedDatastoreS3StorageSummary`](crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary)
pub mod iot_site_wise_customer_managed_datastore_s3_storage_summary {
    /// A builder for [`IotSiteWiseCustomerManagedDatastoreS3StorageSummary`](crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p> The name of the Amazon S3 bucket where your data is stored. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p> (Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/). </p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`IotSiteWiseCustomerManagedDatastoreS3StorageSummary`](crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary)
        pub fn build(self) -> crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary {
            crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
            }
        }
    }
}
impl IotSiteWiseCustomerManagedDatastoreS3StorageSummary {
    /// Creates a new builder-style object to manufacture [`IotSiteWiseCustomerManagedDatastoreS3StorageSummary`](crate::model::IotSiteWiseCustomerManagedDatastoreS3StorageSummary)
    pub fn builder(
    ) -> crate::model::iot_site_wise_customer_managed_datastore_s3_storage_summary::Builder {
        crate::model::iot_site_wise_customer_managed_datastore_s3_storage_summary::Builder::default(
        )
    }
}

/// <p>Contains information about the data store that you manage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerManagedDatastoreS3StorageSummary {
    /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
    pub key_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CustomerManagedDatastoreS3StorageSummary {
    /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomerManagedDatastoreS3StorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerManagedDatastoreS3StorageSummary");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CustomerManagedDatastoreS3StorageSummary`](crate::model::CustomerManagedDatastoreS3StorageSummary)
pub mod customer_managed_datastore_s3_storage_summary {
    /// A builder for [`CustomerManagedDatastoreS3StorageSummary`](crate::model::CustomerManagedDatastoreS3StorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where your data is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket has exactly one key. The prefix must end with a forward slash (/).</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerManagedDatastoreS3StorageSummary`](crate::model::CustomerManagedDatastoreS3StorageSummary)
        pub fn build(self) -> crate::model::CustomerManagedDatastoreS3StorageSummary {
            crate::model::CustomerManagedDatastoreS3StorageSummary {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CustomerManagedDatastoreS3StorageSummary {
    /// Creates a new builder-style object to manufacture [`CustomerManagedDatastoreS3StorageSummary`](crate::model::CustomerManagedDatastoreS3StorageSummary)
    pub fn builder() -> crate::model::customer_managed_datastore_s3_storage_summary::Builder {
        crate::model::customer_managed_datastore_s3_storage_summary::Builder::default()
    }
}

/// <p>Contains information about the data store that is managed by IoT Analytics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceManagedDatastoreS3StorageSummary {}
impl std::fmt::Debug for ServiceManagedDatastoreS3StorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceManagedDatastoreS3StorageSummary");
        formatter.finish()
    }
}
/// See [`ServiceManagedDatastoreS3StorageSummary`](crate::model::ServiceManagedDatastoreS3StorageSummary)
pub mod service_managed_datastore_s3_storage_summary {
    /// A builder for [`ServiceManagedDatastoreS3StorageSummary`](crate::model::ServiceManagedDatastoreS3StorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ServiceManagedDatastoreS3StorageSummary`](crate::model::ServiceManagedDatastoreS3StorageSummary)
        pub fn build(self) -> crate::model::ServiceManagedDatastoreS3StorageSummary {
            crate::model::ServiceManagedDatastoreS3StorageSummary {}
        }
    }
}
impl ServiceManagedDatastoreS3StorageSummary {
    /// Creates a new builder-style object to manufacture [`ServiceManagedDatastoreS3StorageSummary`](crate::model::ServiceManagedDatastoreS3StorageSummary)
    pub fn builder() -> crate::model::service_managed_datastore_s3_storage_summary::Builder {
        crate::model::service_managed_datastore_s3_storage_summary::Builder::default()
    }
}

/// <p>A summary of information about a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetSummary {
    /// <p>The name of the dataset.</p>
    pub dataset_name: std::option::Option<std::string::String>,
    /// <p>The status of the dataset.</p>
    pub status: std::option::Option<crate::model::DatasetStatus>,
    /// <p>The time the dataset was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the dataset was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when another dataset is populated. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects</p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
    /// <p>A list of <code>DataActionSummary</code> objects.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::DatasetActionSummary>>,
}
impl DatasetSummary {
    /// <p>The name of the dataset.</p>
    pub fn dataset_name(&self) -> std::option::Option<&str> {
        self.dataset_name.as_deref()
    }
    /// <p>The status of the dataset.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DatasetStatus> {
        self.status.as_ref()
    }
    /// <p>The time the dataset was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the dataset was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when another dataset is populated. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects</p>
    pub fn triggers(&self) -> std::option::Option<&[crate::model::DatasetTrigger]> {
        self.triggers.as_deref()
    }
    /// <p>A list of <code>DataActionSummary</code> objects.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::DatasetActionSummary]> {
        self.actions.as_deref()
    }
}
impl std::fmt::Debug for DatasetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetSummary");
        formatter.field("dataset_name", &self.dataset_name);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("triggers", &self.triggers);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}
/// See [`DatasetSummary`](crate::model::DatasetSummary)
pub mod dataset_summary {
    /// A builder for [`DatasetSummary`](crate::model::DatasetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DatasetStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::DatasetActionSummary>>,
    }
    impl Builder {
        /// <p>The name of the dataset.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_name = input;
            self
        }
        /// <p>The status of the dataset.</p>
        pub fn status(mut self, input: crate::model::DatasetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the dataset.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatasetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time the dataset was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time the dataset was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the dataset was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the dataset was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when another dataset is populated. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects</p>
        pub fn triggers(mut self, input: crate::model::DatasetTrigger) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input);
            self.triggers = Some(v);
            self
        }
        /// <p>A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when another dataset is populated. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>A list of <code>DataActionSummary</code> objects.</p>
        pub fn actions(mut self, input: crate::model::DatasetActionSummary) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>A list of <code>DataActionSummary</code> objects.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetActionSummary>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetSummary`](crate::model::DatasetSummary)
        pub fn build(self) -> crate::model::DatasetSummary {
            crate::model::DatasetSummary {
                dataset_name: self.dataset_name,
                status: self.status,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                triggers: self.triggers,
                actions: self.actions,
            }
        }
    }
}
impl DatasetSummary {
    /// Creates a new builder-style object to manufacture [`DatasetSummary`](crate::model::DatasetSummary)
    pub fn builder() -> crate::model::dataset_summary::Builder {
        crate::model::dataset_summary::Builder::default()
    }
}

/// <p>Information about the action that automatically creates the dataset's contents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetActionSummary {
    /// <p>The name of the action that automatically creates the dataset's contents.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The type of action by which the dataset's contents are automatically created.</p>
    pub action_type: std::option::Option<crate::model::DatasetActionType>,
}
impl DatasetActionSummary {
    /// <p>The name of the action that automatically creates the dataset's contents.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The type of action by which the dataset's contents are automatically created.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::DatasetActionType> {
        self.action_type.as_ref()
    }
}
impl std::fmt::Debug for DatasetActionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetActionSummary");
        formatter.field("action_name", &self.action_name);
        formatter.field("action_type", &self.action_type);
        formatter.finish()
    }
}
/// See [`DatasetActionSummary`](crate::model::DatasetActionSummary)
pub mod dataset_action_summary {
    /// A builder for [`DatasetActionSummary`](crate::model::DatasetActionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) action_type: std::option::Option<crate::model::DatasetActionType>,
    }
    impl Builder {
        /// <p>The name of the action that automatically creates the dataset's contents.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action that automatically creates the dataset's contents.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The type of action by which the dataset's contents are automatically created.</p>
        pub fn action_type(mut self, input: crate::model::DatasetActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of action by which the dataset's contents are automatically created.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::DatasetActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetActionSummary`](crate::model::DatasetActionSummary)
        pub fn build(self) -> crate::model::DatasetActionSummary {
            crate::model::DatasetActionSummary {
                action_name: self.action_name,
                action_type: self.action_type,
            }
        }
    }
}
impl DatasetActionSummary {
    /// Creates a new builder-style object to manufacture [`DatasetActionSummary`](crate::model::DatasetActionSummary)
    pub fn builder() -> crate::model::dataset_action_summary::Builder {
        crate::model::dataset_action_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetActionType {
    #[allow(missing_docs)] // documentation missing in model
    Container,
    #[allow(missing_docs)] // documentation missing in model
    Query,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetActionType {
    fn from(s: &str) -> Self {
        match s {
            "CONTAINER" => DatasetActionType::Container,
            "QUERY" => DatasetActionType::Query,
            other => DatasetActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetActionType::from(s))
    }
}
impl DatasetActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetActionType::Container => "CONTAINER",
            DatasetActionType::Query => "QUERY",
            DatasetActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTAINER", "QUERY"]
    }
}
impl AsRef<str> for DatasetActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DatasetStatus::Active,
            "CREATING" => DatasetStatus::Creating,
            "DELETING" => DatasetStatus::Deleting,
            other => DatasetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetStatus::from(s))
    }
}
impl DatasetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetStatus::Active => "ACTIVE",
            DatasetStatus::Creating => "CREATING",
            DatasetStatus::Deleting => "DELETING",
            DatasetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for DatasetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about dataset contents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetContentSummary {
    /// <p>The version of the dataset contents.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The status of the dataset contents.</p>
    pub status: std::option::Option<crate::model::DatasetContentStatus>,
    /// <p>The actual time the creation of the dataset contents was started.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the creation of the dataset contents was scheduled to start.</p>
    pub schedule_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the dataset content status was updated to SUCCEEDED or FAILED.</p>
    pub completion_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DatasetContentSummary {
    /// <p>The version of the dataset contents.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The status of the dataset contents.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DatasetContentStatus> {
        self.status.as_ref()
    }
    /// <p>The actual time the creation of the dataset contents was started.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time the creation of the dataset contents was scheduled to start.</p>
    pub fn schedule_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.schedule_time.as_ref()
    }
    /// <p>The time the dataset content status was updated to SUCCEEDED or FAILED.</p>
    pub fn completion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_time.as_ref()
    }
}
impl std::fmt::Debug for DatasetContentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetContentSummary");
        formatter.field("version", &self.version);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("schedule_time", &self.schedule_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.finish()
    }
}
/// See [`DatasetContentSummary`](crate::model::DatasetContentSummary)
pub mod dataset_content_summary {
    /// A builder for [`DatasetContentSummary`](crate::model::DatasetContentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DatasetContentStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) schedule_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The version of the dataset contents.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the dataset contents.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The status of the dataset contents.</p>
        pub fn status(mut self, input: crate::model::DatasetContentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the dataset contents.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatasetContentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The actual time the creation of the dataset contents was started.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The actual time the creation of the dataset contents was started.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time the creation of the dataset contents was scheduled to start.</p>
        pub fn schedule_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.schedule_time = Some(input);
            self
        }
        /// <p>The time the creation of the dataset contents was scheduled to start.</p>
        pub fn set_schedule_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.schedule_time = input;
            self
        }
        /// <p>The time the dataset content status was updated to SUCCEEDED or FAILED.</p>
        pub fn completion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p>The time the dataset content status was updated to SUCCEEDED or FAILED.</p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetContentSummary`](crate::model::DatasetContentSummary)
        pub fn build(self) -> crate::model::DatasetContentSummary {
            crate::model::DatasetContentSummary {
                version: self.version,
                status: self.status,
                creation_time: self.creation_time,
                schedule_time: self.schedule_time,
                completion_time: self.completion_time,
            }
        }
    }
}
impl DatasetContentSummary {
    /// Creates a new builder-style object to manufacture [`DatasetContentSummary`](crate::model::DatasetContentSummary)
    pub fn builder() -> crate::model::dataset_content_summary::Builder {
        crate::model::dataset_content_summary::Builder::default()
    }
}

/// <p>The state of the dataset contents and the reason they are in this state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetContentStatus {
    /// <p>The state of the dataset contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.</p>
    pub state: std::option::Option<crate::model::DatasetContentState>,
    /// <p>The reason the dataset contents are in this state.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl DatasetContentStatus {
    /// <p>The state of the dataset contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::DatasetContentState> {
        self.state.as_ref()
    }
    /// <p>The reason the dataset contents are in this state.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for DatasetContentStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetContentStatus");
        formatter.field("state", &self.state);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`DatasetContentStatus`](crate::model::DatasetContentStatus)
pub mod dataset_content_status {
    /// A builder for [`DatasetContentStatus`](crate::model::DatasetContentStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::DatasetContentState>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the dataset contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.</p>
        pub fn state(mut self, input: crate::model::DatasetContentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the dataset contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DatasetContentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason the dataset contents are in this state.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason the dataset contents are in this state.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetContentStatus`](crate::model::DatasetContentStatus)
        pub fn build(self) -> crate::model::DatasetContentStatus {
            crate::model::DatasetContentStatus {
                state: self.state,
                reason: self.reason,
            }
        }
    }
}
impl DatasetContentStatus {
    /// Creates a new builder-style object to manufacture [`DatasetContentStatus`](crate::model::DatasetContentStatus)
    pub fn builder() -> crate::model::dataset_content_status::Builder {
        crate::model::dataset_content_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetContentState {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetContentState {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => DatasetContentState::Creating,
            "FAILED" => DatasetContentState::Failed,
            "SUCCEEDED" => DatasetContentState::Succeeded,
            other => DatasetContentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetContentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetContentState::from(s))
    }
}
impl DatasetContentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetContentState::Creating => "CREATING",
            DatasetContentState::Failed => "FAILED",
            DatasetContentState::Succeeded => "SUCCEEDED",
            DatasetContentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATING", "FAILED", "SUCCEEDED"]
    }
}
impl AsRef<str> for DatasetContentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of information about a channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelSummary {
    /// <p>The name of the channel.</p>
    pub channel_name: std::option::Option<std::string::String>,
    /// <p>Where channel data is stored.</p>
    pub channel_storage: std::option::Option<crate::model::ChannelStorageSummary>,
    /// <p>The status of the channel.</p>
    pub status: std::option::Option<crate::model::ChannelStatus>,
    /// <p>When the channel was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the channel was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when a new message arrived in the channel.</p>
    /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ChannelSummary {
    /// <p>The name of the channel.</p>
    pub fn channel_name(&self) -> std::option::Option<&str> {
        self.channel_name.as_deref()
    }
    /// <p>Where channel data is stored.</p>
    pub fn channel_storage(&self) -> std::option::Option<&crate::model::ChannelStorageSummary> {
        self.channel_storage.as_ref()
    }
    /// <p>The status of the channel.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChannelStatus> {
        self.status.as_ref()
    }
    /// <p>When the channel was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the channel was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The last time when a new message arrived in the channel.</p>
    /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub fn last_message_arrival_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_message_arrival_time.as_ref()
    }
}
impl std::fmt::Debug for ChannelSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelSummary");
        formatter.field("channel_name", &self.channel_name);
        formatter.field("channel_storage", &self.channel_storage);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("last_message_arrival_time", &self.last_message_arrival_time);
        formatter.finish()
    }
}
/// See [`ChannelSummary`](crate::model::ChannelSummary)
pub mod channel_summary {
    /// A builder for [`ChannelSummary`](crate::model::ChannelSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_name: std::option::Option<std::string::String>,
        pub(crate) channel_storage: std::option::Option<crate::model::ChannelStorageSummary>,
        pub(crate) status: std::option::Option<crate::model::ChannelStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the channel.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_name = input;
            self
        }
        /// <p>Where channel data is stored.</p>
        pub fn channel_storage(mut self, input: crate::model::ChannelStorageSummary) -> Self {
            self.channel_storage = Some(input);
            self
        }
        /// <p>Where channel data is stored.</p>
        pub fn set_channel_storage(
            mut self,
            input: std::option::Option<crate::model::ChannelStorageSummary>,
        ) -> Self {
            self.channel_storage = input;
            self
        }
        /// <p>The status of the channel.</p>
        pub fn status(mut self, input: crate::model::ChannelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the channel.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>When the channel was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the channel was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the channel was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the channel was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The last time when a new message arrived in the channel.</p>
        /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn last_message_arrival_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_message_arrival_time = Some(input);
            self
        }
        /// <p>The last time when a new message arrived in the channel.</p>
        /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn set_last_message_arrival_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_message_arrival_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelSummary`](crate::model::ChannelSummary)
        pub fn build(self) -> crate::model::ChannelSummary {
            crate::model::ChannelSummary {
                channel_name: self.channel_name,
                channel_storage: self.channel_storage,
                status: self.status,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                last_message_arrival_time: self.last_message_arrival_time,
            }
        }
    }
}
impl ChannelSummary {
    /// Creates a new builder-style object to manufacture [`ChannelSummary`](crate::model::ChannelSummary)
    pub fn builder() -> crate::model::channel_summary::Builder {
        crate::model::channel_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ChannelStatus::Active,
            "CREATING" => ChannelStatus::Creating,
            "DELETING" => ChannelStatus::Deleting,
            other => ChannelStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelStatus::from(s))
    }
}
impl ChannelStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelStatus::Active => "ACTIVE",
            ChannelStatus::Creating => "CREATING",
            ChannelStatus::Deleting => "DELETING",
            ChannelStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for ChannelStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Where channel data is stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelStorageSummary {
    /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics.</p>
    pub service_managed_s3:
        std::option::Option<crate::model::ServiceManagedChannelS3StorageSummary>,
    /// <p>Used to store channel data in an S3 bucket that you manage.</p>
    pub customer_managed_s3:
        std::option::Option<crate::model::CustomerManagedChannelS3StorageSummary>,
}
impl ChannelStorageSummary {
    /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics.</p>
    pub fn service_managed_s3(
        &self,
    ) -> std::option::Option<&crate::model::ServiceManagedChannelS3StorageSummary> {
        self.service_managed_s3.as_ref()
    }
    /// <p>Used to store channel data in an S3 bucket that you manage.</p>
    pub fn customer_managed_s3(
        &self,
    ) -> std::option::Option<&crate::model::CustomerManagedChannelS3StorageSummary> {
        self.customer_managed_s3.as_ref()
    }
}
impl std::fmt::Debug for ChannelStorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelStorageSummary");
        formatter.field("service_managed_s3", &self.service_managed_s3);
        formatter.field("customer_managed_s3", &self.customer_managed_s3);
        formatter.finish()
    }
}
/// See [`ChannelStorageSummary`](crate::model::ChannelStorageSummary)
pub mod channel_storage_summary {
    /// A builder for [`ChannelStorageSummary`](crate::model::ChannelStorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_managed_s3:
            std::option::Option<crate::model::ServiceManagedChannelS3StorageSummary>,
        pub(crate) customer_managed_s3:
            std::option::Option<crate::model::CustomerManagedChannelS3StorageSummary>,
    }
    impl Builder {
        /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics.</p>
        pub fn service_managed_s3(
            mut self,
            input: crate::model::ServiceManagedChannelS3StorageSummary,
        ) -> Self {
            self.service_managed_s3 = Some(input);
            self
        }
        /// <p>Used to store channel data in an S3 bucket managed by IoT Analytics.</p>
        pub fn set_service_managed_s3(
            mut self,
            input: std::option::Option<crate::model::ServiceManagedChannelS3StorageSummary>,
        ) -> Self {
            self.service_managed_s3 = input;
            self
        }
        /// <p>Used to store channel data in an S3 bucket that you manage.</p>
        pub fn customer_managed_s3(
            mut self,
            input: crate::model::CustomerManagedChannelS3StorageSummary,
        ) -> Self {
            self.customer_managed_s3 = Some(input);
            self
        }
        /// <p>Used to store channel data in an S3 bucket that you manage.</p>
        pub fn set_customer_managed_s3(
            mut self,
            input: std::option::Option<crate::model::CustomerManagedChannelS3StorageSummary>,
        ) -> Self {
            self.customer_managed_s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelStorageSummary`](crate::model::ChannelStorageSummary)
        pub fn build(self) -> crate::model::ChannelStorageSummary {
            crate::model::ChannelStorageSummary {
                service_managed_s3: self.service_managed_s3,
                customer_managed_s3: self.customer_managed_s3,
            }
        }
    }
}
impl ChannelStorageSummary {
    /// Creates a new builder-style object to manufacture [`ChannelStorageSummary`](crate::model::ChannelStorageSummary)
    pub fn builder() -> crate::model::channel_storage_summary::Builder {
        crate::model::channel_storage_summary::Builder::default()
    }
}

/// <p>Used to store channel data in an S3 bucket that you manage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomerManagedChannelS3StorageSummary {
    /// <p>The name of the S3 bucket in which channel data is stored.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a forward slash (/).</p>
    pub key_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CustomerManagedChannelS3StorageSummary {
    /// <p>The name of the S3 bucket in which channel data is stored.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a forward slash (/).</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
    /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CustomerManagedChannelS3StorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomerManagedChannelS3StorageSummary");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CustomerManagedChannelS3StorageSummary`](crate::model::CustomerManagedChannelS3StorageSummary)
pub mod customer_managed_channel_s3_storage_summary {
    /// A builder for [`CustomerManagedChannelS3StorageSummary`](crate::model::CustomerManagedChannelS3StorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket in which channel data is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket in which channel data is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a forward slash (/).</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>(Optional) The prefix used to create the keys of the channel data objects. Each object in an S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a forward slash (/).</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomerManagedChannelS3StorageSummary`](crate::model::CustomerManagedChannelS3StorageSummary)
        pub fn build(self) -> crate::model::CustomerManagedChannelS3StorageSummary {
            crate::model::CustomerManagedChannelS3StorageSummary {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
                role_arn: self.role_arn,
            }
        }
    }
}
impl CustomerManagedChannelS3StorageSummary {
    /// Creates a new builder-style object to manufacture [`CustomerManagedChannelS3StorageSummary`](crate::model::CustomerManagedChannelS3StorageSummary)
    pub fn builder() -> crate::model::customer_managed_channel_s3_storage_summary::Builder {
        crate::model::customer_managed_channel_s3_storage_summary::Builder::default()
    }
}

/// <p>Used to store channel data in an S3 bucket managed by IoT Analytics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceManagedChannelS3StorageSummary {}
impl std::fmt::Debug for ServiceManagedChannelS3StorageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceManagedChannelS3StorageSummary");
        formatter.finish()
    }
}
/// See [`ServiceManagedChannelS3StorageSummary`](crate::model::ServiceManagedChannelS3StorageSummary)
pub mod service_managed_channel_s3_storage_summary {
    /// A builder for [`ServiceManagedChannelS3StorageSummary`](crate::model::ServiceManagedChannelS3StorageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ServiceManagedChannelS3StorageSummary`](crate::model::ServiceManagedChannelS3StorageSummary)
        pub fn build(self) -> crate::model::ServiceManagedChannelS3StorageSummary {
            crate::model::ServiceManagedChannelS3StorageSummary {}
        }
    }
}
impl ServiceManagedChannelS3StorageSummary {
    /// Creates a new builder-style object to manufacture [`ServiceManagedChannelS3StorageSummary`](crate::model::ServiceManagedChannelS3StorageSummary)
    pub fn builder() -> crate::model::service_managed_channel_s3_storage_summary::Builder {
        crate::model::service_managed_channel_s3_storage_summary::Builder::default()
    }
}

/// <p>The reference to a dataset entry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetEntry {
    /// <p>The name of the dataset item.</p>
    pub entry_name: std::option::Option<std::string::String>,
    /// <p>The presigned URI of the dataset item.</p>
    pub data_uri: std::option::Option<std::string::String>,
}
impl DatasetEntry {
    /// <p>The name of the dataset item.</p>
    pub fn entry_name(&self) -> std::option::Option<&str> {
        self.entry_name.as_deref()
    }
    /// <p>The presigned URI of the dataset item.</p>
    pub fn data_uri(&self) -> std::option::Option<&str> {
        self.data_uri.as_deref()
    }
}
impl std::fmt::Debug for DatasetEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetEntry");
        formatter.field("entry_name", &self.entry_name);
        formatter.field("data_uri", &self.data_uri);
        formatter.finish()
    }
}
/// See [`DatasetEntry`](crate::model::DatasetEntry)
pub mod dataset_entry {
    /// A builder for [`DatasetEntry`](crate::model::DatasetEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_name: std::option::Option<std::string::String>,
        pub(crate) data_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dataset item.</p>
        pub fn entry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset item.</p>
        pub fn set_entry_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_name = input;
            self
        }
        /// <p>The presigned URI of the dataset item.</p>
        pub fn data_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_uri = Some(input.into());
            self
        }
        /// <p>The presigned URI of the dataset item.</p>
        pub fn set_data_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetEntry`](crate::model::DatasetEntry)
        pub fn build(self) -> crate::model::DatasetEntry {
            crate::model::DatasetEntry {
                entry_name: self.entry_name,
                data_uri: self.data_uri,
            }
        }
    }
}
impl DatasetEntry {
    /// Creates a new builder-style object to manufacture [`DatasetEntry`](crate::model::DatasetEntry)
    pub fn builder() -> crate::model::dataset_entry::Builder {
        crate::model::dataset_entry::Builder::default()
    }
}

/// <p>Contains information about a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Pipeline {
    /// <p>The name of the pipeline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the pipeline.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The activities that perform transformations on the messages.</p>
    pub activities: std::option::Option<std::vec::Vec<crate::model::PipelineActivity>>,
    /// <p>A summary of information about the pipeline reprocessing.</p>
    pub reprocessing_summaries:
        std::option::Option<std::vec::Vec<crate::model::ReprocessingSummary>>,
    /// <p>When the pipeline was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the pipeline was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Pipeline {
    /// <p>The name of the pipeline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the pipeline.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The activities that perform transformations on the messages.</p>
    pub fn activities(&self) -> std::option::Option<&[crate::model::PipelineActivity]> {
        self.activities.as_deref()
    }
    /// <p>A summary of information about the pipeline reprocessing.</p>
    pub fn reprocessing_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ReprocessingSummary]> {
        self.reprocessing_summaries.as_deref()
    }
    /// <p>When the pipeline was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the pipeline was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl std::fmt::Debug for Pipeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Pipeline");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("activities", &self.activities);
        formatter.field("reprocessing_summaries", &self.reprocessing_summaries);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.finish()
    }
}
/// See [`Pipeline`](crate::model::Pipeline)
pub mod pipeline {
    /// A builder for [`Pipeline`](crate::model::Pipeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) activities: std::option::Option<std::vec::Vec<crate::model::PipelineActivity>>,
        pub(crate) reprocessing_summaries:
            std::option::Option<std::vec::Vec<crate::model::ReprocessingSummary>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the pipeline.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the pipeline.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `activities`.
        ///
        /// To override the contents of this collection use [`set_activities`](Self::set_activities).
        ///
        /// <p>The activities that perform transformations on the messages.</p>
        pub fn activities(mut self, input: crate::model::PipelineActivity) -> Self {
            let mut v = self.activities.unwrap_or_default();
            v.push(input);
            self.activities = Some(v);
            self
        }
        /// <p>The activities that perform transformations on the messages.</p>
        pub fn set_activities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineActivity>>,
        ) -> Self {
            self.activities = input;
            self
        }
        /// Appends an item to `reprocessing_summaries`.
        ///
        /// To override the contents of this collection use [`set_reprocessing_summaries`](Self::set_reprocessing_summaries).
        ///
        /// <p>A summary of information about the pipeline reprocessing.</p>
        pub fn reprocessing_summaries(mut self, input: crate::model::ReprocessingSummary) -> Self {
            let mut v = self.reprocessing_summaries.unwrap_or_default();
            v.push(input);
            self.reprocessing_summaries = Some(v);
            self
        }
        /// <p>A summary of information about the pipeline reprocessing.</p>
        pub fn set_reprocessing_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReprocessingSummary>>,
        ) -> Self {
            self.reprocessing_summaries = input;
            self
        }
        /// <p>When the pipeline was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the pipeline was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the pipeline was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the pipeline was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Pipeline`](crate::model::Pipeline)
        pub fn build(self) -> crate::model::Pipeline {
            crate::model::Pipeline {
                name: self.name,
                arn: self.arn,
                activities: self.activities,
                reprocessing_summaries: self.reprocessing_summaries,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
            }
        }
    }
}
impl Pipeline {
    /// Creates a new builder-style object to manufacture [`Pipeline`](crate::model::Pipeline)
    pub fn builder() -> crate::model::pipeline::Builder {
        crate::model::pipeline::Builder::default()
    }
}

/// <p>Statistical information about the data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreStatistics {
    /// <p>The estimated size of the data store.</p>
    pub size: std::option::Option<crate::model::EstimatedResourceSize>,
}
impl DatastoreStatistics {
    /// <p>The estimated size of the data store.</p>
    pub fn size(&self) -> std::option::Option<&crate::model::EstimatedResourceSize> {
        self.size.as_ref()
    }
}
impl std::fmt::Debug for DatastoreStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreStatistics");
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`DatastoreStatistics`](crate::model::DatastoreStatistics)
pub mod datastore_statistics {
    /// A builder for [`DatastoreStatistics`](crate::model::DatastoreStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size: std::option::Option<crate::model::EstimatedResourceSize>,
    }
    impl Builder {
        /// <p>The estimated size of the data store.</p>
        pub fn size(mut self, input: crate::model::EstimatedResourceSize) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The estimated size of the data store.</p>
        pub fn set_size(
            mut self,
            input: std::option::Option<crate::model::EstimatedResourceSize>,
        ) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreStatistics`](crate::model::DatastoreStatistics)
        pub fn build(self) -> crate::model::DatastoreStatistics {
            crate::model::DatastoreStatistics { size: self.size }
        }
    }
}
impl DatastoreStatistics {
    /// Creates a new builder-style object to manufacture [`DatastoreStatistics`](crate::model::DatastoreStatistics)
    pub fn builder() -> crate::model::datastore_statistics::Builder {
        crate::model::datastore_statistics::Builder::default()
    }
}

/// <p>The estimated size of the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EstimatedResourceSize {
    /// <p>The estimated size of the resource, in bytes.</p>
    pub estimated_size_in_bytes: std::option::Option<f64>,
    /// <p>The time when the estimate of the size of the resource was made.</p>
    pub estimated_on: std::option::Option<aws_smithy_types::DateTime>,
}
impl EstimatedResourceSize {
    /// <p>The estimated size of the resource, in bytes.</p>
    pub fn estimated_size_in_bytes(&self) -> std::option::Option<f64> {
        self.estimated_size_in_bytes
    }
    /// <p>The time when the estimate of the size of the resource was made.</p>
    pub fn estimated_on(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.estimated_on.as_ref()
    }
}
impl std::fmt::Debug for EstimatedResourceSize {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EstimatedResourceSize");
        formatter.field("estimated_size_in_bytes", &self.estimated_size_in_bytes);
        formatter.field("estimated_on", &self.estimated_on);
        formatter.finish()
    }
}
/// See [`EstimatedResourceSize`](crate::model::EstimatedResourceSize)
pub mod estimated_resource_size {
    /// A builder for [`EstimatedResourceSize`](crate::model::EstimatedResourceSize)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) estimated_size_in_bytes: std::option::Option<f64>,
        pub(crate) estimated_on: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The estimated size of the resource, in bytes.</p>
        pub fn estimated_size_in_bytes(mut self, input: f64) -> Self {
            self.estimated_size_in_bytes = Some(input);
            self
        }
        /// <p>The estimated size of the resource, in bytes.</p>
        pub fn set_estimated_size_in_bytes(mut self, input: std::option::Option<f64>) -> Self {
            self.estimated_size_in_bytes = input;
            self
        }
        /// <p>The time when the estimate of the size of the resource was made.</p>
        pub fn estimated_on(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.estimated_on = Some(input);
            self
        }
        /// <p>The time when the estimate of the size of the resource was made.</p>
        pub fn set_estimated_on(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.estimated_on = input;
            self
        }
        /// Consumes the builder and constructs a [`EstimatedResourceSize`](crate::model::EstimatedResourceSize)
        pub fn build(self) -> crate::model::EstimatedResourceSize {
            crate::model::EstimatedResourceSize {
                estimated_size_in_bytes: self.estimated_size_in_bytes,
                estimated_on: self.estimated_on,
            }
        }
    }
}
impl EstimatedResourceSize {
    /// Creates a new builder-style object to manufacture [`EstimatedResourceSize`](crate::model::EstimatedResourceSize)
    pub fn builder() -> crate::model::estimated_resource_size::Builder {
        crate::model::estimated_resource_size::Builder::default()
    }
}

/// <p>Information about a data store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Datastore {
    /// <p>The name of the data store.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
    pub storage: std::option::Option<crate::model::DatastoreStorage>,
    /// <p>The ARN of the data store.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of a data store:</p>
    /// <dl>
    /// <dt>
    /// CREATING
    /// </dt>
    /// <dd>
    /// <p>The data store is being created.</p>
    /// </dd>
    /// <dt>
    /// ACTIVE
    /// </dt>
    /// <dd>
    /// <p>The data store has been created and can be used.</p>
    /// </dd>
    /// <dt>
    /// DELETING
    /// </dt>
    /// <dd>
    /// <p>The data store is being deleted.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::DatastoreStatus>,
    /// <p>How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>When the data store was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the data store was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when a new message arrived in the data store.</p>
    /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
    /// <p>The default file format is JSON. You can specify only one format.</p>
    /// <p>You can't change the file format after you create the data store.</p>
    pub file_format_configuration: std::option::Option<crate::model::FileFormatConfiguration>,
    /// <p> Contains information about the partition dimensions in a data store. </p>
    pub datastore_partitions: std::option::Option<crate::model::DatastorePartitions>,
}
impl Datastore {
    /// <p>The name of the data store.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
    pub fn storage(&self) -> std::option::Option<&crate::model::DatastoreStorage> {
        self.storage.as_ref()
    }
    /// <p>The ARN of the data store.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of a data store:</p>
    /// <dl>
    /// <dt>
    /// CREATING
    /// </dt>
    /// <dd>
    /// <p>The data store is being created.</p>
    /// </dd>
    /// <dt>
    /// ACTIVE
    /// </dt>
    /// <dd>
    /// <p>The data store has been created and can be used.</p>
    /// </dd>
    /// <dt>
    /// DELETING
    /// </dt>
    /// <dd>
    /// <p>The data store is being deleted.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::DatastoreStatus> {
        self.status.as_ref()
    }
    /// <p>How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>When the data store was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the data store was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The last time when a new message arrived in the data store.</p>
    /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub fn last_message_arrival_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_message_arrival_time.as_ref()
    }
    /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
    /// <p>The default file format is JSON. You can specify only one format.</p>
    /// <p>You can't change the file format after you create the data store.</p>
    pub fn file_format_configuration(
        &self,
    ) -> std::option::Option<&crate::model::FileFormatConfiguration> {
        self.file_format_configuration.as_ref()
    }
    /// <p> Contains information about the partition dimensions in a data store. </p>
    pub fn datastore_partitions(&self) -> std::option::Option<&crate::model::DatastorePartitions> {
        self.datastore_partitions.as_ref()
    }
}
impl std::fmt::Debug for Datastore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Datastore");
        formatter.field("name", &self.name);
        formatter.field("storage", &self.storage);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("retention_period", &self.retention_period);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("last_message_arrival_time", &self.last_message_arrival_time);
        formatter.field("file_format_configuration", &self.file_format_configuration);
        formatter.field("datastore_partitions", &self.datastore_partitions);
        formatter.finish()
    }
}
/// See [`Datastore`](crate::model::Datastore)
pub mod datastore {
    /// A builder for [`Datastore`](crate::model::Datastore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) storage: std::option::Option<crate::model::DatastoreStorage>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DatastoreStatus>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) file_format_configuration:
            std::option::Option<crate::model::FileFormatConfiguration>,
        pub(crate) datastore_partitions: std::option::Option<crate::model::DatastorePartitions>,
    }
    impl Builder {
        /// <p>The name of the data store.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data store.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn storage(mut self, input: crate::model::DatastoreStorage) -> Self {
            self.storage = Some(input);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn set_storage(
            mut self,
            input: std::option::Option<crate::model::DatastoreStorage>,
        ) -> Self {
            self.storage = input;
            self
        }
        /// <p>The ARN of the data store.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the data store.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of a data store:</p>
        /// <dl>
        /// <dt>
        /// CREATING
        /// </dt>
        /// <dd>
        /// <p>The data store is being created.</p>
        /// </dd>
        /// <dt>
        /// ACTIVE
        /// </dt>
        /// <dd>
        /// <p>The data store has been created and can be used.</p>
        /// </dd>
        /// <dt>
        /// DELETING
        /// </dt>
        /// <dd>
        /// <p>The data store is being deleted.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::DatastoreStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a data store:</p>
        /// <dl>
        /// <dt>
        /// CREATING
        /// </dt>
        /// <dd>
        /// <p>The data store is being created.</p>
        /// </dd>
        /// <dt>
        /// ACTIVE
        /// </dt>
        /// <dd>
        /// <p>The data store has been created and can be used.</p>
        /// </dd>
        /// <dt>
        /// DELETING
        /// </dt>
        /// <dd>
        /// <p>The data store is being deleted.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatastoreStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>When the data store was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the data store was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the data store was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the data store was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The last time when a new message arrived in the data store.</p>
        /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn last_message_arrival_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_message_arrival_time = Some(input);
            self
        }
        /// <p>The last time when a new message arrived in the data store.</p>
        /// <p>IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn set_last_message_arrival_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_message_arrival_time = input;
            self
        }
        /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn file_format_configuration(
            mut self,
            input: crate::model::FileFormatConfiguration,
        ) -> Self {
            self.file_format_configuration = Some(input);
            self
        }
        /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn set_file_format_configuration(
            mut self,
            input: std::option::Option<crate::model::FileFormatConfiguration>,
        ) -> Self {
            self.file_format_configuration = input;
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn datastore_partitions(mut self, input: crate::model::DatastorePartitions) -> Self {
            self.datastore_partitions = Some(input);
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn set_datastore_partitions(
            mut self,
            input: std::option::Option<crate::model::DatastorePartitions>,
        ) -> Self {
            self.datastore_partitions = input;
            self
        }
        /// Consumes the builder and constructs a [`Datastore`](crate::model::Datastore)
        pub fn build(self) -> crate::model::Datastore {
            crate::model::Datastore {
                name: self.name,
                storage: self.storage,
                arn: self.arn,
                status: self.status,
                retention_period: self.retention_period,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                last_message_arrival_time: self.last_message_arrival_time,
                file_format_configuration: self.file_format_configuration,
                datastore_partitions: self.datastore_partitions,
            }
        }
    }
}
impl Datastore {
    /// Creates a new builder-style object to manufacture [`Datastore`](crate::model::Datastore)
    pub fn builder() -> crate::model::datastore::Builder {
        crate::model::datastore::Builder::default()
    }
}

/// <p>Information about a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dataset {
    /// <p>The name of the dataset.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the dataset.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The <code>DatasetAction</code> objects that automatically create the dataset contents.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::DatasetAction>>,
    /// <p>The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.</p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
    /// <p>When dataset contents are created they are delivered to destinations specified here.</p>
    pub content_delivery_rules:
        std::option::Option<std::vec::Vec<crate::model::DatasetContentDeliveryRule>>,
    /// <p>The status of the dataset.</p>
    pub status: std::option::Option<crate::model::DatasetStatus>,
    /// <p>When the dataset was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the dataset was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Optional. How long, in days, message data is kept for the dataset.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"> Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
    pub versioning_configuration: std::option::Option<crate::model::VersioningConfiguration>,
    /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
    pub late_data_rules: std::option::Option<std::vec::Vec<crate::model::LateDataRule>>,
}
impl Dataset {
    /// <p>The name of the dataset.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the dataset.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The <code>DatasetAction</code> objects that automatically create the dataset contents.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::DatasetAction]> {
        self.actions.as_deref()
    }
    /// <p>The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.</p>
    pub fn triggers(&self) -> std::option::Option<&[crate::model::DatasetTrigger]> {
        self.triggers.as_deref()
    }
    /// <p>When dataset contents are created they are delivered to destinations specified here.</p>
    pub fn content_delivery_rules(
        &self,
    ) -> std::option::Option<&[crate::model::DatasetContentDeliveryRule]> {
        self.content_delivery_rules.as_deref()
    }
    /// <p>The status of the dataset.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DatasetStatus> {
        self.status.as_ref()
    }
    /// <p>When the dataset was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the dataset was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>Optional. How long, in days, message data is kept for the dataset.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"> Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
    pub fn versioning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::VersioningConfiguration> {
        self.versioning_configuration.as_ref()
    }
    /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
    pub fn late_data_rules(&self) -> std::option::Option<&[crate::model::LateDataRule]> {
        self.late_data_rules.as_deref()
    }
}
impl std::fmt::Debug for Dataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dataset");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("actions", &self.actions);
        formatter.field("triggers", &self.triggers);
        formatter.field("content_delivery_rules", &self.content_delivery_rules);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("retention_period", &self.retention_period);
        formatter.field("versioning_configuration", &self.versioning_configuration);
        formatter.field("late_data_rules", &self.late_data_rules);
        formatter.finish()
    }
}
/// See [`Dataset`](crate::model::Dataset)
pub mod dataset {
    /// A builder for [`Dataset`](crate::model::Dataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::DatasetAction>>,
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        pub(crate) content_delivery_rules:
            std::option::Option<std::vec::Vec<crate::model::DatasetContentDeliveryRule>>,
        pub(crate) status: std::option::Option<crate::model::DatasetStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) versioning_configuration:
            std::option::Option<crate::model::VersioningConfiguration>,
        pub(crate) late_data_rules: std::option::Option<std::vec::Vec<crate::model::LateDataRule>>,
    }
    impl Builder {
        /// <p>The name of the dataset.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The <code>DatasetAction</code> objects that automatically create the dataset contents.</p>
        pub fn actions(mut self, input: crate::model::DatasetAction) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>The <code>DatasetAction</code> objects that automatically create the dataset contents.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetAction>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.</p>
        pub fn triggers(mut self, input: crate::model::DatasetTrigger) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input);
            self.triggers = Some(v);
            self
        }
        /// <p>The <code>DatasetTrigger</code> objects that specify when the dataset is automatically updated.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// Appends an item to `content_delivery_rules`.
        ///
        /// To override the contents of this collection use [`set_content_delivery_rules`](Self::set_content_delivery_rules).
        ///
        /// <p>When dataset contents are created they are delivered to destinations specified here.</p>
        pub fn content_delivery_rules(
            mut self,
            input: crate::model::DatasetContentDeliveryRule,
        ) -> Self {
            let mut v = self.content_delivery_rules.unwrap_or_default();
            v.push(input);
            self.content_delivery_rules = Some(v);
            self
        }
        /// <p>When dataset contents are created they are delivered to destinations specified here.</p>
        pub fn set_content_delivery_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetContentDeliveryRule>>,
        ) -> Self {
            self.content_delivery_rules = input;
            self
        }
        /// <p>The status of the dataset.</p>
        pub fn status(mut self, input: crate::model::DatasetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the dataset.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatasetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>When the dataset was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the dataset was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the dataset was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time the dataset was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>Optional. How long, in days, message data is kept for the dataset.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>Optional. How long, in days, message data is kept for the dataset.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"> Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn versioning_configuration(
            mut self,
            input: crate::model::VersioningConfiguration,
        ) -> Self {
            self.versioning_configuration = Some(input);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"> Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn set_versioning_configuration(
            mut self,
            input: std::option::Option<crate::model::VersioningConfiguration>,
        ) -> Self {
            self.versioning_configuration = input;
            self
        }
        /// Appends an item to `late_data_rules`.
        ///
        /// To override the contents of this collection use [`set_late_data_rules`](Self::set_late_data_rules).
        ///
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn late_data_rules(mut self, input: crate::model::LateDataRule) -> Self {
            let mut v = self.late_data_rules.unwrap_or_default();
            v.push(input);
            self.late_data_rules = Some(v);
            self
        }
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn set_late_data_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LateDataRule>>,
        ) -> Self {
            self.late_data_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`Dataset`](crate::model::Dataset)
        pub fn build(self) -> crate::model::Dataset {
            crate::model::Dataset {
                name: self.name,
                arn: self.arn,
                actions: self.actions,
                triggers: self.triggers,
                content_delivery_rules: self.content_delivery_rules,
                status: self.status,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                retention_period: self.retention_period,
                versioning_configuration: self.versioning_configuration,
                late_data_rules: self.late_data_rules,
            }
        }
    }
}
impl Dataset {
    /// Creates a new builder-style object to manufacture [`Dataset`](crate::model::Dataset)
    pub fn builder() -> crate::model::dataset::Builder {
        crate::model::dataset::Builder::default()
    }
}

/// <p>Statistics information about the channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelStatistics {
    /// <p>The estimated size of the channel.</p>
    pub size: std::option::Option<crate::model::EstimatedResourceSize>,
}
impl ChannelStatistics {
    /// <p>The estimated size of the channel.</p>
    pub fn size(&self) -> std::option::Option<&crate::model::EstimatedResourceSize> {
        self.size.as_ref()
    }
}
impl std::fmt::Debug for ChannelStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelStatistics");
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`ChannelStatistics`](crate::model::ChannelStatistics)
pub mod channel_statistics {
    /// A builder for [`ChannelStatistics`](crate::model::ChannelStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size: std::option::Option<crate::model::EstimatedResourceSize>,
    }
    impl Builder {
        /// <p>The estimated size of the channel.</p>
        pub fn size(mut self, input: crate::model::EstimatedResourceSize) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The estimated size of the channel.</p>
        pub fn set_size(
            mut self,
            input: std::option::Option<crate::model::EstimatedResourceSize>,
        ) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelStatistics`](crate::model::ChannelStatistics)
        pub fn build(self) -> crate::model::ChannelStatistics {
            crate::model::ChannelStatistics { size: self.size }
        }
    }
}
impl ChannelStatistics {
    /// Creates a new builder-style object to manufacture [`ChannelStatistics`](crate::model::ChannelStatistics)
    pub fn builder() -> crate::model::channel_statistics::Builder {
        crate::model::channel_statistics::Builder::default()
    }
}

/// <p>A collection of data from an MQTT topic. Channels archive the raw, unprocessed messages before publishing the data to a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Channel {
    /// <p>The name of the channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
    pub storage: std::option::Option<crate::model::ChannelStorage>,
    /// <p>The ARN of the channel.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the channel.</p>
    pub status: std::option::Option<crate::model::ChannelStatus>,
    /// <p>How long, in days, message data is kept for the channel.</p>
    pub retention_period: std::option::Option<crate::model::RetentionPeriod>,
    /// <p>When the channel was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the channel was last updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when a new message arrived in the channel.</p>
    /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Channel {
    /// <p>The name of the channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
    pub fn storage(&self) -> std::option::Option<&crate::model::ChannelStorage> {
        self.storage.as_ref()
    }
    /// <p>The ARN of the channel.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the channel.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChannelStatus> {
        self.status.as_ref()
    }
    /// <p>How long, in days, message data is kept for the channel.</p>
    pub fn retention_period(&self) -> std::option::Option<&crate::model::RetentionPeriod> {
        self.retention_period.as_ref()
    }
    /// <p>When the channel was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>When the channel was last updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The last time when a new message arrived in the channel.</p>
    /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
    /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
    pub fn last_message_arrival_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_message_arrival_time.as_ref()
    }
}
impl std::fmt::Debug for Channel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Channel");
        formatter.field("name", &self.name);
        formatter.field("storage", &self.storage);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("retention_period", &self.retention_period);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("last_message_arrival_time", &self.last_message_arrival_time);
        formatter.finish()
    }
}
/// See [`Channel`](crate::model::Channel)
pub mod channel {
    /// A builder for [`Channel`](crate::model::Channel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) storage: std::option::Option<crate::model::ChannelStorage>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ChannelStatus>,
        pub(crate) retention_period: std::option::Option<crate::model::RetentionPeriod>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_message_arrival_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
        pub fn storage(mut self, input: crate::model::ChannelStorage) -> Self {
            self.storage = Some(input);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
        pub fn set_storage(
            mut self,
            input: std::option::Option<crate::model::ChannelStorage>,
        ) -> Self {
            self.storage = input;
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the channel.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the channel.</p>
        pub fn status(mut self, input: crate::model::ChannelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the channel.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>How long, in days, message data is kept for the channel.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>How long, in days, message data is kept for the channel.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>When the channel was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the channel was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>When the channel was last updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>When the channel was last updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The last time when a new message arrived in the channel.</p>
        /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn last_message_arrival_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_message_arrival_time = Some(input);
            self
        }
        /// <p>The last time when a new message arrived in the channel.</p>
        /// <p>IoT Analytics updates this value at most once per minute for one channel. Hence, the <code>lastMessageArrivalTime</code> value is an approximation.</p>
        /// <p>This feature only applies to messages that arrived in the data store after October 23, 2020. </p>
        pub fn set_last_message_arrival_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_message_arrival_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Channel`](crate::model::Channel)
        pub fn build(self) -> crate::model::Channel {
            crate::model::Channel {
                name: self.name,
                storage: self.storage,
                arn: self.arn,
                status: self.status,
                retention_period: self.retention_period,
                creation_time: self.creation_time,
                last_update_time: self.last_update_time,
                last_message_arrival_time: self.last_message_arrival_time,
            }
        }
    }
}
impl Channel {
    /// Creates a new builder-style object to manufacture [`Channel`](crate::model::Channel)
    pub fn builder() -> crate::model::channel::Builder {
        crate::model::channel::Builder::default()
    }
}

/// <p>Contains informations about errors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutMessageErrorEntry {
    /// <p>The ID of the message that caused the error. See the value corresponding to the <code>messageId</code> key in the message object.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The code associated with the error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The message associated with the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchPutMessageErrorEntry {
    /// <p>The ID of the message that caused the error. See the value corresponding to the <code>messageId</code> key in the message object.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The code associated with the error.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The message associated with the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchPutMessageErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutMessageErrorEntry");
        formatter.field("message_id", &self.message_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
pub mod batch_put_message_error_entry {
    /// A builder for [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the message that caused the error. See the value corresponding to the <code>messageId</code> key in the message object.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message that caused the error. See the value corresponding to the <code>messageId</code> key in the message object.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The code associated with the error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The code associated with the error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The message associated with the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The message associated with the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
        pub fn build(self) -> crate::model::BatchPutMessageErrorEntry {
            crate::model::BatchPutMessageErrorEntry {
                message_id: self.message_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchPutMessageErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchPutMessageErrorEntry`](crate::model::BatchPutMessageErrorEntry)
    pub fn builder() -> crate::model::batch_put_message_error_entry::Builder {
        crate::model::batch_put_message_error_entry::Builder::default()
    }
}

/// <p>Information about a message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch sent.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>The payload of the message. This can be a JSON string or a base64-encoded string representing binary data, in which case you must decode it by means of a pipeline activity.</p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
}
impl Message {
    /// <p>The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch sent.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>The payload of the message. This can be a JSON string or a base64-encoded string representing binary data, in which case you must decode it by means of a pipeline activity.</p>
    pub fn payload(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("message_id", &self.message_id);
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch sent.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID you want to assign to the message. Each <code>messageId</code> must be unique within each batch sent.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>The payload of the message. This can be a JSON string or a base64-encoded string representing binary data, in which case you must decode it by means of a pipeline activity.</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>The payload of the message. This can be a JSON string or a base64-encoded string representing binary data, in which case you must decode it by means of a pipeline activity.</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                message_id: self.message_id,
                payload: self.payload,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}
