// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT Analytics
///
/// Client for invoking operations on AWS IoT Analytics. Each operation on AWS IoT Analytics is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iotanalytics::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iotanalytics::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iotanalytics::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchPutMessage`](crate::client::fluent_builders::BatchPutMessage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::BatchPutMessage::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::BatchPutMessage::set_channel_name): <p>The name of the channel where the messages are sent.</p>
    ///   - [`messages(Vec<Message>)`](crate::client::fluent_builders::BatchPutMessage::messages) / [`set_messages(Option<Vec<Message>>)`](crate::client::fluent_builders::BatchPutMessage::set_messages): <p>The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}.</p>  <p>The field names of message payloads (data) that you send to IoT Analytics:</p>  <ul>   <li> <p>Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.</p> </li>   <li> <p>Must begin with an alphabetic character or single underscore (_).</p> </li>   <li> <p>Cannot contain hyphens (-).</p> </li>   <li> <p>In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$". </p> </li>   <li> <p>Cannot be more than 255 characters.</p> </li>   <li> <p>Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)</p> </li>  </ul>  <p>For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or {"__temp_01": 29} are invalid in message payloads. </p>
    /// - On success, responds with [`BatchPutMessageOutput`](crate::output::BatchPutMessageOutput) with field(s):
    ///   - [`batch_put_message_error_entries(Option<Vec<BatchPutMessageErrorEntry>>)`](crate::output::BatchPutMessageOutput::batch_put_message_error_entries): <p>A list of any errors encountered when sending the messages to the channel.</p>
    /// - On failure, responds with [`SdkError<BatchPutMessageError>`](crate::error::BatchPutMessageError)
    pub fn batch_put_message(&self) -> fluent_builders::BatchPutMessage {
        fluent_builders::BatchPutMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelPipelineReprocessing`](crate::client::fluent_builders::CancelPipelineReprocessing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_name(impl Into<String>)`](crate::client::fluent_builders::CancelPipelineReprocessing::pipeline_name) / [`set_pipeline_name(Option<String>)`](crate::client::fluent_builders::CancelPipelineReprocessing::set_pipeline_name): <p>The name of pipeline for which data reprocessing is canceled.</p>
    ///   - [`reprocessing_id(impl Into<String>)`](crate::client::fluent_builders::CancelPipelineReprocessing::reprocessing_id) / [`set_reprocessing_id(Option<String>)`](crate::client::fluent_builders::CancelPipelineReprocessing::set_reprocessing_id): <p>The ID of the reprocessing task (returned by <code>StartPipelineReprocessing</code>).</p>
    /// - On success, responds with [`CancelPipelineReprocessingOutput`](crate::output::CancelPipelineReprocessingOutput)

    /// - On failure, responds with [`SdkError<CancelPipelineReprocessingError>`](crate::error::CancelPipelineReprocessingError)
    pub fn cancel_pipeline_reprocessing(&self) -> fluent_builders::CancelPipelineReprocessing {
        fluent_builders::CancelPipelineReprocessing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateChannel`](crate::client::fluent_builders::CreateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::CreateChannel::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::CreateChannel::set_channel_name): <p>The name of the channel.</p>
    ///   - [`channel_storage(ChannelStorage)`](crate::client::fluent_builders::CreateChannel::channel_storage) / [`set_channel_storage(Option<ChannelStorage>)`](crate::client::fluent_builders::CreateChannel::set_channel_storage): <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
    ///   - [`retention_period(RetentionPeriod)`](crate::client::fluent_builders::CreateChannel::retention_period) / [`set_retention_period(Option<RetentionPeriod>)`](crate::client::fluent_builders::CreateChannel::set_retention_period): <p>How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateChannel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateChannel::set_tags): <p>Metadata which can be used to manage the channel.</p>
    /// - On success, responds with [`CreateChannelOutput`](crate::output::CreateChannelOutput) with field(s):
    ///   - [`channel_name(Option<String>)`](crate::output::CreateChannelOutput::channel_name): <p>The name of the channel.</p>
    ///   - [`channel_arn(Option<String>)`](crate::output::CreateChannelOutput::channel_arn): <p>The ARN of the channel.</p>
    ///   - [`retention_period(Option<RetentionPeriod>)`](crate::output::CreateChannelOutput::retention_period): <p>How long, in days, message data is kept for the channel.</p>
    /// - On failure, responds with [`SdkError<CreateChannelError>`](crate::error::CreateChannelError)
    pub fn create_channel(&self) -> fluent_builders::CreateChannel {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataset`](crate::client::fluent_builders::CreateDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::CreateDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::CreateDataset::set_dataset_name): <p>The name of the dataset.</p>
    ///   - [`actions(Vec<DatasetAction>)`](crate::client::fluent_builders::CreateDataset::actions) / [`set_actions(Option<Vec<DatasetAction>>)`](crate::client::fluent_builders::CreateDataset::set_actions): <p>A list of actions that create the dataset contents.</p>
    ///   - [`triggers(Vec<DatasetTrigger>)`](crate::client::fluent_builders::CreateDataset::triggers) / [`set_triggers(Option<Vec<DatasetTrigger>>)`](crate::client::fluent_builders::CreateDataset::set_triggers): <p>A list of triggers. A trigger causes dataset contents to be populated at a specified time interval or when another dataset's contents are created. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects.</p>
    ///   - [`content_delivery_rules(Vec<DatasetContentDeliveryRule>)`](crate::client::fluent_builders::CreateDataset::content_delivery_rules) / [`set_content_delivery_rules(Option<Vec<DatasetContentDeliveryRule>>)`](crate::client::fluent_builders::CreateDataset::set_content_delivery_rules): <p>When dataset contents are created, they are delivered to destinations specified here.</p>
    ///   - [`retention_period(RetentionPeriod)`](crate::client::fluent_builders::CreateDataset::retention_period) / [`set_retention_period(Option<RetentionPeriod>)`](crate::client::fluent_builders::CreateDataset::set_retention_period): <p>Optional. How long, in days, versions of dataset contents are kept for the dataset. If not specified or set to <code>null</code>, versions of dataset contents are retained for at most 90 days. The number of versions of dataset contents retained is determined by the <code>versioningConfiguration</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"> Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
    ///   - [`versioning_configuration(VersioningConfiguration)`](crate::client::fluent_builders::CreateDataset::versioning_configuration) / [`set_versioning_configuration(Option<VersioningConfiguration>)`](crate::client::fluent_builders::CreateDataset::set_versioning_configuration): <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDataset::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDataset::set_tags): <p>Metadata which can be used to manage the dataset.</p>
    ///   - [`late_data_rules(Vec<LateDataRule>)`](crate::client::fluent_builders::CreateDataset::late_data_rules) / [`set_late_data_rules(Option<Vec<LateDataRule>>)`](crate::client::fluent_builders::CreateDataset::set_late_data_rules): <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
    /// - On success, responds with [`CreateDatasetOutput`](crate::output::CreateDatasetOutput) with field(s):
    ///   - [`dataset_name(Option<String>)`](crate::output::CreateDatasetOutput::dataset_name): <p>The name of the dataset.</p>
    ///   - [`dataset_arn(Option<String>)`](crate::output::CreateDatasetOutput::dataset_arn): <p>The ARN of the dataset.</p>
    ///   - [`retention_period(Option<RetentionPeriod>)`](crate::output::CreateDatasetOutput::retention_period): <p>How long, in days, dataset contents are kept for the dataset.</p>
    /// - On failure, responds with [`SdkError<CreateDatasetError>`](crate::error::CreateDatasetError)
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDatasetContent`](crate::client::fluent_builders::CreateDatasetContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::CreateDatasetContent::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::CreateDatasetContent::set_dataset_name): <p>The name of the dataset.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::CreateDatasetContent::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::CreateDatasetContent::set_version_id): <p>The version ID of the dataset content. To specify <code>versionId</code> for a dataset content, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
    /// - On success, responds with [`CreateDatasetContentOutput`](crate::output::CreateDatasetContentOutput) with field(s):
    ///   - [`version_id(Option<String>)`](crate::output::CreateDatasetContentOutput::version_id): <p>The version ID of the dataset contents that are being created.</p>
    /// - On failure, responds with [`SdkError<CreateDatasetContentError>`](crate::error::CreateDatasetContentError)
    pub fn create_dataset_content(&self) -> fluent_builders::CreateDatasetContent {
        fluent_builders::CreateDatasetContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDatastore`](crate::client::fluent_builders::CreateDatastore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_name(impl Into<String>)`](crate::client::fluent_builders::CreateDatastore::datastore_name) / [`set_datastore_name(Option<String>)`](crate::client::fluent_builders::CreateDatastore::set_datastore_name): <p>The name of the data store.</p>
    ///   - [`datastore_storage(DatastoreStorage)`](crate::client::fluent_builders::CreateDatastore::datastore_storage) / [`set_datastore_storage(Option<DatastoreStorage>)`](crate::client::fluent_builders::CreateDatastore::set_datastore_storage): <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
    ///   - [`retention_period(RetentionPeriod)`](crate::client::fluent_builders::CreateDatastore::retention_period) / [`set_retention_period(Option<RetentionPeriod>)`](crate::client::fluent_builders::CreateDatastore::set_retention_period): <p>How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDatastore::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDatastore::set_tags): <p>Metadata which can be used to manage the data store.</p>
    ///   - [`file_format_configuration(FileFormatConfiguration)`](crate::client::fluent_builders::CreateDatastore::file_format_configuration) / [`set_file_format_configuration(Option<FileFormatConfiguration>)`](crate::client::fluent_builders::CreateDatastore::set_file_format_configuration): <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>  <p>The default file format is JSON. You can specify only one format.</p>  <p>You can't change the file format after you create the data store.</p>
    ///   - [`datastore_partitions(DatastorePartitions)`](crate::client::fluent_builders::CreateDatastore::datastore_partitions) / [`set_datastore_partitions(Option<DatastorePartitions>)`](crate::client::fluent_builders::CreateDatastore::set_datastore_partitions): <p> Contains information about the partition dimensions in a data store. </p>
    /// - On success, responds with [`CreateDatastoreOutput`](crate::output::CreateDatastoreOutput) with field(s):
    ///   - [`datastore_name(Option<String>)`](crate::output::CreateDatastoreOutput::datastore_name): <p>The name of the data store.</p>
    ///   - [`datastore_arn(Option<String>)`](crate::output::CreateDatastoreOutput::datastore_arn): <p>The ARN of the data store.</p>
    ///   - [`retention_period(Option<RetentionPeriod>)`](crate::output::CreateDatastoreOutput::retention_period): <p>How long, in days, message data is kept for the data store.</p>
    /// - On failure, responds with [`SdkError<CreateDatastoreError>`](crate::error::CreateDatastoreError)
    pub fn create_datastore(&self) -> fluent_builders::CreateDatastore {
        fluent_builders::CreateDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePipeline`](crate::client::fluent_builders::CreatePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_name(impl Into<String>)`](crate::client::fluent_builders::CreatePipeline::pipeline_name) / [`set_pipeline_name(Option<String>)`](crate::client::fluent_builders::CreatePipeline::set_pipeline_name): <p>The name of the pipeline.</p>
    ///   - [`pipeline_activities(Vec<PipelineActivity>)`](crate::client::fluent_builders::CreatePipeline::pipeline_activities) / [`set_pipeline_activities(Option<Vec<PipelineActivity>>)`](crate::client::fluent_builders::CreatePipeline::set_pipeline_activities): <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda unctions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p>  <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:</p>  <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePipeline::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePipeline::set_tags): <p>Metadata which can be used to manage the pipeline.</p>
    /// - On success, responds with [`CreatePipelineOutput`](crate::output::CreatePipelineOutput) with field(s):
    ///   - [`pipeline_name(Option<String>)`](crate::output::CreatePipelineOutput::pipeline_name): <p>The name of the pipeline.</p>
    ///   - [`pipeline_arn(Option<String>)`](crate::output::CreatePipelineOutput::pipeline_arn): <p>The ARN of the pipeline.</p>
    /// - On failure, responds with [`SdkError<CreatePipelineError>`](crate::error::CreatePipelineError)
    pub fn create_pipeline(&self) -> fluent_builders::CreatePipeline {
        fluent_builders::CreatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::DeleteChannel::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::DeleteChannel::set_channel_name): <p>The name of the channel to delete.</p>
    /// - On success, responds with [`DeleteChannelOutput`](crate::output::DeleteChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteChannelError>`](crate::error::DeleteChannelError)
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_dataset_name): <p>The name of the dataset to delete.</p>
    /// - On success, responds with [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)

    /// - On failure, responds with [`SdkError<DeleteDatasetError>`](crate::error::DeleteDatasetError)
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDatasetContent`](crate::client::fluent_builders::DeleteDatasetContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDatasetContent::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::DeleteDatasetContent::set_dataset_name): <p>The name of the dataset whose content is deleted.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDatasetContent::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::DeleteDatasetContent::set_version_id): <p>The version of the dataset whose content is deleted. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully completed data set. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
    /// - On success, responds with [`DeleteDatasetContentOutput`](crate::output::DeleteDatasetContentOutput)

    /// - On failure, responds with [`SdkError<DeleteDatasetContentError>`](crate::error::DeleteDatasetContentError)
    pub fn delete_dataset_content(&self) -> fluent_builders::DeleteDatasetContent {
        fluent_builders::DeleteDatasetContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDatastore`](crate::client::fluent_builders::DeleteDatastore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDatastore::datastore_name) / [`set_datastore_name(Option<String>)`](crate::client::fluent_builders::DeleteDatastore::set_datastore_name): <p>The name of the data store to delete.</p>
    /// - On success, responds with [`DeleteDatastoreOutput`](crate::output::DeleteDatastoreOutput)

    /// - On failure, responds with [`SdkError<DeleteDatastoreError>`](crate::error::DeleteDatastoreError)
    pub fn delete_datastore(&self) -> fluent_builders::DeleteDatastore {
        fluent_builders::DeleteDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePipeline`](crate::client::fluent_builders::DeletePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_name(impl Into<String>)`](crate::client::fluent_builders::DeletePipeline::pipeline_name) / [`set_pipeline_name(Option<String>)`](crate::client::fluent_builders::DeletePipeline::set_pipeline_name): <p>The name of the pipeline to delete.</p>
    /// - On success, responds with [`DeletePipelineOutput`](crate::output::DeletePipelineOutput)

    /// - On failure, responds with [`SdkError<DeletePipelineError>`](crate::error::DeletePipelineError)
    pub fn delete_pipeline(&self) -> fluent_builders::DeletePipeline {
        fluent_builders::DeletePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::DescribeChannel::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::DescribeChannel::set_channel_name): <p>The name of the channel whose information is retrieved.</p>
    ///   - [`include_statistics(bool)`](crate::client::fluent_builders::DescribeChannel::include_statistics) / [`set_include_statistics(bool)`](crate::client::fluent_builders::DescribeChannel::set_include_statistics): <p>If true, additional statistical information about the channel is included in the response. This feature can't be used with a channel whose S3 storage is customer-managed.</p>
    /// - On success, responds with [`DescribeChannelOutput`](crate::output::DescribeChannelOutput) with field(s):
    ///   - [`channel(Option<Channel>)`](crate::output::DescribeChannelOutput::channel): <p>An object that contains information about the channel.</p>
    ///   - [`statistics(Option<ChannelStatistics>)`](crate::output::DescribeChannelOutput::statistics): <p>Statistics about the channel. Included if the <code>includeStatistics</code> parameter is set to <code>true</code> in the request.</p>
    /// - On failure, responds with [`SdkError<DescribeChannelError>`](crate::error::DescribeChannelError)
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_dataset_name): <p>The name of the dataset whose information is retrieved.</p>
    /// - On success, responds with [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput) with field(s):
    ///   - [`dataset(Option<Dataset>)`](crate::output::DescribeDatasetOutput::dataset): <p>An object that contains information about the dataset.</p>
    /// - On failure, responds with [`SdkError<DescribeDatasetError>`](crate::error::DescribeDatasetError)
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDatastore`](crate::client::fluent_builders::DescribeDatastore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDatastore::datastore_name) / [`set_datastore_name(Option<String>)`](crate::client::fluent_builders::DescribeDatastore::set_datastore_name): <p>The name of the data store</p>
    ///   - [`include_statistics(bool)`](crate::client::fluent_builders::DescribeDatastore::include_statistics) / [`set_include_statistics(bool)`](crate::client::fluent_builders::DescribeDatastore::set_include_statistics): <p>If true, additional statistical information about the data store is included in the response. This feature can't be used with a data store whose S3 storage is customer-managed.</p>
    /// - On success, responds with [`DescribeDatastoreOutput`](crate::output::DescribeDatastoreOutput) with field(s):
    ///   - [`datastore(Option<Datastore>)`](crate::output::DescribeDatastoreOutput::datastore): <p>Information about the data store.</p>
    ///   - [`statistics(Option<DatastoreStatistics>)`](crate::output::DescribeDatastoreOutput::statistics): <p>Additional statistical information about the data store. Included if the <code>includeStatistics</code> parameter is set to <code>true</code> in the request.</p>
    /// - On failure, responds with [`SdkError<DescribeDatastoreError>`](crate::error::DescribeDatastoreError)
    pub fn describe_datastore(&self) -> fluent_builders::DescribeDatastore {
        fluent_builders::DescribeDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoggingOptions`](crate::client::fluent_builders::DescribeLoggingOptions) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeLoggingOptions::send) it.

    /// - On success, responds with [`DescribeLoggingOptionsOutput`](crate::output::DescribeLoggingOptionsOutput) with field(s):
    ///   - [`logging_options(Option<LoggingOptions>)`](crate::output::DescribeLoggingOptionsOutput::logging_options): <p>The current settings of the IoT Analytics logging options.</p>
    /// - On failure, responds with [`SdkError<DescribeLoggingOptionsError>`](crate::error::DescribeLoggingOptionsError)
    pub fn describe_logging_options(&self) -> fluent_builders::DescribeLoggingOptions {
        fluent_builders::DescribeLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePipeline`](crate::client::fluent_builders::DescribePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_name(impl Into<String>)`](crate::client::fluent_builders::DescribePipeline::pipeline_name) / [`set_pipeline_name(Option<String>)`](crate::client::fluent_builders::DescribePipeline::set_pipeline_name): <p>The name of the pipeline whose information is retrieved.</p>
    /// - On success, responds with [`DescribePipelineOutput`](crate::output::DescribePipelineOutput) with field(s):
    ///   - [`pipeline(Option<Pipeline>)`](crate::output::DescribePipelineOutput::pipeline): <p>A <code>Pipeline</code> object that contains information about the pipeline.</p>
    /// - On failure, responds with [`SdkError<DescribePipelineError>`](crate::error::DescribePipelineError)
    pub fn describe_pipeline(&self) -> fluent_builders::DescribePipeline {
        fluent_builders::DescribePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDatasetContent`](crate::client::fluent_builders::GetDatasetContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::GetDatasetContent::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::GetDatasetContent::set_dataset_name): <p>The name of the dataset whose contents are retrieved.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetDatasetContent::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetDatasetContent::set_version_id): <p>The version of the dataset whose contents are retrieved. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of the latest or latest successfully completed dataset. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
    /// - On success, responds with [`GetDatasetContentOutput`](crate::output::GetDatasetContentOutput) with field(s):
    ///   - [`entries(Option<Vec<DatasetEntry>>)`](crate::output::GetDatasetContentOutput::entries): <p>A list of <code>DatasetEntry</code> objects.</p>
    ///   - [`timestamp(Option<DateTime>)`](crate::output::GetDatasetContentOutput::timestamp): <p>The time when the request was made.</p>
    ///   - [`status(Option<DatasetContentStatus>)`](crate::output::GetDatasetContentOutput::status): <p>The status of the dataset content.</p>
    /// - On failure, responds with [`SdkError<GetDatasetContentError>`](crate::error::GetDatasetContentError)
    pub fn get_dataset_content(&self) -> fluent_builders::GetDatasetContent {
        fluent_builders::GetDatasetContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListChannels`](crate::client::fluent_builders::ListChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListChannels::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListChannels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListChannels::set_max_results): <p>The maximum number of results to return in this request.</p>  <p>The default value is 100.</p>
    /// - On success, responds with [`ListChannelsOutput`](crate::output::ListChannelsOutput) with field(s):
    ///   - [`channel_summaries(Option<Vec<ChannelSummary>>)`](crate::output::ListChannelsOutput::channel_summaries): <p>A list of <code>ChannelSummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListChannelsOutput::next_token): <p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListChannelsError>`](crate::error::ListChannelsError)
    pub fn list_channels(&self) -> fluent_builders::ListChannels {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatasetContents`](crate::client::fluent_builders::ListDatasetContents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatasetContents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::ListDatasetContents::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::ListDatasetContents::set_dataset_name): <p>The name of the dataset whose contents information you want to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatasetContents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatasetContents::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatasetContents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDatasetContents::set_max_results): <p>The maximum number of results to return in this request.</p>
    ///   - [`scheduled_on_or_after(DateTime)`](crate::client::fluent_builders::ListDatasetContents::scheduled_on_or_after) / [`set_scheduled_on_or_after(Option<DateTime>)`](crate::client::fluent_builders::ListDatasetContents::set_scheduled_on_or_after): <p>A filter to limit results to those dataset contents whose creation is scheduled on or after the given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code> request. (timestamp)</p>
    ///   - [`scheduled_before(DateTime)`](crate::client::fluent_builders::ListDatasetContents::scheduled_before) / [`set_scheduled_before(Option<DateTime>)`](crate::client::fluent_builders::ListDatasetContents::set_scheduled_before): <p>A filter to limit results to those dataset contents whose creation is scheduled before the given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code> request. (timestamp)</p>
    /// - On success, responds with [`ListDatasetContentsOutput`](crate::output::ListDatasetContentsOutput) with field(s):
    ///   - [`dataset_content_summaries(Option<Vec<DatasetContentSummary>>)`](crate::output::ListDatasetContentsOutput::dataset_content_summaries): <p>Summary information about dataset contents that have been created.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatasetContentsOutput::next_token): <p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListDatasetContentsError>`](crate::error::ListDatasetContentsError)
    pub fn list_dataset_contents(&self) -> fluent_builders::ListDatasetContents {
        fluent_builders::ListDatasetContents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatasets`](crate::client::fluent_builders::ListDatasets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatasets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatasets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatasets::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatasets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDatasets::set_max_results): <p>The maximum number of results to return in this request.</p>  <p>The default value is 100.</p>
    /// - On success, responds with [`ListDatasetsOutput`](crate::output::ListDatasetsOutput) with field(s):
    ///   - [`dataset_summaries(Option<Vec<DatasetSummary>>)`](crate::output::ListDatasetsOutput::dataset_summaries): <p>A list of <code>DatasetSummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatasetsOutput::next_token): <p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListDatasetsError>`](crate::error::ListDatasetsError)
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatastores`](crate::client::fluent_builders::ListDatastores) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatastores::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatastores::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatastores::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatastores::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDatastores::set_max_results): <p>The maximum number of results to return in this request.</p>  <p>The default value is 100.</p>
    /// - On success, responds with [`ListDatastoresOutput`](crate::output::ListDatastoresOutput) with field(s):
    ///   - [`datastore_summaries(Option<Vec<DatastoreSummary>>)`](crate::output::ListDatastoresOutput::datastore_summaries): <p>A list of <code>DatastoreSummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatastoresOutput::next_token): <p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListDatastoresError>`](crate::error::ListDatastoresError)
    pub fn list_datastores(&self) -> fluent_builders::ListDatastores {
        fluent_builders::ListDatastores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPipelines`](crate::client::fluent_builders::ListPipelines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPipelines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPipelines::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPipelines::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPipelines::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPipelines::set_max_results): <p>The maximum number of results to return in this request.</p>  <p>The default value is 100.</p>
    /// - On success, responds with [`ListPipelinesOutput`](crate::output::ListPipelinesOutput) with field(s):
    ///   - [`pipeline_summaries(Option<Vec<PipelineSummary>>)`](crate::output::ListPipelinesOutput::pipeline_summaries): <p>A list of <code>PipelineSummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPipelinesOutput::next_token): <p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListPipelinesError>`](crate::error::ListPipelinesError)
    pub fn list_pipelines(&self) -> fluent_builders::ListPipelines {
        fluent_builders::ListPipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource whose tags you want to list.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags (metadata) that you have assigned to the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLoggingOptions`](crate::client::fluent_builders::PutLoggingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`logging_options(LoggingOptions)`](crate::client::fluent_builders::PutLoggingOptions::logging_options) / [`set_logging_options(Option<LoggingOptions>)`](crate::client::fluent_builders::PutLoggingOptions::set_logging_options): <p>The new values of the IoT Analytics logging options.</p>
    /// - On success, responds with [`PutLoggingOptionsOutput`](crate::output::PutLoggingOptionsOutput)

    /// - On failure, responds with [`SdkError<PutLoggingOptionsError>`](crate::error::PutLoggingOptionsError)
    pub fn put_logging_options(&self) -> fluent_builders::PutLoggingOptions {
        fluent_builders::PutLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RunPipelineActivity`](crate::client::fluent_builders::RunPipelineActivity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_activity(PipelineActivity)`](crate::client::fluent_builders::RunPipelineActivity::pipeline_activity) / [`set_pipeline_activity(Option<PipelineActivity>)`](crate::client::fluent_builders::RunPipelineActivity::set_pipeline_activity): <p>The pipeline activity that is run. This must not be a channel activity or a data store activity because these activities are used in a pipeline only to load the original message and to store the (possibly) transformed message. If a Lambda activity is specified, only short-running Lambda functions (those with a timeout of less than 30 seconds or less) can be used.</p>
    ///   - [`payloads(Vec<Blob>)`](crate::client::fluent_builders::RunPipelineActivity::payloads) / [`set_payloads(Option<Vec<Blob>>)`](crate::client::fluent_builders::RunPipelineActivity::set_payloads): <p>The sample message payloads on which the pipeline activity is run.</p>
    /// - On success, responds with [`RunPipelineActivityOutput`](crate::output::RunPipelineActivityOutput) with field(s):
    ///   - [`payloads(Option<Vec<Blob>>)`](crate::output::RunPipelineActivityOutput::payloads): <p>The enriched or transformed sample message payloads as base64-encoded strings. (The results of running the pipeline activity on each input sample message payload, encoded in base64.)</p>
    ///   - [`log_result(Option<String>)`](crate::output::RunPipelineActivityOutput::log_result): <p>In case the pipeline activity fails, the log message that is generated.</p>
    /// - On failure, responds with [`SdkError<RunPipelineActivityError>`](crate::error::RunPipelineActivityError)
    pub fn run_pipeline_activity(&self) -> fluent_builders::RunPipelineActivity {
        fluent_builders::RunPipelineActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SampleChannelData`](crate::client::fluent_builders::SampleChannelData) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::SampleChannelData::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::SampleChannelData::set_channel_name): <p>The name of the channel whose message samples are retrieved.</p>
    ///   - [`max_messages(i32)`](crate::client::fluent_builders::SampleChannelData::max_messages) / [`set_max_messages(Option<i32>)`](crate::client::fluent_builders::SampleChannelData::set_max_messages): <p>The number of sample messages to be retrieved. The limit is 10. The default is also 10.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::SampleChannelData::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::SampleChannelData::set_start_time): <p>The start of the time window from which sample messages are retrieved.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::SampleChannelData::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::SampleChannelData::set_end_time): <p>The end of the time window from which sample messages are retrieved.</p>
    /// - On success, responds with [`SampleChannelDataOutput`](crate::output::SampleChannelDataOutput) with field(s):
    ///   - [`payloads(Option<Vec<Blob>>)`](crate::output::SampleChannelDataOutput::payloads): <p>The list of message samples. Each sample message is returned as a base64-encoded string.</p>
    /// - On failure, responds with [`SdkError<SampleChannelDataError>`](crate::error::SampleChannelDataError)
    pub fn sample_channel_data(&self) -> fluent_builders::SampleChannelData {
        fluent_builders::SampleChannelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartPipelineReprocessing`](crate::client::fluent_builders::StartPipelineReprocessing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_name(impl Into<String>)`](crate::client::fluent_builders::StartPipelineReprocessing::pipeline_name) / [`set_pipeline_name(Option<String>)`](crate::client::fluent_builders::StartPipelineReprocessing::set_pipeline_name): <p>The name of the pipeline on which to start reprocessing.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::StartPipelineReprocessing::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::StartPipelineReprocessing::set_start_time): <p>The start time (inclusive) of raw message data that is reprocessed.</p>  <p>If you specify a value for the <code>startTime</code> parameter, you must not use the <code>channelMessages</code> object.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::StartPipelineReprocessing::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::StartPipelineReprocessing::set_end_time): <p>The end time (exclusive) of raw message data that is reprocessed.</p>  <p>If you specify a value for the <code>endTime</code> parameter, you must not use the <code>channelMessages</code> object.</p>
    ///   - [`channel_messages(ChannelMessages)`](crate::client::fluent_builders::StartPipelineReprocessing::channel_messages) / [`set_channel_messages(Option<ChannelMessages>)`](crate::client::fluent_builders::StartPipelineReprocessing::set_channel_messages): <p>Specifies one or more sets of channel messages that you want to reprocess.</p>  <p>If you use the <code>channelMessages</code> object, you must not specify a value for <code>startTime</code> and <code>endTime</code>.</p>
    /// - On success, responds with [`StartPipelineReprocessingOutput`](crate::output::StartPipelineReprocessingOutput) with field(s):
    ///   - [`reprocessing_id(Option<String>)`](crate::output::StartPipelineReprocessingOutput::reprocessing_id): <p>The ID of the pipeline reprocessing activity that was started.</p>
    /// - On failure, responds with [`SdkError<StartPipelineReprocessingError>`](crate::error::StartPipelineReprocessingError)
    pub fn start_pipeline_reprocessing(&self) -> fluent_builders::StartPipelineReprocessing {
        fluent_builders::StartPipelineReprocessing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource whose tags you want to modify.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The new or modified tags for the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource whose tags you want to remove.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of those tags which you want to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`channel_name(impl Into<String>)`](crate::client::fluent_builders::UpdateChannel::channel_name) / [`set_channel_name(Option<String>)`](crate::client::fluent_builders::UpdateChannel::set_channel_name): <p>The name of the channel to be updated.</p>
    ///   - [`channel_storage(ChannelStorage)`](crate::client::fluent_builders::UpdateChannel::channel_storage) / [`set_channel_storage(Option<ChannelStorage>)`](crate::client::fluent_builders::UpdateChannel::set_channel_storage): <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
    ///   - [`retention_period(RetentionPeriod)`](crate::client::fluent_builders::UpdateChannel::retention_period) / [`set_retention_period(Option<RetentionPeriod>)`](crate::client::fluent_builders::UpdateChannel::set_retention_period): <p>How long, in days, message data is kept for the channel. The retention period can't be updated if the channel's Amazon S3 storage is customer-managed.</p>
    /// - On success, responds with [`UpdateChannelOutput`](crate::output::UpdateChannelOutput)

    /// - On failure, responds with [`SdkError<UpdateChannelError>`](crate::error::UpdateChannelError)
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataset`](crate::client::fluent_builders::UpdateDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataset::dataset_name) / [`set_dataset_name(Option<String>)`](crate::client::fluent_builders::UpdateDataset::set_dataset_name): <p>The name of the dataset to update.</p>
    ///   - [`actions(Vec<DatasetAction>)`](crate::client::fluent_builders::UpdateDataset::actions) / [`set_actions(Option<Vec<DatasetAction>>)`](crate::client::fluent_builders::UpdateDataset::set_actions): <p>A list of <code>DatasetAction</code> objects.</p>
    ///   - [`triggers(Vec<DatasetTrigger>)`](crate::client::fluent_builders::UpdateDataset::triggers) / [`set_triggers(Option<Vec<DatasetTrigger>>)`](crate::client::fluent_builders::UpdateDataset::set_triggers): <p>A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five <code>DatasetTrigger</code> objects.</p>
    ///   - [`content_delivery_rules(Vec<DatasetContentDeliveryRule>)`](crate::client::fluent_builders::UpdateDataset::content_delivery_rules) / [`set_content_delivery_rules(Option<Vec<DatasetContentDeliveryRule>>)`](crate::client::fluent_builders::UpdateDataset::set_content_delivery_rules): <p>When dataset contents are created, they are delivered to destinations specified here.</p>
    ///   - [`retention_period(RetentionPeriod)`](crate::client::fluent_builders::UpdateDataset::retention_period) / [`set_retention_period(Option<RetentionPeriod>)`](crate::client::fluent_builders::UpdateDataset::set_retention_period): <p>How long, in days, dataset contents are kept for the dataset.</p>
    ///   - [`versioning_configuration(VersioningConfiguration)`](crate::client::fluent_builders::UpdateDataset::versioning_configuration) / [`set_versioning_configuration(Option<VersioningConfiguration>)`](crate::client::fluent_builders::UpdateDataset::set_versioning_configuration): <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
    ///   - [`late_data_rules(Vec<LateDataRule>)`](crate::client::fluent_builders::UpdateDataset::late_data_rules) / [`set_late_data_rules(Option<Vec<LateDataRule>>)`](crate::client::fluent_builders::UpdateDataset::set_late_data_rules): <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
    /// - On success, responds with [`UpdateDatasetOutput`](crate::output::UpdateDatasetOutput)

    /// - On failure, responds with [`SdkError<UpdateDatasetError>`](crate::error::UpdateDatasetError)
    pub fn update_dataset(&self) -> fluent_builders::UpdateDataset {
        fluent_builders::UpdateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDatastore`](crate::client::fluent_builders::UpdateDatastore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDatastore::datastore_name) / [`set_datastore_name(Option<String>)`](crate::client::fluent_builders::UpdateDatastore::set_datastore_name): <p>The name of the data store to be updated.</p>
    ///   - [`retention_period(RetentionPeriod)`](crate::client::fluent_builders::UpdateDatastore::retention_period) / [`set_retention_period(Option<RetentionPeriod>)`](crate::client::fluent_builders::UpdateDatastore::set_retention_period): <p>How long, in days, message data is kept for the data store. The retention period can't be updated if the data store's Amazon S3 storage is customer-managed.</p>
    ///   - [`datastore_storage(DatastoreStorage)`](crate::client::fluent_builders::UpdateDatastore::datastore_storage) / [`set_datastore_storage(Option<DatastoreStorage>)`](crate::client::fluent_builders::UpdateDatastore::set_datastore_storage): <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
    ///   - [`file_format_configuration(FileFormatConfiguration)`](crate::client::fluent_builders::UpdateDatastore::file_format_configuration) / [`set_file_format_configuration(Option<FileFormatConfiguration>)`](crate::client::fluent_builders::UpdateDatastore::set_file_format_configuration): <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>  <p>The default file format is JSON. You can specify only one format.</p>  <p>You can't change the file format after you create the data store.</p>
    /// - On success, responds with [`UpdateDatastoreOutput`](crate::output::UpdateDatastoreOutput)

    /// - On failure, responds with [`SdkError<UpdateDatastoreError>`](crate::error::UpdateDatastoreError)
    pub fn update_datastore(&self) -> fluent_builders::UpdateDatastore {
        fluent_builders::UpdateDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePipeline`](crate::client::fluent_builders::UpdatePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pipeline_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePipeline::pipeline_name) / [`set_pipeline_name(Option<String>)`](crate::client::fluent_builders::UpdatePipeline::set_pipeline_name): <p>The name of the pipeline to update.</p>
    ///   - [`pipeline_activities(Vec<PipelineActivity>)`](crate::client::fluent_builders::UpdatePipeline::pipeline_activities) / [`set_pipeline_activities(Option<Vec<PipelineActivity>>)`](crate::client::fluent_builders::UpdatePipeline::set_pipeline_activities): <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p>  <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:</p>  <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>
    /// - On success, responds with [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)

    /// - On failure, responds with [`SdkError<UpdatePipelineError>`](crate::error::UpdatePipelineError)
    pub fn update_pipeline(&self) -> fluent_builders::UpdatePipeline {
        fluent_builders::UpdatePipeline::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchPutMessage`.
    ///
    /// <p>Sends messages to a channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchPutMessage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_put_message_input::Builder,
    }
    impl BatchPutMessage {
        /// Creates a new `BatchPutMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutMessageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel where the messages are sent.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>The name of the channel where the messages are sent.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}.</p>
        /// <p>The field names of message payloads (data) that you send to IoT Analytics:</p>
        /// <ul>
        /// <li> <p>Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.</p> </li>
        /// <li> <p>Must begin with an alphabetic character or single underscore (_).</p> </li>
        /// <li> <p>Cannot contain hyphens (-).</p> </li>
        /// <li> <p>In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$". </p> </li>
        /// <li> <p>Cannot be more than 255 characters.</p> </li>
        /// <li> <p>Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)</p> </li>
        /// </ul>
        /// <p>For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or {"__temp_01": 29} are invalid in message payloads. </p>
        pub fn messages(mut self, input: crate::model::Message) -> Self {
            self.inner = self.inner.messages(input);
            self
        }
        /// <p>The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}.</p>
        /// <p>The field names of message payloads (data) that you send to IoT Analytics:</p>
        /// <ul>
        /// <li> <p>Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.</p> </li>
        /// <li> <p>Must begin with an alphabetic character or single underscore (_).</p> </li>
        /// <li> <p>Cannot contain hyphens (-).</p> </li>
        /// <li> <p>In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$". </p> </li>
        /// <li> <p>Cannot be more than 255 characters.</p> </li>
        /// <li> <p>Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)</p> </li>
        /// </ul>
        /// <p>For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or {"__temp_01": 29} are invalid in message payloads. </p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.inner = self.inner.set_messages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelPipelineReprocessing`.
    ///
    /// <p>Cancels the reprocessing of data through the pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelPipelineReprocessing {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_pipeline_reprocessing_input::Builder,
    }
    impl CancelPipelineReprocessing {
        /// Creates a new `CancelPipelineReprocessing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelPipelineReprocessingOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelPipelineReprocessingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of pipeline for which data reprocessing is canceled.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of pipeline for which data reprocessing is canceled.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The ID of the reprocessing task (returned by <code>StartPipelineReprocessing</code>).</p>
        pub fn reprocessing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reprocessing_id(input.into());
            self
        }
        /// <p>The ID of the reprocessing task (returned by <code>StartPipelineReprocessing</code>).</p>
        pub fn set_reprocessing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reprocessing_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages before publishing the data to a pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl CreateChannel {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
        pub fn channel_storage(mut self, input: crate::model::ChannelStorage) -> Self {
            self.inner = self.inner.channel_storage(input);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
        pub fn set_channel_storage(
            mut self,
            input: std::option::Option<crate::model::ChannelStorage>,
        ) -> Self {
            self.inner = self.inner.set_channel_storage(input);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the channel.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the channel.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Used to create a dataset. A dataset stores data retrieved from a data store by applying a <code>queryAction</code> (a SQL query) or a <code>containerAction</code> (executing a containerized application). This operation creates the skeleton of a dataset. The dataset can be populated manually by calling <code>CreateDatasetContent</code> or automatically according to a trigger you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl CreateDataset {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>A list of actions that create the dataset contents.</p>
        pub fn actions(mut self, input: crate::model::DatasetAction) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>A list of actions that create the dataset contents.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetAction>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>A list of triggers. A trigger causes dataset contents to be populated at a specified time interval or when another dataset's contents are created. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects.</p>
        pub fn triggers(mut self, input: crate::model::DatasetTrigger) -> Self {
            self.inner = self.inner.triggers(input);
            self
        }
        /// <p>A list of triggers. A trigger causes dataset contents to be populated at a specified time interval or when another dataset's contents are created. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
        /// Appends an item to `contentDeliveryRules`.
        ///
        /// To override the contents of this collection use [`set_content_delivery_rules`](Self::set_content_delivery_rules).
        ///
        /// <p>When dataset contents are created, they are delivered to destinations specified here.</p>
        pub fn content_delivery_rules(
            mut self,
            input: crate::model::DatasetContentDeliveryRule,
        ) -> Self {
            self.inner = self.inner.content_delivery_rules(input);
            self
        }
        /// <p>When dataset contents are created, they are delivered to destinations specified here.</p>
        pub fn set_content_delivery_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetContentDeliveryRule>>,
        ) -> Self {
            self.inner = self.inner.set_content_delivery_rules(input);
            self
        }
        /// <p>Optional. How long, in days, versions of dataset contents are kept for the dataset. If not specified or set to <code>null</code>, versions of dataset contents are retained for at most 90 days. The number of versions of dataset contents retained is determined by the <code>versioningConfiguration</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"> Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>Optional. How long, in days, versions of dataset contents are kept for the dataset. If not specified or set to <code>null</code>, versions of dataset contents are retained for at most 90 days. The number of versions of dataset contents retained is determined by the <code>versioningConfiguration</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"> Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn versioning_configuration(
            mut self,
            input: crate::model::VersioningConfiguration,
        ) -> Self {
            self.inner = self.inner.versioning_configuration(input);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn set_versioning_configuration(
            mut self,
            input: std::option::Option<crate::model::VersioningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_versioning_configuration(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the dataset.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `lateDataRules`.
        ///
        /// To override the contents of this collection use [`set_late_data_rules`](Self::set_late_data_rules).
        ///
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn late_data_rules(mut self, input: crate::model::LateDataRule) -> Self {
            self.inner = self.inner.late_data_rules(input);
            self
        }
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn set_late_data_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LateDataRule>>,
        ) -> Self {
            self.inner = self.inner.set_late_data_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatasetContent`.
    ///
    /// <p>Creates the content of a dataset by applying a <code>queryAction</code> (a SQL query) or a <code>containerAction</code> (executing a containerized application).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDatasetContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dataset_content_input::Builder,
    }
    impl CreateDatasetContent {
        /// Creates a new `CreateDatasetContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetContentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The version ID of the dataset content. To specify <code>versionId</code> for a dataset content, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The version ID of the dataset content. To specify <code>versionId</code> for a dataset content, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatastore`.
    ///
    /// <p>Creates a data store, which is a repository for messages.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDatastore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_datastore_input::Builder,
    }
    impl CreateDatastore {
        /// Creates a new `CreateDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatastoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(input.into());
            self
        }
        /// <p>The name of the data store.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn datastore_storage(mut self, input: crate::model::DatastoreStorage) -> Self {
            self.inner = self.inner.datastore_storage(input);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn set_datastore_storage(
            mut self,
            input: std::option::Option<crate::model::DatastoreStorage>,
        ) -> Self {
            self.inner = self.inner.set_datastore_storage(input);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. When <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the data store.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the data store.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn file_format_configuration(
            mut self,
            input: crate::model::FileFormatConfiguration,
        ) -> Self {
            self.inner = self.inner.file_format_configuration(input);
            self
        }
        /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn set_file_format_configuration(
            mut self,
            input: std::option::Option<crate::model::FileFormatConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_file_format_configuration(input);
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn datastore_partitions(mut self, input: crate::model::DatastorePartitions) -> Self {
            self.inner = self.inner.datastore_partitions(input);
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn set_datastore_partitions(
            mut self,
            input: std::option::Option<crate::model::DatastorePartitions>,
        ) -> Self {
            self.inner = self.inner.set_datastore_partitions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePipeline`.
    ///
    /// <p>Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before storing them in a data store. You must specify both a <code>channel</code> and a <code>datastore</code> activity and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pipeline_input::Builder,
    }
    impl CreatePipeline {
        /// Creates a new `CreatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// Appends an item to `pipelineActivities`.
        ///
        /// To override the contents of this collection use [`set_pipeline_activities`](Self::set_pipeline_activities).
        ///
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda unctions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:</p>
        /// <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>
        pub fn pipeline_activities(mut self, input: crate::model::PipelineActivity) -> Self {
            self.inner = self.inner.pipeline_activities(input);
            self
        }
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda unctions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:</p>
        /// <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>
        pub fn set_pipeline_activities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineActivity>>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_activities(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the pipeline.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Deletes the specified channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl DeleteChannel {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel to delete.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>The name of the channel to delete.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes the specified dataset.</p>
    /// <p>You do not have to delete the content of the dataset before you perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl DeleteDataset {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to delete.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset to delete.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatasetContent`.
    ///
    /// <p>Deletes the content of the specified dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDatasetContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dataset_content_input::Builder,
    }
    impl DeleteDatasetContent {
        /// Creates a new `DeleteDatasetContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetContentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset whose content is deleted.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset whose content is deleted.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The version of the dataset whose content is deleted. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully completed data set. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The version of the dataset whose content is deleted. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully completed data set. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatastore`.
    ///
    /// <p>Deletes the specified data store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDatastore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_datastore_input::Builder,
    }
    impl DeleteDatastore {
        /// Creates a new `DeleteDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatastoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store to delete.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(input.into());
            self
        }
        /// <p>The name of the data store to delete.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePipeline`.
    ///
    /// <p>Deletes the specified pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_pipeline_input::Builder,
    }
    impl DeletePipeline {
        /// Creates a new `DeletePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to delete.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline to delete.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// <p>Retrieves information about a channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl DescribeChannel {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel whose information is retrieved.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>The name of the channel whose information is retrieved.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>If true, additional statistical information about the channel is included in the response. This feature can't be used with a channel whose S3 storage is customer-managed.</p>
        pub fn include_statistics(mut self, input: bool) -> Self {
            self.inner = self.inner.include_statistics(input);
            self
        }
        /// <p>If true, additional statistical information about the channel is included in the response. This feature can't be used with a channel whose S3 storage is customer-managed.</p>
        pub fn set_include_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Retrieves information about a dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl DescribeDataset {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset whose information is retrieved.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset whose information is retrieved.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDatastore`.
    ///
    /// <p>Retrieves information about a data store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDatastore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_datastore_input::Builder,
    }
    impl DescribeDatastore {
        /// Creates a new `DescribeDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatastoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(input.into());
            self
        }
        /// <p>The name of the data store</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>If true, additional statistical information about the data store is included in the response. This feature can't be used with a data store whose S3 storage is customer-managed.</p>
        pub fn include_statistics(mut self, input: bool) -> Self {
            self.inner = self.inner.include_statistics(input);
            self
        }
        /// <p>If true, additional statistical information about the data store is included in the response. This feature can't be used with a data store whose S3 storage is customer-managed.</p>
        pub fn set_include_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingOptions`.
    ///
    /// <p>Retrieves the current settings of the IoT Analytics logging options.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoggingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_logging_options_input::Builder,
    }
    impl DescribeLoggingOptions {
        /// Creates a new `DescribeLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribePipeline`.
    ///
    /// <p>Retrieves information about a pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_pipeline_input::Builder,
    }
    impl DescribePipeline {
        /// Creates a new `DescribePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline whose information is retrieved.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline whose information is retrieved.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDatasetContent`.
    ///
    /// <p>Retrieves the contents of a dataset as presigned URIs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDatasetContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_dataset_content_input::Builder,
    }
    impl GetDatasetContent {
        /// Creates a new `GetDatasetContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDatasetContentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDatasetContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset whose contents are retrieved.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset whose contents are retrieved.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The version of the dataset whose contents are retrieved. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of the latest or latest successfully completed dataset. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The version of the dataset whose contents are retrieved. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of the latest or latest successfully completed dataset. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Retrieves a list of channels.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListChannels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl ListChannels {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListChannelsPaginator {
            crate::paginator::ListChannelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetContents`.
    ///
    /// <p>Lists information about dataset contents that have been created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatasetContents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dataset_contents_input::Builder,
    }
    impl ListDatasetContents {
        /// Creates a new `ListDatasetContents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetContentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetContentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatasetContentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatasetContentsPaginator {
            crate::paginator::ListDatasetContentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the dataset whose contents information you want to list.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset whose contents information you want to list.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled on or after the given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code> request. (timestamp)</p>
        pub fn scheduled_on_or_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.scheduled_on_or_after(input);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled on or after the given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code> request. (timestamp)</p>
        pub fn set_scheduled_on_or_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_on_or_after(input);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled before the given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code> request. (timestamp)</p>
        pub fn scheduled_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.scheduled_before(input);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled before the given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code> request. (timestamp)</p>
        pub fn set_scheduled_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_before(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Retrieves information about datasets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatasets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl ListDatasets {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatasetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatasetsPaginator {
            crate::paginator::ListDatasetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatastores`.
    ///
    /// <p>Retrieves a list of data stores.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatastores {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_datastores_input::Builder,
    }
    impl ListDatastores {
        /// Creates a new `ListDatastores`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatastoresOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatastoresError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatastoresPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatastoresPaginator {
            crate::paginator::ListDatastoresPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPipelines`.
    ///
    /// <p>Retrieves a list of pipelines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPipelines {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pipelines_input::Builder,
    }
    impl ListPipelines {
        /// Creates a new `ListPipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPipelinesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPipelinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPipelinesPaginator {
            crate::paginator::ListPipelinesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags (metadata) that you have assigned to the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags you want to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingOptions`.
    ///
    /// <p>Sets or updates the IoT Analytics logging options.</p>
    /// <p>If you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to take effect. Also, if you change the policy attached to the role you specified in the <code>roleArn</code> field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLoggingOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_logging_options_input::Builder,
    }
    impl PutLoggingOptions {
        /// Creates a new `PutLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The new values of the IoT Analytics logging options.</p>
        pub fn logging_options(mut self, input: crate::model::LoggingOptions) -> Self {
            self.inner = self.inner.logging_options(input);
            self
        }
        /// <p>The new values of the IoT Analytics logging options.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.inner = self.inner.set_logging_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RunPipelineActivity`.
    ///
    /// <p>Simulates the results of running a pipeline activity on a message payload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RunPipelineActivity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::run_pipeline_activity_input::Builder,
    }
    impl RunPipelineActivity {
        /// Creates a new `RunPipelineActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RunPipelineActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::RunPipelineActivityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pipeline activity that is run. This must not be a channel activity or a data store activity because these activities are used in a pipeline only to load the original message and to store the (possibly) transformed message. If a Lambda activity is specified, only short-running Lambda functions (those with a timeout of less than 30 seconds or less) can be used.</p>
        pub fn pipeline_activity(mut self, input: crate::model::PipelineActivity) -> Self {
            self.inner = self.inner.pipeline_activity(input);
            self
        }
        /// <p>The pipeline activity that is run. This must not be a channel activity or a data store activity because these activities are used in a pipeline only to load the original message and to store the (possibly) transformed message. If a Lambda activity is specified, only short-running Lambda functions (those with a timeout of less than 30 seconds or less) can be used.</p>
        pub fn set_pipeline_activity(
            mut self,
            input: std::option::Option<crate::model::PipelineActivity>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_activity(input);
            self
        }
        /// Appends an item to `payloads`.
        ///
        /// To override the contents of this collection use [`set_payloads`](Self::set_payloads).
        ///
        /// <p>The sample message payloads on which the pipeline activity is run.</p>
        pub fn payloads(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.payloads(input);
            self
        }
        /// <p>The sample message payloads on which the pipeline activity is run.</p>
        pub fn set_payloads(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.inner = self.inner.set_payloads(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SampleChannelData`.
    ///
    /// <p>Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10 messages can be retrieved.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SampleChannelData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::sample_channel_data_input::Builder,
    }
    impl SampleChannelData {
        /// Creates a new `SampleChannelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SampleChannelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::SampleChannelDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel whose message samples are retrieved.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>The name of the channel whose message samples are retrieved.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>The number of sample messages to be retrieved. The limit is 10. The default is also 10.</p>
        pub fn max_messages(mut self, input: i32) -> Self {
            self.inner = self.inner.max_messages(input);
            self
        }
        /// <p>The number of sample messages to be retrieved. The limit is 10. The default is also 10.</p>
        pub fn set_max_messages(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_messages(input);
            self
        }
        /// <p>The start of the time window from which sample messages are retrieved.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time window from which sample messages are retrieved.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time window from which sample messages are retrieved.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time window from which sample messages are retrieved.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPipelineReprocessing`.
    ///
    /// <p>Starts the reprocessing of raw message data through the pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartPipelineReprocessing {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_pipeline_reprocessing_input::Builder,
    }
    impl StartPipelineReprocessing {
        /// Creates a new `StartPipelineReprocessing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPipelineReprocessingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPipelineReprocessingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline on which to start reprocessing.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline on which to start reprocessing.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The start time (inclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>startTime</code> parameter, you must not use the <code>channelMessages</code> object.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time (inclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>startTime</code> parameter, you must not use the <code>channelMessages</code> object.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time (exclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>endTime</code> parameter, you must not use the <code>channelMessages</code> object.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end time (exclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>endTime</code> parameter, you must not use the <code>channelMessages</code> object.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Specifies one or more sets of channel messages that you want to reprocess.</p>
        /// <p>If you use the <code>channelMessages</code> object, you must not specify a value for <code>startTime</code> and <code>endTime</code>.</p>
        pub fn channel_messages(mut self, input: crate::model::ChannelMessages) -> Self {
            self.inner = self.inner.channel_messages(input);
            self
        }
        /// <p>Specifies one or more sets of channel messages that you want to reprocess.</p>
        /// <p>If you use the <code>channelMessages</code> object, you must not specify a value for <code>startTime</code> and <code>endTime</code>.</p>
        pub fn set_channel_messages(
            mut self,
            input: std::option::Option<crate::model::ChannelMessages>,
        ) -> Self {
            self.inner = self.inner.set_channel_messages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags you want to modify.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource whose tags you want to modify.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The new or modified tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the given tags (metadata) from the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags you want to remove.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource whose tags you want to remove.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of those tags which you want to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of those tags which you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// <p>Used to update the settings of a channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateChannel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl UpdateChannel {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel to be updated.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(input.into());
            self
        }
        /// <p>The name of the channel to be updated.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
        pub fn channel_storage(mut self, input: crate::model::ChannelStorage) -> Self {
            self.inner = self.inner.channel_storage(input);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't change this storage option after the channel is created.</p>
        pub fn set_channel_storage(
            mut self,
            input: std::option::Option<crate::model::ChannelStorage>,
        ) -> Self {
            self.inner = self.inner.set_channel_storage(input);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. The retention period can't be updated if the channel's Amazon S3 storage is customer-managed.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. The retention period can't be updated if the channel's Amazon S3 storage is customer-managed.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataset`.
    ///
    /// <p>Updates the settings of a dataset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_dataset_input::Builder,
    }
    impl UpdateDataset {
        /// Creates a new `UpdateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to update.</p>
        pub fn dataset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(input.into());
            self
        }
        /// <p>The name of the dataset to update.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>A list of <code>DatasetAction</code> objects.</p>
        pub fn actions(mut self, input: crate::model::DatasetAction) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>A list of <code>DatasetAction</code> objects.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetAction>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five <code>DatasetTrigger</code> objects.</p>
        pub fn triggers(mut self, input: crate::model::DatasetTrigger) -> Self {
            self.inner = self.inner.triggers(input);
            self
        }
        /// <p>A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five <code>DatasetTrigger</code> objects.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
        /// Appends an item to `contentDeliveryRules`.
        ///
        /// To override the contents of this collection use [`set_content_delivery_rules`](Self::set_content_delivery_rules).
        ///
        /// <p>When dataset contents are created, they are delivered to destinations specified here.</p>
        pub fn content_delivery_rules(
            mut self,
            input: crate::model::DatasetContentDeliveryRule,
        ) -> Self {
            self.inner = self.inner.content_delivery_rules(input);
            self
        }
        /// <p>When dataset contents are created, they are delivered to destinations specified here.</p>
        pub fn set_content_delivery_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetContentDeliveryRule>>,
        ) -> Self {
            self.inner = self.inner.set_content_delivery_rules(input);
            self
        }
        /// <p>How long, in days, dataset contents are kept for the dataset.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>How long, in days, dataset contents are kept for the dataset.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn versioning_configuration(
            mut self,
            input: crate::model::VersioningConfiguration,
        ) -> Self {
            self.inner = self.inner.versioning_configuration(input);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the <code>retentionPeriod</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.</p>
        pub fn set_versioning_configuration(
            mut self,
            input: std::option::Option<crate::model::VersioningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_versioning_configuration(input);
            self
        }
        /// Appends an item to `lateDataRules`.
        ///
        /// To override the contents of this collection use [`set_late_data_rules`](Self::set_late_data_rules).
        ///
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn late_data_rules(mut self, input: crate::model::LateDataRule) -> Self {
            self.inner = self.inner.late_data_rules(input);
            self
        }
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn set_late_data_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LateDataRule>>,
        ) -> Self {
            self.inner = self.inner.set_late_data_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatastore`.
    ///
    /// <p>Used to update the settings of a data store.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDatastore {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_datastore_input::Builder,
    }
    impl UpdateDatastore {
        /// Creates a new `UpdateDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatastoreError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store to be updated.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(input.into());
            self
        }
        /// <p>The name of the data store to be updated.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. The retention period can't be updated if the data store's Amazon S3 storage is customer-managed.</p>
        pub fn retention_period(mut self, input: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. The retention period can't be updated if the data store's Amazon S3 storage is customer-managed.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn datastore_storage(mut self, input: crate::model::DatastoreStorage) -> Self {
            self.inner = self.inner.datastore_storage(input);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn set_datastore_storage(
            mut self,
            input: std::option::Option<crate::model::DatastoreStorage>,
        ) -> Self {
            self.inner = self.inner.set_datastore_storage(input);
            self
        }
        /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn file_format_configuration(
            mut self,
            input: crate::model::FileFormatConfiguration,
        ) -> Self {
            self.inner = self.inner.file_format_configuration(input);
            self
        }
        /// <p>Contains the configuration information of file formats. IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn set_file_format_configuration(
            mut self,
            input: std::option::Option<crate::model::FileFormatConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_file_format_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePipeline`.
    ///
    /// <p>Updates the settings of a pipeline. You must specify both a <code>channel</code> and a <code>datastore</code> activity and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pipeline_input::Builder,
    }
    impl UpdatePipeline {
        /// Creates a new `UpdatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to update.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline to update.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// Appends an item to `pipelineActivities`.
        ///
        /// To override the contents of this collection use [`set_pipeline_activities`](Self::set_pipeline_activities).
        ///
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:</p>
        /// <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>
        pub fn pipeline_activities(mut self, input: crate::model::PipelineActivity) -> Self {
            self.inner = self.inner.pipeline_activities(input);
            self
        }
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:</p>
        /// <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>
        pub fn set_pipeline_activities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineActivity>>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_activities(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
