// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchPutMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchPutMessageError {
    /// Kind of error that occurred.
    pub kind: BatchPutMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchPutMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchPutMessageErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchPutMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchPutMessageErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchPutMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchPutMessageError {
    fn code(&self) -> Option<&str> {
        BatchPutMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchPutMessageError {
    /// Creates a new `BatchPutMessageError`.
    pub fn new(kind: BatchPutMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchPutMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchPutMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchPutMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchPutMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutMessageErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutMessageErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutMessageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchPutMessageErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchPutMessageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, BatchPutMessageErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for BatchPutMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchPutMessageErrorKind::InternalFailureException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchPutMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelPipelineReprocessing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelPipelineReprocessingError {
    /// Kind of error that occurred.
    pub kind: CancelPipelineReprocessingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelPipelineReprocessing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelPipelineReprocessingErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelPipelineReprocessingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelPipelineReprocessingErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CancelPipelineReprocessingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CancelPipelineReprocessingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelPipelineReprocessingErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CancelPipelineReprocessingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelPipelineReprocessingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelPipelineReprocessingError {
    fn code(&self) -> Option<&str> {
        CancelPipelineReprocessingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelPipelineReprocessingError {
    /// Creates a new `CancelPipelineReprocessingError`.
    pub fn new(kind: CancelPipelineReprocessingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelPipelineReprocessingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelPipelineReprocessingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelPipelineReprocessingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelPipelineReprocessingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelPipelineReprocessingErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelPipelineReprocessingErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelPipelineReprocessingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelPipelineReprocessingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelPipelineReprocessingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelPipelineReprocessingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelPipelineReprocessingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelPipelineReprocessingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelPipelineReprocessingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelPipelineReprocessingErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CancelPipelineReprocessingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelPipelineReprocessingErrorKind::InternalFailureException(_inner) => Some(_inner),
            CancelPipelineReprocessingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CancelPipelineReprocessingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelPipelineReprocessingErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CancelPipelineReprocessingErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelPipelineReprocessingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateChannelError {
    /// Kind of error that occurred.
    pub kind: CreateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateChannelErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the same name already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateChannelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateChannelError {
    fn code(&self) -> Option<&str> {
        CreateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateChannelError {
    /// Creates a new `CreateChannelError`.
    pub fn new(kind: CreateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateChannelErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateChannelErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateChannelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateChannelErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateChannelErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the same name already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetError {
    fn code(&self) -> Option<&str> {
        CreateDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetError {
    /// Creates a new `CreateDatasetError`.
    pub fn new(kind: CreateDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDatasetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDatasetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatasetContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetContentError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatasetContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetContentErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetContentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDatasetContentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDatasetContentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetContentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateDatasetContentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDatasetContentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetContentError {
    fn code(&self) -> Option<&str> {
        CreateDatasetContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetContentError {
    /// Creates a new `CreateDatasetContentError`.
    pub fn new(kind: CreateDatasetContentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatasetContentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetContentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetContentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetContentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetContentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetContentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetContentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetContentErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatasetContentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetContentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateDatasetContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetContentErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDatasetContentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDatasetContentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetContentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateDatasetContentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDatasetContentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatastoreError {
    /// Kind of error that occurred.
    pub kind: CreateDatastoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatastoreErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the same name already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatastoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatastoreErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDatastoreErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDatastoreErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDatastoreErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDatastoreErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateDatastoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDatastoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatastoreError {
    fn code(&self) -> Option<&str> {
        CreateDatastoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatastoreError {
    /// Creates a new `CreateDatastoreError`.
    pub fn new(kind: CreateDatastoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatastoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatastoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatastoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatastoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatastoreErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatastoreErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatastoreErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatastoreErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatastoreErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatastoreErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatastoreErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatastoreErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatastoreErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatastoreErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatastoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDatastoreErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateDatastoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatastoreErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDatastoreErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDatastoreErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDatastoreErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDatastoreErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateDatastoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDatastoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePipelineError {
    /// Kind of error that occurred.
    pub kind: CreatePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePipelineErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the same name already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePipelineErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePipelineError {
    fn code(&self) -> Option<&str> {
        CreatePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePipelineError {
    /// Creates a new `CreatePipelineError`.
    pub fn new(kind: CreatePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePipelineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePipelineErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePipelineErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreatePipelineErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreatePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePipelineErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreatePipelineErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreatePipelineErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePipelineErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreatePipelineErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreatePipelineErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteChannelErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteChannelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteChannelError {
    fn code(&self) -> Option<&str> {
        DeleteChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteChannelError {
    /// Creates a new `DeleteChannelError`.
    pub fn new(kind: DeleteChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteChannelErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteChannelErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteChannelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetError {
    /// Creates a new `DeleteDatasetError`.
    pub fn new(kind: DeleteDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDatasetContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetContentError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDatasetContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetContentErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetContentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDatasetContentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDatasetContentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetContentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteDatasetContentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDatasetContentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetContentError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetContentError {
    /// Creates a new `DeleteDatasetContentError`.
    pub fn new(kind: DeleteDatasetContentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatasetContentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetContentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetContentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetContentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetContentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetContentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetContentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetContentErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatasetContentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetContentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteDatasetContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetContentErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDatasetContentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDatasetContentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetContentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteDatasetContentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDatasetContentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatastoreError {
    /// Kind of error that occurred.
    pub kind: DeleteDatastoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatastoreErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatastoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatastoreErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDatastoreErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDatastoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatastoreErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteDatastoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDatastoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatastoreError {
    fn code(&self) -> Option<&str> {
        DeleteDatastoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatastoreError {
    /// Creates a new `DeleteDatastoreError`.
    pub fn new(kind: DeleteDatastoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatastoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatastoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatastoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatastoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatastoreErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatastoreErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatastoreErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatastoreErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatastoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatastoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatastoreErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatastoreErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatastoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatastoreErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteDatastoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatastoreErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDatastoreErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDatastoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatastoreErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteDatastoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDatastoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePipelineError {
    /// Kind of error that occurred.
    pub kind: DeletePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePipelineErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePipelineErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePipelineError {
    fn code(&self) -> Option<&str> {
        DeletePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePipelineError {
    /// Creates a new `DeletePipelineError`.
    pub fn new(kind: DeletePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePipelineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePipelineErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePipelineErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeletePipelineErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeletePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePipelineErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeletePipelineErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeletePipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePipelineErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeletePipelineErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeChannelError {
    /// Kind of error that occurred.
    pub kind: DescribeChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeChannelErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeChannelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeChannelError {
    fn code(&self) -> Option<&str> {
        DescribeChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeChannelError {
    /// Creates a new `DescribeChannelError`.
    pub fn new(kind: DescribeChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeChannelErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeChannelErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeChannelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetError {
    /// Creates a new `DescribeDatasetError`.
    pub fn new(kind: DescribeDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeDatasetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatastoreError {
    /// Kind of error that occurred.
    pub kind: DescribeDatastoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatastoreErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatastoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatastoreErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDatastoreErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDatastoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatastoreErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeDatastoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDatastoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatastoreError {
    fn code(&self) -> Option<&str> {
        DescribeDatastoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatastoreError {
    /// Creates a new `DescribeDatastoreError`.
    pub fn new(kind: DescribeDatastoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatastoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatastoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatastoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatastoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDatastoreErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatastoreErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatastoreErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatastoreErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatastoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatastoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatastoreErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatastoreErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDatastoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatastoreErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDatastoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatastoreErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDatastoreErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDatastoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatastoreErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeDatastoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDatastoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoggingOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeLoggingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoggingOptionsErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoggingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoggingOptionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeLoggingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoggingOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeLoggingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoggingOptionsError {
    /// Creates a new `DescribeLoggingOptionsError`.
    pub fn new(kind: DescribeLoggingOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoggingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoggingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoggingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoggingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoggingOptionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoggingOptionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoggingOptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoggingOptionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLoggingOptionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingOptionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeLoggingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoggingOptionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeLoggingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePipelineError {
    /// Kind of error that occurred.
    pub kind: DescribePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePipelineErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePipelineErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribePipelineErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribePipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePipelineErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribePipelineErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePipelineError {
    fn code(&self) -> Option<&str> {
        DescribePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePipelineError {
    /// Creates a new `DescribePipelineError`.
    pub fn new(kind: DescribePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePipelineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePipelineErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePipelineErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePipelineErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePipelineErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePipelineErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePipelineErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePipelineErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePipelineErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePipelineErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribePipelineErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribePipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePipelineErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribePipelineErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDatasetContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDatasetContentError {
    /// Kind of error that occurred.
    pub kind: GetDatasetContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDatasetContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDatasetContentErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDatasetContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDatasetContentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetDatasetContentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetDatasetContentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDatasetContentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetDatasetContentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDatasetContentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDatasetContentError {
    fn code(&self) -> Option<&str> {
        GetDatasetContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDatasetContentError {
    /// Creates a new `GetDatasetContentError`.
    pub fn new(kind: GetDatasetContentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDatasetContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDatasetContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDatasetContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDatasetContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDatasetContentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatasetContentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatasetContentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatasetContentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatasetContentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatasetContentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatasetContentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatasetContentErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatasetContentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatasetContentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetDatasetContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDatasetContentErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetDatasetContentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetDatasetContentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDatasetContentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetDatasetContentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDatasetContentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChannelsError {
    /// Kind of error that occurred.
    pub kind: ListChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChannelsErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChannelsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChannelsError {
    fn code(&self) -> Option<&str> {
        ListChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChannelsError {
    /// Creates a new `ListChannelsError`.
    pub fn new(kind: ListChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChannelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChannelsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChannelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListChannelsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChannelsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListChannelsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListChannelsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListChannelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasetContents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetContentsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetContentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasetContents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetContentsErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetContentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetContentsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDatasetContentsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDatasetContentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDatasetContentsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListDatasetContentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDatasetContentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetContentsError {
    fn code(&self) -> Option<&str> {
        ListDatasetContentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetContentsError {
    /// Creates a new `ListDatasetContentsError`.
    pub fn new(kind: ListDatasetContentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetContentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetContentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetContentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetContentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetContentsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetContentsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetContentsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetContentsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetContentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetContentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetContentsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetContentsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetContentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetContentsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListDatasetContentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetContentsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDatasetContentsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDatasetContentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDatasetContentsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListDatasetContentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDatasetContentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetsError {
    /// Kind of error that occurred.
    pub kind: ListDatasetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetsErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDatasetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetsError {
    fn code(&self) -> Option<&str> {
        ListDatasetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetsError {
    /// Creates a new `ListDatasetsError`.
    pub fn new(kind: ListDatasetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatasetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDatasetsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDatasetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDatasetsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDatasetsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListDatasetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDatasetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatastores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatastoresError {
    /// Kind of error that occurred.
    pub kind: ListDatastoresErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatastores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatastoresErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatastoresError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatastoresErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDatastoresErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDatastoresErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListDatastoresErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDatastoresErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatastoresError {
    fn code(&self) -> Option<&str> {
        ListDatastoresError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatastoresError {
    /// Creates a new `ListDatastoresError`.
    pub fn new(kind: ListDatastoresErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatastoresError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatastoresErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatastoresError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatastoresErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatastoresErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatastoresErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatastoresErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatastoresErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatastoresErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatastoresErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatastoresErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDatastoresErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDatastoresError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatastoresErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDatastoresErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDatastoresErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListDatastoresErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDatastoresErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPipelinesError {
    /// Kind of error that occurred.
    pub kind: ListPipelinesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPipelines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPipelinesErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPipelinesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPipelinesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPipelinesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPipelinesError {
    fn code(&self) -> Option<&str> {
        ListPipelinesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPipelinesError {
    /// Creates a new `ListPipelinesError`.
    pub fn new(kind: ListPipelinesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPipelinesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPipelinesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPipelinesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPipelinesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelinesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelinesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPipelinesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPipelinesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListPipelinesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListPipelinesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPipelinesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListPipelinesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPipelinesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPipelinesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPipelinesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLoggingOptionsError {
    /// Kind of error that occurred.
    pub kind: PutLoggingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLoggingOptionsErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLoggingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLoggingOptionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutLoggingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLoggingOptionsError {
    fn code(&self) -> Option<&str> {
        PutLoggingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLoggingOptionsError {
    /// Creates a new `PutLoggingOptionsError`.
    pub fn new(kind: PutLoggingOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLoggingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLoggingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLoggingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLoggingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutLoggingOptionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingOptionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingOptionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingOptionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingOptionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for PutLoggingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLoggingOptionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutLoggingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RunPipelineActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RunPipelineActivityError {
    /// Kind of error that occurred.
    pub kind: RunPipelineActivityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RunPipelineActivity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RunPipelineActivityErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RunPipelineActivityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RunPipelineActivityErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            RunPipelineActivityErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RunPipelineActivityErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RunPipelineActivityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RunPipelineActivityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RunPipelineActivityError {
    fn code(&self) -> Option<&str> {
        RunPipelineActivityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RunPipelineActivityError {
    /// Creates a new `RunPipelineActivityError`.
    pub fn new(kind: RunPipelineActivityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RunPipelineActivityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RunPipelineActivityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RunPipelineActivityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RunPipelineActivityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RunPipelineActivityErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RunPipelineActivityErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `RunPipelineActivityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RunPipelineActivityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RunPipelineActivityErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RunPipelineActivityErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RunPipelineActivityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RunPipelineActivityErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for RunPipelineActivityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RunPipelineActivityErrorKind::InternalFailureException(_inner) => Some(_inner),
            RunPipelineActivityErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RunPipelineActivityErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RunPipelineActivityErrorKind::ThrottlingException(_inner) => Some(_inner),
            RunPipelineActivityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SampleChannelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SampleChannelDataError {
    /// Kind of error that occurred.
    pub kind: SampleChannelDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SampleChannelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SampleChannelDataErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SampleChannelDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SampleChannelDataErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            SampleChannelDataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            SampleChannelDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SampleChannelDataErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            SampleChannelDataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SampleChannelDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SampleChannelDataError {
    fn code(&self) -> Option<&str> {
        SampleChannelDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SampleChannelDataError {
    /// Creates a new `SampleChannelDataError`.
    pub fn new(kind: SampleChannelDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SampleChannelDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SampleChannelDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SampleChannelDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SampleChannelDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SampleChannelDataErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SampleChannelDataErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `SampleChannelDataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SampleChannelDataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SampleChannelDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SampleChannelDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SampleChannelDataErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SampleChannelDataErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `SampleChannelDataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SampleChannelDataErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for SampleChannelDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SampleChannelDataErrorKind::InternalFailureException(_inner) => Some(_inner),
            SampleChannelDataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            SampleChannelDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SampleChannelDataErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            SampleChannelDataErrorKind::ThrottlingException(_inner) => Some(_inner),
            SampleChannelDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartPipelineReprocessing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartPipelineReprocessingError {
    /// Kind of error that occurred.
    pub kind: StartPipelineReprocessingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartPipelineReprocessing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartPipelineReprocessingErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the same name already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartPipelineReprocessingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartPipelineReprocessingErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            StartPipelineReprocessingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartPipelineReprocessingErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            StartPipelineReprocessingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartPipelineReprocessingErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            StartPipelineReprocessingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartPipelineReprocessingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartPipelineReprocessingError {
    fn code(&self) -> Option<&str> {
        StartPipelineReprocessingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartPipelineReprocessingError {
    /// Creates a new `StartPipelineReprocessingError`.
    pub fn new(kind: StartPipelineReprocessingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartPipelineReprocessingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartPipelineReprocessingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartPipelineReprocessingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartPipelineReprocessingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartPipelineReprocessingErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineReprocessingErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPipelineReprocessingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineReprocessingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPipelineReprocessingErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineReprocessingErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPipelineReprocessingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineReprocessingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPipelineReprocessingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineReprocessingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartPipelineReprocessingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartPipelineReprocessingErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for StartPipelineReprocessingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartPipelineReprocessingErrorKind::InternalFailureException(_inner) => Some(_inner),
            StartPipelineReprocessingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartPipelineReprocessingErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            StartPipelineReprocessingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartPipelineReprocessingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartPipelineReprocessingErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartPipelineReprocessingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateChannelErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateChannelErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateChannelError {
    fn code(&self) -> Option<&str> {
        UpdateChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateChannelError {
    /// Creates a new `UpdateChannelError`.
    pub fn new(kind: UpdateChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateChannelErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateChannelErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateChannelErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateChannelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDatasetError {
    /// Kind of error that occurred.
    pub kind: UpdateDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDatasetErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDatasetErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDatasetError {
    fn code(&self) -> Option<&str> {
        UpdateDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDatasetError {
    /// Creates a new `UpdateDatasetError`.
    pub fn new(kind: UpdateDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDatasetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDatasetErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDatasetErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDatastoreError {
    /// Kind of error that occurred.
    pub kind: UpdateDatastoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDatastoreErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDatastoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDatastoreErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDatastoreErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateDatastoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDatastoreErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateDatastoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDatastoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDatastoreError {
    fn code(&self) -> Option<&str> {
        UpdateDatastoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDatastoreError {
    /// Creates a new `UpdateDatastoreError`.
    pub fn new(kind: UpdateDatastoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDatastoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDatastoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDatastoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDatastoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDatastoreErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatastoreErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatastoreErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatastoreErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatastoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatastoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatastoreErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatastoreErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatastoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDatastoreErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateDatastoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDatastoreErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDatastoreErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateDatastoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDatastoreErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateDatastoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDatastoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePipelineError {
    /// Kind of error that occurred.
    pub kind: UpdatePipelineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePipeline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePipelineErrorKind {
    /// <p>There was an internal failure.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request was not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The command caused an internal limit to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource with the specified name could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePipelineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePipelineErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePipelineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePipelineError {
    fn code(&self) -> Option<&str> {
        UpdatePipelineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePipelineError {
    /// Creates a new `UpdatePipelineError`.
    pub fn new(kind: UpdatePipelineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePipelineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePipelineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePipelineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePipelineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePipelineErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePipelineErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdatePipelineErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdatePipelineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePipelineErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePipelineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The service is temporarily unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>A resource with the specified name could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The command caused an internal limit to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request was not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>There was an internal failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p>A resource with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ResourceAlreadyExistsException {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ARN of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
                resource_id: self.resource_id,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
