// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchPutMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_put_message`](crate::client::Client::batch_put_message).
///
/// See [`crate::client::fluent_builders::BatchPutMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchPutMessage {
    _private: (),
}
impl BatchPutMessage {
    /// Creates a new builder-style object to manufacture [`BatchPutMessageInput`](crate::input::BatchPutMessageInput)
    pub fn builder() -> crate::input::batch_put_message_input::Builder {
        crate::input::batch_put_message_input::Builder::default()
    }
    /// Creates a new `BatchPutMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchPutMessage {
    type Output = std::result::Result<
        crate::output::BatchPutMessageOutput,
        crate::error::BatchPutMessageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_put_message_error(response)
        } else {
            crate::operation_deser::parse_batch_put_message_response(response)
        }
    }
}

/// Operation shape for `CancelPipelineReprocessing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_pipeline_reprocessing`](crate::client::Client::cancel_pipeline_reprocessing).
///
/// See [`crate::client::fluent_builders::CancelPipelineReprocessing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelPipelineReprocessing {
    _private: (),
}
impl CancelPipelineReprocessing {
    /// Creates a new builder-style object to manufacture [`CancelPipelineReprocessingInput`](crate::input::CancelPipelineReprocessingInput)
    pub fn builder() -> crate::input::cancel_pipeline_reprocessing_input::Builder {
        crate::input::cancel_pipeline_reprocessing_input::Builder::default()
    }
    /// Creates a new `CancelPipelineReprocessing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelPipelineReprocessing {
    type Output = std::result::Result<
        crate::output::CancelPipelineReprocessingOutput,
        crate::error::CancelPipelineReprocessingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_pipeline_reprocessing_error(response)
        } else {
            crate::operation_deser::parse_cancel_pipeline_reprocessing_response(response)
        }
    }
}

/// Operation shape for `CreateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel`](crate::client::Client::create_channel).
///
/// See [`crate::client::fluent_builders::CreateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannel {
    _private: (),
}
impl CreateChannel {
    /// Creates a new builder-style object to manufacture [`CreateChannelInput`](crate::input::CreateChannelInput)
    pub fn builder() -> crate::input::create_channel_input::Builder {
        crate::input::create_channel_input::Builder::default()
    }
    /// Creates a new `CreateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannel {
    type Output =
        std::result::Result<crate::output::CreateChannelOutput, crate::error::CreateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_error(response)
        } else {
            crate::operation_deser::parse_create_channel_response(response)
        }
    }
}

/// Operation shape for `CreateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset`](crate::client::Client::create_dataset).
///
/// See [`crate::client::fluent_builders::CreateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataset {
    _private: (),
}
impl CreateDataset {
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
    /// Creates a new `CreateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataset {
    type Output =
        std::result::Result<crate::output::CreateDatasetOutput, crate::error::CreateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_dataset_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_response(response)
        }
    }
}

/// Operation shape for `CreateDatasetContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset_content`](crate::client::Client::create_dataset_content).
///
/// See [`crate::client::fluent_builders::CreateDatasetContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatasetContent {
    _private: (),
}
impl CreateDatasetContent {
    /// Creates a new builder-style object to manufacture [`CreateDatasetContentInput`](crate::input::CreateDatasetContentInput)
    pub fn builder() -> crate::input::create_dataset_content_input::Builder {
        crate::input::create_dataset_content_input::Builder::default()
    }
    /// Creates a new `CreateDatasetContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatasetContent {
    type Output = std::result::Result<
        crate::output::CreateDatasetContentOutput,
        crate::error::CreateDatasetContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_content_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_content_response(response)
        }
    }
}

/// Operation shape for `CreateDatastore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_datastore`](crate::client::Client::create_datastore).
///
/// See [`crate::client::fluent_builders::CreateDatastore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatastore {
    _private: (),
}
impl CreateDatastore {
    /// Creates a new builder-style object to manufacture [`CreateDatastoreInput`](crate::input::CreateDatastoreInput)
    pub fn builder() -> crate::input::create_datastore_input::Builder {
        crate::input::create_datastore_input::Builder::default()
    }
    /// Creates a new `CreateDatastore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatastore {
    type Output = std::result::Result<
        crate::output::CreateDatastoreOutput,
        crate::error::CreateDatastoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_datastore_error(response)
        } else {
            crate::operation_deser::parse_create_datastore_response(response)
        }
    }
}

/// Operation shape for `CreatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pipeline`](crate::client::Client::create_pipeline).
///
/// See [`crate::client::fluent_builders::CreatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePipeline {
    _private: (),
}
impl CreatePipeline {
    /// Creates a new builder-style object to manufacture [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    pub fn builder() -> crate::input::create_pipeline_input::Builder {
        crate::input::create_pipeline_input::Builder::default()
    }
    /// Creates a new `CreatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePipeline {
    type Output =
        std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_pipeline_error(response)
        } else {
            crate::operation_deser::parse_create_pipeline_response(response)
        }
    }
}

/// Operation shape for `DeleteChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel`](crate::client::Client::delete_channel).
///
/// See [`crate::client::fluent_builders::DeleteChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannel {
    _private: (),
}
impl DeleteChannel {
    /// Creates a new builder-style object to manufacture [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    pub fn builder() -> crate::input::delete_channel_input::Builder {
        crate::input::delete_channel_input::Builder::default()
    }
    /// Creates a new `DeleteChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannel {
    type Output =
        std::result::Result<crate::output::DeleteChannelOutput, crate::error::DeleteChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset`](crate::client::Client::delete_dataset).
///
/// See [`crate::client::fluent_builders::DeleteDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataset {
    _private: (),
}
impl DeleteDataset {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
    /// Creates a new `DeleteDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataset {
    type Output =
        std::result::Result<crate::output::DeleteDatasetOutput, crate::error::DeleteDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_dataset_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_response(response)
        }
    }
}

/// Operation shape for `DeleteDatasetContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset_content`](crate::client::Client::delete_dataset_content).
///
/// See [`crate::client::fluent_builders::DeleteDatasetContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDatasetContent {
    _private: (),
}
impl DeleteDatasetContent {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetContentInput`](crate::input::DeleteDatasetContentInput)
    pub fn builder() -> crate::input::delete_dataset_content_input::Builder {
        crate::input::delete_dataset_content_input::Builder::default()
    }
    /// Creates a new `DeleteDatasetContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDatasetContent {
    type Output = std::result::Result<
        crate::output::DeleteDatasetContentOutput,
        crate::error::DeleteDatasetContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_dataset_content_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_content_response(response)
        }
    }
}

/// Operation shape for `DeleteDatastore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_datastore`](crate::client::Client::delete_datastore).
///
/// See [`crate::client::fluent_builders::DeleteDatastore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDatastore {
    _private: (),
}
impl DeleteDatastore {
    /// Creates a new builder-style object to manufacture [`DeleteDatastoreInput`](crate::input::DeleteDatastoreInput)
    pub fn builder() -> crate::input::delete_datastore_input::Builder {
        crate::input::delete_datastore_input::Builder::default()
    }
    /// Creates a new `DeleteDatastore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDatastore {
    type Output = std::result::Result<
        crate::output::DeleteDatastoreOutput,
        crate::error::DeleteDatastoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_datastore_error(response)
        } else {
            crate::operation_deser::parse_delete_datastore_response(response)
        }
    }
}

/// Operation shape for `DeletePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pipeline`](crate::client::Client::delete_pipeline).
///
/// See [`crate::client::fluent_builders::DeletePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePipeline {
    _private: (),
}
impl DeletePipeline {
    /// Creates a new builder-style object to manufacture [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    pub fn builder() -> crate::input::delete_pipeline_input::Builder {
        crate::input::delete_pipeline_input::Builder::default()
    }
    /// Creates a new `DeletePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePipeline {
    type Output =
        std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_pipeline_error(response)
        } else {
            crate::operation_deser::parse_delete_pipeline_response(response)
        }
    }
}

/// Operation shape for `DescribeChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel`](crate::client::Client::describe_channel).
///
/// See [`crate::client::fluent_builders::DescribeChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannel {
    _private: (),
}
impl DescribeChannel {
    /// Creates a new builder-style object to manufacture [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    pub fn builder() -> crate::input::describe_channel_input::Builder {
        crate::input::describe_channel_input::Builder::default()
    }
    /// Creates a new `DescribeChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannel {
    type Output = std::result::Result<
        crate::output::DescribeChannelOutput,
        crate::error::DescribeChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_response(response)
        }
    }
}

/// Operation shape for `DescribeDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset`](crate::client::Client::describe_dataset).
///
/// See [`crate::client::fluent_builders::DescribeDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataset {
    _private: (),
}
impl DescribeDataset {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
    /// Creates a new `DescribeDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataset {
    type Output = std::result::Result<
        crate::output::DescribeDatasetOutput,
        crate::error::DescribeDatasetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_response(response)
        }
    }
}

/// Operation shape for `DescribeDatastore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_datastore`](crate::client::Client::describe_datastore).
///
/// See [`crate::client::fluent_builders::DescribeDatastore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDatastore {
    _private: (),
}
impl DescribeDatastore {
    /// Creates a new builder-style object to manufacture [`DescribeDatastoreInput`](crate::input::DescribeDatastoreInput)
    pub fn builder() -> crate::input::describe_datastore_input::Builder {
        crate::input::describe_datastore_input::Builder::default()
    }
    /// Creates a new `DescribeDatastore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDatastore {
    type Output = std::result::Result<
        crate::output::DescribeDatastoreOutput,
        crate::error::DescribeDatastoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_datastore_error(response)
        } else {
            crate::operation_deser::parse_describe_datastore_response(response)
        }
    }
}

/// Operation shape for `DescribeLoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_logging_options`](crate::client::Client::describe_logging_options).
///
/// See [`crate::client::fluent_builders::DescribeLoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoggingOptions {
    _private: (),
}
impl DescribeLoggingOptions {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingOptionsInput`](crate::input::DescribeLoggingOptionsInput)
    pub fn builder() -> crate::input::describe_logging_options_input::Builder {
        crate::input::describe_logging_options_input::Builder::default()
    }
    /// Creates a new `DescribeLoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoggingOptions {
    type Output = std::result::Result<
        crate::output::DescribeLoggingOptionsOutput,
        crate::error::DescribeLoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_logging_options_error(response)
        } else {
            crate::operation_deser::parse_describe_logging_options_response(response)
        }
    }
}

/// Operation shape for `DescribePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pipeline`](crate::client::Client::describe_pipeline).
///
/// See [`crate::client::fluent_builders::DescribePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePipeline {
    _private: (),
}
impl DescribePipeline {
    /// Creates a new builder-style object to manufacture [`DescribePipelineInput`](crate::input::DescribePipelineInput)
    pub fn builder() -> crate::input::describe_pipeline_input::Builder {
        crate::input::describe_pipeline_input::Builder::default()
    }
    /// Creates a new `DescribePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePipeline {
    type Output = std::result::Result<
        crate::output::DescribePipelineOutput,
        crate::error::DescribePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pipeline_error(response)
        } else {
            crate::operation_deser::parse_describe_pipeline_response(response)
        }
    }
}

/// Operation shape for `GetDatasetContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dataset_content`](crate::client::Client::get_dataset_content).
///
/// See [`crate::client::fluent_builders::GetDatasetContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDatasetContent {
    _private: (),
}
impl GetDatasetContent {
    /// Creates a new builder-style object to manufacture [`GetDatasetContentInput`](crate::input::GetDatasetContentInput)
    pub fn builder() -> crate::input::get_dataset_content_input::Builder {
        crate::input::get_dataset_content_input::Builder::default()
    }
    /// Creates a new `GetDatasetContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDatasetContent {
    type Output = std::result::Result<
        crate::output::GetDatasetContentOutput,
        crate::error::GetDatasetContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dataset_content_error(response)
        } else {
            crate::operation_deser::parse_get_dataset_content_response(response)
        }
    }
}

/// Operation shape for `ListChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channels`](crate::client::Client::list_channels).
///
/// See [`crate::client::fluent_builders::ListChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannels {
    _private: (),
}
impl ListChannels {
    /// Creates a new builder-style object to manufacture [`ListChannelsInput`](crate::input::ListChannelsInput)
    pub fn builder() -> crate::input::list_channels_input::Builder {
        crate::input::list_channels_input::Builder::default()
    }
    /// Creates a new `ListChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannels {
    type Output =
        std::result::Result<crate::output::ListChannelsOutput, crate::error::ListChannelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channels_error(response)
        } else {
            crate::operation_deser::parse_list_channels_response(response)
        }
    }
}

/// Operation shape for `ListDatasetContents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_contents`](crate::client::Client::list_dataset_contents).
///
/// See [`crate::client::fluent_builders::ListDatasetContents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetContents {
    _private: (),
}
impl ListDatasetContents {
    /// Creates a new builder-style object to manufacture [`ListDatasetContentsInput`](crate::input::ListDatasetContentsInput)
    pub fn builder() -> crate::input::list_dataset_contents_input::Builder {
        crate::input::list_dataset_contents_input::Builder::default()
    }
    /// Creates a new `ListDatasetContents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetContents {
    type Output = std::result::Result<
        crate::output::ListDatasetContentsOutput,
        crate::error::ListDatasetContentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_contents_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_contents_response(response)
        }
    }
}

/// Operation shape for `ListDatasets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_datasets`](crate::client::Client::list_datasets).
///
/// See [`crate::client::fluent_builders::ListDatasets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasets {
    _private: (),
}
impl ListDatasets {
    /// Creates a new builder-style object to manufacture [`ListDatasetsInput`](crate::input::ListDatasetsInput)
    pub fn builder() -> crate::input::list_datasets_input::Builder {
        crate::input::list_datasets_input::Builder::default()
    }
    /// Creates a new `ListDatasets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasets {
    type Output =
        std::result::Result<crate::output::ListDatasetsOutput, crate::error::ListDatasetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_datasets_error(response)
        } else {
            crate::operation_deser::parse_list_datasets_response(response)
        }
    }
}

/// Operation shape for `ListDatastores`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_datastores`](crate::client::Client::list_datastores).
///
/// See [`crate::client::fluent_builders::ListDatastores`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatastores {
    _private: (),
}
impl ListDatastores {
    /// Creates a new builder-style object to manufacture [`ListDatastoresInput`](crate::input::ListDatastoresInput)
    pub fn builder() -> crate::input::list_datastores_input::Builder {
        crate::input::list_datastores_input::Builder::default()
    }
    /// Creates a new `ListDatastores` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatastores {
    type Output =
        std::result::Result<crate::output::ListDatastoresOutput, crate::error::ListDatastoresError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_datastores_error(response)
        } else {
            crate::operation_deser::parse_list_datastores_response(response)
        }
    }
}

/// Operation shape for `ListPipelines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipelines`](crate::client::Client::list_pipelines).
///
/// See [`crate::client::fluent_builders::ListPipelines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelines {
    _private: (),
}
impl ListPipelines {
    /// Creates a new builder-style object to manufacture [`ListPipelinesInput`](crate::input::ListPipelinesInput)
    pub fn builder() -> crate::input::list_pipelines_input::Builder {
        crate::input::list_pipelines_input::Builder::default()
    }
    /// Creates a new `ListPipelines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelines {
    type Output =
        std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipelines_error(response)
        } else {
            crate::operation_deser::parse_list_pipelines_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutLoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_logging_options`](crate::client::Client::put_logging_options).
///
/// See [`crate::client::fluent_builders::PutLoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLoggingOptions {
    _private: (),
}
impl PutLoggingOptions {
    /// Creates a new builder-style object to manufacture [`PutLoggingOptionsInput`](crate::input::PutLoggingOptionsInput)
    pub fn builder() -> crate::input::put_logging_options_input::Builder {
        crate::input::put_logging_options_input::Builder::default()
    }
    /// Creates a new `PutLoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLoggingOptions {
    type Output = std::result::Result<
        crate::output::PutLoggingOptionsOutput,
        crate::error::PutLoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_logging_options_error(response)
        } else {
            crate::operation_deser::parse_put_logging_options_response(response)
        }
    }
}

/// Operation shape for `RunPipelineActivity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`run_pipeline_activity`](crate::client::Client::run_pipeline_activity).
///
/// See [`crate::client::fluent_builders::RunPipelineActivity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RunPipelineActivity {
    _private: (),
}
impl RunPipelineActivity {
    /// Creates a new builder-style object to manufacture [`RunPipelineActivityInput`](crate::input::RunPipelineActivityInput)
    pub fn builder() -> crate::input::run_pipeline_activity_input::Builder {
        crate::input::run_pipeline_activity_input::Builder::default()
    }
    /// Creates a new `RunPipelineActivity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RunPipelineActivity {
    type Output = std::result::Result<
        crate::output::RunPipelineActivityOutput,
        crate::error::RunPipelineActivityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_run_pipeline_activity_error(response)
        } else {
            crate::operation_deser::parse_run_pipeline_activity_response(response)
        }
    }
}

/// Operation shape for `SampleChannelData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`sample_channel_data`](crate::client::Client::sample_channel_data).
///
/// See [`crate::client::fluent_builders::SampleChannelData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SampleChannelData {
    _private: (),
}
impl SampleChannelData {
    /// Creates a new builder-style object to manufacture [`SampleChannelDataInput`](crate::input::SampleChannelDataInput)
    pub fn builder() -> crate::input::sample_channel_data_input::Builder {
        crate::input::sample_channel_data_input::Builder::default()
    }
    /// Creates a new `SampleChannelData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SampleChannelData {
    type Output = std::result::Result<
        crate::output::SampleChannelDataOutput,
        crate::error::SampleChannelDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_sample_channel_data_error(response)
        } else {
            crate::operation_deser::parse_sample_channel_data_response(response)
        }
    }
}

/// Operation shape for `StartPipelineReprocessing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_pipeline_reprocessing`](crate::client::Client::start_pipeline_reprocessing).
///
/// See [`crate::client::fluent_builders::StartPipelineReprocessing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartPipelineReprocessing {
    _private: (),
}
impl StartPipelineReprocessing {
    /// Creates a new builder-style object to manufacture [`StartPipelineReprocessingInput`](crate::input::StartPipelineReprocessingInput)
    pub fn builder() -> crate::input::start_pipeline_reprocessing_input::Builder {
        crate::input::start_pipeline_reprocessing_input::Builder::default()
    }
    /// Creates a new `StartPipelineReprocessing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartPipelineReprocessing {
    type Output = std::result::Result<
        crate::output::StartPipelineReprocessingOutput,
        crate::error::StartPipelineReprocessingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_pipeline_reprocessing_error(response)
        } else {
            crate::operation_deser::parse_start_pipeline_reprocessing_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel`](crate::client::Client::update_channel).
///
/// See [`crate::client::fluent_builders::UpdateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannel {
    _private: (),
}
impl UpdateChannel {
    /// Creates a new builder-style object to manufacture [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    pub fn builder() -> crate::input::update_channel_input::Builder {
        crate::input::update_channel_input::Builder::default()
    }
    /// Creates a new `UpdateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannel {
    type Output =
        std::result::Result<crate::output::UpdateChannelOutput, crate::error::UpdateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_error(response)
        } else {
            crate::operation_deser::parse_update_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dataset`](crate::client::Client::update_dataset).
///
/// See [`crate::client::fluent_builders::UpdateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataset {
    _private: (),
}
impl UpdateDataset {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetInput`](crate::input::UpdateDatasetInput)
    pub fn builder() -> crate::input::update_dataset_input::Builder {
        crate::input::update_dataset_input::Builder::default()
    }
    /// Creates a new `UpdateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataset {
    type Output =
        std::result::Result<crate::output::UpdateDatasetOutput, crate::error::UpdateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dataset_error(response)
        } else {
            crate::operation_deser::parse_update_dataset_response(response)
        }
    }
}

/// Operation shape for `UpdateDatastore`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_datastore`](crate::client::Client::update_datastore).
///
/// See [`crate::client::fluent_builders::UpdateDatastore`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDatastore {
    _private: (),
}
impl UpdateDatastore {
    /// Creates a new builder-style object to manufacture [`UpdateDatastoreInput`](crate::input::UpdateDatastoreInput)
    pub fn builder() -> crate::input::update_datastore_input::Builder {
        crate::input::update_datastore_input::Builder::default()
    }
    /// Creates a new `UpdateDatastore` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDatastore {
    type Output = std::result::Result<
        crate::output::UpdateDatastoreOutput,
        crate::error::UpdateDatastoreError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_datastore_error(response)
        } else {
            crate::operation_deser::parse_update_datastore_response(response)
        }
    }
}

/// Operation shape for `UpdatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pipeline`](crate::client::Client::update_pipeline).
///
/// See [`crate::client::fluent_builders::UpdatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePipeline {
    _private: (),
}
impl UpdatePipeline {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
    pub fn builder() -> crate::input::update_pipeline_input::Builder {
        crate::input::update_pipeline_input::Builder::default()
    }
    /// Creates a new `UpdatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePipeline {
    type Output =
        std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pipeline_error(response)
        } else {
            crate::operation_deser::parse_update_pipeline_response(response)
        }
    }
}
