// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSIoTAnalytics`.
///
/// This client allows ergonomic access to a `AWSIoTAnalytics`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchPutMessage` operation.
    ///
    /// See [`BatchPutMessage`](crate::client::fluent_builders::BatchPutMessage) for more information about the
    /// operation and its arguments.
    pub fn batch_put_message(&self) -> fluent_builders::BatchPutMessage<C, M, R> {
        fluent_builders::BatchPutMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelPipelineReprocessing` operation.
    ///
    /// See [`CancelPipelineReprocessing`](crate::client::fluent_builders::CancelPipelineReprocessing) for more information about the
    /// operation and its arguments.
    pub fn cancel_pipeline_reprocessing(
        &self,
    ) -> fluent_builders::CancelPipelineReprocessing<C, M, R> {
        fluent_builders::CancelPipelineReprocessing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateChannel` operation.
    ///
    /// See [`CreateChannel`](crate::client::fluent_builders::CreateChannel) for more information about the
    /// operation and its arguments.
    pub fn create_channel(&self) -> fluent_builders::CreateChannel<C, M, R> {
        fluent_builders::CreateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataset` operation.
    ///
    /// See [`CreateDataset`](crate::client::fluent_builders::CreateDataset) for more information about the
    /// operation and its arguments.
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset<C, M, R> {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatasetContent` operation.
    ///
    /// See [`CreateDatasetContent`](crate::client::fluent_builders::CreateDatasetContent) for more information about the
    /// operation and its arguments.
    pub fn create_dataset_content(&self) -> fluent_builders::CreateDatasetContent<C, M, R> {
        fluent_builders::CreateDatasetContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatastore` operation.
    ///
    /// See [`CreateDatastore`](crate::client::fluent_builders::CreateDatastore) for more information about the
    /// operation and its arguments.
    pub fn create_datastore(&self) -> fluent_builders::CreateDatastore<C, M, R> {
        fluent_builders::CreateDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePipeline` operation.
    ///
    /// See [`CreatePipeline`](crate::client::fluent_builders::CreatePipeline) for more information about the
    /// operation and its arguments.
    pub fn create_pipeline(&self) -> fluent_builders::CreatePipeline<C, M, R> {
        fluent_builders::CreatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteChannel` operation.
    ///
    /// See [`DeleteChannel`](crate::client::fluent_builders::DeleteChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_channel(&self) -> fluent_builders::DeleteChannel<C, M, R> {
        fluent_builders::DeleteChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataset` operation.
    ///
    /// See [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset<C, M, R> {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDatasetContent` operation.
    ///
    /// See [`DeleteDatasetContent`](crate::client::fluent_builders::DeleteDatasetContent) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset_content(&self) -> fluent_builders::DeleteDatasetContent<C, M, R> {
        fluent_builders::DeleteDatasetContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDatastore` operation.
    ///
    /// See [`DeleteDatastore`](crate::client::fluent_builders::DeleteDatastore) for more information about the
    /// operation and its arguments.
    pub fn delete_datastore(&self) -> fluent_builders::DeleteDatastore<C, M, R> {
        fluent_builders::DeleteDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePipeline` operation.
    ///
    /// See [`DeletePipeline`](crate::client::fluent_builders::DeletePipeline) for more information about the
    /// operation and its arguments.
    pub fn delete_pipeline(&self) -> fluent_builders::DeletePipeline<C, M, R> {
        fluent_builders::DeletePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChannel` operation.
    ///
    /// See [`DescribeChannel`](crate::client::fluent_builders::DescribeChannel) for more information about the
    /// operation and its arguments.
    pub fn describe_channel(&self) -> fluent_builders::DescribeChannel<C, M, R> {
        fluent_builders::DescribeChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataset` operation.
    ///
    /// See [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset<C, M, R> {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDatastore` operation.
    ///
    /// See [`DescribeDatastore`](crate::client::fluent_builders::DescribeDatastore) for more information about the
    /// operation and its arguments.
    pub fn describe_datastore(&self) -> fluent_builders::DescribeDatastore<C, M, R> {
        fluent_builders::DescribeDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoggingOptions` operation.
    ///
    /// See [`DescribeLoggingOptions`](crate::client::fluent_builders::DescribeLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_logging_options(&self) -> fluent_builders::DescribeLoggingOptions<C, M, R> {
        fluent_builders::DescribeLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePipeline` operation.
    ///
    /// See [`DescribePipeline`](crate::client::fluent_builders::DescribePipeline) for more information about the
    /// operation and its arguments.
    pub fn describe_pipeline(&self) -> fluent_builders::DescribePipeline<C, M, R> {
        fluent_builders::DescribePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDatasetContent` operation.
    ///
    /// See [`GetDatasetContent`](crate::client::fluent_builders::GetDatasetContent) for more information about the
    /// operation and its arguments.
    pub fn get_dataset_content(&self) -> fluent_builders::GetDatasetContent<C, M, R> {
        fluent_builders::GetDatasetContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChannels` operation.
    ///
    /// See [`ListChannels`](crate::client::fluent_builders::ListChannels) for more information about the
    /// operation and its arguments.
    pub fn list_channels(&self) -> fluent_builders::ListChannels<C, M, R> {
        fluent_builders::ListChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetContents` operation.
    ///
    /// See [`ListDatasetContents`](crate::client::fluent_builders::ListDatasetContents) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_contents(&self) -> fluent_builders::ListDatasetContents<C, M, R> {
        fluent_builders::ListDatasetContents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasets` operation.
    ///
    /// See [`ListDatasets`](crate::client::fluent_builders::ListDatasets) for more information about the
    /// operation and its arguments.
    pub fn list_datasets(&self) -> fluent_builders::ListDatasets<C, M, R> {
        fluent_builders::ListDatasets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatastores` operation.
    ///
    /// See [`ListDatastores`](crate::client::fluent_builders::ListDatastores) for more information about the
    /// operation and its arguments.
    pub fn list_datastores(&self) -> fluent_builders::ListDatastores<C, M, R> {
        fluent_builders::ListDatastores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPipelines` operation.
    ///
    /// See [`ListPipelines`](crate::client::fluent_builders::ListPipelines) for more information about the
    /// operation and its arguments.
    pub fn list_pipelines(&self) -> fluent_builders::ListPipelines<C, M, R> {
        fluent_builders::ListPipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLoggingOptions` operation.
    ///
    /// See [`PutLoggingOptions`](crate::client::fluent_builders::PutLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn put_logging_options(&self) -> fluent_builders::PutLoggingOptions<C, M, R> {
        fluent_builders::PutLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RunPipelineActivity` operation.
    ///
    /// See [`RunPipelineActivity`](crate::client::fluent_builders::RunPipelineActivity) for more information about the
    /// operation and its arguments.
    pub fn run_pipeline_activity(&self) -> fluent_builders::RunPipelineActivity<C, M, R> {
        fluent_builders::RunPipelineActivity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SampleChannelData` operation.
    ///
    /// See [`SampleChannelData`](crate::client::fluent_builders::SampleChannelData) for more information about the
    /// operation and its arguments.
    pub fn sample_channel_data(&self) -> fluent_builders::SampleChannelData<C, M, R> {
        fluent_builders::SampleChannelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartPipelineReprocessing` operation.
    ///
    /// See [`StartPipelineReprocessing`](crate::client::fluent_builders::StartPipelineReprocessing) for more information about the
    /// operation and its arguments.
    pub fn start_pipeline_reprocessing(
        &self,
    ) -> fluent_builders::StartPipelineReprocessing<C, M, R> {
        fluent_builders::StartPipelineReprocessing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateChannel` operation.
    ///
    /// See [`UpdateChannel`](crate::client::fluent_builders::UpdateChannel) for more information about the
    /// operation and its arguments.
    pub fn update_channel(&self) -> fluent_builders::UpdateChannel<C, M, R> {
        fluent_builders::UpdateChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataset` operation.
    ///
    /// See [`UpdateDataset`](crate::client::fluent_builders::UpdateDataset) for more information about the
    /// operation and its arguments.
    pub fn update_dataset(&self) -> fluent_builders::UpdateDataset<C, M, R> {
        fluent_builders::UpdateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDatastore` operation.
    ///
    /// See [`UpdateDatastore`](crate::client::fluent_builders::UpdateDatastore) for more information about the
    /// operation and its arguments.
    pub fn update_datastore(&self) -> fluent_builders::UpdateDatastore<C, M, R> {
        fluent_builders::UpdateDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePipeline` operation.
    ///
    /// See [`UpdatePipeline`](crate::client::fluent_builders::UpdatePipeline) for more information about the
    /// operation and its arguments.
    pub fn update_pipeline(&self) -> fluent_builders::UpdatePipeline<C, M, R> {
        fluent_builders::UpdatePipeline::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchPutMessage`.
    ///
    /// <p>Sends messages to a channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchPutMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_put_message_input::Builder,
    }
    impl<C, M, R> BatchPutMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchPutMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchPutMessageInputOperationOutputAlias,
                crate::output::BatchPutMessageOutput,
                crate::error::BatchPutMessageError,
                crate::input::BatchPutMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel where the messages are sent.</p>
        pub fn channel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(inp);
            self
        }
        /// <p>The name of the channel where the messages are sent.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>The list of messages to be sent. Each message has the format: { "messageId": "string",
        /// "payload": "string"}.</p>
        /// <p>The field names of message payloads (data) that you send to IoT Analytics:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain only alphanumeric characters and undescores (_). No other special characters are
        /// allowed.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with an alphabetic character or single underscore (_).</p>
        /// </li>
        /// <li>
        /// <p>Cannot contain hyphens (-).</p>
        /// </li>
        /// <li>
        /// <p>In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
        /// </p>
        /// </li>
        /// <li>
        /// <p>Cannot be more than 255 characters.</p>
        /// </li>
        /// <li>
        /// <p>Are case insensitive. (Fields named foo and FOO in the same payload are considered
        /// duplicates.)</p>
        /// </li>
        /// </ul>
        /// <p>For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29},
        /// {"01_temp": 29} or {"__temp_01": 29} are invalid in message payloads.  </p>
        pub fn messages(mut self, inp: impl Into<crate::model::Message>) -> Self {
            self.inner = self.inner.messages(inp);
            self
        }
        /// <p>The list of messages to be sent. Each message has the format: { "messageId": "string",
        /// "payload": "string"}.</p>
        /// <p>The field names of message payloads (data) that you send to IoT Analytics:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain only alphanumeric characters and undescores (_). No other special characters are
        /// allowed.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with an alphabetic character or single underscore (_).</p>
        /// </li>
        /// <li>
        /// <p>Cannot contain hyphens (-).</p>
        /// </li>
        /// <li>
        /// <p>In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
        /// </p>
        /// </li>
        /// <li>
        /// <p>Cannot be more than 255 characters.</p>
        /// </li>
        /// <li>
        /// <p>Are case insensitive. (Fields named foo and FOO in the same payload are considered
        /// duplicates.)</p>
        /// </li>
        /// </ul>
        /// <p>For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29},
        /// {"01_temp": 29} or {"__temp_01": 29} are invalid in message payloads.  </p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.inner = self.inner.set_messages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelPipelineReprocessing`.
    ///
    /// <p>Cancels the reprocessing of data through the pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelPipelineReprocessing<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_pipeline_reprocessing_input::Builder,
    }
    impl<C, M, R> CancelPipelineReprocessing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelPipelineReprocessing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelPipelineReprocessingOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelPipelineReprocessingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelPipelineReprocessingInputOperationOutputAlias,
                crate::output::CancelPipelineReprocessingOutput,
                crate::error::CancelPipelineReprocessingError,
                crate::input::CancelPipelineReprocessingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of pipeline for which data reprocessing is canceled.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of pipeline for which data reprocessing is canceled.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The ID of the reprocessing task (returned by
        /// <code>StartPipelineReprocessing</code>).</p>
        pub fn reprocessing_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reprocessing_id(inp);
            self
        }
        /// <p>The ID of the reprocessing task (returned by
        /// <code>StartPipelineReprocessing</code>).</p>
        pub fn set_reprocessing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reprocessing_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateChannel`.
    ///
    /// <p>Used to create a channel. A channel collects data from an MQTT topic and archives the raw,
    /// unprocessed messages before publishing the data to a pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_channel_input::Builder,
    }
    impl<C, M, R> CreateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateChannelInputOperationOutputAlias,
                crate::output::CreateChannelOutput,
                crate::error::CreateChannelError,
                crate::input::CreateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel.</p>
        pub fn channel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(inp);
            self
        }
        /// <p>The name of the channel.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
        /// <code>customerManagedS3</code> storage. If not specified, the default is
        /// <code>serviceManagedS3</code>. You can't change this storage option after the channel is
        /// created.</p>
        pub fn channel_storage(mut self, inp: crate::model::ChannelStorage) -> Self {
            self.inner = self.inner.channel_storage(inp);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
        /// <code>customerManagedS3</code> storage. If not specified, the default is
        /// <code>serviceManagedS3</code>. You can't change this storage option after the channel is
        /// created.</p>
        pub fn set_channel_storage(
            mut self,
            input: std::option::Option<crate::model::ChannelStorage>,
        ) -> Self {
            self.inner = self.inner.set_channel_storage(input);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. When
        /// <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn retention_period(mut self, inp: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. When
        /// <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the channel.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Metadata which can be used to manage the channel.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Used to create a dataset. A dataset stores data retrieved from a data store by applying a
    /// <code>queryAction</code> (a SQL query) or a <code>containerAction</code> (executing a
    /// containerized application). This operation creates the skeleton of a dataset. The dataset can
    /// be populated manually by calling <code>CreateDatasetContent</code> or automatically according
    /// to a trigger you specify.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl<C, M, R> CreateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetInputOperationOutputAlias,
                crate::output::CreateDatasetOutput,
                crate::error::CreateDatasetError,
                crate::input::CreateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>A list of actions that create the dataset contents.</p>
        pub fn actions(mut self, inp: impl Into<crate::model::DatasetAction>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>A list of actions that create the dataset contents.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetAction>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>A list of triggers. A trigger causes dataset contents to be populated at a specified time
        /// interval or when another dataset's contents are created. The list of triggers can be empty or
        /// contain up to five <code>DataSetTrigger</code> objects.</p>
        pub fn triggers(mut self, inp: impl Into<crate::model::DatasetTrigger>) -> Self {
            self.inner = self.inner.triggers(inp);
            self
        }
        /// <p>A list of triggers. A trigger causes dataset contents to be populated at a specified time
        /// interval or when another dataset's contents are created. The list of triggers can be empty or
        /// contain up to five <code>DataSetTrigger</code> objects.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
        /// Appends an item to `contentDeliveryRules`.
        ///
        /// To override the contents of this collection use [`set_content_delivery_rules`](Self::set_content_delivery_rules).
        ///
        /// <p>When dataset contents are created, they are delivered to destinations specified
        /// here.</p>
        pub fn content_delivery_rules(
            mut self,
            inp: impl Into<crate::model::DatasetContentDeliveryRule>,
        ) -> Self {
            self.inner = self.inner.content_delivery_rules(inp);
            self
        }
        /// <p>When dataset contents are created, they are delivered to destinations specified
        /// here.</p>
        pub fn set_content_delivery_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetContentDeliveryRule>>,
        ) -> Self {
            self.inner = self.inner.set_content_delivery_rules(input);
            self
        }
        /// <p>Optional. How long, in days, versions of dataset contents are kept for the dataset. If not
        /// specified or set to <code>null</code>, versions of dataset contents are retained for at most
        /// 90 days. The number of versions of dataset contents retained is determined by the
        /// <code>versioningConfiguration</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
        /// Keeping Multiple Versions of IoT Analytics datasets</a> in the
        /// <i>IoT Analytics User Guide</i>.</p>
        pub fn retention_period(mut self, inp: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>Optional. How long, in days, versions of dataset contents are kept for the dataset. If not
        /// specified or set to <code>null</code>, versions of dataset contents are retained for at most
        /// 90 days. The number of versions of dataset contents retained is determined by the
        /// <code>versioningConfiguration</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
        /// Keeping Multiple Versions of IoT Analytics datasets</a> in the
        /// <i>IoT Analytics User Guide</i>.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null,
        /// only the latest version plus the latest succeeded version (if they are different) are kept for
        /// the time period specified by the <code>retentionPeriod</code> parameter. For more information,
        /// see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the
        /// <i>IoT Analytics User Guide</i>.</p>
        pub fn versioning_configuration(
            mut self,
            inp: crate::model::VersioningConfiguration,
        ) -> Self {
            self.inner = self.inner.versioning_configuration(inp);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null,
        /// only the latest version plus the latest succeeded version (if they are different) are kept for
        /// the time period specified by the <code>retentionPeriod</code> parameter. For more information,
        /// see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the
        /// <i>IoT Analytics User Guide</i>.</p>
        pub fn set_versioning_configuration(
            mut self,
            input: std::option::Option<crate::model::VersioningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_versioning_configuration(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the dataset.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Metadata which can be used to manage the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `lateDataRules`.
        ///
        /// To override the contents of this collection use [`set_late_data_rules`](Self::set_late_data_rules).
        ///
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn late_data_rules(mut self, inp: impl Into<crate::model::LateDataRule>) -> Self {
            self.inner = self.inner.late_data_rules(inp);
            self
        }
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn set_late_data_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LateDataRule>>,
        ) -> Self {
            self.inner = self.inner.set_late_data_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatasetContent`.
    ///
    /// <p>Creates the content of a dataset by applying a <code>queryAction</code> (a SQL query) or a
    /// <code>containerAction</code> (executing a containerized application).</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatasetContent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_content_input::Builder,
    }
    impl<C, M, R> CreateDatasetContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatasetContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetContentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetContentInputOperationOutputAlias,
                crate::output::CreateDatasetContentOutput,
                crate::error::CreateDatasetContentError,
                crate::input::CreateDatasetContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The version ID of the dataset content. To specify <code>versionId</code> for a dataset
        /// content, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The version ID of the dataset content. To specify <code>versionId</code> for a dataset
        /// content, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatastore`.
    ///
    /// <p>Creates a data store, which is a repository for messages.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_datastore_input::Builder,
    }
    impl<C, M, R> CreateDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatastoreInputOperationOutputAlias,
                crate::output::CreateDatastoreOutput,
                crate::error::CreateDatastoreError,
                crate::input::CreateDatastoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store.</p>
        pub fn datastore_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(inp);
            self
        }
        /// <p>The name of the data store.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn datastore_storage(mut self, inp: crate::model::DatastoreStorage) -> Self {
            self.inner = self.inner.datastore_storage(inp);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn set_datastore_storage(
            mut self,
            input: std::option::Option<crate::model::DatastoreStorage>,
        ) -> Self {
            self.inner = self.inner.set_datastore_storage(input);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. When
        /// <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn retention_period(mut self, inp: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. When
        /// <code>customerManagedS3</code> storage is selected, this parameter is ignored.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the data store.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Metadata which can be used to manage the data store.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn file_format_configuration(
            mut self,
            inp: crate::model::FileFormatConfiguration,
        ) -> Self {
            self.inner = self.inner.file_format_configuration(inp);
            self
        }
        /// <p>Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn set_file_format_configuration(
            mut self,
            input: std::option::Option<crate::model::FileFormatConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_file_format_configuration(input);
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn datastore_partitions(mut self, inp: crate::model::DatastorePartitions) -> Self {
            self.inner = self.inner.datastore_partitions(inp);
            self
        }
        /// <p> Contains information about the partition dimensions in a data store. </p>
        pub fn set_datastore_partitions(
            mut self,
            input: std::option::Option<crate::model::DatastorePartitions>,
        ) -> Self {
            self.inner = self.inner.set_datastore_partitions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePipeline`.
    ///
    /// <p>Creates a pipeline. A pipeline consumes messages from a channel and allows you to process
    /// the messages before storing them in a data store. You must specify both a <code>channel</code>
    /// and a <code>datastore</code> activity and, optionally, as many as 23 additional activities in
    /// the <code>pipelineActivities</code> array.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_pipeline_input::Builder,
    }
    impl<C, M, R> CreatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePipelineInputOperationOutputAlias,
                crate::output::CreatePipelineOutput,
                crate::error::CreatePipelineError,
                crate::input::CreatePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// Appends an item to `pipelineActivities`.
        ///
        /// To override the contents of this collection use [`set_pipeline_activities`](Self::set_pipeline_activities).
        ///
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on
        /// your messages, such as removing, renaming or adding message attributes; filtering messages
        /// based on attribute values; invoking your Lambda unctions on messages for advanced processing;
        /// or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a
        /// <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must
        /// contain only one activity. For example:</p>
        /// <p>
        /// <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ...
        /// ]</code>
        /// </p>
        pub fn pipeline_activities(
            mut self,
            inp: impl Into<crate::model::PipelineActivity>,
        ) -> Self {
            self.inner = self.inner.pipeline_activities(inp);
            self
        }
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on
        /// your messages, such as removing, renaming or adding message attributes; filtering messages
        /// based on attribute values; invoking your Lambda unctions on messages for advanced processing;
        /// or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a
        /// <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must
        /// contain only one activity. For example:</p>
        /// <p>
        /// <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ...
        /// ]</code>
        /// </p>
        pub fn set_pipeline_activities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineActivity>>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_activities(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the pipeline.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Metadata which can be used to manage the pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteChannel`.
    ///
    /// <p>Deletes the specified channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_channel_input::Builder,
    }
    impl<C, M, R> DeleteChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteChannelInputOperationOutputAlias,
                crate::output::DeleteChannelOutput,
                crate::error::DeleteChannelError,
                crate::input::DeleteChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel to delete.</p>
        pub fn channel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(inp);
            self
        }
        /// <p>The name of the channel to delete.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes the specified dataset.</p>
    /// <p>You do not have to delete the content of the dataset before you perform this
    /// operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl<C, M, R> DeleteDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetInputOperationOutputAlias,
                crate::output::DeleteDatasetOutput,
                crate::error::DeleteDatasetError,
                crate::input::DeleteDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to delete.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset to delete.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatasetContent`.
    ///
    /// <p>Deletes the content of the specified dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDatasetContent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_content_input::Builder,
    }
    impl<C, M, R> DeleteDatasetContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDatasetContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetContentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetContentInputOperationOutputAlias,
                crate::output::DeleteDatasetContentOutput,
                crate::error::DeleteDatasetContentError,
                crate::input::DeleteDatasetContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset whose content is deleted.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset whose content is deleted.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The version of the dataset whose content is deleted. You can also use the strings
        /// "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully completed data
        /// set. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The version of the dataset whose content is deleted. You can also use the strings
        /// "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully completed data
        /// set. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatastore`.
    ///
    /// <p>Deletes the specified data store.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_datastore_input::Builder,
    }
    impl<C, M, R> DeleteDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatastoreInputOperationOutputAlias,
                crate::output::DeleteDatastoreOutput,
                crate::error::DeleteDatastoreError,
                crate::input::DeleteDatastoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store to delete.</p>
        pub fn datastore_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(inp);
            self
        }
        /// <p>The name of the data store to delete.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePipeline`.
    ///
    /// <p>Deletes the specified pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_pipeline_input::Builder,
    }
    impl<C, M, R> DeletePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePipelineInputOperationOutputAlias,
                crate::output::DeletePipelineOutput,
                crate::error::DeletePipelineError,
                crate::input::DeletePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to delete.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline to delete.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChannel`.
    ///
    /// <p>Retrieves information about a channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_channel_input::Builder,
    }
    impl<C, M, R> DescribeChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChannelInputOperationOutputAlias,
                crate::output::DescribeChannelOutput,
                crate::error::DescribeChannelError,
                crate::input::DescribeChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel whose information is retrieved.</p>
        pub fn channel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(inp);
            self
        }
        /// <p>The name of the channel whose information is retrieved.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>If true, additional statistical information about the channel is included in the response.
        /// This feature can't be used with a channel whose S3 storage is customer-managed.</p>
        pub fn include_statistics(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_statistics(inp);
            self
        }
        /// <p>If true, additional statistical information about the channel is included in the response.
        /// This feature can't be used with a channel whose S3 storage is customer-managed.</p>
        pub fn set_include_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Retrieves information about a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl<C, M, R> DescribeDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetInputOperationOutputAlias,
                crate::output::DescribeDatasetOutput,
                crate::error::DescribeDatasetError,
                crate::input::DescribeDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset whose information is retrieved.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset whose information is retrieved.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDatastore`.
    ///
    /// <p>Retrieves information about a data store.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_datastore_input::Builder,
    }
    impl<C, M, R> DescribeDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatastoreInputOperationOutputAlias,
                crate::output::DescribeDatastoreOutput,
                crate::error::DescribeDatastoreError,
                crate::input::DescribeDatastoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store</p>
        pub fn datastore_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(inp);
            self
        }
        /// <p>The name of the data store</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>If true, additional statistical information about the data store is included in the
        /// response. This feature can't be used with a data store whose S3 storage is
        /// customer-managed.</p>
        pub fn include_statistics(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_statistics(inp);
            self
        }
        /// <p>If true, additional statistical information about the data store is included in the
        /// response. This feature can't be used with a data store whose S3 storage is
        /// customer-managed.</p>
        pub fn set_include_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingOptions`.
    ///
    /// <p>Retrieves the current settings of the IoT Analytics logging options.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_logging_options_input::Builder,
    }
    impl<C, M, R> DescribeLoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoggingOptionsInputOperationOutputAlias,
                crate::output::DescribeLoggingOptionsOutput,
                crate::error::DescribeLoggingOptionsError,
                crate::input::DescribeLoggingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribePipeline`.
    ///
    /// <p>Retrieves information about a pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pipeline_input::Builder,
    }
    impl<C, M, R> DescribePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePipelineInputOperationOutputAlias,
                crate::output::DescribePipelineOutput,
                crate::error::DescribePipelineError,
                crate::input::DescribePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline whose information is retrieved.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline whose information is retrieved.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDatasetContent`.
    ///
    /// <p>Retrieves the contents of a dataset as presigned URIs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDatasetContent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dataset_content_input::Builder,
    }
    impl<C, M, R> GetDatasetContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDatasetContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDatasetContentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDatasetContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDatasetContentInputOperationOutputAlias,
                crate::output::GetDatasetContentOutput,
                crate::error::GetDatasetContentError,
                crate::input::GetDatasetContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset whose contents are retrieved.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset whose contents are retrieved.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The version of the dataset whose contents are retrieved. You can also use the strings
        /// "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of the latest or latest successfully
        /// completed dataset. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The version of the dataset whose contents are retrieved. You can also use the strings
        /// "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of the latest or latest successfully
        /// completed dataset. If not specified, "$LATEST_SUCCEEDED" is the default.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChannels`.
    ///
    /// <p>Retrieves a list of channels.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_channels_input::Builder,
    }
    impl<C, M, R> ListChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChannelsInputOperationOutputAlias,
                crate::output::ListChannelsOutput,
                crate::error::ListChannelsError,
                crate::input::ListChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetContents`.
    ///
    /// <p>Lists information about dataset contents that have been created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetContents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_contents_input::Builder,
    }
    impl<C, M, R> ListDatasetContents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetContents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetContentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetContentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetContentsInputOperationOutputAlias,
                crate::output::ListDatasetContentsOutput,
                crate::error::ListDatasetContentsError,
                crate::input::ListDatasetContentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset whose contents information you want to list.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset whose contents information you want to list.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled on or
        /// after the given time. See the field <code>triggers.schedule</code> in the
        /// <code>CreateDataset</code> request. (timestamp)</p>
        pub fn scheduled_on_or_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.scheduled_on_or_after(inp);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled on or
        /// after the given time. See the field <code>triggers.schedule</code> in the
        /// <code>CreateDataset</code> request. (timestamp)</p>
        pub fn set_scheduled_on_or_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_on_or_after(input);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled before the
        /// given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code>
        /// request. (timestamp)</p>
        pub fn scheduled_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.scheduled_before(inp);
            self
        }
        /// <p>A filter to limit results to those dataset contents whose creation is scheduled before the
        /// given time. See the field <code>triggers.schedule</code> in the <code>CreateDataset</code>
        /// request. (timestamp)</p>
        pub fn set_scheduled_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_before(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasets`.
    ///
    /// <p>Retrieves information about datasets.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_datasets_input::Builder,
    }
    impl<C, M, R> ListDatasets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetsInputOperationOutputAlias,
                crate::output::ListDatasetsOutput,
                crate::error::ListDatasetsError,
                crate::input::ListDatasetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatastores`.
    ///
    /// <p>Retrieves a list of data stores.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatastores<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_datastores_input::Builder,
    }
    impl<C, M, R> ListDatastores<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatastores`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatastoresOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatastoresError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatastoresInputOperationOutputAlias,
                crate::output::ListDatastoresOutput,
                crate::error::ListDatastoresError,
                crate::input::ListDatastoresInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPipelines`.
    ///
    /// <p>Retrieves a list of pipelines.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPipelines<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pipelines_input::Builder,
    }
    impl<C, M, R> ListPipelines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPipelinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPipelinesInputOperationOutputAlias,
                crate::output::ListPipelinesOutput,
                crate::error::ListPipelinesError,
                crate::input::ListPipelinesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        /// <p>The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags (metadata) that you have assigned to the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags you want to list.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingOptions`.
    ///
    /// <p>Sets or updates the IoT Analytics logging options.</p>
    /// <p>If you update the value of any <code>loggingOptions</code> field, it takes up to one
    /// minute for the change to take effect. Also, if you change the policy attached to the role you
    /// specified in the <code>roleArn</code> field (for example, to correct an invalid policy), it
    /// takes up to five minutes for that change to take effect. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutLoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_logging_options_input::Builder,
    }
    impl<C, M, R> PutLoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLoggingOptionsInputOperationOutputAlias,
                crate::output::PutLoggingOptionsOutput,
                crate::error::PutLoggingOptionsError,
                crate::input::PutLoggingOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The new values of the IoT Analytics logging options.</p>
        pub fn logging_options(mut self, inp: crate::model::LoggingOptions) -> Self {
            self.inner = self.inner.logging_options(inp);
            self
        }
        /// <p>The new values of the IoT Analytics logging options.</p>
        pub fn set_logging_options(
            mut self,
            input: std::option::Option<crate::model::LoggingOptions>,
        ) -> Self {
            self.inner = self.inner.set_logging_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RunPipelineActivity`.
    ///
    /// <p>Simulates the results of running a pipeline activity on a message payload.</p>
    #[derive(std::fmt::Debug)]
    pub struct RunPipelineActivity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::run_pipeline_activity_input::Builder,
    }
    impl<C, M, R> RunPipelineActivity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RunPipelineActivity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RunPipelineActivityOutput,
            aws_smithy_http::result::SdkError<crate::error::RunPipelineActivityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RunPipelineActivityInputOperationOutputAlias,
                crate::output::RunPipelineActivityOutput,
                crate::error::RunPipelineActivityError,
                crate::input::RunPipelineActivityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The pipeline activity that is run. This must not be a channel activity or a data store
        /// activity because these activities are used in a pipeline only to load the original message and
        /// to store the (possibly) transformed message. If a Lambda activity is specified, only
        /// short-running Lambda functions (those with a timeout of less than 30 seconds or less) can be
        /// used.</p>
        pub fn pipeline_activity(mut self, inp: crate::model::PipelineActivity) -> Self {
            self.inner = self.inner.pipeline_activity(inp);
            self
        }
        /// <p>The pipeline activity that is run. This must not be a channel activity or a data store
        /// activity because these activities are used in a pipeline only to load the original message and
        /// to store the (possibly) transformed message. If a Lambda activity is specified, only
        /// short-running Lambda functions (those with a timeout of less than 30 seconds or less) can be
        /// used.</p>
        pub fn set_pipeline_activity(
            mut self,
            input: std::option::Option<crate::model::PipelineActivity>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_activity(input);
            self
        }
        /// Appends an item to `payloads`.
        ///
        /// To override the contents of this collection use [`set_payloads`](Self::set_payloads).
        ///
        /// <p>The sample message payloads on which the pipeline activity is run.</p>
        pub fn payloads(mut self, inp: impl Into<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.payloads(inp);
            self
        }
        /// <p>The sample message payloads on which the pipeline activity is run.</p>
        pub fn set_payloads(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.inner = self.inner.set_payloads(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SampleChannelData`.
    ///
    /// <p>Retrieves a sample of messages from the specified channel ingested during the specified
    /// timeframe. Up to 10 messages can be retrieved.</p>
    #[derive(std::fmt::Debug)]
    pub struct SampleChannelData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::sample_channel_data_input::Builder,
    }
    impl<C, M, R> SampleChannelData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SampleChannelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SampleChannelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::SampleChannelDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SampleChannelDataInputOperationOutputAlias,
                crate::output::SampleChannelDataOutput,
                crate::error::SampleChannelDataError,
                crate::input::SampleChannelDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel whose message samples are retrieved.</p>
        pub fn channel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(inp);
            self
        }
        /// <p>The name of the channel whose message samples are retrieved.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>The number of sample messages to be retrieved. The limit is 10. The default is also
        /// 10.</p>
        pub fn max_messages(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_messages(inp);
            self
        }
        /// <p>The number of sample messages to be retrieved. The limit is 10. The default is also
        /// 10.</p>
        pub fn set_max_messages(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_messages(input);
            self
        }
        /// <p>The start of the time window from which sample messages are retrieved.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time window from which sample messages are retrieved.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time window from which sample messages are retrieved.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time window from which sample messages are retrieved.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPipelineReprocessing`.
    ///
    /// <p>Starts the reprocessing of raw message data through the pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartPipelineReprocessing<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_pipeline_reprocessing_input::Builder,
    }
    impl<C, M, R> StartPipelineReprocessing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartPipelineReprocessing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPipelineReprocessingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPipelineReprocessingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartPipelineReprocessingInputOperationOutputAlias,
                crate::output::StartPipelineReprocessingOutput,
                crate::error::StartPipelineReprocessingError,
                crate::input::StartPipelineReprocessingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline on which to start reprocessing.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline on which to start reprocessing.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The start time (inclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>startTime</code> parameter, you must not use the
        /// <code>channelMessages</code> object.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time (inclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>startTime</code> parameter, you must not use the
        /// <code>channelMessages</code> object.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time (exclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>endTime</code> parameter, you must not use the
        /// <code>channelMessages</code> object.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time (exclusive) of raw message data that is reprocessed.</p>
        /// <p>If you specify a value for the <code>endTime</code> parameter, you must not use the
        /// <code>channelMessages</code> object.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Specifies one or more sets of channel messages that you want to reprocess.</p>
        /// <p>If you use the <code>channelMessages</code> object, you must not specify a value for
        /// <code>startTime</code> and <code>endTime</code>.</p>
        pub fn channel_messages(mut self, inp: crate::model::ChannelMessages) -> Self {
            self.inner = self.inner.channel_messages(inp);
            self
        }
        /// <p>Specifies one or more sets of channel messages that you want to reprocess.</p>
        /// <p>If you use the <code>channelMessages</code> object, you must not specify a value for
        /// <code>startTime</code> and <code>endTime</code>.</p>
        pub fn set_channel_messages(
            mut self,
            input: std::option::Option<crate::model::ChannelMessages>,
        ) -> Self {
            self.inner = self.inner.set_channel_messages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to
    /// manage a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags you want to modify.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource whose tags you want to modify.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modified tags for the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The new or modified tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the given tags (metadata) from the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource whose tags you want to remove.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource whose tags you want to remove.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of those tags which you want to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of those tags which you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateChannel`.
    ///
    /// <p>Used to update the settings of a channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_channel_input::Builder,
    }
    impl<C, M, R> UpdateChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateChannelInputOperationOutputAlias,
                crate::output::UpdateChannelOutput,
                crate::error::UpdateChannelError,
                crate::input::UpdateChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the channel to be updated.</p>
        pub fn channel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.channel_name(inp);
            self
        }
        /// <p>The name of the channel to be updated.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_channel_name(input);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
        /// <code>customerManagedS3</code> storage. If not specified, the default is
        /// <code>serviceManagedS3</code>. You can't change this storage option after the channel is
        /// created.</p>
        pub fn channel_storage(mut self, inp: crate::model::ChannelStorage) -> Self {
            self.inner = self.inner.channel_storage(inp);
            self
        }
        /// <p>Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
        /// <code>customerManagedS3</code> storage. If not specified, the default is
        /// <code>serviceManagedS3</code>. You can't change this storage option after the channel is
        /// created.</p>
        pub fn set_channel_storage(
            mut self,
            input: std::option::Option<crate::model::ChannelStorage>,
        ) -> Self {
            self.inner = self.inner.set_channel_storage(input);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. The retention period can't be
        /// updated if the channel's Amazon S3 storage is customer-managed.</p>
        pub fn retention_period(mut self, inp: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>How long, in days, message data is kept for the channel. The retention period can't be
        /// updated if the channel's Amazon S3 storage is customer-managed.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataset`.
    ///
    /// <p>Updates the settings of a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dataset_input::Builder,
    }
    impl<C, M, R> UpdateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDatasetInputOperationOutputAlias,
                crate::output::UpdateDatasetOutput,
                crate::error::UpdateDatasetError,
                crate::input::UpdateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dataset to update.</p>
        pub fn dataset_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_name(inp);
            self
        }
        /// <p>The name of the dataset to update.</p>
        pub fn set_dataset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_name(input);
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>A list of <code>DatasetAction</code> objects.</p>
        pub fn actions(mut self, inp: impl Into<crate::model::DatasetAction>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>A list of <code>DatasetAction</code> objects.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetAction>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to
        /// five <code>DatasetTrigger</code> objects.</p>
        pub fn triggers(mut self, inp: impl Into<crate::model::DatasetTrigger>) -> Self {
            self.inner = self.inner.triggers(inp);
            self
        }
        /// <p>A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to
        /// five <code>DatasetTrigger</code> objects.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
        /// Appends an item to `contentDeliveryRules`.
        ///
        /// To override the contents of this collection use [`set_content_delivery_rules`](Self::set_content_delivery_rules).
        ///
        /// <p>When dataset contents are created, they are delivered to destinations specified
        /// here.</p>
        pub fn content_delivery_rules(
            mut self,
            inp: impl Into<crate::model::DatasetContentDeliveryRule>,
        ) -> Self {
            self.inner = self.inner.content_delivery_rules(inp);
            self
        }
        /// <p>When dataset contents are created, they are delivered to destinations specified
        /// here.</p>
        pub fn set_content_delivery_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetContentDeliveryRule>>,
        ) -> Self {
            self.inner = self.inner.set_content_delivery_rules(input);
            self
        }
        /// <p>How long, in days, dataset contents are kept for the dataset.</p>
        pub fn retention_period(mut self, inp: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>How long, in days, dataset contents are kept for the dataset.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null,
        /// only the latest version plus the latest succeeded version (if they are different) are kept for
        /// the time period specified by the <code>retentionPeriod</code> parameter. For more information,
        /// see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the
        /// <i>IoT Analytics User Guide</i>.</p>
        pub fn versioning_configuration(
            mut self,
            inp: crate::model::VersioningConfiguration,
        ) -> Self {
            self.inner = self.inner.versioning_configuration(inp);
            self
        }
        /// <p>Optional. How many versions of dataset contents are kept. If not specified or set to null,
        /// only the latest version plus the latest succeeded version (if they are different) are kept for
        /// the time period specified by the <code>retentionPeriod</code> parameter. For more information,
        /// see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets</a> in the
        /// <i>IoT Analytics User Guide</i>.</p>
        pub fn set_versioning_configuration(
            mut self,
            input: std::option::Option<crate::model::VersioningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_versioning_configuration(input);
            self
        }
        /// Appends an item to `lateDataRules`.
        ///
        /// To override the contents of this collection use [`set_late_data_rules`](Self::set_late_data_rules).
        ///
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn late_data_rules(mut self, inp: impl Into<crate::model::LateDataRule>) -> Self {
            self.inner = self.inner.late_data_rules(inp);
            self
        }
        /// <p>A list of data rules that send notifications to CloudWatch, when data arrives late. To specify <code>lateDataRules</code>, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.</p>
        pub fn set_late_data_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LateDataRule>>,
        ) -> Self {
            self.inner = self.inner.set_late_data_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatastore`.
    ///
    /// <p>Used to update the settings of a data store.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_datastore_input::Builder,
    }
    impl<C, M, R> UpdateDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDatastoreInputOperationOutputAlias,
                crate::output::UpdateDatastoreOutput,
                crate::error::UpdateDatastoreError,
                crate::input::UpdateDatastoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data store to be updated.</p>
        pub fn datastore_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(inp);
            self
        }
        /// <p>The name of the data store to be updated.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. The retention period can't be
        /// updated if the data store's Amazon S3 storage is customer-managed.</p>
        pub fn retention_period(mut self, inp: crate::model::RetentionPeriod) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>How long, in days, message data is kept for the data store. The retention period can't be
        /// updated if the data store's Amazon S3 storage is customer-managed.</p>
        pub fn set_retention_period(
            mut self,
            input: std::option::Option<crate::model::RetentionPeriod>,
        ) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn datastore_storage(mut self, inp: crate::model::DatastoreStorage) -> Self {
            self.inner = self.inner.datastore_storage(inp);
            self
        }
        /// <p>Where data in a data store is stored.. You can choose <code>serviceManagedS3</code> storage, <code>customerManagedS3</code> storage, or <code>iotSiteWiseMultiLayerStorage</code> storage. The default is <code>serviceManagedS3</code>. You can't change the choice of Amazon S3 storage after your data store is created. </p>
        pub fn set_datastore_storage(
            mut self,
            input: std::option::Option<crate::model::DatastoreStorage>,
        ) -> Self {
            self.inner = self.inner.set_datastore_storage(input);
            self
        }
        /// <p>Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn file_format_configuration(
            mut self,
            inp: crate::model::FileFormatConfiguration,
        ) -> Self {
            self.inner = self.inner.file_format_configuration(inp);
            self
        }
        /// <p>Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet</a>.</p>
        /// <p>The default file format is JSON. You can specify only one format.</p>
        /// <p>You can't change the file format after you create the data store.</p>
        pub fn set_file_format_configuration(
            mut self,
            input: std::option::Option<crate::model::FileFormatConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_file_format_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePipeline`.
    ///
    /// <p>Updates the settings of a pipeline. You must specify both a <code>channel</code> and a
    /// <code>datastore</code> activity and, optionally, as many as 23 additional activities in the
    /// <code>pipelineActivities</code> array.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_pipeline_input::Builder,
    }
    impl<C, M, R> UpdatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePipelineInputOperationOutputAlias,
                crate::output::UpdatePipelineOutput,
                crate::error::UpdatePipelineError,
                crate::input::UpdatePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to update.</p>
        pub fn pipeline_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(inp);
            self
        }
        /// <p>The name of the pipeline to update.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// Appends an item to `pipelineActivities`.
        ///
        /// To override the contents of this collection use [`set_pipeline_activities`](Self::set_pipeline_activities).
        ///
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on
        /// your messages, such as removing, renaming or adding message attributes; filtering messages
        /// based on attribute values; invoking your Lambda functions on messages for advanced processing;
        /// or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a
        /// <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must
        /// contain only one activity. For example:</p>
        /// <p>
        /// <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ...
        /// ]</code>
        /// </p>
        pub fn pipeline_activities(
            mut self,
            inp: impl Into<crate::model::PipelineActivity>,
        ) -> Self {
            self.inner = self.inner.pipeline_activities(inp);
            self
        }
        /// <p>A list of <code>PipelineActivity</code> objects. Activities perform transformations on
        /// your messages, such as removing, renaming or adding message attributes; filtering messages
        /// based on attribute values; invoking your Lambda functions on messages for advanced processing;
        /// or performing mathematical transformations to normalize device data.</p>
        /// <p>The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a
        /// <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must
        /// contain only one activity. For example:</p>
        /// <p>
        /// <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ...
        /// ]</code>
        /// </p>
        pub fn set_pipeline_activities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineActivity>>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_activities(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
