// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateDeviceWithPlacementInput`](crate::input::AssociateDeviceWithPlacementInput)
pub mod associate_device_with_placement_input {
    /// A builder for [`AssociateDeviceWithPlacementInput`](crate::input::AssociateDeviceWithPlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) placement_name: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) device_template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project containing the placement in which to associate the device.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project containing the placement in which to associate the device.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The name of the placement in which to associate the device.</p>
        pub fn placement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_name = Some(input.into());
            self
        }
        /// <p>The name of the placement in which to associate the device.</p>
        pub fn set_placement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_name = input;
            self
        }
        /// <p>The ID of the physical device to be associated with the given placement in the project. Note that a mandatory 4 character prefix is required for all <code>deviceId</code> values.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the physical device to be associated with the given placement in the project. Note that a mandatory 4 character prefix is required for all <code>deviceId</code> values.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The device template name to associate with the device ID.</p>
        pub fn device_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_template_name = Some(input.into());
            self
        }
        /// <p>The device template name to associate with the device ID.</p>
        pub fn set_device_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDeviceWithPlacementInput`](crate::input::AssociateDeviceWithPlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDeviceWithPlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDeviceWithPlacementInput {
                project_name: self.project_name,
                placement_name: self.placement_name,
                device_id: self.device_id,
                device_template_name: self.device_template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDeviceWithPlacementInputOperationOutputAlias =
    crate::operation::AssociateDeviceWithPlacement;
#[doc(hidden)]
pub type AssociateDeviceWithPlacementInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateDeviceWithPlacementInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDeviceWithPlacement`](crate::operation::AssociateDeviceWithPlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDeviceWithPlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateDeviceWithPlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.project_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_1, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.placement_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "placement_name",
                        details: "cannot be empty or unset",
                    })?;
            let placement_name = aws_smithy_http::label::fmt_string(input_2, false);
            if placement_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "placement_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.device_template_name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_template_name",
                        details: "cannot be empty or unset",
                    })?;
            let device_template_name = aws_smithy_http::label::fmt_string(input_3, false);
            if device_template_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_template_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements/{placementName}/devices/{deviceTemplateName}",
                projectName = project_name,
                placementName = placement_name,
                deviceTemplateName = device_template_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateDeviceWithPlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateDeviceWithPlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_device_with_placement(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDeviceWithPlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDeviceWithPlacement",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateDeviceWithPlacementInput`](crate::input::AssociateDeviceWithPlacementInput)
    pub fn builder() -> crate::input::associate_device_with_placement_input::Builder {
        crate::input::associate_device_with_placement_input::Builder::default()
    }
}

/// See [`CreatePlacementInput`](crate::input::CreatePlacementInput)
pub mod create_placement_input {
    /// A builder for [`CreatePlacementInput`](crate::input::CreatePlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_name: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the placement to be created.</p>
        pub fn placement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_name = Some(input.into());
            self
        }
        /// <p>The name of the placement to be created.</p>
        pub fn set_placement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_name = input;
            self
        }
        /// <p>The name of the project in which to create the placement.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project in which to create the placement.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Optional user-defined key/value pairs providing contextual data (such as location or function) for the placement.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>Optional user-defined key/value pairs providing contextual data (such as location or function) for the placement.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlacementInput`](crate::input::CreatePlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlacementInput {
                placement_name: self.placement_name,
                project_name: self.project_name,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlacementInputOperationOutputAlias = crate::operation::CreatePlacement;
#[doc(hidden)]
pub type CreatePlacementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePlacementInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlacement`](crate::operation::CreatePlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.project_name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_4, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements",
                projectName = project_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_placement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlacement",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePlacementInput`](crate::input::CreatePlacementInput)
    pub fn builder() -> crate::input::create_placement_input::Builder {
        crate::input::create_placement_input::Builder::default()
    }
}

/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) placement_template: std::option::Option<crate::model::PlacementTemplate>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the project to create.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project to create.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>An optional description for the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The schema defining the placement to be created. A placement template defines placement default attributes and device templates. You cannot add or remove device templates after the project has been created. However, you can update <code>callbackOverrides</code> for the device templates using the <code>UpdateProject</code> API.</p>
        pub fn placement_template(mut self, input: crate::model::PlacementTemplate) -> Self {
            self.placement_template = Some(input);
            self
        }
        /// <p>The schema defining the placement to be created. A placement template defines placement default attributes and device templates. You cannot add or remove device templates after the project has been created. However, you can update <code>callbackOverrides</code> for the device templates using the <code>UpdateProject</code> API.</p>
        pub fn set_placement_template(
            mut self,
            input: std::option::Option<crate::model::PlacementTemplate>,
        ) -> Self {
            self.placement_template = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional tags (metadata key/value pairs) to be associated with the project. For example, <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Optional tags (metadata key/value pairs) to be associated with the project. For example, <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                project_name: self.project_name,
                description: self.description,
                placement_template: self.placement_template,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_project(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`DeletePlacementInput`](crate::input::DeletePlacementInput)
pub mod delete_placement_input {
    /// A builder for [`DeletePlacementInput`](crate::input::DeletePlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_name: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the empty placement to delete.</p>
        pub fn placement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_name = Some(input.into());
            self
        }
        /// <p>The name of the empty placement to delete.</p>
        pub fn set_placement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_name = input;
            self
        }
        /// <p>The project containing the empty placement to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The project containing the empty placement to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePlacementInput`](crate::input::DeletePlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePlacementInput {
                placement_name: self.placement_name,
                project_name: self.project_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePlacementInputOperationOutputAlias = crate::operation::DeletePlacement;
#[doc(hidden)]
pub type DeletePlacementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePlacementInput {
    /// Consumes the builder and constructs an Operation<[`DeletePlacement`](crate::operation::DeletePlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.project_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_5, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.placement_name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "placement_name",
                        details: "cannot be empty or unset",
                    })?;
            let placement_name = aws_smithy_http::label::fmt_string(input_6, false);
            if placement_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "placement_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements/{placementName}",
                projectName = project_name,
                placementName = placement_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePlacement",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePlacementInput`](crate::input::DeletePlacementInput)
    pub fn builder() -> crate::input::delete_placement_input::Builder {
        crate::input::delete_placement_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the empty project to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the empty project to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput {
                project_name: self.project_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.project_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_7, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}",
                projectName = project_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`DescribePlacementInput`](crate::input::DescribePlacementInput)
pub mod describe_placement_input {
    /// A builder for [`DescribePlacementInput`](crate::input::DescribePlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_name: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the placement within a project.</p>
        pub fn placement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_name = Some(input.into());
            self
        }
        /// <p>The name of the placement within a project.</p>
        pub fn set_placement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_name = input;
            self
        }
        /// <p>The project containing the placement to be described.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The project containing the placement to be described.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePlacementInput`](crate::input::DescribePlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePlacementInput {
                placement_name: self.placement_name,
                project_name: self.project_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePlacementInputOperationOutputAlias = crate::operation::DescribePlacement;
#[doc(hidden)]
pub type DescribePlacementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePlacementInput {
    /// Consumes the builder and constructs an Operation<[`DescribePlacement`](crate::operation::DescribePlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.project_name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_8, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.placement_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "placement_name",
                        details: "cannot be empty or unset",
                    })?;
            let placement_name = aws_smithy_http::label::fmt_string(input_9, false);
            if placement_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "placement_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements/{placementName}",
                projectName = project_name,
                placementName = placement_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePlacement",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePlacementInput`](crate::input::DescribePlacementInput)
    pub fn builder() -> crate::input::describe_placement_input::Builder {
        crate::input::describe_placement_input::Builder::default()
    }
}

/// See [`DescribeProjectInput`](crate::input::DescribeProjectInput)
pub mod describe_project_input {
    /// A builder for [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project to be described.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project to be described.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectInput`](crate::input::DescribeProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProjectInput {
                project_name: self.project_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProjectInputOperationOutputAlias = crate::operation::DescribeProject;
#[doc(hidden)]
pub type DescribeProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProjectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProject`](crate::operation::DescribeProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.project_name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_10, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}",
                projectName = project_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProject",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
}

/// See [`DisassociateDeviceFromPlacementInput`](crate::input::DisassociateDeviceFromPlacementInput)
pub mod disassociate_device_from_placement_input {
    /// A builder for [`DisassociateDeviceFromPlacementInput`](crate::input::DisassociateDeviceFromPlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) placement_name: std::option::Option<std::string::String>,
        pub(crate) device_template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the placement.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the placement.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The name of the placement that the device should be removed from.</p>
        pub fn placement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_name = Some(input.into());
            self
        }
        /// <p>The name of the placement that the device should be removed from.</p>
        pub fn set_placement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_name = input;
            self
        }
        /// <p>The device ID that should be removed from the placement.</p>
        pub fn device_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_template_name = Some(input.into());
            self
        }
        /// <p>The device ID that should be removed from the placement.</p>
        pub fn set_device_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateDeviceFromPlacementInput`](crate::input::DisassociateDeviceFromPlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateDeviceFromPlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateDeviceFromPlacementInput {
                project_name: self.project_name,
                placement_name: self.placement_name,
                device_template_name: self.device_template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateDeviceFromPlacementInputOperationOutputAlias =
    crate::operation::DisassociateDeviceFromPlacement;
#[doc(hidden)]
pub type DisassociateDeviceFromPlacementInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateDeviceFromPlacementInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateDeviceFromPlacement`](crate::operation::DisassociateDeviceFromPlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateDeviceFromPlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateDeviceFromPlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.project_name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_11, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.placement_name;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "placement_name",
                        details: "cannot be empty or unset",
                    })?;
            let placement_name = aws_smithy_http::label::fmt_string(input_12, false);
            if placement_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "placement_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.device_template_name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_template_name",
                        details: "cannot be empty or unset",
                    })?;
            let device_template_name = aws_smithy_http::label::fmt_string(input_13, false);
            if device_template_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_template_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements/{placementName}/devices/{deviceTemplateName}",
                projectName = project_name,
                placementName = placement_name,
                deviceTemplateName = device_template_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateDeviceFromPlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateDeviceFromPlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateDeviceFromPlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateDeviceFromPlacement",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateDeviceFromPlacementInput`](crate::input::DisassociateDeviceFromPlacementInput)
    pub fn builder() -> crate::input::disassociate_device_from_placement_input::Builder {
        crate::input::disassociate_device_from_placement_input::Builder::default()
    }
}

/// See [`GetDevicesInPlacementInput`](crate::input::GetDevicesInPlacementInput)
pub mod get_devices_in_placement_input {
    /// A builder for [`GetDevicesInPlacementInput`](crate::input::GetDevicesInPlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) placement_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project containing the placement.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project containing the placement.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The name of the placement to get the devices from.</p>
        pub fn placement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_name = Some(input.into());
            self
        }
        /// <p>The name of the placement to get the devices from.</p>
        pub fn set_placement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicesInPlacementInput`](crate::input::GetDevicesInPlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDevicesInPlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDevicesInPlacementInput {
                project_name: self.project_name,
                placement_name: self.placement_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDevicesInPlacementInputOperationOutputAlias = crate::operation::GetDevicesInPlacement;
#[doc(hidden)]
pub type GetDevicesInPlacementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDevicesInPlacementInput {
    /// Consumes the builder and constructs an Operation<[`GetDevicesInPlacement`](crate::operation::GetDevicesInPlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevicesInPlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDevicesInPlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.project_name;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_14, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.placement_name;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "placement_name",
                        details: "cannot be empty or unset",
                    })?;
            let placement_name = aws_smithy_http::label::fmt_string(input_15, false);
            if placement_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "placement_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements/{placementName}/devices",
                projectName = project_name,
                placementName = placement_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDevicesInPlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDevicesInPlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDevicesInPlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDevicesInPlacement",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDevicesInPlacementInput`](crate::input::GetDevicesInPlacementInput)
    pub fn builder() -> crate::input::get_devices_in_placement_input::Builder {
        crate::input::get_devices_in_placement_input::Builder::default()
    }
}

/// See [`ListPlacementsInput`](crate::input::ListPlacementsInput)
pub mod list_placements_input {
    /// A builder for [`ListPlacementsInput`](crate::input::ListPlacementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The project containing the placements to be listed.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The project containing the placements to be listed.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlacementsInput`](crate::input::ListPlacementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPlacementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPlacementsInput {
                project_name: self.project_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPlacementsInputOperationOutputAlias = crate::operation::ListPlacements;
#[doc(hidden)]
pub type ListPlacementsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPlacementsInput {
    /// Consumes the builder and constructs an Operation<[`ListPlacements`](crate::operation::ListPlacements)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPlacements,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPlacementsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.project_name;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_16, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements",
                projectName = project_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPlacementsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_17) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_17));
            }
            if let Some(inner_18) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_18).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPlacementsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPlacementsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPlacements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPlacements",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPlacementsInput`](crate::input::ListPlacementsInput)
    pub fn builder() -> crate::input::list_placements_input::Builder {
        crate::input::list_placements_input::Builder::default()
    }
}

/// See [`ListProjectsInput`](crate::input::ListProjectsInput)
pub mod list_projects_input {
    /// A builder for [`ListProjectsInput`](crate::input::ListProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsInput`](crate::input::ListProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectsInputOperationOutputAlias = crate::operation::ListProjects;
#[doc(hidden)]
pub type ListProjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjects`](crate::operation::ListProjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListProjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/projects").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListProjectsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_19) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
            }
            if let Some(inner_20) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_20).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListProjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListProjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjects",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource whose tags you want to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.resource_arn;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_21, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resouce for which tag(s) should be added or modified.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resouce for which tag(s) should be added or modified.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The new or modifying tag(s) for the resource. See <a href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT 1-Click Service Limits</a> for the maximum number of tags allowed per resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The new or modifying tag(s) for the resource. See <a href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT 1-Click Service Limits</a> for the maximum number of tags allowed per resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.resource_arn;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_22, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource whose tag you want to remove.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource whose tag you want to remove.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of those tags which you want to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of those tags which you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.resource_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_23, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_24) = &_input.tag_keys {
                for inner_25 in inner_24 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_25));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdatePlacementInput`](crate::input::UpdatePlacementInput)
pub mod update_placement_input {
    /// A builder for [`UpdatePlacementInput`](crate::input::UpdatePlacementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) placement_name: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the placement to update.</p>
        pub fn placement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_name = Some(input.into());
            self
        }
        /// <p>The name of the placement to update.</p>
        pub fn set_placement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_name = input;
            self
        }
        /// <p>The name of the project containing the placement to be updated.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project containing the placement to be updated.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The user-defined object of attributes used to update the placement. The maximum number of key/value pairs is 50.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The user-defined object of attributes used to update the placement. The maximum number of key/value pairs is 50.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePlacementInput`](crate::input::UpdatePlacementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePlacementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePlacementInput {
                placement_name: self.placement_name,
                project_name: self.project_name,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePlacementInputOperationOutputAlias = crate::operation::UpdatePlacement;
#[doc(hidden)]
pub type UpdatePlacementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePlacementInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePlacement`](crate::operation::UpdatePlacement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePlacement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePlacementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.project_name;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_26, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_27 = &_input.placement_name;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "placement_name",
                        details: "cannot be empty or unset",
                    })?;
            let placement_name = aws_smithy_http::label::fmt_string(input_27, false);
            if placement_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "placement_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}/placements/{placementName}",
                projectName = project_name,
                placementName = placement_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePlacementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePlacementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_placement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePlacement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePlacement",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePlacementInput`](crate::input::UpdatePlacementInput)
    pub fn builder() -> crate::input::update_placement_input::Builder {
        crate::input::update_placement_input::Builder::default()
    }
}

/// See [`UpdateProjectInput`](crate::input::UpdateProjectInput)
pub mod update_project_input {
    /// A builder for [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) placement_template: std::option::Option<crate::model::PlacementTemplate>,
    }
    impl Builder {
        /// <p>The name of the project to be updated.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project to be updated.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>An optional user-defined description for the project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional user-defined description for the project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An object defining the project update. Once a project has been created, you cannot add device template names to the project. However, for a given <code>placementTemplate</code>, you can update the associated <code>callbackOverrides</code> for the device definition using this API.</p>
        pub fn placement_template(mut self, input: crate::model::PlacementTemplate) -> Self {
            self.placement_template = Some(input);
            self
        }
        /// <p>An object defining the project update. Once a project has been created, you cannot add device template names to the project. However, for a given <code>placementTemplate</code>, you can update the associated <code>callbackOverrides</code> for the device definition using this API.</p>
        pub fn set_placement_template(
            mut self,
            input: std::option::Option<crate::model::PlacementTemplate>,
        ) -> Self {
            self.placement_template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectInput`](crate::input::UpdateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProjectInput {
                project_name: self.project_name,
                description: self.description,
                placement_template: self.placement_template,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProjectInputOperationOutputAlias = crate::operation::UpdateProject;
#[doc(hidden)]
pub type UpdateProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProjectInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProject`](crate::operation::UpdateProject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.project_name;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    })?;
            let project_name = aws_smithy_http::label::fmt_string(input_28, false);
            if project_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "project_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/projects/{projectName}",
                projectName = project_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_project(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProject",
            "iot1clickprojects",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectInput {
    /// <p>The name of the project to be updated.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>An optional user-defined description for the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An object defining the project update. Once a project has been created, you cannot add device template names to the project. However, for a given <code>placementTemplate</code>, you can update the associated <code>callbackOverrides</code> for the device definition using this API.</p>
    pub placement_template: std::option::Option<crate::model::PlacementTemplate>,
}
impl UpdateProjectInput {
    /// <p>The name of the project to be updated.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>An optional user-defined description for the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An object defining the project update. Once a project has been created, you cannot add device template names to the project. However, for a given <code>placementTemplate</code>, you can update the associated <code>callbackOverrides</code> for the device definition using this API.</p>
    pub fn placement_template(&self) -> std::option::Option<&crate::model::PlacementTemplate> {
        self.placement_template.as_ref()
    }
}
impl std::fmt::Debug for UpdateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("description", &self.description);
        formatter.field("placement_template", &self.placement_template);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePlacementInput {
    /// <p>The name of the placement to update.</p>
    pub placement_name: std::option::Option<std::string::String>,
    /// <p>The name of the project containing the placement to be updated.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The user-defined object of attributes used to update the placement. The maximum number of key/value pairs is 50.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdatePlacementInput {
    /// <p>The name of the placement to update.</p>
    pub fn placement_name(&self) -> std::option::Option<&str> {
        self.placement_name.as_deref()
    }
    /// <p>The name of the project containing the placement to be updated.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The user-defined object of attributes used to update the placement. The maximum number of key/value pairs is 50.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for UpdatePlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePlacementInput");
        formatter.field("placement_name", &self.placement_name);
        formatter.field("project_name", &self.project_name);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource whose tag you want to remove.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of those tags which you want to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource whose tag you want to remove.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of those tags which you want to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resouce for which tag(s) should be added or modified.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The new or modifying tag(s) for the resource. See <a href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT 1-Click Service Limits</a> for the maximum number of tags allowed per resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resouce for which tag(s) should be added or modified.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The new or modifying tag(s) for the resource. See <a href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT 1-Click Service Limits</a> for the maximum number of tags allowed per resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource whose tags you want to list.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource whose tags you want to list.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsInput {
    /// <p>The token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProjectsInput {
    /// <p>The token to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlacementsInput {
    /// <p>The project containing the placements to be listed.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPlacementsInput {
    /// <p>The project containing the placements to be listed.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The token to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per request. If not set, a default value of 100 is used.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPlacementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlacementsInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicesInPlacementInput {
    /// <p>The name of the project containing the placement.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The name of the placement to get the devices from.</p>
    pub placement_name: std::option::Option<std::string::String>,
}
impl GetDevicesInPlacementInput {
    /// <p>The name of the project containing the placement.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The name of the placement to get the devices from.</p>
    pub fn placement_name(&self) -> std::option::Option<&str> {
        self.placement_name.as_deref()
    }
}
impl std::fmt::Debug for GetDevicesInPlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicesInPlacementInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("placement_name", &self.placement_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateDeviceFromPlacementInput {
    /// <p>The name of the project that contains the placement.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The name of the placement that the device should be removed from.</p>
    pub placement_name: std::option::Option<std::string::String>,
    /// <p>The device ID that should be removed from the placement.</p>
    pub device_template_name: std::option::Option<std::string::String>,
}
impl DisassociateDeviceFromPlacementInput {
    /// <p>The name of the project that contains the placement.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The name of the placement that the device should be removed from.</p>
    pub fn placement_name(&self) -> std::option::Option<&str> {
        self.placement_name.as_deref()
    }
    /// <p>The device ID that should be removed from the placement.</p>
    pub fn device_template_name(&self) -> std::option::Option<&str> {
        self.device_template_name.as_deref()
    }
}
impl std::fmt::Debug for DisassociateDeviceFromPlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateDeviceFromPlacementInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("placement_name", &self.placement_name);
        formatter.field("device_template_name", &self.device_template_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectInput {
    /// <p>The name of the project to be described.</p>
    pub project_name: std::option::Option<std::string::String>,
}
impl DescribeProjectInput {
    /// <p>The name of the project to be described.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectInput");
        formatter.field("project_name", &self.project_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePlacementInput {
    /// <p>The name of the placement within a project.</p>
    pub placement_name: std::option::Option<std::string::String>,
    /// <p>The project containing the placement to be described.</p>
    pub project_name: std::option::Option<std::string::String>,
}
impl DescribePlacementInput {
    /// <p>The name of the placement within a project.</p>
    pub fn placement_name(&self) -> std::option::Option<&str> {
        self.placement_name.as_deref()
    }
    /// <p>The project containing the placement to be described.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
}
impl std::fmt::Debug for DescribePlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePlacementInput");
        formatter.field("placement_name", &self.placement_name);
        formatter.field("project_name", &self.project_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectInput {
    /// <p>The name of the empty project to delete.</p>
    pub project_name: std::option::Option<std::string::String>,
}
impl DeleteProjectInput {
    /// <p>The name of the empty project to delete.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectInput");
        formatter.field("project_name", &self.project_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePlacementInput {
    /// <p>The name of the empty placement to delete.</p>
    pub placement_name: std::option::Option<std::string::String>,
    /// <p>The project containing the empty placement to delete.</p>
    pub project_name: std::option::Option<std::string::String>,
}
impl DeletePlacementInput {
    /// <p>The name of the empty placement to delete.</p>
    pub fn placement_name(&self) -> std::option::Option<&str> {
        self.placement_name.as_deref()
    }
    /// <p>The project containing the empty placement to delete.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
}
impl std::fmt::Debug for DeletePlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePlacementInput");
        formatter.field("placement_name", &self.placement_name);
        formatter.field("project_name", &self.project_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectInput {
    /// <p>The name of the project to create.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>An optional description for the project.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The schema defining the placement to be created. A placement template defines placement default attributes and device templates. You cannot add or remove device templates after the project has been created. However, you can update <code>callbackOverrides</code> for the device templates using the <code>UpdateProject</code> API.</p>
    pub placement_template: std::option::Option<crate::model::PlacementTemplate>,
    /// <p>Optional tags (metadata key/value pairs) to be associated with the project. For example, <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateProjectInput {
    /// <p>The name of the project to create.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>An optional description for the project.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The schema defining the placement to be created. A placement template defines placement default attributes and device templates. You cannot add or remove device templates after the project has been created. However, you can update <code>callbackOverrides</code> for the device templates using the <code>UpdateProject</code> API.</p>
    pub fn placement_template(&self) -> std::option::Option<&crate::model::PlacementTemplate> {
        self.placement_template.as_ref()
    }
    /// <p>Optional tags (metadata key/value pairs) to be associated with the project. For example, <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("description", &self.description);
        formatter.field("placement_template", &self.placement_template);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlacementInput {
    /// <p>The name of the placement to be created.</p>
    pub placement_name: std::option::Option<std::string::String>,
    /// <p>The name of the project in which to create the placement.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>Optional user-defined key/value pairs providing contextual data (such as location or function) for the placement.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePlacementInput {
    /// <p>The name of the placement to be created.</p>
    pub fn placement_name(&self) -> std::option::Option<&str> {
        self.placement_name.as_deref()
    }
    /// <p>The name of the project in which to create the placement.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>Optional user-defined key/value pairs providing contextual data (such as location or function) for the placement.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for CreatePlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlacementInput");
        formatter.field("placement_name", &self.placement_name);
        formatter.field("project_name", &self.project_name);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateDeviceWithPlacementInput {
    /// <p>The name of the project containing the placement in which to associate the device.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The name of the placement in which to associate the device.</p>
    pub placement_name: std::option::Option<std::string::String>,
    /// <p>The ID of the physical device to be associated with the given placement in the project. Note that a mandatory 4 character prefix is required for all <code>deviceId</code> values.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The device template name to associate with the device ID.</p>
    pub device_template_name: std::option::Option<std::string::String>,
}
impl AssociateDeviceWithPlacementInput {
    /// <p>The name of the project containing the placement in which to associate the device.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The name of the placement in which to associate the device.</p>
    pub fn placement_name(&self) -> std::option::Option<&str> {
        self.placement_name.as_deref()
    }
    /// <p>The ID of the physical device to be associated with the given placement in the project. Note that a mandatory 4 character prefix is required for all <code>deviceId</code> values.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The device template name to associate with the device ID.</p>
    pub fn device_template_name(&self) -> std::option::Option<&str> {
        self.device_template_name.as_deref()
    }
}
impl std::fmt::Debug for AssociateDeviceWithPlacementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateDeviceWithPlacementInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("placement_name", &self.placement_name);
        formatter.field("device_id", &self.device_id);
        formatter.field("device_template_name", &self.device_template_name);
        formatter.finish()
    }
}
