// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ClaimDevicesByClaimCode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`claim_devices_by_claim_code`](crate::client::Client::claim_devices_by_claim_code).
///
/// See [`crate::client::fluent_builders::ClaimDevicesByClaimCode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ClaimDevicesByClaimCode {
    _private: (),
}
impl ClaimDevicesByClaimCode {
    /// Creates a new builder-style object to manufacture [`ClaimDevicesByClaimCodeInput`](crate::input::ClaimDevicesByClaimCodeInput)
    pub fn builder() -> crate::input::claim_devices_by_claim_code_input::Builder {
        crate::input::claim_devices_by_claim_code_input::Builder::default()
    }
    /// Creates a new `ClaimDevicesByClaimCode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ClaimDevicesByClaimCode {
    type Output = std::result::Result<
        crate::output::ClaimDevicesByClaimCodeOutput,
        crate::error::ClaimDevicesByClaimCodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_claim_devices_by_claim_code_error(response)
        } else {
            crate::operation_deser::parse_claim_devices_by_claim_code_response(response)
        }
    }
}

/// Operation shape for `DescribeDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device`](crate::client::Client::describe_device).
///
/// See [`crate::client::fluent_builders::DescribeDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDevice {
    _private: (),
}
impl DescribeDevice {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
    /// Creates a new `DescribeDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDevice {
    type Output =
        std::result::Result<crate::output::DescribeDeviceOutput, crate::error::DescribeDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_error(response)
        } else {
            crate::operation_deser::parse_describe_device_response(response)
        }
    }
}

/// Operation shape for `FinalizeDeviceClaim`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`finalize_device_claim`](crate::client::Client::finalize_device_claim).
///
/// See [`crate::client::fluent_builders::FinalizeDeviceClaim`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FinalizeDeviceClaim {
    _private: (),
}
impl FinalizeDeviceClaim {
    /// Creates a new builder-style object to manufacture [`FinalizeDeviceClaimInput`](crate::input::FinalizeDeviceClaimInput)
    pub fn builder() -> crate::input::finalize_device_claim_input::Builder {
        crate::input::finalize_device_claim_input::Builder::default()
    }
    /// Creates a new `FinalizeDeviceClaim` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FinalizeDeviceClaim {
    type Output = std::result::Result<
        crate::output::FinalizeDeviceClaimOutput,
        crate::error::FinalizeDeviceClaimError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_finalize_device_claim_error(response)
        } else {
            crate::operation_deser::parse_finalize_device_claim_response(response)
        }
    }
}

/// Operation shape for `GetDeviceMethods`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_methods`](crate::client::Client::get_device_methods).
///
/// See [`crate::client::fluent_builders::GetDeviceMethods`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeviceMethods {
    _private: (),
}
impl GetDeviceMethods {
    /// Creates a new builder-style object to manufacture [`GetDeviceMethodsInput`](crate::input::GetDeviceMethodsInput)
    pub fn builder() -> crate::input::get_device_methods_input::Builder {
        crate::input::get_device_methods_input::Builder::default()
    }
    /// Creates a new `GetDeviceMethods` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeviceMethods {
    type Output = std::result::Result<
        crate::output::GetDeviceMethodsOutput,
        crate::error::GetDeviceMethodsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_methods_error(response)
        } else {
            crate::operation_deser::parse_get_device_methods_response(response)
        }
    }
}

/// Operation shape for `InitiateDeviceClaim`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_device_claim`](crate::client::Client::initiate_device_claim).
///
/// See [`crate::client::fluent_builders::InitiateDeviceClaim`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateDeviceClaim {
    _private: (),
}
impl InitiateDeviceClaim {
    /// Creates a new builder-style object to manufacture [`InitiateDeviceClaimInput`](crate::input::InitiateDeviceClaimInput)
    pub fn builder() -> crate::input::initiate_device_claim_input::Builder {
        crate::input::initiate_device_claim_input::Builder::default()
    }
    /// Creates a new `InitiateDeviceClaim` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateDeviceClaim {
    type Output = std::result::Result<
        crate::output::InitiateDeviceClaimOutput,
        crate::error::InitiateDeviceClaimError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_initiate_device_claim_error(response)
        } else {
            crate::operation_deser::parse_initiate_device_claim_response(response)
        }
    }
}

/// Operation shape for `InvokeDeviceMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invoke_device_method`](crate::client::Client::invoke_device_method).
///
/// See [`crate::client::fluent_builders::InvokeDeviceMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InvokeDeviceMethod {
    _private: (),
}
impl InvokeDeviceMethod {
    /// Creates a new builder-style object to manufacture [`InvokeDeviceMethodInput`](crate::input::InvokeDeviceMethodInput)
    pub fn builder() -> crate::input::invoke_device_method_input::Builder {
        crate::input::invoke_device_method_input::Builder::default()
    }
    /// Creates a new `InvokeDeviceMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InvokeDeviceMethod {
    type Output = std::result::Result<
        crate::output::InvokeDeviceMethodOutput,
        crate::error::InvokeDeviceMethodError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_invoke_device_method_error(response)
        } else {
            crate::operation_deser::parse_invoke_device_method_response(response)
        }
    }
}

/// Operation shape for `ListDeviceEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_events`](crate::client::Client::list_device_events).
///
/// See [`crate::client::fluent_builders::ListDeviceEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceEvents {
    _private: (),
}
impl ListDeviceEvents {
    /// Creates a new builder-style object to manufacture [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
    pub fn builder() -> crate::input::list_device_events_input::Builder {
        crate::input::list_device_events_input::Builder::default()
    }
    /// Creates a new `ListDeviceEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceEvents {
    type Output = std::result::Result<
        crate::output::ListDeviceEventsOutput,
        crate::error::ListDeviceEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_events_error(response)
        } else {
            crate::operation_deser::parse_list_device_events_response(response)
        }
    }
}

/// Operation shape for `ListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices`](crate::client::Client::list_devices).
///
/// See [`crate::client::fluent_builders::ListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevices {
    _private: (),
}
impl ListDevices {
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
    /// Creates a new `ListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevices {
    type Output =
        std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_error(response)
        } else {
            crate::operation_deser::parse_list_devices_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UnclaimDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unclaim_device`](crate::client::Client::unclaim_device).
///
/// See [`crate::client::fluent_builders::UnclaimDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnclaimDevice {
    _private: (),
}
impl UnclaimDevice {
    /// Creates a new builder-style object to manufacture [`UnclaimDeviceInput`](crate::input::UnclaimDeviceInput)
    pub fn builder() -> crate::input::unclaim_device_input::Builder {
        crate::input::unclaim_device_input::Builder::default()
    }
    /// Creates a new `UnclaimDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnclaimDevice {
    type Output =
        std::result::Result<crate::output::UnclaimDeviceOutput, crate::error::UnclaimDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unclaim_device_error(response)
        } else {
            crate::operation_deser::parse_unclaim_device_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDeviceState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_state`](crate::client::Client::update_device_state).
///
/// See [`crate::client::fluent_builders::UpdateDeviceState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeviceState {
    _private: (),
}
impl UpdateDeviceState {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceStateInput`](crate::input::UpdateDeviceStateInput)
    pub fn builder() -> crate::input::update_device_state_input::Builder {
        crate::input::update_device_state_input::Builder::default()
    }
    /// Creates a new `UpdateDeviceState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeviceState {
    type Output = std::result::Result<
        crate::output::UpdateDeviceStateOutput,
        crate::error::UpdateDeviceStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_state_error(response)
        } else {
            crate::operation_deser::parse_update_device_state_response(response)
        }
    }
}
