// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ClaimDevicesByClaimCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ClaimDevicesByClaimCodeError {
    /// Kind of error that occurred.
    pub kind: ClaimDevicesByClaimCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ClaimDevicesByClaimCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ClaimDevicesByClaimCodeErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    ForbiddenException(crate::error::ForbiddenException),
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ClaimDevicesByClaimCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ClaimDevicesByClaimCodeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ClaimDevicesByClaimCodeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ClaimDevicesByClaimCodeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ClaimDevicesByClaimCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ClaimDevicesByClaimCodeError {
    fn code(&self) -> Option<&str> {
        ClaimDevicesByClaimCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ClaimDevicesByClaimCodeError {
    /// Creates a new `ClaimDevicesByClaimCodeError`.
    pub fn new(kind: ClaimDevicesByClaimCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ClaimDevicesByClaimCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ClaimDevicesByClaimCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ClaimDevicesByClaimCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ClaimDevicesByClaimCodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ClaimDevicesByClaimCodeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimDevicesByClaimCodeErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ClaimDevicesByClaimCodeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimDevicesByClaimCodeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ClaimDevicesByClaimCodeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClaimDevicesByClaimCodeErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ClaimDevicesByClaimCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ClaimDevicesByClaimCodeErrorKind::ForbiddenException(_inner) => Some(_inner),
            ClaimDevicesByClaimCodeErrorKind::InternalFailureException(_inner) => Some(_inner),
            ClaimDevicesByClaimCodeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ClaimDevicesByClaimCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDeviceError {
    /// Kind of error that occurred.
    pub kind: DescribeDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDeviceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDeviceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDeviceError {
    fn code(&self) -> Option<&str> {
        DescribeDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDeviceError {
    /// Creates a new `DescribeDeviceError`.
    pub fn new(kind: DescribeDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDeviceErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FinalizeDeviceClaim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FinalizeDeviceClaimError {
    /// Kind of error that occurred.
    pub kind: FinalizeDeviceClaimErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FinalizeDeviceClaim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FinalizeDeviceClaimErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    PreconditionFailedException(crate::error::PreconditionFailedException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceConflictException(crate::error::ResourceConflictException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FinalizeDeviceClaimError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FinalizeDeviceClaimErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            FinalizeDeviceClaimErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            FinalizeDeviceClaimErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            FinalizeDeviceClaimErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            FinalizeDeviceClaimErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            FinalizeDeviceClaimErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FinalizeDeviceClaimError {
    fn code(&self) -> Option<&str> {
        FinalizeDeviceClaimError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FinalizeDeviceClaimError {
    /// Creates a new `FinalizeDeviceClaimError`.
    pub fn new(kind: FinalizeDeviceClaimErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FinalizeDeviceClaimError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FinalizeDeviceClaimErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FinalizeDeviceClaimError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FinalizeDeviceClaimErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `FinalizeDeviceClaimErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            FinalizeDeviceClaimErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `FinalizeDeviceClaimErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            FinalizeDeviceClaimErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `FinalizeDeviceClaimErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            FinalizeDeviceClaimErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `FinalizeDeviceClaimErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            FinalizeDeviceClaimErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `FinalizeDeviceClaimErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            FinalizeDeviceClaimErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for FinalizeDeviceClaimError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FinalizeDeviceClaimErrorKind::InternalFailureException(_inner) => Some(_inner),
            FinalizeDeviceClaimErrorKind::InvalidRequestException(_inner) => Some(_inner),
            FinalizeDeviceClaimErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            FinalizeDeviceClaimErrorKind::ResourceConflictException(_inner) => Some(_inner),
            FinalizeDeviceClaimErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            FinalizeDeviceClaimErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeviceMethods` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeviceMethodsError {
    /// Kind of error that occurred.
    pub kind: GetDeviceMethodsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeviceMethods` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeviceMethodsErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeviceMethodsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeviceMethodsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetDeviceMethodsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetDeviceMethodsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDeviceMethodsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeviceMethodsError {
    fn code(&self) -> Option<&str> {
        GetDeviceMethodsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeviceMethodsError {
    /// Creates a new `GetDeviceMethodsError`.
    pub fn new(kind: GetDeviceMethodsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeviceMethodsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeviceMethodsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeviceMethodsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeviceMethodsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeviceMethodsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceMethodsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceMethodsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceMethodsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeviceMethodsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeviceMethodsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetDeviceMethodsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeviceMethodsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetDeviceMethodsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetDeviceMethodsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDeviceMethodsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitiateDeviceClaim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitiateDeviceClaimError {
    /// Kind of error that occurred.
    pub kind: InitiateDeviceClaimErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitiateDeviceClaim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitiateDeviceClaimErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceConflictException(crate::error::ResourceConflictException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitiateDeviceClaimError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitiateDeviceClaimErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            InitiateDeviceClaimErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            InitiateDeviceClaimErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            InitiateDeviceClaimErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InitiateDeviceClaimErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitiateDeviceClaimError {
    fn code(&self) -> Option<&str> {
        InitiateDeviceClaimError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitiateDeviceClaimError {
    /// Creates a new `InitiateDeviceClaimError`.
    pub fn new(kind: InitiateDeviceClaimErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitiateDeviceClaimError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitiateDeviceClaimErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitiateDeviceClaimError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitiateDeviceClaimErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitiateDeviceClaimErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateDeviceClaimErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateDeviceClaimErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateDeviceClaimErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateDeviceClaimErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateDeviceClaimErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateDeviceClaimErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateDeviceClaimErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for InitiateDeviceClaimError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitiateDeviceClaimErrorKind::InternalFailureException(_inner) => Some(_inner),
            InitiateDeviceClaimErrorKind::InvalidRequestException(_inner) => Some(_inner),
            InitiateDeviceClaimErrorKind::ResourceConflictException(_inner) => Some(_inner),
            InitiateDeviceClaimErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InitiateDeviceClaimErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InvokeDeviceMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InvokeDeviceMethodError {
    /// Kind of error that occurred.
    pub kind: InvokeDeviceMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InvokeDeviceMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InvokeDeviceMethodErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    PreconditionFailedException(crate::error::PreconditionFailedException),
    #[allow(missing_docs)] // documentation missing in model
    RangeNotSatisfiableException(crate::error::RangeNotSatisfiableException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceConflictException(crate::error::ResourceConflictException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InvokeDeviceMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InvokeDeviceMethodErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            InvokeDeviceMethodErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            InvokeDeviceMethodErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            InvokeDeviceMethodErrorKind::RangeNotSatisfiableException(_inner) => _inner.fmt(f),
            InvokeDeviceMethodErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            InvokeDeviceMethodErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InvokeDeviceMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InvokeDeviceMethodError {
    fn code(&self) -> Option<&str> {
        InvokeDeviceMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InvokeDeviceMethodError {
    /// Creates a new `InvokeDeviceMethodError`.
    pub fn new(kind: InvokeDeviceMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InvokeDeviceMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InvokeDeviceMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InvokeDeviceMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InvokeDeviceMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InvokeDeviceMethodErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeDeviceMethodErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeDeviceMethodErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeDeviceMethodErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeDeviceMethodErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeDeviceMethodErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeDeviceMethodErrorKind::RangeNotSatisfiableException`.
    pub fn is_range_not_satisfiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeDeviceMethodErrorKind::RangeNotSatisfiableException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeDeviceMethodErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeDeviceMethodErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeDeviceMethodErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeDeviceMethodErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for InvokeDeviceMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InvokeDeviceMethodErrorKind::InternalFailureException(_inner) => Some(_inner),
            InvokeDeviceMethodErrorKind::InvalidRequestException(_inner) => Some(_inner),
            InvokeDeviceMethodErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            InvokeDeviceMethodErrorKind::RangeNotSatisfiableException(_inner) => Some(_inner),
            InvokeDeviceMethodErrorKind::ResourceConflictException(_inner) => Some(_inner),
            InvokeDeviceMethodErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InvokeDeviceMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeviceEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeviceEventsError {
    /// Kind of error that occurred.
    pub kind: ListDeviceEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeviceEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeviceEventsErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    RangeNotSatisfiableException(crate::error::RangeNotSatisfiableException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeviceEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeviceEventsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDeviceEventsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDeviceEventsErrorKind::RangeNotSatisfiableException(_inner) => _inner.fmt(f),
            ListDeviceEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDeviceEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeviceEventsError {
    fn code(&self) -> Option<&str> {
        ListDeviceEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeviceEventsError {
    /// Creates a new `ListDeviceEventsError`.
    pub fn new(kind: ListDeviceEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeviceEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeviceEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeviceEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeviceEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDeviceEventsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceEventsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeviceEventsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceEventsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeviceEventsErrorKind::RangeNotSatisfiableException`.
    pub fn is_range_not_satisfiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceEventsErrorKind::RangeNotSatisfiableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeviceEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeviceEventsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListDeviceEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeviceEventsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDeviceEventsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDeviceEventsErrorKind::RangeNotSatisfiableException(_inner) => Some(_inner),
            ListDeviceEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDeviceEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevicesError {
    /// Kind of error that occurred.
    pub kind: ListDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevicesErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    RangeNotSatisfiableException(crate::error::RangeNotSatisfiableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevicesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::RangeNotSatisfiableException(_inner) => _inner.fmt(f),
            ListDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevicesError {
    fn code(&self) -> Option<&str> {
        ListDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevicesError {
    /// Creates a new `ListDevicesError`.
    pub fn new(kind: ListDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListDevicesErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListDevicesErrorKind::RangeNotSatisfiableException`.
    pub fn is_range_not_satisfiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevicesErrorKind::RangeNotSatisfiableException(_)
        )
    }
}
impl std::error::Error for ListDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevicesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDevicesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDevicesErrorKind::RangeNotSatisfiableException(_inner) => Some(_inner),
            ListDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UnclaimDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UnclaimDeviceError {
    /// Kind of error that occurred.
    pub kind: UnclaimDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UnclaimDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UnclaimDeviceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UnclaimDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UnclaimDeviceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UnclaimDeviceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UnclaimDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UnclaimDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UnclaimDeviceError {
    fn code(&self) -> Option<&str> {
        UnclaimDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UnclaimDeviceError {
    /// Creates a new `UnclaimDeviceError`.
    pub fn new(kind: UnclaimDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UnclaimDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UnclaimDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UnclaimDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UnclaimDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UnclaimDeviceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnclaimDeviceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UnclaimDeviceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnclaimDeviceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UnclaimDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnclaimDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UnclaimDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UnclaimDeviceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UnclaimDeviceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UnclaimDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UnclaimDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDeviceState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDeviceStateError {
    /// Kind of error that occurred.
    pub kind: UpdateDeviceStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDeviceState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDeviceStateErrorKind {
    #[allow(missing_docs)] // documentation missing in model
    InternalFailureException(crate::error::InternalFailureException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidRequestException(crate::error::InvalidRequestException),
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDeviceStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDeviceStateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDeviceStateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateDeviceStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDeviceStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDeviceStateError {
    fn code(&self) -> Option<&str> {
        UpdateDeviceStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDeviceStateError {
    /// Creates a new `UpdateDeviceStateError`.
    pub fn new(kind: UpdateDeviceStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDeviceStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDeviceStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDeviceStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDeviceStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDeviceStateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDeviceStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDeviceStateErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateDeviceStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDeviceStateErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDeviceStateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateDeviceStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDeviceStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>404</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The requested device could not be found.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>404</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>404</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>404</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The requested device could not be found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The requested device could not be found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>400</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The 400 error message returned by the web server.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InvalidRequestException {
    /// <p>400</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>400</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>400</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The 400 error message returned by the web server.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The 400 error message returned by the web server.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    /// <p>500</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The 500 error message returned by the web server.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InternalFailureException {
    /// <p>500</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>500</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>500</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The 500 error message returned by the web server.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The 500 error message returned by the web server.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RangeNotSatisfiableException {
    /// <p>416</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The requested number of results specified by nextToken cannot be
    /// satisfied.</p>
    pub message: std::option::Option<std::string::String>,
}
impl RangeNotSatisfiableException {
    /// <p>416</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for RangeNotSatisfiableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RangeNotSatisfiableException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RangeNotSatisfiableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RangeNotSatisfiableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RangeNotSatisfiableException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for RangeNotSatisfiableException {}
/// See [`RangeNotSatisfiableException`](crate::error::RangeNotSatisfiableException)
pub mod range_not_satisfiable_exception {
    /// A builder for [`RangeNotSatisfiableException`](crate::error::RangeNotSatisfiableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>416</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>416</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The requested number of results specified by nextToken cannot be
        /// satisfied.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The requested number of results specified by nextToken cannot be
        /// satisfied.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RangeNotSatisfiableException`](crate::error::RangeNotSatisfiableException)
        pub fn build(self) -> crate::error::RangeNotSatisfiableException {
            crate::error::RangeNotSatisfiableException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl RangeNotSatisfiableException {
    /// Creates a new builder-style object to manufacture [`RangeNotSatisfiableException`](crate::error::RangeNotSatisfiableException)
    pub fn builder() -> crate::error::range_not_satisfiable_exception::Builder {
        crate::error::range_not_satisfiable_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceConflictException {
    /// <p>409</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>An error message explaining the error or its remedy.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ResourceConflictException {
    /// <p>409</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceConflictException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceConflictException {}
/// See [`ResourceConflictException`](crate::error::ResourceConflictException)
pub mod resource_conflict_exception {
    /// A builder for [`ResourceConflictException`](crate::error::ResourceConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>409</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>409</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>An error message explaining the error or its remedy.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An error message explaining the error or its remedy.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceConflictException`](crate::error::ResourceConflictException)
        pub fn build(self) -> crate::error::ResourceConflictException {
            crate::error::ResourceConflictException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ResourceConflictException {
    /// Creates a new builder-style object to manufacture [`ResourceConflictException`](crate::error::ResourceConflictException)
    pub fn builder() -> crate::error::resource_conflict_exception::Builder {
        crate::error::resource_conflict_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionFailedException {
    /// <p>412</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>An error message explaining the error or its remedy.</p>
    pub message: std::option::Option<std::string::String>,
}
impl PreconditionFailedException {
    /// <p>412</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionFailedException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreconditionFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionFailedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionFailedException {}
/// See [`PreconditionFailedException`](crate::error::PreconditionFailedException)
pub mod precondition_failed_exception {
    /// A builder for [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>412</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>412</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>An error message explaining the error or its remedy.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An error message explaining the error or its remedy.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionFailedException`](crate::error::PreconditionFailedException)
        pub fn build(self) -> crate::error::PreconditionFailedException {
            crate::error::PreconditionFailedException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl PreconditionFailedException {
    /// Creates a new builder-style object to manufacture [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    pub fn builder() -> crate::error::precondition_failed_exception::Builder {
        crate::error::precondition_failed_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// <p>403</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The 403 error message returned by the web server.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ForbiddenException {
    /// <p>403</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>403</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>403</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The 403 error message returned by the web server.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The 403 error message returned by the web server.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}
