// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceDescription {
    /// <p>The ARN of the device.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An array of zero or more elements of DeviceAttribute objects providing
    /// user specified device attributes.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether or not the device is enabled.</p>
    pub enabled: bool,
    /// <p>A value between 0 and 1 inclusive, representing the fraction of life remaining for the
    /// device.</p>
    pub remaining_life: f64,
    /// <p>The type of the device, such as "button".</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The tags currently associated with the AWS IoT 1-Click device.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DeviceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceDescription");
        formatter.field("arn", &self.arn);
        formatter.field("attributes", &self.attributes);
        formatter.field("device_id", &self.device_id);
        formatter.field("enabled", &self.enabled);
        formatter.field("remaining_life", &self.remaining_life);
        formatter.field("r#type", &self.r#type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DeviceDescription`](crate::model::DeviceDescription)
pub mod device_description {
    /// A builder for [`DeviceDescription`](crate::model::DeviceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) remaining_life: std::option::Option<f64>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the device.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the device.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>An array of zero or more elements of DeviceAttribute objects providing
        /// user specified device attributes.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>An array of zero or more elements of DeviceAttribute objects providing
        /// user specified device attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>A Boolean value indicating whether or not the device is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether or not the device is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>A value between 0 and 1 inclusive, representing the fraction of life remaining for the
        /// device.</p>
        pub fn remaining_life(mut self, input: f64) -> Self {
            self.remaining_life = Some(input);
            self
        }
        /// <p>A value between 0 and 1 inclusive, representing the fraction of life remaining for the
        /// device.</p>
        pub fn set_remaining_life(mut self, input: std::option::Option<f64>) -> Self {
            self.remaining_life = input;
            self
        }
        /// <p>The type of the device, such as "button".</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the device, such as "button".</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags currently associated with the AWS IoT 1-Click device.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags currently associated with the AWS IoT 1-Click device.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceDescription`](crate::model::DeviceDescription)
        pub fn build(self) -> crate::model::DeviceDescription {
            crate::model::DeviceDescription {
                arn: self.arn,
                attributes: self.attributes,
                device_id: self.device_id,
                enabled: self.enabled.unwrap_or_default(),
                remaining_life: self.remaining_life.unwrap_or_default(),
                r#type: self.r#type,
                tags: self.tags,
            }
        }
    }
}
impl DeviceDescription {
    /// Creates a new builder-style object to manufacture [`DeviceDescription`](crate::model::DeviceDescription)
    pub fn builder() -> crate::model::device_description::Builder {
        crate::model::device_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceEvent {
    /// <p>An object representing the device associated with the event.</p>
    pub device: std::option::Option<crate::model::Device>,
    /// <p>A serialized JSON object representing the device-type specific event.</p>
    pub std_event: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeviceEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceEvent");
        formatter.field("device", &self.device);
        formatter.field("std_event", &self.std_event);
        formatter.finish()
    }
}
/// See [`DeviceEvent`](crate::model::DeviceEvent)
pub mod device_event {
    /// A builder for [`DeviceEvent`](crate::model::DeviceEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<crate::model::Device>,
        pub(crate) std_event: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An object representing the device associated with the event.</p>
        pub fn device(mut self, input: crate::model::Device) -> Self {
            self.device = Some(input);
            self
        }
        /// <p>An object representing the device associated with the event.</p>
        pub fn set_device(mut self, input: std::option::Option<crate::model::Device>) -> Self {
            self.device = input;
            self
        }
        /// <p>A serialized JSON object representing the device-type specific event.</p>
        pub fn std_event(mut self, input: impl Into<std::string::String>) -> Self {
            self.std_event = Some(input.into());
            self
        }
        /// <p>A serialized JSON object representing the device-type specific event.</p>
        pub fn set_std_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.std_event = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceEvent`](crate::model::DeviceEvent)
        pub fn build(self) -> crate::model::DeviceEvent {
            crate::model::DeviceEvent {
                device: self.device,
                std_event: self.std_event,
            }
        }
    }
}
impl DeviceEvent {
    /// Creates a new builder-style object to manufacture [`DeviceEvent`](crate::model::DeviceEvent)
    pub fn builder() -> crate::model::device_event::Builder {
        crate::model::device_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The user specified attributes associated with the device for an event.</p>
    pub attributes: std::option::Option<crate::model::Attributes>,
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The device type, such as "button".</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("attributes", &self.attributes);
        formatter.field("device_id", &self.device_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<crate::model::Attributes>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user specified attributes associated with the device for an event.</p>
        pub fn attributes(mut self, input: crate::model::Attributes) -> Self {
            self.attributes = Some(input);
            self
        }
        /// <p>The user specified attributes associated with the device for an event.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::Attributes>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The device type, such as "button".</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The device type, such as "button".</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                attributes: self.attributes,
                device_id: self.device_id,
                r#type: self.r#type,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attributes {}
impl std::fmt::Debug for Attributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attributes");
        formatter.finish()
    }
}
/// See [`Attributes`](crate::model::Attributes)
pub mod attributes {
    /// A builder for [`Attributes`](crate::model::Attributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Attributes`](crate::model::Attributes)
        pub fn build(self) -> crate::model::Attributes {
            crate::model::Attributes {}
        }
    }
}
impl Attributes {
    /// Creates a new builder-style object to manufacture [`Attributes`](crate::model::Attributes)
    pub fn builder() -> crate::model::attributes::Builder {
        crate::model::attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceMethod {
    /// <p>The type of the device, such as "button".</p>
    pub device_type: std::option::Option<std::string::String>,
    /// <p>The name of the method applicable to the deviceType.</p>
    pub method_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeviceMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceMethod");
        formatter.field("device_type", &self.device_type);
        formatter.field("method_name", &self.method_name);
        formatter.finish()
    }
}
/// See [`DeviceMethod`](crate::model::DeviceMethod)
pub mod device_method {
    /// A builder for [`DeviceMethod`](crate::model::DeviceMethod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_type: std::option::Option<std::string::String>,
        pub(crate) method_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the device, such as "button".</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The type of the device, such as "button".</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// <p>The name of the method applicable to the deviceType.</p>
        pub fn method_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.method_name = Some(input.into());
            self
        }
        /// <p>The name of the method applicable to the deviceType.</p>
        pub fn set_method_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.method_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceMethod`](crate::model::DeviceMethod)
        pub fn build(self) -> crate::model::DeviceMethod {
            crate::model::DeviceMethod {
                device_type: self.device_type,
                method_name: self.method_name,
            }
        }
    }
}
impl DeviceMethod {
    /// Creates a new builder-style object to manufacture [`DeviceMethod`](crate::model::DeviceMethod)
    pub fn builder() -> crate::model::device_method::Builder {
        crate::model::device_method::Builder::default()
    }
}
