// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ClaimDevicesByClaimCodeInput`](crate::input::ClaimDevicesByClaimCodeInput)
pub mod claim_devices_by_claim_code_input {
    /// A builder for [`ClaimDevicesByClaimCodeInput`](crate::input::ClaimDevicesByClaimCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) claim_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The claim code, starting with "C-", as provided by the device manufacturer.</p>
        pub fn claim_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.claim_code = Some(input.into());
            self
        }
        /// <p>The claim code, starting with "C-", as provided by the device manufacturer.</p>
        pub fn set_claim_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.claim_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ClaimDevicesByClaimCodeInput`](crate::input::ClaimDevicesByClaimCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ClaimDevicesByClaimCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ClaimDevicesByClaimCodeInput {
                claim_code: self.claim_code,
            })
        }
    }
}
#[doc(hidden)]
pub type ClaimDevicesByClaimCodeInputOperationOutputAlias =
    crate::operation::ClaimDevicesByClaimCode;
#[doc(hidden)]
pub type ClaimDevicesByClaimCodeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ClaimDevicesByClaimCodeInput {
    /// Consumes the builder and constructs an Operation<[`ClaimDevicesByClaimCode`](crate::operation::ClaimDevicesByClaimCode)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ClaimDevicesByClaimCode,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ClaimDevicesByClaimCodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.claim_code;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "claim_code",
                        details: "cannot be empty or unset",
                    })?;
            let claim_code = aws_smithy_http::label::fmt_string(input_1, false);
            if claim_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "claim_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/claims/{ClaimCode}", ClaimCode = claim_code)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ClaimDevicesByClaimCodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ClaimDevicesByClaimCodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ClaimDevicesByClaimCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ClaimDevicesByClaimCode",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ClaimDevicesByClaimCodeInput`](crate::input::ClaimDevicesByClaimCodeInput)
    pub fn builder() -> crate::input::claim_devices_by_claim_code_input::Builder {
        crate::input::claim_devices_by_claim_code_input::Builder::default()
    }
}

/// See [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
pub mod describe_device_input {
    /// A builder for [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeviceInput {
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeviceInputOperationOutputAlias = crate::operation::DescribeDevice;
#[doc(hidden)]
pub type DescribeDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDevice`](crate::operation::DescribeDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.device_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_2, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDevice",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
}

/// See [`FinalizeDeviceClaimInput`](crate::input::FinalizeDeviceClaimInput)
pub mod finalize_device_claim_input {
    /// A builder for [`FinalizeDeviceClaimInput`](crate::input::FinalizeDeviceClaimInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key/value pairs defining the resource tags. For example, {
        /// "tags": {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS
        /// Tagging Strategies</a>.</p><p>
        ///
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of key/value pairs defining the resource tags. For example, {
        /// "tags": {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS
        /// Tagging Strategies</a>.</p><p>
        ///
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`FinalizeDeviceClaimInput`](crate::input::FinalizeDeviceClaimInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FinalizeDeviceClaimInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FinalizeDeviceClaimInput {
                device_id: self.device_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type FinalizeDeviceClaimInputOperationOutputAlias = crate::operation::FinalizeDeviceClaim;
#[doc(hidden)]
pub type FinalizeDeviceClaimInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl FinalizeDeviceClaimInput {
    /// Consumes the builder and constructs an Operation<[`FinalizeDeviceClaim`](crate::operation::FinalizeDeviceClaim)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FinalizeDeviceClaim,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::FinalizeDeviceClaimInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.device_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_3, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/devices/{DeviceId}/finalize-claim",
                DeviceId = device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::FinalizeDeviceClaimInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::FinalizeDeviceClaimInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_finalize_device_claim(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FinalizeDeviceClaim::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FinalizeDeviceClaim",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`FinalizeDeviceClaimInput`](crate::input::FinalizeDeviceClaimInput)
    pub fn builder() -> crate::input::finalize_device_claim_input::Builder {
        crate::input::finalize_device_claim_input::Builder::default()
    }
}

/// See [`GetDeviceMethodsInput`](crate::input::GetDeviceMethodsInput)
pub mod get_device_methods_input {
    /// A builder for [`GetDeviceMethodsInput`](crate::input::GetDeviceMethodsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceMethodsInput`](crate::input::GetDeviceMethodsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeviceMethodsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeviceMethodsInput {
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceMethodsInputOperationOutputAlias = crate::operation::GetDeviceMethods;
#[doc(hidden)]
pub type GetDeviceMethodsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeviceMethodsInput {
    /// Consumes the builder and constructs an Operation<[`GetDeviceMethods`](crate::operation::GetDeviceMethods)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeviceMethods,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceMethodsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.device_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_4, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}/methods", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceMethodsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceMethodsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeviceMethods::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeviceMethods",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceMethodsInput`](crate::input::GetDeviceMethodsInput)
    pub fn builder() -> crate::input::get_device_methods_input::Builder {
        crate::input::get_device_methods_input::Builder::default()
    }
}

/// See [`InitiateDeviceClaimInput`](crate::input::InitiateDeviceClaimInput)
pub mod initiate_device_claim_input {
    /// A builder for [`InitiateDeviceClaimInput`](crate::input::InitiateDeviceClaimInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateDeviceClaimInput`](crate::input::InitiateDeviceClaimInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateDeviceClaimInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateDeviceClaimInput {
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateDeviceClaimInputOperationOutputAlias = crate::operation::InitiateDeviceClaim;
#[doc(hidden)]
pub type InitiateDeviceClaimInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InitiateDeviceClaimInput {
    /// Consumes the builder and constructs an Operation<[`InitiateDeviceClaim`](crate::operation::InitiateDeviceClaim)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateDeviceClaim,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateDeviceClaimInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.device_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_5, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/devices/{DeviceId}/initiate-claim",
                DeviceId = device_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateDeviceClaimInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateDeviceClaimInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateDeviceClaim::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateDeviceClaim",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateDeviceClaimInput`](crate::input::InitiateDeviceClaimInput)
    pub fn builder() -> crate::input::initiate_device_claim_input::Builder {
        crate::input::initiate_device_claim_input::Builder::default()
    }
}

/// See [`InvokeDeviceMethodInput`](crate::input::InvokeDeviceMethodInput)
pub mod invoke_device_method_input {
    /// A builder for [`InvokeDeviceMethodInput`](crate::input::InvokeDeviceMethodInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) device_method: std::option::Option<crate::model::DeviceMethod>,
        pub(crate) device_method_parameters: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The device method to invoke.</p>
        pub fn device_method(mut self, input: crate::model::DeviceMethod) -> Self {
            self.device_method = Some(input);
            self
        }
        /// <p>The device method to invoke.</p>
        pub fn set_device_method(
            mut self,
            input: std::option::Option<crate::model::DeviceMethod>,
        ) -> Self {
            self.device_method = input;
            self
        }
        /// <p>A JSON encoded string containing the device method request parameters.</p>
        pub fn device_method_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_method_parameters = Some(input.into());
            self
        }
        /// <p>A JSON encoded string containing the device method request parameters.</p>
        pub fn set_device_method_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_method_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeDeviceMethodInput`](crate::input::InvokeDeviceMethodInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InvokeDeviceMethodInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InvokeDeviceMethodInput {
                device_id: self.device_id,
                device_method: self.device_method,
                device_method_parameters: self.device_method_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type InvokeDeviceMethodInputOperationOutputAlias = crate::operation::InvokeDeviceMethod;
#[doc(hidden)]
pub type InvokeDeviceMethodInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InvokeDeviceMethodInput {
    /// Consumes the builder and constructs an Operation<[`InvokeDeviceMethod`](crate::operation::InvokeDeviceMethod)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InvokeDeviceMethod,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InvokeDeviceMethodInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.device_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_6, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}/methods", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InvokeDeviceMethodInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InvokeDeviceMethodInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_invoke_device_method(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InvokeDeviceMethod::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InvokeDeviceMethod",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InvokeDeviceMethodInput`](crate::input::InvokeDeviceMethodInput)
    pub fn builder() -> crate::input::invoke_device_method_input::Builder {
        crate::input::invoke_device_method_input::Builder::default()
    }
}

/// See [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
pub mod list_device_events_input {
    /// A builder for [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) from_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) to_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The start date for the device event query, in ISO8061 format. For example,
        /// 2018-03-28T15:45:12.880Z
        /// </p>
        pub fn from_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.from_time_stamp = Some(input);
            self
        }
        /// <p>The start date for the device event query, in ISO8061 format. For example,
        /// 2018-03-28T15:45:12.880Z
        /// </p>
        pub fn set_from_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.from_time_stamp = input;
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of
        /// 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of
        /// 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The end date for the device event query, in ISO8061 format. For example,
        /// 2018-03-28T15:45:12.880Z
        /// </p>
        pub fn to_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.to_time_stamp = Some(input);
            self
        }
        /// <p>The end date for the device event query, in ISO8061 format. For example,
        /// 2018-03-28T15:45:12.880Z
        /// </p>
        pub fn set_to_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.to_time_stamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeviceEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeviceEventsInput {
                device_id: self.device_id,
                from_time_stamp: self.from_time_stamp,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                to_time_stamp: self.to_time_stamp,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeviceEventsInputOperationOutputAlias = crate::operation::ListDeviceEvents;
#[doc(hidden)]
pub type ListDeviceEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDeviceEventsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeviceEvents`](crate::operation::ListDeviceEvents)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeviceEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeviceEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.device_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_7, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}/events", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDeviceEventsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.from_time_stamp {
                query.push_kv(
                    "fromTimeStamp",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_8,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_9) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_9));
            }
            if let Some(inner_10) = &_input.to_time_stamp {
                query.push_kv(
                    "toTimeStamp",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_10,
                        aws_smithy_types::instant::Format::DateTime,
                    ),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeviceEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeviceEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeviceEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeviceEvents",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeviceEventsInput`](crate::input::ListDeviceEventsInput)
    pub fn builder() -> crate::input::list_device_events_input::Builder {
        crate::input::list_device_events_input::Builder::default()
    }
}

/// See [`ListDevicesInput`](crate::input::ListDevicesInput)
pub mod list_devices_input {
    /// A builder for [`ListDevicesInput`](crate::input::ListDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_type: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the device, such as "button".</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The type of the device, such as "button".</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of
        /// 100 is used.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per request. If not set, a default value of
        /// 100 is used.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesInput`](crate::input::ListDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevicesInput {
                device_type: self.device_type,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevicesInputOperationOutputAlias = crate::operation::ListDevices;
#[doc(hidden)]
pub type ListDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListDevices`](crate::operation::ListDevices)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/devices").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDevicesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.device_type {
                query.push_kv("deviceType", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_12) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_12));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevices",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.resource_arn;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_13, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key/value pairs defining the resource tags. For example, {
        /// "tags": {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS
        /// Tagging Strategies</a>.</p><p>
        ///
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of key/value pairs defining the resource tags. For example, {
        /// "tags": {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS
        /// Tagging Strategies</a>.</p><p>
        ///
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.resource_arn;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_14, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UnclaimDeviceInput`](crate::input::UnclaimDeviceInput)
pub mod unclaim_device_input {
    /// A builder for [`UnclaimDeviceInput`](crate::input::UnclaimDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UnclaimDeviceInput`](crate::input::UnclaimDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnclaimDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnclaimDeviceInput {
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UnclaimDeviceInputOperationOutputAlias = crate::operation::UnclaimDevice;
#[doc(hidden)]
pub type UnclaimDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnclaimDeviceInput {
    /// Consumes the builder and constructs an Operation<[`UnclaimDevice`](crate::operation::UnclaimDevice)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnclaimDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnclaimDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.device_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_15, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}/unclaim", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnclaimDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnclaimDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnclaimDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnclaimDevice",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnclaimDeviceInput`](crate::input::UnclaimDeviceInput)
    pub fn builder() -> crate::input::unclaim_device_input::Builder {
        crate::input::unclaim_device_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A collections of tag keys. For example, {"key1","key2"}</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A collections of tag keys. For example, {"key1","key2"}</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.resource_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_16, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_17) = &_input.tag_keys {
                for inner_18 in inner_17 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_18));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDeviceStateInput`](crate::input::UpdateDeviceStateInput)
pub mod update_device_state_input {
    /// A builder for [`UpdateDeviceStateInput`](crate::input::UpdateDeviceStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier of the device.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the device.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>If true, the device is enabled. If false, the device is
        /// disabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If true, the device is enabled. If false, the device is
        /// disabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceStateInput`](crate::input::UpdateDeviceStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeviceStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeviceStateInput {
                device_id: self.device_id,
                enabled: self.enabled.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeviceStateInputOperationOutputAlias = crate::operation::UpdateDeviceState;
#[doc(hidden)]
pub type UpdateDeviceStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDeviceStateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeviceState`](crate::operation::UpdateDeviceState)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeviceState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeviceStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.device_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_id = aws_smithy_http::label::fmt_string(input_19, false);
            if device_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/devices/{DeviceId}/state", DeviceId = device_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeviceStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeviceStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_device_state(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeviceState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeviceState",
            "iot1clickdevicesservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeviceStateInput`](crate::input::UpdateDeviceStateInput)
    pub fn builder() -> crate::input::update_device_state_input::Builder {
        crate::input::update_device_state_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceStateInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>If true, the device is enabled. If false, the device is
    /// disabled.</p>
    pub enabled: bool,
}
impl std::fmt::Debug for UpdateDeviceStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceStateInput");
        formatter.field("device_id", &self.device_id);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A collections of tag keys. For example, {"key1","key2"}</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnclaimDeviceInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnclaimDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnclaimDeviceInput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A collection of key/value pairs defining the resource tags. For example, {
    /// "tags": {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS
    /// Tagging Strategies</a>.</p><p>
    ///
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesInput {
    /// <p>The type of the device, such as "button".</p>
    pub device_type: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per request. If not set, a default value of
    /// 100 is used.</p>
    pub max_results: i32,
    /// <p>The token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesInput");
        formatter.field("device_type", &self.device_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceEventsInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The start date for the device event query, in ISO8061 format. For example,
    /// 2018-03-28T15:45:12.880Z
    /// </p>
    pub from_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The maximum number of results to return per request. If not set, a default value of
    /// 100 is used.</p>
    pub max_results: i32,
    /// <p>The token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The end date for the device event query, in ISO8061 format. For example,
    /// 2018-03-28T15:45:12.880Z
    /// </p>
    pub to_time_stamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ListDeviceEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceEventsInput");
        formatter.field("device_id", &self.device_id);
        formatter.field("from_time_stamp", &self.from_time_stamp);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("to_time_stamp", &self.to_time_stamp);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeDeviceMethodInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The device method to invoke.</p>
    pub device_method: std::option::Option<crate::model::DeviceMethod>,
    /// <p>A JSON encoded string containing the device method request parameters.</p>
    pub device_method_parameters: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvokeDeviceMethodInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeDeviceMethodInput");
        formatter.field("device_id", &self.device_id);
        formatter.field("device_method", &self.device_method);
        formatter.field("device_method_parameters", &self.device_method_parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateDeviceClaimInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InitiateDeviceClaimInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateDeviceClaimInput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceMethodsInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDeviceMethodsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceMethodsInput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FinalizeDeviceClaimInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>A collection of key/value pairs defining the resource tags. For example, {
    /// "tags": {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS
    /// Tagging Strategies</a>.</p><p>
    ///
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for FinalizeDeviceClaimInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FinalizeDeviceClaimInput");
        formatter.field("device_id", &self.device_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeviceInput {
    /// <p>The unique identifier of the device.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeviceInput");
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClaimDevicesByClaimCodeInput {
    /// <p>The claim code, starting with "C-", as provided by the device manufacturer.</p>
    pub claim_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClaimDevicesByClaimCodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClaimDevicesByClaimCodeInput");
        formatter.field("claim_code", &self.claim_code);
        formatter.finish()
    }
}
