// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateSecurityProfileBehaviorsOutput {
    /// <p>True if the behaviors were valid.</p>
    pub valid: bool,
    /// <p>The list of any errors found in the behaviors.</p>
    pub validation_errors: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
}
impl ValidateSecurityProfileBehaviorsOutput {
    /// <p>True if the behaviors were valid.</p>
    pub fn valid(&self) -> bool {
        self.valid
    }
    /// <p>The list of any errors found in the behaviors.</p>
    pub fn validation_errors(&self) -> std::option::Option<&[crate::model::ValidationError]> {
        self.validation_errors.as_deref()
    }
}
impl std::fmt::Debug for ValidateSecurityProfileBehaviorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateSecurityProfileBehaviorsOutput");
        formatter.field("valid", &self.valid);
        formatter.field("validation_errors", &self.validation_errors);
        formatter.finish()
    }
}
/// See [`ValidateSecurityProfileBehaviorsOutput`](crate::output::ValidateSecurityProfileBehaviorsOutput)
pub mod validate_security_profile_behaviors_output {
    /// A builder for [`ValidateSecurityProfileBehaviorsOutput`](crate::output::ValidateSecurityProfileBehaviorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) valid: std::option::Option<bool>,
        pub(crate) validation_errors:
            std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
    }
    impl Builder {
        /// <p>True if the behaviors were valid.</p>
        pub fn valid(mut self, input: bool) -> Self {
            self.valid = Some(input);
            self
        }
        /// <p>True if the behaviors were valid.</p>
        pub fn set_valid(mut self, input: std::option::Option<bool>) -> Self {
            self.valid = input;
            self
        }
        /// Appends an item to `validation_errors`.
        ///
        /// To override the contents of this collection use [`set_validation_errors`](Self::set_validation_errors).
        ///
        /// <p>The list of any errors found in the behaviors.</p>
        pub fn validation_errors(mut self, input: crate::model::ValidationError) -> Self {
            let mut v = self.validation_errors.unwrap_or_default();
            v.push(input);
            self.validation_errors = Some(v);
            self
        }
        /// <p>The list of any errors found in the behaviors.</p>
        pub fn set_validation_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationError>>,
        ) -> Self {
            self.validation_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateSecurityProfileBehaviorsOutput`](crate::output::ValidateSecurityProfileBehaviorsOutput)
        pub fn build(self) -> crate::output::ValidateSecurityProfileBehaviorsOutput {
            crate::output::ValidateSecurityProfileBehaviorsOutput {
                valid: self.valid.unwrap_or_default(),
                validation_errors: self.validation_errors,
            }
        }
    }
}
impl ValidateSecurityProfileBehaviorsOutput {
    /// Creates a new builder-style object to manufacture [`ValidateSecurityProfileBehaviorsOutput`](crate::output::ValidateSecurityProfileBehaviorsOutput)
    pub fn builder() -> crate::output::validate_security_profile_behaviors_output::Builder {
        crate::output::validate_security_profile_behaviors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTopicRuleDestinationOutput {}
impl std::fmt::Debug for UpdateTopicRuleDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTopicRuleDestinationOutput");
        formatter.finish()
    }
}
/// See [`UpdateTopicRuleDestinationOutput`](crate::output::UpdateTopicRuleDestinationOutput)
pub mod update_topic_rule_destination_output {
    /// A builder for [`UpdateTopicRuleDestinationOutput`](crate::output::UpdateTopicRuleDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTopicRuleDestinationOutput`](crate::output::UpdateTopicRuleDestinationOutput)
        pub fn build(self) -> crate::output::UpdateTopicRuleDestinationOutput {
            crate::output::UpdateTopicRuleDestinationOutput {}
        }
    }
}
impl UpdateTopicRuleDestinationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTopicRuleDestinationOutput`](crate::output::UpdateTopicRuleDestinationOutput)
    pub fn builder() -> crate::output::update_topic_rule_destination_output::Builder {
        crate::output::update_topic_rule_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThingGroupsForThingOutput {}
impl std::fmt::Debug for UpdateThingGroupsForThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThingGroupsForThingOutput");
        formatter.finish()
    }
}
/// See [`UpdateThingGroupsForThingOutput`](crate::output::UpdateThingGroupsForThingOutput)
pub mod update_thing_groups_for_thing_output {
    /// A builder for [`UpdateThingGroupsForThingOutput`](crate::output::UpdateThingGroupsForThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateThingGroupsForThingOutput`](crate::output::UpdateThingGroupsForThingOutput)
        pub fn build(self) -> crate::output::UpdateThingGroupsForThingOutput {
            crate::output::UpdateThingGroupsForThingOutput {}
        }
    }
}
impl UpdateThingGroupsForThingOutput {
    /// Creates a new builder-style object to manufacture [`UpdateThingGroupsForThingOutput`](crate::output::UpdateThingGroupsForThingOutput)
    pub fn builder() -> crate::output::update_thing_groups_for_thing_output::Builder {
        crate::output::update_thing_groups_for_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThingGroupOutput {
    /// <p>The version of the updated thing group.</p>
    pub version: i64,
}
impl UpdateThingGroupOutput {
    /// <p>The version of the updated thing group.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
}
impl std::fmt::Debug for UpdateThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThingGroupOutput");
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`UpdateThingGroupOutput`](crate::output::UpdateThingGroupOutput)
pub mod update_thing_group_output {
    /// A builder for [`UpdateThingGroupOutput`](crate::output::UpdateThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The version of the updated thing group.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the updated thing group.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThingGroupOutput`](crate::output::UpdateThingGroupOutput)
        pub fn build(self) -> crate::output::UpdateThingGroupOutput {
            crate::output::UpdateThingGroupOutput {
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl UpdateThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateThingGroupOutput`](crate::output::UpdateThingGroupOutput)
    pub fn builder() -> crate::output::update_thing_group_output::Builder {
        crate::output::update_thing_group_output::Builder::default()
    }
}

/// <p>The output from the UpdateThing operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThingOutput {}
impl std::fmt::Debug for UpdateThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThingOutput");
        formatter.finish()
    }
}
/// See [`UpdateThingOutput`](crate::output::UpdateThingOutput)
pub mod update_thing_output {
    /// A builder for [`UpdateThingOutput`](crate::output::UpdateThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateThingOutput`](crate::output::UpdateThingOutput)
        pub fn build(self) -> crate::output::UpdateThingOutput {
            crate::output::UpdateThingOutput {}
        }
    }
}
impl UpdateThingOutput {
    /// Creates a new builder-style object to manufacture [`UpdateThingOutput`](crate::output::UpdateThingOutput)
    pub fn builder() -> crate::output::update_thing_output::Builder {
        crate::output::update_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStreamOutput {
    /// <p>The stream ID.</p>
    pub stream_id: std::option::Option<std::string::String>,
    /// <p>The stream ARN.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>A description of the stream.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The stream version.</p>
    pub stream_version: std::option::Option<i32>,
}
impl UpdateStreamOutput {
    /// <p>The stream ID.</p>
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// <p>The stream ARN.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>A description of the stream.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The stream version.</p>
    pub fn stream_version(&self) -> std::option::Option<i32> {
        self.stream_version
    }
}
impl std::fmt::Debug for UpdateStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStreamOutput");
        formatter.field("stream_id", &self.stream_id);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("description", &self.description);
        formatter.field("stream_version", &self.stream_version);
        formatter.finish()
    }
}
/// See [`UpdateStreamOutput`](crate::output::UpdateStreamOutput)
pub mod update_stream_output {
    /// A builder for [`UpdateStreamOutput`](crate::output::UpdateStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) stream_version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>The stream ARN.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The stream ARN.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>A description of the stream.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the stream.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The stream version.</p>
        pub fn stream_version(mut self, input: i32) -> Self {
            self.stream_version = Some(input);
            self
        }
        /// <p>The stream version.</p>
        pub fn set_stream_version(mut self, input: std::option::Option<i32>) -> Self {
            self.stream_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStreamOutput`](crate::output::UpdateStreamOutput)
        pub fn build(self) -> crate::output::UpdateStreamOutput {
            crate::output::UpdateStreamOutput {
                stream_id: self.stream_id,
                stream_arn: self.stream_arn,
                description: self.description,
                stream_version: self.stream_version,
            }
        }
    }
}
impl UpdateStreamOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStreamOutput`](crate::output::UpdateStreamOutput)
    pub fn builder() -> crate::output::update_stream_output::Builder {
        crate::output::update_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSecurityProfileOutput {
    /// <p>The name of the security profile that was updated.</p>
    pub security_profile_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the security profile that was updated.</p>
    pub security_profile_arn: std::option::Option<std::string::String>,
    /// <p>The description of the security profile.</p>
    pub security_profile_description: std::option::Option<std::string::String>,
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    pub behaviors: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
    /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    pub alert_targets: std::option::Option<
        std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
    >,
    /// <p> <i>Please use <code>UpdateSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the security profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
    pub additional_metrics_to_retain: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    pub additional_metrics_to_retain_v2:
        std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
    /// <p>The updated version of the security profile.</p>
    pub version: i64,
    /// <p>The time the security profile was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the security profile was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateSecurityProfileOutput {
    /// <p>The name of the security profile that was updated.</p>
    pub fn security_profile_name(&self) -> std::option::Option<&str> {
        self.security_profile_name.as_deref()
    }
    /// <p>The ARN of the security profile that was updated.</p>
    pub fn security_profile_arn(&self) -> std::option::Option<&str> {
        self.security_profile_arn.as_deref()
    }
    /// <p>The description of the security profile.</p>
    pub fn security_profile_description(&self) -> std::option::Option<&str> {
        self.security_profile_description.as_deref()
    }
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    pub fn behaviors(&self) -> std::option::Option<&[crate::model::Behavior]> {
        self.behaviors.as_deref()
    }
    /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    pub fn alert_targets(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
    > {
        self.alert_targets.as_ref()
    }
    /// <p> <i>Please use <code>UpdateSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the security profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
    pub fn additional_metrics_to_retain(&self) -> std::option::Option<&[std::string::String]> {
        self.additional_metrics_to_retain.as_deref()
    }
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    pub fn additional_metrics_to_retain_v2(
        &self,
    ) -> std::option::Option<&[crate::model::MetricToRetain]> {
        self.additional_metrics_to_retain_v2.as_deref()
    }
    /// <p>The updated version of the security profile.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The time the security profile was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The time the security profile was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for UpdateSecurityProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSecurityProfileOutput");
        formatter.field("security_profile_name", &self.security_profile_name);
        formatter.field("security_profile_arn", &self.security_profile_arn);
        formatter.field(
            "security_profile_description",
            &self.security_profile_description,
        );
        formatter.field("behaviors", &self.behaviors);
        formatter.field("alert_targets", &self.alert_targets);
        formatter.field(
            "additional_metrics_to_retain",
            &self.additional_metrics_to_retain,
        );
        formatter.field(
            "additional_metrics_to_retain_v2",
            &self.additional_metrics_to_retain_v2,
        );
        formatter.field("version", &self.version);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`UpdateSecurityProfileOutput`](crate::output::UpdateSecurityProfileOutput)
pub mod update_security_profile_output {
    /// A builder for [`UpdateSecurityProfileOutput`](crate::output::UpdateSecurityProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_arn: std::option::Option<std::string::String>,
        pub(crate) security_profile_description: std::option::Option<std::string::String>,
        pub(crate) behaviors: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        pub(crate) alert_targets: std::option::Option<
            std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
        >,
        pub(crate) additional_metrics_to_retain:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) additional_metrics_to_retain_v2:
            std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the security profile that was updated.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the security profile that was updated.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The ARN of the security profile that was updated.</p>
        pub fn security_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the security profile that was updated.</p>
        pub fn set_security_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_arn = input;
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn security_profile_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.security_profile_description = Some(input.into());
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn set_security_profile_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_description = input;
            self
        }
        /// Appends an item to `behaviors`.
        ///
        /// To override the contents of this collection use [`set_behaviors`](Self::set_behaviors).
        ///
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn behaviors(mut self, input: crate::model::Behavior) -> Self {
            let mut v = self.behaviors.unwrap_or_default();
            v.push(input);
            self.behaviors = Some(v);
            self
        }
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn set_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        ) -> Self {
            self.behaviors = input;
            self
        }
        /// Adds a key-value pair to `alert_targets`.
        ///
        /// To override the contents of this collection use [`set_alert_targets`](Self::set_alert_targets).
        ///
        /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
        pub fn alert_targets(
            mut self,
            k: crate::model::AlertTargetType,
            v: crate::model::AlertTarget,
        ) -> Self {
            let mut hash_map = self.alert_targets.unwrap_or_default();
            hash_map.insert(k, v);
            self.alert_targets = Some(hash_map);
            self
        }
        /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
        pub fn set_alert_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
            >,
        ) -> Self {
            self.alert_targets = input;
            self
        }
        /// Appends an item to `additional_metrics_to_retain`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain`](Self::set_additional_metrics_to_retain).
        ///
        /// <p> <i>Please use <code>UpdateSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the security profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
        pub fn additional_metrics_to_retain(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_metrics_to_retain.unwrap_or_default();
            v.push(input.into());
            self.additional_metrics_to_retain = Some(v);
            self
        }
        /// <p> <i>Please use <code>UpdateSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the security profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
        pub fn set_additional_metrics_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_metrics_to_retain = input;
            self
        }
        /// Appends an item to `additional_metrics_to_retain_v2`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain_v2`](Self::set_additional_metrics_to_retain_v2).
        ///
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn additional_metrics_to_retain_v2(
            mut self,
            input: crate::model::MetricToRetain,
        ) -> Self {
            let mut v = self.additional_metrics_to_retain_v2.unwrap_or_default();
            v.push(input);
            self.additional_metrics_to_retain_v2 = Some(v);
            self
        }
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn set_additional_metrics_to_retain_v2(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        ) -> Self {
            self.additional_metrics_to_retain_v2 = input;
            self
        }
        /// <p>The updated version of the security profile.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The updated version of the security profile.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The time the security profile was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The time the security profile was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The time the security profile was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The time the security profile was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSecurityProfileOutput`](crate::output::UpdateSecurityProfileOutput)
        pub fn build(self) -> crate::output::UpdateSecurityProfileOutput {
            crate::output::UpdateSecurityProfileOutput {
                security_profile_name: self.security_profile_name,
                security_profile_arn: self.security_profile_arn,
                security_profile_description: self.security_profile_description,
                behaviors: self.behaviors,
                alert_targets: self.alert_targets,
                additional_metrics_to_retain: self.additional_metrics_to_retain,
                additional_metrics_to_retain_v2: self.additional_metrics_to_retain_v2,
                version: self.version.unwrap_or_default(),
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl UpdateSecurityProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSecurityProfileOutput`](crate::output::UpdateSecurityProfileOutput)
    pub fn builder() -> crate::output::update_security_profile_output::Builder {
        crate::output::update_security_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateScheduledAuditOutput {
    /// <p>The ARN of the scheduled audit.</p>
    pub scheduled_audit_arn: std::option::Option<std::string::String>,
}
impl UpdateScheduledAuditOutput {
    /// <p>The ARN of the scheduled audit.</p>
    pub fn scheduled_audit_arn(&self) -> std::option::Option<&str> {
        self.scheduled_audit_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateScheduledAuditOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateScheduledAuditOutput");
        formatter.field("scheduled_audit_arn", &self.scheduled_audit_arn);
        formatter.finish()
    }
}
/// See [`UpdateScheduledAuditOutput`](crate::output::UpdateScheduledAuditOutput)
pub mod update_scheduled_audit_output {
    /// A builder for [`UpdateScheduledAuditOutput`](crate::output::UpdateScheduledAuditOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_audit_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the scheduled audit.</p>
        pub fn scheduled_audit_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the scheduled audit.</p>
        pub fn set_scheduled_audit_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateScheduledAuditOutput`](crate::output::UpdateScheduledAuditOutput)
        pub fn build(self) -> crate::output::UpdateScheduledAuditOutput {
            crate::output::UpdateScheduledAuditOutput {
                scheduled_audit_arn: self.scheduled_audit_arn,
            }
        }
    }
}
impl UpdateScheduledAuditOutput {
    /// Creates a new builder-style object to manufacture [`UpdateScheduledAuditOutput`](crate::output::UpdateScheduledAuditOutput)
    pub fn builder() -> crate::output::update_scheduled_audit_output::Builder {
        crate::output::update_scheduled_audit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoleAliasOutput {
    /// <p>The role alias.</p>
    pub role_alias: std::option::Option<std::string::String>,
    /// <p>The role alias ARN.</p>
    pub role_alias_arn: std::option::Option<std::string::String>,
}
impl UpdateRoleAliasOutput {
    /// <p>The role alias.</p>
    pub fn role_alias(&self) -> std::option::Option<&str> {
        self.role_alias.as_deref()
    }
    /// <p>The role alias ARN.</p>
    pub fn role_alias_arn(&self) -> std::option::Option<&str> {
        self.role_alias_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateRoleAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoleAliasOutput");
        formatter.field("role_alias", &self.role_alias);
        formatter.field("role_alias_arn", &self.role_alias_arn);
        formatter.finish()
    }
}
/// See [`UpdateRoleAliasOutput`](crate::output::UpdateRoleAliasOutput)
pub mod update_role_alias_output {
    /// A builder for [`UpdateRoleAliasOutput`](crate::output::UpdateRoleAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_alias: std::option::Option<std::string::String>,
        pub(crate) role_alias_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The role alias.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias = Some(input.into());
            self
        }
        /// <p>The role alias.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_alias = input;
            self
        }
        /// <p>The role alias ARN.</p>
        pub fn role_alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias_arn = Some(input.into());
            self
        }
        /// <p>The role alias ARN.</p>
        pub fn set_role_alias_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_alias_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoleAliasOutput`](crate::output::UpdateRoleAliasOutput)
        pub fn build(self) -> crate::output::UpdateRoleAliasOutput {
            crate::output::UpdateRoleAliasOutput {
                role_alias: self.role_alias,
                role_alias_arn: self.role_alias_arn,
            }
        }
    }
}
impl UpdateRoleAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRoleAliasOutput`](crate::output::UpdateRoleAliasOutput)
    pub fn builder() -> crate::output::update_role_alias_output::Builder {
        crate::output::update_role_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProvisioningTemplateOutput {}
impl std::fmt::Debug for UpdateProvisioningTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProvisioningTemplateOutput");
        formatter.finish()
    }
}
/// See [`UpdateProvisioningTemplateOutput`](crate::output::UpdateProvisioningTemplateOutput)
pub mod update_provisioning_template_output {
    /// A builder for [`UpdateProvisioningTemplateOutput`](crate::output::UpdateProvisioningTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateProvisioningTemplateOutput`](crate::output::UpdateProvisioningTemplateOutput)
        pub fn build(self) -> crate::output::UpdateProvisioningTemplateOutput {
            crate::output::UpdateProvisioningTemplateOutput {}
        }
    }
}
impl UpdateProvisioningTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProvisioningTemplateOutput`](crate::output::UpdateProvisioningTemplateOutput)
    pub fn builder() -> crate::output::update_provisioning_template_output::Builder {
        crate::output::update_provisioning_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMitigationActionOutput {
    /// <p>The ARN for the new mitigation action.</p>
    pub action_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the mitigation action.</p>
    pub action_id: std::option::Option<std::string::String>,
}
impl UpdateMitigationActionOutput {
    /// <p>The ARN for the new mitigation action.</p>
    pub fn action_arn(&self) -> std::option::Option<&str> {
        self.action_arn.as_deref()
    }
    /// <p>A unique identifier for the mitigation action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateMitigationActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMitigationActionOutput");
        formatter.field("action_arn", &self.action_arn);
        formatter.field("action_id", &self.action_id);
        formatter.finish()
    }
}
/// See [`UpdateMitigationActionOutput`](crate::output::UpdateMitigationActionOutput)
pub mod update_mitigation_action_output {
    /// A builder for [`UpdateMitigationActionOutput`](crate::output::UpdateMitigationActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_arn: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the new mitigation action.</p>
        pub fn action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the new mitigation action.</p>
        pub fn set_action_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_arn = input;
            self
        }
        /// <p>A unique identifier for the mitigation action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the mitigation action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMitigationActionOutput`](crate::output::UpdateMitigationActionOutput)
        pub fn build(self) -> crate::output::UpdateMitigationActionOutput {
            crate::output::UpdateMitigationActionOutput {
                action_arn: self.action_arn,
                action_id: self.action_id,
            }
        }
    }
}
impl UpdateMitigationActionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMitigationActionOutput`](crate::output::UpdateMitigationActionOutput)
    pub fn builder() -> crate::output::update_mitigation_action_output::Builder {
        crate::output::update_mitigation_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobOutput {}
impl std::fmt::Debug for UpdateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobOutput");
        formatter.finish()
    }
}
/// See [`UpdateJobOutput`](crate::output::UpdateJobOutput)
pub mod update_job_output {
    /// A builder for [`UpdateJobOutput`](crate::output::UpdateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateJobOutput`](crate::output::UpdateJobOutput)
        pub fn build(self) -> crate::output::UpdateJobOutput {
            crate::output::UpdateJobOutput {}
        }
    }
}
impl UpdateJobOutput {
    /// Creates a new builder-style object to manufacture [`UpdateJobOutput`](crate::output::UpdateJobOutput)
    pub fn builder() -> crate::output::update_job_output::Builder {
        crate::output::update_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIndexingConfigurationOutput {}
impl std::fmt::Debug for UpdateIndexingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIndexingConfigurationOutput");
        formatter.finish()
    }
}
/// See [`UpdateIndexingConfigurationOutput`](crate::output::UpdateIndexingConfigurationOutput)
pub mod update_indexing_configuration_output {
    /// A builder for [`UpdateIndexingConfigurationOutput`](crate::output::UpdateIndexingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateIndexingConfigurationOutput`](crate::output::UpdateIndexingConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateIndexingConfigurationOutput {
            crate::output::UpdateIndexingConfigurationOutput {}
        }
    }
}
impl UpdateIndexingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIndexingConfigurationOutput`](crate::output::UpdateIndexingConfigurationOutput)
    pub fn builder() -> crate::output::update_indexing_configuration_output::Builder {
        crate::output::update_indexing_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetMetricOutput {}
impl std::fmt::Debug for UpdateFleetMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetMetricOutput");
        formatter.finish()
    }
}
/// See [`UpdateFleetMetricOutput`](crate::output::UpdateFleetMetricOutput)
pub mod update_fleet_metric_output {
    /// A builder for [`UpdateFleetMetricOutput`](crate::output::UpdateFleetMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateFleetMetricOutput`](crate::output::UpdateFleetMetricOutput)
        pub fn build(self) -> crate::output::UpdateFleetMetricOutput {
            crate::output::UpdateFleetMetricOutput {}
        }
    }
}
impl UpdateFleetMetricOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFleetMetricOutput`](crate::output::UpdateFleetMetricOutput)
    pub fn builder() -> crate::output::update_fleet_metric_output::Builder {
        crate::output::update_fleet_metric_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventConfigurationsOutput {}
impl std::fmt::Debug for UpdateEventConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventConfigurationsOutput");
        formatter.finish()
    }
}
/// See [`UpdateEventConfigurationsOutput`](crate::output::UpdateEventConfigurationsOutput)
pub mod update_event_configurations_output {
    /// A builder for [`UpdateEventConfigurationsOutput`](crate::output::UpdateEventConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateEventConfigurationsOutput`](crate::output::UpdateEventConfigurationsOutput)
        pub fn build(self) -> crate::output::UpdateEventConfigurationsOutput {
            crate::output::UpdateEventConfigurationsOutput {}
        }
    }
}
impl UpdateEventConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEventConfigurationsOutput`](crate::output::UpdateEventConfigurationsOutput)
    pub fn builder() -> crate::output::update_event_configurations_output::Builder {
        crate::output::update_event_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDynamicThingGroupOutput {
    /// <p>The dynamic thing group version.</p>
    pub version: i64,
}
impl UpdateDynamicThingGroupOutput {
    /// <p>The dynamic thing group version.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
}
impl std::fmt::Debug for UpdateDynamicThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDynamicThingGroupOutput");
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`UpdateDynamicThingGroupOutput`](crate::output::UpdateDynamicThingGroupOutput)
pub mod update_dynamic_thing_group_output {
    /// A builder for [`UpdateDynamicThingGroupOutput`](crate::output::UpdateDynamicThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The dynamic thing group version.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The dynamic thing group version.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDynamicThingGroupOutput`](crate::output::UpdateDynamicThingGroupOutput)
        pub fn build(self) -> crate::output::UpdateDynamicThingGroupOutput {
            crate::output::UpdateDynamicThingGroupOutput {
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl UpdateDynamicThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDynamicThingGroupOutput`](crate::output::UpdateDynamicThingGroupOutput)
    pub fn builder() -> crate::output::update_dynamic_thing_group_output::Builder {
        crate::output::update_dynamic_thing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainConfigurationOutput {
    /// <p>The name of the domain configuration that was updated.</p>
    pub domain_configuration_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the domain configuration that was updated.</p>
    pub domain_configuration_arn: std::option::Option<std::string::String>,
}
impl UpdateDomainConfigurationOutput {
    /// <p>The name of the domain configuration that was updated.</p>
    pub fn domain_configuration_name(&self) -> std::option::Option<&str> {
        self.domain_configuration_name.as_deref()
    }
    /// <p>The ARN of the domain configuration that was updated.</p>
    pub fn domain_configuration_arn(&self) -> std::option::Option<&str> {
        self.domain_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainConfigurationOutput");
        formatter.field("domain_configuration_name", &self.domain_configuration_name);
        formatter.field("domain_configuration_arn", &self.domain_configuration_arn);
        formatter.finish()
    }
}
/// See [`UpdateDomainConfigurationOutput`](crate::output::UpdateDomainConfigurationOutput)
pub mod update_domain_configuration_output {
    /// A builder for [`UpdateDomainConfigurationOutput`](crate::output::UpdateDomainConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configuration_name: std::option::Option<std::string::String>,
        pub(crate) domain_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain configuration that was updated.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the domain configuration that was updated.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_name = input;
            self
        }
        /// <p>The ARN of the domain configuration that was updated.</p>
        pub fn domain_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the domain configuration that was updated.</p>
        pub fn set_domain_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainConfigurationOutput`](crate::output::UpdateDomainConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateDomainConfigurationOutput {
            crate::output::UpdateDomainConfigurationOutput {
                domain_configuration_name: self.domain_configuration_name,
                domain_configuration_arn: self.domain_configuration_arn,
            }
        }
    }
}
impl UpdateDomainConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainConfigurationOutput`](crate::output::UpdateDomainConfigurationOutput)
    pub fn builder() -> crate::output::update_domain_configuration_output::Builder {
        crate::output::update_domain_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDimensionOutput {
    /// <p>A unique identifier for the dimension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN)of the created dimension.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of the dimension.</p>
    pub r#type: std::option::Option<crate::model::DimensionType>,
    /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    pub string_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time, in milliseconds since epoch, when the dimension was initially created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time, in milliseconds since epoch, when the dimension was most recently updated.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateDimensionOutput {
    /// <p>A unique identifier for the dimension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN)of the created dimension.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of the dimension.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DimensionType> {
        self.r#type.as_ref()
    }
    /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    pub fn string_values(&self) -> std::option::Option<&[std::string::String]> {
        self.string_values.as_deref()
    }
    /// <p>The date and time, in milliseconds since epoch, when the dimension was initially created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time, in milliseconds since epoch, when the dimension was most recently updated.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for UpdateDimensionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDimensionOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("string_values", &self.string_values);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`UpdateDimensionOutput`](crate::output::UpdateDimensionOutput)
pub mod update_dimension_output {
    /// A builder for [`UpdateDimensionOutput`](crate::output::UpdateDimensionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DimensionType>,
        pub(crate) string_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN)of the created dimension.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN)of the created dimension.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of the dimension.</p>
        pub fn r#type(mut self, input: crate::model::DimensionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the dimension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::DimensionType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `string_values`.
        ///
        /// To override the contents of this collection use [`set_string_values`](Self::set_string_values).
        ///
        /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
        pub fn string_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_values.unwrap_or_default();
            v.push(input.into());
            self.string_values = Some(v);
            self
        }
        /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
        pub fn set_string_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_values = input;
            self
        }
        /// <p>The date and time, in milliseconds since epoch, when the dimension was initially created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time, in milliseconds since epoch, when the dimension was initially created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time, in milliseconds since epoch, when the dimension was most recently updated.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time, in milliseconds since epoch, when the dimension was most recently updated.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDimensionOutput`](crate::output::UpdateDimensionOutput)
        pub fn build(self) -> crate::output::UpdateDimensionOutput {
            crate::output::UpdateDimensionOutput {
                name: self.name,
                arn: self.arn,
                r#type: self.r#type,
                string_values: self.string_values,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl UpdateDimensionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDimensionOutput`](crate::output::UpdateDimensionOutput)
    pub fn builder() -> crate::output::update_dimension_output::Builder {
        crate::output::update_dimension_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomMetricOutput {
    /// <p> The name of the custom metric. </p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    pub metric_arn: std::option::Option<std::string::String>,
    /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    pub metric_type: std::option::Option<crate::model::CustomMetricType>,
    /// <p> A friendly name in the console for the custom metric </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateCustomMetricOutput {
    /// <p> The name of the custom metric. </p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    pub fn metric_arn(&self) -> std::option::Option<&str> {
        self.metric_arn.as_deref()
    }
    /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    pub fn metric_type(&self) -> std::option::Option<&crate::model::CustomMetricType> {
        self.metric_type.as_ref()
    }
    /// <p> A friendly name in the console for the custom metric </p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for UpdateCustomMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomMetricOutput");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_arn", &self.metric_arn);
        formatter.field("metric_type", &self.metric_type);
        formatter.field("display_name", &self.display_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`UpdateCustomMetricOutput`](crate::output::UpdateCustomMetricOutput)
pub mod update_custom_metric_output {
    /// A builder for [`UpdateCustomMetricOutput`](crate::output::UpdateCustomMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_arn: std::option::Option<std::string::String>,
        pub(crate) metric_type: std::option::Option<crate::model::CustomMetricType>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
        pub fn metric_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
        pub fn set_metric_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_arn = input;
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn metric_type(mut self, input: crate::model::CustomMetricType) -> Self {
            self.metric_type = Some(input);
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn set_metric_type(
            mut self,
            input: std::option::Option<crate::model::CustomMetricType>,
        ) -> Self {
            self.metric_type = input;
            self
        }
        /// <p> A friendly name in the console for the custom metric </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p> A friendly name in the console for the custom metric </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomMetricOutput`](crate::output::UpdateCustomMetricOutput)
        pub fn build(self) -> crate::output::UpdateCustomMetricOutput {
            crate::output::UpdateCustomMetricOutput {
                metric_name: self.metric_name,
                metric_arn: self.metric_arn,
                metric_type: self.metric_type,
                display_name: self.display_name,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl UpdateCustomMetricOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCustomMetricOutput`](crate::output::UpdateCustomMetricOutput)
    pub fn builder() -> crate::output::update_custom_metric_output::Builder {
        crate::output::update_custom_metric_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCertificateOutput {}
impl std::fmt::Debug for UpdateCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCertificateOutput");
        formatter.finish()
    }
}
/// See [`UpdateCertificateOutput`](crate::output::UpdateCertificateOutput)
pub mod update_certificate_output {
    /// A builder for [`UpdateCertificateOutput`](crate::output::UpdateCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateCertificateOutput`](crate::output::UpdateCertificateOutput)
        pub fn build(self) -> crate::output::UpdateCertificateOutput {
            crate::output::UpdateCertificateOutput {}
        }
    }
}
impl UpdateCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCertificateOutput`](crate::output::UpdateCertificateOutput)
    pub fn builder() -> crate::output::update_certificate_output::Builder {
        crate::output::update_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCaCertificateOutput {}
impl std::fmt::Debug for UpdateCaCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCaCertificateOutput");
        formatter.finish()
    }
}
/// See [`UpdateCaCertificateOutput`](crate::output::UpdateCaCertificateOutput)
pub mod update_ca_certificate_output {
    /// A builder for [`UpdateCaCertificateOutput`](crate::output::UpdateCaCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateCaCertificateOutput`](crate::output::UpdateCaCertificateOutput)
        pub fn build(self) -> crate::output::UpdateCaCertificateOutput {
            crate::output::UpdateCaCertificateOutput {}
        }
    }
}
impl UpdateCaCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCaCertificateOutput`](crate::output::UpdateCaCertificateOutput)
    pub fn builder() -> crate::output::update_ca_certificate_output::Builder {
        crate::output::update_ca_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBillingGroupOutput {
    /// <p>The latest version of the billing group.</p>
    pub version: i64,
}
impl UpdateBillingGroupOutput {
    /// <p>The latest version of the billing group.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
}
impl std::fmt::Debug for UpdateBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBillingGroupOutput");
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
pub mod update_billing_group_output {
    /// A builder for [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The latest version of the billing group.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The latest version of the billing group.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
        pub fn build(self) -> crate::output::UpdateBillingGroupOutput {
            crate::output::UpdateBillingGroupOutput {
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl UpdateBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput)
    pub fn builder() -> crate::output::update_billing_group_output::Builder {
        crate::output::update_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAuthorizerOutput {
    /// <p>The authorizer name.</p>
    pub authorizer_name: std::option::Option<std::string::String>,
    /// <p>The authorizer ARN.</p>
    pub authorizer_arn: std::option::Option<std::string::String>,
}
impl UpdateAuthorizerOutput {
    /// <p>The authorizer name.</p>
    pub fn authorizer_name(&self) -> std::option::Option<&str> {
        self.authorizer_name.as_deref()
    }
    /// <p>The authorizer ARN.</p>
    pub fn authorizer_arn(&self) -> std::option::Option<&str> {
        self.authorizer_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAuthorizerOutput");
        formatter.field("authorizer_name", &self.authorizer_name);
        formatter.field("authorizer_arn", &self.authorizer_arn);
        formatter.finish()
    }
}
/// See [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
pub mod update_authorizer_output {
    /// A builder for [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_name: std::option::Option<std::string::String>,
        pub(crate) authorizer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The authorizer name.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_name = Some(input.into());
            self
        }
        /// <p>The authorizer name.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_name = input;
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn authorizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_arn = Some(input.into());
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn set_authorizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
        pub fn build(self) -> crate::output::UpdateAuthorizerOutput {
            crate::output::UpdateAuthorizerOutput {
                authorizer_name: self.authorizer_name,
                authorizer_arn: self.authorizer_arn,
            }
        }
    }
}
impl UpdateAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput)
    pub fn builder() -> crate::output::update_authorizer_output::Builder {
        crate::output::update_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAuditSuppressionOutput {}
impl std::fmt::Debug for UpdateAuditSuppressionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAuditSuppressionOutput");
        formatter.finish()
    }
}
/// See [`UpdateAuditSuppressionOutput`](crate::output::UpdateAuditSuppressionOutput)
pub mod update_audit_suppression_output {
    /// A builder for [`UpdateAuditSuppressionOutput`](crate::output::UpdateAuditSuppressionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAuditSuppressionOutput`](crate::output::UpdateAuditSuppressionOutput)
        pub fn build(self) -> crate::output::UpdateAuditSuppressionOutput {
            crate::output::UpdateAuditSuppressionOutput {}
        }
    }
}
impl UpdateAuditSuppressionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAuditSuppressionOutput`](crate::output::UpdateAuditSuppressionOutput)
    pub fn builder() -> crate::output::update_audit_suppression_output::Builder {
        crate::output::update_audit_suppression_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountAuditConfigurationOutput {}
impl std::fmt::Debug for UpdateAccountAuditConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountAuditConfigurationOutput");
        formatter.finish()
    }
}
/// See [`UpdateAccountAuditConfigurationOutput`](crate::output::UpdateAccountAuditConfigurationOutput)
pub mod update_account_audit_configuration_output {
    /// A builder for [`UpdateAccountAuditConfigurationOutput`](crate::output::UpdateAccountAuditConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAccountAuditConfigurationOutput`](crate::output::UpdateAccountAuditConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateAccountAuditConfigurationOutput {
            crate::output::UpdateAccountAuditConfigurationOutput {}
        }
    }
}
impl UpdateAccountAuditConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccountAuditConfigurationOutput`](crate::output::UpdateAccountAuditConfigurationOutput)
    pub fn builder() -> crate::output::update_account_audit_configuration_output::Builder {
        crate::output::update_account_audit_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

/// <p>The output from the TransferCertificate operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransferCertificateOutput {
    /// <p>The ARN of the certificate.</p>
    pub transferred_certificate_arn: std::option::Option<std::string::String>,
}
impl TransferCertificateOutput {
    /// <p>The ARN of the certificate.</p>
    pub fn transferred_certificate_arn(&self) -> std::option::Option<&str> {
        self.transferred_certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for TransferCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransferCertificateOutput");
        formatter.field(
            "transferred_certificate_arn",
            &self.transferred_certificate_arn,
        );
        formatter.finish()
    }
}
/// See [`TransferCertificateOutput`](crate::output::TransferCertificateOutput)
pub mod transfer_certificate_output {
    /// A builder for [`TransferCertificateOutput`](crate::output::TransferCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transferred_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the certificate.</p>
        pub fn transferred_certificate_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transferred_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the certificate.</p>
        pub fn set_transferred_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transferred_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`TransferCertificateOutput`](crate::output::TransferCertificateOutput)
        pub fn build(self) -> crate::output::TransferCertificateOutput {
            crate::output::TransferCertificateOutput {
                transferred_certificate_arn: self.transferred_certificate_arn,
            }
        }
    }
}
impl TransferCertificateOutput {
    /// Creates a new builder-style object to manufacture [`TransferCertificateOutput`](crate::output::TransferCertificateOutput)
    pub fn builder() -> crate::output::transfer_certificate_output::Builder {
        crate::output::transfer_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestInvokeAuthorizerOutput {
    /// <p>True if the token is authenticated, otherwise false.</p>
    pub is_authenticated: std::option::Option<bool>,
    /// <p>The principal ID.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>IAM policy documents.</p>
    pub policy_documents: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of seconds after which the temporary credentials are refreshed.</p>
    pub refresh_after_in_seconds: std::option::Option<i32>,
    /// <p>The number of seconds after which the connection is terminated.</p>
    pub disconnect_after_in_seconds: std::option::Option<i32>,
}
impl TestInvokeAuthorizerOutput {
    /// <p>True if the token is authenticated, otherwise false.</p>
    pub fn is_authenticated(&self) -> std::option::Option<bool> {
        self.is_authenticated
    }
    /// <p>The principal ID.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>IAM policy documents.</p>
    pub fn policy_documents(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_documents.as_deref()
    }
    /// <p>The number of seconds after which the temporary credentials are refreshed.</p>
    pub fn refresh_after_in_seconds(&self) -> std::option::Option<i32> {
        self.refresh_after_in_seconds
    }
    /// <p>The number of seconds after which the connection is terminated.</p>
    pub fn disconnect_after_in_seconds(&self) -> std::option::Option<i32> {
        self.disconnect_after_in_seconds
    }
}
impl std::fmt::Debug for TestInvokeAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestInvokeAuthorizerOutput");
        formatter.field("is_authenticated", &self.is_authenticated);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("policy_documents", &self.policy_documents);
        formatter.field("refresh_after_in_seconds", &self.refresh_after_in_seconds);
        formatter.field(
            "disconnect_after_in_seconds",
            &self.disconnect_after_in_seconds,
        );
        formatter.finish()
    }
}
/// See [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
pub mod test_invoke_authorizer_output {
    /// A builder for [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_authenticated: std::option::Option<bool>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) policy_documents: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) refresh_after_in_seconds: std::option::Option<i32>,
        pub(crate) disconnect_after_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>True if the token is authenticated, otherwise false.</p>
        pub fn is_authenticated(mut self, input: bool) -> Self {
            self.is_authenticated = Some(input);
            self
        }
        /// <p>True if the token is authenticated, otherwise false.</p>
        pub fn set_is_authenticated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_authenticated = input;
            self
        }
        /// <p>The principal ID.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Appends an item to `policy_documents`.
        ///
        /// To override the contents of this collection use [`set_policy_documents`](Self::set_policy_documents).
        ///
        /// <p>IAM policy documents.</p>
        pub fn policy_documents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_documents.unwrap_or_default();
            v.push(input.into());
            self.policy_documents = Some(v);
            self
        }
        /// <p>IAM policy documents.</p>
        pub fn set_policy_documents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_documents = input;
            self
        }
        /// <p>The number of seconds after which the temporary credentials are refreshed.</p>
        pub fn refresh_after_in_seconds(mut self, input: i32) -> Self {
            self.refresh_after_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds after which the temporary credentials are refreshed.</p>
        pub fn set_refresh_after_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.refresh_after_in_seconds = input;
            self
        }
        /// <p>The number of seconds after which the connection is terminated.</p>
        pub fn disconnect_after_in_seconds(mut self, input: i32) -> Self {
            self.disconnect_after_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds after which the connection is terminated.</p>
        pub fn set_disconnect_after_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.disconnect_after_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
        pub fn build(self) -> crate::output::TestInvokeAuthorizerOutput {
            crate::output::TestInvokeAuthorizerOutput {
                is_authenticated: self.is_authenticated,
                principal_id: self.principal_id,
                policy_documents: self.policy_documents,
                refresh_after_in_seconds: self.refresh_after_in_seconds,
                disconnect_after_in_seconds: self.disconnect_after_in_seconds,
            }
        }
    }
}
impl TestInvokeAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput)
    pub fn builder() -> crate::output::test_invoke_authorizer_output::Builder {
        crate::output::test_invoke_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestAuthorizationOutput {
    /// <p>The authentication results.</p>
    pub auth_results: std::option::Option<std::vec::Vec<crate::model::AuthResult>>,
}
impl TestAuthorizationOutput {
    /// <p>The authentication results.</p>
    pub fn auth_results(&self) -> std::option::Option<&[crate::model::AuthResult]> {
        self.auth_results.as_deref()
    }
}
impl std::fmt::Debug for TestAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestAuthorizationOutput");
        formatter.field("auth_results", &self.auth_results);
        formatter.finish()
    }
}
/// See [`TestAuthorizationOutput`](crate::output::TestAuthorizationOutput)
pub mod test_authorization_output {
    /// A builder for [`TestAuthorizationOutput`](crate::output::TestAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_results: std::option::Option<std::vec::Vec<crate::model::AuthResult>>,
    }
    impl Builder {
        /// Appends an item to `auth_results`.
        ///
        /// To override the contents of this collection use [`set_auth_results`](Self::set_auth_results).
        ///
        /// <p>The authentication results.</p>
        pub fn auth_results(mut self, input: crate::model::AuthResult) -> Self {
            let mut v = self.auth_results.unwrap_or_default();
            v.push(input);
            self.auth_results = Some(v);
            self
        }
        /// <p>The authentication results.</p>
        pub fn set_auth_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthResult>>,
        ) -> Self {
            self.auth_results = input;
            self
        }
        /// Consumes the builder and constructs a [`TestAuthorizationOutput`](crate::output::TestAuthorizationOutput)
        pub fn build(self) -> crate::output::TestAuthorizationOutput {
            crate::output::TestAuthorizationOutput {
                auth_results: self.auth_results,
            }
        }
    }
}
impl TestAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`TestAuthorizationOutput`](crate::output::TestAuthorizationOutput)
    pub fn builder() -> crate::output::test_authorization_output::Builder {
        crate::output::test_authorization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopThingRegistrationTaskOutput {}
impl std::fmt::Debug for StopThingRegistrationTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopThingRegistrationTaskOutput");
        formatter.finish()
    }
}
/// See [`StopThingRegistrationTaskOutput`](crate::output::StopThingRegistrationTaskOutput)
pub mod stop_thing_registration_task_output {
    /// A builder for [`StopThingRegistrationTaskOutput`](crate::output::StopThingRegistrationTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopThingRegistrationTaskOutput`](crate::output::StopThingRegistrationTaskOutput)
        pub fn build(self) -> crate::output::StopThingRegistrationTaskOutput {
            crate::output::StopThingRegistrationTaskOutput {}
        }
    }
}
impl StopThingRegistrationTaskOutput {
    /// Creates a new builder-style object to manufacture [`StopThingRegistrationTaskOutput`](crate::output::StopThingRegistrationTaskOutput)
    pub fn builder() -> crate::output::stop_thing_registration_task_output::Builder {
        crate::output::stop_thing_registration_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartThingRegistrationTaskOutput {
    /// <p>The bulk thing provisioning task ID.</p>
    pub task_id: std::option::Option<std::string::String>,
}
impl StartThingRegistrationTaskOutput {
    /// <p>The bulk thing provisioning task ID.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
}
impl std::fmt::Debug for StartThingRegistrationTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartThingRegistrationTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}
/// See [`StartThingRegistrationTaskOutput`](crate::output::StartThingRegistrationTaskOutput)
pub mod start_thing_registration_task_output {
    /// A builder for [`StartThingRegistrationTaskOutput`](crate::output::StartThingRegistrationTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bulk thing provisioning task ID.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The bulk thing provisioning task ID.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartThingRegistrationTaskOutput`](crate::output::StartThingRegistrationTaskOutput)
        pub fn build(self) -> crate::output::StartThingRegistrationTaskOutput {
            crate::output::StartThingRegistrationTaskOutput {
                task_id: self.task_id,
            }
        }
    }
}
impl StartThingRegistrationTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartThingRegistrationTaskOutput`](crate::output::StartThingRegistrationTaskOutput)
    pub fn builder() -> crate::output::start_thing_registration_task_output::Builder {
        crate::output::start_thing_registration_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartOnDemandAuditTaskOutput {
    /// <p>The ID of the on-demand audit you started.</p>
    pub task_id: std::option::Option<std::string::String>,
}
impl StartOnDemandAuditTaskOutput {
    /// <p>The ID of the on-demand audit you started.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
}
impl std::fmt::Debug for StartOnDemandAuditTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartOnDemandAuditTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}
/// See [`StartOnDemandAuditTaskOutput`](crate::output::StartOnDemandAuditTaskOutput)
pub mod start_on_demand_audit_task_output {
    /// A builder for [`StartOnDemandAuditTaskOutput`](crate::output::StartOnDemandAuditTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the on-demand audit you started.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the on-demand audit you started.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartOnDemandAuditTaskOutput`](crate::output::StartOnDemandAuditTaskOutput)
        pub fn build(self) -> crate::output::StartOnDemandAuditTaskOutput {
            crate::output::StartOnDemandAuditTaskOutput {
                task_id: self.task_id,
            }
        }
    }
}
impl StartOnDemandAuditTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartOnDemandAuditTaskOutput`](crate::output::StartOnDemandAuditTaskOutput)
    pub fn builder() -> crate::output::start_on_demand_audit_task_output::Builder {
        crate::output::start_on_demand_audit_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDetectMitigationActionsTaskOutput {
    /// <p> The unique identifier of the task. </p>
    pub task_id: std::option::Option<std::string::String>,
}
impl StartDetectMitigationActionsTaskOutput {
    /// <p> The unique identifier of the task. </p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
}
impl std::fmt::Debug for StartDetectMitigationActionsTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDetectMitigationActionsTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}
/// See [`StartDetectMitigationActionsTaskOutput`](crate::output::StartDetectMitigationActionsTaskOutput)
pub mod start_detect_mitigation_actions_task_output {
    /// A builder for [`StartDetectMitigationActionsTaskOutput`](crate::output::StartDetectMitigationActionsTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDetectMitigationActionsTaskOutput`](crate::output::StartDetectMitigationActionsTaskOutput)
        pub fn build(self) -> crate::output::StartDetectMitigationActionsTaskOutput {
            crate::output::StartDetectMitigationActionsTaskOutput {
                task_id: self.task_id,
            }
        }
    }
}
impl StartDetectMitigationActionsTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartDetectMitigationActionsTaskOutput`](crate::output::StartDetectMitigationActionsTaskOutput)
    pub fn builder() -> crate::output::start_detect_mitigation_actions_task_output::Builder {
        crate::output::start_detect_mitigation_actions_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAuditMitigationActionsTaskOutput {
    /// <p>The unique identifier for the audit mitigation task. This matches the <code>taskId</code> that you specified in the request.</p>
    pub task_id: std::option::Option<std::string::String>,
}
impl StartAuditMitigationActionsTaskOutput {
    /// <p>The unique identifier for the audit mitigation task. This matches the <code>taskId</code> that you specified in the request.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
}
impl std::fmt::Debug for StartAuditMitigationActionsTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAuditMitigationActionsTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}
/// See [`StartAuditMitigationActionsTaskOutput`](crate::output::StartAuditMitigationActionsTaskOutput)
pub mod start_audit_mitigation_actions_task_output {
    /// A builder for [`StartAuditMitigationActionsTaskOutput`](crate::output::StartAuditMitigationActionsTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the audit mitigation task. This matches the <code>taskId</code> that you specified in the request.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the audit mitigation task. This matches the <code>taskId</code> that you specified in the request.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAuditMitigationActionsTaskOutput`](crate::output::StartAuditMitigationActionsTaskOutput)
        pub fn build(self) -> crate::output::StartAuditMitigationActionsTaskOutput {
            crate::output::StartAuditMitigationActionsTaskOutput {
                task_id: self.task_id,
            }
        }
    }
}
impl StartAuditMitigationActionsTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartAuditMitigationActionsTaskOutput`](crate::output::StartAuditMitigationActionsTaskOutput)
    pub fn builder() -> crate::output::start_audit_mitigation_actions_task_output::Builder {
        crate::output::start_audit_mitigation_actions_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetV2LoggingOptionsOutput {}
impl std::fmt::Debug for SetV2LoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetV2LoggingOptionsOutput");
        formatter.finish()
    }
}
/// See [`SetV2LoggingOptionsOutput`](crate::output::SetV2LoggingOptionsOutput)
pub mod set_v2_logging_options_output {
    /// A builder for [`SetV2LoggingOptionsOutput`](crate::output::SetV2LoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetV2LoggingOptionsOutput`](crate::output::SetV2LoggingOptionsOutput)
        pub fn build(self) -> crate::output::SetV2LoggingOptionsOutput {
            crate::output::SetV2LoggingOptionsOutput {}
        }
    }
}
impl SetV2LoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`SetV2LoggingOptionsOutput`](crate::output::SetV2LoggingOptionsOutput)
    pub fn builder() -> crate::output::set_v2_logging_options_output::Builder {
        crate::output::set_v2_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetV2LoggingLevelOutput {}
impl std::fmt::Debug for SetV2LoggingLevelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetV2LoggingLevelOutput");
        formatter.finish()
    }
}
/// See [`SetV2LoggingLevelOutput`](crate::output::SetV2LoggingLevelOutput)
pub mod set_v2_logging_level_output {
    /// A builder for [`SetV2LoggingLevelOutput`](crate::output::SetV2LoggingLevelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetV2LoggingLevelOutput`](crate::output::SetV2LoggingLevelOutput)
        pub fn build(self) -> crate::output::SetV2LoggingLevelOutput {
            crate::output::SetV2LoggingLevelOutput {}
        }
    }
}
impl SetV2LoggingLevelOutput {
    /// Creates a new builder-style object to manufacture [`SetV2LoggingLevelOutput`](crate::output::SetV2LoggingLevelOutput)
    pub fn builder() -> crate::output::set_v2_logging_level_output::Builder {
        crate::output::set_v2_logging_level_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetLoggingOptionsOutput {}
impl std::fmt::Debug for SetLoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetLoggingOptionsOutput");
        formatter.finish()
    }
}
/// See [`SetLoggingOptionsOutput`](crate::output::SetLoggingOptionsOutput)
pub mod set_logging_options_output {
    /// A builder for [`SetLoggingOptionsOutput`](crate::output::SetLoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetLoggingOptionsOutput`](crate::output::SetLoggingOptionsOutput)
        pub fn build(self) -> crate::output::SetLoggingOptionsOutput {
            crate::output::SetLoggingOptionsOutput {}
        }
    }
}
impl SetLoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`SetLoggingOptionsOutput`](crate::output::SetLoggingOptionsOutput)
    pub fn builder() -> crate::output::set_logging_options_output::Builder {
        crate::output::set_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDefaultPolicyVersionOutput {}
impl std::fmt::Debug for SetDefaultPolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDefaultPolicyVersionOutput");
        formatter.finish()
    }
}
/// See [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
pub mod set_default_policy_version_output {
    /// A builder for [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
        pub fn build(self) -> crate::output::SetDefaultPolicyVersionOutput {
            crate::output::SetDefaultPolicyVersionOutput {}
        }
    }
}
impl SetDefaultPolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
    pub fn builder() -> crate::output::set_default_policy_version_output::Builder {
        crate::output::set_default_policy_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDefaultAuthorizerOutput {
    /// <p>The authorizer name.</p>
    pub authorizer_name: std::option::Option<std::string::String>,
    /// <p>The authorizer ARN.</p>
    pub authorizer_arn: std::option::Option<std::string::String>,
}
impl SetDefaultAuthorizerOutput {
    /// <p>The authorizer name.</p>
    pub fn authorizer_name(&self) -> std::option::Option<&str> {
        self.authorizer_name.as_deref()
    }
    /// <p>The authorizer ARN.</p>
    pub fn authorizer_arn(&self) -> std::option::Option<&str> {
        self.authorizer_arn.as_deref()
    }
}
impl std::fmt::Debug for SetDefaultAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDefaultAuthorizerOutput");
        formatter.field("authorizer_name", &self.authorizer_name);
        formatter.field("authorizer_arn", &self.authorizer_arn);
        formatter.finish()
    }
}
/// See [`SetDefaultAuthorizerOutput`](crate::output::SetDefaultAuthorizerOutput)
pub mod set_default_authorizer_output {
    /// A builder for [`SetDefaultAuthorizerOutput`](crate::output::SetDefaultAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_name: std::option::Option<std::string::String>,
        pub(crate) authorizer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The authorizer name.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_name = Some(input.into());
            self
        }
        /// <p>The authorizer name.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_name = input;
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn authorizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_arn = Some(input.into());
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn set_authorizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDefaultAuthorizerOutput`](crate::output::SetDefaultAuthorizerOutput)
        pub fn build(self) -> crate::output::SetDefaultAuthorizerOutput {
            crate::output::SetDefaultAuthorizerOutput {
                authorizer_name: self.authorizer_name,
                authorizer_arn: self.authorizer_arn,
            }
        }
    }
}
impl SetDefaultAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`SetDefaultAuthorizerOutput`](crate::output::SetDefaultAuthorizerOutput)
    pub fn builder() -> crate::output::set_default_authorizer_output::Builder {
        crate::output::set_default_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchIndexOutput {
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The things that match the search query.</p>
    pub things: std::option::Option<std::vec::Vec<crate::model::ThingDocument>>,
    /// <p>The thing groups that match the search query.</p>
    pub thing_groups: std::option::Option<std::vec::Vec<crate::model::ThingGroupDocument>>,
}
impl SearchIndexOutput {
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The things that match the search query.</p>
    pub fn things(&self) -> std::option::Option<&[crate::model::ThingDocument]> {
        self.things.as_deref()
    }
    /// <p>The thing groups that match the search query.</p>
    pub fn thing_groups(&self) -> std::option::Option<&[crate::model::ThingGroupDocument]> {
        self.thing_groups.as_deref()
    }
}
impl std::fmt::Debug for SearchIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchIndexOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("things", &self.things);
        formatter.field("thing_groups", &self.thing_groups);
        formatter.finish()
    }
}
/// See [`SearchIndexOutput`](crate::output::SearchIndexOutput)
pub mod search_index_output {
    /// A builder for [`SearchIndexOutput`](crate::output::SearchIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) things: std::option::Option<std::vec::Vec<crate::model::ThingDocument>>,
        pub(crate) thing_groups:
            std::option::Option<std::vec::Vec<crate::model::ThingGroupDocument>>,
    }
    impl Builder {
        /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `things`.
        ///
        /// To override the contents of this collection use [`set_things`](Self::set_things).
        ///
        /// <p>The things that match the search query.</p>
        pub fn things(mut self, input: crate::model::ThingDocument) -> Self {
            let mut v = self.things.unwrap_or_default();
            v.push(input);
            self.things = Some(v);
            self
        }
        /// <p>The things that match the search query.</p>
        pub fn set_things(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThingDocument>>,
        ) -> Self {
            self.things = input;
            self
        }
        /// Appends an item to `thing_groups`.
        ///
        /// To override the contents of this collection use [`set_thing_groups`](Self::set_thing_groups).
        ///
        /// <p>The thing groups that match the search query.</p>
        pub fn thing_groups(mut self, input: crate::model::ThingGroupDocument) -> Self {
            let mut v = self.thing_groups.unwrap_or_default();
            v.push(input);
            self.thing_groups = Some(v);
            self
        }
        /// <p>The thing groups that match the search query.</p>
        pub fn set_thing_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThingGroupDocument>>,
        ) -> Self {
            self.thing_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchIndexOutput`](crate::output::SearchIndexOutput)
        pub fn build(self) -> crate::output::SearchIndexOutput {
            crate::output::SearchIndexOutput {
                next_token: self.next_token,
                things: self.things,
                thing_groups: self.thing_groups,
            }
        }
    }
}
impl SearchIndexOutput {
    /// Creates a new builder-style object to manufacture [`SearchIndexOutput`](crate::output::SearchIndexOutput)
    pub fn builder() -> crate::output::search_index_output::Builder {
        crate::output::search_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplaceTopicRuleOutput {}
impl std::fmt::Debug for ReplaceTopicRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplaceTopicRuleOutput");
        formatter.finish()
    }
}
/// See [`ReplaceTopicRuleOutput`](crate::output::ReplaceTopicRuleOutput)
pub mod replace_topic_rule_output {
    /// A builder for [`ReplaceTopicRuleOutput`](crate::output::ReplaceTopicRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ReplaceTopicRuleOutput`](crate::output::ReplaceTopicRuleOutput)
        pub fn build(self) -> crate::output::ReplaceTopicRuleOutput {
            crate::output::ReplaceTopicRuleOutput {}
        }
    }
}
impl ReplaceTopicRuleOutput {
    /// Creates a new builder-style object to manufacture [`ReplaceTopicRuleOutput`](crate::output::ReplaceTopicRuleOutput)
    pub fn builder() -> crate::output::replace_topic_rule_output::Builder {
        crate::output::replace_topic_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveThingFromThingGroupOutput {}
impl std::fmt::Debug for RemoveThingFromThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveThingFromThingGroupOutput");
        formatter.finish()
    }
}
/// See [`RemoveThingFromThingGroupOutput`](crate::output::RemoveThingFromThingGroupOutput)
pub mod remove_thing_from_thing_group_output {
    /// A builder for [`RemoveThingFromThingGroupOutput`](crate::output::RemoveThingFromThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveThingFromThingGroupOutput`](crate::output::RemoveThingFromThingGroupOutput)
        pub fn build(self) -> crate::output::RemoveThingFromThingGroupOutput {
            crate::output::RemoveThingFromThingGroupOutput {}
        }
    }
}
impl RemoveThingFromThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`RemoveThingFromThingGroupOutput`](crate::output::RemoveThingFromThingGroupOutput)
    pub fn builder() -> crate::output::remove_thing_from_thing_group_output::Builder {
        crate::output::remove_thing_from_thing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveThingFromBillingGroupOutput {}
impl std::fmt::Debug for RemoveThingFromBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveThingFromBillingGroupOutput");
        formatter.finish()
    }
}
/// See [`RemoveThingFromBillingGroupOutput`](crate::output::RemoveThingFromBillingGroupOutput)
pub mod remove_thing_from_billing_group_output {
    /// A builder for [`RemoveThingFromBillingGroupOutput`](crate::output::RemoveThingFromBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveThingFromBillingGroupOutput`](crate::output::RemoveThingFromBillingGroupOutput)
        pub fn build(self) -> crate::output::RemoveThingFromBillingGroupOutput {
            crate::output::RemoveThingFromBillingGroupOutput {}
        }
    }
}
impl RemoveThingFromBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`RemoveThingFromBillingGroupOutput`](crate::output::RemoveThingFromBillingGroupOutput)
    pub fn builder() -> crate::output::remove_thing_from_billing_group_output::Builder {
        crate::output::remove_thing_from_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectCertificateTransferOutput {}
impl std::fmt::Debug for RejectCertificateTransferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectCertificateTransferOutput");
        formatter.finish()
    }
}
/// See [`RejectCertificateTransferOutput`](crate::output::RejectCertificateTransferOutput)
pub mod reject_certificate_transfer_output {
    /// A builder for [`RejectCertificateTransferOutput`](crate::output::RejectCertificateTransferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RejectCertificateTransferOutput`](crate::output::RejectCertificateTransferOutput)
        pub fn build(self) -> crate::output::RejectCertificateTransferOutput {
            crate::output::RejectCertificateTransferOutput {}
        }
    }
}
impl RejectCertificateTransferOutput {
    /// Creates a new builder-style object to manufacture [`RejectCertificateTransferOutput`](crate::output::RejectCertificateTransferOutput)
    pub fn builder() -> crate::output::reject_certificate_transfer_output::Builder {
        crate::output::reject_certificate_transfer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterThingOutput {
    /// <p>The certificate data, in PEM format.</p>
    pub certificate_pem: std::option::Option<std::string::String>,
    /// <p>ARNs for the generated resources.</p>
    pub resource_arns:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl RegisterThingOutput {
    /// <p>The certificate data, in PEM format.</p>
    pub fn certificate_pem(&self) -> std::option::Option<&str> {
        self.certificate_pem.as_deref()
    }
    /// <p>ARNs for the generated resources.</p>
    pub fn resource_arns(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_arns.as_ref()
    }
}
impl std::fmt::Debug for RegisterThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterThingOutput");
        formatter.field("certificate_pem", &self.certificate_pem);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.finish()
    }
}
/// See [`RegisterThingOutput`](crate::output::RegisterThingOutput)
pub mod register_thing_output {
    /// A builder for [`RegisterThingOutput`](crate::output::RegisterThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_pem: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The certificate data, in PEM format.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_pem = Some(input.into());
            self
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_pem = input;
            self
        }
        /// Adds a key-value pair to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>ARNs for the generated resources.</p>
        pub fn resource_arns(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_arns.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_arns = Some(hash_map);
            self
        }
        /// <p>ARNs for the generated resources.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterThingOutput`](crate::output::RegisterThingOutput)
        pub fn build(self) -> crate::output::RegisterThingOutput {
            crate::output::RegisterThingOutput {
                certificate_pem: self.certificate_pem,
                resource_arns: self.resource_arns,
            }
        }
    }
}
impl RegisterThingOutput {
    /// Creates a new builder-style object to manufacture [`RegisterThingOutput`](crate::output::RegisterThingOutput)
    pub fn builder() -> crate::output::register_thing_output::Builder {
        crate::output::register_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterCertificateWithoutCaOutput {
    /// <p>The Amazon Resource Name (ARN) of the registered certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.</p>
    pub certificate_id: std::option::Option<std::string::String>,
}
impl RegisterCertificateWithoutCaOutput {
    /// <p>The Amazon Resource Name (ARN) of the registered certificate.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterCertificateWithoutCaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterCertificateWithoutCaOutput");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.finish()
    }
}
/// See [`RegisterCertificateWithoutCaOutput`](crate::output::RegisterCertificateWithoutCaOutput)
pub mod register_certificate_without_ca_output {
    /// A builder for [`RegisterCertificateWithoutCaOutput`](crate::output::RegisterCertificateWithoutCaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the registered certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registered certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterCertificateWithoutCaOutput`](crate::output::RegisterCertificateWithoutCaOutput)
        pub fn build(self) -> crate::output::RegisterCertificateWithoutCaOutput {
            crate::output::RegisterCertificateWithoutCaOutput {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
            }
        }
    }
}
impl RegisterCertificateWithoutCaOutput {
    /// Creates a new builder-style object to manufacture [`RegisterCertificateWithoutCaOutput`](crate::output::RegisterCertificateWithoutCaOutput)
    pub fn builder() -> crate::output::register_certificate_without_ca_output::Builder {
        crate::output::register_certificate_without_ca_output::Builder::default()
    }
}

/// <p>The output from the RegisterCertificate operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterCertificateOutput {
    /// <p>The certificate ARN.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The certificate identifier.</p>
    pub certificate_id: std::option::Option<std::string::String>,
}
impl RegisterCertificateOutput {
    /// <p>The certificate ARN.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The certificate identifier.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterCertificateOutput");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.finish()
    }
}
/// See [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
pub mod register_certificate_output {
    /// A builder for [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The certificate ARN.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The certificate ARN.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The certificate identifier.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The certificate identifier.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
        pub fn build(self) -> crate::output::RegisterCertificateOutput {
            crate::output::RegisterCertificateOutput {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
            }
        }
    }
}
impl RegisterCertificateOutput {
    /// Creates a new builder-style object to manufacture [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput)
    pub fn builder() -> crate::output::register_certificate_output::Builder {
        crate::output::register_certificate_output::Builder::default()
    }
}

/// <p>The output from the RegisterCACertificateResponse operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterCaCertificateOutput {
    /// <p>The CA certificate ARN.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The CA certificate identifier.</p>
    pub certificate_id: std::option::Option<std::string::String>,
}
impl RegisterCaCertificateOutput {
    /// <p>The CA certificate ARN.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The CA certificate identifier.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterCaCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterCaCertificateOutput");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.finish()
    }
}
/// See [`RegisterCaCertificateOutput`](crate::output::RegisterCaCertificateOutput)
pub mod register_ca_certificate_output {
    /// A builder for [`RegisterCaCertificateOutput`](crate::output::RegisterCaCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CA certificate ARN.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The CA certificate ARN.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The CA certificate identifier.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The CA certificate identifier.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterCaCertificateOutput`](crate::output::RegisterCaCertificateOutput)
        pub fn build(self) -> crate::output::RegisterCaCertificateOutput {
            crate::output::RegisterCaCertificateOutput {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
            }
        }
    }
}
impl RegisterCaCertificateOutput {
    /// Creates a new builder-style object to manufacture [`RegisterCaCertificateOutput`](crate::output::RegisterCaCertificateOutput)
    pub fn builder() -> crate::output::register_ca_certificate_output::Builder {
        crate::output::register_ca_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutVerificationStateOnViolationOutput {}
impl std::fmt::Debug for PutVerificationStateOnViolationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutVerificationStateOnViolationOutput");
        formatter.finish()
    }
}
/// See [`PutVerificationStateOnViolationOutput`](crate::output::PutVerificationStateOnViolationOutput)
pub mod put_verification_state_on_violation_output {
    /// A builder for [`PutVerificationStateOnViolationOutput`](crate::output::PutVerificationStateOnViolationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutVerificationStateOnViolationOutput`](crate::output::PutVerificationStateOnViolationOutput)
        pub fn build(self) -> crate::output::PutVerificationStateOnViolationOutput {
            crate::output::PutVerificationStateOnViolationOutput {}
        }
    }
}
impl PutVerificationStateOnViolationOutput {
    /// Creates a new builder-style object to manufacture [`PutVerificationStateOnViolationOutput`](crate::output::PutVerificationStateOnViolationOutput)
    pub fn builder() -> crate::output::put_verification_state_on_violation_output::Builder {
        crate::output::put_verification_state_on_violation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListViolationEventsOutput {
    /// <p>The security profile violation alerts issued for this account during the given time period, potentially filtered by security profile, behavior violated, or thing (device) violating.</p>
    pub violation_events: std::option::Option<std::vec::Vec<crate::model::ViolationEvent>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListViolationEventsOutput {
    /// <p>The security profile violation alerts issued for this account during the given time period, potentially filtered by security profile, behavior violated, or thing (device) violating.</p>
    pub fn violation_events(&self) -> std::option::Option<&[crate::model::ViolationEvent]> {
        self.violation_events.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListViolationEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListViolationEventsOutput");
        formatter.field("violation_events", &self.violation_events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListViolationEventsOutput`](crate::output::ListViolationEventsOutput)
pub mod list_violation_events_output {
    /// A builder for [`ListViolationEventsOutput`](crate::output::ListViolationEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_events:
            std::option::Option<std::vec::Vec<crate::model::ViolationEvent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `violation_events`.
        ///
        /// To override the contents of this collection use [`set_violation_events`](Self::set_violation_events).
        ///
        /// <p>The security profile violation alerts issued for this account during the given time period, potentially filtered by security profile, behavior violated, or thing (device) violating.</p>
        pub fn violation_events(mut self, input: crate::model::ViolationEvent) -> Self {
            let mut v = self.violation_events.unwrap_or_default();
            v.push(input);
            self.violation_events = Some(v);
            self
        }
        /// <p>The security profile violation alerts issued for this account during the given time period, potentially filtered by security profile, behavior violated, or thing (device) violating.</p>
        pub fn set_violation_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ViolationEvent>>,
        ) -> Self {
            self.violation_events = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListViolationEventsOutput`](crate::output::ListViolationEventsOutput)
        pub fn build(self) -> crate::output::ListViolationEventsOutput {
            crate::output::ListViolationEventsOutput {
                violation_events: self.violation_events,
                next_token: self.next_token,
            }
        }
    }
}
impl ListViolationEventsOutput {
    /// Creates a new builder-style object to manufacture [`ListViolationEventsOutput`](crate::output::ListViolationEventsOutput)
    pub fn builder() -> crate::output::list_violation_events_output::Builder {
        crate::output::list_violation_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListV2LoggingLevelsOutput {
    /// <p>The logging configuration for a target.</p>
    pub log_target_configurations:
        std::option::Option<std::vec::Vec<crate::model::LogTargetConfiguration>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListV2LoggingLevelsOutput {
    /// <p>The logging configuration for a target.</p>
    pub fn log_target_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LogTargetConfiguration]> {
        self.log_target_configurations.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListV2LoggingLevelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListV2LoggingLevelsOutput");
        formatter.field("log_target_configurations", &self.log_target_configurations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListV2LoggingLevelsOutput`](crate::output::ListV2LoggingLevelsOutput)
pub mod list_v2_logging_levels_output {
    /// A builder for [`ListV2LoggingLevelsOutput`](crate::output::ListV2LoggingLevelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_target_configurations:
            std::option::Option<std::vec::Vec<crate::model::LogTargetConfiguration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `log_target_configurations`.
        ///
        /// To override the contents of this collection use [`set_log_target_configurations`](Self::set_log_target_configurations).
        ///
        /// <p>The logging configuration for a target.</p>
        pub fn log_target_configurations(
            mut self,
            input: crate::model::LogTargetConfiguration,
        ) -> Self {
            let mut v = self.log_target_configurations.unwrap_or_default();
            v.push(input);
            self.log_target_configurations = Some(v);
            self
        }
        /// <p>The logging configuration for a target.</p>
        pub fn set_log_target_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogTargetConfiguration>>,
        ) -> Self {
            self.log_target_configurations = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListV2LoggingLevelsOutput`](crate::output::ListV2LoggingLevelsOutput)
        pub fn build(self) -> crate::output::ListV2LoggingLevelsOutput {
            crate::output::ListV2LoggingLevelsOutput {
                log_target_configurations: self.log_target_configurations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListV2LoggingLevelsOutput {
    /// Creates a new builder-style object to manufacture [`ListV2LoggingLevelsOutput`](crate::output::ListV2LoggingLevelsOutput)
    pub fn builder() -> crate::output::list_v2_logging_levels_output::Builder {
        crate::output::list_v2_logging_levels_output::Builder::default()
    }
}

/// <p>The output from the ListTopicRules operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTopicRulesOutput {
    /// <p>The rules.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::TopicRuleListItem>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTopicRulesOutput {
    /// <p>The rules.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::TopicRuleListItem]> {
        self.rules.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTopicRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTopicRulesOutput");
        formatter.field("rules", &self.rules);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTopicRulesOutput`](crate::output::ListTopicRulesOutput)
pub mod list_topic_rules_output {
    /// A builder for [`ListTopicRulesOutput`](crate::output::ListTopicRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::TopicRuleListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules.</p>
        pub fn rules(mut self, input: crate::model::TopicRuleListItem) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The rules.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicRuleListItem>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTopicRulesOutput`](crate::output::ListTopicRulesOutput)
        pub fn build(self) -> crate::output::ListTopicRulesOutput {
            crate::output::ListTopicRulesOutput {
                rules: self.rules,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTopicRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListTopicRulesOutput`](crate::output::ListTopicRulesOutput)
    pub fn builder() -> crate::output::list_topic_rules_output::Builder {
        crate::output::list_topic_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTopicRuleDestinationsOutput {
    /// <p>Information about a topic rule destination.</p>
    pub destination_summaries:
        std::option::Option<std::vec::Vec<crate::model::TopicRuleDestinationSummary>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTopicRuleDestinationsOutput {
    /// <p>Information about a topic rule destination.</p>
    pub fn destination_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::TopicRuleDestinationSummary]> {
        self.destination_summaries.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTopicRuleDestinationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTopicRuleDestinationsOutput");
        formatter.field("destination_summaries", &self.destination_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTopicRuleDestinationsOutput`](crate::output::ListTopicRuleDestinationsOutput)
pub mod list_topic_rule_destinations_output {
    /// A builder for [`ListTopicRuleDestinationsOutput`](crate::output::ListTopicRuleDestinationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_summaries:
            std::option::Option<std::vec::Vec<crate::model::TopicRuleDestinationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `destination_summaries`.
        ///
        /// To override the contents of this collection use [`set_destination_summaries`](Self::set_destination_summaries).
        ///
        /// <p>Information about a topic rule destination.</p>
        pub fn destination_summaries(
            mut self,
            input: crate::model::TopicRuleDestinationSummary,
        ) -> Self {
            let mut v = self.destination_summaries.unwrap_or_default();
            v.push(input);
            self.destination_summaries = Some(v);
            self
        }
        /// <p>Information about a topic rule destination.</p>
        pub fn set_destination_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicRuleDestinationSummary>>,
        ) -> Self {
            self.destination_summaries = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTopicRuleDestinationsOutput`](crate::output::ListTopicRuleDestinationsOutput)
        pub fn build(self) -> crate::output::ListTopicRuleDestinationsOutput {
            crate::output::ListTopicRuleDestinationsOutput {
                destination_summaries: self.destination_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTopicRuleDestinationsOutput {
    /// Creates a new builder-style object to manufacture [`ListTopicRuleDestinationsOutput`](crate::output::ListTopicRuleDestinationsOutput)
    pub fn builder() -> crate::output::list_topic_rule_destinations_output::Builder {
        crate::output::list_topic_rule_destinations_output::Builder::default()
    }
}

/// <p>The output for the ListThingTypes operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingTypesOutput {
    /// <p>The thing types.</p>
    pub thing_types: std::option::Option<std::vec::Vec<crate::model::ThingTypeDefinition>>,
    /// <p>The token for the next set of results. Will not be returned if operation has returned all results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingTypesOutput {
    /// <p>The thing types.</p>
    pub fn thing_types(&self) -> std::option::Option<&[crate::model::ThingTypeDefinition]> {
        self.thing_types.as_deref()
    }
    /// <p>The token for the next set of results. Will not be returned if operation has returned all results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingTypesOutput");
        formatter.field("thing_types", &self.thing_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingTypesOutput`](crate::output::ListThingTypesOutput)
pub mod list_thing_types_output {
    /// A builder for [`ListThingTypesOutput`](crate::output::ListThingTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_types:
            std::option::Option<std::vec::Vec<crate::model::ThingTypeDefinition>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `thing_types`.
        ///
        /// To override the contents of this collection use [`set_thing_types`](Self::set_thing_types).
        ///
        /// <p>The thing types.</p>
        pub fn thing_types(mut self, input: crate::model::ThingTypeDefinition) -> Self {
            let mut v = self.thing_types.unwrap_or_default();
            v.push(input);
            self.thing_types = Some(v);
            self
        }
        /// <p>The thing types.</p>
        pub fn set_thing_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThingTypeDefinition>>,
        ) -> Self {
            self.thing_types = input;
            self
        }
        /// <p>The token for the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingTypesOutput`](crate::output::ListThingTypesOutput)
        pub fn build(self) -> crate::output::ListThingTypesOutput {
            crate::output::ListThingTypesOutput {
                thing_types: self.thing_types,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListThingTypesOutput`](crate::output::ListThingTypesOutput)
    pub fn builder() -> crate::output::list_thing_types_output::Builder {
        crate::output::list_thing_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingsInThingGroupOutput {
    /// <p>The things in the specified thing group.</p>
    pub things: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingsInThingGroupOutput {
    /// <p>The things in the specified thing group.</p>
    pub fn things(&self) -> std::option::Option<&[std::string::String]> {
        self.things.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingsInThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingsInThingGroupOutput");
        formatter.field("things", &self.things);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingsInThingGroupOutput`](crate::output::ListThingsInThingGroupOutput)
pub mod list_things_in_thing_group_output {
    /// A builder for [`ListThingsInThingGroupOutput`](crate::output::ListThingsInThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) things: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `things`.
        ///
        /// To override the contents of this collection use [`set_things`](Self::set_things).
        ///
        /// <p>The things in the specified thing group.</p>
        pub fn things(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.things.unwrap_or_default();
            v.push(input.into());
            self.things = Some(v);
            self
        }
        /// <p>The things in the specified thing group.</p>
        pub fn set_things(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.things = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingsInThingGroupOutput`](crate::output::ListThingsInThingGroupOutput)
        pub fn build(self) -> crate::output::ListThingsInThingGroupOutput {
            crate::output::ListThingsInThingGroupOutput {
                things: self.things,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingsInThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`ListThingsInThingGroupOutput`](crate::output::ListThingsInThingGroupOutput)
    pub fn builder() -> crate::output::list_things_in_thing_group_output::Builder {
        crate::output::list_things_in_thing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingsInBillingGroupOutput {
    /// <p>A list of things in the billing group.</p>
    pub things: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingsInBillingGroupOutput {
    /// <p>A list of things in the billing group.</p>
    pub fn things(&self) -> std::option::Option<&[std::string::String]> {
        self.things.as_deref()
    }
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingsInBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingsInBillingGroupOutput");
        formatter.field("things", &self.things);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingsInBillingGroupOutput`](crate::output::ListThingsInBillingGroupOutput)
pub mod list_things_in_billing_group_output {
    /// A builder for [`ListThingsInBillingGroupOutput`](crate::output::ListThingsInBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) things: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `things`.
        ///
        /// To override the contents of this collection use [`set_things`](Self::set_things).
        ///
        /// <p>A list of things in the billing group.</p>
        pub fn things(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.things.unwrap_or_default();
            v.push(input.into());
            self.things = Some(v);
            self
        }
        /// <p>A list of things in the billing group.</p>
        pub fn set_things(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.things = input;
            self
        }
        /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingsInBillingGroupOutput`](crate::output::ListThingsInBillingGroupOutput)
        pub fn build(self) -> crate::output::ListThingsInBillingGroupOutput {
            crate::output::ListThingsInBillingGroupOutput {
                things: self.things,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingsInBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`ListThingsInBillingGroupOutput`](crate::output::ListThingsInBillingGroupOutput)
    pub fn builder() -> crate::output::list_things_in_billing_group_output::Builder {
        crate::output::list_things_in_billing_group_output::Builder::default()
    }
}

/// <p>The output from the ListThings operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingsOutput {
    /// <p>The things.</p>
    pub things: std::option::Option<std::vec::Vec<crate::model::ThingAttribute>>,
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingsOutput {
    /// <p>The things.</p>
    pub fn things(&self) -> std::option::Option<&[crate::model::ThingAttribute]> {
        self.things.as_deref()
    }
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingsOutput");
        formatter.field("things", &self.things);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingsOutput`](crate::output::ListThingsOutput)
pub mod list_things_output {
    /// A builder for [`ListThingsOutput`](crate::output::ListThingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) things: std::option::Option<std::vec::Vec<crate::model::ThingAttribute>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `things`.
        ///
        /// To override the contents of this collection use [`set_things`](Self::set_things).
        ///
        /// <p>The things.</p>
        pub fn things(mut self, input: crate::model::ThingAttribute) -> Self {
            let mut v = self.things.unwrap_or_default();
            v.push(input);
            self.things = Some(v);
            self
        }
        /// <p>The things.</p>
        pub fn set_things(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThingAttribute>>,
        ) -> Self {
            self.things = input;
            self
        }
        /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingsOutput`](crate::output::ListThingsOutput)
        pub fn build(self) -> crate::output::ListThingsOutput {
            crate::output::ListThingsOutput {
                things: self.things,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingsOutput {
    /// Creates a new builder-style object to manufacture [`ListThingsOutput`](crate::output::ListThingsOutput)
    pub fn builder() -> crate::output::list_things_output::Builder {
        crate::output::list_things_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingRegistrationTasksOutput {
    /// <p>A list of bulk thing provisioning task IDs.</p>
    pub task_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingRegistrationTasksOutput {
    /// <p>A list of bulk thing provisioning task IDs.</p>
    pub fn task_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.task_ids.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingRegistrationTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingRegistrationTasksOutput");
        formatter.field("task_ids", &self.task_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingRegistrationTasksOutput`](crate::output::ListThingRegistrationTasksOutput)
pub mod list_thing_registration_tasks_output {
    /// A builder for [`ListThingRegistrationTasksOutput`](crate::output::ListThingRegistrationTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `task_ids`.
        ///
        /// To override the contents of this collection use [`set_task_ids`](Self::set_task_ids).
        ///
        /// <p>A list of bulk thing provisioning task IDs.</p>
        pub fn task_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.task_ids.unwrap_or_default();
            v.push(input.into());
            self.task_ids = Some(v);
            self
        }
        /// <p>A list of bulk thing provisioning task IDs.</p>
        pub fn set_task_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.task_ids = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingRegistrationTasksOutput`](crate::output::ListThingRegistrationTasksOutput)
        pub fn build(self) -> crate::output::ListThingRegistrationTasksOutput {
            crate::output::ListThingRegistrationTasksOutput {
                task_ids: self.task_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingRegistrationTasksOutput {
    /// Creates a new builder-style object to manufacture [`ListThingRegistrationTasksOutput`](crate::output::ListThingRegistrationTasksOutput)
    pub fn builder() -> crate::output::list_thing_registration_tasks_output::Builder {
        crate::output::list_thing_registration_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingRegistrationTaskReportsOutput {
    /// <p>Links to the task resources.</p>
    pub resource_links: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of task report.</p>
    pub report_type: std::option::Option<crate::model::ReportType>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingRegistrationTaskReportsOutput {
    /// <p>Links to the task resources.</p>
    pub fn resource_links(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_links.as_deref()
    }
    /// <p>The type of task report.</p>
    pub fn report_type(&self) -> std::option::Option<&crate::model::ReportType> {
        self.report_type.as_ref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingRegistrationTaskReportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingRegistrationTaskReportsOutput");
        formatter.field("resource_links", &self.resource_links);
        formatter.field("report_type", &self.report_type);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingRegistrationTaskReportsOutput`](crate::output::ListThingRegistrationTaskReportsOutput)
pub mod list_thing_registration_task_reports_output {
    /// A builder for [`ListThingRegistrationTaskReportsOutput`](crate::output::ListThingRegistrationTaskReportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_links: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) report_type: std::option::Option<crate::model::ReportType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_links`.
        ///
        /// To override the contents of this collection use [`set_resource_links`](Self::set_resource_links).
        ///
        /// <p>Links to the task resources.</p>
        pub fn resource_links(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_links.unwrap_or_default();
            v.push(input.into());
            self.resource_links = Some(v);
            self
        }
        /// <p>Links to the task resources.</p>
        pub fn set_resource_links(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_links = input;
            self
        }
        /// <p>The type of task report.</p>
        pub fn report_type(mut self, input: crate::model::ReportType) -> Self {
            self.report_type = Some(input);
            self
        }
        /// <p>The type of task report.</p>
        pub fn set_report_type(
            mut self,
            input: std::option::Option<crate::model::ReportType>,
        ) -> Self {
            self.report_type = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingRegistrationTaskReportsOutput`](crate::output::ListThingRegistrationTaskReportsOutput)
        pub fn build(self) -> crate::output::ListThingRegistrationTaskReportsOutput {
            crate::output::ListThingRegistrationTaskReportsOutput {
                resource_links: self.resource_links,
                report_type: self.report_type,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingRegistrationTaskReportsOutput {
    /// Creates a new builder-style object to manufacture [`ListThingRegistrationTaskReportsOutput`](crate::output::ListThingRegistrationTaskReportsOutput)
    pub fn builder() -> crate::output::list_thing_registration_task_reports_output::Builder {
        crate::output::list_thing_registration_task_reports_output::Builder::default()
    }
}

/// <p>The output from the ListThingPrincipals operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingPrincipalsOutput {
    /// <p>The principals associated with the thing.</p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingPrincipalsOutput {
    /// <p>The principals associated with the thing.</p>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingPrincipalsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingPrincipalsOutput");
        formatter.field("principals", &self.principals);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingPrincipalsOutput`](crate::output::ListThingPrincipalsOutput)
pub mod list_thing_principals_output {
    /// A builder for [`ListThingPrincipalsOutput`](crate::output::ListThingPrincipalsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The principals associated with the thing.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The principals associated with the thing.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingPrincipalsOutput`](crate::output::ListThingPrincipalsOutput)
        pub fn build(self) -> crate::output::ListThingPrincipalsOutput {
            crate::output::ListThingPrincipalsOutput {
                principals: self.principals,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingPrincipalsOutput {
    /// Creates a new builder-style object to manufacture [`ListThingPrincipalsOutput`](crate::output::ListThingPrincipalsOutput)
    pub fn builder() -> crate::output::list_thing_principals_output::Builder {
        crate::output::list_thing_principals_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingGroupsForThingOutput {
    /// <p>The thing groups.</p>
    pub thing_groups: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingGroupsForThingOutput {
    /// <p>The thing groups.</p>
    pub fn thing_groups(&self) -> std::option::Option<&[crate::model::GroupNameAndArn]> {
        self.thing_groups.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingGroupsForThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingGroupsForThingOutput");
        formatter.field("thing_groups", &self.thing_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingGroupsForThingOutput`](crate::output::ListThingGroupsForThingOutput)
pub mod list_thing_groups_for_thing_output {
    /// A builder for [`ListThingGroupsForThingOutput`](crate::output::ListThingGroupsForThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_groups: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `thing_groups`.
        ///
        /// To override the contents of this collection use [`set_thing_groups`](Self::set_thing_groups).
        ///
        /// <p>The thing groups.</p>
        pub fn thing_groups(mut self, input: crate::model::GroupNameAndArn) -> Self {
            let mut v = self.thing_groups.unwrap_or_default();
            v.push(input);
            self.thing_groups = Some(v);
            self
        }
        /// <p>The thing groups.</p>
        pub fn set_thing_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
        ) -> Self {
            self.thing_groups = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingGroupsForThingOutput`](crate::output::ListThingGroupsForThingOutput)
        pub fn build(self) -> crate::output::ListThingGroupsForThingOutput {
            crate::output::ListThingGroupsForThingOutput {
                thing_groups: self.thing_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingGroupsForThingOutput {
    /// Creates a new builder-style object to manufacture [`ListThingGroupsForThingOutput`](crate::output::ListThingGroupsForThingOutput)
    pub fn builder() -> crate::output::list_thing_groups_for_thing_output::Builder {
        crate::output::list_thing_groups_for_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThingGroupsOutput {
    /// <p>The thing groups.</p>
    pub thing_groups: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThingGroupsOutput {
    /// <p>The thing groups.</p>
    pub fn thing_groups(&self) -> std::option::Option<&[crate::model::GroupNameAndArn]> {
        self.thing_groups.as_deref()
    }
    /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThingGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThingGroupsOutput");
        formatter.field("thing_groups", &self.thing_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListThingGroupsOutput`](crate::output::ListThingGroupsOutput)
pub mod list_thing_groups_output {
    /// A builder for [`ListThingGroupsOutput`](crate::output::ListThingGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_groups: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `thing_groups`.
        ///
        /// To override the contents of this collection use [`set_thing_groups`](Self::set_thing_groups).
        ///
        /// <p>The thing groups.</p>
        pub fn thing_groups(mut self, input: crate::model::GroupNameAndArn) -> Self {
            let mut v = self.thing_groups.unwrap_or_default();
            v.push(input);
            self.thing_groups = Some(v);
            self
        }
        /// <p>The thing groups.</p>
        pub fn set_thing_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
        ) -> Self {
            self.thing_groups = input;
            self
        }
        /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThingGroupsOutput`](crate::output::ListThingGroupsOutput)
        pub fn build(self) -> crate::output::ListThingGroupsOutput {
            crate::output::ListThingGroupsOutput {
                thing_groups: self.thing_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListThingGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListThingGroupsOutput`](crate::output::ListThingGroupsOutput)
    pub fn builder() -> crate::output::list_thing_groups_output::Builder {
        crate::output::list_thing_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsForSecurityProfileOutput {
    /// <p>The thing groups to which the security profile is attached.</p>
    pub security_profile_targets:
        std::option::Option<std::vec::Vec<crate::model::SecurityProfileTarget>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTargetsForSecurityProfileOutput {
    /// <p>The thing groups to which the security profile is attached.</p>
    pub fn security_profile_targets(
        &self,
    ) -> std::option::Option<&[crate::model::SecurityProfileTarget]> {
        self.security_profile_targets.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTargetsForSecurityProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsForSecurityProfileOutput");
        formatter.field("security_profile_targets", &self.security_profile_targets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTargetsForSecurityProfileOutput`](crate::output::ListTargetsForSecurityProfileOutput)
pub mod list_targets_for_security_profile_output {
    /// A builder for [`ListTargetsForSecurityProfileOutput`](crate::output::ListTargetsForSecurityProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_targets:
            std::option::Option<std::vec::Vec<crate::model::SecurityProfileTarget>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `security_profile_targets`.
        ///
        /// To override the contents of this collection use [`set_security_profile_targets`](Self::set_security_profile_targets).
        ///
        /// <p>The thing groups to which the security profile is attached.</p>
        pub fn security_profile_targets(
            mut self,
            input: crate::model::SecurityProfileTarget,
        ) -> Self {
            let mut v = self.security_profile_targets.unwrap_or_default();
            v.push(input);
            self.security_profile_targets = Some(v);
            self
        }
        /// <p>The thing groups to which the security profile is attached.</p>
        pub fn set_security_profile_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityProfileTarget>>,
        ) -> Self {
            self.security_profile_targets = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsForSecurityProfileOutput`](crate::output::ListTargetsForSecurityProfileOutput)
        pub fn build(self) -> crate::output::ListTargetsForSecurityProfileOutput {
            crate::output::ListTargetsForSecurityProfileOutput {
                security_profile_targets: self.security_profile_targets,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTargetsForSecurityProfileOutput {
    /// Creates a new builder-style object to manufacture [`ListTargetsForSecurityProfileOutput`](crate::output::ListTargetsForSecurityProfileOutput)
    pub fn builder() -> crate::output::list_targets_for_security_profile_output::Builder {
        crate::output::list_targets_for_security_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTargetsForPolicyOutput {
    /// <p>The policy targets.</p>
    pub targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A marker used to get the next set of results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListTargetsForPolicyOutput {
    /// <p>The policy targets.</p>
    pub fn targets(&self) -> std::option::Option<&[std::string::String]> {
        self.targets.as_deref()
    }
    /// <p>A marker used to get the next set of results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListTargetsForPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTargetsForPolicyOutput");
        formatter.field("targets", &self.targets);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
pub mod list_targets_for_policy_output {
    /// A builder for [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The policy targets.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The policy targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
        pub fn build(self) -> crate::output::ListTargetsForPolicyOutput {
            crate::output::ListTargetsForPolicyOutput {
                targets: self.targets,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListTargetsForPolicyOutput {
    /// Creates a new builder-style object to manufacture [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput)
    pub fn builder() -> crate::output::list_targets_for_policy_output::Builder {
        crate::output::list_targets_for_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tags assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>The list of tags assigned to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStreamsOutput {
    /// <p>A list of streams.</p>
    pub streams: std::option::Option<std::vec::Vec<crate::model::StreamSummary>>,
    /// <p>A token used to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStreamsOutput {
    /// <p>A list of streams.</p>
    pub fn streams(&self) -> std::option::Option<&[crate::model::StreamSummary]> {
        self.streams.as_deref()
    }
    /// <p>A token used to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStreamsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStreamsOutput");
        formatter.field("streams", &self.streams);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStreamsOutput`](crate::output::ListStreamsOutput)
pub mod list_streams_output {
    /// A builder for [`ListStreamsOutput`](crate::output::ListStreamsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streams: std::option::Option<std::vec::Vec<crate::model::StreamSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `streams`.
        ///
        /// To override the contents of this collection use [`set_streams`](Self::set_streams).
        ///
        /// <p>A list of streams.</p>
        pub fn streams(mut self, input: crate::model::StreamSummary) -> Self {
            let mut v = self.streams.unwrap_or_default();
            v.push(input);
            self.streams = Some(v);
            self
        }
        /// <p>A list of streams.</p>
        pub fn set_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamSummary>>,
        ) -> Self {
            self.streams = input;
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStreamsOutput`](crate::output::ListStreamsOutput)
        pub fn build(self) -> crate::output::ListStreamsOutput {
            crate::output::ListStreamsOutput {
                streams: self.streams,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStreamsOutput {
    /// Creates a new builder-style object to manufacture [`ListStreamsOutput`](crate::output::ListStreamsOutput)
    pub fn builder() -> crate::output::list_streams_output::Builder {
        crate::output::list_streams_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSecurityProfilesForTargetOutput {
    /// <p>A list of security profiles and their associated targets.</p>
    pub security_profile_target_mappings:
        std::option::Option<std::vec::Vec<crate::model::SecurityProfileTargetMapping>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSecurityProfilesForTargetOutput {
    /// <p>A list of security profiles and their associated targets.</p>
    pub fn security_profile_target_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::SecurityProfileTargetMapping]> {
        self.security_profile_target_mappings.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSecurityProfilesForTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSecurityProfilesForTargetOutput");
        formatter.field(
            "security_profile_target_mappings",
            &self.security_profile_target_mappings,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSecurityProfilesForTargetOutput`](crate::output::ListSecurityProfilesForTargetOutput)
pub mod list_security_profiles_for_target_output {
    /// A builder for [`ListSecurityProfilesForTargetOutput`](crate::output::ListSecurityProfilesForTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_target_mappings:
            std::option::Option<std::vec::Vec<crate::model::SecurityProfileTargetMapping>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `security_profile_target_mappings`.
        ///
        /// To override the contents of this collection use [`set_security_profile_target_mappings`](Self::set_security_profile_target_mappings).
        ///
        /// <p>A list of security profiles and their associated targets.</p>
        pub fn security_profile_target_mappings(
            mut self,
            input: crate::model::SecurityProfileTargetMapping,
        ) -> Self {
            let mut v = self.security_profile_target_mappings.unwrap_or_default();
            v.push(input);
            self.security_profile_target_mappings = Some(v);
            self
        }
        /// <p>A list of security profiles and their associated targets.</p>
        pub fn set_security_profile_target_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityProfileTargetMapping>>,
        ) -> Self {
            self.security_profile_target_mappings = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityProfilesForTargetOutput`](crate::output::ListSecurityProfilesForTargetOutput)
        pub fn build(self) -> crate::output::ListSecurityProfilesForTargetOutput {
            crate::output::ListSecurityProfilesForTargetOutput {
                security_profile_target_mappings: self.security_profile_target_mappings,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSecurityProfilesForTargetOutput {
    /// Creates a new builder-style object to manufacture [`ListSecurityProfilesForTargetOutput`](crate::output::ListSecurityProfilesForTargetOutput)
    pub fn builder() -> crate::output::list_security_profiles_for_target_output::Builder {
        crate::output::list_security_profiles_for_target_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSecurityProfilesOutput {
    /// <p>A list of security profile identifiers (names and ARNs).</p>
    pub security_profile_identifiers:
        std::option::Option<std::vec::Vec<crate::model::SecurityProfileIdentifier>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSecurityProfilesOutput {
    /// <p>A list of security profile identifiers (names and ARNs).</p>
    pub fn security_profile_identifiers(
        &self,
    ) -> std::option::Option<&[crate::model::SecurityProfileIdentifier]> {
        self.security_profile_identifiers.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSecurityProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSecurityProfilesOutput");
        formatter.field(
            "security_profile_identifiers",
            &self.security_profile_identifiers,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSecurityProfilesOutput`](crate::output::ListSecurityProfilesOutput)
pub mod list_security_profiles_output {
    /// A builder for [`ListSecurityProfilesOutput`](crate::output::ListSecurityProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_identifiers:
            std::option::Option<std::vec::Vec<crate::model::SecurityProfileIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `security_profile_identifiers`.
        ///
        /// To override the contents of this collection use [`set_security_profile_identifiers`](Self::set_security_profile_identifiers).
        ///
        /// <p>A list of security profile identifiers (names and ARNs).</p>
        pub fn security_profile_identifiers(
            mut self,
            input: crate::model::SecurityProfileIdentifier,
        ) -> Self {
            let mut v = self.security_profile_identifiers.unwrap_or_default();
            v.push(input);
            self.security_profile_identifiers = Some(v);
            self
        }
        /// <p>A list of security profile identifiers (names and ARNs).</p>
        pub fn set_security_profile_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityProfileIdentifier>>,
        ) -> Self {
            self.security_profile_identifiers = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityProfilesOutput`](crate::output::ListSecurityProfilesOutput)
        pub fn build(self) -> crate::output::ListSecurityProfilesOutput {
            crate::output::ListSecurityProfilesOutput {
                security_profile_identifiers: self.security_profile_identifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSecurityProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListSecurityProfilesOutput`](crate::output::ListSecurityProfilesOutput)
    pub fn builder() -> crate::output::list_security_profiles_output::Builder {
        crate::output::list_security_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListScheduledAuditsOutput {
    /// <p>The list of scheduled audits.</p>
    pub scheduled_audits: std::option::Option<std::vec::Vec<crate::model::ScheduledAuditMetadata>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListScheduledAuditsOutput {
    /// <p>The list of scheduled audits.</p>
    pub fn scheduled_audits(&self) -> std::option::Option<&[crate::model::ScheduledAuditMetadata]> {
        self.scheduled_audits.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListScheduledAuditsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListScheduledAuditsOutput");
        formatter.field("scheduled_audits", &self.scheduled_audits);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListScheduledAuditsOutput`](crate::output::ListScheduledAuditsOutput)
pub mod list_scheduled_audits_output {
    /// A builder for [`ListScheduledAuditsOutput`](crate::output::ListScheduledAuditsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_audits:
            std::option::Option<std::vec::Vec<crate::model::ScheduledAuditMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `scheduled_audits`.
        ///
        /// To override the contents of this collection use [`set_scheduled_audits`](Self::set_scheduled_audits).
        ///
        /// <p>The list of scheduled audits.</p>
        pub fn scheduled_audits(mut self, input: crate::model::ScheduledAuditMetadata) -> Self {
            let mut v = self.scheduled_audits.unwrap_or_default();
            v.push(input);
            self.scheduled_audits = Some(v);
            self
        }
        /// <p>The list of scheduled audits.</p>
        pub fn set_scheduled_audits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledAuditMetadata>>,
        ) -> Self {
            self.scheduled_audits = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListScheduledAuditsOutput`](crate::output::ListScheduledAuditsOutput)
        pub fn build(self) -> crate::output::ListScheduledAuditsOutput {
            crate::output::ListScheduledAuditsOutput {
                scheduled_audits: self.scheduled_audits,
                next_token: self.next_token,
            }
        }
    }
}
impl ListScheduledAuditsOutput {
    /// Creates a new builder-style object to manufacture [`ListScheduledAuditsOutput`](crate::output::ListScheduledAuditsOutput)
    pub fn builder() -> crate::output::list_scheduled_audits_output::Builder {
        crate::output::list_scheduled_audits_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoleAliasesOutput {
    /// <p>The role aliases.</p>
    pub role_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A marker used to get the next set of results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListRoleAliasesOutput {
    /// <p>The role aliases.</p>
    pub fn role_aliases(&self) -> std::option::Option<&[std::string::String]> {
        self.role_aliases.as_deref()
    }
    /// <p>A marker used to get the next set of results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListRoleAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoleAliasesOutput");
        formatter.field("role_aliases", &self.role_aliases);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListRoleAliasesOutput`](crate::output::ListRoleAliasesOutput)
pub mod list_role_aliases_output {
    /// A builder for [`ListRoleAliasesOutput`](crate::output::ListRoleAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `role_aliases`.
        ///
        /// To override the contents of this collection use [`set_role_aliases`](Self::set_role_aliases).
        ///
        /// <p>The role aliases.</p>
        pub fn role_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.role_aliases.unwrap_or_default();
            v.push(input.into());
            self.role_aliases = Some(v);
            self
        }
        /// <p>The role aliases.</p>
        pub fn set_role_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.role_aliases = input;
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoleAliasesOutput`](crate::output::ListRoleAliasesOutput)
        pub fn build(self) -> crate::output::ListRoleAliasesOutput {
            crate::output::ListRoleAliasesOutput {
                role_aliases: self.role_aliases,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListRoleAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListRoleAliasesOutput`](crate::output::ListRoleAliasesOutput)
    pub fn builder() -> crate::output::list_role_aliases_output::Builder {
        crate::output::list_role_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisioningTemplateVersionsOutput {
    /// <p>The list of fleet provisioning template versions.</p>
    pub versions:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningTemplateVersionSummary>>,
    /// <p>A token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProvisioningTemplateVersionsOutput {
    /// <p>The list of fleet provisioning template versions.</p>
    pub fn versions(
        &self,
    ) -> std::option::Option<&[crate::model::ProvisioningTemplateVersionSummary]> {
        self.versions.as_deref()
    }
    /// <p>A token to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProvisioningTemplateVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisioningTemplateVersionsOutput");
        formatter.field("versions", &self.versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProvisioningTemplateVersionsOutput`](crate::output::ListProvisioningTemplateVersionsOutput)
pub mod list_provisioning_template_versions_output {
    /// A builder for [`ListProvisioningTemplateVersionsOutput`](crate::output::ListProvisioningTemplateVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) versions:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningTemplateVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>The list of fleet provisioning template versions.</p>
        pub fn versions(mut self, input: crate::model::ProvisioningTemplateVersionSummary) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input);
            self.versions = Some(v);
            self
        }
        /// <p>The list of fleet provisioning template versions.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ProvisioningTemplateVersionSummary>,
            >,
        ) -> Self {
            self.versions = input;
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisioningTemplateVersionsOutput`](crate::output::ListProvisioningTemplateVersionsOutput)
        pub fn build(self) -> crate::output::ListProvisioningTemplateVersionsOutput {
            crate::output::ListProvisioningTemplateVersionsOutput {
                versions: self.versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProvisioningTemplateVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListProvisioningTemplateVersionsOutput`](crate::output::ListProvisioningTemplateVersionsOutput)
    pub fn builder() -> crate::output::list_provisioning_template_versions_output::Builder {
        crate::output::list_provisioning_template_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisioningTemplatesOutput {
    /// <p>A list of fleet provisioning templates</p>
    pub templates: std::option::Option<std::vec::Vec<crate::model::ProvisioningTemplateSummary>>,
    /// <p>A token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProvisioningTemplatesOutput {
    /// <p>A list of fleet provisioning templates</p>
    pub fn templates(&self) -> std::option::Option<&[crate::model::ProvisioningTemplateSummary]> {
        self.templates.as_deref()
    }
    /// <p>A token to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProvisioningTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisioningTemplatesOutput");
        formatter.field("templates", &self.templates);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProvisioningTemplatesOutput`](crate::output::ListProvisioningTemplatesOutput)
pub mod list_provisioning_templates_output {
    /// A builder for [`ListProvisioningTemplatesOutput`](crate::output::ListProvisioningTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) templates:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningTemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `templates`.
        ///
        /// To override the contents of this collection use [`set_templates`](Self::set_templates).
        ///
        /// <p>A list of fleet provisioning templates</p>
        pub fn templates(mut self, input: crate::model::ProvisioningTemplateSummary) -> Self {
            let mut v = self.templates.unwrap_or_default();
            v.push(input);
            self.templates = Some(v);
            self
        }
        /// <p>A list of fleet provisioning templates</p>
        pub fn set_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningTemplateSummary>>,
        ) -> Self {
            self.templates = input;
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisioningTemplatesOutput`](crate::output::ListProvisioningTemplatesOutput)
        pub fn build(self) -> crate::output::ListProvisioningTemplatesOutput {
            crate::output::ListProvisioningTemplatesOutput {
                templates: self.templates,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProvisioningTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListProvisioningTemplatesOutput`](crate::output::ListProvisioningTemplatesOutput)
    pub fn builder() -> crate::output::list_provisioning_templates_output::Builder {
        crate::output::list_provisioning_templates_output::Builder::default()
    }
}

/// <p>The output from the ListPrincipalThings operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPrincipalThingsOutput {
    /// <p>The things.</p>
    pub things: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPrincipalThingsOutput {
    /// <p>The things.</p>
    pub fn things(&self) -> std::option::Option<&[std::string::String]> {
        self.things.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPrincipalThingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPrincipalThingsOutput");
        formatter.field("things", &self.things);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPrincipalThingsOutput`](crate::output::ListPrincipalThingsOutput)
pub mod list_principal_things_output {
    /// A builder for [`ListPrincipalThingsOutput`](crate::output::ListPrincipalThingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) things: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `things`.
        ///
        /// To override the contents of this collection use [`set_things`](Self::set_things).
        ///
        /// <p>The things.</p>
        pub fn things(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.things.unwrap_or_default();
            v.push(input.into());
            self.things = Some(v);
            self
        }
        /// <p>The things.</p>
        pub fn set_things(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.things = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPrincipalThingsOutput`](crate::output::ListPrincipalThingsOutput)
        pub fn build(self) -> crate::output::ListPrincipalThingsOutput {
            crate::output::ListPrincipalThingsOutput {
                things: self.things,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPrincipalThingsOutput {
    /// Creates a new builder-style object to manufacture [`ListPrincipalThingsOutput`](crate::output::ListPrincipalThingsOutput)
    pub fn builder() -> crate::output::list_principal_things_output::Builder {
        crate::output::list_principal_things_output::Builder::default()
    }
}

/// <p>The output from the ListPrincipalPolicies operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPrincipalPoliciesOutput {
    /// <p>The policies.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListPrincipalPoliciesOutput {
    /// <p>The policies.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::Policy]> {
        self.policies.as_deref()
    }
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListPrincipalPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPrincipalPoliciesOutput");
        formatter.field("policies", &self.policies);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListPrincipalPoliciesOutput`](crate::output::ListPrincipalPoliciesOutput)
pub mod list_principal_policies_output {
    /// A builder for [`ListPrincipalPoliciesOutput`](crate::output::ListPrincipalPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>The policies.</p>
        pub fn policies(mut self, input: crate::model::Policy) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input);
            self.policies = Some(v);
            self
        }
        /// <p>The policies.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPrincipalPoliciesOutput`](crate::output::ListPrincipalPoliciesOutput)
        pub fn build(self) -> crate::output::ListPrincipalPoliciesOutput {
            crate::output::ListPrincipalPoliciesOutput {
                policies: self.policies,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListPrincipalPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListPrincipalPoliciesOutput`](crate::output::ListPrincipalPoliciesOutput)
    pub fn builder() -> crate::output::list_principal_policies_output::Builder {
        crate::output::list_principal_policies_output::Builder::default()
    }
}

/// <p>The output from the ListPolicyVersions operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyVersionsOutput {
    /// <p>The policy versions.</p>
    pub policy_versions: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
}
impl ListPolicyVersionsOutput {
    /// <p>The policy versions.</p>
    pub fn policy_versions(&self) -> std::option::Option<&[crate::model::PolicyVersion]> {
        self.policy_versions.as_deref()
    }
}
impl std::fmt::Debug for ListPolicyVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyVersionsOutput");
        formatter.field("policy_versions", &self.policy_versions);
        formatter.finish()
    }
}
/// See [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
pub mod list_policy_versions_output {
    /// A builder for [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_versions: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
    }
    impl Builder {
        /// Appends an item to `policy_versions`.
        ///
        /// To override the contents of this collection use [`set_policy_versions`](Self::set_policy_versions).
        ///
        /// <p>The policy versions.</p>
        pub fn policy_versions(mut self, input: crate::model::PolicyVersion) -> Self {
            let mut v = self.policy_versions.unwrap_or_default();
            v.push(input);
            self.policy_versions = Some(v);
            self
        }
        /// <p>The policy versions.</p>
        pub fn set_policy_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
        ) -> Self {
            self.policy_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
        pub fn build(self) -> crate::output::ListPolicyVersionsOutput {
            crate::output::ListPolicyVersionsOutput {
                policy_versions: self.policy_versions,
            }
        }
    }
}
impl ListPolicyVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
    pub fn builder() -> crate::output::list_policy_versions_output::Builder {
        crate::output::list_policy_versions_output::Builder::default()
    }
}

/// <p>The output from the ListPolicyPrincipals operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyPrincipalsOutput {
    /// <p>The descriptions of the principals.</p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListPolicyPrincipalsOutput {
    /// <p>The descriptions of the principals.</p>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListPolicyPrincipalsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyPrincipalsOutput");
        formatter.field("principals", &self.principals);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListPolicyPrincipalsOutput`](crate::output::ListPolicyPrincipalsOutput)
pub mod list_policy_principals_output {
    /// A builder for [`ListPolicyPrincipalsOutput`](crate::output::ListPolicyPrincipalsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The descriptions of the principals.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The descriptions of the principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyPrincipalsOutput`](crate::output::ListPolicyPrincipalsOutput)
        pub fn build(self) -> crate::output::ListPolicyPrincipalsOutput {
            crate::output::ListPolicyPrincipalsOutput {
                principals: self.principals,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListPolicyPrincipalsOutput {
    /// Creates a new builder-style object to manufacture [`ListPolicyPrincipalsOutput`](crate::output::ListPolicyPrincipalsOutput)
    pub fn builder() -> crate::output::list_policy_principals_output::Builder {
        crate::output::list_policy_principals_output::Builder::default()
    }
}

/// <p>The output from the ListPolicies operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesOutput {
    /// <p>The descriptions of the policies.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListPoliciesOutput {
    /// <p>The descriptions of the policies.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::Policy]> {
        self.policies.as_deref()
    }
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesOutput");
        formatter.field("policies", &self.policies);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
pub mod list_policies_output {
    /// A builder for [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>The descriptions of the policies.</p>
        pub fn policies(mut self, input: crate::model::Policy) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input);
            self.policies = Some(v);
            self
        }
        /// <p>The descriptions of the policies.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
        pub fn build(self) -> crate::output::ListPoliciesOutput {
            crate::output::ListPoliciesOutput {
                policies: self.policies,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
    pub fn builder() -> crate::output::list_policies_output::Builder {
        crate::output::list_policies_output::Builder::default()
    }
}

/// <p>The output from the ListOutgoingCertificates operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOutgoingCertificatesOutput {
    /// <p>The certificates that are being transferred but not yet accepted.</p>
    pub outgoing_certificates:
        std::option::Option<std::vec::Vec<crate::model::OutgoingCertificate>>,
    /// <p>The marker for the next set of results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListOutgoingCertificatesOutput {
    /// <p>The certificates that are being transferred but not yet accepted.</p>
    pub fn outgoing_certificates(
        &self,
    ) -> std::option::Option<&[crate::model::OutgoingCertificate]> {
        self.outgoing_certificates.as_deref()
    }
    /// <p>The marker for the next set of results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListOutgoingCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOutgoingCertificatesOutput");
        formatter.field("outgoing_certificates", &self.outgoing_certificates);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListOutgoingCertificatesOutput`](crate::output::ListOutgoingCertificatesOutput)
pub mod list_outgoing_certificates_output {
    /// A builder for [`ListOutgoingCertificatesOutput`](crate::output::ListOutgoingCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) outgoing_certificates:
            std::option::Option<std::vec::Vec<crate::model::OutgoingCertificate>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `outgoing_certificates`.
        ///
        /// To override the contents of this collection use [`set_outgoing_certificates`](Self::set_outgoing_certificates).
        ///
        /// <p>The certificates that are being transferred but not yet accepted.</p>
        pub fn outgoing_certificates(mut self, input: crate::model::OutgoingCertificate) -> Self {
            let mut v = self.outgoing_certificates.unwrap_or_default();
            v.push(input);
            self.outgoing_certificates = Some(v);
            self
        }
        /// <p>The certificates that are being transferred but not yet accepted.</p>
        pub fn set_outgoing_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutgoingCertificate>>,
        ) -> Self {
            self.outgoing_certificates = input;
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOutgoingCertificatesOutput`](crate::output::ListOutgoingCertificatesOutput)
        pub fn build(self) -> crate::output::ListOutgoingCertificatesOutput {
            crate::output::ListOutgoingCertificatesOutput {
                outgoing_certificates: self.outgoing_certificates,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListOutgoingCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`ListOutgoingCertificatesOutput`](crate::output::ListOutgoingCertificatesOutput)
    pub fn builder() -> crate::output::list_outgoing_certificates_output::Builder {
        crate::output::list_outgoing_certificates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOtaUpdatesOutput {
    /// <p>A list of OTA update jobs.</p>
    pub ota_updates: std::option::Option<std::vec::Vec<crate::model::OtaUpdateSummary>>,
    /// <p>A token to use to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOtaUpdatesOutput {
    /// <p>A list of OTA update jobs.</p>
    pub fn ota_updates(&self) -> std::option::Option<&[crate::model::OtaUpdateSummary]> {
        self.ota_updates.as_deref()
    }
    /// <p>A token to use to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOtaUpdatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOtaUpdatesOutput");
        formatter.field("ota_updates", &self.ota_updates);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOtaUpdatesOutput`](crate::output::ListOtaUpdatesOutput)
pub mod list_ota_updates_output {
    /// A builder for [`ListOtaUpdatesOutput`](crate::output::ListOtaUpdatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_updates: std::option::Option<std::vec::Vec<crate::model::OtaUpdateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ota_updates`.
        ///
        /// To override the contents of this collection use [`set_ota_updates`](Self::set_ota_updates).
        ///
        /// <p>A list of OTA update jobs.</p>
        pub fn ota_updates(mut self, input: crate::model::OtaUpdateSummary) -> Self {
            let mut v = self.ota_updates.unwrap_or_default();
            v.push(input);
            self.ota_updates = Some(v);
            self
        }
        /// <p>A list of OTA update jobs.</p>
        pub fn set_ota_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OtaUpdateSummary>>,
        ) -> Self {
            self.ota_updates = input;
            self
        }
        /// <p>A token to use to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOtaUpdatesOutput`](crate::output::ListOtaUpdatesOutput)
        pub fn build(self) -> crate::output::ListOtaUpdatesOutput {
            crate::output::ListOtaUpdatesOutput {
                ota_updates: self.ota_updates,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOtaUpdatesOutput {
    /// Creates a new builder-style object to manufacture [`ListOtaUpdatesOutput`](crate::output::ListOtaUpdatesOutput)
    pub fn builder() -> crate::output::list_ota_updates_output::Builder {
        crate::output::list_ota_updates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMitigationActionsOutput {
    /// <p>A set of actions that matched the specified filter criteria.</p>
    pub action_identifiers:
        std::option::Option<std::vec::Vec<crate::model::MitigationActionIdentifier>>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMitigationActionsOutput {
    /// <p>A set of actions that matched the specified filter criteria.</p>
    pub fn action_identifiers(
        &self,
    ) -> std::option::Option<&[crate::model::MitigationActionIdentifier]> {
        self.action_identifiers.as_deref()
    }
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMitigationActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMitigationActionsOutput");
        formatter.field("action_identifiers", &self.action_identifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMitigationActionsOutput`](crate::output::ListMitigationActionsOutput)
pub mod list_mitigation_actions_output {
    /// A builder for [`ListMitigationActionsOutput`](crate::output::ListMitigationActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_identifiers:
            std::option::Option<std::vec::Vec<crate::model::MitigationActionIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `action_identifiers`.
        ///
        /// To override the contents of this collection use [`set_action_identifiers`](Self::set_action_identifiers).
        ///
        /// <p>A set of actions that matched the specified filter criteria.</p>
        pub fn action_identifiers(
            mut self,
            input: crate::model::MitigationActionIdentifier,
        ) -> Self {
            let mut v = self.action_identifiers.unwrap_or_default();
            v.push(input);
            self.action_identifiers = Some(v);
            self
        }
        /// <p>A set of actions that matched the specified filter criteria.</p>
        pub fn set_action_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MitigationActionIdentifier>>,
        ) -> Self {
            self.action_identifiers = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMitigationActionsOutput`](crate::output::ListMitigationActionsOutput)
        pub fn build(self) -> crate::output::ListMitigationActionsOutput {
            crate::output::ListMitigationActionsOutput {
                action_identifiers: self.action_identifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMitigationActionsOutput {
    /// Creates a new builder-style object to manufacture [`ListMitigationActionsOutput`](crate::output::ListMitigationActionsOutput)
    pub fn builder() -> crate::output::list_mitigation_actions_output::Builder {
        crate::output::list_mitigation_actions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListManagedJobTemplatesOutput {
    /// <p>A list of managed job templates that are returned.</p>
    pub managed_job_templates:
        std::option::Option<std::vec::Vec<crate::model::ManagedJobTemplateSummary>>,
    /// <p>The token to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListManagedJobTemplatesOutput {
    /// <p>A list of managed job templates that are returned.</p>
    pub fn managed_job_templates(
        &self,
    ) -> std::option::Option<&[crate::model::ManagedJobTemplateSummary]> {
        self.managed_job_templates.as_deref()
    }
    /// <p>The token to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListManagedJobTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListManagedJobTemplatesOutput");
        formatter.field("managed_job_templates", &self.managed_job_templates);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListManagedJobTemplatesOutput`](crate::output::ListManagedJobTemplatesOutput)
pub mod list_managed_job_templates_output {
    /// A builder for [`ListManagedJobTemplatesOutput`](crate::output::ListManagedJobTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) managed_job_templates:
            std::option::Option<std::vec::Vec<crate::model::ManagedJobTemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `managed_job_templates`.
        ///
        /// To override the contents of this collection use [`set_managed_job_templates`](Self::set_managed_job_templates).
        ///
        /// <p>A list of managed job templates that are returned.</p>
        pub fn managed_job_templates(
            mut self,
            input: crate::model::ManagedJobTemplateSummary,
        ) -> Self {
            let mut v = self.managed_job_templates.unwrap_or_default();
            v.push(input);
            self.managed_job_templates = Some(v);
            self
        }
        /// <p>A list of managed job templates that are returned.</p>
        pub fn set_managed_job_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedJobTemplateSummary>>,
        ) -> Self {
            self.managed_job_templates = input;
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListManagedJobTemplatesOutput`](crate::output::ListManagedJobTemplatesOutput)
        pub fn build(self) -> crate::output::ListManagedJobTemplatesOutput {
            crate::output::ListManagedJobTemplatesOutput {
                managed_job_templates: self.managed_job_templates,
                next_token: self.next_token,
            }
        }
    }
}
impl ListManagedJobTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListManagedJobTemplatesOutput`](crate::output::ListManagedJobTemplatesOutput)
    pub fn builder() -> crate::output::list_managed_job_templates_output::Builder {
        crate::output::list_managed_job_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobTemplatesOutput {
    /// <p>A list of objects that contain information about the job templates.</p>
    pub job_templates: std::option::Option<std::vec::Vec<crate::model::JobTemplateSummary>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobTemplatesOutput {
    /// <p>A list of objects that contain information about the job templates.</p>
    pub fn job_templates(&self) -> std::option::Option<&[crate::model::JobTemplateSummary]> {
        self.job_templates.as_deref()
    }
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobTemplatesOutput");
        formatter.field("job_templates", &self.job_templates);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
pub mod list_job_templates_output {
    /// A builder for [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_templates:
            std::option::Option<std::vec::Vec<crate::model::JobTemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_templates`.
        ///
        /// To override the contents of this collection use [`set_job_templates`](Self::set_job_templates).
        ///
        /// <p>A list of objects that contain information about the job templates.</p>
        pub fn job_templates(mut self, input: crate::model::JobTemplateSummary) -> Self {
            let mut v = self.job_templates.unwrap_or_default();
            v.push(input);
            self.job_templates = Some(v);
            self
        }
        /// <p>A list of objects that contain information about the job templates.</p>
        pub fn set_job_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobTemplateSummary>>,
        ) -> Self {
            self.job_templates = input;
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
        pub fn build(self) -> crate::output::ListJobTemplatesOutput {
            crate::output::ListJobTemplatesOutput {
                job_templates: self.job_templates,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
    pub fn builder() -> crate::output::list_job_templates_output::Builder {
        crate::output::list_job_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p>A list of jobs.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::JobSummary>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsOutput {
    /// <p>A list of jobs.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::JobSummary]> {
        self.jobs.as_deref()
    }
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::JobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of jobs.</p>
        pub fn jobs(mut self, input: crate::model::JobSummary) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input);
            self.jobs = Some(v);
            self
        }
        /// <p>A list of jobs.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobSummary>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobExecutionsForThingOutput {
    /// <p>A list of job execution summaries.</p>
    pub execution_summaries:
        std::option::Option<std::vec::Vec<crate::model::JobExecutionSummaryForThing>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobExecutionsForThingOutput {
    /// <p>A list of job execution summaries.</p>
    pub fn execution_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::JobExecutionSummaryForThing]> {
        self.execution_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobExecutionsForThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobExecutionsForThingOutput");
        formatter.field("execution_summaries", &self.execution_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobExecutionsForThingOutput`](crate::output::ListJobExecutionsForThingOutput)
pub mod list_job_executions_for_thing_output {
    /// A builder for [`ListJobExecutionsForThingOutput`](crate::output::ListJobExecutionsForThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_summaries:
            std::option::Option<std::vec::Vec<crate::model::JobExecutionSummaryForThing>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `execution_summaries`.
        ///
        /// To override the contents of this collection use [`set_execution_summaries`](Self::set_execution_summaries).
        ///
        /// <p>A list of job execution summaries.</p>
        pub fn execution_summaries(
            mut self,
            input: crate::model::JobExecutionSummaryForThing,
        ) -> Self {
            let mut v = self.execution_summaries.unwrap_or_default();
            v.push(input);
            self.execution_summaries = Some(v);
            self
        }
        /// <p>A list of job execution summaries.</p>
        pub fn set_execution_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobExecutionSummaryForThing>>,
        ) -> Self {
            self.execution_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobExecutionsForThingOutput`](crate::output::ListJobExecutionsForThingOutput)
        pub fn build(self) -> crate::output::ListJobExecutionsForThingOutput {
            crate::output::ListJobExecutionsForThingOutput {
                execution_summaries: self.execution_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobExecutionsForThingOutput {
    /// Creates a new builder-style object to manufacture [`ListJobExecutionsForThingOutput`](crate::output::ListJobExecutionsForThingOutput)
    pub fn builder() -> crate::output::list_job_executions_for_thing_output::Builder {
        crate::output::list_job_executions_for_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobExecutionsForJobOutput {
    /// <p>A list of job execution summaries.</p>
    pub execution_summaries:
        std::option::Option<std::vec::Vec<crate::model::JobExecutionSummaryForJob>>,
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobExecutionsForJobOutput {
    /// <p>A list of job execution summaries.</p>
    pub fn execution_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::JobExecutionSummaryForJob]> {
        self.execution_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobExecutionsForJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobExecutionsForJobOutput");
        formatter.field("execution_summaries", &self.execution_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobExecutionsForJobOutput`](crate::output::ListJobExecutionsForJobOutput)
pub mod list_job_executions_for_job_output {
    /// A builder for [`ListJobExecutionsForJobOutput`](crate::output::ListJobExecutionsForJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_summaries:
            std::option::Option<std::vec::Vec<crate::model::JobExecutionSummaryForJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `execution_summaries`.
        ///
        /// To override the contents of this collection use [`set_execution_summaries`](Self::set_execution_summaries).
        ///
        /// <p>A list of job execution summaries.</p>
        pub fn execution_summaries(
            mut self,
            input: crate::model::JobExecutionSummaryForJob,
        ) -> Self {
            let mut v = self.execution_summaries.unwrap_or_default();
            v.push(input);
            self.execution_summaries = Some(v);
            self
        }
        /// <p>A list of job execution summaries.</p>
        pub fn set_execution_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobExecutionSummaryForJob>>,
        ) -> Self {
            self.execution_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobExecutionsForJobOutput`](crate::output::ListJobExecutionsForJobOutput)
        pub fn build(self) -> crate::output::ListJobExecutionsForJobOutput {
            crate::output::ListJobExecutionsForJobOutput {
                execution_summaries: self.execution_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobExecutionsForJobOutput {
    /// Creates a new builder-style object to manufacture [`ListJobExecutionsForJobOutput`](crate::output::ListJobExecutionsForJobOutput)
    pub fn builder() -> crate::output::list_job_executions_for_job_output::Builder {
        crate::output::list_job_executions_for_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIndicesOutput {
    /// <p>The index names.</p>
    pub index_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIndicesOutput {
    /// <p>The index names.</p>
    pub fn index_names(&self) -> std::option::Option<&[std::string::String]> {
        self.index_names.as_deref()
    }
    /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIndicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIndicesOutput");
        formatter.field("index_names", &self.index_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIndicesOutput`](crate::output::ListIndicesOutput)
pub mod list_indices_output {
    /// A builder for [`ListIndicesOutput`](crate::output::ListIndicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `index_names`.
        ///
        /// To override the contents of this collection use [`set_index_names`](Self::set_index_names).
        ///
        /// <p>The index names.</p>
        pub fn index_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.index_names.unwrap_or_default();
            v.push(input.into());
            self.index_names = Some(v);
            self
        }
        /// <p>The index names.</p>
        pub fn set_index_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.index_names = input;
            self
        }
        /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIndicesOutput`](crate::output::ListIndicesOutput)
        pub fn build(self) -> crate::output::ListIndicesOutput {
            crate::output::ListIndicesOutput {
                index_names: self.index_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIndicesOutput {
    /// Creates a new builder-style object to manufacture [`ListIndicesOutput`](crate::output::ListIndicesOutput)
    pub fn builder() -> crate::output::list_indices_output::Builder {
        crate::output::list_indices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFleetMetricsOutput {
    /// <p>The list of fleet metrics objects.</p>
    pub fleet_metrics: std::option::Option<std::vec::Vec<crate::model::FleetMetricNameAndArn>>,
    /// <p>The token for the next set of results. Will not be returned if the operation has returned all results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFleetMetricsOutput {
    /// <p>The list of fleet metrics objects.</p>
    pub fn fleet_metrics(&self) -> std::option::Option<&[crate::model::FleetMetricNameAndArn]> {
        self.fleet_metrics.as_deref()
    }
    /// <p>The token for the next set of results. Will not be returned if the operation has returned all results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFleetMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFleetMetricsOutput");
        formatter.field("fleet_metrics", &self.fleet_metrics);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFleetMetricsOutput`](crate::output::ListFleetMetricsOutput)
pub mod list_fleet_metrics_output {
    /// A builder for [`ListFleetMetricsOutput`](crate::output::ListFleetMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_metrics:
            std::option::Option<std::vec::Vec<crate::model::FleetMetricNameAndArn>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_metrics`.
        ///
        /// To override the contents of this collection use [`set_fleet_metrics`](Self::set_fleet_metrics).
        ///
        /// <p>The list of fleet metrics objects.</p>
        pub fn fleet_metrics(mut self, input: crate::model::FleetMetricNameAndArn) -> Self {
            let mut v = self.fleet_metrics.unwrap_or_default();
            v.push(input);
            self.fleet_metrics = Some(v);
            self
        }
        /// <p>The list of fleet metrics objects.</p>
        pub fn set_fleet_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetMetricNameAndArn>>,
        ) -> Self {
            self.fleet_metrics = input;
            self
        }
        /// <p>The token for the next set of results. Will not be returned if the operation has returned all results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Will not be returned if the operation has returned all results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFleetMetricsOutput`](crate::output::ListFleetMetricsOutput)
        pub fn build(self) -> crate::output::ListFleetMetricsOutput {
            crate::output::ListFleetMetricsOutput {
                fleet_metrics: self.fleet_metrics,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFleetMetricsOutput {
    /// Creates a new builder-style object to manufacture [`ListFleetMetricsOutput`](crate::output::ListFleetMetricsOutput)
    pub fn builder() -> crate::output::list_fleet_metrics_output::Builder {
        crate::output::list_fleet_metrics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainConfigurationsOutput {
    /// <p>A list of objects that contain summary information about the user's domain configurations.</p>
    pub domain_configurations:
        std::option::Option<std::vec::Vec<crate::model::DomainConfigurationSummary>>,
    /// <p>The marker for the next set of results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListDomainConfigurationsOutput {
    /// <p>A list of objects that contain summary information about the user's domain configurations.</p>
    pub fn domain_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DomainConfigurationSummary]> {
        self.domain_configurations.as_deref()
    }
    /// <p>The marker for the next set of results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListDomainConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainConfigurationsOutput");
        formatter.field("domain_configurations", &self.domain_configurations);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListDomainConfigurationsOutput`](crate::output::ListDomainConfigurationsOutput)
pub mod list_domain_configurations_output {
    /// A builder for [`ListDomainConfigurationsOutput`](crate::output::ListDomainConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configurations:
            std::option::Option<std::vec::Vec<crate::model::DomainConfigurationSummary>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_configurations`.
        ///
        /// To override the contents of this collection use [`set_domain_configurations`](Self::set_domain_configurations).
        ///
        /// <p>A list of objects that contain summary information about the user's domain configurations.</p>
        pub fn domain_configurations(
            mut self,
            input: crate::model::DomainConfigurationSummary,
        ) -> Self {
            let mut v = self.domain_configurations.unwrap_or_default();
            v.push(input);
            self.domain_configurations = Some(v);
            self
        }
        /// <p>A list of objects that contain summary information about the user's domain configurations.</p>
        pub fn set_domain_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainConfigurationSummary>>,
        ) -> Self {
            self.domain_configurations = input;
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainConfigurationsOutput`](crate::output::ListDomainConfigurationsOutput)
        pub fn build(self) -> crate::output::ListDomainConfigurationsOutput {
            crate::output::ListDomainConfigurationsOutput {
                domain_configurations: self.domain_configurations,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListDomainConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainConfigurationsOutput`](crate::output::ListDomainConfigurationsOutput)
    pub fn builder() -> crate::output::list_domain_configurations_output::Builder {
        crate::output::list_domain_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDimensionsOutput {
    /// <p>A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.</p>
    pub dimension_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDimensionsOutput {
    /// <p>A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.</p>
    pub fn dimension_names(&self) -> std::option::Option<&[std::string::String]> {
        self.dimension_names.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDimensionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDimensionsOutput");
        formatter.field("dimension_names", &self.dimension_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDimensionsOutput`](crate::output::ListDimensionsOutput)
pub mod list_dimensions_output {
    /// A builder for [`ListDimensionsOutput`](crate::output::ListDimensionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dimension_names`.
        ///
        /// To override the contents of this collection use [`set_dimension_names`](Self::set_dimension_names).
        ///
        /// <p>A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.</p>
        pub fn dimension_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dimension_names.unwrap_or_default();
            v.push(input.into());
            self.dimension_names = Some(v);
            self
        }
        /// <p>A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.</p>
        pub fn set_dimension_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dimension_names = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDimensionsOutput`](crate::output::ListDimensionsOutput)
        pub fn build(self) -> crate::output::ListDimensionsOutput {
            crate::output::ListDimensionsOutput {
                dimension_names: self.dimension_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDimensionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDimensionsOutput`](crate::output::ListDimensionsOutput)
    pub fn builder() -> crate::output::list_dimensions_output::Builder {
        crate::output::list_dimensions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectMitigationActionsTasksOutput {
    /// <p> The collection of ML Detect mitigation tasks that matched the filter criteria. </p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::DetectMitigationActionsTaskSummary>>,
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDetectMitigationActionsTasksOutput {
    /// <p> The collection of ML Detect mitigation tasks that matched the filter criteria. </p>
    pub fn tasks(
        &self,
    ) -> std::option::Option<&[crate::model::DetectMitigationActionsTaskSummary]> {
        self.tasks.as_deref()
    }
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDetectMitigationActionsTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectMitigationActionsTasksOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDetectMitigationActionsTasksOutput`](crate::output::ListDetectMitigationActionsTasksOutput)
pub mod list_detect_mitigation_actions_tasks_output {
    /// A builder for [`ListDetectMitigationActionsTasksOutput`](crate::output::ListDetectMitigationActionsTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks:
            std::option::Option<std::vec::Vec<crate::model::DetectMitigationActionsTaskSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p> The collection of ML Detect mitigation tasks that matched the filter criteria. </p>
        pub fn tasks(mut self, input: crate::model::DetectMitigationActionsTaskSummary) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p> The collection of ML Detect mitigation tasks that matched the filter criteria. </p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DetectMitigationActionsTaskSummary>,
            >,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectMitigationActionsTasksOutput`](crate::output::ListDetectMitigationActionsTasksOutput)
        pub fn build(self) -> crate::output::ListDetectMitigationActionsTasksOutput {
            crate::output::ListDetectMitigationActionsTasksOutput {
                tasks: self.tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDetectMitigationActionsTasksOutput {
    /// Creates a new builder-style object to manufacture [`ListDetectMitigationActionsTasksOutput`](crate::output::ListDetectMitigationActionsTasksOutput)
    pub fn builder() -> crate::output::list_detect_mitigation_actions_tasks_output::Builder {
        crate::output::list_detect_mitigation_actions_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectMitigationActionsExecutionsOutput {
    /// <p> List of actions executions. </p>
    pub actions_executions:
        std::option::Option<std::vec::Vec<crate::model::DetectMitigationActionExecution>>,
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDetectMitigationActionsExecutionsOutput {
    /// <p> List of actions executions. </p>
    pub fn actions_executions(
        &self,
    ) -> std::option::Option<&[crate::model::DetectMitigationActionExecution]> {
        self.actions_executions.as_deref()
    }
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDetectMitigationActionsExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectMitigationActionsExecutionsOutput");
        formatter.field("actions_executions", &self.actions_executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDetectMitigationActionsExecutionsOutput`](crate::output::ListDetectMitigationActionsExecutionsOutput)
pub mod list_detect_mitigation_actions_executions_output {
    /// A builder for [`ListDetectMitigationActionsExecutionsOutput`](crate::output::ListDetectMitigationActionsExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions_executions:
            std::option::Option<std::vec::Vec<crate::model::DetectMitigationActionExecution>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `actions_executions`.
        ///
        /// To override the contents of this collection use [`set_actions_executions`](Self::set_actions_executions).
        ///
        /// <p> List of actions executions. </p>
        pub fn actions_executions(
            mut self,
            input: crate::model::DetectMitigationActionExecution,
        ) -> Self {
            let mut v = self.actions_executions.unwrap_or_default();
            v.push(input);
            self.actions_executions = Some(v);
            self
        }
        /// <p> List of actions executions. </p>
        pub fn set_actions_executions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DetectMitigationActionExecution>,
            >,
        ) -> Self {
            self.actions_executions = input;
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectMitigationActionsExecutionsOutput`](crate::output::ListDetectMitigationActionsExecutionsOutput)
        pub fn build(self) -> crate::output::ListDetectMitigationActionsExecutionsOutput {
            crate::output::ListDetectMitigationActionsExecutionsOutput {
                actions_executions: self.actions_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDetectMitigationActionsExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDetectMitigationActionsExecutionsOutput`](crate::output::ListDetectMitigationActionsExecutionsOutput)
    pub fn builder() -> crate::output::list_detect_mitigation_actions_executions_output::Builder {
        crate::output::list_detect_mitigation_actions_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomMetricsOutput {
    /// <p> The name of the custom metric. </p>
    pub metric_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomMetricsOutput {
    /// <p> The name of the custom metric. </p>
    pub fn metric_names(&self) -> std::option::Option<&[std::string::String]> {
        self.metric_names.as_deref()
    }
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomMetricsOutput");
        formatter.field("metric_names", &self.metric_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCustomMetricsOutput`](crate::output::ListCustomMetricsOutput)
pub mod list_custom_metrics_output {
    /// A builder for [`ListCustomMetricsOutput`](crate::output::ListCustomMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `metric_names`.
        ///
        /// To override the contents of this collection use [`set_metric_names`](Self::set_metric_names).
        ///
        /// <p> The name of the custom metric. </p>
        pub fn metric_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metric_names.unwrap_or_default();
            v.push(input.into());
            self.metric_names = Some(v);
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metric_names = input;
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomMetricsOutput`](crate::output::ListCustomMetricsOutput)
        pub fn build(self) -> crate::output::ListCustomMetricsOutput {
            crate::output::ListCustomMetricsOutput {
                metric_names: self.metric_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCustomMetricsOutput {
    /// Creates a new builder-style object to manufacture [`ListCustomMetricsOutput`](crate::output::ListCustomMetricsOutput)
    pub fn builder() -> crate::output::list_custom_metrics_output::Builder {
        crate::output::list_custom_metrics_output::Builder::default()
    }
}

/// <p>The output of the ListCertificatesByCA operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCertificatesByCaOutput {
    /// <p>The device certificates signed by the specified CA certificate.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListCertificatesByCaOutput {
    /// <p>The device certificates signed by the specified CA certificate.</p>
    pub fn certificates(&self) -> std::option::Option<&[crate::model::Certificate]> {
        self.certificates.as_deref()
    }
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListCertificatesByCaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCertificatesByCaOutput");
        formatter.field("certificates", &self.certificates);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListCertificatesByCaOutput`](crate::output::ListCertificatesByCaOutput)
pub mod list_certificates_by_ca_output {
    /// A builder for [`ListCertificatesByCaOutput`](crate::output::ListCertificatesByCaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The device certificates signed by the specified CA certificate.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input);
            self.certificates = Some(v);
            self
        }
        /// <p>The device certificates signed by the specified CA certificate.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCertificatesByCaOutput`](crate::output::ListCertificatesByCaOutput)
        pub fn build(self) -> crate::output::ListCertificatesByCaOutput {
            crate::output::ListCertificatesByCaOutput {
                certificates: self.certificates,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListCertificatesByCaOutput {
    /// Creates a new builder-style object to manufacture [`ListCertificatesByCaOutput`](crate::output::ListCertificatesByCaOutput)
    pub fn builder() -> crate::output::list_certificates_by_ca_output::Builder {
        crate::output::list_certificates_by_ca_output::Builder::default()
    }
}

/// <p>The output of the ListCertificates operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCertificatesOutput {
    /// <p>The descriptions of the certificates.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListCertificatesOutput {
    /// <p>The descriptions of the certificates.</p>
    pub fn certificates(&self) -> std::option::Option<&[crate::model::Certificate]> {
        self.certificates.as_deref()
    }
    /// <p>The marker for the next set of results, or null if there are no additional results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCertificatesOutput");
        formatter.field("certificates", &self.certificates);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
pub mod list_certificates_output {
    /// A builder for [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The descriptions of the certificates.</p>
        pub fn certificates(mut self, input: crate::model::Certificate) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input);
            self.certificates = Some(v);
            self
        }
        /// <p>The descriptions of the certificates.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The marker for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
        pub fn build(self) -> crate::output::ListCertificatesOutput {
            crate::output::ListCertificatesOutput {
                certificates: self.certificates,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`ListCertificatesOutput`](crate::output::ListCertificatesOutput)
    pub fn builder() -> crate::output::list_certificates_output::Builder {
        crate::output::list_certificates_output::Builder::default()
    }
}

/// <p>The output from the ListCACertificates operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCaCertificatesOutput {
    /// <p>The CA certificates registered in your Amazon Web Services account.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::CaCertificate>>,
    /// <p>The current position within the list of CA certificates.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListCaCertificatesOutput {
    /// <p>The CA certificates registered in your Amazon Web Services account.</p>
    pub fn certificates(&self) -> std::option::Option<&[crate::model::CaCertificate]> {
        self.certificates.as_deref()
    }
    /// <p>The current position within the list of CA certificates.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListCaCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCaCertificatesOutput");
        formatter.field("certificates", &self.certificates);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListCaCertificatesOutput`](crate::output::ListCaCertificatesOutput)
pub mod list_ca_certificates_output {
    /// A builder for [`ListCaCertificatesOutput`](crate::output::ListCaCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::CaCertificate>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The CA certificates registered in your Amazon Web Services account.</p>
        pub fn certificates(mut self, input: crate::model::CaCertificate) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input);
            self.certificates = Some(v);
            self
        }
        /// <p>The CA certificates registered in your Amazon Web Services account.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaCertificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// <p>The current position within the list of CA certificates.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The current position within the list of CA certificates.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCaCertificatesOutput`](crate::output::ListCaCertificatesOutput)
        pub fn build(self) -> crate::output::ListCaCertificatesOutput {
            crate::output::ListCaCertificatesOutput {
                certificates: self.certificates,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListCaCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`ListCaCertificatesOutput`](crate::output::ListCaCertificatesOutput)
    pub fn builder() -> crate::output::list_ca_certificates_output::Builder {
        crate::output::list_ca_certificates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBillingGroupsOutput {
    /// <p>The list of billing groups.</p>
    pub billing_groups: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBillingGroupsOutput {
    /// <p>The list of billing groups.</p>
    pub fn billing_groups(&self) -> std::option::Option<&[crate::model::GroupNameAndArn]> {
        self.billing_groups.as_deref()
    }
    /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBillingGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBillingGroupsOutput");
        formatter.field("billing_groups", &self.billing_groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
pub mod list_billing_groups_output {
    /// A builder for [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_groups:
            std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `billing_groups`.
        ///
        /// To override the contents of this collection use [`set_billing_groups`](Self::set_billing_groups).
        ///
        /// <p>The list of billing groups.</p>
        pub fn billing_groups(mut self, input: crate::model::GroupNameAndArn) -> Self {
            let mut v = self.billing_groups.unwrap_or_default();
            v.push(input);
            self.billing_groups = Some(v);
            self
        }
        /// <p>The list of billing groups.</p>
        pub fn set_billing_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupNameAndArn>>,
        ) -> Self {
            self.billing_groups = input;
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
        pub fn build(self) -> crate::output::ListBillingGroupsOutput {
            crate::output::ListBillingGroupsOutput {
                billing_groups: self.billing_groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBillingGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput)
    pub fn builder() -> crate::output::list_billing_groups_output::Builder {
        crate::output::list_billing_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAuthorizersOutput {
    /// <p>The authorizers.</p>
    pub authorizers: std::option::Option<std::vec::Vec<crate::model::AuthorizerSummary>>,
    /// <p>A marker used to get the next set of results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListAuthorizersOutput {
    /// <p>The authorizers.</p>
    pub fn authorizers(&self) -> std::option::Option<&[crate::model::AuthorizerSummary]> {
        self.authorizers.as_deref()
    }
    /// <p>A marker used to get the next set of results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListAuthorizersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAuthorizersOutput");
        formatter.field("authorizers", &self.authorizers);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListAuthorizersOutput`](crate::output::ListAuthorizersOutput)
pub mod list_authorizers_output {
    /// A builder for [`ListAuthorizersOutput`](crate::output::ListAuthorizersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizers: std::option::Option<std::vec::Vec<crate::model::AuthorizerSummary>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `authorizers`.
        ///
        /// To override the contents of this collection use [`set_authorizers`](Self::set_authorizers).
        ///
        /// <p>The authorizers.</p>
        pub fn authorizers(mut self, input: crate::model::AuthorizerSummary) -> Self {
            let mut v = self.authorizers.unwrap_or_default();
            v.push(input);
            self.authorizers = Some(v);
            self
        }
        /// <p>The authorizers.</p>
        pub fn set_authorizers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthorizerSummary>>,
        ) -> Self {
            self.authorizers = input;
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAuthorizersOutput`](crate::output::ListAuthorizersOutput)
        pub fn build(self) -> crate::output::ListAuthorizersOutput {
            crate::output::ListAuthorizersOutput {
                authorizers: self.authorizers,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListAuthorizersOutput {
    /// Creates a new builder-style object to manufacture [`ListAuthorizersOutput`](crate::output::ListAuthorizersOutput)
    pub fn builder() -> crate::output::list_authorizers_output::Builder {
        crate::output::list_authorizers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAuditTasksOutput {
    /// <p>The audits that were performed during the specified time period.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::AuditTaskMetadata>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAuditTasksOutput {
    /// <p>The audits that were performed during the specified time period.</p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::AuditTaskMetadata]> {
        self.tasks.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAuditTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAuditTasksOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAuditTasksOutput`](crate::output::ListAuditTasksOutput)
pub mod list_audit_tasks_output {
    /// A builder for [`ListAuditTasksOutput`](crate::output::ListAuditTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::AuditTaskMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>The audits that were performed during the specified time period.</p>
        pub fn tasks(mut self, input: crate::model::AuditTaskMetadata) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p>The audits that were performed during the specified time period.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuditTaskMetadata>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAuditTasksOutput`](crate::output::ListAuditTasksOutput)
        pub fn build(self) -> crate::output::ListAuditTasksOutput {
            crate::output::ListAuditTasksOutput {
                tasks: self.tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAuditTasksOutput {
    /// Creates a new builder-style object to manufacture [`ListAuditTasksOutput`](crate::output::ListAuditTasksOutput)
    pub fn builder() -> crate::output::list_audit_tasks_output::Builder {
        crate::output::list_audit_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAuditSuppressionsOutput {
    /// <p> List of audit suppressions. </p>
    pub suppressions: std::option::Option<std::vec::Vec<crate::model::AuditSuppression>>,
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAuditSuppressionsOutput {
    /// <p> List of audit suppressions. </p>
    pub fn suppressions(&self) -> std::option::Option<&[crate::model::AuditSuppression]> {
        self.suppressions.as_deref()
    }
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAuditSuppressionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAuditSuppressionsOutput");
        formatter.field("suppressions", &self.suppressions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAuditSuppressionsOutput`](crate::output::ListAuditSuppressionsOutput)
pub mod list_audit_suppressions_output {
    /// A builder for [`ListAuditSuppressionsOutput`](crate::output::ListAuditSuppressionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suppressions: std::option::Option<std::vec::Vec<crate::model::AuditSuppression>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `suppressions`.
        ///
        /// To override the contents of this collection use [`set_suppressions`](Self::set_suppressions).
        ///
        /// <p> List of audit suppressions. </p>
        pub fn suppressions(mut self, input: crate::model::AuditSuppression) -> Self {
            let mut v = self.suppressions.unwrap_or_default();
            v.push(input);
            self.suppressions = Some(v);
            self
        }
        /// <p> List of audit suppressions. </p>
        pub fn set_suppressions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuditSuppression>>,
        ) -> Self {
            self.suppressions = input;
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAuditSuppressionsOutput`](crate::output::ListAuditSuppressionsOutput)
        pub fn build(self) -> crate::output::ListAuditSuppressionsOutput {
            crate::output::ListAuditSuppressionsOutput {
                suppressions: self.suppressions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAuditSuppressionsOutput {
    /// Creates a new builder-style object to manufacture [`ListAuditSuppressionsOutput`](crate::output::ListAuditSuppressionsOutput)
    pub fn builder() -> crate::output::list_audit_suppressions_output::Builder {
        crate::output::list_audit_suppressions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAuditMitigationActionsTasksOutput {
    /// <p>The collection of audit mitigation tasks that matched the filter criteria.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::AuditMitigationActionsTaskMetadata>>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAuditMitigationActionsTasksOutput {
    /// <p>The collection of audit mitigation tasks that matched the filter criteria.</p>
    pub fn tasks(
        &self,
    ) -> std::option::Option<&[crate::model::AuditMitigationActionsTaskMetadata]> {
        self.tasks.as_deref()
    }
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAuditMitigationActionsTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAuditMitigationActionsTasksOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAuditMitigationActionsTasksOutput`](crate::output::ListAuditMitigationActionsTasksOutput)
pub mod list_audit_mitigation_actions_tasks_output {
    /// A builder for [`ListAuditMitigationActionsTasksOutput`](crate::output::ListAuditMitigationActionsTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks:
            std::option::Option<std::vec::Vec<crate::model::AuditMitigationActionsTaskMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>The collection of audit mitigation tasks that matched the filter criteria.</p>
        pub fn tasks(mut self, input: crate::model::AuditMitigationActionsTaskMetadata) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p>The collection of audit mitigation tasks that matched the filter criteria.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AuditMitigationActionsTaskMetadata>,
            >,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAuditMitigationActionsTasksOutput`](crate::output::ListAuditMitigationActionsTasksOutput)
        pub fn build(self) -> crate::output::ListAuditMitigationActionsTasksOutput {
            crate::output::ListAuditMitigationActionsTasksOutput {
                tasks: self.tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAuditMitigationActionsTasksOutput {
    /// Creates a new builder-style object to manufacture [`ListAuditMitigationActionsTasksOutput`](crate::output::ListAuditMitigationActionsTasksOutput)
    pub fn builder() -> crate::output::list_audit_mitigation_actions_tasks_output::Builder {
        crate::output::list_audit_mitigation_actions_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAuditMitigationActionsExecutionsOutput {
    /// <p>A set of task execution results based on the input parameters. Details include the mitigation action applied, start time, and task status.</p>
    pub actions_executions:
        std::option::Option<std::vec::Vec<crate::model::AuditMitigationActionExecutionMetadata>>,
    /// <p>The token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAuditMitigationActionsExecutionsOutput {
    /// <p>A set of task execution results based on the input parameters. Details include the mitigation action applied, start time, and task status.</p>
    pub fn actions_executions(
        &self,
    ) -> std::option::Option<&[crate::model::AuditMitigationActionExecutionMetadata]> {
        self.actions_executions.as_deref()
    }
    /// <p>The token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAuditMitigationActionsExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAuditMitigationActionsExecutionsOutput");
        formatter.field("actions_executions", &self.actions_executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAuditMitigationActionsExecutionsOutput`](crate::output::ListAuditMitigationActionsExecutionsOutput)
pub mod list_audit_mitigation_actions_executions_output {
    /// A builder for [`ListAuditMitigationActionsExecutionsOutput`](crate::output::ListAuditMitigationActionsExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions_executions: std::option::Option<
            std::vec::Vec<crate::model::AuditMitigationActionExecutionMetadata>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `actions_executions`.
        ///
        /// To override the contents of this collection use [`set_actions_executions`](Self::set_actions_executions).
        ///
        /// <p>A set of task execution results based on the input parameters. Details include the mitigation action applied, start time, and task status.</p>
        pub fn actions_executions(
            mut self,
            input: crate::model::AuditMitigationActionExecutionMetadata,
        ) -> Self {
            let mut v = self.actions_executions.unwrap_or_default();
            v.push(input);
            self.actions_executions = Some(v);
            self
        }
        /// <p>A set of task execution results based on the input parameters. Details include the mitigation action applied, start time, and task status.</p>
        pub fn set_actions_executions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AuditMitigationActionExecutionMetadata>,
            >,
        ) -> Self {
            self.actions_executions = input;
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAuditMitigationActionsExecutionsOutput`](crate::output::ListAuditMitigationActionsExecutionsOutput)
        pub fn build(self) -> crate::output::ListAuditMitigationActionsExecutionsOutput {
            crate::output::ListAuditMitigationActionsExecutionsOutput {
                actions_executions: self.actions_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAuditMitigationActionsExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListAuditMitigationActionsExecutionsOutput`](crate::output::ListAuditMitigationActionsExecutionsOutput)
    pub fn builder() -> crate::output::list_audit_mitigation_actions_executions_output::Builder {
        crate::output::list_audit_mitigation_actions_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAuditFindingsOutput {
    /// <p>The findings (results) of the audit.</p>
    pub findings: std::option::Option<std::vec::Vec<crate::model::AuditFinding>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAuditFindingsOutput {
    /// <p>The findings (results) of the audit.</p>
    pub fn findings(&self) -> std::option::Option<&[crate::model::AuditFinding]> {
        self.findings.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAuditFindingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAuditFindingsOutput");
        formatter.field("findings", &self.findings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAuditFindingsOutput`](crate::output::ListAuditFindingsOutput)
pub mod list_audit_findings_output {
    /// A builder for [`ListAuditFindingsOutput`](crate::output::ListAuditFindingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) findings: std::option::Option<std::vec::Vec<crate::model::AuditFinding>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `findings`.
        ///
        /// To override the contents of this collection use [`set_findings`](Self::set_findings).
        ///
        /// <p>The findings (results) of the audit.</p>
        pub fn findings(mut self, input: crate::model::AuditFinding) -> Self {
            let mut v = self.findings.unwrap_or_default();
            v.push(input);
            self.findings = Some(v);
            self
        }
        /// <p>The findings (results) of the audit.</p>
        pub fn set_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuditFinding>>,
        ) -> Self {
            self.findings = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAuditFindingsOutput`](crate::output::ListAuditFindingsOutput)
        pub fn build(self) -> crate::output::ListAuditFindingsOutput {
            crate::output::ListAuditFindingsOutput {
                findings: self.findings,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAuditFindingsOutput {
    /// Creates a new builder-style object to manufacture [`ListAuditFindingsOutput`](crate::output::ListAuditFindingsOutput)
    pub fn builder() -> crate::output::list_audit_findings_output::Builder {
        crate::output::list_audit_findings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttachedPoliciesOutput {
    /// <p>The policies.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
    /// <p>The token to retrieve the next set of results, or ``null`` if there are no more results.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListAttachedPoliciesOutput {
    /// <p>The policies.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::Policy]> {
        self.policies.as_deref()
    }
    /// <p>The token to retrieve the next set of results, or ``null`` if there are no more results.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListAttachedPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttachedPoliciesOutput");
        formatter.field("policies", &self.policies);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListAttachedPoliciesOutput`](crate::output::ListAttachedPoliciesOutput)
pub mod list_attached_policies_output {
    /// A builder for [`ListAttachedPoliciesOutput`](crate::output::ListAttachedPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>The policies.</p>
        pub fn policies(mut self, input: crate::model::Policy) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input);
            self.policies = Some(v);
            self
        }
        /// <p>The policies.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The token to retrieve the next set of results, or ``null`` if there are no more results.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results, or ``null`` if there are no more results.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedPoliciesOutput`](crate::output::ListAttachedPoliciesOutput)
        pub fn build(self) -> crate::output::ListAttachedPoliciesOutput {
            crate::output::ListAttachedPoliciesOutput {
                policies: self.policies,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListAttachedPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListAttachedPoliciesOutput`](crate::output::ListAttachedPoliciesOutput)
    pub fn builder() -> crate::output::list_attached_policies_output::Builder {
        crate::output::list_attached_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActiveViolationsOutput {
    /// <p>The list of active violations.</p>
    pub active_violations: std::option::Option<std::vec::Vec<crate::model::ActiveViolation>>,
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListActiveViolationsOutput {
    /// <p>The list of active violations.</p>
    pub fn active_violations(&self) -> std::option::Option<&[crate::model::ActiveViolation]> {
        self.active_violations.as_deref()
    }
    /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListActiveViolationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActiveViolationsOutput");
        formatter.field("active_violations", &self.active_violations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListActiveViolationsOutput`](crate::output::ListActiveViolationsOutput)
pub mod list_active_violations_output {
    /// A builder for [`ListActiveViolationsOutput`](crate::output::ListActiveViolationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_violations:
            std::option::Option<std::vec::Vec<crate::model::ActiveViolation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `active_violations`.
        ///
        /// To override the contents of this collection use [`set_active_violations`](Self::set_active_violations).
        ///
        /// <p>The list of active violations.</p>
        pub fn active_violations(mut self, input: crate::model::ActiveViolation) -> Self {
            let mut v = self.active_violations.unwrap_or_default();
            v.push(input);
            self.active_violations = Some(v);
            self
        }
        /// <p>The list of active violations.</p>
        pub fn set_active_violations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveViolation>>,
        ) -> Self {
            self.active_violations = input;
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActiveViolationsOutput`](crate::output::ListActiveViolationsOutput)
        pub fn build(self) -> crate::output::ListActiveViolationsOutput {
            crate::output::ListActiveViolationsOutput {
                active_violations: self.active_violations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListActiveViolationsOutput {
    /// Creates a new builder-style object to manufacture [`ListActiveViolationsOutput`](crate::output::ListActiveViolationsOutput)
    pub fn builder() -> crate::output::list_active_violations_output::Builder {
        crate::output::list_active_violations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetV2LoggingOptionsOutput {
    /// <p>The IAM role ARN IoT uses to write to your CloudWatch logs.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The default log level.</p>
    pub default_log_level: std::option::Option<crate::model::LogLevel>,
    /// <p>Disables all logs.</p>
    pub disable_all_logs: bool,
}
impl GetV2LoggingOptionsOutput {
    /// <p>The IAM role ARN IoT uses to write to your CloudWatch logs.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The default log level.</p>
    pub fn default_log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.default_log_level.as_ref()
    }
    /// <p>Disables all logs.</p>
    pub fn disable_all_logs(&self) -> bool {
        self.disable_all_logs
    }
}
impl std::fmt::Debug for GetV2LoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetV2LoggingOptionsOutput");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("default_log_level", &self.default_log_level);
        formatter.field("disable_all_logs", &self.disable_all_logs);
        formatter.finish()
    }
}
/// See [`GetV2LoggingOptionsOutput`](crate::output::GetV2LoggingOptionsOutput)
pub mod get_v2_logging_options_output {
    /// A builder for [`GetV2LoggingOptionsOutput`](crate::output::GetV2LoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) default_log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) disable_all_logs: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The IAM role ARN IoT uses to write to your CloudWatch logs.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role ARN IoT uses to write to your CloudWatch logs.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The default log level.</p>
        pub fn default_log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.default_log_level = Some(input);
            self
        }
        /// <p>The default log level.</p>
        pub fn set_default_log_level(
            mut self,
            input: std::option::Option<crate::model::LogLevel>,
        ) -> Self {
            self.default_log_level = input;
            self
        }
        /// <p>Disables all logs.</p>
        pub fn disable_all_logs(mut self, input: bool) -> Self {
            self.disable_all_logs = Some(input);
            self
        }
        /// <p>Disables all logs.</p>
        pub fn set_disable_all_logs(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_all_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`GetV2LoggingOptionsOutput`](crate::output::GetV2LoggingOptionsOutput)
        pub fn build(self) -> crate::output::GetV2LoggingOptionsOutput {
            crate::output::GetV2LoggingOptionsOutput {
                role_arn: self.role_arn,
                default_log_level: self.default_log_level,
                disable_all_logs: self.disable_all_logs.unwrap_or_default(),
            }
        }
    }
}
impl GetV2LoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`GetV2LoggingOptionsOutput`](crate::output::GetV2LoggingOptionsOutput)
    pub fn builder() -> crate::output::get_v2_logging_options_output::Builder {
        crate::output::get_v2_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTopicRuleDestinationOutput {
    /// <p>The topic rule destination.</p>
    pub topic_rule_destination: std::option::Option<crate::model::TopicRuleDestination>,
}
impl GetTopicRuleDestinationOutput {
    /// <p>The topic rule destination.</p>
    pub fn topic_rule_destination(
        &self,
    ) -> std::option::Option<&crate::model::TopicRuleDestination> {
        self.topic_rule_destination.as_ref()
    }
}
impl std::fmt::Debug for GetTopicRuleDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTopicRuleDestinationOutput");
        formatter.field("topic_rule_destination", &self.topic_rule_destination);
        formatter.finish()
    }
}
/// See [`GetTopicRuleDestinationOutput`](crate::output::GetTopicRuleDestinationOutput)
pub mod get_topic_rule_destination_output {
    /// A builder for [`GetTopicRuleDestinationOutput`](crate::output::GetTopicRuleDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_rule_destination: std::option::Option<crate::model::TopicRuleDestination>,
    }
    impl Builder {
        /// <p>The topic rule destination.</p>
        pub fn topic_rule_destination(mut self, input: crate::model::TopicRuleDestination) -> Self {
            self.topic_rule_destination = Some(input);
            self
        }
        /// <p>The topic rule destination.</p>
        pub fn set_topic_rule_destination(
            mut self,
            input: std::option::Option<crate::model::TopicRuleDestination>,
        ) -> Self {
            self.topic_rule_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTopicRuleDestinationOutput`](crate::output::GetTopicRuleDestinationOutput)
        pub fn build(self) -> crate::output::GetTopicRuleDestinationOutput {
            crate::output::GetTopicRuleDestinationOutput {
                topic_rule_destination: self.topic_rule_destination,
            }
        }
    }
}
impl GetTopicRuleDestinationOutput {
    /// Creates a new builder-style object to manufacture [`GetTopicRuleDestinationOutput`](crate::output::GetTopicRuleDestinationOutput)
    pub fn builder() -> crate::output::get_topic_rule_destination_output::Builder {
        crate::output::get_topic_rule_destination_output::Builder::default()
    }
}

/// <p>The output from the GetTopicRule operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTopicRuleOutput {
    /// <p>The rule ARN.</p>
    pub rule_arn: std::option::Option<std::string::String>,
    /// <p>The rule.</p>
    pub rule: std::option::Option<crate::model::TopicRule>,
}
impl GetTopicRuleOutput {
    /// <p>The rule ARN.</p>
    pub fn rule_arn(&self) -> std::option::Option<&str> {
        self.rule_arn.as_deref()
    }
    /// <p>The rule.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::TopicRule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for GetTopicRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTopicRuleOutput");
        formatter.field("rule_arn", &self.rule_arn);
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}
/// See [`GetTopicRuleOutput`](crate::output::GetTopicRuleOutput)
pub mod get_topic_rule_output {
    /// A builder for [`GetTopicRuleOutput`](crate::output::GetTopicRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_arn: std::option::Option<std::string::String>,
        pub(crate) rule: std::option::Option<crate::model::TopicRule>,
    }
    impl Builder {
        /// <p>The rule ARN.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The rule ARN.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// <p>The rule.</p>
        pub fn rule(mut self, input: crate::model::TopicRule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>The rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::TopicRule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTopicRuleOutput`](crate::output::GetTopicRuleOutput)
        pub fn build(self) -> crate::output::GetTopicRuleOutput {
            crate::output::GetTopicRuleOutput {
                rule_arn: self.rule_arn,
                rule: self.rule,
            }
        }
    }
}
impl GetTopicRuleOutput {
    /// Creates a new builder-style object to manufacture [`GetTopicRuleOutput`](crate::output::GetTopicRuleOutput)
    pub fn builder() -> crate::output::get_topic_rule_output::Builder {
        crate::output::get_topic_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStatisticsOutput {
    /// <p>The statistics returned by the Fleet Indexing service based on the query and aggregation field.</p>
    pub statistics: std::option::Option<crate::model::Statistics>,
}
impl GetStatisticsOutput {
    /// <p>The statistics returned by the Fleet Indexing service based on the query and aggregation field.</p>
    pub fn statistics(&self) -> std::option::Option<&crate::model::Statistics> {
        self.statistics.as_ref()
    }
}
impl std::fmt::Debug for GetStatisticsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStatisticsOutput");
        formatter.field("statistics", &self.statistics);
        formatter.finish()
    }
}
/// See [`GetStatisticsOutput`](crate::output::GetStatisticsOutput)
pub mod get_statistics_output {
    /// A builder for [`GetStatisticsOutput`](crate::output::GetStatisticsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statistics: std::option::Option<crate::model::Statistics>,
    }
    impl Builder {
        /// <p>The statistics returned by the Fleet Indexing service based on the query and aggregation field.</p>
        pub fn statistics(mut self, input: crate::model::Statistics) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p>The statistics returned by the Fleet Indexing service based on the query and aggregation field.</p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::Statistics>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStatisticsOutput`](crate::output::GetStatisticsOutput)
        pub fn build(self) -> crate::output::GetStatisticsOutput {
            crate::output::GetStatisticsOutput {
                statistics: self.statistics,
            }
        }
    }
}
impl GetStatisticsOutput {
    /// Creates a new builder-style object to manufacture [`GetStatisticsOutput`](crate::output::GetStatisticsOutput)
    pub fn builder() -> crate::output::get_statistics_output::Builder {
        crate::output::get_statistics_output::Builder::default()
    }
}

/// <p>The output from the GetRegistrationCode operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegistrationCodeOutput {
    /// <p>The CA certificate registration code.</p>
    pub registration_code: std::option::Option<std::string::String>,
}
impl GetRegistrationCodeOutput {
    /// <p>The CA certificate registration code.</p>
    pub fn registration_code(&self) -> std::option::Option<&str> {
        self.registration_code.as_deref()
    }
}
impl std::fmt::Debug for GetRegistrationCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegistrationCodeOutput");
        formatter.field("registration_code", &self.registration_code);
        formatter.finish()
    }
}
/// See [`GetRegistrationCodeOutput`](crate::output::GetRegistrationCodeOutput)
pub mod get_registration_code_output {
    /// A builder for [`GetRegistrationCodeOutput`](crate::output::GetRegistrationCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registration_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CA certificate registration code.</p>
        pub fn registration_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.registration_code = Some(input.into());
            self
        }
        /// <p>The CA certificate registration code.</p>
        pub fn set_registration_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registration_code = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegistrationCodeOutput`](crate::output::GetRegistrationCodeOutput)
        pub fn build(self) -> crate::output::GetRegistrationCodeOutput {
            crate::output::GetRegistrationCodeOutput {
                registration_code: self.registration_code,
            }
        }
    }
}
impl GetRegistrationCodeOutput {
    /// Creates a new builder-style object to manufacture [`GetRegistrationCodeOutput`](crate::output::GetRegistrationCodeOutput)
    pub fn builder() -> crate::output::get_registration_code_output::Builder {
        crate::output::get_registration_code_output::Builder::default()
    }
}

/// <p>The output from the GetPolicyVersion operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyVersionOutput {
    /// <p>The policy ARN.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The policy name.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The JSON document that describes the policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
    /// <p>The policy version ID.</p>
    pub policy_version_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the policy version is the default.</p>
    pub is_default_version: bool,
    /// <p>The date the policy was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the policy was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The generation ID of the policy version.</p>
    pub generation_id: std::option::Option<std::string::String>,
}
impl GetPolicyVersionOutput {
    /// <p>The policy ARN.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The policy name.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The JSON document that describes the policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
    /// <p>The policy version ID.</p>
    pub fn policy_version_id(&self) -> std::option::Option<&str> {
        self.policy_version_id.as_deref()
    }
    /// <p>Specifies whether the policy version is the default.</p>
    pub fn is_default_version(&self) -> bool {
        self.is_default_version
    }
    /// <p>The date the policy was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the policy was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The generation ID of the policy version.</p>
    pub fn generation_id(&self) -> std::option::Option<&str> {
        self.generation_id.as_deref()
    }
}
impl std::fmt::Debug for GetPolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyVersionOutput");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_document", &self.policy_document);
        formatter.field("policy_version_id", &self.policy_version_id);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("generation_id", &self.generation_id);
        formatter.finish()
    }
}
/// See [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
pub mod get_policy_version_output {
    /// A builder for [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<std::string::String>,
        pub(crate) is_default_version: std::option::Option<bool>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) generation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy ARN.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The policy ARN.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_version_id = Some(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_version_id = input;
            self
        }
        /// <p>Specifies whether the policy version is the default.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>Specifies whether the policy version is the default.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// <p>The date the policy was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the policy was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the policy was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the policy was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The generation ID of the policy version.</p>
        pub fn generation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_id = Some(input.into());
            self
        }
        /// <p>The generation ID of the policy version.</p>
        pub fn set_generation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
        pub fn build(self) -> crate::output::GetPolicyVersionOutput {
            crate::output::GetPolicyVersionOutput {
                policy_arn: self.policy_arn,
                policy_name: self.policy_name,
                policy_document: self.policy_document,
                policy_version_id: self.policy_version_id,
                is_default_version: self.is_default_version.unwrap_or_default(),
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                generation_id: self.generation_id,
            }
        }
    }
}
impl GetPolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
    pub fn builder() -> crate::output::get_policy_version_output::Builder {
        crate::output::get_policy_version_output::Builder::default()
    }
}

/// <p>The output from the GetPolicy operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyOutput {
    /// <p>The policy name.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy ARN.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The JSON document that describes the policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
    /// <p>The default policy version ID.</p>
    pub default_version_id: std::option::Option<std::string::String>,
    /// <p>The date the policy was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the policy was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The generation ID of the policy.</p>
    pub generation_id: std::option::Option<std::string::String>,
}
impl GetPolicyOutput {
    /// <p>The policy name.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy ARN.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The JSON document that describes the policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
    /// <p>The default policy version ID.</p>
    pub fn default_version_id(&self) -> std::option::Option<&str> {
        self.default_version_id.as_deref()
    }
    /// <p>The date the policy was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the policy was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The generation ID of the policy.</p>
    pub fn generation_id(&self) -> std::option::Option<&str> {
        self.generation_id.as_deref()
    }
}
impl std::fmt::Debug for GetPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyOutput");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_document", &self.policy_document);
        formatter.field("default_version_id", &self.default_version_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("generation_id", &self.generation_id);
        formatter.finish()
    }
}
/// See [`GetPolicyOutput`](crate::output::GetPolicyOutput)
pub mod get_policy_output {
    /// A builder for [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) default_version_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) generation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy ARN.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The policy ARN.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>The default policy version ID.</p>
        pub fn default_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_version_id = Some(input.into());
            self
        }
        /// <p>The default policy version ID.</p>
        pub fn set_default_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_version_id = input;
            self
        }
        /// <p>The date the policy was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the policy was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the policy was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the policy was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The generation ID of the policy.</p>
        pub fn generation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_id = Some(input.into());
            self
        }
        /// <p>The generation ID of the policy.</p>
        pub fn set_generation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyOutput`](crate::output::GetPolicyOutput)
        pub fn build(self) -> crate::output::GetPolicyOutput {
            crate::output::GetPolicyOutput {
                policy_name: self.policy_name,
                policy_arn: self.policy_arn,
                policy_document: self.policy_document,
                default_version_id: self.default_version_id,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                generation_id: self.generation_id,
            }
        }
    }
}
impl GetPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    pub fn builder() -> crate::output::get_policy_output::Builder {
        crate::output::get_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPercentilesOutput {
    /// <p>The percentile values of the aggregated fields.</p>
    pub percentiles: std::option::Option<std::vec::Vec<crate::model::PercentPair>>,
}
impl GetPercentilesOutput {
    /// <p>The percentile values of the aggregated fields.</p>
    pub fn percentiles(&self) -> std::option::Option<&[crate::model::PercentPair]> {
        self.percentiles.as_deref()
    }
}
impl std::fmt::Debug for GetPercentilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPercentilesOutput");
        formatter.field("percentiles", &self.percentiles);
        formatter.finish()
    }
}
/// See [`GetPercentilesOutput`](crate::output::GetPercentilesOutput)
pub mod get_percentiles_output {
    /// A builder for [`GetPercentilesOutput`](crate::output::GetPercentilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percentiles: std::option::Option<std::vec::Vec<crate::model::PercentPair>>,
    }
    impl Builder {
        /// Appends an item to `percentiles`.
        ///
        /// To override the contents of this collection use [`set_percentiles`](Self::set_percentiles).
        ///
        /// <p>The percentile values of the aggregated fields.</p>
        pub fn percentiles(mut self, input: crate::model::PercentPair) -> Self {
            let mut v = self.percentiles.unwrap_or_default();
            v.push(input);
            self.percentiles = Some(v);
            self
        }
        /// <p>The percentile values of the aggregated fields.</p>
        pub fn set_percentiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PercentPair>>,
        ) -> Self {
            self.percentiles = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPercentilesOutput`](crate::output::GetPercentilesOutput)
        pub fn build(self) -> crate::output::GetPercentilesOutput {
            crate::output::GetPercentilesOutput {
                percentiles: self.percentiles,
            }
        }
    }
}
impl GetPercentilesOutput {
    /// Creates a new builder-style object to manufacture [`GetPercentilesOutput`](crate::output::GetPercentilesOutput)
    pub fn builder() -> crate::output::get_percentiles_output::Builder {
        crate::output::get_percentiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOtaUpdateOutput {
    /// <p>The OTA update info.</p>
    pub ota_update_info: std::option::Option<crate::model::OtaUpdateInfo>,
}
impl GetOtaUpdateOutput {
    /// <p>The OTA update info.</p>
    pub fn ota_update_info(&self) -> std::option::Option<&crate::model::OtaUpdateInfo> {
        self.ota_update_info.as_ref()
    }
}
impl std::fmt::Debug for GetOtaUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOtaUpdateOutput");
        formatter.field("ota_update_info", &self.ota_update_info);
        formatter.finish()
    }
}
/// See [`GetOtaUpdateOutput`](crate::output::GetOtaUpdateOutput)
pub mod get_ota_update_output {
    /// A builder for [`GetOtaUpdateOutput`](crate::output::GetOtaUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_update_info: std::option::Option<crate::model::OtaUpdateInfo>,
    }
    impl Builder {
        /// <p>The OTA update info.</p>
        pub fn ota_update_info(mut self, input: crate::model::OtaUpdateInfo) -> Self {
            self.ota_update_info = Some(input);
            self
        }
        /// <p>The OTA update info.</p>
        pub fn set_ota_update_info(
            mut self,
            input: std::option::Option<crate::model::OtaUpdateInfo>,
        ) -> Self {
            self.ota_update_info = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOtaUpdateOutput`](crate::output::GetOtaUpdateOutput)
        pub fn build(self) -> crate::output::GetOtaUpdateOutput {
            crate::output::GetOtaUpdateOutput {
                ota_update_info: self.ota_update_info,
            }
        }
    }
}
impl GetOtaUpdateOutput {
    /// Creates a new builder-style object to manufacture [`GetOtaUpdateOutput`](crate::output::GetOtaUpdateOutput)
    pub fn builder() -> crate::output::get_ota_update_output::Builder {
        crate::output::get_ota_update_output::Builder::default()
    }
}

/// <p>The output from the GetLoggingOptions operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLoggingOptionsOutput {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The logging level.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl GetLoggingOptionsOutput {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The logging level.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for GetLoggingOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLoggingOptionsOutput");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`GetLoggingOptionsOutput`](crate::output::GetLoggingOptionsOutput)
pub mod get_logging_options_output {
    /// A builder for [`GetLoggingOptionsOutput`](crate::output::GetLoggingOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The logging level.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The logging level.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoggingOptionsOutput`](crate::output::GetLoggingOptionsOutput)
        pub fn build(self) -> crate::output::GetLoggingOptionsOutput {
            crate::output::GetLoggingOptionsOutput {
                role_arn: self.role_arn,
                log_level: self.log_level,
            }
        }
    }
}
impl GetLoggingOptionsOutput {
    /// Creates a new builder-style object to manufacture [`GetLoggingOptionsOutput`](crate::output::GetLoggingOptionsOutput)
    pub fn builder() -> crate::output::get_logging_options_output::Builder {
        crate::output::get_logging_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobDocumentOutput {
    /// <p>The job document content.</p>
    pub document: std::option::Option<std::string::String>,
}
impl GetJobDocumentOutput {
    /// <p>The job document content.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
}
impl std::fmt::Debug for GetJobDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobDocumentOutput");
        formatter.field("document", &self.document);
        formatter.finish()
    }
}
/// See [`GetJobDocumentOutput`](crate::output::GetJobDocumentOutput)
pub mod get_job_document_output {
    /// A builder for [`GetJobDocumentOutput`](crate::output::GetJobDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job document content.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The job document content.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobDocumentOutput`](crate::output::GetJobDocumentOutput)
        pub fn build(self) -> crate::output::GetJobDocumentOutput {
            crate::output::GetJobDocumentOutput {
                document: self.document,
            }
        }
    }
}
impl GetJobDocumentOutput {
    /// Creates a new builder-style object to manufacture [`GetJobDocumentOutput`](crate::output::GetJobDocumentOutput)
    pub fn builder() -> crate::output::get_job_document_output::Builder {
        crate::output::get_job_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIndexingConfigurationOutput {
    /// <p>Thing indexing configuration.</p>
    pub thing_indexing_configuration: std::option::Option<crate::model::ThingIndexingConfiguration>,
    /// <p>The index configuration.</p>
    pub thing_group_indexing_configuration:
        std::option::Option<crate::model::ThingGroupIndexingConfiguration>,
}
impl GetIndexingConfigurationOutput {
    /// <p>Thing indexing configuration.</p>
    pub fn thing_indexing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ThingIndexingConfiguration> {
        self.thing_indexing_configuration.as_ref()
    }
    /// <p>The index configuration.</p>
    pub fn thing_group_indexing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ThingGroupIndexingConfiguration> {
        self.thing_group_indexing_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetIndexingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIndexingConfigurationOutput");
        formatter.field(
            "thing_indexing_configuration",
            &self.thing_indexing_configuration,
        );
        formatter.field(
            "thing_group_indexing_configuration",
            &self.thing_group_indexing_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetIndexingConfigurationOutput`](crate::output::GetIndexingConfigurationOutput)
pub mod get_indexing_configuration_output {
    /// A builder for [`GetIndexingConfigurationOutput`](crate::output::GetIndexingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_indexing_configuration:
            std::option::Option<crate::model::ThingIndexingConfiguration>,
        pub(crate) thing_group_indexing_configuration:
            std::option::Option<crate::model::ThingGroupIndexingConfiguration>,
    }
    impl Builder {
        /// <p>Thing indexing configuration.</p>
        pub fn thing_indexing_configuration(
            mut self,
            input: crate::model::ThingIndexingConfiguration,
        ) -> Self {
            self.thing_indexing_configuration = Some(input);
            self
        }
        /// <p>Thing indexing configuration.</p>
        pub fn set_thing_indexing_configuration(
            mut self,
            input: std::option::Option<crate::model::ThingIndexingConfiguration>,
        ) -> Self {
            self.thing_indexing_configuration = input;
            self
        }
        /// <p>The index configuration.</p>
        pub fn thing_group_indexing_configuration(
            mut self,
            input: crate::model::ThingGroupIndexingConfiguration,
        ) -> Self {
            self.thing_group_indexing_configuration = Some(input);
            self
        }
        /// <p>The index configuration.</p>
        pub fn set_thing_group_indexing_configuration(
            mut self,
            input: std::option::Option<crate::model::ThingGroupIndexingConfiguration>,
        ) -> Self {
            self.thing_group_indexing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIndexingConfigurationOutput`](crate::output::GetIndexingConfigurationOutput)
        pub fn build(self) -> crate::output::GetIndexingConfigurationOutput {
            crate::output::GetIndexingConfigurationOutput {
                thing_indexing_configuration: self.thing_indexing_configuration,
                thing_group_indexing_configuration: self.thing_group_indexing_configuration,
            }
        }
    }
}
impl GetIndexingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetIndexingConfigurationOutput`](crate::output::GetIndexingConfigurationOutput)
    pub fn builder() -> crate::output::get_indexing_configuration_output::Builder {
        crate::output::get_indexing_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEffectivePoliciesOutput {
    /// <p>The effective policies.</p>
    pub effective_policies: std::option::Option<std::vec::Vec<crate::model::EffectivePolicy>>,
}
impl GetEffectivePoliciesOutput {
    /// <p>The effective policies.</p>
    pub fn effective_policies(&self) -> std::option::Option<&[crate::model::EffectivePolicy]> {
        self.effective_policies.as_deref()
    }
}
impl std::fmt::Debug for GetEffectivePoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEffectivePoliciesOutput");
        formatter.field("effective_policies", &self.effective_policies);
        formatter.finish()
    }
}
/// See [`GetEffectivePoliciesOutput`](crate::output::GetEffectivePoliciesOutput)
pub mod get_effective_policies_output {
    /// A builder for [`GetEffectivePoliciesOutput`](crate::output::GetEffectivePoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) effective_policies:
            std::option::Option<std::vec::Vec<crate::model::EffectivePolicy>>,
    }
    impl Builder {
        /// Appends an item to `effective_policies`.
        ///
        /// To override the contents of this collection use [`set_effective_policies`](Self::set_effective_policies).
        ///
        /// <p>The effective policies.</p>
        pub fn effective_policies(mut self, input: crate::model::EffectivePolicy) -> Self {
            let mut v = self.effective_policies.unwrap_or_default();
            v.push(input);
            self.effective_policies = Some(v);
            self
        }
        /// <p>The effective policies.</p>
        pub fn set_effective_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EffectivePolicy>>,
        ) -> Self {
            self.effective_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEffectivePoliciesOutput`](crate::output::GetEffectivePoliciesOutput)
        pub fn build(self) -> crate::output::GetEffectivePoliciesOutput {
            crate::output::GetEffectivePoliciesOutput {
                effective_policies: self.effective_policies,
            }
        }
    }
}
impl GetEffectivePoliciesOutput {
    /// Creates a new builder-style object to manufacture [`GetEffectivePoliciesOutput`](crate::output::GetEffectivePoliciesOutput)
    pub fn builder() -> crate::output::get_effective_policies_output::Builder {
        crate::output::get_effective_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCardinalityOutput {
    /// <p>The approximate count of unique values that match the query.</p>
    pub cardinality: i32,
}
impl GetCardinalityOutput {
    /// <p>The approximate count of unique values that match the query.</p>
    pub fn cardinality(&self) -> i32 {
        self.cardinality
    }
}
impl std::fmt::Debug for GetCardinalityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCardinalityOutput");
        formatter.field("cardinality", &self.cardinality);
        formatter.finish()
    }
}
/// See [`GetCardinalityOutput`](crate::output::GetCardinalityOutput)
pub mod get_cardinality_output {
    /// A builder for [`GetCardinalityOutput`](crate::output::GetCardinalityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cardinality: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The approximate count of unique values that match the query.</p>
        pub fn cardinality(mut self, input: i32) -> Self {
            self.cardinality = Some(input);
            self
        }
        /// <p>The approximate count of unique values that match the query.</p>
        pub fn set_cardinality(mut self, input: std::option::Option<i32>) -> Self {
            self.cardinality = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCardinalityOutput`](crate::output::GetCardinalityOutput)
        pub fn build(self) -> crate::output::GetCardinalityOutput {
            crate::output::GetCardinalityOutput {
                cardinality: self.cardinality.unwrap_or_default(),
            }
        }
    }
}
impl GetCardinalityOutput {
    /// Creates a new builder-style object to manufacture [`GetCardinalityOutput`](crate::output::GetCardinalityOutput)
    pub fn builder() -> crate::output::get_cardinality_output::Builder {
        crate::output::get_cardinality_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketsAggregationOutput {
    /// <p>The total number of things that fit the query string criteria.</p>
    pub total_count: i32,
    /// <p>The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a <code>count</code>.</p>
    /// <p> <code>keyValue</code>: The aggregation field value counted for the particular bucket.</p>
    /// <p> <code>count</code>: The number of documents that have that value.</p>
    pub buckets: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
}
impl GetBucketsAggregationOutput {
    /// <p>The total number of things that fit the query string criteria.</p>
    pub fn total_count(&self) -> i32 {
        self.total_count
    }
    /// <p>The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a <code>count</code>.</p>
    /// <p> <code>keyValue</code>: The aggregation field value counted for the particular bucket.</p>
    /// <p> <code>count</code>: The number of documents that have that value.</p>
    pub fn buckets(&self) -> std::option::Option<&[crate::model::Bucket]> {
        self.buckets.as_deref()
    }
}
impl std::fmt::Debug for GetBucketsAggregationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketsAggregationOutput");
        formatter.field("total_count", &self.total_count);
        formatter.field("buckets", &self.buckets);
        formatter.finish()
    }
}
/// See [`GetBucketsAggregationOutput`](crate::output::GetBucketsAggregationOutput)
pub mod get_buckets_aggregation_output {
    /// A builder for [`GetBucketsAggregationOutput`](crate::output::GetBucketsAggregationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_count: std::option::Option<i32>,
        pub(crate) buckets: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
    }
    impl Builder {
        /// <p>The total number of things that fit the query string criteria.</p>
        pub fn total_count(mut self, input: i32) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of things that fit the query string criteria.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_count = input;
            self
        }
        /// Appends an item to `buckets`.
        ///
        /// To override the contents of this collection use [`set_buckets`](Self::set_buckets).
        ///
        /// <p>The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a <code>count</code>.</p>
        /// <p> <code>keyValue</code>: The aggregation field value counted for the particular bucket.</p>
        /// <p> <code>count</code>: The number of documents that have that value.</p>
        pub fn buckets(mut self, input: crate::model::Bucket) -> Self {
            let mut v = self.buckets.unwrap_or_default();
            v.push(input);
            self.buckets = Some(v);
            self
        }
        /// <p>The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a <code>count</code>.</p>
        /// <p> <code>keyValue</code>: The aggregation field value counted for the particular bucket.</p>
        /// <p> <code>count</code>: The number of documents that have that value.</p>
        pub fn set_buckets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
        ) -> Self {
            self.buckets = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketsAggregationOutput`](crate::output::GetBucketsAggregationOutput)
        pub fn build(self) -> crate::output::GetBucketsAggregationOutput {
            crate::output::GetBucketsAggregationOutput {
                total_count: self.total_count.unwrap_or_default(),
                buckets: self.buckets,
            }
        }
    }
}
impl GetBucketsAggregationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketsAggregationOutput`](crate::output::GetBucketsAggregationOutput)
    pub fn builder() -> crate::output::get_buckets_aggregation_output::Builder {
        crate::output::get_buckets_aggregation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBehaviorModelTrainingSummariesOutput {
    /// <p> A list of all ML Detect behaviors and their model status for a given Security Profile. </p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::BehaviorModelTrainingSummary>>,
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBehaviorModelTrainingSummariesOutput {
    /// <p> A list of all ML Detect behaviors and their model status for a given Security Profile. </p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::BehaviorModelTrainingSummary]> {
        self.summaries.as_deref()
    }
    /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBehaviorModelTrainingSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBehaviorModelTrainingSummariesOutput");
        formatter.field("summaries", &self.summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBehaviorModelTrainingSummariesOutput`](crate::output::GetBehaviorModelTrainingSummariesOutput)
pub mod get_behavior_model_training_summaries_output {
    /// A builder for [`GetBehaviorModelTrainingSummariesOutput`](crate::output::GetBehaviorModelTrainingSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summaries:
            std::option::Option<std::vec::Vec<crate::model::BehaviorModelTrainingSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p> A list of all ML Detect behaviors and their model status for a given Security Profile. </p>
        pub fn summaries(mut self, input: crate::model::BehaviorModelTrainingSummary) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input);
            self.summaries = Some(v);
            self
        }
        /// <p> A list of all ML Detect behaviors and their model status for a given Security Profile. </p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BehaviorModelTrainingSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBehaviorModelTrainingSummariesOutput`](crate::output::GetBehaviorModelTrainingSummariesOutput)
        pub fn build(self) -> crate::output::GetBehaviorModelTrainingSummariesOutput {
            crate::output::GetBehaviorModelTrainingSummariesOutput {
                summaries: self.summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBehaviorModelTrainingSummariesOutput {
    /// Creates a new builder-style object to manufacture [`GetBehaviorModelTrainingSummariesOutput`](crate::output::GetBehaviorModelTrainingSummariesOutput)
    pub fn builder() -> crate::output::get_behavior_model_training_summaries_output::Builder {
        crate::output::get_behavior_model_training_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableTopicRuleOutput {}
impl std::fmt::Debug for EnableTopicRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableTopicRuleOutput");
        formatter.finish()
    }
}
/// See [`EnableTopicRuleOutput`](crate::output::EnableTopicRuleOutput)
pub mod enable_topic_rule_output {
    /// A builder for [`EnableTopicRuleOutput`](crate::output::EnableTopicRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableTopicRuleOutput`](crate::output::EnableTopicRuleOutput)
        pub fn build(self) -> crate::output::EnableTopicRuleOutput {
            crate::output::EnableTopicRuleOutput {}
        }
    }
}
impl EnableTopicRuleOutput {
    /// Creates a new builder-style object to manufacture [`EnableTopicRuleOutput`](crate::output::EnableTopicRuleOutput)
    pub fn builder() -> crate::output::enable_topic_rule_output::Builder {
        crate::output::enable_topic_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableTopicRuleOutput {}
impl std::fmt::Debug for DisableTopicRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableTopicRuleOutput");
        formatter.finish()
    }
}
/// See [`DisableTopicRuleOutput`](crate::output::DisableTopicRuleOutput)
pub mod disable_topic_rule_output {
    /// A builder for [`DisableTopicRuleOutput`](crate::output::DisableTopicRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableTopicRuleOutput`](crate::output::DisableTopicRuleOutput)
        pub fn build(self) -> crate::output::DisableTopicRuleOutput {
            crate::output::DisableTopicRuleOutput {}
        }
    }
}
impl DisableTopicRuleOutput {
    /// Creates a new builder-style object to manufacture [`DisableTopicRuleOutput`](crate::output::DisableTopicRuleOutput)
    pub fn builder() -> crate::output::disable_topic_rule_output::Builder {
        crate::output::disable_topic_rule_output::Builder::default()
    }
}

/// <p>The output from the DetachThingPrincipal operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachThingPrincipalOutput {}
impl std::fmt::Debug for DetachThingPrincipalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachThingPrincipalOutput");
        formatter.finish()
    }
}
/// See [`DetachThingPrincipalOutput`](crate::output::DetachThingPrincipalOutput)
pub mod detach_thing_principal_output {
    /// A builder for [`DetachThingPrincipalOutput`](crate::output::DetachThingPrincipalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachThingPrincipalOutput`](crate::output::DetachThingPrincipalOutput)
        pub fn build(self) -> crate::output::DetachThingPrincipalOutput {
            crate::output::DetachThingPrincipalOutput {}
        }
    }
}
impl DetachThingPrincipalOutput {
    /// Creates a new builder-style object to manufacture [`DetachThingPrincipalOutput`](crate::output::DetachThingPrincipalOutput)
    pub fn builder() -> crate::output::detach_thing_principal_output::Builder {
        crate::output::detach_thing_principal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachSecurityProfileOutput {}
impl std::fmt::Debug for DetachSecurityProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachSecurityProfileOutput");
        formatter.finish()
    }
}
/// See [`DetachSecurityProfileOutput`](crate::output::DetachSecurityProfileOutput)
pub mod detach_security_profile_output {
    /// A builder for [`DetachSecurityProfileOutput`](crate::output::DetachSecurityProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachSecurityProfileOutput`](crate::output::DetachSecurityProfileOutput)
        pub fn build(self) -> crate::output::DetachSecurityProfileOutput {
            crate::output::DetachSecurityProfileOutput {}
        }
    }
}
impl DetachSecurityProfileOutput {
    /// Creates a new builder-style object to manufacture [`DetachSecurityProfileOutput`](crate::output::DetachSecurityProfileOutput)
    pub fn builder() -> crate::output::detach_security_profile_output::Builder {
        crate::output::detach_security_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachPrincipalPolicyOutput {}
impl std::fmt::Debug for DetachPrincipalPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachPrincipalPolicyOutput");
        formatter.finish()
    }
}
/// See [`DetachPrincipalPolicyOutput`](crate::output::DetachPrincipalPolicyOutput)
pub mod detach_principal_policy_output {
    /// A builder for [`DetachPrincipalPolicyOutput`](crate::output::DetachPrincipalPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachPrincipalPolicyOutput`](crate::output::DetachPrincipalPolicyOutput)
        pub fn build(self) -> crate::output::DetachPrincipalPolicyOutput {
            crate::output::DetachPrincipalPolicyOutput {}
        }
    }
}
impl DetachPrincipalPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DetachPrincipalPolicyOutput`](crate::output::DetachPrincipalPolicyOutput)
    pub fn builder() -> crate::output::detach_principal_policy_output::Builder {
        crate::output::detach_principal_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachPolicyOutput {}
impl std::fmt::Debug for DetachPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachPolicyOutput");
        formatter.finish()
    }
}
/// See [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
pub mod detach_policy_output {
    /// A builder for [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
        pub fn build(self) -> crate::output::DetachPolicyOutput {
            crate::output::DetachPolicyOutput {}
        }
    }
}
impl DetachPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)
    pub fn builder() -> crate::output::detach_policy_output::Builder {
        crate::output::detach_policy_output::Builder::default()
    }
}

/// <p>The output for the DescribeThingType operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThingTypeOutput {
    /// <p>The name of the thing type.</p>
    pub thing_type_name: std::option::Option<std::string::String>,
    /// <p>The thing type ID.</p>
    pub thing_type_id: std::option::Option<std::string::String>,
    /// <p>The thing type ARN.</p>
    pub thing_type_arn: std::option::Option<std::string::String>,
    /// <p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>
    pub thing_type_properties: std::option::Option<crate::model::ThingTypeProperties>,
    /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>
    pub thing_type_metadata: std::option::Option<crate::model::ThingTypeMetadata>,
}
impl DescribeThingTypeOutput {
    /// <p>The name of the thing type.</p>
    pub fn thing_type_name(&self) -> std::option::Option<&str> {
        self.thing_type_name.as_deref()
    }
    /// <p>The thing type ID.</p>
    pub fn thing_type_id(&self) -> std::option::Option<&str> {
        self.thing_type_id.as_deref()
    }
    /// <p>The thing type ARN.</p>
    pub fn thing_type_arn(&self) -> std::option::Option<&str> {
        self.thing_type_arn.as_deref()
    }
    /// <p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>
    pub fn thing_type_properties(&self) -> std::option::Option<&crate::model::ThingTypeProperties> {
        self.thing_type_properties.as_ref()
    }
    /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>
    pub fn thing_type_metadata(&self) -> std::option::Option<&crate::model::ThingTypeMetadata> {
        self.thing_type_metadata.as_ref()
    }
}
impl std::fmt::Debug for DescribeThingTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThingTypeOutput");
        formatter.field("thing_type_name", &self.thing_type_name);
        formatter.field("thing_type_id", &self.thing_type_id);
        formatter.field("thing_type_arn", &self.thing_type_arn);
        formatter.field("thing_type_properties", &self.thing_type_properties);
        formatter.field("thing_type_metadata", &self.thing_type_metadata);
        formatter.finish()
    }
}
/// See [`DescribeThingTypeOutput`](crate::output::DescribeThingTypeOutput)
pub mod describe_thing_type_output {
    /// A builder for [`DescribeThingTypeOutput`](crate::output::DescribeThingTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) thing_type_id: std::option::Option<std::string::String>,
        pub(crate) thing_type_arn: std::option::Option<std::string::String>,
        pub(crate) thing_type_properties: std::option::Option<crate::model::ThingTypeProperties>,
        pub(crate) thing_type_metadata: std::option::Option<crate::model::ThingTypeMetadata>,
    }
    impl Builder {
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// <p>The thing type ID.</p>
        pub fn thing_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_id = Some(input.into());
            self
        }
        /// <p>The thing type ID.</p>
        pub fn set_thing_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_id = input;
            self
        }
        /// <p>The thing type ARN.</p>
        pub fn thing_type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_arn = Some(input.into());
            self
        }
        /// <p>The thing type ARN.</p>
        pub fn set_thing_type_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_arn = input;
            self
        }
        /// <p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>
        pub fn thing_type_properties(mut self, input: crate::model::ThingTypeProperties) -> Self {
            self.thing_type_properties = Some(input);
            self
        }
        /// <p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>
        pub fn set_thing_type_properties(
            mut self,
            input: std::option::Option<crate::model::ThingTypeProperties>,
        ) -> Self {
            self.thing_type_properties = input;
            self
        }
        /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>
        pub fn thing_type_metadata(mut self, input: crate::model::ThingTypeMetadata) -> Self {
            self.thing_type_metadata = Some(input);
            self
        }
        /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>
        pub fn set_thing_type_metadata(
            mut self,
            input: std::option::Option<crate::model::ThingTypeMetadata>,
        ) -> Self {
            self.thing_type_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingTypeOutput`](crate::output::DescribeThingTypeOutput)
        pub fn build(self) -> crate::output::DescribeThingTypeOutput {
            crate::output::DescribeThingTypeOutput {
                thing_type_name: self.thing_type_name,
                thing_type_id: self.thing_type_id,
                thing_type_arn: self.thing_type_arn,
                thing_type_properties: self.thing_type_properties,
                thing_type_metadata: self.thing_type_metadata,
            }
        }
    }
}
impl DescribeThingTypeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeThingTypeOutput`](crate::output::DescribeThingTypeOutput)
    pub fn builder() -> crate::output::describe_thing_type_output::Builder {
        crate::output::describe_thing_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThingRegistrationTaskOutput {
    /// <p>The task ID.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The task creation date.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the task was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The task's template.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>The S3 bucket that contains the input file.</p>
    pub input_file_bucket: std::option::Option<std::string::String>,
    /// <p>The input file key.</p>
    pub input_file_key: std::option::Option<std::string::String>,
    /// <p>The role ARN that grants access to the input file bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the bulk thing provisioning task.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The number of things successfully provisioned.</p>
    pub success_count: i32,
    /// <p>The number of things that failed to be provisioned.</p>
    pub failure_count: i32,
    /// <p>The progress of the bulk provisioning task expressed as a percentage.</p>
    pub percentage_progress: i32,
}
impl DescribeThingRegistrationTaskOutput {
    /// <p>The task ID.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The task creation date.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date when the task was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The task's template.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>The S3 bucket that contains the input file.</p>
    pub fn input_file_bucket(&self) -> std::option::Option<&str> {
        self.input_file_bucket.as_deref()
    }
    /// <p>The input file key.</p>
    pub fn input_file_key(&self) -> std::option::Option<&str> {
        self.input_file_key.as_deref()
    }
    /// <p>The role ARN that grants access to the input file bucket.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the bulk thing provisioning task.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The number of things successfully provisioned.</p>
    pub fn success_count(&self) -> i32 {
        self.success_count
    }
    /// <p>The number of things that failed to be provisioned.</p>
    pub fn failure_count(&self) -> i32 {
        self.failure_count
    }
    /// <p>The progress of the bulk provisioning task expressed as a percentage.</p>
    pub fn percentage_progress(&self) -> i32 {
        self.percentage_progress
    }
}
impl std::fmt::Debug for DescribeThingRegistrationTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThingRegistrationTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("template_body", &self.template_body);
        formatter.field("input_file_bucket", &self.input_file_bucket);
        formatter.field("input_file_key", &self.input_file_key);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("success_count", &self.success_count);
        formatter.field("failure_count", &self.failure_count);
        formatter.field("percentage_progress", &self.percentage_progress);
        formatter.finish()
    }
}
/// See [`DescribeThingRegistrationTaskOutput`](crate::output::DescribeThingRegistrationTaskOutput)
pub mod describe_thing_registration_task_output {
    /// A builder for [`DescribeThingRegistrationTaskOutput`](crate::output::DescribeThingRegistrationTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) input_file_bucket: std::option::Option<std::string::String>,
        pub(crate) input_file_key: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) success_count: std::option::Option<i32>,
        pub(crate) failure_count: std::option::Option<i32>,
        pub(crate) percentage_progress: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The task ID.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The task ID.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The task creation date.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The task creation date.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date when the task was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date when the task was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The task's template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The task's template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The S3 bucket that contains the input file.</p>
        pub fn input_file_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_file_bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket that contains the input file.</p>
        pub fn set_input_file_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_file_bucket = input;
            self
        }
        /// <p>The input file key.</p>
        pub fn input_file_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_file_key = Some(input.into());
            self
        }
        /// <p>The input file key.</p>
        pub fn set_input_file_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_file_key = input;
            self
        }
        /// <p>The role ARN that grants access to the input file bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN that grants access to the input file bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the bulk thing provisioning task.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the bulk thing provisioning task.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The number of things successfully provisioned.</p>
        pub fn success_count(mut self, input: i32) -> Self {
            self.success_count = Some(input);
            self
        }
        /// <p>The number of things successfully provisioned.</p>
        pub fn set_success_count(mut self, input: std::option::Option<i32>) -> Self {
            self.success_count = input;
            self
        }
        /// <p>The number of things that failed to be provisioned.</p>
        pub fn failure_count(mut self, input: i32) -> Self {
            self.failure_count = Some(input);
            self
        }
        /// <p>The number of things that failed to be provisioned.</p>
        pub fn set_failure_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_count = input;
            self
        }
        /// <p>The progress of the bulk provisioning task expressed as a percentage.</p>
        pub fn percentage_progress(mut self, input: i32) -> Self {
            self.percentage_progress = Some(input);
            self
        }
        /// <p>The progress of the bulk provisioning task expressed as a percentage.</p>
        pub fn set_percentage_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.percentage_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingRegistrationTaskOutput`](crate::output::DescribeThingRegistrationTaskOutput)
        pub fn build(self) -> crate::output::DescribeThingRegistrationTaskOutput {
            crate::output::DescribeThingRegistrationTaskOutput {
                task_id: self.task_id,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                template_body: self.template_body,
                input_file_bucket: self.input_file_bucket,
                input_file_key: self.input_file_key,
                role_arn: self.role_arn,
                status: self.status,
                message: self.message,
                success_count: self.success_count.unwrap_or_default(),
                failure_count: self.failure_count.unwrap_or_default(),
                percentage_progress: self.percentage_progress.unwrap_or_default(),
            }
        }
    }
}
impl DescribeThingRegistrationTaskOutput {
    /// Creates a new builder-style object to manufacture [`DescribeThingRegistrationTaskOutput`](crate::output::DescribeThingRegistrationTaskOutput)
    pub fn builder() -> crate::output::describe_thing_registration_task_output::Builder {
        crate::output::describe_thing_registration_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThingGroupOutput {
    /// <p>The name of the thing group.</p>
    pub thing_group_name: std::option::Option<std::string::String>,
    /// <p>The thing group ID.</p>
    pub thing_group_id: std::option::Option<std::string::String>,
    /// <p>The thing group ARN.</p>
    pub thing_group_arn: std::option::Option<std::string::String>,
    /// <p>The version of the thing group.</p>
    pub version: i64,
    /// <p>The thing group properties.</p>
    pub thing_group_properties: std::option::Option<crate::model::ThingGroupProperties>,
    /// <p>Thing group metadata.</p>
    pub thing_group_metadata: std::option::Option<crate::model::ThingGroupMetadata>,
    /// <p>The dynamic thing group index name.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group search query string.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group query version.</p>
    pub query_version: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group status.</p>
    pub status: std::option::Option<crate::model::DynamicGroupStatus>,
}
impl DescribeThingGroupOutput {
    /// <p>The name of the thing group.</p>
    pub fn thing_group_name(&self) -> std::option::Option<&str> {
        self.thing_group_name.as_deref()
    }
    /// <p>The thing group ID.</p>
    pub fn thing_group_id(&self) -> std::option::Option<&str> {
        self.thing_group_id.as_deref()
    }
    /// <p>The thing group ARN.</p>
    pub fn thing_group_arn(&self) -> std::option::Option<&str> {
        self.thing_group_arn.as_deref()
    }
    /// <p>The version of the thing group.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The thing group properties.</p>
    pub fn thing_group_properties(
        &self,
    ) -> std::option::Option<&crate::model::ThingGroupProperties> {
        self.thing_group_properties.as_ref()
    }
    /// <p>Thing group metadata.</p>
    pub fn thing_group_metadata(&self) -> std::option::Option<&crate::model::ThingGroupMetadata> {
        self.thing_group_metadata.as_ref()
    }
    /// <p>The dynamic thing group index name.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The dynamic thing group search query string.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The dynamic thing group query version.</p>
    pub fn query_version(&self) -> std::option::Option<&str> {
        self.query_version.as_deref()
    }
    /// <p>The dynamic thing group status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DynamicGroupStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DescribeThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThingGroupOutput");
        formatter.field("thing_group_name", &self.thing_group_name);
        formatter.field("thing_group_id", &self.thing_group_id);
        formatter.field("thing_group_arn", &self.thing_group_arn);
        formatter.field("version", &self.version);
        formatter.field("thing_group_properties", &self.thing_group_properties);
        formatter.field("thing_group_metadata", &self.thing_group_metadata);
        formatter.field("index_name", &self.index_name);
        formatter.field("query_string", &self.query_string);
        formatter.field("query_version", &self.query_version);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DescribeThingGroupOutput`](crate::output::DescribeThingGroupOutput)
pub mod describe_thing_group_output {
    /// A builder for [`DescribeThingGroupOutput`](crate::output::DescribeThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_id: std::option::Option<std::string::String>,
        pub(crate) thing_group_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) thing_group_properties: std::option::Option<crate::model::ThingGroupProperties>,
        pub(crate) thing_group_metadata: std::option::Option<crate::model::ThingGroupMetadata>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DynamicGroupStatus>,
    }
    impl Builder {
        /// <p>The name of the thing group.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the thing group.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The thing group ID.</p>
        pub fn thing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_id = Some(input.into());
            self
        }
        /// <p>The thing group ID.</p>
        pub fn set_thing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_id = input;
            self
        }
        /// <p>The thing group ARN.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_arn = Some(input.into());
            self
        }
        /// <p>The thing group ARN.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_arn = input;
            self
        }
        /// <p>The version of the thing group.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the thing group.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The thing group properties.</p>
        pub fn thing_group_properties(mut self, input: crate::model::ThingGroupProperties) -> Self {
            self.thing_group_properties = Some(input);
            self
        }
        /// <p>The thing group properties.</p>
        pub fn set_thing_group_properties(
            mut self,
            input: std::option::Option<crate::model::ThingGroupProperties>,
        ) -> Self {
            self.thing_group_properties = input;
            self
        }
        /// <p>Thing group metadata.</p>
        pub fn thing_group_metadata(mut self, input: crate::model::ThingGroupMetadata) -> Self {
            self.thing_group_metadata = Some(input);
            self
        }
        /// <p>Thing group metadata.</p>
        pub fn set_thing_group_metadata(
            mut self,
            input: std::option::Option<crate::model::ThingGroupMetadata>,
        ) -> Self {
            self.thing_group_metadata = input;
            self
        }
        /// <p>The dynamic thing group index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The dynamic thing group index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The dynamic thing group query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The dynamic thing group query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// <p>The dynamic thing group status.</p>
        pub fn status(mut self, input: crate::model::DynamicGroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The dynamic thing group status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DynamicGroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingGroupOutput`](crate::output::DescribeThingGroupOutput)
        pub fn build(self) -> crate::output::DescribeThingGroupOutput {
            crate::output::DescribeThingGroupOutput {
                thing_group_name: self.thing_group_name,
                thing_group_id: self.thing_group_id,
                thing_group_arn: self.thing_group_arn,
                version: self.version.unwrap_or_default(),
                thing_group_properties: self.thing_group_properties,
                thing_group_metadata: self.thing_group_metadata,
                index_name: self.index_name,
                query_string: self.query_string,
                query_version: self.query_version,
                status: self.status,
            }
        }
    }
}
impl DescribeThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeThingGroupOutput`](crate::output::DescribeThingGroupOutput)
    pub fn builder() -> crate::output::describe_thing_group_output::Builder {
        crate::output::describe_thing_group_output::Builder::default()
    }
}

/// <p>The output from the DescribeThing operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeThingOutput {
    /// <p>The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and the Device Shadow service.</p>
    /// <p>This lets you better organize your IoT fleet without removing the flexibility of the underlying device certificate model or shadows.</p>
    pub default_client_id: std::option::Option<std::string::String>,
    /// <p>The name of the thing.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The ID of the thing to describe.</p>
    pub thing_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the thing to describe.</p>
    pub thing_arn: std::option::Option<std::string::String>,
    /// <p>The thing type name.</p>
    pub thing_type_name: std::option::Option<std::string::String>,
    /// <p>The thing attributes.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The current version of the thing record in the registry.</p> <note>
    /// <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p>
    /// </note>
    pub version: i64,
    /// <p>The name of the billing group the thing belongs to.</p>
    pub billing_group_name: std::option::Option<std::string::String>,
}
impl DescribeThingOutput {
    /// <p>The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and the Device Shadow service.</p>
    /// <p>This lets you better organize your IoT fleet without removing the flexibility of the underlying device certificate model or shadows.</p>
    pub fn default_client_id(&self) -> std::option::Option<&str> {
        self.default_client_id.as_deref()
    }
    /// <p>The name of the thing.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The ID of the thing to describe.</p>
    pub fn thing_id(&self) -> std::option::Option<&str> {
        self.thing_id.as_deref()
    }
    /// <p>The ARN of the thing to describe.</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
    /// <p>The thing type name.</p>
    pub fn thing_type_name(&self) -> std::option::Option<&str> {
        self.thing_type_name.as_deref()
    }
    /// <p>The thing attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>The current version of the thing record in the registry.</p> <note>
    /// <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p>
    /// </note>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The name of the billing group the thing belongs to.</p>
    pub fn billing_group_name(&self) -> std::option::Option<&str> {
        self.billing_group_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeThingOutput");
        formatter.field("default_client_id", &self.default_client_id);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("thing_id", &self.thing_id);
        formatter.field("thing_arn", &self.thing_arn);
        formatter.field("thing_type_name", &self.thing_type_name);
        formatter.field("attributes", &self.attributes);
        formatter.field("version", &self.version);
        formatter.field("billing_group_name", &self.billing_group_name);
        formatter.finish()
    }
}
/// See [`DescribeThingOutput`](crate::output::DescribeThingOutput)
pub mod describe_thing_output {
    /// A builder for [`DescribeThingOutput`](crate::output::DescribeThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_client_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) thing_id: std::option::Option<std::string::String>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and the Device Shadow service.</p>
        /// <p>This lets you better organize your IoT fleet without removing the flexibility of the underlying device certificate model or shadows.</p>
        pub fn default_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_client_id = Some(input.into());
            self
        }
        /// <p>The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and the Device Shadow service.</p>
        /// <p>This lets you better organize your IoT fleet without removing the flexibility of the underlying device certificate model or shadows.</p>
        pub fn set_default_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_client_id = input;
            self
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ID of the thing to describe.</p>
        pub fn thing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_id = Some(input.into());
            self
        }
        /// <p>The ID of the thing to describe.</p>
        pub fn set_thing_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_id = input;
            self
        }
        /// <p>The ARN of the thing to describe.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing to describe.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// <p>The thing type name.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The thing type name.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The thing attributes.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The thing attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The current version of the thing record in the registry.</p> <note>
        /// <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p>
        /// </note>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The current version of the thing record in the registry.</p> <note>
        /// <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The name of the billing group the thing belongs to.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the billing group the thing belongs to.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingOutput`](crate::output::DescribeThingOutput)
        pub fn build(self) -> crate::output::DescribeThingOutput {
            crate::output::DescribeThingOutput {
                default_client_id: self.default_client_id,
                thing_name: self.thing_name,
                thing_id: self.thing_id,
                thing_arn: self.thing_arn,
                thing_type_name: self.thing_type_name,
                attributes: self.attributes,
                version: self.version.unwrap_or_default(),
                billing_group_name: self.billing_group_name,
            }
        }
    }
}
impl DescribeThingOutput {
    /// Creates a new builder-style object to manufacture [`DescribeThingOutput`](crate::output::DescribeThingOutput)
    pub fn builder() -> crate::output::describe_thing_output::Builder {
        crate::output::describe_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStreamOutput {
    /// <p>Information about the stream.</p>
    pub stream_info: std::option::Option<crate::model::StreamInfo>,
}
impl DescribeStreamOutput {
    /// <p>Information about the stream.</p>
    pub fn stream_info(&self) -> std::option::Option<&crate::model::StreamInfo> {
        self.stream_info.as_ref()
    }
}
impl std::fmt::Debug for DescribeStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStreamOutput");
        formatter.field("stream_info", &self.stream_info);
        formatter.finish()
    }
}
/// See [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
pub mod describe_stream_output {
    /// A builder for [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_info: std::option::Option<crate::model::StreamInfo>,
    }
    impl Builder {
        /// <p>Information about the stream.</p>
        pub fn stream_info(mut self, input: crate::model::StreamInfo) -> Self {
            self.stream_info = Some(input);
            self
        }
        /// <p>Information about the stream.</p>
        pub fn set_stream_info(
            mut self,
            input: std::option::Option<crate::model::StreamInfo>,
        ) -> Self {
            self.stream_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
        pub fn build(self) -> crate::output::DescribeStreamOutput {
            crate::output::DescribeStreamOutput {
                stream_info: self.stream_info,
            }
        }
    }
}
impl DescribeStreamOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStreamOutput`](crate::output::DescribeStreamOutput)
    pub fn builder() -> crate::output::describe_stream_output::Builder {
        crate::output::describe_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSecurityProfileOutput {
    /// <p>The name of the security profile.</p>
    pub security_profile_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the security profile.</p>
    pub security_profile_arn: std::option::Option<std::string::String>,
    /// <p>A description of the security profile (associated with the security profile when it was created or updated).</p>
    pub security_profile_description: std::option::Option<std::string::String>,
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    pub behaviors: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
    /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    pub alert_targets: std::option::Option<
        std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
    >,
    /// <p> <i>Please use <code>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
    pub additional_metrics_to_retain: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here.</p>
    pub additional_metrics_to_retain_v2:
        std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
    /// <p>The version of the security profile. A new version is generated whenever the security profile is updated.</p>
    pub version: i64,
    /// <p>The time the security profile was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the security profile was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeSecurityProfileOutput {
    /// <p>The name of the security profile.</p>
    pub fn security_profile_name(&self) -> std::option::Option<&str> {
        self.security_profile_name.as_deref()
    }
    /// <p>The ARN of the security profile.</p>
    pub fn security_profile_arn(&self) -> std::option::Option<&str> {
        self.security_profile_arn.as_deref()
    }
    /// <p>A description of the security profile (associated with the security profile when it was created or updated).</p>
    pub fn security_profile_description(&self) -> std::option::Option<&str> {
        self.security_profile_description.as_deref()
    }
    /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    pub fn behaviors(&self) -> std::option::Option<&[crate::model::Behavior]> {
        self.behaviors.as_deref()
    }
    /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    pub fn alert_targets(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
    > {
        self.alert_targets.as_ref()
    }
    /// <p> <i>Please use <code>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
    pub fn additional_metrics_to_retain(&self) -> std::option::Option<&[std::string::String]> {
        self.additional_metrics_to_retain.as_deref()
    }
    /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here.</p>
    pub fn additional_metrics_to_retain_v2(
        &self,
    ) -> std::option::Option<&[crate::model::MetricToRetain]> {
        self.additional_metrics_to_retain_v2.as_deref()
    }
    /// <p>The version of the security profile. A new version is generated whenever the security profile is updated.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The time the security profile was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The time the security profile was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeSecurityProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSecurityProfileOutput");
        formatter.field("security_profile_name", &self.security_profile_name);
        formatter.field("security_profile_arn", &self.security_profile_arn);
        formatter.field(
            "security_profile_description",
            &self.security_profile_description,
        );
        formatter.field("behaviors", &self.behaviors);
        formatter.field("alert_targets", &self.alert_targets);
        formatter.field(
            "additional_metrics_to_retain",
            &self.additional_metrics_to_retain,
        );
        formatter.field(
            "additional_metrics_to_retain_v2",
            &self.additional_metrics_to_retain_v2,
        );
        formatter.field("version", &self.version);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`DescribeSecurityProfileOutput`](crate::output::DescribeSecurityProfileOutput)
pub mod describe_security_profile_output {
    /// A builder for [`DescribeSecurityProfileOutput`](crate::output::DescribeSecurityProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_arn: std::option::Option<std::string::String>,
        pub(crate) security_profile_description: std::option::Option<std::string::String>,
        pub(crate) behaviors: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        pub(crate) alert_targets: std::option::Option<
            std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
        >,
        pub(crate) additional_metrics_to_retain:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) additional_metrics_to_retain_v2:
            std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The ARN of the security profile.</p>
        pub fn security_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the security profile.</p>
        pub fn set_security_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_arn = input;
            self
        }
        /// <p>A description of the security profile (associated with the security profile when it was created or updated).</p>
        pub fn security_profile_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.security_profile_description = Some(input.into());
            self
        }
        /// <p>A description of the security profile (associated with the security profile when it was created or updated).</p>
        pub fn set_security_profile_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_description = input;
            self
        }
        /// Appends an item to `behaviors`.
        ///
        /// To override the contents of this collection use [`set_behaviors`](Self::set_behaviors).
        ///
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn behaviors(mut self, input: crate::model::Behavior) -> Self {
            let mut v = self.behaviors.unwrap_or_default();
            v.push(input);
            self.behaviors = Some(v);
            self
        }
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn set_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        ) -> Self {
            self.behaviors = input;
            self
        }
        /// Adds a key-value pair to `alert_targets`.
        ///
        /// To override the contents of this collection use [`set_alert_targets`](Self::set_alert_targets).
        ///
        /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
        pub fn alert_targets(
            mut self,
            k: crate::model::AlertTargetType,
            v: crate::model::AlertTarget,
        ) -> Self {
            let mut hash_map = self.alert_targets.unwrap_or_default();
            hash_map.insert(k, v);
            self.alert_targets = Some(hash_map);
            self
        }
        /// <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
        pub fn set_alert_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
            >,
        ) -> Self {
            self.alert_targets = input;
            self
        }
        /// Appends an item to `additional_metrics_to_retain`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain`](Self::set_additional_metrics_to_retain).
        ///
        /// <p> <i>Please use <code>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
        pub fn additional_metrics_to_retain(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_metrics_to_retain.unwrap_or_default();
            v.push(input.into());
            self.additional_metrics_to_retain = Some(v);
            self
        }
        /// <p> <i>Please use <code>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
        pub fn set_additional_metrics_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_metrics_to_retain = input;
            self
        }
        /// Appends an item to `additional_metrics_to_retain_v2`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain_v2`](Self::set_additional_metrics_to_retain_v2).
        ///
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here.</p>
        pub fn additional_metrics_to_retain_v2(
            mut self,
            input: crate::model::MetricToRetain,
        ) -> Self {
            let mut v = self.additional_metrics_to_retain_v2.unwrap_or_default();
            v.push(input);
            self.additional_metrics_to_retain_v2 = Some(v);
            self
        }
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here.</p>
        pub fn set_additional_metrics_to_retain_v2(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        ) -> Self {
            self.additional_metrics_to_retain_v2 = input;
            self
        }
        /// <p>The version of the security profile. A new version is generated whenever the security profile is updated.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the security profile. A new version is generated whenever the security profile is updated.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The time the security profile was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The time the security profile was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The time the security profile was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The time the security profile was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSecurityProfileOutput`](crate::output::DescribeSecurityProfileOutput)
        pub fn build(self) -> crate::output::DescribeSecurityProfileOutput {
            crate::output::DescribeSecurityProfileOutput {
                security_profile_name: self.security_profile_name,
                security_profile_arn: self.security_profile_arn,
                security_profile_description: self.security_profile_description,
                behaviors: self.behaviors,
                alert_targets: self.alert_targets,
                additional_metrics_to_retain: self.additional_metrics_to_retain,
                additional_metrics_to_retain_v2: self.additional_metrics_to_retain_v2,
                version: self.version.unwrap_or_default(),
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl DescribeSecurityProfileOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityProfileOutput`](crate::output::DescribeSecurityProfileOutput)
    pub fn builder() -> crate::output::describe_security_profile_output::Builder {
        crate::output::describe_security_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScheduledAuditOutput {
    /// <p>How often the scheduled audit takes place, either one of <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    pub frequency: std::option::Option<crate::model::AuditFrequency>,
    /// <p>The day of the month on which the scheduled audit takes place. This is will be <code>1</code> through <code>31</code> or <code>LAST</code>. If days <code>29</code>-<code>31</code> are specified, and the month does not have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
    pub day_of_month: std::option::Option<std::string::String>,
    /// <p>The day of the week on which the scheduled audit takes place, either one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>.</p>
    pub day_of_week: std::option::Option<crate::model::DayOfWeek>,
    /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    pub target_check_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the scheduled audit.</p>
    pub scheduled_audit_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the scheduled audit.</p>
    pub scheduled_audit_arn: std::option::Option<std::string::String>,
}
impl DescribeScheduledAuditOutput {
    /// <p>How often the scheduled audit takes place, either one of <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::AuditFrequency> {
        self.frequency.as_ref()
    }
    /// <p>The day of the month on which the scheduled audit takes place. This is will be <code>1</code> through <code>31</code> or <code>LAST</code>. If days <code>29</code>-<code>31</code> are specified, and the month does not have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
    pub fn day_of_month(&self) -> std::option::Option<&str> {
        self.day_of_month.as_deref()
    }
    /// <p>The day of the week on which the scheduled audit takes place, either one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>.</p>
    pub fn day_of_week(&self) -> std::option::Option<&crate::model::DayOfWeek> {
        self.day_of_week.as_ref()
    }
    /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    pub fn target_check_names(&self) -> std::option::Option<&[std::string::String]> {
        self.target_check_names.as_deref()
    }
    /// <p>The name of the scheduled audit.</p>
    pub fn scheduled_audit_name(&self) -> std::option::Option<&str> {
        self.scheduled_audit_name.as_deref()
    }
    /// <p>The ARN of the scheduled audit.</p>
    pub fn scheduled_audit_arn(&self) -> std::option::Option<&str> {
        self.scheduled_audit_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeScheduledAuditOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScheduledAuditOutput");
        formatter.field("frequency", &self.frequency);
        formatter.field("day_of_month", &self.day_of_month);
        formatter.field("day_of_week", &self.day_of_week);
        formatter.field("target_check_names", &self.target_check_names);
        formatter.field("scheduled_audit_name", &self.scheduled_audit_name);
        formatter.field("scheduled_audit_arn", &self.scheduled_audit_arn);
        formatter.finish()
    }
}
/// See [`DescribeScheduledAuditOutput`](crate::output::DescribeScheduledAuditOutput)
pub mod describe_scheduled_audit_output {
    /// A builder for [`DescribeScheduledAuditOutput`](crate::output::DescribeScheduledAuditOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frequency: std::option::Option<crate::model::AuditFrequency>,
        pub(crate) day_of_month: std::option::Option<std::string::String>,
        pub(crate) day_of_week: std::option::Option<crate::model::DayOfWeek>,
        pub(crate) target_check_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scheduled_audit_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_audit_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>How often the scheduled audit takes place, either one of <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn frequency(mut self, input: crate::model::AuditFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>How often the scheduled audit takes place, either one of <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AuditFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This is will be <code>1</code> through <code>31</code> or <code>LAST</code>. If days <code>29</code>-<code>31</code> are specified, and the month does not have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn day_of_month(mut self, input: impl Into<std::string::String>) -> Self {
            self.day_of_month = Some(input.into());
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This is will be <code>1</code> through <code>31</code> or <code>LAST</code>. If days <code>29</code>-<code>31</code> are specified, and the month does not have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.day_of_month = input;
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>.</p>
        pub fn day_of_week(mut self, input: crate::model::DayOfWeek) -> Self {
            self.day_of_week = Some(input);
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>.</p>
        pub fn set_day_of_week(
            mut self,
            input: std::option::Option<crate::model::DayOfWeek>,
        ) -> Self {
            self.day_of_week = input;
            self
        }
        /// Appends an item to `target_check_names`.
        ///
        /// To override the contents of this collection use [`set_target_check_names`](Self::set_target_check_names).
        ///
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn target_check_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_check_names.unwrap_or_default();
            v.push(input.into());
            self.target_check_names = Some(v);
            self
        }
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_target_check_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_check_names = input;
            self
        }
        /// <p>The name of the scheduled audit.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled audit.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_name = input;
            self
        }
        /// <p>The ARN of the scheduled audit.</p>
        pub fn scheduled_audit_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the scheduled audit.</p>
        pub fn set_scheduled_audit_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduledAuditOutput`](crate::output::DescribeScheduledAuditOutput)
        pub fn build(self) -> crate::output::DescribeScheduledAuditOutput {
            crate::output::DescribeScheduledAuditOutput {
                frequency: self.frequency,
                day_of_month: self.day_of_month,
                day_of_week: self.day_of_week,
                target_check_names: self.target_check_names,
                scheduled_audit_name: self.scheduled_audit_name,
                scheduled_audit_arn: self.scheduled_audit_arn,
            }
        }
    }
}
impl DescribeScheduledAuditOutput {
    /// Creates a new builder-style object to manufacture [`DescribeScheduledAuditOutput`](crate::output::DescribeScheduledAuditOutput)
    pub fn builder() -> crate::output::describe_scheduled_audit_output::Builder {
        crate::output::describe_scheduled_audit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRoleAliasOutput {
    /// <p>The role alias description.</p>
    pub role_alias_description: std::option::Option<crate::model::RoleAliasDescription>,
}
impl DescribeRoleAliasOutput {
    /// <p>The role alias description.</p>
    pub fn role_alias_description(
        &self,
    ) -> std::option::Option<&crate::model::RoleAliasDescription> {
        self.role_alias_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeRoleAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRoleAliasOutput");
        formatter.field("role_alias_description", &self.role_alias_description);
        formatter.finish()
    }
}
/// See [`DescribeRoleAliasOutput`](crate::output::DescribeRoleAliasOutput)
pub mod describe_role_alias_output {
    /// A builder for [`DescribeRoleAliasOutput`](crate::output::DescribeRoleAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_alias_description: std::option::Option<crate::model::RoleAliasDescription>,
    }
    impl Builder {
        /// <p>The role alias description.</p>
        pub fn role_alias_description(mut self, input: crate::model::RoleAliasDescription) -> Self {
            self.role_alias_description = Some(input);
            self
        }
        /// <p>The role alias description.</p>
        pub fn set_role_alias_description(
            mut self,
            input: std::option::Option<crate::model::RoleAliasDescription>,
        ) -> Self {
            self.role_alias_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRoleAliasOutput`](crate::output::DescribeRoleAliasOutput)
        pub fn build(self) -> crate::output::DescribeRoleAliasOutput {
            crate::output::DescribeRoleAliasOutput {
                role_alias_description: self.role_alias_description,
            }
        }
    }
}
impl DescribeRoleAliasOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRoleAliasOutput`](crate::output::DescribeRoleAliasOutput)
    pub fn builder() -> crate::output::describe_role_alias_output::Builder {
        crate::output::describe_role_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisioningTemplateVersionOutput {
    /// <p>The fleet provisioning template version ID.</p>
    pub version_id: std::option::Option<i32>,
    /// <p>The date when the fleet provisioning template version was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The JSON formatted contents of the fleet provisioning template version.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>True if the fleet provisioning template version is the default version.</p>
    pub is_default_version: bool,
}
impl DescribeProvisioningTemplateVersionOutput {
    /// <p>The fleet provisioning template version ID.</p>
    pub fn version_id(&self) -> std::option::Option<i32> {
        self.version_id
    }
    /// <p>The date when the fleet provisioning template version was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The JSON formatted contents of the fleet provisioning template version.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>True if the fleet provisioning template version is the default version.</p>
    pub fn is_default_version(&self) -> bool {
        self.is_default_version
    }
}
impl std::fmt::Debug for DescribeProvisioningTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisioningTemplateVersionOutput");
        formatter.field("version_id", &self.version_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("template_body", &self.template_body);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.finish()
    }
}
/// See [`DescribeProvisioningTemplateVersionOutput`](crate::output::DescribeProvisioningTemplateVersionOutput)
pub mod describe_provisioning_template_version_output {
    /// A builder for [`DescribeProvisioningTemplateVersionOutput`](crate::output::DescribeProvisioningTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_id: std::option::Option<i32>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) is_default_version: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The fleet provisioning template version ID.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.version_id = Some(input);
            self
        }
        /// <p>The fleet provisioning template version ID.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The date when the fleet provisioning template version was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the fleet provisioning template version was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template version.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template version.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>True if the fleet provisioning template version is the default version.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>True if the fleet provisioning template version is the default version.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningTemplateVersionOutput`](crate::output::DescribeProvisioningTemplateVersionOutput)
        pub fn build(self) -> crate::output::DescribeProvisioningTemplateVersionOutput {
            crate::output::DescribeProvisioningTemplateVersionOutput {
                version_id: self.version_id,
                creation_date: self.creation_date,
                template_body: self.template_body,
                is_default_version: self.is_default_version.unwrap_or_default(),
            }
        }
    }
}
impl DescribeProvisioningTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningTemplateVersionOutput`](crate::output::DescribeProvisioningTemplateVersionOutput)
    pub fn builder() -> crate::output::describe_provisioning_template_version_output::Builder {
        crate::output::describe_provisioning_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProvisioningTemplateOutput {
    /// <p>The ARN of the fleet provisioning template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>The name of the fleet provisioning template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The description of the fleet provisioning template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date when the fleet provisioning template was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the fleet provisioning template was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The default fleet template version ID.</p>
    pub default_version_id: std::option::Option<i32>,
    /// <p>The JSON formatted contents of the fleet provisioning template.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>True if the fleet provisioning template is enabled, otherwise false.</p>
    pub enabled: bool,
    /// <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
    pub provisioning_role_arn: std::option::Option<std::string::String>,
    /// <p>Gets information about a pre-provisioned hook.</p>
    pub pre_provisioning_hook: std::option::Option<crate::model::ProvisioningHook>,
}
impl DescribeProvisioningTemplateOutput {
    /// <p>The ARN of the fleet provisioning template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>The name of the fleet provisioning template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The description of the fleet provisioning template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date when the fleet provisioning template was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date when the fleet provisioning template was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The default fleet template version ID.</p>
    pub fn default_version_id(&self) -> std::option::Option<i32> {
        self.default_version_id
    }
    /// <p>The JSON formatted contents of the fleet provisioning template.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>True if the fleet provisioning template is enabled, otherwise false.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
    pub fn provisioning_role_arn(&self) -> std::option::Option<&str> {
        self.provisioning_role_arn.as_deref()
    }
    /// <p>Gets information about a pre-provisioned hook.</p>
    pub fn pre_provisioning_hook(&self) -> std::option::Option<&crate::model::ProvisioningHook> {
        self.pre_provisioning_hook.as_ref()
    }
}
impl std::fmt::Debug for DescribeProvisioningTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProvisioningTemplateOutput");
        formatter.field("template_arn", &self.template_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("default_version_id", &self.default_version_id);
        formatter.field("template_body", &self.template_body);
        formatter.field("enabled", &self.enabled);
        formatter.field("provisioning_role_arn", &self.provisioning_role_arn);
        formatter.field("pre_provisioning_hook", &self.pre_provisioning_hook);
        formatter.finish()
    }
}
/// See [`DescribeProvisioningTemplateOutput`](crate::output::DescribeProvisioningTemplateOutput)
pub mod describe_provisioning_template_output {
    /// A builder for [`DescribeProvisioningTemplateOutput`](crate::output::DescribeProvisioningTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) default_version_id: std::option::Option<i32>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) provisioning_role_arn: std::option::Option<std::string::String>,
        pub(crate) pre_provisioning_hook: std::option::Option<crate::model::ProvisioningHook>,
    }
    impl Builder {
        /// <p>The ARN of the fleet provisioning template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the fleet provisioning template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date when the fleet provisioning template was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the fleet provisioning template was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date when the fleet provisioning template was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date when the fleet provisioning template was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The default fleet template version ID.</p>
        pub fn default_version_id(mut self, input: i32) -> Self {
            self.default_version_id = Some(input);
            self
        }
        /// <p>The default fleet template version ID.</p>
        pub fn set_default_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.default_version_id = input;
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>True if the fleet provisioning template is enabled, otherwise false.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if the fleet provisioning template is enabled, otherwise false.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn provisioning_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn set_provisioning_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_role_arn = input;
            self
        }
        /// <p>Gets information about a pre-provisioned hook.</p>
        pub fn pre_provisioning_hook(mut self, input: crate::model::ProvisioningHook) -> Self {
            self.pre_provisioning_hook = Some(input);
            self
        }
        /// <p>Gets information about a pre-provisioned hook.</p>
        pub fn set_pre_provisioning_hook(
            mut self,
            input: std::option::Option<crate::model::ProvisioningHook>,
        ) -> Self {
            self.pre_provisioning_hook = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningTemplateOutput`](crate::output::DescribeProvisioningTemplateOutput)
        pub fn build(self) -> crate::output::DescribeProvisioningTemplateOutput {
            crate::output::DescribeProvisioningTemplateOutput {
                template_arn: self.template_arn,
                template_name: self.template_name,
                description: self.description,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                default_version_id: self.default_version_id,
                template_body: self.template_body,
                enabled: self.enabled.unwrap_or_default(),
                provisioning_role_arn: self.provisioning_role_arn,
                pre_provisioning_hook: self.pre_provisioning_hook,
            }
        }
    }
}
impl DescribeProvisioningTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningTemplateOutput`](crate::output::DescribeProvisioningTemplateOutput)
    pub fn builder() -> crate::output::describe_provisioning_template_output::Builder {
        crate::output::describe_provisioning_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMitigationActionOutput {
    /// <p>The friendly name that uniquely identifies the mitigation action.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The type of mitigation action.</p>
    pub action_type: std::option::Option<crate::model::MitigationActionType>,
    /// <p>The ARN that identifies this migration action.</p>
    pub action_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for this action.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role used to apply this action.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Parameters that control how the mitigation action is applied, specific to the type of mitigation action.</p>
    pub action_params: std::option::Option<crate::model::MitigationActionParams>,
    /// <p>The date and time when the mitigation action was added to your Amazon Web Services accounts.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the mitigation action was last changed.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeMitigationActionOutput {
    /// <p>The friendly name that uniquely identifies the mitigation action.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The type of mitigation action.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::MitigationActionType> {
        self.action_type.as_ref()
    }
    /// <p>The ARN that identifies this migration action.</p>
    pub fn action_arn(&self) -> std::option::Option<&str> {
        self.action_arn.as_deref()
    }
    /// <p>A unique identifier for this action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>The ARN of the IAM role used to apply this action.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Parameters that control how the mitigation action is applied, specific to the type of mitigation action.</p>
    pub fn action_params(&self) -> std::option::Option<&crate::model::MitigationActionParams> {
        self.action_params.as_ref()
    }
    /// <p>The date and time when the mitigation action was added to your Amazon Web Services accounts.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time when the mitigation action was last changed.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeMitigationActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMitigationActionOutput");
        formatter.field("action_name", &self.action_name);
        formatter.field("action_type", &self.action_type);
        formatter.field("action_arn", &self.action_arn);
        formatter.field("action_id", &self.action_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("action_params", &self.action_params);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`DescribeMitigationActionOutput`](crate::output::DescribeMitigationActionOutput)
pub mod describe_mitigation_action_output {
    /// A builder for [`DescribeMitigationActionOutput`](crate::output::DescribeMitigationActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) action_type: std::option::Option<crate::model::MitigationActionType>,
        pub(crate) action_arn: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) action_params: std::option::Option<crate::model::MitigationActionParams>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The type of mitigation action.</p>
        pub fn action_type(mut self, input: crate::model::MitigationActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of mitigation action.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::MitigationActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>The ARN that identifies this migration action.</p>
        pub fn action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_arn = Some(input.into());
            self
        }
        /// <p>The ARN that identifies this migration action.</p>
        pub fn set_action_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_arn = input;
            self
        }
        /// <p>A unique identifier for this action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for this action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>The ARN of the IAM role used to apply this action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role used to apply this action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Parameters that control how the mitigation action is applied, specific to the type of mitigation action.</p>
        pub fn action_params(mut self, input: crate::model::MitigationActionParams) -> Self {
            self.action_params = Some(input);
            self
        }
        /// <p>Parameters that control how the mitigation action is applied, specific to the type of mitigation action.</p>
        pub fn set_action_params(
            mut self,
            input: std::option::Option<crate::model::MitigationActionParams>,
        ) -> Self {
            self.action_params = input;
            self
        }
        /// <p>The date and time when the mitigation action was added to your Amazon Web Services accounts.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time when the mitigation action was added to your Amazon Web Services accounts.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time when the mitigation action was last changed.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time when the mitigation action was last changed.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMitigationActionOutput`](crate::output::DescribeMitigationActionOutput)
        pub fn build(self) -> crate::output::DescribeMitigationActionOutput {
            crate::output::DescribeMitigationActionOutput {
                action_name: self.action_name,
                action_type: self.action_type,
                action_arn: self.action_arn,
                action_id: self.action_id,
                role_arn: self.role_arn,
                action_params: self.action_params,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl DescribeMitigationActionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMitigationActionOutput`](crate::output::DescribeMitigationActionOutput)
    pub fn builder() -> crate::output::describe_mitigation_action_output::Builder {
        crate::output::describe_mitigation_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeManagedJobTemplateOutput {
    /// <p>The unique name of a managed template, such as <code>AWS-Reboot</code>.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The unique Amazon Resource Name (ARN) of the managed template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>The unique description of a managed template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version for a managed template.</p>
    pub template_version: std::option::Option<std::string::String>,
    /// <p>A list of environments that are supported with the managed job template.</p>
    pub environments: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed template.</p>
    pub document_parameters: std::option::Option<std::vec::Vec<crate::model::DocumentParameter>>,
    /// <p>The document schema for a managed job template.</p>
    pub document: std::option::Option<std::string::String>,
}
impl DescribeManagedJobTemplateOutput {
    /// <p>The unique name of a managed template, such as <code>AWS-Reboot</code>.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The unique Amazon Resource Name (ARN) of the managed template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>The unique description of a managed template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version for a managed template.</p>
    pub fn template_version(&self) -> std::option::Option<&str> {
        self.template_version.as_deref()
    }
    /// <p>A list of environments that are supported with the managed job template.</p>
    pub fn environments(&self) -> std::option::Option<&[std::string::String]> {
        self.environments.as_deref()
    }
    /// <p>A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed template.</p>
    pub fn document_parameters(&self) -> std::option::Option<&[crate::model::DocumentParameter]> {
        self.document_parameters.as_deref()
    }
    /// <p>The document schema for a managed job template.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
}
impl std::fmt::Debug for DescribeManagedJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeManagedJobTemplateOutput");
        formatter.field("template_name", &self.template_name);
        formatter.field("template_arn", &self.template_arn);
        formatter.field("description", &self.description);
        formatter.field("template_version", &self.template_version);
        formatter.field("environments", &self.environments);
        formatter.field("document_parameters", &self.document_parameters);
        formatter.field("document", &self.document);
        formatter.finish()
    }
}
/// See [`DescribeManagedJobTemplateOutput`](crate::output::DescribeManagedJobTemplateOutput)
pub mod describe_managed_job_template_output {
    /// A builder for [`DescribeManagedJobTemplateOutput`](crate::output::DescribeManagedJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_version: std::option::Option<std::string::String>,
        pub(crate) environments: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) document_parameters:
            std::option::Option<std::vec::Vec<crate::model::DocumentParameter>>,
        pub(crate) document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a managed template, such as <code>AWS-Reboot</code>.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The unique name of a managed template, such as <code>AWS-Reboot</code>.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the managed template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) of the managed template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>The unique description of a managed template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The unique description of a managed template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version for a managed template.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_version = Some(input.into());
            self
        }
        /// <p>The version for a managed template.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_version = input;
            self
        }
        /// Appends an item to `environments`.
        ///
        /// To override the contents of this collection use [`set_environments`](Self::set_environments).
        ///
        /// <p>A list of environments that are supported with the managed job template.</p>
        pub fn environments(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.environments.unwrap_or_default();
            v.push(input.into());
            self.environments = Some(v);
            self
        }
        /// <p>A list of environments that are supported with the managed job template.</p>
        pub fn set_environments(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.environments = input;
            self
        }
        /// Appends an item to `document_parameters`.
        ///
        /// To override the contents of this collection use [`set_document_parameters`](Self::set_document_parameters).
        ///
        /// <p>A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed template.</p>
        pub fn document_parameters(mut self, input: crate::model::DocumentParameter) -> Self {
            let mut v = self.document_parameters.unwrap_or_default();
            v.push(input);
            self.document_parameters = Some(v);
            self
        }
        /// <p>A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed template.</p>
        pub fn set_document_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentParameter>>,
        ) -> Self {
            self.document_parameters = input;
            self
        }
        /// <p>The document schema for a managed job template.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The document schema for a managed job template.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeManagedJobTemplateOutput`](crate::output::DescribeManagedJobTemplateOutput)
        pub fn build(self) -> crate::output::DescribeManagedJobTemplateOutput {
            crate::output::DescribeManagedJobTemplateOutput {
                template_name: self.template_name,
                template_arn: self.template_arn,
                description: self.description,
                template_version: self.template_version,
                environments: self.environments,
                document_parameters: self.document_parameters,
                document: self.document,
            }
        }
    }
}
impl DescribeManagedJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeManagedJobTemplateOutput`](crate::output::DescribeManagedJobTemplateOutput)
    pub fn builder() -> crate::output::describe_managed_job_template_output::Builder {
        crate::output::describe_managed_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobTemplateOutput {
    /// <p>The ARN of the job template.</p>
    pub job_template_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the job template.</p>
    pub job_template_id: std::option::Option<std::string::String>,
    /// <p>A description of the job template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An S3 link to the job document.</p>
    pub document_source: std::option::Option<std::string::String>,
    /// <p>The job document.</p>
    pub document: std::option::Option<std::string::String>,
    /// <p>The time, in seconds since the epoch, when the job template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Configuration for pre-signed S3 URLs.</p>
    pub presigned_url_config: std::option::Option<crate::model::PresignedUrlConfig>,
    /// <p>Allows you to create a staged rollout of a job.</p>
    pub job_executions_rollout_config:
        std::option::Option<crate::model::JobExecutionsRolloutConfig>,
    /// <p>The criteria that determine when and how a job abort takes place.</p>
    pub abort_config: std::option::Option<crate::model::AbortConfig>,
    /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    pub timeout_config: std::option::Option<crate::model::TimeoutConfig>,
    /// <p>The configuration that determines how many retries are allowed for each failure type for a job.</p>
    pub job_executions_retry_config: std::option::Option<crate::model::JobExecutionsRetryConfig>,
}
impl DescribeJobTemplateOutput {
    /// <p>The ARN of the job template.</p>
    pub fn job_template_arn(&self) -> std::option::Option<&str> {
        self.job_template_arn.as_deref()
    }
    /// <p>The unique identifier of the job template.</p>
    pub fn job_template_id(&self) -> std::option::Option<&str> {
        self.job_template_id.as_deref()
    }
    /// <p>A description of the job template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An S3 link to the job document.</p>
    pub fn document_source(&self) -> std::option::Option<&str> {
        self.document_source.as_deref()
    }
    /// <p>The job document.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
    /// <p>The time, in seconds since the epoch, when the job template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Configuration for pre-signed S3 URLs.</p>
    pub fn presigned_url_config(&self) -> std::option::Option<&crate::model::PresignedUrlConfig> {
        self.presigned_url_config.as_ref()
    }
    /// <p>Allows you to create a staged rollout of a job.</p>
    pub fn job_executions_rollout_config(
        &self,
    ) -> std::option::Option<&crate::model::JobExecutionsRolloutConfig> {
        self.job_executions_rollout_config.as_ref()
    }
    /// <p>The criteria that determine when and how a job abort takes place.</p>
    pub fn abort_config(&self) -> std::option::Option<&crate::model::AbortConfig> {
        self.abort_config.as_ref()
    }
    /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    pub fn timeout_config(&self) -> std::option::Option<&crate::model::TimeoutConfig> {
        self.timeout_config.as_ref()
    }
    /// <p>The configuration that determines how many retries are allowed for each failure type for a job.</p>
    pub fn job_executions_retry_config(
        &self,
    ) -> std::option::Option<&crate::model::JobExecutionsRetryConfig> {
        self.job_executions_retry_config.as_ref()
    }
}
impl std::fmt::Debug for DescribeJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobTemplateOutput");
        formatter.field("job_template_arn", &self.job_template_arn);
        formatter.field("job_template_id", &self.job_template_id);
        formatter.field("description", &self.description);
        formatter.field("document_source", &self.document_source);
        formatter.field("document", &self.document);
        formatter.field("created_at", &self.created_at);
        formatter.field("presigned_url_config", &self.presigned_url_config);
        formatter.field(
            "job_executions_rollout_config",
            &self.job_executions_rollout_config,
        );
        formatter.field("abort_config", &self.abort_config);
        formatter.field("timeout_config", &self.timeout_config);
        formatter.field(
            "job_executions_retry_config",
            &self.job_executions_retry_config,
        );
        formatter.finish()
    }
}
/// See [`DescribeJobTemplateOutput`](crate::output::DescribeJobTemplateOutput)
pub mod describe_job_template_output {
    /// A builder for [`DescribeJobTemplateOutput`](crate::output::DescribeJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template_arn: std::option::Option<std::string::String>,
        pub(crate) job_template_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) document_source: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) presigned_url_config: std::option::Option<crate::model::PresignedUrlConfig>,
        pub(crate) job_executions_rollout_config:
            std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        pub(crate) abort_config: std::option::Option<crate::model::AbortConfig>,
        pub(crate) timeout_config: std::option::Option<crate::model::TimeoutConfig>,
        pub(crate) job_executions_retry_config:
            std::option::Option<crate::model::JobExecutionsRetryConfig>,
    }
    impl Builder {
        /// <p>The ARN of the job template.</p>
        pub fn job_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the job template.</p>
        pub fn set_job_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_arn = input;
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_id = input;
            self
        }
        /// <p>A description of the job template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the job template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An S3 link to the job document.</p>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_source = Some(input.into());
            self
        }
        /// <p>An S3 link to the job document.</p>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_source = input;
            self
        }
        /// <p>The job document.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The job document.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn presigned_url_config(mut self, input: crate::model::PresignedUrlConfig) -> Self {
            self.presigned_url_config = Some(input);
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn set_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::PresignedUrlConfig>,
        ) -> Self {
            self.presigned_url_config = input;
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::JobExecutionsRolloutConfig,
        ) -> Self {
            self.job_executions_rollout_config = Some(input);
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        ) -> Self {
            self.job_executions_rollout_config = input;
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn abort_config(mut self, input: crate::model::AbortConfig) -> Self {
            self.abort_config = Some(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::AbortConfig>,
        ) -> Self {
            self.abort_config = input;
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn timeout_config(mut self, input: crate::model::TimeoutConfig) -> Self {
            self.timeout_config = Some(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::TimeoutConfig>,
        ) -> Self {
            self.timeout_config = input;
            self
        }
        /// <p>The configuration that determines how many retries are allowed for each failure type for a job.</p>
        pub fn job_executions_retry_config(
            mut self,
            input: crate::model::JobExecutionsRetryConfig,
        ) -> Self {
            self.job_executions_retry_config = Some(input);
            self
        }
        /// <p>The configuration that determines how many retries are allowed for each failure type for a job.</p>
        pub fn set_job_executions_retry_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRetryConfig>,
        ) -> Self {
            self.job_executions_retry_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobTemplateOutput`](crate::output::DescribeJobTemplateOutput)
        pub fn build(self) -> crate::output::DescribeJobTemplateOutput {
            crate::output::DescribeJobTemplateOutput {
                job_template_arn: self.job_template_arn,
                job_template_id: self.job_template_id,
                description: self.description,
                document_source: self.document_source,
                document: self.document,
                created_at: self.created_at,
                presigned_url_config: self.presigned_url_config,
                job_executions_rollout_config: self.job_executions_rollout_config,
                abort_config: self.abort_config,
                timeout_config: self.timeout_config,
                job_executions_retry_config: self.job_executions_retry_config,
            }
        }
    }
}
impl DescribeJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobTemplateOutput`](crate::output::DescribeJobTemplateOutput)
    pub fn builder() -> crate::output::describe_job_template_output::Builder {
        crate::output::describe_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobExecutionOutput {
    /// <p>Information about the job execution.</p>
    pub execution: std::option::Option<crate::model::JobExecution>,
}
impl DescribeJobExecutionOutput {
    /// <p>Information about the job execution.</p>
    pub fn execution(&self) -> std::option::Option<&crate::model::JobExecution> {
        self.execution.as_ref()
    }
}
impl std::fmt::Debug for DescribeJobExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobExecutionOutput");
        formatter.field("execution", &self.execution);
        formatter.finish()
    }
}
/// See [`DescribeJobExecutionOutput`](crate::output::DescribeJobExecutionOutput)
pub mod describe_job_execution_output {
    /// A builder for [`DescribeJobExecutionOutput`](crate::output::DescribeJobExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution: std::option::Option<crate::model::JobExecution>,
    }
    impl Builder {
        /// <p>Information about the job execution.</p>
        pub fn execution(mut self, input: crate::model::JobExecution) -> Self {
            self.execution = Some(input);
            self
        }
        /// <p>Information about the job execution.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::JobExecution>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobExecutionOutput`](crate::output::DescribeJobExecutionOutput)
        pub fn build(self) -> crate::output::DescribeJobExecutionOutput {
            crate::output::DescribeJobExecutionOutput {
                execution: self.execution,
            }
        }
    }
}
impl DescribeJobExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobExecutionOutput`](crate::output::DescribeJobExecutionOutput)
    pub fn builder() -> crate::output::describe_job_execution_output::Builder {
        crate::output::describe_job_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobOutput {
    /// <p>An S3 link to the job document.</p>
    pub document_source: std::option::Option<std::string::String>,
    /// <p>Information about the job.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl DescribeJobOutput {
    /// <p>An S3 link to the job document.</p>
    pub fn document_source(&self) -> std::option::Option<&str> {
        self.document_source.as_deref()
    }
    /// <p>Information about the job.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for DescribeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobOutput");
        formatter.field("document_source", &self.document_source);
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`DescribeJobOutput`](crate::output::DescribeJobOutput)
pub mod describe_job_output {
    /// A builder for [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_source: std::option::Option<std::string::String>,
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>An S3 link to the job document.</p>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_source = Some(input.into());
            self
        }
        /// <p>An S3 link to the job document.</p>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_source = input;
            self
        }
        /// <p>Information about the job.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Information about the job.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobOutput`](crate::output::DescribeJobOutput)
        pub fn build(self) -> crate::output::DescribeJobOutput {
            crate::output::DescribeJobOutput {
                document_source: self.document_source,
                job: self.job,
            }
        }
    }
}
impl DescribeJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    pub fn builder() -> crate::output::describe_job_output::Builder {
        crate::output::describe_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIndexOutput {
    /// <p>The index name.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The index status.</p>
    pub index_status: std::option::Option<crate::model::IndexStatus>,
    /// <p>Contains a value that specifies the type of indexing performed. Valid values are:</p>
    /// <ul>
    /// <li> <p>REGISTRY – Your thing index contains only registry data.</p> </li>
    /// <li> <p>REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.</p> </li>
    /// <li> <p>REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status data.</p> </li>
    /// <li> <p>REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing connectivity status data.</p> </li>
    /// <li> <p>MULTI_INDEXING_MODE - Your thing index contains multiple data sources. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_GetIndexingConfiguration.html">GetIndexingConfiguration</a>.</p> </li>
    /// </ul>
    pub schema: std::option::Option<std::string::String>,
}
impl DescribeIndexOutput {
    /// <p>The index name.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The index status.</p>
    pub fn index_status(&self) -> std::option::Option<&crate::model::IndexStatus> {
        self.index_status.as_ref()
    }
    /// <p>Contains a value that specifies the type of indexing performed. Valid values are:</p>
    /// <ul>
    /// <li> <p>REGISTRY – Your thing index contains only registry data.</p> </li>
    /// <li> <p>REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.</p> </li>
    /// <li> <p>REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status data.</p> </li>
    /// <li> <p>REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing connectivity status data.</p> </li>
    /// <li> <p>MULTI_INDEXING_MODE - Your thing index contains multiple data sources. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_GetIndexingConfiguration.html">GetIndexingConfiguration</a>.</p> </li>
    /// </ul>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for DescribeIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIndexOutput");
        formatter.field("index_name", &self.index_name);
        formatter.field("index_status", &self.index_status);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`DescribeIndexOutput`](crate::output::DescribeIndexOutput)
pub mod describe_index_output {
    /// A builder for [`DescribeIndexOutput`](crate::output::DescribeIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) index_status: std::option::Option<crate::model::IndexStatus>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The index status.</p>
        pub fn index_status(mut self, input: crate::model::IndexStatus) -> Self {
            self.index_status = Some(input);
            self
        }
        /// <p>The index status.</p>
        pub fn set_index_status(
            mut self,
            input: std::option::Option<crate::model::IndexStatus>,
        ) -> Self {
            self.index_status = input;
            self
        }
        /// <p>Contains a value that specifies the type of indexing performed. Valid values are:</p>
        /// <ul>
        /// <li> <p>REGISTRY – Your thing index contains only registry data.</p> </li>
        /// <li> <p>REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.</p> </li>
        /// <li> <p>REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status data.</p> </li>
        /// <li> <p>REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing connectivity status data.</p> </li>
        /// <li> <p>MULTI_INDEXING_MODE - Your thing index contains multiple data sources. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_GetIndexingConfiguration.html">GetIndexingConfiguration</a>.</p> </li>
        /// </ul>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>Contains a value that specifies the type of indexing performed. Valid values are:</p>
        /// <ul>
        /// <li> <p>REGISTRY – Your thing index contains only registry data.</p> </li>
        /// <li> <p>REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.</p> </li>
        /// <li> <p>REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status data.</p> </li>
        /// <li> <p>REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing connectivity status data.</p> </li>
        /// <li> <p>MULTI_INDEXING_MODE - Your thing index contains multiple data sources. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_GetIndexingConfiguration.html">GetIndexingConfiguration</a>.</p> </li>
        /// </ul>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIndexOutput`](crate::output::DescribeIndexOutput)
        pub fn build(self) -> crate::output::DescribeIndexOutput {
            crate::output::DescribeIndexOutput {
                index_name: self.index_name,
                index_status: self.index_status,
                schema: self.schema,
            }
        }
    }
}
impl DescribeIndexOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIndexOutput`](crate::output::DescribeIndexOutput)
    pub fn builder() -> crate::output::describe_index_output::Builder {
        crate::output::describe_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetMetricOutput {
    /// <p>The name of the fleet metric to describe.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The search query string.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The type of the aggregation query.</p>
    pub aggregation_type: std::option::Option<crate::model::AggregationType>,
    /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
    pub period: std::option::Option<i32>,
    /// <p>The field to aggregate.</p>
    pub aggregation_field: std::option::Option<std::string::String>,
    /// <p>The fleet metric description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The query version.</p>
    pub query_version: std::option::Option<std::string::String>,
    /// <p>The name of the index to search.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The date when the fleet metric is created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the fleet metric is last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.</p>
    pub unit: std::option::Option<crate::model::FleetMetricUnit>,
    /// <p>The version of the fleet metric.</p>
    pub version: i64,
    /// <p>The ARN of the fleet metric to describe.</p>
    pub metric_arn: std::option::Option<std::string::String>,
}
impl DescribeFleetMetricOutput {
    /// <p>The name of the fleet metric to describe.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The search query string.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The type of the aggregation query.</p>
    pub fn aggregation_type(&self) -> std::option::Option<&crate::model::AggregationType> {
        self.aggregation_type.as_ref()
    }
    /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
    pub fn period(&self) -> std::option::Option<i32> {
        self.period
    }
    /// <p>The field to aggregate.</p>
    pub fn aggregation_field(&self) -> std::option::Option<&str> {
        self.aggregation_field.as_deref()
    }
    /// <p>The fleet metric description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The query version.</p>
    pub fn query_version(&self) -> std::option::Option<&str> {
        self.query_version.as_deref()
    }
    /// <p>The name of the index to search.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The date when the fleet metric is created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date when the fleet metric is last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::FleetMetricUnit> {
        self.unit.as_ref()
    }
    /// <p>The version of the fleet metric.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The ARN of the fleet metric to describe.</p>
    pub fn metric_arn(&self) -> std::option::Option<&str> {
        self.metric_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetMetricOutput");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("query_string", &self.query_string);
        formatter.field("aggregation_type", &self.aggregation_type);
        formatter.field("period", &self.period);
        formatter.field("aggregation_field", &self.aggregation_field);
        formatter.field("description", &self.description);
        formatter.field("query_version", &self.query_version);
        formatter.field("index_name", &self.index_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("unit", &self.unit);
        formatter.field("version", &self.version);
        formatter.field("metric_arn", &self.metric_arn);
        formatter.finish()
    }
}
/// See [`DescribeFleetMetricOutput`](crate::output::DescribeFleetMetricOutput)
pub mod describe_fleet_metric_output {
    /// A builder for [`DescribeFleetMetricOutput`](crate::output::DescribeFleetMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) aggregation_type: std::option::Option<crate::model::AggregationType>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) aggregation_field: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) unit: std::option::Option<crate::model::FleetMetricUnit>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) metric_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet metric to describe.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet metric to describe.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.aggregation_type = Some(input);
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.aggregation_type = input;
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregation_field = Some(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregation_field = input;
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The date when the fleet metric is created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the fleet metric is created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date when the fleet metric is last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date when the fleet metric is last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.</p>
        pub fn unit(mut self, input: crate::model::FleetMetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::FleetMetricUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// <p>The version of the fleet metric.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the fleet metric.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The ARN of the fleet metric to describe.</p>
        pub fn metric_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the fleet metric to describe.</p>
        pub fn set_metric_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetMetricOutput`](crate::output::DescribeFleetMetricOutput)
        pub fn build(self) -> crate::output::DescribeFleetMetricOutput {
            crate::output::DescribeFleetMetricOutput {
                metric_name: self.metric_name,
                query_string: self.query_string,
                aggregation_type: self.aggregation_type,
                period: self.period,
                aggregation_field: self.aggregation_field,
                description: self.description,
                query_version: self.query_version,
                index_name: self.index_name,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                unit: self.unit,
                version: self.version.unwrap_or_default(),
                metric_arn: self.metric_arn,
            }
        }
    }
}
impl DescribeFleetMetricOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetMetricOutput`](crate::output::DescribeFleetMetricOutput)
    pub fn builder() -> crate::output::describe_fleet_metric_output::Builder {
        crate::output::describe_fleet_metric_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventConfigurationsOutput {
    /// <p>The event configurations.</p>
    pub event_configurations: std::option::Option<
        std::collections::HashMap<crate::model::EventType, crate::model::Configuration>,
    >,
    /// <p>The creation date of the event configuration.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the event configurations were last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeEventConfigurationsOutput {
    /// <p>The event configurations.</p>
    pub fn event_configurations(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::EventType, crate::model::Configuration>,
    > {
        self.event_configurations.as_ref()
    }
    /// <p>The creation date of the event configuration.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the event configurations were last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeEventConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventConfigurationsOutput");
        formatter.field("event_configurations", &self.event_configurations);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`DescribeEventConfigurationsOutput`](crate::output::DescribeEventConfigurationsOutput)
pub mod describe_event_configurations_output {
    /// A builder for [`DescribeEventConfigurationsOutput`](crate::output::DescribeEventConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_configurations: std::option::Option<
            std::collections::HashMap<crate::model::EventType, crate::model::Configuration>,
        >,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// Adds a key-value pair to `event_configurations`.
        ///
        /// To override the contents of this collection use [`set_event_configurations`](Self::set_event_configurations).
        ///
        /// <p>The event configurations.</p>
        pub fn event_configurations(
            mut self,
            k: crate::model::EventType,
            v: crate::model::Configuration,
        ) -> Self {
            let mut hash_map = self.event_configurations.unwrap_or_default();
            hash_map.insert(k, v);
            self.event_configurations = Some(hash_map);
            self
        }
        /// <p>The event configurations.</p>
        pub fn set_event_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::EventType, crate::model::Configuration>,
            >,
        ) -> Self {
            self.event_configurations = input;
            self
        }
        /// <p>The creation date of the event configuration.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date of the event configuration.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the event configurations were last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the event configurations were last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventConfigurationsOutput`](crate::output::DescribeEventConfigurationsOutput)
        pub fn build(self) -> crate::output::DescribeEventConfigurationsOutput {
            crate::output::DescribeEventConfigurationsOutput {
                event_configurations: self.event_configurations,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl DescribeEventConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventConfigurationsOutput`](crate::output::DescribeEventConfigurationsOutput)
    pub fn builder() -> crate::output::describe_event_configurations_output::Builder {
        crate::output::describe_event_configurations_output::Builder::default()
    }
}

/// <p>The output from the DescribeEndpoint operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointOutput {
    /// <p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>
    pub endpoint_address: std::option::Option<std::string::String>,
}
impl DescribeEndpointOutput {
    /// <p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>
    pub fn endpoint_address(&self) -> std::option::Option<&str> {
        self.endpoint_address.as_deref()
    }
}
impl std::fmt::Debug for DescribeEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointOutput");
        formatter.field("endpoint_address", &self.endpoint_address);
        formatter.finish()
    }
}
/// See [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
pub mod describe_endpoint_output {
    /// A builder for [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>
        pub fn endpoint_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_address = Some(input.into());
            self
        }
        /// <p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>
        pub fn set_endpoint_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_address = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
        pub fn build(self) -> crate::output::DescribeEndpointOutput {
            crate::output::DescribeEndpointOutput {
                endpoint_address: self.endpoint_address,
            }
        }
    }
}
impl DescribeEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
    pub fn builder() -> crate::output::describe_endpoint_output::Builder {
        crate::output::describe_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainConfigurationOutput {
    /// <p>The name of the domain configuration.</p>
    pub domain_configuration_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the domain configuration.</p>
    pub domain_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A list containing summary information about the server certificate included in the domain configuration.</p>
    pub server_certificates:
        std::option::Option<std::vec::Vec<crate::model::ServerCertificateSummary>>,
    /// <p>An object that specifies the authorization service for a domain.</p>
    pub authorizer_config: std::option::Option<crate::model::AuthorizerConfig>,
    /// <p>A Boolean value that specifies the current state of the domain configuration.</p>
    pub domain_configuration_status: std::option::Option<crate::model::DomainConfigurationStatus>,
    /// <p>The type of service delivered by the endpoint.</p>
    pub service_type: std::option::Option<crate::model::ServiceType>,
    /// <p>The type of the domain.</p>
    pub domain_type: std::option::Option<crate::model::DomainType>,
    /// <p>The date and time the domain configuration's status was last changed.</p>
    pub last_status_change_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeDomainConfigurationOutput {
    /// <p>The name of the domain configuration.</p>
    pub fn domain_configuration_name(&self) -> std::option::Option<&str> {
        self.domain_configuration_name.as_deref()
    }
    /// <p>The ARN of the domain configuration.</p>
    pub fn domain_configuration_arn(&self) -> std::option::Option<&str> {
        self.domain_configuration_arn.as_deref()
    }
    /// <p>The name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A list containing summary information about the server certificate included in the domain configuration.</p>
    pub fn server_certificates(
        &self,
    ) -> std::option::Option<&[crate::model::ServerCertificateSummary]> {
        self.server_certificates.as_deref()
    }
    /// <p>An object that specifies the authorization service for a domain.</p>
    pub fn authorizer_config(&self) -> std::option::Option<&crate::model::AuthorizerConfig> {
        self.authorizer_config.as_ref()
    }
    /// <p>A Boolean value that specifies the current state of the domain configuration.</p>
    pub fn domain_configuration_status(
        &self,
    ) -> std::option::Option<&crate::model::DomainConfigurationStatus> {
        self.domain_configuration_status.as_ref()
    }
    /// <p>The type of service delivered by the endpoint.</p>
    pub fn service_type(&self) -> std::option::Option<&crate::model::ServiceType> {
        self.service_type.as_ref()
    }
    /// <p>The type of the domain.</p>
    pub fn domain_type(&self) -> std::option::Option<&crate::model::DomainType> {
        self.domain_type.as_ref()
    }
    /// <p>The date and time the domain configuration's status was last changed.</p>
    pub fn last_status_change_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_status_change_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeDomainConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainConfigurationOutput");
        formatter.field("domain_configuration_name", &self.domain_configuration_name);
        formatter.field("domain_configuration_arn", &self.domain_configuration_arn);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("server_certificates", &self.server_certificates);
        formatter.field("authorizer_config", &self.authorizer_config);
        formatter.field(
            "domain_configuration_status",
            &self.domain_configuration_status,
        );
        formatter.field("service_type", &self.service_type);
        formatter.field("domain_type", &self.domain_type);
        formatter.field("last_status_change_date", &self.last_status_change_date);
        formatter.finish()
    }
}
/// See [`DescribeDomainConfigurationOutput`](crate::output::DescribeDomainConfigurationOutput)
pub mod describe_domain_configuration_output {
    /// A builder for [`DescribeDomainConfigurationOutput`](crate::output::DescribeDomainConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configuration_name: std::option::Option<std::string::String>,
        pub(crate) domain_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) server_certificates:
            std::option::Option<std::vec::Vec<crate::model::ServerCertificateSummary>>,
        pub(crate) authorizer_config: std::option::Option<crate::model::AuthorizerConfig>,
        pub(crate) domain_configuration_status:
            std::option::Option<crate::model::DomainConfigurationStatus>,
        pub(crate) service_type: std::option::Option<crate::model::ServiceType>,
        pub(crate) domain_type: std::option::Option<crate::model::DomainType>,
        pub(crate) last_status_change_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the domain configuration.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the domain configuration.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_name = input;
            self
        }
        /// <p>The ARN of the domain configuration.</p>
        pub fn domain_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the domain configuration.</p>
        pub fn set_domain_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_arn = input;
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `server_certificates`.
        ///
        /// To override the contents of this collection use [`set_server_certificates`](Self::set_server_certificates).
        ///
        /// <p>A list containing summary information about the server certificate included in the domain configuration.</p>
        pub fn server_certificates(
            mut self,
            input: crate::model::ServerCertificateSummary,
        ) -> Self {
            let mut v = self.server_certificates.unwrap_or_default();
            v.push(input);
            self.server_certificates = Some(v);
            self
        }
        /// <p>A list containing summary information about the server certificate included in the domain configuration.</p>
        pub fn set_server_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerCertificateSummary>>,
        ) -> Self {
            self.server_certificates = input;
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn authorizer_config(mut self, input: crate::model::AuthorizerConfig) -> Self {
            self.authorizer_config = Some(input);
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn set_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::AuthorizerConfig>,
        ) -> Self {
            self.authorizer_config = input;
            self
        }
        /// <p>A Boolean value that specifies the current state of the domain configuration.</p>
        pub fn domain_configuration_status(
            mut self,
            input: crate::model::DomainConfigurationStatus,
        ) -> Self {
            self.domain_configuration_status = Some(input);
            self
        }
        /// <p>A Boolean value that specifies the current state of the domain configuration.</p>
        pub fn set_domain_configuration_status(
            mut self,
            input: std::option::Option<crate::model::DomainConfigurationStatus>,
        ) -> Self {
            self.domain_configuration_status = input;
            self
        }
        /// <p>The type of service delivered by the endpoint.</p>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// <p>The type of the domain.</p>
        pub fn domain_type(mut self, input: crate::model::DomainType) -> Self {
            self.domain_type = Some(input);
            self
        }
        /// <p>The type of the domain.</p>
        pub fn set_domain_type(
            mut self,
            input: std::option::Option<crate::model::DomainType>,
        ) -> Self {
            self.domain_type = input;
            self
        }
        /// <p>The date and time the domain configuration's status was last changed.</p>
        pub fn last_status_change_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_status_change_date = Some(input);
            self
        }
        /// <p>The date and time the domain configuration's status was last changed.</p>
        pub fn set_last_status_change_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_status_change_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainConfigurationOutput`](crate::output::DescribeDomainConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeDomainConfigurationOutput {
            crate::output::DescribeDomainConfigurationOutput {
                domain_configuration_name: self.domain_configuration_name,
                domain_configuration_arn: self.domain_configuration_arn,
                domain_name: self.domain_name,
                server_certificates: self.server_certificates,
                authorizer_config: self.authorizer_config,
                domain_configuration_status: self.domain_configuration_status,
                service_type: self.service_type,
                domain_type: self.domain_type,
                last_status_change_date: self.last_status_change_date,
            }
        }
    }
}
impl DescribeDomainConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainConfigurationOutput`](crate::output::DescribeDomainConfigurationOutput)
    pub fn builder() -> crate::output::describe_domain_configuration_output::Builder {
        crate::output::describe_domain_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDimensionOutput {
    /// <p>The unique identifier for the dimension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the dimension.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of the dimension.</p>
    pub r#type: std::option::Option<crate::model::DimensionType>,
    /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    pub string_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date the dimension was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the dimension was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeDimensionOutput {
    /// <p>The unique identifier for the dimension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the dimension.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of the dimension.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DimensionType> {
        self.r#type.as_ref()
    }
    /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    pub fn string_values(&self) -> std::option::Option<&[std::string::String]> {
        self.string_values.as_deref()
    }
    /// <p>The date the dimension was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date the dimension was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeDimensionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDimensionOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("string_values", &self.string_values);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`DescribeDimensionOutput`](crate::output::DescribeDimensionOutput)
pub mod describe_dimension_output {
    /// A builder for [`DescribeDimensionOutput`](crate::output::DescribeDimensionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DimensionType>,
        pub(crate) string_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier for the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique identifier for the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the dimension.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the dimension.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of the dimension.</p>
        pub fn r#type(mut self, input: crate::model::DimensionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the dimension.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::DimensionType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `string_values`.
        ///
        /// To override the contents of this collection use [`set_string_values`](Self::set_string_values).
        ///
        /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
        pub fn string_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_values.unwrap_or_default();
            v.push(input.into());
            self.string_values = Some(v);
            self
        }
        /// <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
        pub fn set_string_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_values = input;
            self
        }
        /// <p>The date the dimension was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the dimension was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date the dimension was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the dimension was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDimensionOutput`](crate::output::DescribeDimensionOutput)
        pub fn build(self) -> crate::output::DescribeDimensionOutput {
            crate::output::DescribeDimensionOutput {
                name: self.name,
                arn: self.arn,
                r#type: self.r#type,
                string_values: self.string_values,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl DescribeDimensionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDimensionOutput`](crate::output::DescribeDimensionOutput)
    pub fn builder() -> crate::output::describe_dimension_output::Builder {
        crate::output::describe_dimension_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDetectMitigationActionsTaskOutput {
    /// <p> The description of a task. </p>
    pub task_summary: std::option::Option<crate::model::DetectMitigationActionsTaskSummary>,
}
impl DescribeDetectMitigationActionsTaskOutput {
    /// <p> The description of a task. </p>
    pub fn task_summary(
        &self,
    ) -> std::option::Option<&crate::model::DetectMitigationActionsTaskSummary> {
        self.task_summary.as_ref()
    }
}
impl std::fmt::Debug for DescribeDetectMitigationActionsTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDetectMitigationActionsTaskOutput");
        formatter.field("task_summary", &self.task_summary);
        formatter.finish()
    }
}
/// See [`DescribeDetectMitigationActionsTaskOutput`](crate::output::DescribeDetectMitigationActionsTaskOutput)
pub mod describe_detect_mitigation_actions_task_output {
    /// A builder for [`DescribeDetectMitigationActionsTaskOutput`](crate::output::DescribeDetectMitigationActionsTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_summary:
            std::option::Option<crate::model::DetectMitigationActionsTaskSummary>,
    }
    impl Builder {
        /// <p> The description of a task. </p>
        pub fn task_summary(
            mut self,
            input: crate::model::DetectMitigationActionsTaskSummary,
        ) -> Self {
            self.task_summary = Some(input);
            self
        }
        /// <p> The description of a task. </p>
        pub fn set_task_summary(
            mut self,
            input: std::option::Option<crate::model::DetectMitigationActionsTaskSummary>,
        ) -> Self {
            self.task_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectMitigationActionsTaskOutput`](crate::output::DescribeDetectMitigationActionsTaskOutput)
        pub fn build(self) -> crate::output::DescribeDetectMitigationActionsTaskOutput {
            crate::output::DescribeDetectMitigationActionsTaskOutput {
                task_summary: self.task_summary,
            }
        }
    }
}
impl DescribeDetectMitigationActionsTaskOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDetectMitigationActionsTaskOutput`](crate::output::DescribeDetectMitigationActionsTaskOutput)
    pub fn builder() -> crate::output::describe_detect_mitigation_actions_task_output::Builder {
        crate::output::describe_detect_mitigation_actions_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDefaultAuthorizerOutput {
    /// <p>The default authorizer's description.</p>
    pub authorizer_description: std::option::Option<crate::model::AuthorizerDescription>,
}
impl DescribeDefaultAuthorizerOutput {
    /// <p>The default authorizer's description.</p>
    pub fn authorizer_description(
        &self,
    ) -> std::option::Option<&crate::model::AuthorizerDescription> {
        self.authorizer_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeDefaultAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDefaultAuthorizerOutput");
        formatter.field("authorizer_description", &self.authorizer_description);
        formatter.finish()
    }
}
/// See [`DescribeDefaultAuthorizerOutput`](crate::output::DescribeDefaultAuthorizerOutput)
pub mod describe_default_authorizer_output {
    /// A builder for [`DescribeDefaultAuthorizerOutput`](crate::output::DescribeDefaultAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_description: std::option::Option<crate::model::AuthorizerDescription>,
    }
    impl Builder {
        /// <p>The default authorizer's description.</p>
        pub fn authorizer_description(
            mut self,
            input: crate::model::AuthorizerDescription,
        ) -> Self {
            self.authorizer_description = Some(input);
            self
        }
        /// <p>The default authorizer's description.</p>
        pub fn set_authorizer_description(
            mut self,
            input: std::option::Option<crate::model::AuthorizerDescription>,
        ) -> Self {
            self.authorizer_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDefaultAuthorizerOutput`](crate::output::DescribeDefaultAuthorizerOutput)
        pub fn build(self) -> crate::output::DescribeDefaultAuthorizerOutput {
            crate::output::DescribeDefaultAuthorizerOutput {
                authorizer_description: self.authorizer_description,
            }
        }
    }
}
impl DescribeDefaultAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDefaultAuthorizerOutput`](crate::output::DescribeDefaultAuthorizerOutput)
    pub fn builder() -> crate::output::describe_default_authorizer_output::Builder {
        crate::output::describe_default_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomMetricOutput {
    /// <p> The name of the custom metric. </p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    pub metric_arn: std::option::Option<std::string::String>,
    /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    pub metric_type: std::option::Option<crate::model::CustomMetricType>,
    /// <p> Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeCustomMetricOutput {
    /// <p> The name of the custom metric. </p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    pub fn metric_arn(&self) -> std::option::Option<&str> {
        self.metric_arn.as_deref()
    }
    /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    pub fn metric_type(&self) -> std::option::Option<&crate::model::CustomMetricType> {
        self.metric_type.as_ref()
    }
    /// <p> Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
}
impl std::fmt::Debug for DescribeCustomMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomMetricOutput");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_arn", &self.metric_arn);
        formatter.field("metric_type", &self.metric_type);
        formatter.field("display_name", &self.display_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.finish()
    }
}
/// See [`DescribeCustomMetricOutput`](crate::output::DescribeCustomMetricOutput)
pub mod describe_custom_metric_output {
    /// A builder for [`DescribeCustomMetricOutput`](crate::output::DescribeCustomMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_arn: std::option::Option<std::string::String>,
        pub(crate) metric_type: std::option::Option<crate::model::CustomMetricType>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
        pub fn metric_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Number (ARN) of the custom metric. </p>
        pub fn set_metric_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_arn = input;
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn metric_type(mut self, input: crate::model::CustomMetricType) -> Self {
            self.metric_type = Some(input);
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn set_metric_type(
            mut self,
            input: std::option::Option<crate::model::CustomMetricType>,
        ) -> Self {
            self.metric_type = input;
            self
        }
        /// <p> Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p> Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p> The creation date of the custom metric in milliseconds since epoch. </p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p> The time the custom metric was last modified in milliseconds since epoch. </p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomMetricOutput`](crate::output::DescribeCustomMetricOutput)
        pub fn build(self) -> crate::output::DescribeCustomMetricOutput {
            crate::output::DescribeCustomMetricOutput {
                metric_name: self.metric_name,
                metric_arn: self.metric_arn,
                metric_type: self.metric_type,
                display_name: self.display_name,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
            }
        }
    }
}
impl DescribeCustomMetricOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCustomMetricOutput`](crate::output::DescribeCustomMetricOutput)
    pub fn builder() -> crate::output::describe_custom_metric_output::Builder {
        crate::output::describe_custom_metric_output::Builder::default()
    }
}

/// <p>The output of the DescribeCertificate operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificateOutput {
    /// <p>The description of the certificate.</p>
    pub certificate_description: std::option::Option<crate::model::CertificateDescription>,
}
impl DescribeCertificateOutput {
    /// <p>The description of the certificate.</p>
    pub fn certificate_description(
        &self,
    ) -> std::option::Option<&crate::model::CertificateDescription> {
        self.certificate_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificateOutput");
        formatter.field("certificate_description", &self.certificate_description);
        formatter.finish()
    }
}
/// See [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
pub mod describe_certificate_output {
    /// A builder for [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_description:
            std::option::Option<crate::model::CertificateDescription>,
    }
    impl Builder {
        /// <p>The description of the certificate.</p>
        pub fn certificate_description(
            mut self,
            input: crate::model::CertificateDescription,
        ) -> Self {
            self.certificate_description = Some(input);
            self
        }
        /// <p>The description of the certificate.</p>
        pub fn set_certificate_description(
            mut self,
            input: std::option::Option<crate::model::CertificateDescription>,
        ) -> Self {
            self.certificate_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
        pub fn build(self) -> crate::output::DescribeCertificateOutput {
            crate::output::DescribeCertificateOutput {
                certificate_description: self.certificate_description,
            }
        }
    }
}
impl DescribeCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput)
    pub fn builder() -> crate::output::describe_certificate_output::Builder {
        crate::output::describe_certificate_output::Builder::default()
    }
}

/// <p>The output from the DescribeCACertificate operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCaCertificateOutput {
    /// <p>The CA certificate description.</p>
    pub certificate_description: std::option::Option<crate::model::CaCertificateDescription>,
    /// <p>Information about the registration configuration.</p>
    pub registration_config: std::option::Option<crate::model::RegistrationConfig>,
}
impl DescribeCaCertificateOutput {
    /// <p>The CA certificate description.</p>
    pub fn certificate_description(
        &self,
    ) -> std::option::Option<&crate::model::CaCertificateDescription> {
        self.certificate_description.as_ref()
    }
    /// <p>Information about the registration configuration.</p>
    pub fn registration_config(&self) -> std::option::Option<&crate::model::RegistrationConfig> {
        self.registration_config.as_ref()
    }
}
impl std::fmt::Debug for DescribeCaCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCaCertificateOutput");
        formatter.field("certificate_description", &self.certificate_description);
        formatter.field("registration_config", &self.registration_config);
        formatter.finish()
    }
}
/// See [`DescribeCaCertificateOutput`](crate::output::DescribeCaCertificateOutput)
pub mod describe_ca_certificate_output {
    /// A builder for [`DescribeCaCertificateOutput`](crate::output::DescribeCaCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_description:
            std::option::Option<crate::model::CaCertificateDescription>,
        pub(crate) registration_config: std::option::Option<crate::model::RegistrationConfig>,
    }
    impl Builder {
        /// <p>The CA certificate description.</p>
        pub fn certificate_description(
            mut self,
            input: crate::model::CaCertificateDescription,
        ) -> Self {
            self.certificate_description = Some(input);
            self
        }
        /// <p>The CA certificate description.</p>
        pub fn set_certificate_description(
            mut self,
            input: std::option::Option<crate::model::CaCertificateDescription>,
        ) -> Self {
            self.certificate_description = input;
            self
        }
        /// <p>Information about the registration configuration.</p>
        pub fn registration_config(mut self, input: crate::model::RegistrationConfig) -> Self {
            self.registration_config = Some(input);
            self
        }
        /// <p>Information about the registration configuration.</p>
        pub fn set_registration_config(
            mut self,
            input: std::option::Option<crate::model::RegistrationConfig>,
        ) -> Self {
            self.registration_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCaCertificateOutput`](crate::output::DescribeCaCertificateOutput)
        pub fn build(self) -> crate::output::DescribeCaCertificateOutput {
            crate::output::DescribeCaCertificateOutput {
                certificate_description: self.certificate_description,
                registration_config: self.registration_config,
            }
        }
    }
}
impl DescribeCaCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCaCertificateOutput`](crate::output::DescribeCaCertificateOutput)
    pub fn builder() -> crate::output::describe_ca_certificate_output::Builder {
        crate::output::describe_ca_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBillingGroupOutput {
    /// <p>The name of the billing group.</p>
    pub billing_group_name: std::option::Option<std::string::String>,
    /// <p>The ID of the billing group.</p>
    pub billing_group_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the billing group.</p>
    pub billing_group_arn: std::option::Option<std::string::String>,
    /// <p>The version of the billing group.</p>
    pub version: i64,
    /// <p>The properties of the billing group.</p>
    pub billing_group_properties: std::option::Option<crate::model::BillingGroupProperties>,
    /// <p>Additional information about the billing group.</p>
    pub billing_group_metadata: std::option::Option<crate::model::BillingGroupMetadata>,
}
impl DescribeBillingGroupOutput {
    /// <p>The name of the billing group.</p>
    pub fn billing_group_name(&self) -> std::option::Option<&str> {
        self.billing_group_name.as_deref()
    }
    /// <p>The ID of the billing group.</p>
    pub fn billing_group_id(&self) -> std::option::Option<&str> {
        self.billing_group_id.as_deref()
    }
    /// <p>The ARN of the billing group.</p>
    pub fn billing_group_arn(&self) -> std::option::Option<&str> {
        self.billing_group_arn.as_deref()
    }
    /// <p>The version of the billing group.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The properties of the billing group.</p>
    pub fn billing_group_properties(
        &self,
    ) -> std::option::Option<&crate::model::BillingGroupProperties> {
        self.billing_group_properties.as_ref()
    }
    /// <p>Additional information about the billing group.</p>
    pub fn billing_group_metadata(
        &self,
    ) -> std::option::Option<&crate::model::BillingGroupMetadata> {
        self.billing_group_metadata.as_ref()
    }
}
impl std::fmt::Debug for DescribeBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBillingGroupOutput");
        formatter.field("billing_group_name", &self.billing_group_name);
        formatter.field("billing_group_id", &self.billing_group_id);
        formatter.field("billing_group_arn", &self.billing_group_arn);
        formatter.field("version", &self.version);
        formatter.field("billing_group_properties", &self.billing_group_properties);
        formatter.field("billing_group_metadata", &self.billing_group_metadata);
        formatter.finish()
    }
}
/// See [`DescribeBillingGroupOutput`](crate::output::DescribeBillingGroupOutput)
pub mod describe_billing_group_output {
    /// A builder for [`DescribeBillingGroupOutput`](crate::output::DescribeBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
        pub(crate) billing_group_id: std::option::Option<std::string::String>,
        pub(crate) billing_group_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) billing_group_properties:
            std::option::Option<crate::model::BillingGroupProperties>,
        pub(crate) billing_group_metadata: std::option::Option<crate::model::BillingGroupMetadata>,
    }
    impl Builder {
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// <p>The ID of the billing group.</p>
        pub fn billing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the billing group.</p>
        pub fn set_billing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_id = input;
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_arn = input;
            self
        }
        /// <p>The version of the billing group.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the billing group.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn billing_group_properties(
            mut self,
            input: crate::model::BillingGroupProperties,
        ) -> Self {
            self.billing_group_properties = Some(input);
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn set_billing_group_properties(
            mut self,
            input: std::option::Option<crate::model::BillingGroupProperties>,
        ) -> Self {
            self.billing_group_properties = input;
            self
        }
        /// <p>Additional information about the billing group.</p>
        pub fn billing_group_metadata(mut self, input: crate::model::BillingGroupMetadata) -> Self {
            self.billing_group_metadata = Some(input);
            self
        }
        /// <p>Additional information about the billing group.</p>
        pub fn set_billing_group_metadata(
            mut self,
            input: std::option::Option<crate::model::BillingGroupMetadata>,
        ) -> Self {
            self.billing_group_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBillingGroupOutput`](crate::output::DescribeBillingGroupOutput)
        pub fn build(self) -> crate::output::DescribeBillingGroupOutput {
            crate::output::DescribeBillingGroupOutput {
                billing_group_name: self.billing_group_name,
                billing_group_id: self.billing_group_id,
                billing_group_arn: self.billing_group_arn,
                version: self.version.unwrap_or_default(),
                billing_group_properties: self.billing_group_properties,
                billing_group_metadata: self.billing_group_metadata,
            }
        }
    }
}
impl DescribeBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBillingGroupOutput`](crate::output::DescribeBillingGroupOutput)
    pub fn builder() -> crate::output::describe_billing_group_output::Builder {
        crate::output::describe_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAuthorizerOutput {
    /// <p>The authorizer description.</p>
    pub authorizer_description: std::option::Option<crate::model::AuthorizerDescription>,
}
impl DescribeAuthorizerOutput {
    /// <p>The authorizer description.</p>
    pub fn authorizer_description(
        &self,
    ) -> std::option::Option<&crate::model::AuthorizerDescription> {
        self.authorizer_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAuthorizerOutput");
        formatter.field("authorizer_description", &self.authorizer_description);
        formatter.finish()
    }
}
/// See [`DescribeAuthorizerOutput`](crate::output::DescribeAuthorizerOutput)
pub mod describe_authorizer_output {
    /// A builder for [`DescribeAuthorizerOutput`](crate::output::DescribeAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_description: std::option::Option<crate::model::AuthorizerDescription>,
    }
    impl Builder {
        /// <p>The authorizer description.</p>
        pub fn authorizer_description(
            mut self,
            input: crate::model::AuthorizerDescription,
        ) -> Self {
            self.authorizer_description = Some(input);
            self
        }
        /// <p>The authorizer description.</p>
        pub fn set_authorizer_description(
            mut self,
            input: std::option::Option<crate::model::AuthorizerDescription>,
        ) -> Self {
            self.authorizer_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuthorizerOutput`](crate::output::DescribeAuthorizerOutput)
        pub fn build(self) -> crate::output::DescribeAuthorizerOutput {
            crate::output::DescribeAuthorizerOutput {
                authorizer_description: self.authorizer_description,
            }
        }
    }
}
impl DescribeAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAuthorizerOutput`](crate::output::DescribeAuthorizerOutput)
    pub fn builder() -> crate::output::describe_authorizer_output::Builder {
        crate::output::describe_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAuditTaskOutput {
    /// <p>The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
    pub task_status: std::option::Option<crate::model::AuditTaskStatus>,
    /// <p>The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
    pub task_type: std::option::Option<crate::model::AuditTaskType>,
    /// <p>The time the audit started.</p>
    pub task_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Statistical information about the audit.</p>
    pub task_statistics: std::option::Option<crate::model::TaskStatistics>,
    /// <p>The name of the scheduled audit (only if the audit was a scheduled audit).</p>
    pub scheduled_audit_name: std::option::Option<std::string::String>,
    /// <p>Detailed information about each check performed during this audit.</p>
    pub audit_details: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AuditCheckDetails>,
    >,
}
impl DescribeAuditTaskOutput {
    /// <p>The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
    pub fn task_status(&self) -> std::option::Option<&crate::model::AuditTaskStatus> {
        self.task_status.as_ref()
    }
    /// <p>The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
    pub fn task_type(&self) -> std::option::Option<&crate::model::AuditTaskType> {
        self.task_type.as_ref()
    }
    /// <p>The time the audit started.</p>
    pub fn task_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.task_start_time.as_ref()
    }
    /// <p>Statistical information about the audit.</p>
    pub fn task_statistics(&self) -> std::option::Option<&crate::model::TaskStatistics> {
        self.task_statistics.as_ref()
    }
    /// <p>The name of the scheduled audit (only if the audit was a scheduled audit).</p>
    pub fn scheduled_audit_name(&self) -> std::option::Option<&str> {
        self.scheduled_audit_name.as_deref()
    }
    /// <p>Detailed information about each check performed during this audit.</p>
    pub fn audit_details(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AuditCheckDetails>,
    > {
        self.audit_details.as_ref()
    }
}
impl std::fmt::Debug for DescribeAuditTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAuditTaskOutput");
        formatter.field("task_status", &self.task_status);
        formatter.field("task_type", &self.task_type);
        formatter.field("task_start_time", &self.task_start_time);
        formatter.field("task_statistics", &self.task_statistics);
        formatter.field("scheduled_audit_name", &self.scheduled_audit_name);
        formatter.field("audit_details", &self.audit_details);
        formatter.finish()
    }
}
/// See [`DescribeAuditTaskOutput`](crate::output::DescribeAuditTaskOutput)
pub mod describe_audit_task_output {
    /// A builder for [`DescribeAuditTaskOutput`](crate::output::DescribeAuditTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_status: std::option::Option<crate::model::AuditTaskStatus>,
        pub(crate) task_type: std::option::Option<crate::model::AuditTaskType>,
        pub(crate) task_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) task_statistics: std::option::Option<crate::model::TaskStatistics>,
        pub(crate) scheduled_audit_name: std::option::Option<std::string::String>,
        pub(crate) audit_details: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AuditCheckDetails>,
        >,
    }
    impl Builder {
        /// <p>The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
        pub fn task_status(mut self, input: crate::model::AuditTaskStatus) -> Self {
            self.task_status = Some(input);
            self
        }
        /// <p>The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::AuditTaskStatus>,
        ) -> Self {
            self.task_status = input;
            self
        }
        /// <p>The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
        pub fn task_type(mut self, input: crate::model::AuditTaskType) -> Self {
            self.task_type = Some(input);
            self
        }
        /// <p>The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
        pub fn set_task_type(
            mut self,
            input: std::option::Option<crate::model::AuditTaskType>,
        ) -> Self {
            self.task_type = input;
            self
        }
        /// <p>The time the audit started.</p>
        pub fn task_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.task_start_time = Some(input);
            self
        }
        /// <p>The time the audit started.</p>
        pub fn set_task_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.task_start_time = input;
            self
        }
        /// <p>Statistical information about the audit.</p>
        pub fn task_statistics(mut self, input: crate::model::TaskStatistics) -> Self {
            self.task_statistics = Some(input);
            self
        }
        /// <p>Statistical information about the audit.</p>
        pub fn set_task_statistics(
            mut self,
            input: std::option::Option<crate::model::TaskStatistics>,
        ) -> Self {
            self.task_statistics = input;
            self
        }
        /// <p>The name of the scheduled audit (only if the audit was a scheduled audit).</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled audit (only if the audit was a scheduled audit).</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_name = input;
            self
        }
        /// Adds a key-value pair to `audit_details`.
        ///
        /// To override the contents of this collection use [`set_audit_details`](Self::set_audit_details).
        ///
        /// <p>Detailed information about each check performed during this audit.</p>
        pub fn audit_details(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AuditCheckDetails,
        ) -> Self {
            let mut hash_map = self.audit_details.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.audit_details = Some(hash_map);
            self
        }
        /// <p>Detailed information about each check performed during this audit.</p>
        pub fn set_audit_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AuditCheckDetails>,
            >,
        ) -> Self {
            self.audit_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditTaskOutput`](crate::output::DescribeAuditTaskOutput)
        pub fn build(self) -> crate::output::DescribeAuditTaskOutput {
            crate::output::DescribeAuditTaskOutput {
                task_status: self.task_status,
                task_type: self.task_type,
                task_start_time: self.task_start_time,
                task_statistics: self.task_statistics,
                scheduled_audit_name: self.scheduled_audit_name,
                audit_details: self.audit_details,
            }
        }
    }
}
impl DescribeAuditTaskOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAuditTaskOutput`](crate::output::DescribeAuditTaskOutput)
    pub fn builder() -> crate::output::describe_audit_task_output::Builder {
        crate::output::describe_audit_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAuditSuppressionOutput {
    /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    pub check_name: std::option::Option<std::string::String>,
    /// <p>Information that identifies the noncompliant resource.</p>
    pub resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
    /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
    pub expiration_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
    pub suppress_indefinitely: std::option::Option<bool>,
    /// <p> The description of the audit suppression. </p>
    pub description: std::option::Option<std::string::String>,
}
impl DescribeAuditSuppressionOutput {
    /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    pub fn check_name(&self) -> std::option::Option<&str> {
        self.check_name.as_deref()
    }
    /// <p>Information that identifies the noncompliant resource.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&crate::model::ResourceIdentifier> {
        self.resource_identifier.as_ref()
    }
    /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
    pub fn expiration_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_date.as_ref()
    }
    /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
    pub fn suppress_indefinitely(&self) -> std::option::Option<bool> {
        self.suppress_indefinitely
    }
    /// <p> The description of the audit suppression. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for DescribeAuditSuppressionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAuditSuppressionOutput");
        formatter.field("check_name", &self.check_name);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("suppress_indefinitely", &self.suppress_indefinitely);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`DescribeAuditSuppressionOutput`](crate::output::DescribeAuditSuppressionOutput)
pub mod describe_audit_suppression_output {
    /// A builder for [`DescribeAuditSuppressionOutput`](crate::output::DescribeAuditSuppressionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) suppress_indefinitely: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_name = Some(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_name = input;
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn suppress_indefinitely(mut self, input: bool) -> Self {
            self.suppress_indefinitely = Some(input);
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn set_suppress_indefinitely(mut self, input: std::option::Option<bool>) -> Self {
            self.suppress_indefinitely = input;
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditSuppressionOutput`](crate::output::DescribeAuditSuppressionOutput)
        pub fn build(self) -> crate::output::DescribeAuditSuppressionOutput {
            crate::output::DescribeAuditSuppressionOutput {
                check_name: self.check_name,
                resource_identifier: self.resource_identifier,
                expiration_date: self.expiration_date,
                suppress_indefinitely: self.suppress_indefinitely,
                description: self.description,
            }
        }
    }
}
impl DescribeAuditSuppressionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAuditSuppressionOutput`](crate::output::DescribeAuditSuppressionOutput)
    pub fn builder() -> crate::output::describe_audit_suppression_output::Builder {
        crate::output::describe_audit_suppression_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAuditMitigationActionsTaskOutput {
    /// <p>The current status of the task.</p>
    pub task_status: std::option::Option<crate::model::AuditMitigationActionsTaskStatus>,
    /// <p>The date and time when the task was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the task was completed or canceled.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation actions task.</p>
    pub task_statistics: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::TaskStatisticsForAuditCheck>,
    >,
    /// <p>Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task, or a set of findings.</p>
    pub target: std::option::Option<crate::model::AuditMitigationActionsTaskTarget>,
    /// <p>Specifies the mitigation actions that should be applied to specific audit checks.</p>
    pub audit_check_to_actions_mapping: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>Specifies the mitigation actions and their parameters that are applied as part of this task.</p>
    pub actions_definition: std::option::Option<std::vec::Vec<crate::model::MitigationAction>>,
}
impl DescribeAuditMitigationActionsTaskOutput {
    /// <p>The current status of the task.</p>
    pub fn task_status(
        &self,
    ) -> std::option::Option<&crate::model::AuditMitigationActionsTaskStatus> {
        self.task_status.as_ref()
    }
    /// <p>The date and time when the task was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time when the task was completed or canceled.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation actions task.</p>
    pub fn task_statistics(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::TaskStatisticsForAuditCheck>,
    > {
        self.task_statistics.as_ref()
    }
    /// <p>Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task, or a set of findings.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::AuditMitigationActionsTaskTarget> {
        self.target.as_ref()
    }
    /// <p>Specifies the mitigation actions that should be applied to specific audit checks.</p>
    pub fn audit_check_to_actions_mapping(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.audit_check_to_actions_mapping.as_ref()
    }
    /// <p>Specifies the mitigation actions and their parameters that are applied as part of this task.</p>
    pub fn actions_definition(&self) -> std::option::Option<&[crate::model::MitigationAction]> {
        self.actions_definition.as_deref()
    }
}
impl std::fmt::Debug for DescribeAuditMitigationActionsTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAuditMitigationActionsTaskOutput");
        formatter.field("task_status", &self.task_status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("task_statistics", &self.task_statistics);
        formatter.field("target", &self.target);
        formatter.field(
            "audit_check_to_actions_mapping",
            &self.audit_check_to_actions_mapping,
        );
        formatter.field("actions_definition", &self.actions_definition);
        formatter.finish()
    }
}
/// See [`DescribeAuditMitigationActionsTaskOutput`](crate::output::DescribeAuditMitigationActionsTaskOutput)
pub mod describe_audit_mitigation_actions_task_output {
    /// A builder for [`DescribeAuditMitigationActionsTaskOutput`](crate::output::DescribeAuditMitigationActionsTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_status: std::option::Option<crate::model::AuditMitigationActionsTaskStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) task_statistics: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::TaskStatisticsForAuditCheck,
            >,
        >,
        pub(crate) target: std::option::Option<crate::model::AuditMitigationActionsTaskTarget>,
        pub(crate) audit_check_to_actions_mapping: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) actions_definition:
            std::option::Option<std::vec::Vec<crate::model::MitigationAction>>,
    }
    impl Builder {
        /// <p>The current status of the task.</p>
        pub fn task_status(
            mut self,
            input: crate::model::AuditMitigationActionsTaskStatus,
        ) -> Self {
            self.task_status = Some(input);
            self
        }
        /// <p>The current status of the task.</p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::AuditMitigationActionsTaskStatus>,
        ) -> Self {
            self.task_status = input;
            self
        }
        /// <p>The date and time when the task was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time when the task was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time when the task was completed or canceled.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time when the task was completed or canceled.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Adds a key-value pair to `task_statistics`.
        ///
        /// To override the contents of this collection use [`set_task_statistics`](Self::set_task_statistics).
        ///
        /// <p>Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation actions task.</p>
        pub fn task_statistics(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::TaskStatisticsForAuditCheck,
        ) -> Self {
            let mut hash_map = self.task_statistics.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.task_statistics = Some(hash_map);
            self
        }
        /// <p>Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation actions task.</p>
        pub fn set_task_statistics(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TaskStatisticsForAuditCheck,
                >,
            >,
        ) -> Self {
            self.task_statistics = input;
            self
        }
        /// <p>Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task, or a set of findings.</p>
        pub fn target(mut self, input: crate::model::AuditMitigationActionsTaskTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task, or a set of findings.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::AuditMitigationActionsTaskTarget>,
        ) -> Self {
            self.target = input;
            self
        }
        /// Adds a key-value pair to `audit_check_to_actions_mapping`.
        ///
        /// To override the contents of this collection use [`set_audit_check_to_actions_mapping`](Self::set_audit_check_to_actions_mapping).
        ///
        /// <p>Specifies the mitigation actions that should be applied to specific audit checks.</p>
        pub fn audit_check_to_actions_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.audit_check_to_actions_mapping.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.audit_check_to_actions_mapping = Some(hash_map);
            self
        }
        /// <p>Specifies the mitigation actions that should be applied to specific audit checks.</p>
        pub fn set_audit_check_to_actions_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.audit_check_to_actions_mapping = input;
            self
        }
        /// Appends an item to `actions_definition`.
        ///
        /// To override the contents of this collection use [`set_actions_definition`](Self::set_actions_definition).
        ///
        /// <p>Specifies the mitigation actions and their parameters that are applied as part of this task.</p>
        pub fn actions_definition(mut self, input: crate::model::MitigationAction) -> Self {
            let mut v = self.actions_definition.unwrap_or_default();
            v.push(input);
            self.actions_definition = Some(v);
            self
        }
        /// <p>Specifies the mitigation actions and their parameters that are applied as part of this task.</p>
        pub fn set_actions_definition(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MitigationAction>>,
        ) -> Self {
            self.actions_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditMitigationActionsTaskOutput`](crate::output::DescribeAuditMitigationActionsTaskOutput)
        pub fn build(self) -> crate::output::DescribeAuditMitigationActionsTaskOutput {
            crate::output::DescribeAuditMitigationActionsTaskOutput {
                task_status: self.task_status,
                start_time: self.start_time,
                end_time: self.end_time,
                task_statistics: self.task_statistics,
                target: self.target,
                audit_check_to_actions_mapping: self.audit_check_to_actions_mapping,
                actions_definition: self.actions_definition,
            }
        }
    }
}
impl DescribeAuditMitigationActionsTaskOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAuditMitigationActionsTaskOutput`](crate::output::DescribeAuditMitigationActionsTaskOutput)
    pub fn builder() -> crate::output::describe_audit_mitigation_actions_task_output::Builder {
        crate::output::describe_audit_mitigation_actions_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAuditFindingOutput {
    /// <p>The findings (results) of the audit.</p>
    pub finding: std::option::Option<crate::model::AuditFinding>,
}
impl DescribeAuditFindingOutput {
    /// <p>The findings (results) of the audit.</p>
    pub fn finding(&self) -> std::option::Option<&crate::model::AuditFinding> {
        self.finding.as_ref()
    }
}
impl std::fmt::Debug for DescribeAuditFindingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAuditFindingOutput");
        formatter.field("finding", &self.finding);
        formatter.finish()
    }
}
/// See [`DescribeAuditFindingOutput`](crate::output::DescribeAuditFindingOutput)
pub mod describe_audit_finding_output {
    /// A builder for [`DescribeAuditFindingOutput`](crate::output::DescribeAuditFindingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding: std::option::Option<crate::model::AuditFinding>,
    }
    impl Builder {
        /// <p>The findings (results) of the audit.</p>
        pub fn finding(mut self, input: crate::model::AuditFinding) -> Self {
            self.finding = Some(input);
            self
        }
        /// <p>The findings (results) of the audit.</p>
        pub fn set_finding(
            mut self,
            input: std::option::Option<crate::model::AuditFinding>,
        ) -> Self {
            self.finding = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditFindingOutput`](crate::output::DescribeAuditFindingOutput)
        pub fn build(self) -> crate::output::DescribeAuditFindingOutput {
            crate::output::DescribeAuditFindingOutput {
                finding: self.finding,
            }
        }
    }
}
impl DescribeAuditFindingOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAuditFindingOutput`](crate::output::DescribeAuditFindingOutput)
    pub fn builder() -> crate::output::describe_audit_finding_output::Builder {
        crate::output::describe_audit_finding_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAuditConfigurationOutput {
    /// <p>The ARN of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p>
    /// <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Information about the targets to which audit notifications are sent for this account.</p>
    pub audit_notification_target_configurations: std::option::Option<
        std::collections::HashMap<
            crate::model::AuditNotificationType,
            crate::model::AuditNotificationTarget,
        >,
    >,
    /// <p>Which audit checks are enabled and disabled for this account.</p>
    pub audit_check_configurations: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AuditCheckConfiguration>,
    >,
}
impl DescribeAccountAuditConfigurationOutput {
    /// <p>The ARN of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p>
    /// <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Information about the targets to which audit notifications are sent for this account.</p>
    pub fn audit_notification_target_configurations(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::AuditNotificationType,
            crate::model::AuditNotificationTarget,
        >,
    > {
        self.audit_notification_target_configurations.as_ref()
    }
    /// <p>Which audit checks are enabled and disabled for this account.</p>
    pub fn audit_check_configurations(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AuditCheckConfiguration>,
    > {
        self.audit_check_configurations.as_ref()
    }
}
impl std::fmt::Debug for DescribeAccountAuditConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAuditConfigurationOutput");
        formatter.field("role_arn", &self.role_arn);
        formatter.field(
            "audit_notification_target_configurations",
            &self.audit_notification_target_configurations,
        );
        formatter.field(
            "audit_check_configurations",
            &self.audit_check_configurations,
        );
        formatter.finish()
    }
}
/// See [`DescribeAccountAuditConfigurationOutput`](crate::output::DescribeAccountAuditConfigurationOutput)
pub mod describe_account_audit_configuration_output {
    /// A builder for [`DescribeAccountAuditConfigurationOutput`](crate::output::DescribeAccountAuditConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) audit_notification_target_configurations: std::option::Option<
            std::collections::HashMap<
                crate::model::AuditNotificationType,
                crate::model::AuditNotificationTarget,
            >,
        >,
        pub(crate) audit_check_configurations: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AuditCheckConfiguration>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p>
        /// <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p>
        /// <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `audit_notification_target_configurations`.
        ///
        /// To override the contents of this collection use [`set_audit_notification_target_configurations`](Self::set_audit_notification_target_configurations).
        ///
        /// <p>Information about the targets to which audit notifications are sent for this account.</p>
        pub fn audit_notification_target_configurations(
            mut self,
            k: crate::model::AuditNotificationType,
            v: crate::model::AuditNotificationTarget,
        ) -> Self {
            let mut hash_map = self
                .audit_notification_target_configurations
                .unwrap_or_default();
            hash_map.insert(k, v);
            self.audit_notification_target_configurations = Some(hash_map);
            self
        }
        /// <p>Information about the targets to which audit notifications are sent for this account.</p>
        pub fn set_audit_notification_target_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::AuditNotificationType,
                    crate::model::AuditNotificationTarget,
                >,
            >,
        ) -> Self {
            self.audit_notification_target_configurations = input;
            self
        }
        /// Adds a key-value pair to `audit_check_configurations`.
        ///
        /// To override the contents of this collection use [`set_audit_check_configurations`](Self::set_audit_check_configurations).
        ///
        /// <p>Which audit checks are enabled and disabled for this account.</p>
        pub fn audit_check_configurations(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AuditCheckConfiguration,
        ) -> Self {
            let mut hash_map = self.audit_check_configurations.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.audit_check_configurations = Some(hash_map);
            self
        }
        /// <p>Which audit checks are enabled and disabled for this account.</p>
        pub fn set_audit_check_configurations(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::AuditCheckConfiguration,
                >,
            >,
        ) -> Self {
            self.audit_check_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAuditConfigurationOutput`](crate::output::DescribeAccountAuditConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeAccountAuditConfigurationOutput {
            crate::output::DescribeAccountAuditConfigurationOutput {
                role_arn: self.role_arn,
                audit_notification_target_configurations: self
                    .audit_notification_target_configurations,
                audit_check_configurations: self.audit_check_configurations,
            }
        }
    }
}
impl DescribeAccountAuditConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAuditConfigurationOutput`](crate::output::DescribeAccountAuditConfigurationOutput)
    pub fn builder() -> crate::output::describe_account_audit_configuration_output::Builder {
        crate::output::describe_account_audit_configuration_output::Builder::default()
    }
}

/// <p>The output for the DeprecateThingType operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprecateThingTypeOutput {}
impl std::fmt::Debug for DeprecateThingTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprecateThingTypeOutput");
        formatter.finish()
    }
}
/// See [`DeprecateThingTypeOutput`](crate::output::DeprecateThingTypeOutput)
pub mod deprecate_thing_type_output {
    /// A builder for [`DeprecateThingTypeOutput`](crate::output::DeprecateThingTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeprecateThingTypeOutput`](crate::output::DeprecateThingTypeOutput)
        pub fn build(self) -> crate::output::DeprecateThingTypeOutput {
            crate::output::DeprecateThingTypeOutput {}
        }
    }
}
impl DeprecateThingTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeprecateThingTypeOutput`](crate::output::DeprecateThingTypeOutput)
    pub fn builder() -> crate::output::deprecate_thing_type_output::Builder {
        crate::output::deprecate_thing_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteV2LoggingLevelOutput {}
impl std::fmt::Debug for DeleteV2LoggingLevelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteV2LoggingLevelOutput");
        formatter.finish()
    }
}
/// See [`DeleteV2LoggingLevelOutput`](crate::output::DeleteV2LoggingLevelOutput)
pub mod delete_v2_logging_level_output {
    /// A builder for [`DeleteV2LoggingLevelOutput`](crate::output::DeleteV2LoggingLevelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteV2LoggingLevelOutput`](crate::output::DeleteV2LoggingLevelOutput)
        pub fn build(self) -> crate::output::DeleteV2LoggingLevelOutput {
            crate::output::DeleteV2LoggingLevelOutput {}
        }
    }
}
impl DeleteV2LoggingLevelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteV2LoggingLevelOutput`](crate::output::DeleteV2LoggingLevelOutput)
    pub fn builder() -> crate::output::delete_v2_logging_level_output::Builder {
        crate::output::delete_v2_logging_level_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTopicRuleDestinationOutput {}
impl std::fmt::Debug for DeleteTopicRuleDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTopicRuleDestinationOutput");
        formatter.finish()
    }
}
/// See [`DeleteTopicRuleDestinationOutput`](crate::output::DeleteTopicRuleDestinationOutput)
pub mod delete_topic_rule_destination_output {
    /// A builder for [`DeleteTopicRuleDestinationOutput`](crate::output::DeleteTopicRuleDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTopicRuleDestinationOutput`](crate::output::DeleteTopicRuleDestinationOutput)
        pub fn build(self) -> crate::output::DeleteTopicRuleDestinationOutput {
            crate::output::DeleteTopicRuleDestinationOutput {}
        }
    }
}
impl DeleteTopicRuleDestinationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTopicRuleDestinationOutput`](crate::output::DeleteTopicRuleDestinationOutput)
    pub fn builder() -> crate::output::delete_topic_rule_destination_output::Builder {
        crate::output::delete_topic_rule_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTopicRuleOutput {}
impl std::fmt::Debug for DeleteTopicRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTopicRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteTopicRuleOutput`](crate::output::DeleteTopicRuleOutput)
pub mod delete_topic_rule_output {
    /// A builder for [`DeleteTopicRuleOutput`](crate::output::DeleteTopicRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTopicRuleOutput`](crate::output::DeleteTopicRuleOutput)
        pub fn build(self) -> crate::output::DeleteTopicRuleOutput {
            crate::output::DeleteTopicRuleOutput {}
        }
    }
}
impl DeleteTopicRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTopicRuleOutput`](crate::output::DeleteTopicRuleOutput)
    pub fn builder() -> crate::output::delete_topic_rule_output::Builder {
        crate::output::delete_topic_rule_output::Builder::default()
    }
}

/// <p>The output for the DeleteThingType operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThingTypeOutput {}
impl std::fmt::Debug for DeleteThingTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThingTypeOutput");
        formatter.finish()
    }
}
/// See [`DeleteThingTypeOutput`](crate::output::DeleteThingTypeOutput)
pub mod delete_thing_type_output {
    /// A builder for [`DeleteThingTypeOutput`](crate::output::DeleteThingTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteThingTypeOutput`](crate::output::DeleteThingTypeOutput)
        pub fn build(self) -> crate::output::DeleteThingTypeOutput {
            crate::output::DeleteThingTypeOutput {}
        }
    }
}
impl DeleteThingTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteThingTypeOutput`](crate::output::DeleteThingTypeOutput)
    pub fn builder() -> crate::output::delete_thing_type_output::Builder {
        crate::output::delete_thing_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThingGroupOutput {}
impl std::fmt::Debug for DeleteThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThingGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteThingGroupOutput`](crate::output::DeleteThingGroupOutput)
pub mod delete_thing_group_output {
    /// A builder for [`DeleteThingGroupOutput`](crate::output::DeleteThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteThingGroupOutput`](crate::output::DeleteThingGroupOutput)
        pub fn build(self) -> crate::output::DeleteThingGroupOutput {
            crate::output::DeleteThingGroupOutput {}
        }
    }
}
impl DeleteThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteThingGroupOutput`](crate::output::DeleteThingGroupOutput)
    pub fn builder() -> crate::output::delete_thing_group_output::Builder {
        crate::output::delete_thing_group_output::Builder::default()
    }
}

/// <p>The output of the DeleteThing operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThingOutput {}
impl std::fmt::Debug for DeleteThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThingOutput");
        formatter.finish()
    }
}
/// See [`DeleteThingOutput`](crate::output::DeleteThingOutput)
pub mod delete_thing_output {
    /// A builder for [`DeleteThingOutput`](crate::output::DeleteThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteThingOutput`](crate::output::DeleteThingOutput)
        pub fn build(self) -> crate::output::DeleteThingOutput {
            crate::output::DeleteThingOutput {}
        }
    }
}
impl DeleteThingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteThingOutput`](crate::output::DeleteThingOutput)
    pub fn builder() -> crate::output::delete_thing_output::Builder {
        crate::output::delete_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStreamOutput {}
impl std::fmt::Debug for DeleteStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStreamOutput");
        formatter.finish()
    }
}
/// See [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
pub mod delete_stream_output {
    /// A builder for [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
        pub fn build(self) -> crate::output::DeleteStreamOutput {
            crate::output::DeleteStreamOutput {}
        }
    }
}
impl DeleteStreamOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)
    pub fn builder() -> crate::output::delete_stream_output::Builder {
        crate::output::delete_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSecurityProfileOutput {}
impl std::fmt::Debug for DeleteSecurityProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSecurityProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteSecurityProfileOutput`](crate::output::DeleteSecurityProfileOutput)
pub mod delete_security_profile_output {
    /// A builder for [`DeleteSecurityProfileOutput`](crate::output::DeleteSecurityProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSecurityProfileOutput`](crate::output::DeleteSecurityProfileOutput)
        pub fn build(self) -> crate::output::DeleteSecurityProfileOutput {
            crate::output::DeleteSecurityProfileOutput {}
        }
    }
}
impl DeleteSecurityProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSecurityProfileOutput`](crate::output::DeleteSecurityProfileOutput)
    pub fn builder() -> crate::output::delete_security_profile_output::Builder {
        crate::output::delete_security_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScheduledAuditOutput {}
impl std::fmt::Debug for DeleteScheduledAuditOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScheduledAuditOutput");
        formatter.finish()
    }
}
/// See [`DeleteScheduledAuditOutput`](crate::output::DeleteScheduledAuditOutput)
pub mod delete_scheduled_audit_output {
    /// A builder for [`DeleteScheduledAuditOutput`](crate::output::DeleteScheduledAuditOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteScheduledAuditOutput`](crate::output::DeleteScheduledAuditOutput)
        pub fn build(self) -> crate::output::DeleteScheduledAuditOutput {
            crate::output::DeleteScheduledAuditOutput {}
        }
    }
}
impl DeleteScheduledAuditOutput {
    /// Creates a new builder-style object to manufacture [`DeleteScheduledAuditOutput`](crate::output::DeleteScheduledAuditOutput)
    pub fn builder() -> crate::output::delete_scheduled_audit_output::Builder {
        crate::output::delete_scheduled_audit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoleAliasOutput {}
impl std::fmt::Debug for DeleteRoleAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoleAliasOutput");
        formatter.finish()
    }
}
/// See [`DeleteRoleAliasOutput`](crate::output::DeleteRoleAliasOutput)
pub mod delete_role_alias_output {
    /// A builder for [`DeleteRoleAliasOutput`](crate::output::DeleteRoleAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRoleAliasOutput`](crate::output::DeleteRoleAliasOutput)
        pub fn build(self) -> crate::output::DeleteRoleAliasOutput {
            crate::output::DeleteRoleAliasOutput {}
        }
    }
}
impl DeleteRoleAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRoleAliasOutput`](crate::output::DeleteRoleAliasOutput)
    pub fn builder() -> crate::output::delete_role_alias_output::Builder {
        crate::output::delete_role_alias_output::Builder::default()
    }
}

/// <p>The output for the DeleteRegistrationCode operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegistrationCodeOutput {}
impl std::fmt::Debug for DeleteRegistrationCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegistrationCodeOutput");
        formatter.finish()
    }
}
/// See [`DeleteRegistrationCodeOutput`](crate::output::DeleteRegistrationCodeOutput)
pub mod delete_registration_code_output {
    /// A builder for [`DeleteRegistrationCodeOutput`](crate::output::DeleteRegistrationCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRegistrationCodeOutput`](crate::output::DeleteRegistrationCodeOutput)
        pub fn build(self) -> crate::output::DeleteRegistrationCodeOutput {
            crate::output::DeleteRegistrationCodeOutput {}
        }
    }
}
impl DeleteRegistrationCodeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRegistrationCodeOutput`](crate::output::DeleteRegistrationCodeOutput)
    pub fn builder() -> crate::output::delete_registration_code_output::Builder {
        crate::output::delete_registration_code_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProvisioningTemplateVersionOutput {}
impl std::fmt::Debug for DeleteProvisioningTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProvisioningTemplateVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteProvisioningTemplateVersionOutput`](crate::output::DeleteProvisioningTemplateVersionOutput)
pub mod delete_provisioning_template_version_output {
    /// A builder for [`DeleteProvisioningTemplateVersionOutput`](crate::output::DeleteProvisioningTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProvisioningTemplateVersionOutput`](crate::output::DeleteProvisioningTemplateVersionOutput)
        pub fn build(self) -> crate::output::DeleteProvisioningTemplateVersionOutput {
            crate::output::DeleteProvisioningTemplateVersionOutput {}
        }
    }
}
impl DeleteProvisioningTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningTemplateVersionOutput`](crate::output::DeleteProvisioningTemplateVersionOutput)
    pub fn builder() -> crate::output::delete_provisioning_template_version_output::Builder {
        crate::output::delete_provisioning_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProvisioningTemplateOutput {}
impl std::fmt::Debug for DeleteProvisioningTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProvisioningTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteProvisioningTemplateOutput`](crate::output::DeleteProvisioningTemplateOutput)
pub mod delete_provisioning_template_output {
    /// A builder for [`DeleteProvisioningTemplateOutput`](crate::output::DeleteProvisioningTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProvisioningTemplateOutput`](crate::output::DeleteProvisioningTemplateOutput)
        pub fn build(self) -> crate::output::DeleteProvisioningTemplateOutput {
            crate::output::DeleteProvisioningTemplateOutput {}
        }
    }
}
impl DeleteProvisioningTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningTemplateOutput`](crate::output::DeleteProvisioningTemplateOutput)
    pub fn builder() -> crate::output::delete_provisioning_template_output::Builder {
        crate::output::delete_provisioning_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyVersionOutput {}
impl std::fmt::Debug for DeletePolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyVersionOutput");
        formatter.finish()
    }
}
/// See [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
pub mod delete_policy_version_output {
    /// A builder for [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
        pub fn build(self) -> crate::output::DeletePolicyVersionOutput {
            crate::output::DeletePolicyVersionOutput {}
        }
    }
}
impl DeletePolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
    pub fn builder() -> crate::output::delete_policy_version_output::Builder {
        crate::output::delete_policy_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyOutput {}
impl std::fmt::Debug for DeletePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
pub mod delete_policy_output {
    /// A builder for [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
        pub fn build(self) -> crate::output::DeletePolicyOutput {
            crate::output::DeletePolicyOutput {}
        }
    }
}
impl DeletePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    pub fn builder() -> crate::output::delete_policy_output::Builder {
        crate::output::delete_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOtaUpdateOutput {}
impl std::fmt::Debug for DeleteOtaUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOtaUpdateOutput");
        formatter.finish()
    }
}
/// See [`DeleteOtaUpdateOutput`](crate::output::DeleteOtaUpdateOutput)
pub mod delete_ota_update_output {
    /// A builder for [`DeleteOtaUpdateOutput`](crate::output::DeleteOtaUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOtaUpdateOutput`](crate::output::DeleteOtaUpdateOutput)
        pub fn build(self) -> crate::output::DeleteOtaUpdateOutput {
            crate::output::DeleteOtaUpdateOutput {}
        }
    }
}
impl DeleteOtaUpdateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOtaUpdateOutput`](crate::output::DeleteOtaUpdateOutput)
    pub fn builder() -> crate::output::delete_ota_update_output::Builder {
        crate::output::delete_ota_update_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMitigationActionOutput {}
impl std::fmt::Debug for DeleteMitigationActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMitigationActionOutput");
        formatter.finish()
    }
}
/// See [`DeleteMitigationActionOutput`](crate::output::DeleteMitigationActionOutput)
pub mod delete_mitigation_action_output {
    /// A builder for [`DeleteMitigationActionOutput`](crate::output::DeleteMitigationActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteMitigationActionOutput`](crate::output::DeleteMitigationActionOutput)
        pub fn build(self) -> crate::output::DeleteMitigationActionOutput {
            crate::output::DeleteMitigationActionOutput {}
        }
    }
}
impl DeleteMitigationActionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMitigationActionOutput`](crate::output::DeleteMitigationActionOutput)
    pub fn builder() -> crate::output::delete_mitigation_action_output::Builder {
        crate::output::delete_mitigation_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobTemplateOutput {}
impl std::fmt::Debug for DeleteJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
pub mod delete_job_template_output {
    /// A builder for [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
        pub fn build(self) -> crate::output::DeleteJobTemplateOutput {
            crate::output::DeleteJobTemplateOutput {}
        }
    }
}
impl DeleteJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
    pub fn builder() -> crate::output::delete_job_template_output::Builder {
        crate::output::delete_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobExecutionOutput {}
impl std::fmt::Debug for DeleteJobExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobExecutionOutput");
        formatter.finish()
    }
}
/// See [`DeleteJobExecutionOutput`](crate::output::DeleteJobExecutionOutput)
pub mod delete_job_execution_output {
    /// A builder for [`DeleteJobExecutionOutput`](crate::output::DeleteJobExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteJobExecutionOutput`](crate::output::DeleteJobExecutionOutput)
        pub fn build(self) -> crate::output::DeleteJobExecutionOutput {
            crate::output::DeleteJobExecutionOutput {}
        }
    }
}
impl DeleteJobExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobExecutionOutput`](crate::output::DeleteJobExecutionOutput)
    pub fn builder() -> crate::output::delete_job_execution_output::Builder {
        crate::output::delete_job_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobOutput {}
impl std::fmt::Debug for DeleteJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobOutput");
        formatter.finish()
    }
}
/// See [`DeleteJobOutput`](crate::output::DeleteJobOutput)
pub mod delete_job_output {
    /// A builder for [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteJobOutput`](crate::output::DeleteJobOutput)
        pub fn build(self) -> crate::output::DeleteJobOutput {
            crate::output::DeleteJobOutput {}
        }
    }
}
impl DeleteJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    pub fn builder() -> crate::output::delete_job_output::Builder {
        crate::output::delete_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFleetMetricOutput {}
impl std::fmt::Debug for DeleteFleetMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFleetMetricOutput");
        formatter.finish()
    }
}
/// See [`DeleteFleetMetricOutput`](crate::output::DeleteFleetMetricOutput)
pub mod delete_fleet_metric_output {
    /// A builder for [`DeleteFleetMetricOutput`](crate::output::DeleteFleetMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFleetMetricOutput`](crate::output::DeleteFleetMetricOutput)
        pub fn build(self) -> crate::output::DeleteFleetMetricOutput {
            crate::output::DeleteFleetMetricOutput {}
        }
    }
}
impl DeleteFleetMetricOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFleetMetricOutput`](crate::output::DeleteFleetMetricOutput)
    pub fn builder() -> crate::output::delete_fleet_metric_output::Builder {
        crate::output::delete_fleet_metric_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDynamicThingGroupOutput {}
impl std::fmt::Debug for DeleteDynamicThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDynamicThingGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDynamicThingGroupOutput`](crate::output::DeleteDynamicThingGroupOutput)
pub mod delete_dynamic_thing_group_output {
    /// A builder for [`DeleteDynamicThingGroupOutput`](crate::output::DeleteDynamicThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDynamicThingGroupOutput`](crate::output::DeleteDynamicThingGroupOutput)
        pub fn build(self) -> crate::output::DeleteDynamicThingGroupOutput {
            crate::output::DeleteDynamicThingGroupOutput {}
        }
    }
}
impl DeleteDynamicThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDynamicThingGroupOutput`](crate::output::DeleteDynamicThingGroupOutput)
    pub fn builder() -> crate::output::delete_dynamic_thing_group_output::Builder {
        crate::output::delete_dynamic_thing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainConfigurationOutput {}
impl std::fmt::Debug for DeleteDomainConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteDomainConfigurationOutput`](crate::output::DeleteDomainConfigurationOutput)
pub mod delete_domain_configuration_output {
    /// A builder for [`DeleteDomainConfigurationOutput`](crate::output::DeleteDomainConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDomainConfigurationOutput`](crate::output::DeleteDomainConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteDomainConfigurationOutput {
            crate::output::DeleteDomainConfigurationOutput {}
        }
    }
}
impl DeleteDomainConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainConfigurationOutput`](crate::output::DeleteDomainConfigurationOutput)
    pub fn builder() -> crate::output::delete_domain_configuration_output::Builder {
        crate::output::delete_domain_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDimensionOutput {}
impl std::fmt::Debug for DeleteDimensionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDimensionOutput");
        formatter.finish()
    }
}
/// See [`DeleteDimensionOutput`](crate::output::DeleteDimensionOutput)
pub mod delete_dimension_output {
    /// A builder for [`DeleteDimensionOutput`](crate::output::DeleteDimensionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDimensionOutput`](crate::output::DeleteDimensionOutput)
        pub fn build(self) -> crate::output::DeleteDimensionOutput {
            crate::output::DeleteDimensionOutput {}
        }
    }
}
impl DeleteDimensionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDimensionOutput`](crate::output::DeleteDimensionOutput)
    pub fn builder() -> crate::output::delete_dimension_output::Builder {
        crate::output::delete_dimension_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomMetricOutput {}
impl std::fmt::Debug for DeleteCustomMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomMetricOutput");
        formatter.finish()
    }
}
/// See [`DeleteCustomMetricOutput`](crate::output::DeleteCustomMetricOutput)
pub mod delete_custom_metric_output {
    /// A builder for [`DeleteCustomMetricOutput`](crate::output::DeleteCustomMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCustomMetricOutput`](crate::output::DeleteCustomMetricOutput)
        pub fn build(self) -> crate::output::DeleteCustomMetricOutput {
            crate::output::DeleteCustomMetricOutput {}
        }
    }
}
impl DeleteCustomMetricOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomMetricOutput`](crate::output::DeleteCustomMetricOutput)
    pub fn builder() -> crate::output::delete_custom_metric_output::Builder {
        crate::output::delete_custom_metric_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCertificateOutput {}
impl std::fmt::Debug for DeleteCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCertificateOutput");
        formatter.finish()
    }
}
/// See [`DeleteCertificateOutput`](crate::output::DeleteCertificateOutput)
pub mod delete_certificate_output {
    /// A builder for [`DeleteCertificateOutput`](crate::output::DeleteCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCertificateOutput`](crate::output::DeleteCertificateOutput)
        pub fn build(self) -> crate::output::DeleteCertificateOutput {
            crate::output::DeleteCertificateOutput {}
        }
    }
}
impl DeleteCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCertificateOutput`](crate::output::DeleteCertificateOutput)
    pub fn builder() -> crate::output::delete_certificate_output::Builder {
        crate::output::delete_certificate_output::Builder::default()
    }
}

/// <p>The output for the DeleteCACertificate operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCaCertificateOutput {}
impl std::fmt::Debug for DeleteCaCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCaCertificateOutput");
        formatter.finish()
    }
}
/// See [`DeleteCaCertificateOutput`](crate::output::DeleteCaCertificateOutput)
pub mod delete_ca_certificate_output {
    /// A builder for [`DeleteCaCertificateOutput`](crate::output::DeleteCaCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCaCertificateOutput`](crate::output::DeleteCaCertificateOutput)
        pub fn build(self) -> crate::output::DeleteCaCertificateOutput {
            crate::output::DeleteCaCertificateOutput {}
        }
    }
}
impl DeleteCaCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCaCertificateOutput`](crate::output::DeleteCaCertificateOutput)
    pub fn builder() -> crate::output::delete_ca_certificate_output::Builder {
        crate::output::delete_ca_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBillingGroupOutput {}
impl std::fmt::Debug for DeleteBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBillingGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
pub mod delete_billing_group_output {
    /// A builder for [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
        pub fn build(self) -> crate::output::DeleteBillingGroupOutput {
            crate::output::DeleteBillingGroupOutput {}
        }
    }
}
impl DeleteBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)
    pub fn builder() -> crate::output::delete_billing_group_output::Builder {
        crate::output::delete_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAuthorizerOutput {}
impl std::fmt::Debug for DeleteAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAuthorizerOutput");
        formatter.finish()
    }
}
/// See [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
pub mod delete_authorizer_output {
    /// A builder for [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
        pub fn build(self) -> crate::output::DeleteAuthorizerOutput {
            crate::output::DeleteAuthorizerOutput {}
        }
    }
}
impl DeleteAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)
    pub fn builder() -> crate::output::delete_authorizer_output::Builder {
        crate::output::delete_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAuditSuppressionOutput {}
impl std::fmt::Debug for DeleteAuditSuppressionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAuditSuppressionOutput");
        formatter.finish()
    }
}
/// See [`DeleteAuditSuppressionOutput`](crate::output::DeleteAuditSuppressionOutput)
pub mod delete_audit_suppression_output {
    /// A builder for [`DeleteAuditSuppressionOutput`](crate::output::DeleteAuditSuppressionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAuditSuppressionOutput`](crate::output::DeleteAuditSuppressionOutput)
        pub fn build(self) -> crate::output::DeleteAuditSuppressionOutput {
            crate::output::DeleteAuditSuppressionOutput {}
        }
    }
}
impl DeleteAuditSuppressionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAuditSuppressionOutput`](crate::output::DeleteAuditSuppressionOutput)
    pub fn builder() -> crate::output::delete_audit_suppression_output::Builder {
        crate::output::delete_audit_suppression_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccountAuditConfigurationOutput {}
impl std::fmt::Debug for DeleteAccountAuditConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccountAuditConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccountAuditConfigurationOutput`](crate::output::DeleteAccountAuditConfigurationOutput)
pub mod delete_account_audit_configuration_output {
    /// A builder for [`DeleteAccountAuditConfigurationOutput`](crate::output::DeleteAccountAuditConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccountAuditConfigurationOutput`](crate::output::DeleteAccountAuditConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteAccountAuditConfigurationOutput {
            crate::output::DeleteAccountAuditConfigurationOutput {}
        }
    }
}
impl DeleteAccountAuditConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccountAuditConfigurationOutput`](crate::output::DeleteAccountAuditConfigurationOutput)
    pub fn builder() -> crate::output::delete_account_audit_configuration_output::Builder {
        crate::output::delete_account_audit_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTopicRuleDestinationOutput {
    /// <p>The topic rule destination.</p>
    pub topic_rule_destination: std::option::Option<crate::model::TopicRuleDestination>,
}
impl CreateTopicRuleDestinationOutput {
    /// <p>The topic rule destination.</p>
    pub fn topic_rule_destination(
        &self,
    ) -> std::option::Option<&crate::model::TopicRuleDestination> {
        self.topic_rule_destination.as_ref()
    }
}
impl std::fmt::Debug for CreateTopicRuleDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTopicRuleDestinationOutput");
        formatter.field("topic_rule_destination", &self.topic_rule_destination);
        formatter.finish()
    }
}
/// See [`CreateTopicRuleDestinationOutput`](crate::output::CreateTopicRuleDestinationOutput)
pub mod create_topic_rule_destination_output {
    /// A builder for [`CreateTopicRuleDestinationOutput`](crate::output::CreateTopicRuleDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_rule_destination: std::option::Option<crate::model::TopicRuleDestination>,
    }
    impl Builder {
        /// <p>The topic rule destination.</p>
        pub fn topic_rule_destination(mut self, input: crate::model::TopicRuleDestination) -> Self {
            self.topic_rule_destination = Some(input);
            self
        }
        /// <p>The topic rule destination.</p>
        pub fn set_topic_rule_destination(
            mut self,
            input: std::option::Option<crate::model::TopicRuleDestination>,
        ) -> Self {
            self.topic_rule_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTopicRuleDestinationOutput`](crate::output::CreateTopicRuleDestinationOutput)
        pub fn build(self) -> crate::output::CreateTopicRuleDestinationOutput {
            crate::output::CreateTopicRuleDestinationOutput {
                topic_rule_destination: self.topic_rule_destination,
            }
        }
    }
}
impl CreateTopicRuleDestinationOutput {
    /// Creates a new builder-style object to manufacture [`CreateTopicRuleDestinationOutput`](crate::output::CreateTopicRuleDestinationOutput)
    pub fn builder() -> crate::output::create_topic_rule_destination_output::Builder {
        crate::output::create_topic_rule_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTopicRuleOutput {}
impl std::fmt::Debug for CreateTopicRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTopicRuleOutput");
        formatter.finish()
    }
}
/// See [`CreateTopicRuleOutput`](crate::output::CreateTopicRuleOutput)
pub mod create_topic_rule_output {
    /// A builder for [`CreateTopicRuleOutput`](crate::output::CreateTopicRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTopicRuleOutput`](crate::output::CreateTopicRuleOutput)
        pub fn build(self) -> crate::output::CreateTopicRuleOutput {
            crate::output::CreateTopicRuleOutput {}
        }
    }
}
impl CreateTopicRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateTopicRuleOutput`](crate::output::CreateTopicRuleOutput)
    pub fn builder() -> crate::output::create_topic_rule_output::Builder {
        crate::output::create_topic_rule_output::Builder::default()
    }
}

/// <p>The output of the CreateThingType operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThingTypeOutput {
    /// <p>The name of the thing type.</p>
    pub thing_type_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the thing type.</p>
    pub thing_type_arn: std::option::Option<std::string::String>,
    /// <p>The thing type ID.</p>
    pub thing_type_id: std::option::Option<std::string::String>,
}
impl CreateThingTypeOutput {
    /// <p>The name of the thing type.</p>
    pub fn thing_type_name(&self) -> std::option::Option<&str> {
        self.thing_type_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the thing type.</p>
    pub fn thing_type_arn(&self) -> std::option::Option<&str> {
        self.thing_type_arn.as_deref()
    }
    /// <p>The thing type ID.</p>
    pub fn thing_type_id(&self) -> std::option::Option<&str> {
        self.thing_type_id.as_deref()
    }
}
impl std::fmt::Debug for CreateThingTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThingTypeOutput");
        formatter.field("thing_type_name", &self.thing_type_name);
        formatter.field("thing_type_arn", &self.thing_type_arn);
        formatter.field("thing_type_id", &self.thing_type_id);
        formatter.finish()
    }
}
/// See [`CreateThingTypeOutput`](crate::output::CreateThingTypeOutput)
pub mod create_thing_type_output {
    /// A builder for [`CreateThingTypeOutput`](crate::output::CreateThingTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) thing_type_arn: std::option::Option<std::string::String>,
        pub(crate) thing_type_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the thing type.</p>
        pub fn thing_type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the thing type.</p>
        pub fn set_thing_type_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_arn = input;
            self
        }
        /// <p>The thing type ID.</p>
        pub fn thing_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_id = Some(input.into());
            self
        }
        /// <p>The thing type ID.</p>
        pub fn set_thing_type_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThingTypeOutput`](crate::output::CreateThingTypeOutput)
        pub fn build(self) -> crate::output::CreateThingTypeOutput {
            crate::output::CreateThingTypeOutput {
                thing_type_name: self.thing_type_name,
                thing_type_arn: self.thing_type_arn,
                thing_type_id: self.thing_type_id,
            }
        }
    }
}
impl CreateThingTypeOutput {
    /// Creates a new builder-style object to manufacture [`CreateThingTypeOutput`](crate::output::CreateThingTypeOutput)
    pub fn builder() -> crate::output::create_thing_type_output::Builder {
        crate::output::create_thing_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThingGroupOutput {
    /// <p>The thing group name.</p>
    pub thing_group_name: std::option::Option<std::string::String>,
    /// <p>The thing group ARN.</p>
    pub thing_group_arn: std::option::Option<std::string::String>,
    /// <p>The thing group ID.</p>
    pub thing_group_id: std::option::Option<std::string::String>,
}
impl CreateThingGroupOutput {
    /// <p>The thing group name.</p>
    pub fn thing_group_name(&self) -> std::option::Option<&str> {
        self.thing_group_name.as_deref()
    }
    /// <p>The thing group ARN.</p>
    pub fn thing_group_arn(&self) -> std::option::Option<&str> {
        self.thing_group_arn.as_deref()
    }
    /// <p>The thing group ID.</p>
    pub fn thing_group_id(&self) -> std::option::Option<&str> {
        self.thing_group_id.as_deref()
    }
}
impl std::fmt::Debug for CreateThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThingGroupOutput");
        formatter.field("thing_group_name", &self.thing_group_name);
        formatter.field("thing_group_arn", &self.thing_group_arn);
        formatter.field("thing_group_id", &self.thing_group_id);
        formatter.finish()
    }
}
/// See [`CreateThingGroupOutput`](crate::output::CreateThingGroupOutput)
pub mod create_thing_group_output {
    /// A builder for [`CreateThingGroupOutput`](crate::output::CreateThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_arn: std::option::Option<std::string::String>,
        pub(crate) thing_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The thing group name.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The thing group name.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The thing group ARN.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_arn = Some(input.into());
            self
        }
        /// <p>The thing group ARN.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_arn = input;
            self
        }
        /// <p>The thing group ID.</p>
        pub fn thing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_id = Some(input.into());
            self
        }
        /// <p>The thing group ID.</p>
        pub fn set_thing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThingGroupOutput`](crate::output::CreateThingGroupOutput)
        pub fn build(self) -> crate::output::CreateThingGroupOutput {
            crate::output::CreateThingGroupOutput {
                thing_group_name: self.thing_group_name,
                thing_group_arn: self.thing_group_arn,
                thing_group_id: self.thing_group_id,
            }
        }
    }
}
impl CreateThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateThingGroupOutput`](crate::output::CreateThingGroupOutput)
    pub fn builder() -> crate::output::create_thing_group_output::Builder {
        crate::output::create_thing_group_output::Builder::default()
    }
}

/// <p>The output of the CreateThing operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThingOutput {
    /// <p>The name of the new thing.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the new thing.</p>
    pub thing_arn: std::option::Option<std::string::String>,
    /// <p>The thing ID.</p>
    pub thing_id: std::option::Option<std::string::String>,
}
impl CreateThingOutput {
    /// <p>The name of the new thing.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The ARN of the new thing.</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
    /// <p>The thing ID.</p>
    pub fn thing_id(&self) -> std::option::Option<&str> {
        self.thing_id.as_deref()
    }
}
impl std::fmt::Debug for CreateThingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThingOutput");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("thing_arn", &self.thing_arn);
        formatter.field("thing_id", &self.thing_id);
        formatter.finish()
    }
}
/// See [`CreateThingOutput`](crate::output::CreateThingOutput)
pub mod create_thing_output {
    /// A builder for [`CreateThingOutput`](crate::output::CreateThingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
        pub(crate) thing_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the new thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the new thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ARN of the new thing.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the new thing.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// <p>The thing ID.</p>
        pub fn thing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_id = Some(input.into());
            self
        }
        /// <p>The thing ID.</p>
        pub fn set_thing_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThingOutput`](crate::output::CreateThingOutput)
        pub fn build(self) -> crate::output::CreateThingOutput {
            crate::output::CreateThingOutput {
                thing_name: self.thing_name,
                thing_arn: self.thing_arn,
                thing_id: self.thing_id,
            }
        }
    }
}
impl CreateThingOutput {
    /// Creates a new builder-style object to manufacture [`CreateThingOutput`](crate::output::CreateThingOutput)
    pub fn builder() -> crate::output::create_thing_output::Builder {
        crate::output::create_thing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamOutput {
    /// <p>The stream ID.</p>
    pub stream_id: std::option::Option<std::string::String>,
    /// <p>The stream ARN.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>A description of the stream.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the stream.</p>
    pub stream_version: std::option::Option<i32>,
}
impl CreateStreamOutput {
    /// <p>The stream ID.</p>
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// <p>The stream ARN.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>A description of the stream.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the stream.</p>
    pub fn stream_version(&self) -> std::option::Option<i32> {
        self.stream_version
    }
}
impl std::fmt::Debug for CreateStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamOutput");
        formatter.field("stream_id", &self.stream_id);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("description", &self.description);
        formatter.field("stream_version", &self.stream_version);
        formatter.finish()
    }
}
/// See [`CreateStreamOutput`](crate::output::CreateStreamOutput)
pub mod create_stream_output {
    /// A builder for [`CreateStreamOutput`](crate::output::CreateStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) stream_version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>The stream ARN.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The stream ARN.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>A description of the stream.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the stream.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the stream.</p>
        pub fn stream_version(mut self, input: i32) -> Self {
            self.stream_version = Some(input);
            self
        }
        /// <p>The version of the stream.</p>
        pub fn set_stream_version(mut self, input: std::option::Option<i32>) -> Self {
            self.stream_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamOutput`](crate::output::CreateStreamOutput)
        pub fn build(self) -> crate::output::CreateStreamOutput {
            crate::output::CreateStreamOutput {
                stream_id: self.stream_id,
                stream_arn: self.stream_arn,
                description: self.description,
                stream_version: self.stream_version,
            }
        }
    }
}
impl CreateStreamOutput {
    /// Creates a new builder-style object to manufacture [`CreateStreamOutput`](crate::output::CreateStreamOutput)
    pub fn builder() -> crate::output::create_stream_output::Builder {
        crate::output::create_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSecurityProfileOutput {
    /// <p>The name you gave to the security profile.</p>
    pub security_profile_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the security profile.</p>
    pub security_profile_arn: std::option::Option<std::string::String>,
}
impl CreateSecurityProfileOutput {
    /// <p>The name you gave to the security profile.</p>
    pub fn security_profile_name(&self) -> std::option::Option<&str> {
        self.security_profile_name.as_deref()
    }
    /// <p>The ARN of the security profile.</p>
    pub fn security_profile_arn(&self) -> std::option::Option<&str> {
        self.security_profile_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateSecurityProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSecurityProfileOutput");
        formatter.field("security_profile_name", &self.security_profile_name);
        formatter.field("security_profile_arn", &self.security_profile_arn);
        formatter.finish()
    }
}
/// See [`CreateSecurityProfileOutput`](crate::output::CreateSecurityProfileOutput)
pub mod create_security_profile_output {
    /// A builder for [`CreateSecurityProfileOutput`](crate::output::CreateSecurityProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name you gave to the security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name you gave to the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The ARN of the security profile.</p>
        pub fn security_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the security profile.</p>
        pub fn set_security_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSecurityProfileOutput`](crate::output::CreateSecurityProfileOutput)
        pub fn build(self) -> crate::output::CreateSecurityProfileOutput {
            crate::output::CreateSecurityProfileOutput {
                security_profile_name: self.security_profile_name,
                security_profile_arn: self.security_profile_arn,
            }
        }
    }
}
impl CreateSecurityProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateSecurityProfileOutput`](crate::output::CreateSecurityProfileOutput)
    pub fn builder() -> crate::output::create_security_profile_output::Builder {
        crate::output::create_security_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateScheduledAuditOutput {
    /// <p>The ARN of the scheduled audit.</p>
    pub scheduled_audit_arn: std::option::Option<std::string::String>,
}
impl CreateScheduledAuditOutput {
    /// <p>The ARN of the scheduled audit.</p>
    pub fn scheduled_audit_arn(&self) -> std::option::Option<&str> {
        self.scheduled_audit_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateScheduledAuditOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateScheduledAuditOutput");
        formatter.field("scheduled_audit_arn", &self.scheduled_audit_arn);
        formatter.finish()
    }
}
/// See [`CreateScheduledAuditOutput`](crate::output::CreateScheduledAuditOutput)
pub mod create_scheduled_audit_output {
    /// A builder for [`CreateScheduledAuditOutput`](crate::output::CreateScheduledAuditOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_audit_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the scheduled audit.</p>
        pub fn scheduled_audit_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the scheduled audit.</p>
        pub fn set_scheduled_audit_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScheduledAuditOutput`](crate::output::CreateScheduledAuditOutput)
        pub fn build(self) -> crate::output::CreateScheduledAuditOutput {
            crate::output::CreateScheduledAuditOutput {
                scheduled_audit_arn: self.scheduled_audit_arn,
            }
        }
    }
}
impl CreateScheduledAuditOutput {
    /// Creates a new builder-style object to manufacture [`CreateScheduledAuditOutput`](crate::output::CreateScheduledAuditOutput)
    pub fn builder() -> crate::output::create_scheduled_audit_output::Builder {
        crate::output::create_scheduled_audit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRoleAliasOutput {
    /// <p>The role alias.</p>
    pub role_alias: std::option::Option<std::string::String>,
    /// <p>The role alias ARN.</p>
    pub role_alias_arn: std::option::Option<std::string::String>,
}
impl CreateRoleAliasOutput {
    /// <p>The role alias.</p>
    pub fn role_alias(&self) -> std::option::Option<&str> {
        self.role_alias.as_deref()
    }
    /// <p>The role alias ARN.</p>
    pub fn role_alias_arn(&self) -> std::option::Option<&str> {
        self.role_alias_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateRoleAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRoleAliasOutput");
        formatter.field("role_alias", &self.role_alias);
        formatter.field("role_alias_arn", &self.role_alias_arn);
        formatter.finish()
    }
}
/// See [`CreateRoleAliasOutput`](crate::output::CreateRoleAliasOutput)
pub mod create_role_alias_output {
    /// A builder for [`CreateRoleAliasOutput`](crate::output::CreateRoleAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_alias: std::option::Option<std::string::String>,
        pub(crate) role_alias_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The role alias.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias = Some(input.into());
            self
        }
        /// <p>The role alias.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_alias = input;
            self
        }
        /// <p>The role alias ARN.</p>
        pub fn role_alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias_arn = Some(input.into());
            self
        }
        /// <p>The role alias ARN.</p>
        pub fn set_role_alias_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_alias_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoleAliasOutput`](crate::output::CreateRoleAliasOutput)
        pub fn build(self) -> crate::output::CreateRoleAliasOutput {
            crate::output::CreateRoleAliasOutput {
                role_alias: self.role_alias,
                role_alias_arn: self.role_alias_arn,
            }
        }
    }
}
impl CreateRoleAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateRoleAliasOutput`](crate::output::CreateRoleAliasOutput)
    pub fn builder() -> crate::output::create_role_alias_output::Builder {
        crate::output::create_role_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProvisioningTemplateVersionOutput {
    /// <p>The ARN that identifies the provisioning template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>The name of the fleet provisioning template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The version of the fleet provisioning template.</p>
    pub version_id: std::option::Option<i32>,
    /// <p>True if the fleet provisioning template version is the default version, otherwise false.</p>
    pub is_default_version: bool,
}
impl CreateProvisioningTemplateVersionOutput {
    /// <p>The ARN that identifies the provisioning template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>The name of the fleet provisioning template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The version of the fleet provisioning template.</p>
    pub fn version_id(&self) -> std::option::Option<i32> {
        self.version_id
    }
    /// <p>True if the fleet provisioning template version is the default version, otherwise false.</p>
    pub fn is_default_version(&self) -> bool {
        self.is_default_version
    }
}
impl std::fmt::Debug for CreateProvisioningTemplateVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProvisioningTemplateVersionOutput");
        formatter.field("template_arn", &self.template_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("version_id", &self.version_id);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.finish()
    }
}
/// See [`CreateProvisioningTemplateVersionOutput`](crate::output::CreateProvisioningTemplateVersionOutput)
pub mod create_provisioning_template_version_output {
    /// A builder for [`CreateProvisioningTemplateVersionOutput`](crate::output::CreateProvisioningTemplateVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<i32>,
        pub(crate) is_default_version: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN that identifies the provisioning template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The ARN that identifies the provisioning template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The version of the fleet provisioning template.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.version_id = Some(input);
            self
        }
        /// <p>The version of the fleet provisioning template.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>True if the fleet provisioning template version is the default version, otherwise false.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>True if the fleet provisioning template version is the default version, otherwise false.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningTemplateVersionOutput`](crate::output::CreateProvisioningTemplateVersionOutput)
        pub fn build(self) -> crate::output::CreateProvisioningTemplateVersionOutput {
            crate::output::CreateProvisioningTemplateVersionOutput {
                template_arn: self.template_arn,
                template_name: self.template_name,
                version_id: self.version_id,
                is_default_version: self.is_default_version.unwrap_or_default(),
            }
        }
    }
}
impl CreateProvisioningTemplateVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningTemplateVersionOutput`](crate::output::CreateProvisioningTemplateVersionOutput)
    pub fn builder() -> crate::output::create_provisioning_template_version_output::Builder {
        crate::output::create_provisioning_template_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProvisioningTemplateOutput {
    /// <p>The ARN that identifies the provisioning template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>The name of the fleet provisioning template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The default version of the fleet provisioning template.</p>
    pub default_version_id: std::option::Option<i32>,
}
impl CreateProvisioningTemplateOutput {
    /// <p>The ARN that identifies the provisioning template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>The name of the fleet provisioning template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The default version of the fleet provisioning template.</p>
    pub fn default_version_id(&self) -> std::option::Option<i32> {
        self.default_version_id
    }
}
impl std::fmt::Debug for CreateProvisioningTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProvisioningTemplateOutput");
        formatter.field("template_arn", &self.template_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("default_version_id", &self.default_version_id);
        formatter.finish()
    }
}
/// See [`CreateProvisioningTemplateOutput`](crate::output::CreateProvisioningTemplateOutput)
pub mod create_provisioning_template_output {
    /// A builder for [`CreateProvisioningTemplateOutput`](crate::output::CreateProvisioningTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) default_version_id: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN that identifies the provisioning template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The ARN that identifies the provisioning template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The default version of the fleet provisioning template.</p>
        pub fn default_version_id(mut self, input: i32) -> Self {
            self.default_version_id = Some(input);
            self
        }
        /// <p>The default version of the fleet provisioning template.</p>
        pub fn set_default_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.default_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningTemplateOutput`](crate::output::CreateProvisioningTemplateOutput)
        pub fn build(self) -> crate::output::CreateProvisioningTemplateOutput {
            crate::output::CreateProvisioningTemplateOutput {
                template_arn: self.template_arn,
                template_name: self.template_name,
                default_version_id: self.default_version_id,
            }
        }
    }
}
impl CreateProvisioningTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningTemplateOutput`](crate::output::CreateProvisioningTemplateOutput)
    pub fn builder() -> crate::output::create_provisioning_template_output::Builder {
        crate::output::create_provisioning_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProvisioningClaimOutput {
    /// <p>The ID of the certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The provisioning claim certificate.</p>
    pub certificate_pem: std::option::Option<std::string::String>,
    /// <p>The provisioning claim key pair.</p>
    pub key_pair: std::option::Option<crate::model::KeyPair>,
    /// <p>The provisioning claim expiration time.</p>
    pub expiration: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateProvisioningClaimOutput {
    /// <p>The ID of the certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The provisioning claim certificate.</p>
    pub fn certificate_pem(&self) -> std::option::Option<&str> {
        self.certificate_pem.as_deref()
    }
    /// <p>The provisioning claim key pair.</p>
    pub fn key_pair(&self) -> std::option::Option<&crate::model::KeyPair> {
        self.key_pair.as_ref()
    }
    /// <p>The provisioning claim expiration time.</p>
    pub fn expiration(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration.as_ref()
    }
}
impl std::fmt::Debug for CreateProvisioningClaimOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProvisioningClaimOutput");
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("certificate_pem", &self.certificate_pem);
        formatter.field("key_pair", &self.key_pair);
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
/// See [`CreateProvisioningClaimOutput`](crate::output::CreateProvisioningClaimOutput)
pub mod create_provisioning_claim_output {
    /// A builder for [`CreateProvisioningClaimOutput`](crate::output::CreateProvisioningClaimOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) certificate_pem: std::option::Option<std::string::String>,
        pub(crate) key_pair: std::option::Option<crate::model::KeyPair>,
        pub(crate) expiration: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The provisioning claim certificate.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_pem = Some(input.into());
            self
        }
        /// <p>The provisioning claim certificate.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_pem = input;
            self
        }
        /// <p>The provisioning claim key pair.</p>
        pub fn key_pair(mut self, input: crate::model::KeyPair) -> Self {
            self.key_pair = Some(input);
            self
        }
        /// <p>The provisioning claim key pair.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<crate::model::KeyPair>) -> Self {
            self.key_pair = input;
            self
        }
        /// <p>The provisioning claim expiration time.</p>
        pub fn expiration(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>The provisioning claim expiration time.</p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningClaimOutput`](crate::output::CreateProvisioningClaimOutput)
        pub fn build(self) -> crate::output::CreateProvisioningClaimOutput {
            crate::output::CreateProvisioningClaimOutput {
                certificate_id: self.certificate_id,
                certificate_pem: self.certificate_pem,
                key_pair: self.key_pair,
                expiration: self.expiration,
            }
        }
    }
}
impl CreateProvisioningClaimOutput {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningClaimOutput`](crate::output::CreateProvisioningClaimOutput)
    pub fn builder() -> crate::output::create_provisioning_claim_output::Builder {
        crate::output::create_provisioning_claim_output::Builder::default()
    }
}

/// <p>The output of the CreatePolicyVersion operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePolicyVersionOutput {
    /// <p>The policy ARN.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The JSON document that describes the policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
    /// <p>The policy version ID.</p>
    pub policy_version_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the policy version is the default.</p>
    pub is_default_version: bool,
}
impl CreatePolicyVersionOutput {
    /// <p>The policy ARN.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The JSON document that describes the policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
    /// <p>The policy version ID.</p>
    pub fn policy_version_id(&self) -> std::option::Option<&str> {
        self.policy_version_id.as_deref()
    }
    /// <p>Specifies whether the policy version is the default.</p>
    pub fn is_default_version(&self) -> bool {
        self.is_default_version
    }
}
impl std::fmt::Debug for CreatePolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePolicyVersionOutput");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_document", &self.policy_document);
        formatter.field("policy_version_id", &self.policy_version_id);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.finish()
    }
}
/// See [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
pub mod create_policy_version_output {
    /// A builder for [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<std::string::String>,
        pub(crate) is_default_version: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The policy ARN.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The policy ARN.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_version_id = Some(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_version_id = input;
            self
        }
        /// <p>Specifies whether the policy version is the default.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>Specifies whether the policy version is the default.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
        pub fn build(self) -> crate::output::CreatePolicyVersionOutput {
            crate::output::CreatePolicyVersionOutput {
                policy_arn: self.policy_arn,
                policy_document: self.policy_document,
                policy_version_id: self.policy_version_id,
                is_default_version: self.is_default_version.unwrap_or_default(),
            }
        }
    }
}
impl CreatePolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
    pub fn builder() -> crate::output::create_policy_version_output::Builder {
        crate::output::create_policy_version_output::Builder::default()
    }
}

/// <p>The output from the CreatePolicy operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePolicyOutput {
    /// <p>The policy name.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy ARN.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The JSON document that describes the policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
    /// <p>The policy version ID.</p>
    pub policy_version_id: std::option::Option<std::string::String>,
}
impl CreatePolicyOutput {
    /// <p>The policy name.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy ARN.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The JSON document that describes the policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
    /// <p>The policy version ID.</p>
    pub fn policy_version_id(&self) -> std::option::Option<&str> {
        self.policy_version_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePolicyOutput");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_document", &self.policy_document);
        formatter.field("policy_version_id", &self.policy_version_id);
        formatter.finish()
    }
}
/// See [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
pub mod create_policy_output {
    /// A builder for [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy ARN.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The policy ARN.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON document that describes the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_version_id = Some(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
        pub fn build(self) -> crate::output::CreatePolicyOutput {
            crate::output::CreatePolicyOutput {
                policy_name: self.policy_name,
                policy_arn: self.policy_arn,
                policy_document: self.policy_document,
                policy_version_id: self.policy_version_id,
            }
        }
    }
}
impl CreatePolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
    pub fn builder() -> crate::output::create_policy_output::Builder {
        crate::output::create_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOtaUpdateOutput {
    /// <p>The OTA update ID.</p>
    pub ota_update_id: std::option::Option<std::string::String>,
    /// <p>The IoT job ID associated with the OTA update.</p>
    pub aws_iot_job_id: std::option::Option<std::string::String>,
    /// <p>The OTA update ARN.</p>
    pub ota_update_arn: std::option::Option<std::string::String>,
    /// <p>The IoT job ARN associated with the OTA update.</p>
    pub aws_iot_job_arn: std::option::Option<std::string::String>,
    /// <p>The OTA update status.</p>
    pub ota_update_status: std::option::Option<crate::model::OtaUpdateStatus>,
}
impl CreateOtaUpdateOutput {
    /// <p>The OTA update ID.</p>
    pub fn ota_update_id(&self) -> std::option::Option<&str> {
        self.ota_update_id.as_deref()
    }
    /// <p>The IoT job ID associated with the OTA update.</p>
    pub fn aws_iot_job_id(&self) -> std::option::Option<&str> {
        self.aws_iot_job_id.as_deref()
    }
    /// <p>The OTA update ARN.</p>
    pub fn ota_update_arn(&self) -> std::option::Option<&str> {
        self.ota_update_arn.as_deref()
    }
    /// <p>The IoT job ARN associated with the OTA update.</p>
    pub fn aws_iot_job_arn(&self) -> std::option::Option<&str> {
        self.aws_iot_job_arn.as_deref()
    }
    /// <p>The OTA update status.</p>
    pub fn ota_update_status(&self) -> std::option::Option<&crate::model::OtaUpdateStatus> {
        self.ota_update_status.as_ref()
    }
}
impl std::fmt::Debug for CreateOtaUpdateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOtaUpdateOutput");
        formatter.field("ota_update_id", &self.ota_update_id);
        formatter.field("aws_iot_job_id", &self.aws_iot_job_id);
        formatter.field("ota_update_arn", &self.ota_update_arn);
        formatter.field("aws_iot_job_arn", &self.aws_iot_job_arn);
        formatter.field("ota_update_status", &self.ota_update_status);
        formatter.finish()
    }
}
/// See [`CreateOtaUpdateOutput`](crate::output::CreateOtaUpdateOutput)
pub mod create_ota_update_output {
    /// A builder for [`CreateOtaUpdateOutput`](crate::output::CreateOtaUpdateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_update_id: std::option::Option<std::string::String>,
        pub(crate) aws_iot_job_id: std::option::Option<std::string::String>,
        pub(crate) ota_update_arn: std::option::Option<std::string::String>,
        pub(crate) aws_iot_job_arn: std::option::Option<std::string::String>,
        pub(crate) ota_update_status: std::option::Option<crate::model::OtaUpdateStatus>,
    }
    impl Builder {
        /// <p>The OTA update ID.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_id = Some(input.into());
            self
        }
        /// <p>The OTA update ID.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_id = input;
            self
        }
        /// <p>The IoT job ID associated with the OTA update.</p>
        pub fn aws_iot_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_iot_job_id = Some(input.into());
            self
        }
        /// <p>The IoT job ID associated with the OTA update.</p>
        pub fn set_aws_iot_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_iot_job_id = input;
            self
        }
        /// <p>The OTA update ARN.</p>
        pub fn ota_update_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_arn = Some(input.into());
            self
        }
        /// <p>The OTA update ARN.</p>
        pub fn set_ota_update_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_arn = input;
            self
        }
        /// <p>The IoT job ARN associated with the OTA update.</p>
        pub fn aws_iot_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_iot_job_arn = Some(input.into());
            self
        }
        /// <p>The IoT job ARN associated with the OTA update.</p>
        pub fn set_aws_iot_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_iot_job_arn = input;
            self
        }
        /// <p>The OTA update status.</p>
        pub fn ota_update_status(mut self, input: crate::model::OtaUpdateStatus) -> Self {
            self.ota_update_status = Some(input);
            self
        }
        /// <p>The OTA update status.</p>
        pub fn set_ota_update_status(
            mut self,
            input: std::option::Option<crate::model::OtaUpdateStatus>,
        ) -> Self {
            self.ota_update_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOtaUpdateOutput`](crate::output::CreateOtaUpdateOutput)
        pub fn build(self) -> crate::output::CreateOtaUpdateOutput {
            crate::output::CreateOtaUpdateOutput {
                ota_update_id: self.ota_update_id,
                aws_iot_job_id: self.aws_iot_job_id,
                ota_update_arn: self.ota_update_arn,
                aws_iot_job_arn: self.aws_iot_job_arn,
                ota_update_status: self.ota_update_status,
            }
        }
    }
}
impl CreateOtaUpdateOutput {
    /// Creates a new builder-style object to manufacture [`CreateOtaUpdateOutput`](crate::output::CreateOtaUpdateOutput)
    pub fn builder() -> crate::output::create_ota_update_output::Builder {
        crate::output::create_ota_update_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMitigationActionOutput {
    /// <p>The ARN for the new mitigation action.</p>
    pub action_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the new mitigation action.</p>
    pub action_id: std::option::Option<std::string::String>,
}
impl CreateMitigationActionOutput {
    /// <p>The ARN for the new mitigation action.</p>
    pub fn action_arn(&self) -> std::option::Option<&str> {
        self.action_arn.as_deref()
    }
    /// <p>A unique identifier for the new mitigation action.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
}
impl std::fmt::Debug for CreateMitigationActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMitigationActionOutput");
        formatter.field("action_arn", &self.action_arn);
        formatter.field("action_id", &self.action_id);
        formatter.finish()
    }
}
/// See [`CreateMitigationActionOutput`](crate::output::CreateMitigationActionOutput)
pub mod create_mitigation_action_output {
    /// A builder for [`CreateMitigationActionOutput`](crate::output::CreateMitigationActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_arn: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the new mitigation action.</p>
        pub fn action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the new mitigation action.</p>
        pub fn set_action_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_arn = input;
            self
        }
        /// <p>A unique identifier for the new mitigation action.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the new mitigation action.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMitigationActionOutput`](crate::output::CreateMitigationActionOutput)
        pub fn build(self) -> crate::output::CreateMitigationActionOutput {
            crate::output::CreateMitigationActionOutput {
                action_arn: self.action_arn,
                action_id: self.action_id,
            }
        }
    }
}
impl CreateMitigationActionOutput {
    /// Creates a new builder-style object to manufacture [`CreateMitigationActionOutput`](crate::output::CreateMitigationActionOutput)
    pub fn builder() -> crate::output::create_mitigation_action_output::Builder {
        crate::output::create_mitigation_action_output::Builder::default()
    }
}

/// <p>The output of the CreateKeysAndCertificate operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeysAndCertificateOutput {
    /// <p>The ARN of the certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT Certificate).</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The certificate data, in PEM format.</p>
    pub certificate_pem: std::option::Option<std::string::String>,
    /// <p>The generated key pair.</p>
    pub key_pair: std::option::Option<crate::model::KeyPair>,
}
impl CreateKeysAndCertificateOutput {
    /// <p>The ARN of the certificate.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT Certificate).</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The certificate data, in PEM format.</p>
    pub fn certificate_pem(&self) -> std::option::Option<&str> {
        self.certificate_pem.as_deref()
    }
    /// <p>The generated key pair.</p>
    pub fn key_pair(&self) -> std::option::Option<&crate::model::KeyPair> {
        self.key_pair.as_ref()
    }
}
impl std::fmt::Debug for CreateKeysAndCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeysAndCertificateOutput");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("certificate_pem", &self.certificate_pem);
        formatter.field("key_pair", &self.key_pair);
        formatter.finish()
    }
}
/// See [`CreateKeysAndCertificateOutput`](crate::output::CreateKeysAndCertificateOutput)
pub mod create_keys_and_certificate_output {
    /// A builder for [`CreateKeysAndCertificateOutput`](crate::output::CreateKeysAndCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) certificate_pem: std::option::Option<std::string::String>,
        pub(crate) key_pair: std::option::Option<crate::model::KeyPair>,
    }
    impl Builder {
        /// <p>The ARN of the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT Certificate).</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT Certificate).</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_pem = Some(input.into());
            self
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_pem = input;
            self
        }
        /// <p>The generated key pair.</p>
        pub fn key_pair(mut self, input: crate::model::KeyPair) -> Self {
            self.key_pair = Some(input);
            self
        }
        /// <p>The generated key pair.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<crate::model::KeyPair>) -> Self {
            self.key_pair = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeysAndCertificateOutput`](crate::output::CreateKeysAndCertificateOutput)
        pub fn build(self) -> crate::output::CreateKeysAndCertificateOutput {
            crate::output::CreateKeysAndCertificateOutput {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
                certificate_pem: self.certificate_pem,
                key_pair: self.key_pair,
            }
        }
    }
}
impl CreateKeysAndCertificateOutput {
    /// Creates a new builder-style object to manufacture [`CreateKeysAndCertificateOutput`](crate::output::CreateKeysAndCertificateOutput)
    pub fn builder() -> crate::output::create_keys_and_certificate_output::Builder {
        crate::output::create_keys_and_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobTemplateOutput {
    /// <p>The ARN of the job template.</p>
    pub job_template_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the job template.</p>
    pub job_template_id: std::option::Option<std::string::String>,
}
impl CreateJobTemplateOutput {
    /// <p>The ARN of the job template.</p>
    pub fn job_template_arn(&self) -> std::option::Option<&str> {
        self.job_template_arn.as_deref()
    }
    /// <p>The unique identifier of the job template.</p>
    pub fn job_template_id(&self) -> std::option::Option<&str> {
        self.job_template_id.as_deref()
    }
}
impl std::fmt::Debug for CreateJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobTemplateOutput");
        formatter.field("job_template_arn", &self.job_template_arn);
        formatter.field("job_template_id", &self.job_template_id);
        formatter.finish()
    }
}
/// See [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
pub mod create_job_template_output {
    /// A builder for [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template_arn: std::option::Option<std::string::String>,
        pub(crate) job_template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the job template.</p>
        pub fn job_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the job template.</p>
        pub fn set_job_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_arn = input;
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
        pub fn build(self) -> crate::output::CreateJobTemplateOutput {
            crate::output::CreateJobTemplateOutput {
                job_template_arn: self.job_template_arn,
                job_template_id: self.job_template_id,
            }
        }
    }
}
impl CreateJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
    pub fn builder() -> crate::output::create_job_template_output::Builder {
        crate::output::create_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobOutput {
    /// <p>The job ARN.</p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier you assigned to this job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The job description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl CreateJobOutput {
    /// <p>The job ARN.</p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The unique identifier you assigned to this job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The job description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CreateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobOutput");
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_id", &self.job_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`CreateJobOutput`](crate::output::CreateJobOutput)
pub mod create_job_output {
    /// A builder for [`CreateJobOutput`](crate::output::CreateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job ARN.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The job ARN.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The unique identifier you assigned to this job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The job description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The job description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobOutput`](crate::output::CreateJobOutput)
        pub fn build(self) -> crate::output::CreateJobOutput {
            crate::output::CreateJobOutput {
                job_arn: self.job_arn,
                job_id: self.job_id,
                description: self.description,
            }
        }
    }
}
impl CreateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobOutput`](crate::output::CreateJobOutput)
    pub fn builder() -> crate::output::create_job_output::Builder {
        crate::output::create_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFleetMetricOutput {
    /// <p>The name of the fleet metric to create.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the new fleet metric.</p>
    pub metric_arn: std::option::Option<std::string::String>,
}
impl CreateFleetMetricOutput {
    /// <p>The name of the fleet metric to create.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the new fleet metric.</p>
    pub fn metric_arn(&self) -> std::option::Option<&str> {
        self.metric_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateFleetMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFleetMetricOutput");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_arn", &self.metric_arn);
        formatter.finish()
    }
}
/// See [`CreateFleetMetricOutput`](crate::output::CreateFleetMetricOutput)
pub mod create_fleet_metric_output {
    /// A builder for [`CreateFleetMetricOutput`](crate::output::CreateFleetMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet metric to create.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet metric to create.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new fleet metric.</p>
        pub fn metric_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new fleet metric.</p>
        pub fn set_metric_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetMetricOutput`](crate::output::CreateFleetMetricOutput)
        pub fn build(self) -> crate::output::CreateFleetMetricOutput {
            crate::output::CreateFleetMetricOutput {
                metric_name: self.metric_name,
                metric_arn: self.metric_arn,
            }
        }
    }
}
impl CreateFleetMetricOutput {
    /// Creates a new builder-style object to manufacture [`CreateFleetMetricOutput`](crate::output::CreateFleetMetricOutput)
    pub fn builder() -> crate::output::create_fleet_metric_output::Builder {
        crate::output::create_fleet_metric_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDynamicThingGroupOutput {
    /// <p>The dynamic thing group name.</p>
    pub thing_group_name: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group ARN.</p>
    pub thing_group_arn: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group ID.</p>
    pub thing_group_id: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group index name.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group search query string.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The dynamic thing group query version.</p>
    pub query_version: std::option::Option<std::string::String>,
}
impl CreateDynamicThingGroupOutput {
    /// <p>The dynamic thing group name.</p>
    pub fn thing_group_name(&self) -> std::option::Option<&str> {
        self.thing_group_name.as_deref()
    }
    /// <p>The dynamic thing group ARN.</p>
    pub fn thing_group_arn(&self) -> std::option::Option<&str> {
        self.thing_group_arn.as_deref()
    }
    /// <p>The dynamic thing group ID.</p>
    pub fn thing_group_id(&self) -> std::option::Option<&str> {
        self.thing_group_id.as_deref()
    }
    /// <p>The dynamic thing group index name.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The dynamic thing group search query string.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The dynamic thing group query version.</p>
    pub fn query_version(&self) -> std::option::Option<&str> {
        self.query_version.as_deref()
    }
}
impl std::fmt::Debug for CreateDynamicThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDynamicThingGroupOutput");
        formatter.field("thing_group_name", &self.thing_group_name);
        formatter.field("thing_group_arn", &self.thing_group_arn);
        formatter.field("thing_group_id", &self.thing_group_id);
        formatter.field("index_name", &self.index_name);
        formatter.field("query_string", &self.query_string);
        formatter.field("query_version", &self.query_version);
        formatter.finish()
    }
}
/// See [`CreateDynamicThingGroupOutput`](crate::output::CreateDynamicThingGroupOutput)
pub mod create_dynamic_thing_group_output {
    /// A builder for [`CreateDynamicThingGroupOutput`](crate::output::CreateDynamicThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_arn: std::option::Option<std::string::String>,
        pub(crate) thing_group_id: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The dynamic thing group name.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The dynamic thing group name.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The dynamic thing group ARN.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_arn = Some(input.into());
            self
        }
        /// <p>The dynamic thing group ARN.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_arn = input;
            self
        }
        /// <p>The dynamic thing group ID.</p>
        pub fn thing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_id = Some(input.into());
            self
        }
        /// <p>The dynamic thing group ID.</p>
        pub fn set_thing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_id = input;
            self
        }
        /// <p>The dynamic thing group index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The dynamic thing group index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The dynamic thing group query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The dynamic thing group query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDynamicThingGroupOutput`](crate::output::CreateDynamicThingGroupOutput)
        pub fn build(self) -> crate::output::CreateDynamicThingGroupOutput {
            crate::output::CreateDynamicThingGroupOutput {
                thing_group_name: self.thing_group_name,
                thing_group_arn: self.thing_group_arn,
                thing_group_id: self.thing_group_id,
                index_name: self.index_name,
                query_string: self.query_string,
                query_version: self.query_version,
            }
        }
    }
}
impl CreateDynamicThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDynamicThingGroupOutput`](crate::output::CreateDynamicThingGroupOutput)
    pub fn builder() -> crate::output::create_dynamic_thing_group_output::Builder {
        crate::output::create_dynamic_thing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainConfigurationOutput {
    /// <p>The name of the domain configuration.</p>
    pub domain_configuration_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the domain configuration.</p>
    pub domain_configuration_arn: std::option::Option<std::string::String>,
}
impl CreateDomainConfigurationOutput {
    /// <p>The name of the domain configuration.</p>
    pub fn domain_configuration_name(&self) -> std::option::Option<&str> {
        self.domain_configuration_name.as_deref()
    }
    /// <p>The ARN of the domain configuration.</p>
    pub fn domain_configuration_arn(&self) -> std::option::Option<&str> {
        self.domain_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDomainConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainConfigurationOutput");
        formatter.field("domain_configuration_name", &self.domain_configuration_name);
        formatter.field("domain_configuration_arn", &self.domain_configuration_arn);
        formatter.finish()
    }
}
/// See [`CreateDomainConfigurationOutput`](crate::output::CreateDomainConfigurationOutput)
pub mod create_domain_configuration_output {
    /// A builder for [`CreateDomainConfigurationOutput`](crate::output::CreateDomainConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configuration_name: std::option::Option<std::string::String>,
        pub(crate) domain_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain configuration.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the domain configuration.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_name = input;
            self
        }
        /// <p>The ARN of the domain configuration.</p>
        pub fn domain_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the domain configuration.</p>
        pub fn set_domain_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainConfigurationOutput`](crate::output::CreateDomainConfigurationOutput)
        pub fn build(self) -> crate::output::CreateDomainConfigurationOutput {
            crate::output::CreateDomainConfigurationOutput {
                domain_configuration_name: self.domain_configuration_name,
                domain_configuration_arn: self.domain_configuration_arn,
            }
        }
    }
}
impl CreateDomainConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainConfigurationOutput`](crate::output::CreateDomainConfigurationOutput)
    pub fn builder() -> crate::output::create_domain_configuration_output::Builder {
        crate::output::create_domain_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDimensionOutput {
    /// <p>A unique identifier for the dimension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the created dimension.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreateDimensionOutput {
    /// <p>A unique identifier for the dimension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the created dimension.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDimensionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDimensionOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateDimensionOutput`](crate::output::CreateDimensionOutput)
pub mod create_dimension_output {
    /// A builder for [`CreateDimensionOutput`](crate::output::CreateDimensionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created dimension.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created dimension.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDimensionOutput`](crate::output::CreateDimensionOutput)
        pub fn build(self) -> crate::output::CreateDimensionOutput {
            crate::output::CreateDimensionOutput {
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl CreateDimensionOutput {
    /// Creates a new builder-style object to manufacture [`CreateDimensionOutput`](crate::output::CreateDimensionOutput)
    pub fn builder() -> crate::output::create_dimension_output::Builder {
        crate::output::create_dimension_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomMetricOutput {
    /// <p> The name of the custom metric to be used in the metric report. </p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Number (ARN) of the custom metric, e.g. <code>arn:<i>aws-partition</i>:iot:<i>region</i>:<i>accountId</i>:custommetric/<i>metricName</i> </code> </p>
    pub metric_arn: std::option::Option<std::string::String>,
}
impl CreateCustomMetricOutput {
    /// <p> The name of the custom metric to be used in the metric report. </p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p> The Amazon Resource Number (ARN) of the custom metric, e.g. <code>arn:<i>aws-partition</i>:iot:<i>region</i>:<i>accountId</i>:custommetric/<i>metricName</i> </code> </p>
    pub fn metric_arn(&self) -> std::option::Option<&str> {
        self.metric_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomMetricOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomMetricOutput");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_arn", &self.metric_arn);
        formatter.finish()
    }
}
/// See [`CreateCustomMetricOutput`](crate::output::CreateCustomMetricOutput)
pub mod create_custom_metric_output {
    /// A builder for [`CreateCustomMetricOutput`](crate::output::CreateCustomMetricOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the custom metric to be used in the metric report. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p> The name of the custom metric to be used in the metric report. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p> The Amazon Resource Number (ARN) of the custom metric, e.g. <code>arn:<i>aws-partition</i>:iot:<i>region</i>:<i>accountId</i>:custommetric/<i>metricName</i> </code> </p>
        pub fn metric_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Number (ARN) of the custom metric, e.g. <code>arn:<i>aws-partition</i>:iot:<i>region</i>:<i>accountId</i>:custommetric/<i>metricName</i> </code> </p>
        pub fn set_metric_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomMetricOutput`](crate::output::CreateCustomMetricOutput)
        pub fn build(self) -> crate::output::CreateCustomMetricOutput {
            crate::output::CreateCustomMetricOutput {
                metric_name: self.metric_name,
                metric_arn: self.metric_arn,
            }
        }
    }
}
impl CreateCustomMetricOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomMetricOutput`](crate::output::CreateCustomMetricOutput)
    pub fn builder() -> crate::output::create_custom_metric_output::Builder {
        crate::output::create_custom_metric_output::Builder::default()
    }
}

/// <p>The output from the CreateCertificateFromCsr operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCertificateFromCsrOutput {
    /// <p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the certificate. Certificate management operations only take a certificateId.</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The certificate data, in PEM format.</p>
    pub certificate_pem: std::option::Option<std::string::String>,
}
impl CreateCertificateFromCsrOutput {
    /// <p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The ID of the certificate. Certificate management operations only take a certificateId.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The certificate data, in PEM format.</p>
    pub fn certificate_pem(&self) -> std::option::Option<&str> {
        self.certificate_pem.as_deref()
    }
}
impl std::fmt::Debug for CreateCertificateFromCsrOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCertificateFromCsrOutput");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("certificate_pem", &self.certificate_pem);
        formatter.finish()
    }
}
/// See [`CreateCertificateFromCsrOutput`](crate::output::CreateCertificateFromCsrOutput)
pub mod create_certificate_from_csr_output {
    /// A builder for [`CreateCertificateFromCsrOutput`](crate::output::CreateCertificateFromCsrOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) certificate_pem: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The ID of the certificate. Certificate management operations only take a certificateId.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate. Certificate management operations only take a certificateId.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_pem = Some(input.into());
            self
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_pem = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCertificateFromCsrOutput`](crate::output::CreateCertificateFromCsrOutput)
        pub fn build(self) -> crate::output::CreateCertificateFromCsrOutput {
            crate::output::CreateCertificateFromCsrOutput {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
                certificate_pem: self.certificate_pem,
            }
        }
    }
}
impl CreateCertificateFromCsrOutput {
    /// Creates a new builder-style object to manufacture [`CreateCertificateFromCsrOutput`](crate::output::CreateCertificateFromCsrOutput)
    pub fn builder() -> crate::output::create_certificate_from_csr_output::Builder {
        crate::output::create_certificate_from_csr_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBillingGroupOutput {
    /// <p>The name you gave to the billing group.</p>
    pub billing_group_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the billing group.</p>
    pub billing_group_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the billing group.</p>
    pub billing_group_id: std::option::Option<std::string::String>,
}
impl CreateBillingGroupOutput {
    /// <p>The name you gave to the billing group.</p>
    pub fn billing_group_name(&self) -> std::option::Option<&str> {
        self.billing_group_name.as_deref()
    }
    /// <p>The ARN of the billing group.</p>
    pub fn billing_group_arn(&self) -> std::option::Option<&str> {
        self.billing_group_arn.as_deref()
    }
    /// <p>The ID of the billing group.</p>
    pub fn billing_group_id(&self) -> std::option::Option<&str> {
        self.billing_group_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBillingGroupOutput");
        formatter.field("billing_group_name", &self.billing_group_name);
        formatter.field("billing_group_arn", &self.billing_group_arn);
        formatter.field("billing_group_id", &self.billing_group_id);
        formatter.finish()
    }
}
/// See [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
pub mod create_billing_group_output {
    /// A builder for [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
        pub(crate) billing_group_arn: std::option::Option<std::string::String>,
        pub(crate) billing_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name you gave to the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name you gave to the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_arn = input;
            self
        }
        /// <p>The ID of the billing group.</p>
        pub fn billing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the billing group.</p>
        pub fn set_billing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
        pub fn build(self) -> crate::output::CreateBillingGroupOutput {
            crate::output::CreateBillingGroupOutput {
                billing_group_name: self.billing_group_name,
                billing_group_arn: self.billing_group_arn,
                billing_group_id: self.billing_group_id,
            }
        }
    }
}
impl CreateBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput)
    pub fn builder() -> crate::output::create_billing_group_output::Builder {
        crate::output::create_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAuthorizerOutput {
    /// <p>The authorizer's name.</p>
    pub authorizer_name: std::option::Option<std::string::String>,
    /// <p>The authorizer ARN.</p>
    pub authorizer_arn: std::option::Option<std::string::String>,
}
impl CreateAuthorizerOutput {
    /// <p>The authorizer's name.</p>
    pub fn authorizer_name(&self) -> std::option::Option<&str> {
        self.authorizer_name.as_deref()
    }
    /// <p>The authorizer ARN.</p>
    pub fn authorizer_arn(&self) -> std::option::Option<&str> {
        self.authorizer_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAuthorizerOutput");
        formatter.field("authorizer_name", &self.authorizer_name);
        formatter.field("authorizer_arn", &self.authorizer_arn);
        formatter.finish()
    }
}
/// See [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
pub mod create_authorizer_output {
    /// A builder for [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_name: std::option::Option<std::string::String>,
        pub(crate) authorizer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The authorizer's name.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_name = Some(input.into());
            self
        }
        /// <p>The authorizer's name.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_name = input;
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn authorizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_arn = Some(input.into());
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn set_authorizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
        pub fn build(self) -> crate::output::CreateAuthorizerOutput {
            crate::output::CreateAuthorizerOutput {
                authorizer_name: self.authorizer_name,
                authorizer_arn: self.authorizer_arn,
            }
        }
    }
}
impl CreateAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput)
    pub fn builder() -> crate::output::create_authorizer_output::Builder {
        crate::output::create_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAuditSuppressionOutput {}
impl std::fmt::Debug for CreateAuditSuppressionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAuditSuppressionOutput");
        formatter.finish()
    }
}
/// See [`CreateAuditSuppressionOutput`](crate::output::CreateAuditSuppressionOutput)
pub mod create_audit_suppression_output {
    /// A builder for [`CreateAuditSuppressionOutput`](crate::output::CreateAuditSuppressionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateAuditSuppressionOutput`](crate::output::CreateAuditSuppressionOutput)
        pub fn build(self) -> crate::output::CreateAuditSuppressionOutput {
            crate::output::CreateAuditSuppressionOutput {}
        }
    }
}
impl CreateAuditSuppressionOutput {
    /// Creates a new builder-style object to manufacture [`CreateAuditSuppressionOutput`](crate::output::CreateAuditSuppressionOutput)
    pub fn builder() -> crate::output::create_audit_suppression_output::Builder {
        crate::output::create_audit_suppression_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmTopicRuleDestinationOutput {}
impl std::fmt::Debug for ConfirmTopicRuleDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmTopicRuleDestinationOutput");
        formatter.finish()
    }
}
/// See [`ConfirmTopicRuleDestinationOutput`](crate::output::ConfirmTopicRuleDestinationOutput)
pub mod confirm_topic_rule_destination_output {
    /// A builder for [`ConfirmTopicRuleDestinationOutput`](crate::output::ConfirmTopicRuleDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ConfirmTopicRuleDestinationOutput`](crate::output::ConfirmTopicRuleDestinationOutput)
        pub fn build(self) -> crate::output::ConfirmTopicRuleDestinationOutput {
            crate::output::ConfirmTopicRuleDestinationOutput {}
        }
    }
}
impl ConfirmTopicRuleDestinationOutput {
    /// Creates a new builder-style object to manufacture [`ConfirmTopicRuleDestinationOutput`](crate::output::ConfirmTopicRuleDestinationOutput)
    pub fn builder() -> crate::output::confirm_topic_rule_destination_output::Builder {
        crate::output::confirm_topic_rule_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClearDefaultAuthorizerOutput {}
impl std::fmt::Debug for ClearDefaultAuthorizerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClearDefaultAuthorizerOutput");
        formatter.finish()
    }
}
/// See [`ClearDefaultAuthorizerOutput`](crate::output::ClearDefaultAuthorizerOutput)
pub mod clear_default_authorizer_output {
    /// A builder for [`ClearDefaultAuthorizerOutput`](crate::output::ClearDefaultAuthorizerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ClearDefaultAuthorizerOutput`](crate::output::ClearDefaultAuthorizerOutput)
        pub fn build(self) -> crate::output::ClearDefaultAuthorizerOutput {
            crate::output::ClearDefaultAuthorizerOutput {}
        }
    }
}
impl ClearDefaultAuthorizerOutput {
    /// Creates a new builder-style object to manufacture [`ClearDefaultAuthorizerOutput`](crate::output::ClearDefaultAuthorizerOutput)
    pub fn builder() -> crate::output::clear_default_authorizer_output::Builder {
        crate::output::clear_default_authorizer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobExecutionOutput {}
impl std::fmt::Debug for CancelJobExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobExecutionOutput");
        formatter.finish()
    }
}
/// See [`CancelJobExecutionOutput`](crate::output::CancelJobExecutionOutput)
pub mod cancel_job_execution_output {
    /// A builder for [`CancelJobExecutionOutput`](crate::output::CancelJobExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelJobExecutionOutput`](crate::output::CancelJobExecutionOutput)
        pub fn build(self) -> crate::output::CancelJobExecutionOutput {
            crate::output::CancelJobExecutionOutput {}
        }
    }
}
impl CancelJobExecutionOutput {
    /// Creates a new builder-style object to manufacture [`CancelJobExecutionOutput`](crate::output::CancelJobExecutionOutput)
    pub fn builder() -> crate::output::cancel_job_execution_output::Builder {
        crate::output::cancel_job_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobOutput {
    /// <p>The job ARN.</p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>A short text description of the job.</p>
    pub description: std::option::Option<std::string::String>,
}
impl CancelJobOutput {
    /// <p>The job ARN.</p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>A short text description of the job.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CancelJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobOutput");
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_id", &self.job_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`CancelJobOutput`](crate::output::CancelJobOutput)
pub mod cancel_job_output {
    /// A builder for [`CancelJobOutput`](crate::output::CancelJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job ARN.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The job ARN.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelJobOutput`](crate::output::CancelJobOutput)
        pub fn build(self) -> crate::output::CancelJobOutput {
            crate::output::CancelJobOutput {
                job_arn: self.job_arn,
                job_id: self.job_id,
                description: self.description,
            }
        }
    }
}
impl CancelJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelJobOutput`](crate::output::CancelJobOutput)
    pub fn builder() -> crate::output::cancel_job_output::Builder {
        crate::output::cancel_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDetectMitigationActionsTaskOutput {}
impl std::fmt::Debug for CancelDetectMitigationActionsTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDetectMitigationActionsTaskOutput");
        formatter.finish()
    }
}
/// See [`CancelDetectMitigationActionsTaskOutput`](crate::output::CancelDetectMitigationActionsTaskOutput)
pub mod cancel_detect_mitigation_actions_task_output {
    /// A builder for [`CancelDetectMitigationActionsTaskOutput`](crate::output::CancelDetectMitigationActionsTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelDetectMitigationActionsTaskOutput`](crate::output::CancelDetectMitigationActionsTaskOutput)
        pub fn build(self) -> crate::output::CancelDetectMitigationActionsTaskOutput {
            crate::output::CancelDetectMitigationActionsTaskOutput {}
        }
    }
}
impl CancelDetectMitigationActionsTaskOutput {
    /// Creates a new builder-style object to manufacture [`CancelDetectMitigationActionsTaskOutput`](crate::output::CancelDetectMitigationActionsTaskOutput)
    pub fn builder() -> crate::output::cancel_detect_mitigation_actions_task_output::Builder {
        crate::output::cancel_detect_mitigation_actions_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelCertificateTransferOutput {}
impl std::fmt::Debug for CancelCertificateTransferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelCertificateTransferOutput");
        formatter.finish()
    }
}
/// See [`CancelCertificateTransferOutput`](crate::output::CancelCertificateTransferOutput)
pub mod cancel_certificate_transfer_output {
    /// A builder for [`CancelCertificateTransferOutput`](crate::output::CancelCertificateTransferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelCertificateTransferOutput`](crate::output::CancelCertificateTransferOutput)
        pub fn build(self) -> crate::output::CancelCertificateTransferOutput {
            crate::output::CancelCertificateTransferOutput {}
        }
    }
}
impl CancelCertificateTransferOutput {
    /// Creates a new builder-style object to manufacture [`CancelCertificateTransferOutput`](crate::output::CancelCertificateTransferOutput)
    pub fn builder() -> crate::output::cancel_certificate_transfer_output::Builder {
        crate::output::cancel_certificate_transfer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelAuditTaskOutput {}
impl std::fmt::Debug for CancelAuditTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelAuditTaskOutput");
        formatter.finish()
    }
}
/// See [`CancelAuditTaskOutput`](crate::output::CancelAuditTaskOutput)
pub mod cancel_audit_task_output {
    /// A builder for [`CancelAuditTaskOutput`](crate::output::CancelAuditTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelAuditTaskOutput`](crate::output::CancelAuditTaskOutput)
        pub fn build(self) -> crate::output::CancelAuditTaskOutput {
            crate::output::CancelAuditTaskOutput {}
        }
    }
}
impl CancelAuditTaskOutput {
    /// Creates a new builder-style object to manufacture [`CancelAuditTaskOutput`](crate::output::CancelAuditTaskOutput)
    pub fn builder() -> crate::output::cancel_audit_task_output::Builder {
        crate::output::cancel_audit_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelAuditMitigationActionsTaskOutput {}
impl std::fmt::Debug for CancelAuditMitigationActionsTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelAuditMitigationActionsTaskOutput");
        formatter.finish()
    }
}
/// See [`CancelAuditMitigationActionsTaskOutput`](crate::output::CancelAuditMitigationActionsTaskOutput)
pub mod cancel_audit_mitigation_actions_task_output {
    /// A builder for [`CancelAuditMitigationActionsTaskOutput`](crate::output::CancelAuditMitigationActionsTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelAuditMitigationActionsTaskOutput`](crate::output::CancelAuditMitigationActionsTaskOutput)
        pub fn build(self) -> crate::output::CancelAuditMitigationActionsTaskOutput {
            crate::output::CancelAuditMitigationActionsTaskOutput {}
        }
    }
}
impl CancelAuditMitigationActionsTaskOutput {
    /// Creates a new builder-style object to manufacture [`CancelAuditMitigationActionsTaskOutput`](crate::output::CancelAuditMitigationActionsTaskOutput)
    pub fn builder() -> crate::output::cancel_audit_mitigation_actions_task_output::Builder {
        crate::output::cancel_audit_mitigation_actions_task_output::Builder::default()
    }
}

/// <p>The output from the AttachThingPrincipal operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachThingPrincipalOutput {}
impl std::fmt::Debug for AttachThingPrincipalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachThingPrincipalOutput");
        formatter.finish()
    }
}
/// See [`AttachThingPrincipalOutput`](crate::output::AttachThingPrincipalOutput)
pub mod attach_thing_principal_output {
    /// A builder for [`AttachThingPrincipalOutput`](crate::output::AttachThingPrincipalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachThingPrincipalOutput`](crate::output::AttachThingPrincipalOutput)
        pub fn build(self) -> crate::output::AttachThingPrincipalOutput {
            crate::output::AttachThingPrincipalOutput {}
        }
    }
}
impl AttachThingPrincipalOutput {
    /// Creates a new builder-style object to manufacture [`AttachThingPrincipalOutput`](crate::output::AttachThingPrincipalOutput)
    pub fn builder() -> crate::output::attach_thing_principal_output::Builder {
        crate::output::attach_thing_principal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachSecurityProfileOutput {}
impl std::fmt::Debug for AttachSecurityProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachSecurityProfileOutput");
        formatter.finish()
    }
}
/// See [`AttachSecurityProfileOutput`](crate::output::AttachSecurityProfileOutput)
pub mod attach_security_profile_output {
    /// A builder for [`AttachSecurityProfileOutput`](crate::output::AttachSecurityProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachSecurityProfileOutput`](crate::output::AttachSecurityProfileOutput)
        pub fn build(self) -> crate::output::AttachSecurityProfileOutput {
            crate::output::AttachSecurityProfileOutput {}
        }
    }
}
impl AttachSecurityProfileOutput {
    /// Creates a new builder-style object to manufacture [`AttachSecurityProfileOutput`](crate::output::AttachSecurityProfileOutput)
    pub fn builder() -> crate::output::attach_security_profile_output::Builder {
        crate::output::attach_security_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachPrincipalPolicyOutput {}
impl std::fmt::Debug for AttachPrincipalPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachPrincipalPolicyOutput");
        formatter.finish()
    }
}
/// See [`AttachPrincipalPolicyOutput`](crate::output::AttachPrincipalPolicyOutput)
pub mod attach_principal_policy_output {
    /// A builder for [`AttachPrincipalPolicyOutput`](crate::output::AttachPrincipalPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachPrincipalPolicyOutput`](crate::output::AttachPrincipalPolicyOutput)
        pub fn build(self) -> crate::output::AttachPrincipalPolicyOutput {
            crate::output::AttachPrincipalPolicyOutput {}
        }
    }
}
impl AttachPrincipalPolicyOutput {
    /// Creates a new builder-style object to manufacture [`AttachPrincipalPolicyOutput`](crate::output::AttachPrincipalPolicyOutput)
    pub fn builder() -> crate::output::attach_principal_policy_output::Builder {
        crate::output::attach_principal_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachPolicyOutput {}
impl std::fmt::Debug for AttachPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachPolicyOutput");
        formatter.finish()
    }
}
/// See [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
pub mod attach_policy_output {
    /// A builder for [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
        pub fn build(self) -> crate::output::AttachPolicyOutput {
            crate::output::AttachPolicyOutput {}
        }
    }
}
impl AttachPolicyOutput {
    /// Creates a new builder-style object to manufacture [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)
    pub fn builder() -> crate::output::attach_policy_output::Builder {
        crate::output::attach_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTargetsWithJobOutput {
    /// <p>An ARN identifying the job.</p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>A short text description of the job.</p>
    pub description: std::option::Option<std::string::String>,
}
impl AssociateTargetsWithJobOutput {
    /// <p>An ARN identifying the job.</p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>A short text description of the job.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for AssociateTargetsWithJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTargetsWithJobOutput");
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_id", &self.job_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`AssociateTargetsWithJobOutput`](crate::output::AssociateTargetsWithJobOutput)
pub mod associate_targets_with_job_output {
    /// A builder for [`AssociateTargetsWithJobOutput`](crate::output::AssociateTargetsWithJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An ARN identifying the job.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>An ARN identifying the job.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTargetsWithJobOutput`](crate::output::AssociateTargetsWithJobOutput)
        pub fn build(self) -> crate::output::AssociateTargetsWithJobOutput {
            crate::output::AssociateTargetsWithJobOutput {
                job_arn: self.job_arn,
                job_id: self.job_id,
                description: self.description,
            }
        }
    }
}
impl AssociateTargetsWithJobOutput {
    /// Creates a new builder-style object to manufacture [`AssociateTargetsWithJobOutput`](crate::output::AssociateTargetsWithJobOutput)
    pub fn builder() -> crate::output::associate_targets_with_job_output::Builder {
        crate::output::associate_targets_with_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddThingToThingGroupOutput {}
impl std::fmt::Debug for AddThingToThingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddThingToThingGroupOutput");
        formatter.finish()
    }
}
/// See [`AddThingToThingGroupOutput`](crate::output::AddThingToThingGroupOutput)
pub mod add_thing_to_thing_group_output {
    /// A builder for [`AddThingToThingGroupOutput`](crate::output::AddThingToThingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddThingToThingGroupOutput`](crate::output::AddThingToThingGroupOutput)
        pub fn build(self) -> crate::output::AddThingToThingGroupOutput {
            crate::output::AddThingToThingGroupOutput {}
        }
    }
}
impl AddThingToThingGroupOutput {
    /// Creates a new builder-style object to manufacture [`AddThingToThingGroupOutput`](crate::output::AddThingToThingGroupOutput)
    pub fn builder() -> crate::output::add_thing_to_thing_group_output::Builder {
        crate::output::add_thing_to_thing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddThingToBillingGroupOutput {}
impl std::fmt::Debug for AddThingToBillingGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddThingToBillingGroupOutput");
        formatter.finish()
    }
}
/// See [`AddThingToBillingGroupOutput`](crate::output::AddThingToBillingGroupOutput)
pub mod add_thing_to_billing_group_output {
    /// A builder for [`AddThingToBillingGroupOutput`](crate::output::AddThingToBillingGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddThingToBillingGroupOutput`](crate::output::AddThingToBillingGroupOutput)
        pub fn build(self) -> crate::output::AddThingToBillingGroupOutput {
            crate::output::AddThingToBillingGroupOutput {}
        }
    }
}
impl AddThingToBillingGroupOutput {
    /// Creates a new builder-style object to manufacture [`AddThingToBillingGroupOutput`](crate::output::AddThingToBillingGroupOutput)
    pub fn builder() -> crate::output::add_thing_to_billing_group_output::Builder {
        crate::output::add_thing_to_billing_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptCertificateTransferOutput {}
impl std::fmt::Debug for AcceptCertificateTransferOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptCertificateTransferOutput");
        formatter.finish()
    }
}
/// See [`AcceptCertificateTransferOutput`](crate::output::AcceptCertificateTransferOutput)
pub mod accept_certificate_transfer_output {
    /// A builder for [`AcceptCertificateTransferOutput`](crate::output::AcceptCertificateTransferOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AcceptCertificateTransferOutput`](crate::output::AcceptCertificateTransferOutput)
        pub fn build(self) -> crate::output::AcceptCertificateTransferOutput {
            crate::output::AcceptCertificateTransferOutput {}
        }
    }
}
impl AcceptCertificateTransferOutput {
    /// Creates a new builder-style object to manufacture [`AcceptCertificateTransferOutput`](crate::output::AcceptCertificateTransferOutput)
    pub fn builder() -> crate::output::accept_certificate_transfer_output::Builder {
        crate::output::accept_certificate_transfer_output::Builder::default()
    }
}
