// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT
///
/// Client for invoking operations on AWS IoT. Each operation on AWS IoT is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iot::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iot::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iot::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AcceptCertificateTransfer`](crate::client::fluent_builders::AcceptCertificateTransfer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::AcceptCertificateTransfer::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::AcceptCertificateTransfer::set_certificate_id): <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    ///   - [`set_as_active(bool)`](crate::client::fluent_builders::AcceptCertificateTransfer::set_as_active) / [`set_set_as_active(bool)`](crate::client::fluent_builders::AcceptCertificateTransfer::set_set_as_active): <p>Specifies whether the certificate is active.</p>
    /// - On success, responds with [`AcceptCertificateTransferOutput`](crate::output::AcceptCertificateTransferOutput)

    /// - On failure, responds with [`SdkError<AcceptCertificateTransferError>`](crate::error::AcceptCertificateTransferError)
    pub fn accept_certificate_transfer(
        &self,
    ) -> fluent_builders::AcceptCertificateTransfer<C, M, R> {
        fluent_builders::AcceptCertificateTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddThingToBillingGroup`](crate::client::fluent_builders::AddThingToBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::set_billing_group_name): <p>The name of the billing group.</p> <note>   <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>  </note>
    ///   - [`billing_group_arn(impl Into<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::billing_group_arn) / [`set_billing_group_arn(Option<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::set_billing_group_arn): <p>The ARN of the billing group.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::set_thing_name): <p>The name of the thing to be added to the billing group.</p>
    ///   - [`thing_arn(impl Into<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::thing_arn) / [`set_thing_arn(Option<String>)`](crate::client::fluent_builders::AddThingToBillingGroup::set_thing_arn): <p>The ARN of the thing to be added to the billing group.</p>
    /// - On success, responds with [`AddThingToBillingGroupOutput`](crate::output::AddThingToBillingGroupOutput)

    /// - On failure, responds with [`SdkError<AddThingToBillingGroupError>`](crate::error::AddThingToBillingGroupError)
    pub fn add_thing_to_billing_group(&self) -> fluent_builders::AddThingToBillingGroup<C, M, R> {
        fluent_builders::AddThingToBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddThingToThingGroup`](crate::client::fluent_builders::AddThingToThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::AddThingToThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::AddThingToThingGroup::set_thing_group_name): <p>The name of the group to which you are adding a thing.</p>
    ///   - [`thing_group_arn(impl Into<String>)`](crate::client::fluent_builders::AddThingToThingGroup::thing_group_arn) / [`set_thing_group_arn(Option<String>)`](crate::client::fluent_builders::AddThingToThingGroup::set_thing_group_arn): <p>The ARN of the group to which you are adding a thing.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::AddThingToThingGroup::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::AddThingToThingGroup::set_thing_name): <p>The name of the thing to add to a group.</p>
    ///   - [`thing_arn(impl Into<String>)`](crate::client::fluent_builders::AddThingToThingGroup::thing_arn) / [`set_thing_arn(Option<String>)`](crate::client::fluent_builders::AddThingToThingGroup::set_thing_arn): <p>The ARN of the thing to add to a group.</p>
    ///   - [`override_dynamic_groups(bool)`](crate::client::fluent_builders::AddThingToThingGroup::override_dynamic_groups) / [`set_override_dynamic_groups(bool)`](crate::client::fluent_builders::AddThingToThingGroup::set_override_dynamic_groups): <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
    /// - On success, responds with [`AddThingToThingGroupOutput`](crate::output::AddThingToThingGroupOutput)

    /// - On failure, responds with [`SdkError<AddThingToThingGroupError>`](crate::error::AddThingToThingGroupError)
    pub fn add_thing_to_thing_group(&self) -> fluent_builders::AddThingToThingGroup<C, M, R> {
        fluent_builders::AddThingToThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTargetsWithJob`](crate::client::fluent_builders::AssociateTargetsWithJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`targets(Vec<String>)`](crate::client::fluent_builders::AssociateTargetsWithJob::targets) / [`set_targets(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateTargetsWithJob::set_targets): <p>A list of thing group ARNs that define the targets of the job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTargetsWithJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::AssociateTargetsWithJob::set_job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::AssociateTargetsWithJob::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::AssociateTargetsWithJob::set_comment): <p>An optional comment string describing why the job was associated with the targets.</p>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTargetsWithJob::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::AssociateTargetsWithJob::set_namespace_id): <p>The namespace used to indicate that a job is a customer-managed job.</p>  <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>  <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>   <p>The <code>namespaceId</code> feature is in public preview.</p>  </note>
    /// - On success, responds with [`AssociateTargetsWithJobOutput`](crate::output::AssociateTargetsWithJobOutput) with field(s):
    ///   - [`job_arn(Option<String>)`](crate::output::AssociateTargetsWithJobOutput::job_arn): <p>An ARN identifying the job.</p>
    ///   - [`job_id(Option<String>)`](crate::output::AssociateTargetsWithJobOutput::job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    ///   - [`description(Option<String>)`](crate::output::AssociateTargetsWithJobOutput::description): <p>A short text description of the job.</p>
    /// - On failure, responds with [`SdkError<AssociateTargetsWithJobError>`](crate::error::AssociateTargetsWithJobError)
    pub fn associate_targets_with_job(&self) -> fluent_builders::AssociateTargetsWithJob<C, M, R> {
        fluent_builders::AssociateTargetsWithJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachPolicy`](crate::client::fluent_builders::AttachPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::AttachPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::AttachPolicy::set_policy_name): <p>The name of the policy to attach.</p>
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::AttachPolicy::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::AttachPolicy::set_target): <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
    /// - On success, responds with [`AttachPolicyOutput`](crate::output::AttachPolicyOutput)

    /// - On failure, responds with [`SdkError<AttachPolicyError>`](crate::error::AttachPolicyError)
    pub fn attach_policy(&self) -> fluent_builders::AttachPolicy<C, M, R> {
        fluent_builders::AttachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachPrincipalPolicy`](crate::client::fluent_builders::AttachPrincipalPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::AttachPrincipalPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::AttachPrincipalPolicy::set_policy_name): <p>The policy name.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::AttachPrincipalPolicy::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::AttachPrincipalPolicy::set_principal): <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
    /// - On success, responds with [`AttachPrincipalPolicyOutput`](crate::output::AttachPrincipalPolicyOutput)

    /// - On failure, responds with [`SdkError<AttachPrincipalPolicyError>`](crate::error::AttachPrincipalPolicyError)
    pub fn attach_principal_policy(&self) -> fluent_builders::AttachPrincipalPolicy<C, M, R> {
        fluent_builders::AttachPrincipalPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachSecurityProfile`](crate::client::fluent_builders::AttachSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::AttachSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::AttachSecurityProfile::set_security_profile_name): <p>The security profile that is attached.</p>
    ///   - [`security_profile_target_arn(impl Into<String>)`](crate::client::fluent_builders::AttachSecurityProfile::security_profile_target_arn) / [`set_security_profile_target_arn(Option<String>)`](crate::client::fluent_builders::AttachSecurityProfile::set_security_profile_target_arn): <p>The ARN of the target (thing group) to which the security profile is attached.</p>
    /// - On success, responds with [`AttachSecurityProfileOutput`](crate::output::AttachSecurityProfileOutput)

    /// - On failure, responds with [`SdkError<AttachSecurityProfileError>`](crate::error::AttachSecurityProfileError)
    pub fn attach_security_profile(&self) -> fluent_builders::AttachSecurityProfile<C, M, R> {
        fluent_builders::AttachSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachThingPrincipal`](crate::client::fluent_builders::AttachThingPrincipal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::AttachThingPrincipal::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::AttachThingPrincipal::set_thing_name): <p>The name of the thing.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::AttachThingPrincipal::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::AttachThingPrincipal::set_principal): <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
    /// - On success, responds with [`AttachThingPrincipalOutput`](crate::output::AttachThingPrincipalOutput)

    /// - On failure, responds with [`SdkError<AttachThingPrincipalError>`](crate::error::AttachThingPrincipalError)
    pub fn attach_thing_principal(&self) -> fluent_builders::AttachThingPrincipal<C, M, R> {
        fluent_builders::AttachThingPrincipal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelAuditMitigationActionsTask`](crate::client::fluent_builders::CancelAuditMitigationActionsTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::CancelAuditMitigationActionsTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::CancelAuditMitigationActionsTask::set_task_id): <p>The unique identifier for the task that you want to cancel. </p>
    /// - On success, responds with [`CancelAuditMitigationActionsTaskOutput`](crate::output::CancelAuditMitigationActionsTaskOutput)

    /// - On failure, responds with [`SdkError<CancelAuditMitigationActionsTaskError>`](crate::error::CancelAuditMitigationActionsTaskError)
    pub fn cancel_audit_mitigation_actions_task(
        &self,
    ) -> fluent_builders::CancelAuditMitigationActionsTask<C, M, R> {
        fluent_builders::CancelAuditMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelAuditTask`](crate::client::fluent_builders::CancelAuditTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::CancelAuditTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::CancelAuditTask::set_task_id): <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
    /// - On success, responds with [`CancelAuditTaskOutput`](crate::output::CancelAuditTaskOutput)

    /// - On failure, responds with [`SdkError<CancelAuditTaskError>`](crate::error::CancelAuditTaskError)
    pub fn cancel_audit_task(&self) -> fluent_builders::CancelAuditTask<C, M, R> {
        fluent_builders::CancelAuditTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelCertificateTransfer`](crate::client::fluent_builders::CancelCertificateTransfer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::CancelCertificateTransfer::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::CancelCertificateTransfer::set_certificate_id): <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    /// - On success, responds with [`CancelCertificateTransferOutput`](crate::output::CancelCertificateTransferOutput)

    /// - On failure, responds with [`SdkError<CancelCertificateTransferError>`](crate::error::CancelCertificateTransferError)
    pub fn cancel_certificate_transfer(
        &self,
    ) -> fluent_builders::CancelCertificateTransfer<C, M, R> {
        fluent_builders::CancelCertificateTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelDetectMitigationActionsTask`](crate::client::fluent_builders::CancelDetectMitigationActionsTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::CancelDetectMitigationActionsTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::CancelDetectMitigationActionsTask::set_task_id): <p> The unique identifier of the task. </p>
    /// - On success, responds with [`CancelDetectMitigationActionsTaskOutput`](crate::output::CancelDetectMitigationActionsTaskOutput)

    /// - On failure, responds with [`SdkError<CancelDetectMitigationActionsTaskError>`](crate::error::CancelDetectMitigationActionsTaskError)
    pub fn cancel_detect_mitigation_actions_task(
        &self,
    ) -> fluent_builders::CancelDetectMitigationActionsTask<C, M, R> {
        fluent_builders::CancelDetectMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelJob`](crate::client::fluent_builders::CancelJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelJob::set_job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    ///   - [`reason_code(impl Into<String>)`](crate::client::fluent_builders::CancelJob::reason_code) / [`set_reason_code(Option<String>)`](crate::client::fluent_builders::CancelJob::set_reason_code): <p>(Optional)A reason code string that explains why the job was canceled.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::CancelJob::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::CancelJob::set_comment): <p>An optional comment string describing why the job was canceled.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::CancelJob::force) / [`set_force(bool)`](crate::client::fluent_builders::CancelJob::set_force): <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>  <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
    /// - On success, responds with [`CancelJobOutput`](crate::output::CancelJobOutput) with field(s):
    ///   - [`job_arn(Option<String>)`](crate::output::CancelJobOutput::job_arn): <p>The job ARN.</p>
    ///   - [`job_id(Option<String>)`](crate::output::CancelJobOutput::job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    ///   - [`description(Option<String>)`](crate::output::CancelJobOutput::description): <p>A short text description of the job.</p>
    /// - On failure, responds with [`SdkError<CancelJobError>`](crate::error::CancelJobError)
    pub fn cancel_job(&self) -> fluent_builders::CancelJob<C, M, R> {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelJobExecution`](crate::client::fluent_builders::CancelJobExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelJobExecution::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelJobExecution::set_job_id): <p>The ID of the job to be canceled.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::CancelJobExecution::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::CancelJobExecution::set_thing_name): <p>The name of the thing whose execution of the job will be canceled.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::CancelJobExecution::force) / [`set_force(bool)`](crate::client::fluent_builders::CancelJobExecution::set_force): <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p>  <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::CancelJobExecution::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::CancelJobExecution::set_expected_version): <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
    ///   - [`status_details(HashMap<String, String>)`](crate::client::fluent_builders::CancelJobExecution::status_details) / [`set_status_details(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CancelJobExecution::set_status_details): <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
    /// - On success, responds with [`CancelJobExecutionOutput`](crate::output::CancelJobExecutionOutput)

    /// - On failure, responds with [`SdkError<CancelJobExecutionError>`](crate::error::CancelJobExecutionError)
    pub fn cancel_job_execution(&self) -> fluent_builders::CancelJobExecution<C, M, R> {
        fluent_builders::CancelJobExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ClearDefaultAuthorizer`](crate::client::fluent_builders::ClearDefaultAuthorizer) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ClearDefaultAuthorizer::send) it.

    /// - On success, responds with [`ClearDefaultAuthorizerOutput`](crate::output::ClearDefaultAuthorizerOutput)

    /// - On failure, responds with [`SdkError<ClearDefaultAuthorizerError>`](crate::error::ClearDefaultAuthorizerError)
    pub fn clear_default_authorizer(&self) -> fluent_builders::ClearDefaultAuthorizer<C, M, R> {
        fluent_builders::ClearDefaultAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmTopicRuleDestination`](crate::client::fluent_builders::ConfirmTopicRuleDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`confirmation_token(impl Into<String>)`](crate::client::fluent_builders::ConfirmTopicRuleDestination::confirmation_token) / [`set_confirmation_token(Option<String>)`](crate::client::fluent_builders::ConfirmTopicRuleDestination::set_confirmation_token): <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
    /// - On success, responds with [`ConfirmTopicRuleDestinationOutput`](crate::output::ConfirmTopicRuleDestinationOutput)

    /// - On failure, responds with [`SdkError<ConfirmTopicRuleDestinationError>`](crate::error::ConfirmTopicRuleDestinationError)
    pub fn confirm_topic_rule_destination(
        &self,
    ) -> fluent_builders::ConfirmTopicRuleDestination<C, M, R> {
        fluent_builders::ConfirmTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAuditSuppression`](crate::client::fluent_builders::CreateAuditSuppression) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_name(impl Into<String>)`](crate::client::fluent_builders::CreateAuditSuppression::check_name) / [`set_check_name(Option<String>)`](crate::client::fluent_builders::CreateAuditSuppression::set_check_name): <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`resource_identifier(ResourceIdentifier)`](crate::client::fluent_builders::CreateAuditSuppression::resource_identifier) / [`set_resource_identifier(Option<ResourceIdentifier>)`](crate::client::fluent_builders::CreateAuditSuppression::set_resource_identifier): <p>Information that identifies the noncompliant resource.</p>
    ///   - [`expiration_date(DateTime)`](crate::client::fluent_builders::CreateAuditSuppression::expiration_date) / [`set_expiration_date(Option<DateTime>)`](crate::client::fluent_builders::CreateAuditSuppression::set_expiration_date): <p> The epoch timestamp in seconds at which this suppression expires. </p>
    ///   - [`suppress_indefinitely(bool)`](crate::client::fluent_builders::CreateAuditSuppression::suppress_indefinitely) / [`set_suppress_indefinitely(Option<bool>)`](crate::client::fluent_builders::CreateAuditSuppression::set_suppress_indefinitely): <p> Indicates whether a suppression should exist indefinitely or not. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAuditSuppression::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAuditSuppression::set_description): <p> The description of the audit suppression. </p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateAuditSuppression::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateAuditSuppression::set_client_request_token): <p> Each audit supression must have a unique client request token. If you try to create a new audit suppression with the same token as one that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
    /// - On success, responds with [`CreateAuditSuppressionOutput`](crate::output::CreateAuditSuppressionOutput)

    /// - On failure, responds with [`SdkError<CreateAuditSuppressionError>`](crate::error::CreateAuditSuppressionError)
    pub fn create_audit_suppression(&self) -> fluent_builders::CreateAuditSuppression<C, M, R> {
        fluent_builders::CreateAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAuthorizer`](crate::client::fluent_builders::CreateAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorizer_name(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_name) / [`set_authorizer_name(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_name): <p>The authorizer name.</p>
    ///   - [`authorizer_function_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::authorizer_function_arn) / [`set_authorizer_function_arn(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_authorizer_function_arn): <p>The ARN of the authorizer's Lambda function.</p>
    ///   - [`token_key_name(impl Into<String>)`](crate::client::fluent_builders::CreateAuthorizer::token_key_name) / [`set_token_key_name(Option<String>)`](crate::client::fluent_builders::CreateAuthorizer::set_token_key_name): <p>The name of the token key used to extract the token from the HTTP headers.</p>
    ///   - [`token_signing_public_keys(HashMap<String, String>)`](crate::client::fluent_builders::CreateAuthorizer::token_signing_public_keys) / [`set_token_signing_public_keys(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAuthorizer::set_token_signing_public_keys): <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
    ///   - [`status(AuthorizerStatus)`](crate::client::fluent_builders::CreateAuthorizer::status) / [`set_status(Option<AuthorizerStatus>)`](crate::client::fluent_builders::CreateAuthorizer::set_status): <p>The status of the create authorizer request.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAuthorizer::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAuthorizer::set_tags): <p>Metadata which can be used to manage the custom authorizer.</p> <note>   <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>   <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>   <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>  </note>
    ///   - [`signing_disabled(bool)`](crate::client::fluent_builders::CreateAuthorizer::signing_disabled) / [`set_signing_disabled(Option<bool>)`](crate::client::fluent_builders::CreateAuthorizer::set_signing_disabled): <p>Specifies whether IoT validates the token signature in an authorization request.</p>
    ///   - [`enable_caching_for_http(bool)`](crate::client::fluent_builders::CreateAuthorizer::enable_caching_for_http) / [`set_enable_caching_for_http(Option<bool>)`](crate::client::fluent_builders::CreateAuthorizer::set_enable_caching_for_http): <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT connections.</p>  <p>The default value is <code>false</code>.</p>
    /// - On success, responds with [`CreateAuthorizerOutput`](crate::output::CreateAuthorizerOutput) with field(s):
    ///   - [`authorizer_name(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_name): <p>The authorizer's name.</p>
    ///   - [`authorizer_arn(Option<String>)`](crate::output::CreateAuthorizerOutput::authorizer_arn): <p>The authorizer ARN.</p>
    /// - On failure, responds with [`SdkError<CreateAuthorizerError>`](crate::error::CreateAuthorizerError)
    pub fn create_authorizer(&self) -> fluent_builders::CreateAuthorizer<C, M, R> {
        fluent_builders::CreateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBillingGroup`](crate::client::fluent_builders::CreateBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateBillingGroup::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::CreateBillingGroup::set_billing_group_name): <p>The name you wish to give to the billing group.</p>
    ///   - [`billing_group_properties(BillingGroupProperties)`](crate::client::fluent_builders::CreateBillingGroup::billing_group_properties) / [`set_billing_group_properties(Option<BillingGroupProperties>)`](crate::client::fluent_builders::CreateBillingGroup::set_billing_group_properties): <p>The properties of the billing group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateBillingGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateBillingGroup::set_tags): <p>Metadata which can be used to manage the billing group.</p>
    /// - On success, responds with [`CreateBillingGroupOutput`](crate::output::CreateBillingGroupOutput) with field(s):
    ///   - [`billing_group_name(Option<String>)`](crate::output::CreateBillingGroupOutput::billing_group_name): <p>The name you gave to the billing group.</p>
    ///   - [`billing_group_arn(Option<String>)`](crate::output::CreateBillingGroupOutput::billing_group_arn): <p>The ARN of the billing group.</p>
    ///   - [`billing_group_id(Option<String>)`](crate::output::CreateBillingGroupOutput::billing_group_id): <p>The ID of the billing group.</p>
    /// - On failure, responds with [`SdkError<CreateBillingGroupError>`](crate::error::CreateBillingGroupError)
    pub fn create_billing_group(&self) -> fluent_builders::CreateBillingGroup<C, M, R> {
        fluent_builders::CreateBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCertificateFromCsr`](crate::client::fluent_builders::CreateCertificateFromCsr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_signing_request(impl Into<String>)`](crate::client::fluent_builders::CreateCertificateFromCsr::certificate_signing_request) / [`set_certificate_signing_request(Option<String>)`](crate::client::fluent_builders::CreateCertificateFromCsr::set_certificate_signing_request): <p>The certificate signing request (CSR).</p>
    ///   - [`set_as_active(bool)`](crate::client::fluent_builders::CreateCertificateFromCsr::set_as_active) / [`set_set_as_active(bool)`](crate::client::fluent_builders::CreateCertificateFromCsr::set_set_as_active): <p>Specifies whether the certificate is active.</p>
    /// - On success, responds with [`CreateCertificateFromCsrOutput`](crate::output::CreateCertificateFromCsrOutput) with field(s):
    ///   - [`certificate_arn(Option<String>)`](crate::output::CreateCertificateFromCsrOutput::certificate_arn): <p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>
    ///   - [`certificate_id(Option<String>)`](crate::output::CreateCertificateFromCsrOutput::certificate_id): <p>The ID of the certificate. Certificate management operations only take a certificateId.</p>
    ///   - [`certificate_pem(Option<String>)`](crate::output::CreateCertificateFromCsrOutput::certificate_pem): <p>The certificate data, in PEM format.</p>
    /// - On failure, responds with [`SdkError<CreateCertificateFromCsrError>`](crate::error::CreateCertificateFromCsrError)
    pub fn create_certificate_from_csr(
        &self,
    ) -> fluent_builders::CreateCertificateFromCsr<C, M, R> {
        fluent_builders::CreateCertificateFromCsr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomMetric`](crate::client::fluent_builders::CreateCustomMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::CreateCustomMetric::set_metric_name): <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomMetric::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateCustomMetric::set_display_name): <p> Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated once defined.</p>
    ///   - [`metric_type(CustomMetricType)`](crate::client::fluent_builders::CreateCustomMetric::metric_type) / [`set_metric_type(Option<CustomMetricType>)`](crate::client::fluent_builders::CreateCustomMetric::set_metric_type): <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCustomMetric::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCustomMetric::set_tags): <p> Metadata that can be used to manage the custom metric. </p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateCustomMetric::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateCustomMetric::set_client_request_token): <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
    /// - On success, responds with [`CreateCustomMetricOutput`](crate::output::CreateCustomMetricOutput) with field(s):
    ///   - [`metric_name(Option<String>)`](crate::output::CreateCustomMetricOutput::metric_name): <p> The name of the custom metric to be used in the metric report. </p>
    ///   - [`metric_arn(Option<String>)`](crate::output::CreateCustomMetricOutput::metric_arn): <p> The Amazon Resource Number (ARN) of the custom metric, e.g. <code>arn:<i>aws-partition</i>:iot:<i>region</i>:<i>accountId</i>:custommetric/<i>metricName</i> </code> </p>
    /// - On failure, responds with [`SdkError<CreateCustomMetricError>`](crate::error::CreateCustomMetricError)
    pub fn create_custom_metric(&self) -> fluent_builders::CreateCustomMetric<C, M, R> {
        fluent_builders::CreateCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDimension`](crate::client::fluent_builders::CreateDimension) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDimension::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDimension::set_name): <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
    ///   - [`r#type(DimensionType)`](crate::client::fluent_builders::CreateDimension::r#type) / [`set_type(Option<DimensionType>)`](crate::client::fluent_builders::CreateDimension::set_type): <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
    ///   - [`string_values(Vec<String>)`](crate::client::fluent_builders::CreateDimension::string_values) / [`set_string_values(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDimension::set_string_values): <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDimension::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDimension::set_tags): <p>Metadata that can be used to manage the dimension.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateDimension::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateDimension::set_client_request_token): <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
    /// - On success, responds with [`CreateDimensionOutput`](crate::output::CreateDimensionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateDimensionOutput::name): <p>A unique identifier for the dimension.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateDimensionOutput::arn): <p>The Amazon Resource Name (ARN) of the created dimension.</p>
    /// - On failure, responds with [`SdkError<CreateDimensionError>`](crate::error::CreateDimensionError)
    pub fn create_dimension(&self) -> fluent_builders::CreateDimension<C, M, R> {
        fluent_builders::CreateDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomainConfiguration`](crate::client::fluent_builders::CreateDomainConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_configuration_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainConfiguration::domain_configuration_name) / [`set_domain_configuration_name(Option<String>)`](crate::client::fluent_builders::CreateDomainConfiguration::set_domain_configuration_name): <p>The name of the domain configuration. This value must be unique to a region.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainConfiguration::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateDomainConfiguration::set_domain_name): <p>The name of the domain.</p>
    ///   - [`server_certificate_arns(Vec<String>)`](crate::client::fluent_builders::CreateDomainConfiguration::server_certificate_arns) / [`set_server_certificate_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDomainConfiguration::set_server_certificate_arns): <p>The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.</p>
    ///   - [`validation_certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDomainConfiguration::validation_certificate_arn) / [`set_validation_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateDomainConfiguration::set_validation_certificate_arn): <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.</p>
    ///   - [`authorizer_config(AuthorizerConfig)`](crate::client::fluent_builders::CreateDomainConfiguration::authorizer_config) / [`set_authorizer_config(Option<AuthorizerConfig>)`](crate::client::fluent_builders::CreateDomainConfiguration::set_authorizer_config): <p>An object that specifies the authorization service for a domain.</p>
    ///   - [`service_type(ServiceType)`](crate::client::fluent_builders::CreateDomainConfiguration::service_type) / [`set_service_type(Option<ServiceType>)`](crate::client::fluent_builders::CreateDomainConfiguration::set_service_type): <p>The type of service delivered by the endpoint.</p> <note>   <p>Amazon Web Services IoT Core currently supports only the <code>DATA</code> service type.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDomainConfiguration::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDomainConfiguration::set_tags): <p>Metadata which can be used to manage the domain configuration.</p> <note>   <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>   <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>   <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>  </note>
    /// - On success, responds with [`CreateDomainConfigurationOutput`](crate::output::CreateDomainConfigurationOutput) with field(s):
    ///   - [`domain_configuration_name(Option<String>)`](crate::output::CreateDomainConfigurationOutput::domain_configuration_name): <p>The name of the domain configuration.</p>
    ///   - [`domain_configuration_arn(Option<String>)`](crate::output::CreateDomainConfigurationOutput::domain_configuration_arn): <p>The ARN of the domain configuration.</p>
    /// - On failure, responds with [`SdkError<CreateDomainConfigurationError>`](crate::error::CreateDomainConfigurationError)
    pub fn create_domain_configuration(
        &self,
    ) -> fluent_builders::CreateDomainConfiguration<C, M, R> {
        fluent_builders::CreateDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDynamicThingGroup`](crate::client::fluent_builders::CreateDynamicThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::set_thing_group_name): <p>The dynamic thing group name to create.</p>
    ///   - [`thing_group_properties(ThingGroupProperties)`](crate::client::fluent_builders::CreateDynamicThingGroup::thing_group_properties) / [`set_thing_group_properties(Option<ThingGroupProperties>)`](crate::client::fluent_builders::CreateDynamicThingGroup::set_thing_group_properties): <p>The dynamic thing group properties.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::set_index_name): <p>The dynamic thing group index name.</p> <note>   <p>Currently one index is supported: <code>AWS_Things</code>.</p>  </note>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::set_query_string): <p>The dynamic thing group search query string.</p>  <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::CreateDynamicThingGroup::set_query_version): <p>The dynamic thing group query version.</p> <note>   <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDynamicThingGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDynamicThingGroup::set_tags): <p>Metadata which can be used to manage the dynamic thing group.</p>
    /// - On success, responds with [`CreateDynamicThingGroupOutput`](crate::output::CreateDynamicThingGroupOutput) with field(s):
    ///   - [`thing_group_name(Option<String>)`](crate::output::CreateDynamicThingGroupOutput::thing_group_name): <p>The dynamic thing group name.</p>
    ///   - [`thing_group_arn(Option<String>)`](crate::output::CreateDynamicThingGroupOutput::thing_group_arn): <p>The dynamic thing group ARN.</p>
    ///   - [`thing_group_id(Option<String>)`](crate::output::CreateDynamicThingGroupOutput::thing_group_id): <p>The dynamic thing group ID.</p>
    ///   - [`index_name(Option<String>)`](crate::output::CreateDynamicThingGroupOutput::index_name): <p>The dynamic thing group index name.</p>
    ///   - [`query_string(Option<String>)`](crate::output::CreateDynamicThingGroupOutput::query_string): <p>The dynamic thing group search query string.</p>
    ///   - [`query_version(Option<String>)`](crate::output::CreateDynamicThingGroupOutput::query_version): <p>The dynamic thing group query version.</p>
    /// - On failure, responds with [`SdkError<CreateDynamicThingGroupError>`](crate::error::CreateDynamicThingGroupError)
    pub fn create_dynamic_thing_group(&self) -> fluent_builders::CreateDynamicThingGroup<C, M, R> {
        fluent_builders::CreateDynamicThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFleetMetric`](crate::client::fluent_builders::CreateFleetMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::CreateFleetMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::CreateFleetMetric::set_metric_name): <p>The name of the fleet metric to create.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::CreateFleetMetric::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::CreateFleetMetric::set_query_string): <p>The search query string.</p>
    ///   - [`aggregation_type(AggregationType)`](crate::client::fluent_builders::CreateFleetMetric::aggregation_type) / [`set_aggregation_type(Option<AggregationType>)`](crate::client::fluent_builders::CreateFleetMetric::set_aggregation_type): <p>The type of the aggregation query.</p>
    ///   - [`period(i32)`](crate::client::fluent_builders::CreateFleetMetric::period) / [`set_period(Option<i32>)`](crate::client::fluent_builders::CreateFleetMetric::set_period): <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
    ///   - [`aggregation_field(impl Into<String>)`](crate::client::fluent_builders::CreateFleetMetric::aggregation_field) / [`set_aggregation_field(Option<String>)`](crate::client::fluent_builders::CreateFleetMetric::set_aggregation_field): <p>The field to aggregate.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFleetMetric::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFleetMetric::set_description): <p>The fleet metric description.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::CreateFleetMetric::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::CreateFleetMetric::set_query_version): <p>The query version.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::CreateFleetMetric::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::CreateFleetMetric::set_index_name): <p>The name of the index to search.</p>
    ///   - [`unit(FleetMetricUnit)`](crate::client::fluent_builders::CreateFleetMetric::unit) / [`set_unit(Option<FleetMetricUnit>)`](crate::client::fluent_builders::CreateFleetMetric::set_unit): <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>. Default to null.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFleetMetric::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFleetMetric::set_tags): <p>Metadata, which can be used to manage the fleet metric.</p>
    /// - On success, responds with [`CreateFleetMetricOutput`](crate::output::CreateFleetMetricOutput) with field(s):
    ///   - [`metric_name(Option<String>)`](crate::output::CreateFleetMetricOutput::metric_name): <p>The name of the fleet metric to create.</p>
    ///   - [`metric_arn(Option<String>)`](crate::output::CreateFleetMetricOutput::metric_arn): <p>The Amazon Resource Name (ARN) of the new fleet metric.</p>
    /// - On failure, responds with [`SdkError<CreateFleetMetricError>`](crate::error::CreateFleetMetricError)
    pub fn create_fleet_metric(&self) -> fluent_builders::CreateFleetMetric<C, M, R> {
        fluent_builders::CreateFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJob`](crate::client::fluent_builders::CreateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_job_id): <p>A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
    ///   - [`targets(Vec<String>)`](crate::client::fluent_builders::CreateJob::targets) / [`set_targets(Option<Vec<String>>)`](crate::client::fluent_builders::CreateJob::set_targets): <p>A list of things and thing groups to which the job should be sent.</p>
    ///   - [`document_source(impl Into<String>)`](crate::client::fluent_builders::CreateJob::document_source) / [`set_document_source(Option<String>)`](crate::client::fluent_builders::CreateJob::set_document_source): <p>An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p> <note>   <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>   <p>The placeholder link is of the following form:</p>   <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>   <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>  </note>
    ///   - [`document(impl Into<String>)`](crate::client::fluent_builders::CreateJob::document) / [`set_document(Option<String>)`](crate::client::fluent_builders::CreateJob::set_document): <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateJob::set_description): <p>A short text description of the job.</p>
    ///   - [`presigned_url_config(PresignedUrlConfig)`](crate::client::fluent_builders::CreateJob::presigned_url_config) / [`set_presigned_url_config(Option<PresignedUrlConfig>)`](crate::client::fluent_builders::CreateJob::set_presigned_url_config): <p>Configuration information for pre-signed S3 URLs.</p>
    ///   - [`target_selection(TargetSelection)`](crate::client::fluent_builders::CreateJob::target_selection) / [`set_target_selection(Option<TargetSelection>)`](crate::client::fluent_builders::CreateJob::set_target_selection): <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
    ///   - [`job_executions_rollout_config(JobExecutionsRolloutConfig)`](crate::client::fluent_builders::CreateJob::job_executions_rollout_config) / [`set_job_executions_rollout_config(Option<JobExecutionsRolloutConfig>)`](crate::client::fluent_builders::CreateJob::set_job_executions_rollout_config): <p>Allows you to create a staged rollout of the job.</p>
    ///   - [`abort_config(AbortConfig)`](crate::client::fluent_builders::CreateJob::abort_config) / [`set_abort_config(Option<AbortConfig>)`](crate::client::fluent_builders::CreateJob::set_abort_config): <p>Allows you to create the criteria to abort a job.</p>
    ///   - [`timeout_config(TimeoutConfig)`](crate::client::fluent_builders::CreateJob::timeout_config) / [`set_timeout_config(Option<TimeoutConfig>)`](crate::client::fluent_builders::CreateJob::set_timeout_config): <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateJob::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateJob::set_tags): <p>Metadata which can be used to manage the job.</p>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_namespace_id): <p>The namespace used to indicate that a job is a customer-managed job.</p>  <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>  <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>   <p>The <code>namespaceId</code> feature is in public preview.</p>  </note>
    ///   - [`job_template_arn(impl Into<String>)`](crate::client::fluent_builders::CreateJob::job_template_arn) / [`set_job_template_arn(Option<String>)`](crate::client::fluent_builders::CreateJob::set_job_template_arn): <p>The ARN of the job template used to create the job.</p>
    ///   - [`job_executions_retry_config(JobExecutionsRetryConfig)`](crate::client::fluent_builders::CreateJob::job_executions_retry_config) / [`set_job_executions_retry_config(Option<JobExecutionsRetryConfig>)`](crate::client::fluent_builders::CreateJob::set_job_executions_retry_config): <p>Allows you to create the criteria to retry a job.</p>
    ///   - [`document_parameters(HashMap<String, String>)`](crate::client::fluent_builders::CreateJob::document_parameters) / [`set_document_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateJob::set_document_parameters): <p>Parameters of a managed template that you can specify to create the job document.</p>
    /// - On success, responds with [`CreateJobOutput`](crate::output::CreateJobOutput) with field(s):
    ///   - [`job_arn(Option<String>)`](crate::output::CreateJobOutput::job_arn): <p>The job ARN.</p>
    ///   - [`job_id(Option<String>)`](crate::output::CreateJobOutput::job_id): <p>The unique identifier you assigned to this job.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateJobOutput::description): <p>The job description.</p>
    /// - On failure, responds with [`SdkError<CreateJobError>`](crate::error::CreateJobError)
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJobTemplate`](crate::client::fluent_builders::CreateJobTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_template_id(impl Into<String>)`](crate::client::fluent_builders::CreateJobTemplate::job_template_id) / [`set_job_template_id(Option<String>)`](crate::client::fluent_builders::CreateJobTemplate::set_job_template_id): <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
    ///   - [`job_arn(impl Into<String>)`](crate::client::fluent_builders::CreateJobTemplate::job_arn) / [`set_job_arn(Option<String>)`](crate::client::fluent_builders::CreateJobTemplate::set_job_arn): <p>The ARN of the job to use as the basis for the job template.</p>
    ///   - [`document_source(impl Into<String>)`](crate::client::fluent_builders::CreateJobTemplate::document_source) / [`set_document_source(Option<String>)`](crate::client::fluent_builders::CreateJobTemplate::set_document_source): <p>An S3 link to the job document to use in the template. Required if you don't specify a value for <code>document</code>.</p> <note>   <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>   <p>The placeholder link is of the following form:</p>   <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>   <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>  </note>
    ///   - [`document(impl Into<String>)`](crate::client::fluent_builders::CreateJobTemplate::document) / [`set_document(Option<String>)`](crate::client::fluent_builders::CreateJobTemplate::set_document): <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateJobTemplate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateJobTemplate::set_description): <p>A description of the job document.</p>
    ///   - [`presigned_url_config(PresignedUrlConfig)`](crate::client::fluent_builders::CreateJobTemplate::presigned_url_config) / [`set_presigned_url_config(Option<PresignedUrlConfig>)`](crate::client::fluent_builders::CreateJobTemplate::set_presigned_url_config): <p>Configuration for pre-signed S3 URLs.</p>
    ///   - [`job_executions_rollout_config(JobExecutionsRolloutConfig)`](crate::client::fluent_builders::CreateJobTemplate::job_executions_rollout_config) / [`set_job_executions_rollout_config(Option<JobExecutionsRolloutConfig>)`](crate::client::fluent_builders::CreateJobTemplate::set_job_executions_rollout_config): <p>Allows you to create a staged rollout of a job.</p>
    ///   - [`abort_config(AbortConfig)`](crate::client::fluent_builders::CreateJobTemplate::abort_config) / [`set_abort_config(Option<AbortConfig>)`](crate::client::fluent_builders::CreateJobTemplate::set_abort_config): <p>The criteria that determine when and how a job abort takes place.</p>
    ///   - [`timeout_config(TimeoutConfig)`](crate::client::fluent_builders::CreateJobTemplate::timeout_config) / [`set_timeout_config(Option<TimeoutConfig>)`](crate::client::fluent_builders::CreateJobTemplate::set_timeout_config): <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateJobTemplate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateJobTemplate::set_tags): <p>Metadata that can be used to manage the job template.</p>
    ///   - [`job_executions_retry_config(JobExecutionsRetryConfig)`](crate::client::fluent_builders::CreateJobTemplate::job_executions_retry_config) / [`set_job_executions_retry_config(Option<JobExecutionsRetryConfig>)`](crate::client::fluent_builders::CreateJobTemplate::set_job_executions_retry_config): <p>Allows you to create the criteria to retry a job.</p>
    /// - On success, responds with [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput) with field(s):
    ///   - [`job_template_arn(Option<String>)`](crate::output::CreateJobTemplateOutput::job_template_arn): <p>The ARN of the job template.</p>
    ///   - [`job_template_id(Option<String>)`](crate::output::CreateJobTemplateOutput::job_template_id): <p>The unique identifier of the job template.</p>
    /// - On failure, responds with [`SdkError<CreateJobTemplateError>`](crate::error::CreateJobTemplateError)
    pub fn create_job_template(&self) -> fluent_builders::CreateJobTemplate<C, M, R> {
        fluent_builders::CreateJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateKeysAndCertificate`](crate::client::fluent_builders::CreateKeysAndCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`set_as_active(bool)`](crate::client::fluent_builders::CreateKeysAndCertificate::set_as_active) / [`set_set_as_active(bool)`](crate::client::fluent_builders::CreateKeysAndCertificate::set_set_as_active): <p>Specifies whether the certificate is active.</p>
    /// - On success, responds with [`CreateKeysAndCertificateOutput`](crate::output::CreateKeysAndCertificateOutput) with field(s):
    ///   - [`certificate_arn(Option<String>)`](crate::output::CreateKeysAndCertificateOutput::certificate_arn): <p>The ARN of the certificate.</p>
    ///   - [`certificate_id(Option<String>)`](crate::output::CreateKeysAndCertificateOutput::certificate_id): <p>The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT Certificate).</p>
    ///   - [`certificate_pem(Option<String>)`](crate::output::CreateKeysAndCertificateOutput::certificate_pem): <p>The certificate data, in PEM format.</p>
    ///   - [`key_pair(Option<KeyPair>)`](crate::output::CreateKeysAndCertificateOutput::key_pair): <p>The generated key pair.</p>
    /// - On failure, responds with [`SdkError<CreateKeysAndCertificateError>`](crate::error::CreateKeysAndCertificateError)
    pub fn create_keys_and_certificate(
        &self,
    ) -> fluent_builders::CreateKeysAndCertificate<C, M, R> {
        fluent_builders::CreateKeysAndCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMitigationAction`](crate::client::fluent_builders::CreateMitigationAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_name(impl Into<String>)`](crate::client::fluent_builders::CreateMitigationAction::action_name) / [`set_action_name(Option<String>)`](crate::client::fluent_builders::CreateMitigationAction::set_action_name): <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateMitigationAction::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateMitigationAction::set_role_arn): <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
    ///   - [`action_params(MitigationActionParams)`](crate::client::fluent_builders::CreateMitigationAction::action_params) / [`set_action_params(Option<MitigationActionParams>)`](crate::client::fluent_builders::CreateMitigationAction::set_action_params): <p>Defines the type of action and the parameters for that action.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateMitigationAction::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateMitigationAction::set_tags): <p>Metadata that can be used to manage the mitigation action.</p>
    /// - On success, responds with [`CreateMitigationActionOutput`](crate::output::CreateMitigationActionOutput) with field(s):
    ///   - [`action_arn(Option<String>)`](crate::output::CreateMitigationActionOutput::action_arn): <p>The ARN for the new mitigation action.</p>
    ///   - [`action_id(Option<String>)`](crate::output::CreateMitigationActionOutput::action_id): <p>A unique identifier for the new mitigation action.</p>
    /// - On failure, responds with [`SdkError<CreateMitigationActionError>`](crate::error::CreateMitigationActionError)
    pub fn create_mitigation_action(&self) -> fluent_builders::CreateMitigationAction<C, M, R> {
        fluent_builders::CreateMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOTAUpdate`](crate::client::fluent_builders::CreateOTAUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ota_update_id(impl Into<String>)`](crate::client::fluent_builders::CreateOTAUpdate::ota_update_id) / [`set_ota_update_id(Option<String>)`](crate::client::fluent_builders::CreateOTAUpdate::set_ota_update_id): <p>The ID of the OTA update to be created.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateOTAUpdate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateOTAUpdate::set_description): <p>The description of the OTA update.</p>
    ///   - [`targets(Vec<String>)`](crate::client::fluent_builders::CreateOTAUpdate::targets) / [`set_targets(Option<Vec<String>>)`](crate::client::fluent_builders::CreateOTAUpdate::set_targets): <p>The devices targeted to receive OTA updates.</p>
    ///   - [`protocols(Vec<Protocol>)`](crate::client::fluent_builders::CreateOTAUpdate::protocols) / [`set_protocols(Option<Vec<Protocol>>)`](crate::client::fluent_builders::CreateOTAUpdate::set_protocols): <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
    ///   - [`target_selection(TargetSelection)`](crate::client::fluent_builders::CreateOTAUpdate::target_selection) / [`set_target_selection(Option<TargetSelection>)`](crate::client::fluent_builders::CreateOTAUpdate::set_target_selection): <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
    ///   - [`aws_job_executions_rollout_config(AwsJobExecutionsRolloutConfig)`](crate::client::fluent_builders::CreateOTAUpdate::aws_job_executions_rollout_config) / [`set_aws_job_executions_rollout_config(Option<AwsJobExecutionsRolloutConfig>)`](crate::client::fluent_builders::CreateOTAUpdate::set_aws_job_executions_rollout_config): <p>Configuration for the rollout of OTA updates.</p>
    ///   - [`aws_job_presigned_url_config(AwsJobPresignedUrlConfig)`](crate::client::fluent_builders::CreateOTAUpdate::aws_job_presigned_url_config) / [`set_aws_job_presigned_url_config(Option<AwsJobPresignedUrlConfig>)`](crate::client::fluent_builders::CreateOTAUpdate::set_aws_job_presigned_url_config): <p>Configuration information for pre-signed URLs.</p>
    ///   - [`aws_job_abort_config(AwsJobAbortConfig)`](crate::client::fluent_builders::CreateOTAUpdate::aws_job_abort_config) / [`set_aws_job_abort_config(Option<AwsJobAbortConfig>)`](crate::client::fluent_builders::CreateOTAUpdate::set_aws_job_abort_config): <p>The criteria that determine when and how a job abort takes place.</p>
    ///   - [`aws_job_timeout_config(AwsJobTimeoutConfig)`](crate::client::fluent_builders::CreateOTAUpdate::aws_job_timeout_config) / [`set_aws_job_timeout_config(Option<AwsJobTimeoutConfig>)`](crate::client::fluent_builders::CreateOTAUpdate::set_aws_job_timeout_config): <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    ///   - [`files(Vec<OtaUpdateFile>)`](crate::client::fluent_builders::CreateOTAUpdate::files) / [`set_files(Option<Vec<OtaUpdateFile>>)`](crate::client::fluent_builders::CreateOTAUpdate::set_files): <p>The files to be streamed by the OTA update.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateOTAUpdate::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateOTAUpdate::set_role_arn): <p>The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.</p>
    ///   - [`additional_parameters(HashMap<String, String>)`](crate::client::fluent_builders::CreateOTAUpdate::additional_parameters) / [`set_additional_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateOTAUpdate::set_additional_parameters): <p>A list of additional OTA update parameters which are name-value pairs.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateOTAUpdate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateOTAUpdate::set_tags): <p>Metadata which can be used to manage updates.</p>
    /// - On success, responds with [`CreateOtaUpdateOutput`](crate::output::CreateOtaUpdateOutput) with field(s):
    ///   - [`ota_update_id(Option<String>)`](crate::output::CreateOtaUpdateOutput::ota_update_id): <p>The OTA update ID.</p>
    ///   - [`aws_iot_job_id(Option<String>)`](crate::output::CreateOtaUpdateOutput::aws_iot_job_id): <p>The IoT job ID associated with the OTA update.</p>
    ///   - [`ota_update_arn(Option<String>)`](crate::output::CreateOtaUpdateOutput::ota_update_arn): <p>The OTA update ARN.</p>
    ///   - [`aws_iot_job_arn(Option<String>)`](crate::output::CreateOtaUpdateOutput::aws_iot_job_arn): <p>The IoT job ARN associated with the OTA update.</p>
    ///   - [`ota_update_status(Option<OtaUpdateStatus>)`](crate::output::CreateOtaUpdateOutput::ota_update_status): <p>The OTA update status.</p>
    /// - On failure, responds with [`SdkError<CreateOTAUpdateError>`](crate::error::CreateOTAUpdateError)
    pub fn create_ota_update(&self) -> fluent_builders::CreateOTAUpdate<C, M, R> {
        fluent_builders::CreateOTAUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePolicy`](crate::client::fluent_builders::CreatePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::CreatePolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::CreatePolicy::set_policy_name): <p>The policy name.</p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::CreatePolicy::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::CreatePolicy::set_policy_document): <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePolicy::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePolicy::set_tags): <p>Metadata which can be used to manage the policy.</p> <note>   <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>   <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>   <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>  </note>
    /// - On success, responds with [`CreatePolicyOutput`](crate::output::CreatePolicyOutput) with field(s):
    ///   - [`policy_name(Option<String>)`](crate::output::CreatePolicyOutput::policy_name): <p>The policy name.</p>
    ///   - [`policy_arn(Option<String>)`](crate::output::CreatePolicyOutput::policy_arn): <p>The policy ARN.</p>
    ///   - [`policy_document(Option<String>)`](crate::output::CreatePolicyOutput::policy_document): <p>The JSON document that describes the policy.</p>
    ///   - [`policy_version_id(Option<String>)`](crate::output::CreatePolicyOutput::policy_version_id): <p>The policy version ID.</p>
    /// - On failure, responds with [`SdkError<CreatePolicyError>`](crate::error::CreatePolicyError)
    pub fn create_policy(&self) -> fluent_builders::CreatePolicy<C, M, R> {
        fluent_builders::CreatePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePolicyVersion`](crate::client::fluent_builders::CreatePolicyVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::CreatePolicyVersion::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::CreatePolicyVersion::set_policy_name): <p>The policy name.</p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::CreatePolicyVersion::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::CreatePolicyVersion::set_policy_document): <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
    ///   - [`set_as_default(bool)`](crate::client::fluent_builders::CreatePolicyVersion::set_as_default) / [`set_set_as_default(bool)`](crate::client::fluent_builders::CreatePolicyVersion::set_set_as_default): <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
    /// - On success, responds with [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput) with field(s):
    ///   - [`policy_arn(Option<String>)`](crate::output::CreatePolicyVersionOutput::policy_arn): <p>The policy ARN.</p>
    ///   - [`policy_document(Option<String>)`](crate::output::CreatePolicyVersionOutput::policy_document): <p>The JSON document that describes the policy.</p>
    ///   - [`policy_version_id(Option<String>)`](crate::output::CreatePolicyVersionOutput::policy_version_id): <p>The policy version ID.</p>
    ///   - [`is_default_version(bool)`](crate::output::CreatePolicyVersionOutput::is_default_version): <p>Specifies whether the policy version is the default.</p>
    /// - On failure, responds with [`SdkError<CreatePolicyVersionError>`](crate::error::CreatePolicyVersionError)
    pub fn create_policy_version(&self) -> fluent_builders::CreatePolicyVersion<C, M, R> {
        fluent_builders::CreatePolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProvisioningClaim`](crate::client::fluent_builders::CreateProvisioningClaim) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningClaim::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateProvisioningClaim::set_template_name): <p>The name of the provisioning template to use.</p>
    /// - On success, responds with [`CreateProvisioningClaimOutput`](crate::output::CreateProvisioningClaimOutput) with field(s):
    ///   - [`certificate_id(Option<String>)`](crate::output::CreateProvisioningClaimOutput::certificate_id): <p>The ID of the certificate.</p>
    ///   - [`certificate_pem(Option<String>)`](crate::output::CreateProvisioningClaimOutput::certificate_pem): <p>The provisioning claim certificate.</p>
    ///   - [`key_pair(Option<KeyPair>)`](crate::output::CreateProvisioningClaimOutput::key_pair): <p>The provisioning claim key pair.</p>
    ///   - [`expiration(Option<DateTime>)`](crate::output::CreateProvisioningClaimOutput::expiration): <p>The provisioning claim expiration time.</p>
    /// - On failure, responds with [`SdkError<CreateProvisioningClaimError>`](crate::error::CreateProvisioningClaimError)
    pub fn create_provisioning_claim(&self) -> fluent_builders::CreateProvisioningClaim<C, M, R> {
        fluent_builders::CreateProvisioningClaim::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProvisioningTemplate`](crate::client::fluent_builders::CreateProvisioningTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::set_template_name): <p>The name of the fleet provisioning template.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::set_description): <p>The description of the fleet provisioning template.</p>
    ///   - [`template_body(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::template_body) / [`set_template_body(Option<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::set_template_body): <p>The JSON formatted contents of the fleet provisioning template.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateProvisioningTemplate::enabled) / [`set_enabled(bool)`](crate::client::fluent_builders::CreateProvisioningTemplate::set_enabled): <p>True to enable the fleet provisioning template, otherwise false.</p>
    ///   - [`provisioning_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::provisioning_role_arn) / [`set_provisioning_role_arn(Option<String>)`](crate::client::fluent_builders::CreateProvisioningTemplate::set_provisioning_role_arn): <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
    ///   - [`pre_provisioning_hook(ProvisioningHook)`](crate::client::fluent_builders::CreateProvisioningTemplate::pre_provisioning_hook) / [`set_pre_provisioning_hook(Option<ProvisioningHook>)`](crate::client::fluent_builders::CreateProvisioningTemplate::set_pre_provisioning_hook): <p>Creates a pre-provisioning hook template.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateProvisioningTemplate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateProvisioningTemplate::set_tags): <p>Metadata which can be used to manage the fleet provisioning template.</p> <note>   <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>   <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>   <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>  </note>
    /// - On success, responds with [`CreateProvisioningTemplateOutput`](crate::output::CreateProvisioningTemplateOutput) with field(s):
    ///   - [`template_arn(Option<String>)`](crate::output::CreateProvisioningTemplateOutput::template_arn): <p>The ARN that identifies the provisioning template.</p>
    ///   - [`template_name(Option<String>)`](crate::output::CreateProvisioningTemplateOutput::template_name): <p>The name of the fleet provisioning template.</p>
    ///   - [`default_version_id(Option<i32>)`](crate::output::CreateProvisioningTemplateOutput::default_version_id): <p>The default version of the fleet provisioning template.</p>
    /// - On failure, responds with [`SdkError<CreateProvisioningTemplateError>`](crate::error::CreateProvisioningTemplateError)
    pub fn create_provisioning_template(
        &self,
    ) -> fluent_builders::CreateProvisioningTemplate<C, M, R> {
        fluent_builders::CreateProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProvisioningTemplateVersion`](crate::client::fluent_builders::CreateProvisioningTemplateVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningTemplateVersion::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::CreateProvisioningTemplateVersion::set_template_name): <p>The name of the fleet provisioning template.</p>
    ///   - [`template_body(impl Into<String>)`](crate::client::fluent_builders::CreateProvisioningTemplateVersion::template_body) / [`set_template_body(Option<String>)`](crate::client::fluent_builders::CreateProvisioningTemplateVersion::set_template_body): <p>The JSON formatted contents of the fleet provisioning template.</p>
    ///   - [`set_as_default(bool)`](crate::client::fluent_builders::CreateProvisioningTemplateVersion::set_as_default) / [`set_set_as_default(bool)`](crate::client::fluent_builders::CreateProvisioningTemplateVersion::set_set_as_default): <p>Sets a fleet provision template version as the default version.</p>
    /// - On success, responds with [`CreateProvisioningTemplateVersionOutput`](crate::output::CreateProvisioningTemplateVersionOutput) with field(s):
    ///   - [`template_arn(Option<String>)`](crate::output::CreateProvisioningTemplateVersionOutput::template_arn): <p>The ARN that identifies the provisioning template.</p>
    ///   - [`template_name(Option<String>)`](crate::output::CreateProvisioningTemplateVersionOutput::template_name): <p>The name of the fleet provisioning template.</p>
    ///   - [`version_id(Option<i32>)`](crate::output::CreateProvisioningTemplateVersionOutput::version_id): <p>The version of the fleet provisioning template.</p>
    ///   - [`is_default_version(bool)`](crate::output::CreateProvisioningTemplateVersionOutput::is_default_version): <p>True if the fleet provisioning template version is the default version, otherwise false.</p>
    /// - On failure, responds with [`SdkError<CreateProvisioningTemplateVersionError>`](crate::error::CreateProvisioningTemplateVersionError)
    pub fn create_provisioning_template_version(
        &self,
    ) -> fluent_builders::CreateProvisioningTemplateVersion<C, M, R> {
        fluent_builders::CreateProvisioningTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoleAlias`](crate::client::fluent_builders::CreateRoleAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_alias(impl Into<String>)`](crate::client::fluent_builders::CreateRoleAlias::role_alias) / [`set_role_alias(Option<String>)`](crate::client::fluent_builders::CreateRoleAlias::set_role_alias): <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateRoleAlias::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateRoleAlias::set_role_arn): <p>The role ARN.</p>
    ///   - [`credential_duration_seconds(i32)`](crate::client::fluent_builders::CreateRoleAlias::credential_duration_seconds) / [`set_credential_duration_seconds(Option<i32>)`](crate::client::fluent_builders::CreateRoleAlias::set_credential_duration_seconds): <p>How long (in seconds) the credentials will be valid. The default value is 3,600 seconds.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRoleAlias::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRoleAlias::set_tags): <p>Metadata which can be used to manage the role alias.</p> <note>   <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>   <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>   <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>  </note>
    /// - On success, responds with [`CreateRoleAliasOutput`](crate::output::CreateRoleAliasOutput) with field(s):
    ///   - [`role_alias(Option<String>)`](crate::output::CreateRoleAliasOutput::role_alias): <p>The role alias.</p>
    ///   - [`role_alias_arn(Option<String>)`](crate::output::CreateRoleAliasOutput::role_alias_arn): <p>The role alias ARN.</p>
    /// - On failure, responds with [`SdkError<CreateRoleAliasError>`](crate::error::CreateRoleAliasError)
    pub fn create_role_alias(&self) -> fluent_builders::CreateRoleAlias<C, M, R> {
        fluent_builders::CreateRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateScheduledAudit`](crate::client::fluent_builders::CreateScheduledAudit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`frequency(AuditFrequency)`](crate::client::fluent_builders::CreateScheduledAudit::frequency) / [`set_frequency(Option<AuditFrequency>)`](crate::client::fluent_builders::CreateScheduledAudit::set_frequency): <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    ///   - [`day_of_month(impl Into<String>)`](crate::client::fluent_builders::CreateScheduledAudit::day_of_month) / [`set_day_of_month(Option<String>)`](crate::client::fluent_builders::CreateScheduledAudit::set_day_of_month): <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
    ///   - [`day_of_week(DayOfWeek)`](crate::client::fluent_builders::CreateScheduledAudit::day_of_week) / [`set_day_of_week(Option<DayOfWeek>)`](crate::client::fluent_builders::CreateScheduledAudit::set_day_of_week): <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
    ///   - [`target_check_names(Vec<String>)`](crate::client::fluent_builders::CreateScheduledAudit::target_check_names) / [`set_target_check_names(Option<Vec<String>>)`](crate::client::fluent_builders::CreateScheduledAudit::set_target_check_names): <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`scheduled_audit_name(impl Into<String>)`](crate::client::fluent_builders::CreateScheduledAudit::scheduled_audit_name) / [`set_scheduled_audit_name(Option<String>)`](crate::client::fluent_builders::CreateScheduledAudit::set_scheduled_audit_name): <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateScheduledAudit::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateScheduledAudit::set_tags): <p>Metadata that can be used to manage the scheduled audit.</p>
    /// - On success, responds with [`CreateScheduledAuditOutput`](crate::output::CreateScheduledAuditOutput) with field(s):
    ///   - [`scheduled_audit_arn(Option<String>)`](crate::output::CreateScheduledAuditOutput::scheduled_audit_arn): <p>The ARN of the scheduled audit.</p>
    /// - On failure, responds with [`SdkError<CreateScheduledAuditError>`](crate::error::CreateScheduledAuditError)
    pub fn create_scheduled_audit(&self) -> fluent_builders::CreateScheduledAudit<C, M, R> {
        fluent_builders::CreateScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSecurityProfile`](crate::client::fluent_builders::CreateSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::CreateSecurityProfile::set_security_profile_name): <p>The name you are giving to the security profile.</p>
    ///   - [`security_profile_description(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityProfile::security_profile_description) / [`set_security_profile_description(Option<String>)`](crate::client::fluent_builders::CreateSecurityProfile::set_security_profile_description): <p>A description of the security profile.</p>
    ///   - [`behaviors(Vec<Behavior>)`](crate::client::fluent_builders::CreateSecurityProfile::behaviors) / [`set_behaviors(Option<Vec<Behavior>>)`](crate::client::fluent_builders::CreateSecurityProfile::set_behaviors): <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    ///   - [`alert_targets(HashMap<AlertTargetType, AlertTarget>)`](crate::client::fluent_builders::CreateSecurityProfile::alert_targets) / [`set_alert_targets(Option<HashMap<AlertTargetType, AlertTarget>>)`](crate::client::fluent_builders::CreateSecurityProfile::set_alert_targets): <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
    ///   - [`additional_metrics_to_retain(Vec<String>)`](crate::client::fluent_builders::CreateSecurityProfile::additional_metrics_to_retain) / [`set_additional_metrics_to_retain(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSecurityProfile::set_additional_metrics_to_retain): <p> <i>Please use <code>CreateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>  <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    ///   - [`additional_metrics_to_retain_v2(Vec<MetricToRetain>)`](crate::client::fluent_builders::CreateSecurityProfile::additional_metrics_to_retain_v2) / [`set_additional_metrics_to_retain_v2(Option<Vec<MetricToRetain>>)`](crate::client::fluent_builders::CreateSecurityProfile::set_additional_metrics_to_retain_v2): <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSecurityProfile::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSecurityProfile::set_tags): <p>Metadata that can be used to manage the security profile.</p>
    /// - On success, responds with [`CreateSecurityProfileOutput`](crate::output::CreateSecurityProfileOutput) with field(s):
    ///   - [`security_profile_name(Option<String>)`](crate::output::CreateSecurityProfileOutput::security_profile_name): <p>The name you gave to the security profile.</p>
    ///   - [`security_profile_arn(Option<String>)`](crate::output::CreateSecurityProfileOutput::security_profile_arn): <p>The ARN of the security profile.</p>
    /// - On failure, responds with [`SdkError<CreateSecurityProfileError>`](crate::error::CreateSecurityProfileError)
    pub fn create_security_profile(&self) -> fluent_builders::CreateSecurityProfile<C, M, R> {
        fluent_builders::CreateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStream`](crate::client::fluent_builders::CreateStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::CreateStream::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::CreateStream::set_stream_id): <p>The stream ID.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStream::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStream::set_description): <p>A description of the stream.</p>
    ///   - [`files(Vec<StreamFile>)`](crate::client::fluent_builders::CreateStream::files) / [`set_files(Option<Vec<StreamFile>>)`](crate::client::fluent_builders::CreateStream::set_files): <p>The files to stream.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStream::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateStream::set_role_arn): <p>An IAM role that allows the IoT service principal to access your S3 files.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateStream::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateStream::set_tags): <p>Metadata which can be used to manage streams.</p>
    /// - On success, responds with [`CreateStreamOutput`](crate::output::CreateStreamOutput) with field(s):
    ///   - [`stream_id(Option<String>)`](crate::output::CreateStreamOutput::stream_id): <p>The stream ID.</p>
    ///   - [`stream_arn(Option<String>)`](crate::output::CreateStreamOutput::stream_arn): <p>The stream ARN.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateStreamOutput::description): <p>A description of the stream.</p>
    ///   - [`stream_version(Option<i32>)`](crate::output::CreateStreamOutput::stream_version): <p>The version of the stream.</p>
    /// - On failure, responds with [`SdkError<CreateStreamError>`](crate::error::CreateStreamError)
    pub fn create_stream(&self) -> fluent_builders::CreateStream<C, M, R> {
        fluent_builders::CreateStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateThing`](crate::client::fluent_builders::CreateThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::CreateThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::CreateThing::set_thing_name): <p>The name of the thing to create.</p>  <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::CreateThing::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::CreateThing::set_thing_type_name): <p>The name of the thing type associated with the new thing.</p>
    ///   - [`attribute_payload(AttributePayload)`](crate::client::fluent_builders::CreateThing::attribute_payload) / [`set_attribute_payload(Option<AttributePayload>)`](crate::client::fluent_builders::CreateThing::set_attribute_payload): <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p>  <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateThing::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::CreateThing::set_billing_group_name): <p>The name of the billing group the thing will be added to.</p>
    /// - On success, responds with [`CreateThingOutput`](crate::output::CreateThingOutput) with field(s):
    ///   - [`thing_name(Option<String>)`](crate::output::CreateThingOutput::thing_name): <p>The name of the new thing.</p>
    ///   - [`thing_arn(Option<String>)`](crate::output::CreateThingOutput::thing_arn): <p>The ARN of the new thing.</p>
    ///   - [`thing_id(Option<String>)`](crate::output::CreateThingOutput::thing_id): <p>The thing ID.</p>
    /// - On failure, responds with [`SdkError<CreateThingError>`](crate::error::CreateThingError)
    pub fn create_thing(&self) -> fluent_builders::CreateThing<C, M, R> {
        fluent_builders::CreateThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateThingGroup`](crate::client::fluent_builders::CreateThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::CreateThingGroup::set_thing_group_name): <p>The thing group name to create.</p>
    ///   - [`parent_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateThingGroup::parent_group_name) / [`set_parent_group_name(Option<String>)`](crate::client::fluent_builders::CreateThingGroup::set_parent_group_name): <p>The name of the parent thing group.</p>
    ///   - [`thing_group_properties(ThingGroupProperties)`](crate::client::fluent_builders::CreateThingGroup::thing_group_properties) / [`set_thing_group_properties(Option<ThingGroupProperties>)`](crate::client::fluent_builders::CreateThingGroup::set_thing_group_properties): <p>The thing group properties.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateThingGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateThingGroup::set_tags): <p>Metadata which can be used to manage the thing group.</p>
    /// - On success, responds with [`CreateThingGroupOutput`](crate::output::CreateThingGroupOutput) with field(s):
    ///   - [`thing_group_name(Option<String>)`](crate::output::CreateThingGroupOutput::thing_group_name): <p>The thing group name.</p>
    ///   - [`thing_group_arn(Option<String>)`](crate::output::CreateThingGroupOutput::thing_group_arn): <p>The thing group ARN.</p>
    ///   - [`thing_group_id(Option<String>)`](crate::output::CreateThingGroupOutput::thing_group_id): <p>The thing group ID.</p>
    /// - On failure, responds with [`SdkError<CreateThingGroupError>`](crate::error::CreateThingGroupError)
    pub fn create_thing_group(&self) -> fluent_builders::CreateThingGroup<C, M, R> {
        fluent_builders::CreateThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateThingType`](crate::client::fluent_builders::CreateThingType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::CreateThingType::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::CreateThingType::set_thing_type_name): <p>The name of the thing type.</p>
    ///   - [`thing_type_properties(ThingTypeProperties)`](crate::client::fluent_builders::CreateThingType::thing_type_properties) / [`set_thing_type_properties(Option<ThingTypeProperties>)`](crate::client::fluent_builders::CreateThingType::set_thing_type_properties): <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateThingType::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateThingType::set_tags): <p>Metadata which can be used to manage the thing type.</p>
    /// - On success, responds with [`CreateThingTypeOutput`](crate::output::CreateThingTypeOutput) with field(s):
    ///   - [`thing_type_name(Option<String>)`](crate::output::CreateThingTypeOutput::thing_type_name): <p>The name of the thing type.</p>
    ///   - [`thing_type_arn(Option<String>)`](crate::output::CreateThingTypeOutput::thing_type_arn): <p>The Amazon Resource Name (ARN) of the thing type.</p>
    ///   - [`thing_type_id(Option<String>)`](crate::output::CreateThingTypeOutput::thing_type_id): <p>The thing type ID.</p>
    /// - On failure, responds with [`SdkError<CreateThingTypeError>`](crate::error::CreateThingTypeError)
    pub fn create_thing_type(&self) -> fluent_builders::CreateThingType<C, M, R> {
        fluent_builders::CreateThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTopicRule`](crate::client::fluent_builders::CreateTopicRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::CreateTopicRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::CreateTopicRule::set_rule_name): <p>The name of the rule.</p>
    ///   - [`topic_rule_payload(TopicRulePayload)`](crate::client::fluent_builders::CreateTopicRule::topic_rule_payload) / [`set_topic_rule_payload(Option<TopicRulePayload>)`](crate::client::fluent_builders::CreateTopicRule::set_topic_rule_payload): <p>The rule payload.</p>
    ///   - [`tags(impl Into<String>)`](crate::client::fluent_builders::CreateTopicRule::tags) / [`set_tags(Option<String>)`](crate::client::fluent_builders::CreateTopicRule::set_tags): <p>Metadata which can be used to manage the topic rule.</p> <note>   <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>   <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p>   <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>  </note>
    /// - On success, responds with [`CreateTopicRuleOutput`](crate::output::CreateTopicRuleOutput)

    /// - On failure, responds with [`SdkError<CreateTopicRuleError>`](crate::error::CreateTopicRuleError)
    pub fn create_topic_rule(&self) -> fluent_builders::CreateTopicRule<C, M, R> {
        fluent_builders::CreateTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTopicRuleDestination`](crate::client::fluent_builders::CreateTopicRuleDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_configuration(TopicRuleDestinationConfiguration)`](crate::client::fluent_builders::CreateTopicRuleDestination::destination_configuration) / [`set_destination_configuration(Option<TopicRuleDestinationConfiguration>)`](crate::client::fluent_builders::CreateTopicRuleDestination::set_destination_configuration): <p>The topic rule destination configuration.</p>
    /// - On success, responds with [`CreateTopicRuleDestinationOutput`](crate::output::CreateTopicRuleDestinationOutput) with field(s):
    ///   - [`topic_rule_destination(Option<TopicRuleDestination>)`](crate::output::CreateTopicRuleDestinationOutput::topic_rule_destination): <p>The topic rule destination.</p>
    /// - On failure, responds with [`SdkError<CreateTopicRuleDestinationError>`](crate::error::CreateTopicRuleDestinationError)
    pub fn create_topic_rule_destination(
        &self,
    ) -> fluent_builders::CreateTopicRuleDestination<C, M, R> {
        fluent_builders::CreateTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccountAuditConfiguration`](crate::client::fluent_builders::DeleteAccountAuditConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delete_scheduled_audits(bool)`](crate::client::fluent_builders::DeleteAccountAuditConfiguration::delete_scheduled_audits) / [`set_delete_scheduled_audits(bool)`](crate::client::fluent_builders::DeleteAccountAuditConfiguration::set_delete_scheduled_audits): <p>If true, all scheduled audits are deleted.</p>
    /// - On success, responds with [`DeleteAccountAuditConfigurationOutput`](crate::output::DeleteAccountAuditConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteAccountAuditConfigurationError>`](crate::error::DeleteAccountAuditConfigurationError)
    pub fn delete_account_audit_configuration(
        &self,
    ) -> fluent_builders::DeleteAccountAuditConfiguration<C, M, R> {
        fluent_builders::DeleteAccountAuditConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAuditSuppression`](crate::client::fluent_builders::DeleteAuditSuppression) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAuditSuppression::check_name) / [`set_check_name(Option<String>)`](crate::client::fluent_builders::DeleteAuditSuppression::set_check_name): <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`resource_identifier(ResourceIdentifier)`](crate::client::fluent_builders::DeleteAuditSuppression::resource_identifier) / [`set_resource_identifier(Option<ResourceIdentifier>)`](crate::client::fluent_builders::DeleteAuditSuppression::set_resource_identifier): <p>Information that identifies the noncompliant resource.</p>
    /// - On success, responds with [`DeleteAuditSuppressionOutput`](crate::output::DeleteAuditSuppressionOutput)

    /// - On failure, responds with [`SdkError<DeleteAuditSuppressionError>`](crate::error::DeleteAuditSuppressionError)
    pub fn delete_audit_suppression(&self) -> fluent_builders::DeleteAuditSuppression<C, M, R> {
        fluent_builders::DeleteAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAuthorizer`](crate::client::fluent_builders::DeleteAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorizer_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAuthorizer::authorizer_name) / [`set_authorizer_name(Option<String>)`](crate::client::fluent_builders::DeleteAuthorizer::set_authorizer_name): <p>The name of the authorizer to delete.</p>
    /// - On success, responds with [`DeleteAuthorizerOutput`](crate::output::DeleteAuthorizerOutput)

    /// - On failure, responds with [`SdkError<DeleteAuthorizerError>`](crate::error::DeleteAuthorizerError)
    pub fn delete_authorizer(&self) -> fluent_builders::DeleteAuthorizer<C, M, R> {
        fluent_builders::DeleteAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBillingGroup`](crate::client::fluent_builders::DeleteBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBillingGroup::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::DeleteBillingGroup::set_billing_group_name): <p>The name of the billing group.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::DeleteBillingGroup::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::DeleteBillingGroup::set_expected_version): <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
    /// - On success, responds with [`DeleteBillingGroupOutput`](crate::output::DeleteBillingGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteBillingGroupError>`](crate::error::DeleteBillingGroupError)
    pub fn delete_billing_group(&self) -> fluent_builders::DeleteBillingGroup<C, M, R> {
        fluent_builders::DeleteBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCACertificate`](crate::client::fluent_builders::DeleteCACertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCACertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::DeleteCACertificate::set_certificate_id): <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
    /// - On success, responds with [`DeleteCaCertificateOutput`](crate::output::DeleteCaCertificateOutput)

    /// - On failure, responds with [`SdkError<DeleteCACertificateError>`](crate::error::DeleteCACertificateError)
    pub fn delete_ca_certificate(&self) -> fluent_builders::DeleteCACertificate<C, M, R> {
        fluent_builders::DeleteCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCertificate`](crate::client::fluent_builders::DeleteCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::DeleteCertificate::set_certificate_id): <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::DeleteCertificate::force_delete) / [`set_force_delete(bool)`](crate::client::fluent_builders::DeleteCertificate::set_force_delete): <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
    /// - On success, responds with [`DeleteCertificateOutput`](crate::output::DeleteCertificateOutput)

    /// - On failure, responds with [`SdkError<DeleteCertificateError>`](crate::error::DeleteCertificateError)
    pub fn delete_certificate(&self) -> fluent_builders::DeleteCertificate<C, M, R> {
        fluent_builders::DeleteCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomMetric`](crate::client::fluent_builders::DeleteCustomMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::DeleteCustomMetric::set_metric_name): <p> The name of the custom metric. </p>
    /// - On success, responds with [`DeleteCustomMetricOutput`](crate::output::DeleteCustomMetricOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomMetricError>`](crate::error::DeleteCustomMetricError)
    pub fn delete_custom_metric(&self) -> fluent_builders::DeleteCustomMetric<C, M, R> {
        fluent_builders::DeleteCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDimension`](crate::client::fluent_builders::DeleteDimension) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteDimension::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteDimension::set_name): <p>The unique identifier for the dimension that you want to delete.</p>
    /// - On success, responds with [`DeleteDimensionOutput`](crate::output::DeleteDimensionOutput)

    /// - On failure, responds with [`SdkError<DeleteDimensionError>`](crate::error::DeleteDimensionError)
    pub fn delete_dimension(&self) -> fluent_builders::DeleteDimension<C, M, R> {
        fluent_builders::DeleteDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomainConfiguration`](crate::client::fluent_builders::DeleteDomainConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_configuration_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainConfiguration::domain_configuration_name) / [`set_domain_configuration_name(Option<String>)`](crate::client::fluent_builders::DeleteDomainConfiguration::set_domain_configuration_name): <p>The name of the domain configuration to be deleted.</p>
    /// - On success, responds with [`DeleteDomainConfigurationOutput`](crate::output::DeleteDomainConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteDomainConfigurationError>`](crate::error::DeleteDomainConfigurationError)
    pub fn delete_domain_configuration(
        &self,
    ) -> fluent_builders::DeleteDomainConfiguration<C, M, R> {
        fluent_builders::DeleteDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDynamicThingGroup`](crate::client::fluent_builders::DeleteDynamicThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDynamicThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDynamicThingGroup::set_thing_group_name): <p>The name of the dynamic thing group to delete.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::DeleteDynamicThingGroup::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::DeleteDynamicThingGroup::set_expected_version): <p>The expected version of the dynamic thing group to delete.</p>
    /// - On success, responds with [`DeleteDynamicThingGroupOutput`](crate::output::DeleteDynamicThingGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDynamicThingGroupError>`](crate::error::DeleteDynamicThingGroupError)
    pub fn delete_dynamic_thing_group(&self) -> fluent_builders::DeleteDynamicThingGroup<C, M, R> {
        fluent_builders::DeleteDynamicThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFleetMetric`](crate::client::fluent_builders::DeleteFleetMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFleetMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::DeleteFleetMetric::set_metric_name): <p>The name of the fleet metric to delete.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::DeleteFleetMetric::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::DeleteFleetMetric::set_expected_version): <p>The expected version of the fleet metric to delete.</p>
    /// - On success, responds with [`DeleteFleetMetricOutput`](crate::output::DeleteFleetMetricOutput)

    /// - On failure, responds with [`SdkError<DeleteFleetMetricError>`](crate::error::DeleteFleetMetricError)
    pub fn delete_fleet_metric(&self) -> fluent_builders::DeleteFleetMetric<C, M, R> {
        fluent_builders::DeleteFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJob`](crate::client::fluent_builders::DeleteJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_job_id): <p>The ID of the job to be deleted.</p>  <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteJob::force) / [`set_force(bool)`](crate::client::fluent_builders::DeleteJob::set_force): <p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note>   <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p>  </note>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJob::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::DeleteJob::set_namespace_id): <p>The namespace used to indicate that a job is a customer-managed job.</p>  <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>  <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>   <p>The <code>namespaceId</code> feature is in public preview.</p>  </note>
    /// - On success, responds with [`DeleteJobOutput`](crate::output::DeleteJobOutput)

    /// - On failure, responds with [`SdkError<DeleteJobError>`](crate::error::DeleteJobError)
    pub fn delete_job(&self) -> fluent_builders::DeleteJob<C, M, R> {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJobExecution`](crate::client::fluent_builders::DeleteJobExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJobExecution::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteJobExecution::set_job_id): <p>The ID of the job whose execution on a particular device will be deleted.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::DeleteJobExecution::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::DeleteJobExecution::set_thing_name): <p>The name of the thing whose job execution will be deleted.</p>
    ///   - [`execution_number(i64)`](crate::client::fluent_builders::DeleteJobExecution::execution_number) / [`set_execution_number(Option<i64>)`](crate::client::fluent_builders::DeleteJobExecution::set_execution_number): <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p>  <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteJobExecution::force) / [`set_force(bool)`](crate::client::fluent_builders::DeleteJobExecution::set_force): <p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note>   <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>  </note>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJobExecution::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::DeleteJobExecution::set_namespace_id): <p>The namespace used to indicate that a job is a customer-managed job.</p>  <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>  <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>   <p>The <code>namespaceId</code> feature is in public preview.</p>  </note>
    /// - On success, responds with [`DeleteJobExecutionOutput`](crate::output::DeleteJobExecutionOutput)

    /// - On failure, responds with [`SdkError<DeleteJobExecutionError>`](crate::error::DeleteJobExecutionError)
    pub fn delete_job_execution(&self) -> fluent_builders::DeleteJobExecution<C, M, R> {
        fluent_builders::DeleteJobExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJobTemplate`](crate::client::fluent_builders::DeleteJobTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_template_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJobTemplate::job_template_id) / [`set_job_template_id(Option<String>)`](crate::client::fluent_builders::DeleteJobTemplate::set_job_template_id): <p>The unique identifier of the job template to delete.</p>
    /// - On success, responds with [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteJobTemplateError>`](crate::error::DeleteJobTemplateError)
    pub fn delete_job_template(&self) -> fluent_builders::DeleteJobTemplate<C, M, R> {
        fluent_builders::DeleteJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMitigationAction`](crate::client::fluent_builders::DeleteMitigationAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_name(impl Into<String>)`](crate::client::fluent_builders::DeleteMitigationAction::action_name) / [`set_action_name(Option<String>)`](crate::client::fluent_builders::DeleteMitigationAction::set_action_name): <p>The name of the mitigation action that you want to delete.</p>
    /// - On success, responds with [`DeleteMitigationActionOutput`](crate::output::DeleteMitigationActionOutput)

    /// - On failure, responds with [`SdkError<DeleteMitigationActionError>`](crate::error::DeleteMitigationActionError)
    pub fn delete_mitigation_action(&self) -> fluent_builders::DeleteMitigationAction<C, M, R> {
        fluent_builders::DeleteMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOTAUpdate`](crate::client::fluent_builders::DeleteOTAUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ota_update_id(impl Into<String>)`](crate::client::fluent_builders::DeleteOTAUpdate::ota_update_id) / [`set_ota_update_id(Option<String>)`](crate::client::fluent_builders::DeleteOTAUpdate::set_ota_update_id): <p>The ID of the OTA update to delete.</p>
    ///   - [`delete_stream(bool)`](crate::client::fluent_builders::DeleteOTAUpdate::delete_stream) / [`set_delete_stream(bool)`](crate::client::fluent_builders::DeleteOTAUpdate::set_delete_stream): <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
    ///   - [`force_delete_aws_job(bool)`](crate::client::fluent_builders::DeleteOTAUpdate::force_delete_aws_job) / [`set_force_delete_aws_job(bool)`](crate::client::fluent_builders::DeleteOTAUpdate::set_force_delete_aws_job): <p>When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
    /// - On success, responds with [`DeleteOtaUpdateOutput`](crate::output::DeleteOtaUpdateOutput)

    /// - On failure, responds with [`SdkError<DeleteOTAUpdateError>`](crate::error::DeleteOTAUpdateError)
    pub fn delete_ota_update(&self) -> fluent_builders::DeleteOTAUpdate<C, M, R> {
        fluent_builders::DeleteOTAUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::DeletePolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::DeletePolicy::set_policy_name): <p>The name of the policy to delete.</p>
    /// - On success, responds with [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)

    /// - On failure, responds with [`SdkError<DeletePolicyError>`](crate::error::DeletePolicyError)
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy<C, M, R> {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePolicyVersion`](crate::client::fluent_builders::DeletePolicyVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::DeletePolicyVersion::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::DeletePolicyVersion::set_policy_name): <p>The name of the policy.</p>
    ///   - [`policy_version_id(impl Into<String>)`](crate::client::fluent_builders::DeletePolicyVersion::policy_version_id) / [`set_policy_version_id(Option<String>)`](crate::client::fluent_builders::DeletePolicyVersion::set_policy_version_id): <p>The policy version ID.</p>
    /// - On success, responds with [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)

    /// - On failure, responds with [`SdkError<DeletePolicyVersionError>`](crate::error::DeletePolicyVersionError)
    pub fn delete_policy_version(&self) -> fluent_builders::DeletePolicyVersion<C, M, R> {
        fluent_builders::DeletePolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProvisioningTemplate`](crate::client::fluent_builders::DeleteProvisioningTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisioningTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteProvisioningTemplate::set_template_name): <p>The name of the fleet provision template to delete.</p>
    /// - On success, responds with [`DeleteProvisioningTemplateOutput`](crate::output::DeleteProvisioningTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteProvisioningTemplateError>`](crate::error::DeleteProvisioningTemplateError)
    pub fn delete_provisioning_template(
        &self,
    ) -> fluent_builders::DeleteProvisioningTemplate<C, M, R> {
        fluent_builders::DeleteProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProvisioningTemplateVersion`](crate::client::fluent_builders::DeleteProvisioningTemplateVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisioningTemplateVersion::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DeleteProvisioningTemplateVersion::set_template_name): <p>The name of the fleet provisioning template version to delete.</p>
    ///   - [`version_id(i32)`](crate::client::fluent_builders::DeleteProvisioningTemplateVersion::version_id) / [`set_version_id(Option<i32>)`](crate::client::fluent_builders::DeleteProvisioningTemplateVersion::set_version_id): <p>The fleet provisioning template version ID to delete.</p>
    /// - On success, responds with [`DeleteProvisioningTemplateVersionOutput`](crate::output::DeleteProvisioningTemplateVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteProvisioningTemplateVersionError>`](crate::error::DeleteProvisioningTemplateVersionError)
    pub fn delete_provisioning_template_version(
        &self,
    ) -> fluent_builders::DeleteProvisioningTemplateVersion<C, M, R> {
        fluent_builders::DeleteProvisioningTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRegistrationCode`](crate::client::fluent_builders::DeleteRegistrationCode) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteRegistrationCode::send) it.

    /// - On success, responds with [`DeleteRegistrationCodeOutput`](crate::output::DeleteRegistrationCodeOutput)

    /// - On failure, responds with [`SdkError<DeleteRegistrationCodeError>`](crate::error::DeleteRegistrationCodeError)
    pub fn delete_registration_code(&self) -> fluent_builders::DeleteRegistrationCode<C, M, R> {
        fluent_builders::DeleteRegistrationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoleAlias`](crate::client::fluent_builders::DeleteRoleAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_alias(impl Into<String>)`](crate::client::fluent_builders::DeleteRoleAlias::role_alias) / [`set_role_alias(Option<String>)`](crate::client::fluent_builders::DeleteRoleAlias::set_role_alias): <p>The role alias to delete.</p>
    /// - On success, responds with [`DeleteRoleAliasOutput`](crate::output::DeleteRoleAliasOutput)

    /// - On failure, responds with [`SdkError<DeleteRoleAliasError>`](crate::error::DeleteRoleAliasError)
    pub fn delete_role_alias(&self) -> fluent_builders::DeleteRoleAlias<C, M, R> {
        fluent_builders::DeleteRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteScheduledAudit`](crate::client::fluent_builders::DeleteScheduledAudit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scheduled_audit_name(impl Into<String>)`](crate::client::fluent_builders::DeleteScheduledAudit::scheduled_audit_name) / [`set_scheduled_audit_name(Option<String>)`](crate::client::fluent_builders::DeleteScheduledAudit::set_scheduled_audit_name): <p>The name of the scheduled audit you want to delete.</p>
    /// - On success, responds with [`DeleteScheduledAuditOutput`](crate::output::DeleteScheduledAuditOutput)

    /// - On failure, responds with [`SdkError<DeleteScheduledAuditError>`](crate::error::DeleteScheduledAuditError)
    pub fn delete_scheduled_audit(&self) -> fluent_builders::DeleteScheduledAudit<C, M, R> {
        fluent_builders::DeleteScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSecurityProfile`](crate::client::fluent_builders::DeleteSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::DeleteSecurityProfile::set_security_profile_name): <p>The name of the security profile to be deleted.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::DeleteSecurityProfile::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::DeleteSecurityProfile::set_expected_version): <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
    /// - On success, responds with [`DeleteSecurityProfileOutput`](crate::output::DeleteSecurityProfileOutput)

    /// - On failure, responds with [`SdkError<DeleteSecurityProfileError>`](crate::error::DeleteSecurityProfileError)
    pub fn delete_security_profile(&self) -> fluent_builders::DeleteSecurityProfile<C, M, R> {
        fluent_builders::DeleteSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStream`](crate::client::fluent_builders::DeleteStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStream::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::DeleteStream::set_stream_id): <p>The stream ID.</p>
    /// - On success, responds with [`DeleteStreamOutput`](crate::output::DeleteStreamOutput)

    /// - On failure, responds with [`SdkError<DeleteStreamError>`](crate::error::DeleteStreamError)
    pub fn delete_stream(&self) -> fluent_builders::DeleteStream<C, M, R> {
        fluent_builders::DeleteStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteThing`](crate::client::fluent_builders::DeleteThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::DeleteThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::DeleteThing::set_thing_name): <p>The name of the thing to delete.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::DeleteThing::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::DeleteThing::set_expected_version): <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
    /// - On success, responds with [`DeleteThingOutput`](crate::output::DeleteThingOutput)

    /// - On failure, responds with [`SdkError<DeleteThingError>`](crate::error::DeleteThingError)
    pub fn delete_thing(&self) -> fluent_builders::DeleteThing<C, M, R> {
        fluent_builders::DeleteThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteThingGroup`](crate::client::fluent_builders::DeleteThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::DeleteThingGroup::set_thing_group_name): <p>The name of the thing group to delete.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::DeleteThingGroup::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::DeleteThingGroup::set_expected_version): <p>The expected version of the thing group to delete.</p>
    /// - On success, responds with [`DeleteThingGroupOutput`](crate::output::DeleteThingGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteThingGroupError>`](crate::error::DeleteThingGroupError)
    pub fn delete_thing_group(&self) -> fluent_builders::DeleteThingGroup<C, M, R> {
        fluent_builders::DeleteThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteThingType`](crate::client::fluent_builders::DeleteThingType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteThingType::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::DeleteThingType::set_thing_type_name): <p>The name of the thing type.</p>
    /// - On success, responds with [`DeleteThingTypeOutput`](crate::output::DeleteThingTypeOutput)

    /// - On failure, responds with [`SdkError<DeleteThingTypeError>`](crate::error::DeleteThingTypeError)
    pub fn delete_thing_type(&self) -> fluent_builders::DeleteThingType<C, M, R> {
        fluent_builders::DeleteThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTopicRule`](crate::client::fluent_builders::DeleteTopicRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTopicRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::DeleteTopicRule::set_rule_name): <p>The name of the rule.</p>
    /// - On success, responds with [`DeleteTopicRuleOutput`](crate::output::DeleteTopicRuleOutput)

    /// - On failure, responds with [`SdkError<DeleteTopicRuleError>`](crate::error::DeleteTopicRuleError)
    pub fn delete_topic_rule(&self) -> fluent_builders::DeleteTopicRule<C, M, R> {
        fluent_builders::DeleteTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTopicRuleDestination`](crate::client::fluent_builders::DeleteTopicRuleDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteTopicRuleDestination::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteTopicRuleDestination::set_arn): <p>The ARN of the topic rule destination to delete.</p>
    /// - On success, responds with [`DeleteTopicRuleDestinationOutput`](crate::output::DeleteTopicRuleDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteTopicRuleDestinationError>`](crate::error::DeleteTopicRuleDestinationError)
    pub fn delete_topic_rule_destination(
        &self,
    ) -> fluent_builders::DeleteTopicRuleDestination<C, M, R> {
        fluent_builders::DeleteTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteV2LoggingLevel`](crate::client::fluent_builders::DeleteV2LoggingLevel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_type(LogTargetType)`](crate::client::fluent_builders::DeleteV2LoggingLevel::target_type) / [`set_target_type(Option<LogTargetType>)`](crate::client::fluent_builders::DeleteV2LoggingLevel::set_target_type): <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
    ///   - [`target_name(impl Into<String>)`](crate::client::fluent_builders::DeleteV2LoggingLevel::target_name) / [`set_target_name(Option<String>)`](crate::client::fluent_builders::DeleteV2LoggingLevel::set_target_name): <p>The name of the resource for which you are configuring logging.</p>
    /// - On success, responds with [`DeleteV2LoggingLevelOutput`](crate::output::DeleteV2LoggingLevelOutput)

    /// - On failure, responds with [`SdkError<DeleteV2LoggingLevelError>`](crate::error::DeleteV2LoggingLevelError)
    pub fn delete_v2_logging_level(&self) -> fluent_builders::DeleteV2LoggingLevel<C, M, R> {
        fluent_builders::DeleteV2LoggingLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprecateThingType`](crate::client::fluent_builders::DeprecateThingType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::DeprecateThingType::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::DeprecateThingType::set_thing_type_name): <p>The name of the thing type to deprecate.</p>
    ///   - [`undo_deprecate(bool)`](crate::client::fluent_builders::DeprecateThingType::undo_deprecate) / [`set_undo_deprecate(bool)`](crate::client::fluent_builders::DeprecateThingType::set_undo_deprecate): <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
    /// - On success, responds with [`DeprecateThingTypeOutput`](crate::output::DeprecateThingTypeOutput)

    /// - On failure, responds with [`SdkError<DeprecateThingTypeError>`](crate::error::DeprecateThingTypeError)
    pub fn deprecate_thing_type(&self) -> fluent_builders::DeprecateThingType<C, M, R> {
        fluent_builders::DeprecateThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAuditConfiguration`](crate::client::fluent_builders::DescribeAccountAuditConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeAccountAuditConfiguration::send) it.

    /// - On success, responds with [`DescribeAccountAuditConfigurationOutput`](crate::output::DescribeAccountAuditConfigurationOutput) with field(s):
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeAccountAuditConfigurationOutput::role_arn): <p>The ARN of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p>  <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required.</p>
    ///   - [`audit_notification_target_configurations(Option<HashMap<AuditNotificationType, AuditNotificationTarget>>)`](crate::output::DescribeAccountAuditConfigurationOutput::audit_notification_target_configurations): <p>Information about the targets to which audit notifications are sent for this account.</p>
    ///   - [`audit_check_configurations(Option<HashMap<String, AuditCheckConfiguration>>)`](crate::output::DescribeAccountAuditConfigurationOutput::audit_check_configurations): <p>Which audit checks are enabled and disabled for this account.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAuditConfigurationError>`](crate::error::DescribeAccountAuditConfigurationError)
    pub fn describe_account_audit_configuration(
        &self,
    ) -> fluent_builders::DescribeAccountAuditConfiguration<C, M, R> {
        fluent_builders::DescribeAccountAuditConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAuditFinding`](crate::client::fluent_builders::DescribeAuditFinding) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAuditFinding::finding_id) / [`set_finding_id(Option<String>)`](crate::client::fluent_builders::DescribeAuditFinding::set_finding_id): <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
    /// - On success, responds with [`DescribeAuditFindingOutput`](crate::output::DescribeAuditFindingOutput) with field(s):
    ///   - [`finding(Option<AuditFinding>)`](crate::output::DescribeAuditFindingOutput::finding): <p>The findings (results) of the audit.</p>
    /// - On failure, responds with [`SdkError<DescribeAuditFindingError>`](crate::error::DescribeAuditFindingError)
    pub fn describe_audit_finding(&self) -> fluent_builders::DescribeAuditFinding<C, M, R> {
        fluent_builders::DescribeAuditFinding::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAuditMitigationActionsTask`](crate::client::fluent_builders::DescribeAuditMitigationActionsTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAuditMitigationActionsTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeAuditMitigationActionsTask::set_task_id): <p>The unique identifier for the audit mitigation task.</p>
    /// - On success, responds with [`DescribeAuditMitigationActionsTaskOutput`](crate::output::DescribeAuditMitigationActionsTaskOutput) with field(s):
    ///   - [`task_status(Option<AuditMitigationActionsTaskStatus>)`](crate::output::DescribeAuditMitigationActionsTaskOutput::task_status): <p>The current status of the task.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeAuditMitigationActionsTaskOutput::start_time): <p>The date and time when the task was started.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::DescribeAuditMitigationActionsTaskOutput::end_time): <p>The date and time when the task was completed or canceled.</p>
    ///   - [`task_statistics(Option<HashMap<String, TaskStatisticsForAuditCheck>>)`](crate::output::DescribeAuditMitigationActionsTaskOutput::task_statistics): <p>Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation actions task.</p>
    ///   - [`target(Option<AuditMitigationActionsTaskTarget>)`](crate::output::DescribeAuditMitigationActionsTaskOutput::target): <p>Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task, or a set of findings.</p>
    ///   - [`audit_check_to_actions_mapping(Option<HashMap<String, Vec<String>>>)`](crate::output::DescribeAuditMitigationActionsTaskOutput::audit_check_to_actions_mapping): <p>Specifies the mitigation actions that should be applied to specific audit checks.</p>
    ///   - [`actions_definition(Option<Vec<MitigationAction>>)`](crate::output::DescribeAuditMitigationActionsTaskOutput::actions_definition): <p>Specifies the mitigation actions and their parameters that are applied as part of this task.</p>
    /// - On failure, responds with [`SdkError<DescribeAuditMitigationActionsTaskError>`](crate::error::DescribeAuditMitigationActionsTaskError)
    pub fn describe_audit_mitigation_actions_task(
        &self,
    ) -> fluent_builders::DescribeAuditMitigationActionsTask<C, M, R> {
        fluent_builders::DescribeAuditMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAuditSuppression`](crate::client::fluent_builders::DescribeAuditSuppression) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_name(impl Into<String>)`](crate::client::fluent_builders::DescribeAuditSuppression::check_name) / [`set_check_name(Option<String>)`](crate::client::fluent_builders::DescribeAuditSuppression::set_check_name): <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`resource_identifier(ResourceIdentifier)`](crate::client::fluent_builders::DescribeAuditSuppression::resource_identifier) / [`set_resource_identifier(Option<ResourceIdentifier>)`](crate::client::fluent_builders::DescribeAuditSuppression::set_resource_identifier): <p>Information that identifies the noncompliant resource.</p>
    /// - On success, responds with [`DescribeAuditSuppressionOutput`](crate::output::DescribeAuditSuppressionOutput) with field(s):
    ///   - [`check_name(Option<String>)`](crate::output::DescribeAuditSuppressionOutput::check_name): <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`resource_identifier(Option<ResourceIdentifier>)`](crate::output::DescribeAuditSuppressionOutput::resource_identifier): <p>Information that identifies the noncompliant resource.</p>
    ///   - [`expiration_date(Option<DateTime>)`](crate::output::DescribeAuditSuppressionOutput::expiration_date): <p> The epoch timestamp in seconds at which this suppression expires. </p>
    ///   - [`suppress_indefinitely(Option<bool>)`](crate::output::DescribeAuditSuppressionOutput::suppress_indefinitely): <p> Indicates whether a suppression should exist indefinitely or not. </p>
    ///   - [`description(Option<String>)`](crate::output::DescribeAuditSuppressionOutput::description): <p> The description of the audit suppression. </p>
    /// - On failure, responds with [`SdkError<DescribeAuditSuppressionError>`](crate::error::DescribeAuditSuppressionError)
    pub fn describe_audit_suppression(&self) -> fluent_builders::DescribeAuditSuppression<C, M, R> {
        fluent_builders::DescribeAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAuditTask`](crate::client::fluent_builders::DescribeAuditTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAuditTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeAuditTask::set_task_id): <p>The ID of the audit whose information you want to get.</p>
    /// - On success, responds with [`DescribeAuditTaskOutput`](crate::output::DescribeAuditTaskOutput) with field(s):
    ///   - [`task_status(Option<AuditTaskStatus>)`](crate::output::DescribeAuditTaskOutput::task_status): <p>The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
    ///   - [`task_type(Option<AuditTaskType>)`](crate::output::DescribeAuditTaskOutput::task_type): <p>The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
    ///   - [`task_start_time(Option<DateTime>)`](crate::output::DescribeAuditTaskOutput::task_start_time): <p>The time the audit started.</p>
    ///   - [`task_statistics(Option<TaskStatistics>)`](crate::output::DescribeAuditTaskOutput::task_statistics): <p>Statistical information about the audit.</p>
    ///   - [`scheduled_audit_name(Option<String>)`](crate::output::DescribeAuditTaskOutput::scheduled_audit_name): <p>The name of the scheduled audit (only if the audit was a scheduled audit).</p>
    ///   - [`audit_details(Option<HashMap<String, AuditCheckDetails>>)`](crate::output::DescribeAuditTaskOutput::audit_details): <p>Detailed information about each check performed during this audit.</p>
    /// - On failure, responds with [`SdkError<DescribeAuditTaskError>`](crate::error::DescribeAuditTaskError)
    pub fn describe_audit_task(&self) -> fluent_builders::DescribeAuditTask<C, M, R> {
        fluent_builders::DescribeAuditTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAuthorizer`](crate::client::fluent_builders::DescribeAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorizer_name(impl Into<String>)`](crate::client::fluent_builders::DescribeAuthorizer::authorizer_name) / [`set_authorizer_name(Option<String>)`](crate::client::fluent_builders::DescribeAuthorizer::set_authorizer_name): <p>The name of the authorizer to describe.</p>
    /// - On success, responds with [`DescribeAuthorizerOutput`](crate::output::DescribeAuthorizerOutput) with field(s):
    ///   - [`authorizer_description(Option<AuthorizerDescription>)`](crate::output::DescribeAuthorizerOutput::authorizer_description): <p>The authorizer description.</p>
    /// - On failure, responds with [`SdkError<DescribeAuthorizerError>`](crate::error::DescribeAuthorizerError)
    pub fn describe_authorizer(&self) -> fluent_builders::DescribeAuthorizer<C, M, R> {
        fluent_builders::DescribeAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBillingGroup`](crate::client::fluent_builders::DescribeBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeBillingGroup::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::DescribeBillingGroup::set_billing_group_name): <p>The name of the billing group.</p>
    /// - On success, responds with [`DescribeBillingGroupOutput`](crate::output::DescribeBillingGroupOutput) with field(s):
    ///   - [`billing_group_name(Option<String>)`](crate::output::DescribeBillingGroupOutput::billing_group_name): <p>The name of the billing group.</p>
    ///   - [`billing_group_id(Option<String>)`](crate::output::DescribeBillingGroupOutput::billing_group_id): <p>The ID of the billing group.</p>
    ///   - [`billing_group_arn(Option<String>)`](crate::output::DescribeBillingGroupOutput::billing_group_arn): <p>The ARN of the billing group.</p>
    ///   - [`version(i64)`](crate::output::DescribeBillingGroupOutput::version): <p>The version of the billing group.</p>
    ///   - [`billing_group_properties(Option<BillingGroupProperties>)`](crate::output::DescribeBillingGroupOutput::billing_group_properties): <p>The properties of the billing group.</p>
    ///   - [`billing_group_metadata(Option<BillingGroupMetadata>)`](crate::output::DescribeBillingGroupOutput::billing_group_metadata): <p>Additional information about the billing group.</p>
    /// - On failure, responds with [`SdkError<DescribeBillingGroupError>`](crate::error::DescribeBillingGroupError)
    pub fn describe_billing_group(&self) -> fluent_builders::DescribeBillingGroup<C, M, R> {
        fluent_builders::DescribeBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCACertificate`](crate::client::fluent_builders::DescribeCACertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCACertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::DescribeCACertificate::set_certificate_id): <p>The CA certificate identifier.</p>
    /// - On success, responds with [`DescribeCaCertificateOutput`](crate::output::DescribeCaCertificateOutput) with field(s):
    ///   - [`certificate_description(Option<CaCertificateDescription>)`](crate::output::DescribeCaCertificateOutput::certificate_description): <p>The CA certificate description.</p>
    ///   - [`registration_config(Option<RegistrationConfig>)`](crate::output::DescribeCaCertificateOutput::registration_config): <p>Information about the registration configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeCACertificateError>`](crate::error::DescribeCACertificateError)
    pub fn describe_ca_certificate(&self) -> fluent_builders::DescribeCACertificate<C, M, R> {
        fluent_builders::DescribeCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCertificate`](crate::client::fluent_builders::DescribeCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::DescribeCertificate::set_certificate_id): <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    /// - On success, responds with [`DescribeCertificateOutput`](crate::output::DescribeCertificateOutput) with field(s):
    ///   - [`certificate_description(Option<CertificateDescription>)`](crate::output::DescribeCertificateOutput::certificate_description): <p>The description of the certificate.</p>
    /// - On failure, responds with [`SdkError<DescribeCertificateError>`](crate::error::DescribeCertificateError)
    pub fn describe_certificate(&self) -> fluent_builders::DescribeCertificate<C, M, R> {
        fluent_builders::DescribeCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomMetric`](crate::client::fluent_builders::DescribeCustomMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::DescribeCustomMetric::set_metric_name): <p> The name of the custom metric. </p>
    /// - On success, responds with [`DescribeCustomMetricOutput`](crate::output::DescribeCustomMetricOutput) with field(s):
    ///   - [`metric_name(Option<String>)`](crate::output::DescribeCustomMetricOutput::metric_name): <p> The name of the custom metric. </p>
    ///   - [`metric_arn(Option<String>)`](crate::output::DescribeCustomMetricOutput::metric_arn): <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    ///   - [`metric_type(Option<CustomMetricType>)`](crate::output::DescribeCustomMetricOutput::metric_type): <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    ///   - [`display_name(Option<String>)`](crate::output::DescribeCustomMetricOutput::display_name): <p> Field represents a friendly name in the console for the custom metric; doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeCustomMetricOutput::creation_date): <p> The creation date of the custom metric in milliseconds since epoch. </p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeCustomMetricOutput::last_modified_date): <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    /// - On failure, responds with [`SdkError<DescribeCustomMetricError>`](crate::error::DescribeCustomMetricError)
    pub fn describe_custom_metric(&self) -> fluent_builders::DescribeCustomMetric<C, M, R> {
        fluent_builders::DescribeCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDefaultAuthorizer`](crate::client::fluent_builders::DescribeDefaultAuthorizer) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeDefaultAuthorizer::send) it.

    /// - On success, responds with [`DescribeDefaultAuthorizerOutput`](crate::output::DescribeDefaultAuthorizerOutput) with field(s):
    ///   - [`authorizer_description(Option<AuthorizerDescription>)`](crate::output::DescribeDefaultAuthorizerOutput::authorizer_description): <p>The default authorizer's description.</p>
    /// - On failure, responds with [`SdkError<DescribeDefaultAuthorizerError>`](crate::error::DescribeDefaultAuthorizerError)
    pub fn describe_default_authorizer(
        &self,
    ) -> fluent_builders::DescribeDefaultAuthorizer<C, M, R> {
        fluent_builders::DescribeDefaultAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDetectMitigationActionsTask`](crate::client::fluent_builders::DescribeDetectMitigationActionsTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDetectMitigationActionsTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeDetectMitigationActionsTask::set_task_id): <p> The unique identifier of the task. </p>
    /// - On success, responds with [`DescribeDetectMitigationActionsTaskOutput`](crate::output::DescribeDetectMitigationActionsTaskOutput) with field(s):
    ///   - [`task_summary(Option<DetectMitigationActionsTaskSummary>)`](crate::output::DescribeDetectMitigationActionsTaskOutput::task_summary): <p> The description of a task. </p>
    /// - On failure, responds with [`SdkError<DescribeDetectMitigationActionsTaskError>`](crate::error::DescribeDetectMitigationActionsTaskError)
    pub fn describe_detect_mitigation_actions_task(
        &self,
    ) -> fluent_builders::DescribeDetectMitigationActionsTask<C, M, R> {
        fluent_builders::DescribeDetectMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDimension`](crate::client::fluent_builders::DescribeDimension) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeDimension::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeDimension::set_name): <p>The unique identifier for the dimension.</p>
    /// - On success, responds with [`DescribeDimensionOutput`](crate::output::DescribeDimensionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeDimensionOutput::name): <p>The unique identifier for the dimension.</p>
    ///   - [`arn(Option<String>)`](crate::output::DescribeDimensionOutput::arn): <p>The Amazon Resource Name (ARN) for the dimension.</p>
    ///   - [`r#type(Option<DimensionType>)`](crate::output::DescribeDimensionOutput::type): <p>The type of the dimension.</p>
    ///   - [`string_values(Option<Vec<String>>)`](crate::output::DescribeDimensionOutput::string_values): <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeDimensionOutput::creation_date): <p>The date the dimension was created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeDimensionOutput::last_modified_date): <p>The date the dimension was last modified.</p>
    /// - On failure, responds with [`SdkError<DescribeDimensionError>`](crate::error::DescribeDimensionError)
    pub fn describe_dimension(&self) -> fluent_builders::DescribeDimension<C, M, R> {
        fluent_builders::DescribeDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomainConfiguration`](crate::client::fluent_builders::DescribeDomainConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_configuration_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDomainConfiguration::domain_configuration_name) / [`set_domain_configuration_name(Option<String>)`](crate::client::fluent_builders::DescribeDomainConfiguration::set_domain_configuration_name): <p>The name of the domain configuration.</p>
    /// - On success, responds with [`DescribeDomainConfigurationOutput`](crate::output::DescribeDomainConfigurationOutput) with field(s):
    ///   - [`domain_configuration_name(Option<String>)`](crate::output::DescribeDomainConfigurationOutput::domain_configuration_name): <p>The name of the domain configuration.</p>
    ///   - [`domain_configuration_arn(Option<String>)`](crate::output::DescribeDomainConfigurationOutput::domain_configuration_arn): <p>The ARN of the domain configuration.</p>
    ///   - [`domain_name(Option<String>)`](crate::output::DescribeDomainConfigurationOutput::domain_name): <p>The name of the domain.</p>
    ///   - [`server_certificates(Option<Vec<ServerCertificateSummary>>)`](crate::output::DescribeDomainConfigurationOutput::server_certificates): <p>A list containing summary information about the server certificate included in the domain configuration.</p>
    ///   - [`authorizer_config(Option<AuthorizerConfig>)`](crate::output::DescribeDomainConfigurationOutput::authorizer_config): <p>An object that specifies the authorization service for a domain.</p>
    ///   - [`domain_configuration_status(Option<DomainConfigurationStatus>)`](crate::output::DescribeDomainConfigurationOutput::domain_configuration_status): <p>A Boolean value that specifies the current state of the domain configuration.</p>
    ///   - [`service_type(Option<ServiceType>)`](crate::output::DescribeDomainConfigurationOutput::service_type): <p>The type of service delivered by the endpoint.</p>
    ///   - [`domain_type(Option<DomainType>)`](crate::output::DescribeDomainConfigurationOutput::domain_type): <p>The type of the domain.</p>
    ///   - [`last_status_change_date(Option<DateTime>)`](crate::output::DescribeDomainConfigurationOutput::last_status_change_date): <p>The date and time the domain configuration's status was last changed.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainConfigurationError>`](crate::error::DescribeDomainConfigurationError)
    pub fn describe_domain_configuration(
        &self,
    ) -> fluent_builders::DescribeDomainConfiguration<C, M, R> {
        fluent_builders::DescribeDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpoint`](crate::client::fluent_builders::DescribeEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_type(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpoint::endpoint_type) / [`set_endpoint_type(Option<String>)`](crate::client::fluent_builders::DescribeEndpoint::set_endpoint_type): <p>The endpoint type. Valid endpoint types include:</p>  <ul>   <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li>  </ul>  <ul>   <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li>  </ul>  <ul>   <li> <p> <code>iot:CredentialProvider</code> - Returns an IoT credentials provider API endpoint.</p> </li>  </ul>  <ul>   <li> <p> <code>iot:Jobs</code> - Returns an IoT device management Jobs API endpoint.</p> </li>  </ul>  <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
    /// - On success, responds with [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput) with field(s):
    ///   - [`endpoint_address(Option<String>)`](crate::output::DescribeEndpointOutput::endpoint_address): <p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointError>`](crate::error::DescribeEndpointError)
    pub fn describe_endpoint(&self) -> fluent_builders::DescribeEndpoint<C, M, R> {
        fluent_builders::DescribeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventConfigurations`](crate::client::fluent_builders::DescribeEventConfigurations) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeEventConfigurations::send) it.

    /// - On success, responds with [`DescribeEventConfigurationsOutput`](crate::output::DescribeEventConfigurationsOutput) with field(s):
    ///   - [`event_configurations(Option<HashMap<EventType, Configuration>>)`](crate::output::DescribeEventConfigurationsOutput::event_configurations): <p>The event configurations.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeEventConfigurationsOutput::creation_date): <p>The creation date of the event configuration.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeEventConfigurationsOutput::last_modified_date): <p>The date the event configurations were last modified.</p>
    /// - On failure, responds with [`SdkError<DescribeEventConfigurationsError>`](crate::error::DescribeEventConfigurationsError)
    pub fn describe_event_configurations(
        &self,
    ) -> fluent_builders::DescribeEventConfigurations<C, M, R> {
        fluent_builders::DescribeEventConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFleetMetric`](crate::client::fluent_builders::DescribeFleetMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::DescribeFleetMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::DescribeFleetMetric::set_metric_name): <p>The name of the fleet metric to describe.</p>
    /// - On success, responds with [`DescribeFleetMetricOutput`](crate::output::DescribeFleetMetricOutput) with field(s):
    ///   - [`metric_name(Option<String>)`](crate::output::DescribeFleetMetricOutput::metric_name): <p>The name of the fleet metric to describe.</p>
    ///   - [`query_string(Option<String>)`](crate::output::DescribeFleetMetricOutput::query_string): <p>The search query string.</p>
    ///   - [`aggregation_type(Option<AggregationType>)`](crate::output::DescribeFleetMetricOutput::aggregation_type): <p>The type of the aggregation query.</p>
    ///   - [`period(Option<i32>)`](crate::output::DescribeFleetMetricOutput::period): <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
    ///   - [`aggregation_field(Option<String>)`](crate::output::DescribeFleetMetricOutput::aggregation_field): <p>The field to aggregate.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeFleetMetricOutput::description): <p>The fleet metric description.</p>
    ///   - [`query_version(Option<String>)`](crate::output::DescribeFleetMetricOutput::query_version): <p>The query version.</p>
    ///   - [`index_name(Option<String>)`](crate::output::DescribeFleetMetricOutput::index_name): <p>The name of the index to search.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeFleetMetricOutput::creation_date): <p>The date when the fleet metric is created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeFleetMetricOutput::last_modified_date): <p>The date when the fleet metric is last modified.</p>
    ///   - [`unit(Option<FleetMetricUnit>)`](crate::output::DescribeFleetMetricOutput::unit): <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.</p>
    ///   - [`version(i64)`](crate::output::DescribeFleetMetricOutput::version): <p>The version of the fleet metric.</p>
    ///   - [`metric_arn(Option<String>)`](crate::output::DescribeFleetMetricOutput::metric_arn): <p>The ARN of the fleet metric to describe.</p>
    /// - On failure, responds with [`SdkError<DescribeFleetMetricError>`](crate::error::DescribeFleetMetricError)
    pub fn describe_fleet_metric(&self) -> fluent_builders::DescribeFleetMetric<C, M, R> {
        fluent_builders::DescribeFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIndex`](crate::client::fluent_builders::DescribeIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::DescribeIndex::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::DescribeIndex::set_index_name): <p>The index name.</p>
    /// - On success, responds with [`DescribeIndexOutput`](crate::output::DescribeIndexOutput) with field(s):
    ///   - [`index_name(Option<String>)`](crate::output::DescribeIndexOutput::index_name): <p>The index name.</p>
    ///   - [`index_status(Option<IndexStatus>)`](crate::output::DescribeIndexOutput::index_status): <p>The index status.</p>
    ///   - [`schema(Option<String>)`](crate::output::DescribeIndexOutput::schema): <p>Contains a value that specifies the type of indexing performed. Valid values are:</p>  <ul>   <li> <p>REGISTRY – Your thing index contains only registry data.</p> </li>   <li> <p>REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.</p> </li>   <li> <p>REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status data.</p> </li>   <li> <p>REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing connectivity status data.</p> </li>   <li> <p>MULTI_INDEXING_MODE - Your thing index contains multiple data sources. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_GetIndexingConfiguration.html">GetIndexingConfiguration</a>.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeIndexError>`](crate::error::DescribeIndexError)
    pub fn describe_index(&self) -> fluent_builders::DescribeIndex<C, M, R> {
        fluent_builders::DescribeIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJob`](crate::client::fluent_builders::DescribeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeJob::set_job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    /// - On success, responds with [`DescribeJobOutput`](crate::output::DescribeJobOutput) with field(s):
    ///   - [`document_source(Option<String>)`](crate::output::DescribeJobOutput::document_source): <p>An S3 link to the job document.</p>
    ///   - [`job(Option<Job>)`](crate::output::DescribeJobOutput::job): <p>Information about the job.</p>
    /// - On failure, responds with [`SdkError<DescribeJobError>`](crate::error::DescribeJobError)
    pub fn describe_job(&self) -> fluent_builders::DescribeJob<C, M, R> {
        fluent_builders::DescribeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobExecution`](crate::client::fluent_builders::DescribeJobExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJobExecution::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeJobExecution::set_job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::DescribeJobExecution::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::DescribeJobExecution::set_thing_name): <p>The name of the thing on which the job execution is running.</p>
    ///   - [`execution_number(i64)`](crate::client::fluent_builders::DescribeJobExecution::execution_number) / [`set_execution_number(Option<i64>)`](crate::client::fluent_builders::DescribeJobExecution::set_execution_number): <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
    /// - On success, responds with [`DescribeJobExecutionOutput`](crate::output::DescribeJobExecutionOutput) with field(s):
    ///   - [`execution(Option<JobExecution>)`](crate::output::DescribeJobExecutionOutput::execution): <p>Information about the job execution.</p>
    /// - On failure, responds with [`SdkError<DescribeJobExecutionError>`](crate::error::DescribeJobExecutionError)
    pub fn describe_job_execution(&self) -> fluent_builders::DescribeJobExecution<C, M, R> {
        fluent_builders::DescribeJobExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJobTemplate`](crate::client::fluent_builders::DescribeJobTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_template_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJobTemplate::job_template_id) / [`set_job_template_id(Option<String>)`](crate::client::fluent_builders::DescribeJobTemplate::set_job_template_id): <p>The unique identifier of the job template.</p>
    /// - On success, responds with [`DescribeJobTemplateOutput`](crate::output::DescribeJobTemplateOutput) with field(s):
    ///   - [`job_template_arn(Option<String>)`](crate::output::DescribeJobTemplateOutput::job_template_arn): <p>The ARN of the job template.</p>
    ///   - [`job_template_id(Option<String>)`](crate::output::DescribeJobTemplateOutput::job_template_id): <p>The unique identifier of the job template.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeJobTemplateOutput::description): <p>A description of the job template.</p>
    ///   - [`document_source(Option<String>)`](crate::output::DescribeJobTemplateOutput::document_source): <p>An S3 link to the job document.</p>
    ///   - [`document(Option<String>)`](crate::output::DescribeJobTemplateOutput::document): <p>The job document.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DescribeJobTemplateOutput::created_at): <p>The time, in seconds since the epoch, when the job template was created.</p>
    ///   - [`presigned_url_config(Option<PresignedUrlConfig>)`](crate::output::DescribeJobTemplateOutput::presigned_url_config): <p>Configuration for pre-signed S3 URLs.</p>
    ///   - [`job_executions_rollout_config(Option<JobExecutionsRolloutConfig>)`](crate::output::DescribeJobTemplateOutput::job_executions_rollout_config): <p>Allows you to create a staged rollout of a job.</p>
    ///   - [`abort_config(Option<AbortConfig>)`](crate::output::DescribeJobTemplateOutput::abort_config): <p>The criteria that determine when and how a job abort takes place.</p>
    ///   - [`timeout_config(Option<TimeoutConfig>)`](crate::output::DescribeJobTemplateOutput::timeout_config): <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
    ///   - [`job_executions_retry_config(Option<JobExecutionsRetryConfig>)`](crate::output::DescribeJobTemplateOutput::job_executions_retry_config): <p>The configuration that determines how many retries are allowed for each failure type for a job.</p>
    /// - On failure, responds with [`SdkError<DescribeJobTemplateError>`](crate::error::DescribeJobTemplateError)
    pub fn describe_job_template(&self) -> fluent_builders::DescribeJobTemplate<C, M, R> {
        fluent_builders::DescribeJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeManagedJobTemplate`](crate::client::fluent_builders::DescribeManagedJobTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedJobTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DescribeManagedJobTemplate::set_template_name): <p>The unique name of a managed job template, which is required.</p>
    ///   - [`template_version(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedJobTemplate::template_version) / [`set_template_version(Option<String>)`](crate::client::fluent_builders::DescribeManagedJobTemplate::set_template_version): <p>An optional parameter to specify version of a managed template. If not specified, the pre-defined default version is returned.</p>
    /// - On success, responds with [`DescribeManagedJobTemplateOutput`](crate::output::DescribeManagedJobTemplateOutput) with field(s):
    ///   - [`template_name(Option<String>)`](crate::output::DescribeManagedJobTemplateOutput::template_name): <p>The unique name of a managed template, such as <code>AWS-Reboot</code>.</p>
    ///   - [`template_arn(Option<String>)`](crate::output::DescribeManagedJobTemplateOutput::template_arn): <p>The unique Amazon Resource Name (ARN) of the managed template.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeManagedJobTemplateOutput::description): <p>The unique description of a managed template.</p>
    ///   - [`template_version(Option<String>)`](crate::output::DescribeManagedJobTemplateOutput::template_version): <p>The version for a managed template.</p>
    ///   - [`environments(Option<Vec<String>>)`](crate::output::DescribeManagedJobTemplateOutput::environments): <p>A list of environments that are supported with the managed job template.</p>
    ///   - [`document_parameters(Option<Vec<DocumentParameter>>)`](crate::output::DescribeManagedJobTemplateOutput::document_parameters): <p>A map of key-value pairs that you can use as guidance to specify the inputs for creating a job from a managed template.</p>
    ///   - [`document(Option<String>)`](crate::output::DescribeManagedJobTemplateOutput::document): <p>The document schema for a managed job template.</p>
    /// - On failure, responds with [`SdkError<DescribeManagedJobTemplateError>`](crate::error::DescribeManagedJobTemplateError)
    pub fn describe_managed_job_template(
        &self,
    ) -> fluent_builders::DescribeManagedJobTemplate<C, M, R> {
        fluent_builders::DescribeManagedJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMitigationAction`](crate::client::fluent_builders::DescribeMitigationAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_name(impl Into<String>)`](crate::client::fluent_builders::DescribeMitigationAction::action_name) / [`set_action_name(Option<String>)`](crate::client::fluent_builders::DescribeMitigationAction::set_action_name): <p>The friendly name that uniquely identifies the mitigation action.</p>
    /// - On success, responds with [`DescribeMitigationActionOutput`](crate::output::DescribeMitigationActionOutput) with field(s):
    ///   - [`action_name(Option<String>)`](crate::output::DescribeMitigationActionOutput::action_name): <p>The friendly name that uniquely identifies the mitigation action.</p>
    ///   - [`action_type(Option<MitigationActionType>)`](crate::output::DescribeMitigationActionOutput::action_type): <p>The type of mitigation action.</p>
    ///   - [`action_arn(Option<String>)`](crate::output::DescribeMitigationActionOutput::action_arn): <p>The ARN that identifies this migration action.</p>
    ///   - [`action_id(Option<String>)`](crate::output::DescribeMitigationActionOutput::action_id): <p>A unique identifier for this action.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeMitigationActionOutput::role_arn): <p>The ARN of the IAM role used to apply this action.</p>
    ///   - [`action_params(Option<MitigationActionParams>)`](crate::output::DescribeMitigationActionOutput::action_params): <p>Parameters that control how the mitigation action is applied, specific to the type of mitigation action.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeMitigationActionOutput::creation_date): <p>The date and time when the mitigation action was added to your Amazon Web Services accounts.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeMitigationActionOutput::last_modified_date): <p>The date and time when the mitigation action was last changed.</p>
    /// - On failure, responds with [`SdkError<DescribeMitigationActionError>`](crate::error::DescribeMitigationActionError)
    pub fn describe_mitigation_action(&self) -> fluent_builders::DescribeMitigationAction<C, M, R> {
        fluent_builders::DescribeMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProvisioningTemplate`](crate::client::fluent_builders::DescribeProvisioningTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningTemplate::set_template_name): <p>The name of the fleet provisioning template.</p>
    /// - On success, responds with [`DescribeProvisioningTemplateOutput`](crate::output::DescribeProvisioningTemplateOutput) with field(s):
    ///   - [`template_arn(Option<String>)`](crate::output::DescribeProvisioningTemplateOutput::template_arn): <p>The ARN of the fleet provisioning template.</p>
    ///   - [`template_name(Option<String>)`](crate::output::DescribeProvisioningTemplateOutput::template_name): <p>The name of the fleet provisioning template.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeProvisioningTemplateOutput::description): <p>The description of the fleet provisioning template.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeProvisioningTemplateOutput::creation_date): <p>The date when the fleet provisioning template was created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeProvisioningTemplateOutput::last_modified_date): <p>The date when the fleet provisioning template was last modified.</p>
    ///   - [`default_version_id(Option<i32>)`](crate::output::DescribeProvisioningTemplateOutput::default_version_id): <p>The default fleet template version ID.</p>
    ///   - [`template_body(Option<String>)`](crate::output::DescribeProvisioningTemplateOutput::template_body): <p>The JSON formatted contents of the fleet provisioning template.</p>
    ///   - [`enabled(bool)`](crate::output::DescribeProvisioningTemplateOutput::enabled): <p>True if the fleet provisioning template is enabled, otherwise false.</p>
    ///   - [`provisioning_role_arn(Option<String>)`](crate::output::DescribeProvisioningTemplateOutput::provisioning_role_arn): <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
    ///   - [`pre_provisioning_hook(Option<ProvisioningHook>)`](crate::output::DescribeProvisioningTemplateOutput::pre_provisioning_hook): <p>Gets information about a pre-provisioned hook.</p>
    /// - On failure, responds with [`SdkError<DescribeProvisioningTemplateError>`](crate::error::DescribeProvisioningTemplateError)
    pub fn describe_provisioning_template(
        &self,
    ) -> fluent_builders::DescribeProvisioningTemplate<C, M, R> {
        fluent_builders::DescribeProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProvisioningTemplateVersion`](crate::client::fluent_builders::DescribeProvisioningTemplateVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProvisioningTemplateVersion::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::DescribeProvisioningTemplateVersion::set_template_name): <p>The template name.</p>
    ///   - [`version_id(i32)`](crate::client::fluent_builders::DescribeProvisioningTemplateVersion::version_id) / [`set_version_id(Option<i32>)`](crate::client::fluent_builders::DescribeProvisioningTemplateVersion::set_version_id): <p>The fleet provisioning template version ID.</p>
    /// - On success, responds with [`DescribeProvisioningTemplateVersionOutput`](crate::output::DescribeProvisioningTemplateVersionOutput) with field(s):
    ///   - [`version_id(Option<i32>)`](crate::output::DescribeProvisioningTemplateVersionOutput::version_id): <p>The fleet provisioning template version ID.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeProvisioningTemplateVersionOutput::creation_date): <p>The date when the fleet provisioning template version was created.</p>
    ///   - [`template_body(Option<String>)`](crate::output::DescribeProvisioningTemplateVersionOutput::template_body): <p>The JSON formatted contents of the fleet provisioning template version.</p>
    ///   - [`is_default_version(bool)`](crate::output::DescribeProvisioningTemplateVersionOutput::is_default_version): <p>True if the fleet provisioning template version is the default version.</p>
    /// - On failure, responds with [`SdkError<DescribeProvisioningTemplateVersionError>`](crate::error::DescribeProvisioningTemplateVersionError)
    pub fn describe_provisioning_template_version(
        &self,
    ) -> fluent_builders::DescribeProvisioningTemplateVersion<C, M, R> {
        fluent_builders::DescribeProvisioningTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRoleAlias`](crate::client::fluent_builders::DescribeRoleAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_alias(impl Into<String>)`](crate::client::fluent_builders::DescribeRoleAlias::role_alias) / [`set_role_alias(Option<String>)`](crate::client::fluent_builders::DescribeRoleAlias::set_role_alias): <p>The role alias to describe.</p>
    /// - On success, responds with [`DescribeRoleAliasOutput`](crate::output::DescribeRoleAliasOutput) with field(s):
    ///   - [`role_alias_description(Option<RoleAliasDescription>)`](crate::output::DescribeRoleAliasOutput::role_alias_description): <p>The role alias description.</p>
    /// - On failure, responds with [`SdkError<DescribeRoleAliasError>`](crate::error::DescribeRoleAliasError)
    pub fn describe_role_alias(&self) -> fluent_builders::DescribeRoleAlias<C, M, R> {
        fluent_builders::DescribeRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeScheduledAudit`](crate::client::fluent_builders::DescribeScheduledAudit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scheduled_audit_name(impl Into<String>)`](crate::client::fluent_builders::DescribeScheduledAudit::scheduled_audit_name) / [`set_scheduled_audit_name(Option<String>)`](crate::client::fluent_builders::DescribeScheduledAudit::set_scheduled_audit_name): <p>The name of the scheduled audit whose information you want to get.</p>
    /// - On success, responds with [`DescribeScheduledAuditOutput`](crate::output::DescribeScheduledAuditOutput) with field(s):
    ///   - [`frequency(Option<AuditFrequency>)`](crate::output::DescribeScheduledAuditOutput::frequency): <p>How often the scheduled audit takes place, either one of <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    ///   - [`day_of_month(Option<String>)`](crate::output::DescribeScheduledAuditOutput::day_of_month): <p>The day of the month on which the scheduled audit takes place. This is will be <code>1</code> through <code>31</code> or <code>LAST</code>. If days <code>29</code>-<code>31</code> are specified, and the month does not have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
    ///   - [`day_of_week(Option<DayOfWeek>)`](crate::output::DescribeScheduledAuditOutput::day_of_week): <p>The day of the week on which the scheduled audit takes place, either one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>.</p>
    ///   - [`target_check_names(Option<Vec<String>>)`](crate::output::DescribeScheduledAuditOutput::target_check_names): <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`scheduled_audit_name(Option<String>)`](crate::output::DescribeScheduledAuditOutput::scheduled_audit_name): <p>The name of the scheduled audit.</p>
    ///   - [`scheduled_audit_arn(Option<String>)`](crate::output::DescribeScheduledAuditOutput::scheduled_audit_arn): <p>The ARN of the scheduled audit.</p>
    /// - On failure, responds with [`SdkError<DescribeScheduledAuditError>`](crate::error::DescribeScheduledAuditError)
    pub fn describe_scheduled_audit(&self) -> fluent_builders::DescribeScheduledAudit<C, M, R> {
        fluent_builders::DescribeScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecurityProfile`](crate::client::fluent_builders::DescribeSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::DescribeSecurityProfile::set_security_profile_name): <p>The name of the security profile whose information you want to get.</p>
    /// - On success, responds with [`DescribeSecurityProfileOutput`](crate::output::DescribeSecurityProfileOutput) with field(s):
    ///   - [`security_profile_name(Option<String>)`](crate::output::DescribeSecurityProfileOutput::security_profile_name): <p>The name of the security profile.</p>
    ///   - [`security_profile_arn(Option<String>)`](crate::output::DescribeSecurityProfileOutput::security_profile_arn): <p>The ARN of the security profile.</p>
    ///   - [`security_profile_description(Option<String>)`](crate::output::DescribeSecurityProfileOutput::security_profile_description): <p>A description of the security profile (associated with the security profile when it was created or updated).</p>
    ///   - [`behaviors(Option<Vec<Behavior>>)`](crate::output::DescribeSecurityProfileOutput::behaviors): <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    ///   - [`alert_targets(Option<HashMap<AlertTargetType, AlertTarget>>)`](crate::output::DescribeSecurityProfileOutput::alert_targets): <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    ///   - [`additional_metrics_to_retain(Option<Vec<String>>)`](crate::output::DescribeSecurityProfileOutput::additional_metrics_to_retain): <p> <i>Please use <code>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>  <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
    ///   - [`additional_metrics_to_retain_v2(Option<Vec<MetricToRetain>>)`](crate::output::DescribeSecurityProfileOutput::additional_metrics_to_retain_v2): <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here.</p>
    ///   - [`version(i64)`](crate::output::DescribeSecurityProfileOutput::version): <p>The version of the security profile. A new version is generated whenever the security profile is updated.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeSecurityProfileOutput::creation_date): <p>The time the security profile was created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeSecurityProfileOutput::last_modified_date): <p>The time the security profile was last modified.</p>
    /// - On failure, responds with [`SdkError<DescribeSecurityProfileError>`](crate::error::DescribeSecurityProfileError)
    pub fn describe_security_profile(&self) -> fluent_builders::DescribeSecurityProfile<C, M, R> {
        fluent_builders::DescribeSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStream`](crate::client::fluent_builders::DescribeStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::DescribeStream::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::DescribeStream::set_stream_id): <p>The stream ID.</p>
    /// - On success, responds with [`DescribeStreamOutput`](crate::output::DescribeStreamOutput) with field(s):
    ///   - [`stream_info(Option<StreamInfo>)`](crate::output::DescribeStreamOutput::stream_info): <p>Information about the stream.</p>
    /// - On failure, responds with [`SdkError<DescribeStreamError>`](crate::error::DescribeStreamError)
    pub fn describe_stream(&self) -> fluent_builders::DescribeStream<C, M, R> {
        fluent_builders::DescribeStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeThing`](crate::client::fluent_builders::DescribeThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::DescribeThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::DescribeThing::set_thing_name): <p>The name of the thing.</p>
    /// - On success, responds with [`DescribeThingOutput`](crate::output::DescribeThingOutput) with field(s):
    ///   - [`default_client_id(Option<String>)`](crate::output::DescribeThingOutput::default_client_id): <p>The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID. Although we don’t require a mapping between a thing's registry name and its use of MQTT client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and the Device Shadow service.</p>  <p>This lets you better organize your IoT fleet without removing the flexibility of the underlying device certificate model or shadows.</p>
    ///   - [`thing_name(Option<String>)`](crate::output::DescribeThingOutput::thing_name): <p>The name of the thing.</p>
    ///   - [`thing_id(Option<String>)`](crate::output::DescribeThingOutput::thing_id): <p>The ID of the thing to describe.</p>
    ///   - [`thing_arn(Option<String>)`](crate::output::DescribeThingOutput::thing_arn): <p>The ARN of the thing to describe.</p>
    ///   - [`thing_type_name(Option<String>)`](crate::output::DescribeThingOutput::thing_type_name): <p>The thing type name.</p>
    ///   - [`attributes(Option<HashMap<String, String>>)`](crate::output::DescribeThingOutput::attributes): <p>The thing attributes.</p>
    ///   - [`version(i64)`](crate::output::DescribeThingOutput::version): <p>The current version of the thing record in the registry.</p> <note>   <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p>  </note>
    ///   - [`billing_group_name(Option<String>)`](crate::output::DescribeThingOutput::billing_group_name): <p>The name of the billing group the thing belongs to.</p>
    /// - On failure, responds with [`SdkError<DescribeThingError>`](crate::error::DescribeThingError)
    pub fn describe_thing(&self) -> fluent_builders::DescribeThing<C, M, R> {
        fluent_builders::DescribeThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeThingGroup`](crate::client::fluent_builders::DescribeThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::DescribeThingGroup::set_thing_group_name): <p>The name of the thing group.</p>
    /// - On success, responds with [`DescribeThingGroupOutput`](crate::output::DescribeThingGroupOutput) with field(s):
    ///   - [`thing_group_name(Option<String>)`](crate::output::DescribeThingGroupOutput::thing_group_name): <p>The name of the thing group.</p>
    ///   - [`thing_group_id(Option<String>)`](crate::output::DescribeThingGroupOutput::thing_group_id): <p>The thing group ID.</p>
    ///   - [`thing_group_arn(Option<String>)`](crate::output::DescribeThingGroupOutput::thing_group_arn): <p>The thing group ARN.</p>
    ///   - [`version(i64)`](crate::output::DescribeThingGroupOutput::version): <p>The version of the thing group.</p>
    ///   - [`thing_group_properties(Option<ThingGroupProperties>)`](crate::output::DescribeThingGroupOutput::thing_group_properties): <p>The thing group properties.</p>
    ///   - [`thing_group_metadata(Option<ThingGroupMetadata>)`](crate::output::DescribeThingGroupOutput::thing_group_metadata): <p>Thing group metadata.</p>
    ///   - [`index_name(Option<String>)`](crate::output::DescribeThingGroupOutput::index_name): <p>The dynamic thing group index name.</p>
    ///   - [`query_string(Option<String>)`](crate::output::DescribeThingGroupOutput::query_string): <p>The dynamic thing group search query string.</p>
    ///   - [`query_version(Option<String>)`](crate::output::DescribeThingGroupOutput::query_version): <p>The dynamic thing group query version.</p>
    ///   - [`status(Option<DynamicGroupStatus>)`](crate::output::DescribeThingGroupOutput::status): <p>The dynamic thing group status.</p>
    /// - On failure, responds with [`SdkError<DescribeThingGroupError>`](crate::error::DescribeThingGroupError)
    pub fn describe_thing_group(&self) -> fluent_builders::DescribeThingGroup<C, M, R> {
        fluent_builders::DescribeThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeThingRegistrationTask`](crate::client::fluent_builders::DescribeThingRegistrationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeThingRegistrationTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeThingRegistrationTask::set_task_id): <p>The task ID.</p>
    /// - On success, responds with [`DescribeThingRegistrationTaskOutput`](crate::output::DescribeThingRegistrationTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::DescribeThingRegistrationTaskOutput::task_id): <p>The task ID.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::DescribeThingRegistrationTaskOutput::creation_date): <p>The task creation date.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::DescribeThingRegistrationTaskOutput::last_modified_date): <p>The date when the task was last modified.</p>
    ///   - [`template_body(Option<String>)`](crate::output::DescribeThingRegistrationTaskOutput::template_body): <p>The task's template.</p>
    ///   - [`input_file_bucket(Option<String>)`](crate::output::DescribeThingRegistrationTaskOutput::input_file_bucket): <p>The S3 bucket that contains the input file.</p>
    ///   - [`input_file_key(Option<String>)`](crate::output::DescribeThingRegistrationTaskOutput::input_file_key): <p>The input file key.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeThingRegistrationTaskOutput::role_arn): <p>The role ARN that grants access to the input file bucket.</p>
    ///   - [`status(Option<Status>)`](crate::output::DescribeThingRegistrationTaskOutput::status): <p>The status of the bulk thing provisioning task.</p>
    ///   - [`message(Option<String>)`](crate::output::DescribeThingRegistrationTaskOutput::message): <p>The message.</p>
    ///   - [`success_count(i32)`](crate::output::DescribeThingRegistrationTaskOutput::success_count): <p>The number of things successfully provisioned.</p>
    ///   - [`failure_count(i32)`](crate::output::DescribeThingRegistrationTaskOutput::failure_count): <p>The number of things that failed to be provisioned.</p>
    ///   - [`percentage_progress(i32)`](crate::output::DescribeThingRegistrationTaskOutput::percentage_progress): <p>The progress of the bulk provisioning task expressed as a percentage.</p>
    /// - On failure, responds with [`SdkError<DescribeThingRegistrationTaskError>`](crate::error::DescribeThingRegistrationTaskError)
    pub fn describe_thing_registration_task(
        &self,
    ) -> fluent_builders::DescribeThingRegistrationTask<C, M, R> {
        fluent_builders::DescribeThingRegistrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeThingType`](crate::client::fluent_builders::DescribeThingType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::DescribeThingType::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::DescribeThingType::set_thing_type_name): <p>The name of the thing type.</p>
    /// - On success, responds with [`DescribeThingTypeOutput`](crate::output::DescribeThingTypeOutput) with field(s):
    ///   - [`thing_type_name(Option<String>)`](crate::output::DescribeThingTypeOutput::thing_type_name): <p>The name of the thing type.</p>
    ///   - [`thing_type_id(Option<String>)`](crate::output::DescribeThingTypeOutput::thing_type_id): <p>The thing type ID.</p>
    ///   - [`thing_type_arn(Option<String>)`](crate::output::DescribeThingTypeOutput::thing_type_arn): <p>The thing type ARN.</p>
    ///   - [`thing_type_properties(Option<ThingTypeProperties>)`](crate::output::DescribeThingTypeOutput::thing_type_properties): <p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>
    ///   - [`thing_type_metadata(Option<ThingTypeMetadata>)`](crate::output::DescribeThingTypeOutput::thing_type_metadata): <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>
    /// - On failure, responds with [`SdkError<DescribeThingTypeError>`](crate::error::DescribeThingTypeError)
    pub fn describe_thing_type(&self) -> fluent_builders::DescribeThingType<C, M, R> {
        fluent_builders::DescribeThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachPolicy`](crate::client::fluent_builders::DetachPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::DetachPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::DetachPolicy::set_policy_name): <p>The policy to detach.</p>
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::DetachPolicy::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::DetachPolicy::set_target): <p>The target from which the policy will be detached.</p>
    /// - On success, responds with [`DetachPolicyOutput`](crate::output::DetachPolicyOutput)

    /// - On failure, responds with [`SdkError<DetachPolicyError>`](crate::error::DetachPolicyError)
    pub fn detach_policy(&self) -> fluent_builders::DetachPolicy<C, M, R> {
        fluent_builders::DetachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachPrincipalPolicy`](crate::client::fluent_builders::DetachPrincipalPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::DetachPrincipalPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::DetachPrincipalPolicy::set_policy_name): <p>The name of the policy to detach.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::DetachPrincipalPolicy::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::DetachPrincipalPolicy::set_principal): <p>The principal.</p>  <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    /// - On success, responds with [`DetachPrincipalPolicyOutput`](crate::output::DetachPrincipalPolicyOutput)

    /// - On failure, responds with [`SdkError<DetachPrincipalPolicyError>`](crate::error::DetachPrincipalPolicyError)
    pub fn detach_principal_policy(&self) -> fluent_builders::DetachPrincipalPolicy<C, M, R> {
        fluent_builders::DetachPrincipalPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachSecurityProfile`](crate::client::fluent_builders::DetachSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::DetachSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::DetachSecurityProfile::set_security_profile_name): <p>The security profile that is detached.</p>
    ///   - [`security_profile_target_arn(impl Into<String>)`](crate::client::fluent_builders::DetachSecurityProfile::security_profile_target_arn) / [`set_security_profile_target_arn(Option<String>)`](crate::client::fluent_builders::DetachSecurityProfile::set_security_profile_target_arn): <p>The ARN of the thing group from which the security profile is detached.</p>
    /// - On success, responds with [`DetachSecurityProfileOutput`](crate::output::DetachSecurityProfileOutput)

    /// - On failure, responds with [`SdkError<DetachSecurityProfileError>`](crate::error::DetachSecurityProfileError)
    pub fn detach_security_profile(&self) -> fluent_builders::DetachSecurityProfile<C, M, R> {
        fluent_builders::DetachSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetachThingPrincipal`](crate::client::fluent_builders::DetachThingPrincipal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::DetachThingPrincipal::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::DetachThingPrincipal::set_thing_name): <p>The name of the thing.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::DetachThingPrincipal::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::DetachThingPrincipal::set_principal): <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
    /// - On success, responds with [`DetachThingPrincipalOutput`](crate::output::DetachThingPrincipalOutput)

    /// - On failure, responds with [`SdkError<DetachThingPrincipalError>`](crate::error::DetachThingPrincipalError)
    pub fn detach_thing_principal(&self) -> fluent_builders::DetachThingPrincipal<C, M, R> {
        fluent_builders::DetachThingPrincipal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableTopicRule`](crate::client::fluent_builders::DisableTopicRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::DisableTopicRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::DisableTopicRule::set_rule_name): <p>The name of the rule to disable.</p>
    /// - On success, responds with [`DisableTopicRuleOutput`](crate::output::DisableTopicRuleOutput)

    /// - On failure, responds with [`SdkError<DisableTopicRuleError>`](crate::error::DisableTopicRuleError)
    pub fn disable_topic_rule(&self) -> fluent_builders::DisableTopicRule<C, M, R> {
        fluent_builders::DisableTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableTopicRule`](crate::client::fluent_builders::EnableTopicRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::EnableTopicRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::EnableTopicRule::set_rule_name): <p>The name of the topic rule to enable.</p>
    /// - On success, responds with [`EnableTopicRuleOutput`](crate::output::EnableTopicRuleOutput)

    /// - On failure, responds with [`SdkError<EnableTopicRuleError>`](crate::error::EnableTopicRuleError)
    pub fn enable_topic_rule(&self) -> fluent_builders::EnableTopicRule<C, M, R> {
        fluent_builders::EnableTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBehaviorModelTrainingSummaries`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::set_security_profile_name): <p> The name of the security profile. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::set_max_results): <p> The maximum number of results to return at one time. The default is 25. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::set_next_token): <p> The token for the next set of results. </p>
    /// - On success, responds with [`GetBehaviorModelTrainingSummariesOutput`](crate::output::GetBehaviorModelTrainingSummariesOutput) with field(s):
    ///   - [`summaries(Option<Vec<BehaviorModelTrainingSummary>>)`](crate::output::GetBehaviorModelTrainingSummariesOutput::summaries): <p> A list of all ML Detect behaviors and their model status for a given Security Profile. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBehaviorModelTrainingSummariesOutput::next_token): <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    /// - On failure, responds with [`SdkError<GetBehaviorModelTrainingSummariesError>`](crate::error::GetBehaviorModelTrainingSummariesError)
    pub fn get_behavior_model_training_summaries(
        &self,
    ) -> fluent_builders::GetBehaviorModelTrainingSummaries<C, M, R> {
        fluent_builders::GetBehaviorModelTrainingSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketsAggregation`](crate::client::fluent_builders::GetBucketsAggregation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::GetBucketsAggregation::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::GetBucketsAggregation::set_index_name): <p>The name of the index to search.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::GetBucketsAggregation::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::GetBucketsAggregation::set_query_string): <p>The search query string.</p>
    ///   - [`aggregation_field(impl Into<String>)`](crate::client::fluent_builders::GetBucketsAggregation::aggregation_field) / [`set_aggregation_field(Option<String>)`](crate::client::fluent_builders::GetBucketsAggregation::set_aggregation_field): <p>The aggregation field.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::GetBucketsAggregation::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::GetBucketsAggregation::set_query_version): <p>The version of the query.</p>
    ///   - [`buckets_aggregation_type(BucketsAggregationType)`](crate::client::fluent_builders::GetBucketsAggregation::buckets_aggregation_type) / [`set_buckets_aggregation_type(Option<BucketsAggregationType>)`](crate::client::fluent_builders::GetBucketsAggregation::set_buckets_aggregation_type): <p>The basic control of the response shape and the bucket aggregation type to perform. </p>
    /// - On success, responds with [`GetBucketsAggregationOutput`](crate::output::GetBucketsAggregationOutput) with field(s):
    ///   - [`total_count(i32)`](crate::output::GetBucketsAggregationOutput::total_count): <p>The total number of things that fit the query string criteria.</p>
    ///   - [`buckets(Option<Vec<Bucket>>)`](crate::output::GetBucketsAggregationOutput::buckets): <p>The main part of the response with a list of buckets. Each bucket contains a <code>keyValue</code> and a <code>count</code>.</p>  <p> <code>keyValue</code>: The aggregation field value counted for the particular bucket.</p>  <p> <code>count</code>: The number of documents that have that value.</p>
    /// - On failure, responds with [`SdkError<GetBucketsAggregationError>`](crate::error::GetBucketsAggregationError)
    pub fn get_buckets_aggregation(&self) -> fluent_builders::GetBucketsAggregation<C, M, R> {
        fluent_builders::GetBucketsAggregation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCardinality`](crate::client::fluent_builders::GetCardinality) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::GetCardinality::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::GetCardinality::set_index_name): <p>The name of the index to search.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::GetCardinality::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::GetCardinality::set_query_string): <p>The search query string.</p>
    ///   - [`aggregation_field(impl Into<String>)`](crate::client::fluent_builders::GetCardinality::aggregation_field) / [`set_aggregation_field(Option<String>)`](crate::client::fluent_builders::GetCardinality::set_aggregation_field): <p>The field to aggregate.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::GetCardinality::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::GetCardinality::set_query_version): <p>The query version.</p>
    /// - On success, responds with [`GetCardinalityOutput`](crate::output::GetCardinalityOutput) with field(s):
    ///   - [`cardinality(i32)`](crate::output::GetCardinalityOutput::cardinality): <p>The approximate count of unique values that match the query.</p>
    /// - On failure, responds with [`SdkError<GetCardinalityError>`](crate::error::GetCardinalityError)
    pub fn get_cardinality(&self) -> fluent_builders::GetCardinality<C, M, R> {
        fluent_builders::GetCardinality::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEffectivePolicies`](crate::client::fluent_builders::GetEffectivePolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::GetEffectivePolicies::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::GetEffectivePolicies::set_principal): <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    ///   - [`cognito_identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::GetEffectivePolicies::cognito_identity_pool_id) / [`set_cognito_identity_pool_id(Option<String>)`](crate::client::fluent_builders::GetEffectivePolicies::set_cognito_identity_pool_id): <p>The Cognito identity pool ID.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::GetEffectivePolicies::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::GetEffectivePolicies::set_thing_name): <p>The thing name.</p>
    /// - On success, responds with [`GetEffectivePoliciesOutput`](crate::output::GetEffectivePoliciesOutput) with field(s):
    ///   - [`effective_policies(Option<Vec<EffectivePolicy>>)`](crate::output::GetEffectivePoliciesOutput::effective_policies): <p>The effective policies.</p>
    /// - On failure, responds with [`SdkError<GetEffectivePoliciesError>`](crate::error::GetEffectivePoliciesError)
    pub fn get_effective_policies(&self) -> fluent_builders::GetEffectivePolicies<C, M, R> {
        fluent_builders::GetEffectivePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIndexingConfiguration`](crate::client::fluent_builders::GetIndexingConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetIndexingConfiguration::send) it.

    /// - On success, responds with [`GetIndexingConfigurationOutput`](crate::output::GetIndexingConfigurationOutput) with field(s):
    ///   - [`thing_indexing_configuration(Option<ThingIndexingConfiguration>)`](crate::output::GetIndexingConfigurationOutput::thing_indexing_configuration): <p>Thing indexing configuration.</p>
    ///   - [`thing_group_indexing_configuration(Option<ThingGroupIndexingConfiguration>)`](crate::output::GetIndexingConfigurationOutput::thing_group_indexing_configuration): <p>The index configuration.</p>
    /// - On failure, responds with [`SdkError<GetIndexingConfigurationError>`](crate::error::GetIndexingConfigurationError)
    pub fn get_indexing_configuration(&self) -> fluent_builders::GetIndexingConfiguration<C, M, R> {
        fluent_builders::GetIndexingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJobDocument`](crate::client::fluent_builders::GetJobDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetJobDocument::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetJobDocument::set_job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    /// - On success, responds with [`GetJobDocumentOutput`](crate::output::GetJobDocumentOutput) with field(s):
    ///   - [`document(Option<String>)`](crate::output::GetJobDocumentOutput::document): <p>The job document content.</p>
    /// - On failure, responds with [`SdkError<GetJobDocumentError>`](crate::error::GetJobDocumentError)
    pub fn get_job_document(&self) -> fluent_builders::GetJobDocument<C, M, R> {
        fluent_builders::GetJobDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLoggingOptions`](crate::client::fluent_builders::GetLoggingOptions) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetLoggingOptions::send) it.

    /// - On success, responds with [`GetLoggingOptionsOutput`](crate::output::GetLoggingOptionsOutput) with field(s):
    ///   - [`role_arn(Option<String>)`](crate::output::GetLoggingOptionsOutput::role_arn): <p>The ARN of the IAM role that grants access.</p>
    ///   - [`log_level(Option<LogLevel>)`](crate::output::GetLoggingOptionsOutput::log_level): <p>The logging level.</p>
    /// - On failure, responds with [`SdkError<GetLoggingOptionsError>`](crate::error::GetLoggingOptionsError)
    pub fn get_logging_options(&self) -> fluent_builders::GetLoggingOptions<C, M, R> {
        fluent_builders::GetLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOTAUpdate`](crate::client::fluent_builders::GetOTAUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ota_update_id(impl Into<String>)`](crate::client::fluent_builders::GetOTAUpdate::ota_update_id) / [`set_ota_update_id(Option<String>)`](crate::client::fluent_builders::GetOTAUpdate::set_ota_update_id): <p>The OTA update ID.</p>
    /// - On success, responds with [`GetOtaUpdateOutput`](crate::output::GetOtaUpdateOutput) with field(s):
    ///   - [`ota_update_info(Option<OtaUpdateInfo>)`](crate::output::GetOtaUpdateOutput::ota_update_info): <p>The OTA update info.</p>
    /// - On failure, responds with [`SdkError<GetOTAUpdateError>`](crate::error::GetOTAUpdateError)
    pub fn get_ota_update(&self) -> fluent_builders::GetOTAUpdate<C, M, R> {
        fluent_builders::GetOTAUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPercentiles`](crate::client::fluent_builders::GetPercentiles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::GetPercentiles::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::GetPercentiles::set_index_name): <p>The name of the index to search.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::GetPercentiles::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::GetPercentiles::set_query_string): <p>The search query string.</p>
    ///   - [`aggregation_field(impl Into<String>)`](crate::client::fluent_builders::GetPercentiles::aggregation_field) / [`set_aggregation_field(Option<String>)`](crate::client::fluent_builders::GetPercentiles::set_aggregation_field): <p>The field to aggregate.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::GetPercentiles::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::GetPercentiles::set_query_version): <p>The query version.</p>
    ///   - [`percents(Vec<f64>)`](crate::client::fluent_builders::GetPercentiles::percents) / [`set_percents(Option<Vec<f64>>)`](crate::client::fluent_builders::GetPercentiles::set_percents): <p>The percentile groups returned.</p>
    /// - On success, responds with [`GetPercentilesOutput`](crate::output::GetPercentilesOutput) with field(s):
    ///   - [`percentiles(Option<Vec<PercentPair>>)`](crate::output::GetPercentilesOutput::percentiles): <p>The percentile values of the aggregated fields.</p>
    /// - On failure, responds with [`SdkError<GetPercentilesError>`](crate::error::GetPercentilesError)
    pub fn get_percentiles(&self) -> fluent_builders::GetPercentiles<C, M, R> {
        fluent_builders::GetPercentiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPolicy`](crate::client::fluent_builders::GetPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::GetPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::GetPolicy::set_policy_name): <p>The name of the policy.</p>
    /// - On success, responds with [`GetPolicyOutput`](crate::output::GetPolicyOutput) with field(s):
    ///   - [`policy_name(Option<String>)`](crate::output::GetPolicyOutput::policy_name): <p>The policy name.</p>
    ///   - [`policy_arn(Option<String>)`](crate::output::GetPolicyOutput::policy_arn): <p>The policy ARN.</p>
    ///   - [`policy_document(Option<String>)`](crate::output::GetPolicyOutput::policy_document): <p>The JSON document that describes the policy.</p>
    ///   - [`default_version_id(Option<String>)`](crate::output::GetPolicyOutput::default_version_id): <p>The default policy version ID.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::GetPolicyOutput::creation_date): <p>The date the policy was created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::GetPolicyOutput::last_modified_date): <p>The date the policy was last modified.</p>
    ///   - [`generation_id(Option<String>)`](crate::output::GetPolicyOutput::generation_id): <p>The generation ID of the policy.</p>
    /// - On failure, responds with [`SdkError<GetPolicyError>`](crate::error::GetPolicyError)
    pub fn get_policy(&self) -> fluent_builders::GetPolicy<C, M, R> {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPolicyVersion`](crate::client::fluent_builders::GetPolicyVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::GetPolicyVersion::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::GetPolicyVersion::set_policy_name): <p>The name of the policy.</p>
    ///   - [`policy_version_id(impl Into<String>)`](crate::client::fluent_builders::GetPolicyVersion::policy_version_id) / [`set_policy_version_id(Option<String>)`](crate::client::fluent_builders::GetPolicyVersion::set_policy_version_id): <p>The policy version ID.</p>
    /// - On success, responds with [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput) with field(s):
    ///   - [`policy_arn(Option<String>)`](crate::output::GetPolicyVersionOutput::policy_arn): <p>The policy ARN.</p>
    ///   - [`policy_name(Option<String>)`](crate::output::GetPolicyVersionOutput::policy_name): <p>The policy name.</p>
    ///   - [`policy_document(Option<String>)`](crate::output::GetPolicyVersionOutput::policy_document): <p>The JSON document that describes the policy.</p>
    ///   - [`policy_version_id(Option<String>)`](crate::output::GetPolicyVersionOutput::policy_version_id): <p>The policy version ID.</p>
    ///   - [`is_default_version(bool)`](crate::output::GetPolicyVersionOutput::is_default_version): <p>Specifies whether the policy version is the default.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::GetPolicyVersionOutput::creation_date): <p>The date the policy was created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::GetPolicyVersionOutput::last_modified_date): <p>The date the policy was last modified.</p>
    ///   - [`generation_id(Option<String>)`](crate::output::GetPolicyVersionOutput::generation_id): <p>The generation ID of the policy version.</p>
    /// - On failure, responds with [`SdkError<GetPolicyVersionError>`](crate::error::GetPolicyVersionError)
    pub fn get_policy_version(&self) -> fluent_builders::GetPolicyVersion<C, M, R> {
        fluent_builders::GetPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRegistrationCode`](crate::client::fluent_builders::GetRegistrationCode) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetRegistrationCode::send) it.

    /// - On success, responds with [`GetRegistrationCodeOutput`](crate::output::GetRegistrationCodeOutput) with field(s):
    ///   - [`registration_code(Option<String>)`](crate::output::GetRegistrationCodeOutput::registration_code): <p>The CA certificate registration code.</p>
    /// - On failure, responds with [`SdkError<GetRegistrationCodeError>`](crate::error::GetRegistrationCodeError)
    pub fn get_registration_code(&self) -> fluent_builders::GetRegistrationCode<C, M, R> {
        fluent_builders::GetRegistrationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStatistics`](crate::client::fluent_builders::GetStatistics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::GetStatistics::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::GetStatistics::set_index_name): <p>The name of the index to search. The default value is <code>AWS_Things</code>.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::GetStatistics::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::GetStatistics::set_query_string): <p>The query used to search. You can specify "*" for the query string to get the count of all indexed things in your Amazon Web Services account.</p>
    ///   - [`aggregation_field(impl Into<String>)`](crate::client::fluent_builders::GetStatistics::aggregation_field) / [`set_aggregation_field(Option<String>)`](crate::client::fluent_builders::GetStatistics::set_aggregation_field): <p>The aggregation field name.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::GetStatistics::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::GetStatistics::set_query_version): <p>The version of the query used to search.</p>
    /// - On success, responds with [`GetStatisticsOutput`](crate::output::GetStatisticsOutput) with field(s):
    ///   - [`statistics(Option<Statistics>)`](crate::output::GetStatisticsOutput::statistics): <p>The statistics returned by the Fleet Indexing service based on the query and aggregation field.</p>
    /// - On failure, responds with [`SdkError<GetStatisticsError>`](crate::error::GetStatisticsError)
    pub fn get_statistics(&self) -> fluent_builders::GetStatistics<C, M, R> {
        fluent_builders::GetStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTopicRule`](crate::client::fluent_builders::GetTopicRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::GetTopicRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::GetTopicRule::set_rule_name): <p>The name of the rule.</p>
    /// - On success, responds with [`GetTopicRuleOutput`](crate::output::GetTopicRuleOutput) with field(s):
    ///   - [`rule_arn(Option<String>)`](crate::output::GetTopicRuleOutput::rule_arn): <p>The rule ARN.</p>
    ///   - [`rule(Option<TopicRule>)`](crate::output::GetTopicRuleOutput::rule): <p>The rule.</p>
    /// - On failure, responds with [`SdkError<GetTopicRuleError>`](crate::error::GetTopicRuleError)
    pub fn get_topic_rule(&self) -> fluent_builders::GetTopicRule<C, M, R> {
        fluent_builders::GetTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTopicRuleDestination`](crate::client::fluent_builders::GetTopicRuleDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetTopicRuleDestination::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetTopicRuleDestination::set_arn): <p>The ARN of the topic rule destination.</p>
    /// - On success, responds with [`GetTopicRuleDestinationOutput`](crate::output::GetTopicRuleDestinationOutput) with field(s):
    ///   - [`topic_rule_destination(Option<TopicRuleDestination>)`](crate::output::GetTopicRuleDestinationOutput::topic_rule_destination): <p>The topic rule destination.</p>
    /// - On failure, responds with [`SdkError<GetTopicRuleDestinationError>`](crate::error::GetTopicRuleDestinationError)
    pub fn get_topic_rule_destination(&self) -> fluent_builders::GetTopicRuleDestination<C, M, R> {
        fluent_builders::GetTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetV2LoggingOptions`](crate::client::fluent_builders::GetV2LoggingOptions) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetV2LoggingOptions::send) it.

    /// - On success, responds with [`GetV2LoggingOptionsOutput`](crate::output::GetV2LoggingOptionsOutput) with field(s):
    ///   - [`role_arn(Option<String>)`](crate::output::GetV2LoggingOptionsOutput::role_arn): <p>The IAM role ARN IoT uses to write to your CloudWatch logs.</p>
    ///   - [`default_log_level(Option<LogLevel>)`](crate::output::GetV2LoggingOptionsOutput::default_log_level): <p>The default log level.</p>
    ///   - [`disable_all_logs(bool)`](crate::output::GetV2LoggingOptionsOutput::disable_all_logs): <p>Disables all logs.</p>
    /// - On failure, responds with [`SdkError<GetV2LoggingOptionsError>`](crate::error::GetV2LoggingOptionsError)
    pub fn get_v2_logging_options(&self) -> fluent_builders::GetV2LoggingOptions<C, M, R> {
        fluent_builders::GetV2LoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListActiveViolations`](crate::client::fluent_builders::ListActiveViolations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListActiveViolations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::ListActiveViolations::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::ListActiveViolations::set_thing_name): <p>The name of the thing whose active violations are listed.</p>
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::ListActiveViolations::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::ListActiveViolations::set_security_profile_name): <p>The name of the Device Defender security profile for which violations are listed.</p>
    ///   - [`behavior_criteria_type(BehaviorCriteriaType)`](crate::client::fluent_builders::ListActiveViolations::behavior_criteria_type) / [`set_behavior_criteria_type(Option<BehaviorCriteriaType>)`](crate::client::fluent_builders::ListActiveViolations::set_behavior_criteria_type): <p> The criteria for a behavior. </p>
    ///   - [`list_suppressed_alerts(bool)`](crate::client::fluent_builders::ListActiveViolations::list_suppressed_alerts) / [`set_list_suppressed_alerts(Option<bool>)`](crate::client::fluent_builders::ListActiveViolations::set_list_suppressed_alerts): <p> A list of all suppressed alerts. </p>
    ///   - [`verification_state(VerificationState)`](crate::client::fluent_builders::ListActiveViolations::verification_state) / [`set_verification_state(Option<VerificationState>)`](crate::client::fluent_builders::ListActiveViolations::set_verification_state): <p>The verification state of the violation (detect alarm).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListActiveViolations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListActiveViolations::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListActiveViolations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListActiveViolations::set_max_results): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListActiveViolationsOutput`](crate::output::ListActiveViolationsOutput) with field(s):
    ///   - [`active_violations(Option<Vec<ActiveViolation>>)`](crate::output::ListActiveViolationsOutput::active_violations): <p>The list of active violations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListActiveViolationsOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListActiveViolationsError>`](crate::error::ListActiveViolationsError)
    pub fn list_active_violations(&self) -> fluent_builders::ListActiveViolations<C, M, R> {
        fluent_builders::ListActiveViolations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttachedPolicies`](crate::client::fluent_builders::ListAttachedPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttachedPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::ListAttachedPolicies::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::ListAttachedPolicies::set_target): <p>The group or principal for which the policies will be listed. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    ///   - [`recursive(bool)`](crate::client::fluent_builders::ListAttachedPolicies::recursive) / [`set_recursive(bool)`](crate::client::fluent_builders::ListAttachedPolicies::set_recursive): <p>When true, recursively list attached policies.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListAttachedPolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListAttachedPolicies::set_marker): <p>The token to retrieve the next set of results.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListAttachedPolicies::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListAttachedPolicies::set_page_size): <p>The maximum number of results to be returned per request.</p>
    /// - On success, responds with [`ListAttachedPoliciesOutput`](crate::output::ListAttachedPoliciesOutput) with field(s):
    ///   - [`policies(Option<Vec<Policy>>)`](crate::output::ListAttachedPoliciesOutput::policies): <p>The policies.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListAttachedPoliciesOutput::next_marker): <p>The token to retrieve the next set of results, or ``null`` if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAttachedPoliciesError>`](crate::error::ListAttachedPoliciesError)
    pub fn list_attached_policies(&self) -> fluent_builders::ListAttachedPolicies<C, M, R> {
        fluent_builders::ListAttachedPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAuditFindings`](crate::client::fluent_builders::ListAuditFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAuditFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::ListAuditFindings::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::ListAuditFindings::set_task_id): <p>A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime and endTime, but not both.</p>
    ///   - [`check_name(impl Into<String>)`](crate::client::fluent_builders::ListAuditFindings::check_name) / [`set_check_name(Option<String>)`](crate::client::fluent_builders::ListAuditFindings::set_check_name): <p>A filter to limit results to the findings for the specified audit check.</p>
    ///   - [`resource_identifier(ResourceIdentifier)`](crate::client::fluent_builders::ListAuditFindings::resource_identifier) / [`set_resource_identifier(Option<ResourceIdentifier>)`](crate::client::fluent_builders::ListAuditFindings::set_resource_identifier): <p>Information identifying the noncompliant resource.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAuditFindings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAuditFindings::set_max_results): <p>The maximum number of results to return at one time. The default is 25.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAuditFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAuditFindings::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListAuditFindings::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListAuditFindings::set_start_time): <p>A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListAuditFindings::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListAuditFindings::set_end_time): <p>A filter to limit results to those found before the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
    ///   - [`list_suppressed_findings(bool)`](crate::client::fluent_builders::ListAuditFindings::list_suppressed_findings) / [`set_list_suppressed_findings(bool)`](crate::client::fluent_builders::ListAuditFindings::set_list_suppressed_findings): <p> Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be listed. If this parameter isn't provided, the response will list both suppressed and unsuppressed findings. </p>
    /// - On success, responds with [`ListAuditFindingsOutput`](crate::output::ListAuditFindingsOutput) with field(s):
    ///   - [`findings(Option<Vec<AuditFinding>>)`](crate::output::ListAuditFindingsOutput::findings): <p>The findings (results) of the audit.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAuditFindingsOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListAuditFindingsError>`](crate::error::ListAuditFindingsError)
    pub fn list_audit_findings(&self) -> fluent_builders::ListAuditFindings<C, M, R> {
        fluent_builders::ListAuditFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAuditMitigationActionsExecutions`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::set_task_id): <p>Specify this filter to limit results to actions for a specific audit mitigation actions task.</p>
    ///   - [`action_status(AuditMitigationActionsExecutionStatus)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::action_status) / [`set_action_status(Option<AuditMitigationActionsExecutionStatus>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::set_action_status): <p>Specify this filter to limit results to those with a specific status.</p>
    ///   - [`finding_id(impl Into<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::finding_id) / [`set_finding_id(Option<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::set_finding_id): <p>Specify this filter to limit results to those that were applied to a specific audit finding.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::set_max_results): <p>The maximum number of results to return at one time. The default is 25.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::set_next_token): <p>The token for the next set of results.</p>
    /// - On success, responds with [`ListAuditMitigationActionsExecutionsOutput`](crate::output::ListAuditMitigationActionsExecutionsOutput) with field(s):
    ///   - [`actions_executions(Option<Vec<AuditMitigationActionExecutionMetadata>>)`](crate::output::ListAuditMitigationActionsExecutionsOutput::actions_executions): <p>A set of task execution results based on the input parameters. Details include the mitigation action applied, start time, and task status.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAuditMitigationActionsExecutionsOutput::next_token): <p>The token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAuditMitigationActionsExecutionsError>`](crate::error::ListAuditMitigationActionsExecutionsError)
    pub fn list_audit_mitigation_actions_executions(
        &self,
    ) -> fluent_builders::ListAuditMitigationActionsExecutions<C, M, R> {
        fluent_builders::ListAuditMitigationActionsExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAuditMitigationActionsTasks`](crate::client::fluent_builders::ListAuditMitigationActionsTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`audit_task_id(impl Into<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::audit_task_id) / [`set_audit_task_id(Option<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::set_audit_task_id): <p>Specify this filter to limit results to tasks that were applied to results for a specific audit.</p>
    ///   - [`finding_id(impl Into<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::finding_id) / [`set_finding_id(Option<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::set_finding_id): <p>Specify this filter to limit results to tasks that were applied to a specific audit finding.</p>
    ///   - [`task_status(AuditMitigationActionsTaskStatus)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::task_status) / [`set_task_status(Option<AuditMitigationActionsTaskStatus>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::set_task_status): <p>Specify this filter to limit results to tasks that are in a specific state.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::set_max_results): <p>The maximum number of results to return at one time. The default is 25.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::set_start_time): <p>Specify this filter to limit results to tasks that began on or after a specific date and time.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::set_end_time): <p>Specify this filter to limit results to tasks that were completed or canceled on or before a specific date and time.</p>
    /// - On success, responds with [`ListAuditMitigationActionsTasksOutput`](crate::output::ListAuditMitigationActionsTasksOutput) with field(s):
    ///   - [`tasks(Option<Vec<AuditMitigationActionsTaskMetadata>>)`](crate::output::ListAuditMitigationActionsTasksOutput::tasks): <p>The collection of audit mitigation tasks that matched the filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAuditMitigationActionsTasksOutput::next_token): <p>The token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAuditMitigationActionsTasksError>`](crate::error::ListAuditMitigationActionsTasksError)
    pub fn list_audit_mitigation_actions_tasks(
        &self,
    ) -> fluent_builders::ListAuditMitigationActionsTasks<C, M, R> {
        fluent_builders::ListAuditMitigationActionsTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAuditSuppressions`](crate::client::fluent_builders::ListAuditSuppressions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAuditSuppressions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_name(impl Into<String>)`](crate::client::fluent_builders::ListAuditSuppressions::check_name) / [`set_check_name(Option<String>)`](crate::client::fluent_builders::ListAuditSuppressions::set_check_name): <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`resource_identifier(ResourceIdentifier)`](crate::client::fluent_builders::ListAuditSuppressions::resource_identifier) / [`set_resource_identifier(Option<ResourceIdentifier>)`](crate::client::fluent_builders::ListAuditSuppressions::set_resource_identifier): <p>Information that identifies the noncompliant resource.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListAuditSuppressions::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListAuditSuppressions::set_ascending_order): <p> Determines whether suppressions are listed in ascending order by expiration date or not. If parameter isn't provided, <code>ascendingOrder=true</code>. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAuditSuppressions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAuditSuppressions::set_next_token): <p> The token for the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAuditSuppressions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAuditSuppressions::set_max_results): <p> The maximum number of results to return at one time. The default is 25. </p>
    /// - On success, responds with [`ListAuditSuppressionsOutput`](crate::output::ListAuditSuppressionsOutput) with field(s):
    ///   - [`suppressions(Option<Vec<AuditSuppression>>)`](crate::output::ListAuditSuppressionsOutput::suppressions): <p> List of audit suppressions. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAuditSuppressionsOutput::next_token): <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    /// - On failure, responds with [`SdkError<ListAuditSuppressionsError>`](crate::error::ListAuditSuppressionsError)
    pub fn list_audit_suppressions(&self) -> fluent_builders::ListAuditSuppressions<C, M, R> {
        fluent_builders::ListAuditSuppressions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAuditTasks`](crate::client::fluent_builders::ListAuditTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAuditTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListAuditTasks::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListAuditTasks::set_start_time): <p>The beginning of the time period. Audit information is retained for a limited time (90 days). Requesting a start time prior to what is retained results in an "InvalidRequestException".</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListAuditTasks::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListAuditTasks::set_end_time): <p>The end of the time period.</p>
    ///   - [`task_type(AuditTaskType)`](crate::client::fluent_builders::ListAuditTasks::task_type) / [`set_task_type(Option<AuditTaskType>)`](crate::client::fluent_builders::ListAuditTasks::set_task_type): <p>A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".</p>
    ///   - [`task_status(AuditTaskStatus)`](crate::client::fluent_builders::ListAuditTasks::task_status) / [`set_task_status(Option<AuditTaskStatus>)`](crate::client::fluent_builders::ListAuditTasks::set_task_status): <p>A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAuditTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAuditTasks::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAuditTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAuditTasks::set_max_results): <p>The maximum number of results to return at one time. The default is 25.</p>
    /// - On success, responds with [`ListAuditTasksOutput`](crate::output::ListAuditTasksOutput) with field(s):
    ///   - [`tasks(Option<Vec<AuditTaskMetadata>>)`](crate::output::ListAuditTasksOutput::tasks): <p>The audits that were performed during the specified time period.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAuditTasksOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListAuditTasksError>`](crate::error::ListAuditTasksError)
    pub fn list_audit_tasks(&self) -> fluent_builders::ListAuditTasks<C, M, R> {
        fluent_builders::ListAuditTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAuthorizers`](crate::client::fluent_builders::ListAuthorizers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAuthorizers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListAuthorizers::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListAuthorizers::set_page_size): <p>The maximum number of results to return at one time.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListAuthorizers::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListAuthorizers::set_marker): <p>A marker used to get the next set of results.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListAuthorizers::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListAuthorizers::set_ascending_order): <p>Return the list of authorizers in ascending alphabetical order.</p>
    ///   - [`status(AuthorizerStatus)`](crate::client::fluent_builders::ListAuthorizers::status) / [`set_status(Option<AuthorizerStatus>)`](crate::client::fluent_builders::ListAuthorizers::set_status): <p>The status of the list authorizers request.</p>
    /// - On success, responds with [`ListAuthorizersOutput`](crate::output::ListAuthorizersOutput) with field(s):
    ///   - [`authorizers(Option<Vec<AuthorizerSummary>>)`](crate::output::ListAuthorizersOutput::authorizers): <p>The authorizers.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListAuthorizersOutput::next_marker): <p>A marker used to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAuthorizersError>`](crate::error::ListAuthorizersError)
    pub fn list_authorizers(&self) -> fluent_builders::ListAuthorizers<C, M, R> {
        fluent_builders::ListAuthorizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBillingGroups`](crate::client::fluent_builders::ListBillingGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBillingGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBillingGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBillingGroups::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBillingGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBillingGroups::set_max_results): <p>The maximum number of results to return per request.</p>
    ///   - [`name_prefix_filter(impl Into<String>)`](crate::client::fluent_builders::ListBillingGroups::name_prefix_filter) / [`set_name_prefix_filter(Option<String>)`](crate::client::fluent_builders::ListBillingGroups::set_name_prefix_filter): <p>Limit the results to billing groups whose names have the given prefix.</p>
    /// - On success, responds with [`ListBillingGroupsOutput`](crate::output::ListBillingGroupsOutput) with field(s):
    ///   - [`billing_groups(Option<Vec<GroupNameAndArn>>)`](crate::output::ListBillingGroupsOutput::billing_groups): <p>The list of billing groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBillingGroupsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListBillingGroupsError>`](crate::error::ListBillingGroupsError)
    pub fn list_billing_groups(&self) -> fluent_builders::ListBillingGroups<C, M, R> {
        fluent_builders::ListBillingGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCACertificates`](crate::client::fluent_builders::ListCACertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCACertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListCACertificates::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListCACertificates::set_page_size): <p>The result page size.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListCACertificates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListCACertificates::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListCACertificates::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListCACertificates::set_ascending_order): <p>Determines the order of the results.</p>
    /// - On success, responds with [`ListCaCertificatesOutput`](crate::output::ListCaCertificatesOutput) with field(s):
    ///   - [`certificates(Option<Vec<CaCertificate>>)`](crate::output::ListCaCertificatesOutput::certificates): <p>The CA certificates registered in your Amazon Web Services account.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListCaCertificatesOutput::next_marker): <p>The current position within the list of CA certificates.</p>
    /// - On failure, responds with [`SdkError<ListCACertificatesError>`](crate::error::ListCACertificatesError)
    pub fn list_ca_certificates(&self) -> fluent_builders::ListCACertificates<C, M, R> {
        fluent_builders::ListCACertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCertificates`](crate::client::fluent_builders::ListCertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListCertificates::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListCertificates::set_page_size): <p>The result page size.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListCertificates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListCertificates::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListCertificates::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListCertificates::set_ascending_order): <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
    /// - On success, responds with [`ListCertificatesOutput`](crate::output::ListCertificatesOutput) with field(s):
    ///   - [`certificates(Option<Vec<Certificate>>)`](crate::output::ListCertificatesOutput::certificates): <p>The descriptions of the certificates.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListCertificatesOutput::next_marker): <p>The marker for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListCertificatesError>`](crate::error::ListCertificatesError)
    pub fn list_certificates(&self) -> fluent_builders::ListCertificates<C, M, R> {
        fluent_builders::ListCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCertificatesByCA`](crate::client::fluent_builders::ListCertificatesByCA) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCertificatesByCA::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`ca_certificate_id(impl Into<String>)`](crate::client::fluent_builders::ListCertificatesByCA::ca_certificate_id) / [`set_ca_certificate_id(Option<String>)`](crate::client::fluent_builders::ListCertificatesByCA::set_ca_certificate_id): <p>The ID of the CA certificate. This operation will list all registered device certificate that were signed by this CA certificate.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListCertificatesByCA::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListCertificatesByCA::set_page_size): <p>The result page size.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListCertificatesByCA::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListCertificatesByCA::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListCertificatesByCA::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListCertificatesByCA::set_ascending_order): <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
    /// - On success, responds with [`ListCertificatesByCaOutput`](crate::output::ListCertificatesByCaOutput) with field(s):
    ///   - [`certificates(Option<Vec<Certificate>>)`](crate::output::ListCertificatesByCaOutput::certificates): <p>The device certificates signed by the specified CA certificate.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListCertificatesByCaOutput::next_marker): <p>The marker for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListCertificatesByCAError>`](crate::error::ListCertificatesByCAError)
    pub fn list_certificates_by_ca(&self) -> fluent_builders::ListCertificatesByCA<C, M, R> {
        fluent_builders::ListCertificatesByCA::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomMetrics`](crate::client::fluent_builders::ListCustomMetrics) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomMetrics::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomMetrics::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomMetrics::set_next_token): <p> The token for the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomMetrics::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomMetrics::set_max_results): <p> The maximum number of results to return at one time. The default is 25. </p>
    /// - On success, responds with [`ListCustomMetricsOutput`](crate::output::ListCustomMetricsOutput) with field(s):
    ///   - [`metric_names(Option<Vec<String>>)`](crate::output::ListCustomMetricsOutput::metric_names): <p> The name of the custom metric. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomMetricsOutput::next_token): <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    /// - On failure, responds with [`SdkError<ListCustomMetricsError>`](crate::error::ListCustomMetricsError)
    pub fn list_custom_metrics(&self) -> fluent_builders::ListCustomMetrics<C, M, R> {
        fluent_builders::ListCustomMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDetectMitigationActionsExecutions`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::set_task_id): <p> The unique identifier of the task. </p>
    ///   - [`violation_id(impl Into<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::violation_id) / [`set_violation_id(Option<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::set_violation_id): <p> The unique identifier of the violation. </p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::set_thing_name): <p> The name of the thing whose mitigation actions are listed. </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::set_start_time): <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::set_end_time): <p> The end of the time period for which ML Detect mitigation actions executions are returned. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::set_max_results): <p> The maximum number of results to return at one time. The default is 25. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::set_next_token): <p> The token for the next set of results. </p>
    /// - On success, responds with [`ListDetectMitigationActionsExecutionsOutput`](crate::output::ListDetectMitigationActionsExecutionsOutput) with field(s):
    ///   - [`actions_executions(Option<Vec<DetectMitigationActionExecution>>)`](crate::output::ListDetectMitigationActionsExecutionsOutput::actions_executions): <p> List of actions executions. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDetectMitigationActionsExecutionsOutput::next_token): <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    /// - On failure, responds with [`SdkError<ListDetectMitigationActionsExecutionsError>`](crate::error::ListDetectMitigationActionsExecutionsError)
    pub fn list_detect_mitigation_actions_executions(
        &self,
    ) -> fluent_builders::ListDetectMitigationActionsExecutions<C, M, R> {
        fluent_builders::ListDetectMitigationActionsExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDetectMitigationActionsTasks`](crate::client::fluent_builders::ListDetectMitigationActionsTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::set_max_results): <p>The maximum number of results to return at one time. The default is 25.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::set_next_token): <p> The token for the next set of results. </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::set_start_time): <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::set_end_time): <p> The end of the time period for which ML Detect mitigation actions tasks are returned. </p>
    /// - On success, responds with [`ListDetectMitigationActionsTasksOutput`](crate::output::ListDetectMitigationActionsTasksOutput) with field(s):
    ///   - [`tasks(Option<Vec<DetectMitigationActionsTaskSummary>>)`](crate::output::ListDetectMitigationActionsTasksOutput::tasks): <p> The collection of ML Detect mitigation tasks that matched the filter criteria. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDetectMitigationActionsTasksOutput::next_token): <p> A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results. </p>
    /// - On failure, responds with [`SdkError<ListDetectMitigationActionsTasksError>`](crate::error::ListDetectMitigationActionsTasksError)
    pub fn list_detect_mitigation_actions_tasks(
        &self,
    ) -> fluent_builders::ListDetectMitigationActionsTasks<C, M, R> {
        fluent_builders::ListDetectMitigationActionsTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDimensions`](crate::client::fluent_builders::ListDimensions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDimensions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDimensions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDimensions::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDimensions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDimensions::set_max_results): <p>The maximum number of results to retrieve at one time.</p>
    /// - On success, responds with [`ListDimensionsOutput`](crate::output::ListDimensionsOutput) with field(s):
    ///   - [`dimension_names(Option<Vec<String>>)`](crate::output::ListDimensionsOutput::dimension_names): <p>A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDimensionsOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListDimensionsError>`](crate::error::ListDimensionsError)
    pub fn list_dimensions(&self) -> fluent_builders::ListDimensions<C, M, R> {
        fluent_builders::ListDimensions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainConfigurations`](crate::client::fluent_builders::ListDomainConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomainConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDomainConfigurations::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDomainConfigurations::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListDomainConfigurations::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListDomainConfigurations::set_page_size): <p>The result page size.</p>
    ///   - [`service_type(ServiceType)`](crate::client::fluent_builders::ListDomainConfigurations::service_type) / [`set_service_type(Option<ServiceType>)`](crate::client::fluent_builders::ListDomainConfigurations::set_service_type): <p>The type of service delivered by the endpoint.</p>
    /// - On success, responds with [`ListDomainConfigurationsOutput`](crate::output::ListDomainConfigurationsOutput) with field(s):
    ///   - [`domain_configurations(Option<Vec<DomainConfigurationSummary>>)`](crate::output::ListDomainConfigurationsOutput::domain_configurations): <p>A list of objects that contain summary information about the user's domain configurations.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListDomainConfigurationsOutput::next_marker): <p>The marker for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDomainConfigurationsError>`](crate::error::ListDomainConfigurationsError)
    pub fn list_domain_configurations(&self) -> fluent_builders::ListDomainConfigurations<C, M, R> {
        fluent_builders::ListDomainConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFleetMetrics`](crate::client::fluent_builders::ListFleetMetrics) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFleetMetrics::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFleetMetrics::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFleetMetrics::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <code>null</code> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFleetMetrics::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFleetMetrics::set_max_results): <p>The maximum number of results to return in this operation.</p>
    /// - On success, responds with [`ListFleetMetricsOutput`](crate::output::ListFleetMetricsOutput) with field(s):
    ///   - [`fleet_metrics(Option<Vec<FleetMetricNameAndArn>>)`](crate::output::ListFleetMetricsOutput::fleet_metrics): <p>The list of fleet metrics objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFleetMetricsOutput::next_token): <p>The token for the next set of results. Will not be returned if the operation has returned all results.</p>
    /// - On failure, responds with [`SdkError<ListFleetMetricsError>`](crate::error::ListFleetMetricsError)
    pub fn list_fleet_metrics(&self) -> fluent_builders::ListFleetMetrics<C, M, R> {
        fluent_builders::ListFleetMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIndices`](crate::client::fluent_builders::ListIndices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIndices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIndices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIndices::set_next_token): <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIndices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIndices::set_max_results): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListIndicesOutput`](crate::output::ListIndicesOutput) with field(s):
    ///   - [`index_names(Option<Vec<String>>)`](crate::output::ListIndicesOutput::index_names): <p>The index names.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIndicesOutput::next_token): <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListIndicesError>`](crate::error::ListIndicesError)
    pub fn list_indices(&self) -> fluent_builders::ListIndices<C, M, R> {
        fluent_builders::ListIndices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobExecutionsForJob`](crate::client::fluent_builders::ListJobExecutionsForJob) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobExecutionsForJob::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::ListJobExecutionsForJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::ListJobExecutionsForJob::set_job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    ///   - [`status(JobExecutionStatus)`](crate::client::fluent_builders::ListJobExecutionsForJob::status) / [`set_status(Option<JobExecutionStatus>)`](crate::client::fluent_builders::ListJobExecutionsForJob::set_status): <p>The status of the job.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobExecutionsForJob::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobExecutionsForJob::set_max_results): <p>The maximum number of results to be returned per request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobExecutionsForJob::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobExecutionsForJob::set_next_token): <p>The token to retrieve the next set of results.</p>
    /// - On success, responds with [`ListJobExecutionsForJobOutput`](crate::output::ListJobExecutionsForJobOutput) with field(s):
    ///   - [`execution_summaries(Option<Vec<JobExecutionSummaryForJob>>)`](crate::output::ListJobExecutionsForJobOutput::execution_summaries): <p>A list of job execution summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobExecutionsForJobOutput::next_token): <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListJobExecutionsForJobError>`](crate::error::ListJobExecutionsForJobError)
    pub fn list_job_executions_for_job(&self) -> fluent_builders::ListJobExecutionsForJob<C, M, R> {
        fluent_builders::ListJobExecutionsForJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobExecutionsForThing`](crate::client::fluent_builders::ListJobExecutionsForThing) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobExecutionsForThing::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::set_thing_name): <p>The thing name.</p>
    ///   - [`status(JobExecutionStatus)`](crate::client::fluent_builders::ListJobExecutionsForThing::status) / [`set_status(Option<JobExecutionStatus>)`](crate::client::fluent_builders::ListJobExecutionsForThing::set_status): <p>An optional filter that lets you search for jobs that have the specified status.</p>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::set_namespace_id): <p>The namespace used to indicate that a job is a customer-managed job.</p>  <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>  <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>   <p>The <code>namespaceId</code> feature is in public preview.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobExecutionsForThing::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobExecutionsForThing::set_max_results): <p>The maximum number of results to be returned per request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::set_next_token): <p>The token to retrieve the next set of results.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::ListJobExecutionsForThing::set_job_id): <p>The unique identifier you assigned to this job when it was created.</p>
    /// - On success, responds with [`ListJobExecutionsForThingOutput`](crate::output::ListJobExecutionsForThingOutput) with field(s):
    ///   - [`execution_summaries(Option<Vec<JobExecutionSummaryForThing>>)`](crate::output::ListJobExecutionsForThingOutput::execution_summaries): <p>A list of job execution summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobExecutionsForThingOutput::next_token): <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListJobExecutionsForThingError>`](crate::error::ListJobExecutionsForThingError)
    pub fn list_job_executions_for_thing(
        &self,
    ) -> fluent_builders::ListJobExecutionsForThing<C, M, R> {
        fluent_builders::ListJobExecutionsForThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobs`](crate::client::fluent_builders::ListJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`status(JobStatus)`](crate::client::fluent_builders::ListJobs::status) / [`set_status(Option<JobStatus>)`](crate::client::fluent_builders::ListJobs::set_status): <p>An optional filter that lets you search for jobs that have the specified status.</p>
    ///   - [`target_selection(TargetSelection)`](crate::client::fluent_builders::ListJobs::target_selection) / [`set_target_selection(Option<TargetSelection>)`](crate::client::fluent_builders::ListJobs::set_target_selection): <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobs::set_max_results): <p>The maximum number of results to return per request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobs::set_next_token): <p>The token to retrieve the next set of results.</p>
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::ListJobs::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::ListJobs::set_thing_group_name): <p>A filter that limits the returned jobs to those for the specified group.</p>
    ///   - [`thing_group_id(impl Into<String>)`](crate::client::fluent_builders::ListJobs::thing_group_id) / [`set_thing_group_id(Option<String>)`](crate::client::fluent_builders::ListJobs::set_thing_group_id): <p>A filter that limits the returned jobs to those for the specified group.</p>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::ListJobs::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::ListJobs::set_namespace_id): <p>The namespace used to indicate that a job is a customer-managed job.</p>  <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>  <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>   <p>The <code>namespaceId</code> feature is in public preview.</p>  </note>
    /// - On success, responds with [`ListJobsOutput`](crate::output::ListJobsOutput) with field(s):
    ///   - [`jobs(Option<Vec<JobSummary>>)`](crate::output::ListJobsOutput::jobs): <p>A list of jobs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobsOutput::next_token): <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListJobsError>`](crate::error::ListJobsError)
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobTemplates`](crate::client::fluent_builders::ListJobTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobTemplates::set_max_results): <p>The maximum number of results to return in the list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobTemplates::set_next_token): <p>The token to use to return the next set of results in the list.</p>
    /// - On success, responds with [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput) with field(s):
    ///   - [`job_templates(Option<Vec<JobTemplateSummary>>)`](crate::output::ListJobTemplatesOutput::job_templates): <p>A list of objects that contain information about the job templates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobTemplatesOutput::next_token): <p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListJobTemplatesError>`](crate::error::ListJobTemplatesError)
    pub fn list_job_templates(&self) -> fluent_builders::ListJobTemplates<C, M, R> {
        fluent_builders::ListJobTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListManagedJobTemplates`](crate::client::fluent_builders::ListManagedJobTemplates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::ListManagedJobTemplates::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::ListManagedJobTemplates::set_template_name): <p>An optional parameter for template name. If specified, only the versions of the managed job templates that have the specified template name will be returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListManagedJobTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListManagedJobTemplates::set_max_results): <p>Maximum number of entries that can be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListManagedJobTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListManagedJobTemplates::set_next_token): <p>The token to retrieve the next set of results.</p>
    /// - On success, responds with [`ListManagedJobTemplatesOutput`](crate::output::ListManagedJobTemplatesOutput) with field(s):
    ///   - [`managed_job_templates(Option<Vec<ManagedJobTemplateSummary>>)`](crate::output::ListManagedJobTemplatesOutput::managed_job_templates): <p>A list of managed job templates that are returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListManagedJobTemplatesOutput::next_token): <p>The token to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListManagedJobTemplatesError>`](crate::error::ListManagedJobTemplatesError)
    pub fn list_managed_job_templates(&self) -> fluent_builders::ListManagedJobTemplates<C, M, R> {
        fluent_builders::ListManagedJobTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMitigationActions`](crate::client::fluent_builders::ListMitigationActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMitigationActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_type(MitigationActionType)`](crate::client::fluent_builders::ListMitigationActions::action_type) / [`set_action_type(Option<MitigationActionType>)`](crate::client::fluent_builders::ListMitigationActions::set_action_type): <p>Specify a value to limit the result to mitigation actions with a specific action type.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMitigationActions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMitigationActions::set_max_results): <p>The maximum number of results to return at one time. The default is 25.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMitigationActions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMitigationActions::set_next_token): <p>The token for the next set of results.</p>
    /// - On success, responds with [`ListMitigationActionsOutput`](crate::output::ListMitigationActionsOutput) with field(s):
    ///   - [`action_identifiers(Option<Vec<MitigationActionIdentifier>>)`](crate::output::ListMitigationActionsOutput::action_identifiers): <p>A set of actions that matched the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMitigationActionsOutput::next_token): <p>The token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListMitigationActionsError>`](crate::error::ListMitigationActionsError)
    pub fn list_mitigation_actions(&self) -> fluent_builders::ListMitigationActions<C, M, R> {
        fluent_builders::ListMitigationActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOTAUpdates`](crate::client::fluent_builders::ListOTAUpdates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOTAUpdates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOTAUpdates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOTAUpdates::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOTAUpdates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOTAUpdates::set_next_token): <p>A token used to retrieve the next set of results.</p>
    ///   - [`ota_update_status(OtaUpdateStatus)`](crate::client::fluent_builders::ListOTAUpdates::ota_update_status) / [`set_ota_update_status(Option<OtaUpdateStatus>)`](crate::client::fluent_builders::ListOTAUpdates::set_ota_update_status): <p>The OTA update job status.</p>
    /// - On success, responds with [`ListOtaUpdatesOutput`](crate::output::ListOtaUpdatesOutput) with field(s):
    ///   - [`ota_updates(Option<Vec<OtaUpdateSummary>>)`](crate::output::ListOtaUpdatesOutput::ota_updates): <p>A list of OTA update jobs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOtaUpdatesOutput::next_token): <p>A token to use to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListOTAUpdatesError>`](crate::error::ListOTAUpdatesError)
    pub fn list_ota_updates(&self) -> fluent_builders::ListOTAUpdates<C, M, R> {
        fluent_builders::ListOTAUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOutgoingCertificates`](crate::client::fluent_builders::ListOutgoingCertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOutgoingCertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListOutgoingCertificates::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListOutgoingCertificates::set_page_size): <p>The result page size.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListOutgoingCertificates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListOutgoingCertificates::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListOutgoingCertificates::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListOutgoingCertificates::set_ascending_order): <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
    /// - On success, responds with [`ListOutgoingCertificatesOutput`](crate::output::ListOutgoingCertificatesOutput) with field(s):
    ///   - [`outgoing_certificates(Option<Vec<OutgoingCertificate>>)`](crate::output::ListOutgoingCertificatesOutput::outgoing_certificates): <p>The certificates that are being transferred but not yet accepted.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListOutgoingCertificatesOutput::next_marker): <p>The marker for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListOutgoingCertificatesError>`](crate::error::ListOutgoingCertificatesError)
    pub fn list_outgoing_certificates(&self) -> fluent_builders::ListOutgoingCertificates<C, M, R> {
        fluent_builders::ListOutgoingCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPolicies`](crate::client::fluent_builders::ListPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListPolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListPolicies::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListPolicies::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListPolicies::set_page_size): <p>The result page size.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListPolicies::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListPolicies::set_ascending_order): <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
    /// - On success, responds with [`ListPoliciesOutput`](crate::output::ListPoliciesOutput) with field(s):
    ///   - [`policies(Option<Vec<Policy>>)`](crate::output::ListPoliciesOutput::policies): <p>The descriptions of the policies.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListPoliciesOutput::next_marker): <p>The marker for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListPoliciesError>`](crate::error::ListPoliciesError)
    pub fn list_policies(&self) -> fluent_builders::ListPolicies<C, M, R> {
        fluent_builders::ListPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPolicyPrincipals`](crate::client::fluent_builders::ListPolicyPrincipals) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPolicyPrincipals::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::ListPolicyPrincipals::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::ListPolicyPrincipals::set_policy_name): <p>The policy name.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListPolicyPrincipals::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListPolicyPrincipals::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListPolicyPrincipals::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListPolicyPrincipals::set_page_size): <p>The result page size.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListPolicyPrincipals::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListPolicyPrincipals::set_ascending_order): <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
    /// - On success, responds with [`ListPolicyPrincipalsOutput`](crate::output::ListPolicyPrincipalsOutput) with field(s):
    ///   - [`principals(Option<Vec<String>>)`](crate::output::ListPolicyPrincipalsOutput::principals): <p>The descriptions of the principals.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListPolicyPrincipalsOutput::next_marker): <p>The marker for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListPolicyPrincipalsError>`](crate::error::ListPolicyPrincipalsError)
    pub fn list_policy_principals(&self) -> fluent_builders::ListPolicyPrincipals<C, M, R> {
        fluent_builders::ListPolicyPrincipals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPolicyVersions`](crate::client::fluent_builders::ListPolicyVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::ListPolicyVersions::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::ListPolicyVersions::set_policy_name): <p>The policy name.</p>
    /// - On success, responds with [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput) with field(s):
    ///   - [`policy_versions(Option<Vec<PolicyVersion>>)`](crate::output::ListPolicyVersionsOutput::policy_versions): <p>The policy versions.</p>
    /// - On failure, responds with [`SdkError<ListPolicyVersionsError>`](crate::error::ListPolicyVersionsError)
    pub fn list_policy_versions(&self) -> fluent_builders::ListPolicyVersions<C, M, R> {
        fluent_builders::ListPolicyVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPrincipalPolicies`](crate::client::fluent_builders::ListPrincipalPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPrincipalPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::ListPrincipalPolicies::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::ListPrincipalPolicies::set_principal): <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListPrincipalPolicies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListPrincipalPolicies::set_marker): <p>The marker for the next set of results.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListPrincipalPolicies::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListPrincipalPolicies::set_page_size): <p>The result page size.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListPrincipalPolicies::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListPrincipalPolicies::set_ascending_order): <p>Specifies the order for results. If true, results are returned in ascending creation order.</p>
    /// - On success, responds with [`ListPrincipalPoliciesOutput`](crate::output::ListPrincipalPoliciesOutput) with field(s):
    ///   - [`policies(Option<Vec<Policy>>)`](crate::output::ListPrincipalPoliciesOutput::policies): <p>The policies.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListPrincipalPoliciesOutput::next_marker): <p>The marker for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListPrincipalPoliciesError>`](crate::error::ListPrincipalPoliciesError)
    pub fn list_principal_policies(&self) -> fluent_builders::ListPrincipalPolicies<C, M, R> {
        fluent_builders::ListPrincipalPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPrincipalThings`](crate::client::fluent_builders::ListPrincipalThings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPrincipalThings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPrincipalThings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPrincipalThings::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPrincipalThings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPrincipalThings::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::ListPrincipalThings::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::ListPrincipalThings::set_principal): <p>The principal.</p>
    /// - On success, responds with [`ListPrincipalThingsOutput`](crate::output::ListPrincipalThingsOutput) with field(s):
    ///   - [`things(Option<Vec<String>>)`](crate::output::ListPrincipalThingsOutput::things): <p>The things.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPrincipalThingsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListPrincipalThingsError>`](crate::error::ListPrincipalThingsError)
    pub fn list_principal_things(&self) -> fluent_builders::ListPrincipalThings<C, M, R> {
        fluent_builders::ListPrincipalThings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProvisioningTemplates`](crate::client::fluent_builders::ListProvisioningTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProvisioningTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProvisioningTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProvisioningTemplates::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProvisioningTemplates::set_next_token): <p>A token to retrieve the next set of results.</p>
    /// - On success, responds with [`ListProvisioningTemplatesOutput`](crate::output::ListProvisioningTemplatesOutput) with field(s):
    ///   - [`templates(Option<Vec<ProvisioningTemplateSummary>>)`](crate::output::ListProvisioningTemplatesOutput::templates): <p>A list of fleet provisioning templates</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProvisioningTemplatesOutput::next_token): <p>A token to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListProvisioningTemplatesError>`](crate::error::ListProvisioningTemplatesError)
    pub fn list_provisioning_templates(
        &self,
    ) -> fluent_builders::ListProvisioningTemplates<C, M, R> {
        fluent_builders::ListProvisioningTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProvisioningTemplateVersions`](crate::client::fluent_builders::ListProvisioningTemplateVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProvisioningTemplateVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningTemplateVersions::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::ListProvisioningTemplateVersions::set_template_name): <p>The name of the fleet provisioning template.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProvisioningTemplateVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProvisioningTemplateVersions::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProvisioningTemplateVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProvisioningTemplateVersions::set_next_token): <p>A token to retrieve the next set of results.</p>
    /// - On success, responds with [`ListProvisioningTemplateVersionsOutput`](crate::output::ListProvisioningTemplateVersionsOutput) with field(s):
    ///   - [`versions(Option<Vec<ProvisioningTemplateVersionSummary>>)`](crate::output::ListProvisioningTemplateVersionsOutput::versions): <p>The list of fleet provisioning template versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProvisioningTemplateVersionsOutput::next_token): <p>A token to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListProvisioningTemplateVersionsError>`](crate::error::ListProvisioningTemplateVersionsError)
    pub fn list_provisioning_template_versions(
        &self,
    ) -> fluent_builders::ListProvisioningTemplateVersions<C, M, R> {
        fluent_builders::ListProvisioningTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRoleAliases`](crate::client::fluent_builders::ListRoleAliases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRoleAliases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListRoleAliases::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListRoleAliases::set_page_size): <p>The maximum number of results to return at one time.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListRoleAliases::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListRoleAliases::set_marker): <p>A marker used to get the next set of results.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListRoleAliases::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListRoleAliases::set_ascending_order): <p>Return the list of role aliases in ascending alphabetical order.</p>
    /// - On success, responds with [`ListRoleAliasesOutput`](crate::output::ListRoleAliasesOutput) with field(s):
    ///   - [`role_aliases(Option<Vec<String>>)`](crate::output::ListRoleAliasesOutput::role_aliases): <p>The role aliases.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListRoleAliasesOutput::next_marker): <p>A marker used to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListRoleAliasesError>`](crate::error::ListRoleAliasesError)
    pub fn list_role_aliases(&self) -> fluent_builders::ListRoleAliases<C, M, R> {
        fluent_builders::ListRoleAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListScheduledAudits`](crate::client::fluent_builders::ListScheduledAudits) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListScheduledAudits::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListScheduledAudits::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListScheduledAudits::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListScheduledAudits::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListScheduledAudits::set_max_results): <p>The maximum number of results to return at one time. The default is 25.</p>
    /// - On success, responds with [`ListScheduledAuditsOutput`](crate::output::ListScheduledAuditsOutput) with field(s):
    ///   - [`scheduled_audits(Option<Vec<ScheduledAuditMetadata>>)`](crate::output::ListScheduledAuditsOutput::scheduled_audits): <p>The list of scheduled audits.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListScheduledAuditsOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListScheduledAuditsError>`](crate::error::ListScheduledAuditsError)
    pub fn list_scheduled_audits(&self) -> fluent_builders::ListScheduledAudits<C, M, R> {
        fluent_builders::ListScheduledAudits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecurityProfiles`](crate::client::fluent_builders::ListSecurityProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecurityProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecurityProfiles::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecurityProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecurityProfiles::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`dimension_name(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfiles::dimension_name) / [`set_dimension_name(Option<String>)`](crate::client::fluent_builders::ListSecurityProfiles::set_dimension_name): <p>A filter to limit results to the security profiles that use the defined dimension. Cannot be used with <code>metricName</code> </p>
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfiles::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::ListSecurityProfiles::set_metric_name): <p> The name of the custom metric. Cannot be used with <code>dimensionName</code>. </p>
    /// - On success, responds with [`ListSecurityProfilesOutput`](crate::output::ListSecurityProfilesOutput) with field(s):
    ///   - [`security_profile_identifiers(Option<Vec<SecurityProfileIdentifier>>)`](crate::output::ListSecurityProfilesOutput::security_profile_identifiers): <p>A list of security profile identifiers (names and ARNs).</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSecurityProfilesOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListSecurityProfilesError>`](crate::error::ListSecurityProfilesError)
    pub fn list_security_profiles(&self) -> fluent_builders::ListSecurityProfiles<C, M, R> {
        fluent_builders::ListSecurityProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecurityProfilesForTarget`](crate::client::fluent_builders::ListSecurityProfilesForTarget) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecurityProfilesForTarget::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`recursive(bool)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::recursive) / [`set_recursive(bool)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::set_recursive): <p>If true, return child groups too.</p>
    ///   - [`security_profile_target_arn(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::security_profile_target_arn) / [`set_security_profile_target_arn(Option<String>)`](crate::client::fluent_builders::ListSecurityProfilesForTarget::set_security_profile_target_arn): <p>The ARN of the target (thing group) whose attached security profiles you want to get.</p>
    /// - On success, responds with [`ListSecurityProfilesForTargetOutput`](crate::output::ListSecurityProfilesForTargetOutput) with field(s):
    ///   - [`security_profile_target_mappings(Option<Vec<SecurityProfileTargetMapping>>)`](crate::output::ListSecurityProfilesForTargetOutput::security_profile_target_mappings): <p>A list of security profiles and their associated targets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSecurityProfilesForTargetOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListSecurityProfilesForTargetError>`](crate::error::ListSecurityProfilesForTargetError)
    pub fn list_security_profiles_for_target(
        &self,
    ) -> fluent_builders::ListSecurityProfilesForTarget<C, M, R> {
        fluent_builders::ListSecurityProfilesForTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreams`](crate::client::fluent_builders::ListStreams) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreams::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStreams::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListStreams::set_max_results): <p>The maximum number of results to return at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreams::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreams::set_next_token): <p>A token used to get the next set of results.</p>
    ///   - [`ascending_order(bool)`](crate::client::fluent_builders::ListStreams::ascending_order) / [`set_ascending_order(bool)`](crate::client::fluent_builders::ListStreams::set_ascending_order): <p>Set to true to return the list of streams in ascending order.</p>
    /// - On success, responds with [`ListStreamsOutput`](crate::output::ListStreamsOutput) with field(s):
    ///   - [`streams(Option<Vec<StreamSummary>>)`](crate::output::ListStreamsOutput::streams): <p>A list of streams.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamsOutput::next_token): <p>A token used to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListStreamsError>`](crate::error::ListStreamsError)
    pub fn list_streams(&self) -> fluent_builders::ListStreams<C, M, R> {
        fluent_builders::ListStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tags assigned to the resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTargetsForPolicy`](crate::client::fluent_builders::ListTargetsForPolicy) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTargetsForPolicy::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::set_policy_name): <p>The policy name.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListTargetsForPolicy::set_marker): <p>A marker used to get the next set of results.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::ListTargetsForPolicy::page_size) / [`set_page_size(Option<i32>)`](crate::client::fluent_builders::ListTargetsForPolicy::set_page_size): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListTargetsForPolicyOutput`](crate::output::ListTargetsForPolicyOutput) with field(s):
    ///   - [`targets(Option<Vec<String>>)`](crate::output::ListTargetsForPolicyOutput::targets): <p>The policy targets.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListTargetsForPolicyOutput::next_marker): <p>A marker used to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListTargetsForPolicyError>`](crate::error::ListTargetsForPolicyError)
    pub fn list_targets_for_policy(&self) -> fluent_builders::ListTargetsForPolicy<C, M, R> {
        fluent_builders::ListTargetsForPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTargetsForSecurityProfile`](crate::client::fluent_builders::ListTargetsForSecurityProfile) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTargetsForSecurityProfile::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::ListTargetsForSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::ListTargetsForSecurityProfile::set_security_profile_name): <p>The security profile.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTargetsForSecurityProfile::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTargetsForSecurityProfile::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTargetsForSecurityProfile::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTargetsForSecurityProfile::set_max_results): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListTargetsForSecurityProfileOutput`](crate::output::ListTargetsForSecurityProfileOutput) with field(s):
    ///   - [`security_profile_targets(Option<Vec<SecurityProfileTarget>>)`](crate::output::ListTargetsForSecurityProfileOutput::security_profile_targets): <p>The thing groups to which the security profile is attached.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTargetsForSecurityProfileOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListTargetsForSecurityProfileError>`](crate::error::ListTargetsForSecurityProfileError)
    pub fn list_targets_for_security_profile(
        &self,
    ) -> fluent_builders::ListTargetsForSecurityProfile<C, M, R> {
        fluent_builders::ListTargetsForSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingGroups`](crate::client::fluent_builders::ListThingGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingGroups::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingGroups::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`parent_group(impl Into<String>)`](crate::client::fluent_builders::ListThingGroups::parent_group) / [`set_parent_group(Option<String>)`](crate::client::fluent_builders::ListThingGroups::set_parent_group): <p>A filter that limits the results to those with the specified parent group.</p>
    ///   - [`name_prefix_filter(impl Into<String>)`](crate::client::fluent_builders::ListThingGroups::name_prefix_filter) / [`set_name_prefix_filter(Option<String>)`](crate::client::fluent_builders::ListThingGroups::set_name_prefix_filter): <p>A filter that limits the results to those with the specified name prefix.</p>
    ///   - [`recursive(bool)`](crate::client::fluent_builders::ListThingGroups::recursive) / [`set_recursive(Option<bool>)`](crate::client::fluent_builders::ListThingGroups::set_recursive): <p>If true, return child groups as well.</p>
    /// - On success, responds with [`ListThingGroupsOutput`](crate::output::ListThingGroupsOutput) with field(s):
    ///   - [`thing_groups(Option<Vec<GroupNameAndArn>>)`](crate::output::ListThingGroupsOutput::thing_groups): <p>The thing groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingGroupsOutput::next_token): <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    /// - On failure, responds with [`SdkError<ListThingGroupsError>`](crate::error::ListThingGroupsError)
    pub fn list_thing_groups(&self) -> fluent_builders::ListThingGroups<C, M, R> {
        fluent_builders::ListThingGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingGroupsForThing`](crate::client::fluent_builders::ListThingGroupsForThing) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingGroupsForThing::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::ListThingGroupsForThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::ListThingGroupsForThing::set_thing_name): <p>The thing name.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingGroupsForThing::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingGroupsForThing::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingGroupsForThing::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingGroupsForThing::set_max_results): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListThingGroupsForThingOutput`](crate::output::ListThingGroupsForThingOutput) with field(s):
    ///   - [`thing_groups(Option<Vec<GroupNameAndArn>>)`](crate::output::ListThingGroupsForThingOutput::thing_groups): <p>The thing groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingGroupsForThingOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListThingGroupsForThingError>`](crate::error::ListThingGroupsForThingError)
    pub fn list_thing_groups_for_thing(&self) -> fluent_builders::ListThingGroupsForThing<C, M, R> {
        fluent_builders::ListThingGroupsForThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingPrincipals`](crate::client::fluent_builders::ListThingPrincipals) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingPrincipals::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingPrincipals::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingPrincipals::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingPrincipals::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingPrincipals::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::ListThingPrincipals::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::ListThingPrincipals::set_thing_name): <p>The name of the thing.</p>
    /// - On success, responds with [`ListThingPrincipalsOutput`](crate::output::ListThingPrincipalsOutput) with field(s):
    ///   - [`principals(Option<Vec<String>>)`](crate::output::ListThingPrincipalsOutput::principals): <p>The principals associated with the thing.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingPrincipalsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListThingPrincipalsError>`](crate::error::ListThingPrincipalsError)
    pub fn list_thing_principals(&self) -> fluent_builders::ListThingPrincipals<C, M, R> {
        fluent_builders::ListThingPrincipals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingRegistrationTaskReports`](crate::client::fluent_builders::ListThingRegistrationTaskReports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingRegistrationTaskReports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::set_task_id): <p>The id of the task.</p>
    ///   - [`report_type(ReportType)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::report_type) / [`set_report_type(Option<ReportType>)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::set_report_type): <p>The type of task report.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingRegistrationTaskReports::set_max_results): <p>The maximum number of results to return per request.</p>
    /// - On success, responds with [`ListThingRegistrationTaskReportsOutput`](crate::output::ListThingRegistrationTaskReportsOutput) with field(s):
    ///   - [`resource_links(Option<Vec<String>>)`](crate::output::ListThingRegistrationTaskReportsOutput::resource_links): <p>Links to the task resources.</p>
    ///   - [`report_type(Option<ReportType>)`](crate::output::ListThingRegistrationTaskReportsOutput::report_type): <p>The type of task report.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingRegistrationTaskReportsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListThingRegistrationTaskReportsError>`](crate::error::ListThingRegistrationTaskReportsError)
    pub fn list_thing_registration_task_reports(
        &self,
    ) -> fluent_builders::ListThingRegistrationTaskReports<C, M, R> {
        fluent_builders::ListThingRegistrationTaskReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingRegistrationTasks`](crate::client::fluent_builders::ListThingRegistrationTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingRegistrationTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingRegistrationTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingRegistrationTasks::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingRegistrationTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingRegistrationTasks::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`status(Status)`](crate::client::fluent_builders::ListThingRegistrationTasks::status) / [`set_status(Option<Status>)`](crate::client::fluent_builders::ListThingRegistrationTasks::set_status): <p>The status of the bulk thing provisioning task.</p>
    /// - On success, responds with [`ListThingRegistrationTasksOutput`](crate::output::ListThingRegistrationTasksOutput) with field(s):
    ///   - [`task_ids(Option<Vec<String>>)`](crate::output::ListThingRegistrationTasksOutput::task_ids): <p>A list of bulk thing provisioning task IDs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingRegistrationTasksOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListThingRegistrationTasksError>`](crate::error::ListThingRegistrationTasksError)
    pub fn list_thing_registration_tasks(
        &self,
    ) -> fluent_builders::ListThingRegistrationTasks<C, M, R> {
        fluent_builders::ListThingRegistrationTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThings`](crate::client::fluent_builders::ListThings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThings::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThings::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`attribute_name(impl Into<String>)`](crate::client::fluent_builders::ListThings::attribute_name) / [`set_attribute_name(Option<String>)`](crate::client::fluent_builders::ListThings::set_attribute_name): <p>The attribute name used to search for things.</p>
    ///   - [`attribute_value(impl Into<String>)`](crate::client::fluent_builders::ListThings::attribute_value) / [`set_attribute_value(Option<String>)`](crate::client::fluent_builders::ListThings::set_attribute_value): <p>The attribute value used to search for things.</p>
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::ListThings::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::ListThings::set_thing_type_name): <p>The name of the thing type used to search for things.</p>
    ///   - [`use_prefix_attribute_value(bool)`](crate::client::fluent_builders::ListThings::use_prefix_attribute_value) / [`set_use_prefix_attribute_value(bool)`](crate::client::fluent_builders::ListThings::set_use_prefix_attribute_value): <p>When <code>true</code>, the action returns the thing resources with attribute values that start with the <code>attributeValue</code> provided.</p>  <p>When <code>false</code>, or not present, the action returns only the thing resources with attribute values that match the entire <code>attributeValue</code> provided. </p>
    /// - On success, responds with [`ListThingsOutput`](crate::output::ListThingsOutput) with field(s):
    ///   - [`things(Option<Vec<ThingAttribute>>)`](crate::output::ListThingsOutput::things): <p>The things.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingsOutput::next_token): <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    /// - On failure, responds with [`SdkError<ListThingsError>`](crate::error::ListThingsError)
    pub fn list_things(&self) -> fluent_builders::ListThings<C, M, R> {
        fluent_builders::ListThings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingsInBillingGroup`](crate::client::fluent_builders::ListThingsInBillingGroup) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingsInBillingGroup::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::ListThingsInBillingGroup::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::ListThingsInBillingGroup::set_billing_group_name): <p>The name of the billing group.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingsInBillingGroup::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingsInBillingGroup::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingsInBillingGroup::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingsInBillingGroup::set_max_results): <p>The maximum number of results to return per request.</p>
    /// - On success, responds with [`ListThingsInBillingGroupOutput`](crate::output::ListThingsInBillingGroupOutput) with field(s):
    ///   - [`things(Option<Vec<String>>)`](crate::output::ListThingsInBillingGroupOutput::things): <p>A list of things in the billing group.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingsInBillingGroupOutput::next_token): <p>The token to use to get the next set of results. Will not be returned if operation has returned all results.</p>
    /// - On failure, responds with [`SdkError<ListThingsInBillingGroupError>`](crate::error::ListThingsInBillingGroupError)
    pub fn list_things_in_billing_group(
        &self,
    ) -> fluent_builders::ListThingsInBillingGroup<C, M, R> {
        fluent_builders::ListThingsInBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingsInThingGroup`](crate::client::fluent_builders::ListThingsInThingGroup) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingsInThingGroup::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::ListThingsInThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::ListThingsInThingGroup::set_thing_group_name): <p>The thing group name.</p>
    ///   - [`recursive(bool)`](crate::client::fluent_builders::ListThingsInThingGroup::recursive) / [`set_recursive(bool)`](crate::client::fluent_builders::ListThingsInThingGroup::set_recursive): <p>When true, list things in this thing group and in all child groups as well.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingsInThingGroup::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingsInThingGroup::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingsInThingGroup::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingsInThingGroup::set_max_results): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListThingsInThingGroupOutput`](crate::output::ListThingsInThingGroupOutput) with field(s):
    ///   - [`things(Option<Vec<String>>)`](crate::output::ListThingsInThingGroupOutput::things): <p>The things in the specified thing group.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingsInThingGroupOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListThingsInThingGroupError>`](crate::error::ListThingsInThingGroupError)
    pub fn list_things_in_thing_group(&self) -> fluent_builders::ListThingsInThingGroup<C, M, R> {
        fluent_builders::ListThingsInThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListThingTypes`](crate::client::fluent_builders::ListThingTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListThingTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListThingTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListThingTypes::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListThingTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListThingTypes::set_max_results): <p>The maximum number of results to return in this operation.</p>
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::ListThingTypes::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::ListThingTypes::set_thing_type_name): <p>The name of the thing type.</p>
    /// - On success, responds with [`ListThingTypesOutput`](crate::output::ListThingTypesOutput) with field(s):
    ///   - [`thing_types(Option<Vec<ThingTypeDefinition>>)`](crate::output::ListThingTypesOutput::thing_types): <p>The thing types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListThingTypesOutput::next_token): <p>The token for the next set of results. Will not be returned if operation has returned all results.</p>
    /// - On failure, responds with [`SdkError<ListThingTypesError>`](crate::error::ListThingTypesError)
    pub fn list_thing_types(&self) -> fluent_builders::ListThingTypes<C, M, R> {
        fluent_builders::ListThingTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTopicRuleDestinations`](crate::client::fluent_builders::ListTopicRuleDestinations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTopicRuleDestinations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTopicRuleDestinations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTopicRuleDestinations::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTopicRuleDestinations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTopicRuleDestinations::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    /// - On success, responds with [`ListTopicRuleDestinationsOutput`](crate::output::ListTopicRuleDestinationsOutput) with field(s):
    ///   - [`destination_summaries(Option<Vec<TopicRuleDestinationSummary>>)`](crate::output::ListTopicRuleDestinationsOutput::destination_summaries): <p>Information about a topic rule destination.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTopicRuleDestinationsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListTopicRuleDestinationsError>`](crate::error::ListTopicRuleDestinationsError)
    pub fn list_topic_rule_destinations(
        &self,
    ) -> fluent_builders::ListTopicRuleDestinations<C, M, R> {
        fluent_builders::ListTopicRuleDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTopicRules`](crate::client::fluent_builders::ListTopicRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTopicRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`topic(impl Into<String>)`](crate::client::fluent_builders::ListTopicRules::topic) / [`set_topic(Option<String>)`](crate::client::fluent_builders::ListTopicRules::set_topic): <p>The topic.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTopicRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTopicRules::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTopicRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTopicRules::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`rule_disabled(bool)`](crate::client::fluent_builders::ListTopicRules::rule_disabled) / [`set_rule_disabled(Option<bool>)`](crate::client::fluent_builders::ListTopicRules::set_rule_disabled): <p>Specifies whether the rule is disabled.</p>
    /// - On success, responds with [`ListTopicRulesOutput`](crate::output::ListTopicRulesOutput) with field(s):
    ///   - [`rules(Option<Vec<TopicRuleListItem>>)`](crate::output::ListTopicRulesOutput::rules): <p>The rules.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTopicRulesOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListTopicRulesError>`](crate::error::ListTopicRulesError)
    pub fn list_topic_rules(&self) -> fluent_builders::ListTopicRules<C, M, R> {
        fluent_builders::ListTopicRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListV2LoggingLevels`](crate::client::fluent_builders::ListV2LoggingLevels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListV2LoggingLevels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_type(LogTargetType)`](crate::client::fluent_builders::ListV2LoggingLevels::target_type) / [`set_target_type(Option<LogTargetType>)`](crate::client::fluent_builders::ListV2LoggingLevels::set_target_type): <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListV2LoggingLevels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListV2LoggingLevels::set_next_token): <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListV2LoggingLevels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListV2LoggingLevels::set_max_results): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListV2LoggingLevelsOutput`](crate::output::ListV2LoggingLevelsOutput) with field(s):
    ///   - [`log_target_configurations(Option<Vec<LogTargetConfiguration>>)`](crate::output::ListV2LoggingLevelsOutput::log_target_configurations): <p>The logging configuration for a target.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListV2LoggingLevelsOutput::next_token): <p>The token to use to get the next set of results, or <b>null</b> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListV2LoggingLevelsError>`](crate::error::ListV2LoggingLevelsError)
    pub fn list_v2_logging_levels(&self) -> fluent_builders::ListV2LoggingLevels<C, M, R> {
        fluent_builders::ListV2LoggingLevels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListViolationEvents`](crate::client::fluent_builders::ListViolationEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListViolationEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListViolationEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListViolationEvents::set_start_time): <p>The start time for the alerts to be listed.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListViolationEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListViolationEvents::set_end_time): <p>The end time for the alerts to be listed.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::ListViolationEvents::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::ListViolationEvents::set_thing_name): <p>A filter to limit results to those alerts caused by the specified thing.</p>
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::ListViolationEvents::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::ListViolationEvents::set_security_profile_name): <p>A filter to limit results to those alerts generated by the specified security profile.</p>
    ///   - [`behavior_criteria_type(BehaviorCriteriaType)`](crate::client::fluent_builders::ListViolationEvents::behavior_criteria_type) / [`set_behavior_criteria_type(Option<BehaviorCriteriaType>)`](crate::client::fluent_builders::ListViolationEvents::set_behavior_criteria_type): <p> The criteria for a behavior. </p>
    ///   - [`list_suppressed_alerts(bool)`](crate::client::fluent_builders::ListViolationEvents::list_suppressed_alerts) / [`set_list_suppressed_alerts(Option<bool>)`](crate::client::fluent_builders::ListViolationEvents::set_list_suppressed_alerts): <p> A list of all suppressed alerts. </p>
    ///   - [`verification_state(VerificationState)`](crate::client::fluent_builders::ListViolationEvents::verification_state) / [`set_verification_state(Option<VerificationState>)`](crate::client::fluent_builders::ListViolationEvents::set_verification_state): <p>The verification state of the violation (detect alarm).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListViolationEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListViolationEvents::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListViolationEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListViolationEvents::set_max_results): <p>The maximum number of results to return at one time.</p>
    /// - On success, responds with [`ListViolationEventsOutput`](crate::output::ListViolationEventsOutput) with field(s):
    ///   - [`violation_events(Option<Vec<ViolationEvent>>)`](crate::output::ListViolationEventsOutput::violation_events): <p>The security profile violation alerts issued for this account during the given time period, potentially filtered by security profile, behavior violated, or thing (device) violating.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListViolationEventsOutput::next_token): <p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListViolationEventsError>`](crate::error::ListViolationEventsError)
    pub fn list_violation_events(&self) -> fluent_builders::ListViolationEvents<C, M, R> {
        fluent_builders::ListViolationEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutVerificationStateOnViolation`](crate::client::fluent_builders::PutVerificationStateOnViolation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`violation_id(impl Into<String>)`](crate::client::fluent_builders::PutVerificationStateOnViolation::violation_id) / [`set_violation_id(Option<String>)`](crate::client::fluent_builders::PutVerificationStateOnViolation::set_violation_id): <p>The violation ID.</p>
    ///   - [`verification_state(VerificationState)`](crate::client::fluent_builders::PutVerificationStateOnViolation::verification_state) / [`set_verification_state(Option<VerificationState>)`](crate::client::fluent_builders::PutVerificationStateOnViolation::set_verification_state): <p>The verification state of the violation.</p>
    ///   - [`verification_state_description(impl Into<String>)`](crate::client::fluent_builders::PutVerificationStateOnViolation::verification_state_description) / [`set_verification_state_description(Option<String>)`](crate::client::fluent_builders::PutVerificationStateOnViolation::set_verification_state_description): <p>The description of the verification state of the violation (detect alarm).</p>
    /// - On success, responds with [`PutVerificationStateOnViolationOutput`](crate::output::PutVerificationStateOnViolationOutput)

    /// - On failure, responds with [`SdkError<PutVerificationStateOnViolationError>`](crate::error::PutVerificationStateOnViolationError)
    pub fn put_verification_state_on_violation(
        &self,
    ) -> fluent_builders::PutVerificationStateOnViolation<C, M, R> {
        fluent_builders::PutVerificationStateOnViolation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterCACertificate`](crate::client::fluent_builders::RegisterCACertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ca_certificate(impl Into<String>)`](crate::client::fluent_builders::RegisterCACertificate::ca_certificate) / [`set_ca_certificate(Option<String>)`](crate::client::fluent_builders::RegisterCACertificate::set_ca_certificate): <p>The CA certificate.</p>
    ///   - [`verification_certificate(impl Into<String>)`](crate::client::fluent_builders::RegisterCACertificate::verification_certificate) / [`set_verification_certificate(Option<String>)`](crate::client::fluent_builders::RegisterCACertificate::set_verification_certificate): <p>The private key verification certificate.</p>
    ///   - [`set_as_active(bool)`](crate::client::fluent_builders::RegisterCACertificate::set_as_active) / [`set_set_as_active(bool)`](crate::client::fluent_builders::RegisterCACertificate::set_set_as_active): <p>A boolean value that specifies if the CA certificate is set to active.</p>
    ///   - [`allow_auto_registration(bool)`](crate::client::fluent_builders::RegisterCACertificate::allow_auto_registration) / [`set_allow_auto_registration(bool)`](crate::client::fluent_builders::RegisterCACertificate::set_allow_auto_registration): <p>Allows this CA certificate to be used for auto registration of device certificates.</p>
    ///   - [`registration_config(RegistrationConfig)`](crate::client::fluent_builders::RegisterCACertificate::registration_config) / [`set_registration_config(Option<RegistrationConfig>)`](crate::client::fluent_builders::RegisterCACertificate::set_registration_config): <p>Information about the registration configuration.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RegisterCACertificate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RegisterCACertificate::set_tags): <p>Metadata which can be used to manage the CA certificate.</p> <note>   <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>   <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>   <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>  </note>
    /// - On success, responds with [`RegisterCaCertificateOutput`](crate::output::RegisterCaCertificateOutput) with field(s):
    ///   - [`certificate_arn(Option<String>)`](crate::output::RegisterCaCertificateOutput::certificate_arn): <p>The CA certificate ARN.</p>
    ///   - [`certificate_id(Option<String>)`](crate::output::RegisterCaCertificateOutput::certificate_id): <p>The CA certificate identifier.</p>
    /// - On failure, responds with [`SdkError<RegisterCACertificateError>`](crate::error::RegisterCACertificateError)
    pub fn register_ca_certificate(&self) -> fluent_builders::RegisterCACertificate<C, M, R> {
        fluent_builders::RegisterCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterCertificate`](crate::client::fluent_builders::RegisterCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_pem(impl Into<String>)`](crate::client::fluent_builders::RegisterCertificate::certificate_pem) / [`set_certificate_pem(Option<String>)`](crate::client::fluent_builders::RegisterCertificate::set_certificate_pem): <p>The certificate data, in PEM format.</p>
    ///   - [`ca_certificate_pem(impl Into<String>)`](crate::client::fluent_builders::RegisterCertificate::ca_certificate_pem) / [`set_ca_certificate_pem(Option<String>)`](crate::client::fluent_builders::RegisterCertificate::set_ca_certificate_pem): <p>The CA certificate used to sign the device certificate being registered.</p>
    ///   - [`set_as_active(bool)`](crate::client::fluent_builders::RegisterCertificate::set_as_active) / [`set_set_as_active(Option<bool>)`](crate::client::fluent_builders::RegisterCertificate::set_set_as_active): <p>A boolean value that specifies if the certificate is set to active.</p>
    ///   - [`status(CertificateStatus)`](crate::client::fluent_builders::RegisterCertificate::status) / [`set_status(Option<CertificateStatus>)`](crate::client::fluent_builders::RegisterCertificate::set_status): <p>The status of the register certificate request.</p>
    /// - On success, responds with [`RegisterCertificateOutput`](crate::output::RegisterCertificateOutput) with field(s):
    ///   - [`certificate_arn(Option<String>)`](crate::output::RegisterCertificateOutput::certificate_arn): <p>The certificate ARN.</p>
    ///   - [`certificate_id(Option<String>)`](crate::output::RegisterCertificateOutput::certificate_id): <p>The certificate identifier.</p>
    /// - On failure, responds with [`SdkError<RegisterCertificateError>`](crate::error::RegisterCertificateError)
    pub fn register_certificate(&self) -> fluent_builders::RegisterCertificate<C, M, R> {
        fluent_builders::RegisterCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterCertificateWithoutCA`](crate::client::fluent_builders::RegisterCertificateWithoutCA) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_pem(impl Into<String>)`](crate::client::fluent_builders::RegisterCertificateWithoutCA::certificate_pem) / [`set_certificate_pem(Option<String>)`](crate::client::fluent_builders::RegisterCertificateWithoutCA::set_certificate_pem): <p>The certificate data, in PEM format.</p>
    ///   - [`status(CertificateStatus)`](crate::client::fluent_builders::RegisterCertificateWithoutCA::status) / [`set_status(Option<CertificateStatus>)`](crate::client::fluent_builders::RegisterCertificateWithoutCA::set_status): <p>The status of the register certificate request.</p>
    /// - On success, responds with [`RegisterCertificateWithoutCaOutput`](crate::output::RegisterCertificateWithoutCaOutput) with field(s):
    ///   - [`certificate_arn(Option<String>)`](crate::output::RegisterCertificateWithoutCaOutput::certificate_arn): <p>The Amazon Resource Name (ARN) of the registered certificate.</p>
    ///   - [`certificate_id(Option<String>)`](crate::output::RegisterCertificateWithoutCaOutput::certificate_id): <p>The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.</p>
    /// - On failure, responds with [`SdkError<RegisterCertificateWithoutCAError>`](crate::error::RegisterCertificateWithoutCAError)
    pub fn register_certificate_without_ca(
        &self,
    ) -> fluent_builders::RegisterCertificateWithoutCA<C, M, R> {
        fluent_builders::RegisterCertificateWithoutCA::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterThing`](crate::client::fluent_builders::RegisterThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_body(impl Into<String>)`](crate::client::fluent_builders::RegisterThing::template_body) / [`set_template_body(Option<String>)`](crate::client::fluent_builders::RegisterThing::set_template_body): <p>The provisioning template. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-w-cert.html">Provisioning Devices That Have Device Certificates</a> for more information.</p>
    ///   - [`parameters(HashMap<String, String>)`](crate::client::fluent_builders::RegisterThing::parameters) / [`set_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::RegisterThing::set_parameters): <p>The parameters for provisioning a thing. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning Templates</a> for more information.</p>
    /// - On success, responds with [`RegisterThingOutput`](crate::output::RegisterThingOutput) with field(s):
    ///   - [`certificate_pem(Option<String>)`](crate::output::RegisterThingOutput::certificate_pem): <p>The certificate data, in PEM format.</p>
    ///   - [`resource_arns(Option<HashMap<String, String>>)`](crate::output::RegisterThingOutput::resource_arns): <p>ARNs for the generated resources.</p>
    /// - On failure, responds with [`SdkError<RegisterThingError>`](crate::error::RegisterThingError)
    pub fn register_thing(&self) -> fluent_builders::RegisterThing<C, M, R> {
        fluent_builders::RegisterThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectCertificateTransfer`](crate::client::fluent_builders::RejectCertificateTransfer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::RejectCertificateTransfer::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::RejectCertificateTransfer::set_certificate_id): <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    ///   - [`reject_reason(impl Into<String>)`](crate::client::fluent_builders::RejectCertificateTransfer::reject_reason) / [`set_reject_reason(Option<String>)`](crate::client::fluent_builders::RejectCertificateTransfer::set_reject_reason): <p>The reason the certificate transfer was rejected.</p>
    /// - On success, responds with [`RejectCertificateTransferOutput`](crate::output::RejectCertificateTransferOutput)

    /// - On failure, responds with [`SdkError<RejectCertificateTransferError>`](crate::error::RejectCertificateTransferError)
    pub fn reject_certificate_transfer(
        &self,
    ) -> fluent_builders::RejectCertificateTransfer<C, M, R> {
        fluent_builders::RejectCertificateTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveThingFromBillingGroup`](crate::client::fluent_builders::RemoveThingFromBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::set_billing_group_name): <p>The name of the billing group.</p>
    ///   - [`billing_group_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::billing_group_arn) / [`set_billing_group_arn(Option<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::set_billing_group_arn): <p>The ARN of the billing group.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::set_thing_name): <p>The name of the thing to be removed from the billing group.</p>
    ///   - [`thing_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::thing_arn) / [`set_thing_arn(Option<String>)`](crate::client::fluent_builders::RemoveThingFromBillingGroup::set_thing_arn): <p>The ARN of the thing to be removed from the billing group.</p>
    /// - On success, responds with [`RemoveThingFromBillingGroupOutput`](crate::output::RemoveThingFromBillingGroupOutput)

    /// - On failure, responds with [`SdkError<RemoveThingFromBillingGroupError>`](crate::error::RemoveThingFromBillingGroupError)
    pub fn remove_thing_from_billing_group(
        &self,
    ) -> fluent_builders::RemoveThingFromBillingGroup<C, M, R> {
        fluent_builders::RemoveThingFromBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveThingFromThingGroup`](crate::client::fluent_builders::RemoveThingFromThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::set_thing_group_name): <p>The group name.</p>
    ///   - [`thing_group_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::thing_group_arn) / [`set_thing_group_arn(Option<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::set_thing_group_arn): <p>The group ARN.</p>
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::set_thing_name): <p>The name of the thing to remove from the group.</p>
    ///   - [`thing_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::thing_arn) / [`set_thing_arn(Option<String>)`](crate::client::fluent_builders::RemoveThingFromThingGroup::set_thing_arn): <p>The ARN of the thing to remove from the group.</p>
    /// - On success, responds with [`RemoveThingFromThingGroupOutput`](crate::output::RemoveThingFromThingGroupOutput)

    /// - On failure, responds with [`SdkError<RemoveThingFromThingGroupError>`](crate::error::RemoveThingFromThingGroupError)
    pub fn remove_thing_from_thing_group(
        &self,
    ) -> fluent_builders::RemoveThingFromThingGroup<C, M, R> {
        fluent_builders::RemoveThingFromThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReplaceTopicRule`](crate::client::fluent_builders::ReplaceTopicRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::ReplaceTopicRule::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::ReplaceTopicRule::set_rule_name): <p>The name of the rule.</p>
    ///   - [`topic_rule_payload(TopicRulePayload)`](crate::client::fluent_builders::ReplaceTopicRule::topic_rule_payload) / [`set_topic_rule_payload(Option<TopicRulePayload>)`](crate::client::fluent_builders::ReplaceTopicRule::set_topic_rule_payload): <p>The rule payload.</p>
    /// - On success, responds with [`ReplaceTopicRuleOutput`](crate::output::ReplaceTopicRuleOutput)

    /// - On failure, responds with [`SdkError<ReplaceTopicRuleError>`](crate::error::ReplaceTopicRuleError)
    pub fn replace_topic_rule(&self) -> fluent_builders::ReplaceTopicRule<C, M, R> {
        fluent_builders::ReplaceTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchIndex`](crate::client::fluent_builders::SearchIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::SearchIndex::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::SearchIndex::set_index_name): <p>The search index name.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::SearchIndex::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::SearchIndex::set_query_string): <p>The search query string.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchIndex::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchIndex::set_next_token): <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchIndex::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchIndex::set_max_results): <p>The maximum number of results to return at one time.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::SearchIndex::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::SearchIndex::set_query_version): <p>The query version.</p>
    /// - On success, responds with [`SearchIndexOutput`](crate::output::SearchIndexOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::SearchIndexOutput::next_token): <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
    ///   - [`things(Option<Vec<ThingDocument>>)`](crate::output::SearchIndexOutput::things): <p>The things that match the search query.</p>
    ///   - [`thing_groups(Option<Vec<ThingGroupDocument>>)`](crate::output::SearchIndexOutput::thing_groups): <p>The thing groups that match the search query.</p>
    /// - On failure, responds with [`SdkError<SearchIndexError>`](crate::error::SearchIndexError)
    pub fn search_index(&self) -> fluent_builders::SearchIndex<C, M, R> {
        fluent_builders::SearchIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetDefaultAuthorizer`](crate::client::fluent_builders::SetDefaultAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorizer_name(impl Into<String>)`](crate::client::fluent_builders::SetDefaultAuthorizer::authorizer_name) / [`set_authorizer_name(Option<String>)`](crate::client::fluent_builders::SetDefaultAuthorizer::set_authorizer_name): <p>The authorizer name.</p>
    /// - On success, responds with [`SetDefaultAuthorizerOutput`](crate::output::SetDefaultAuthorizerOutput) with field(s):
    ///   - [`authorizer_name(Option<String>)`](crate::output::SetDefaultAuthorizerOutput::authorizer_name): <p>The authorizer name.</p>
    ///   - [`authorizer_arn(Option<String>)`](crate::output::SetDefaultAuthorizerOutput::authorizer_arn): <p>The authorizer ARN.</p>
    /// - On failure, responds with [`SdkError<SetDefaultAuthorizerError>`](crate::error::SetDefaultAuthorizerError)
    pub fn set_default_authorizer(&self) -> fluent_builders::SetDefaultAuthorizer<C, M, R> {
        fluent_builders::SetDefaultAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetDefaultPolicyVersion`](crate::client::fluent_builders::SetDefaultPolicyVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::SetDefaultPolicyVersion::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::SetDefaultPolicyVersion::set_policy_name): <p>The policy name.</p>
    ///   - [`policy_version_id(impl Into<String>)`](crate::client::fluent_builders::SetDefaultPolicyVersion::policy_version_id) / [`set_policy_version_id(Option<String>)`](crate::client::fluent_builders::SetDefaultPolicyVersion::set_policy_version_id): <p>The policy version ID.</p>
    /// - On success, responds with [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)

    /// - On failure, responds with [`SdkError<SetDefaultPolicyVersionError>`](crate::error::SetDefaultPolicyVersionError)
    pub fn set_default_policy_version(&self) -> fluent_builders::SetDefaultPolicyVersion<C, M, R> {
        fluent_builders::SetDefaultPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetLoggingOptions`](crate::client::fluent_builders::SetLoggingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`logging_options_payload(LoggingOptionsPayload)`](crate::client::fluent_builders::SetLoggingOptions::logging_options_payload) / [`set_logging_options_payload(Option<LoggingOptionsPayload>)`](crate::client::fluent_builders::SetLoggingOptions::set_logging_options_payload): <p>The logging options payload.</p>
    /// - On success, responds with [`SetLoggingOptionsOutput`](crate::output::SetLoggingOptionsOutput)

    /// - On failure, responds with [`SdkError<SetLoggingOptionsError>`](crate::error::SetLoggingOptionsError)
    pub fn set_logging_options(&self) -> fluent_builders::SetLoggingOptions<C, M, R> {
        fluent_builders::SetLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetV2LoggingLevel`](crate::client::fluent_builders::SetV2LoggingLevel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_target(LogTarget)`](crate::client::fluent_builders::SetV2LoggingLevel::log_target) / [`set_log_target(Option<LogTarget>)`](crate::client::fluent_builders::SetV2LoggingLevel::set_log_target): <p>The log target.</p>
    ///   - [`log_level(LogLevel)`](crate::client::fluent_builders::SetV2LoggingLevel::log_level) / [`set_log_level(Option<LogLevel>)`](crate::client::fluent_builders::SetV2LoggingLevel::set_log_level): <p>The log level.</p>
    /// - On success, responds with [`SetV2LoggingLevelOutput`](crate::output::SetV2LoggingLevelOutput)

    /// - On failure, responds with [`SdkError<SetV2LoggingLevelError>`](crate::error::SetV2LoggingLevelError)
    pub fn set_v2_logging_level(&self) -> fluent_builders::SetV2LoggingLevel<C, M, R> {
        fluent_builders::SetV2LoggingLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetV2LoggingOptions`](crate::client::fluent_builders::SetV2LoggingOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::SetV2LoggingOptions::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::SetV2LoggingOptions::set_role_arn): <p>The ARN of the role that allows IoT to write to Cloudwatch logs.</p>
    ///   - [`default_log_level(LogLevel)`](crate::client::fluent_builders::SetV2LoggingOptions::default_log_level) / [`set_default_log_level(Option<LogLevel>)`](crate::client::fluent_builders::SetV2LoggingOptions::set_default_log_level): <p>The default logging level.</p>
    ///   - [`disable_all_logs(bool)`](crate::client::fluent_builders::SetV2LoggingOptions::disable_all_logs) / [`set_disable_all_logs(bool)`](crate::client::fluent_builders::SetV2LoggingOptions::set_disable_all_logs): <p>If true all logs are disabled. The default is false.</p>
    /// - On success, responds with [`SetV2LoggingOptionsOutput`](crate::output::SetV2LoggingOptionsOutput)

    /// - On failure, responds with [`SdkError<SetV2LoggingOptionsError>`](crate::error::SetV2LoggingOptionsError)
    pub fn set_v2_logging_options(&self) -> fluent_builders::SetV2LoggingOptions<C, M, R> {
        fluent_builders::SetV2LoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAuditMitigationActionsTask`](crate::client::fluent_builders::StartAuditMitigationActionsTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::set_task_id): <p>A unique identifier for the task. You can use this identifier to check the status of the task or to cancel it.</p>
    ///   - [`target(AuditMitigationActionsTaskTarget)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::target) / [`set_target(Option<AuditMitigationActionsTaskTarget>)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::set_target): <p>Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of audit check, to all findings from an audit, or to a specific set of findings.</p>
    ///   - [`audit_check_to_actions_mapping(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::audit_check_to_actions_mapping) / [`set_audit_check_to_actions_mapping(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::set_audit_check_to_actions_mapping): <p>For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your Amazon Web Services accounts.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartAuditMitigationActionsTask::set_client_request_token): <p>Each audit mitigation task must have a unique client request token. If you try to start a new task with the same token as a task that already exists, an exception occurs. If you omit this value, a unique client request token is generated automatically.</p>
    /// - On success, responds with [`StartAuditMitigationActionsTaskOutput`](crate::output::StartAuditMitigationActionsTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::StartAuditMitigationActionsTaskOutput::task_id): <p>The unique identifier for the audit mitigation task. This matches the <code>taskId</code> that you specified in the request.</p>
    /// - On failure, responds with [`SdkError<StartAuditMitigationActionsTaskError>`](crate::error::StartAuditMitigationActionsTaskError)
    pub fn start_audit_mitigation_actions_task(
        &self,
    ) -> fluent_builders::StartAuditMitigationActionsTask<C, M, R> {
        fluent_builders::StartAuditMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDetectMitigationActionsTask`](crate::client::fluent_builders::StartDetectMitigationActionsTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::set_task_id): <p> The unique identifier of the task. </p>
    ///   - [`target(DetectMitigationActionsTaskTarget)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::target) / [`set_target(Option<DetectMitigationActionsTaskTarget>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::set_target): <p> Specifies the ML Detect findings to which the mitigation actions are applied. </p>
    ///   - [`actions(Vec<String>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::actions) / [`set_actions(Option<Vec<String>>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::set_actions): <p> The actions to be performed when a device has unexpected behavior. </p>
    ///   - [`violation_event_occurrence_range(ViolationEventOccurrenceRange)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::violation_event_occurrence_range) / [`set_violation_event_occurrence_range(Option<ViolationEventOccurrenceRange>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::set_violation_event_occurrence_range): <p> Specifies the time period of which violation events occurred between. </p>
    ///   - [`include_only_active_violations(bool)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::include_only_active_violations) / [`set_include_only_active_violations(Option<bool>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::set_include_only_active_violations): <p> Specifies to list only active violations. </p>
    ///   - [`include_suppressed_alerts(bool)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::include_suppressed_alerts) / [`set_include_suppressed_alerts(Option<bool>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::set_include_suppressed_alerts): <p> Specifies to include suppressed alerts. </p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartDetectMitigationActionsTask::set_client_request_token): <p> Each mitigation action task must have a unique client request token. If you try to create a new task with the same token as a task that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
    /// - On success, responds with [`StartDetectMitigationActionsTaskOutput`](crate::output::StartDetectMitigationActionsTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::StartDetectMitigationActionsTaskOutput::task_id): <p> The unique identifier of the task. </p>
    /// - On failure, responds with [`SdkError<StartDetectMitigationActionsTaskError>`](crate::error::StartDetectMitigationActionsTaskError)
    pub fn start_detect_mitigation_actions_task(
        &self,
    ) -> fluent_builders::StartDetectMitigationActionsTask<C, M, R> {
        fluent_builders::StartDetectMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartOnDemandAuditTask`](crate::client::fluent_builders::StartOnDemandAuditTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_check_names(Vec<String>)`](crate::client::fluent_builders::StartOnDemandAuditTask::target_check_names) / [`set_target_check_names(Option<Vec<String>>)`](crate::client::fluent_builders::StartOnDemandAuditTask::set_target_check_names): <p>Which checks are performed during the audit. The checks you specify must be enabled for your account or an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.</p>
    /// - On success, responds with [`StartOnDemandAuditTaskOutput`](crate::output::StartOnDemandAuditTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::StartOnDemandAuditTaskOutput::task_id): <p>The ID of the on-demand audit you started.</p>
    /// - On failure, responds with [`SdkError<StartOnDemandAuditTaskError>`](crate::error::StartOnDemandAuditTaskError)
    pub fn start_on_demand_audit_task(&self) -> fluent_builders::StartOnDemandAuditTask<C, M, R> {
        fluent_builders::StartOnDemandAuditTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartThingRegistrationTask`](crate::client::fluent_builders::StartThingRegistrationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_body(impl Into<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::template_body) / [`set_template_body(Option<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::set_template_body): <p>The provisioning template.</p>
    ///   - [`input_file_bucket(impl Into<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::input_file_bucket) / [`set_input_file_bucket(Option<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::set_input_file_bucket): <p>The S3 bucket that contains the input file.</p>
    ///   - [`input_file_key(impl Into<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::input_file_key) / [`set_input_file_key(Option<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::set_input_file_key): <p>The name of input file within the S3 bucket. This file contains a newline delimited JSON file. Each line contains the parameter values to provision one device (thing).</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::StartThingRegistrationTask::set_role_arn): <p>The IAM role ARN that grants permission the input file.</p>
    /// - On success, responds with [`StartThingRegistrationTaskOutput`](crate::output::StartThingRegistrationTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::StartThingRegistrationTaskOutput::task_id): <p>The bulk thing provisioning task ID.</p>
    /// - On failure, responds with [`SdkError<StartThingRegistrationTaskError>`](crate::error::StartThingRegistrationTaskError)
    pub fn start_thing_registration_task(
        &self,
    ) -> fluent_builders::StartThingRegistrationTask<C, M, R> {
        fluent_builders::StartThingRegistrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopThingRegistrationTask`](crate::client::fluent_builders::StopThingRegistrationTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::StopThingRegistrationTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::StopThingRegistrationTask::set_task_id): <p>The bulk thing provisioning task ID.</p>
    /// - On success, responds with [`StopThingRegistrationTaskOutput`](crate::output::StopThingRegistrationTaskOutput)

    /// - On failure, responds with [`SdkError<StopThingRegistrationTaskError>`](crate::error::StopThingRegistrationTaskError)
    pub fn stop_thing_registration_task(
        &self,
    ) -> fluent_builders::StopThingRegistrationTask<C, M, R> {
        fluent_builders::StopThingRegistrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The new or modified tags for the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestAuthorization`](crate::client::fluent_builders::TestAuthorization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::TestAuthorization::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::TestAuthorization::set_principal): <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
    ///   - [`cognito_identity_pool_id(impl Into<String>)`](crate::client::fluent_builders::TestAuthorization::cognito_identity_pool_id) / [`set_cognito_identity_pool_id(Option<String>)`](crate::client::fluent_builders::TestAuthorization::set_cognito_identity_pool_id): <p>The Cognito identity pool ID.</p>
    ///   - [`auth_infos(Vec<AuthInfo>)`](crate::client::fluent_builders::TestAuthorization::auth_infos) / [`set_auth_infos(Option<Vec<AuthInfo>>)`](crate::client::fluent_builders::TestAuthorization::set_auth_infos): <p>A list of authorization info objects. Simulating authorization will create a response for each <code>authInfo</code> object in the list.</p>
    ///   - [`client_id(impl Into<String>)`](crate::client::fluent_builders::TestAuthorization::client_id) / [`set_client_id(Option<String>)`](crate::client::fluent_builders::TestAuthorization::set_client_id): <p>The MQTT client ID.</p>
    ///   - [`policy_names_to_add(Vec<String>)`](crate::client::fluent_builders::TestAuthorization::policy_names_to_add) / [`set_policy_names_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::TestAuthorization::set_policy_names_to_add): <p>When testing custom authorization, the policies specified here are treated as if they are attached to the principal being authorized.</p>
    ///   - [`policy_names_to_skip(Vec<String>)`](crate::client::fluent_builders::TestAuthorization::policy_names_to_skip) / [`set_policy_names_to_skip(Option<Vec<String>>)`](crate::client::fluent_builders::TestAuthorization::set_policy_names_to_skip): <p>When testing custom authorization, the policies specified here are treated as if they are not attached to the principal being authorized.</p>
    /// - On success, responds with [`TestAuthorizationOutput`](crate::output::TestAuthorizationOutput) with field(s):
    ///   - [`auth_results(Option<Vec<AuthResult>>)`](crate::output::TestAuthorizationOutput::auth_results): <p>The authentication results.</p>
    /// - On failure, responds with [`SdkError<TestAuthorizationError>`](crate::error::TestAuthorizationError)
    pub fn test_authorization(&self) -> fluent_builders::TestAuthorization<C, M, R> {
        fluent_builders::TestAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestInvokeAuthorizer`](crate::client::fluent_builders::TestInvokeAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorizer_name(impl Into<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::authorizer_name) / [`set_authorizer_name(Option<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_authorizer_name): <p>The custom authorizer name.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_token): <p>The token returned by your custom authentication service.</p>
    ///   - [`token_signature(impl Into<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::token_signature) / [`set_token_signature(Option<String>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_token_signature): <p>The signature made with the token and your custom authentication service's private key. This value must be Base-64-encoded.</p>
    ///   - [`http_context(HttpContext)`](crate::client::fluent_builders::TestInvokeAuthorizer::http_context) / [`set_http_context(Option<HttpContext>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_http_context): <p>Specifies a test HTTP authorization request.</p>
    ///   - [`mqtt_context(MqttContext)`](crate::client::fluent_builders::TestInvokeAuthorizer::mqtt_context) / [`set_mqtt_context(Option<MqttContext>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_mqtt_context): <p>Specifies a test MQTT authorization request.</p>
    ///   - [`tls_context(TlsContext)`](crate::client::fluent_builders::TestInvokeAuthorizer::tls_context) / [`set_tls_context(Option<TlsContext>)`](crate::client::fluent_builders::TestInvokeAuthorizer::set_tls_context): <p>Specifies a test TLS authorization request.</p>
    /// - On success, responds with [`TestInvokeAuthorizerOutput`](crate::output::TestInvokeAuthorizerOutput) with field(s):
    ///   - [`is_authenticated(Option<bool>)`](crate::output::TestInvokeAuthorizerOutput::is_authenticated): <p>True if the token is authenticated, otherwise false.</p>
    ///   - [`principal_id(Option<String>)`](crate::output::TestInvokeAuthorizerOutput::principal_id): <p>The principal ID.</p>
    ///   - [`policy_documents(Option<Vec<String>>)`](crate::output::TestInvokeAuthorizerOutput::policy_documents): <p>IAM policy documents.</p>
    ///   - [`refresh_after_in_seconds(Option<i32>)`](crate::output::TestInvokeAuthorizerOutput::refresh_after_in_seconds): <p>The number of seconds after which the temporary credentials are refreshed.</p>
    ///   - [`disconnect_after_in_seconds(Option<i32>)`](crate::output::TestInvokeAuthorizerOutput::disconnect_after_in_seconds): <p>The number of seconds after which the connection is terminated.</p>
    /// - On failure, responds with [`SdkError<TestInvokeAuthorizerError>`](crate::error::TestInvokeAuthorizerError)
    pub fn test_invoke_authorizer(&self) -> fluent_builders::TestInvokeAuthorizer<C, M, R> {
        fluent_builders::TestInvokeAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TransferCertificate`](crate::client::fluent_builders::TransferCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::TransferCertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::TransferCertificate::set_certificate_id): <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    ///   - [`target_aws_account(impl Into<String>)`](crate::client::fluent_builders::TransferCertificate::target_aws_account) / [`set_target_aws_account(Option<String>)`](crate::client::fluent_builders::TransferCertificate::set_target_aws_account): <p>The Amazon Web Services account.</p>
    ///   - [`transfer_message(impl Into<String>)`](crate::client::fluent_builders::TransferCertificate::transfer_message) / [`set_transfer_message(Option<String>)`](crate::client::fluent_builders::TransferCertificate::set_transfer_message): <p>The transfer message.</p>
    /// - On success, responds with [`TransferCertificateOutput`](crate::output::TransferCertificateOutput) with field(s):
    ///   - [`transferred_certificate_arn(Option<String>)`](crate::output::TransferCertificateOutput::transferred_certificate_arn): <p>The ARN of the certificate.</p>
    /// - On failure, responds with [`SdkError<TransferCertificateError>`](crate::error::TransferCertificateError)
    pub fn transfer_certificate(&self) -> fluent_builders::TransferCertificate<C, M, R> {
        fluent_builders::TransferCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of the keys of the tags to be removed from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccountAuditConfiguration`](crate::client::fluent_builders::UpdateAccountAuditConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAccountAuditConfiguration::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateAccountAuditConfiguration::set_role_arn): <p>The Amazon Resource Name (ARN) of the role that grants permission to IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p>
    ///   - [`audit_notification_target_configurations(HashMap<AuditNotificationType, AuditNotificationTarget>)`](crate::client::fluent_builders::UpdateAccountAuditConfiguration::audit_notification_target_configurations) / [`set_audit_notification_target_configurations(Option<HashMap<AuditNotificationType, AuditNotificationTarget>>)`](crate::client::fluent_builders::UpdateAccountAuditConfiguration::set_audit_notification_target_configurations): <p>Information about the targets to which audit notifications are sent.</p>
    ///   - [`audit_check_configurations(HashMap<String, AuditCheckConfiguration>)`](crate::client::fluent_builders::UpdateAccountAuditConfiguration::audit_check_configurations) / [`set_audit_check_configurations(Option<HashMap<String, AuditCheckConfiguration>>)`](crate::client::fluent_builders::UpdateAccountAuditConfiguration::set_audit_check_configurations): <p>Specifies which audit checks are enabled and disabled for this account. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are currently enabled.</p>  <p>Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted.</p>  <p>You cannot disable a check if it's used by any scheduled audit. You must first delete the check from the scheduled audit or delete the scheduled audit itself.</p>  <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required and must specify at least one enabled check.</p>
    /// - On success, responds with [`UpdateAccountAuditConfigurationOutput`](crate::output::UpdateAccountAuditConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateAccountAuditConfigurationError>`](crate::error::UpdateAccountAuditConfigurationError)
    pub fn update_account_audit_configuration(
        &self,
    ) -> fluent_builders::UpdateAccountAuditConfiguration<C, M, R> {
        fluent_builders::UpdateAccountAuditConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAuditSuppression`](crate::client::fluent_builders::UpdateAuditSuppression) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`check_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAuditSuppression::check_name) / [`set_check_name(Option<String>)`](crate::client::fluent_builders::UpdateAuditSuppression::set_check_name): <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`resource_identifier(ResourceIdentifier)`](crate::client::fluent_builders::UpdateAuditSuppression::resource_identifier) / [`set_resource_identifier(Option<ResourceIdentifier>)`](crate::client::fluent_builders::UpdateAuditSuppression::set_resource_identifier): <p>Information that identifies the noncompliant resource.</p>
    ///   - [`expiration_date(DateTime)`](crate::client::fluent_builders::UpdateAuditSuppression::expiration_date) / [`set_expiration_date(Option<DateTime>)`](crate::client::fluent_builders::UpdateAuditSuppression::set_expiration_date): <p> The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to. </p>
    ///   - [`suppress_indefinitely(bool)`](crate::client::fluent_builders::UpdateAuditSuppression::suppress_indefinitely) / [`set_suppress_indefinitely(Option<bool>)`](crate::client::fluent_builders::UpdateAuditSuppression::set_suppress_indefinitely): <p> Indicates whether a suppression should exist indefinitely or not. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateAuditSuppression::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateAuditSuppression::set_description): <p> The description of the audit suppression. </p>
    /// - On success, responds with [`UpdateAuditSuppressionOutput`](crate::output::UpdateAuditSuppressionOutput)

    /// - On failure, responds with [`SdkError<UpdateAuditSuppressionError>`](crate::error::UpdateAuditSuppressionError)
    pub fn update_audit_suppression(&self) -> fluent_builders::UpdateAuditSuppression<C, M, R> {
        fluent_builders::UpdateAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAuthorizer`](crate::client::fluent_builders::UpdateAuthorizer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authorizer_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_name) / [`set_authorizer_name(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_name): <p>The authorizer name.</p>
    ///   - [`authorizer_function_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::authorizer_function_arn) / [`set_authorizer_function_arn(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_authorizer_function_arn): <p>The ARN of the authorizer's Lambda function.</p>
    ///   - [`token_key_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAuthorizer::token_key_name) / [`set_token_key_name(Option<String>)`](crate::client::fluent_builders::UpdateAuthorizer::set_token_key_name): <p>The key used to extract the token from the HTTP headers. </p>
    ///   - [`token_signing_public_keys(HashMap<String, String>)`](crate::client::fluent_builders::UpdateAuthorizer::token_signing_public_keys) / [`set_token_signing_public_keys(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateAuthorizer::set_token_signing_public_keys): <p>The public keys used to verify the token signature.</p>
    ///   - [`status(AuthorizerStatus)`](crate::client::fluent_builders::UpdateAuthorizer::status) / [`set_status(Option<AuthorizerStatus>)`](crate::client::fluent_builders::UpdateAuthorizer::set_status): <p>The status of the update authorizer request.</p>
    ///   - [`enable_caching_for_http(bool)`](crate::client::fluent_builders::UpdateAuthorizer::enable_caching_for_http) / [`set_enable_caching_for_http(Option<bool>)`](crate::client::fluent_builders::UpdateAuthorizer::set_enable_caching_for_http): <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for the time specified in <code>refreshAfterInSeconds</code>. The cached result is used while the device reuses the same HTTP connection.</p>
    /// - On success, responds with [`UpdateAuthorizerOutput`](crate::output::UpdateAuthorizerOutput) with field(s):
    ///   - [`authorizer_name(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_name): <p>The authorizer name.</p>
    ///   - [`authorizer_arn(Option<String>)`](crate::output::UpdateAuthorizerOutput::authorizer_arn): <p>The authorizer ARN.</p>
    /// - On failure, responds with [`SdkError<UpdateAuthorizerError>`](crate::error::UpdateAuthorizerError)
    pub fn update_authorizer(&self) -> fluent_builders::UpdateAuthorizer<C, M, R> {
        fluent_builders::UpdateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBillingGroup`](crate::client::fluent_builders::UpdateBillingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`billing_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBillingGroup::billing_group_name) / [`set_billing_group_name(Option<String>)`](crate::client::fluent_builders::UpdateBillingGroup::set_billing_group_name): <p>The name of the billing group.</p>
    ///   - [`billing_group_properties(BillingGroupProperties)`](crate::client::fluent_builders::UpdateBillingGroup::billing_group_properties) / [`set_billing_group_properties(Option<BillingGroupProperties>)`](crate::client::fluent_builders::UpdateBillingGroup::set_billing_group_properties): <p>The properties of the billing group.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::UpdateBillingGroup::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::UpdateBillingGroup::set_expected_version): <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>UpdateBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
    /// - On success, responds with [`UpdateBillingGroupOutput`](crate::output::UpdateBillingGroupOutput) with field(s):
    ///   - [`version(i64)`](crate::output::UpdateBillingGroupOutput::version): <p>The latest version of the billing group.</p>
    /// - On failure, responds with [`SdkError<UpdateBillingGroupError>`](crate::error::UpdateBillingGroupError)
    pub fn update_billing_group(&self) -> fluent_builders::UpdateBillingGroup<C, M, R> {
        fluent_builders::UpdateBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCACertificate`](crate::client::fluent_builders::UpdateCACertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCACertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::UpdateCACertificate::set_certificate_id): <p>The CA certificate identifier.</p>
    ///   - [`new_status(CaCertificateStatus)`](crate::client::fluent_builders::UpdateCACertificate::new_status) / [`set_new_status(Option<CaCertificateStatus>)`](crate::client::fluent_builders::UpdateCACertificate::set_new_status): <p>The updated status of the CA certificate.</p>  <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    ///   - [`new_auto_registration_status(AutoRegistrationStatus)`](crate::client::fluent_builders::UpdateCACertificate::new_auto_registration_status) / [`set_new_auto_registration_status(Option<AutoRegistrationStatus>)`](crate::client::fluent_builders::UpdateCACertificate::set_new_auto_registration_status): <p>The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".</p>
    ///   - [`registration_config(RegistrationConfig)`](crate::client::fluent_builders::UpdateCACertificate::registration_config) / [`set_registration_config(Option<RegistrationConfig>)`](crate::client::fluent_builders::UpdateCACertificate::set_registration_config): <p>Information about the registration configuration.</p>
    ///   - [`remove_auto_registration(bool)`](crate::client::fluent_builders::UpdateCACertificate::remove_auto_registration) / [`set_remove_auto_registration(bool)`](crate::client::fluent_builders::UpdateCACertificate::set_remove_auto_registration): <p>If true, removes auto registration.</p>
    /// - On success, responds with [`UpdateCaCertificateOutput`](crate::output::UpdateCaCertificateOutput)

    /// - On failure, responds with [`SdkError<UpdateCACertificateError>`](crate::error::UpdateCACertificateError)
    pub fn update_ca_certificate(&self) -> fluent_builders::UpdateCACertificate<C, M, R> {
        fluent_builders::UpdateCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCertificate`](crate::client::fluent_builders::UpdateCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCertificate::certificate_id) / [`set_certificate_id(Option<String>)`](crate::client::fluent_builders::UpdateCertificate::set_certificate_id): <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
    ///   - [`new_status(CertificateStatus)`](crate::client::fluent_builders::UpdateCertificate::new_status) / [`set_new_status(Option<CertificateStatus>)`](crate::client::fluent_builders::UpdateCertificate::set_new_status): <p>The new status.</p>  <p> <b>Note:</b> Setting the status to PENDING_TRANSFER or PENDING_ACTIVATION will result in an exception being thrown. PENDING_TRANSFER and PENDING_ACTIVATION are statuses used internally by IoT. They are not intended for developer use.</p>  <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    /// - On success, responds with [`UpdateCertificateOutput`](crate::output::UpdateCertificateOutput)

    /// - On failure, responds with [`SdkError<UpdateCertificateError>`](crate::error::UpdateCertificateError)
    pub fn update_certificate(&self) -> fluent_builders::UpdateCertificate<C, M, R> {
        fluent_builders::UpdateCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomMetric`](crate::client::fluent_builders::UpdateCustomMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::UpdateCustomMetric::set_metric_name): <p> The name of the custom metric. Cannot be updated. </p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomMetric::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateCustomMetric::set_display_name): <p> Field represents a friendly name in the console for the custom metric, it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated. </p>
    /// - On success, responds with [`UpdateCustomMetricOutput`](crate::output::UpdateCustomMetricOutput) with field(s):
    ///   - [`metric_name(Option<String>)`](crate::output::UpdateCustomMetricOutput::metric_name): <p> The name of the custom metric. </p>
    ///   - [`metric_arn(Option<String>)`](crate::output::UpdateCustomMetricOutput::metric_arn): <p> The Amazon Resource Number (ARN) of the custom metric. </p>
    ///   - [`metric_type(Option<CustomMetricType>)`](crate::output::UpdateCustomMetricOutput::metric_type): <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
    ///   - [`display_name(Option<String>)`](crate::output::UpdateCustomMetricOutput::display_name): <p> A friendly name in the console for the custom metric </p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::UpdateCustomMetricOutput::creation_date): <p> The creation date of the custom metric in milliseconds since epoch. </p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::UpdateCustomMetricOutput::last_modified_date): <p> The time the custom metric was last modified in milliseconds since epoch. </p>
    /// - On failure, responds with [`SdkError<UpdateCustomMetricError>`](crate::error::UpdateCustomMetricError)
    pub fn update_custom_metric(&self) -> fluent_builders::UpdateCustomMetric<C, M, R> {
        fluent_builders::UpdateCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDimension`](crate::client::fluent_builders::UpdateDimension) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDimension::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDimension::set_name): <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
    ///   - [`string_values(Vec<String>)`](crate::client::fluent_builders::UpdateDimension::string_values) / [`set_string_values(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateDimension::set_string_values): <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
    /// - On success, responds with [`UpdateDimensionOutput`](crate::output::UpdateDimensionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateDimensionOutput::name): <p>A unique identifier for the dimension.</p>
    ///   - [`arn(Option<String>)`](crate::output::UpdateDimensionOutput::arn): <p>The Amazon Resource Name (ARN)of the created dimension.</p>
    ///   - [`r#type(Option<DimensionType>)`](crate::output::UpdateDimensionOutput::type): <p>The type of the dimension.</p>
    ///   - [`string_values(Option<Vec<String>>)`](crate::output::UpdateDimensionOutput::string_values): <p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::UpdateDimensionOutput::creation_date): <p>The date and time, in milliseconds since epoch, when the dimension was initially created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::UpdateDimensionOutput::last_modified_date): <p>The date and time, in milliseconds since epoch, when the dimension was most recently updated.</p>
    /// - On failure, responds with [`SdkError<UpdateDimensionError>`](crate::error::UpdateDimensionError)
    pub fn update_dimension(&self) -> fluent_builders::UpdateDimension<C, M, R> {
        fluent_builders::UpdateDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainConfiguration`](crate::client::fluent_builders::UpdateDomainConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_configuration_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainConfiguration::domain_configuration_name) / [`set_domain_configuration_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainConfiguration::set_domain_configuration_name): <p>The name of the domain configuration to be updated.</p>
    ///   - [`authorizer_config(AuthorizerConfig)`](crate::client::fluent_builders::UpdateDomainConfiguration::authorizer_config) / [`set_authorizer_config(Option<AuthorizerConfig>)`](crate::client::fluent_builders::UpdateDomainConfiguration::set_authorizer_config): <p>An object that specifies the authorization service for a domain.</p>
    ///   - [`domain_configuration_status(DomainConfigurationStatus)`](crate::client::fluent_builders::UpdateDomainConfiguration::domain_configuration_status) / [`set_domain_configuration_status(Option<DomainConfigurationStatus>)`](crate::client::fluent_builders::UpdateDomainConfiguration::set_domain_configuration_status): <p>The status to which the domain configuration should be updated.</p>
    ///   - [`remove_authorizer_config(bool)`](crate::client::fluent_builders::UpdateDomainConfiguration::remove_authorizer_config) / [`set_remove_authorizer_config(bool)`](crate::client::fluent_builders::UpdateDomainConfiguration::set_remove_authorizer_config): <p>Removes the authorization configuration from a domain.</p>
    /// - On success, responds with [`UpdateDomainConfigurationOutput`](crate::output::UpdateDomainConfigurationOutput) with field(s):
    ///   - [`domain_configuration_name(Option<String>)`](crate::output::UpdateDomainConfigurationOutput::domain_configuration_name): <p>The name of the domain configuration that was updated.</p>
    ///   - [`domain_configuration_arn(Option<String>)`](crate::output::UpdateDomainConfigurationOutput::domain_configuration_arn): <p>The ARN of the domain configuration that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainConfigurationError>`](crate::error::UpdateDomainConfigurationError)
    pub fn update_domain_configuration(
        &self,
    ) -> fluent_builders::UpdateDomainConfiguration<C, M, R> {
        fluent_builders::UpdateDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDynamicThingGroup`](crate::client::fluent_builders::UpdateDynamicThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::set_thing_group_name): <p>The name of the dynamic thing group to update.</p>
    ///   - [`thing_group_properties(ThingGroupProperties)`](crate::client::fluent_builders::UpdateDynamicThingGroup::thing_group_properties) / [`set_thing_group_properties(Option<ThingGroupProperties>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::set_thing_group_properties): <p>The dynamic thing group properties to update.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::UpdateDynamicThingGroup::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::set_expected_version): <p>The expected version of the dynamic thing group to update.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::set_index_name): <p>The dynamic thing group index to update.</p> <note>   <p>Currently one index is supported: <code>AWS_Things</code>.</p>  </note>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::set_query_string): <p>The dynamic thing group search query string to update.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::UpdateDynamicThingGroup::set_query_version): <p>The dynamic thing group query version to update.</p> <note>   <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>  </note>
    /// - On success, responds with [`UpdateDynamicThingGroupOutput`](crate::output::UpdateDynamicThingGroupOutput) with field(s):
    ///   - [`version(i64)`](crate::output::UpdateDynamicThingGroupOutput::version): <p>The dynamic thing group version.</p>
    /// - On failure, responds with [`SdkError<UpdateDynamicThingGroupError>`](crate::error::UpdateDynamicThingGroupError)
    pub fn update_dynamic_thing_group(&self) -> fluent_builders::UpdateDynamicThingGroup<C, M, R> {
        fluent_builders::UpdateDynamicThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEventConfigurations`](crate::client::fluent_builders::UpdateEventConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_configurations(HashMap<EventType, Configuration>)`](crate::client::fluent_builders::UpdateEventConfigurations::event_configurations) / [`set_event_configurations(Option<HashMap<EventType, Configuration>>)`](crate::client::fluent_builders::UpdateEventConfigurations::set_event_configurations): <p>The new event configuration values.</p>
    /// - On success, responds with [`UpdateEventConfigurationsOutput`](crate::output::UpdateEventConfigurationsOutput)

    /// - On failure, responds with [`SdkError<UpdateEventConfigurationsError>`](crate::error::UpdateEventConfigurationsError)
    pub fn update_event_configurations(
        &self,
    ) -> fluent_builders::UpdateEventConfigurations<C, M, R> {
        fluent_builders::UpdateEventConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFleetMetric`](crate::client::fluent_builders::UpdateFleetMetric) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetric::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetric::set_metric_name): <p>The name of the fleet metric to update.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetric::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetric::set_query_string): <p>The search query string.</p>
    ///   - [`aggregation_type(AggregationType)`](crate::client::fluent_builders::UpdateFleetMetric::aggregation_type) / [`set_aggregation_type(Option<AggregationType>)`](crate::client::fluent_builders::UpdateFleetMetric::set_aggregation_type): <p>The type of the aggregation query.</p>
    ///   - [`period(i32)`](crate::client::fluent_builders::UpdateFleetMetric::period) / [`set_period(Option<i32>)`](crate::client::fluent_builders::UpdateFleetMetric::set_period): <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
    ///   - [`aggregation_field(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetric::aggregation_field) / [`set_aggregation_field(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetric::set_aggregation_field): <p>The field to aggregate.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetric::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetric::set_description): <p>The description of the fleet metric.</p>
    ///   - [`query_version(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetric::query_version) / [`set_query_version(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetric::set_query_version): <p>The version of the query.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFleetMetric::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::UpdateFleetMetric::set_index_name): <p>The name of the index to search.</p>
    ///   - [`unit(FleetMetricUnit)`](crate::client::fluent_builders::UpdateFleetMetric::unit) / [`set_unit(Option<FleetMetricUnit>)`](crate::client::fluent_builders::UpdateFleetMetric::set_unit): <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::UpdateFleetMetric::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::UpdateFleetMetric::set_expected_version): <p>The expected version of the fleet metric record in the registry.</p>
    /// - On success, responds with [`UpdateFleetMetricOutput`](crate::output::UpdateFleetMetricOutput)

    /// - On failure, responds with [`SdkError<UpdateFleetMetricError>`](crate::error::UpdateFleetMetricError)
    pub fn update_fleet_metric(&self) -> fluent_builders::UpdateFleetMetric<C, M, R> {
        fluent_builders::UpdateFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIndexingConfiguration`](crate::client::fluent_builders::UpdateIndexingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_indexing_configuration(ThingIndexingConfiguration)`](crate::client::fluent_builders::UpdateIndexingConfiguration::thing_indexing_configuration) / [`set_thing_indexing_configuration(Option<ThingIndexingConfiguration>)`](crate::client::fluent_builders::UpdateIndexingConfiguration::set_thing_indexing_configuration): <p>Thing indexing configuration.</p>
    ///   - [`thing_group_indexing_configuration(ThingGroupIndexingConfiguration)`](crate::client::fluent_builders::UpdateIndexingConfiguration::thing_group_indexing_configuration) / [`set_thing_group_indexing_configuration(Option<ThingGroupIndexingConfiguration>)`](crate::client::fluent_builders::UpdateIndexingConfiguration::set_thing_group_indexing_configuration): <p>Thing group indexing configuration.</p>
    /// - On success, responds with [`UpdateIndexingConfigurationOutput`](crate::output::UpdateIndexingConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateIndexingConfigurationError>`](crate::error::UpdateIndexingConfigurationError)
    pub fn update_indexing_configuration(
        &self,
    ) -> fluent_builders::UpdateIndexingConfiguration<C, M, R> {
        fluent_builders::UpdateIndexingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateJob`](crate::client::fluent_builders::UpdateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_job_id): <p>The ID of the job to be updated.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_description): <p>A short text description of the job.</p>
    ///   - [`presigned_url_config(PresignedUrlConfig)`](crate::client::fluent_builders::UpdateJob::presigned_url_config) / [`set_presigned_url_config(Option<PresignedUrlConfig>)`](crate::client::fluent_builders::UpdateJob::set_presigned_url_config): <p>Configuration information for pre-signed S3 URLs.</p>
    ///   - [`job_executions_rollout_config(JobExecutionsRolloutConfig)`](crate::client::fluent_builders::UpdateJob::job_executions_rollout_config) / [`set_job_executions_rollout_config(Option<JobExecutionsRolloutConfig>)`](crate::client::fluent_builders::UpdateJob::set_job_executions_rollout_config): <p>Allows you to create a staged rollout of the job.</p>
    ///   - [`abort_config(AbortConfig)`](crate::client::fluent_builders::UpdateJob::abort_config) / [`set_abort_config(Option<AbortConfig>)`](crate::client::fluent_builders::UpdateJob::set_abort_config): <p>Allows you to create criteria to abort a job.</p>
    ///   - [`timeout_config(TimeoutConfig)`](crate::client::fluent_builders::UpdateJob::timeout_config) / [`set_timeout_config(Option<TimeoutConfig>)`](crate::client::fluent_builders::UpdateJob::set_timeout_config): <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>. </p>
    ///   - [`namespace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::namespace_id) / [`set_namespace_id(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_namespace_id): <p>The namespace used to indicate that a job is a customer-managed job.</p>  <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>  <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>   <p>The <code>namespaceId</code> feature is in public preview.</p>  </note>
    ///   - [`job_executions_retry_config(JobExecutionsRetryConfig)`](crate::client::fluent_builders::UpdateJob::job_executions_retry_config) / [`set_job_executions_retry_config(Option<JobExecutionsRetryConfig>)`](crate::client::fluent_builders::UpdateJob::set_job_executions_retry_config): <p>Allows you to create the criteria to retry a job.</p>
    /// - On success, responds with [`UpdateJobOutput`](crate::output::UpdateJobOutput)

    /// - On failure, responds with [`SdkError<UpdateJobError>`](crate::error::UpdateJobError)
    pub fn update_job(&self) -> fluent_builders::UpdateJob<C, M, R> {
        fluent_builders::UpdateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMitigationAction`](crate::client::fluent_builders::UpdateMitigationAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_name(impl Into<String>)`](crate::client::fluent_builders::UpdateMitigationAction::action_name) / [`set_action_name(Option<String>)`](crate::client::fluent_builders::UpdateMitigationAction::set_action_name): <p>The friendly name for the mitigation action. You cannot change the name by using <code>UpdateMitigationAction</code>. Instead, you must delete and recreate the mitigation action with the new name.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateMitigationAction::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateMitigationAction::set_role_arn): <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
    ///   - [`action_params(MitigationActionParams)`](crate::client::fluent_builders::UpdateMitigationAction::action_params) / [`set_action_params(Option<MitigationActionParams>)`](crate::client::fluent_builders::UpdateMitigationAction::set_action_params): <p>Defines the type of action and the parameters for that action.</p>
    /// - On success, responds with [`UpdateMitigationActionOutput`](crate::output::UpdateMitigationActionOutput) with field(s):
    ///   - [`action_arn(Option<String>)`](crate::output::UpdateMitigationActionOutput::action_arn): <p>The ARN for the new mitigation action.</p>
    ///   - [`action_id(Option<String>)`](crate::output::UpdateMitigationActionOutput::action_id): <p>A unique identifier for the mitigation action.</p>
    /// - On failure, responds with [`SdkError<UpdateMitigationActionError>`](crate::error::UpdateMitigationActionError)
    pub fn update_mitigation_action(&self) -> fluent_builders::UpdateMitigationAction<C, M, R> {
        fluent_builders::UpdateMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProvisioningTemplate`](crate::client::fluent_builders::UpdateProvisioningTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::template_name) / [`set_template_name(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::set_template_name): <p>The name of the fleet provisioning template.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::set_description): <p>The description of the fleet provisioning template.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateProvisioningTemplate::enabled) / [`set_enabled(bool)`](crate::client::fluent_builders::UpdateProvisioningTemplate::set_enabled): <p>True to enable the fleet provisioning template, otherwise false.</p>
    ///   - [`default_version_id(i32)`](crate::client::fluent_builders::UpdateProvisioningTemplate::default_version_id) / [`set_default_version_id(Option<i32>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::set_default_version_id): <p>The ID of the default provisioning template version.</p>
    ///   - [`provisioning_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::provisioning_role_arn) / [`set_provisioning_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::set_provisioning_role_arn): <p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>
    ///   - [`pre_provisioning_hook(ProvisioningHook)`](crate::client::fluent_builders::UpdateProvisioningTemplate::pre_provisioning_hook) / [`set_pre_provisioning_hook(Option<ProvisioningHook>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::set_pre_provisioning_hook): <p>Updates the pre-provisioning hook template.</p>
    ///   - [`remove_pre_provisioning_hook(bool)`](crate::client::fluent_builders::UpdateProvisioningTemplate::remove_pre_provisioning_hook) / [`set_remove_pre_provisioning_hook(Option<bool>)`](crate::client::fluent_builders::UpdateProvisioningTemplate::set_remove_pre_provisioning_hook): <p>Removes pre-provisioning hook template.</p>
    /// - On success, responds with [`UpdateProvisioningTemplateOutput`](crate::output::UpdateProvisioningTemplateOutput)

    /// - On failure, responds with [`SdkError<UpdateProvisioningTemplateError>`](crate::error::UpdateProvisioningTemplateError)
    pub fn update_provisioning_template(
        &self,
    ) -> fluent_builders::UpdateProvisioningTemplate<C, M, R> {
        fluent_builders::UpdateProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoleAlias`](crate::client::fluent_builders::UpdateRoleAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_alias(impl Into<String>)`](crate::client::fluent_builders::UpdateRoleAlias::role_alias) / [`set_role_alias(Option<String>)`](crate::client::fluent_builders::UpdateRoleAlias::set_role_alias): <p>The role alias to update.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateRoleAlias::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateRoleAlias::set_role_arn): <p>The role ARN.</p>
    ///   - [`credential_duration_seconds(i32)`](crate::client::fluent_builders::UpdateRoleAlias::credential_duration_seconds) / [`set_credential_duration_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateRoleAlias::set_credential_duration_seconds): <p>The number of seconds the credential will be valid.</p>
    /// - On success, responds with [`UpdateRoleAliasOutput`](crate::output::UpdateRoleAliasOutput) with field(s):
    ///   - [`role_alias(Option<String>)`](crate::output::UpdateRoleAliasOutput::role_alias): <p>The role alias.</p>
    ///   - [`role_alias_arn(Option<String>)`](crate::output::UpdateRoleAliasOutput::role_alias_arn): <p>The role alias ARN.</p>
    /// - On failure, responds with [`SdkError<UpdateRoleAliasError>`](crate::error::UpdateRoleAliasError)
    pub fn update_role_alias(&self) -> fluent_builders::UpdateRoleAlias<C, M, R> {
        fluent_builders::UpdateRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateScheduledAudit`](crate::client::fluent_builders::UpdateScheduledAudit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`frequency(AuditFrequency)`](crate::client::fluent_builders::UpdateScheduledAudit::frequency) / [`set_frequency(Option<AuditFrequency>)`](crate::client::fluent_builders::UpdateScheduledAudit::set_frequency): <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code>, or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
    ///   - [`day_of_month(impl Into<String>)`](crate::client::fluent_builders::UpdateScheduledAudit::day_of_month) / [`set_day_of_month(Option<String>)`](crate::client::fluent_builders::UpdateScheduledAudit::set_day_of_month): <p>The day of the month on which the scheduled audit takes place. This can be <code>1</code> through <code>31</code> or <code>LAST</code>. This field is required if the <code>frequency</code> parameter is set to <code>MONTHLY</code>. If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.</p>
    ///   - [`day_of_week(DayOfWeek)`](crate::client::fluent_builders::UpdateScheduledAudit::day_of_week) / [`set_day_of_week(Option<DayOfWeek>)`](crate::client::fluent_builders::UpdateScheduledAudit::set_day_of_week): <p>The day of the week on which the scheduled audit takes place. This can be one of <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the "frequency" parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
    ///   - [`target_check_names(Vec<String>)`](crate::client::fluent_builders::UpdateScheduledAudit::target_check_names) / [`set_target_check_names(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateScheduledAudit::set_target_check_names): <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
    ///   - [`scheduled_audit_name(impl Into<String>)`](crate::client::fluent_builders::UpdateScheduledAudit::scheduled_audit_name) / [`set_scheduled_audit_name(Option<String>)`](crate::client::fluent_builders::UpdateScheduledAudit::set_scheduled_audit_name): <p>The name of the scheduled audit. (Max. 128 chars)</p>
    /// - On success, responds with [`UpdateScheduledAuditOutput`](crate::output::UpdateScheduledAuditOutput) with field(s):
    ///   - [`scheduled_audit_arn(Option<String>)`](crate::output::UpdateScheduledAuditOutput::scheduled_audit_arn): <p>The ARN of the scheduled audit.</p>
    /// - On failure, responds with [`SdkError<UpdateScheduledAuditError>`](crate::error::UpdateScheduledAuditError)
    pub fn update_scheduled_audit(&self) -> fluent_builders::UpdateScheduledAudit<C, M, R> {
        fluent_builders::UpdateScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSecurityProfile`](crate::client::fluent_builders::UpdateSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_security_profile_name): <p>The name of the security profile you want to update.</p>
    ///   - [`security_profile_description(impl Into<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::security_profile_description) / [`set_security_profile_description(Option<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_security_profile_description): <p>A description of the security profile.</p>
    ///   - [`behaviors(Vec<Behavior>)`](crate::client::fluent_builders::UpdateSecurityProfile::behaviors) / [`set_behaviors(Option<Vec<Behavior>>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_behaviors): <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    ///   - [`alert_targets(HashMap<AlertTargetType, AlertTarget>)`](crate::client::fluent_builders::UpdateSecurityProfile::alert_targets) / [`set_alert_targets(Option<HashMap<AlertTargetType, AlertTarget>>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_alert_targets): <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    ///   - [`additional_metrics_to_retain(Vec<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::additional_metrics_to_retain) / [`set_additional_metrics_to_retain(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_additional_metrics_to_retain): <p> <i>Please use <code>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>  <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    ///   - [`additional_metrics_to_retain_v2(Vec<MetricToRetain>)`](crate::client::fluent_builders::UpdateSecurityProfile::additional_metrics_to_retain_v2) / [`set_additional_metrics_to_retain_v2(Option<Vec<MetricToRetain>>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_additional_metrics_to_retain_v2): <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    ///   - [`delete_behaviors(bool)`](crate::client::fluent_builders::UpdateSecurityProfile::delete_behaviors) / [`set_delete_behaviors(bool)`](crate::client::fluent_builders::UpdateSecurityProfile::set_delete_behaviors): <p>If true, delete all <code>behaviors</code> defined for this security profile. If any <code>behaviors</code> are defined in the current invocation, an exception occurs.</p>
    ///   - [`delete_alert_targets(bool)`](crate::client::fluent_builders::UpdateSecurityProfile::delete_alert_targets) / [`set_delete_alert_targets(bool)`](crate::client::fluent_builders::UpdateSecurityProfile::set_delete_alert_targets): <p>If true, delete all <code>alertTargets</code> defined for this security profile. If any <code>alertTargets</code> are defined in the current invocation, an exception occurs.</p>
    ///   - [`delete_additional_metrics_to_retain(bool)`](crate::client::fluent_builders::UpdateSecurityProfile::delete_additional_metrics_to_retain) / [`set_delete_additional_metrics_to_retain(bool)`](crate::client::fluent_builders::UpdateSecurityProfile::set_delete_additional_metrics_to_retain): <p>If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::UpdateSecurityProfile::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_expected_version): <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
    /// - On success, responds with [`UpdateSecurityProfileOutput`](crate::output::UpdateSecurityProfileOutput) with field(s):
    ///   - [`security_profile_name(Option<String>)`](crate::output::UpdateSecurityProfileOutput::security_profile_name): <p>The name of the security profile that was updated.</p>
    ///   - [`security_profile_arn(Option<String>)`](crate::output::UpdateSecurityProfileOutput::security_profile_arn): <p>The ARN of the security profile that was updated.</p>
    ///   - [`security_profile_description(Option<String>)`](crate::output::UpdateSecurityProfileOutput::security_profile_description): <p>The description of the security profile.</p>
    ///   - [`behaviors(Option<Vec<Behavior>>)`](crate::output::UpdateSecurityProfileOutput::behaviors): <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    ///   - [`alert_targets(Option<HashMap<AlertTargetType, AlertTarget>>)`](crate::output::UpdateSecurityProfileOutput::alert_targets): <p>Where the alerts are sent. (Alerts are always sent to the console.)</p>
    ///   - [`additional_metrics_to_retain(Option<Vec<String>>)`](crate::output::UpdateSecurityProfileOutput::additional_metrics_to_retain): <p> <i>Please use <code>UpdateSecurityProfileResponse$additionalMetricsToRetainV2</code> instead.</i> </p>  <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the security profile's <code>behaviors</code>, but it is also retained for any metric specified here.</p>
    ///   - [`additional_metrics_to_retain_v2(Option<Vec<MetricToRetain>>)`](crate::output::UpdateSecurityProfileOutput::additional_metrics_to_retain_v2): <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's behaviors, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
    ///   - [`version(i64)`](crate::output::UpdateSecurityProfileOutput::version): <p>The updated version of the security profile.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::UpdateSecurityProfileOutput::creation_date): <p>The time the security profile was created.</p>
    ///   - [`last_modified_date(Option<DateTime>)`](crate::output::UpdateSecurityProfileOutput::last_modified_date): <p>The time the security profile was last modified.</p>
    /// - On failure, responds with [`SdkError<UpdateSecurityProfileError>`](crate::error::UpdateSecurityProfileError)
    pub fn update_security_profile(&self) -> fluent_builders::UpdateSecurityProfile<C, M, R> {
        fluent_builders::UpdateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStream`](crate::client::fluent_builders::UpdateStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_stream_id): <p>The stream ID.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_description): <p>The description of the stream.</p>
    ///   - [`files(Vec<StreamFile>)`](crate::client::fluent_builders::UpdateStream::files) / [`set_files(Option<Vec<StreamFile>>)`](crate::client::fluent_builders::UpdateStream::set_files): <p>The files associated with the stream.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateStream::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateStream::set_role_arn): <p>An IAM role that allows the IoT service principal assumes to access your S3 files.</p>
    /// - On success, responds with [`UpdateStreamOutput`](crate::output::UpdateStreamOutput) with field(s):
    ///   - [`stream_id(Option<String>)`](crate::output::UpdateStreamOutput::stream_id): <p>The stream ID.</p>
    ///   - [`stream_arn(Option<String>)`](crate::output::UpdateStreamOutput::stream_arn): <p>The stream ARN.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateStreamOutput::description): <p>A description of the stream.</p>
    ///   - [`stream_version(Option<i32>)`](crate::output::UpdateStreamOutput::stream_version): <p>The stream version.</p>
    /// - On failure, responds with [`SdkError<UpdateStreamError>`](crate::error::UpdateStreamError)
    pub fn update_stream(&self) -> fluent_builders::UpdateStream<C, M, R> {
        fluent_builders::UpdateStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateThing`](crate::client::fluent_builders::UpdateThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::UpdateThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::UpdateThing::set_thing_name): <p>The name of the thing to update.</p>  <p>You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
    ///   - [`thing_type_name(impl Into<String>)`](crate::client::fluent_builders::UpdateThing::thing_type_name) / [`set_thing_type_name(Option<String>)`](crate::client::fluent_builders::UpdateThing::set_thing_type_name): <p>The name of the thing type.</p>
    ///   - [`attribute_payload(AttributePayload)`](crate::client::fluent_builders::UpdateThing::attribute_payload) / [`set_attribute_payload(Option<AttributePayload>)`](crate::client::fluent_builders::UpdateThing::set_attribute_payload): <p>A list of thing attributes, a JSON string containing name-value pairs. For example:</p>  <p> <code>{\"attributes\":{\"name1\":\"value2\"}}</code> </p>  <p>This data is used to add new attributes or update existing attributes.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::UpdateThing::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::UpdateThing::set_expected_version): <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>UpdateThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
    ///   - [`remove_thing_type(bool)`](crate::client::fluent_builders::UpdateThing::remove_thing_type) / [`set_remove_thing_type(bool)`](crate::client::fluent_builders::UpdateThing::set_remove_thing_type): <p>Remove a thing type association. If <b>true</b>, the association is removed.</p>
    /// - On success, responds with [`UpdateThingOutput`](crate::output::UpdateThingOutput)

    /// - On failure, responds with [`SdkError<UpdateThingError>`](crate::error::UpdateThingError)
    pub fn update_thing(&self) -> fluent_builders::UpdateThing<C, M, R> {
        fluent_builders::UpdateThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateThingGroup`](crate::client::fluent_builders::UpdateThingGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateThingGroup::thing_group_name) / [`set_thing_group_name(Option<String>)`](crate::client::fluent_builders::UpdateThingGroup::set_thing_group_name): <p>The thing group to update.</p>
    ///   - [`thing_group_properties(ThingGroupProperties)`](crate::client::fluent_builders::UpdateThingGroup::thing_group_properties) / [`set_thing_group_properties(Option<ThingGroupProperties>)`](crate::client::fluent_builders::UpdateThingGroup::set_thing_group_properties): <p>The thing group properties.</p>
    ///   - [`expected_version(i64)`](crate::client::fluent_builders::UpdateThingGroup::expected_version) / [`set_expected_version(Option<i64>)`](crate::client::fluent_builders::UpdateThingGroup::set_expected_version): <p>The expected version of the thing group. If this does not match the version of the thing group being updated, the update will fail.</p>
    /// - On success, responds with [`UpdateThingGroupOutput`](crate::output::UpdateThingGroupOutput) with field(s):
    ///   - [`version(i64)`](crate::output::UpdateThingGroupOutput::version): <p>The version of the updated thing group.</p>
    /// - On failure, responds with [`SdkError<UpdateThingGroupError>`](crate::error::UpdateThingGroupError)
    pub fn update_thing_group(&self) -> fluent_builders::UpdateThingGroup<C, M, R> {
        fluent_builders::UpdateThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateThingGroupsForThing`](crate::client::fluent_builders::UpdateThingGroupsForThing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::UpdateThingGroupsForThing::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::UpdateThingGroupsForThing::set_thing_name): <p>The thing whose group memberships will be updated.</p>
    ///   - [`thing_groups_to_add(Vec<String>)`](crate::client::fluent_builders::UpdateThingGroupsForThing::thing_groups_to_add) / [`set_thing_groups_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateThingGroupsForThing::set_thing_groups_to_add): <p>The groups to which the thing will be added.</p>
    ///   - [`thing_groups_to_remove(Vec<String>)`](crate::client::fluent_builders::UpdateThingGroupsForThing::thing_groups_to_remove) / [`set_thing_groups_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateThingGroupsForThing::set_thing_groups_to_remove): <p>The groups from which the thing will be removed.</p>
    ///   - [`override_dynamic_groups(bool)`](crate::client::fluent_builders::UpdateThingGroupsForThing::override_dynamic_groups) / [`set_override_dynamic_groups(bool)`](crate::client::fluent_builders::UpdateThingGroupsForThing::set_override_dynamic_groups): <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
    /// - On success, responds with [`UpdateThingGroupsForThingOutput`](crate::output::UpdateThingGroupsForThingOutput)

    /// - On failure, responds with [`SdkError<UpdateThingGroupsForThingError>`](crate::error::UpdateThingGroupsForThingError)
    pub fn update_thing_groups_for_thing(
        &self,
    ) -> fluent_builders::UpdateThingGroupsForThing<C, M, R> {
        fluent_builders::UpdateThingGroupsForThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTopicRuleDestination`](crate::client::fluent_builders::UpdateTopicRuleDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateTopicRuleDestination::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateTopicRuleDestination::set_arn): <p>The ARN of the topic rule destination.</p>
    ///   - [`status(TopicRuleDestinationStatus)`](crate::client::fluent_builders::UpdateTopicRuleDestination::status) / [`set_status(Option<TopicRuleDestinationStatus>)`](crate::client::fluent_builders::UpdateTopicRuleDestination::set_status): <p>The status of the topic rule destination. Valid values are:</p>  <dl>   <dt>   IN_PROGRESS  </dt>   <dd>    <p>A topic rule destination was created but has not been confirmed. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p>   </dd>   <dt>   ENABLED  </dt>   <dd>    <p>Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p>   </dd>   <dt>   DISABLED  </dt>   <dd>    <p>Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p>   </dd>   <dt>   ERROR  </dt>   <dd>    <p>Confirmation could not be completed, for example if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p>   </dd>  </dl>
    /// - On success, responds with [`UpdateTopicRuleDestinationOutput`](crate::output::UpdateTopicRuleDestinationOutput)

    /// - On failure, responds with [`SdkError<UpdateTopicRuleDestinationError>`](crate::error::UpdateTopicRuleDestinationError)
    pub fn update_topic_rule_destination(
        &self,
    ) -> fluent_builders::UpdateTopicRuleDestination<C, M, R> {
        fluent_builders::UpdateTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ValidateSecurityProfileBehaviors`](crate::client::fluent_builders::ValidateSecurityProfileBehaviors) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`behaviors(Vec<Behavior>)`](crate::client::fluent_builders::ValidateSecurityProfileBehaviors::behaviors) / [`set_behaviors(Option<Vec<Behavior>>)`](crate::client::fluent_builders::ValidateSecurityProfileBehaviors::set_behaviors): <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
    /// - On success, responds with [`ValidateSecurityProfileBehaviorsOutput`](crate::output::ValidateSecurityProfileBehaviorsOutput) with field(s):
    ///   - [`valid(bool)`](crate::output::ValidateSecurityProfileBehaviorsOutput::valid): <p>True if the behaviors were valid.</p>
    ///   - [`validation_errors(Option<Vec<ValidationError>>)`](crate::output::ValidateSecurityProfileBehaviorsOutput::validation_errors): <p>The list of any errors found in the behaviors.</p>
    /// - On failure, responds with [`SdkError<ValidateSecurityProfileBehaviorsError>`](crate::error::ValidateSecurityProfileBehaviorsError)
    pub fn validate_security_profile_behaviors(
        &self,
    ) -> fluent_builders::ValidateSecurityProfileBehaviors<C, M, R> {
        fluent_builders::ValidateSecurityProfileBehaviors::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptCertificateTransfer`.
    ///
    /// <p>Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.</p>
    /// <p>To check for pending certificate transfers, call <code>ListCertificates</code> to enumerate your certificates.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AcceptCertificateTransfer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptCertificateTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_certificate_transfer_input::Builder,
    }
    impl<C, M, R> AcceptCertificateTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptCertificateTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptCertificateTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptCertificateTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptCertificateTransferInputOperationOutputAlias,
                crate::output::AcceptCertificateTransferOutput,
                crate::error::AcceptCertificateTransferError,
                crate::input::AcceptCertificateTransferInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddThingToBillingGroup`.
    ///
    /// <p>Adds a thing to a billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddThingToBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_thing_to_billing_group_input::Builder,
    }
    impl<C, M, R> AddThingToBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddThingToBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddThingToBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AddThingToBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddThingToBillingGroupInputOperationOutputAlias,
                crate::output::AddThingToBillingGroupOutput,
                crate::error::AddThingToBillingGroupError,
                crate::input::AddThingToBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the billing group.</p> <note>
        /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
        /// </note>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group.</p> <note>
        /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
        /// </note>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_arn(input.into());
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_arn(input);
            self
        }
        /// <p>The name of the thing to be added to the billing group.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to be added to the billing group.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ARN of the thing to be added to the billing group.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(input.into());
            self
        }
        /// <p>The ARN of the thing to be added to the billing group.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddThingToThingGroup`.
    ///
    /// <p>Adds a thing to a thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddThingToThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_thing_to_thing_group_input::Builder,
    }
    impl<C, M, R> AddThingToThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddThingToThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddThingToThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AddThingToThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddThingToThingGroupInputOperationOutputAlias,
                crate::output::AddThingToThingGroupOutput,
                crate::error::AddThingToThingGroupError,
                crate::input::AddThingToThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group to which you are adding a thing.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the group to which you are adding a thing.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The ARN of the group to which you are adding a thing.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_arn(input.into());
            self
        }
        /// <p>The ARN of the group to which you are adding a thing.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_arn(input);
            self
        }
        /// <p>The name of the thing to add to a group.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to add to a group.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ARN of the thing to add to a group.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(input.into());
            self
        }
        /// <p>The ARN of the thing to add to a group.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
        /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
        pub fn override_dynamic_groups(mut self, input: bool) -> Self {
            self.inner = self.inner.override_dynamic_groups(input);
            self
        }
        /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
        pub fn set_override_dynamic_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_override_dynamic_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTargetsWithJob`.
    ///
    /// <p>Associates a group with a continuous job. The following criteria must be met: </p>
    /// <ul>
    /// <li> <p>The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".</p> </li>
    /// <li> <p>The job status must currently be "IN_PROGRESS".</p> </li>
    /// <li> <p>The total number of targets associated with a job must not exceed 100.</p> </li>
    /// </ul>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AssociateTargetsWithJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTargetsWithJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_targets_with_job_input::Builder,
    }
    impl<C, M, R> AssociateTargetsWithJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTargetsWithJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTargetsWithJobOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTargetsWithJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTargetsWithJobInputOperationOutputAlias,
                crate::output::AssociateTargetsWithJobOutput,
                crate::error::AssociateTargetsWithJobError,
                crate::input::AssociateTargetsWithJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of thing group ARNs that define the targets of the job.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.targets(input.into());
            self
        }
        /// <p>A list of thing group ARNs that define the targets of the job.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>An optional comment string describing why the job was associated with the targets.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment string describing why the job was associated with the targets.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPolicy`.
    ///
    /// <p>Attaches the specified policy to the specified principal (certificate or other credential).</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_policy_input::Builder,
    }
    impl<C, M, R> AttachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachPolicyInputOperationOutputAlias,
                crate::output::AttachPolicyOutput,
                crate::error::AttachPolicyError,
                crate::input::AttachPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy to attach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to attach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPrincipalPolicy`.
    ///
    /// <p>Attaches the specified policy to the specified principal (certificate or other credential).</p>
    /// <p> <b>Note:</b> This action is deprecated. Please use <code>AttachPolicy</code> instead.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPrincipalPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachPrincipalPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_principal_policy_input::Builder,
    }
    impl<C, M, R> AttachPrincipalPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachPrincipalPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPrincipalPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPrincipalPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachPrincipalPolicyInputOperationOutputAlias,
                crate::output::AttachPrincipalPolicyOutput,
                crate::error::AttachPrincipalPolicyError,
                crate::input::AttachPrincipalPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachSecurityProfile`.
    ///
    /// <p>Associates a Device Defender security profile with a thing group or this account. Each thing group or account can have up to five security profiles associated with it.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_security_profile_input::Builder,
    }
    impl<C, M, R> AttachSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachSecurityProfileInputOperationOutputAlias,
                crate::output::AttachSecurityProfileOutput,
                crate::error::AttachSecurityProfileError,
                crate::input::AttachSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The security profile that is attached.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The security profile that is attached.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The ARN of the target (thing group) to which the security profile is attached.</p>
        pub fn security_profile_target_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.security_profile_target_arn(input.into());
            self
        }
        /// <p>The ARN of the target (thing group) to which the security profile is attached.</p>
        pub fn set_security_profile_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachThingPrincipal`.
    ///
    /// <p>Attaches the specified principal to the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachThingPrincipal</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachThingPrincipal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_thing_principal_input::Builder,
    }
    impl<C, M, R> AttachThingPrincipal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachThingPrincipal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachThingPrincipalOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachThingPrincipalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachThingPrincipalInputOperationOutputAlias,
                crate::output::AttachThingPrincipalOutput,
                crate::error::AttachThingPrincipalError,
                crate::input::AttachThingPrincipalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelAuditMitigationActionsTask`.
    ///
    /// <p>Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException occurs.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditMitigationActionsTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelAuditMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_audit_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> CancelAuditMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelAuditMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelAuditMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelAuditMitigationActionsTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelAuditMitigationActionsTaskInputOperationOutputAlias,
                crate::output::CancelAuditMitigationActionsTaskOutput,
                crate::error::CancelAuditMitigationActionsTaskError,
                crate::input::CancelAuditMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the task that you want to cancel. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The unique identifier for the task that you want to cancel. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelAuditTask`.
    ///
    /// <p>Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelAuditTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_audit_task_input::Builder,
    }
    impl<C, M, R> CancelAuditTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelAuditTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelAuditTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelAuditTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelAuditTaskInputOperationOutputAlias,
                crate::output::CancelAuditTaskOutput,
                crate::error::CancelAuditTaskError,
                crate::input::CancelAuditTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelCertificateTransfer`.
    ///
    /// <p>Cancels a pending transfer for the specified certificate.</p>
    /// <p> <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations can use <code>RejectCertificateTransfer</code> instead.) After transfer, IoT returns the certificate to the source account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be cancelled.</p>
    /// <p>After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to INACTIVE.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelCertificateTransfer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelCertificateTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_certificate_transfer_input::Builder,
    }
    impl<C, M, R> CancelCertificateTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelCertificateTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelCertificateTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelCertificateTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelCertificateTransferInputOperationOutputAlias,
                crate::output::CancelCertificateTransferOutput,
                crate::error::CancelCertificateTransferError,
                crate::input::CancelCertificateTransferInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelDetectMitigationActionsTask`.
    ///
    /// <p> Cancels a Device Defender ML Detect mitigation action. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelDetectMitigationActionsTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelDetectMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_detect_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> CancelDetectMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelDetectMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelDetectMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelDetectMitigationActionsTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelDetectMitigationActionsTaskInputOperationOutputAlias,
                crate::output::CancelDetectMitigationActionsTaskOutput,
                crate::error::CancelDetectMitigationActionsTaskError,
                crate::input::CancelDetectMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// <p>Cancels a job.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl<C, M, R> CancelJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobInputOperationOutputAlias,
                crate::output::CancelJobOutput,
                crate::error::CancelJobError,
                crate::input::CancelJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>(Optional)A reason code string that explains why the job was canceled.</p>
        pub fn reason_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason_code(input.into());
            self
        }
        /// <p>(Optional)A reason code string that explains why the job was canceled.</p>
        pub fn set_reason_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason_code(input);
            self
        }
        /// <p>An optional comment string describing why the job was canceled.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment string describing why the job was canceled.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
        /// <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
        /// <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelJobExecution`.
    ///
    /// <p>Cancels the execution of a job for a given thing.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJobExecution</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJobExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_execution_input::Builder,
    }
    impl<C, M, R> CancelJobExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJobExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobExecutionInputOperationOutputAlias,
                crate::output::CancelJobExecutionOutput,
                crate::error::CancelJobExecutionError,
                crate::input::CancelJobExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job to be canceled.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job to be canceled.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The name of the thing whose execution of the job will be canceled.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing whose execution of the job will be canceled.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p>
        /// <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p>
        /// <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
        /// Adds a key-value pair to `statusDetails`.
        ///
        /// To override the contents of this collection use [`set_status_details`](Self::set_status_details).
        ///
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
        pub fn status_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.status_details(k.into(), v.into());
            self
        }
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_status_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ClearDefaultAuthorizer`.
    ///
    /// <p>Clears the default authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ClearDefaultAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ClearDefaultAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::clear_default_authorizer_input::Builder,
    }
    impl<C, M, R> ClearDefaultAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ClearDefaultAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ClearDefaultAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::ClearDefaultAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ClearDefaultAuthorizerInputOperationOutputAlias,
                crate::output::ClearDefaultAuthorizerOutput,
                crate::error::ClearDefaultAuthorizerError,
                crate::input::ClearDefaultAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ConfirmTopicRuleDestination`.
    ///
    /// <p>Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation message to the endpoint or base address you specify. The message includes a token which you pass back when calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ConfirmTopicRuleDestination</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmTopicRuleDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_topic_rule_destination_input::Builder,
    }
    impl<C, M, R> ConfirmTopicRuleDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmTopicRuleDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmTopicRuleDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmTopicRuleDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmTopicRuleDestinationInputOperationOutputAlias,
                crate::output::ConfirmTopicRuleDestinationOutput,
                crate::error::ConfirmTopicRuleDestinationError,
                crate::input::ConfirmTopicRuleDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
        pub fn confirmation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.confirmation_token(input.into());
            self
        }
        /// <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
        pub fn set_confirmation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_confirmation_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuditSuppression`.
    ///
    /// <p> Creates a Device Defender audit suppression. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuditSuppression</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuditSuppression<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_audit_suppression_input::Builder,
    }
    impl<C, M, R> CreateAuditSuppression<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuditSuppression`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuditSuppressionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuditSuppressionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuditSuppressionInputOperationOutputAlias,
                crate::output::CreateAuditSuppressionOutput,
                crate::error::CreateAuditSuppressionError,
                crate::input::CreateAuditSuppressionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expiration_date(input);
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expiration_date(input);
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn suppress_indefinitely(mut self, input: bool) -> Self {
            self.inner = self.inner.suppress_indefinitely(input);
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn set_suppress_indefinitely(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_suppress_indefinitely(input);
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> Each audit supression must have a unique client request token. If you try to create a new audit suppression with the same token as one that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p> Each audit supression must have a unique client request token. If you try to create a new audit suppression with the same token as one that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthorizer`.
    ///
    /// <p>Creates an authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_authorizer_input::Builder,
    }
    impl<C, M, R> CreateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuthorizerInputOperationOutputAlias,
                crate::output::CreateAuthorizerOutput,
                crate::error::CreateAuthorizerError,
                crate::input::CreateAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The authorizer name.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_name(input.into());
            self
        }
        /// <p>The authorizer name.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_name(input);
            self
        }
        /// <p>The ARN of the authorizer's Lambda function.</p>
        pub fn authorizer_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_function_arn(input.into());
            self
        }
        /// <p>The ARN of the authorizer's Lambda function.</p>
        pub fn set_authorizer_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_function_arn(input);
            self
        }
        /// <p>The name of the token key used to extract the token from the HTTP headers.</p>
        pub fn token_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_key_name(input.into());
            self
        }
        /// <p>The name of the token key used to extract the token from the HTTP headers.</p>
        pub fn set_token_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_token_key_name(input);
            self
        }
        /// Adds a key-value pair to `tokenSigningPublicKeys`.
        ///
        /// To override the contents of this collection use [`set_token_signing_public_keys`](Self::set_token_signing_public_keys).
        ///
        /// <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
        pub fn token_signing_public_keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.token_signing_public_keys(k.into(), v.into());
            self
        }
        /// <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
        pub fn set_token_signing_public_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_token_signing_public_keys(input);
            self
        }
        /// <p>The status of the create authorizer request.</p>
        pub fn status(mut self, input: crate::model::AuthorizerStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the create authorizer request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuthorizerStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the custom authorizer.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the custom authorizer.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether IoT validates the token signature in an authorization request.</p>
        pub fn signing_disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.signing_disabled(input);
            self
        }
        /// <p>Specifies whether IoT validates the token signature in an authorization request.</p>
        pub fn set_signing_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_signing_disabled(input);
            self
        }
        /// <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT connections.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn enable_caching_for_http(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_caching_for_http(input);
            self
        }
        /// <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT connections.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_enable_caching_for_http(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_caching_for_http(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBillingGroup`.
    ///
    /// <p>Creates a billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_billing_group_input::Builder,
    }
    impl<C, M, R> CreateBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBillingGroupInputOperationOutputAlias,
                crate::output::CreateBillingGroupOutput,
                crate::error::CreateBillingGroupError,
                crate::input::CreateBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name you wish to give to the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name you wish to give to the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn billing_group_properties(
            mut self,
            input: crate::model::BillingGroupProperties,
        ) -> Self {
            self.inner = self.inner.billing_group_properties(input);
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn set_billing_group_properties(
            mut self,
            input: std::option::Option<crate::model::BillingGroupProperties>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_properties(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the billing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the billing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCertificateFromCsr`.
    ///
    /// <p>Creates an X.509 certificate using the specified certificate signing request.</p>
    /// <p> <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key from NIST P-256, NIST P-384, or NIST P-512 curves. For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms"> Certificate signing algorithms supported by IoT</a>.</p>
    /// <p> <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCertificateFromCsr</a> action.</p>
    /// <p>You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that directory, and then specifying that directory on the command line. The following commands show how to create a batch of certificates given a batch of CSRs.</p>
    /// <p>Assuming a set of CSRs are located inside of the directory my-csr-directory:</p>
    /// <p>On Linux and OS X, the command is:</p>
    /// <p>$ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p>
    /// <p>This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot create-certificate-from-csr Amazon Web Services CLI command to create a certificate for the corresponding CSR.</p>
    /// <p>The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the certificate creation process:</p>
    /// <p>$ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p>
    /// <p>On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:</p>
    /// <p>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/$_}</p>
    /// <p>On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:</p>
    /// <p>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCertificateFromCsr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_certificate_from_csr_input::Builder,
    }
    impl<C, M, R> CreateCertificateFromCsr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCertificateFromCsr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCertificateFromCsrOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCertificateFromCsrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCertificateFromCsrInputOperationOutputAlias,
                crate::output::CreateCertificateFromCsrOutput,
                crate::error::CreateCertificateFromCsrError,
                crate::input::CreateCertificateFromCsrInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The certificate signing request (CSR).</p>
        pub fn certificate_signing_request(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.certificate_signing_request(input.into());
            self
        }
        /// <p>The certificate signing request (CSR).</p>
        pub fn set_certificate_signing_request(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_signing_request(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomMetric`.
    ///
    /// <p> Use this API to define a Custom Metric published by your devices to Device Defender. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCustomMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_metric_input::Builder,
    }
    impl<C, M, R> CreateCustomMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomMetricInputOperationOutputAlias,
                crate::output::CreateCustomMetricOutput,
                crate::error::CreateCustomMetricError,
                crate::input::CreateCustomMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p> Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated once defined.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p> Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated once defined.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn metric_type(mut self, input: crate::model::CustomMetricType) -> Self {
            self.inner = self.inner.metric_type(input);
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn set_metric_type(
            mut self,
            input: std::option::Option<crate::model::CustomMetricType>,
        ) -> Self {
            self.inner = self.inner.set_metric_type(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> Metadata that can be used to manage the custom metric. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> Metadata that can be used to manage the custom metric. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDimension`.
    ///
    /// <p>Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDimension</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDimension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dimension_input::Builder,
    }
    impl<C, M, R> CreateDimension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDimension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDimensionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDimensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDimensionInputOperationOutputAlias,
                crate::output::CreateDimensionOutput,
                crate::error::CreateDimensionError,
                crate::input::CreateDimensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
        pub fn r#type(mut self, input: crate::model::DimensionType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::DimensionType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `stringValues`.
        ///
        /// To override the contents of this collection use [`set_string_values`](Self::set_string_values).
        ///
        /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
        pub fn string_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.string_values(input.into());
            self
        }
        /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
        pub fn set_string_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_string_values(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the dimension.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the dimension.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainConfiguration`.
    ///
    /// <p>Creates a domain configuration.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDomainConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomainConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_configuration_input::Builder,
    }
    impl<C, M, R> CreateDomainConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomainConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainConfigurationInputOperationOutputAlias,
                crate::output::CreateDomainConfigurationOutput,
                crate::error::CreateDomainConfigurationError,
                crate::input::CreateDomainConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_configuration_name(input.into());
            self
        }
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_configuration_name(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `serverCertificateArns`.
        ///
        /// To override the contents of this collection use [`set_server_certificate_arns`](Self::set_server_certificate_arns).
        ///
        /// <p>The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn server_certificate_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_arns(input.into());
            self
        }
        /// <p>The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn set_server_certificate_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_arns(input);
            self
        }
        /// <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn validation_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.validation_certificate_arn(input.into());
            self
        }
        /// <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn set_validation_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_validation_certificate_arn(input);
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn authorizer_config(mut self, input: crate::model::AuthorizerConfig) -> Self {
            self.inner = self.inner.authorizer_config(input);
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn set_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::AuthorizerConfig>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_config(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p> <note>
        /// <p>Amazon Web Services IoT Core currently supports only the <code>DATA</code> service type.</p>
        /// </note>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.inner = self.inner.service_type(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p> <note>
        /// <p>Amazon Web Services IoT Core currently supports only the <code>DATA</code> service type.</p>
        /// </note>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the domain configuration.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the domain configuration.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDynamicThingGroup`.
    ///
    /// <p>Creates a dynamic thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDynamicThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDynamicThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dynamic_thing_group_input::Builder,
    }
    impl<C, M, R> CreateDynamicThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDynamicThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDynamicThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDynamicThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDynamicThingGroupInputOperationOutputAlias,
                crate::output::CreateDynamicThingGroupOutput,
                crate::error::CreateDynamicThingGroupError,
                crate::input::CreateDynamicThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The dynamic thing group name to create.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The dynamic thing group name to create.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The dynamic thing group properties.</p>
        pub fn thing_group_properties(mut self, input: crate::model::ThingGroupProperties) -> Self {
            self.inner = self.inner.thing_group_properties(input);
            self
        }
        /// <p>The dynamic thing group properties.</p>
        pub fn set_thing_group_properties(
            mut self,
            input: std::option::Option<crate::model::ThingGroupProperties>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_properties(input);
            self
        }
        /// <p>The dynamic thing group index name.</p> <note>
        /// <p>Currently one index is supported: <code>AWS_Things</code>.</p>
        /// </note>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The dynamic thing group index name.</p> <note>
        /// <p>Currently one index is supported: <code>AWS_Things</code>.</p>
        /// </note>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        /// <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        /// <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The dynamic thing group query version.</p> <note>
        /// <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>
        /// </note>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The dynamic thing group query version.</p> <note>
        /// <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>
        /// </note>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the dynamic thing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the dynamic thing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleetMetric`.
    ///
    /// <p>Creates a fleet metric.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateFleetMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFleetMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fleet_metric_input::Builder,
    }
    impl<C, M, R> CreateFleetMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFleetMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFleetMetricInputOperationOutputAlias,
                crate::output::CreateFleetMetricOutput,
                crate::error::CreateFleetMetricError,
                crate::input::CreateFleetMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet metric to create.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>The name of the fleet metric to create.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.inner = self.inner.aggregation_type(input);
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_type(input);
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.inner = self.inner.period(input);
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>. Default to null.</p>
        pub fn unit(mut self, input: crate::model::FleetMetricUnit) -> Self {
            self.inner = self.inner.unit(input);
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>. Default to null.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::FleetMetricUnit>,
        ) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata, which can be used to manage the fleet metric.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata, which can be used to manage the fleet metric.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>Creates a job.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of things and thing groups to which the job should be sent.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.targets(input.into());
            self
        }
        /// <p>A list of things and thing groups to which the job should be sent.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_source(input.into());
            self
        }
        /// <p>An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_source(input);
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Configuration information for pre-signed S3 URLs.</p>
        pub fn presigned_url_config(mut self, input: crate::model::PresignedUrlConfig) -> Self {
            self.inner = self.inner.presigned_url_config(input);
            self
        }
        /// <p>Configuration information for pre-signed S3 URLs.</p>
        pub fn set_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::PresignedUrlConfig>,
        ) -> Self {
            self.inner = self.inner.set_presigned_url_config(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.inner = self.inner.target_selection(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.inner = self.inner.set_target_selection(input);
            self
        }
        /// <p>Allows you to create a staged rollout of the job.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::JobExecutionsRolloutConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_rollout_config(input);
            self
        }
        /// <p>Allows you to create a staged rollout of the job.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_rollout_config(input);
            self
        }
        /// <p>Allows you to create the criteria to abort a job.</p>
        pub fn abort_config(mut self, input: crate::model::AbortConfig) -> Self {
            self.inner = self.inner.abort_config(input);
            self
        }
        /// <p>Allows you to create the criteria to abort a job.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::AbortConfig>,
        ) -> Self {
            self.inner = self.inner.set_abort_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn timeout_config(mut self, input: crate::model::TimeoutConfig) -> Self {
            self.inner = self.inner.timeout_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::TimeoutConfig>,
        ) -> Self {
            self.inner = self.inner.set_timeout_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the job.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
        /// <p>The ARN of the job template used to create the job.</p>
        pub fn job_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_arn(input.into());
            self
        }
        /// <p>The ARN of the job template used to create the job.</p>
        pub fn set_job_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_arn(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn job_executions_retry_config(
            mut self,
            input: crate::model::JobExecutionsRetryConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_retry_config(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn set_job_executions_retry_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRetryConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_retry_config(input);
            self
        }
        /// Adds a key-value pair to `documentParameters`.
        ///
        /// To override the contents of this collection use [`set_document_parameters`](Self::set_document_parameters).
        ///
        /// <p>Parameters of a managed template that you can specify to create the job document.</p>
        pub fn document_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.document_parameters(k.into(), v.into());
            self
        }
        /// <p>Parameters of a managed template that you can specify to create the job document.</p>
        pub fn set_document_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_document_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJobTemplate`.
    ///
    /// <p>Creates a job template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJobTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_template_input::Builder,
    }
    impl<C, M, R> CreateJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobTemplateInputOperationOutputAlias,
                crate::output::CreateJobTemplateOutput,
                crate::error::CreateJobTemplateError,
                crate::input::CreateJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_id(input.into());
            self
        }
        /// <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_id(input);
            self
        }
        /// <p>The ARN of the job to use as the basis for the job template.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_arn(input.into());
            self
        }
        /// <p>The ARN of the job to use as the basis for the job template.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_arn(input);
            self
        }
        /// <p>An S3 link to the job document to use in the template. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_source(input.into());
            self
        }
        /// <p>An S3 link to the job document to use in the template. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_source(input);
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>A description of the job document.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the job document.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn presigned_url_config(mut self, input: crate::model::PresignedUrlConfig) -> Self {
            self.inner = self.inner.presigned_url_config(input);
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn set_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::PresignedUrlConfig>,
        ) -> Self {
            self.inner = self.inner.set_presigned_url_config(input);
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::JobExecutionsRolloutConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_rollout_config(input);
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_rollout_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn abort_config(mut self, input: crate::model::AbortConfig) -> Self {
            self.inner = self.inner.abort_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::AbortConfig>,
        ) -> Self {
            self.inner = self.inner.set_abort_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn timeout_config(mut self, input: crate::model::TimeoutConfig) -> Self {
            self.inner = self.inner.timeout_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::TimeoutConfig>,
        ) -> Self {
            self.inner = self.inner.set_timeout_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the job template.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the job template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn job_executions_retry_config(
            mut self,
            input: crate::model::JobExecutionsRetryConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_retry_config(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn set_job_executions_retry_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRetryConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_retry_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeysAndCertificate`.
    ///
    /// <p>Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api">Provisioning MQTT API</a>.</p>
    /// <p> <b>Note</b> This is the only time IoT issues the private key for this certificate, so it is important to keep it in a secure location.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateKeysAndCertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKeysAndCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_keys_and_certificate_input::Builder,
    }
    impl<C, M, R> CreateKeysAndCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateKeysAndCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeysAndCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeysAndCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateKeysAndCertificateInputOperationOutputAlias,
                crate::output::CreateKeysAndCertificateOutput,
                crate::error::CreateKeysAndCertificateError,
                crate::input::CreateKeysAndCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMitigationAction`.
    ///
    /// <p>Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation actions</a>. Each mitigation action can apply only one type of change.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateMitigationAction</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMitigationAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_mitigation_action_input::Builder,
    }
    impl<C, M, R> CreateMitigationAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMitigationAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMitigationActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMitigationActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMitigationActionInputOperationOutputAlias,
                crate::output::CreateMitigationActionOutput,
                crate::error::CreateMitigationActionError,
                crate::input::CreateMitigationActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
        /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Defines the type of action and the parameters for that action.</p>
        pub fn action_params(mut self, input: crate::model::MitigationActionParams) -> Self {
            self.inner = self.inner.action_params(input);
            self
        }
        /// <p>Defines the type of action and the parameters for that action.</p>
        pub fn set_action_params(
            mut self,
            input: std::option::Option<crate::model::MitigationActionParams>,
        ) -> Self {
            self.inner = self.inner.set_action_params(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the mitigation action.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the mitigation action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOTAUpdate`.
    ///
    /// <p>Creates an IoT OTA update on a target group of things or groups.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateOTAUpdate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOTAUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ota_update_input::Builder,
    }
    impl<C, M, R> CreateOTAUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOTAUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOtaUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOTAUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOtaUpdateInputOperationOutputAlias,
                crate::output::CreateOtaUpdateOutput,
                crate::error::CreateOTAUpdateError,
                crate::input::CreateOtaUpdateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OTA update to be created.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ota_update_id(input.into());
            self
        }
        /// <p>The ID of the OTA update to be created.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ota_update_id(input);
            self
        }
        /// <p>The description of the OTA update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the OTA update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The devices targeted to receive OTA updates.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.targets(input.into());
            self
        }
        /// <p>The devices targeted to receive OTA updates.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn protocols(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocols(input);
            self
        }
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.inner = self.inner.set_protocols(input);
            self
        }
        /// <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.inner = self.inner.target_selection(input);
            self
        }
        /// <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.inner = self.inner.set_target_selection(input);
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn aws_job_executions_rollout_config(
            mut self,
            input: crate::model::AwsJobExecutionsRolloutConfig,
        ) -> Self {
            self.inner = self.inner.aws_job_executions_rollout_config(input);
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn set_aws_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobExecutionsRolloutConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_executions_rollout_config(input);
            self
        }
        /// <p>Configuration information for pre-signed URLs.</p>
        pub fn aws_job_presigned_url_config(
            mut self,
            input: crate::model::AwsJobPresignedUrlConfig,
        ) -> Self {
            self.inner = self.inner.aws_job_presigned_url_config(input);
            self
        }
        /// <p>Configuration information for pre-signed URLs.</p>
        pub fn set_aws_job_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobPresignedUrlConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_presigned_url_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn aws_job_abort_config(mut self, input: crate::model::AwsJobAbortConfig) -> Self {
            self.inner = self.inner.aws_job_abort_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn set_aws_job_abort_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobAbortConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_abort_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn aws_job_timeout_config(mut self, input: crate::model::AwsJobTimeoutConfig) -> Self {
            self.inner = self.inner.aws_job_timeout_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_aws_job_timeout_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobTimeoutConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_timeout_config(input);
            self
        }
        /// Appends an item to `files`.
        ///
        /// To override the contents of this collection use [`set_files`](Self::set_files).
        ///
        /// <p>The files to be streamed by the OTA update.</p>
        pub fn files(mut self, input: crate::model::OtaUpdateFile) -> Self {
            self.inner = self.inner.files(input);
            self
        }
        /// <p>The files to be streamed by the OTA update.</p>
        pub fn set_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OtaUpdateFile>>,
        ) -> Self {
            self.inner = self.inner.set_files(input);
            self
        }
        /// <p>The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `additionalParameters`.
        ///
        /// To override the contents of this collection use [`set_additional_parameters`](Self::set_additional_parameters).
        ///
        /// <p>A list of additional OTA update parameters which are name-value pairs.</p>
        pub fn additional_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_parameters(k.into(), v.into());
            self
        }
        /// <p>A list of additional OTA update parameters which are name-value pairs.</p>
        pub fn set_additional_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_parameters(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage updates.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicy`.
    ///
    /// <p>Creates an IoT policy.</p>
    /// <p>The created policy is the default version for the policy. This operation creates a policy version with a version identifier of <b>1</b> and sets <b>1</b> as the policy's default version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_policy_input::Builder,
    }
    impl<C, M, R> CreatePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePolicyInputOperationOutputAlias,
                crate::output::CreatePolicyOutput,
                crate::error::CreatePolicyError,
                crate::input::CreatePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the policy.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the policy.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicyVersion`.
    ///
    /// <p>Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must use <code>DeletePolicyVersion</code> to delete an existing version before you create a new one.</p>
    /// <p>Optionally, you can set the new version as the policy's default version. The default version is the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicyVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_policy_version_input::Builder,
    }
    impl<C, M, R> CreatePolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePolicyVersionInputOperationOutputAlias,
                crate::output::CreatePolicyVersionOutput,
                crate::error::CreatePolicyVersionError,
                crate::input::CreatePolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
        pub fn set_as_default(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_default(input);
            self
        }
        /// <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_default(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningClaim`.
    ///
    /// <p>Creates a provisioning claim.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningClaim</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisioningClaim<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioning_claim_input::Builder,
    }
    impl<C, M, R> CreateProvisioningClaim<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisioningClaim`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningClaimOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningClaimError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisioningClaimInputOperationOutputAlias,
                crate::output::CreateProvisioningClaimOutput,
                crate::error::CreateProvisioningClaimError,
                crate::input::CreateProvisioningClaimInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the provisioning template to use.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the provisioning template to use.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningTemplate`.
    ///
    /// <p>Creates a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisioningTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioning_template_input::Builder,
    }
    impl<C, M, R> CreateProvisioningTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisioningTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisioningTemplateInputOperationOutputAlias,
                crate::output::CreateProvisioningTemplateOutput,
                crate::error::CreateProvisioningTemplateError,
                crate::input::CreateProvisioningTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>True to enable the fleet provisioning template, otherwise false.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>True to enable the fleet provisioning template, otherwise false.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn provisioning_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_role_arn(input.into());
            self
        }
        /// <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn set_provisioning_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_role_arn(input);
            self
        }
        /// <p>Creates a pre-provisioning hook template.</p>
        pub fn pre_provisioning_hook(mut self, input: crate::model::ProvisioningHook) -> Self {
            self.inner = self.inner.pre_provisioning_hook(input);
            self
        }
        /// <p>Creates a pre-provisioning hook template.</p>
        pub fn set_pre_provisioning_hook(
            mut self,
            input: std::option::Option<crate::model::ProvisioningHook>,
        ) -> Self {
            self.inner = self.inner.set_pre_provisioning_hook(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the fleet provisioning template.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the fleet provisioning template.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningTemplateVersion`.
    ///
    /// <p>Creates a new version of a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplateVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisioningTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioning_template_version_input::Builder,
    }
    impl<C, M, R> CreateProvisioningTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisioningTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisioningTemplateVersionInputOperationOutputAlias,
                crate::output::CreateProvisioningTemplateVersionOutput,
                crate::error::CreateProvisioningTemplateVersionError,
                crate::input::CreateProvisioningTemplateVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>Sets a fleet provision template version as the default version.</p>
        pub fn set_as_default(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_default(input);
            self
        }
        /// <p>Sets a fleet provision template version as the default version.</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_default(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoleAlias`.
    ///
    /// <p>Creates a role alias.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateRoleAlias</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoleAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_role_alias_input::Builder,
    }
    impl<C, M, R> CreateRoleAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoleAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoleAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoleAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoleAliasInputOperationOutputAlias,
                crate::output::CreateRoleAliasOutput,
                crate::error::CreateRoleAliasError,
                crate::input::CreateRoleAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_alias(input.into());
            self
        }
        /// <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_alias(input);
            self
        }
        /// <p>The role ARN.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The role ARN.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>How long (in seconds) the credentials will be valid. The default value is 3,600 seconds.</p>
        pub fn credential_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.credential_duration_seconds(input);
            self
        }
        /// <p>How long (in seconds) the credentials will be valid. The default value is 3,600 seconds.</p>
        pub fn set_credential_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_credential_duration_seconds(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the role alias.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the role alias.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateScheduledAudit`.
    ///
    /// <p>Creates a scheduled audit that is run at a specified time interval.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateScheduledAudit</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateScheduledAudit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_scheduled_audit_input::Builder,
    }
    impl<C, M, R> CreateScheduledAudit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateScheduledAudit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScheduledAuditOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScheduledAuditError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateScheduledAuditInputOperationOutputAlias,
                crate::output::CreateScheduledAuditOutput,
                crate::error::CreateScheduledAuditError,
                crate::input::CreateScheduledAuditInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn frequency(mut self, input: crate::model::AuditFrequency) -> Self {
            self.inner = self.inner.frequency(input);
            self
        }
        /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AuditFrequency>,
        ) -> Self {
            self.inner = self.inner.set_frequency(input);
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn day_of_month(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.day_of_month(input.into());
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_day_of_month(input);
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
        pub fn day_of_week(mut self, input: crate::model::DayOfWeek) -> Self {
            self.inner = self.inner.day_of_week(input);
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
        pub fn set_day_of_week(
            mut self,
            input: std::option::Option<crate::model::DayOfWeek>,
        ) -> Self {
            self.inner = self.inner.set_day_of_week(input);
            self
        }
        /// Appends an item to `targetCheckNames`.
        ///
        /// To override the contents of this collection use [`set_target_check_names`](Self::set_target_check_names).
        ///
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn target_check_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_check_names(input.into());
            self
        }
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_target_check_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_check_names(input);
            self
        }
        /// <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_audit_name(input.into());
            self
        }
        /// <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_audit_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the scheduled audit.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the scheduled audit.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecurityProfile`.
    ///
    /// <p>Creates a Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_security_profile_input::Builder,
    }
    impl<C, M, R> CreateSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSecurityProfileInputOperationOutputAlias,
                crate::output::CreateSecurityProfileOutput,
                crate::error::CreateSecurityProfileError,
                crate::input::CreateSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name you are giving to the security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name you are giving to the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>A description of the security profile.</p>
        pub fn security_profile_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.security_profile_description(input.into());
            self
        }
        /// <p>A description of the security profile.</p>
        pub fn set_security_profile_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_description(input);
            self
        }
        /// Appends an item to `behaviors`.
        ///
        /// To override the contents of this collection use [`set_behaviors`](Self::set_behaviors).
        ///
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn behaviors(mut self, input: crate::model::Behavior) -> Self {
            self.inner = self.inner.behaviors(input);
            self
        }
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn set_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        ) -> Self {
            self.inner = self.inner.set_behaviors(input);
            self
        }
        /// Adds a key-value pair to `alertTargets`.
        ///
        /// To override the contents of this collection use [`set_alert_targets`](Self::set_alert_targets).
        ///
        /// <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
        pub fn alert_targets(
            mut self,
            k: crate::model::AlertTargetType,
            v: crate::model::AlertTarget,
        ) -> Self {
            self.inner = self.inner.alert_targets(k, v);
            self
        }
        /// <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
        pub fn set_alert_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
            >,
        ) -> Self {
            self.inner = self.inner.set_alert_targets(input);
            self
        }
        /// Appends an item to `additionalMetricsToRetain`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain`](Self::set_additional_metrics_to_retain).
        ///
        /// <p> <i>Please use <code>CreateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn additional_metrics_to_retain(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_metrics_to_retain(input.into());
            self
        }
        /// <p> <i>Please use <code>CreateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn set_additional_metrics_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_additional_metrics_to_retain(input);
            self
        }
        /// Appends an item to `additionalMetricsToRetainV2`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain_v2`](Self::set_additional_metrics_to_retain_v2).
        ///
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn additional_metrics_to_retain_v2(
            mut self,
            input: crate::model::MetricToRetain,
        ) -> Self {
            self.inner = self.inner.additional_metrics_to_retain_v2(input);
            self
        }
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn set_additional_metrics_to_retain_v2(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        ) -> Self {
            self.inner = self.inner.set_additional_metrics_to_retain_v2(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the security profile.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the security profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStream`.
    ///
    /// <p>Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with a stream.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateStream</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stream_input::Builder,
    }
    impl<C, M, R> CreateStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamInputOperationOutputAlias,
                crate::output::CreateStreamOutput,
                crate::error::CreateStreamError,
                crate::input::CreateStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// <p>A description of the stream.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the stream.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `files`.
        ///
        /// To override the contents of this collection use [`set_files`](Self::set_files).
        ///
        /// <p>The files to stream.</p>
        pub fn files(mut self, input: crate::model::StreamFile) -> Self {
            self.inner = self.inner.files(input);
            self
        }
        /// <p>The files to stream.</p>
        pub fn set_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamFile>>,
        ) -> Self {
            self.inner = self.inner.set_files(input);
            self
        }
        /// <p>An IAM role that allows the IoT service principal to access your S3 files.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>An IAM role that allows the IoT service principal to access your S3 files.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage streams.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage streams.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThing`.
    ///
    /// <p>Creates a thing record in the registry. If this call is made multiple times using the same thing name and configuration, the call will succeed. If this call is made with the same thing name but different configuration a <code>ResourceAlreadyExistsException</code> is thrown.</p> <note>
    /// <p>This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for information about authorizing control plane actions.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_thing_input::Builder,
    }
    impl<C, M, R> CreateThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThingInputOperationOutputAlias,
                crate::output::CreateThingOutput,
                crate::error::CreateThingError,
                crate::input::CreateThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to create.</p>
        /// <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to create.</p>
        /// <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The name of the thing type associated with the new thing.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type associated with the new thing.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
        /// <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p>
        /// <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
        pub fn attribute_payload(mut self, input: crate::model::AttributePayload) -> Self {
            self.inner = self.inner.attribute_payload(input);
            self
        }
        /// <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p>
        /// <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
        pub fn set_attribute_payload(
            mut self,
            input: std::option::Option<crate::model::AttributePayload>,
        ) -> Self {
            self.inner = self.inner.set_attribute_payload(input);
            self
        }
        /// <p>The name of the billing group the thing will be added to.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group the thing will be added to.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThingGroup`.
    ///
    /// <p>Create a thing group.</p> <note>
    /// <p>This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for information about authorizing control plane actions.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_thing_group_input::Builder,
    }
    impl<C, M, R> CreateThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThingGroupInputOperationOutputAlias,
                crate::output::CreateThingGroupOutput,
                crate::error::CreateThingGroupError,
                crate::input::CreateThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The thing group name to create.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The thing group name to create.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The name of the parent thing group.</p>
        pub fn parent_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_group_name(input.into());
            self
        }
        /// <p>The name of the parent thing group.</p>
        pub fn set_parent_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_group_name(input);
            self
        }
        /// <p>The thing group properties.</p>
        pub fn thing_group_properties(mut self, input: crate::model::ThingGroupProperties) -> Self {
            self.inner = self.inner.thing_group_properties(input);
            self
        }
        /// <p>The thing group properties.</p>
        pub fn set_thing_group_properties(
            mut self,
            input: std::option::Option<crate::model::ThingGroupProperties>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_properties(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the thing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the thing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThingType`.
    ///
    /// <p>Creates a new thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_thing_type_input::Builder,
    }
    impl<C, M, R> CreateThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThingTypeInputOperationOutputAlias,
                crate::output::CreateThingTypeOutput,
                crate::error::CreateThingTypeError,
                crate::input::CreateThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
        /// <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
        pub fn thing_type_properties(mut self, input: crate::model::ThingTypeProperties) -> Self {
            self.inner = self.inner.thing_type_properties(input);
            self
        }
        /// <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
        pub fn set_thing_type_properties(
            mut self,
            input: std::option::Option<crate::model::ThingTypeProperties>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_properties(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the thing type.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the thing type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTopicRule`.
    ///
    /// <p>Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_topic_rule_input::Builder,
    }
    impl<C, M, R> CreateTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTopicRuleInputOperationOutputAlias,
                crate::output::CreateTopicRuleOutput,
                crate::error::CreateTopicRuleError,
                crate::input::CreateTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>The rule payload.</p>
        pub fn topic_rule_payload(mut self, input: crate::model::TopicRulePayload) -> Self {
            self.inner = self.inner.topic_rule_payload(input);
            self
        }
        /// <p>The rule payload.</p>
        pub fn set_topic_rule_payload(
            mut self,
            input: std::option::Option<crate::model::TopicRulePayload>,
        ) -> Self {
            self.inner = self.inner.set_topic_rule_payload(input);
            self
        }
        /// <p>Metadata which can be used to manage the topic rule.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags(input.into());
            self
        }
        /// <p>Metadata which can be used to manage the topic rule.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTopicRuleDestination`.
    ///
    /// <p>Creates a topic rule destination. The destination must be confirmed prior to use.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRuleDestination</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTopicRuleDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_topic_rule_destination_input::Builder,
    }
    impl<C, M, R> CreateTopicRuleDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTopicRuleDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTopicRuleDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTopicRuleDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTopicRuleDestinationInputOperationOutputAlias,
                crate::output::CreateTopicRuleDestinationOutput,
                crate::error::CreateTopicRuleDestinationError,
                crate::input::CreateTopicRuleDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The topic rule destination configuration.</p>
        pub fn destination_configuration(
            mut self,
            input: crate::model::TopicRuleDestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.destination_configuration(input);
            self
        }
        /// <p>The topic rule destination configuration.</p>
        pub fn set_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::TopicRuleDestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_destination_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountAuditConfiguration`.
    ///
    /// <p>Restores the default settings for Device Defender audits for this account. Any configuration data you entered is deleted and all audit checks are reset to disabled. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAccountAuditConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccountAuditConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_audit_configuration_input::Builder,
    }
    impl<C, M, R> DeleteAccountAuditConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccountAuditConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountAuditConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountAuditConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountAuditConfigurationInputOperationOutputAlias,
                crate::output::DeleteAccountAuditConfigurationOutput,
                crate::error::DeleteAccountAuditConfigurationError,
                crate::input::DeleteAccountAuditConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If true, all scheduled audits are deleted.</p>
        pub fn delete_scheduled_audits(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_scheduled_audits(input);
            self
        }
        /// <p>If true, all scheduled audits are deleted.</p>
        pub fn set_delete_scheduled_audits(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_scheduled_audits(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuditSuppression`.
    ///
    /// <p> Deletes a Device Defender audit suppression. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuditSuppression</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuditSuppression<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_audit_suppression_input::Builder,
    }
    impl<C, M, R> DeleteAuditSuppression<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuditSuppression`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuditSuppressionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuditSuppressionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuditSuppressionInputOperationOutputAlias,
                crate::output::DeleteAuditSuppressionOutput,
                crate::error::DeleteAuditSuppressionError,
                crate::input::DeleteAuditSuppressionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthorizer`.
    ///
    /// <p>Deletes an authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_authorizer_input::Builder,
    }
    impl<C, M, R> DeleteAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuthorizerInputOperationOutputAlias,
                crate::output::DeleteAuthorizerOutput,
                crate::error::DeleteAuthorizerError,
                crate::input::DeleteAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authorizer to delete.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_name(input.into());
            self
        }
        /// <p>The name of the authorizer to delete.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBillingGroup`.
    ///
    /// <p>Deletes the billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_billing_group_input::Builder,
    }
    impl<C, M, R> DeleteBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBillingGroupInputOperationOutputAlias,
                crate::output::DeleteBillingGroupOutput,
                crate::error::DeleteBillingGroupError,
                crate::input::DeleteBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
        /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCACertificate`.
    ///
    /// <p>Deletes a registered CA certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCACertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCACertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ca_certificate_input::Builder,
    }
    impl<C, M, R> DeleteCACertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCACertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCaCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCACertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCaCertificateInputOperationOutputAlias,
                crate::output::DeleteCaCertificateOutput,
                crate::error::DeleteCACertificateError,
                crate::input::DeleteCaCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCertificate`.
    ///
    /// <p>Deletes the specified certificate.</p>
    /// <p>A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE. To delete a certificate, first use the <code>DetachPolicy</code> action to detach all policies. Next, use the <code>UpdateCertificate</code> action to set the certificate to the INACTIVE status.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_certificate_input::Builder,
    }
    impl<C, M, R> DeleteCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCertificateInputOperationOutputAlias,
                crate::output::DeleteCertificateOutput,
                crate::error::DeleteCertificateError,
                crate::input::DeleteCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
        /// <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomMetric`.
    ///
    /// <p> Deletes a Device Defender detect custom metric. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCustomMetric</a> action.</p> <note>
    /// <p>Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a part of. The security profile associated with the custom metric can be found using the <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles</a> API with <code>metricName</code> set to your custom metric name.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_metric_input::Builder,
    }
    impl<C, M, R> DeleteCustomMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomMetricInputOperationOutputAlias,
                crate::output::DeleteCustomMetricOutput,
                crate::error::DeleteCustomMetricError,
                crate::input::DeleteCustomMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDimension`.
    ///
    /// <p>Removes the specified dimension from your Amazon Web Services accounts.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDimension</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDimension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dimension_input::Builder,
    }
    impl<C, M, R> DeleteDimension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDimension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDimensionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDimensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDimensionInputOperationOutputAlias,
                crate::output::DeleteDimensionOutput,
                crate::error::DeleteDimensionError,
                crate::input::DeleteDimensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the dimension that you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique identifier for the dimension that you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainConfiguration`.
    ///
    /// <p>Deletes the specified domain configuration.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDomainConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_configuration_input::Builder,
    }
    impl<C, M, R> DeleteDomainConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainConfigurationInputOperationOutputAlias,
                crate::output::DeleteDomainConfigurationOutput,
                crate::error::DeleteDomainConfigurationError,
                crate::input::DeleteDomainConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain configuration to be deleted.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_configuration_name(input.into());
            self
        }
        /// <p>The name of the domain configuration to be deleted.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_configuration_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDynamicThingGroup`.
    ///
    /// <p>Deletes a dynamic thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDynamicThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDynamicThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dynamic_thing_group_input::Builder,
    }
    impl<C, M, R> DeleteDynamicThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDynamicThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDynamicThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDynamicThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDynamicThingGroupInputOperationOutputAlias,
                crate::output::DeleteDynamicThingGroupOutput,
                crate::error::DeleteDynamicThingGroupError,
                crate::input::DeleteDynamicThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dynamic thing group to delete.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the dynamic thing group to delete.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The expected version of the dynamic thing group to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the dynamic thing group to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFleetMetric`.
    ///
    /// <p>Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you specify a fleet metric that doesn't exist.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteFleetMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFleetMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fleet_metric_input::Builder,
    }
    impl<C, M, R> DeleteFleetMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFleetMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFleetMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFleetMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFleetMetricInputOperationOutputAlias,
                crate::output::DeleteFleetMetricOutput,
                crate::error::DeleteFleetMetricError,
                crate::input::DeleteFleetMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet metric to delete.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>The name of the fleet metric to delete.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The expected version of the fleet metric to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the fleet metric to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes a job and its related job executions.</p>
    /// <p>Deleting a job may take time, depending on the number of job executions created for the job and various other factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.</p>
    /// <p>Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl<C, M, R> DeleteJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobInputOperationOutputAlias,
                crate::output::DeleteJobOutput,
                crate::error::DeleteJobError,
                crate::input::DeleteJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job to be deleted.</p>
        /// <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job to be deleted.</p>
        /// <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p>
        /// </note>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p>
        /// </note>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJobExecution`.
    ///
    /// <p>Deletes a job execution.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJobExecution</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJobExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_execution_input::Builder,
    }
    impl<C, M, R> DeleteJobExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJobExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobExecutionInputOperationOutputAlias,
                crate::output::DeleteJobExecutionOutput,
                crate::error::DeleteJobExecutionError,
                crate::input::DeleteJobExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job whose execution on a particular device will be deleted.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job whose execution on a particular device will be deleted.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The name of the thing whose job execution will be deleted.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing whose job execution will be deleted.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p>
        /// <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.inner = self.inner.execution_number(input);
            self
        }
        /// <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p>
        /// <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_execution_number(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        /// </note>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        /// </note>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJobTemplate`.
    ///
    /// <p>Deletes the specified job template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_template_input::Builder,
    }
    impl<C, M, R> DeleteJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobTemplateInputOperationOutputAlias,
                crate::output::DeleteJobTemplateOutput,
                crate::error::DeleteJobTemplateError,
                crate::input::DeleteJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the job template to delete.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_id(input.into());
            self
        }
        /// <p>The unique identifier of the job template to delete.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMitigationAction`.
    ///
    /// <p>Deletes a defined mitigation action from your Amazon Web Services accounts.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteMitigationAction</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMitigationAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mitigation_action_input::Builder,
    }
    impl<C, M, R> DeleteMitigationAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMitigationAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMitigationActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMitigationActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMitigationActionInputOperationOutputAlias,
                crate::output::DeleteMitigationActionOutput,
                crate::error::DeleteMitigationActionError,
                crate::input::DeleteMitigationActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the mitigation action that you want to delete.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>The name of the mitigation action that you want to delete.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOTAUpdate`.
    ///
    /// <p>Delete an OTA update.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteOTAUpdate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOTAUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ota_update_input::Builder,
    }
    impl<C, M, R> DeleteOTAUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOTAUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOtaUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOTAUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOtaUpdateInputOperationOutputAlias,
                crate::output::DeleteOtaUpdateOutput,
                crate::error::DeleteOTAUpdateError,
                crate::input::DeleteOtaUpdateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OTA update to delete.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ota_update_id(input.into());
            self
        }
        /// <p>The ID of the OTA update to delete.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ota_update_id(input);
            self
        }
        /// <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
        pub fn delete_stream(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_stream(input);
            self
        }
        /// <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
        pub fn set_delete_stream(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_stream(input);
            self
        }
        /// <p>When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
        pub fn force_delete_aws_job(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete_aws_job(input);
            self
        }
        /// <p>When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
        pub fn set_force_delete_aws_job(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete_aws_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// <p>Deletes the specified policy.</p>
    /// <p>A policy cannot be deleted if it has non-default versions or it is attached to any certificate.</p>
    /// <p>To delete a policy, use the <code>DeletePolicyVersion</code> action to delete all non-default versions of the policy; use the <code>DetachPolicy</code> action to detach the policy from any certificate; and then use the DeletePolicy action to delete the policy.</p>
    /// <p>When a policy is deleted using DeletePolicy, its default version is deleted with it.</p> <note>
    /// <p>Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl<C, M, R> DeletePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyInputOperationOutputAlias,
                crate::output::DeletePolicyOutput,
                crate::error::DeletePolicyError,
                crate::input::DeletePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy to delete.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to delete.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicyVersion`.
    ///
    /// <p>Deletes the specified version of the specified policy. You cannot delete the default version of a policy using this action. To delete the default version of a policy, use <code>DeletePolicy</code>. To find out which version of a policy is marked as the default version, use ListPolicyVersions.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicyVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_version_input::Builder,
    }
    impl<C, M, R> DeletePolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyVersionInputOperationOutputAlias,
                crate::output::DeletePolicyVersionOutput,
                crate::error::DeletePolicyVersionError,
                crate::input::DeletePolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_version_id(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisioningTemplate`.
    ///
    /// <p>Deletes a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProvisioningTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_provisioning_template_input::Builder,
    }
    impl<C, M, R> DeleteProvisioningTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProvisioningTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisioningTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisioningTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProvisioningTemplateInputOperationOutputAlias,
                crate::output::DeleteProvisioningTemplateOutput,
                crate::error::DeleteProvisioningTemplateError,
                crate::input::DeleteProvisioningTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provision template to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provision template to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisioningTemplateVersion`.
    ///
    /// <p>Deletes a fleet provisioning template version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplateVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProvisioningTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_provisioning_template_version_input::Builder,
    }
    impl<C, M, R> DeleteProvisioningTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProvisioningTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisioningTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisioningTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProvisioningTemplateVersionInputOperationOutputAlias,
                crate::output::DeleteProvisioningTemplateVersionOutput,
                crate::error::DeleteProvisioningTemplateVersionError,
                crate::input::DeleteProvisioningTemplateVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template version to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template version to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The fleet provisioning template version ID to delete.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.version_id(input);
            self
        }
        /// <p>The fleet provisioning template version ID to delete.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegistrationCode`.
    ///
    /// <p>Deletes a CA certificate registration code.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRegistrationCode</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRegistrationCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_registration_code_input::Builder,
    }
    impl<C, M, R> DeleteRegistrationCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRegistrationCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegistrationCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegistrationCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRegistrationCodeInputOperationOutputAlias,
                crate::output::DeleteRegistrationCodeOutput,
                crate::error::DeleteRegistrationCodeError,
                crate::input::DeleteRegistrationCodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteRoleAlias`.
    ///
    /// <p>Deletes a role alias</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRoleAlias</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoleAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_role_alias_input::Builder,
    }
    impl<C, M, R> DeleteRoleAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoleAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoleAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoleAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoleAliasInputOperationOutputAlias,
                crate::output::DeleteRoleAliasOutput,
                crate::error::DeleteRoleAliasError,
                crate::input::DeleteRoleAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The role alias to delete.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_alias(input.into());
            self
        }
        /// <p>The role alias to delete.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteScheduledAudit`.
    ///
    /// <p>Deletes a scheduled audit.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteScheduledAudit</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteScheduledAudit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_scheduled_audit_input::Builder,
    }
    impl<C, M, R> DeleteScheduledAudit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteScheduledAudit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScheduledAuditOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScheduledAuditError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteScheduledAuditInputOperationOutputAlias,
                crate::output::DeleteScheduledAuditOutput,
                crate::error::DeleteScheduledAuditError,
                crate::input::DeleteScheduledAuditInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled audit you want to delete.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_audit_name(input.into());
            self
        }
        /// <p>The name of the scheduled audit you want to delete.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_audit_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecurityProfile`.
    ///
    /// <p>Deletes a Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_security_profile_input::Builder,
    }
    impl<C, M, R> DeleteSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSecurityProfileInputOperationOutputAlias,
                crate::output::DeleteSecurityProfileOutput,
                crate::error::DeleteSecurityProfileError,
                crate::input::DeleteSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security profile to be deleted.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name of the security profile to be deleted.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStream`.
    ///
    /// <p>Deletes a stream.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteStream</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stream_input::Builder,
    }
    impl<C, M, R> DeleteStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamInputOperationOutputAlias,
                crate::output::DeleteStreamOutput,
                crate::error::DeleteStreamError,
                crate::input::DeleteStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThing`.
    ///
    /// <p>Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a thing that doesn't exist.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_thing_input::Builder,
    }
    impl<C, M, R> DeleteThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThingInputOperationOutputAlias,
                crate::output::DeleteThingOutput,
                crate::error::DeleteThingError,
                crate::input::DeleteThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to delete.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to delete.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThingGroup`.
    ///
    /// <p>Deletes a thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_thing_group_input::Builder,
    }
    impl<C, M, R> DeleteThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThingGroupInputOperationOutputAlias,
                crate::output::DeleteThingGroupOutput,
                crate::error::DeleteThingGroupError,
                crate::input::DeleteThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing group to delete.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the thing group to delete.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The expected version of the thing group to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the thing group to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThingType`.
    ///
    /// <p>Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a thing type, first mark it as deprecated by calling <code>DeprecateThingType</code>, then remove any associated things by calling <code>UpdateThing</code> to change the thing type on any associated thing, and finally use <code>DeleteThingType</code> to delete the thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_thing_type_input::Builder,
    }
    impl<C, M, R> DeleteThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThingTypeInputOperationOutputAlias,
                crate::output::DeleteThingTypeOutput,
                crate::error::DeleteThingTypeError,
                crate::input::DeleteThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTopicRule`.
    ///
    /// <p>Deletes the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_topic_rule_input::Builder,
    }
    impl<C, M, R> DeleteTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTopicRuleInputOperationOutputAlias,
                crate::output::DeleteTopicRuleOutput,
                crate::error::DeleteTopicRuleError,
                crate::input::DeleteTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTopicRuleDestination`.
    ///
    /// <p>Deletes a topic rule destination.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRuleDestination</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTopicRuleDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_topic_rule_destination_input::Builder,
    }
    impl<C, M, R> DeleteTopicRuleDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTopicRuleDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTopicRuleDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTopicRuleDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTopicRuleDestinationInputOperationOutputAlias,
                crate::output::DeleteTopicRuleDestinationOutput,
                crate::error::DeleteTopicRuleDestinationError,
                crate::input::DeleteTopicRuleDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the topic rule destination to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the topic rule destination to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteV2LoggingLevel`.
    ///
    /// <p>Deletes a logging level.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteV2LoggingLevel</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteV2LoggingLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_v2_logging_level_input::Builder,
    }
    impl<C, M, R> DeleteV2LoggingLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteV2LoggingLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteV2LoggingLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteV2LoggingLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteV2LoggingLevelInputOperationOutputAlias,
                crate::output::DeleteV2LoggingLevelOutput,
                crate::error::DeleteV2LoggingLevelError,
                crate::input::DeleteV2LoggingLevelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn target_type(mut self, input: crate::model::LogTargetType) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::LogTargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>The name of the resource for which you are configuring logging.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(input.into());
            self
        }
        /// <p>The name of the resource for which you are configuring logging.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateThingType`.
    ///
    /// <p>Deprecates a thing type. You can not associate new things with deprecated thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprecate_thing_type_input::Builder,
    }
    impl<C, M, R> DeprecateThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprecateThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprecateThingTypeInputOperationOutputAlias,
                crate::output::DeprecateThingTypeOutput,
                crate::error::DeprecateThingTypeError,
                crate::input::DeprecateThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type to deprecate.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type to deprecate.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
        /// <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
        pub fn undo_deprecate(mut self, input: bool) -> Self {
            self.inner = self.inner.undo_deprecate(input);
            self
        }
        /// <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
        pub fn set_undo_deprecate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_undo_deprecate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAuditConfiguration`.
    ///
    /// <p>Gets information about the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAccountAuditConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAuditConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_audit_configuration_input::Builder,
    }
    impl<C, M, R> DescribeAccountAuditConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAuditConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAuditConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAuditConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAuditConfigurationInputOperationOutputAlias,
                crate::output::DescribeAccountAuditConfigurationOutput,
                crate::error::DescribeAccountAuditConfigurationError,
                crate::input::DescribeAccountAuditConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditFinding`.
    ///
    /// <p>Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of the issue, and the start time when the audit that returned the finding.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditFinding</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditFinding<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_finding_input::Builder,
    }
    impl<C, M, R> DescribeAuditFinding<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditFinding`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditFindingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditFindingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditFindingInputOperationOutputAlias,
                crate::output::DescribeAuditFindingOutput,
                crate::error::DescribeAuditFindingError,
                crate::input::DescribeAuditFindingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
        pub fn finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_id(input.into());
            self
        }
        /// <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
        pub fn set_finding_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_finding_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditMitigationActionsTask`.
    ///
    /// <p>Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> DescribeAuditMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAuditMitigationActionsTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditMitigationActionsTaskInputOperationOutputAlias,
                crate::output::DescribeAuditMitigationActionsTaskOutput,
                crate::error::DescribeAuditMitigationActionsTaskError,
                crate::input::DescribeAuditMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the audit mitigation task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The unique identifier for the audit mitigation task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditSuppression`.
    ///
    /// <p> Gets information about a Device Defender audit suppression. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditSuppression<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_suppression_input::Builder,
    }
    impl<C, M, R> DescribeAuditSuppression<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditSuppression`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditSuppressionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditSuppressionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditSuppressionInputOperationOutputAlias,
                crate::output::DescribeAuditSuppressionOutput,
                crate::error::DescribeAuditSuppressionError,
                crate::input::DescribeAuditSuppressionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditTask`.
    ///
    /// <p>Gets information about a Device Defender audit.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_task_input::Builder,
    }
    impl<C, M, R> DescribeAuditTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditTaskInputOperationOutputAlias,
                crate::output::DescribeAuditTaskOutput,
                crate::error::DescribeAuditTaskError,
                crate::input::DescribeAuditTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the audit whose information you want to get.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the audit whose information you want to get.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuthorizer`.
    ///
    /// <p>Describes an authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_authorizer_input::Builder,
    }
    impl<C, M, R> DescribeAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuthorizerInputOperationOutputAlias,
                crate::output::DescribeAuthorizerOutput,
                crate::error::DescribeAuthorizerError,
                crate::input::DescribeAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authorizer to describe.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_name(input.into());
            self
        }
        /// <p>The name of the authorizer to describe.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBillingGroup`.
    ///
    /// <p>Returns information about a billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_billing_group_input::Builder,
    }
    impl<C, M, R> DescribeBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBillingGroupInputOperationOutputAlias,
                crate::output::DescribeBillingGroupOutput,
                crate::error::DescribeBillingGroupError,
                crate::input::DescribeBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCACertificate`.
    ///
    /// <p>Describes a registered CA certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCACertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCACertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ca_certificate_input::Builder,
    }
    impl<C, M, R> DescribeCACertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCACertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCaCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCACertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCaCertificateInputOperationOutputAlias,
                crate::output::DescribeCaCertificateOutput,
                crate::error::DescribeCACertificateError,
                crate::input::DescribeCaCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The CA certificate identifier.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The CA certificate identifier.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificate`.
    ///
    /// <p>Gets information about the specified certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_certificate_input::Builder,
    }
    impl<C, M, R> DescribeCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCertificateInputOperationOutputAlias,
                crate::output::DescribeCertificateOutput,
                crate::error::DescribeCertificateError,
                crate::input::DescribeCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomMetric`.
    ///
    /// <p> Gets information about a Device Defender detect custom metric. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCustomMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_metric_input::Builder,
    }
    impl<C, M, R> DescribeCustomMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomMetricInputOperationOutputAlias,
                crate::output::DescribeCustomMetricOutput,
                crate::error::DescribeCustomMetricError,
                crate::input::DescribeCustomMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDefaultAuthorizer`.
    ///
    /// <p>Describes the default authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDefaultAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDefaultAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_default_authorizer_input::Builder,
    }
    impl<C, M, R> DescribeDefaultAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDefaultAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDefaultAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDefaultAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDefaultAuthorizerInputOperationOutputAlias,
                crate::output::DescribeDefaultAuthorizerOutput,
                crate::error::DescribeDefaultAuthorizerError,
                crate::input::DescribeDefaultAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeDetectMitigationActionsTask`.
    ///
    /// <p> Gets information about a Device Defender ML Detect mitigation action. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDetectMitigationActionsTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDetectMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_detect_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> DescribeDetectMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDetectMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDetectMitigationActionsTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDetectMitigationActionsTaskInputOperationOutputAlias,
                crate::output::DescribeDetectMitigationActionsTaskOutput,
                crate::error::DescribeDetectMitigationActionsTaskError,
                crate::input::DescribeDetectMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDimension`.
    ///
    /// <p>Provides details about a dimension that is defined in your Amazon Web Services accounts.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDimension</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDimension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dimension_input::Builder,
    }
    impl<C, M, R> DescribeDimension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDimension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDimensionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDimensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDimensionInputOperationOutputAlias,
                crate::output::DescribeDimensionOutput,
                crate::error::DescribeDimensionError,
                crate::input::DescribeDimensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique identifier for the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainConfiguration`.
    ///
    /// <p>Gets summary information about a domain configuration.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDomainConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_configuration_input::Builder,
    }
    impl<C, M, R> DescribeDomainConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomainConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainConfigurationInputOperationOutputAlias,
                crate::output::DescribeDomainConfigurationOutput,
                crate::error::DescribeDomainConfigurationError,
                crate::input::DescribeDomainConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain configuration.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_configuration_name(input.into());
            self
        }
        /// <p>The name of the domain configuration.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_configuration_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoint`.
    ///
    /// <p>Returns a unique endpoint specific to the Amazon Web Services account making the call.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEndpoint</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_input::Builder,
    }
    impl<C, M, R> DescribeEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointInputOperationOutputAlias,
                crate::output::DescribeEndpointOutput,
                crate::error::DescribeEndpointError,
                crate::input::DescribeEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The endpoint type. Valid endpoint types include:</p>
        /// <ul>
        /// <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:CredentialProvider</code> - Returns an IoT credentials provider API endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Jobs</code> - Returns an IoT device management Jobs API endpoint.</p> </li>
        /// </ul>
        /// <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(input.into());
            self
        }
        /// <p>The endpoint type. Valid endpoint types include:</p>
        /// <ul>
        /// <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:CredentialProvider</code> - Returns an IoT credentials provider API endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Jobs</code> - Returns an IoT device management Jobs API endpoint.</p> </li>
        /// </ul>
        /// <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventConfigurations`.
    ///
    /// <p>Describes event configurations.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEventConfigurations</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_configurations_input::Builder,
    }
    impl<C, M, R> DescribeEventConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventConfigurationsInputOperationOutputAlias,
                crate::output::DescribeEventConfigurationsOutput,
                crate::error::DescribeEventConfigurationsError,
                crate::input::DescribeEventConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeFleetMetric`.
    ///
    /// <p>Gets information about the specified fleet metric.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeFleetMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFleetMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fleet_metric_input::Builder,
    }
    impl<C, M, R> DescribeFleetMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFleetMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFleetMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFleetMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFleetMetricInputOperationOutputAlias,
                crate::output::DescribeFleetMetricOutput,
                crate::error::DescribeFleetMetricError,
                crate::input::DescribeFleetMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet metric to describe.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>The name of the fleet metric to describe.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIndex`.
    ///
    /// <p>Describes a search index.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeIndex</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_index_input::Builder,
    }
    impl<C, M, R> DescribeIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIndexInputOperationOutputAlias,
                crate::output::DescribeIndexOutput,
                crate::error::DescribeIndexError,
                crate::input::DescribeIndexInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJob`.
    ///
    /// <p>Describes a job.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_input::Builder,
    }
    impl<C, M, R> DescribeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobInputOperationOutputAlias,
                crate::output::DescribeJobOutput,
                crate::error::DescribeJobError,
                crate::input::DescribeJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobExecution`.
    ///
    /// <p>Describes a job execution.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJobExecution</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_execution_input::Builder,
    }
    impl<C, M, R> DescribeJobExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobExecutionInputOperationOutputAlias,
                crate::output::DescribeJobExecutionOutput,
                crate::error::DescribeJobExecutionError,
                crate::input::DescribeJobExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The name of the thing on which the job execution is running.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing on which the job execution is running.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.inner = self.inner.execution_number(input);
            self
        }
        /// <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_execution_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobTemplate`.
    ///
    /// <p>Returns information about a job template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_template_input::Builder,
    }
    impl<C, M, R> DescribeJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobTemplateInputOperationOutputAlias,
                crate::output::DescribeJobTemplateOutput,
                crate::error::DescribeJobTemplateError,
                crate::input::DescribeJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_id(input.into());
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeManagedJobTemplate`.
    ///
    /// <p>View details of a managed job template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeManagedJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_managed_job_template_input::Builder,
    }
    impl<C, M, R> DescribeManagedJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeManagedJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeManagedJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeManagedJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeManagedJobTemplateInputOperationOutputAlias,
                crate::output::DescribeManagedJobTemplateOutput,
                crate::error::DescribeManagedJobTemplateError,
                crate::input::DescribeManagedJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a managed job template, which is required.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The unique name of a managed job template, which is required.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>An optional parameter to specify version of a managed template. If not specified, the pre-defined default version is returned.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_version(input.into());
            self
        }
        /// <p>An optional parameter to specify version of a managed template. If not specified, the pre-defined default version is returned.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMitigationAction`.
    ///
    /// <p>Gets information about a mitigation action.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeMitigationAction</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMitigationAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_mitigation_action_input::Builder,
    }
    impl<C, M, R> DescribeMitigationAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMitigationAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMitigationActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMitigationActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMitigationActionInputOperationOutputAlias,
                crate::output::DescribeMitigationActionOutput,
                crate::error::DescribeMitigationActionError,
                crate::input::DescribeMitigationActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningTemplate`.
    ///
    /// <p>Returns information about a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisioningTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioning_template_input::Builder,
    }
    impl<C, M, R> DescribeProvisioningTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisioningTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisioningTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisioningTemplateInputOperationOutputAlias,
                crate::output::DescribeProvisioningTemplateOutput,
                crate::error::DescribeProvisioningTemplateError,
                crate::input::DescribeProvisioningTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningTemplateVersion`.
    ///
    /// <p>Returns information about a fleet provisioning template version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplateVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisioningTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioning_template_version_input::Builder,
    }
    impl<C, M, R> DescribeProvisioningTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisioningTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningTemplateVersionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeProvisioningTemplateVersionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisioningTemplateVersionInputOperationOutputAlias,
                crate::output::DescribeProvisioningTemplateVersionOutput,
                crate::error::DescribeProvisioningTemplateVersionError,
                crate::input::DescribeProvisioningTemplateVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The template name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The fleet provisioning template version ID.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.version_id(input);
            self
        }
        /// <p>The fleet provisioning template version ID.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRoleAlias`.
    ///
    /// <p>Describes a role alias.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeRoleAlias</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRoleAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_role_alias_input::Builder,
    }
    impl<C, M, R> DescribeRoleAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRoleAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRoleAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRoleAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRoleAliasInputOperationOutputAlias,
                crate::output::DescribeRoleAliasOutput,
                crate::error::DescribeRoleAliasError,
                crate::input::DescribeRoleAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The role alias to describe.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_alias(input.into());
            self
        }
        /// <p>The role alias to describe.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeScheduledAudit`.
    ///
    /// <p>Gets information about a scheduled audit.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeScheduledAudit</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeScheduledAudit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_scheduled_audit_input::Builder,
    }
    impl<C, M, R> DescribeScheduledAudit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeScheduledAudit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScheduledAuditOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScheduledAuditError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeScheduledAuditInputOperationOutputAlias,
                crate::output::DescribeScheduledAuditOutput,
                crate::error::DescribeScheduledAuditError,
                crate::input::DescribeScheduledAuditInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled audit whose information you want to get.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_audit_name(input.into());
            self
        }
        /// <p>The name of the scheduled audit whose information you want to get.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_audit_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecurityProfile`.
    ///
    /// <p>Gets information about a Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_security_profile_input::Builder,
    }
    impl<C, M, R> DescribeSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSecurityProfileInputOperationOutputAlias,
                crate::output::DescribeSecurityProfileOutput,
                crate::error::DescribeSecurityProfileError,
                crate::input::DescribeSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security profile whose information you want to get.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name of the security profile whose information you want to get.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStream`.
    ///
    /// <p>Gets information about a stream.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeStream</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stream_input::Builder,
    }
    impl<C, M, R> DescribeStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStreamInputOperationOutputAlias,
                crate::output::DescribeStreamOutput,
                crate::error::DescribeStreamError,
                crate::input::DescribeStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThing`.
    ///
    /// <p>Gets information about the specified thing.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_input::Builder,
    }
    impl<C, M, R> DescribeThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingInputOperationOutputAlias,
                crate::output::DescribeThingOutput,
                crate::error::DescribeThingError,
                crate::input::DescribeThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThingGroup`.
    ///
    /// <p>Describe a thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_group_input::Builder,
    }
    impl<C, M, R> DescribeThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingGroupInputOperationOutputAlias,
                crate::output::DescribeThingGroupOutput,
                crate::error::DescribeThingGroupError,
                crate::input::DescribeThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing group.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the thing group.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThingRegistrationTask`.
    ///
    /// <p>Describes a bulk thing provisioning task.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingRegistrationTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThingRegistrationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_registration_task_input::Builder,
    }
    impl<C, M, R> DescribeThingRegistrationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThingRegistrationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingRegistrationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingRegistrationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingRegistrationTaskInputOperationOutputAlias,
                crate::output::DescribeThingRegistrationTaskOutput,
                crate::error::DescribeThingRegistrationTaskError,
                crate::input::DescribeThingRegistrationTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The task ID.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The task ID.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThingType`.
    ///
    /// <p>Gets information about the specified thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_type_input::Builder,
    }
    impl<C, M, R> DescribeThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingTypeInputOperationOutputAlias,
                crate::output::DescribeThingTypeOutput,
                crate::error::DescribeThingTypeError,
                crate::input::DescribeThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPolicy`.
    ///
    /// <p>Detaches a policy from the specified target.</p> <note>
    /// <p>Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_policy_input::Builder,
    }
    impl<C, M, R> DetachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachPolicyInputOperationOutputAlias,
                crate::output::DetachPolicyOutput,
                crate::error::DetachPolicyError,
                crate::input::DetachPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy to detach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy to detach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The target from which the policy will be detached.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The target from which the policy will be detached.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPrincipalPolicy`.
    ///
    /// <p>Removes the specified policy from the specified certificate.</p> <note>
    /// <p>This action is deprecated. Please use <code>DetachPolicy</code> instead.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPrincipalPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachPrincipalPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_principal_policy_input::Builder,
    }
    impl<C, M, R> DetachPrincipalPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachPrincipalPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPrincipalPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPrincipalPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachPrincipalPolicyInputOperationOutputAlias,
                crate::output::DetachPrincipalPolicyOutput,
                crate::error::DetachPrincipalPolicyError,
                crate::input::DetachPrincipalPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy to detach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to detach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The principal.</p>
        /// <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal.</p>
        /// <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachSecurityProfile`.
    ///
    /// <p>Disassociates a Device Defender security profile from a thing group or from this account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_security_profile_input::Builder,
    }
    impl<C, M, R> DetachSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachSecurityProfileInputOperationOutputAlias,
                crate::output::DetachSecurityProfileOutput,
                crate::error::DetachSecurityProfileError,
                crate::input::DetachSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The security profile that is detached.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The security profile that is detached.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The ARN of the thing group from which the security profile is detached.</p>
        pub fn security_profile_target_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.security_profile_target_arn(input.into());
            self
        }
        /// <p>The ARN of the thing group from which the security profile is detached.</p>
        pub fn set_security_profile_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachThingPrincipal`.
    ///
    /// <p>Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p> <note>
    /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachThingPrincipal</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachThingPrincipal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_thing_principal_input::Builder,
    }
    impl<C, M, R> DetachThingPrincipal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachThingPrincipal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachThingPrincipalOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachThingPrincipalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachThingPrincipalInputOperationOutputAlias,
                crate::output::DetachThingPrincipalOutput,
                crate::error::DetachThingPrincipalError,
                crate::input::DetachThingPrincipalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableTopicRule`.
    ///
    /// <p>Disables the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DisableTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_topic_rule_input::Builder,
    }
    impl<C, M, R> DisableTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableTopicRuleInputOperationOutputAlias,
                crate::output::DisableTopicRuleOutput,
                crate::error::DisableTopicRuleError,
                crate::input::DisableTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule to disable.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule to disable.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableTopicRule`.
    ///
    /// <p>Enables the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">EnableTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_topic_rule_input::Builder,
    }
    impl<C, M, R> EnableTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableTopicRuleInputOperationOutputAlias,
                crate::output::EnableTopicRuleOutput,
                crate::error::EnableTopicRuleError,
                crate::input::EnableTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the topic rule to enable.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the topic rule to enable.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBehaviorModelTrainingSummaries`.
    ///
    /// <p> Returns a Device Defender's ML Detect Security Profile training model's status. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBehaviorModelTrainingSummaries</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBehaviorModelTrainingSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_behavior_model_training_summaries_input::Builder,
    }
    impl<C, M, R> GetBehaviorModelTrainingSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBehaviorModelTrainingSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBehaviorModelTrainingSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBehaviorModelTrainingSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBehaviorModelTrainingSummariesInputOperationOutputAlias,
                crate::output::GetBehaviorModelTrainingSummariesOutput,
                crate::error::GetBehaviorModelTrainingSummariesError,
                crate::input::GetBehaviorModelTrainingSummariesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBehaviorModelTrainingSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetBehaviorModelTrainingSummariesPaginator<C, M, R> {
            crate::paginator::GetBehaviorModelTrainingSummariesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The name of the security profile. </p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p> The name of the security profile. </p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketsAggregation`.
    ///
    /// <p>Aggregates on indexed data with search queries pertaining to particular fields. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBucketsAggregation</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketsAggregation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_buckets_aggregation_input::Builder,
    }
    impl<C, M, R> GetBucketsAggregation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketsAggregation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketsAggregationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketsAggregationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketsAggregationInputOperationOutputAlias,
                crate::output::GetBucketsAggregationOutput,
                crate::error::GetBucketsAggregationError,
                crate::input::GetBucketsAggregationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The aggregation field.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The aggregation field.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The version of the query.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The version of the query.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
        /// <p>The basic control of the response shape and the bucket aggregation type to perform. </p>
        pub fn buckets_aggregation_type(
            mut self,
            input: crate::model::BucketsAggregationType,
        ) -> Self {
            self.inner = self.inner.buckets_aggregation_type(input);
            self
        }
        /// <p>The basic control of the response shape and the bucket aggregation type to perform. </p>
        pub fn set_buckets_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::BucketsAggregationType>,
        ) -> Self {
            self.inner = self.inner.set_buckets_aggregation_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCardinality`.
    ///
    /// <p>Returns the approximate count of unique values that match the query.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetCardinality</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCardinality<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cardinality_input::Builder,
    }
    impl<C, M, R> GetCardinality<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCardinality`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCardinalityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCardinalityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCardinalityInputOperationOutputAlias,
                crate::output::GetCardinalityOutput,
                crate::error::GetCardinalityError,
                crate::input::GetCardinalityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEffectivePolicies`.
    ///
    /// <p>Gets a list of the policies that have an effect on the authorization behavior of the specified device when it connects to the IoT device gateway.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetEffectivePolicies</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEffectivePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_effective_policies_input::Builder,
    }
    impl<C, M, R> GetEffectivePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEffectivePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be re