// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT
///
/// Client for invoking operations on AWS IoT. Each operation on AWS IoT is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_iot::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_iot::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_iot::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptCertificateTransfer` operation.
    ///
    /// See [`AcceptCertificateTransfer`](crate::client::fluent_builders::AcceptCertificateTransfer) for more information about the
    /// operation and its arguments.
    pub fn accept_certificate_transfer(
        &self,
    ) -> fluent_builders::AcceptCertificateTransfer<C, M, R> {
        fluent_builders::AcceptCertificateTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddThingToBillingGroup` operation.
    ///
    /// See [`AddThingToBillingGroup`](crate::client::fluent_builders::AddThingToBillingGroup) for more information about the
    /// operation and its arguments.
    pub fn add_thing_to_billing_group(&self) -> fluent_builders::AddThingToBillingGroup<C, M, R> {
        fluent_builders::AddThingToBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddThingToThingGroup` operation.
    ///
    /// See [`AddThingToThingGroup`](crate::client::fluent_builders::AddThingToThingGroup) for more information about the
    /// operation and its arguments.
    pub fn add_thing_to_thing_group(&self) -> fluent_builders::AddThingToThingGroup<C, M, R> {
        fluent_builders::AddThingToThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTargetsWithJob` operation.
    ///
    /// See [`AssociateTargetsWithJob`](crate::client::fluent_builders::AssociateTargetsWithJob) for more information about the
    /// operation and its arguments.
    pub fn associate_targets_with_job(&self) -> fluent_builders::AssociateTargetsWithJob<C, M, R> {
        fluent_builders::AssociateTargetsWithJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachPolicy` operation.
    ///
    /// See [`AttachPolicy`](crate::client::fluent_builders::AttachPolicy) for more information about the
    /// operation and its arguments.
    pub fn attach_policy(&self) -> fluent_builders::AttachPolicy<C, M, R> {
        fluent_builders::AttachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachPrincipalPolicy` operation.
    ///
    /// See [`AttachPrincipalPolicy`](crate::client::fluent_builders::AttachPrincipalPolicy) for more information about the
    /// operation and its arguments.
    pub fn attach_principal_policy(&self) -> fluent_builders::AttachPrincipalPolicy<C, M, R> {
        fluent_builders::AttachPrincipalPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachSecurityProfile` operation.
    ///
    /// See [`AttachSecurityProfile`](crate::client::fluent_builders::AttachSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn attach_security_profile(&self) -> fluent_builders::AttachSecurityProfile<C, M, R> {
        fluent_builders::AttachSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachThingPrincipal` operation.
    ///
    /// See [`AttachThingPrincipal`](crate::client::fluent_builders::AttachThingPrincipal) for more information about the
    /// operation and its arguments.
    pub fn attach_thing_principal(&self) -> fluent_builders::AttachThingPrincipal<C, M, R> {
        fluent_builders::AttachThingPrincipal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelAuditMitigationActionsTask` operation.
    ///
    /// See [`CancelAuditMitigationActionsTask`](crate::client::fluent_builders::CancelAuditMitigationActionsTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_audit_mitigation_actions_task(
        &self,
    ) -> fluent_builders::CancelAuditMitigationActionsTask<C, M, R> {
        fluent_builders::CancelAuditMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelAuditTask` operation.
    ///
    /// See [`CancelAuditTask`](crate::client::fluent_builders::CancelAuditTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_audit_task(&self) -> fluent_builders::CancelAuditTask<C, M, R> {
        fluent_builders::CancelAuditTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelCertificateTransfer` operation.
    ///
    /// See [`CancelCertificateTransfer`](crate::client::fluent_builders::CancelCertificateTransfer) for more information about the
    /// operation and its arguments.
    pub fn cancel_certificate_transfer(
        &self,
    ) -> fluent_builders::CancelCertificateTransfer<C, M, R> {
        fluent_builders::CancelCertificateTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelDetectMitigationActionsTask` operation.
    ///
    /// See [`CancelDetectMitigationActionsTask`](crate::client::fluent_builders::CancelDetectMitigationActionsTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_detect_mitigation_actions_task(
        &self,
    ) -> fluent_builders::CancelDetectMitigationActionsTask<C, M, R> {
        fluent_builders::CancelDetectMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelJob` operation.
    ///
    /// See [`CancelJob`](crate::client::fluent_builders::CancelJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_job(&self) -> fluent_builders::CancelJob<C, M, R> {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelJobExecution` operation.
    ///
    /// See [`CancelJobExecution`](crate::client::fluent_builders::CancelJobExecution) for more information about the
    /// operation and its arguments.
    pub fn cancel_job_execution(&self) -> fluent_builders::CancelJobExecution<C, M, R> {
        fluent_builders::CancelJobExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ClearDefaultAuthorizer` operation.
    ///
    /// See [`ClearDefaultAuthorizer`](crate::client::fluent_builders::ClearDefaultAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn clear_default_authorizer(&self) -> fluent_builders::ClearDefaultAuthorizer<C, M, R> {
        fluent_builders::ClearDefaultAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfirmTopicRuleDestination` operation.
    ///
    /// See [`ConfirmTopicRuleDestination`](crate::client::fluent_builders::ConfirmTopicRuleDestination) for more information about the
    /// operation and its arguments.
    pub fn confirm_topic_rule_destination(
        &self,
    ) -> fluent_builders::ConfirmTopicRuleDestination<C, M, R> {
        fluent_builders::ConfirmTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAuditSuppression` operation.
    ///
    /// See [`CreateAuditSuppression`](crate::client::fluent_builders::CreateAuditSuppression) for more information about the
    /// operation and its arguments.
    pub fn create_audit_suppression(&self) -> fluent_builders::CreateAuditSuppression<C, M, R> {
        fluent_builders::CreateAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAuthorizer` operation.
    ///
    /// See [`CreateAuthorizer`](crate::client::fluent_builders::CreateAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn create_authorizer(&self) -> fluent_builders::CreateAuthorizer<C, M, R> {
        fluent_builders::CreateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBillingGroup` operation.
    ///
    /// See [`CreateBillingGroup`](crate::client::fluent_builders::CreateBillingGroup) for more information about the
    /// operation and its arguments.
    pub fn create_billing_group(&self) -> fluent_builders::CreateBillingGroup<C, M, R> {
        fluent_builders::CreateBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCertificateFromCsr` operation.
    ///
    /// See [`CreateCertificateFromCsr`](crate::client::fluent_builders::CreateCertificateFromCsr) for more information about the
    /// operation and its arguments.
    pub fn create_certificate_from_csr(
        &self,
    ) -> fluent_builders::CreateCertificateFromCsr<C, M, R> {
        fluent_builders::CreateCertificateFromCsr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomMetric` operation.
    ///
    /// See [`CreateCustomMetric`](crate::client::fluent_builders::CreateCustomMetric) for more information about the
    /// operation and its arguments.
    pub fn create_custom_metric(&self) -> fluent_builders::CreateCustomMetric<C, M, R> {
        fluent_builders::CreateCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDimension` operation.
    ///
    /// See [`CreateDimension`](crate::client::fluent_builders::CreateDimension) for more information about the
    /// operation and its arguments.
    pub fn create_dimension(&self) -> fluent_builders::CreateDimension<C, M, R> {
        fluent_builders::CreateDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomainConfiguration` operation.
    ///
    /// See [`CreateDomainConfiguration`](crate::client::fluent_builders::CreateDomainConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_domain_configuration(
        &self,
    ) -> fluent_builders::CreateDomainConfiguration<C, M, R> {
        fluent_builders::CreateDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDynamicThingGroup` operation.
    ///
    /// See [`CreateDynamicThingGroup`](crate::client::fluent_builders::CreateDynamicThingGroup) for more information about the
    /// operation and its arguments.
    pub fn create_dynamic_thing_group(&self) -> fluent_builders::CreateDynamicThingGroup<C, M, R> {
        fluent_builders::CreateDynamicThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFleetMetric` operation.
    ///
    /// See [`CreateFleetMetric`](crate::client::fluent_builders::CreateFleetMetric) for more information about the
    /// operation and its arguments.
    pub fn create_fleet_metric(&self) -> fluent_builders::CreateFleetMetric<C, M, R> {
        fluent_builders::CreateFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJob` operation.
    ///
    /// See [`CreateJob`](crate::client::fluent_builders::CreateJob) for more information about the
    /// operation and its arguments.
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJobTemplate` operation.
    ///
    /// See [`CreateJobTemplate`](crate::client::fluent_builders::CreateJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_job_template(&self) -> fluent_builders::CreateJobTemplate<C, M, R> {
        fluent_builders::CreateJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateKeysAndCertificate` operation.
    ///
    /// See [`CreateKeysAndCertificate`](crate::client::fluent_builders::CreateKeysAndCertificate) for more information about the
    /// operation and its arguments.
    pub fn create_keys_and_certificate(
        &self,
    ) -> fluent_builders::CreateKeysAndCertificate<C, M, R> {
        fluent_builders::CreateKeysAndCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMitigationAction` operation.
    ///
    /// See [`CreateMitigationAction`](crate::client::fluent_builders::CreateMitigationAction) for more information about the
    /// operation and its arguments.
    pub fn create_mitigation_action(&self) -> fluent_builders::CreateMitigationAction<C, M, R> {
        fluent_builders::CreateMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOTAUpdate` operation.
    ///
    /// See [`CreateOTAUpdate`](crate::client::fluent_builders::CreateOTAUpdate) for more information about the
    /// operation and its arguments.
    pub fn create_ota_update(&self) -> fluent_builders::CreateOTAUpdate<C, M, R> {
        fluent_builders::CreateOTAUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePolicy` operation.
    ///
    /// See [`CreatePolicy`](crate::client::fluent_builders::CreatePolicy) for more information about the
    /// operation and its arguments.
    pub fn create_policy(&self) -> fluent_builders::CreatePolicy<C, M, R> {
        fluent_builders::CreatePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePolicyVersion` operation.
    ///
    /// See [`CreatePolicyVersion`](crate::client::fluent_builders::CreatePolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn create_policy_version(&self) -> fluent_builders::CreatePolicyVersion<C, M, R> {
        fluent_builders::CreatePolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProvisioningClaim` operation.
    ///
    /// See [`CreateProvisioningClaim`](crate::client::fluent_builders::CreateProvisioningClaim) for more information about the
    /// operation and its arguments.
    pub fn create_provisioning_claim(&self) -> fluent_builders::CreateProvisioningClaim<C, M, R> {
        fluent_builders::CreateProvisioningClaim::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProvisioningTemplate` operation.
    ///
    /// See [`CreateProvisioningTemplate`](crate::client::fluent_builders::CreateProvisioningTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_provisioning_template(
        &self,
    ) -> fluent_builders::CreateProvisioningTemplate<C, M, R> {
        fluent_builders::CreateProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProvisioningTemplateVersion` operation.
    ///
    /// See [`CreateProvisioningTemplateVersion`](crate::client::fluent_builders::CreateProvisioningTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn create_provisioning_template_version(
        &self,
    ) -> fluent_builders::CreateProvisioningTemplateVersion<C, M, R> {
        fluent_builders::CreateProvisioningTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoleAlias` operation.
    ///
    /// See [`CreateRoleAlias`](crate::client::fluent_builders::CreateRoleAlias) for more information about the
    /// operation and its arguments.
    pub fn create_role_alias(&self) -> fluent_builders::CreateRoleAlias<C, M, R> {
        fluent_builders::CreateRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateScheduledAudit` operation.
    ///
    /// See [`CreateScheduledAudit`](crate::client::fluent_builders::CreateScheduledAudit) for more information about the
    /// operation and its arguments.
    pub fn create_scheduled_audit(&self) -> fluent_builders::CreateScheduledAudit<C, M, R> {
        fluent_builders::CreateScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSecurityProfile` operation.
    ///
    /// See [`CreateSecurityProfile`](crate::client::fluent_builders::CreateSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn create_security_profile(&self) -> fluent_builders::CreateSecurityProfile<C, M, R> {
        fluent_builders::CreateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStream` operation.
    ///
    /// See [`CreateStream`](crate::client::fluent_builders::CreateStream) for more information about the
    /// operation and its arguments.
    pub fn create_stream(&self) -> fluent_builders::CreateStream<C, M, R> {
        fluent_builders::CreateStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateThing` operation.
    ///
    /// See [`CreateThing`](crate::client::fluent_builders::CreateThing) for more information about the
    /// operation and its arguments.
    pub fn create_thing(&self) -> fluent_builders::CreateThing<C, M, R> {
        fluent_builders::CreateThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateThingGroup` operation.
    ///
    /// See [`CreateThingGroup`](crate::client::fluent_builders::CreateThingGroup) for more information about the
    /// operation and its arguments.
    pub fn create_thing_group(&self) -> fluent_builders::CreateThingGroup<C, M, R> {
        fluent_builders::CreateThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateThingType` operation.
    ///
    /// See [`CreateThingType`](crate::client::fluent_builders::CreateThingType) for more information about the
    /// operation and its arguments.
    pub fn create_thing_type(&self) -> fluent_builders::CreateThingType<C, M, R> {
        fluent_builders::CreateThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTopicRule` operation.
    ///
    /// See [`CreateTopicRule`](crate::client::fluent_builders::CreateTopicRule) for more information about the
    /// operation and its arguments.
    pub fn create_topic_rule(&self) -> fluent_builders::CreateTopicRule<C, M, R> {
        fluent_builders::CreateTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTopicRuleDestination` operation.
    ///
    /// See [`CreateTopicRuleDestination`](crate::client::fluent_builders::CreateTopicRuleDestination) for more information about the
    /// operation and its arguments.
    pub fn create_topic_rule_destination(
        &self,
    ) -> fluent_builders::CreateTopicRuleDestination<C, M, R> {
        fluent_builders::CreateTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccountAuditConfiguration` operation.
    ///
    /// See [`DeleteAccountAuditConfiguration`](crate::client::fluent_builders::DeleteAccountAuditConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_account_audit_configuration(
        &self,
    ) -> fluent_builders::DeleteAccountAuditConfiguration<C, M, R> {
        fluent_builders::DeleteAccountAuditConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAuditSuppression` operation.
    ///
    /// See [`DeleteAuditSuppression`](crate::client::fluent_builders::DeleteAuditSuppression) for more information about the
    /// operation and its arguments.
    pub fn delete_audit_suppression(&self) -> fluent_builders::DeleteAuditSuppression<C, M, R> {
        fluent_builders::DeleteAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAuthorizer` operation.
    ///
    /// See [`DeleteAuthorizer`](crate::client::fluent_builders::DeleteAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn delete_authorizer(&self) -> fluent_builders::DeleteAuthorizer<C, M, R> {
        fluent_builders::DeleteAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBillingGroup` operation.
    ///
    /// See [`DeleteBillingGroup`](crate::client::fluent_builders::DeleteBillingGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_billing_group(&self) -> fluent_builders::DeleteBillingGroup<C, M, R> {
        fluent_builders::DeleteBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCACertificate` operation.
    ///
    /// See [`DeleteCACertificate`](crate::client::fluent_builders::DeleteCACertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_ca_certificate(&self) -> fluent_builders::DeleteCACertificate<C, M, R> {
        fluent_builders::DeleteCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCertificate` operation.
    ///
    /// See [`DeleteCertificate`](crate::client::fluent_builders::DeleteCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_certificate(&self) -> fluent_builders::DeleteCertificate<C, M, R> {
        fluent_builders::DeleteCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomMetric` operation.
    ///
    /// See [`DeleteCustomMetric`](crate::client::fluent_builders::DeleteCustomMetric) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_metric(&self) -> fluent_builders::DeleteCustomMetric<C, M, R> {
        fluent_builders::DeleteCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDimension` operation.
    ///
    /// See [`DeleteDimension`](crate::client::fluent_builders::DeleteDimension) for more information about the
    /// operation and its arguments.
    pub fn delete_dimension(&self) -> fluent_builders::DeleteDimension<C, M, R> {
        fluent_builders::DeleteDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomainConfiguration` operation.
    ///
    /// See [`DeleteDomainConfiguration`](crate::client::fluent_builders::DeleteDomainConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_domain_configuration(
        &self,
    ) -> fluent_builders::DeleteDomainConfiguration<C, M, R> {
        fluent_builders::DeleteDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDynamicThingGroup` operation.
    ///
    /// See [`DeleteDynamicThingGroup`](crate::client::fluent_builders::DeleteDynamicThingGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_dynamic_thing_group(&self) -> fluent_builders::DeleteDynamicThingGroup<C, M, R> {
        fluent_builders::DeleteDynamicThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFleetMetric` operation.
    ///
    /// See [`DeleteFleetMetric`](crate::client::fluent_builders::DeleteFleetMetric) for more information about the
    /// operation and its arguments.
    pub fn delete_fleet_metric(&self) -> fluent_builders::DeleteFleetMetric<C, M, R> {
        fluent_builders::DeleteFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJob` operation.
    ///
    /// See [`DeleteJob`](crate::client::fluent_builders::DeleteJob) for more information about the
    /// operation and its arguments.
    pub fn delete_job(&self) -> fluent_builders::DeleteJob<C, M, R> {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJobExecution` operation.
    ///
    /// See [`DeleteJobExecution`](crate::client::fluent_builders::DeleteJobExecution) for more information about the
    /// operation and its arguments.
    pub fn delete_job_execution(&self) -> fluent_builders::DeleteJobExecution<C, M, R> {
        fluent_builders::DeleteJobExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJobTemplate` operation.
    ///
    /// See [`DeleteJobTemplate`](crate::client::fluent_builders::DeleteJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_job_template(&self) -> fluent_builders::DeleteJobTemplate<C, M, R> {
        fluent_builders::DeleteJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMitigationAction` operation.
    ///
    /// See [`DeleteMitigationAction`](crate::client::fluent_builders::DeleteMitigationAction) for more information about the
    /// operation and its arguments.
    pub fn delete_mitigation_action(&self) -> fluent_builders::DeleteMitigationAction<C, M, R> {
        fluent_builders::DeleteMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOTAUpdate` operation.
    ///
    /// See [`DeleteOTAUpdate`](crate::client::fluent_builders::DeleteOTAUpdate) for more information about the
    /// operation and its arguments.
    pub fn delete_ota_update(&self) -> fluent_builders::DeleteOTAUpdate<C, M, R> {
        fluent_builders::DeleteOTAUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePolicy` operation.
    ///
    /// See [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy<C, M, R> {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePolicyVersion` operation.
    ///
    /// See [`DeletePolicyVersion`](crate::client::fluent_builders::DeletePolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_policy_version(&self) -> fluent_builders::DeletePolicyVersion<C, M, R> {
        fluent_builders::DeletePolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProvisioningTemplate` operation.
    ///
    /// See [`DeleteProvisioningTemplate`](crate::client::fluent_builders::DeleteProvisioningTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_provisioning_template(
        &self,
    ) -> fluent_builders::DeleteProvisioningTemplate<C, M, R> {
        fluent_builders::DeleteProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProvisioningTemplateVersion` operation.
    ///
    /// See [`DeleteProvisioningTemplateVersion`](crate::client::fluent_builders::DeleteProvisioningTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_provisioning_template_version(
        &self,
    ) -> fluent_builders::DeleteProvisioningTemplateVersion<C, M, R> {
        fluent_builders::DeleteProvisioningTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRegistrationCode` operation.
    ///
    /// See [`DeleteRegistrationCode`](crate::client::fluent_builders::DeleteRegistrationCode) for more information about the
    /// operation and its arguments.
    pub fn delete_registration_code(&self) -> fluent_builders::DeleteRegistrationCode<C, M, R> {
        fluent_builders::DeleteRegistrationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoleAlias` operation.
    ///
    /// See [`DeleteRoleAlias`](crate::client::fluent_builders::DeleteRoleAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_role_alias(&self) -> fluent_builders::DeleteRoleAlias<C, M, R> {
        fluent_builders::DeleteRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteScheduledAudit` operation.
    ///
    /// See [`DeleteScheduledAudit`](crate::client::fluent_builders::DeleteScheduledAudit) for more information about the
    /// operation and its arguments.
    pub fn delete_scheduled_audit(&self) -> fluent_builders::DeleteScheduledAudit<C, M, R> {
        fluent_builders::DeleteScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSecurityProfile` operation.
    ///
    /// See [`DeleteSecurityProfile`](crate::client::fluent_builders::DeleteSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_security_profile(&self) -> fluent_builders::DeleteSecurityProfile<C, M, R> {
        fluent_builders::DeleteSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStream` operation.
    ///
    /// See [`DeleteStream`](crate::client::fluent_builders::DeleteStream) for more information about the
    /// operation and its arguments.
    pub fn delete_stream(&self) -> fluent_builders::DeleteStream<C, M, R> {
        fluent_builders::DeleteStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteThing` operation.
    ///
    /// See [`DeleteThing`](crate::client::fluent_builders::DeleteThing) for more information about the
    /// operation and its arguments.
    pub fn delete_thing(&self) -> fluent_builders::DeleteThing<C, M, R> {
        fluent_builders::DeleteThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteThingGroup` operation.
    ///
    /// See [`DeleteThingGroup`](crate::client::fluent_builders::DeleteThingGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_thing_group(&self) -> fluent_builders::DeleteThingGroup<C, M, R> {
        fluent_builders::DeleteThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteThingType` operation.
    ///
    /// See [`DeleteThingType`](crate::client::fluent_builders::DeleteThingType) for more information about the
    /// operation and its arguments.
    pub fn delete_thing_type(&self) -> fluent_builders::DeleteThingType<C, M, R> {
        fluent_builders::DeleteThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTopicRule` operation.
    ///
    /// See [`DeleteTopicRule`](crate::client::fluent_builders::DeleteTopicRule) for more information about the
    /// operation and its arguments.
    pub fn delete_topic_rule(&self) -> fluent_builders::DeleteTopicRule<C, M, R> {
        fluent_builders::DeleteTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTopicRuleDestination` operation.
    ///
    /// See [`DeleteTopicRuleDestination`](crate::client::fluent_builders::DeleteTopicRuleDestination) for more information about the
    /// operation and its arguments.
    pub fn delete_topic_rule_destination(
        &self,
    ) -> fluent_builders::DeleteTopicRuleDestination<C, M, R> {
        fluent_builders::DeleteTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteV2LoggingLevel` operation.
    ///
    /// See [`DeleteV2LoggingLevel`](crate::client::fluent_builders::DeleteV2LoggingLevel) for more information about the
    /// operation and its arguments.
    pub fn delete_v2_logging_level(&self) -> fluent_builders::DeleteV2LoggingLevel<C, M, R> {
        fluent_builders::DeleteV2LoggingLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprecateThingType` operation.
    ///
    /// See [`DeprecateThingType`](crate::client::fluent_builders::DeprecateThingType) for more information about the
    /// operation and its arguments.
    pub fn deprecate_thing_type(&self) -> fluent_builders::DeprecateThingType<C, M, R> {
        fluent_builders::DeprecateThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAuditConfiguration` operation.
    ///
    /// See [`DescribeAccountAuditConfiguration`](crate::client::fluent_builders::DescribeAccountAuditConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_account_audit_configuration(
        &self,
    ) -> fluent_builders::DescribeAccountAuditConfiguration<C, M, R> {
        fluent_builders::DescribeAccountAuditConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAuditFinding` operation.
    ///
    /// See [`DescribeAuditFinding`](crate::client::fluent_builders::DescribeAuditFinding) for more information about the
    /// operation and its arguments.
    pub fn describe_audit_finding(&self) -> fluent_builders::DescribeAuditFinding<C, M, R> {
        fluent_builders::DescribeAuditFinding::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAuditMitigationActionsTask` operation.
    ///
    /// See [`DescribeAuditMitigationActionsTask`](crate::client::fluent_builders::DescribeAuditMitigationActionsTask) for more information about the
    /// operation and its arguments.
    pub fn describe_audit_mitigation_actions_task(
        &self,
    ) -> fluent_builders::DescribeAuditMitigationActionsTask<C, M, R> {
        fluent_builders::DescribeAuditMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAuditSuppression` operation.
    ///
    /// See [`DescribeAuditSuppression`](crate::client::fluent_builders::DescribeAuditSuppression) for more information about the
    /// operation and its arguments.
    pub fn describe_audit_suppression(&self) -> fluent_builders::DescribeAuditSuppression<C, M, R> {
        fluent_builders::DescribeAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAuditTask` operation.
    ///
    /// See [`DescribeAuditTask`](crate::client::fluent_builders::DescribeAuditTask) for more information about the
    /// operation and its arguments.
    pub fn describe_audit_task(&self) -> fluent_builders::DescribeAuditTask<C, M, R> {
        fluent_builders::DescribeAuditTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAuthorizer` operation.
    ///
    /// See [`DescribeAuthorizer`](crate::client::fluent_builders::DescribeAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn describe_authorizer(&self) -> fluent_builders::DescribeAuthorizer<C, M, R> {
        fluent_builders::DescribeAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBillingGroup` operation.
    ///
    /// See [`DescribeBillingGroup`](crate::client::fluent_builders::DescribeBillingGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_billing_group(&self) -> fluent_builders::DescribeBillingGroup<C, M, R> {
        fluent_builders::DescribeBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCACertificate` operation.
    ///
    /// See [`DescribeCACertificate`](crate::client::fluent_builders::DescribeCACertificate) for more information about the
    /// operation and its arguments.
    pub fn describe_ca_certificate(&self) -> fluent_builders::DescribeCACertificate<C, M, R> {
        fluent_builders::DescribeCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCertificate` operation.
    ///
    /// See [`DescribeCertificate`](crate::client::fluent_builders::DescribeCertificate) for more information about the
    /// operation and its arguments.
    pub fn describe_certificate(&self) -> fluent_builders::DescribeCertificate<C, M, R> {
        fluent_builders::DescribeCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomMetric` operation.
    ///
    /// See [`DescribeCustomMetric`](crate::client::fluent_builders::DescribeCustomMetric) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_metric(&self) -> fluent_builders::DescribeCustomMetric<C, M, R> {
        fluent_builders::DescribeCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDefaultAuthorizer` operation.
    ///
    /// See [`DescribeDefaultAuthorizer`](crate::client::fluent_builders::DescribeDefaultAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn describe_default_authorizer(
        &self,
    ) -> fluent_builders::DescribeDefaultAuthorizer<C, M, R> {
        fluent_builders::DescribeDefaultAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDetectMitigationActionsTask` operation.
    ///
    /// See [`DescribeDetectMitigationActionsTask`](crate::client::fluent_builders::DescribeDetectMitigationActionsTask) for more information about the
    /// operation and its arguments.
    pub fn describe_detect_mitigation_actions_task(
        &self,
    ) -> fluent_builders::DescribeDetectMitigationActionsTask<C, M, R> {
        fluent_builders::DescribeDetectMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDimension` operation.
    ///
    /// See [`DescribeDimension`](crate::client::fluent_builders::DescribeDimension) for more information about the
    /// operation and its arguments.
    pub fn describe_dimension(&self) -> fluent_builders::DescribeDimension<C, M, R> {
        fluent_builders::DescribeDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomainConfiguration` operation.
    ///
    /// See [`DescribeDomainConfiguration`](crate::client::fluent_builders::DescribeDomainConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_domain_configuration(
        &self,
    ) -> fluent_builders::DescribeDomainConfiguration<C, M, R> {
        fluent_builders::DescribeDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpoint` operation.
    ///
    /// See [`DescribeEndpoint`](crate::client::fluent_builders::DescribeEndpoint) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint(&self) -> fluent_builders::DescribeEndpoint<C, M, R> {
        fluent_builders::DescribeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventConfigurations` operation.
    ///
    /// See [`DescribeEventConfigurations`](crate::client::fluent_builders::DescribeEventConfigurations) for more information about the
    /// operation and its arguments.
    pub fn describe_event_configurations(
        &self,
    ) -> fluent_builders::DescribeEventConfigurations<C, M, R> {
        fluent_builders::DescribeEventConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFleetMetric` operation.
    ///
    /// See [`DescribeFleetMetric`](crate::client::fluent_builders::DescribeFleetMetric) for more information about the
    /// operation and its arguments.
    pub fn describe_fleet_metric(&self) -> fluent_builders::DescribeFleetMetric<C, M, R> {
        fluent_builders::DescribeFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIndex` operation.
    ///
    /// See [`DescribeIndex`](crate::client::fluent_builders::DescribeIndex) for more information about the
    /// operation and its arguments.
    pub fn describe_index(&self) -> fluent_builders::DescribeIndex<C, M, R> {
        fluent_builders::DescribeIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJob` operation.
    ///
    /// See [`DescribeJob`](crate::client::fluent_builders::DescribeJob) for more information about the
    /// operation and its arguments.
    pub fn describe_job(&self) -> fluent_builders::DescribeJob<C, M, R> {
        fluent_builders::DescribeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJobExecution` operation.
    ///
    /// See [`DescribeJobExecution`](crate::client::fluent_builders::DescribeJobExecution) for more information about the
    /// operation and its arguments.
    pub fn describe_job_execution(&self) -> fluent_builders::DescribeJobExecution<C, M, R> {
        fluent_builders::DescribeJobExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJobTemplate` operation.
    ///
    /// See [`DescribeJobTemplate`](crate::client::fluent_builders::DescribeJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn describe_job_template(&self) -> fluent_builders::DescribeJobTemplate<C, M, R> {
        fluent_builders::DescribeJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeManagedJobTemplate` operation.
    ///
    /// See [`DescribeManagedJobTemplate`](crate::client::fluent_builders::DescribeManagedJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn describe_managed_job_template(
        &self,
    ) -> fluent_builders::DescribeManagedJobTemplate<C, M, R> {
        fluent_builders::DescribeManagedJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMitigationAction` operation.
    ///
    /// See [`DescribeMitigationAction`](crate::client::fluent_builders::DescribeMitigationAction) for more information about the
    /// operation and its arguments.
    pub fn describe_mitigation_action(&self) -> fluent_builders::DescribeMitigationAction<C, M, R> {
        fluent_builders::DescribeMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProvisioningTemplate` operation.
    ///
    /// See [`DescribeProvisioningTemplate`](crate::client::fluent_builders::DescribeProvisioningTemplate) for more information about the
    /// operation and its arguments.
    pub fn describe_provisioning_template(
        &self,
    ) -> fluent_builders::DescribeProvisioningTemplate<C, M, R> {
        fluent_builders::DescribeProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProvisioningTemplateVersion` operation.
    ///
    /// See [`DescribeProvisioningTemplateVersion`](crate::client::fluent_builders::DescribeProvisioningTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn describe_provisioning_template_version(
        &self,
    ) -> fluent_builders::DescribeProvisioningTemplateVersion<C, M, R> {
        fluent_builders::DescribeProvisioningTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRoleAlias` operation.
    ///
    /// See [`DescribeRoleAlias`](crate::client::fluent_builders::DescribeRoleAlias) for more information about the
    /// operation and its arguments.
    pub fn describe_role_alias(&self) -> fluent_builders::DescribeRoleAlias<C, M, R> {
        fluent_builders::DescribeRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeScheduledAudit` operation.
    ///
    /// See [`DescribeScheduledAudit`](crate::client::fluent_builders::DescribeScheduledAudit) for more information about the
    /// operation and its arguments.
    pub fn describe_scheduled_audit(&self) -> fluent_builders::DescribeScheduledAudit<C, M, R> {
        fluent_builders::DescribeScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSecurityProfile` operation.
    ///
    /// See [`DescribeSecurityProfile`](crate::client::fluent_builders::DescribeSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn describe_security_profile(&self) -> fluent_builders::DescribeSecurityProfile<C, M, R> {
        fluent_builders::DescribeSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStream` operation.
    ///
    /// See [`DescribeStream`](crate::client::fluent_builders::DescribeStream) for more information about the
    /// operation and its arguments.
    pub fn describe_stream(&self) -> fluent_builders::DescribeStream<C, M, R> {
        fluent_builders::DescribeStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeThing` operation.
    ///
    /// See [`DescribeThing`](crate::client::fluent_builders::DescribeThing) for more information about the
    /// operation and its arguments.
    pub fn describe_thing(&self) -> fluent_builders::DescribeThing<C, M, R> {
        fluent_builders::DescribeThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeThingGroup` operation.
    ///
    /// See [`DescribeThingGroup`](crate::client::fluent_builders::DescribeThingGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_thing_group(&self) -> fluent_builders::DescribeThingGroup<C, M, R> {
        fluent_builders::DescribeThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeThingRegistrationTask` operation.
    ///
    /// See [`DescribeThingRegistrationTask`](crate::client::fluent_builders::DescribeThingRegistrationTask) for more information about the
    /// operation and its arguments.
    pub fn describe_thing_registration_task(
        &self,
    ) -> fluent_builders::DescribeThingRegistrationTask<C, M, R> {
        fluent_builders::DescribeThingRegistrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeThingType` operation.
    ///
    /// See [`DescribeThingType`](crate::client::fluent_builders::DescribeThingType) for more information about the
    /// operation and its arguments.
    pub fn describe_thing_type(&self) -> fluent_builders::DescribeThingType<C, M, R> {
        fluent_builders::DescribeThingType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachPolicy` operation.
    ///
    /// See [`DetachPolicy`](crate::client::fluent_builders::DetachPolicy) for more information about the
    /// operation and its arguments.
    pub fn detach_policy(&self) -> fluent_builders::DetachPolicy<C, M, R> {
        fluent_builders::DetachPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachPrincipalPolicy` operation.
    ///
    /// See [`DetachPrincipalPolicy`](crate::client::fluent_builders::DetachPrincipalPolicy) for more information about the
    /// operation and its arguments.
    pub fn detach_principal_policy(&self) -> fluent_builders::DetachPrincipalPolicy<C, M, R> {
        fluent_builders::DetachPrincipalPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachSecurityProfile` operation.
    ///
    /// See [`DetachSecurityProfile`](crate::client::fluent_builders::DetachSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn detach_security_profile(&self) -> fluent_builders::DetachSecurityProfile<C, M, R> {
        fluent_builders::DetachSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachThingPrincipal` operation.
    ///
    /// See [`DetachThingPrincipal`](crate::client::fluent_builders::DetachThingPrincipal) for more information about the
    /// operation and its arguments.
    pub fn detach_thing_principal(&self) -> fluent_builders::DetachThingPrincipal<C, M, R> {
        fluent_builders::DetachThingPrincipal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableTopicRule` operation.
    ///
    /// See [`DisableTopicRule`](crate::client::fluent_builders::DisableTopicRule) for more information about the
    /// operation and its arguments.
    pub fn disable_topic_rule(&self) -> fluent_builders::DisableTopicRule<C, M, R> {
        fluent_builders::DisableTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableTopicRule` operation.
    ///
    /// See [`EnableTopicRule`](crate::client::fluent_builders::EnableTopicRule) for more information about the
    /// operation and its arguments.
    pub fn enable_topic_rule(&self) -> fluent_builders::EnableTopicRule<C, M, R> {
        fluent_builders::EnableTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBehaviorModelTrainingSummaries` operation.
    ///
    /// See [`GetBehaviorModelTrainingSummaries`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetBehaviorModelTrainingSummaries::into_paginator).
    pub fn get_behavior_model_training_summaries(
        &self,
    ) -> fluent_builders::GetBehaviorModelTrainingSummaries<C, M, R> {
        fluent_builders::GetBehaviorModelTrainingSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketsAggregation` operation.
    ///
    /// See [`GetBucketsAggregation`](crate::client::fluent_builders::GetBucketsAggregation) for more information about the
    /// operation and its arguments.
    pub fn get_buckets_aggregation(&self) -> fluent_builders::GetBucketsAggregation<C, M, R> {
        fluent_builders::GetBucketsAggregation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCardinality` operation.
    ///
    /// See [`GetCardinality`](crate::client::fluent_builders::GetCardinality) for more information about the
    /// operation and its arguments.
    pub fn get_cardinality(&self) -> fluent_builders::GetCardinality<C, M, R> {
        fluent_builders::GetCardinality::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEffectivePolicies` operation.
    ///
    /// See [`GetEffectivePolicies`](crate::client::fluent_builders::GetEffectivePolicies) for more information about the
    /// operation and its arguments.
    pub fn get_effective_policies(&self) -> fluent_builders::GetEffectivePolicies<C, M, R> {
        fluent_builders::GetEffectivePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIndexingConfiguration` operation.
    ///
    /// See [`GetIndexingConfiguration`](crate::client::fluent_builders::GetIndexingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_indexing_configuration(&self) -> fluent_builders::GetIndexingConfiguration<C, M, R> {
        fluent_builders::GetIndexingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobDocument` operation.
    ///
    /// See [`GetJobDocument`](crate::client::fluent_builders::GetJobDocument) for more information about the
    /// operation and its arguments.
    pub fn get_job_document(&self) -> fluent_builders::GetJobDocument<C, M, R> {
        fluent_builders::GetJobDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoggingOptions` operation.
    ///
    /// See [`GetLoggingOptions`](crate::client::fluent_builders::GetLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn get_logging_options(&self) -> fluent_builders::GetLoggingOptions<C, M, R> {
        fluent_builders::GetLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOTAUpdate` operation.
    ///
    /// See [`GetOTAUpdate`](crate::client::fluent_builders::GetOTAUpdate) for more information about the
    /// operation and its arguments.
    pub fn get_ota_update(&self) -> fluent_builders::GetOTAUpdate<C, M, R> {
        fluent_builders::GetOTAUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPercentiles` operation.
    ///
    /// See [`GetPercentiles`](crate::client::fluent_builders::GetPercentiles) for more information about the
    /// operation and its arguments.
    pub fn get_percentiles(&self) -> fluent_builders::GetPercentiles<C, M, R> {
        fluent_builders::GetPercentiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPolicy` operation.
    ///
    /// See [`GetPolicy`](crate::client::fluent_builders::GetPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_policy(&self) -> fluent_builders::GetPolicy<C, M, R> {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPolicyVersion` operation.
    ///
    /// See [`GetPolicyVersion`](crate::client::fluent_builders::GetPolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn get_policy_version(&self) -> fluent_builders::GetPolicyVersion<C, M, R> {
        fluent_builders::GetPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegistrationCode` operation.
    ///
    /// See [`GetRegistrationCode`](crate::client::fluent_builders::GetRegistrationCode) for more information about the
    /// operation and its arguments.
    pub fn get_registration_code(&self) -> fluent_builders::GetRegistrationCode<C, M, R> {
        fluent_builders::GetRegistrationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStatistics` operation.
    ///
    /// See [`GetStatistics`](crate::client::fluent_builders::GetStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_statistics(&self) -> fluent_builders::GetStatistics<C, M, R> {
        fluent_builders::GetStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTopicRule` operation.
    ///
    /// See [`GetTopicRule`](crate::client::fluent_builders::GetTopicRule) for more information about the
    /// operation and its arguments.
    pub fn get_topic_rule(&self) -> fluent_builders::GetTopicRule<C, M, R> {
        fluent_builders::GetTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTopicRuleDestination` operation.
    ///
    /// See [`GetTopicRuleDestination`](crate::client::fluent_builders::GetTopicRuleDestination) for more information about the
    /// operation and its arguments.
    pub fn get_topic_rule_destination(&self) -> fluent_builders::GetTopicRuleDestination<C, M, R> {
        fluent_builders::GetTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetV2LoggingOptions` operation.
    ///
    /// See [`GetV2LoggingOptions`](crate::client::fluent_builders::GetV2LoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn get_v2_logging_options(&self) -> fluent_builders::GetV2LoggingOptions<C, M, R> {
        fluent_builders::GetV2LoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListActiveViolations` operation.
    ///
    /// See [`ListActiveViolations`](crate::client::fluent_builders::ListActiveViolations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListActiveViolations::into_paginator).
    pub fn list_active_violations(&self) -> fluent_builders::ListActiveViolations<C, M, R> {
        fluent_builders::ListActiveViolations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttachedPolicies` operation.
    ///
    /// See [`ListAttachedPolicies`](crate::client::fluent_builders::ListAttachedPolicies) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAttachedPolicies::into_paginator).
    pub fn list_attached_policies(&self) -> fluent_builders::ListAttachedPolicies<C, M, R> {
        fluent_builders::ListAttachedPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAuditFindings` operation.
    ///
    /// See [`ListAuditFindings`](crate::client::fluent_builders::ListAuditFindings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAuditFindings::into_paginator).
    pub fn list_audit_findings(&self) -> fluent_builders::ListAuditFindings<C, M, R> {
        fluent_builders::ListAuditFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAuditMitigationActionsExecutions` operation.
    ///
    /// See [`ListAuditMitigationActionsExecutions`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAuditMitigationActionsExecutions::into_paginator).
    pub fn list_audit_mitigation_actions_executions(
        &self,
    ) -> fluent_builders::ListAuditMitigationActionsExecutions<C, M, R> {
        fluent_builders::ListAuditMitigationActionsExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAuditMitigationActionsTasks` operation.
    ///
    /// See [`ListAuditMitigationActionsTasks`](crate::client::fluent_builders::ListAuditMitigationActionsTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAuditMitigationActionsTasks::into_paginator).
    pub fn list_audit_mitigation_actions_tasks(
        &self,
    ) -> fluent_builders::ListAuditMitigationActionsTasks<C, M, R> {
        fluent_builders::ListAuditMitigationActionsTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAuditSuppressions` operation.
    ///
    /// See [`ListAuditSuppressions`](crate::client::fluent_builders::ListAuditSuppressions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAuditSuppressions::into_paginator).
    pub fn list_audit_suppressions(&self) -> fluent_builders::ListAuditSuppressions<C, M, R> {
        fluent_builders::ListAuditSuppressions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAuditTasks` operation.
    ///
    /// See [`ListAuditTasks`](crate::client::fluent_builders::ListAuditTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAuditTasks::into_paginator).
    pub fn list_audit_tasks(&self) -> fluent_builders::ListAuditTasks<C, M, R> {
        fluent_builders::ListAuditTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAuthorizers` operation.
    ///
    /// See [`ListAuthorizers`](crate::client::fluent_builders::ListAuthorizers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAuthorizers::into_paginator).
    pub fn list_authorizers(&self) -> fluent_builders::ListAuthorizers<C, M, R> {
        fluent_builders::ListAuthorizers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBillingGroups` operation.
    ///
    /// See [`ListBillingGroups`](crate::client::fluent_builders::ListBillingGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListBillingGroups::into_paginator).
    pub fn list_billing_groups(&self) -> fluent_builders::ListBillingGroups<C, M, R> {
        fluent_builders::ListBillingGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCACertificates` operation.
    ///
    /// See [`ListCACertificates`](crate::client::fluent_builders::ListCACertificates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCACertificates::into_paginator).
    pub fn list_ca_certificates(&self) -> fluent_builders::ListCACertificates<C, M, R> {
        fluent_builders::ListCACertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCertificates` operation.
    ///
    /// See [`ListCertificates`](crate::client::fluent_builders::ListCertificates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCertificates::into_paginator).
    pub fn list_certificates(&self) -> fluent_builders::ListCertificates<C, M, R> {
        fluent_builders::ListCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCertificatesByCA` operation.
    ///
    /// See [`ListCertificatesByCA`](crate::client::fluent_builders::ListCertificatesByCA) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCertificatesByCA::into_paginator).
    pub fn list_certificates_by_ca(&self) -> fluent_builders::ListCertificatesByCA<C, M, R> {
        fluent_builders::ListCertificatesByCA::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomMetrics` operation.
    ///
    /// See [`ListCustomMetrics`](crate::client::fluent_builders::ListCustomMetrics) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCustomMetrics::into_paginator).
    pub fn list_custom_metrics(&self) -> fluent_builders::ListCustomMetrics<C, M, R> {
        fluent_builders::ListCustomMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDetectMitigationActionsExecutions` operation.
    ///
    /// See [`ListDetectMitigationActionsExecutions`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDetectMitigationActionsExecutions::into_paginator).
    pub fn list_detect_mitigation_actions_executions(
        &self,
    ) -> fluent_builders::ListDetectMitigationActionsExecutions<C, M, R> {
        fluent_builders::ListDetectMitigationActionsExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDetectMitigationActionsTasks` operation.
    ///
    /// See [`ListDetectMitigationActionsTasks`](crate::client::fluent_builders::ListDetectMitigationActionsTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDetectMitigationActionsTasks::into_paginator).
    pub fn list_detect_mitigation_actions_tasks(
        &self,
    ) -> fluent_builders::ListDetectMitigationActionsTasks<C, M, R> {
        fluent_builders::ListDetectMitigationActionsTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDimensions` operation.
    ///
    /// See [`ListDimensions`](crate::client::fluent_builders::ListDimensions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDimensions::into_paginator).
    pub fn list_dimensions(&self) -> fluent_builders::ListDimensions<C, M, R> {
        fluent_builders::ListDimensions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomainConfigurations` operation.
    ///
    /// See [`ListDomainConfigurations`](crate::client::fluent_builders::ListDomainConfigurations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDomainConfigurations::into_paginator).
    pub fn list_domain_configurations(&self) -> fluent_builders::ListDomainConfigurations<C, M, R> {
        fluent_builders::ListDomainConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFleetMetrics` operation.
    ///
    /// See [`ListFleetMetrics`](crate::client::fluent_builders::ListFleetMetrics) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFleetMetrics::into_paginator).
    pub fn list_fleet_metrics(&self) -> fluent_builders::ListFleetMetrics<C, M, R> {
        fluent_builders::ListFleetMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIndices` operation.
    ///
    /// See [`ListIndices`](crate::client::fluent_builders::ListIndices) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListIndices::into_paginator).
    pub fn list_indices(&self) -> fluent_builders::ListIndices<C, M, R> {
        fluent_builders::ListIndices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobExecutionsForJob` operation.
    ///
    /// See [`ListJobExecutionsForJob`](crate::client::fluent_builders::ListJobExecutionsForJob) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListJobExecutionsForJob::into_paginator).
    pub fn list_job_executions_for_job(&self) -> fluent_builders::ListJobExecutionsForJob<C, M, R> {
        fluent_builders::ListJobExecutionsForJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobExecutionsForThing` operation.
    ///
    /// See [`ListJobExecutionsForThing`](crate::client::fluent_builders::ListJobExecutionsForThing) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListJobExecutionsForThing::into_paginator).
    pub fn list_job_executions_for_thing(
        &self,
    ) -> fluent_builders::ListJobExecutionsForThing<C, M, R> {
        fluent_builders::ListJobExecutionsForThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListJobs::into_paginator).
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobTemplates` operation.
    ///
    /// See [`ListJobTemplates`](crate::client::fluent_builders::ListJobTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListJobTemplates::into_paginator).
    pub fn list_job_templates(&self) -> fluent_builders::ListJobTemplates<C, M, R> {
        fluent_builders::ListJobTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListManagedJobTemplates` operation.
    ///
    /// See [`ListManagedJobTemplates`](crate::client::fluent_builders::ListManagedJobTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_managed_job_templates(&self) -> fluent_builders::ListManagedJobTemplates<C, M, R> {
        fluent_builders::ListManagedJobTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMitigationActions` operation.
    ///
    /// See [`ListMitigationActions`](crate::client::fluent_builders::ListMitigationActions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListMitigationActions::into_paginator).
    pub fn list_mitigation_actions(&self) -> fluent_builders::ListMitigationActions<C, M, R> {
        fluent_builders::ListMitigationActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOTAUpdates` operation.
    ///
    /// See [`ListOTAUpdates`](crate::client::fluent_builders::ListOTAUpdates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListOTAUpdates::into_paginator).
    pub fn list_ota_updates(&self) -> fluent_builders::ListOTAUpdates<C, M, R> {
        fluent_builders::ListOTAUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOutgoingCertificates` operation.
    ///
    /// See [`ListOutgoingCertificates`](crate::client::fluent_builders::ListOutgoingCertificates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListOutgoingCertificates::into_paginator).
    pub fn list_outgoing_certificates(&self) -> fluent_builders::ListOutgoingCertificates<C, M, R> {
        fluent_builders::ListOutgoingCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicies` operation.
    ///
    /// See [`ListPolicies`](crate::client::fluent_builders::ListPolicies) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPolicies::into_paginator).
    pub fn list_policies(&self) -> fluent_builders::ListPolicies<C, M, R> {
        fluent_builders::ListPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicyPrincipals` operation.
    ///
    /// See [`ListPolicyPrincipals`](crate::client::fluent_builders::ListPolicyPrincipals) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPolicyPrincipals::into_paginator).
    pub fn list_policy_principals(&self) -> fluent_builders::ListPolicyPrincipals<C, M, R> {
        fluent_builders::ListPolicyPrincipals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicyVersions` operation.
    ///
    /// See [`ListPolicyVersions`](crate::client::fluent_builders::ListPolicyVersions) for more information about the
    /// operation and its arguments.
    pub fn list_policy_versions(&self) -> fluent_builders::ListPolicyVersions<C, M, R> {
        fluent_builders::ListPolicyVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPrincipalPolicies` operation.
    ///
    /// See [`ListPrincipalPolicies`](crate::client::fluent_builders::ListPrincipalPolicies) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPrincipalPolicies::into_paginator).
    pub fn list_principal_policies(&self) -> fluent_builders::ListPrincipalPolicies<C, M, R> {
        fluent_builders::ListPrincipalPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPrincipalThings` operation.
    ///
    /// See [`ListPrincipalThings`](crate::client::fluent_builders::ListPrincipalThings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPrincipalThings::into_paginator).
    pub fn list_principal_things(&self) -> fluent_builders::ListPrincipalThings<C, M, R> {
        fluent_builders::ListPrincipalThings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProvisioningTemplates` operation.
    ///
    /// See [`ListProvisioningTemplates`](crate::client::fluent_builders::ListProvisioningTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProvisioningTemplates::into_paginator).
    pub fn list_provisioning_templates(
        &self,
    ) -> fluent_builders::ListProvisioningTemplates<C, M, R> {
        fluent_builders::ListProvisioningTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProvisioningTemplateVersions` operation.
    ///
    /// See [`ListProvisioningTemplateVersions`](crate::client::fluent_builders::ListProvisioningTemplateVersions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProvisioningTemplateVersions::into_paginator).
    pub fn list_provisioning_template_versions(
        &self,
    ) -> fluent_builders::ListProvisioningTemplateVersions<C, M, R> {
        fluent_builders::ListProvisioningTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoleAliases` operation.
    ///
    /// See [`ListRoleAliases`](crate::client::fluent_builders::ListRoleAliases) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListRoleAliases::into_paginator).
    pub fn list_role_aliases(&self) -> fluent_builders::ListRoleAliases<C, M, R> {
        fluent_builders::ListRoleAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListScheduledAudits` operation.
    ///
    /// See [`ListScheduledAudits`](crate::client::fluent_builders::ListScheduledAudits) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListScheduledAudits::into_paginator).
    pub fn list_scheduled_audits(&self) -> fluent_builders::ListScheduledAudits<C, M, R> {
        fluent_builders::ListScheduledAudits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSecurityProfiles` operation.
    ///
    /// See [`ListSecurityProfiles`](crate::client::fluent_builders::ListSecurityProfiles) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSecurityProfiles::into_paginator).
    pub fn list_security_profiles(&self) -> fluent_builders::ListSecurityProfiles<C, M, R> {
        fluent_builders::ListSecurityProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSecurityProfilesForTarget` operation.
    ///
    /// See [`ListSecurityProfilesForTarget`](crate::client::fluent_builders::ListSecurityProfilesForTarget) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSecurityProfilesForTarget::into_paginator).
    pub fn list_security_profiles_for_target(
        &self,
    ) -> fluent_builders::ListSecurityProfilesForTarget<C, M, R> {
        fluent_builders::ListSecurityProfilesForTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreams` operation.
    ///
    /// See [`ListStreams`](crate::client::fluent_builders::ListStreams) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListStreams::into_paginator).
    pub fn list_streams(&self) -> fluent_builders::ListStreams<C, M, R> {
        fluent_builders::ListStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTargetsForPolicy` operation.
    ///
    /// See [`ListTargetsForPolicy`](crate::client::fluent_builders::ListTargetsForPolicy) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTargetsForPolicy::into_paginator).
    pub fn list_targets_for_policy(&self) -> fluent_builders::ListTargetsForPolicy<C, M, R> {
        fluent_builders::ListTargetsForPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTargetsForSecurityProfile` operation.
    ///
    /// See [`ListTargetsForSecurityProfile`](crate::client::fluent_builders::ListTargetsForSecurityProfile) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTargetsForSecurityProfile::into_paginator).
    pub fn list_targets_for_security_profile(
        &self,
    ) -> fluent_builders::ListTargetsForSecurityProfile<C, M, R> {
        fluent_builders::ListTargetsForSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingGroups` operation.
    ///
    /// See [`ListThingGroups`](crate::client::fluent_builders::ListThingGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingGroups::into_paginator).
    pub fn list_thing_groups(&self) -> fluent_builders::ListThingGroups<C, M, R> {
        fluent_builders::ListThingGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingGroupsForThing` operation.
    ///
    /// See [`ListThingGroupsForThing`](crate::client::fluent_builders::ListThingGroupsForThing) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingGroupsForThing::into_paginator).
    pub fn list_thing_groups_for_thing(&self) -> fluent_builders::ListThingGroupsForThing<C, M, R> {
        fluent_builders::ListThingGroupsForThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingPrincipals` operation.
    ///
    /// See [`ListThingPrincipals`](crate::client::fluent_builders::ListThingPrincipals) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingPrincipals::into_paginator).
    pub fn list_thing_principals(&self) -> fluent_builders::ListThingPrincipals<C, M, R> {
        fluent_builders::ListThingPrincipals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingRegistrationTaskReports` operation.
    ///
    /// See [`ListThingRegistrationTaskReports`](crate::client::fluent_builders::ListThingRegistrationTaskReports) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingRegistrationTaskReports::into_paginator).
    pub fn list_thing_registration_task_reports(
        &self,
    ) -> fluent_builders::ListThingRegistrationTaskReports<C, M, R> {
        fluent_builders::ListThingRegistrationTaskReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingRegistrationTasks` operation.
    ///
    /// See [`ListThingRegistrationTasks`](crate::client::fluent_builders::ListThingRegistrationTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingRegistrationTasks::into_paginator).
    pub fn list_thing_registration_tasks(
        &self,
    ) -> fluent_builders::ListThingRegistrationTasks<C, M, R> {
        fluent_builders::ListThingRegistrationTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThings` operation.
    ///
    /// See [`ListThings`](crate::client::fluent_builders::ListThings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThings::into_paginator).
    pub fn list_things(&self) -> fluent_builders::ListThings<C, M, R> {
        fluent_builders::ListThings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingsInBillingGroup` operation.
    ///
    /// See [`ListThingsInBillingGroup`](crate::client::fluent_builders::ListThingsInBillingGroup) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingsInBillingGroup::into_paginator).
    pub fn list_things_in_billing_group(
        &self,
    ) -> fluent_builders::ListThingsInBillingGroup<C, M, R> {
        fluent_builders::ListThingsInBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingsInThingGroup` operation.
    ///
    /// See [`ListThingsInThingGroup`](crate::client::fluent_builders::ListThingsInThingGroup) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingsInThingGroup::into_paginator).
    pub fn list_things_in_thing_group(&self) -> fluent_builders::ListThingsInThingGroup<C, M, R> {
        fluent_builders::ListThingsInThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThingTypes` operation.
    ///
    /// See [`ListThingTypes`](crate::client::fluent_builders::ListThingTypes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListThingTypes::into_paginator).
    pub fn list_thing_types(&self) -> fluent_builders::ListThingTypes<C, M, R> {
        fluent_builders::ListThingTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTopicRuleDestinations` operation.
    ///
    /// See [`ListTopicRuleDestinations`](crate::client::fluent_builders::ListTopicRuleDestinations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTopicRuleDestinations::into_paginator).
    pub fn list_topic_rule_destinations(
        &self,
    ) -> fluent_builders::ListTopicRuleDestinations<C, M, R> {
        fluent_builders::ListTopicRuleDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTopicRules` operation.
    ///
    /// See [`ListTopicRules`](crate::client::fluent_builders::ListTopicRules) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTopicRules::into_paginator).
    pub fn list_topic_rules(&self) -> fluent_builders::ListTopicRules<C, M, R> {
        fluent_builders::ListTopicRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListV2LoggingLevels` operation.
    ///
    /// See [`ListV2LoggingLevels`](crate::client::fluent_builders::ListV2LoggingLevels) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListV2LoggingLevels::into_paginator).
    pub fn list_v2_logging_levels(&self) -> fluent_builders::ListV2LoggingLevels<C, M, R> {
        fluent_builders::ListV2LoggingLevels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListViolationEvents` operation.
    ///
    /// See [`ListViolationEvents`](crate::client::fluent_builders::ListViolationEvents) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListViolationEvents::into_paginator).
    pub fn list_violation_events(&self) -> fluent_builders::ListViolationEvents<C, M, R> {
        fluent_builders::ListViolationEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutVerificationStateOnViolation` operation.
    ///
    /// See [`PutVerificationStateOnViolation`](crate::client::fluent_builders::PutVerificationStateOnViolation) for more information about the
    /// operation and its arguments.
    pub fn put_verification_state_on_violation(
        &self,
    ) -> fluent_builders::PutVerificationStateOnViolation<C, M, R> {
        fluent_builders::PutVerificationStateOnViolation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterCACertificate` operation.
    ///
    /// See [`RegisterCACertificate`](crate::client::fluent_builders::RegisterCACertificate) for more information about the
    /// operation and its arguments.
    pub fn register_ca_certificate(&self) -> fluent_builders::RegisterCACertificate<C, M, R> {
        fluent_builders::RegisterCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterCertificate` operation.
    ///
    /// See [`RegisterCertificate`](crate::client::fluent_builders::RegisterCertificate) for more information about the
    /// operation and its arguments.
    pub fn register_certificate(&self) -> fluent_builders::RegisterCertificate<C, M, R> {
        fluent_builders::RegisterCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterCertificateWithoutCA` operation.
    ///
    /// See [`RegisterCertificateWithoutCA`](crate::client::fluent_builders::RegisterCertificateWithoutCA) for more information about the
    /// operation and its arguments.
    pub fn register_certificate_without_ca(
        &self,
    ) -> fluent_builders::RegisterCertificateWithoutCA<C, M, R> {
        fluent_builders::RegisterCertificateWithoutCA::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterThing` operation.
    ///
    /// See [`RegisterThing`](crate::client::fluent_builders::RegisterThing) for more information about the
    /// operation and its arguments.
    pub fn register_thing(&self) -> fluent_builders::RegisterThing<C, M, R> {
        fluent_builders::RegisterThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectCertificateTransfer` operation.
    ///
    /// See [`RejectCertificateTransfer`](crate::client::fluent_builders::RejectCertificateTransfer) for more information about the
    /// operation and its arguments.
    pub fn reject_certificate_transfer(
        &self,
    ) -> fluent_builders::RejectCertificateTransfer<C, M, R> {
        fluent_builders::RejectCertificateTransfer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveThingFromBillingGroup` operation.
    ///
    /// See [`RemoveThingFromBillingGroup`](crate::client::fluent_builders::RemoveThingFromBillingGroup) for more information about the
    /// operation and its arguments.
    pub fn remove_thing_from_billing_group(
        &self,
    ) -> fluent_builders::RemoveThingFromBillingGroup<C, M, R> {
        fluent_builders::RemoveThingFromBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveThingFromThingGroup` operation.
    ///
    /// See [`RemoveThingFromThingGroup`](crate::client::fluent_builders::RemoveThingFromThingGroup) for more information about the
    /// operation and its arguments.
    pub fn remove_thing_from_thing_group(
        &self,
    ) -> fluent_builders::RemoveThingFromThingGroup<C, M, R> {
        fluent_builders::RemoveThingFromThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplaceTopicRule` operation.
    ///
    /// See [`ReplaceTopicRule`](crate::client::fluent_builders::ReplaceTopicRule) for more information about the
    /// operation and its arguments.
    pub fn replace_topic_rule(&self) -> fluent_builders::ReplaceTopicRule<C, M, R> {
        fluent_builders::ReplaceTopicRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchIndex` operation.
    ///
    /// See [`SearchIndex`](crate::client::fluent_builders::SearchIndex) for more information about the
    /// operation and its arguments.
    pub fn search_index(&self) -> fluent_builders::SearchIndex<C, M, R> {
        fluent_builders::SearchIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetDefaultAuthorizer` operation.
    ///
    /// See [`SetDefaultAuthorizer`](crate::client::fluent_builders::SetDefaultAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn set_default_authorizer(&self) -> fluent_builders::SetDefaultAuthorizer<C, M, R> {
        fluent_builders::SetDefaultAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetDefaultPolicyVersion` operation.
    ///
    /// See [`SetDefaultPolicyVersion`](crate::client::fluent_builders::SetDefaultPolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn set_default_policy_version(&self) -> fluent_builders::SetDefaultPolicyVersion<C, M, R> {
        fluent_builders::SetDefaultPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetLoggingOptions` operation.
    ///
    /// See [`SetLoggingOptions`](crate::client::fluent_builders::SetLoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn set_logging_options(&self) -> fluent_builders::SetLoggingOptions<C, M, R> {
        fluent_builders::SetLoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetV2LoggingLevel` operation.
    ///
    /// See [`SetV2LoggingLevel`](crate::client::fluent_builders::SetV2LoggingLevel) for more information about the
    /// operation and its arguments.
    pub fn set_v2_logging_level(&self) -> fluent_builders::SetV2LoggingLevel<C, M, R> {
        fluent_builders::SetV2LoggingLevel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetV2LoggingOptions` operation.
    ///
    /// See [`SetV2LoggingOptions`](crate::client::fluent_builders::SetV2LoggingOptions) for more information about the
    /// operation and its arguments.
    pub fn set_v2_logging_options(&self) -> fluent_builders::SetV2LoggingOptions<C, M, R> {
        fluent_builders::SetV2LoggingOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAuditMitigationActionsTask` operation.
    ///
    /// See [`StartAuditMitigationActionsTask`](crate::client::fluent_builders::StartAuditMitigationActionsTask) for more information about the
    /// operation and its arguments.
    pub fn start_audit_mitigation_actions_task(
        &self,
    ) -> fluent_builders::StartAuditMitigationActionsTask<C, M, R> {
        fluent_builders::StartAuditMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDetectMitigationActionsTask` operation.
    ///
    /// See [`StartDetectMitigationActionsTask`](crate::client::fluent_builders::StartDetectMitigationActionsTask) for more information about the
    /// operation and its arguments.
    pub fn start_detect_mitigation_actions_task(
        &self,
    ) -> fluent_builders::StartDetectMitigationActionsTask<C, M, R> {
        fluent_builders::StartDetectMitigationActionsTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartOnDemandAuditTask` operation.
    ///
    /// See [`StartOnDemandAuditTask`](crate::client::fluent_builders::StartOnDemandAuditTask) for more information about the
    /// operation and its arguments.
    pub fn start_on_demand_audit_task(&self) -> fluent_builders::StartOnDemandAuditTask<C, M, R> {
        fluent_builders::StartOnDemandAuditTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartThingRegistrationTask` operation.
    ///
    /// See [`StartThingRegistrationTask`](crate::client::fluent_builders::StartThingRegistrationTask) for more information about the
    /// operation and its arguments.
    pub fn start_thing_registration_task(
        &self,
    ) -> fluent_builders::StartThingRegistrationTask<C, M, R> {
        fluent_builders::StartThingRegistrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopThingRegistrationTask` operation.
    ///
    /// See [`StopThingRegistrationTask`](crate::client::fluent_builders::StopThingRegistrationTask) for more information about the
    /// operation and its arguments.
    pub fn stop_thing_registration_task(
        &self,
    ) -> fluent_builders::StopThingRegistrationTask<C, M, R> {
        fluent_builders::StopThingRegistrationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestAuthorization` operation.
    ///
    /// See [`TestAuthorization`](crate::client::fluent_builders::TestAuthorization) for more information about the
    /// operation and its arguments.
    pub fn test_authorization(&self) -> fluent_builders::TestAuthorization<C, M, R> {
        fluent_builders::TestAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestInvokeAuthorizer` operation.
    ///
    /// See [`TestInvokeAuthorizer`](crate::client::fluent_builders::TestInvokeAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn test_invoke_authorizer(&self) -> fluent_builders::TestInvokeAuthorizer<C, M, R> {
        fluent_builders::TestInvokeAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TransferCertificate` operation.
    ///
    /// See [`TransferCertificate`](crate::client::fluent_builders::TransferCertificate) for more information about the
    /// operation and its arguments.
    pub fn transfer_certificate(&self) -> fluent_builders::TransferCertificate<C, M, R> {
        fluent_builders::TransferCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccountAuditConfiguration` operation.
    ///
    /// See [`UpdateAccountAuditConfiguration`](crate::client::fluent_builders::UpdateAccountAuditConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_account_audit_configuration(
        &self,
    ) -> fluent_builders::UpdateAccountAuditConfiguration<C, M, R> {
        fluent_builders::UpdateAccountAuditConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAuditSuppression` operation.
    ///
    /// See [`UpdateAuditSuppression`](crate::client::fluent_builders::UpdateAuditSuppression) for more information about the
    /// operation and its arguments.
    pub fn update_audit_suppression(&self) -> fluent_builders::UpdateAuditSuppression<C, M, R> {
        fluent_builders::UpdateAuditSuppression::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAuthorizer` operation.
    ///
    /// See [`UpdateAuthorizer`](crate::client::fluent_builders::UpdateAuthorizer) for more information about the
    /// operation and its arguments.
    pub fn update_authorizer(&self) -> fluent_builders::UpdateAuthorizer<C, M, R> {
        fluent_builders::UpdateAuthorizer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBillingGroup` operation.
    ///
    /// See [`UpdateBillingGroup`](crate::client::fluent_builders::UpdateBillingGroup) for more information about the
    /// operation and its arguments.
    pub fn update_billing_group(&self) -> fluent_builders::UpdateBillingGroup<C, M, R> {
        fluent_builders::UpdateBillingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCACertificate` operation.
    ///
    /// See [`UpdateCACertificate`](crate::client::fluent_builders::UpdateCACertificate) for more information about the
    /// operation and its arguments.
    pub fn update_ca_certificate(&self) -> fluent_builders::UpdateCACertificate<C, M, R> {
        fluent_builders::UpdateCACertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCertificate` operation.
    ///
    /// See [`UpdateCertificate`](crate::client::fluent_builders::UpdateCertificate) for more information about the
    /// operation and its arguments.
    pub fn update_certificate(&self) -> fluent_builders::UpdateCertificate<C, M, R> {
        fluent_builders::UpdateCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCustomMetric` operation.
    ///
    /// See [`UpdateCustomMetric`](crate::client::fluent_builders::UpdateCustomMetric) for more information about the
    /// operation and its arguments.
    pub fn update_custom_metric(&self) -> fluent_builders::UpdateCustomMetric<C, M, R> {
        fluent_builders::UpdateCustomMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDimension` operation.
    ///
    /// See [`UpdateDimension`](crate::client::fluent_builders::UpdateDimension) for more information about the
    /// operation and its arguments.
    pub fn update_dimension(&self) -> fluent_builders::UpdateDimension<C, M, R> {
        fluent_builders::UpdateDimension::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainConfiguration` operation.
    ///
    /// See [`UpdateDomainConfiguration`](crate::client::fluent_builders::UpdateDomainConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_domain_configuration(
        &self,
    ) -> fluent_builders::UpdateDomainConfiguration<C, M, R> {
        fluent_builders::UpdateDomainConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDynamicThingGroup` operation.
    ///
    /// See [`UpdateDynamicThingGroup`](crate::client::fluent_builders::UpdateDynamicThingGroup) for more information about the
    /// operation and its arguments.
    pub fn update_dynamic_thing_group(&self) -> fluent_builders::UpdateDynamicThingGroup<C, M, R> {
        fluent_builders::UpdateDynamicThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEventConfigurations` operation.
    ///
    /// See [`UpdateEventConfigurations`](crate::client::fluent_builders::UpdateEventConfigurations) for more information about the
    /// operation and its arguments.
    pub fn update_event_configurations(
        &self,
    ) -> fluent_builders::UpdateEventConfigurations<C, M, R> {
        fluent_builders::UpdateEventConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFleetMetric` operation.
    ///
    /// See [`UpdateFleetMetric`](crate::client::fluent_builders::UpdateFleetMetric) for more information about the
    /// operation and its arguments.
    pub fn update_fleet_metric(&self) -> fluent_builders::UpdateFleetMetric<C, M, R> {
        fluent_builders::UpdateFleetMetric::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIndexingConfiguration` operation.
    ///
    /// See [`UpdateIndexingConfiguration`](crate::client::fluent_builders::UpdateIndexingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_indexing_configuration(
        &self,
    ) -> fluent_builders::UpdateIndexingConfiguration<C, M, R> {
        fluent_builders::UpdateIndexingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateJob` operation.
    ///
    /// See [`UpdateJob`](crate::client::fluent_builders::UpdateJob) for more information about the
    /// operation and its arguments.
    pub fn update_job(&self) -> fluent_builders::UpdateJob<C, M, R> {
        fluent_builders::UpdateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMitigationAction` operation.
    ///
    /// See [`UpdateMitigationAction`](crate::client::fluent_builders::UpdateMitigationAction) for more information about the
    /// operation and its arguments.
    pub fn update_mitigation_action(&self) -> fluent_builders::UpdateMitigationAction<C, M, R> {
        fluent_builders::UpdateMitigationAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProvisioningTemplate` operation.
    ///
    /// See [`UpdateProvisioningTemplate`](crate::client::fluent_builders::UpdateProvisioningTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_provisioning_template(
        &self,
    ) -> fluent_builders::UpdateProvisioningTemplate<C, M, R> {
        fluent_builders::UpdateProvisioningTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoleAlias` operation.
    ///
    /// See [`UpdateRoleAlias`](crate::client::fluent_builders::UpdateRoleAlias) for more information about the
    /// operation and its arguments.
    pub fn update_role_alias(&self) -> fluent_builders::UpdateRoleAlias<C, M, R> {
        fluent_builders::UpdateRoleAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateScheduledAudit` operation.
    ///
    /// See [`UpdateScheduledAudit`](crate::client::fluent_builders::UpdateScheduledAudit) for more information about the
    /// operation and its arguments.
    pub fn update_scheduled_audit(&self) -> fluent_builders::UpdateScheduledAudit<C, M, R> {
        fluent_builders::UpdateScheduledAudit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSecurityProfile` operation.
    ///
    /// See [`UpdateSecurityProfile`](crate::client::fluent_builders::UpdateSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn update_security_profile(&self) -> fluent_builders::UpdateSecurityProfile<C, M, R> {
        fluent_builders::UpdateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStream` operation.
    ///
    /// See [`UpdateStream`](crate::client::fluent_builders::UpdateStream) for more information about the
    /// operation and its arguments.
    pub fn update_stream(&self) -> fluent_builders::UpdateStream<C, M, R> {
        fluent_builders::UpdateStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThing` operation.
    ///
    /// See [`UpdateThing`](crate::client::fluent_builders::UpdateThing) for more information about the
    /// operation and its arguments.
    pub fn update_thing(&self) -> fluent_builders::UpdateThing<C, M, R> {
        fluent_builders::UpdateThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThingGroup` operation.
    ///
    /// See [`UpdateThingGroup`](crate::client::fluent_builders::UpdateThingGroup) for more information about the
    /// operation and its arguments.
    pub fn update_thing_group(&self) -> fluent_builders::UpdateThingGroup<C, M, R> {
        fluent_builders::UpdateThingGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThingGroupsForThing` operation.
    ///
    /// See [`UpdateThingGroupsForThing`](crate::client::fluent_builders::UpdateThingGroupsForThing) for more information about the
    /// operation and its arguments.
    pub fn update_thing_groups_for_thing(
        &self,
    ) -> fluent_builders::UpdateThingGroupsForThing<C, M, R> {
        fluent_builders::UpdateThingGroupsForThing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTopicRuleDestination` operation.
    ///
    /// See [`UpdateTopicRuleDestination`](crate::client::fluent_builders::UpdateTopicRuleDestination) for more information about the
    /// operation and its arguments.
    pub fn update_topic_rule_destination(
        &self,
    ) -> fluent_builders::UpdateTopicRuleDestination<C, M, R> {
        fluent_builders::UpdateTopicRuleDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ValidateSecurityProfileBehaviors` operation.
    ///
    /// See [`ValidateSecurityProfileBehaviors`](crate::client::fluent_builders::ValidateSecurityProfileBehaviors) for more information about the
    /// operation and its arguments.
    pub fn validate_security_profile_behaviors(
        &self,
    ) -> fluent_builders::ValidateSecurityProfileBehaviors<C, M, R> {
        fluent_builders::ValidateSecurityProfileBehaviors::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptCertificateTransfer`.
    ///
    /// <p>Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.</p>
    /// <p>To check for pending certificate transfers, call <code>ListCertificates</code> to enumerate your certificates.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AcceptCertificateTransfer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptCertificateTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_certificate_transfer_input::Builder,
    }
    impl<C, M, R> AcceptCertificateTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptCertificateTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptCertificateTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptCertificateTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptCertificateTransferInputOperationOutputAlias,
                crate::output::AcceptCertificateTransferOutput,
                crate::error::AcceptCertificateTransferError,
                crate::input::AcceptCertificateTransferInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddThingToBillingGroup`.
    ///
    /// <p>Adds a thing to a billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddThingToBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_thing_to_billing_group_input::Builder,
    }
    impl<C, M, R> AddThingToBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddThingToBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddThingToBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AddThingToBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddThingToBillingGroupInputOperationOutputAlias,
                crate::output::AddThingToBillingGroupOutput,
                crate::error::AddThingToBillingGroupError,
                crate::input::AddThingToBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the billing group.</p> <note>
        /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
        /// </note>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group.</p> <note>
        /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
        /// </note>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_arn(input.into());
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_arn(input);
            self
        }
        /// <p>The name of the thing to be added to the billing group.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to be added to the billing group.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ARN of the thing to be added to the billing group.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(input.into());
            self
        }
        /// <p>The ARN of the thing to be added to the billing group.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddThingToThingGroup`.
    ///
    /// <p>Adds a thing to a thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AddThingToThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddThingToThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_thing_to_thing_group_input::Builder,
    }
    impl<C, M, R> AddThingToThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddThingToThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddThingToThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AddThingToThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddThingToThingGroupInputOperationOutputAlias,
                crate::output::AddThingToThingGroupOutput,
                crate::error::AddThingToThingGroupError,
                crate::input::AddThingToThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group to which you are adding a thing.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the group to which you are adding a thing.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The ARN of the group to which you are adding a thing.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_arn(input.into());
            self
        }
        /// <p>The ARN of the group to which you are adding a thing.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_arn(input);
            self
        }
        /// <p>The name of the thing to add to a group.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to add to a group.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ARN of the thing to add to a group.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_arn(input.into());
            self
        }
        /// <p>The ARN of the thing to add to a group.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_arn(input);
            self
        }
        /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
        pub fn override_dynamic_groups(mut self, input: bool) -> Self {
            self.inner = self.inner.override_dynamic_groups(input);
            self
        }
        /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
        pub fn set_override_dynamic_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_override_dynamic_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTargetsWithJob`.
    ///
    /// <p>Associates a group with a continuous job. The following criteria must be met: </p>
    /// <ul>
    /// <li> <p>The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".</p> </li>
    /// <li> <p>The job status must currently be "IN_PROGRESS".</p> </li>
    /// <li> <p>The total number of targets associated with a job must not exceed 100.</p> </li>
    /// </ul>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AssociateTargetsWithJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTargetsWithJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_targets_with_job_input::Builder,
    }
    impl<C, M, R> AssociateTargetsWithJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTargetsWithJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTargetsWithJobOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTargetsWithJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTargetsWithJobInputOperationOutputAlias,
                crate::output::AssociateTargetsWithJobOutput,
                crate::error::AssociateTargetsWithJobError,
                crate::input::AssociateTargetsWithJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of thing group ARNs that define the targets of the job.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.targets(input.into());
            self
        }
        /// <p>A list of thing group ARNs that define the targets of the job.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>An optional comment string describing why the job was associated with the targets.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment string describing why the job was associated with the targets.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPolicy`.
    ///
    /// <p>Attaches the specified policy to the specified principal (certificate or other credential).</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_policy_input::Builder,
    }
    impl<C, M, R> AttachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachPolicyInputOperationOutputAlias,
                crate::output::AttachPolicyOutput,
                crate::error::AttachPolicyError,
                crate::input::AttachPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy to attach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to attach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachPrincipalPolicy`.
    ///
    /// <p>Attaches the specified policy to the specified principal (certificate or other credential).</p>
    /// <p> <b>Note:</b> This action is deprecated. Please use <code>AttachPolicy</code> instead.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachPrincipalPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachPrincipalPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_principal_policy_input::Builder,
    }
    impl<C, M, R> AttachPrincipalPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachPrincipalPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachPrincipalPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachPrincipalPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachPrincipalPolicyInputOperationOutputAlias,
                crate::output::AttachPrincipalPolicyOutput,
                crate::error::AttachPrincipalPolicyError,
                crate::input::AttachPrincipalPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachSecurityProfile`.
    ///
    /// <p>Associates a Device Defender security profile with a thing group or this account. Each thing group or account can have up to five security profiles associated with it.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_security_profile_input::Builder,
    }
    impl<C, M, R> AttachSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachSecurityProfileInputOperationOutputAlias,
                crate::output::AttachSecurityProfileOutput,
                crate::error::AttachSecurityProfileError,
                crate::input::AttachSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The security profile that is attached.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The security profile that is attached.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The ARN of the target (thing group) to which the security profile is attached.</p>
        pub fn security_profile_target_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.security_profile_target_arn(input.into());
            self
        }
        /// <p>The ARN of the target (thing group) to which the security profile is attached.</p>
        pub fn set_security_profile_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachThingPrincipal`.
    ///
    /// <p>Attaches the specified principal to the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">AttachThingPrincipal</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachThingPrincipal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_thing_principal_input::Builder,
    }
    impl<C, M, R> AttachThingPrincipal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachThingPrincipal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachThingPrincipalOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachThingPrincipalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachThingPrincipalInputOperationOutputAlias,
                crate::output::AttachThingPrincipalOutput,
                crate::error::AttachThingPrincipalError,
                crate::input::AttachThingPrincipalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelAuditMitigationActionsTask`.
    ///
    /// <p>Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException occurs.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditMitigationActionsTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelAuditMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_audit_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> CancelAuditMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelAuditMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelAuditMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelAuditMitigationActionsTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelAuditMitigationActionsTaskInputOperationOutputAlias,
                crate::output::CancelAuditMitigationActionsTaskOutput,
                crate::error::CancelAuditMitigationActionsTaskError,
                crate::input::CancelAuditMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the task that you want to cancel. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The unique identifier for the task that you want to cancel. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelAuditTask`.
    ///
    /// <p>Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in progress, an "InvalidRequestException" occurs.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelAuditTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelAuditTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_audit_task_input::Builder,
    }
    impl<C, M, R> CancelAuditTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelAuditTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelAuditTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelAuditTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelAuditTaskInputOperationOutputAlias,
                crate::output::CancelAuditTaskOutput,
                crate::error::CancelAuditTaskError,
                crate::input::CancelAuditTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelCertificateTransfer`.
    ///
    /// <p>Cancels a pending transfer for the specified certificate.</p>
    /// <p> <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations can use <code>RejectCertificateTransfer</code> instead.) After transfer, IoT returns the certificate to the source account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be cancelled.</p>
    /// <p>After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to INACTIVE.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelCertificateTransfer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelCertificateTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_certificate_transfer_input::Builder,
    }
    impl<C, M, R> CancelCertificateTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelCertificateTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelCertificateTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelCertificateTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelCertificateTransferInputOperationOutputAlias,
                crate::output::CancelCertificateTransferOutput,
                crate::error::CancelCertificateTransferError,
                crate::input::CancelCertificateTransferInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelDetectMitigationActionsTask`.
    ///
    /// <p> Cancels a Device Defender ML Detect mitigation action. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelDetectMitigationActionsTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelDetectMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_detect_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> CancelDetectMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelDetectMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelDetectMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelDetectMitigationActionsTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelDetectMitigationActionsTaskInputOperationOutputAlias,
                crate::output::CancelDetectMitigationActionsTaskOutput,
                crate::error::CancelDetectMitigationActionsTaskError,
                crate::input::CancelDetectMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// <p>Cancels a job.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl<C, M, R> CancelJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobInputOperationOutputAlias,
                crate::output::CancelJobOutput,
                crate::error::CancelJobError,
                crate::input::CancelJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>(Optional)A reason code string that explains why the job was canceled.</p>
        pub fn reason_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason_code(input.into());
            self
        }
        /// <p>(Optional)A reason code string that explains why the job was canceled.</p>
        pub fn set_reason_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason_code(input);
            self
        }
        /// <p>An optional comment string describing why the job was canceled.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>An optional comment string describing why the job was canceled.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
        /// <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
        /// <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelJobExecution`.
    ///
    /// <p>Cancels the execution of a job for a given thing.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CancelJobExecution</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJobExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_execution_input::Builder,
    }
    impl<C, M, R> CancelJobExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJobExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobExecutionInputOperationOutputAlias,
                crate::output::CancelJobExecutionOutput,
                crate::error::CancelJobExecutionError,
                crate::input::CancelJobExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job to be canceled.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job to be canceled.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The name of the thing whose execution of the job will be canceled.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing whose execution of the job will be canceled.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p>
        /// <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p>
        /// <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
        /// Adds a key-value pair to `statusDetails`.
        ///
        /// To override the contents of this collection use [`set_status_details`](Self::set_status_details).
        ///
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
        pub fn status_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.status_details(k.into(), v.into());
            self
        }
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_status_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ClearDefaultAuthorizer`.
    ///
    /// <p>Clears the default authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ClearDefaultAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ClearDefaultAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::clear_default_authorizer_input::Builder,
    }
    impl<C, M, R> ClearDefaultAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ClearDefaultAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ClearDefaultAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::ClearDefaultAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ClearDefaultAuthorizerInputOperationOutputAlias,
                crate::output::ClearDefaultAuthorizerOutput,
                crate::error::ClearDefaultAuthorizerError,
                crate::input::ClearDefaultAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ConfirmTopicRuleDestination`.
    ///
    /// <p>Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation message to the endpoint or base address you specify. The message includes a token which you pass back when calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ConfirmTopicRuleDestination</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmTopicRuleDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_topic_rule_destination_input::Builder,
    }
    impl<C, M, R> ConfirmTopicRuleDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmTopicRuleDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmTopicRuleDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmTopicRuleDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmTopicRuleDestinationInputOperationOutputAlias,
                crate::output::ConfirmTopicRuleDestinationOutput,
                crate::error::ConfirmTopicRuleDestinationError,
                crate::input::ConfirmTopicRuleDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
        pub fn confirmation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.confirmation_token(input.into());
            self
        }
        /// <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
        pub fn set_confirmation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_confirmation_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuditSuppression`.
    ///
    /// <p> Creates a Device Defender audit suppression. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuditSuppression</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuditSuppression<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_audit_suppression_input::Builder,
    }
    impl<C, M, R> CreateAuditSuppression<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuditSuppression`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuditSuppressionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuditSuppressionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuditSuppressionInputOperationOutputAlias,
                crate::output::CreateAuditSuppressionOutput,
                crate::error::CreateAuditSuppressionError,
                crate::input::CreateAuditSuppressionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expiration_date(input);
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expiration_date(input);
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn suppress_indefinitely(mut self, input: bool) -> Self {
            self.inner = self.inner.suppress_indefinitely(input);
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn set_suppress_indefinitely(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_suppress_indefinitely(input);
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> Each audit supression must have a unique client request token. If you try to create a new audit suppression with the same token as one that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p> Each audit supression must have a unique client request token. If you try to create a new audit suppression with the same token as one that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthorizer`.
    ///
    /// <p>Creates an authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_authorizer_input::Builder,
    }
    impl<C, M, R> CreateAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuthorizerInputOperationOutputAlias,
                crate::output::CreateAuthorizerOutput,
                crate::error::CreateAuthorizerError,
                crate::input::CreateAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The authorizer name.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_name(input.into());
            self
        }
        /// <p>The authorizer name.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_name(input);
            self
        }
        /// <p>The ARN of the authorizer's Lambda function.</p>
        pub fn authorizer_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_function_arn(input.into());
            self
        }
        /// <p>The ARN of the authorizer's Lambda function.</p>
        pub fn set_authorizer_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_function_arn(input);
            self
        }
        /// <p>The name of the token key used to extract the token from the HTTP headers.</p>
        pub fn token_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_key_name(input.into());
            self
        }
        /// <p>The name of the token key used to extract the token from the HTTP headers.</p>
        pub fn set_token_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_token_key_name(input);
            self
        }
        /// Adds a key-value pair to `tokenSigningPublicKeys`.
        ///
        /// To override the contents of this collection use [`set_token_signing_public_keys`](Self::set_token_signing_public_keys).
        ///
        /// <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
        pub fn token_signing_public_keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.token_signing_public_keys(k.into(), v.into());
            self
        }
        /// <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
        pub fn set_token_signing_public_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_token_signing_public_keys(input);
            self
        }
        /// <p>The status of the create authorizer request.</p>
        pub fn status(mut self, input: crate::model::AuthorizerStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the create authorizer request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuthorizerStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the custom authorizer.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the custom authorizer.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether IoT validates the token signature in an authorization request.</p>
        pub fn signing_disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.signing_disabled(input);
            self
        }
        /// <p>Specifies whether IoT validates the token signature in an authorization request.</p>
        pub fn set_signing_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_signing_disabled(input);
            self
        }
        /// <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT connections.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn enable_caching_for_http(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_caching_for_http(input);
            self
        }
        /// <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT connections.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_enable_caching_for_http(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_caching_for_http(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBillingGroup`.
    ///
    /// <p>Creates a billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_billing_group_input::Builder,
    }
    impl<C, M, R> CreateBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBillingGroupInputOperationOutputAlias,
                crate::output::CreateBillingGroupOutput,
                crate::error::CreateBillingGroupError,
                crate::input::CreateBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name you wish to give to the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name you wish to give to the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn billing_group_properties(
            mut self,
            input: crate::model::BillingGroupProperties,
        ) -> Self {
            self.inner = self.inner.billing_group_properties(input);
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn set_billing_group_properties(
            mut self,
            input: std::option::Option<crate::model::BillingGroupProperties>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_properties(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the billing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the billing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCertificateFromCsr`.
    ///
    /// <p>Creates an X.509 certificate using the specified certificate signing request.</p>
    /// <p> <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key from NIST P-256, NIST P-384, or NIST P-512 curves. For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms"> Certificate signing algorithms supported by IoT</a>.</p>
    /// <p> <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCertificateFromCsr</a> action.</p>
    /// <p>You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that directory, and then specifying that directory on the command line. The following commands show how to create a batch of certificates given a batch of CSRs.</p>
    /// <p>Assuming a set of CSRs are located inside of the directory my-csr-directory:</p>
    /// <p>On Linux and OS X, the command is:</p>
    /// <p>$ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p>
    /// <p>This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot create-certificate-from-csr Amazon Web Services CLI command to create a certificate for the corresponding CSR.</p>
    /// <p>The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the certificate creation process:</p>
    /// <p>$ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p>
    /// <p>On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:</p>
    /// <p>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/$_}</p>
    /// <p>On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:</p>
    /// <p>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCertificateFromCsr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_certificate_from_csr_input::Builder,
    }
    impl<C, M, R> CreateCertificateFromCsr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCertificateFromCsr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCertificateFromCsrOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCertificateFromCsrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCertificateFromCsrInputOperationOutputAlias,
                crate::output::CreateCertificateFromCsrOutput,
                crate::error::CreateCertificateFromCsrError,
                crate::input::CreateCertificateFromCsrInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The certificate signing request (CSR).</p>
        pub fn certificate_signing_request(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.certificate_signing_request(input.into());
            self
        }
        /// <p>The certificate signing request (CSR).</p>
        pub fn set_certificate_signing_request(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_signing_request(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomMetric`.
    ///
    /// <p> Use this API to define a Custom Metric published by your devices to Device Defender. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateCustomMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_metric_input::Builder,
    }
    impl<C, M, R> CreateCustomMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomMetricInputOperationOutputAlias,
                crate::output::CreateCustomMetricOutput,
                crate::error::CreateCustomMetricError,
                crate::input::CreateCustomMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. Shouldn't begin with <code>aws:</code>. Cannot be updated once defined.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p> Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated once defined.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p> Field represents a friendly name in the console for the custom metric; it doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. Can be updated once defined.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn metric_type(mut self, input: crate::model::CustomMetricType) -> Self {
            self.inner = self.inner.metric_type(input);
            self
        }
        /// <p> The type of the custom metric. Types include <code>string-list</code>, <code>ip-address-list</code>, <code>number-list</code>, and <code>number</code>. </p>
        pub fn set_metric_type(
            mut self,
            input: std::option::Option<crate::model::CustomMetricType>,
        ) -> Self {
            self.inner = self.inner.set_metric_type(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> Metadata that can be used to manage the custom metric. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> Metadata that can be used to manage the custom metric. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDimension`.
    ///
    /// <p>Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDimension</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDimension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dimension_input::Builder,
    }
    impl<C, M, R> CreateDimension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDimension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDimensionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDimensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDimensionInputOperationOutputAlias,
                crate::output::CreateDimensionOutput,
                crate::error::CreateDimensionError,
                crate::input::CreateDimensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
        pub fn r#type(mut self, input: crate::model::DimensionType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::DimensionType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `stringValues`.
        ///
        /// To override the contents of this collection use [`set_string_values`](Self::set_string_values).
        ///
        /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
        pub fn string_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.string_values(input.into());
            self
        }
        /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
        pub fn set_string_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_string_values(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the dimension.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the dimension.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainConfiguration`.
    ///
    /// <p>Creates a domain configuration.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDomainConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomainConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_configuration_input::Builder,
    }
    impl<C, M, R> CreateDomainConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomainConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainConfigurationInputOperationOutputAlias,
                crate::output::CreateDomainConfigurationOutput,
                crate::error::CreateDomainConfigurationError,
                crate::input::CreateDomainConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_configuration_name(input.into());
            self
        }
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_configuration_name(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `serverCertificateArns`.
        ///
        /// To override the contents of this collection use [`set_server_certificate_arns`](Self::set_server_certificate_arns).
        ///
        /// <p>The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn server_certificate_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_arns(input.into());
            self
        }
        /// <p>The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn set_server_certificate_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_arns(input);
            self
        }
        /// <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn validation_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.validation_certificate_arn(input.into());
            self
        }
        /// <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn set_validation_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_validation_certificate_arn(input);
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn authorizer_config(mut self, input: crate::model::AuthorizerConfig) -> Self {
            self.inner = self.inner.authorizer_config(input);
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn set_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::AuthorizerConfig>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_config(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p> <note>
        /// <p>Amazon Web Services IoT Core currently supports only the <code>DATA</code> service type.</p>
        /// </note>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.inner = self.inner.service_type(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p> <note>
        /// <p>Amazon Web Services IoT Core currently supports only the <code>DATA</code> service type.</p>
        /// </note>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the domain configuration.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the domain configuration.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDynamicThingGroup`.
    ///
    /// <p>Creates a dynamic thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateDynamicThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDynamicThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dynamic_thing_group_input::Builder,
    }
    impl<C, M, R> CreateDynamicThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDynamicThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDynamicThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDynamicThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDynamicThingGroupInputOperationOutputAlias,
                crate::output::CreateDynamicThingGroupOutput,
                crate::error::CreateDynamicThingGroupError,
                crate::input::CreateDynamicThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The dynamic thing group name to create.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The dynamic thing group name to create.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The dynamic thing group properties.</p>
        pub fn thing_group_properties(mut self, input: crate::model::ThingGroupProperties) -> Self {
            self.inner = self.inner.thing_group_properties(input);
            self
        }
        /// <p>The dynamic thing group properties.</p>
        pub fn set_thing_group_properties(
            mut self,
            input: std::option::Option<crate::model::ThingGroupProperties>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_properties(input);
            self
        }
        /// <p>The dynamic thing group index name.</p> <note>
        /// <p>Currently one index is supported: <code>AWS_Things</code>.</p>
        /// </note>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The dynamic thing group index name.</p> <note>
        /// <p>Currently one index is supported: <code>AWS_Things</code>.</p>
        /// </note>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        /// <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        /// <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The dynamic thing group query version.</p> <note>
        /// <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>
        /// </note>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The dynamic thing group query version.</p> <note>
        /// <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>
        /// </note>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the dynamic thing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the dynamic thing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleetMetric`.
    ///
    /// <p>Creates a fleet metric.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateFleetMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFleetMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fleet_metric_input::Builder,
    }
    impl<C, M, R> CreateFleetMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFleetMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFleetMetricInputOperationOutputAlias,
                crate::output::CreateFleetMetricOutput,
                crate::error::CreateFleetMetricError,
                crate::input::CreateFleetMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet metric to create.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>The name of the fleet metric to create.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.inner = self.inner.aggregation_type(input);
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_type(input);
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.inner = self.inner.period(input);
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>. Default to null.</p>
        pub fn unit(mut self, input: crate::model::FleetMetricUnit) -> Self {
            self.inner = self.inner.unit(input);
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>. Default to null.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::FleetMetricUnit>,
        ) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata, which can be used to manage the fleet metric.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata, which can be used to manage the fleet metric.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>Creates a job.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of things and thing groups to which the job should be sent.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.targets(input.into());
            self
        }
        /// <p>A list of things and thing groups to which the job should be sent.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_source(input.into());
            self
        }
        /// <p>An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_source(input);
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Configuration information for pre-signed S3 URLs.</p>
        pub fn presigned_url_config(mut self, input: crate::model::PresignedUrlConfig) -> Self {
            self.inner = self.inner.presigned_url_config(input);
            self
        }
        /// <p>Configuration information for pre-signed S3 URLs.</p>
        pub fn set_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::PresignedUrlConfig>,
        ) -> Self {
            self.inner = self.inner.set_presigned_url_config(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.inner = self.inner.target_selection(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.inner = self.inner.set_target_selection(input);
            self
        }
        /// <p>Allows you to create a staged rollout of the job.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::JobExecutionsRolloutConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_rollout_config(input);
            self
        }
        /// <p>Allows you to create a staged rollout of the job.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_rollout_config(input);
            self
        }
        /// <p>Allows you to create the criteria to abort a job.</p>
        pub fn abort_config(mut self, input: crate::model::AbortConfig) -> Self {
            self.inner = self.inner.abort_config(input);
            self
        }
        /// <p>Allows you to create the criteria to abort a job.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::AbortConfig>,
        ) -> Self {
            self.inner = self.inner.set_abort_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn timeout_config(mut self, input: crate::model::TimeoutConfig) -> Self {
            self.inner = self.inner.timeout_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::TimeoutConfig>,
        ) -> Self {
            self.inner = self.inner.set_timeout_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the job.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
        /// <p>The ARN of the job template used to create the job.</p>
        pub fn job_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_arn(input.into());
            self
        }
        /// <p>The ARN of the job template used to create the job.</p>
        pub fn set_job_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_arn(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn job_executions_retry_config(
            mut self,
            input: crate::model::JobExecutionsRetryConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_retry_config(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn set_job_executions_retry_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRetryConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_retry_config(input);
            self
        }
        /// Adds a key-value pair to `documentParameters`.
        ///
        /// To override the contents of this collection use [`set_document_parameters`](Self::set_document_parameters).
        ///
        /// <p>Parameters of a managed template that you can specify to create the job document.</p>
        pub fn document_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.document_parameters(k.into(), v.into());
            self
        }
        /// <p>Parameters of a managed template that you can specify to create the job document.</p>
        pub fn set_document_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_document_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJobTemplate`.
    ///
    /// <p>Creates a job template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateJobTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_template_input::Builder,
    }
    impl<C, M, R> CreateJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobTemplateInputOperationOutputAlias,
                crate::output::CreateJobTemplateOutput,
                crate::error::CreateJobTemplateError,
                crate::input::CreateJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_id(input.into());
            self
        }
        /// <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_id(input);
            self
        }
        /// <p>The ARN of the job to use as the basis for the job template.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_arn(input.into());
            self
        }
        /// <p>The ARN of the job to use as the basis for the job template.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_arn(input);
            self
        }
        /// <p>An S3 link to the job document to use in the template. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_source(input.into());
            self
        }
        /// <p>An S3 link to the job document to use in the template. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_source(input);
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>A description of the job document.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the job document.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn presigned_url_config(mut self, input: crate::model::PresignedUrlConfig) -> Self {
            self.inner = self.inner.presigned_url_config(input);
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn set_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::PresignedUrlConfig>,
        ) -> Self {
            self.inner = self.inner.set_presigned_url_config(input);
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::JobExecutionsRolloutConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_rollout_config(input);
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_rollout_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn abort_config(mut self, input: crate::model::AbortConfig) -> Self {
            self.inner = self.inner.abort_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::AbortConfig>,
        ) -> Self {
            self.inner = self.inner.set_abort_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn timeout_config(mut self, input: crate::model::TimeoutConfig) -> Self {
            self.inner = self.inner.timeout_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::TimeoutConfig>,
        ) -> Self {
            self.inner = self.inner.set_timeout_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the job template.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the job template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn job_executions_retry_config(
            mut self,
            input: crate::model::JobExecutionsRetryConfig,
        ) -> Self {
            self.inner = self.inner.job_executions_retry_config(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn set_job_executions_retry_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRetryConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_executions_retry_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeysAndCertificate`.
    ///
    /// <p>Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api">Provisioning MQTT API</a>.</p>
    /// <p> <b>Note</b> This is the only time IoT issues the private key for this certificate, so it is important to keep it in a secure location.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateKeysAndCertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKeysAndCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_keys_and_certificate_input::Builder,
    }
    impl<C, M, R> CreateKeysAndCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateKeysAndCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeysAndCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeysAndCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateKeysAndCertificateInputOperationOutputAlias,
                crate::output::CreateKeysAndCertificateOutput,
                crate::error::CreateKeysAndCertificateError,
                crate::input::CreateKeysAndCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMitigationAction`.
    ///
    /// <p>Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain types of mitigation actions can be applied to specific check names. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation actions</a>. Each mitigation action can apply only one type of change.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateMitigationAction</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMitigationAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_mitigation_action_input::Builder,
    }
    impl<C, M, R> CreateMitigationAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMitigationAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMitigationActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMitigationActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMitigationActionInputOperationOutputAlias,
                crate::output::CreateMitigationActionOutput,
                crate::error::CreateMitigationActionError,
                crate::input::CreateMitigationActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
        /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Defines the type of action and the parameters for that action.</p>
        pub fn action_params(mut self, input: crate::model::MitigationActionParams) -> Self {
            self.inner = self.inner.action_params(input);
            self
        }
        /// <p>Defines the type of action and the parameters for that action.</p>
        pub fn set_action_params(
            mut self,
            input: std::option::Option<crate::model::MitigationActionParams>,
        ) -> Self {
            self.inner = self.inner.set_action_params(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the mitigation action.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the mitigation action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOTAUpdate`.
    ///
    /// <p>Creates an IoT OTA update on a target group of things or groups.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateOTAUpdate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOTAUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ota_update_input::Builder,
    }
    impl<C, M, R> CreateOTAUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOTAUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOtaUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOTAUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOtaUpdateInputOperationOutputAlias,
                crate::output::CreateOtaUpdateOutput,
                crate::error::CreateOTAUpdateError,
                crate::input::CreateOtaUpdateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OTA update to be created.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ota_update_id(input.into());
            self
        }
        /// <p>The ID of the OTA update to be created.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ota_update_id(input);
            self
        }
        /// <p>The description of the OTA update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the OTA update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The devices targeted to receive OTA updates.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.targets(input.into());
            self
        }
        /// <p>The devices targeted to receive OTA updates.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn protocols(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocols(input);
            self
        }
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.inner = self.inner.set_protocols(input);
            self
        }
        /// <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.inner = self.inner.target_selection(input);
            self
        }
        /// <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.inner = self.inner.set_target_selection(input);
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn aws_job_executions_rollout_config(
            mut self,
            input: crate::model::AwsJobExecutionsRolloutConfig,
        ) -> Self {
            self.inner = self.inner.aws_job_executions_rollout_config(input);
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn set_aws_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobExecutionsRolloutConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_executions_rollout_config(input);
            self
        }
        /// <p>Configuration information for pre-signed URLs.</p>
        pub fn aws_job_presigned_url_config(
            mut self,
            input: crate::model::AwsJobPresignedUrlConfig,
        ) -> Self {
            self.inner = self.inner.aws_job_presigned_url_config(input);
            self
        }
        /// <p>Configuration information for pre-signed URLs.</p>
        pub fn set_aws_job_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobPresignedUrlConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_presigned_url_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn aws_job_abort_config(mut self, input: crate::model::AwsJobAbortConfig) -> Self {
            self.inner = self.inner.aws_job_abort_config(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn set_aws_job_abort_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobAbortConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_abort_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn aws_job_timeout_config(mut self, input: crate::model::AwsJobTimeoutConfig) -> Self {
            self.inner = self.inner.aws_job_timeout_config(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_aws_job_timeout_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobTimeoutConfig>,
        ) -> Self {
            self.inner = self.inner.set_aws_job_timeout_config(input);
            self
        }
        /// Appends an item to `files`.
        ///
        /// To override the contents of this collection use [`set_files`](Self::set_files).
        ///
        /// <p>The files to be streamed by the OTA update.</p>
        pub fn files(mut self, input: crate::model::OtaUpdateFile) -> Self {
            self.inner = self.inner.files(input);
            self
        }
        /// <p>The files to be streamed by the OTA update.</p>
        pub fn set_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OtaUpdateFile>>,
        ) -> Self {
            self.inner = self.inner.set_files(input);
            self
        }
        /// <p>The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `additionalParameters`.
        ///
        /// To override the contents of this collection use [`set_additional_parameters`](Self::set_additional_parameters).
        ///
        /// <p>A list of additional OTA update parameters which are name-value pairs.</p>
        pub fn additional_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_parameters(k.into(), v.into());
            self
        }
        /// <p>A list of additional OTA update parameters which are name-value pairs.</p>
        pub fn set_additional_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_parameters(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage updates.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicy`.
    ///
    /// <p>Creates an IoT policy.</p>
    /// <p>The created policy is the default version for the policy. This operation creates a policy version with a version identifier of <b>1</b> and sets <b>1</b> as the policy's default version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_policy_input::Builder,
    }
    impl<C, M, R> CreatePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePolicyInputOperationOutputAlias,
                crate::output::CreatePolicyOutput,
                crate::error::CreatePolicyError,
                crate::input::CreatePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the policy.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the policy.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicyVersion`.
    ///
    /// <p>Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must use <code>DeletePolicyVersion</code> to delete an existing version before you create a new one.</p>
    /// <p>Optionally, you can set the new version as the policy's default version. The default version is the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreatePolicyVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_policy_version_input::Builder,
    }
    impl<C, M, R> CreatePolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePolicyVersionInputOperationOutputAlias,
                crate::output::CreatePolicyVersionOutput,
                crate::error::CreatePolicyVersionError,
                crate::input::CreatePolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
        pub fn set_as_default(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_default(input);
            self
        }
        /// <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_default(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningClaim`.
    ///
    /// <p>Creates a provisioning claim.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningClaim</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisioningClaim<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioning_claim_input::Builder,
    }
    impl<C, M, R> CreateProvisioningClaim<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisioningClaim`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningClaimOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningClaimError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisioningClaimInputOperationOutputAlias,
                crate::output::CreateProvisioningClaimOutput,
                crate::error::CreateProvisioningClaimError,
                crate::input::CreateProvisioningClaimInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the provisioning template to use.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the provisioning template to use.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningTemplate`.
    ///
    /// <p>Creates a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisioningTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioning_template_input::Builder,
    }
    impl<C, M, R> CreateProvisioningTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisioningTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisioningTemplateInputOperationOutputAlias,
                crate::output::CreateProvisioningTemplateOutput,
                crate::error::CreateProvisioningTemplateError,
                crate::input::CreateProvisioningTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>True to enable the fleet provisioning template, otherwise false.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>True to enable the fleet provisioning template, otherwise false.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn provisioning_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.provisioning_role_arn(input.into());
            self
        }
        /// <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn set_provisioning_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_provisioning_role_arn(input);
            self
        }
        /// <p>Creates a pre-provisioning hook template.</p>
        pub fn pre_provisioning_hook(mut self, input: crate::model::ProvisioningHook) -> Self {
            self.inner = self.inner.pre_provisioning_hook(input);
            self
        }
        /// <p>Creates a pre-provisioning hook template.</p>
        pub fn set_pre_provisioning_hook(
            mut self,
            input: std::option::Option<crate::model::ProvisioningHook>,
        ) -> Self {
            self.inner = self.inner.set_pre_provisioning_hook(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the fleet provisioning template.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the fleet provisioning template.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProvisioningTemplateVersion`.
    ///
    /// <p>Creates a new version of a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateProvisioningTemplateVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProvisioningTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_provisioning_template_version_input::Builder,
    }
    impl<C, M, R> CreateProvisioningTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProvisioningTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProvisioningTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProvisioningTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProvisioningTemplateVersionInputOperationOutputAlias,
                crate::output::CreateProvisioningTemplateVersionOutput,
                crate::error::CreateProvisioningTemplateVersionError,
                crate::input::CreateProvisioningTemplateVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>Sets a fleet provision template version as the default version.</p>
        pub fn set_as_default(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_default(input);
            self
        }
        /// <p>Sets a fleet provision template version as the default version.</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_default(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoleAlias`.
    ///
    /// <p>Creates a role alias.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateRoleAlias</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoleAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_role_alias_input::Builder,
    }
    impl<C, M, R> CreateRoleAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoleAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoleAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoleAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoleAliasInputOperationOutputAlias,
                crate::output::CreateRoleAliasOutput,
                crate::error::CreateRoleAliasError,
                crate::input::CreateRoleAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_alias(input.into());
            self
        }
        /// <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_alias(input);
            self
        }
        /// <p>The role ARN.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The role ARN.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>How long (in seconds) the credentials will be valid. The default value is 3,600 seconds.</p>
        pub fn credential_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.credential_duration_seconds(input);
            self
        }
        /// <p>How long (in seconds) the credentials will be valid. The default value is 3,600 seconds.</p>
        pub fn set_credential_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_credential_duration_seconds(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the role alias.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the role alias.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateScheduledAudit`.
    ///
    /// <p>Creates a scheduled audit that is run at a specified time interval.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateScheduledAudit</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateScheduledAudit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_scheduled_audit_input::Builder,
    }
    impl<C, M, R> CreateScheduledAudit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateScheduledAudit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScheduledAuditOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScheduledAuditError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateScheduledAuditInputOperationOutputAlias,
                crate::output::CreateScheduledAuditOutput,
                crate::error::CreateScheduledAuditError,
                crate::input::CreateScheduledAuditInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn frequency(mut self, input: crate::model::AuditFrequency) -> Self {
            self.inner = self.inner.frequency(input);
            self
        }
        /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AuditFrequency>,
        ) -> Self {
            self.inner = self.inner.set_frequency(input);
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn day_of_month(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.day_of_month(input.into());
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_day_of_month(input);
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
        pub fn day_of_week(mut self, input: crate::model::DayOfWeek) -> Self {
            self.inner = self.inner.day_of_week(input);
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
        pub fn set_day_of_week(
            mut self,
            input: std::option::Option<crate::model::DayOfWeek>,
        ) -> Self {
            self.inner = self.inner.set_day_of_week(input);
            self
        }
        /// Appends an item to `targetCheckNames`.
        ///
        /// To override the contents of this collection use [`set_target_check_names`](Self::set_target_check_names).
        ///
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn target_check_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_check_names(input.into());
            self
        }
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_target_check_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_check_names(input);
            self
        }
        /// <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_audit_name(input.into());
            self
        }
        /// <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_audit_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the scheduled audit.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the scheduled audit.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecurityProfile`.
    ///
    /// <p>Creates a Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_security_profile_input::Builder,
    }
    impl<C, M, R> CreateSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSecurityProfileInputOperationOutputAlias,
                crate::output::CreateSecurityProfileOutput,
                crate::error::CreateSecurityProfileError,
                crate::input::CreateSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name you are giving to the security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name you are giving to the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>A description of the security profile.</p>
        pub fn security_profile_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.security_profile_description(input.into());
            self
        }
        /// <p>A description of the security profile.</p>
        pub fn set_security_profile_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_description(input);
            self
        }
        /// Appends an item to `behaviors`.
        ///
        /// To override the contents of this collection use [`set_behaviors`](Self::set_behaviors).
        ///
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn behaviors(mut self, input: crate::model::Behavior) -> Self {
            self.inner = self.inner.behaviors(input);
            self
        }
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn set_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        ) -> Self {
            self.inner = self.inner.set_behaviors(input);
            self
        }
        /// Adds a key-value pair to `alertTargets`.
        ///
        /// To override the contents of this collection use [`set_alert_targets`](Self::set_alert_targets).
        ///
        /// <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
        pub fn alert_targets(
            mut self,
            k: crate::model::AlertTargetType,
            v: crate::model::AlertTarget,
        ) -> Self {
            self.inner = self.inner.alert_targets(k, v);
            self
        }
        /// <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
        pub fn set_alert_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
            >,
        ) -> Self {
            self.inner = self.inner.set_alert_targets(input);
            self
        }
        /// Appends an item to `additionalMetricsToRetain`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain`](Self::set_additional_metrics_to_retain).
        ///
        /// <p> <i>Please use <code>CreateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn additional_metrics_to_retain(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_metrics_to_retain(input.into());
            self
        }
        /// <p> <i>Please use <code>CreateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn set_additional_metrics_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_additional_metrics_to_retain(input);
            self
        }
        /// Appends an item to `additionalMetricsToRetainV2`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain_v2`](Self::set_additional_metrics_to_retain_v2).
        ///
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn additional_metrics_to_retain_v2(
            mut self,
            input: crate::model::MetricToRetain,
        ) -> Self {
            self.inner = self.inner.additional_metrics_to_retain_v2(input);
            self
        }
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn set_additional_metrics_to_retain_v2(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        ) -> Self {
            self.inner = self.inner.set_additional_metrics_to_retain_v2(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the security profile.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata that can be used to manage the security profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStream`.
    ///
    /// <p>Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with a stream.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateStream</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stream_input::Builder,
    }
    impl<C, M, R> CreateStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamInputOperationOutputAlias,
                crate::output::CreateStreamOutput,
                crate::error::CreateStreamError,
                crate::input::CreateStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// <p>A description of the stream.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the stream.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `files`.
        ///
        /// To override the contents of this collection use [`set_files`](Self::set_files).
        ///
        /// <p>The files to stream.</p>
        pub fn files(mut self, input: crate::model::StreamFile) -> Self {
            self.inner = self.inner.files(input);
            self
        }
        /// <p>The files to stream.</p>
        pub fn set_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamFile>>,
        ) -> Self {
            self.inner = self.inner.set_files(input);
            self
        }
        /// <p>An IAM role that allows the IoT service principal to access your S3 files.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>An IAM role that allows the IoT service principal to access your S3 files.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage streams.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage streams.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThing`.
    ///
    /// <p>Creates a thing record in the registry. If this call is made multiple times using the same thing name and configuration, the call will succeed. If this call is made with the same thing name but different configuration a <code>ResourceAlreadyExistsException</code> is thrown.</p> <note>
    /// <p>This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for information about authorizing control plane actions.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_thing_input::Builder,
    }
    impl<C, M, R> CreateThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThingInputOperationOutputAlias,
                crate::output::CreateThingOutput,
                crate::error::CreateThingError,
                crate::input::CreateThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to create.</p>
        /// <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to create.</p>
        /// <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The name of the thing type associated with the new thing.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type associated with the new thing.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
        /// <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p>
        /// <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
        pub fn attribute_payload(mut self, input: crate::model::AttributePayload) -> Self {
            self.inner = self.inner.attribute_payload(input);
            self
        }
        /// <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p>
        /// <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
        pub fn set_attribute_payload(
            mut self,
            input: std::option::Option<crate::model::AttributePayload>,
        ) -> Self {
            self.inner = self.inner.set_attribute_payload(input);
            self
        }
        /// <p>The name of the billing group the thing will be added to.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group the thing will be added to.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThingGroup`.
    ///
    /// <p>Create a thing group.</p> <note>
    /// <p>This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for information about authorizing control plane actions.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_thing_group_input::Builder,
    }
    impl<C, M, R> CreateThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThingGroupInputOperationOutputAlias,
                crate::output::CreateThingGroupOutput,
                crate::error::CreateThingGroupError,
                crate::input::CreateThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The thing group name to create.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The thing group name to create.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The name of the parent thing group.</p>
        pub fn parent_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_group_name(input.into());
            self
        }
        /// <p>The name of the parent thing group.</p>
        pub fn set_parent_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_group_name(input);
            self
        }
        /// <p>The thing group properties.</p>
        pub fn thing_group_properties(mut self, input: crate::model::ThingGroupProperties) -> Self {
            self.inner = self.inner.thing_group_properties(input);
            self
        }
        /// <p>The thing group properties.</p>
        pub fn set_thing_group_properties(
            mut self,
            input: std::option::Option<crate::model::ThingGroupProperties>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_properties(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the thing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the thing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThingType`.
    ///
    /// <p>Creates a new thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_thing_type_input::Builder,
    }
    impl<C, M, R> CreateThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThingTypeInputOperationOutputAlias,
                crate::output::CreateThingTypeOutput,
                crate::error::CreateThingTypeError,
                crate::input::CreateThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
        /// <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
        pub fn thing_type_properties(mut self, input: crate::model::ThingTypeProperties) -> Self {
            self.inner = self.inner.thing_type_properties(input);
            self
        }
        /// <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
        pub fn set_thing_type_properties(
            mut self,
            input: std::option::Option<crate::model::ThingTypeProperties>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_properties(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the thing type.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the thing type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTopicRule`.
    ///
    /// <p>Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_topic_rule_input::Builder,
    }
    impl<C, M, R> CreateTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTopicRuleInputOperationOutputAlias,
                crate::output::CreateTopicRuleOutput,
                crate::error::CreateTopicRuleError,
                crate::input::CreateTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
        /// <p>The rule payload.</p>
        pub fn topic_rule_payload(mut self, input: crate::model::TopicRulePayload) -> Self {
            self.inner = self.inner.topic_rule_payload(input);
            self
        }
        /// <p>The rule payload.</p>
        pub fn set_topic_rule_payload(
            mut self,
            input: std::option::Option<crate::model::TopicRulePayload>,
        ) -> Self {
            self.inner = self.inner.set_topic_rule_payload(input);
            self
        }
        /// <p>Metadata which can be used to manage the topic rule.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags(input.into());
            self
        }
        /// <p>Metadata which can be used to manage the topic rule.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTopicRuleDestination`.
    ///
    /// <p>Creates a topic rule destination. The destination must be confirmed prior to use.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateTopicRuleDestination</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTopicRuleDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_topic_rule_destination_input::Builder,
    }
    impl<C, M, R> CreateTopicRuleDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTopicRuleDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTopicRuleDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTopicRuleDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTopicRuleDestinationInputOperationOutputAlias,
                crate::output::CreateTopicRuleDestinationOutput,
                crate::error::CreateTopicRuleDestinationError,
                crate::input::CreateTopicRuleDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The topic rule destination configuration.</p>
        pub fn destination_configuration(
            mut self,
            input: crate::model::TopicRuleDestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.destination_configuration(input);
            self
        }
        /// <p>The topic rule destination configuration.</p>
        pub fn set_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::TopicRuleDestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_destination_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountAuditConfiguration`.
    ///
    /// <p>Restores the default settings for Device Defender audits for this account. Any configuration data you entered is deleted and all audit checks are reset to disabled. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAccountAuditConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccountAuditConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_audit_configuration_input::Builder,
    }
    impl<C, M, R> DeleteAccountAuditConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccountAuditConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountAuditConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountAuditConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountAuditConfigurationInputOperationOutputAlias,
                crate::output::DeleteAccountAuditConfigurationOutput,
                crate::error::DeleteAccountAuditConfigurationError,
                crate::input::DeleteAccountAuditConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If true, all scheduled audits are deleted.</p>
        pub fn delete_scheduled_audits(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_scheduled_audits(input);
            self
        }
        /// <p>If true, all scheduled audits are deleted.</p>
        pub fn set_delete_scheduled_audits(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_scheduled_audits(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuditSuppression`.
    ///
    /// <p> Deletes a Device Defender audit suppression. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuditSuppression</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuditSuppression<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_audit_suppression_input::Builder,
    }
    impl<C, M, R> DeleteAuditSuppression<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuditSuppression`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuditSuppressionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuditSuppressionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuditSuppressionInputOperationOutputAlias,
                crate::output::DeleteAuditSuppressionOutput,
                crate::error::DeleteAuditSuppressionError,
                crate::input::DeleteAuditSuppressionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthorizer`.
    ///
    /// <p>Deletes an authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_authorizer_input::Builder,
    }
    impl<C, M, R> DeleteAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuthorizerInputOperationOutputAlias,
                crate::output::DeleteAuthorizerOutput,
                crate::error::DeleteAuthorizerError,
                crate::input::DeleteAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authorizer to delete.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_name(input.into());
            self
        }
        /// <p>The name of the authorizer to delete.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBillingGroup`.
    ///
    /// <p>Deletes the billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_billing_group_input::Builder,
    }
    impl<C, M, R> DeleteBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBillingGroupInputOperationOutputAlias,
                crate::output::DeleteBillingGroupOutput,
                crate::error::DeleteBillingGroupError,
                crate::input::DeleteBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
        /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCACertificate`.
    ///
    /// <p>Deletes a registered CA certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCACertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCACertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ca_certificate_input::Builder,
    }
    impl<C, M, R> DeleteCACertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCACertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCaCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCACertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCaCertificateInputOperationOutputAlias,
                crate::output::DeleteCaCertificateOutput,
                crate::error::DeleteCACertificateError,
                crate::input::DeleteCaCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCertificate`.
    ///
    /// <p>Deletes the specified certificate.</p>
    /// <p>A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE. To delete a certificate, first use the <code>DetachPolicy</code> action to detach all policies. Next, use the <code>UpdateCertificate</code> action to set the certificate to the INACTIVE status.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_certificate_input::Builder,
    }
    impl<C, M, R> DeleteCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCertificateInputOperationOutputAlias,
                crate::output::DeleteCertificateOutput,
                crate::error::DeleteCertificateError,
                crate::input::DeleteCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
        /// <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomMetric`.
    ///
    /// <p> Deletes a Device Defender detect custom metric. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteCustomMetric</a> action.</p> <note>
    /// <p>Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a part of. The security profile associated with the custom metric can be found using the <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles</a> API with <code>metricName</code> set to your custom metric name.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_metric_input::Builder,
    }
    impl<C, M, R> DeleteCustomMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomMetricInputOperationOutputAlias,
                crate::output::DeleteCustomMetricOutput,
                crate::error::DeleteCustomMetricError,
                crate::input::DeleteCustomMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDimension`.
    ///
    /// <p>Removes the specified dimension from your Amazon Web Services accounts.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDimension</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDimension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dimension_input::Builder,
    }
    impl<C, M, R> DeleteDimension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDimension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDimensionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDimensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDimensionInputOperationOutputAlias,
                crate::output::DeleteDimensionOutput,
                crate::error::DeleteDimensionError,
                crate::input::DeleteDimensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the dimension that you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique identifier for the dimension that you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainConfiguration`.
    ///
    /// <p>Deletes the specified domain configuration.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDomainConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_configuration_input::Builder,
    }
    impl<C, M, R> DeleteDomainConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainConfigurationInputOperationOutputAlias,
                crate::output::DeleteDomainConfigurationOutput,
                crate::error::DeleteDomainConfigurationError,
                crate::input::DeleteDomainConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain configuration to be deleted.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_configuration_name(input.into());
            self
        }
        /// <p>The name of the domain configuration to be deleted.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_configuration_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDynamicThingGroup`.
    ///
    /// <p>Deletes a dynamic thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteDynamicThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDynamicThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dynamic_thing_group_input::Builder,
    }
    impl<C, M, R> DeleteDynamicThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDynamicThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDynamicThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDynamicThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDynamicThingGroupInputOperationOutputAlias,
                crate::output::DeleteDynamicThingGroupOutput,
                crate::error::DeleteDynamicThingGroupError,
                crate::input::DeleteDynamicThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the dynamic thing group to delete.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the dynamic thing group to delete.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The expected version of the dynamic thing group to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the dynamic thing group to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFleetMetric`.
    ///
    /// <p>Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you specify a fleet metric that doesn't exist.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteFleetMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFleetMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fleet_metric_input::Builder,
    }
    impl<C, M, R> DeleteFleetMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFleetMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFleetMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFleetMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFleetMetricInputOperationOutputAlias,
                crate::output::DeleteFleetMetricOutput,
                crate::error::DeleteFleetMetricError,
                crate::input::DeleteFleetMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet metric to delete.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>The name of the fleet metric to delete.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The expected version of the fleet metric to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the fleet metric to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes a job and its related job executions.</p>
    /// <p>Deleting a job may take time, depending on the number of job executions created for the job and various other factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.</p>
    /// <p>Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl<C, M, R> DeleteJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobInputOperationOutputAlias,
                crate::output::DeleteJobOutput,
                crate::error::DeleteJobError,
                crate::input::DeleteJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job to be deleted.</p>
        /// <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job to be deleted.</p>
        /// <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p>
        /// </note>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p>
        /// </note>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJobExecution`.
    ///
    /// <p>Deletes a job execution.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteJobExecution</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJobExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_execution_input::Builder,
    }
    impl<C, M, R> DeleteJobExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJobExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobExecutionInputOperationOutputAlias,
                crate::output::DeleteJobExecutionOutput,
                crate::error::DeleteJobExecutionError,
                crate::input::DeleteJobExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the job whose execution on a particular device will be deleted.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job whose execution on a particular device will be deleted.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The name of the thing whose job execution will be deleted.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing whose job execution will be deleted.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p>
        /// <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.inner = self.inner.execution_number(input);
            self
        }
        /// <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p>
        /// <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_execution_number(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        /// </note>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        /// </note>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJobTemplate`.
    ///
    /// <p>Deletes the specified job template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_template_input::Builder,
    }
    impl<C, M, R> DeleteJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobTemplateInputOperationOutputAlias,
                crate::output::DeleteJobTemplateOutput,
                crate::error::DeleteJobTemplateError,
                crate::input::DeleteJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the job template to delete.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_id(input.into());
            self
        }
        /// <p>The unique identifier of the job template to delete.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMitigationAction`.
    ///
    /// <p>Deletes a defined mitigation action from your Amazon Web Services accounts.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteMitigationAction</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMitigationAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mitigation_action_input::Builder,
    }
    impl<C, M, R> DeleteMitigationAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMitigationAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMitigationActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMitigationActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMitigationActionInputOperationOutputAlias,
                crate::output::DeleteMitigationActionOutput,
                crate::error::DeleteMitigationActionError,
                crate::input::DeleteMitigationActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the mitigation action that you want to delete.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>The name of the mitigation action that you want to delete.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOTAUpdate`.
    ///
    /// <p>Delete an OTA update.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteOTAUpdate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOTAUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ota_update_input::Builder,
    }
    impl<C, M, R> DeleteOTAUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOTAUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOtaUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOTAUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOtaUpdateInputOperationOutputAlias,
                crate::output::DeleteOtaUpdateOutput,
                crate::error::DeleteOTAUpdateError,
                crate::input::DeleteOtaUpdateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OTA update to delete.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ota_update_id(input.into());
            self
        }
        /// <p>The ID of the OTA update to delete.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ota_update_id(input);
            self
        }
        /// <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
        pub fn delete_stream(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_stream(input);
            self
        }
        /// <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
        pub fn set_delete_stream(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_stream(input);
            self
        }
        /// <p>When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
        pub fn force_delete_aws_job(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete_aws_job(input);
            self
        }
        /// <p>When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
        pub fn set_force_delete_aws_job(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete_aws_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// <p>Deletes the specified policy.</p>
    /// <p>A policy cannot be deleted if it has non-default versions or it is attached to any certificate.</p>
    /// <p>To delete a policy, use the <code>DeletePolicyVersion</code> action to delete all non-default versions of the policy; use the <code>DetachPolicy</code> action to detach the policy from any certificate; and then use the DeletePolicy action to delete the policy.</p>
    /// <p>When a policy is deleted using DeletePolicy, its default version is deleted with it.</p> <note>
    /// <p>Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl<C, M, R> DeletePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyInputOperationOutputAlias,
                crate::output::DeletePolicyOutput,
                crate::error::DeletePolicyError,
                crate::input::DeletePolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy to delete.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to delete.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicyVersion`.
    ///
    /// <p>Deletes the specified version of the specified policy. You cannot delete the default version of a policy using this action. To delete the default version of a policy, use <code>DeletePolicy</code>. To find out which version of a policy is marked as the default version, use ListPolicyVersions.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeletePolicyVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_version_input::Builder,
    }
    impl<C, M, R> DeletePolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyVersionInputOperationOutputAlias,
                crate::output::DeletePolicyVersionOutput,
                crate::error::DeletePolicyVersionError,
                crate::input::DeletePolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_version_id(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisioningTemplate`.
    ///
    /// <p>Deletes a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProvisioningTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_provisioning_template_input::Builder,
    }
    impl<C, M, R> DeleteProvisioningTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProvisioningTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisioningTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisioningTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProvisioningTemplateInputOperationOutputAlias,
                crate::output::DeleteProvisioningTemplateOutput,
                crate::error::DeleteProvisioningTemplateError,
                crate::input::DeleteProvisioningTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provision template to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provision template to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisioningTemplateVersion`.
    ///
    /// <p>Deletes a fleet provisioning template version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteProvisioningTemplateVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProvisioningTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_provisioning_template_version_input::Builder,
    }
    impl<C, M, R> DeleteProvisioningTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProvisioningTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisioningTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProvisioningTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProvisioningTemplateVersionInputOperationOutputAlias,
                crate::output::DeleteProvisioningTemplateVersionOutput,
                crate::error::DeleteProvisioningTemplateVersionError,
                crate::input::DeleteProvisioningTemplateVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template version to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template version to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The fleet provisioning template version ID to delete.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.version_id(input);
            self
        }
        /// <p>The fleet provisioning template version ID to delete.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegistrationCode`.
    ///
    /// <p>Deletes a CA certificate registration code.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRegistrationCode</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRegistrationCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_registration_code_input::Builder,
    }
    impl<C, M, R> DeleteRegistrationCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRegistrationCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegistrationCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegistrationCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRegistrationCodeInputOperationOutputAlias,
                crate::output::DeleteRegistrationCodeOutput,
                crate::error::DeleteRegistrationCodeError,
                crate::input::DeleteRegistrationCodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteRoleAlias`.
    ///
    /// <p>Deletes a role alias</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteRoleAlias</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoleAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_role_alias_input::Builder,
    }
    impl<C, M, R> DeleteRoleAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoleAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoleAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoleAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoleAliasInputOperationOutputAlias,
                crate::output::DeleteRoleAliasOutput,
                crate::error::DeleteRoleAliasError,
                crate::input::DeleteRoleAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The role alias to delete.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_alias(input.into());
            self
        }
        /// <p>The role alias to delete.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteScheduledAudit`.
    ///
    /// <p>Deletes a scheduled audit.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteScheduledAudit</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteScheduledAudit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_scheduled_audit_input::Builder,
    }
    impl<C, M, R> DeleteScheduledAudit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteScheduledAudit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScheduledAuditOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScheduledAuditError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteScheduledAuditInputOperationOutputAlias,
                crate::output::DeleteScheduledAuditOutput,
                crate::error::DeleteScheduledAuditError,
                crate::input::DeleteScheduledAuditInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled audit you want to delete.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_audit_name(input.into());
            self
        }
        /// <p>The name of the scheduled audit you want to delete.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_audit_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecurityProfile`.
    ///
    /// <p>Deletes a Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_security_profile_input::Builder,
    }
    impl<C, M, R> DeleteSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSecurityProfileInputOperationOutputAlias,
                crate::output::DeleteSecurityProfileOutput,
                crate::error::DeleteSecurityProfileError,
                crate::input::DeleteSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security profile to be deleted.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name of the security profile to be deleted.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStream`.
    ///
    /// <p>Deletes a stream.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteStream</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stream_input::Builder,
    }
    impl<C, M, R> DeleteStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamInputOperationOutputAlias,
                crate::output::DeleteStreamOutput,
                crate::error::DeleteStreamError,
                crate::input::DeleteStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThing`.
    ///
    /// <p>Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a thing that doesn't exist.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_thing_input::Builder,
    }
    impl<C, M, R> DeleteThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThingInputOperationOutputAlias,
                crate::output::DeleteThingOutput,
                crate::error::DeleteThingError,
                crate::input::DeleteThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing to delete.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing to delete.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThingGroup`.
    ///
    /// <p>Deletes a thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_thing_group_input::Builder,
    }
    impl<C, M, R> DeleteThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThingGroupInputOperationOutputAlias,
                crate::output::DeleteThingGroupOutput,
                crate::error::DeleteThingGroupError,
                crate::input::DeleteThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing group to delete.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the thing group to delete.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>The expected version of the thing group to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.inner = self.inner.expected_version(input);
            self
        }
        /// <p>The expected version of the thing group to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expected_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThingType`.
    ///
    /// <p>Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a thing type, first mark it as deprecated by calling <code>DeprecateThingType</code>, then remove any associated things by calling <code>UpdateThing</code> to change the thing type on any associated thing, and finally use <code>DeleteThingType</code> to delete the thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_thing_type_input::Builder,
    }
    impl<C, M, R> DeleteThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThingTypeInputOperationOutputAlias,
                crate::output::DeleteThingTypeOutput,
                crate::error::DeleteThingTypeError,
                crate::input::DeleteThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTopicRule`.
    ///
    /// <p>Deletes the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_topic_rule_input::Builder,
    }
    impl<C, M, R> DeleteTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTopicRuleInputOperationOutputAlias,
                crate::output::DeleteTopicRuleOutput,
                crate::error::DeleteTopicRuleError,
                crate::input::DeleteTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTopicRuleDestination`.
    ///
    /// <p>Deletes a topic rule destination.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteTopicRuleDestination</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTopicRuleDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_topic_rule_destination_input::Builder,
    }
    impl<C, M, R> DeleteTopicRuleDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTopicRuleDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTopicRuleDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTopicRuleDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTopicRuleDestinationInputOperationOutputAlias,
                crate::output::DeleteTopicRuleDestinationOutput,
                crate::error::DeleteTopicRuleDestinationError,
                crate::input::DeleteTopicRuleDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the topic rule destination to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the topic rule destination to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteV2LoggingLevel`.
    ///
    /// <p>Deletes a logging level.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteV2LoggingLevel</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteV2LoggingLevel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_v2_logging_level_input::Builder,
    }
    impl<C, M, R> DeleteV2LoggingLevel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteV2LoggingLevel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteV2LoggingLevelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteV2LoggingLevelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteV2LoggingLevelInputOperationOutputAlias,
                crate::output::DeleteV2LoggingLevelOutput,
                crate::error::DeleteV2LoggingLevelError,
                crate::input::DeleteV2LoggingLevelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn target_type(mut self, input: crate::model::LogTargetType) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::LogTargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>The name of the resource for which you are configuring logging.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_name(input.into());
            self
        }
        /// <p>The name of the resource for which you are configuring logging.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprecateThingType`.
    ///
    /// <p>Deprecates a thing type. You can not associate new things with deprecated thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprecateThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprecate_thing_type_input::Builder,
    }
    impl<C, M, R> DeprecateThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprecateThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprecateThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprecateThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprecateThingTypeInputOperationOutputAlias,
                crate::output::DeprecateThingTypeOutput,
                crate::error::DeprecateThingTypeError,
                crate::input::DeprecateThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type to deprecate.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type to deprecate.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
        /// <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
        pub fn undo_deprecate(mut self, input: bool) -> Self {
            self.inner = self.inner.undo_deprecate(input);
            self
        }
        /// <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
        pub fn set_undo_deprecate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_undo_deprecate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAuditConfiguration`.
    ///
    /// <p>Gets information about the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAccountAuditConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAuditConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_audit_configuration_input::Builder,
    }
    impl<C, M, R> DescribeAccountAuditConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAuditConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAuditConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAuditConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAuditConfigurationInputOperationOutputAlias,
                crate::output::DescribeAccountAuditConfigurationOutput,
                crate::error::DescribeAccountAuditConfigurationError,
                crate::input::DescribeAccountAuditConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditFinding`.
    ///
    /// <p>Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of the issue, and the start time when the audit that returned the finding.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditFinding</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditFinding<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_finding_input::Builder,
    }
    impl<C, M, R> DescribeAuditFinding<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditFinding`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditFindingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditFindingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditFindingInputOperationOutputAlias,
                crate::output::DescribeAuditFindingOutput,
                crate::error::DescribeAuditFindingError,
                crate::input::DescribeAuditFindingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
        pub fn finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_id(input.into());
            self
        }
        /// <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
        pub fn set_finding_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_finding_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditMitigationActionsTask`.
    ///
    /// <p>Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they're being applied, the task status, and aggregated task statistics.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> DescribeAuditMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAuditMitigationActionsTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditMitigationActionsTaskInputOperationOutputAlias,
                crate::output::DescribeAuditMitigationActionsTaskOutput,
                crate::error::DescribeAuditMitigationActionsTaskError,
                crate::input::DescribeAuditMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the audit mitigation task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The unique identifier for the audit mitigation task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditSuppression`.
    ///
    /// <p> Gets information about a Device Defender audit suppression. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditSuppression<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_suppression_input::Builder,
    }
    impl<C, M, R> DescribeAuditSuppression<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditSuppression`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditSuppressionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditSuppressionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditSuppressionInputOperationOutputAlias,
                crate::output::DescribeAuditSuppressionOutput,
                crate::error::DescribeAuditSuppressionError,
                crate::input::DescribeAuditSuppressionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuditTask`.
    ///
    /// <p>Gets information about a Device Defender audit.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuditTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuditTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_audit_task_input::Builder,
    }
    impl<C, M, R> DescribeAuditTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuditTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuditTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuditTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuditTaskInputOperationOutputAlias,
                crate::output::DescribeAuditTaskOutput,
                crate::error::DescribeAuditTaskError,
                crate::input::DescribeAuditTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the audit whose information you want to get.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the audit whose information you want to get.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuthorizer`.
    ///
    /// <p>Describes an authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_authorizer_input::Builder,
    }
    impl<C, M, R> DescribeAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuthorizerInputOperationOutputAlias,
                crate::output::DescribeAuthorizerOutput,
                crate::error::DescribeAuthorizerError,
                crate::input::DescribeAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authorizer to describe.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authorizer_name(input.into());
            self
        }
        /// <p>The name of the authorizer to describe.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authorizer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBillingGroup`.
    ///
    /// <p>Returns information about a billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_billing_group_input::Builder,
    }
    impl<C, M, R> DescribeBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBillingGroupInputOperationOutputAlias,
                crate::output::DescribeBillingGroupOutput,
                crate::error::DescribeBillingGroupError,
                crate::input::DescribeBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCACertificate`.
    ///
    /// <p>Describes a registered CA certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCACertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCACertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ca_certificate_input::Builder,
    }
    impl<C, M, R> DescribeCACertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCACertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCaCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCACertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCaCertificateInputOperationOutputAlias,
                crate::output::DescribeCaCertificateOutput,
                crate::error::DescribeCACertificateError,
                crate::input::DescribeCaCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The CA certificate identifier.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The CA certificate identifier.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificate`.
    ///
    /// <p>Gets information about the specified certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_certificate_input::Builder,
    }
    impl<C, M, R> DescribeCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCertificateInputOperationOutputAlias,
                crate::output::DescribeCertificateOutput,
                crate::error::DescribeCertificateError,
                crate::input::DescribeCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomMetric`.
    ///
    /// <p> Gets information about a Device Defender detect custom metric. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeCustomMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_metric_input::Builder,
    }
    impl<C, M, R> DescribeCustomMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomMetricInputOperationOutputAlias,
                crate::output::DescribeCustomMetricOutput,
                crate::error::DescribeCustomMetricError,
                crate::input::DescribeCustomMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDefaultAuthorizer`.
    ///
    /// <p>Describes the default authorizer.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDefaultAuthorizer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDefaultAuthorizer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_default_authorizer_input::Builder,
    }
    impl<C, M, R> DescribeDefaultAuthorizer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDefaultAuthorizer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDefaultAuthorizerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDefaultAuthorizerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDefaultAuthorizerInputOperationOutputAlias,
                crate::output::DescribeDefaultAuthorizerOutput,
                crate::error::DescribeDefaultAuthorizerError,
                crate::input::DescribeDefaultAuthorizerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeDetectMitigationActionsTask`.
    ///
    /// <p> Gets information about a Device Defender ML Detect mitigation action. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDetectMitigationActionsTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDetectMitigationActionsTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_detect_mitigation_actions_task_input::Builder,
    }
    impl<C, M, R> DescribeDetectMitigationActionsTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDetectMitigationActionsTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDetectMitigationActionsTaskOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDetectMitigationActionsTaskError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDetectMitigationActionsTaskInputOperationOutputAlias,
                crate::output::DescribeDetectMitigationActionsTaskOutput,
                crate::error::DescribeDetectMitigationActionsTaskError,
                crate::input::DescribeDetectMitigationActionsTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDimension`.
    ///
    /// <p>Provides details about a dimension that is defined in your Amazon Web Services accounts.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDimension</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDimension<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dimension_input::Builder,
    }
    impl<C, M, R> DescribeDimension<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDimension`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDimensionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDimensionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDimensionInputOperationOutputAlias,
                crate::output::DescribeDimensionOutput,
                crate::error::DescribeDimensionError,
                crate::input::DescribeDimensionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique identifier for the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomainConfiguration`.
    ///
    /// <p>Gets summary information about a domain configuration.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeDomainConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomainConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_configuration_input::Builder,
    }
    impl<C, M, R> DescribeDomainConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomainConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainConfigurationInputOperationOutputAlias,
                crate::output::DescribeDomainConfigurationOutput,
                crate::error::DescribeDomainConfigurationError,
                crate::input::DescribeDomainConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain configuration.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_configuration_name(input.into());
            self
        }
        /// <p>The name of the domain configuration.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_configuration_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoint`.
    ///
    /// <p>Returns a unique endpoint specific to the Amazon Web Services account making the call.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEndpoint</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_input::Builder,
    }
    impl<C, M, R> DescribeEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointInputOperationOutputAlias,
                crate::output::DescribeEndpointOutput,
                crate::error::DescribeEndpointError,
                crate::input::DescribeEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The endpoint type. Valid endpoint types include:</p>
        /// <ul>
        /// <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:CredentialProvider</code> - Returns an IoT credentials provider API endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Jobs</code> - Returns an IoT device management Jobs API endpoint.</p> </li>
        /// </ul>
        /// <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(input.into());
            self
        }
        /// <p>The endpoint type. Valid endpoint types include:</p>
        /// <ul>
        /// <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:CredentialProvider</code> - Returns an IoT credentials provider API endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Jobs</code> - Returns an IoT device management Jobs API endpoint.</p> </li>
        /// </ul>
        /// <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventConfigurations`.
    ///
    /// <p>Describes event configurations.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeEventConfigurations</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_configurations_input::Builder,
    }
    impl<C, M, R> DescribeEventConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventConfigurationsInputOperationOutputAlias,
                crate::output::DescribeEventConfigurationsOutput,
                crate::error::DescribeEventConfigurationsError,
                crate::input::DescribeEventConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeFleetMetric`.
    ///
    /// <p>Gets information about the specified fleet metric.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeFleetMetric</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFleetMetric<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fleet_metric_input::Builder,
    }
    impl<C, M, R> DescribeFleetMetric<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFleetMetric`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFleetMetricOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFleetMetricError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFleetMetricInputOperationOutputAlias,
                crate::output::DescribeFleetMetricOutput,
                crate::error::DescribeFleetMetricError,
                crate::input::DescribeFleetMetricInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet metric to describe.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>The name of the fleet metric to describe.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIndex`.
    ///
    /// <p>Describes a search index.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeIndex</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_index_input::Builder,
    }
    impl<C, M, R> DescribeIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIndexInputOperationOutputAlias,
                crate::output::DescribeIndexOutput,
                crate::error::DescribeIndexError,
                crate::input::DescribeIndexInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJob`.
    ///
    /// <p>Describes a job.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_input::Builder,
    }
    impl<C, M, R> DescribeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobInputOperationOutputAlias,
                crate::output::DescribeJobOutput,
                crate::error::DescribeJobError,
                crate::input::DescribeJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobExecution`.
    ///
    /// <p>Describes a job execution.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeJobExecution</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_execution_input::Builder,
    }
    impl<C, M, R> DescribeJobExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobExecutionInputOperationOutputAlias,
                crate::output::DescribeJobExecutionOutput,
                crate::error::DescribeJobExecutionError,
                crate::input::DescribeJobExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The name of the thing on which the job execution is running.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing on which the job execution is running.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.inner = self.inner.execution_number(input);
            self
        }
        /// <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_execution_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJobTemplate`.
    ///
    /// <p>Returns information about a job template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_template_input::Builder,
    }
    impl<C, M, R> DescribeJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobTemplateInputOperationOutputAlias,
                crate::output::DescribeJobTemplateOutput,
                crate::error::DescribeJobTemplateError,
                crate::input::DescribeJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template_id(input.into());
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeManagedJobTemplate`.
    ///
    /// <p>View details of a managed job template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeManagedJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_managed_job_template_input::Builder,
    }
    impl<C, M, R> DescribeManagedJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeManagedJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeManagedJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeManagedJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeManagedJobTemplateInputOperationOutputAlias,
                crate::output::DescribeManagedJobTemplateOutput,
                crate::error::DescribeManagedJobTemplateError,
                crate::input::DescribeManagedJobTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of a managed job template, which is required.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The unique name of a managed job template, which is required.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>An optional parameter to specify version of a managed template. If not specified, the pre-defined default version is returned.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_version(input.into());
            self
        }
        /// <p>An optional parameter to specify version of a managed template. If not specified, the pre-defined default version is returned.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMitigationAction`.
    ///
    /// <p>Gets information about a mitigation action.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeMitigationAction</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMitigationAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_mitigation_action_input::Builder,
    }
    impl<C, M, R> DescribeMitigationAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMitigationAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMitigationActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMitigationActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMitigationActionInputOperationOutputAlias,
                crate::output::DescribeMitigationActionOutput,
                crate::error::DescribeMitigationActionError,
                crate::input::DescribeMitigationActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningTemplate`.
    ///
    /// <p>Returns information about a fleet provisioning template.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisioningTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioning_template_input::Builder,
    }
    impl<C, M, R> DescribeProvisioningTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisioningTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProvisioningTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisioningTemplateInputOperationOutputAlias,
                crate::output::DescribeProvisioningTemplateOutput,
                crate::error::DescribeProvisioningTemplateError,
                crate::input::DescribeProvisioningTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProvisioningTemplateVersion`.
    ///
    /// <p>Returns information about a fleet provisioning template version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeProvisioningTemplateVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProvisioningTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_provisioning_template_version_input::Builder,
    }
    impl<C, M, R> DescribeProvisioningTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProvisioningTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProvisioningTemplateVersionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeProvisioningTemplateVersionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProvisioningTemplateVersionInputOperationOutputAlias,
                crate::output::DescribeProvisioningTemplateVersionOutput,
                crate::error::DescribeProvisioningTemplateVersionError,
                crate::input::DescribeProvisioningTemplateVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The template name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The fleet provisioning template version ID.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.inner = self.inner.version_id(input);
            self
        }
        /// <p>The fleet provisioning template version ID.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRoleAlias`.
    ///
    /// <p>Describes a role alias.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeRoleAlias</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRoleAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_role_alias_input::Builder,
    }
    impl<C, M, R> DescribeRoleAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRoleAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRoleAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRoleAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRoleAliasInputOperationOutputAlias,
                crate::output::DescribeRoleAliasOutput,
                crate::error::DescribeRoleAliasError,
                crate::input::DescribeRoleAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The role alias to describe.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_alias(input.into());
            self
        }
        /// <p>The role alias to describe.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeScheduledAudit`.
    ///
    /// <p>Gets information about a scheduled audit.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeScheduledAudit</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeScheduledAudit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_scheduled_audit_input::Builder,
    }
    impl<C, M, R> DescribeScheduledAudit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeScheduledAudit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScheduledAuditOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScheduledAuditError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeScheduledAuditInputOperationOutputAlias,
                crate::output::DescribeScheduledAuditOutput,
                crate::error::DescribeScheduledAuditError,
                crate::input::DescribeScheduledAuditInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled audit whose information you want to get.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_audit_name(input.into());
            self
        }
        /// <p>The name of the scheduled audit whose information you want to get.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_audit_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecurityProfile`.
    ///
    /// <p>Gets information about a Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_security_profile_input::Builder,
    }
    impl<C, M, R> DescribeSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSecurityProfileInputOperationOutputAlias,
                crate::output::DescribeSecurityProfileOutput,
                crate::error::DescribeSecurityProfileError,
                crate::input::DescribeSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security profile whose information you want to get.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name of the security profile whose information you want to get.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStream`.
    ///
    /// <p>Gets information about a stream.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeStream</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStream<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stream_input::Builder,
    }
    impl<C, M, R> DescribeStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStreamInputOperationOutputAlias,
                crate::output::DescribeStreamOutput,
                crate::error::DescribeStreamError,
                crate::input::DescribeStreamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThing`.
    ///
    /// <p>Gets information about the specified thing.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_input::Builder,
    }
    impl<C, M, R> DescribeThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingInputOperationOutputAlias,
                crate::output::DescribeThingOutput,
                crate::error::DescribeThingError,
                crate::input::DescribeThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThingGroup`.
    ///
    /// <p>Describe a thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_group_input::Builder,
    }
    impl<C, M, R> DescribeThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingGroupInputOperationOutputAlias,
                crate::output::DescribeThingGroupOutput,
                crate::error::DescribeThingGroupError,
                crate::input::DescribeThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing group.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The name of the thing group.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThingRegistrationTask`.
    ///
    /// <p>Describes a bulk thing provisioning task.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingRegistrationTask</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThingRegistrationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_registration_task_input::Builder,
    }
    impl<C, M, R> DescribeThingRegistrationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThingRegistrationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingRegistrationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingRegistrationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingRegistrationTaskInputOperationOutputAlias,
                crate::output::DescribeThingRegistrationTaskOutput,
                crate::error::DescribeThingRegistrationTaskError,
                crate::input::DescribeThingRegistrationTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The task ID.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The task ID.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeThingType`.
    ///
    /// <p>Gets information about the specified thing type.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DescribeThingType</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeThingType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_thing_type_input::Builder,
    }
    impl<C, M, R> DescribeThingType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeThingType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeThingTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeThingTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeThingTypeInputOperationOutputAlias,
                crate::output::DescribeThingTypeOutput,
                crate::error::DescribeThingTypeError,
                crate::input::DescribeThingTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPolicy`.
    ///
    /// <p>Detaches a policy from the specified target.</p> <note>
    /// <p>Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is detached before it's ready to be deleted.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_policy_input::Builder,
    }
    impl<C, M, R> DetachPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachPolicyInputOperationOutputAlias,
                crate::output::DetachPolicyOutput,
                crate::error::DetachPolicyError,
                crate::input::DetachPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy to detach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy to detach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The target from which the policy will be detached.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The target from which the policy will be detached.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachPrincipalPolicy`.
    ///
    /// <p>Removes the specified policy from the specified certificate.</p> <note>
    /// <p>This action is deprecated. Please use <code>DetachPolicy</code> instead.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachPrincipalPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachPrincipalPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_principal_policy_input::Builder,
    }
    impl<C, M, R> DetachPrincipalPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachPrincipalPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachPrincipalPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachPrincipalPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachPrincipalPolicyInputOperationOutputAlias,
                crate::output::DetachPrincipalPolicyOutput,
                crate::error::DetachPrincipalPolicyError,
                crate::input::DetachPrincipalPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy to detach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to detach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The principal.</p>
        /// <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal.</p>
        /// <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachSecurityProfile`.
    ///
    /// <p>Disassociates a Device Defender security profile from a thing group or from this account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_security_profile_input::Builder,
    }
    impl<C, M, R> DetachSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachSecurityProfileInputOperationOutputAlias,
                crate::output::DetachSecurityProfileOutput,
                crate::error::DetachSecurityProfileError,
                crate::input::DetachSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The security profile that is detached.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The security profile that is detached.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The ARN of the thing group from which the security profile is detached.</p>
        pub fn security_profile_target_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.security_profile_target_arn(input.into());
            self
        }
        /// <p>The ARN of the thing group from which the security profile is detached.</p>
        pub fn set_security_profile_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachThingPrincipal`.
    ///
    /// <p>Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p> <note>
    /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
    /// </note>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DetachThingPrincipal</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetachThingPrincipal<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_thing_principal_input::Builder,
    }
    impl<C, M, R> DetachThingPrincipal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachThingPrincipal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachThingPrincipalOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachThingPrincipalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachThingPrincipalInputOperationOutputAlias,
                crate::output::DetachThingPrincipalOutput,
                crate::error::DetachThingPrincipalError,
                crate::input::DetachThingPrincipalInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableTopicRule`.
    ///
    /// <p>Disables the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DisableTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_topic_rule_input::Builder,
    }
    impl<C, M, R> DisableTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableTopicRuleInputOperationOutputAlias,
                crate::output::DisableTopicRuleOutput,
                crate::error::DisableTopicRuleError,
                crate::input::DisableTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule to disable.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule to disable.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableTopicRule`.
    ///
    /// <p>Enables the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">EnableTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_topic_rule_input::Builder,
    }
    impl<C, M, R> EnableTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableTopicRuleInputOperationOutputAlias,
                crate::output::EnableTopicRuleOutput,
                crate::error::EnableTopicRuleError,
                crate::input::EnableTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the topic rule to enable.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the topic rule to enable.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBehaviorModelTrainingSummaries`.
    ///
    /// <p> Returns a Device Defender's ML Detect Security Profile training model's status. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBehaviorModelTrainingSummaries</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBehaviorModelTrainingSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_behavior_model_training_summaries_input::Builder,
    }
    impl<C, M, R> GetBehaviorModelTrainingSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBehaviorModelTrainingSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBehaviorModelTrainingSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBehaviorModelTrainingSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBehaviorModelTrainingSummariesInputOperationOutputAlias,
                crate::output::GetBehaviorModelTrainingSummariesOutput,
                crate::error::GetBehaviorModelTrainingSummariesError,
                crate::input::GetBehaviorModelTrainingSummariesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBehaviorModelTrainingSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetBehaviorModelTrainingSummariesPaginator<C, M, R> {
            crate::paginator::GetBehaviorModelTrainingSummariesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The name of the security profile. </p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p> The name of the security profile. </p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketsAggregation`.
    ///
    /// <p>Aggregates on indexed data with search queries pertaining to particular fields. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetBucketsAggregation</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketsAggregation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_buckets_aggregation_input::Builder,
    }
    impl<C, M, R> GetBucketsAggregation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketsAggregation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketsAggregationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketsAggregationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketsAggregationInputOperationOutputAlias,
                crate::output::GetBucketsAggregationOutput,
                crate::error::GetBucketsAggregationError,
                crate::input::GetBucketsAggregationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The aggregation field.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The aggregation field.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The version of the query.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The version of the query.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
        /// <p>The basic control of the response shape and the bucket aggregation type to perform. </p>
        pub fn buckets_aggregation_type(
            mut self,
            input: crate::model::BucketsAggregationType,
        ) -> Self {
            self.inner = self.inner.buckets_aggregation_type(input);
            self
        }
        /// <p>The basic control of the response shape and the bucket aggregation type to perform. </p>
        pub fn set_buckets_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::BucketsAggregationType>,
        ) -> Self {
            self.inner = self.inner.set_buckets_aggregation_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCardinality`.
    ///
    /// <p>Returns the approximate count of unique values that match the query.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetCardinality</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCardinality<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cardinality_input::Builder,
    }
    impl<C, M, R> GetCardinality<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCardinality`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCardinalityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCardinalityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCardinalityInputOperationOutputAlias,
                crate::output::GetCardinalityOutput,
                crate::error::GetCardinalityError,
                crate::input::GetCardinalityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEffectivePolicies`.
    ///
    /// <p>Gets a list of the policies that have an effect on the authorization behavior of the specified device when it connects to the IoT device gateway.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetEffectivePolicies</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEffectivePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_effective_policies_input::Builder,
    }
    impl<C, M, R> GetEffectivePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEffectivePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEffectivePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEffectivePoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEffectivePoliciesInputOperationOutputAlias,
                crate::output::GetEffectivePoliciesOutput,
                crate::error::GetEffectivePoliciesError,
                crate::input::GetEffectivePoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The Cognito identity pool ID.</p>
        pub fn cognito_identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cognito_identity_pool_id(input.into());
            self
        }
        /// <p>The Cognito identity pool ID.</p>
        pub fn set_cognito_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cognito_identity_pool_id(input);
            self
        }
        /// <p>The thing name.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The thing name.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIndexingConfiguration`.
    ///
    /// <p>Gets the indexing configuration.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetIndexingConfiguration</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIndexingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_indexing_configuration_input::Builder,
    }
    impl<C, M, R> GetIndexingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIndexingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIndexingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIndexingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIndexingConfigurationInputOperationOutputAlias,
                crate::output::GetIndexingConfigurationOutput,
                crate::error::GetIndexingConfigurationError,
                crate::input::GetIndexingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetJobDocument`.
    ///
    /// <p>Gets a job document.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetJobDocument</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJobDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_document_input::Builder,
    }
    impl<C, M, R> GetJobDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobDocumentInputOperationOutputAlias,
                crate::output::GetJobDocumentOutput,
                crate::error::GetJobDocumentError,
                crate::input::GetJobDocumentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoggingOptions`.
    ///
    /// <p>Gets the logging options.</p>
    /// <p>NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetLoggingOptions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_logging_options_input::Builder,
    }
    impl<C, M, R> GetLoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoggingOptionsInputOperationOutputAlias,
                crate::output::GetLoggingOptionsOutput,
                crate::error::GetLoggingOptionsError,
                crate::input::GetLoggingOptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetOTAUpdate`.
    ///
    /// <p>Gets an OTA update.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetOTAUpdate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOTAUpdate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ota_update_input::Builder,
    }
    impl<C, M, R> GetOTAUpdate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOTAUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOtaUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOTAUpdateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOtaUpdateInputOperationOutputAlias,
                crate::output::GetOtaUpdateOutput,
                crate::error::GetOTAUpdateError,
                crate::input::GetOtaUpdateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The OTA update ID.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ota_update_id(input.into());
            self
        }
        /// <p>The OTA update ID.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ota_update_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPercentiles`.
    ///
    /// <p>Groups the aggregated values that match the query into percentile groupings. The default percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This function returns a value for each percentile group specified (or the default percentile groupings). The percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately five percent of the values that match the query, and so on. The result is an approximation, the more values that match the query, the more accurate the percentile values.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPercentiles</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPercentiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_percentiles_input::Builder,
    }
    impl<C, M, R> GetPercentiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPercentiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPercentilesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPercentilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPercentilesInputOperationOutputAlias,
                crate::output::GetPercentilesOutput,
                crate::error::GetPercentilesError,
                crate::input::GetPercentilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
        /// Appends an item to `percents`.
        ///
        /// To override the contents of this collection use [`set_percents`](Self::set_percents).
        ///
        /// <p>The percentile groups returned.</p>
        pub fn percents(mut self, input: f64) -> Self {
            self.inner = self.inner.percents(input);
            self
        }
        /// <p>The percentile groups returned.</p>
        pub fn set_percents(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_percents(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// <p>Gets information about the specified policy with the policy document of the default version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl<C, M, R> GetPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyInputOperationOutputAlias,
                crate::output::GetPolicyOutput,
                crate::error::GetPolicyError,
                crate::input::GetPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicyVersion`.
    ///
    /// <p>Gets information about the specified policy version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetPolicyVersion</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_version_input::Builder,
    }
    impl<C, M, R> GetPolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyVersionInputOperationOutputAlias,
                crate::output::GetPolicyVersionOutput,
                crate::error::GetPolicyVersionError,
                crate::input::GetPolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_version_id(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegistrationCode`.
    ///
    /// <p>Gets a registration code used to register a CA certificate with IoT.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetRegistrationCode</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRegistrationCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_registration_code_input::Builder,
    }
    impl<C, M, R> GetRegistrationCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegistrationCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegistrationCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegistrationCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegistrationCodeInputOperationOutputAlias,
                crate::output::GetRegistrationCodeOutput,
                crate::error::GetRegistrationCodeError,
                crate::input::GetRegistrationCodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetStatistics`.
    ///
    /// <p>Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is returned.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetStatistics</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_statistics_input::Builder,
    }
    impl<C, M, R> GetStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStatisticsInputOperationOutputAlias,
                crate::output::GetStatisticsOutput,
                crate::error::GetStatisticsError,
                crate::input::GetStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the index to search. The default value is <code>AWS_Things</code>.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the index to search. The default value is <code>AWS_Things</code>.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The query used to search. You can specify "*" for the query string to get the count of all indexed things in your Amazon Web Services account.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The query used to search. You can specify "*" for the query string to get the count of all indexed things in your Amazon Web Services account.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The aggregation field name.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aggregation_field(input.into());
            self
        }
        /// <p>The aggregation field name.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_field(input);
            self
        }
        /// <p>The version of the query used to search.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_version(input.into());
            self
        }
        /// <p>The version of the query used to search.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTopicRule`.
    ///
    /// <p>Gets information about the rule.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRule</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTopicRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_topic_rule_input::Builder,
    }
    impl<C, M, R> GetTopicRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTopicRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTopicRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTopicRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTopicRuleInputOperationOutputAlias,
                crate::output::GetTopicRuleOutput,
                crate::error::GetTopicRuleError,
                crate::input::GetTopicRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTopicRuleDestination`.
    ///
    /// <p>Gets information about a topic rule destination.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetTopicRuleDestination</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTopicRuleDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_topic_rule_destination_input::Builder,
    }
    impl<C, M, R> GetTopicRuleDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTopicRuleDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTopicRuleDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTopicRuleDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTopicRuleDestinationInputOperationOutputAlias,
                crate::output::GetTopicRuleDestinationOutput,
                crate::error::GetTopicRuleDestinationError,
                crate::input::GetTopicRuleDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the topic rule destination.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the topic rule destination.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetV2LoggingOptions`.
    ///
    /// <p>Gets the fine grained logging options.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetV2LoggingOptions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetV2LoggingOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_v2_logging_options_input::Builder,
    }
    impl<C, M, R> GetV2LoggingOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetV2LoggingOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetV2LoggingOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetV2LoggingOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetV2LoggingOptionsInputOperationOutputAlias,
                crate::output::GetV2LoggingOptionsOutput,
                crate::error::GetV2LoggingOptionsError,
                crate::input::GetV2LoggingOptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListActiveViolations`.
    ///
    /// <p>Lists the active violations for a given Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListActiveViolations</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListActiveViolations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_active_violations_input::Builder,
    }
    impl<C, M, R> ListActiveViolations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListActiveViolations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActiveViolationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActiveViolationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListActiveViolationsInputOperationOutputAlias,
                crate::output::ListActiveViolationsOutput,
                crate::error::ListActiveViolationsError,
                crate::input::ListActiveViolationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListActiveViolationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListActiveViolationsPaginator<C, M, R> {
            crate::paginator::ListActiveViolationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the thing whose active violations are listed.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing whose active violations are listed.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>The name of the Device Defender security profile for which violations are listed.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name of the Device Defender security profile for which violations are listed.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p> The criteria for a behavior. </p>
        pub fn behavior_criteria_type(mut self, input: crate::model::BehaviorCriteriaType) -> Self {
            self.inner = self.inner.behavior_criteria_type(input);
            self
        }
        /// <p> The criteria for a behavior. </p>
        pub fn set_behavior_criteria_type(
            mut self,
            input: std::option::Option<crate::model::BehaviorCriteriaType>,
        ) -> Self {
            self.inner = self.inner.set_behavior_criteria_type(input);
            self
        }
        /// <p> A list of all suppressed alerts. </p>
        pub fn list_suppressed_alerts(mut self, input: bool) -> Self {
            self.inner = self.inner.list_suppressed_alerts(input);
            self
        }
        /// <p> A list of all suppressed alerts. </p>
        pub fn set_list_suppressed_alerts(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_list_suppressed_alerts(input);
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.inner = self.inner.verification_state(input);
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.inner = self.inner.set_verification_state(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachedPolicies`.
    ///
    /// <p>Lists the policies attached to the specified thing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAttachedPolicies</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttachedPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attached_policies_input::Builder,
    }
    impl<C, M, R> ListAttachedPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttachedPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachedPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachedPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttachedPoliciesInputOperationOutputAlias,
                crate::output::ListAttachedPoliciesOutput,
                crate::error::ListAttachedPoliciesError,
                crate::input::ListAttachedPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttachedPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttachedPoliciesPaginator<C, M, R> {
            crate::paginator::ListAttachedPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The group or principal for which the policies will be listed. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The group or principal for which the policies will be listed. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>When true, recursively list attached policies.</p>
        pub fn recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.recursive(input);
            self
        }
        /// <p>When true, recursively list attached policies.</p>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAuditFindings`.
    ///
    /// <p>Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time period. (Findings are retained for 90 days.)</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditFindings</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAuditFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_audit_findings_input::Builder,
    }
    impl<C, M, R> ListAuditFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAuditFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAuditFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAuditFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAuditFindingsInputOperationOutputAlias,
                crate::output::ListAuditFindingsOutput,
                crate::error::ListAuditFindingsError,
                crate::input::ListAuditFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAuditFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAuditFindingsPaginator<C, M, R> {
            crate::paginator::ListAuditFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime and endTime, but not both.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime and endTime, but not both.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>A filter to limit results to the findings for the specified audit check.</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>A filter to limit results to the findings for the specified audit check.</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information identifying the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information identifying the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>A filter to limit results to those found before the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>A filter to limit results to those found before the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be listed. If this parameter isn't provided, the response will list both suppressed and unsuppressed findings. </p>
        pub fn list_suppressed_findings(mut self, input: bool) -> Self {
            self.inner = self.inner.list_suppressed_findings(input);
            self
        }
        /// <p> Boolean flag indicating whether only the suppressed findings or the unsuppressed findings should be listed. If this parameter isn't provided, the response will list both suppressed and unsuppressed findings. </p>
        pub fn set_list_suppressed_findings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_list_suppressed_findings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAuditMitigationActionsExecutions`.
    ///
    /// <p>Gets the status of audit mitigation action tasks that were executed.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsExecutions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAuditMitigationActionsExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_audit_mitigation_actions_executions_input::Builder,
    }
    impl<C, M, R> ListAuditMitigationActionsExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAuditMitigationActionsExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAuditMitigationActionsExecutionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAuditMitigationActionsExecutionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAuditMitigationActionsExecutionsInputOperationOutputAlias,
                crate::output::ListAuditMitigationActionsExecutionsOutput,
                crate::error::ListAuditMitigationActionsExecutionsError,
                crate::input::ListAuditMitigationActionsExecutionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAuditMitigationActionsExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAuditMitigationActionsExecutionsPaginator<C, M, R> {
            crate::paginator::ListAuditMitigationActionsExecutionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>Specify this filter to limit results to actions for a specific audit mitigation actions task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>Specify this filter to limit results to actions for a specific audit mitigation actions task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>Specify this filter to limit results to those with a specific status.</p>
        pub fn action_status(
            mut self,
            input: crate::model::AuditMitigationActionsExecutionStatus,
        ) -> Self {
            self.inner = self.inner.action_status(input);
            self
        }
        /// <p>Specify this filter to limit results to those with a specific status.</p>
        pub fn set_action_status(
            mut self,
            input: std::option::Option<crate::model::AuditMitigationActionsExecutionStatus>,
        ) -> Self {
            self.inner = self.inner.set_action_status(input);
            self
        }
        /// <p>Specify this filter to limit results to those that were applied to a specific audit finding.</p>
        pub fn finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_id(input.into());
            self
        }
        /// <p>Specify this filter to limit results to those that were applied to a specific audit finding.</p>
        pub fn set_finding_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_finding_id(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAuditMitigationActionsTasks`.
    ///
    /// <p>Gets a list of audit mitigation action tasks that match the specified filters.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditMitigationActionsTasks</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAuditMitigationActionsTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_audit_mitigation_actions_tasks_input::Builder,
    }
    impl<C, M, R> ListAuditMitigationActionsTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAuditMitigationActionsTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAuditMitigationActionsTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAuditMitigationActionsTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAuditMitigationActionsTasksInputOperationOutputAlias,
                crate::output::ListAuditMitigationActionsTasksOutput,
                crate::error::ListAuditMitigationActionsTasksError,
                crate::input::ListAuditMitigationActionsTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAuditMitigationActionsTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAuditMitigationActionsTasksPaginator<C, M, R> {
            crate::paginator::ListAuditMitigationActionsTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify this filter to limit results to tasks that were applied to results for a specific audit.</p>
        pub fn audit_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.audit_task_id(input.into());
            self
        }
        /// <p>Specify this filter to limit results to tasks that were applied to results for a specific audit.</p>
        pub fn set_audit_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_audit_task_id(input);
            self
        }
        /// <p>Specify this filter to limit results to tasks that were applied to a specific audit finding.</p>
        pub fn finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_id(input.into());
            self
        }
        /// <p>Specify this filter to limit results to tasks that were applied to a specific audit finding.</p>
        pub fn set_finding_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_finding_id(input);
            self
        }
        /// <p>Specify this filter to limit results to tasks that are in a specific state.</p>
        pub fn task_status(
            mut self,
            input: crate::model::AuditMitigationActionsTaskStatus,
        ) -> Self {
            self.inner = self.inner.task_status(input);
            self
        }
        /// <p>Specify this filter to limit results to tasks that are in a specific state.</p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::AuditMitigationActionsTaskStatus>,
        ) -> Self {
            self.inner = self.inner.set_task_status(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specify this filter to limit results to tasks that began on or after a specific date and time.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>Specify this filter to limit results to tasks that began on or after a specific date and time.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>Specify this filter to limit results to tasks that were completed or canceled on or before a specific date and time.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>Specify this filter to limit results to tasks that were completed or canceled on or before a specific date and time.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAuditSuppressions`.
    ///
    /// <p> Lists your Device Defender audit listings. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditSuppressions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAuditSuppressions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_audit_suppressions_input::Builder,
    }
    impl<C, M, R> ListAuditSuppressions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAuditSuppressions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAuditSuppressionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAuditSuppressionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAuditSuppressionsInputOperationOutputAlias,
                crate::output::ListAuditSuppressionsOutput,
                crate::error::ListAuditSuppressionsError,
                crate::input::ListAuditSuppressionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAuditSuppressionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAuditSuppressionsPaginator<C, M, R> {
            crate::paginator::ListAuditSuppressionsPaginator::new(self.handle, self.inner)
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.check_name(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_check_name(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.inner = self.inner.resource_identifier(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p> Determines whether suppressions are listed in ascending order by expiration date or not. If parameter isn't provided, <code>ascendingOrder=true</code>. </p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p> Determines whether suppressions are listed in ascending order by expiration date or not. If parameter isn't provided, <code>ascendingOrder=true</code>. </p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAuditTasks`.
    ///
    /// <p>Lists the Device Defender audits that have been performed during a given time period.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuditTasks</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAuditTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_audit_tasks_input::Builder,
    }
    impl<C, M, R> ListAuditTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAuditTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAuditTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAuditTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAuditTasksInputOperationOutputAlias,
                crate::output::ListAuditTasksOutput,
                crate::error::ListAuditTasksError,
                crate::input::ListAuditTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAuditTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAuditTasksPaginator<C, M, R> {
            crate::paginator::ListAuditTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>The beginning of the time period. Audit information is retained for a limited time (90 days). Requesting a start time prior to what is retained results in an "InvalidRequestException".</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The beginning of the time period. Audit information is retained for a limited time (90 days). Requesting a start time prior to what is retained results in an "InvalidRequestException".</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time period.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".</p>
        pub fn task_type(mut self, input: crate::model::AuditTaskType) -> Self {
            self.inner = self.inner.task_type(input);
            self
        }
        /// <p>A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".</p>
        pub fn set_task_type(
            mut self,
            input: std::option::Option<crate::model::AuditTaskType>,
        ) -> Self {
            self.inner = self.inner.set_task_type(input);
            self
        }
        /// <p>A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
        pub fn task_status(mut self, input: crate::model::AuditTaskStatus) -> Self {
            self.inner = self.inner.task_status(input);
            self
        }
        /// <p>A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::AuditTaskStatus>,
        ) -> Self {
            self.inner = self.inner.set_task_status(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAuthorizers`.
    ///
    /// <p>Lists the authorizers registered in your account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListAuthorizers</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAuthorizers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_authorizers_input::Builder,
    }
    impl<C, M, R> ListAuthorizers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAuthorizers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAuthorizersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAuthorizersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAuthorizersInputOperationOutputAlias,
                crate::output::ListAuthorizersOutput,
                crate::error::ListAuthorizersError,
                crate::input::ListAuthorizersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAuthorizersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAuthorizersPaginator<C, M, R> {
            crate::paginator::ListAuthorizersPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Return the list of authorizers in ascending alphabetical order.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Return the list of authorizers in ascending alphabetical order.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
        /// <p>The status of the list authorizers request.</p>
        pub fn status(mut self, input: crate::model::AuthorizerStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the list authorizers request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuthorizerStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBillingGroups`.
    ///
    /// <p>Lists the billing groups you have created.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListBillingGroups</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBillingGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_billing_groups_input::Builder,
    }
    impl<C, M, R> ListBillingGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBillingGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBillingGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBillingGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBillingGroupsInputOperationOutputAlias,
                crate::output::ListBillingGroupsOutput,
                crate::error::ListBillingGroupsError,
                crate::input::ListBillingGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBillingGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBillingGroupsPaginator<C, M, R> {
            crate::paginator::ListBillingGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Limit the results to billing groups whose names have the given prefix.</p>
        pub fn name_prefix_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix_filter(input.into());
            self
        }
        /// <p>Limit the results to billing groups whose names have the given prefix.</p>
        pub fn set_name_prefix_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_prefix_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCACertificates`.
    ///
    /// <p>Lists the CA certificates registered for your Amazon Web Services account.</p>
    /// <p>The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCACertificates</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCACertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ca_certificates_input::Builder,
    }
    impl<C, M, R> ListCACertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCACertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCaCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCACertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCaCertificatesInputOperationOutputAlias,
                crate::output::ListCaCertificatesOutput,
                crate::error::ListCACertificatesError,
                crate::input::ListCaCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCaCertificatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCaCertificatesPaginator<C, M, R> {
            crate::paginator::ListCaCertificatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Determines the order of the results.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Determines the order of the results.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCertificates`.
    ///
    /// <p>Lists the certificates registered in your Amazon Web Services account.</p>
    /// <p>The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificates</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_certificates_input::Builder,
    }
    impl<C, M, R> ListCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCertificatesInputOperationOutputAlias,
                crate::output::ListCertificatesOutput,
                crate::error::ListCertificatesError,
                crate::input::ListCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCertificatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCertificatesPaginator<C, M, R> {
            crate::paginator::ListCertificatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCertificatesByCA`.
    ///
    /// <p>List the device certificates signed by the specified CA certificate.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCertificatesByCA</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCertificatesByCA<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_certificates_by_ca_input::Builder,
    }
    impl<C, M, R> ListCertificatesByCA<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCertificatesByCA`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCertificatesByCaOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCertificatesByCAError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCertificatesByCaInputOperationOutputAlias,
                crate::output::ListCertificatesByCaOutput,
                crate::error::ListCertificatesByCAError,
                crate::input::ListCertificatesByCaInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCertificatesByCaPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCertificatesByCaPaginator<C, M, R> {
            crate::paginator::ListCertificatesByCaPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the CA certificate. This operation will list all registered device certificate that were signed by this CA certificate.</p>
        pub fn ca_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ca_certificate_id(input.into());
            self
        }
        /// <p>The ID of the CA certificate. This operation will list all registered device certificate that were signed by this CA certificate.</p>
        pub fn set_ca_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ca_certificate_id(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomMetrics`.
    ///
    /// <p> Lists your Device Defender detect custom metrics. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListCustomMetrics</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_metrics_input::Builder,
    }
    impl<C, M, R> ListCustomMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomMetricsInputOperationOutputAlias,
                crate::output::ListCustomMetricsOutput,
                crate::error::ListCustomMetricsError,
                crate::input::ListCustomMetricsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomMetricsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCustomMetricsPaginator<C, M, R> {
            crate::paginator::ListCustomMetricsPaginator::new(self.handle, self.inner)
        }
        /// <p> The token for the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDetectMitigationActionsExecutions`.
    ///
    /// <p> Lists mitigation actions executions for a Device Defender ML Detect Security Profile. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsExecutions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDetectMitigationActionsExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_detect_mitigation_actions_executions_input::Builder,
    }
    impl<C, M, R> ListDetectMitigationActionsExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDetectMitigationActionsExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDetectMitigationActionsExecutionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListDetectMitigationActionsExecutionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDetectMitigationActionsExecutionsInputOperationOutputAlias,
                crate::output::ListDetectMitigationActionsExecutionsOutput,
                crate::error::ListDetectMitigationActionsExecutionsError,
                crate::input::ListDetectMitigationActionsExecutionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDetectMitigationActionsExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDetectMitigationActionsExecutionsPaginator<C, M, R> {
            crate::paginator::ListDetectMitigationActionsExecutionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p> The unique identifier of the violation. </p>
        pub fn violation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.violation_id(input.into());
            self
        }
        /// <p> The unique identifier of the violation. </p>
        pub fn set_violation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_violation_id(input);
            self
        }
        /// <p> The name of the thing whose mitigation actions are listed. </p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p> The name of the thing whose mitigation actions are listed. </p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The end of the time period for which ML Detect mitigation actions executions are returned. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The end of the time period for which ML Detect mitigation actions executions are returned. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDetectMitigationActionsTasks`.
    ///
    /// <p> List of Device Defender ML Detect mitigation actions tasks. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDetectMitigationActionsTasks</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDetectMitigationActionsTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_detect_mitigation_actions_tasks_input::Builder,
    }
    impl<C, M, R> ListDetectMitigationActionsTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDetectMitigationActionsTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDetectMitigationActionsTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDetectMitigationActionsTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDetectMitigationActionsTasksInputOperationOutputAlias,
                crate::output::ListDetectMitigationActionsTasksOutput,
                crate::error::ListDetectMitigationActionsTasksError,
                crate::input::ListDetectMitigationActionsTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDetectMitigationActionsTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDetectMitigationActionsTasksPaginator<C, M, R> {
            crate::paginator::ListDetectMitigationActionsTasksPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p> A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p> The end of the time period for which ML Detect mitigation actions tasks are returned. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p> The end of the time period for which ML Detect mitigation actions tasks are returned. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDimensions`.
    ///
    /// <p>List the set of dimensions that are defined for your Amazon Web Services accounts.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDimensions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDimensions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dimensions_input::Builder,
    }
    impl<C, M, R> ListDimensions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDimensions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDimensionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDimensionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDimensionsInputOperationOutputAlias,
                crate::output::ListDimensionsOutput,
                crate::error::ListDimensionsError,
                crate::input::ListDimensionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDimensionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDimensionsPaginator<C, M, R> {
            crate::paginator::ListDimensionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to retrieve at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to retrieve at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainConfigurations`.
    ///
    /// <p>Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration name.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListDomainConfigurations</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domain_configurations_input::Builder,
    }
    impl<C, M, R> ListDomainConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomainConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainConfigurationsInputOperationOutputAlias,
                crate::output::ListDomainConfigurationsOutput,
                crate::error::ListDomainConfigurationsError,
                crate::input::ListDomainConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDomainConfigurationsPaginator<C, M, R> {
            crate::paginator::ListDomainConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.inner = self.inner.service_type(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.inner = self.inner.set_service_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFleetMetrics`.
    ///
    /// <p>Lists all your fleet metrics. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListFleetMetrics</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFleetMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fleet_metrics_input::Builder,
    }
    impl<C, M, R> ListFleetMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFleetMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFleetMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFleetMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFleetMetricsInputOperationOutputAlias,
                crate::output::ListFleetMetricsOutput,
                crate::error::ListFleetMetricsError,
                crate::input::ListFleetMetricsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFleetMetricsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFleetMetricsPaginator<C, M, R> {
            crate::paginator::ListFleetMetricsPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <code>null</code> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <code>null</code> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIndices`.
    ///
    /// <p>Lists the search indices.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListIndices</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIndices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_indices_input::Builder,
    }
    impl<C, M, R> ListIndices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIndices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIndicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIndicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIndicesInputOperationOutputAlias,
                crate::output::ListIndicesOutput,
                crate::error::ListIndicesError,
                crate::input::ListIndicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIndicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIndicesPaginator<C, M, R> {
            crate::paginator::ListIndicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobExecutionsForJob`.
    ///
    /// <p>Lists the job executions for a job.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForJob</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobExecutionsForJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_job_executions_for_job_input::Builder,
    }
    impl<C, M, R> ListJobExecutionsForJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobExecutionsForJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobExecutionsForJobOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobExecutionsForJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobExecutionsForJobInputOperationOutputAlias,
                crate::output::ListJobExecutionsForJobOutput,
                crate::error::ListJobExecutionsForJobError,
                crate::input::ListJobExecutionsForJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobExecutionsForJobPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobExecutionsForJobPaginator<C, M, R> {
            crate::paginator::ListJobExecutionsForJobPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The status of the job.</p>
        pub fn status(mut self, input: crate::model::JobExecutionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::JobExecutionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobExecutionsForThing`.
    ///
    /// <p>Lists the job executions for the specified thing.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobExecutionsForThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobExecutionsForThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_job_executions_for_thing_input::Builder,
    }
    impl<C, M, R> ListJobExecutionsForThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobExecutionsForThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobExecutionsForThingOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobExecutionsForThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobExecutionsForThingInputOperationOutputAlias,
                crate::output::ListJobExecutionsForThingOutput,
                crate::error::ListJobExecutionsForThingError,
                crate::input::ListJobExecutionsForThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobExecutionsForThingPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListJobExecutionsForThingPaginator<C, M, R> {
            crate::paginator::ListJobExecutionsForThingPaginator::new(self.handle, self.inner)
        }
        /// <p>The thing name.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The thing name.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>An optional filter that lets you search for jobs that have the specified status.</p>
        pub fn status(mut self, input: crate::model::JobExecutionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>An optional filter that lets you search for jobs that have the specified status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::JobExecutionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Lists jobs.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobs</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsPaginator<C, M, R> {
            crate::paginator::ListJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional filter that lets you search for jobs that have the specified status.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>An optional filter that lets you search for jobs that have the specified status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group. </p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.inner = self.inner.target_selection(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group. </p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.inner = self.inner.set_target_selection(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter that limits the returned jobs to those for the specified group.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>A filter that limits the returned jobs to those for the specified group.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>A filter that limits the returned jobs to those for the specified group.</p>
        pub fn thing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_id(input.into());
            self
        }
        /// <p>A filter that limits the returned jobs to those for the specified group.</p>
        pub fn set_thing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_id(input);
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace_id(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobTemplates`.
    ///
    /// <p>Returns a list of job templates.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListJobTemplates</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_job_templates_input::Builder,
    }
    impl<C, M, R> ListJobTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobTemplatesInputOperationOutputAlias,
                crate::output::ListJobTemplatesOutput,
                crate::error::ListJobTemplatesError,
                crate::input::ListJobTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobTemplatesPaginator<C, M, R> {
            crate::paginator::ListJobTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use to return the next set of results in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to return the next set of results in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedJobTemplates`.
    ///
    /// <p>Returns a list of managed job templates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListManagedJobTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_managed_job_templates_input::Builder,
    }
    impl<C, M, R> ListManagedJobTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListManagedJobTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedJobTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedJobTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListManagedJobTemplatesInputOperationOutputAlias,
                crate::output::ListManagedJobTemplatesOutput,
                crate::error::ListManagedJobTemplatesError,
                crate::input::ListManagedJobTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional parameter for template name. If specified, only the versions of the managed job templates that have the specified template name will be returned.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>An optional parameter for template name. If specified, only the versions of the managed job templates that have the specified template name will be returned.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>Maximum number of entries that can be returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of entries that can be returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMitigationActions`.
    ///
    /// <p>Gets a list of all mitigation actions that match the specified filter criteria.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListMitigationActions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMitigationActions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mitigation_actions_input::Builder,
    }
    impl<C, M, R> ListMitigationActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMitigationActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMitigationActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMitigationActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMitigationActionsInputOperationOutputAlias,
                crate::output::ListMitigationActionsOutput,
                crate::error::ListMitigationActionsError,
                crate::input::ListMitigationActionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMitigationActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMitigationActionsPaginator<C, M, R> {
            crate::paginator::ListMitigationActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify a value to limit the result to mitigation actions with a specific action type.</p>
        pub fn action_type(mut self, input: crate::model::MitigationActionType) -> Self {
            self.inner = self.inner.action_type(input);
            self
        }
        /// <p>Specify a value to limit the result to mitigation actions with a specific action type.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::MitigationActionType>,
        ) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOTAUpdates`.
    ///
    /// <p>Lists OTA updates.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOTAUpdates</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOTAUpdates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ota_updates_input::Builder,
    }
    impl<C, M, R> ListOTAUpdates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOTAUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOtaUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOTAUpdatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOtaUpdatesInputOperationOutputAlias,
                crate::output::ListOtaUpdatesOutput,
                crate::error::ListOTAUpdatesError,
                crate::input::ListOtaUpdatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOtaUpdatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOtaUpdatesPaginator<C, M, R> {
            crate::paginator::ListOtaUpdatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The OTA update job status.</p>
        pub fn ota_update_status(mut self, input: crate::model::OtaUpdateStatus) -> Self {
            self.inner = self.inner.ota_update_status(input);
            self
        }
        /// <p>The OTA update job status.</p>
        pub fn set_ota_update_status(
            mut self,
            input: std::option::Option<crate::model::OtaUpdateStatus>,
        ) -> Self {
            self.inner = self.inner.set_ota_update_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOutgoingCertificates`.
    ///
    /// <p>Lists certificates that are being transferred but not yet accepted.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListOutgoingCertificates</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOutgoingCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_outgoing_certificates_input::Builder,
    }
    impl<C, M, R> ListOutgoingCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOutgoingCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOutgoingCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOutgoingCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOutgoingCertificatesInputOperationOutputAlias,
                crate::output::ListOutgoingCertificatesOutput,
                crate::error::ListOutgoingCertificatesError,
                crate::input::ListOutgoingCertificatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOutgoingCertificatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListOutgoingCertificatesPaginator<C, M, R> {
            crate::paginator::ListOutgoingCertificatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicies`.
    ///
    /// <p>Lists your policies.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicies</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policies_input::Builder,
    }
    impl<C, M, R> ListPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPoliciesInputOperationOutputAlias,
                crate::output::ListPoliciesOutput,
                crate::error::ListPoliciesError,
                crate::input::ListPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPoliciesPaginator<C, M, R> {
            crate::paginator::ListPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyPrincipals`.
    ///
    /// <p>Lists the principals associated with the specified policy.</p>
    /// <p> <b>Note:</b> This action is deprecated. Please use <code>ListTargetsForPolicy</code> instead.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyPrincipals</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPolicyPrincipals<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policy_principals_input::Builder,
    }
    impl<C, M, R> ListPolicyPrincipals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicyPrincipals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyPrincipalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyPrincipalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPolicyPrincipalsInputOperationOutputAlias,
                crate::output::ListPolicyPrincipalsOutput,
                crate::error::ListPolicyPrincipalsError,
                crate::input::ListPolicyPrincipalsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPolicyPrincipalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPolicyPrincipalsPaginator<C, M, R> {
            crate::paginator::ListPolicyPrincipalsPaginator::new(self.handle, self.inner)
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyVersions`.
    ///
    /// <p>Lists the versions of the specified policy and identifies the default version.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPolicyVersions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPolicyVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policy_versions_input::Builder,
    }
    impl<C, M, R> ListPolicyVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicyVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPolicyVersionsInputOperationOutputAlias,
                crate::output::ListPolicyVersionsOutput,
                crate::error::ListPolicyVersionsError,
                crate::input::ListPolicyVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrincipalPolicies`.
    ///
    /// <p>Lists the policies attached to the specified principal. If you use an Cognito identity, the ID must be in <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax">AmazonCognito Identity format</a>.</p>
    /// <p> <b>Note:</b> This action is deprecated. Please use <code>ListAttachedPolicies</code> instead.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalPolicies</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPrincipalPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_principal_policies_input::Builder,
    }
    impl<C, M, R> ListPrincipalPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPrincipalPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPrincipalPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPrincipalPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPrincipalPoliciesInputOperationOutputAlias,
                crate::output::ListPrincipalPoliciesOutput,
                crate::error::ListPrincipalPoliciesError,
                crate::input::ListPrincipalPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPrincipalPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPrincipalPoliciesPaginator<C, M, R> {
            crate::paginator::ListPrincipalPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>The marker for the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The result page size.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>Specifies the order for results. If true, results are returned in ascending creation order.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Specifies the order for results. If true, results are returned in ascending creation order.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrincipalThings`.
    ///
    /// <p>Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListPrincipalThings</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPrincipalThings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_principal_things_input::Builder,
    }
    impl<C, M, R> ListPrincipalThings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPrincipalThings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPrincipalThingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPrincipalThingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPrincipalThingsInputOperationOutputAlias,
                crate::output::ListPrincipalThingsOutput,
                crate::error::ListPrincipalThingsError,
                crate::input::ListPrincipalThingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPrincipalThingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPrincipalThingsPaginator<C, M, R> {
            crate::paginator::ListPrincipalThingsPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The principal.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The principal.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisioningTemplates`.
    ///
    /// <p>Lists the fleet provisioning templates in your Amazon Web Services account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplates</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProvisioningTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_provisioning_templates_input::Builder,
    }
    impl<C, M, R> ListProvisioningTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProvisioningTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisioningTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisioningTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProvisioningTemplatesInputOperationOutputAlias,
                crate::output::ListProvisioningTemplatesOutput,
                crate::error::ListProvisioningTemplatesError,
                crate::input::ListProvisioningTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProvisioningTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListProvisioningTemplatesPaginator<C, M, R> {
            crate::paginator::ListProvisioningTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisioningTemplateVersions`.
    ///
    /// <p>A list of fleet provisioning template versions.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListProvisioningTemplateVersions</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProvisioningTemplateVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_provisioning_template_versions_input::Builder,
    }
    impl<C, M, R> ListProvisioningTemplateVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProvisioningTemplateVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisioningTemplateVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisioningTemplateVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProvisioningTemplateVersionsInputOperationOutputAlias,
                crate::output::ListProvisioningTemplateVersionsOutput,
                crate::error::ListProvisioningTemplateVersionsError,
                crate::input::ListProvisioningTemplateVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProvisioningTemplateVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListProvisioningTemplateVersionsPaginator<C, M, R> {
            crate::paginator::ListProvisioningTemplateVersionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_name(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_name(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoleAliases`.
    ///
    /// <p>Lists the role aliases registered in your account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListRoleAliases</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRoleAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_role_aliases_input::Builder,
    }
    impl<C, M, R> ListRoleAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoleAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoleAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoleAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoleAliasesInputOperationOutputAlias,
                crate::output::ListRoleAliasesOutput,
                crate::error::ListRoleAliasesError,
                crate::input::ListRoleAliasesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoleAliasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRoleAliasesPaginator<C, M, R> {
            crate::paginator::ListRoleAliasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Return the list of role aliases in ascending alphabetical order.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Return the list of role aliases in ascending alphabetical order.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListScheduledAudits`.
    ///
    /// <p>Lists all of your scheduled audits.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListScheduledAudits</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListScheduledAudits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_scheduled_audits_input::Builder,
    }
    impl<C, M, R> ListScheduledAudits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListScheduledAudits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListScheduledAuditsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListScheduledAuditsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListScheduledAuditsInputOperationOutputAlias,
                crate::output::ListScheduledAuditsOutput,
                crate::error::ListScheduledAuditsError,
                crate::input::ListScheduledAuditsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListScheduledAuditsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListScheduledAuditsPaginator<C, M, R> {
            crate::paginator::ListScheduledAuditsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time. The default is 25.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityProfiles`.
    ///
    /// <p>Lists the Device Defender security profiles you've created. You can filter security profiles by dimension or custom metric.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfiles</a> action.</p> <note>
    /// <p> <code>dimensionName</code> and <code>metricName</code> cannot be used in the same request.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecurityProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_profiles_input::Builder,
    }
    impl<C, M, R> ListSecurityProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityProfilesInputOperationOutputAlias,
                crate::output::ListSecurityProfilesOutput,
                crate::error::ListSecurityProfilesError,
                crate::input::ListSecurityProfilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecurityProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecurityProfilesPaginator<C, M, R> {
            crate::paginator::ListSecurityProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A filter to limit results to the security profiles that use the defined dimension. Cannot be used with <code>metricName</code> </p>
        pub fn dimension_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dimension_name(input.into());
            self
        }
        /// <p>A filter to limit results to the security profiles that use the defined dimension. Cannot be used with <code>metricName</code> </p>
        pub fn set_dimension_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dimension_name(input);
            self
        }
        /// <p> The name of the custom metric. Cannot be used with <code>dimensionName</code>. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p> The name of the custom metric. Cannot be used with <code>dimensionName</code>. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityProfilesForTarget`.
    ///
    /// <p>Lists the Device Defender security profiles attached to a target (thing group).</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSecurityProfilesForTarget</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecurityProfilesForTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_profiles_for_target_input::Builder,
    }
    impl<C, M, R> ListSecurityProfilesForTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityProfilesForTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityProfilesForTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityProfilesForTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityProfilesForTargetInputOperationOutputAlias,
                crate::output::ListSecurityProfilesForTargetOutput,
                crate::error::ListSecurityProfilesForTargetError,
                crate::input::ListSecurityProfilesForTargetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecurityProfilesForTargetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListSecurityProfilesForTargetPaginator<C, M, R> {
            crate::paginator::ListSecurityProfilesForTargetPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If true, return child groups too.</p>
        pub fn recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.recursive(input);
            self
        }
        /// <p>If true, return child groups too.</p>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
        /// <p>The ARN of the target (thing group) whose attached security profiles you want to get.</p>
        pub fn security_profile_target_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.security_profile_target_arn(input.into());
            self
        }
        /// <p>The ARN of the target (thing group) whose attached security profiles you want to get.</p>
        pub fn set_security_profile_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreams`.
    ///
    /// <p>Lists all of the streams in your Amazon Web Services account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListStreams</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_streams_input::Builder,
    }
    impl<C, M, R> ListStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamsInputOperationOutputAlias,
                crate::output::ListStreamsOutput,
                crate::error::ListStreamsError,
                crate::input::ListStreamsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamsPaginator<C, M, R> {
            crate::paginator::ListStreamsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return at a time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at a time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token used to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Set to true to return the list of streams in ascending order.</p>
        pub fn ascending_order(mut self, input: bool) -> Self {
            self.inner = self.inner.ascending_order(input);
            self
        }
        /// <p>Set to true to return the list of streams in ascending order.</p>
        pub fn set_ascending_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ascending_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags (metadata) you have assigned to the resource.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTagsForResource</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator<C, M, R> {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargetsForPolicy`.
    ///
    /// <p>List targets for the specified policy.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForPolicy</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTargetsForPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_targets_for_policy_input::Builder,
    }
    impl<C, M, R> ListTargetsForPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTargetsForPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsForPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsForPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTargetsForPolicyInputOperationOutputAlias,
                crate::output::ListTargetsForPolicyOutput,
                crate::error::ListTargetsForPolicyError,
                crate::input::ListTargetsForPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTargetsForPolicyPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTargetsForPolicyPaginator<C, M, R> {
            crate::paginator::ListTargetsForPolicyPaginator::new(self.handle, self.inner)
        }
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A marker used to get the next set of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargetsForSecurityProfile`.
    ///
    /// <p>Lists the targets (thing groups) associated with a given Device Defender security profile.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTargetsForSecurityProfile</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTargetsForSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_targets_for_security_profile_input::Builder,
    }
    impl<C, M, R> ListTargetsForSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTargetsForSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsForSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsForSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTargetsForSecurityProfileInputOperationOutputAlias,
                crate::output::ListTargetsForSecurityProfileOutput,
                crate::error::ListTargetsForSecurityProfileError,
                crate::input::ListTargetsForSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTargetsForSecurityProfilePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListTargetsForSecurityProfilePaginator<C, M, R> {
            crate::paginator::ListTargetsForSecurityProfilePaginator::new(self.handle, self.inner)
        }
        /// <p>The security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingGroups`.
    ///
    /// <p>List the thing groups in your account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroups</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_thing_groups_input::Builder,
    }
    impl<C, M, R> ListThingGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingGroupsInputOperationOutputAlias,
                crate::output::ListThingGroupsOutput,
                crate::error::ListThingGroupsError,
                crate::input::ListThingGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThingGroupsPaginator<C, M, R> {
            crate::paginator::ListThingGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A filter that limits the results to those with the specified parent group.</p>
        pub fn parent_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_group(input.into());
            self
        }
        /// <p>A filter that limits the results to those with the specified parent group.</p>
        pub fn set_parent_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_group(input);
            self
        }
        /// <p>A filter that limits the results to those with the specified name prefix.</p>
        pub fn name_prefix_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix_filter(input.into());
            self
        }
        /// <p>A filter that limits the results to those with the specified name prefix.</p>
        pub fn set_name_prefix_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_prefix_filter(input);
            self
        }
        /// <p>If true, return child groups as well.</p>
        pub fn recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.recursive(input);
            self
        }
        /// <p>If true, return child groups as well.</p>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingGroupsForThing`.
    ///
    /// <p>List the thing groups to which the specified thing belongs.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingGroupsForThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingGroupsForThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_thing_groups_for_thing_input::Builder,
    }
    impl<C, M, R> ListThingGroupsForThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingGroupsForThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingGroupsForThingOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingGroupsForThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingGroupsForThingInputOperationOutputAlias,
                crate::output::ListThingGroupsForThingOutput,
                crate::error::ListThingGroupsForThingError,
                crate::input::ListThingGroupsForThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingGroupsForThingPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThingGroupsForThingPaginator<C, M, R> {
            crate::paginator::ListThingGroupsForThingPaginator::new(self.handle, self.inner)
        }
        /// <p>The thing name.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The thing name.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingPrincipals`.
    ///
    /// <p>Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingPrincipals</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingPrincipals<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_thing_principals_input::Builder,
    }
    impl<C, M, R> ListThingPrincipals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingPrincipals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingPrincipalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingPrincipalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingPrincipalsInputOperationOutputAlias,
                crate::output::ListThingPrincipalsOutput,
                crate::error::ListThingPrincipalsError,
                crate::input::ListThingPrincipalsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingPrincipalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThingPrincipalsPaginator<C, M, R> {
            crate::paginator::ListThingPrincipalsPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingRegistrationTaskReports`.
    ///
    /// <p>Information about the thing registration tasks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingRegistrationTaskReports<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_thing_registration_task_reports_input::Builder,
    }
    impl<C, M, R> ListThingRegistrationTaskReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingRegistrationTaskReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingRegistrationTaskReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingRegistrationTaskReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingRegistrationTaskReportsInputOperationOutputAlias,
                crate::output::ListThingRegistrationTaskReportsOutput,
                crate::error::ListThingRegistrationTaskReportsError,
                crate::input::ListThingRegistrationTaskReportsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingRegistrationTaskReportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListThingRegistrationTaskReportsPaginator<C, M, R> {
            crate::paginator::ListThingRegistrationTaskReportsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The id of the task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The id of the task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>The type of task report.</p>
        pub fn report_type(mut self, input: crate::model::ReportType) -> Self {
            self.inner = self.inner.report_type(input);
            self
        }
        /// <p>The type of task report.</p>
        pub fn set_report_type(
            mut self,
            input: std::option::Option<crate::model::ReportType>,
        ) -> Self {
            self.inner = self.inner.set_report_type(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingRegistrationTasks`.
    ///
    /// <p>List bulk thing provisioning tasks.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingRegistrationTasks</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingRegistrationTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_thing_registration_tasks_input::Builder,
    }
    impl<C, M, R> ListThingRegistrationTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingRegistrationTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingRegistrationTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingRegistrationTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingRegistrationTasksInputOperationOutputAlias,
                crate::output::ListThingRegistrationTasksOutput,
                crate::error::ListThingRegistrationTasksError,
                crate::input::ListThingRegistrationTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingRegistrationTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListThingRegistrationTasksPaginator<C, M, R> {
            crate::paginator::ListThingRegistrationTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The status of the bulk thing provisioning task.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the bulk thing provisioning task.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThings`.
    ///
    /// <p>Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in the registry that contain an attribute <b>Color</b> with the value <b>Red</b>. </p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThings</a> action.</p> <note>
    /// <p>You will not be charged for calling this API if an <code>Access denied</code> error is returned. You will also not be charged if no attributes or pagination token was provided in request and no pagination token and no results were returned.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_things_input::Builder,
    }
    impl<C, M, R> ListThings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingsInputOperationOutputAlias,
                crate::output::ListThingsOutput,
                crate::error::ListThingsError,
                crate::input::ListThingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThingsPaginator<C, M, R> {
            crate::paginator::ListThingsPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The attribute name used to search for things.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(input.into());
            self
        }
        /// <p>The attribute name used to search for things.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// <p>The attribute value used to search for things.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_value(input.into());
            self
        }
        /// <p>The attribute value used to search for things.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_value(input);
            self
        }
        /// <p>The name of the thing type used to search for things.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type used to search for things.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
        /// <p>When <code>true</code>, the action returns the thing resources with attribute values that start with the <code>attributeValue</code> provided.</p>
        /// <p>When <code>false</code>, or not present, the action returns only the thing resources with attribute values that match the entire <code>attributeValue</code> provided. </p>
        pub fn use_prefix_attribute_value(mut self, input: bool) -> Self {
            self.inner = self.inner.use_prefix_attribute_value(input);
            self
        }
        /// <p>When <code>true</code>, the action returns the thing resources with attribute values that start with the <code>attributeValue</code> provided.</p>
        /// <p>When <code>false</code>, or not present, the action returns only the thing resources with attribute values that match the entire <code>attributeValue</code> provided. </p>
        pub fn set_use_prefix_attribute_value(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_prefix_attribute_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingsInBillingGroup`.
    ///
    /// <p>Lists the things you have added to the given billing group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInBillingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingsInBillingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_things_in_billing_group_input::Builder,
    }
    impl<C, M, R> ListThingsInBillingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingsInBillingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingsInBillingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingsInBillingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingsInBillingGroupInputOperationOutputAlias,
                crate::output::ListThingsInBillingGroupOutput,
                crate::error::ListThingsInBillingGroupError,
                crate::input::ListThingsInBillingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingsInBillingGroupPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListThingsInBillingGroupPaginator<C, M, R> {
            crate::paginator::ListThingsInBillingGroupPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.billing_group_name(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_billing_group_name(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingsInThingGroup`.
    ///
    /// <p>Lists the things in the specified group.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingsInThingGroup</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingsInThingGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_things_in_thing_group_input::Builder,
    }
    impl<C, M, R> ListThingsInThingGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingsInThingGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingsInThingGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingsInThingGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingsInThingGroupInputOperationOutputAlias,
                crate::output::ListThingsInThingGroupOutput,
                crate::error::ListThingsInThingGroupError,
                crate::input::ListThingsInThingGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingsInThingGroupPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThingsInThingGroupPaginator<C, M, R> {
            crate::paginator::ListThingsInThingGroupPaginator::new(self.handle, self.inner)
        }
        /// <p>The thing group name.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_name(input.into());
            self
        }
        /// <p>The thing group name.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_name(input);
            self
        }
        /// <p>When true, list things in this thing group and in all child groups as well.</p>
        pub fn recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.recursive(input);
            self
        }
        /// <p>When true, list things in this thing group and in all child groups as well.</p>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThingTypes`.
    ///
    /// <p>Lists the existing thing types.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListThingTypes</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListThingTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_thing_types_input::Builder,
    }
    impl<C, M, R> ListThingTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThingTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThingTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThingTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThingTypesInputOperationOutputAlias,
                crate::output::ListThingTypesOutput,
                crate::error::ListThingTypesError,
                crate::input::ListThingTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListThingTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListThingTypesPaginator<C, M, R> {
            crate::paginator::ListThingTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in this operation.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_type_name(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTopicRuleDestinations`.
    ///
    /// <p>Lists all the topic rule destinations in your Amazon Web Services account.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRuleDestinations</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTopicRuleDestinations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_topic_rule_destinations_input::Builder,
    }
    impl<C, M, R> ListTopicRuleDestinations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTopicRuleDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTopicRuleDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTopicRuleDestinationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTopicRuleDestinationsInputOperationOutputAlias,
                crate::output::ListTopicRuleDestinationsOutput,
                crate::error::ListTopicRuleDestinationsError,
                crate::input::ListTopicRuleDestinationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTopicRuleDestinationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListTopicRuleDestinationsPaginator<C, M, R> {
            crate::paginator::ListTopicRuleDestinationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTopicRules`.
    ///
    /// <p>Lists the rules for the specific topic.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTopicRules</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTopicRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_topic_rules_input::Builder,
    }
    impl<C, M, R> ListTopicRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTopicRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTopicRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTopicRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTopicRulesInputOperationOutputAlias,
                crate::output::ListTopicRulesOutput,
                crate::error::ListTopicRulesError,
                crate::input::ListTopicRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTopicRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTopicRulesPaginator<C, M, R> {
            crate::paginator::ListTopicRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The topic.</p>
        pub fn topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic(input.into());
            self
        }
        /// <p>The topic.</p>
        pub fn set_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn rule_disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.rule_disabled(input);
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn set_rule_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_rule_disabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListV2LoggingLevels`.
    ///
    /// <p>Lists logging levels.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListV2LoggingLevels</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListV2LoggingLevels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_v2_logging_levels_input::Builder,
    }
    impl<C, M, R> ListV2LoggingLevels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListV2LoggingLevels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListV2LoggingLevelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListV2LoggingLevelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListV2LoggingLevelsInputOperationOutputAlias,
                crate::output::ListV2LoggingLevelsOutput,
                crate::error::ListV2LoggingLevelsError,
                crate::input::ListV2LoggingLevelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListV2LoggingLevelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListV2LoggingLevelsPaginator<C, M, R> {
            crate::paginator::ListV2LoggingLevelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn target_type(mut self, input: crate::model::LogTargetType) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::LogTargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise <b>null</b> to receive the first set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListViolationEvents`.
    ///
    /// <p>Lists the Device Defender security profile violations discovered during the given time period. You can use filters to limit the results to those alerts issued for a particular security profile, behavior, or thing (device).</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListViolationEvents</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListViolationEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_violation_events_input::Builder,
    }
    impl<C, M, R> ListViolationEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListViolationEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListViolationEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListViolationEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListViolationEventsInputOperationOutputAlias,
                crate::output::ListViolationEventsOutput,
                crate::error::ListViolationEventsError,
                crate::input::ListViolationEventsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListViolationEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListViolationEventsPaginator<C, M, R> {
            crate::paginator::ListViolationEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The start time for the alerts to be listed.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time for the alerts to be listed.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time for the alerts to be listed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end time for the alerts to be listed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>A filter to limit results to those alerts caused by the specified thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>A filter to limit results to those alerts caused by the specified thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// <p>A filter to limit results to those alerts generated by the specified security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>A filter to limit results to those alerts generated by the specified security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p> The criteria for a behavior. </p>
        pub fn behavior_criteria_type(mut self, input: crate::model::BehaviorCriteriaType) -> Self {
            self.inner = self.inner.behavior_criteria_type(input);
            self
        }
        /// <p> The criteria for a behavior. </p>
        pub fn set_behavior_criteria_type(
            mut self,
            input: std::option::Option<crate::model::BehaviorCriteriaType>,
        ) -> Self {
            self.inner = self.inner.set_behavior_criteria_type(input);
            self
        }
        /// <p> A list of all suppressed alerts. </p>
        pub fn list_suppressed_alerts(mut self, input: bool) -> Self {
            self.inner = self.inner.list_suppressed_alerts(input);
            self
        }
        /// <p> A list of all suppressed alerts. </p>
        pub fn set_list_suppressed_alerts(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_list_suppressed_alerts(input);
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.inner = self.inner.verification_state(input);
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.inner = self.inner.set_verification_state(input);
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return at one time.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutVerificationStateOnViolation`.
    ///
    /// <p>Set a verification state and provide a description of that verification state on a violation (detect alarm).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutVerificationStateOnViolation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_verification_state_on_violation_input::Builder,
    }
    impl<C, M, R> PutVerificationStateOnViolation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutVerificationStateOnViolation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutVerificationStateOnViolationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutVerificationStateOnViolationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutVerificationStateOnViolationInputOperationOutputAlias,
                crate::output::PutVerificationStateOnViolationOutput,
                crate::error::PutVerificationStateOnViolationError,
                crate::input::PutVerificationStateOnViolationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The violation ID.</p>
        pub fn violation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.violation_id(input.into());
            self
        }
        /// <p>The violation ID.</p>
        pub fn set_violation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_violation_id(input);
            self
        }
        /// <p>The verification state of the violation.</p>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.inner = self.inner.verification_state(input);
            self
        }
        /// <p>The verification state of the violation.</p>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.inner = self.inner.set_verification_state(input);
            self
        }
        /// <p>The description of the verification state of the violation (detect alarm).</p>
        pub fn verification_state_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.verification_state_description(input.into());
            self
        }
        /// <p>The description of the verification state of the violation (detect alarm).</p>
        pub fn set_verification_state_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_verification_state_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCACertificate`.
    ///
    /// <p>Registers a CA certificate with IoT. This CA certificate can then be used to sign device certificates, which can be then registered with IoT. You can register up to 10 CA certificates per Amazon Web Services account that have the same subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you have more than one CA certificate registered, make sure you pass the CA certificate when you register your device certificates with the <code>RegisterCertificate</code> action.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCACertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterCACertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_ca_certificate_input::Builder,
    }
    impl<C, M, R> RegisterCACertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterCACertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterCaCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterCACertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterCaCertificateInputOperationOutputAlias,
                crate::output::RegisterCaCertificateOutput,
                crate::error::RegisterCACertificateError,
                crate::input::RegisterCaCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The CA certificate.</p>
        pub fn ca_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ca_certificate(input.into());
            self
        }
        /// <p>The CA certificate.</p>
        pub fn set_ca_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ca_certificate(input);
            self
        }
        /// <p>The private key verification certificate.</p>
        pub fn verification_certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.verification_certificate(input.into());
            self
        }
        /// <p>The private key verification certificate.</p>
        pub fn set_verification_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_verification_certificate(input);
            self
        }
        /// <p>A boolean value that specifies if the CA certificate is set to active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>A boolean value that specifies if the CA certificate is set to active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
        /// <p>Allows this CA certificate to be used for auto registration of device certificates.</p>
        pub fn allow_auto_registration(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_auto_registration(input);
            self
        }
        /// <p>Allows this CA certificate to be used for auto registration of device certificates.</p>
        pub fn set_allow_auto_registration(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_auto_registration(input);
            self
        }
        /// <p>Information about the registration configuration.</p>
        pub fn registration_config(mut self, input: crate::model::RegistrationConfig) -> Self {
            self.inner = self.inner.registration_config(input);
            self
        }
        /// <p>Information about the registration configuration.</p>
        pub fn set_registration_config(
            mut self,
            input: std::option::Option<crate::model::RegistrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_registration_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the CA certificate.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Metadata which can be used to manage the CA certificate.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCertificate`.
    ///
    /// <p>Registers a device certificate with IoT. If you have more than one CA certificate that has the same subject field, you must specify the CA certificate that was used to sign the device certificate being registered.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterCertificate</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_certificate_input::Builder,
    }
    impl<C, M, R> RegisterCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterCertificateInputOperationOutputAlias,
                crate::output::RegisterCertificateOutput,
                crate::error::RegisterCertificateError,
                crate::input::RegisterCertificateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_pem(input.into());
            self
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_pem(input);
            self
        }
        /// <p>The CA certificate used to sign the device certificate being registered.</p>
        pub fn ca_certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ca_certificate_pem(input.into());
            self
        }
        /// <p>The CA certificate used to sign the device certificate being registered.</p>
        pub fn set_ca_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ca_certificate_pem(input);
            self
        }
        /// <p>A boolean value that specifies if the certificate is set to active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.inner = self.inner.set_as_active(input);
            self
        }
        /// <p>A boolean value that specifies if the certificate is set to active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_active(input);
            self
        }
        /// <p>The status of the register certificate request.</p>
        pub fn status(mut self, input: crate::model::CertificateStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the register certificate request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCertificateWithoutCA`.
    ///
    /// <p>Register a certificate that does not have a certificate authority (CA). For supported certificates, consult <a href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms"> Certificate signing algorithms supported by IoT</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterCertificateWithoutCA<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_certificate_without_ca_input::Builder,
    }
    impl<C, M, R> RegisterCertificateWithoutCA<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterCertificateWithoutCA`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterCertificateWithoutCaOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterCertificateWithoutCAError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterCertificateWithoutCaInputOperationOutputAlias,
                crate::output::RegisterCertificateWithoutCaOutput,
                crate::error::RegisterCertificateWithoutCAError,
                crate::input::RegisterCertificateWithoutCaInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_pem(input.into());
            self
        }
        /// <p>The certificate data, in PEM format.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_pem(input);
            self
        }
        /// <p>The status of the register certificate request.</p>
        pub fn status(mut self, input: crate::model::CertificateStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the register certificate request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterThing`.
    ///
    /// <p>Provisions a thing in the device registry. RegisterThing calls other IoT control plane APIs. These calls might exceed your account level <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot"> IoT Throttling Limits</a> and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Customer Support</a> to raise your throttling limits if necessary.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RegisterThing</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterThing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_thing_input::Builder,
    }
    impl<C, M, R> RegisterThing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterThing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterThingOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterThingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterThingInputOperationOutputAlias,
                crate::output::RegisterThingOutput,
                crate::error::RegisterThingError,
                crate::input::RegisterThingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The provisioning template. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-w-cert.html">Provisioning Devices That Have Device Certificates</a> for more information.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The provisioning template. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-w-cert.html">Provisioning Devices That Have Device Certificates</a> for more information.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for provisioning a thing. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning Templates</a> for more information.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v.into());
            self
        }
        /// <p>The parameters for provisioning a thing. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning Templates</a> for more information.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectCertificateTransfer`.
    ///
    /// <p>Rejects a pending certificate transfer. After IoT rejects a certificate transfer, the certificate status changes from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.</p>
    /// <p>To check for pending certificate transfers, call <code>ListCertificates</code> to enumerate your certificates.</p>
    /// <p>This operation can only be called by the transfer destination. After it is called, the certificate will be returned to the source's account in the INACTIVE state.</p>
    /// <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">RejectCertificateTransfer</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectCertificateTransfer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_certificate_transfer_input::Builder,
    }
    impl<C, M, R> RejectCertificateTransfer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectCertificateTransfer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectCertificateTransferOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectCertificateTransferError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectCertificateTransferInputOperationOutputAlias,
                crate::output::RejectCertificateTransferOutput,
                crate::error::RejectCertificateTransferError,
                crate::input::RejectCertificateTransferInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(input.into());
    