// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptCertificateTransferInput`](crate::input::AcceptCertificateTransferInput)
pub mod accept_certificate_transfer_input {
    /// A builder for [`AcceptCertificateTransferInput`](crate::input::AcceptCertificateTransferInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) set_as_active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.set_as_active = Some(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.set_as_active = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptCertificateTransferInput`](crate::input::AcceptCertificateTransferInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptCertificateTransferInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptCertificateTransferInput {
                certificate_id: self.certificate_id,
                set_as_active: self.set_as_active.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptCertificateTransferInputOperationOutputAlias =
    crate::operation::AcceptCertificateTransfer;
#[doc(hidden)]
pub type AcceptCertificateTransferInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptCertificateTransferInput {
    /// Consumes the builder and constructs an Operation<[`AcceptCertificateTransfer`](crate::operation::AcceptCertificateTransfer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptCertificateTransfer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptCertificateTransferInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.certificate_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let certificate_id = aws_smithy_http::label::fmt_string(input_1, false);
                if certificate_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/accept-certificate-transfer/{certificateId}",
                    certificateId = certificate_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::AcceptCertificateTransferInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.set_as_active {
                    query.push_kv(
                        "setAsActive",
                        aws_smithy_types::primitive::Encoder::from(_input.set_as_active).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptCertificateTransferInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptCertificateTransfer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptCertificateTransfer",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptCertificateTransferInput`](crate::input::AcceptCertificateTransferInput)
    pub fn builder() -> crate::input::accept_certificate_transfer_input::Builder {
        crate::input::accept_certificate_transfer_input::Builder::default()
    }
}

/// See [`AddThingToBillingGroupInput`](crate::input::AddThingToBillingGroupInput)
pub mod add_thing_to_billing_group_input {
    /// A builder for [`AddThingToBillingGroupInput`](crate::input::AddThingToBillingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
        pub(crate) billing_group_arn: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the billing group.</p> <note>
        /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
        /// </note>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the billing group.</p> <note>
        /// <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p>
        /// </note>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn billing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the billing group.</p>
        pub fn set_billing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_arn = input;
            self
        }
        /// <p>The name of the thing to be added to the billing group.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing to be added to the billing group.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ARN of the thing to be added to the billing group.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing to be added to the billing group.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AddThingToBillingGroupInput`](crate::input::AddThingToBillingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddThingToBillingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddThingToBillingGroupInput {
                billing_group_name: self.billing_group_name,
                billing_group_arn: self.billing_group_arn,
                thing_name: self.thing_name,
                thing_arn: self.thing_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AddThingToBillingGroupInputOperationOutputAlias = crate::operation::AddThingToBillingGroup;
#[doc(hidden)]
pub type AddThingToBillingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddThingToBillingGroupInput {
    /// Consumes the builder and constructs an Operation<[`AddThingToBillingGroup`](crate::operation::AddThingToBillingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddThingToBillingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddThingToBillingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/billing-groups/addThingToBillingGroup")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddThingToBillingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_thing_to_billing_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddThingToBillingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddThingToBillingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddThingToBillingGroupInput`](crate::input::AddThingToBillingGroupInput)
    pub fn builder() -> crate::input::add_thing_to_billing_group_input::Builder {
        crate::input::add_thing_to_billing_group_input::Builder::default()
    }
}

/// See [`AddThingToThingGroupInput`](crate::input::AddThingToThingGroupInput)
pub mod add_thing_to_thing_group_input {
    /// A builder for [`AddThingToThingGroupInput`](crate::input::AddThingToThingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_arn: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
        pub(crate) override_dynamic_groups: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the group to which you are adding a thing.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to which you are adding a thing.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The ARN of the group to which you are adding a thing.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the group to which you are adding a thing.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_arn = input;
            self
        }
        /// <p>The name of the thing to add to a group.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing to add to a group.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ARN of the thing to add to a group.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing to add to a group.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
        pub fn override_dynamic_groups(mut self, input: bool) -> Self {
            self.override_dynamic_groups = Some(input);
            self
        }
        /// <p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>
        pub fn set_override_dynamic_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.override_dynamic_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`AddThingToThingGroupInput`](crate::input::AddThingToThingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddThingToThingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddThingToThingGroupInput {
                thing_group_name: self.thing_group_name,
                thing_group_arn: self.thing_group_arn,
                thing_name: self.thing_name,
                thing_arn: self.thing_arn,
                override_dynamic_groups: self.override_dynamic_groups.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type AddThingToThingGroupInputOperationOutputAlias = crate::operation::AddThingToThingGroup;
#[doc(hidden)]
pub type AddThingToThingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddThingToThingGroupInput {
    /// Consumes the builder and constructs an Operation<[`AddThingToThingGroup`](crate::operation::AddThingToThingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddThingToThingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddThingToThingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/thing-groups/addThingToThingGroup")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddThingToThingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_thing_to_thing_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddThingToThingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddThingToThingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddThingToThingGroupInput`](crate::input::AddThingToThingGroupInput)
    pub fn builder() -> crate::input::add_thing_to_thing_group_input::Builder {
        crate::input::add_thing_to_thing_group_input::Builder::default()
    }
}

/// See [`AssociateTargetsWithJobInput`](crate::input::AssociateTargetsWithJobInput)
pub mod associate_targets_with_job_input {
    /// A builder for [`AssociateTargetsWithJobInput`](crate::input::AssociateTargetsWithJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) namespace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of thing group ARNs that define the targets of the job.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>A list of thing group ARNs that define the targets of the job.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>An optional comment string describing why the job was associated with the targets.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment string describing why the job was associated with the targets.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_id = Some(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTargetsWithJobInput`](crate::input::AssociateTargetsWithJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTargetsWithJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTargetsWithJobInput {
                targets: self.targets,
                job_id: self.job_id,
                comment: self.comment,
                namespace_id: self.namespace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTargetsWithJobInputOperationOutputAlias =
    crate::operation::AssociateTargetsWithJob;
#[doc(hidden)]
pub type AssociateTargetsWithJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateTargetsWithJobInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTargetsWithJob`](crate::operation::AssociateTargetsWithJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTargetsWithJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateTargetsWithJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.job_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_2, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/jobs/{jobId}/targets", jobId = job_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::AssociateTargetsWithJobInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_3) = &_input.namespace_id {
                    query.push_kv("namespaceId", &aws_smithy_http::query::fmt_string(&inner_3));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateTargetsWithJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_targets_with_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTargetsWithJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTargetsWithJob",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateTargetsWithJobInput`](crate::input::AssociateTargetsWithJobInput)
    pub fn builder() -> crate::input::associate_targets_with_job_input::Builder {
        crate::input::associate_targets_with_job_input::Builder::default()
    }
}

/// See [`AttachPolicyInput`](crate::input::AttachPolicyInput)
pub mod attach_policy_input {
    /// A builder for [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy to attach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy to attach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached. For example, a thing group or a certificate.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachPolicyInput`](crate::input::AttachPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachPolicyInput {
                policy_name: self.policy_name,
                target: self.target,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachPolicyInputOperationOutputAlias = crate::operation::AttachPolicy;
#[doc(hidden)]
pub type AttachPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachPolicyInput {
    /// Consumes the builder and constructs an Operation<[`AttachPolicy`](crate::operation::AttachPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.policy_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_4, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/target-policies/{policyName}",
                    policyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachPolicy",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    pub fn builder() -> crate::input::attach_policy_input::Builder {
        crate::input::attach_policy_input::Builder::default()
    }
}

/// See [`AttachPrincipalPolicyInput`](crate::input::AttachPrincipalPolicyInput)
pub mod attach_principal_policy_input {
    /// A builder for [`AttachPrincipalPolicyInput`](crate::input::AttachPrincipalPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachPrincipalPolicyInput`](crate::input::AttachPrincipalPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachPrincipalPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachPrincipalPolicyInput {
                policy_name: self.policy_name,
                principal: self.principal,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachPrincipalPolicyInputOperationOutputAlias = crate::operation::AttachPrincipalPolicy;
#[doc(hidden)]
pub type AttachPrincipalPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachPrincipalPolicyInput {
    /// Consumes the builder and constructs an Operation<[`AttachPrincipalPolicy`](crate::operation::AttachPrincipalPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachPrincipalPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachPrincipalPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.policy_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_5, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/principal-policies/{policyName}",
                    policyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachPrincipalPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_attach_principal_policy(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachPrincipalPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachPrincipalPolicy",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachPrincipalPolicyInput`](crate::input::AttachPrincipalPolicyInput)
    pub fn builder() -> crate::input::attach_principal_policy_input::Builder {
        crate::input::attach_principal_policy_input::Builder::default()
    }
}

/// See [`AttachSecurityProfileInput`](crate::input::AttachSecurityProfileInput)
pub mod attach_security_profile_input {
    /// A builder for [`AttachSecurityProfileInput`](crate::input::AttachSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The security profile that is attached.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The security profile that is attached.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The ARN of the target (thing group) to which the security profile is attached.</p>
        pub fn security_profile_target_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.security_profile_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the target (thing group) to which the security profile is attached.</p>
        pub fn set_security_profile_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachSecurityProfileInput`](crate::input::AttachSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachSecurityProfileInput {
                security_profile_name: self.security_profile_name,
                security_profile_target_arn: self.security_profile_target_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachSecurityProfileInputOperationOutputAlias = crate::operation::AttachSecurityProfile;
#[doc(hidden)]
pub type AttachSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`AttachSecurityProfile`](crate::operation::AttachSecurityProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachSecurityProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.security_profile_name;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let security_profile_name = aws_smithy_http::label::fmt_string(input_6, false);
                if security_profile_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/security-profiles/{securityProfileName}/targets",
                    securityProfileName = security_profile_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::AttachSecurityProfileInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_7) = &_input.security_profile_target_arn {
                    query.push_kv(
                        "securityProfileTargetArn",
                        &aws_smithy_http::query::fmt_string(&inner_7),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachSecurityProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachSecurityProfile",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachSecurityProfileInput`](crate::input::AttachSecurityProfileInput)
    pub fn builder() -> crate::input::attach_security_profile_input::Builder {
        crate::input::attach_security_profile_input::Builder::default()
    }
}

/// See [`AttachThingPrincipalInput`](crate::input::AttachThingPrincipalInput)
pub mod attach_thing_principal_input {
    /// A builder for [`AttachThingPrincipalInput`](crate::input::AttachThingPrincipalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachThingPrincipalInput`](crate::input::AttachThingPrincipalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachThingPrincipalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachThingPrincipalInput {
                thing_name: self.thing_name,
                principal: self.principal,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachThingPrincipalInputOperationOutputAlias = crate::operation::AttachThingPrincipal;
#[doc(hidden)]
pub type AttachThingPrincipalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachThingPrincipalInput {
    /// Consumes the builder and constructs an Operation<[`AttachThingPrincipal`](crate::operation::AttachThingPrincipal)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachThingPrincipal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachThingPrincipalInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.thing_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_8, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/things/{thingName}/principals",
                    thingName = thing_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachThingPrincipalInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_attach_thing_principal(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachThingPrincipal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachThingPrincipal",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachThingPrincipalInput`](crate::input::AttachThingPrincipalInput)
    pub fn builder() -> crate::input::attach_thing_principal_input::Builder {
        crate::input::attach_thing_principal_input::Builder::default()
    }
}

/// See [`CancelAuditMitigationActionsTaskInput`](crate::input::CancelAuditMitigationActionsTaskInput)
pub mod cancel_audit_mitigation_actions_task_input {
    /// A builder for [`CancelAuditMitigationActionsTaskInput`](crate::input::CancelAuditMitigationActionsTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the task that you want to cancel. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the task that you want to cancel. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelAuditMitigationActionsTaskInput`](crate::input::CancelAuditMitigationActionsTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelAuditMitigationActionsTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelAuditMitigationActionsTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelAuditMitigationActionsTaskInputOperationOutputAlias =
    crate::operation::CancelAuditMitigationActionsTask;
#[doc(hidden)]
pub type CancelAuditMitigationActionsTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CancelAuditMitigationActionsTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelAuditMitigationActionsTask`](crate::operation::CancelAuditMitigationActionsTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelAuditMitigationActionsTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelAuditMitigationActionsTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.task_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let task_id = aws_smithy_http::label::fmt_string(input_9, false);
                if task_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/audit/mitigationactions/tasks/{taskId}/cancel",
                    taskId = task_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelAuditMitigationActionsTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelAuditMitigationActionsTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelAuditMitigationActionsTask",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelAuditMitigationActionsTaskInput`](crate::input::CancelAuditMitigationActionsTaskInput)
    pub fn builder() -> crate::input::cancel_audit_mitigation_actions_task_input::Builder {
        crate::input::cancel_audit_mitigation_actions_task_input::Builder::default()
    }
}

/// See [`CancelAuditTaskInput`](crate::input::CancelAuditTaskInput)
pub mod cancel_audit_task_input {
    /// A builder for [`CancelAuditTaskInput`](crate::input::CancelAuditTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelAuditTaskInput`](crate::input::CancelAuditTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelAuditTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelAuditTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelAuditTaskInputOperationOutputAlias = crate::operation::CancelAuditTask;
#[doc(hidden)]
pub type CancelAuditTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelAuditTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelAuditTask`](crate::operation::CancelAuditTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelAuditTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelAuditTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.task_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let task_id = aws_smithy_http::label::fmt_string(input_10, false);
                if task_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/audit/tasks/{taskId}/cancel", taskId = task_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelAuditTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelAuditTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelAuditTask",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelAuditTaskInput`](crate::input::CancelAuditTaskInput)
    pub fn builder() -> crate::input::cancel_audit_task_input::Builder {
        crate::input::cancel_audit_task_input::Builder::default()
    }
}

/// See [`CancelCertificateTransferInput`](crate::input::CancelCertificateTransferInput)
pub mod cancel_certificate_transfer_input {
    /// A builder for [`CancelCertificateTransferInput`](crate::input::CancelCertificateTransferInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelCertificateTransferInput`](crate::input::CancelCertificateTransferInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelCertificateTransferInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelCertificateTransferInput {
                certificate_id: self.certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelCertificateTransferInputOperationOutputAlias =
    crate::operation::CancelCertificateTransfer;
#[doc(hidden)]
pub type CancelCertificateTransferInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelCertificateTransferInput {
    /// Consumes the builder and constructs an Operation<[`CancelCertificateTransfer`](crate::operation::CancelCertificateTransfer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelCertificateTransfer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelCertificateTransferInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.certificate_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let certificate_id = aws_smithy_http::label::fmt_string(input_11, false);
                if certificate_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/cancel-certificate-transfer/{certificateId}",
                    certificateId = certificate_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelCertificateTransferInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelCertificateTransfer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelCertificateTransfer",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelCertificateTransferInput`](crate::input::CancelCertificateTransferInput)
    pub fn builder() -> crate::input::cancel_certificate_transfer_input::Builder {
        crate::input::cancel_certificate_transfer_input::Builder::default()
    }
}

/// See [`CancelDetectMitigationActionsTaskInput`](crate::input::CancelDetectMitigationActionsTaskInput)
pub mod cancel_detect_mitigation_actions_task_input {
    /// A builder for [`CancelDetectMitigationActionsTaskInput`](crate::input::CancelDetectMitigationActionsTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDetectMitigationActionsTaskInput`](crate::input::CancelDetectMitigationActionsTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelDetectMitigationActionsTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelDetectMitigationActionsTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelDetectMitigationActionsTaskInputOperationOutputAlias =
    crate::operation::CancelDetectMitigationActionsTask;
#[doc(hidden)]
pub type CancelDetectMitigationActionsTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CancelDetectMitigationActionsTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelDetectMitigationActionsTask`](crate::operation::CancelDetectMitigationActionsTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelDetectMitigationActionsTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelDetectMitigationActionsTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.task_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let task_id = aws_smithy_http::label::fmt_string(input_12, false);
                if task_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/detect/mitigationactions/tasks/{taskId}/cancel",
                    taskId = task_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelDetectMitigationActionsTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelDetectMitigationActionsTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelDetectMitigationActionsTask",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelDetectMitigationActionsTaskInput`](crate::input::CancelDetectMitigationActionsTaskInput)
    pub fn builder() -> crate::input::cancel_detect_mitigation_actions_task_input::Builder {
        crate::input::cancel_detect_mitigation_actions_task_input::Builder::default()
    }
}

/// See [`CancelJobInput`](crate::input::CancelJobInput)
pub mod cancel_job_input {
    /// A builder for [`CancelJobInput`](crate::input::CancelJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) reason_code: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>(Optional)A reason code string that explains why the job was canceled.</p>
        pub fn reason_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason_code = Some(input.into());
            self
        }
        /// <p>(Optional)A reason code string that explains why the job was canceled.</p>
        pub fn set_reason_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason_code = input;
            self
        }
        /// <p>An optional comment string describing why the job was canceled.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>An optional comment string describing why the job was canceled.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
        /// <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p>
        /// <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelJobInput`](crate::input::CancelJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CancelJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CancelJobInput {
                job_id: self.job_id,
                reason_code: self.reason_code,
                comment: self.comment,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CancelJobInputOperationOutputAlias = crate::operation::CancelJob;
#[doc(hidden)]
pub type CancelJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelJob`](crate::operation::CancelJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.job_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_13, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/jobs/{jobId}/cancel", jobId = job_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CancelJobInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.force {
                    query.push_kv(
                        "force",
                        aws_smithy_types::primitive::Encoder::from(_input.force).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CancelJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CancelJob",
                    "iot",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelJobInput`](crate::input::CancelJobInput)
    pub fn builder() -> crate::input::cancel_job_input::Builder {
        crate::input::cancel_job_input::Builder::default()
    }
}

/// See [`CancelJobExecutionInput`](crate::input::CancelJobExecutionInput)
pub mod cancel_job_execution_input {
    /// A builder for [`CancelJobExecutionInput`](crate::input::CancelJobExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
        pub(crate) expected_version: std::option::Option<i64>,
        pub(crate) status_details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the job to be canceled.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job to be canceled.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the thing whose execution of the job will be canceled.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing whose execution of the job will be canceled.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p>
        /// <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p>
        /// <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// Adds a key-value pair to `status_details`.
        ///
        /// To override the contents of this collection use [`set_status_details`](Self::set_status_details).
        ///
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
        pub fn status_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.status_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.status_details = Some(hash_map);
            self
        }
        /// <p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelJobExecutionInput`](crate::input::CancelJobExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelJobExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelJobExecutionInput {
                job_id: self.job_id,
                thing_name: self.thing_name,
                force: self.force.unwrap_or_default(),
                expected_version: self.expected_version,
                status_details: self.status_details,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelJobExecutionInputOperationOutputAlias = crate::operation::CancelJobExecution;
#[doc(hidden)]
pub type CancelJobExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelJobExecutionInput {
    /// Consumes the builder and constructs an Operation<[`CancelJobExecution`](crate::operation::CancelJobExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelJobExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelJobExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.thing_name;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_14, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_15 = &_input.job_id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_15, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/things/{thingName}/jobs/{jobId}/cancel",
                    thingName = thing_name,
                    jobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CancelJobExecutionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.force {
                    query.push_kv(
                        "force",
                        aws_smithy_types::primitive::Encoder::from(_input.force).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelJobExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_job_execution(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelJobExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelJobExecution",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelJobExecutionInput`](crate::input::CancelJobExecutionInput)
    pub fn builder() -> crate::input::cancel_job_execution_input::Builder {
        crate::input::cancel_job_execution_input::Builder::default()
    }
}

/// See [`ClearDefaultAuthorizerInput`](crate::input::ClearDefaultAuthorizerInput)
pub mod clear_default_authorizer_input {
    /// A builder for [`ClearDefaultAuthorizerInput`](crate::input::ClearDefaultAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ClearDefaultAuthorizerInput`](crate::input::ClearDefaultAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ClearDefaultAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ClearDefaultAuthorizerInput {})
        }
    }
}
#[doc(hidden)]
pub type ClearDefaultAuthorizerInputOperationOutputAlias = crate::operation::ClearDefaultAuthorizer;
#[doc(hidden)]
pub type ClearDefaultAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ClearDefaultAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`ClearDefaultAuthorizer`](crate::operation::ClearDefaultAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ClearDefaultAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ClearDefaultAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/default-authorizer").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ClearDefaultAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ClearDefaultAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ClearDefaultAuthorizer",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ClearDefaultAuthorizerInput`](crate::input::ClearDefaultAuthorizerInput)
    pub fn builder() -> crate::input::clear_default_authorizer_input::Builder {
        crate::input::clear_default_authorizer_input::Builder::default()
    }
}

/// See [`ConfirmTopicRuleDestinationInput`](crate::input::ConfirmTopicRuleDestinationInput)
pub mod confirm_topic_rule_destination_input {
    /// A builder for [`ConfirmTopicRuleDestinationInput`](crate::input::ConfirmTopicRuleDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confirmation_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
        pub fn confirmation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.confirmation_token = Some(input.into());
            self
        }
        /// <p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>
        pub fn set_confirmation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.confirmation_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmTopicRuleDestinationInput`](crate::input::ConfirmTopicRuleDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmTopicRuleDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmTopicRuleDestinationInput {
                confirmation_token: self.confirmation_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmTopicRuleDestinationInputOperationOutputAlias =
    crate::operation::ConfirmTopicRuleDestination;
#[doc(hidden)]
pub type ConfirmTopicRuleDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ConfirmTopicRuleDestinationInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmTopicRuleDestination`](crate::operation::ConfirmTopicRuleDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmTopicRuleDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ConfirmTopicRuleDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.confirmation_token;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "confirmation_token",
                        details: "cannot be empty or unset",
                    },
                )?;
                let confirmation_token = aws_smithy_http::label::fmt_string(input_16, true);
                if confirmation_token.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "confirmation_token",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/confirmdestination/{confirmationToken}",
                    confirmationToken = confirmation_token
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ConfirmTopicRuleDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmTopicRuleDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmTopicRuleDestination",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ConfirmTopicRuleDestinationInput`](crate::input::ConfirmTopicRuleDestinationInput)
    pub fn builder() -> crate::input::confirm_topic_rule_destination_input::Builder {
        crate::input::confirm_topic_rule_destination_input::Builder::default()
    }
}

/// See [`CreateAuditSuppressionInput`](crate::input::CreateAuditSuppressionInput)
pub mod create_audit_suppression_input {
    /// A builder for [`CreateAuditSuppressionInput`](crate::input::CreateAuditSuppressionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) suppress_indefinitely: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_name = Some(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_name = input;
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p> The epoch timestamp in seconds at which this suppression expires. </p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn suppress_indefinitely(mut self, input: bool) -> Self {
            self.suppress_indefinitely = Some(input);
            self
        }
        /// <p> Indicates whether a suppression should exist indefinitely or not. </p>
        pub fn set_suppress_indefinitely(mut self, input: std::option::Option<bool>) -> Self {
            self.suppress_indefinitely = input;
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the audit suppression. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> Each audit supression must have a unique client request token. If you try to create a new audit suppression with the same token as one that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> Each audit supression must have a unique client request token. If you try to create a new audit suppression with the same token as one that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuditSuppressionInput`](crate::input::CreateAuditSuppressionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAuditSuppressionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAuditSuppressionInput {
                check_name: self.check_name,
                resource_identifier: self.resource_identifier,
                expiration_date: self.expiration_date,
                suppress_indefinitely: self.suppress_indefinitely,
                description: self.description,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAuditSuppressionInputOperationOutputAlias = crate::operation::CreateAuditSuppression;
#[doc(hidden)]
pub type CreateAuditSuppressionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAuditSuppressionInput {
    /// Consumes the builder and constructs an Operation<[`CreateAuditSuppression`](crate::operation::CreateAuditSuppression)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAuditSuppression,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAuditSuppressionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/audit/suppressions/create").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAuditSuppressionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_audit_suppression(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAuditSuppression::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAuditSuppression",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAuditSuppressionInput`](crate::input::CreateAuditSuppressionInput)
    pub fn builder() -> crate::input::create_audit_suppression_input::Builder {
        crate::input::create_audit_suppression_input::Builder::default()
    }
}

/// See [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
pub mod create_authorizer_input {
    /// A builder for [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_name: std::option::Option<std::string::String>,
        pub(crate) authorizer_function_arn: std::option::Option<std::string::String>,
        pub(crate) token_key_name: std::option::Option<std::string::String>,
        pub(crate) token_signing_public_keys: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::AuthorizerStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) signing_disabled: std::option::Option<bool>,
        pub(crate) enable_caching_for_http: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The authorizer name.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_name = Some(input.into());
            self
        }
        /// <p>The authorizer name.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_name = input;
            self
        }
        /// <p>The ARN of the authorizer's Lambda function.</p>
        pub fn authorizer_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the authorizer's Lambda function.</p>
        pub fn set_authorizer_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_function_arn = input;
            self
        }
        /// <p>The name of the token key used to extract the token from the HTTP headers.</p>
        pub fn token_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_key_name = Some(input.into());
            self
        }
        /// <p>The name of the token key used to extract the token from the HTTP headers.</p>
        pub fn set_token_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.token_key_name = input;
            self
        }
        /// Adds a key-value pair to `token_signing_public_keys`.
        ///
        /// To override the contents of this collection use [`set_token_signing_public_keys`](Self::set_token_signing_public_keys).
        ///
        /// <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
        pub fn token_signing_public_keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.token_signing_public_keys.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.token_signing_public_keys = Some(hash_map);
            self
        }
        /// <p>The public keys used to verify the digital signature returned by your custom authentication service.</p>
        pub fn set_token_signing_public_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.token_signing_public_keys = input;
            self
        }
        /// <p>The status of the create authorizer request.</p>
        pub fn status(mut self, input: crate::model::AuthorizerStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the create authorizer request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuthorizerStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the custom authorizer.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the custom authorizer.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether IoT validates the token signature in an authorization request.</p>
        pub fn signing_disabled(mut self, input: bool) -> Self {
            self.signing_disabled = Some(input);
            self
        }
        /// <p>Specifies whether IoT validates the token signature in an authorization request.</p>
        pub fn set_signing_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.signing_disabled = input;
            self
        }
        /// <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT connections.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn enable_caching_for_http(mut self, input: bool) -> Self {
            self.enable_caching_for_http = Some(input);
            self
        }
        /// <p>When <code>true</code>, the result from the authorizer’s Lambda function is cached for clients that use persistent HTTP connections. The results are cached for the time specified by the Lambda function in <code>refreshAfterInSeconds</code>. This value does not affect authorization of clients that use MQTT connections.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_enable_caching_for_http(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_caching_for_http = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAuthorizerInput {
                authorizer_name: self.authorizer_name,
                authorizer_function_arn: self.authorizer_function_arn,
                token_key_name: self.token_key_name,
                token_signing_public_keys: self.token_signing_public_keys,
                status: self.status,
                tags: self.tags,
                signing_disabled: self.signing_disabled,
                enable_caching_for_http: self.enable_caching_for_http,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAuthorizerInputOperationOutputAlias = crate::operation::CreateAuthorizer;
#[doc(hidden)]
pub type CreateAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`CreateAuthorizer`](crate::operation::CreateAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.authorizer_name;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let authorizer_name = aws_smithy_http::label::fmt_string(input_17, false);
                if authorizer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/authorizer/{authorizerName}",
                    authorizerName = authorizer_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_authorizer(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAuthorizer",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    pub fn builder() -> crate::input::create_authorizer_input::Builder {
        crate::input::create_authorizer_input::Builder::default()
    }
}

/// See [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
pub mod create_billing_group_input {
    /// A builder for [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
        pub(crate) billing_group_properties:
            std::option::Option<crate::model::BillingGroupProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name you wish to give to the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name you wish to give to the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn billing_group_properties(
            mut self,
            input: crate::model::BillingGroupProperties,
        ) -> Self {
            self.billing_group_properties = Some(input);
            self
        }
        /// <p>The properties of the billing group.</p>
        pub fn set_billing_group_properties(
            mut self,
            input: std::option::Option<crate::model::BillingGroupProperties>,
        ) -> Self {
            self.billing_group_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the billing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the billing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBillingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBillingGroupInput {
                billing_group_name: self.billing_group_name,
                billing_group_properties: self.billing_group_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBillingGroupInputOperationOutputAlias = crate::operation::CreateBillingGroup;
#[doc(hidden)]
pub type CreateBillingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBillingGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateBillingGroup`](crate::operation::CreateBillingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBillingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBillingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.billing_group_name;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "billing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let billing_group_name = aws_smithy_http::label::fmt_string(input_18, false);
                if billing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "billing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/billing-groups/{billingGroupName}",
                    billingGroupName = billing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBillingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_billing_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBillingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBillingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
    pub fn builder() -> crate::input::create_billing_group_input::Builder {
        crate::input::create_billing_group_input::Builder::default()
    }
}

/// See [`CreateCertificateFromCsrInput`](crate::input::CreateCertificateFromCsrInput)
pub mod create_certificate_from_csr_input {
    /// A builder for [`CreateCertificateFromCsrInput`](crate::input::CreateCertificateFromCsrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_signing_request: std::option::Option<std::string::String>,
        pub(crate) set_as_active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The certificate signing request (CSR).</p>
        pub fn certificate_signing_request(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.certificate_signing_request = Some(input.into());
            self
        }
        /// <p>The certificate signing request (CSR).</p>
        pub fn set_certificate_signing_request(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_signing_request = input;
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.set_as_active = Some(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.set_as_active = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCertificateFromCsrInput`](crate::input::CreateCertificateFromCsrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCertificateFromCsrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCertificateFromCsrInput {
                certificate_signing_request: self.certificate_signing_request,
                set_as_active: self.set_as_active.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCertificateFromCsrInputOperationOutputAlias =
    crate::operation::CreateCertificateFromCsr;
#[doc(hidden)]
pub type CreateCertificateFromCsrInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCertificateFromCsrInput {
    /// Consumes the builder and constructs an Operation<[`CreateCertificateFromCsr`](crate::operation::CreateCertificateFromCsr)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCertificateFromCsr,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCertificateFromCsrInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/certificates").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateCertificateFromCsrInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.set_as_active {
                    query.push_kv(
                        "setAsActive",
                        aws_smithy_types::primitive::Encoder::from(_input.set_as_active).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCertificateFromCsrInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_certificate_from_csr(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCertificateFromCsr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCertificateFromCsr",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCertificateFromCsrInput`](crate::input::CreateCertificateFromCsrInput)
    pub fn builder() -> crate::input::create_certificate_from_csr_input::Builder {
        crate::input::create_certificate_from_csr_input::Builder::default()
    }
}

/// See [`CreateCustomMetricInput`](crate::input::CreateCustomMetricInput)
pub mod create_custom_metric_input {
    /// A builder for [`CreateCustomMetricInput`](crate::input::CreateCustomMetricInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) metric_type: std::option::Option<crate::model::CustomMetricType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. The name can't begin with <code>aws:</code>. You can't change the name after you define it.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p> The name of the custom metric. This will be used in the metric report submitted from the device/thing. The name can't begin with <code>aws:</code>. You can't change the name after you define it.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p> The friendly name in the console for the custom metric. This name doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. You can update the friendly name after you define it.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p> The friendly name in the console for the custom metric. This name doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. You can update the friendly name after you define it.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p> The type of the custom metric. </p> <important>
        /// <p>The type <code>number</code> only takes a single metric value as an input, but when you submit the metrics value in the DeviceMetrics report, you must pass it as an array with a single value.</p>
        /// </important>
        pub fn metric_type(mut self, input: crate::model::CustomMetricType) -> Self {
            self.metric_type = Some(input);
            self
        }
        /// <p> The type of the custom metric. </p> <important>
        /// <p>The type <code>number</code> only takes a single metric value as an input, but when you submit the metrics value in the DeviceMetrics report, you must pass it as an array with a single value.</p>
        /// </important>
        pub fn set_metric_type(
            mut self,
            input: std::option::Option<crate::model::CustomMetricType>,
        ) -> Self {
            self.metric_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> Metadata that can be used to manage the custom metric. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p> Metadata that can be used to manage the custom metric. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each custom metric must have a unique client request token. If you try to create a new custom metric that already exists with a different token, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomMetricInput`](crate::input::CreateCustomMetricInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomMetricInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomMetricInput {
                metric_name: self.metric_name,
                display_name: self.display_name,
                metric_type: self.metric_type,
                tags: self.tags,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomMetricInputOperationOutputAlias = crate::operation::CreateCustomMetric;
#[doc(hidden)]
pub type CreateCustomMetricInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCustomMetricInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomMetric`](crate::operation::CreateCustomMetric)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomMetric,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCustomMetricInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.metric_name;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let metric_name = aws_smithy_http::label::fmt_string(input_19, false);
                if metric_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/custom-metric/{metricName}",
                    metricName = metric_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCustomMetricInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_custom_metric(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomMetric::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomMetric",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomMetricInput`](crate::input::CreateCustomMetricInput)
    pub fn builder() -> crate::input::create_custom_metric_input::Builder {
        crate::input::create_custom_metric_input::Builder::default()
    }
}

/// See [`CreateDimensionInput`](crate::input::CreateDimensionInput)
pub mod create_dimension_input {
    /// A builder for [`CreateDimensionInput`](crate::input::CreateDimensionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DimensionType>,
        pub(crate) string_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
        pub fn r#type(mut self, input: crate::model::DimensionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::DimensionType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `string_values`.
        ///
        /// To override the contents of this collection use [`set_string_values`](Self::set_string_values).
        ///
        /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
        pub fn string_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_values.unwrap_or_default();
            v.push(input.into());
            self.string_values = Some(v);
            self
        }
        /// <p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>
        pub fn set_string_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_values = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the dimension.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata that can be used to manage the dimension.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs will automatically generate a unique client request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDimensionInput`](crate::input::CreateDimensionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDimensionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDimensionInput {
                name: self.name,
                r#type: self.r#type,
                string_values: self.string_values,
                tags: self.tags,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDimensionInputOperationOutputAlias = crate::operation::CreateDimension;
#[doc(hidden)]
pub type CreateDimensionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDimensionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDimension`](crate::operation::CreateDimension)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDimension,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDimensionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.name;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_20, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/dimensions/{name}", name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDimensionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_dimension(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDimension::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDimension",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDimensionInput`](crate::input::CreateDimensionInput)
    pub fn builder() -> crate::input::create_dimension_input::Builder {
        crate::input::create_dimension_input::Builder::default()
    }
}

/// See [`CreateDomainConfigurationInput`](crate::input::CreateDomainConfigurationInput)
pub mod create_domain_configuration_input {
    /// A builder for [`CreateDomainConfigurationInput`](crate::input::CreateDomainConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configuration_name: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) server_certificate_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) validation_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) authorizer_config: std::option::Option<crate::model::AuthorizerConfig>,
        pub(crate) service_type: std::option::Option<crate::model::ServiceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_name = input;
            self
        }
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `server_certificate_arns`.
        ///
        /// To override the contents of this collection use [`set_server_certificate_arns`](Self::set_server_certificate_arns).
        ///
        /// <p>The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn server_certificate_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.server_certificate_arns.unwrap_or_default();
            v.push(input.into());
            self.server_certificate_arns = Some(v);
            self
        }
        /// <p>The ARNs of the certificates that IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn set_server_certificate_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.server_certificate_arns = input;
            self
        }
        /// <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn validation_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_certificate_arn = Some(input.into());
            self
        }
        /// <p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for Amazon Web Services-managed domains.</p>
        pub fn set_validation_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_certificate_arn = input;
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn authorizer_config(mut self, input: crate::model::AuthorizerConfig) -> Self {
            self.authorizer_config = Some(input);
            self
        }
        /// <p>An object that specifies the authorization service for a domain.</p>
        pub fn set_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::AuthorizerConfig>,
        ) -> Self {
            self.authorizer_config = input;
            self
        }
        /// <p>The type of service delivered by the endpoint.</p> <note>
        /// <p>Amazon Web Services IoT Core currently supports only the <code>DATA</code> service type.</p>
        /// </note>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p> <note>
        /// <p>Amazon Web Services IoT Core currently supports only the <code>DATA</code> service type.</p>
        /// </note>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the domain configuration.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the domain configuration.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainConfigurationInput`](crate::input::CreateDomainConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainConfigurationInput {
                domain_configuration_name: self.domain_configuration_name,
                domain_name: self.domain_name,
                server_certificate_arns: self.server_certificate_arns,
                validation_certificate_arn: self.validation_certificate_arn,
                authorizer_config: self.authorizer_config,
                service_type: self.service_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainConfigurationInputOperationOutputAlias =
    crate::operation::CreateDomainConfiguration;
#[doc(hidden)]
pub type CreateDomainConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomainConfiguration`](crate::operation::CreateDomainConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomainConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.domain_configuration_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_configuration_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_configuration_name = aws_smithy_http::label::fmt_string(input_21, false);
                if domain_configuration_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_configuration_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainConfigurations/{domainConfigurationName}",
                    domainConfigurationName = domain_configuration_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomainConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomainConfiguration",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainConfigurationInput`](crate::input::CreateDomainConfigurationInput)
    pub fn builder() -> crate::input::create_domain_configuration_input::Builder {
        crate::input::create_domain_configuration_input::Builder::default()
    }
}

/// See [`CreateDynamicThingGroupInput`](crate::input::CreateDynamicThingGroupInput)
pub mod create_dynamic_thing_group_input {
    /// A builder for [`CreateDynamicThingGroupInput`](crate::input::CreateDynamicThingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_properties: std::option::Option<crate::model::ThingGroupProperties>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The dynamic thing group name to create.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The dynamic thing group name to create.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The dynamic thing group properties.</p>
        pub fn thing_group_properties(mut self, input: crate::model::ThingGroupProperties) -> Self {
            self.thing_group_properties = Some(input);
            self
        }
        /// <p>The dynamic thing group properties.</p>
        pub fn set_thing_group_properties(
            mut self,
            input: std::option::Option<crate::model::ThingGroupProperties>,
        ) -> Self {
            self.thing_group_properties = input;
            self
        }
        /// <p>The dynamic thing group index name.</p> <note>
        /// <p>Currently one index is supported: <code>AWS_Things</code>.</p>
        /// </note>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The dynamic thing group index name.</p> <note>
        /// <p>Currently one index is supported: <code>AWS_Things</code>.</p>
        /// </note>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        /// <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The dynamic thing group search query string.</p>
        /// <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The dynamic thing group query version.</p> <note>
        /// <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>
        /// </note>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The dynamic thing group query version.</p> <note>
        /// <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p>
        /// </note>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the dynamic thing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the dynamic thing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDynamicThingGroupInput`](crate::input::CreateDynamicThingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDynamicThingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDynamicThingGroupInput {
                thing_group_name: self.thing_group_name,
                thing_group_properties: self.thing_group_properties,
                index_name: self.index_name,
                query_string: self.query_string,
                query_version: self.query_version,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDynamicThingGroupInputOperationOutputAlias =
    crate::operation::CreateDynamicThingGroup;
#[doc(hidden)]
pub type CreateDynamicThingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDynamicThingGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDynamicThingGroup`](crate::operation::CreateDynamicThingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDynamicThingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDynamicThingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.thing_group_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_group_name = aws_smithy_http::label::fmt_string(input_22, false);
                if thing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/dynamic-thing-groups/{thingGroupName}",
                    thingGroupName = thing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDynamicThingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_dynamic_thing_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDynamicThingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDynamicThingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDynamicThingGroupInput`](crate::input::CreateDynamicThingGroupInput)
    pub fn builder() -> crate::input::create_dynamic_thing_group_input::Builder {
        crate::input::create_dynamic_thing_group_input::Builder::default()
    }
}

/// See [`CreateFleetMetricInput`](crate::input::CreateFleetMetricInput)
pub mod create_fleet_metric_input {
    /// A builder for [`CreateFleetMetricInput`](crate::input::CreateFleetMetricInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) aggregation_type: std::option::Option<crate::model::AggregationType>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) aggregation_field: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<crate::model::FleetMetricUnit>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the fleet metric to create.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet metric to create.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.aggregation_type = Some(input);
            self
        }
        /// <p>The type of the aggregation query.</p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.aggregation_type = input;
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregation_field = Some(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregation_field = input;
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The fleet metric description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>. Default to null.</p>
        pub fn unit(mut self, input: crate::model::FleetMetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>. Default to null.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::FleetMetricUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata, which can be used to manage the fleet metric.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata, which can be used to manage the fleet metric.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetMetricInput`](crate::input::CreateFleetMetricInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFleetMetricInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFleetMetricInput {
                metric_name: self.metric_name,
                query_string: self.query_string,
                aggregation_type: self.aggregation_type,
                period: self.period,
                aggregation_field: self.aggregation_field,
                description: self.description,
                query_version: self.query_version,
                index_name: self.index_name,
                unit: self.unit,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFleetMetricInputOperationOutputAlias = crate::operation::CreateFleetMetric;
#[doc(hidden)]
pub type CreateFleetMetricInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFleetMetricInput {
    /// Consumes the builder and constructs an Operation<[`CreateFleetMetric`](crate::operation::CreateFleetMetric)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFleetMetric,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFleetMetricInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.metric_name;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let metric_name = aws_smithy_http::label::fmt_string(input_23, false);
                if metric_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/fleet-metric/{metricName}",
                    metricName = metric_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFleetMetricInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_fleet_metric(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFleetMetric::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFleetMetric",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFleetMetricInput`](crate::input::CreateFleetMetricInput)
    pub fn builder() -> crate::input::create_fleet_metric_input::Builder {
        crate::input::create_fleet_metric_input::Builder::default()
    }
}

/// See [`CreateJobInput`](crate::input::CreateJobInput)
pub mod create_job_input {
    /// A builder for [`CreateJobInput`](crate::input::CreateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) document_source: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) presigned_url_config: std::option::Option<crate::model::PresignedUrlConfig>,
        pub(crate) target_selection: std::option::Option<crate::model::TargetSelection>,
        pub(crate) job_executions_rollout_config:
            std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        pub(crate) abort_config: std::option::Option<crate::model::AbortConfig>,
        pub(crate) timeout_config: std::option::Option<crate::model::TimeoutConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) namespace_id: std::option::Option<std::string::String>,
        pub(crate) job_template_arn: std::option::Option<std::string::String>,
        pub(crate) job_executions_retry_config:
            std::option::Option<crate::model::JobExecutionsRetryConfig>,
        pub(crate) document_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of things and thing groups to which the job should be sent.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>A list of things and thing groups to which the job should be sent.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_source = Some(input.into());
            self
        }
        /// <p>An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_source = input;
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A short text description of the job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Configuration information for pre-signed S3 URLs.</p>
        pub fn presigned_url_config(mut self, input: crate::model::PresignedUrlConfig) -> Self {
            self.presigned_url_config = Some(input);
            self
        }
        /// <p>Configuration information for pre-signed S3 URLs.</p>
        pub fn set_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::PresignedUrlConfig>,
        ) -> Self {
            self.presigned_url_config = input;
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.target_selection = Some(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.target_selection = input;
            self
        }
        /// <p>Allows you to create a staged rollout of the job.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::JobExecutionsRolloutConfig,
        ) -> Self {
            self.job_executions_rollout_config = Some(input);
            self
        }
        /// <p>Allows you to create a staged rollout of the job.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        ) -> Self {
            self.job_executions_rollout_config = input;
            self
        }
        /// <p>Allows you to create the criteria to abort a job.</p>
        pub fn abort_config(mut self, input: crate::model::AbortConfig) -> Self {
            self.abort_config = Some(input);
            self
        }
        /// <p>Allows you to create the criteria to abort a job.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::AbortConfig>,
        ) -> Self {
            self.abort_config = input;
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn timeout_config(mut self, input: crate::model::TimeoutConfig) -> Self {
            self.timeout_config = Some(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::TimeoutConfig>,
        ) -> Self {
            self.timeout_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the job.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_id = Some(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace_id = input;
            self
        }
        /// <p>The ARN of the job template used to create the job.</p>
        pub fn job_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the job template used to create the job.</p>
        pub fn set_job_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_arn = input;
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn job_executions_retry_config(
            mut self,
            input: crate::model::JobExecutionsRetryConfig,
        ) -> Self {
            self.job_executions_retry_config = Some(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn set_job_executions_retry_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRetryConfig>,
        ) -> Self {
            self.job_executions_retry_config = input;
            self
        }
        /// Adds a key-value pair to `document_parameters`.
        ///
        /// To override the contents of this collection use [`set_document_parameters`](Self::set_document_parameters).
        ///
        /// <p>Parameters of a managed template that you can specify to create the job document.</p>
        pub fn document_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.document_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.document_parameters = Some(hash_map);
            self
        }
        /// <p>Parameters of a managed template that you can specify to create the job document.</p>
        pub fn set_document_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.document_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobInput`](crate::input::CreateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateJobInput {
                job_id: self.job_id,
                targets: self.targets,
                document_source: self.document_source,
                document: self.document,
                description: self.description,
                presigned_url_config: self.presigned_url_config,
                target_selection: self.target_selection,
                job_executions_rollout_config: self.job_executions_rollout_config,
                abort_config: self.abort_config,
                timeout_config: self.timeout_config,
                tags: self.tags,
                namespace_id: self.namespace_id,
                job_template_arn: self.job_template_arn,
                job_executions_retry_config: self.job_executions_retry_config,
                document_parameters: self.document_parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateJobInputOperationOutputAlias = crate::operation::CreateJob;
#[doc(hidden)]
pub type CreateJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateJob`](crate::operation::CreateJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.job_id;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_24, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/jobs/{jobId}", jobId = job_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateJob",
                    "iot",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
}

/// See [`CreateJobTemplateInput`](crate::input::CreateJobTemplateInput)
pub mod create_job_template_input {
    /// A builder for [`CreateJobTemplateInput`](crate::input::CreateJobTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template_id: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) document_source: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) presigned_url_config: std::option::Option<crate::model::PresignedUrlConfig>,
        pub(crate) job_executions_rollout_config:
            std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        pub(crate) abort_config: std::option::Option<crate::model::AbortConfig>,
        pub(crate) timeout_config: std::option::Option<crate::model::TimeoutConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) job_executions_retry_config:
            std::option::Option<crate::model::JobExecutionsRetryConfig>,
    }
    impl Builder {
        /// <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_id = input;
            self
        }
        /// <p>The ARN of the job to use as the basis for the job template.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the job to use as the basis for the job template.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>An S3 link to the job document to use in the template. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn document_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_source = Some(input.into());
            self
        }
        /// <p>An S3 link to the job document to use in the template. Required if you don't specify a value for <code>document</code>.</p> <note>
        /// <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p>
        /// <p>The placeholder link is of the following form:</p>
        /// <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p>
        /// <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p>
        /// </note>
        pub fn set_document_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_source = input;
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The job document. Required if you don't specify a value for <code>documentSource</code>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>A description of the job document.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the job document.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn presigned_url_config(mut self, input: crate::model::PresignedUrlConfig) -> Self {
            self.presigned_url_config = Some(input);
            self
        }
        /// <p>Configuration for pre-signed S3 URLs.</p>
        pub fn set_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::PresignedUrlConfig>,
        ) -> Self {
            self.presigned_url_config = input;
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::JobExecutionsRolloutConfig,
        ) -> Self {
            self.job_executions_rollout_config = Some(input);
            self
        }
        /// <p>Allows you to create a staged rollout of a job.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRolloutConfig>,
        ) -> Self {
            self.job_executions_rollout_config = input;
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn abort_config(mut self, input: crate::model::AbortConfig) -> Self {
            self.abort_config = Some(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::AbortConfig>,
        ) -> Self {
            self.abort_config = input;
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn timeout_config(mut self, input: crate::model::TimeoutConfig) -> Self {
            self.timeout_config = Some(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::TimeoutConfig>,
        ) -> Self {
            self.timeout_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the job template.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata that can be used to manage the job template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn job_executions_retry_config(
            mut self,
            input: crate::model::JobExecutionsRetryConfig,
        ) -> Self {
            self.job_executions_retry_config = Some(input);
            self
        }
        /// <p>Allows you to create the criteria to retry a job.</p>
        pub fn set_job_executions_retry_config(
            mut self,
            input: std::option::Option<crate::model::JobExecutionsRetryConfig>,
        ) -> Self {
            self.job_executions_retry_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobTemplateInput`](crate::input::CreateJobTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateJobTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateJobTemplateInput {
                job_template_id: self.job_template_id,
                job_arn: self.job_arn,
                document_source: self.document_source,
                document: self.document,
                description: self.description,
                presigned_url_config: self.presigned_url_config,
                job_executions_rollout_config: self.job_executions_rollout_config,
                abort_config: self.abort_config,
                timeout_config: self.timeout_config,
                tags: self.tags,
                job_executions_retry_config: self.job_executions_retry_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateJobTemplateInputOperationOutputAlias = crate::operation::CreateJobTemplate;
#[doc(hidden)]
pub type CreateJobTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateJobTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateJobTemplate`](crate::operation::CreateJobTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateJobTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateJobTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.job_template_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_template_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_template_id = aws_smithy_http::label::fmt_string(input_25, false);
                if job_template_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_template_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/job-templates/{jobTemplateId}",
                    jobTemplateId = job_template_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateJobTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_job_template(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateJobTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateJobTemplate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateJobTemplateInput`](crate::input::CreateJobTemplateInput)
    pub fn builder() -> crate::input::create_job_template_input::Builder {
        crate::input::create_job_template_input::Builder::default()
    }
}

/// See [`CreateKeysAndCertificateInput`](crate::input::CreateKeysAndCertificateInput)
pub mod create_keys_and_certificate_input {
    /// A builder for [`CreateKeysAndCertificateInput`](crate::input::CreateKeysAndCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) set_as_active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_as_active(mut self, input: bool) -> Self {
            self.set_as_active = Some(input);
            self
        }
        /// <p>Specifies whether the certificate is active.</p>
        pub fn set_set_as_active(mut self, input: std::option::Option<bool>) -> Self {
            self.set_as_active = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeysAndCertificateInput`](crate::input::CreateKeysAndCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateKeysAndCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateKeysAndCertificateInput {
                set_as_active: self.set_as_active.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateKeysAndCertificateInputOperationOutputAlias =
    crate::operation::CreateKeysAndCertificate;
#[doc(hidden)]
pub type CreateKeysAndCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateKeysAndCertificateInput {
    /// Consumes the builder and constructs an Operation<[`CreateKeysAndCertificate`](crate::operation::CreateKeysAndCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateKeysAndCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateKeysAndCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/keys-and-certificate").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateKeysAndCertificateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.set_as_active {
                    query.push_kv(
                        "setAsActive",
                        aws_smithy_types::primitive::Encoder::from(_input.set_as_active).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateKeysAndCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateKeysAndCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateKeysAndCertificate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateKeysAndCertificateInput`](crate::input::CreateKeysAndCertificateInput)
    pub fn builder() -> crate::input::create_keys_and_certificate_input::Builder {
        crate::input::create_keys_and_certificate_input::Builder::default()
    }
}

/// See [`CreateMitigationActionInput`](crate::input::CreateMitigationActionInput)
pub mod create_mitigation_action_input {
    /// A builder for [`CreateMitigationActionInput`](crate::input::CreateMitigationActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) action_params: std::option::Option<crate::model::MitigationActionParams>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is used to apply the mitigation action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Defines the type of action and the parameters for that action.</p>
        pub fn action_params(mut self, input: crate::model::MitigationActionParams) -> Self {
            self.action_params = Some(input);
            self
        }
        /// <p>Defines the type of action and the parameters for that action.</p>
        pub fn set_action_params(
            mut self,
            input: std::option::Option<crate::model::MitigationActionParams>,
        ) -> Self {
            self.action_params = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the mitigation action.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata that can be used to manage the mitigation action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMitigationActionInput`](crate::input::CreateMitigationActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMitigationActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMitigationActionInput {
                action_name: self.action_name,
                role_arn: self.role_arn,
                action_params: self.action_params,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMitigationActionInputOperationOutputAlias = crate::operation::CreateMitigationAction;
#[doc(hidden)]
pub type CreateMitigationActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMitigationActionInput {
    /// Consumes the builder and constructs an Operation<[`CreateMitigationAction`](crate::operation::CreateMitigationAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMitigationAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMitigationActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.action_name;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let action_name = aws_smithy_http::label::fmt_string(input_26, false);
                if action_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/mitigationactions/actions/{actionName}",
                    actionName = action_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMitigationActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_mitigation_action(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMitigationAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMitigationAction",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMitigationActionInput`](crate::input::CreateMitigationActionInput)
    pub fn builder() -> crate::input::create_mitigation_action_input::Builder {
        crate::input::create_mitigation_action_input::Builder::default()
    }
}

/// See [`CreateOtaUpdateInput`](crate::input::CreateOtaUpdateInput)
pub mod create_ota_update_input {
    /// A builder for [`CreateOtaUpdateInput`](crate::input::CreateOtaUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_update_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        pub(crate) target_selection: std::option::Option<crate::model::TargetSelection>,
        pub(crate) aws_job_executions_rollout_config:
            std::option::Option<crate::model::AwsJobExecutionsRolloutConfig>,
        pub(crate) aws_job_presigned_url_config:
            std::option::Option<crate::model::AwsJobPresignedUrlConfig>,
        pub(crate) aws_job_abort_config: std::option::Option<crate::model::AwsJobAbortConfig>,
        pub(crate) aws_job_timeout_config: std::option::Option<crate::model::AwsJobTimeoutConfig>,
        pub(crate) files: std::option::Option<std::vec::Vec<crate::model::OtaUpdateFile>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) additional_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the OTA update to be created.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_id = Some(input.into());
            self
        }
        /// <p>The ID of the OTA update to be created.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_id = input;
            self
        }
        /// <p>The description of the OTA update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the OTA update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The devices targeted to receive OTA updates.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The devices targeted to receive OTA updates.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn protocols(mut self, input: crate::model::Protocol) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input);
            self.protocols = Some(v);
            self
        }
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.target_selection = Some(input);
            self
        }
        /// <p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.target_selection = input;
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn aws_job_executions_rollout_config(
            mut self,
            input: crate::model::AwsJobExecutionsRolloutConfig,
        ) -> Self {
            self.aws_job_executions_rollout_config = Some(input);
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn set_aws_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobExecutionsRolloutConfig>,
        ) -> Self {
            self.aws_job_executions_rollout_config = input;
            self
        }
        /// <p>Configuration information for pre-signed URLs.</p>
        pub fn aws_job_presigned_url_config(
            mut self,
            input: crate::model::AwsJobPresignedUrlConfig,
        ) -> Self {
            self.aws_job_presigned_url_config = Some(input);
            self
        }
        /// <p>Configuration information for pre-signed URLs.</p>
        pub fn set_aws_job_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobPresignedUrlConfig>,
        ) -> Self {
            self.aws_job_presigned_url_config = input;
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn aws_job_abort_config(mut self, input: crate::model::AwsJobAbortConfig) -> Self {
            self.aws_job_abort_config = Some(input);
            self
        }
        /// <p>The criteria that determine when and how a job abort takes place.</p>
        pub fn set_aws_job_abort_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobAbortConfig>,
        ) -> Self {
            self.aws_job_abort_config = input;
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn aws_job_timeout_config(mut self, input: crate::model::AwsJobTimeoutConfig) -> Self {
            self.aws_job_timeout_config = Some(input);
            self
        }
        /// <p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>
        pub fn set_aws_job_timeout_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobTimeoutConfig>,
        ) -> Self {
            self.aws_job_timeout_config = input;
            self
        }
        /// Appends an item to `files`.
        ///
        /// To override the contents of this collection use [`set_files`](Self::set_files).
        ///
        /// <p>The files to be streamed by the OTA update.</p>
        pub fn files(mut self, input: crate::model::OtaUpdateFile) -> Self {
            let mut v = self.files.unwrap_or_default();
            v.push(input);
            self.files = Some(v);
            self
        }
        /// <p>The files to be streamed by the OTA update.</p>
        pub fn set_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OtaUpdateFile>>,
        ) -> Self {
            self.files = input;
            self
        }
        /// <p>The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that grants Amazon Web Services IoT Core access to the Amazon S3, IoT jobs and Amazon Web Services Code Signing resources to create an OTA update job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `additional_parameters`.
        ///
        /// To override the contents of this collection use [`set_additional_parameters`](Self::set_additional_parameters).
        ///
        /// <p>A list of additional OTA update parameters which are name-value pairs.</p>
        pub fn additional_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_parameters = Some(hash_map);
            self
        }
        /// <p>A list of additional OTA update parameters which are name-value pairs.</p>
        pub fn set_additional_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_parameters = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage updates.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage updates.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOtaUpdateInput`](crate::input::CreateOtaUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOtaUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOtaUpdateInput {
                ota_update_id: self.ota_update_id,
                description: self.description,
                targets: self.targets,
                protocols: self.protocols,
                target_selection: self.target_selection,
                aws_job_executions_rollout_config: self.aws_job_executions_rollout_config,
                aws_job_presigned_url_config: self.aws_job_presigned_url_config,
                aws_job_abort_config: self.aws_job_abort_config,
                aws_job_timeout_config: self.aws_job_timeout_config,
                files: self.files,
                role_arn: self.role_arn,
                additional_parameters: self.additional_parameters,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOtaUpdateInputOperationOutputAlias = crate::operation::CreateOTAUpdate;
#[doc(hidden)]
pub type CreateOtaUpdateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOtaUpdateInput {
    /// Consumes the builder and constructs an Operation<[`CreateOTAUpdate`](crate::operation::CreateOTAUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOTAUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOtaUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.ota_update_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "ota_update_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let ota_update_id = aws_smithy_http::label::fmt_string(input_27, false);
                if ota_update_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ota_update_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/otaUpdates/{otaUpdateId}",
                    otaUpdateId = ota_update_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOtaUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_ota_update(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOTAUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOTAUpdate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOtaUpdateInput`](crate::input::CreateOtaUpdateInput)
    pub fn builder() -> crate::input::create_ota_update_input::Builder {
        crate::input::create_ota_update_input::Builder::default()
    }
}

/// See [`CreatePolicyInput`](crate::input::CreatePolicyInput)
pub mod create_policy_input {
    /// A builder for [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the policy.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the policy.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyInput`](crate::input::CreatePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePolicyInput {
                policy_name: self.policy_name,
                policy_document: self.policy_document,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePolicyInputOperationOutputAlias = crate::operation::CreatePolicy;
#[doc(hidden)]
pub type CreatePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreatePolicy`](crate::operation::CreatePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_28 = &_input.policy_name;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_28, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/policies/{policyName}", policyName = policy_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePolicy",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    pub fn builder() -> crate::input::create_policy_input::Builder {
        crate::input::create_policy_input::Builder::default()
    }
}

/// See [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
pub mod create_policy_version_input {
    /// A builder for [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) set_as_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
        pub fn set_as_default(mut self, input: bool) -> Self {
            self.set_as_default = Some(input);
            self
        }
        /// <p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.set_as_default = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePolicyVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePolicyVersionInput {
                policy_name: self.policy_name,
                policy_document: self.policy_document,
                set_as_default: self.set_as_default.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePolicyVersionInputOperationOutputAlias = crate::operation::CreatePolicyVersion;
#[doc(hidden)]
pub type CreatePolicyVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePolicyVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreatePolicyVersion`](crate::operation::CreatePolicyVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePolicyVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePolicyVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.policy_name;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_29, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/policies/{policyName}/version",
                    policyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreatePolicyVersionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.set_as_default {
                    query.push_kv(
                        "setAsDefault",
                        aws_smithy_types::primitive::Encoder::from(_input.set_as_default).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePolicyVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_policy_version(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePolicyVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePolicyVersion",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
    pub fn builder() -> crate::input::create_policy_version_input::Builder {
        crate::input::create_policy_version_input::Builder::default()
    }
}

/// See [`CreateProvisioningClaimInput`](crate::input::CreateProvisioningClaimInput)
pub mod create_provisioning_claim_input {
    /// A builder for [`CreateProvisioningClaimInput`](crate::input::CreateProvisioningClaimInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the provisioning template to use.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the provisioning template to use.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningClaimInput`](crate::input::CreateProvisioningClaimInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProvisioningClaimInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProvisioningClaimInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProvisioningClaimInputOperationOutputAlias =
    crate::operation::CreateProvisioningClaim;
#[doc(hidden)]
pub type CreateProvisioningClaimInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProvisioningClaimInput {
    /// Consumes the builder and constructs an Operation<[`CreateProvisioningClaim`](crate::operation::CreateProvisioningClaim)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProvisioningClaim,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateProvisioningClaimInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.template_name;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_30, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/provisioning-templates/{templateName}/provisioning-claim",
                    templateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateProvisioningClaimInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProvisioningClaim::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProvisioningClaim",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateProvisioningClaimInput`](crate::input::CreateProvisioningClaimInput)
    pub fn builder() -> crate::input::create_provisioning_claim_input::Builder {
        crate::input::create_provisioning_claim_input::Builder::default()
    }
}

/// See [`CreateProvisioningTemplateInput`](crate::input::CreateProvisioningTemplateInput)
pub mod create_provisioning_template_input {
    /// A builder for [`CreateProvisioningTemplateInput`](crate::input::CreateProvisioningTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) provisioning_role_arn: std::option::Option<std::string::String>,
        pub(crate) pre_provisioning_hook: std::option::Option<crate::model::ProvisioningHook>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>True to enable the fleet provisioning template, otherwise false.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True to enable the fleet provisioning template, otherwise false.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn provisioning_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>
        pub fn set_provisioning_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_role_arn = input;
            self
        }
        /// <p>Creates a pre-provisioning hook template.</p>
        pub fn pre_provisioning_hook(mut self, input: crate::model::ProvisioningHook) -> Self {
            self.pre_provisioning_hook = Some(input);
            self
        }
        /// <p>Creates a pre-provisioning hook template.</p>
        pub fn set_pre_provisioning_hook(
            mut self,
            input: std::option::Option<crate::model::ProvisioningHook>,
        ) -> Self {
            self.pre_provisioning_hook = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the fleet provisioning template.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the fleet provisioning template.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningTemplateInput`](crate::input::CreateProvisioningTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProvisioningTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProvisioningTemplateInput {
                template_name: self.template_name,
                description: self.description,
                template_body: self.template_body,
                enabled: self.enabled.unwrap_or_default(),
                provisioning_role_arn: self.provisioning_role_arn,
                pre_provisioning_hook: self.pre_provisioning_hook,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProvisioningTemplateInputOperationOutputAlias =
    crate::operation::CreateProvisioningTemplate;
#[doc(hidden)]
pub type CreateProvisioningTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProvisioningTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateProvisioningTemplate`](crate::operation::CreateProvisioningTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProvisioningTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateProvisioningTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/provisioning-templates").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateProvisioningTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_provisioning_template(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProvisioningTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProvisioningTemplate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateProvisioningTemplateInput`](crate::input::CreateProvisioningTemplateInput)
    pub fn builder() -> crate::input::create_provisioning_template_input::Builder {
        crate::input::create_provisioning_template_input::Builder::default()
    }
}

/// See [`CreateProvisioningTemplateVersionInput`](crate::input::CreateProvisioningTemplateVersionInput)
pub mod create_provisioning_template_version_input {
    /// A builder for [`CreateProvisioningTemplateVersionInput`](crate::input::CreateProvisioningTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) set_as_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The JSON formatted contents of the fleet provisioning template.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>Sets a fleet provision template version as the default version.</p>
        pub fn set_as_default(mut self, input: bool) -> Self {
            self.set_as_default = Some(input);
            self
        }
        /// <p>Sets a fleet provision template version as the default version.</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.set_as_default = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProvisioningTemplateVersionInput`](crate::input::CreateProvisioningTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProvisioningTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProvisioningTemplateVersionInput {
                template_name: self.template_name,
                template_body: self.template_body,
                set_as_default: self.set_as_default.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProvisioningTemplateVersionInputOperationOutputAlias =
    crate::operation::CreateProvisioningTemplateVersion;
#[doc(hidden)]
pub type CreateProvisioningTemplateVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateProvisioningTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateProvisioningTemplateVersion`](crate::operation::CreateProvisioningTemplateVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProvisioningTemplateVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateProvisioningTemplateVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.template_name;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_31, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/provisioning-templates/{templateName}/versions",
                    templateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateProvisioningTemplateVersionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.set_as_default {
                    query.push_kv(
                        "setAsDefault",
                        aws_smithy_types::primitive::Encoder::from(_input.set_as_default).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateProvisioningTemplateVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_provisioning_template_version(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProvisioningTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProvisioningTemplateVersion",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateProvisioningTemplateVersionInput`](crate::input::CreateProvisioningTemplateVersionInput)
    pub fn builder() -> crate::input::create_provisioning_template_version_input::Builder {
        crate::input::create_provisioning_template_version_input::Builder::default()
    }
}

/// See [`CreateRoleAliasInput`](crate::input::CreateRoleAliasInput)
pub mod create_role_alias_input {
    /// A builder for [`CreateRoleAliasInput`](crate::input::CreateRoleAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_alias: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) credential_duration_seconds: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias = Some(input.into());
            self
        }
        /// <p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_alias = input;
            self
        }
        /// <p>The role ARN.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>How long (in seconds) the credentials will be valid. The default value is 3,600 seconds.</p>
        /// <p>This value must be less than or equal to the maximum session duration of the IAM role that the role alias references.</p>
        pub fn credential_duration_seconds(mut self, input: i32) -> Self {
            self.credential_duration_seconds = Some(input);
            self
        }
        /// <p>How long (in seconds) the credentials will be valid. The default value is 3,600 seconds.</p>
        /// <p>This value must be less than or equal to the maximum session duration of the IAM role that the role alias references.</p>
        pub fn set_credential_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.credential_duration_seconds = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the role alias.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the role alias.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoleAliasInput`](crate::input::CreateRoleAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoleAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoleAliasInput {
                role_alias: self.role_alias,
                role_arn: self.role_arn,
                credential_duration_seconds: self.credential_duration_seconds,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoleAliasInputOperationOutputAlias = crate::operation::CreateRoleAlias;
#[doc(hidden)]
pub type CreateRoleAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRoleAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoleAlias`](crate::operation::CreateRoleAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoleAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRoleAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.role_alias;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "role_alias",
                        details: "cannot be empty or unset",
                    },
                )?;
                let role_alias = aws_smithy_http::label::fmt_string(input_32, false);
                if role_alias.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "role_alias",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/role-aliases/{roleAlias}", roleAlias = role_alias)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRoleAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_role_alias(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoleAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoleAlias",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRoleAliasInput`](crate::input::CreateRoleAliasInput)
    pub fn builder() -> crate::input::create_role_alias_input::Builder {
        crate::input::create_role_alias_input::Builder::default()
    }
}

/// See [`CreateScheduledAuditInput`](crate::input::CreateScheduledAuditInput)
pub mod create_scheduled_audit_input {
    /// A builder for [`CreateScheduledAuditInput`](crate::input::CreateScheduledAuditInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frequency: std::option::Option<crate::model::AuditFrequency>,
        pub(crate) day_of_month: std::option::Option<std::string::String>,
        pub(crate) day_of_week: std::option::Option<crate::model::DayOfWeek>,
        pub(crate) target_check_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) scheduled_audit_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn frequency(mut self, input: crate::model::AuditFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>How often the scheduled audit takes place, either <code>DAILY</code>, <code>WEEKLY</code>, <code>BIWEEKLY</code> or <code>MONTHLY</code>. The start time of each audit is determined by the system.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AuditFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn day_of_month(mut self, input: impl Into<std::string::String>) -> Self {
            self.day_of_month = Some(input.into());
            self
        }
        /// <p>The day of the month on which the scheduled audit takes place. This can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to <code>MONTHLY</code>. If days 29 to 31 are specified, and the month doesn't have that many days, the audit takes place on the <code>LAST</code> day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.day_of_month = input;
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
        pub fn day_of_week(mut self, input: crate::model::DayOfWeek) -> Self {
            self.day_of_week = Some(input);
            self
        }
        /// <p>The day of the week on which the scheduled audit takes place, either <code>SUN</code>, <code>MON</code>, <code>TUE</code>, <code>WED</code>, <code>THU</code>, <code>FRI</code>, or <code>SAT</code>. This field is required if the <code>frequency</code> parameter is set to <code>WEEKLY</code> or <code>BIWEEKLY</code>.</p>
        pub fn set_day_of_week(
            mut self,
            input: std::option::Option<crate::model::DayOfWeek>,
        ) -> Self {
            self.day_of_week = input;
            self
        }
        /// Appends an item to `target_check_names`.
        ///
        /// To override the contents of this collection use [`set_target_check_names`](Self::set_target_check_names).
        ///
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn target_check_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_check_names.unwrap_or_default();
            v.push(input.into());
            self.target_check_names = Some(v);
            self
        }
        /// <p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_target_check_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_check_names = input;
            self
        }
        /// <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_name = Some(input.into());
            self
        }
        /// <p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the scheduled audit.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata that can be used to manage the scheduled audit.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScheduledAuditInput`](crate::input::CreateScheduledAuditInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateScheduledAuditInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateScheduledAuditInput {
                frequency: self.frequency,
                day_of_month: self.day_of_month,
                day_of_week: self.day_of_week,
                target_check_names: self.target_check_names,
                scheduled_audit_name: self.scheduled_audit_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateScheduledAuditInputOperationOutputAlias = crate::operation::CreateScheduledAudit;
#[doc(hidden)]
pub type CreateScheduledAuditInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateScheduledAuditInput {
    /// Consumes the builder and constructs an Operation<[`CreateScheduledAudit`](crate::operation::CreateScheduledAudit)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateScheduledAudit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateScheduledAuditInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.scheduled_audit_name;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "scheduled_audit_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let scheduled_audit_name = aws_smithy_http::label::fmt_string(input_33, false);
                if scheduled_audit_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "scheduled_audit_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/audit/scheduledaudits/{scheduledAuditName}",
                    scheduledAuditName = scheduled_audit_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateScheduledAuditInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_scheduled_audit(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateScheduledAudit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateScheduledAudit",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateScheduledAuditInput`](crate::input::CreateScheduledAuditInput)
    pub fn builder() -> crate::input::create_scheduled_audit_input::Builder {
        crate::input::create_scheduled_audit_input::Builder::default()
    }
}

/// See [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
pub mod create_security_profile_input {
    /// A builder for [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_description: std::option::Option<std::string::String>,
        pub(crate) behaviors: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        pub(crate) alert_targets: std::option::Option<
            std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
        >,
        pub(crate) additional_metrics_to_retain:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) additional_metrics_to_retain_v2:
            std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name you are giving to the security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name you are giving to the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>A description of the security profile.</p>
        pub fn security_profile_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.security_profile_description = Some(input.into());
            self
        }
        /// <p>A description of the security profile.</p>
        pub fn set_security_profile_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_description = input;
            self
        }
        /// Appends an item to `behaviors`.
        ///
        /// To override the contents of this collection use [`set_behaviors`](Self::set_behaviors).
        ///
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn behaviors(mut self, input: crate::model::Behavior) -> Self {
            let mut v = self.behaviors.unwrap_or_default();
            v.push(input);
            self.behaviors = Some(v);
            self
        }
        /// <p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>
        pub fn set_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Behavior>>,
        ) -> Self {
            self.behaviors = input;
            self
        }
        /// Adds a key-value pair to `alert_targets`.
        ///
        /// To override the contents of this collection use [`set_alert_targets`](Self::set_alert_targets).
        ///
        /// <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
        pub fn alert_targets(
            mut self,
            k: crate::model::AlertTargetType,
            v: crate::model::AlertTarget,
        ) -> Self {
            let mut hash_map = self.alert_targets.unwrap_or_default();
            hash_map.insert(k, v);
            self.alert_targets = Some(hash_map);
            self
        }
        /// <p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>
        pub fn set_alert_targets(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::AlertTargetType, crate::model::AlertTarget>,
            >,
        ) -> Self {
            self.alert_targets = input;
            self
        }
        /// Appends an item to `additional_metrics_to_retain`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain`](Self::set_additional_metrics_to_retain).
        ///
        /// <p> <i>Please use <code>CreateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn additional_metrics_to_retain(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_metrics_to_retain.unwrap_or_default();
            v.push(input.into());
            self.additional_metrics_to_retain = Some(v);
            self
        }
        /// <p> <i>Please use <code>CreateSecurityProfileRequest$additionalMetricsToRetainV2</code> instead.</i> </p>
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn set_additional_metrics_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_metrics_to_retain = input;
            self
        }
        /// Appends an item to `additional_metrics_to_retain_v2`.
        ///
        /// To override the contents of this collection use [`set_additional_metrics_to_retain_v2`](Self::set_additional_metrics_to_retain_v2).
        ///
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn additional_metrics_to_retain_v2(
            mut self,
            input: crate::model::MetricToRetain,
        ) -> Self {
            let mut v = self.additional_metrics_to_retain_v2.unwrap_or_default();
            v.push(input);
            self.additional_metrics_to_retain_v2 = Some(v);
            self
        }
        /// <p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's <code>behaviors</code>, but it is also retained for any metric specified here. Can be used with custom metrics; cannot be used with dimensions.</p>
        pub fn set_additional_metrics_to_retain_v2(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricToRetain>>,
        ) -> Self {
            self.additional_metrics_to_retain_v2 = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata that can be used to manage the security profile.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata that can be used to manage the security profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSecurityProfileInput {
                security_profile_name: self.security_profile_name,
                security_profile_description: self.security_profile_description,
                behaviors: self.behaviors,
                alert_targets: self.alert_targets,
                additional_metrics_to_retain: self.additional_metrics_to_retain,
                additional_metrics_to_retain_v2: self.additional_metrics_to_retain_v2,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSecurityProfileInputOperationOutputAlias = crate::operation::CreateSecurityProfile;
#[doc(hidden)]
pub type CreateSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateSecurityProfile`](crate::operation::CreateSecurityProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSecurityProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_34 = &_input.security_profile_name;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let security_profile_name = aws_smithy_http::label::fmt_string(input_34, false);
                if security_profile_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/security-profiles/{securityProfileName}",
                    securityProfileName = security_profile_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSecurityProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_security_profile(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSecurityProfile",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
    pub fn builder() -> crate::input::create_security_profile_input::Builder {
        crate::input::create_security_profile_input::Builder::default()
    }
}

/// See [`CreateStreamInput`](crate::input::CreateStreamInput)
pub mod create_stream_input {
    /// A builder for [`CreateStreamInput`](crate::input::CreateStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) files: std::option::Option<std::vec::Vec<crate::model::StreamFile>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>A description of the stream.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the stream.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `files`.
        ///
        /// To override the contents of this collection use [`set_files`](Self::set_files).
        ///
        /// <p>The files to stream.</p>
        pub fn files(mut self, input: crate::model::StreamFile) -> Self {
            let mut v = self.files.unwrap_or_default();
            v.push(input);
            self.files = Some(v);
            self
        }
        /// <p>The files to stream.</p>
        pub fn set_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StreamFile>>,
        ) -> Self {
            self.files = input;
            self
        }
        /// <p>An IAM role that allows the IoT service principal to access your S3 files.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>An IAM role that allows the IoT service principal to access your S3 files.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage streams.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage streams.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamInput`](crate::input::CreateStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamInput {
                stream_id: self.stream_id,
                description: self.description,
                files: self.files,
                role_arn: self.role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamInputOperationOutputAlias = crate::operation::CreateStream;
#[doc(hidden)]
pub type CreateStreamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStreamInput {
    /// Consumes the builder and constructs an Operation<[`CreateStream`](crate::operation::CreateStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.stream_id;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stream_id = aws_smithy_http::label::fmt_string(input_35, false);
                if stream_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/streams/{streamId}", streamId = stream_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_stream(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStream",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamInput`](crate::input::CreateStreamInput)
    pub fn builder() -> crate::input::create_stream_input::Builder {
        crate::input::create_stream_input::Builder::default()
    }
}

/// See [`CreateThingInput`](crate::input::CreateThingInput)
pub mod create_thing_input {
    /// A builder for [`CreateThingInput`](crate::input::CreateThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) attribute_payload: std::option::Option<crate::model::AttributePayload>,
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing to create.</p>
        /// <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing to create.</p>
        /// <p>You can't change a thing's name after you create it. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The name of the thing type associated with the new thing.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type associated with the new thing.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p>
        /// <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
        pub fn attribute_payload(mut self, input: crate::model::AttributePayload) -> Self {
            self.attribute_payload = Some(input);
            self
        }
        /// <p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p>
        /// <p> <code>{\"attributes\":{\"string1\":\"string2\"}}</code> </p>
        pub fn set_attribute_payload(
            mut self,
            input: std::option::Option<crate::model::AttributePayload>,
        ) -> Self {
            self.attribute_payload = input;
            self
        }
        /// <p>The name of the billing group the thing will be added to.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the billing group the thing will be added to.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThingInput`](crate::input::CreateThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThingInput {
                thing_name: self.thing_name,
                thing_type_name: self.thing_type_name,
                attribute_payload: self.attribute_payload,
                billing_group_name: self.billing_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThingInputOperationOutputAlias = crate::operation::CreateThing;
#[doc(hidden)]
pub type CreateThingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThingInput {
    /// Consumes the builder and constructs an Operation<[`CreateThing`](crate::operation::CreateThing)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateThing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateThingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.thing_name;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_36, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/things/{thingName}", thingName = thing_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateThingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_thing(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateThing",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateThingInput`](crate::input::CreateThingInput)
    pub fn builder() -> crate::input::create_thing_input::Builder {
        crate::input::create_thing_input::Builder::default()
    }
}

/// See [`CreateThingGroupInput`](crate::input::CreateThingGroupInput)
pub mod create_thing_group_input {
    /// A builder for [`CreateThingGroupInput`](crate::input::CreateThingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) parent_group_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_properties: std::option::Option<crate::model::ThingGroupProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The thing group name to create.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The thing group name to create.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The name of the parent thing group.</p>
        pub fn parent_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parent thing group.</p>
        pub fn set_parent_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_group_name = input;
            self
        }
        /// <p>The thing group properties.</p>
        pub fn thing_group_properties(mut self, input: crate::model::ThingGroupProperties) -> Self {
            self.thing_group_properties = Some(input);
            self
        }
        /// <p>The thing group properties.</p>
        pub fn set_thing_group_properties(
            mut self,
            input: std::option::Option<crate::model::ThingGroupProperties>,
        ) -> Self {
            self.thing_group_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the thing group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the thing group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThingGroupInput`](crate::input::CreateThingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThingGroupInput {
                thing_group_name: self.thing_group_name,
                parent_group_name: self.parent_group_name,
                thing_group_properties: self.thing_group_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThingGroupInputOperationOutputAlias = crate::operation::CreateThingGroup;
#[doc(hidden)]
pub type CreateThingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThingGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateThingGroup`](crate::operation::CreateThingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateThingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateThingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.thing_group_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_group_name = aws_smithy_http::label::fmt_string(input_37, false);
                if thing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-groups/{thingGroupName}",
                    thingGroupName = thing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateThingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_thing_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateThingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateThingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateThingGroupInput`](crate::input::CreateThingGroupInput)
    pub fn builder() -> crate::input::create_thing_group_input::Builder {
        crate::input::create_thing_group_input::Builder::default()
    }
}

/// See [`CreateThingTypeInput`](crate::input::CreateThingTypeInput)
pub mod create_thing_type_input {
    /// A builder for [`CreateThingTypeInput`](crate::input::CreateThingTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) thing_type_properties: std::option::Option<crate::model::ThingTypeProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
        pub fn thing_type_properties(mut self, input: crate::model::ThingTypeProperties) -> Self {
            self.thing_type_properties = Some(input);
            self
        }
        /// <p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>
        pub fn set_thing_type_properties(
            mut self,
            input: std::option::Option<crate::model::ThingTypeProperties>,
        ) -> Self {
            self.thing_type_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Metadata which can be used to manage the thing type.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Metadata which can be used to manage the thing type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThingTypeInput`](crate::input::CreateThingTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThingTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThingTypeInput {
                thing_type_name: self.thing_type_name,
                thing_type_properties: self.thing_type_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThingTypeInputOperationOutputAlias = crate::operation::CreateThingType;
#[doc(hidden)]
pub type CreateThingTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThingTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateThingType`](crate::operation::CreateThingType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateThingType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateThingTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.thing_type_name;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_type_name = aws_smithy_http::label::fmt_string(input_38, false);
                if thing_type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-types/{thingTypeName}",
                    thingTypeName = thing_type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateThingTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_thing_type(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateThingType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateThingType",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateThingTypeInput`](crate::input::CreateThingTypeInput)
    pub fn builder() -> crate::input::create_thing_type_input::Builder {
        crate::input::create_thing_type_input::Builder::default()
    }
}

/// See [`CreateTopicRuleInput`](crate::input::CreateTopicRuleInput)
pub mod create_topic_rule_input {
    /// A builder for [`CreateTopicRuleInput`](crate::input::CreateTopicRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) topic_rule_payload: std::option::Option<crate::model::TopicRulePayload>,
        pub(crate) tags: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The rule payload.</p>
        pub fn topic_rule_payload(mut self, input: crate::model::TopicRulePayload) -> Self {
            self.topic_rule_payload = Some(input);
            self
        }
        /// <p>The rule payload.</p>
        pub fn set_topic_rule_payload(
            mut self,
            input: std::option::Option<crate::model::TopicRulePayload>,
        ) -> Self {
            self.topic_rule_payload = input;
            self
        }
        /// <p>Metadata which can be used to manage the topic rule.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.tags = Some(input.into());
            self
        }
        /// <p>Metadata which can be used to manage the topic rule.</p> <note>
        /// <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p>
        /// <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p>
        /// <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p>
        /// </note>
        pub fn set_tags(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTopicRuleInput`](crate::input::CreateTopicRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTopicRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTopicRuleInput {
                rule_name: self.rule_name,
                topic_rule_payload: self.topic_rule_payload,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTopicRuleInputOperationOutputAlias = crate::operation::CreateTopicRule;
#[doc(hidden)]
pub type CreateTopicRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTopicRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateTopicRule`](crate::operation::CreateTopicRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTopicRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTopicRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.rule_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let rule_name = aws_smithy_http::label::fmt_string(input_39, false);
                if rule_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/rules/{ruleName}", ruleName = rule_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTopicRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_topic_rule(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_topic_rule_input(
                &self.topic_rule_payload,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTopicRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTopicRule",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTopicRuleInput`](crate::input::CreateTopicRuleInput)
    pub fn builder() -> crate::input::create_topic_rule_input::Builder {
        crate::input::create_topic_rule_input::Builder::default()
    }
}

/// See [`CreateTopicRuleDestinationInput`](crate::input::CreateTopicRuleDestinationInput)
pub mod create_topic_rule_destination_input {
    /// A builder for [`CreateTopicRuleDestinationInput`](crate::input::CreateTopicRuleDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_configuration:
            std::option::Option<crate::model::TopicRuleDestinationConfiguration>,
    }
    impl Builder {
        /// <p>The topic rule destination configuration.</p>
        pub fn destination_configuration(
            mut self,
            input: crate::model::TopicRuleDestinationConfiguration,
        ) -> Self {
            self.destination_configuration = Some(input);
            self
        }
        /// <p>The topic rule destination configuration.</p>
        pub fn set_destination_configuration(
            mut self,
            input: std::option::Option<crate::model::TopicRuleDestinationConfiguration>,
        ) -> Self {
            self.destination_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTopicRuleDestinationInput`](crate::input::CreateTopicRuleDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTopicRuleDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTopicRuleDestinationInput {
                destination_configuration: self.destination_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTopicRuleDestinationInputOperationOutputAlias =
    crate::operation::CreateTopicRuleDestination;
#[doc(hidden)]
pub type CreateTopicRuleDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTopicRuleDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreateTopicRuleDestination`](crate::operation::CreateTopicRuleDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTopicRuleDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTopicRuleDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/destinations").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTopicRuleDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_topic_rule_destination(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTopicRuleDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTopicRuleDestination",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTopicRuleDestinationInput`](crate::input::CreateTopicRuleDestinationInput)
    pub fn builder() -> crate::input::create_topic_rule_destination_input::Builder {
        crate::input::create_topic_rule_destination_input::Builder::default()
    }
}

/// See [`DeleteAccountAuditConfigurationInput`](crate::input::DeleteAccountAuditConfigurationInput)
pub mod delete_account_audit_configuration_input {
    /// A builder for [`DeleteAccountAuditConfigurationInput`](crate::input::DeleteAccountAuditConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delete_scheduled_audits: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If true, all scheduled audits are deleted.</p>
        pub fn delete_scheduled_audits(mut self, input: bool) -> Self {
            self.delete_scheduled_audits = Some(input);
            self
        }
        /// <p>If true, all scheduled audits are deleted.</p>
        pub fn set_delete_scheduled_audits(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_scheduled_audits = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountAuditConfigurationInput`](crate::input::DeleteAccountAuditConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccountAuditConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccountAuditConfigurationInput {
                delete_scheduled_audits: self.delete_scheduled_audits.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccountAuditConfigurationInputOperationOutputAlias =
    crate::operation::DeleteAccountAuditConfiguration;
#[doc(hidden)]
pub type DeleteAccountAuditConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccountAuditConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccountAuditConfiguration`](crate::operation::DeleteAccountAuditConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccountAuditConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAccountAuditConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/audit/configuration").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteAccountAuditConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.delete_scheduled_audits {
                    query.push_kv(
                        "deleteScheduledAudits",
                        aws_smithy_types::primitive::Encoder::from(_input.delete_scheduled_audits)
                            .encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAccountAuditConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccountAuditConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccountAuditConfiguration",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccountAuditConfigurationInput`](crate::input::DeleteAccountAuditConfigurationInput)
    pub fn builder() -> crate::input::delete_account_audit_configuration_input::Builder {
        crate::input::delete_account_audit_configuration_input::Builder::default()
    }
}

/// See [`DeleteAuditSuppressionInput`](crate::input::DeleteAuditSuppressionInput)
pub mod delete_audit_suppression_input {
    /// A builder for [`DeleteAuditSuppressionInput`](crate::input::DeleteAuditSuppressionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
    }
    impl Builder {
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_name = Some(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_name = input;
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAuditSuppressionInput`](crate::input::DeleteAuditSuppressionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAuditSuppressionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAuditSuppressionInput {
                check_name: self.check_name,
                resource_identifier: self.resource_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAuditSuppressionInputOperationOutputAlias = crate::operation::DeleteAuditSuppression;
#[doc(hidden)]
pub type DeleteAuditSuppressionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAuditSuppressionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAuditSuppression`](crate::operation::DeleteAuditSuppression)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAuditSuppression,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAuditSuppressionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/audit/suppressions/delete").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAuditSuppressionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_audit_suppression(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAuditSuppression::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAuditSuppression",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAuditSuppressionInput`](crate::input::DeleteAuditSuppressionInput)
    pub fn builder() -> crate::input::delete_audit_suppression_input::Builder {
        crate::input::delete_audit_suppression_input::Builder::default()
    }
}

/// See [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
pub mod delete_authorizer_input {
    /// A builder for [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authorizer to delete.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer to delete.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAuthorizerInput {
                authorizer_name: self.authorizer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAuthorizerInputOperationOutputAlias = crate::operation::DeleteAuthorizer;
#[doc(hidden)]
pub type DeleteAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAuthorizer`](crate::operation::DeleteAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.authorizer_name;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let authorizer_name = aws_smithy_http::label::fmt_string(input_40, false);
                if authorizer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/authorizer/{authorizerName}",
                    authorizerName = authorizer_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAuthorizer",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    pub fn builder() -> crate::input::delete_authorizer_input::Builder {
        crate::input::delete_authorizer_input::Builder::default()
    }
}

/// See [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
pub mod delete_billing_group_input {
    /// A builder for [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
        pub(crate) expected_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBillingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBillingGroupInput {
                billing_group_name: self.billing_group_name,
                expected_version: self.expected_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBillingGroupInputOperationOutputAlias = crate::operation::DeleteBillingGroup;
#[doc(hidden)]
pub type DeleteBillingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBillingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBillingGroup`](crate::operation::DeleteBillingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBillingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBillingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.billing_group_name;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "billing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let billing_group_name = aws_smithy_http::label::fmt_string(input_41, false);
                if billing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "billing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/billing-groups/{billingGroupName}",
                    billingGroupName = billing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBillingGroupInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_42) = &_input.expected_version {
                    query.push_kv(
                        "expectedVersion",
                        aws_smithy_types::primitive::Encoder::from(*inner_42).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBillingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBillingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBillingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
    pub fn builder() -> crate::input::delete_billing_group_input::Builder {
        crate::input::delete_billing_group_input::Builder::default()
    }
}

/// See [`DeleteCaCertificateInput`](crate::input::DeleteCaCertificateInput)
pub mod delete_ca_certificate_input {
    /// A builder for [`DeleteCaCertificateInput`](crate::input::DeleteCaCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCaCertificateInput`](crate::input::DeleteCaCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCaCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCaCertificateInput {
                certificate_id: self.certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCaCertificateInputOperationOutputAlias = crate::operation::DeleteCACertificate;
#[doc(hidden)]
pub type DeleteCaCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCaCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCACertificate`](crate::operation::DeleteCACertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCACertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCaCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.certificate_id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let certificate_id = aws_smithy_http::label::fmt_string(input_43, false);
                if certificate_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/cacertificate/{certificateId}",
                    certificateId = certificate_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCaCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCACertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCACertificate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCaCertificateInput`](crate::input::DeleteCaCertificateInput)
    pub fn builder() -> crate::input::delete_ca_certificate_input::Builder {
        crate::input::delete_ca_certificate_input::Builder::default()
    }
}

/// See [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
pub mod delete_certificate_input {
    /// A builder for [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCertificateInput {
                certificate_id: self.certificate_id,
                force_delete: self.force_delete.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCertificateInputOperationOutputAlias = crate::operation::DeleteCertificate;
#[doc(hidden)]
pub type DeleteCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCertificate`](crate::operation::DeleteCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.certificate_id;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let certificate_id = aws_smithy_http::label::fmt_string(input_44, false);
                if certificate_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/certificates/{certificateId}",
                    certificateId = certificate_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteCertificateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.force_delete {
                    query.push_kv(
                        "forceDelete",
                        aws_smithy_types::primitive::Encoder::from(_input.force_delete).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCertificate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    pub fn builder() -> crate::input::delete_certificate_input::Builder {
        crate::input::delete_certificate_input::Builder::default()
    }
}

/// See [`DeleteCustomMetricInput`](crate::input::DeleteCustomMetricInput)
pub mod delete_custom_metric_input {
    /// A builder for [`DeleteCustomMetricInput`](crate::input::DeleteCustomMetricInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomMetricInput`](crate::input::DeleteCustomMetricInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomMetricInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomMetricInput {
                metric_name: self.metric_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomMetricInputOperationOutputAlias = crate::operation::DeleteCustomMetric;
#[doc(hidden)]
pub type DeleteCustomMetricInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCustomMetricInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomMetric`](crate::operation::DeleteCustomMetric)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomMetric,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCustomMetricInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.metric_name;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let metric_name = aws_smithy_http::label::fmt_string(input_45, false);
                if metric_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/custom-metric/{metricName}",
                    metricName = metric_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCustomMetricInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomMetric::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomMetric",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomMetricInput`](crate::input::DeleteCustomMetricInput)
    pub fn builder() -> crate::input::delete_custom_metric_input::Builder {
        crate::input::delete_custom_metric_input::Builder::default()
    }
}

/// See [`DeleteDimensionInput`](crate::input::DeleteDimensionInput)
pub mod delete_dimension_input {
    /// A builder for [`DeleteDimensionInput`](crate::input::DeleteDimensionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the dimension that you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique identifier for the dimension that you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDimensionInput`](crate::input::DeleteDimensionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDimensionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDimensionInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteDimensionInputOperationOutputAlias = crate::operation::DeleteDimension;
#[doc(hidden)]
pub type DeleteDimensionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDimensionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDimension`](crate::operation::DeleteDimension)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDimension,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDimensionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.name;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_46, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/dimensions/{name}", name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDimensionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDimension::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDimension",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDimensionInput`](crate::input::DeleteDimensionInput)
    pub fn builder() -> crate::input::delete_dimension_input::Builder {
        crate::input::delete_dimension_input::Builder::default()
    }
}

/// See [`DeleteDomainConfigurationInput`](crate::input::DeleteDomainConfigurationInput)
pub mod delete_domain_configuration_input {
    /// A builder for [`DeleteDomainConfigurationInput`](crate::input::DeleteDomainConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configuration_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain configuration to be deleted.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the domain configuration to be deleted.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainConfigurationInput`](crate::input::DeleteDomainConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainConfigurationInput {
                domain_configuration_name: self.domain_configuration_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainConfigurationInputOperationOutputAlias =
    crate::operation::DeleteDomainConfiguration;
#[doc(hidden)]
pub type DeleteDomainConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomainConfiguration`](crate::operation::DeleteDomainConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomainConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_47 = &_input.domain_configuration_name;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_configuration_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_configuration_name = aws_smithy_http::label::fmt_string(input_47, false);
                if domain_configuration_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_configuration_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainConfigurations/{domainConfigurationName}",
                    domainConfigurationName = domain_configuration_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomainConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomainConfiguration",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainConfigurationInput`](crate::input::DeleteDomainConfigurationInput)
    pub fn builder() -> crate::input::delete_domain_configuration_input::Builder {
        crate::input::delete_domain_configuration_input::Builder::default()
    }
}

/// See [`DeleteDynamicThingGroupInput`](crate::input::DeleteDynamicThingGroupInput)
pub mod delete_dynamic_thing_group_input {
    /// A builder for [`DeleteDynamicThingGroupInput`](crate::input::DeleteDynamicThingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) expected_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the dynamic thing group to delete.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the dynamic thing group to delete.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The expected version of the dynamic thing group to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>The expected version of the dynamic thing group to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDynamicThingGroupInput`](crate::input::DeleteDynamicThingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDynamicThingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDynamicThingGroupInput {
                thing_group_name: self.thing_group_name,
                expected_version: self.expected_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDynamicThingGroupInputOperationOutputAlias =
    crate::operation::DeleteDynamicThingGroup;
#[doc(hidden)]
pub type DeleteDynamicThingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDynamicThingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDynamicThingGroup`](crate::operation::DeleteDynamicThingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDynamicThingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDynamicThingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.thing_group_name;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_group_name = aws_smithy_http::label::fmt_string(input_48, false);
                if thing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/dynamic-thing-groups/{thingGroupName}",
                    thingGroupName = thing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteDynamicThingGroupInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.expected_version {
                    query.push_kv(
                        "expectedVersion",
                        aws_smithy_types::primitive::Encoder::from(*inner_49).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDynamicThingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDynamicThingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDynamicThingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDynamicThingGroupInput`](crate::input::DeleteDynamicThingGroupInput)
    pub fn builder() -> crate::input::delete_dynamic_thing_group_input::Builder {
        crate::input::delete_dynamic_thing_group_input::Builder::default()
    }
}

/// See [`DeleteFleetMetricInput`](crate::input::DeleteFleetMetricInput)
pub mod delete_fleet_metric_input {
    /// A builder for [`DeleteFleetMetricInput`](crate::input::DeleteFleetMetricInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) expected_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the fleet metric to delete.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet metric to delete.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The expected version of the fleet metric to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>The expected version of the fleet metric to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFleetMetricInput`](crate::input::DeleteFleetMetricInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFleetMetricInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFleetMetricInput {
                metric_name: self.metric_name,
                expected_version: self.expected_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFleetMetricInputOperationOutputAlias = crate::operation::DeleteFleetMetric;
#[doc(hidden)]
pub type DeleteFleetMetricInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFleetMetricInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFleetMetric`](crate::operation::DeleteFleetMetric)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFleetMetric,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFleetMetricInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.metric_name;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let metric_name = aws_smithy_http::label::fmt_string(input_50, false);
                if metric_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/fleet-metric/{metricName}",
                    metricName = metric_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteFleetMetricInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_51) = &_input.expected_version {
                    query.push_kv(
                        "expectedVersion",
                        aws_smithy_types::primitive::Encoder::from(*inner_51).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFleetMetricInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFleetMetric::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFleetMetric",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFleetMetricInput`](crate::input::DeleteFleetMetricInput)
    pub fn builder() -> crate::input::delete_fleet_metric_input::Builder {
        crate::input::delete_fleet_metric_input::Builder::default()
    }
}

/// See [`DeleteJobInput`](crate::input::DeleteJobInput)
pub mod delete_job_input {
    /// A builder for [`DeleteJobInput`](crate::input::DeleteJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
        pub(crate) namespace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the job to be deleted.</p>
        /// <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job to be deleted.</p>
        /// <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p>
        /// </note>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p>
        /// </note>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_id = Some(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobInput`](crate::input::DeleteJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteJobInput {
                job_id: self.job_id,
                force: self.force.unwrap_or_default(),
                namespace_id: self.namespace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteJobInputOperationOutputAlias = crate::operation::DeleteJob;
#[doc(hidden)]
pub type DeleteJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteJobInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJob`](crate::operation::DeleteJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.job_id;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_52, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/jobs/{jobId}", jobId = job_id).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteJobInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.force {
                    query.push_kv(
                        "force",
                        aws_smithy_types::primitive::Encoder::from(_input.force).encode(),
                    );
                }
                if let Some(inner_53) = &_input.namespace_id {
                    query.push_kv(
                        "namespaceId",
                        &aws_smithy_http::query::fmt_string(&inner_53),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteJob",
                    "iot",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
}

/// See [`DeleteJobExecutionInput`](crate::input::DeleteJobExecutionInput)
pub mod delete_job_execution_input {
    /// A builder for [`DeleteJobExecutionInput`](crate::input::DeleteJobExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) execution_number: std::option::Option<i64>,
        pub(crate) force: std::option::Option<bool>,
        pub(crate) namespace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the job whose execution on a particular device will be deleted.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job whose execution on a particular device will be deleted.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the thing whose job execution will be deleted.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing whose job execution will be deleted.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p>
        /// <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.execution_number = Some(input);
            self
        }
        /// <p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p>
        /// <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.execution_number = input;
            self
        }
        /// <p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        /// </note>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note>
        /// <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>
        /// </note>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn namespace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace_id = Some(input.into());
            self
        }
        /// <p>The namespace used to indicate that a job is a customer-managed job.</p>
        /// <p>When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics that contain the value in the following format.</p>
        /// <p> <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code> </p> <note>
        /// <p>The <code>namespaceId</code> feature is in public preview.</p>
        /// </note>
        pub fn set_namespace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobExecutionInput`](crate::input::DeleteJobExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteJobExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteJobExecutionInput {
                job_id: self.job_id,
                thing_name: self.thing_name,
                execution_number: self.execution_number,
                force: self.force.unwrap_or_default(),
                namespace_id: self.namespace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteJobExecutionInputOperationOutputAlias = crate::operation::DeleteJobExecution;
#[doc(hidden)]
pub type DeleteJobExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteJobExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJobExecution`](crate::operation::DeleteJobExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJobExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteJobExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_54 = &_input.thing_name;
                let input_54 = input_54.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_54, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_55 = &_input.job_id;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_55, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_56 = &_input.execution_number;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "execution_number",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mut execution_number_encoder =
                    aws_smithy_types::primitive::Encoder::from(*input_56);
                let execution_number = execution_number_encoder.encode();
                if execution_number.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "execution_number",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/things/{thingName}/jobs/{jobId}/executionNumber/{executionNumber}",
                    thingName = thing_name,
                    jobId = job_id,
                    executionNumber = execution_number
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteJobExecutionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.force {
                    query.push_kv(
                        "force",
                        aws_smithy_types::primitive::Encoder::from(_input.force).encode(),
                    );
                }
                if let Some(inner_57) = &_input.namespace_id {
                    query.push_kv(
                        "namespaceId",
                        &aws_smithy_http::query::fmt_string(&inner_57),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteJobExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteJobExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteJobExecution",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteJobExecutionInput`](crate::input::DeleteJobExecutionInput)
    pub fn builder() -> crate::input::delete_job_execution_input::Builder {
        crate::input::delete_job_execution_input::Builder::default()
    }
}

/// See [`DeleteJobTemplateInput`](crate::input::DeleteJobTemplateInput)
pub mod delete_job_template_input {
    /// A builder for [`DeleteJobTemplateInput`](crate::input::DeleteJobTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the job template to delete.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job template to delete.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobTemplateInput`](crate::input::DeleteJobTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteJobTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteJobTemplateInput {
                job_template_id: self.job_template_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteJobTemplateInputOperationOutputAlias = crate::operation::DeleteJobTemplate;
#[doc(hidden)]
pub type DeleteJobTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteJobTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJobTemplate`](crate::operation::DeleteJobTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJobTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteJobTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.job_template_id;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_template_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_template_id = aws_smithy_http::label::fmt_string(input_58, false);
                if job_template_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_template_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/job-templates/{jobTemplateId}",
                    jobTemplateId = job_template_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteJobTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteJobTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteJobTemplate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteJobTemplateInput`](crate::input::DeleteJobTemplateInput)
    pub fn builder() -> crate::input::delete_job_template_input::Builder {
        crate::input::delete_job_template_input::Builder::default()
    }
}

/// See [`DeleteMitigationActionInput`](crate::input::DeleteMitigationActionInput)
pub mod delete_mitigation_action_input {
    /// A builder for [`DeleteMitigationActionInput`](crate::input::DeleteMitigationActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the mitigation action that you want to delete.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the mitigation action that you want to delete.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMitigationActionInput`](crate::input::DeleteMitigationActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMitigationActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMitigationActionInput {
                action_name: self.action_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMitigationActionInputOperationOutputAlias = crate::operation::DeleteMitigationAction;
#[doc(hidden)]
pub type DeleteMitigationActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMitigationActionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMitigationAction`](crate::operation::DeleteMitigationAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMitigationAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMitigationActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_59 = &_input.action_name;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let action_name = aws_smithy_http::label::fmt_string(input_59, false);
                if action_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/mitigationactions/actions/{actionName}",
                    actionName = action_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMitigationActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMitigationAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMitigationAction",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMitigationActionInput`](crate::input::DeleteMitigationActionInput)
    pub fn builder() -> crate::input::delete_mitigation_action_input::Builder {
        crate::input::delete_mitigation_action_input::Builder::default()
    }
}

/// See [`DeleteOtaUpdateInput`](crate::input::DeleteOtaUpdateInput)
pub mod delete_ota_update_input {
    /// A builder for [`DeleteOtaUpdateInput`](crate::input::DeleteOtaUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_update_id: std::option::Option<std::string::String>,
        pub(crate) delete_stream: std::option::Option<bool>,
        pub(crate) force_delete_aws_job: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the OTA update to delete.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_id = Some(input.into());
            self
        }
        /// <p>The ID of the OTA update to delete.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_id = input;
            self
        }
        /// <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
        pub fn delete_stream(mut self, input: bool) -> Self {
            self.delete_stream = Some(input);
            self
        }
        /// <p>When true, the stream created by the OTAUpdate process is deleted when the OTA update is deleted. Ignored if the stream specified in the OTAUpdate is supplied by the user.</p>
        pub fn set_delete_stream(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_stream = input;
            self
        }
        /// <p>When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
        pub fn force_delete_aws_job(mut self, input: bool) -> Self {
            self.force_delete_aws_job = Some(input);
            self
        }
        /// <p>When true, deletes the IoT job created by the OTAUpdate process even if it is "IN_PROGRESS". Otherwise, if the job is not in a terminal state ("COMPLETED" or "CANCELED") an exception will occur. The default is false.</p>
        pub fn set_force_delete_aws_job(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete_aws_job = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOtaUpdateInput`](crate::input::DeleteOtaUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOtaUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOtaUpdateInput {
                ota_update_id: self.ota_update_id,
                delete_stream: self.delete_stream.unwrap_or_default(),
                force_delete_aws_job: self.force_delete_aws_job.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOtaUpdateInputOperationOutputAlias = crate::operation::DeleteOTAUpdate;
#[doc(hidden)]
pub type DeleteOtaUpdateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOtaUpdateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOTAUpdate`](crate::operation::DeleteOTAUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOTAUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOtaUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_60 = &_input.ota_update_id;
                let input_60 = input_60.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "ota_update_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let ota_update_id = aws_smithy_http::label::fmt_string(input_60, false);
                if ota_update_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ota_update_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/otaUpdates/{otaUpdateId}",
                    otaUpdateId = ota_update_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteOtaUpdateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.delete_stream {
                    query.push_kv(
                        "deleteStream",
                        aws_smithy_types::primitive::Encoder::from(_input.delete_stream).encode(),
                    );
                }
                if _input.force_delete_aws_job {
                    query.push_kv(
                        "forceDeleteAWSJob",
                        aws_smithy_types::primitive::Encoder::from(_input.force_delete_aws_job)
                            .encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOtaUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOTAUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOTAUpdate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOtaUpdateInput`](crate::input::DeleteOtaUpdateInput)
    pub fn builder() -> crate::input::delete_ota_update_input::Builder {
        crate::input::delete_ota_update_input::Builder::default()
    }
}

/// See [`DeletePolicyInput`](crate::input::DeletePolicyInput)
pub mod delete_policy_input {
    /// A builder for [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy to delete.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy to delete.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePolicyInput`](crate::input::DeletePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePolicyInput {
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePolicyInputOperationOutputAlias = crate::operation::DeletePolicy;
#[doc(hidden)]
pub type DeletePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeletePolicy`](crate::operation::DeletePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_61 = &_input.policy_name;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_61, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/policies/{policyName}", policyName = policy_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePolicy",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
}

/// See [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
pub mod delete_policy_version_input {
    /// A builder for [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_version_id = Some(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePolicyVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePolicyVersionInput {
                policy_name: self.policy_name,
                policy_version_id: self.policy_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePolicyVersionInputOperationOutputAlias = crate::operation::DeletePolicyVersion;
#[doc(hidden)]
pub type DeletePolicyVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePolicyVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeletePolicyVersion`](crate::operation::DeletePolicyVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePolicyVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePolicyVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_62 = &_input.policy_name;
                let input_62 = input_62.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_62, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_63 = &_input.policy_version_id;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_version_id = aws_smithy_http::label::fmt_string(input_63, false);
                if policy_version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/policies/{policyName}/version/{policyVersionId}",
                    policyName = policy_name,
                    policyVersionId = policy_version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePolicyVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePolicyVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePolicyVersion",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
    pub fn builder() -> crate::input::delete_policy_version_input::Builder {
        crate::input::delete_policy_version_input::Builder::default()
    }
}

/// See [`DeleteProvisioningTemplateInput`](crate::input::DeleteProvisioningTemplateInput)
pub mod delete_provisioning_template_input {
    /// A builder for [`DeleteProvisioningTemplateInput`](crate::input::DeleteProvisioningTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet provision template to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provision template to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProvisioningTemplateInput`](crate::input::DeleteProvisioningTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProvisioningTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProvisioningTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProvisioningTemplateInputOperationOutputAlias =
    crate::operation::DeleteProvisioningTemplate;
#[doc(hidden)]
pub type DeleteProvisioningTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProvisioningTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProvisioningTemplate`](crate::operation::DeleteProvisioningTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProvisioningTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProvisioningTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_64 = &_input.template_name;
                let input_64 = input_64.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_64, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/provisioning-templates/{templateName}",
                    templateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProvisioningTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProvisioningTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProvisioningTemplate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningTemplateInput`](crate::input::DeleteProvisioningTemplateInput)
    pub fn builder() -> crate::input::delete_provisioning_template_input::Builder {
        crate::input::delete_provisioning_template_input::Builder::default()
    }
}

/// See [`DeleteProvisioningTemplateVersionInput`](crate::input::DeleteProvisioningTemplateVersionInput)
pub mod delete_provisioning_template_version_input {
    /// A builder for [`DeleteProvisioningTemplateVersionInput`](crate::input::DeleteProvisioningTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the fleet provisioning template version to delete.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template version to delete.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The fleet provisioning template version ID to delete.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.version_id = Some(input);
            self
        }
        /// <p>The fleet provisioning template version ID to delete.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProvisioningTemplateVersionInput`](crate::input::DeleteProvisioningTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProvisioningTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProvisioningTemplateVersionInput {
                template_name: self.template_name,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProvisioningTemplateVersionInputOperationOutputAlias =
    crate::operation::DeleteProvisioningTemplateVersion;
#[doc(hidden)]
pub type DeleteProvisioningTemplateVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProvisioningTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProvisioningTemplateVersion`](crate::operation::DeleteProvisioningTemplateVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProvisioningTemplateVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProvisioningTemplateVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_65 = &_input.template_name;
                let input_65 = input_65.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_65, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_66 = &_input.version_id;
                let input_66 = input_66.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mut version_id_encoder = aws_smithy_types::primitive::Encoder::from(*input_66);
                let version_id = version_id_encoder.encode();
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/provisioning-templates/{templateName}/versions/{versionId}",
                    templateName = template_name,
                    versionId = version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProvisioningTemplateVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProvisioningTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProvisioningTemplateVersion",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningTemplateVersionInput`](crate::input::DeleteProvisioningTemplateVersionInput)
    pub fn builder() -> crate::input::delete_provisioning_template_version_input::Builder {
        crate::input::delete_provisioning_template_version_input::Builder::default()
    }
}

/// See [`DeleteRegistrationCodeInput`](crate::input::DeleteRegistrationCodeInput)
pub mod delete_registration_code_input {
    /// A builder for [`DeleteRegistrationCodeInput`](crate::input::DeleteRegistrationCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRegistrationCodeInput`](crate::input::DeleteRegistrationCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRegistrationCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRegistrationCodeInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteRegistrationCodeInputOperationOutputAlias = crate::operation::DeleteRegistrationCode;
#[doc(hidden)]
pub type DeleteRegistrationCodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRegistrationCodeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRegistrationCode`](crate::operation::DeleteRegistrationCode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRegistrationCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRegistrationCodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/registrationcode").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRegistrationCodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRegistrationCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRegistrationCode",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRegistrationCodeInput`](crate::input::DeleteRegistrationCodeInput)
    pub fn builder() -> crate::input::delete_registration_code_input::Builder {
        crate::input::delete_registration_code_input::Builder::default()
    }
}

/// See [`DeleteRoleAliasInput`](crate::input::DeleteRoleAliasInput)
pub mod delete_role_alias_input {
    /// A builder for [`DeleteRoleAliasInput`](crate::input::DeleteRoleAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The role alias to delete.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias = Some(input.into());
            self
        }
        /// <p>The role alias to delete.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoleAliasInput`](crate::input::DeleteRoleAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoleAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoleAliasInput {
                role_alias: self.role_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoleAliasInputOperationOutputAlias = crate::operation::DeleteRoleAlias;
#[doc(hidden)]
pub type DeleteRoleAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRoleAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoleAlias`](crate::operation::DeleteRoleAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoleAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRoleAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_67 = &_input.role_alias;
                let input_67 = input_67.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "role_alias",
                        details: "cannot be empty or unset",
                    },
                )?;
                let role_alias = aws_smithy_http::label::fmt_string(input_67, false);
                if role_alias.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "role_alias",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/role-aliases/{roleAlias}", roleAlias = role_alias)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRoleAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoleAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoleAlias",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoleAliasInput`](crate::input::DeleteRoleAliasInput)
    pub fn builder() -> crate::input::delete_role_alias_input::Builder {
        crate::input::delete_role_alias_input::Builder::default()
    }
}

/// See [`DeleteScheduledAuditInput`](crate::input::DeleteScheduledAuditInput)
pub mod delete_scheduled_audit_input {
    /// A builder for [`DeleteScheduledAuditInput`](crate::input::DeleteScheduledAuditInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_audit_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scheduled audit you want to delete.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled audit you want to delete.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScheduledAuditInput`](crate::input::DeleteScheduledAuditInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScheduledAuditInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScheduledAuditInput {
                scheduled_audit_name: self.scheduled_audit_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteScheduledAuditInputOperationOutputAlias = crate::operation::DeleteScheduledAudit;
#[doc(hidden)]
pub type DeleteScheduledAuditInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteScheduledAuditInput {
    /// Consumes the builder and constructs an Operation<[`DeleteScheduledAudit`](crate::operation::DeleteScheduledAudit)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteScheduledAudit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteScheduledAuditInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_68 = &_input.scheduled_audit_name;
                let input_68 = input_68.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "scheduled_audit_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let scheduled_audit_name = aws_smithy_http::label::fmt_string(input_68, false);
                if scheduled_audit_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "scheduled_audit_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/audit/scheduledaudits/{scheduledAuditName}",
                    scheduledAuditName = scheduled_audit_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteScheduledAuditInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteScheduledAudit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteScheduledAudit",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteScheduledAuditInput`](crate::input::DeleteScheduledAuditInput)
    pub fn builder() -> crate::input::delete_scheduled_audit_input::Builder {
        crate::input::delete_scheduled_audit_input::Builder::default()
    }
}

/// See [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
pub mod delete_security_profile_input {
    /// A builder for [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) expected_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the security profile to be deleted.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the security profile to be deleted.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSecurityProfileInput {
                security_profile_name: self.security_profile_name,
                expected_version: self.expected_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSecurityProfileInputOperationOutputAlias = crate::operation::DeleteSecurityProfile;
#[doc(hidden)]
pub type DeleteSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSecurityProfile`](crate::operation::DeleteSecurityProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSecurityProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_69 = &_input.security_profile_name;
                let input_69 = input_69.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let security_profile_name = aws_smithy_http::label::fmt_string(input_69, false);
                if security_profile_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/security-profiles/{securityProfileName}",
                    securityProfileName = security_profile_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteSecurityProfileInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_70) = &_input.expected_version {
                    query.push_kv(
                        "expectedVersion",
                        aws_smithy_types::primitive::Encoder::from(*inner_70).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSecurityProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSecurityProfile",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
    pub fn builder() -> crate::input::delete_security_profile_input::Builder {
        crate::input::delete_security_profile_input::Builder::default()
    }
}

/// See [`DeleteStreamInput`](crate::input::DeleteStreamInput)
pub mod delete_stream_input {
    /// A builder for [`DeleteStreamInput`](crate::input::DeleteStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStreamInput`](crate::input::DeleteStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStreamInput {
                stream_id: self.stream_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStreamInputOperationOutputAlias = crate::operation::DeleteStream;
#[doc(hidden)]
pub type DeleteStreamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStreamInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStream`](crate::operation::DeleteStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_71 = &_input.stream_id;
                let input_71 = input_71.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stream_id = aws_smithy_http::label::fmt_string(input_71, false);
                if stream_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/streams/{streamId}", streamId = stream_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStream",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStreamInput`](crate::input::DeleteStreamInput)
    pub fn builder() -> crate::input::delete_stream_input::Builder {
        crate::input::delete_stream_input::Builder::default()
    }
}

/// See [`DeleteThingInput`](crate::input::DeleteThingInput)
pub mod delete_thing_input {
    /// A builder for [`DeleteThingInput`](crate::input::DeleteThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) expected_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the thing to delete.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing to delete.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThingInput`](crate::input::DeleteThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThingInput {
                thing_name: self.thing_name,
                expected_version: self.expected_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThingInputOperationOutputAlias = crate::operation::DeleteThing;
#[doc(hidden)]
pub type DeleteThingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteThing`](crate::operation::DeleteThing)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteThing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteThingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_72 = &_input.thing_name;
                let input_72 = input_72.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_72, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/things/{thingName}", thingName = thing_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteThingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_73) = &_input.expected_version {
                    query.push_kv(
                        "expectedVersion",
                        aws_smithy_types::primitive::Encoder::from(*inner_73).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteThingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteThing",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteThingInput`](crate::input::DeleteThingInput)
    pub fn builder() -> crate::input::delete_thing_input::Builder {
        crate::input::delete_thing_input::Builder::default()
    }
}

/// See [`DeleteThingGroupInput`](crate::input::DeleteThingGroupInput)
pub mod delete_thing_group_input {
    /// A builder for [`DeleteThingGroupInput`](crate::input::DeleteThingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) expected_version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the thing group to delete.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the thing group to delete.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The expected version of the thing group to delete.</p>
        pub fn expected_version(mut self, input: i64) -> Self {
            self.expected_version = Some(input);
            self
        }
        /// <p>The expected version of the thing group to delete.</p>
        pub fn set_expected_version(mut self, input: std::option::Option<i64>) -> Self {
            self.expected_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThingGroupInput`](crate::input::DeleteThingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThingGroupInput {
                thing_group_name: self.thing_group_name,
                expected_version: self.expected_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThingGroupInputOperationOutputAlias = crate::operation::DeleteThingGroup;
#[doc(hidden)]
pub type DeleteThingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteThingGroup`](crate::operation::DeleteThingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteThingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteThingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_74 = &_input.thing_group_name;
                let input_74 = input_74.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_group_name = aws_smithy_http::label::fmt_string(input_74, false);
                if thing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-groups/{thingGroupName}",
                    thingGroupName = thing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteThingGroupInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_75) = &_input.expected_version {
                    query.push_kv(
                        "expectedVersion",
                        aws_smithy_types::primitive::Encoder::from(*inner_75).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteThingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteThingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteThingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteThingGroupInput`](crate::input::DeleteThingGroupInput)
    pub fn builder() -> crate::input::delete_thing_group_input::Builder {
        crate::input::delete_thing_group_input::Builder::default()
    }
}

/// See [`DeleteThingTypeInput`](crate::input::DeleteThingTypeInput)
pub mod delete_thing_type_input {
    /// A builder for [`DeleteThingTypeInput`](crate::input::DeleteThingTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThingTypeInput`](crate::input::DeleteThingTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThingTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThingTypeInput {
                thing_type_name: self.thing_type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThingTypeInputOperationOutputAlias = crate::operation::DeleteThingType;
#[doc(hidden)]
pub type DeleteThingTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThingTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteThingType`](crate::operation::DeleteThingType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteThingType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteThingTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_76 = &_input.thing_type_name;
                let input_76 = input_76.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_type_name = aws_smithy_http::label::fmt_string(input_76, false);
                if thing_type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-types/{thingTypeName}",
                    thingTypeName = thing_type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteThingTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteThingType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteThingType",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteThingTypeInput`](crate::input::DeleteThingTypeInput)
    pub fn builder() -> crate::input::delete_thing_type_input::Builder {
        crate::input::delete_thing_type_input::Builder::default()
    }
}

/// See [`DeleteTopicRuleInput`](crate::input::DeleteTopicRuleInput)
pub mod delete_topic_rule_input {
    /// A builder for [`DeleteTopicRuleInput`](crate::input::DeleteTopicRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTopicRuleInput`](crate::input::DeleteTopicRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTopicRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTopicRuleInput {
                rule_name: self.rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTopicRuleInputOperationOutputAlias = crate::operation::DeleteTopicRule;
#[doc(hidden)]
pub type DeleteTopicRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTopicRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTopicRule`](crate::operation::DeleteTopicRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTopicRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTopicRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_77 = &_input.rule_name;
                let input_77 = input_77.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let rule_name = aws_smithy_http::label::fmt_string(input_77, false);
                if rule_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/rules/{ruleName}", ruleName = rule_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTopicRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTopicRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTopicRule",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTopicRuleInput`](crate::input::DeleteTopicRuleInput)
    pub fn builder() -> crate::input::delete_topic_rule_input::Builder {
        crate::input::delete_topic_rule_input::Builder::default()
    }
}

/// See [`DeleteTopicRuleDestinationInput`](crate::input::DeleteTopicRuleDestinationInput)
pub mod delete_topic_rule_destination_input {
    /// A builder for [`DeleteTopicRuleDestinationInput`](crate::input::DeleteTopicRuleDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic rule destination to delete.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic rule destination to delete.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTopicRuleDestinationInput`](crate::input::DeleteTopicRuleDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTopicRuleDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTopicRuleDestinationInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteTopicRuleDestinationInputOperationOutputAlias =
    crate::operation::DeleteTopicRuleDestination;
#[doc(hidden)]
pub type DeleteTopicRuleDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTopicRuleDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTopicRuleDestination`](crate::operation::DeleteTopicRuleDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTopicRuleDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTopicRuleDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_78 = &_input.arn;
                let input_78 = input_78.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let arn = aws_smithy_http::label::fmt_string(input_78, true);
                if arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/destinations/{arn}", arn = arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTopicRuleDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTopicRuleDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTopicRuleDestination",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTopicRuleDestinationInput`](crate::input::DeleteTopicRuleDestinationInput)
    pub fn builder() -> crate::input::delete_topic_rule_destination_input::Builder {
        crate::input::delete_topic_rule_destination_input::Builder::default()
    }
}

/// See [`DeleteV2LoggingLevelInput`](crate::input::DeleteV2LoggingLevelInput)
pub mod delete_v2_logging_level_input {
    /// A builder for [`DeleteV2LoggingLevelInput`](crate::input::DeleteV2LoggingLevelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_type: std::option::Option<crate::model::LogTargetType>,
        pub(crate) target_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn target_type(mut self, input: crate::model::LogTargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::LogTargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The name of the resource for which you are configuring logging.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_name = Some(input.into());
            self
        }
        /// <p>The name of the resource for which you are configuring logging.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteV2LoggingLevelInput`](crate::input::DeleteV2LoggingLevelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteV2LoggingLevelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteV2LoggingLevelInput {
                target_type: self.target_type,
                target_name: self.target_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteV2LoggingLevelInputOperationOutputAlias = crate::operation::DeleteV2LoggingLevel;
#[doc(hidden)]
pub type DeleteV2LoggingLevelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteV2LoggingLevelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteV2LoggingLevel`](crate::operation::DeleteV2LoggingLevel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteV2LoggingLevel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteV2LoggingLevelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v2LoggingLevel").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteV2LoggingLevelInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_79) = &_input.target_type {
                    query.push_kv("targetType", &aws_smithy_http::query::fmt_string(&inner_79));
                }
                if let Some(inner_80) = &_input.target_name {
                    query.push_kv("targetName", &aws_smithy_http::query::fmt_string(&inner_80));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteV2LoggingLevelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteV2LoggingLevel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteV2LoggingLevel",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteV2LoggingLevelInput`](crate::input::DeleteV2LoggingLevelInput)
    pub fn builder() -> crate::input::delete_v2_logging_level_input::Builder {
        crate::input::delete_v2_logging_level_input::Builder::default()
    }
}

/// See [`DeprecateThingTypeInput`](crate::input::DeprecateThingTypeInput)
pub mod deprecate_thing_type_input {
    /// A builder for [`DeprecateThingTypeInput`](crate::input::DeprecateThingTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) undo_deprecate: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the thing type to deprecate.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type to deprecate.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
        pub fn undo_deprecate(mut self, input: bool) -> Self {
            self.undo_deprecate = Some(input);
            self
        }
        /// <p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>
        pub fn set_undo_deprecate(mut self, input: std::option::Option<bool>) -> Self {
            self.undo_deprecate = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprecateThingTypeInput`](crate::input::DeprecateThingTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeprecateThingTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeprecateThingTypeInput {
                thing_type_name: self.thing_type_name,
                undo_deprecate: self.undo_deprecate.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeprecateThingTypeInputOperationOutputAlias = crate::operation::DeprecateThingType;
#[doc(hidden)]
pub type DeprecateThingTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeprecateThingTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeprecateThingType`](crate::operation::DeprecateThingType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeprecateThingType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeprecateThingTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_81 = &_input.thing_type_name;
                let input_81 = input_81.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_type_name = aws_smithy_http::label::fmt_string(input_81, false);
                if thing_type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-types/{thingTypeName}/deprecate",
                    thingTypeName = thing_type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeprecateThingTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deprecate_thing_type(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeprecateThingType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeprecateThingType",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeprecateThingTypeInput`](crate::input::DeprecateThingTypeInput)
    pub fn builder() -> crate::input::deprecate_thing_type_input::Builder {
        crate::input::deprecate_thing_type_input::Builder::default()
    }
}

/// See [`DescribeAccountAuditConfigurationInput`](crate::input::DescribeAccountAuditConfigurationInput)
pub mod describe_account_audit_configuration_input {
    /// A builder for [`DescribeAccountAuditConfigurationInput`](crate::input::DescribeAccountAuditConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAccountAuditConfigurationInput`](crate::input::DescribeAccountAuditConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAuditConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAuditConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAuditConfigurationInputOperationOutputAlias =
    crate::operation::DescribeAccountAuditConfiguration;
#[doc(hidden)]
pub type DescribeAccountAuditConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountAuditConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAuditConfiguration`](crate::operation::DescribeAccountAuditConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAuditConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountAuditConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/audit/configuration").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountAuditConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAuditConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAuditConfiguration",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAuditConfigurationInput`](crate::input::DescribeAccountAuditConfigurationInput)
    pub fn builder() -> crate::input::describe_account_audit_configuration_input::Builder {
        crate::input::describe_account_audit_configuration_input::Builder::default()
    }
}

/// See [`DescribeAuditFindingInput`](crate::input::DescribeAuditFindingInput)
pub mod describe_audit_finding_input {
    /// A builder for [`DescribeAuditFindingInput`](crate::input::DescribeAuditFindingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
        pub fn finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>
        pub fn set_finding_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.finding_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditFindingInput`](crate::input::DescribeAuditFindingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAuditFindingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAuditFindingInput {
                finding_id: self.finding_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAuditFindingInputOperationOutputAlias = crate::operation::DescribeAuditFinding;
#[doc(hidden)]
pub type DescribeAuditFindingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAuditFindingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAuditFinding`](crate::operation::DescribeAuditFinding)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAuditFinding,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAuditFindingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_82 = &_input.finding_id;
                let input_82 = input_82.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "finding_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let finding_id = aws_smithy_http::label::fmt_string(input_82, false);
                if finding_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "finding_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/audit/findings/{findingId}",
                    findingId = finding_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAuditFindingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAuditFinding::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAuditFinding",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAuditFindingInput`](crate::input::DescribeAuditFindingInput)
    pub fn builder() -> crate::input::describe_audit_finding_input::Builder {
        crate::input::describe_audit_finding_input::Builder::default()
    }
}

/// See [`DescribeAuditMitigationActionsTaskInput`](crate::input::DescribeAuditMitigationActionsTaskInput)
pub mod describe_audit_mitigation_actions_task_input {
    /// A builder for [`DescribeAuditMitigationActionsTaskInput`](crate::input::DescribeAuditMitigationActionsTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the audit mitigation task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the audit mitigation task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditMitigationActionsTaskInput`](crate::input::DescribeAuditMitigationActionsTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAuditMitigationActionsTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAuditMitigationActionsTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAuditMitigationActionsTaskInputOperationOutputAlias =
    crate::operation::DescribeAuditMitigationActionsTask;
#[doc(hidden)]
pub type DescribeAuditMitigationActionsTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAuditMitigationActionsTaskInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAuditMitigationActionsTask`](crate::operation::DescribeAuditMitigationActionsTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAuditMitigationActionsTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAuditMitigationActionsTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_83 = &_input.task_id;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let task_id = aws_smithy_http::label::fmt_string(input_83, false);
                if task_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/audit/mitigationactions/tasks/{taskId}",
                    taskId = task_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAuditMitigationActionsTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAuditMitigationActionsTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAuditMitigationActionsTask",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAuditMitigationActionsTaskInput`](crate::input::DescribeAuditMitigationActionsTaskInput)
    pub fn builder() -> crate::input::describe_audit_mitigation_actions_task_input::Builder {
        crate::input::describe_audit_mitigation_actions_task_input::Builder::default()
    }
}

/// See [`DescribeAuditSuppressionInput`](crate::input::DescribeAuditSuppressionInput)
pub mod describe_audit_suppression_input {
    /// A builder for [`DescribeAuditSuppressionInput`](crate::input::DescribeAuditSuppressionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
    }
    impl Builder {
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_name = Some(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_name = input;
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditSuppressionInput`](crate::input::DescribeAuditSuppressionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAuditSuppressionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAuditSuppressionInput {
                check_name: self.check_name,
                resource_identifier: self.resource_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAuditSuppressionInputOperationOutputAlias =
    crate::operation::DescribeAuditSuppression;
#[doc(hidden)]
pub type DescribeAuditSuppressionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAuditSuppressionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAuditSuppression`](crate::operation::DescribeAuditSuppression)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAuditSuppression,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAuditSuppressionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/audit/suppressions/describe").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAuditSuppressionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_audit_suppression(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAuditSuppression::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAuditSuppression",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAuditSuppressionInput`](crate::input::DescribeAuditSuppressionInput)
    pub fn builder() -> crate::input::describe_audit_suppression_input::Builder {
        crate::input::describe_audit_suppression_input::Builder::default()
    }
}

/// See [`DescribeAuditTaskInput`](crate::input::DescribeAuditTaskInput)
pub mod describe_audit_task_input {
    /// A builder for [`DescribeAuditTaskInput`](crate::input::DescribeAuditTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the audit whose information you want to get.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the audit whose information you want to get.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuditTaskInput`](crate::input::DescribeAuditTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAuditTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAuditTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAuditTaskInputOperationOutputAlias = crate::operation::DescribeAuditTask;
#[doc(hidden)]
pub type DescribeAuditTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAuditTaskInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAuditTask`](crate::operation::DescribeAuditTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAuditTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAuditTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_84 = &_input.task_id;
                let input_84 = input_84.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let task_id = aws_smithy_http::label::fmt_string(input_84, false);
                if task_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/audit/tasks/{taskId}", taskId = task_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAuditTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAuditTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAuditTask",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAuditTaskInput`](crate::input::DescribeAuditTaskInput)
    pub fn builder() -> crate::input::describe_audit_task_input::Builder {
        crate::input::describe_audit_task_input::Builder::default()
    }
}

/// See [`DescribeAuthorizerInput`](crate::input::DescribeAuthorizerInput)
pub mod describe_authorizer_input {
    /// A builder for [`DescribeAuthorizerInput`](crate::input::DescribeAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authorizer to describe.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_name = Some(input.into());
            self
        }
        /// <p>The name of the authorizer to describe.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuthorizerInput`](crate::input::DescribeAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAuthorizerInput {
                authorizer_name: self.authorizer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAuthorizerInputOperationOutputAlias = crate::operation::DescribeAuthorizer;
#[doc(hidden)]
pub type DescribeAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAuthorizer`](crate::operation::DescribeAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_85 = &_input.authorizer_name;
                let input_85 = input_85.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let authorizer_name = aws_smithy_http::label::fmt_string(input_85, false);
                if authorizer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "authorizer_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/authorizer/{authorizerName}",
                    authorizerName = authorizer_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAuthorizer",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAuthorizerInput`](crate::input::DescribeAuthorizerInput)
    pub fn builder() -> crate::input::describe_authorizer_input::Builder {
        crate::input::describe_authorizer_input::Builder::default()
    }
}

/// See [`DescribeBillingGroupInput`](crate::input::DescribeBillingGroupInput)
pub mod describe_billing_group_input {
    /// A builder for [`DescribeBillingGroupInput`](crate::input::DescribeBillingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the billing group.</p>
        pub fn billing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the billing group.</p>
        pub fn set_billing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBillingGroupInput`](crate::input::DescribeBillingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBillingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBillingGroupInput {
                billing_group_name: self.billing_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBillingGroupInputOperationOutputAlias = crate::operation::DescribeBillingGroup;
#[doc(hidden)]
pub type DescribeBillingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBillingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBillingGroup`](crate::operation::DescribeBillingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBillingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeBillingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_86 = &_input.billing_group_name;
                let input_86 = input_86.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "billing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let billing_group_name = aws_smithy_http::label::fmt_string(input_86, false);
                if billing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "billing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/billing-groups/{billingGroupName}",
                    billingGroupName = billing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeBillingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBillingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBillingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeBillingGroupInput`](crate::input::DescribeBillingGroupInput)
    pub fn builder() -> crate::input::describe_billing_group_input::Builder {
        crate::input::describe_billing_group_input::Builder::default()
    }
}

/// See [`DescribeCaCertificateInput`](crate::input::DescribeCaCertificateInput)
pub mod describe_ca_certificate_input {
    /// A builder for [`DescribeCaCertificateInput`](crate::input::DescribeCaCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CA certificate identifier.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The CA certificate identifier.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCaCertificateInput`](crate::input::DescribeCaCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCaCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCaCertificateInput {
                certificate_id: self.certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCaCertificateInputOperationOutputAlias = crate::operation::DescribeCACertificate;
#[doc(hidden)]
pub type DescribeCaCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCaCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCACertificate`](crate::operation::DescribeCACertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCACertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeCaCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_87 = &_input.certificate_id;
                let input_87 = input_87.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let certificate_id = aws_smithy_http::label::fmt_string(input_87, false);
                if certificate_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/cacertificate/{certificateId}",
                    certificateId = certificate_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeCaCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCACertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCACertificate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeCaCertificateInput`](crate::input::DescribeCaCertificateInput)
    pub fn builder() -> crate::input::describe_ca_certificate_input::Builder {
        crate::input::describe_ca_certificate_input::Builder::default()
    }
}

/// See [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
pub mod describe_certificate_input {
    /// A builder for [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCertificateInput {
                certificate_id: self.certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCertificateInputOperationOutputAlias = crate::operation::DescribeCertificate;
#[doc(hidden)]
pub type DescribeCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCertificate`](crate::operation::DescribeCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_88 = &_input.certificate_id;
                let input_88 = input_88.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let certificate_id = aws_smithy_http::label::fmt_string(input_88, false);
                if certificate_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/certificates/{certificateId}",
                    certificateId = certificate_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCertificate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
    pub fn builder() -> crate::input::describe_certificate_input::Builder {
        crate::input::describe_certificate_input::Builder::default()
    }
}

/// See [`DescribeCustomMetricInput`](crate::input::DescribeCustomMetricInput)
pub mod describe_custom_metric_input {
    /// A builder for [`DescribeCustomMetricInput`](crate::input::DescribeCustomMetricInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the custom metric. </p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p> The name of the custom metric. </p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomMetricInput`](crate::input::DescribeCustomMetricInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCustomMetricInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCustomMetricInput {
                metric_name: self.metric_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCustomMetricInputOperationOutputAlias = crate::operation::DescribeCustomMetric;
#[doc(hidden)]
pub type DescribeCustomMetricInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCustomMetricInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCustomMetric`](crate::operation::DescribeCustomMetric)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCustomMetric,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeCustomMetricInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_89 = &_input.metric_name;
                let input_89 = input_89.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let metric_name = aws_smithy_http::label::fmt_string(input_89, false);
                if metric_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/custom-metric/{metricName}",
                    metricName = metric_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeCustomMetricInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCustomMetric::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCustomMetric",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeCustomMetricInput`](crate::input::DescribeCustomMetricInput)
    pub fn builder() -> crate::input::describe_custom_metric_input::Builder {
        crate::input::describe_custom_metric_input::Builder::default()
    }
}

/// See [`DescribeDefaultAuthorizerInput`](crate::input::DescribeDefaultAuthorizerInput)
pub mod describe_default_authorizer_input {
    /// A builder for [`DescribeDefaultAuthorizerInput`](crate::input::DescribeDefaultAuthorizerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeDefaultAuthorizerInput`](crate::input::DescribeDefaultAuthorizerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDefaultAuthorizerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDefaultAuthorizerInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeDefaultAuthorizerInputOperationOutputAlias =
    crate::operation::DescribeDefaultAuthorizer;
#[doc(hidden)]
pub type DescribeDefaultAuthorizerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDefaultAuthorizerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDefaultAuthorizer`](crate::operation::DescribeDefaultAuthorizer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDefaultAuthorizer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDefaultAuthorizerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/default-authorizer").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDefaultAuthorizerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDefaultAuthorizer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDefaultAuthorizer",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDefaultAuthorizerInput`](crate::input::DescribeDefaultAuthorizerInput)
    pub fn builder() -> crate::input::describe_default_authorizer_input::Builder {
        crate::input::describe_default_authorizer_input::Builder::default()
    }
}

/// See [`DescribeDetectMitigationActionsTaskInput`](crate::input::DescribeDetectMitigationActionsTaskInput)
pub mod describe_detect_mitigation_actions_task_input {
    /// A builder for [`DescribeDetectMitigationActionsTaskInput`](crate::input::DescribeDetectMitigationActionsTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier of the task. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the task. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDetectMitigationActionsTaskInput`](crate::input::DescribeDetectMitigationActionsTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDetectMitigationActionsTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDetectMitigationActionsTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDetectMitigationActionsTaskInputOperationOutputAlias =
    crate::operation::DescribeDetectMitigationActionsTask;
#[doc(hidden)]
pub type DescribeDetectMitigationActionsTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDetectMitigationActionsTaskInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDetectMitigationActionsTask`](crate::operation::DescribeDetectMitigationActionsTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDetectMitigationActionsTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDetectMitigationActionsTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_90 = &_input.task_id;
                let input_90 = input_90.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let task_id = aws_smithy_http::label::fmt_string(input_90, false);
                if task_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/detect/mitigationactions/tasks/{taskId}",
                    taskId = task_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDetectMitigationActionsTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDetectMitigationActionsTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDetectMitigationActionsTask",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDetectMitigationActionsTaskInput`](crate::input::DescribeDetectMitigationActionsTaskInput)
    pub fn builder() -> crate::input::describe_detect_mitigation_actions_task_input::Builder {
        crate::input::describe_detect_mitigation_actions_task_input::Builder::default()
    }
}

/// See [`DescribeDimensionInput`](crate::input::DescribeDimensionInput)
pub mod describe_dimension_input {
    /// A builder for [`DescribeDimensionInput`](crate::input::DescribeDimensionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique identifier for the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDimensionInput`](crate::input::DescribeDimensionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDimensionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDimensionInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DescribeDimensionInputOperationOutputAlias = crate::operation::DescribeDimension;
#[doc(hidden)]
pub type DescribeDimensionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDimensionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDimension`](crate::operation::DescribeDimension)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDimension,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDimensionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_91 = &_input.name;
                let input_91 = input_91.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_91, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/dimensions/{name}", name = name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDimensionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDimension::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDimension",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDimensionInput`](crate::input::DescribeDimensionInput)
    pub fn builder() -> crate::input::describe_dimension_input::Builder {
        crate::input::describe_dimension_input::Builder::default()
    }
}

/// See [`DescribeDomainConfigurationInput`](crate::input::DescribeDomainConfigurationInput)
pub mod describe_domain_configuration_input {
    /// A builder for [`DescribeDomainConfigurationInput`](crate::input::DescribeDomainConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configuration_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain configuration.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the domain configuration.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainConfigurationInput`](crate::input::DescribeDomainConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainConfigurationInput {
                domain_configuration_name: self.domain_configuration_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainConfigurationInputOperationOutputAlias =
    crate::operation::DescribeDomainConfiguration;
#[doc(hidden)]
pub type DescribeDomainConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDomainConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomainConfiguration`](crate::operation::DescribeDomainConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomainConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDomainConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_92 = &_input.domain_configuration_name;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_configuration_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_configuration_name = aws_smithy_http::label::fmt_string(input_92, false);
                if domain_configuration_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_configuration_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainConfigurations/{domainConfigurationName}",
                    domainConfigurationName = domain_configuration_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDomainConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomainConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomainConfiguration",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainConfigurationInput`](crate::input::DescribeDomainConfigurationInput)
    pub fn builder() -> crate::input::describe_domain_configuration_input::Builder {
        crate::input::describe_domain_configuration_input::Builder::default()
    }
}

/// See [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
pub mod describe_endpoint_input {
    /// A builder for [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint type. Valid endpoint types include:</p>
        /// <ul>
        /// <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:CredentialProvider</code> - Returns an IoT credentials provider API endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Jobs</code> - Returns an IoT device management Jobs API endpoint.</p> </li>
        /// </ul>
        /// <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The endpoint type. Valid endpoint types include:</p>
        /// <ul>
        /// <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:CredentialProvider</code> - Returns an IoT credentials provider API endpoint.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p> <code>iot:Jobs</code> - Returns an IoT device management Jobs API endpoint.</p> </li>
        /// </ul>
        /// <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointInput {
                endpoint_type: self.endpoint_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointInputOperationOutputAlias = crate::operation::DescribeEndpoint;
#[doc(hidden)]
pub type DescribeEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpoint`](crate::operation::DescribeEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/endpoint").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeEndpointInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_93) = &_input.endpoint_type {
                    query.push_kv(
                        "endpointType",
                        &aws_smithy_http::query::fmt_string(&inner_93),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpoint",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    pub fn builder() -> crate::input::describe_endpoint_input::Builder {
        crate::input::describe_endpoint_input::Builder::default()
    }
}

/// See [`DescribeEventConfigurationsInput`](crate::input::DescribeEventConfigurationsInput)
pub mod describe_event_configurations_input {
    /// A builder for [`DescribeEventConfigurationsInput`](crate::input::DescribeEventConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeEventConfigurationsInput`](crate::input::DescribeEventConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventConfigurationsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeEventConfigurationsInputOperationOutputAlias =
    crate::operation::DescribeEventConfigurations;
#[doc(hidden)]
pub type DescribeEventConfigurationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEventConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventConfigurations`](crate::operation::DescribeEventConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEventConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/event-configurations").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEventConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventConfigurations",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventConfigurationsInput`](crate::input::DescribeEventConfigurationsInput)
    pub fn builder() -> crate::input::describe_event_configurations_input::Builder {
        crate::input::describe_event_configurations_input::Builder::default()
    }
}

/// See [`DescribeFleetMetricInput`](crate::input::DescribeFleetMetricInput)
pub mod describe_fleet_metric_input {
    /// A builder for [`DescribeFleetMetricInput`](crate::input::DescribeFleetMetricInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet metric to describe.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet metric to describe.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetMetricInput`](crate::input::DescribeFleetMetricInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetMetricInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetMetricInput {
                metric_name: self.metric_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetMetricInputOperationOutputAlias = crate::operation::DescribeFleetMetric;
#[doc(hidden)]
pub type DescribeFleetMetricInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetMetricInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleetMetric`](crate::operation::DescribeFleetMetric)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleetMetric,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeFleetMetricInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_94 = &_input.metric_name;
                let input_94 = input_94.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let metric_name = aws_smithy_http::label::fmt_string(input_94, false);
                if metric_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "metric_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/fleet-metric/{metricName}",
                    metricName = metric_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeFleetMetricInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleetMetric::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleetMetric",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetMetricInput`](crate::input::DescribeFleetMetricInput)
    pub fn builder() -> crate::input::describe_fleet_metric_input::Builder {
        crate::input::describe_fleet_metric_input::Builder::default()
    }
}

/// See [`DescribeIndexInput`](crate::input::DescribeIndexInput)
pub mod describe_index_input {
    /// A builder for [`DescribeIndexInput`](crate::input::DescribeIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The index name.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The index name.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIndexInput`](crate::input::DescribeIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIndexInput {
                index_name: self.index_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIndexInputOperationOutputAlias = crate::operation::DescribeIndex;
#[doc(hidden)]
pub type DescribeIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeIndexInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIndex`](crate::operation::DescribeIndex)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeIndexInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.index_name;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let index_name = aws_smithy_http::label::fmt_string(input_95, false);
                if index_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/indices/{indexName}", indexName = index_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeIndexInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIndex",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeIndexInput`](crate::input::DescribeIndexInput)
    pub fn builder() -> crate::input::describe_index_input::Builder {
        crate::input::describe_index_input::Builder::default()
    }
}

/// See [`DescribeJobInput`](crate::input::DescribeJobInput)
pub mod describe_job_input {
    /// A builder for [`DescribeJobInput`](crate::input::DescribeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobInput`](crate::input::DescribeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobInputOperationOutputAlias = crate::operation::DescribeJob;
#[doc(hidden)]
pub type DescribeJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJob`](crate::operation::DescribeJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_96 = &_input.job_id;
                let input_96 = input_96.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_96, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/jobs/{jobId}", jobId = job_id).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJob",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
}

/// See [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
pub mod describe_job_execution_input {
    /// A builder for [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) execution_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name of the thing on which the job execution is running.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing on which the job execution is running.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.execution_number = Some(input);
            self
        }
        /// <p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.execution_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobExecutionInput {
                job_id: self.job_id,
                thing_name: self.thing_name,
                execution_number: self.execution_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobExecutionInputOperationOutputAlias = crate::operation::DescribeJobExecution;
#[doc(hidden)]
pub type DescribeJobExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobExecution`](crate::operation::DescribeJobExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeJobExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_97 = &_input.thing_name;
                let input_97 = input_97.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_97, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_98 = &_input.job_id;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_98, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/things/{thingName}/jobs/{jobId}",
                    thingName = thing_name,
                    jobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeJobExecutionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_99) = &_input.execution_number {
                    query.push_kv(
                        "executionNumber",
                        aws_smithy_types::primitive::Encoder::from(*inner_99).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeJobExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobExecution",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
    pub fn builder() -> crate::input::describe_job_execution_input::Builder {
        crate::input::describe_job_execution_input::Builder::default()
    }
}

/// See [`DescribeJobTemplateInput`](crate::input::DescribeJobTemplateInput)
pub mod describe_job_template_input {
    /// A builder for [`DescribeJobTemplateInput`](crate::input::DescribeJobTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the job template.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobTemplateInput`](crate::input::DescribeJobTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobTemplateInput {
                job_template_id: self.job_template_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobTemplateInputOperationOutputAlias = crate::operation::DescribeJobTemplate;
#[doc(hidden)]
pub type DescribeJobTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJobTemplate`](crate::operation::DescribeJobTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJobTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeJobTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_100 = &_input.job_template_id;
                let input_100 = input_100.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_template_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_template_id = aws_smithy_http::label::fmt_string(input_100, false);
                if job_template_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_template_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/job-templates/{jobTemplateId}",
                    jobTemplateId = job_template_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeJobTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJobTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJobTemplate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobTemplateInput`](crate::input::DescribeJobTemplateInput)
    pub fn builder() -> crate::input::describe_job_template_input::Builder {
        crate::input::describe_job_template_input::Builder::default()
    }
}

/// See [`DescribeManagedJobTemplateInput`](crate::input::DescribeManagedJobTemplateInput)
pub mod describe_managed_job_template_input {
    /// A builder for [`DescribeManagedJobTemplateInput`](crate::input::DescribeManagedJobTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) template_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of a managed job template, which is required.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The unique name of a managed job template, which is required.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>An optional parameter to specify version of a managed template. If not specified, the pre-defined default version is returned.</p>
        pub fn template_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_version = Some(input.into());
            self
        }
        /// <p>An optional parameter to specify version of a managed template. If not specified, the pre-defined default version is returned.</p>
        pub fn set_template_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeManagedJobTemplateInput`](crate::input::DescribeManagedJobTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeManagedJobTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeManagedJobTemplateInput {
                template_name: self.template_name,
                template_version: self.template_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeManagedJobTemplateInputOperationOutputAlias =
    crate::operation::DescribeManagedJobTemplate;
#[doc(hidden)]
pub type DescribeManagedJobTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeManagedJobTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeManagedJobTemplate`](crate::operation::DescribeManagedJobTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeManagedJobTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeManagedJobTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_101 = &_input.template_name;
                let input_101 = input_101.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_101, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/managed-job-templates/{templateName}",
                    templateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeManagedJobTemplateInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_102) = &_input.template_version {
                    query.push_kv(
                        "templateVersion",
                        &aws_smithy_http::query::fmt_string(&inner_102),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeManagedJobTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeManagedJobTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeManagedJobTemplate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeManagedJobTemplateInput`](crate::input::DescribeManagedJobTemplateInput)
    pub fn builder() -> crate::input::describe_managed_job_template_input::Builder {
        crate::input::describe_managed_job_template_input::Builder::default()
    }
}

/// See [`DescribeMitigationActionInput`](crate::input::DescribeMitigationActionInput)
pub mod describe_mitigation_action_input {
    /// A builder for [`DescribeMitigationActionInput`](crate::input::DescribeMitigationActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The friendly name that uniquely identifies the mitigation action.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMitigationActionInput`](crate::input::DescribeMitigationActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMitigationActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMitigationActionInput {
                action_name: self.action_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMitigationActionInputOperationOutputAlias =
    crate::operation::DescribeMitigationAction;
#[doc(hidden)]
pub type DescribeMitigationActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMitigationActionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMitigationAction`](crate::operation::DescribeMitigationAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMitigationAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeMitigationActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_103 = &_input.action_name;
                let input_103 = input_103.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let action_name = aws_smithy_http::label::fmt_string(input_103, false);
                if action_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "action_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/mitigationactions/actions/{actionName}",
                    actionName = action_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeMitigationActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMitigationAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMitigationAction",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeMitigationActionInput`](crate::input::DescribeMitigationActionInput)
    pub fn builder() -> crate::input::describe_mitigation_action_input::Builder {
        crate::input::describe_mitigation_action_input::Builder::default()
    }
}

/// See [`DescribeProvisioningTemplateInput`](crate::input::DescribeProvisioningTemplateInput)
pub mod describe_provisioning_template_input {
    /// A builder for [`DescribeProvisioningTemplateInput`](crate::input::DescribeProvisioningTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningTemplateInput`](crate::input::DescribeProvisioningTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProvisioningTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProvisioningTemplateInput {
                template_name: self.template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProvisioningTemplateInputOperationOutputAlias =
    crate::operation::DescribeProvisioningTemplate;
#[doc(hidden)]
pub type DescribeProvisioningTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProvisioningTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProvisioningTemplate`](crate::operation::DescribeProvisioningTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProvisioningTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeProvisioningTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_104 = &_input.template_name;
                let input_104 = input_104.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_104, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/provisioning-templates/{templateName}",
                    templateName = template_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeProvisioningTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProvisioningTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProvisioningTemplate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningTemplateInput`](crate::input::DescribeProvisioningTemplateInput)
    pub fn builder() -> crate::input::describe_provisioning_template_input::Builder {
        crate::input::describe_provisioning_template_input::Builder::default()
    }
}

/// See [`DescribeProvisioningTemplateVersionInput`](crate::input::DescribeProvisioningTemplateVersionInput)
pub mod describe_provisioning_template_version_input {
    /// A builder for [`DescribeProvisioningTemplateVersionInput`](crate::input::DescribeProvisioningTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The template name.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The template name.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The fleet provisioning template version ID.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.version_id = Some(input);
            self
        }
        /// <p>The fleet provisioning template version ID.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProvisioningTemplateVersionInput`](crate::input::DescribeProvisioningTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProvisioningTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProvisioningTemplateVersionInput {
                template_name: self.template_name,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProvisioningTemplateVersionInputOperationOutputAlias =
    crate::operation::DescribeProvisioningTemplateVersion;
#[doc(hidden)]
pub type DescribeProvisioningTemplateVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProvisioningTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProvisioningTemplateVersion`](crate::operation::DescribeProvisioningTemplateVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProvisioningTemplateVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeProvisioningTemplateVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_105 = &_input.template_name;
                let input_105 = input_105.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_name = aws_smithy_http::label::fmt_string(input_105, false);
                if template_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_106 = &_input.version_id;
                let input_106 = input_106.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mut version_id_encoder = aws_smithy_types::primitive::Encoder::from(*input_106);
                let version_id = version_id_encoder.encode();
                if version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/provisioning-templates/{templateName}/versions/{versionId}",
                    templateName = template_name,
                    versionId = version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeProvisioningTemplateVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProvisioningTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProvisioningTemplateVersion",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningTemplateVersionInput`](crate::input::DescribeProvisioningTemplateVersionInput)
    pub fn builder() -> crate::input::describe_provisioning_template_version_input::Builder {
        crate::input::describe_provisioning_template_version_input::Builder::default()
    }
}

/// See [`DescribeRoleAliasInput`](crate::input::DescribeRoleAliasInput)
pub mod describe_role_alias_input {
    /// A builder for [`DescribeRoleAliasInput`](crate::input::DescribeRoleAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The role alias to describe.</p>
        pub fn role_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias = Some(input.into());
            self
        }
        /// <p>The role alias to describe.</p>
        pub fn set_role_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRoleAliasInput`](crate::input::DescribeRoleAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRoleAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRoleAliasInput {
                role_alias: self.role_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRoleAliasInputOperationOutputAlias = crate::operation::DescribeRoleAlias;
#[doc(hidden)]
pub type DescribeRoleAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRoleAliasInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRoleAlias`](crate::operation::DescribeRoleAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRoleAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRoleAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_107 = &_input.role_alias;
                let input_107 = input_107.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "role_alias",
                        details: "cannot be empty or unset",
                    },
                )?;
                let role_alias = aws_smithy_http::label::fmt_string(input_107, false);
                if role_alias.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "role_alias",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/role-aliases/{roleAlias}", roleAlias = role_alias)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRoleAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRoleAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRoleAlias",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRoleAliasInput`](crate::input::DescribeRoleAliasInput)
    pub fn builder() -> crate::input::describe_role_alias_input::Builder {
        crate::input::describe_role_alias_input::Builder::default()
    }
}

/// See [`DescribeScheduledAuditInput`](crate::input::DescribeScheduledAuditInput)
pub mod describe_scheduled_audit_input {
    /// A builder for [`DescribeScheduledAuditInput`](crate::input::DescribeScheduledAuditInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_audit_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scheduled audit whose information you want to get.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled audit whose information you want to get.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduledAuditInput`](crate::input::DescribeScheduledAuditInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScheduledAuditInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScheduledAuditInput {
                scheduled_audit_name: self.scheduled_audit_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScheduledAuditInputOperationOutputAlias = crate::operation::DescribeScheduledAudit;
#[doc(hidden)]
pub type DescribeScheduledAuditInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeScheduledAuditInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScheduledAudit`](crate::operation::DescribeScheduledAudit)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScheduledAudit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeScheduledAuditInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_108 = &_input.scheduled_audit_name;
                let input_108 = input_108.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "scheduled_audit_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let scheduled_audit_name = aws_smithy_http::label::fmt_string(input_108, false);
                if scheduled_audit_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "scheduled_audit_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/audit/scheduledaudits/{scheduledAuditName}",
                    scheduledAuditName = scheduled_audit_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeScheduledAuditInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScheduledAudit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScheduledAudit",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeScheduledAuditInput`](crate::input::DescribeScheduledAuditInput)
    pub fn builder() -> crate::input::describe_scheduled_audit_input::Builder {
        crate::input::describe_scheduled_audit_input::Builder::default()
    }
}

/// See [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
pub mod describe_security_profile_input {
    /// A builder for [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the security profile whose information you want to get.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the security profile whose information you want to get.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSecurityProfileInput {
                security_profile_name: self.security_profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSecurityProfileInputOperationOutputAlias =
    crate::operation::DescribeSecurityProfile;
#[doc(hidden)]
pub type DescribeSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSecurityProfile`](crate::operation::DescribeSecurityProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSecurityProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_109 = &_input.security_profile_name;
                let input_109 = input_109.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let security_profile_name = aws_smithy_http::label::fmt_string(input_109, false);
                if security_profile_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/security-profiles/{securityProfileName}",
                    securityProfileName = security_profile_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSecurityProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSecurityProfile",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
    pub fn builder() -> crate::input::describe_security_profile_input::Builder {
        crate::input::describe_security_profile_input::Builder::default()
    }
}

/// See [`DescribeStreamInput`](crate::input::DescribeStreamInput)
pub mod describe_stream_input {
    /// A builder for [`DescribeStreamInput`](crate::input::DescribeStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStreamInput`](crate::input::DescribeStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStreamInput {
                stream_id: self.stream_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStreamInputOperationOutputAlias = crate::operation::DescribeStream;
#[doc(hidden)]
pub type DescribeStreamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeStreamInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStream`](crate::operation::DescribeStream)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStream,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeStreamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_110 = &_input.stream_id;
                let input_110 = input_110.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let stream_id = aws_smithy_http::label::fmt_string(input_110, false);
                if stream_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "stream_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/streams/{streamId}", streamId = stream_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeStreamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStream",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeStreamInput`](crate::input::DescribeStreamInput)
    pub fn builder() -> crate::input::describe_stream_input::Builder {
        crate::input::describe_stream_input::Builder::default()
    }
}

/// See [`DescribeThingInput`](crate::input::DescribeThingInput)
pub mod describe_thing_input {
    /// A builder for [`DescribeThingInput`](crate::input::DescribeThingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingInput`](crate::input::DescribeThingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThingInput {
                thing_name: self.thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThingInputOperationOutputAlias = crate::operation::DescribeThing;
#[doc(hidden)]
pub type DescribeThingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeThing`](crate::operation::DescribeThing)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeThing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeThingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_111 = &_input.thing_name;
                let input_111 = input_111.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_111, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/things/{thingName}", thingName = thing_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeThingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeThing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeThing",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeThingInput`](crate::input::DescribeThingInput)
    pub fn builder() -> crate::input::describe_thing_input::Builder {
        crate::input::describe_thing_input::Builder::default()
    }
}

/// See [`DescribeThingGroupInput`](crate::input::DescribeThingGroupInput)
pub mod describe_thing_group_input {
    /// A builder for [`DescribeThingGroupInput`](crate::input::DescribeThingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing group.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The name of the thing group.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingGroupInput`](crate::input::DescribeThingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThingGroupInput {
                thing_group_name: self.thing_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThingGroupInputOperationOutputAlias = crate::operation::DescribeThingGroup;
#[doc(hidden)]
pub type DescribeThingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeThingGroup`](crate::operation::DescribeThingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeThingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeThingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_112 = &_input.thing_group_name;
                let input_112 = input_112.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_group_name = aws_smithy_http::label::fmt_string(input_112, false);
                if thing_group_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_group_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-groups/{thingGroupName}",
                    thingGroupName = thing_group_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeThingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeThingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeThingGroup",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeThingGroupInput`](crate::input::DescribeThingGroupInput)
    pub fn builder() -> crate::input::describe_thing_group_input::Builder {
        crate::input::describe_thing_group_input::Builder::default()
    }
}

/// See [`DescribeThingRegistrationTaskInput`](crate::input::DescribeThingRegistrationTaskInput)
pub mod describe_thing_registration_task_input {
    /// A builder for [`DescribeThingRegistrationTaskInput`](crate::input::DescribeThingRegistrationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The task ID.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The task ID.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingRegistrationTaskInput`](crate::input::DescribeThingRegistrationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThingRegistrationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThingRegistrationTaskInput {
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThingRegistrationTaskInputOperationOutputAlias =
    crate::operation::DescribeThingRegistrationTask;
#[doc(hidden)]
pub type DescribeThingRegistrationTaskInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThingRegistrationTaskInput {
    /// Consumes the builder and constructs an Operation<[`DescribeThingRegistrationTask`](crate::operation::DescribeThingRegistrationTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeThingRegistrationTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeThingRegistrationTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_113 = &_input.task_id;
                let input_113 = input_113.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let task_id = aws_smithy_http::label::fmt_string(input_113, false);
                if task_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "task_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-registration-tasks/{taskId}",
                    taskId = task_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeThingRegistrationTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeThingRegistrationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeThingRegistrationTask",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeThingRegistrationTaskInput`](crate::input::DescribeThingRegistrationTaskInput)
    pub fn builder() -> crate::input::describe_thing_registration_task_input::Builder {
        crate::input::describe_thing_registration_task_input::Builder::default()
    }
}

/// See [`DescribeThingTypeInput`](crate::input::DescribeThingTypeInput)
pub mod describe_thing_type_input {
    /// A builder for [`DescribeThingTypeInput`](crate::input::DescribeThingTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeThingTypeInput`](crate::input::DescribeThingTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeThingTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeThingTypeInput {
                thing_type_name: self.thing_type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeThingTypeInputOperationOutputAlias = crate::operation::DescribeThingType;
#[doc(hidden)]
pub type DescribeThingTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeThingTypeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeThingType`](crate::operation::DescribeThingType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeThingType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeThingTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_114 = &_input.thing_type_name;
                let input_114 = input_114.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_type_name = aws_smithy_http::label::fmt_string(input_114, false);
                if thing_type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/thing-types/{thingTypeName}",
                    thingTypeName = thing_type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeThingTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeThingType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeThingType",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeThingTypeInput`](crate::input::DescribeThingTypeInput)
    pub fn builder() -> crate::input::describe_thing_type_input::Builder {
        crate::input::describe_thing_type_input::Builder::default()
    }
}

/// See [`DetachPolicyInput`](crate::input::DetachPolicyInput)
pub mod detach_policy_input {
    /// A builder for [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy to detach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy to detach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The target from which the policy will be detached.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target from which the policy will be detached.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachPolicyInput`](crate::input::DetachPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachPolicyInput {
                policy_name: self.policy_name,
                target: self.target,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachPolicyInputOperationOutputAlias = crate::operation::DetachPolicy;
#[doc(hidden)]
pub type DetachPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DetachPolicy`](crate::operation::DetachPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_115 = &_input.policy_name;
                let input_115 = input_115.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_115, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/target-policies/{policyName}",
                    policyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachPolicy",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    pub fn builder() -> crate::input::detach_policy_input::Builder {
        crate::input::detach_policy_input::Builder::default()
    }
}

/// See [`DetachPrincipalPolicyInput`](crate::input::DetachPrincipalPolicyInput)
pub mod detach_principal_policy_input {
    /// A builder for [`DetachPrincipalPolicyInput`](crate::input::DetachPrincipalPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy to detach.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy to detach.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The principal.</p>
        /// <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The principal.</p>
        /// <p>Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachPrincipalPolicyInput`](crate::input::DetachPrincipalPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachPrincipalPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachPrincipalPolicyInput {
                policy_name: self.policy_name,
                principal: self.principal,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachPrincipalPolicyInputOperationOutputAlias = crate::operation::DetachPrincipalPolicy;
#[doc(hidden)]
pub type DetachPrincipalPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachPrincipalPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DetachPrincipalPolicy`](crate::operation::DetachPrincipalPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachPrincipalPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachPrincipalPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_116 = &_input.policy_name;
                let input_116 = input_116.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_116, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/principal-policies/{policyName}",
                    policyName = policy_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachPrincipalPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_detach_principal_policy(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachPrincipalPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachPrincipalPolicy",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachPrincipalPolicyInput`](crate::input::DetachPrincipalPolicyInput)
    pub fn builder() -> crate::input::detach_principal_policy_input::Builder {
        crate::input::detach_principal_policy_input::Builder::default()
    }
}

/// See [`DetachSecurityProfileInput`](crate::input::DetachSecurityProfileInput)
pub mod detach_security_profile_input {
    /// A builder for [`DetachSecurityProfileInput`](crate::input::DetachSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The security profile that is detached.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The security profile that is detached.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The ARN of the thing group from which the security profile is detached.</p>
        pub fn security_profile_target_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.security_profile_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing group from which the security profile is detached.</p>
        pub fn set_security_profile_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachSecurityProfileInput`](crate::input::DetachSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachSecurityProfileInput {
                security_profile_name: self.security_profile_name,
                security_profile_target_arn: self.security_profile_target_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachSecurityProfileInputOperationOutputAlias = crate::operation::DetachSecurityProfile;
#[doc(hidden)]
pub type DetachSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`DetachSecurityProfile`](crate::operation::DetachSecurityProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachSecurityProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_117 = &_input.security_profile_name;
                let input_117 = input_117.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let security_profile_name = aws_smithy_http::label::fmt_string(input_117, false);
                if security_profile_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/security-profiles/{securityProfileName}/targets",
                    securityProfileName = security_profile_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DetachSecurityProfileInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_118) = &_input.security_profile_target_arn {
                    query.push_kv(
                        "securityProfileTargetArn",
                        &aws_smithy_http::query::fmt_string(&inner_118),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachSecurityProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachSecurityProfile",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachSecurityProfileInput`](crate::input::DetachSecurityProfileInput)
    pub fn builder() -> crate::input::detach_security_profile_input::Builder {
        crate::input::detach_security_profile_input::Builder::default()
    }
}

/// See [`DetachThingPrincipalInput`](crate::input::DetachThingPrincipalInput)
pub mod detach_thing_principal_input {
    /// A builder for [`DetachThingPrincipalInput`](crate::input::DetachThingPrincipalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachThingPrincipalInput`](crate::input::DetachThingPrincipalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachThingPrincipalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachThingPrincipalInput {
                thing_name: self.thing_name,
                principal: self.principal,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachThingPrincipalInputOperationOutputAlias = crate::operation::DetachThingPrincipal;
#[doc(hidden)]
pub type DetachThingPrincipalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachThingPrincipalInput {
    /// Consumes the builder and constructs an Operation<[`DetachThingPrincipal`](crate::operation::DetachThingPrincipal)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachThingPrincipal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachThingPrincipalInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_119 = &_input.thing_name;
                let input_119 = input_119.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let thing_name = aws_smithy_http::label::fmt_string(input_119, false);
                if thing_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/things/{thingName}/principals",
                    thingName = thing_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachThingPrincipalInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_detach_thing_principal(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachThingPrincipal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachThingPrincipal",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachThingPrincipalInput`](crate::input::DetachThingPrincipalInput)
    pub fn builder() -> crate::input::detach_thing_principal_input::Builder {
        crate::input::detach_thing_principal_input::Builder::default()
    }
}

/// See [`DisableTopicRuleInput`](crate::input::DisableTopicRuleInput)
pub mod disable_topic_rule_input {
    /// A builder for [`DisableTopicRuleInput`](crate::input::DisableTopicRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule to disable.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule to disable.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableTopicRuleInput`](crate::input::DisableTopicRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableTopicRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableTopicRuleInput {
                rule_name: self.rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableTopicRuleInputOperationOutputAlias = crate::operation::DisableTopicRule;
#[doc(hidden)]
pub type DisableTopicRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableTopicRuleInput {
    /// Consumes the builder and constructs an Operation<[`DisableTopicRule`](crate::operation::DisableTopicRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableTopicRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisableTopicRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_120 = &_input.rule_name;
                let input_120 = input_120.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let rule_name = aws_smithy_http::label::fmt_string(input_120, false);
                if rule_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/rules/{ruleName}/disable", ruleName = rule_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisableTopicRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableTopicRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableTopicRule",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisableTopicRuleInput`](crate::input::DisableTopicRuleInput)
    pub fn builder() -> crate::input::disable_topic_rule_input::Builder {
        crate::input::disable_topic_rule_input::Builder::default()
    }
}

/// See [`EnableTopicRuleInput`](crate::input::EnableTopicRuleInput)
pub mod enable_topic_rule_input {
    /// A builder for [`EnableTopicRuleInput`](crate::input::EnableTopicRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the topic rule to enable.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the topic rule to enable.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableTopicRuleInput`](crate::input::EnableTopicRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableTopicRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableTopicRuleInput {
                rule_name: self.rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableTopicRuleInputOperationOutputAlias = crate::operation::EnableTopicRule;
#[doc(hidden)]
pub type EnableTopicRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableTopicRuleInput {
    /// Consumes the builder and constructs an Operation<[`EnableTopicRule`](crate::operation::EnableTopicRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableTopicRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::EnableTopicRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_121 = &_input.rule_name;
                let input_121 = input_121.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let rule_name = aws_smithy_http::label::fmt_string(input_121, false);
                if rule_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/rules/{ruleName}/enable", ruleName = rule_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EnableTopicRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableTopicRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableTopicRule",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EnableTopicRuleInput`](crate::input::EnableTopicRuleInput)
    pub fn builder() -> crate::input::enable_topic_rule_input::Builder {
        crate::input::enable_topic_rule_input::Builder::default()
    }
}

/// See [`GetBehaviorModelTrainingSummariesInput`](crate::input::GetBehaviorModelTrainingSummariesInput)
pub mod get_behavior_model_training_summaries_input {
    /// A builder for [`GetBehaviorModelTrainingSummariesInput`](crate::input::GetBehaviorModelTrainingSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the security profile. </p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p> The name of the security profile. </p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of results to return at one time. The default is 25. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The token for the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBehaviorModelTrainingSummariesInput`](crate::input::GetBehaviorModelTrainingSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBehaviorModelTrainingSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBehaviorModelTrainingSummariesInput {
                security_profile_name: self.security_profile_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBehaviorModelTrainingSummariesInputOperationOutputAlias =
    crate::operation::GetBehaviorModelTrainingSummaries;
#[doc(hidden)]
pub type GetBehaviorModelTrainingSummariesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBehaviorModelTrainingSummariesInput {
    /// Consumes the builder and constructs an Operation<[`GetBehaviorModelTrainingSummaries`](crate::operation::GetBehaviorModelTrainingSummaries)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBehaviorModelTrainingSummaries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBehaviorModelTrainingSummariesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/behavior-model-training/summaries")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBehaviorModelTrainingSummariesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_122) = &_input.security_profile_name {
                    query.push_kv(
                        "securityProfileName",
                        &aws_smithy_http::query::fmt_string(&inner_122),
                    );
                }
                if let Some(inner_123) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_123).encode(),
                    );
                }
                if let Some(inner_124) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_124));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBehaviorModelTrainingSummariesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBehaviorModelTrainingSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBehaviorModelTrainingSummaries",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBehaviorModelTrainingSummariesInput`](crate::input::GetBehaviorModelTrainingSummariesInput)
    pub fn builder() -> crate::input::get_behavior_model_training_summaries_input::Builder {
        crate::input::get_behavior_model_training_summaries_input::Builder::default()
    }
}

/// See [`GetBucketsAggregationInput`](crate::input::GetBucketsAggregationInput)
pub mod get_buckets_aggregation_input {
    /// A builder for [`GetBucketsAggregationInput`](crate::input::GetBucketsAggregationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) aggregation_field: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
        pub(crate) buckets_aggregation_type:
            std::option::Option<crate::model::BucketsAggregationType>,
    }
    impl Builder {
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The aggregation field.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregation_field = Some(input.into());
            self
        }
        /// <p>The aggregation field.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregation_field = input;
            self
        }
        /// <p>The version of the query.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The version of the query.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// <p>The basic control of the response shape and the bucket aggregation type to perform. </p>
        pub fn buckets_aggregation_type(
            mut self,
            input: crate::model::BucketsAggregationType,
        ) -> Self {
            self.buckets_aggregation_type = Some(input);
            self
        }
        /// <p>The basic control of the response shape and the bucket aggregation type to perform. </p>
        pub fn set_buckets_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::BucketsAggregationType>,
        ) -> Self {
            self.buckets_aggregation_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketsAggregationInput`](crate::input::GetBucketsAggregationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketsAggregationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketsAggregationInput {
                index_name: self.index_name,
                query_string: self.query_string,
                aggregation_field: self.aggregation_field,
                query_version: self.query_version,
                buckets_aggregation_type: self.buckets_aggregation_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketsAggregationInputOperationOutputAlias = crate::operation::GetBucketsAggregation;
#[doc(hidden)]
pub type GetBucketsAggregationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketsAggregationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketsAggregation`](crate::operation::GetBucketsAggregation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketsAggregation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketsAggregationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/indices/buckets").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketsAggregationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_buckets_aggregation(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketsAggregation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketsAggregation",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketsAggregationInput`](crate::input::GetBucketsAggregationInput)
    pub fn builder() -> crate::input::get_buckets_aggregation_input::Builder {
        crate::input::get_buckets_aggregation_input::Builder::default()
    }
}

/// See [`GetCardinalityInput`](crate::input::GetCardinalityInput)
pub mod get_cardinality_input {
    /// A builder for [`GetCardinalityInput`](crate::input::GetCardinalityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) aggregation_field: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregation_field = Some(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregation_field = input;
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCardinalityInput`](crate::input::GetCardinalityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCardinalityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCardinalityInput {
                index_name: self.index_name,
                query_string: self.query_string,
                aggregation_field: self.aggregation_field,
                query_version: self.query_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCardinalityInputOperationOutputAlias = crate::operation::GetCardinality;
#[doc(hidden)]
pub type GetCardinalityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCardinalityInput {
    /// Consumes the builder and constructs an Operation<[`GetCardinality`](crate::operation::GetCardinality)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCardinality,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCardinalityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/indices/cardinality").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCardinalityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_cardinality(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCardinality::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCardinality",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCardinalityInput`](crate::input::GetCardinalityInput)
    pub fn builder() -> crate::input::get_cardinality_input::Builder {
        crate::input::get_cardinality_input::Builder::default()
    }
}

/// See [`GetEffectivePoliciesInput`](crate::input::GetEffectivePoliciesInput)
pub mod get_effective_policies_input {
    /// A builder for [`GetEffectivePoliciesInput`](crate::input::GetEffectivePoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) cognito_identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The principal. Valid principals are CertificateArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>), thingGroupArn (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and CognitoId (<i>region</i>:<i>id</i>).</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>The Cognito identity pool ID.</p>
        pub fn cognito_identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cognito_identity_pool_id = Some(input.into());
            self
        }
        /// <p>The Cognito identity pool ID.</p>
        pub fn set_cognito_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cognito_identity_pool_id = input;
            self
        }
        /// <p>The thing name.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The thing name.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEffectivePoliciesInput`](crate::input::GetEffectivePoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEffectivePoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEffectivePoliciesInput {
                principal: self.principal,
                cognito_identity_pool_id: self.cognito_identity_pool_id,
                thing_name: self.thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEffectivePoliciesInputOperationOutputAlias = crate::operation::GetEffectivePolicies;
#[doc(hidden)]
pub type GetEffectivePoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEffectivePoliciesInput {
    /// Consumes the builder and constructs an Operation<[`GetEffectivePolicies`](crate::operation::GetEffectivePolicies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEffectivePolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEffectivePoliciesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/effective-policies").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetEffectivePoliciesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_125) = &_input.thing_name {
                    query.push_kv("thingName", &aws_smithy_http::query::fmt_string(&inner_125));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEffectivePoliciesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_effective_policies(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEffectivePolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEffectivePolicies",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEffectivePoliciesInput`](crate::input::GetEffectivePoliciesInput)
    pub fn builder() -> crate::input::get_effective_policies_input::Builder {
        crate::input::get_effective_policies_input::Builder::default()
    }
}

/// See [`GetIndexingConfigurationInput`](crate::input::GetIndexingConfigurationInput)
pub mod get_indexing_configuration_input {
    /// A builder for [`GetIndexingConfigurationInput`](crate::input::GetIndexingConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetIndexingConfigurationInput`](crate::input::GetIndexingConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIndexingConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIndexingConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type GetIndexingConfigurationInputOperationOutputAlias =
    crate::operation::GetIndexingConfiguration;
#[doc(hidden)]
pub type GetIndexingConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIndexingConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetIndexingConfiguration`](crate::operation::GetIndexingConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIndexingConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIndexingConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/indexing/config").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIndexingConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIndexingConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIndexingConfiguration",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIndexingConfigurationInput`](crate::input::GetIndexingConfigurationInput)
    pub fn builder() -> crate::input::get_indexing_configuration_input::Builder {
        crate::input::get_indexing_configuration_input::Builder::default()
    }
}

/// See [`GetJobDocumentInput`](crate::input::GetJobDocumentInput)
pub mod get_job_document_input {
    /// A builder for [`GetJobDocumentInput`](crate::input::GetJobDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobDocumentInput`](crate::input::GetJobDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJobDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJobDocumentInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobDocumentInputOperationOutputAlias = crate::operation::GetJobDocument;
#[doc(hidden)]
pub type GetJobDocumentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobDocumentInput {
    /// Consumes the builder and constructs an Operation<[`GetJobDocument`](crate::operation::GetJobDocument)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJobDocument,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetJobDocumentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_126 = &_input.job_id;
                let input_126 = input_126.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_126, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/jobs/{jobId}/job-document", jobId = job_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetJobDocumentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJobDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJobDocument",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetJobDocumentInput`](crate::input::GetJobDocumentInput)
    pub fn builder() -> crate::input::get_job_document_input::Builder {
        crate::input::get_job_document_input::Builder::default()
    }
}

/// See [`GetLoggingOptionsInput`](crate::input::GetLoggingOptionsInput)
pub mod get_logging_options_input {
    /// A builder for [`GetLoggingOptionsInput`](crate::input::GetLoggingOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetLoggingOptionsInput`](crate::input::GetLoggingOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoggingOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoggingOptionsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetLoggingOptionsInputOperationOutputAlias = crate::operation::GetLoggingOptions;
#[doc(hidden)]
pub type GetLoggingOptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLoggingOptionsInput {
    /// Consumes the builder and constructs an Operation<[`GetLoggingOptions`](crate::operation::GetLoggingOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoggingOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLoggingOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/loggingOptions").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLoggingOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoggingOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoggingOptions",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLoggingOptionsInput`](crate::input::GetLoggingOptionsInput)
    pub fn builder() -> crate::input::get_logging_options_input::Builder {
        crate::input::get_logging_options_input::Builder::default()
    }
}

/// See [`GetOtaUpdateInput`](crate::input::GetOtaUpdateInput)
pub mod get_ota_update_input {
    /// A builder for [`GetOtaUpdateInput`](crate::input::GetOtaUpdateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_update_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The OTA update ID.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_id = Some(input.into());
            self
        }
        /// <p>The OTA update ID.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOtaUpdateInput`](crate::input::GetOtaUpdateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOtaUpdateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOtaUpdateInput {
                ota_update_id: self.ota_update_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOtaUpdateInputOperationOutputAlias = crate::operation::GetOTAUpdate;
#[doc(hidden)]
pub type GetOtaUpdateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOtaUpdateInput {
    /// Consumes the builder and constructs an Operation<[`GetOTAUpdate`](crate::operation::GetOTAUpdate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOTAUpdate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOtaUpdateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_127 = &_input.ota_update_id;
                let input_127 = input_127.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "ota_update_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let ota_update_id = aws_smithy_http::label::fmt_string(input_127, false);
                if ota_update_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ota_update_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/otaUpdates/{otaUpdateId}",
                    otaUpdateId = ota_update_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOtaUpdateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOTAUpdate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOTAUpdate",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOtaUpdateInput`](crate::input::GetOtaUpdateInput)
    pub fn builder() -> crate::input::get_ota_update_input::Builder {
        crate::input::get_ota_update_input::Builder::default()
    }
}

/// See [`GetPercentilesInput`](crate::input::GetPercentilesInput)
pub mod get_percentiles_input {
    /// A builder for [`GetPercentilesInput`](crate::input::GetPercentilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) aggregation_field: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
        pub(crate) percents: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// <p>The name of the index to search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the index to search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The search query string.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The search query string.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregation_field = Some(input.into());
            self
        }
        /// <p>The field to aggregate.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregation_field = input;
            self
        }
        /// <p>The query version.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The query version.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// Appends an item to `percents`.
        ///
        /// To override the contents of this collection use [`set_percents`](Self::set_percents).
        ///
        /// <p>The percentile groups returned.</p>
        pub fn percents(mut self, input: f64) -> Self {
            let mut v = self.percents.unwrap_or_default();
            v.push(input);
            self.percents = Some(v);
            self
        }
        /// <p>The percentile groups returned.</p>
        pub fn set_percents(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.percents = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPercentilesInput`](crate::input::GetPercentilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPercentilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPercentilesInput {
                index_name: self.index_name,
                query_string: self.query_string,
                aggregation_field: self.aggregation_field,
                query_version: self.query_version,
                percents: self.percents,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPercentilesInputOperationOutputAlias = crate::operation::GetPercentiles;
#[doc(hidden)]
pub type GetPercentilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPercentilesInput {
    /// Consumes the builder and constructs an Operation<[`GetPercentiles`](crate::operation::GetPercentiles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPercentiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPercentilesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/indices/percentiles").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPercentilesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_percentiles(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPercentiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPercentiles",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPercentilesInput`](crate::input::GetPercentilesInput)
    pub fn builder() -> crate::input::get_percentiles_input::Builder {
        crate::input::get_percentiles_input::Builder::default()
    }
}

/// See [`GetPolicyInput`](crate::input::GetPolicyInput)
pub mod get_policy_input {
    /// A builder for [`GetPolicyInput`](crate::input::GetPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyInput`](crate::input::GetPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetPolicyInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetPolicyInput {
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPolicyInputOperationOutputAlias = crate::operation::GetPolicy;
#[doc(hidden)]
pub type GetPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetPolicy`](crate::operation::GetPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_128 = &_input.policy_name;
                let input_128 = input_128.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_128, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/policies/{policyName}", policyName = policy_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetPolicy::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetPolicy",
                    "iot",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
}

/// See [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
pub mod get_policy_version_input {
    /// A builder for [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy version ID.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_version_id = Some(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPolicyVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPolicyVersionInput {
                policy_name: self.policy_name,
                policy_version_id: self.policy_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPolicyVersionInputOperationOutputAlias = crate::operation::GetPolicyVersion;
#[doc(hidden)]
pub type GetPolicyVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPolicyVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetPolicyVersion`](crate::operation::GetPolicyVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPolicyVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPolicyVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_129 = &_input.policy_name;
                let input_129 = input_129.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_name = aws_smithy_http::label::fmt_string(input_129, false);
                if policy_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_130 = &_input.policy_version_id;
                let input_130 = input_130.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_version_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let policy_version_id = aws_smithy_http::label::fmt_string(input_130, false);
                if policy_version_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "policy_version_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/policies/{policyName}/version/{policyVersionId}",
                    policyName = policy_name,
                    policyVersionId = policy_version_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPolicyVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPolicyVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPolicyVersion",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
    pub fn builder() -> crate::input::get_policy_version_input::Builder {
        crate::input::get_policy_version_input::Builder::default()
    }
}

/// See [`GetRegistrationCodeInput`](crate::input::GetRegistrationCodeInput)
pub mod get_registration_code_input {
    /// A builder for [`GetRegistrationCodeInput`](crate::input::GetRegistrationCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetRegistrationCodeInput`](crate::input::GetRegistrationCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRegistrationCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRegistrationCodeInput {})
        }
    }
}
#[doc(hidden)]
pub type GetRegistrationCodeInputOperationOutputAlias = crate::operation::GetRegistrationCode;
#[doc(hidden)]
pub type GetRegistrationCodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRegistrationCodeInput {
    /// Consumes the builder and constructs an Operation<[`GetRegistrationCode`](crate::operation::GetRegistrationCode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRegistrationCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRegistrationCodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/registrationcode").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRegistrationCodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRegistrationCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRegistrationCode",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRegistrationCodeInput`](crate::input::GetRegistrationCodeInput)
    pub fn builder() -> crate::input::get_registration_code_input::Builder {
        crate::input::get_registration_code_input::Builder::default()
    }
}

/// See [`GetStatisticsInput`](crate::input::GetStatisticsInput)
pub mod get_statistics_input {
    /// A builder for [`GetStatisticsInput`](crate::input::GetStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) aggregation_field: std::option::Option<std::string::String>,
        pub(crate) query_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the index to search. The default value is <code>AWS_Things</code>.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the index to search. The default value is <code>AWS_Things</code>.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The query used to search. You can specify "*" for the query string to get the count of all indexed things in your Amazon Web Services account.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The query used to search. You can specify "*" for the query string to get the count of all indexed things in your Amazon Web Services account.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The aggregation field name.</p>
        pub fn aggregation_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregation_field = Some(input.into());
            self
        }
        /// <p>The aggregation field name.</p>
        pub fn set_aggregation_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregation_field = input;
            self
        }
        /// <p>The version of the query used to search.</p>
        pub fn query_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_version = Some(input.into());
            self
        }
        /// <p>The version of the query used to search.</p>
        pub fn set_query_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStatisticsInput`](crate::input::GetStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStatisticsInput {
                index_name: self.index_name,
                query_string: self.query_string,
                aggregation_field: self.aggregation_field,
                query_version: self.query_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStatisticsInputOperationOutputAlias = crate::operation::GetStatistics;
#[doc(hidden)]
pub type GetStatisticsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetStatistics`](crate::operation::GetStatistics)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStatistics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetStatisticsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/indices/statistics").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetStatisticsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_statistics(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStatistics",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetStatisticsInput`](crate::input::GetStatisticsInput)
    pub fn builder() -> crate::input::get_statistics_input::Builder {
        crate::input::get_statistics_input::Builder::default()
    }
}

/// See [`GetTopicRuleInput`](crate::input::GetTopicRuleInput)
pub mod get_topic_rule_input {
    /// A builder for [`GetTopicRuleInput`](crate::input::GetTopicRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTopicRuleInput`](crate::input::GetTopicRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTopicRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTopicRuleInput {
                rule_name: self.rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTopicRuleInputOperationOutputAlias = crate::operation::GetTopicRule;
#[doc(hidden)]
pub type GetTopicRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTopicRuleInput {
    /// Consumes the builder and constructs an Operation<[`GetTopicRule`](crate::operation::GetTopicRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTopicRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTopicRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_131 = &_input.rule_name;
                let input_131 = input_131.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let rule_name = aws_smithy_http::label::fmt_string(input_131, false);
                if rule_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "rule_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/rules/{ruleName}", ruleName = rule_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTopicRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTopicRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTopicRule",
            "iot",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetTopicRuleInput`](crate::input::GetTopicRuleInput)
    pub fn builder() -> crate::input::get_topic_rule_input::Builder {
        crate::input::get_topic_rule_input::Builder::default()
    }
}

/// See [`GetTopicRuleDestinationInput`](crate::input::GetTopicRuleDestinationInput)
pub mod get_topic_rule_destination_input {
    /// A builder for [`GetTopicRuleDestinationInput`](crate::input::GetTopicRuleDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic rule destination.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic rule destination.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTopicRuleDestinationInput`](crate::input::GetTopicRuleDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTopicRuleDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTopicRuleDestinationInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetTopicRuleDestinationInputOperationOutputAlias =
    crate::operation::GetTopicRuleDestination;
#[doc(hidden)]
pub type GetTopicRuleDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTopicRuleDestinationInput {
    /// Consumes the builder and constructs an Operation<[`GetTopicRuleDestination`](crate::operation::GetTopicRuleDestination)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTopicRuleDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTopicRuleDestinationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_132 = &_input.arn;
                let input_132 = input_132.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let arn = aws_smithy_http::label::fmt_string(input_132, true);
                if arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/destinations/{arn}", arn = arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTopicRuleDestinationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conve