// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptCertificateTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptCertificateTransferError {
    /// Kind of error that occurred.
    pub kind: AcceptCertificateTransferErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptCertificateTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptCertificateTransferErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You can't revert the certificate transfer because the transfer is already complete.</p>
    TransferAlreadyCompletedException(crate::error::TransferAlreadyCompletedException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptCertificateTransferError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptCertificateTransferErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AcceptCertificateTransferErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AcceptCertificateTransferErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AcceptCertificateTransferErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            AcceptCertificateTransferErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AcceptCertificateTransferErrorKind::TransferAlreadyCompletedException(_inner) => {
                _inner.fmt(f)
            }
            AcceptCertificateTransferErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            AcceptCertificateTransferErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptCertificateTransferError {
    fn code(&self) -> Option<&str> {
        AcceptCertificateTransferError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptCertificateTransferError {
    /// Creates a new `AcceptCertificateTransferError`.
    pub fn new(kind: AcceptCertificateTransferErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptCertificateTransferError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptCertificateTransferErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptCertificateTransferError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptCertificateTransferErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptCertificateTransferErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptCertificateTransferErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptCertificateTransferErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptCertificateTransferErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptCertificateTransferErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptCertificateTransferErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptCertificateTransferErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptCertificateTransferErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptCertificateTransferErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptCertificateTransferErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptCertificateTransferErrorKind::TransferAlreadyCompletedException`.
    pub fn is_transfer_already_completed_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptCertificateTransferErrorKind::TransferAlreadyCompletedException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptCertificateTransferErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptCertificateTransferErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for AcceptCertificateTransferError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptCertificateTransferErrorKind::InternalFailureException(_inner) => Some(_inner),
            AcceptCertificateTransferErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AcceptCertificateTransferErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AcceptCertificateTransferErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AcceptCertificateTransferErrorKind::ThrottlingException(_inner) => Some(_inner),
            AcceptCertificateTransferErrorKind::TransferAlreadyCompletedException(_inner) => {
                Some(_inner)
            }
            AcceptCertificateTransferErrorKind::UnauthorizedException(_inner) => Some(_inner),
            AcceptCertificateTransferErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddThingToBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddThingToBillingGroupError {
    /// Kind of error that occurred.
    pub kind: AddThingToBillingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddThingToBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddThingToBillingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddThingToBillingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddThingToBillingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AddThingToBillingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AddThingToBillingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddThingToBillingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AddThingToBillingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddThingToBillingGroupError {
    fn code(&self) -> Option<&str> {
        AddThingToBillingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddThingToBillingGroupError {
    /// Creates a new `AddThingToBillingGroupError`.
    pub fn new(kind: AddThingToBillingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddThingToBillingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddThingToBillingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddThingToBillingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddThingToBillingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddThingToBillingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToBillingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AddThingToBillingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToBillingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AddThingToBillingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToBillingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddThingToBillingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToBillingGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AddThingToBillingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddThingToBillingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            AddThingToBillingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AddThingToBillingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddThingToBillingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            AddThingToBillingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddThingToThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddThingToThingGroupError {
    /// Kind of error that occurred.
    pub kind: AddThingToThingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddThingToThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddThingToThingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddThingToThingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddThingToThingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AddThingToThingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AddThingToThingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddThingToThingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AddThingToThingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddThingToThingGroupError {
    fn code(&self) -> Option<&str> {
        AddThingToThingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddThingToThingGroupError {
    /// Creates a new `AddThingToThingGroupError`.
    pub fn new(kind: AddThingToThingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddThingToThingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddThingToThingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddThingToThingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddThingToThingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddThingToThingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToThingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AddThingToThingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToThingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AddThingToThingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToThingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddThingToThingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddThingToThingGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AddThingToThingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddThingToThingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            AddThingToThingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AddThingToThingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddThingToThingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            AddThingToThingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateTargetsWithJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateTargetsWithJobError {
    /// Kind of error that occurred.
    pub kind: AssociateTargetsWithJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateTargetsWithJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateTargetsWithJobErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateTargetsWithJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateTargetsWithJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateTargetsWithJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateTargetsWithJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateTargetsWithJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AssociateTargetsWithJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateTargetsWithJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateTargetsWithJobError {
    fn code(&self) -> Option<&str> {
        AssociateTargetsWithJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateTargetsWithJobError {
    /// Creates a new `AssociateTargetsWithJobError`.
    pub fn new(kind: AssociateTargetsWithJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateTargetsWithJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateTargetsWithJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateTargetsWithJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateTargetsWithJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateTargetsWithJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTargetsWithJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTargetsWithJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTargetsWithJobErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTargetsWithJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTargetsWithJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTargetsWithJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTargetsWithJobErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateTargetsWithJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateTargetsWithJobErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateTargetsWithJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateTargetsWithJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateTargetsWithJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateTargetsWithJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateTargetsWithJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AssociateTargetsWithJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateTargetsWithJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachPolicyError {
    /// Kind of error that occurred.
    pub kind: AttachPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachPolicyErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            AttachPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachPolicyError {
    fn code(&self) -> Option<&str> {
        AttachPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachPolicyError {
    /// Creates a new `AttachPolicyError`.
    pub fn new(kind: AttachPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `AttachPolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, AttachPolicyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for AttachPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            AttachPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AttachPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AttachPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            AttachPolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            AttachPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachPrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachPrincipalPolicyError {
    /// Kind of error that occurred.
    pub kind: AttachPrincipalPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachPrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachPrincipalPolicyErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachPrincipalPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachPrincipalPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AttachPrincipalPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AttachPrincipalPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachPrincipalPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachPrincipalPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AttachPrincipalPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AttachPrincipalPolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            AttachPrincipalPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachPrincipalPolicyError {
    fn code(&self) -> Option<&str> {
        AttachPrincipalPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachPrincipalPolicyError {
    /// Creates a new `AttachPrincipalPolicyError`.
    pub fn new(kind: AttachPrincipalPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachPrincipalPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachPrincipalPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachPrincipalPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachPrincipalPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachPrincipalPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPrincipalPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPrincipalPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPrincipalPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPrincipalPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPrincipalPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPrincipalPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPrincipalPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPrincipalPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPrincipalPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPrincipalPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPrincipalPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachPrincipalPolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachPrincipalPolicyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for AttachPrincipalPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachPrincipalPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            AttachPrincipalPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AttachPrincipalPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachPrincipalPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachPrincipalPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AttachPrincipalPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            AttachPrincipalPolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            AttachPrincipalPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: AttachSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachSecurityProfileErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachSecurityProfileErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AttachSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AttachSecurityProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachSecurityProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AttachSecurityProfileErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            AttachSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachSecurityProfileError {
    fn code(&self) -> Option<&str> {
        AttachSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachSecurityProfileError {
    /// Creates a new `AttachSecurityProfileError`.
    pub fn new(kind: AttachSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachSecurityProfileErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachSecurityProfileErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachSecurityProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachSecurityProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachSecurityProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachSecurityProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachSecurityProfileErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachSecurityProfileErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for AttachSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachSecurityProfileErrorKind::InternalFailureException(_inner) => Some(_inner),
            AttachSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AttachSecurityProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachSecurityProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            AttachSecurityProfileErrorKind::VersionConflictException(_inner) => Some(_inner),
            AttachSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachThingPrincipal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachThingPrincipalError {
    /// Kind of error that occurred.
    pub kind: AttachThingPrincipalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachThingPrincipal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachThingPrincipalErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachThingPrincipalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachThingPrincipalErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            AttachThingPrincipalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AttachThingPrincipalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AttachThingPrincipalErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AttachThingPrincipalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AttachThingPrincipalErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            AttachThingPrincipalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachThingPrincipalError {
    fn code(&self) -> Option<&str> {
        AttachThingPrincipalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachThingPrincipalError {
    /// Creates a new `AttachThingPrincipalError`.
    pub fn new(kind: AttachThingPrincipalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachThingPrincipalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachThingPrincipalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachThingPrincipalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachThingPrincipalErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachThingPrincipalErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachThingPrincipalErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachThingPrincipalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachThingPrincipalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachThingPrincipalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachThingPrincipalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachThingPrincipalErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachThingPrincipalErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachThingPrincipalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachThingPrincipalErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachThingPrincipalErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachThingPrincipalErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for AttachThingPrincipalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachThingPrincipalErrorKind::InternalFailureException(_inner) => Some(_inner),
            AttachThingPrincipalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AttachThingPrincipalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AttachThingPrincipalErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AttachThingPrincipalErrorKind::ThrottlingException(_inner) => Some(_inner),
            AttachThingPrincipalErrorKind::UnauthorizedException(_inner) => Some(_inner),
            AttachThingPrincipalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelAuditMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelAuditMitigationActionsTaskError {
    /// Kind of error that occurred.
    pub kind: CancelAuditMitigationActionsTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelAuditMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelAuditMitigationActionsTaskErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelAuditMitigationActionsTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelAuditMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            CancelAuditMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            CancelAuditMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CancelAuditMitigationActionsTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelAuditMitigationActionsTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelAuditMitigationActionsTaskError {
    fn code(&self) -> Option<&str> {
        CancelAuditMitigationActionsTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelAuditMitigationActionsTaskError {
    /// Creates a new `CancelAuditMitigationActionsTaskError`.
    pub fn new(
        kind: CancelAuditMitigationActionsTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelAuditMitigationActionsTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelAuditMitigationActionsTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelAuditMitigationActionsTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelAuditMitigationActionsTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelAuditMitigationActionsTaskErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelAuditMitigationActionsTaskErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelAuditMitigationActionsTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelAuditMitigationActionsTaskErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelAuditMitigationActionsTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelAuditMitigationActionsTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelAuditMitigationActionsTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelAuditMitigationActionsTaskErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CancelAuditMitigationActionsTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelAuditMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            CancelAuditMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            CancelAuditMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CancelAuditMitigationActionsTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelAuditMitigationActionsTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelAuditTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelAuditTaskError {
    /// Kind of error that occurred.
    pub kind: CancelAuditTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelAuditTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelAuditTaskErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelAuditTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelAuditTaskErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CancelAuditTaskErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CancelAuditTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelAuditTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelAuditTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelAuditTaskError {
    fn code(&self) -> Option<&str> {
        CancelAuditTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelAuditTaskError {
    /// Creates a new `CancelAuditTaskError`.
    pub fn new(kind: CancelAuditTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelAuditTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelAuditTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelAuditTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelAuditTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelAuditTaskErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelAuditTaskErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelAuditTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelAuditTaskErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelAuditTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelAuditTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelAuditTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CancelAuditTaskErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CancelAuditTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelAuditTaskErrorKind::InternalFailureException(_inner) => Some(_inner),
            CancelAuditTaskErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CancelAuditTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelAuditTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelAuditTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelCertificateTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelCertificateTransferError {
    /// Kind of error that occurred.
    pub kind: CancelCertificateTransferErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelCertificateTransfer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelCertificateTransferErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You can't revert the certificate transfer because the transfer is already complete.</p>
    TransferAlreadyCompletedException(crate::error::TransferAlreadyCompletedException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelCertificateTransferError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelCertificateTransferErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CancelCertificateTransferErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CancelCertificateTransferErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelCertificateTransferErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CancelCertificateTransferErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelCertificateTransferErrorKind::TransferAlreadyCompletedException(_inner) => {
                _inner.fmt(f)
            }
            CancelCertificateTransferErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CancelCertificateTransferErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelCertificateTransferError {
    fn code(&self) -> Option<&str> {
        CancelCertificateTransferError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelCertificateTransferError {
    /// Creates a new `CancelCertificateTransferError`.
    pub fn new(kind: CancelCertificateTransferErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelCertificateTransferError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelCertificateTransferErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelCertificateTransferError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelCertificateTransferErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelCertificateTransferErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelCertificateTransferErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelCertificateTransferErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelCertificateTransferErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelCertificateTransferErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelCertificateTransferErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelCertificateTransferErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelCertificateTransferErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelCertificateTransferErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelCertificateTransferErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelCertificateTransferErrorKind::TransferAlreadyCompletedException`.
    pub fn is_transfer_already_completed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelCertificateTransferErrorKind::TransferAlreadyCompletedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelCertificateTransferErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelCertificateTransferErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CancelCertificateTransferError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelCertificateTransferErrorKind::InternalFailureException(_inner) => Some(_inner),
            CancelCertificateTransferErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CancelCertificateTransferErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelCertificateTransferErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CancelCertificateTransferErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelCertificateTransferErrorKind::TransferAlreadyCompletedException(_inner) => {
                Some(_inner)
            }
            CancelCertificateTransferErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CancelCertificateTransferErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelDetectMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelDetectMitigationActionsTaskError {
    /// Kind of error that occurred.
    pub kind: CancelDetectMitigationActionsTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelDetectMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelDetectMitigationActionsTaskErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelDetectMitigationActionsTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelDetectMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            CancelDetectMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            CancelDetectMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CancelDetectMitigationActionsTaskErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            CancelDetectMitigationActionsTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelDetectMitigationActionsTaskError {
    fn code(&self) -> Option<&str> {
        CancelDetectMitigationActionsTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelDetectMitigationActionsTaskError {
    /// Creates a new `CancelDetectMitigationActionsTaskError`.
    pub fn new(
        kind: CancelDetectMitigationActionsTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelDetectMitigationActionsTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelDetectMitigationActionsTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelDetectMitigationActionsTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelDetectMitigationActionsTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelDetectMitigationActionsTaskErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDetectMitigationActionsTaskErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDetectMitigationActionsTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDetectMitigationActionsTaskErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDetectMitigationActionsTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDetectMitigationActionsTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDetectMitigationActionsTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDetectMitigationActionsTaskErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CancelDetectMitigationActionsTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelDetectMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            CancelDetectMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            CancelDetectMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CancelDetectMitigationActionsTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelDetectMitigationActionsTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelJobError {
    /// Kind of error that occurred.
    pub kind: CancelJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelJobErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelJobError {
    fn code(&self) -> Option<&str> {
        CancelJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelJobError {
    /// Creates a new `CancelJobError`.
    pub fn new(kind: CancelJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CancelJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CancelJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CancelJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CancelJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelJobExecutionError {
    /// Kind of error that occurred.
    pub kind: CancelJobExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelJobExecutionErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An attempt was made to change to an invalid state, for example by deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code> parameter.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelJobExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelJobExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CancelJobExecutionErrorKind::InvalidStateTransitionException(_inner) => _inner.fmt(f),
            CancelJobExecutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelJobExecutionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CancelJobExecutionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelJobExecutionErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            CancelJobExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelJobExecutionError {
    fn code(&self) -> Option<&str> {
        CancelJobExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelJobExecutionError {
    /// Creates a new `CancelJobExecutionError`.
    pub fn new(kind: CancelJobExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelJobExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelJobExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelJobExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelJobExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelJobExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobExecutionErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobExecutionErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobExecutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobExecutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobExecutionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobExecutionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobExecutionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobExecutionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobExecutionErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobExecutionErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for CancelJobExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelJobExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CancelJobExecutionErrorKind::InvalidStateTransitionException(_inner) => Some(_inner),
            CancelJobExecutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelJobExecutionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CancelJobExecutionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelJobExecutionErrorKind::VersionConflictException(_inner) => Some(_inner),
            CancelJobExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ClearDefaultAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ClearDefaultAuthorizerError {
    /// Kind of error that occurred.
    pub kind: ClearDefaultAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ClearDefaultAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ClearDefaultAuthorizerErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ClearDefaultAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ClearDefaultAuthorizerErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ClearDefaultAuthorizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ClearDefaultAuthorizerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ClearDefaultAuthorizerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ClearDefaultAuthorizerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ClearDefaultAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ClearDefaultAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ClearDefaultAuthorizerError {
    fn code(&self) -> Option<&str> {
        ClearDefaultAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ClearDefaultAuthorizerError {
    /// Creates a new `ClearDefaultAuthorizerError`.
    pub fn new(kind: ClearDefaultAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ClearDefaultAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ClearDefaultAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ClearDefaultAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ClearDefaultAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ClearDefaultAuthorizerErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearDefaultAuthorizerErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearDefaultAuthorizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearDefaultAuthorizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearDefaultAuthorizerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearDefaultAuthorizerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearDefaultAuthorizerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearDefaultAuthorizerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearDefaultAuthorizerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearDefaultAuthorizerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ClearDefaultAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ClearDefaultAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ClearDefaultAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ClearDefaultAuthorizerErrorKind::InternalFailureException(_inner) => Some(_inner),
            ClearDefaultAuthorizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ClearDefaultAuthorizerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ClearDefaultAuthorizerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ClearDefaultAuthorizerErrorKind::ThrottlingException(_inner) => Some(_inner),
            ClearDefaultAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ClearDefaultAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmTopicRuleDestinationError {
    /// Kind of error that occurred.
    pub kind: ConfirmTopicRuleDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmTopicRuleDestinationErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmTopicRuleDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmTopicRuleDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            ConfirmTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ConfirmTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmTopicRuleDestinationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ConfirmTopicRuleDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmTopicRuleDestinationError {
    fn code(&self) -> Option<&str> {
        ConfirmTopicRuleDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmTopicRuleDestinationError {
    /// Creates a new `ConfirmTopicRuleDestinationError`.
    pub fn new(kind: ConfirmTopicRuleDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmTopicRuleDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmTopicRuleDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmTopicRuleDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmTopicRuleDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ConfirmTopicRuleDestinationErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmTopicRuleDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmTopicRuleDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmTopicRuleDestinationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmTopicRuleDestinationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmTopicRuleDestinationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmTopicRuleDestinationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ConfirmTopicRuleDestinationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmTopicRuleDestinationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ConfirmTopicRuleDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_inner) => {
                Some(_inner)
            }
            ConfirmTopicRuleDestinationErrorKind::InternalException(_inner) => Some(_inner),
            ConfirmTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ConfirmTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ConfirmTopicRuleDestinationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ConfirmTopicRuleDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAuditSuppression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAuditSuppressionError {
    /// Kind of error that occurred.
    pub kind: CreateAuditSuppressionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAuditSuppression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAuditSuppressionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAuditSuppressionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAuditSuppressionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAuditSuppressionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAuditSuppressionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAuditSuppressionErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateAuditSuppressionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAuditSuppressionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAuditSuppressionError {
    fn code(&self) -> Option<&str> {
        CreateAuditSuppressionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAuditSuppressionError {
    /// Creates a new `CreateAuditSuppressionError`.
    pub fn new(kind: CreateAuditSuppressionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAuditSuppressionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAuditSuppressionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAuditSuppressionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAuditSuppressionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAuditSuppressionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuditSuppressionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuditSuppressionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuditSuppressionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuditSuppressionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuditSuppressionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuditSuppressionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuditSuppressionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuditSuppressionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuditSuppressionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateAuditSuppressionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAuditSuppressionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAuditSuppressionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAuditSuppressionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAuditSuppressionErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateAuditSuppressionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAuditSuppressionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAuthorizerError {
    /// Kind of error that occurred.
    pub kind: CreateAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAuthorizerErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAuthorizerErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAuthorizerError {
    fn code(&self) -> Option<&str> {
        CreateAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAuthorizerError {
    /// Creates a new `CreateAuthorizerError`.
    pub fn new(kind: CreateAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAuthorizerErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthorizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthorizerErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthorizerErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthorizerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthorizerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAuthorizerErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBillingGroupError {
    /// Kind of error that occurred.
    pub kind: CreateBillingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBillingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBillingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBillingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBillingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBillingGroupError {
    fn code(&self) -> Option<&str> {
        CreateBillingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBillingGroupError {
    /// Creates a new `CreateBillingGroupError`.
    pub fn new(kind: CreateBillingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBillingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBillingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBillingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBillingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBillingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBillingGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateBillingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBillingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBillingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCertificateFromCsr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCertificateFromCsrError {
    /// Kind of error that occurred.
    pub kind: CreateCertificateFromCsrErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCertificateFromCsr` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCertificateFromCsrErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCertificateFromCsrError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCertificateFromCsrErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateCertificateFromCsrErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateCertificateFromCsrErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateCertificateFromCsrErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateCertificateFromCsrErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateCertificateFromCsrErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCertificateFromCsrError {
    fn code(&self) -> Option<&str> {
        CreateCertificateFromCsrError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCertificateFromCsrError {
    /// Creates a new `CreateCertificateFromCsrError`.
    pub fn new(kind: CreateCertificateFromCsrErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCertificateFromCsrError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCertificateFromCsrErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCertificateFromCsrError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCertificateFromCsrErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCertificateFromCsrErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateFromCsrErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateFromCsrErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateFromCsrErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateFromCsrErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateFromCsrErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateFromCsrErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateFromCsrErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateFromCsrErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateFromCsrErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateCertificateFromCsrError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCertificateFromCsrErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateCertificateFromCsrErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateCertificateFromCsrErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateCertificateFromCsrErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateCertificateFromCsrErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateCertificateFromCsrErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomMetricError {
    /// Kind of error that occurred.
    pub kind: CreateCustomMetricErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomMetricErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomMetricError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomMetricErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateCustomMetricErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateCustomMetricErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateCustomMetricErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateCustomMetricErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateCustomMetricErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomMetricError {
    fn code(&self) -> Option<&str> {
        CreateCustomMetricError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomMetricError {
    /// Creates a new `CreateCustomMetricError`.
    pub fn new(kind: CreateCustomMetricErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomMetricError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomMetricErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomMetricError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomMetricErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomMetricErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomMetricErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomMetricErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomMetricErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomMetricErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomMetricErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomMetricErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomMetricErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomMetricErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomMetricErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateCustomMetricError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomMetricErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateCustomMetricErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateCustomMetricErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCustomMetricErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateCustomMetricErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateCustomMetricErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDimension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDimensionError {
    /// Kind of error that occurred.
    pub kind: CreateDimensionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDimension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDimensionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDimensionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDimensionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDimensionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDimensionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDimensionErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDimensionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDimensionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDimensionError {
    fn code(&self) -> Option<&str> {
        CreateDimensionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDimensionError {
    /// Creates a new `CreateDimensionError`.
    pub fn new(kind: CreateDimensionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDimensionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDimensionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDimensionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDimensionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDimensionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDimensionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDimensionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDimensionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDimensionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDimensionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDimensionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDimensionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDimensionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDimensionErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateDimensionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDimensionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDimensionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDimensionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDimensionErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDimensionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDimensionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomainConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateDomainConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomainConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainConfigurationErrorKind {
    /// <p>The certificate is invalid.</p>
    CertificateValidationException(crate::error::CertificateValidationException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainConfigurationErrorKind::CertificateValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateDomainConfigurationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDomainConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDomainConfigurationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDomainConfigurationErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateDomainConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateDomainConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDomainConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDomainConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateDomainConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainConfigurationError {
    /// Creates a new `CreateDomainConfigurationError`.
    pub fn new(kind: CreateDomainConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::CertificateValidationException`.
    pub fn is_certificate_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::CertificateValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDomainConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainConfigurationErrorKind::CertificateValidationException(_inner) => {
                Some(_inner)
            }
            CreateDomainConfigurationErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDomainConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDomainConfigurationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDomainConfigurationErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateDomainConfigurationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateDomainConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDomainConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDomainConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDynamicThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDynamicThingGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDynamicThingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDynamicThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDynamicThingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The query is invalid.</p>
    InvalidQueryException(crate::error::InvalidQueryException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDynamicThingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDynamicThingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDynamicThingGroupErrorKind::InvalidQueryException(_inner) => _inner.fmt(f),
            CreateDynamicThingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDynamicThingGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDynamicThingGroupErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateDynamicThingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDynamicThingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDynamicThingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDynamicThingGroupError {
    fn code(&self) -> Option<&str> {
        CreateDynamicThingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDynamicThingGroupError {
    /// Creates a new `CreateDynamicThingGroupError`.
    pub fn new(kind: CreateDynamicThingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDynamicThingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDynamicThingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDynamicThingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDynamicThingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDynamicThingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDynamicThingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDynamicThingGroupErrorKind::InvalidQueryException`.
    pub fn is_invalid_query_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDynamicThingGroupErrorKind::InvalidQueryException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDynamicThingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDynamicThingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDynamicThingGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDynamicThingGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDynamicThingGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDynamicThingGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDynamicThingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDynamicThingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDynamicThingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDynamicThingGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateDynamicThingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDynamicThingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDynamicThingGroupErrorKind::InvalidQueryException(_inner) => Some(_inner),
            CreateDynamicThingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDynamicThingGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDynamicThingGroupErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateDynamicThingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDynamicThingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDynamicThingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFleetMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFleetMetricError {
    /// Kind of error that occurred.
    pub kind: CreateFleetMetricErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFleetMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFleetMetricErrorKind {
    /// <p>The index is not ready.</p>
    IndexNotReadyException(crate::error::IndexNotReadyException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregationException(crate::error::InvalidAggregationException),
    /// <p>The query is invalid.</p>
    InvalidQueryException(crate::error::InvalidQueryException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFleetMetricError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFleetMetricErrorKind::IndexNotReadyException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::InvalidAggregationException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::InvalidQueryException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateFleetMetricErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFleetMetricError {
    fn code(&self) -> Option<&str> {
        CreateFleetMetricError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFleetMetricError {
    /// Creates a new `CreateFleetMetricError`.
    pub fn new(kind: CreateFleetMetricErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFleetMetricError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFleetMetricErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFleetMetricError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFleetMetricErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::IndexNotReadyException`.
    pub fn is_index_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::IndexNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::InvalidAggregationException`.
    pub fn is_invalid_aggregation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::InvalidAggregationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::InvalidQueryException`.
    pub fn is_invalid_query_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::InvalidQueryException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetMetricErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetMetricErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateFleetMetricError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFleetMetricErrorKind::IndexNotReadyException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::InvalidAggregationException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::InvalidQueryException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateFleetMetricErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobError {
    /// Kind of error that occurred.
    pub kind: CreateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobError {
    fn code(&self) -> Option<&str> {
        CreateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobError {
    /// Creates a new `CreateJobError`.
    pub fn new(kind: CreateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateJobErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobTemplateErrorKind {
    /// <p>A resource with the same name already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobTemplateError {
    fn code(&self) -> Option<&str> {
        CreateJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobTemplateError {
    /// Creates a new `CreateJobTemplateError`.
    pub fn new(kind: CreateJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateJobTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateKeysAndCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateKeysAndCertificateError {
    /// Kind of error that occurred.
    pub kind: CreateKeysAndCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateKeysAndCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateKeysAndCertificateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateKeysAndCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateKeysAndCertificateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateKeysAndCertificateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateKeysAndCertificateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateKeysAndCertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateKeysAndCertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateKeysAndCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateKeysAndCertificateError {
    fn code(&self) -> Option<&str> {
        CreateKeysAndCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateKeysAndCertificateError {
    /// Creates a new `CreateKeysAndCertificateError`.
    pub fn new(kind: CreateKeysAndCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateKeysAndCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateKeysAndCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateKeysAndCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateKeysAndCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateKeysAndCertificateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeysAndCertificateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeysAndCertificateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeysAndCertificateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeysAndCertificateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeysAndCertificateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeysAndCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeysAndCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeysAndCertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeysAndCertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateKeysAndCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateKeysAndCertificateErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateKeysAndCertificateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateKeysAndCertificateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateKeysAndCertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateKeysAndCertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateKeysAndCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMitigationAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMitigationActionError {
    /// Kind of error that occurred.
    pub kind: CreateMitigationActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMitigationAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMitigationActionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMitigationActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMitigationActionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateMitigationActionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateMitigationActionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateMitigationActionErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateMitigationActionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateMitigationActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMitigationActionError {
    fn code(&self) -> Option<&str> {
        CreateMitigationActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMitigationActionError {
    /// Creates a new `CreateMitigationActionError`.
    pub fn new(kind: CreateMitigationActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMitigationActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMitigationActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMitigationActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMitigationActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMitigationActionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMitigationActionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMitigationActionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMitigationActionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMitigationActionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMitigationActionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMitigationActionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMitigationActionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMitigationActionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMitigationActionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateMitigationActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMitigationActionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateMitigationActionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateMitigationActionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateMitigationActionErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateMitigationActionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateMitigationActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOTAUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOTAUpdateError {
    /// Kind of error that occurred.
    pub kind: CreateOTAUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOTAUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOTAUpdateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOTAUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOTAUpdateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateOTAUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOTAUpdateError {
    fn code(&self) -> Option<&str> {
        CreateOTAUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOTAUpdateError {
    /// Creates a new `CreateOTAUpdateError`.
    pub fn new(kind: CreateOTAUpdateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOTAUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOTAUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOTAUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOTAUpdateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOTAUpdateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOTAUpdateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOTAUpdateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOTAUpdateErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOTAUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOTAUpdateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateOTAUpdateErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateOTAUpdateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOTAUpdateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateOTAUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOTAUpdateErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateOTAUpdateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePolicyError {
    /// Kind of error that occurred.
    pub kind: CreatePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePolicyErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The policy documentation is not valid.</p>
    MalformedPolicyException(crate::error::MalformedPolicyException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::MalformedPolicyException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePolicyError {
    fn code(&self) -> Option<&str> {
        CreatePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePolicyError {
    /// Creates a new `CreatePolicyError`.
    pub fn new(kind: CreatePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::MalformedPolicyException`.
    pub fn is_malformed_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::MalformedPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreatePolicyErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreatePolicyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreatePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreatePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreatePolicyErrorKind::MalformedPolicyException(_inner) => Some(_inner),
            CreatePolicyErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreatePolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreatePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreatePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePolicyVersionError {
    /// Kind of error that occurred.
    pub kind: CreatePolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePolicyVersionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The policy documentation is not valid.</p>
    MalformedPolicyException(crate::error::MalformedPolicyException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The number of policy versions exceeds the limit.</p>
    VersionsLimitExceededException(crate::error::VersionsLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePolicyVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::MalformedPolicyException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::VersionsLimitExceededException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePolicyVersionError {
    fn code(&self) -> Option<&str> {
        CreatePolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePolicyVersionError {
    /// Creates a new `CreatePolicyVersionError`.
    pub fn new(kind: CreatePolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::MalformedPolicyException`.
    pub fn is_malformed_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::MalformedPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::VersionsLimitExceededException`.
    pub fn is_versions_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::VersionsLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreatePolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePolicyVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::MalformedPolicyException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::VersionsLimitExceededException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProvisioningClaim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProvisioningClaimError {
    /// Kind of error that occurred.
    pub kind: CreateProvisioningClaimErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProvisioningClaim` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProvisioningClaimErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProvisioningClaimError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProvisioningClaimErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateProvisioningClaimErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateProvisioningClaimErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProvisioningClaimErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateProvisioningClaimErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProvisioningClaimErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateProvisioningClaimErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProvisioningClaimError {
    fn code(&self) -> Option<&str> {
        CreateProvisioningClaimError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProvisioningClaimError {
    /// Creates a new `CreateProvisioningClaimError`.
    pub fn new(kind: CreateProvisioningClaimErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProvisioningClaimError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProvisioningClaimErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProvisioningClaimError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProvisioningClaimErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProvisioningClaimErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningClaimErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningClaimErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningClaimErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningClaimErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningClaimErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningClaimErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningClaimErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningClaimErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningClaimErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningClaimErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningClaimErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateProvisioningClaimError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProvisioningClaimErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateProvisioningClaimErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateProvisioningClaimErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProvisioningClaimErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateProvisioningClaimErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProvisioningClaimErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateProvisioningClaimErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProvisioningTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProvisioningTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateProvisioningTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProvisioningTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProvisioningTemplateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProvisioningTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProvisioningTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateProvisioningTemplateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateProvisioningTemplateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateProvisioningTemplateErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProvisioningTemplateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateProvisioningTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProvisioningTemplateError {
    fn code(&self) -> Option<&str> {
        CreateProvisioningTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProvisioningTemplateError {
    /// Creates a new `CreateProvisioningTemplateError`.
    pub fn new(kind: CreateProvisioningTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProvisioningTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProvisioningTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProvisioningTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProvisioningTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateProvisioningTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProvisioningTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateProvisioningTemplateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateProvisioningTemplateErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateProvisioningTemplateErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateProvisioningTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProvisioningTemplateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateProvisioningTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProvisioningTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProvisioningTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: CreateProvisioningTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProvisioningTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProvisioningTemplateVersionErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>The number of policy versions exceeds the limit.</p>
    VersionsLimitExceededException(crate::error::VersionsLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProvisioningTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException(
                _inner,
            ) => _inner.fmt(f),
            CreateProvisioningTemplateVersionErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningTemplateVersionErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningTemplateVersionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningTemplateVersionErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningTemplateVersionErrorKind::VersionsLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateProvisioningTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProvisioningTemplateVersionError {
    fn code(&self) -> Option<&str> {
        CreateProvisioningTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProvisioningTemplateVersionError {
    /// Creates a new `CreateProvisioningTemplateVersionError`.
    pub fn new(
        kind: CreateProvisioningTemplateVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProvisioningTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProvisioningTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProvisioningTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProvisioningTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateVersionErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProvisioningTemplateVersionErrorKind::VersionsLimitExceededException`.
    pub fn is_versions_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProvisioningTemplateVersionErrorKind::VersionsLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateProvisioningTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException(
                _inner,
            ) => Some(_inner),
            CreateProvisioningTemplateVersionErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            CreateProvisioningTemplateVersionErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            CreateProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateProvisioningTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProvisioningTemplateVersionErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            CreateProvisioningTemplateVersionErrorKind::VersionsLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateProvisioningTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoleAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRoleAliasError {
    /// Kind of error that occurred.
    pub kind: CreateRoleAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoleAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRoleAliasErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRoleAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRoleAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateRoleAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateRoleAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRoleAliasErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateRoleAliasErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateRoleAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRoleAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateRoleAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRoleAliasError {
    fn code(&self) -> Option<&str> {
        CreateRoleAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRoleAliasError {
    /// Creates a new `CreateRoleAliasError`.
    pub fn new(kind: CreateRoleAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRoleAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRoleAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRoleAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRoleAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRoleAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleAliasErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleAliasErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleAliasErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleAliasErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleAliasErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleAliasErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateRoleAliasErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateRoleAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleAliasErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateRoleAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRoleAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateRoleAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateRoleAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRoleAliasErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateRoleAliasErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateRoleAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRoleAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateRoleAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateScheduledAudit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateScheduledAuditError {
    /// Kind of error that occurred.
    pub kind: CreateScheduledAuditErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateScheduledAudit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateScheduledAuditErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateScheduledAuditError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateScheduledAuditErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateScheduledAuditErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateScheduledAuditErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateScheduledAuditErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateScheduledAuditErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateScheduledAuditErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateScheduledAuditError {
    fn code(&self) -> Option<&str> {
        CreateScheduledAuditError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateScheduledAuditError {
    /// Creates a new `CreateScheduledAuditError`.
    pub fn new(kind: CreateScheduledAuditErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateScheduledAuditError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateScheduledAuditErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateScheduledAuditError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateScheduledAuditErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateScheduledAuditErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledAuditErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledAuditErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledAuditErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledAuditErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledAuditErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledAuditErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledAuditErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledAuditErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledAuditErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateScheduledAuditError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateScheduledAuditErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateScheduledAuditErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateScheduledAuditErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateScheduledAuditErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateScheduledAuditErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateScheduledAuditErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: CreateSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSecurityProfileErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSecurityProfileErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSecurityProfileError {
    fn code(&self) -> Option<&str> {
        CreateSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSecurityProfileError {
    /// Creates a new `CreateSecurityProfileError`.
    pub fn new(kind: CreateSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSecurityProfileErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamError {
    /// Kind of error that occurred.
    pub kind: CreateStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamError {
    fn code(&self) -> Option<&str> {
        CreateStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamError {
    /// Creates a new `CreateStreamError`.
    pub fn new(kind: CreateStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateStreamErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateStreamErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateStreamErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateStreamErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateStreamErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStreamErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateStreamErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateStreamErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateThingError {
    /// Kind of error that occurred.
    pub kind: CreateThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateThingErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateThingErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateThingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateThingErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateThingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateThingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateThingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateThingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateThingError {
    fn code(&self) -> Option<&str> {
        CreateThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateThingError {
    /// Creates a new `CreateThingError`.
    pub fn new(kind: CreateThingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateThingErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateThingErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateThingErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateThingErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateThingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateThingErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateThingErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateThingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateThingErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateThingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateThingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateThingErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateThingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateThingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateThingGroupError {
    /// Kind of error that occurred.
    pub kind: CreateThingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateThingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateThingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateThingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateThingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateThingGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateThingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateThingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateThingGroupError {
    fn code(&self) -> Option<&str> {
        CreateThingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateThingGroupError {
    /// Creates a new `CreateThingGroupError`.
    pub fn new(kind: CreateThingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateThingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateThingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateThingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateThingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateThingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateThingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateThingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateThingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateThingGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateThingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateThingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateThingTypeError {
    /// Kind of error that occurred.
    pub kind: CreateThingTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateThingTypeErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateThingTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateThingTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateThingTypeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateThingTypeErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateThingTypeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateThingTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateThingTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateThingTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateThingTypeError {
    fn code(&self) -> Option<&str> {
        CreateThingTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateThingTypeError {
    /// Creates a new `CreateThingTypeError`.
    pub fn new(kind: CreateThingTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateThingTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateThingTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateThingTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateThingTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateThingTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingTypeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingTypeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingTypeErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingTypeErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingTypeErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingTypeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingTypeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThingTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateThingTypeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateThingTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThingTypeErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateThingTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateThingTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateThingTypeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateThingTypeErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateThingTypeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateThingTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateThingTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateThingTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTopicRuleError {
    /// Kind of error that occurred.
    pub kind: CreateTopicRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTopicRuleErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The Rule-SQL expression can't be parsed correctly.</p>
    SqlParseException(crate::error::SqlParseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTopicRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => _inner.fmt(f),
            CreateTopicRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateTopicRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateTopicRuleErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateTopicRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateTopicRuleErrorKind::SqlParseException(_inner) => _inner.fmt(f),
            CreateTopicRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTopicRuleError {
    fn code(&self) -> Option<&str> {
        CreateTopicRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTopicRuleError {
    /// Creates a new `CreateTopicRuleError`.
    pub fn new(kind: CreateTopicRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTopicRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTopicRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTopicRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTopicRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTopicRuleErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateTopicRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateTopicRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleErrorKind::SqlParseException`.
    pub fn is_sql_parse_exception(&self) -> bool {
        matches!(&self.kind, CreateTopicRuleErrorKind::SqlParseException(_))
    }
}
impl std::error::Error for CreateTopicRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => Some(_inner),
            CreateTopicRuleErrorKind::InternalException(_inner) => Some(_inner),
            CreateTopicRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateTopicRuleErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateTopicRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateTopicRuleErrorKind::SqlParseException(_inner) => Some(_inner),
            CreateTopicRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTopicRuleDestinationError {
    /// Kind of error that occurred.
    pub kind: CreateTopicRuleDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTopicRuleDestinationErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTopicRuleDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_inner) => {
                _inner.fmt(f)
            }
            CreateTopicRuleDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateTopicRuleDestinationErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateTopicRuleDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTopicRuleDestinationError {
    fn code(&self) -> Option<&str> {
        CreateTopicRuleDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTopicRuleDestinationError {
    /// Creates a new `CreateTopicRuleDestinationError`.
    pub fn new(kind: CreateTopicRuleDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTopicRuleDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTopicRuleDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTopicRuleDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTopicRuleDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTopicRuleDestinationErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleDestinationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleDestinationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleDestinationErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleDestinationErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTopicRuleDestinationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicRuleDestinationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateTopicRuleDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_inner) => {
                Some(_inner)
            }
            CreateTopicRuleDestinationErrorKind::InternalException(_inner) => Some(_inner),
            CreateTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateTopicRuleDestinationErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateTopicRuleDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccountAuditConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccountAuditConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteAccountAuditConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccountAuditConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccountAuditConfigurationErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccountAuditConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccountAuditConfigurationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAccountAuditConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAccountAuditConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAccountAuditConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAccountAuditConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccountAuditConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteAccountAuditConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccountAuditConfigurationError {
    /// Creates a new `DeleteAccountAuditConfigurationError`.
    pub fn new(
        kind: DeleteAccountAuditConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccountAuditConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccountAuditConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccountAuditConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccountAuditConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccountAuditConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAuditConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAuditConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAuditConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAuditConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAuditConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAuditConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAuditConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteAccountAuditConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccountAuditConfigurationErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DeleteAccountAuditConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DeleteAccountAuditConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteAccountAuditConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAccountAuditConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAuditSuppression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAuditSuppressionError {
    /// Kind of error that occurred.
    pub kind: DeleteAuditSuppressionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAuditSuppression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAuditSuppressionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAuditSuppressionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAuditSuppressionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAuditSuppressionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAuditSuppressionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAuditSuppressionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAuditSuppressionError {
    fn code(&self) -> Option<&str> {
        DeleteAuditSuppressionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAuditSuppressionError {
    /// Creates a new `DeleteAuditSuppressionError`.
    pub fn new(kind: DeleteAuditSuppressionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAuditSuppressionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAuditSuppressionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAuditSuppressionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAuditSuppressionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAuditSuppressionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuditSuppressionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuditSuppressionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuditSuppressionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuditSuppressionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuditSuppressionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteAuditSuppressionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAuditSuppressionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAuditSuppressionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAuditSuppressionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAuditSuppressionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAuthorizerError {
    /// Kind of error that occurred.
    pub kind: DeleteAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAuthorizerErrorKind {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAuthorizerErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAuthorizerError {
    fn code(&self) -> Option<&str> {
        DeleteAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAuthorizerError {
    /// Creates a new `DeleteAuthorizerError`.
    pub fn new(kind: DeleteAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAuthorizerErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuthorizerErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuthorizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuthorizerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuthorizerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuthorizerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAuthorizerErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBillingGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteBillingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBillingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBillingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBillingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            DeleteBillingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBillingGroupError {
    fn code(&self) -> Option<&str> {
        DeleteBillingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBillingGroupError {
    /// Creates a new `DeleteBillingGroupError`.
    pub fn new(kind: DeleteBillingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBillingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBillingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBillingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBillingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBillingGroupErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBillingGroupErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteBillingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBillingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::VersionConflictException(_inner) => Some(_inner),
            DeleteBillingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCACertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCACertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteCACertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCACertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCACertificateErrorKind {
    /// <p>The certificate operation is not allowed.</p>
    CertificateStateException(crate::error::CertificateStateException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCACertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCACertificateErrorKind::CertificateStateException(_inner) => _inner.fmt(f),
            DeleteCACertificateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteCACertificateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteCACertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCACertificateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteCACertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCACertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteCACertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCACertificateError {
    fn code(&self) -> Option<&str> {
        DeleteCACertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCACertificateError {
    /// Creates a new `DeleteCACertificateError`.
    pub fn new(kind: DeleteCACertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCACertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCACertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCACertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCACertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCACertificateErrorKind::CertificateStateException`.
    pub fn is_certificate_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCACertificateErrorKind::CertificateStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCACertificateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCACertificateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCACertificateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCACertificateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCACertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCACertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCACertificateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCACertificateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCACertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCACertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCACertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCACertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteCACertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCACertificateErrorKind::CertificateStateException(_inner) => Some(_inner),
            DeleteCACertificateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteCACertificateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteCACertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCACertificateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteCACertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCACertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteCACertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCertificateErrorKind {
    /// <p>The certificate operation is not allowed.</p>
    CertificateStateException(crate::error::CertificateStateException),
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCertificateErrorKind::CertificateStateException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCertificateError {
    /// Creates a new `DeleteCertificateError`.
    pub fn new(kind: DeleteCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::CertificateStateException`.
    pub fn is_certificate_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::CertificateStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCertificateErrorKind::CertificateStateException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomMetricError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomMetricErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomMetricErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomMetricError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomMetricErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteCustomMetricErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteCustomMetricErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCustomMetricErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomMetricError {
    fn code(&self) -> Option<&str> {
        DeleteCustomMetricError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomMetricError {
    /// Creates a new `DeleteCustomMetricError`.
    pub fn new(kind: DeleteCustomMetricErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomMetricError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomMetricErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomMetricError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomMetricErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomMetricErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomMetricErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomMetricErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomMetricErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomMetricErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomMetricErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteCustomMetricError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomMetricErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteCustomMetricErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteCustomMetricErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCustomMetricErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDimension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDimensionError {
    /// Kind of error that occurred.
    pub kind: DeleteDimensionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDimension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDimensionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDimensionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDimensionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDimensionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDimensionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDimensionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDimensionError {
    fn code(&self) -> Option<&str> {
        DeleteDimensionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDimensionError {
    /// Creates a new `DeleteDimensionError`.
    pub fn new(kind: DeleteDimensionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDimensionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDimensionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDimensionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDimensionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDimensionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDimensionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDimensionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDimensionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDimensionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDimensionErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteDimensionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDimensionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDimensionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDimensionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDimensionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomainConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomainConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainConfigurationErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainConfigurationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDomainConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDomainConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDomainConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDomainConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDomainConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteDomainConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainConfigurationError {
    /// Creates a new `DeleteDomainConfigurationError`.
    pub fn new(kind: DeleteDomainConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDomainConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainConfigurationErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDomainConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDomainConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDomainConfigurationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteDomainConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDomainConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDomainConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDynamicThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDynamicThingGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDynamicThingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDynamicThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDynamicThingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDynamicThingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDynamicThingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDynamicThingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDynamicThingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDynamicThingGroupErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            DeleteDynamicThingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDynamicThingGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDynamicThingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDynamicThingGroupError {
    /// Creates a new `DeleteDynamicThingGroupError`.
    pub fn new(kind: DeleteDynamicThingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDynamicThingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDynamicThingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDynamicThingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDynamicThingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDynamicThingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDynamicThingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDynamicThingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDynamicThingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDynamicThingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDynamicThingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDynamicThingGroupErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDynamicThingGroupErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteDynamicThingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDynamicThingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDynamicThingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDynamicThingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDynamicThingGroupErrorKind::VersionConflictException(_inner) => Some(_inner),
            DeleteDynamicThingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFleetMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFleetMetricError {
    /// Kind of error that occurred.
    pub kind: DeleteFleetMetricErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFleetMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFleetMetricErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFleetMetricError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFleetMetricErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteFleetMetricErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteFleetMetricErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteFleetMetricErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFleetMetricErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteFleetMetricErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            DeleteFleetMetricErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFleetMetricError {
    fn code(&self) -> Option<&str> {
        DeleteFleetMetricError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFleetMetricError {
    /// Creates a new `DeleteFleetMetricError`.
    pub fn new(kind: DeleteFleetMetricErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFleetMetricError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFleetMetricErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFleetMetricError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFleetMetricErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFleetMetricErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetMetricErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetMetricErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetMetricErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetMetricErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetMetricErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetMetricErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetMetricErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetMetricErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetMetricErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetMetricErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetMetricErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteFleetMetricError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFleetMetricErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteFleetMetricErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteFleetMetricErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteFleetMetricErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFleetMetricErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteFleetMetricErrorKind::VersionConflictException(_inner) => Some(_inner),
            DeleteFleetMetricErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobError {
    /// Kind of error that occurred.
    pub kind: DeleteJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An attempt was made to change to an invalid state, for example by deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code> parameter.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::InvalidStateTransitionException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobError {
    fn code(&self) -> Option<&str> {
        DeleteJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobError {
    /// Creates a new `DeleteJobError`.
    pub fn new(kind: DeleteJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteJobErrorKind::InvalidStateTransitionException(_inner) => Some(_inner),
            DeleteJobErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobExecutionError {
    /// Kind of error that occurred.
    pub kind: DeleteJobExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobExecutionErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An attempt was made to change to an invalid state, for example by deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code> parameter.</p>
    InvalidStateTransitionException(crate::error::InvalidStateTransitionException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteJobExecutionErrorKind::InvalidStateTransitionException(_inner) => _inner.fmt(f),
            DeleteJobExecutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteJobExecutionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteJobExecutionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteJobExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobExecutionError {
    fn code(&self) -> Option<&str> {
        DeleteJobExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobExecutionError {
    /// Creates a new `DeleteJobExecutionError`.
    pub fn new(kind: DeleteJobExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobExecutionErrorKind::InvalidStateTransitionException`.
    pub fn is_invalid_state_transition_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobExecutionErrorKind::InvalidStateTransitionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobExecutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobExecutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobExecutionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobExecutionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobExecutionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobExecutionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteJobExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteJobExecutionErrorKind::InvalidStateTransitionException(_inner) => Some(_inner),
            DeleteJobExecutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteJobExecutionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteJobExecutionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteJobExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobTemplateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobTemplateError {
    /// Creates a new `DeleteJobTemplateError`.
    pub fn new(kind: DeleteJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMitigationAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMitigationActionError {
    /// Kind of error that occurred.
    pub kind: DeleteMitigationActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMitigationAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMitigationActionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMitigationActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMitigationActionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteMitigationActionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteMitigationActionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteMitigationActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMitigationActionError {
    fn code(&self) -> Option<&str> {
        DeleteMitigationActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMitigationActionError {
    /// Creates a new `DeleteMitigationActionError`.
    pub fn new(kind: DeleteMitigationActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMitigationActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMitigationActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMitigationActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMitigationActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMitigationActionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMitigationActionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMitigationActionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMitigationActionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMitigationActionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMitigationActionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteMitigationActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMitigationActionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteMitigationActionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteMitigationActionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteMitigationActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOTAUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOTAUpdateError {
    /// Kind of error that occurred.
    pub kind: DeleteOTAUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOTAUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOTAUpdateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOTAUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOTAUpdateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteOTAUpdateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteOTAUpdateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteOTAUpdateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteOTAUpdateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteOTAUpdateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteOTAUpdateErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            DeleteOTAUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOTAUpdateError {
    fn code(&self) -> Option<&str> {
        DeleteOTAUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOTAUpdateError {
    /// Creates a new `DeleteOTAUpdateError`.
    pub fn new(kind: DeleteOTAUpdateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOTAUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOTAUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOTAUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOTAUpdateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOTAUpdateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOTAUpdateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOTAUpdateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOTAUpdateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOTAUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOTAUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOTAUpdateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOTAUpdateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOTAUpdateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteOTAUpdateErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteOTAUpdateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOTAUpdateErrorKind::UnauthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOTAUpdateErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOTAUpdateErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteOTAUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOTAUpdateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteOTAUpdateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteOTAUpdateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteOTAUpdateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteOTAUpdateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteOTAUpdateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteOTAUpdateErrorKind::VersionConflictException(_inner) => Some(_inner),
            DeleteOTAUpdateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyErrorKind {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyError {
    fn code(&self) -> Option<&str> {
        DeletePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyError {
    /// Creates a new `DeletePolicyError`.
    pub fn new(kind: DeletePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeletePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeletePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyVersionError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyVersionErrorKind {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyVersionErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyVersionError {
    fn code(&self) -> Option<&str> {
        DeletePolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyVersionError {
    /// Creates a new `DeletePolicyVersionError`.
    pub fn new(kind: DeletePolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeletePolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyVersionErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProvisioningTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProvisioningTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteProvisioningTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProvisioningTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProvisioningTemplateErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProvisioningTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProvisioningTemplateErrorKind::ConflictingResourceUpdateException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningTemplateErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteProvisioningTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteProvisioningTemplateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteProvisioningTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProvisioningTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProvisioningTemplateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteProvisioningTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProvisioningTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteProvisioningTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProvisioningTemplateError {
    /// Creates a new `DeleteProvisioningTemplateError`.
    pub fn new(kind: DeleteProvisioningTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProvisioningTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProvisioningTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProvisioningTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProvisioningTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteProvisioningTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProvisioningTemplateErrorKind::ConflictingResourceUpdateException(_inner) => {
                Some(_inner)
            }
            DeleteProvisioningTemplateErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteProvisioningTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteProvisioningTemplateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteProvisioningTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProvisioningTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProvisioningTemplateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteProvisioningTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProvisioningTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProvisioningTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteProvisioningTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProvisioningTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProvisioningTemplateVersionErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProvisioningTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException(
                _inner,
            ) => _inner.fmt(f),
            DeleteProvisioningTemplateVersionErrorKind::DeleteConflictException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningTemplateVersionErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningTemplateVersionErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningTemplateVersionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningTemplateVersionErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisioningTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProvisioningTemplateVersionError {
    fn code(&self) -> Option<&str> {
        DeleteProvisioningTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProvisioningTemplateVersionError {
    /// Creates a new `DeleteProvisioningTemplateVersionError`.
    pub fn new(
        kind: DeleteProvisioningTemplateVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProvisioningTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProvisioningTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProvisioningTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProvisioningTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateVersionErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateVersionErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisioningTemplateVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisioningTemplateVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteProvisioningTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProvisioningTemplateVersionErrorKind::ConflictingResourceUpdateException(
                _inner,
            ) => Some(_inner),
            DeleteProvisioningTemplateVersionErrorKind::DeleteConflictException(_inner) => {
                Some(_inner)
            }
            DeleteProvisioningTemplateVersionErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DeleteProvisioningTemplateVersionErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DeleteProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteProvisioningTemplateVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProvisioningTemplateVersionErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DeleteProvisioningTemplateVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRegistrationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRegistrationCodeError {
    /// Kind of error that occurred.
    pub kind: DeleteRegistrationCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRegistrationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRegistrationCodeErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRegistrationCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRegistrationCodeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteRegistrationCodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRegistrationCodeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRegistrationCodeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRegistrationCodeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteRegistrationCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRegistrationCodeError {
    fn code(&self) -> Option<&str> {
        DeleteRegistrationCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRegistrationCodeError {
    /// Creates a new `DeleteRegistrationCodeError`.
    pub fn new(kind: DeleteRegistrationCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRegistrationCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRegistrationCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRegistrationCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRegistrationCodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRegistrationCodeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistrationCodeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistrationCodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistrationCodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistrationCodeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistrationCodeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistrationCodeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistrationCodeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistrationCodeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistrationCodeErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteRegistrationCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRegistrationCodeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteRegistrationCodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRegistrationCodeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRegistrationCodeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRegistrationCodeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteRegistrationCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoleAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRoleAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteRoleAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoleAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRoleAliasErrorKind {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRoleAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRoleAliasErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteRoleAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteRoleAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteRoleAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRoleAliasErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRoleAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRoleAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteRoleAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRoleAliasError {
    fn code(&self) -> Option<&str> {
        DeleteRoleAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRoleAliasError {
    /// Creates a new `DeleteRoleAliasError`.
    pub fn new(kind: DeleteRoleAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRoleAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRoleAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRoleAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRoleAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRoleAliasErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleAliasErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoleAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoleAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleAliasErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoleAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoleAliasErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleAliasErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoleAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoleAliasErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoleAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleAliasErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteRoleAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRoleAliasErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteRoleAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteRoleAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteRoleAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRoleAliasErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRoleAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRoleAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteRoleAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScheduledAudit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScheduledAuditError {
    /// Kind of error that occurred.
    pub kind: DeleteScheduledAuditErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScheduledAudit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScheduledAuditErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScheduledAuditError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScheduledAuditErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteScheduledAuditErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteScheduledAuditErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteScheduledAuditErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteScheduledAuditErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScheduledAuditError {
    fn code(&self) -> Option<&str> {
        DeleteScheduledAuditError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScheduledAuditError {
    /// Creates a new `DeleteScheduledAuditError`.
    pub fn new(kind: DeleteScheduledAuditErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScheduledAuditError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScheduledAuditErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScheduledAuditError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScheduledAuditErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScheduledAuditErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledAuditErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduledAuditErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledAuditErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduledAuditErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledAuditErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduledAuditErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledAuditErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteScheduledAuditError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScheduledAuditErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteScheduledAuditErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteScheduledAuditErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteScheduledAuditErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteScheduledAuditErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSecurityProfileErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSecurityProfileErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSecurityProfileError {
    fn code(&self) -> Option<&str> {
        DeleteSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSecurityProfileError {
    /// Creates a new `DeleteSecurityProfileError`.
    pub fn new(kind: DeleteSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSecurityProfileErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::VersionConflictException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStreamErrorKind {
    /// <p>You can't delete the resource because it is attached to one or more resources.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStreamErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStreamError {
    fn code(&self) -> Option<&str> {
        DeleteStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStreamError {
    /// Creates a new `DeleteStreamError`.
    pub fn new(kind: DeleteStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStreamErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteStreamErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteStreamErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteStreamErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStreamErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteStreamErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteStreamErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStreamErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteStreamErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteStreamErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThingError {
    /// Kind of error that occurred.
    pub kind: DeleteThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThingErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThingErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteThingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteThingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteThingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteThingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteThingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteThingErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            DeleteThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThingError {
    fn code(&self) -> Option<&str> {
        DeleteThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThingError {
    /// Creates a new `DeleteThingError`.
    pub fn new(kind: DeleteThingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThingErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteThingErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteThingErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteThingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteThingErrorKind::UnauthorizedException(_))
    }
    /// Returns `true` if the error kind is `DeleteThingErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThingErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteThingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteThingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteThingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteThingErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteThingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteThingErrorKind::VersionConflictException(_inner) => Some(_inner),
            DeleteThingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThingGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteThingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>
    VersionConflictException(crate::error::VersionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteThingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteThingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteThingGroupErrorKind::VersionConflictException(_inner) => _inner.fmt(f),
            DeleteThingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThingGroupError {
    fn code(&self) -> Option<&str> {
        DeleteThingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThingGroupError {
    /// Creates a new `DeleteThingGroupError`.
    pub fn new(kind: DeleteThingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingGroupErrorKind::VersionConflictException`.
    pub fn is_version_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingGroupErrorKind::VersionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteThingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteThingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteThingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteThingGroupErrorKind::VersionConflictException(_inner) => Some(_inner),
            DeleteThingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThingTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteThingTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThingTypeErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThingTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThingTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteThingTypeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteThingTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteThingTypeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteThingTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteThingTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteThingTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThingTypeError {
    fn code(&self) -> Option<&str> {
        DeleteThingTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThingTypeError {
    /// Creates a new `DeleteThingTypeError`.
    pub fn new(kind: DeleteThingTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThingTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThingTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThingTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThingTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThingTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingTypeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingTypeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingTypeErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingTypeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingTypeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThingTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteThingTypeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteThingTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThingTypeErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteThingTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThingTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteThingTypeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteThingTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteThingTypeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteThingTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteThingTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteThingTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTopicRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteTopicRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTopicRuleErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTopicRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => _inner.fmt(f),
            DeleteTopicRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteTopicRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteTopicRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteTopicRuleErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteTopicRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTopicRuleError {
    fn code(&self) -> Option<&str> {
        DeleteTopicRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTopicRuleError {
    /// Creates a new `DeleteTopicRuleError`.
    pub fn new(kind: DeleteTopicRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTopicRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTopicRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTopicRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTopicRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteTopicRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteTopicRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => Some(_inner),
            DeleteTopicRuleErrorKind::InternalException(_inner) => Some(_inner),
            DeleteTopicRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteTopicRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteTopicRuleErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteTopicRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTopicRuleDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteTopicRuleDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTopicRuleDestinationErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTopicRuleDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_inner) => {
                _inner.fmt(f)
            }
            DeleteTopicRuleDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteTopicRuleDestinationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteTopicRuleDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTopicRuleDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteTopicRuleDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTopicRuleDestinationError {
    /// Creates a new `DeleteTopicRuleDestinationError`.
    pub fn new(kind: DeleteTopicRuleDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTopicRuleDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTopicRuleDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTopicRuleDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTopicRuleDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleDestinationErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleDestinationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleDestinationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleDestinationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleDestinationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTopicRuleDestinationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicRuleDestinationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteTopicRuleDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTopicRuleDestinationErrorKind::ConflictingResourceUpdateException(_inner) => {
                Some(_inner)
            }
            DeleteTopicRuleDestinationErrorKind::InternalException(_inner) => Some(_inner),
            DeleteTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteTopicRuleDestinationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteTopicRuleDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteV2LoggingLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteV2LoggingLevelError {
    /// Kind of error that occurred.
    pub kind: DeleteV2LoggingLevelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteV2LoggingLevel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteV2LoggingLevelErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteV2LoggingLevelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteV2LoggingLevelErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteV2LoggingLevelErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteV2LoggingLevelErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteV2LoggingLevelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteV2LoggingLevelError {
    fn code(&self) -> Option<&str> {
        DeleteV2LoggingLevelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteV2LoggingLevelError {
    /// Creates a new `DeleteV2LoggingLevelError`.
    pub fn new(kind: DeleteV2LoggingLevelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteV2LoggingLevelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteV2LoggingLevelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteV2LoggingLevelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteV2LoggingLevelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteV2LoggingLevelErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteV2LoggingLevelErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteV2LoggingLevelErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteV2LoggingLevelErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteV2LoggingLevelErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteV2LoggingLevelErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteV2LoggingLevelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteV2LoggingLevelErrorKind::InternalException(_inner) => Some(_inner),
            DeleteV2LoggingLevelErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteV2LoggingLevelErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteV2LoggingLevelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeprecateThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeprecateThingTypeError {
    /// Kind of error that occurred.
    pub kind: DeprecateThingTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeprecateThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeprecateThingTypeErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeprecateThingTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeprecateThingTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeprecateThingTypeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeprecateThingTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeprecateThingTypeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeprecateThingTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeprecateThingTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeprecateThingTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeprecateThingTypeError {
    fn code(&self) -> Option<&str> {
        DeprecateThingTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeprecateThingTypeError {
    /// Creates a new `DeprecateThingTypeError`.
    pub fn new(kind: DeprecateThingTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeprecateThingTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeprecateThingTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeprecateThingTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeprecateThingTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeprecateThingTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateThingTypeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateThingTypeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateThingTypeErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateThingTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateThingTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateThingTypeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateThingTypeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateThingTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateThingTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeprecateThingTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeprecateThingTypeErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeprecateThingTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeprecateThingTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeprecateThingTypeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeprecateThingTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeprecateThingTypeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeprecateThingTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeprecateThingTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeprecateThingTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountAuditConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAuditConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAuditConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAuditConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAuditConfigurationErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAuditConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAuditConfigurationErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAuditConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAccountAuditConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAuditConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAuditConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAuditConfigurationError {
    /// Creates a new `DescribeAccountAuditConfigurationError`.
    pub fn new(
        kind: DescribeAccountAuditConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAuditConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAuditConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAuditConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAuditConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountAuditConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAuditConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccountAuditConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountAuditConfigurationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAccountAuditConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAuditConfigurationErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeAccountAuditConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAccountAuditConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAuditFinding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAuditFindingError {
    /// Kind of error that occurred.
    pub kind: DescribeAuditFindingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAuditFinding` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAuditFindingErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAuditFindingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAuditFindingErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAuditFindingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAuditFindingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAuditFindingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAuditFindingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAuditFindingError {
    fn code(&self) -> Option<&str> {
        DescribeAuditFindingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAuditFindingError {
    /// Creates a new `DescribeAuditFindingError`.
    pub fn new(kind: DescribeAuditFindingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAuditFindingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAuditFindingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAuditFindingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAuditFindingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAuditFindingErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditFindingErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditFindingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditFindingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditFindingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditFindingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditFindingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditFindingErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAuditFindingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAuditFindingErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAuditFindingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAuditFindingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAuditFindingErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAuditFindingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAuditMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAuditMitigationActionsTaskError {
    /// Kind of error that occurred.
    pub kind: DescribeAuditMitigationActionsTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAuditMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAuditMitigationActionsTaskErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAuditMitigationActionsTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAuditMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditMitigationActionsTaskErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuditMitigationActionsTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAuditMitigationActionsTaskError {
    fn code(&self) -> Option<&str> {
        DescribeAuditMitigationActionsTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAuditMitigationActionsTaskError {
    /// Creates a new `DescribeAuditMitigationActionsTaskError`.
    pub fn new(
        kind: DescribeAuditMitigationActionsTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAuditMitigationActionsTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAuditMitigationActionsTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAuditMitigationActionsTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAuditMitigationActionsTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAuditMitigationActionsTaskErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditMitigationActionsTaskErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditMitigationActionsTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditMitigationActionsTaskErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditMitigationActionsTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditMitigationActionsTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditMitigationActionsTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditMitigationActionsTaskErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAuditMitigationActionsTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAuditMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeAuditMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeAuditMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAuditMitigationActionsTaskErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeAuditMitigationActionsTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAuditSuppression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAuditSuppressionError {
    /// Kind of error that occurred.
    pub kind: DescribeAuditSuppressionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAuditSuppression` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAuditSuppressionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAuditSuppressionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAuditSuppressionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAuditSuppressionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAuditSuppressionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAuditSuppressionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAuditSuppressionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAuditSuppressionError {
    fn code(&self) -> Option<&str> {
        DescribeAuditSuppressionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAuditSuppressionError {
    /// Creates a new `DescribeAuditSuppressionError`.
    pub fn new(kind: DescribeAuditSuppressionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAuditSuppressionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAuditSuppressionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAuditSuppressionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAuditSuppressionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAuditSuppressionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditSuppressionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditSuppressionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditSuppressionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditSuppressionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditSuppressionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditSuppressionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditSuppressionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAuditSuppressionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAuditSuppressionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAuditSuppressionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAuditSuppressionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAuditSuppressionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAuditSuppressionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAuditTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAuditTaskError {
    /// Kind of error that occurred.
    pub kind: DescribeAuditTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAuditTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAuditTaskErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAuditTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAuditTaskErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAuditTaskErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAuditTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAuditTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAuditTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAuditTaskError {
    fn code(&self) -> Option<&str> {
        DescribeAuditTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAuditTaskError {
    /// Creates a new `DescribeAuditTaskError`.
    pub fn new(kind: DescribeAuditTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAuditTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAuditTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAuditTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAuditTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAuditTaskErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditTaskErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditTaskErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuditTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuditTaskErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAuditTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAuditTaskErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAuditTaskErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAuditTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAuditTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAuditTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAuthorizerError {
    /// Kind of error that occurred.
    pub kind: DescribeAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAuthorizerErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAuthorizerErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeAuthorizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAuthorizerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAuthorizerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAuthorizerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAuthorizerError {
    fn code(&self) -> Option<&str> {
        DescribeAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAuthorizerError {
    /// Creates a new `DescribeAuthorizerError`.
    pub fn new(kind: DescribeAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAuthorizerErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthorizerErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuthorizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthorizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuthorizerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthorizerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuthorizerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthorizerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuthorizerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthorizerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAuthorizerErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeAuthorizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAuthorizerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAuthorizerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeAuthorizerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBillingGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeBillingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBillingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBillingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBillingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBillingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeBillingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeBillingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBillingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeBillingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBillingGroupError {
    fn code(&self) -> Option<&str> {
        DescribeBillingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBillingGroupError {
    /// Creates a new `DescribeBillingGroupError`.
    pub fn new(kind: DescribeBillingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBillingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBillingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBillingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBillingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBillingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBillingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBillingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBillingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBillingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBillingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBillingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBillingGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeBillingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBillingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeBillingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeBillingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBillingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeBillingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCACertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCACertificateError {
    /// Kind of error that occurred.
    pub kind: DescribeCACertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCACertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCACertificateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCACertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCACertificateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeCACertificateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeCACertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCACertificateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeCACertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeCACertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeCACertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCACertificateError {
    fn code(&self) -> Option<&str> {
        DescribeCACertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCACertificateError {
    /// Creates a new `DescribeCACertificateError`.
    pub fn new(kind: DescribeCACertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCACertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCACertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCACertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCACertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCACertificateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCACertificateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCACertificateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCACertificateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCACertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCACertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCACertificateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCACertificateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCACertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCACertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCACertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCACertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeCACertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCACertificateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeCACertificateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeCACertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCACertificateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeCACertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeCACertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeCACertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCertificateError {
    /// Kind of error that occurred.
    pub kind: DescribeCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCertificateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCertificateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCertificateError {
    fn code(&self) -> Option<&str> {
        DescribeCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCertificateError {
    /// Creates a new `DescribeCertificateError`.
    pub fn new(kind: DescribeCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCertificateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCertificateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCertificateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomMetricError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomMetricErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomMetricErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomMetricError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomMetricErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeCustomMetricErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeCustomMetricErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCustomMetricErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeCustomMetricErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomMetricError {
    fn code(&self) -> Option<&str> {
        DescribeCustomMetricError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomMetricError {
    /// Creates a new `DescribeCustomMetricError`.
    pub fn new(kind: DescribeCustomMetricErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomMetricError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomMetricErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomMetricError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomMetricErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCustomMetricErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomMetricErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomMetricErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomMetricErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomMetricErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomMetricErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCustomMetricErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomMetricErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeCustomMetricError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomMetricErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeCustomMetricErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeCustomMetricErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCustomMetricErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeCustomMetricErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDefaultAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDefaultAuthorizerError {
    /// Kind of error that occurred.
    pub kind: DescribeDefaultAuthorizerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDefaultAuthorizer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDefaultAuthorizerErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDefaultAuthorizerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDefaultAuthorizerErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDefaultAuthorizerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDefaultAuthorizerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDefaultAuthorizerErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDefaultAuthorizerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDefaultAuthorizerErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeDefaultAuthorizerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDefaultAuthorizerError {
    fn code(&self) -> Option<&str> {
        DescribeDefaultAuthorizerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDefaultAuthorizerError {
    /// Creates a new `DescribeDefaultAuthorizerError`.
    pub fn new(kind: DescribeDefaultAuthorizerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDefaultAuthorizerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDefaultAuthorizerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDefaultAuthorizerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDefaultAuthorizerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDefaultAuthorizerErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultAuthorizerErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDefaultAuthorizerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultAuthorizerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDefaultAuthorizerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultAuthorizerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDefaultAuthorizerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultAuthorizerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDefaultAuthorizerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultAuthorizerErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDefaultAuthorizerErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDefaultAuthorizerErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeDefaultAuthorizerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDefaultAuthorizerErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDefaultAuthorizerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDefaultAuthorizerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDefaultAuthorizerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeDefaultAuthorizerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDefaultAuthorizerErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeDefaultAuthorizerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDetectMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDetectMitigationActionsTaskError {
    /// Kind of error that occurred.
    pub kind: DescribeDetectMitigationActionsTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDetectMitigationActionsTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDetectMitigationActionsTaskErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDetectMitigationActionsTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDetectMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDetectMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDetectMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDetectMitigationActionsTaskErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDetectMitigationActionsTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDetectMitigationActionsTaskError {
    fn code(&self) -> Option<&str> {
        DescribeDetectMitigationActionsTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDetectMitigationActionsTaskError {
    /// Creates a new `DescribeDetectMitigationActionsTaskError`.
    pub fn new(
        kind: DescribeDetectMitigationActionsTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDetectMitigationActionsTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDetectMitigationActionsTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDetectMitigationActionsTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDetectMitigationActionsTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDetectMitigationActionsTaskErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectMitigationActionsTaskErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDetectMitigationActionsTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectMitigationActionsTaskErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDetectMitigationActionsTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectMitigationActionsTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDetectMitigationActionsTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDetectMitigationActionsTaskErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDetectMitigationActionsTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDetectMitigationActionsTaskErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeDetectMitigationActionsTaskErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeDetectMitigationActionsTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeDetectMitigationActionsTaskErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeDetectMitigationActionsTaskErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeDimension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDimensionError {
    /// Kind of error that occurred.
    pub kind: DescribeDimensionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDimension` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDimensionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDimensionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDimensionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDimensionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDimensionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDimensionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDimensionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDimensionError {
    fn code(&self) -> Option<&str> {
        DescribeDimensionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDimensionError {
    /// Creates a new `DescribeDimensionError`.
    pub fn new(kind: DescribeDimensionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDimensionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDimensionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDimensionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDimensionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDimensionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDimensionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDimensionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDimensionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDimensionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDimensionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDimensionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDimensionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeDimensionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDimensionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDimensionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDimensionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDimensionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDimensionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomainConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomainConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainConfigurationErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainConfigurationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeDomainConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeDomainConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDomainConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeDomainConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDomainConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeDomainConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeDomainConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainConfigurationError {
    /// Creates a new `DescribeDomainConfigurationError`.
    pub fn new(kind: DescribeDomainConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDomainConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeDomainConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainConfigurationErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeDomainConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeDomainConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainConfigurationErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribeDomainConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDomainConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeDomainConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointError {
    /// Creates a new `DescribeEndpointError`.
    pub fn new(kind: DescribeEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventConfigurationsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventConfigurationsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeEventConfigurationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeEventConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeEventConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventConfigurationsError {
    /// Creates a new `DescribeEventConfigurationsError`.
    pub fn new(kind: DescribeEventConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventConfigurationsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventConfigurationsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventConfigurationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventConfigurationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeEventConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventConfigurationsErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeEventConfigurationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeEventConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleetMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetMetricError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetMetricErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleetMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetMetricErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetMetricError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetMetricErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeFleetMetricErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeFleetMetricErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetMetricErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeFleetMetricErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFleetMetricErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeFleetMetricErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetMetricError {
    fn code(&self) -> Option<&str> {
        DescribeFleetMetricError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetMetricError {
    /// Creates a new `DescribeFleetMetricError`.
    pub fn new(kind: DescribeFleetMetricErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetMetricError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetMetricErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetMetricError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetMetricErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetMetricErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetricErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetricErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetricErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetricErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetricErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetricErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetricErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetricErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetricErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFleetMetricErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetMetricErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeFleetMetricError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetMetricErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeFleetMetricErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeFleetMetricErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFleetMetricErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeFleetMetricErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFleetMetricErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeFleetMetricErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIndexError {
    /// Kind of error that occurred.
    pub kind: DescribeIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIndexErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIndexErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIndexError {
    fn code(&self) -> Option<&str> {
        DescribeIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIndexError {
    /// Creates a new `DescribeIndexError`.
    pub fn new(kind: DescribeIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIndexErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIndexErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeIndexErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeIndexErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DescribeIndexErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DescribeIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIndexErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeIndexErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeIndexErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIndexErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeIndexErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeIndexErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobError {
    /// Kind of error that occurred.
    pub kind: DescribeJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobError {
    fn code(&self) -> Option<&str> {
        DescribeJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobError {
    /// Creates a new `DescribeJobError`.
    pub fn new(kind: DescribeJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeJobErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeJobExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobExecutionErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeJobExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeJobExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobExecutionError {
    /// Creates a new `DescribeJobExecutionError`.
    pub fn new(kind: DescribeJobExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobExecutionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobExecutionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobExecutionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeJobExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeJobExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeJobTemplateError {
    /// Kind of error that occurred.
    pub kind: DescribeJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeJobTemplateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeJobTemplateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeJobTemplateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeJobTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeJobTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeJobTemplateError {
    fn code(&self) -> Option<&str> {
        DescribeJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeJobTemplateError {
    /// Creates a new `DescribeJobTemplateError`.
    pub fn new(kind: DescribeJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeJobTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobTemplateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobTemplateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeJobTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeJobTemplateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeJobTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeJobTemplateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeJobTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeJobTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeManagedJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeManagedJobTemplateError {
    /// Kind of error that occurred.
    pub kind: DescribeManagedJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeManagedJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeManagedJobTemplateErrorKind {
    /// <p>Internal error from the service that indicates an unexpected error or that the service is unavailable.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeManagedJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeManagedJobTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeManagedJobTemplateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeManagedJobTemplateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeManagedJobTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeManagedJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeManagedJobTemplateError {
    fn code(&self) -> Option<&str> {
        DescribeManagedJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeManagedJobTemplateError {
    /// Creates a new `DescribeManagedJobTemplateError`.
    pub fn new(kind: DescribeManagedJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeManagedJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeManagedJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeManagedJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeManagedJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeManagedJobTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedJobTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedJobTemplateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedJobTemplateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedJobTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedJobTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedJobTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedJobTemplateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeManagedJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeManagedJobTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeManagedJobTemplateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeManagedJobTemplateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeManagedJobTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeManagedJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMitigationAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMitigationActionError {
    /// Kind of error that occurred.
    pub kind: DescribeMitigationActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMitigationAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMitigationActionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMitigationActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMitigationActionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeMitigationActionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeMitigationActionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeMitigationActionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeMitigationActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMitigationActionError {
    fn code(&self) -> Option<&str> {
        DescribeMitigationActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMitigationActionError {
    /// Creates a new `DescribeMitigationActionError`.
    pub fn new(kind: DescribeMitigationActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMitigationActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMitigationActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMitigationActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMitigationActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMitigationActionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMitigationActionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMitigationActionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMitigationActionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMitigationActionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMitigationActionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMitigationActionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMitigationActionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeMitigationActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMitigationActionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeMitigationActionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeMitigationActionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeMitigationActionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeMitigationActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProvisioningTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProvisioningTemplateError {
    /// Kind of error that occurred.
    pub kind: DescribeProvisioningTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProvisioningTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProvisioningTemplateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProvisioningTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProvisioningTemplateErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningTemplateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeProvisioningTemplateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeProvisioningTemplateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeProvisioningTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProvisioningTemplateError {
    fn code(&self) -> Option<&str> {
        DescribeProvisioningTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProvisioningTemplateError {
    /// Creates a new `DescribeProvisioningTemplateError`.
    pub fn new(kind: DescribeProvisioningTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProvisioningTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProvisioningTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProvisioningTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProvisioningTemplateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeProvisioningTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProvisioningTemplateErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeProvisioningTemplateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeProvisioningTemplateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeProvisioningTemplateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeProvisioningTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProvisioningTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProvisioningTemplateVersionError {
    /// Kind of error that occurred.
    pub kind: DescribeProvisioningTemplateVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProvisioningTemplateVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProvisioningTemplateVersionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProvisioningTemplateVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProvisioningTemplateVersionErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningTemplateVersionErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningTemplateVersionErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningTemplateVersionErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeProvisioningTemplateVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProvisioningTemplateVersionError {
    fn code(&self) -> Option<&str> {
        DescribeProvisioningTemplateVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProvisioningTemplateVersionError {
    /// Creates a new `DescribeProvisioningTemplateVersionError`.
    pub fn new(
        kind: DescribeProvisioningTemplateVersionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProvisioningTemplateVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProvisioningTemplateVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProvisioningTemplateVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProvisioningTemplateVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeProvisioningTemplateVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProvisioningTemplateVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeProvisioningTemplateVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProvisioningTemplateVersionErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningTemplateVersionErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningTemplateVersionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningTemplateVersionErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningTemplateVersionErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            DescribeProvisioningTemplateVersionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeRoleAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRoleAliasError {
    /// Kind of error that occurred.
    pub kind: DescribeRoleAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRoleAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRoleAliasErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRoleAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRoleAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeRoleAliasErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeRoleAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRoleAliasErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeRoleAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRoleAliasErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeRoleAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRoleAliasError {
    fn code(&self) -> Option<&str> {
        DescribeRoleAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRoleAliasError {
    /// Creates a new `DescribeRoleAliasError`.
    pub fn new(kind: DescribeRoleAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRoleAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRoleAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRoleAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRoleAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRoleAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoleAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoleAliasErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoleAliasErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoleAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoleAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoleAliasErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoleAliasErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoleAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoleAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoleAliasErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoleAliasErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeRoleAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRoleAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeRoleAliasErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeRoleAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRoleAliasErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeRoleAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRoleAliasErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeRoleAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScheduledAudit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScheduledAuditError {
    /// Kind of error that occurred.
    pub kind: DescribeScheduledAuditErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScheduledAudit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScheduledAuditErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScheduledAuditError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScheduledAuditErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeScheduledAuditErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeScheduledAuditErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeScheduledAuditErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeScheduledAuditErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScheduledAuditError {
    fn code(&self) -> Option<&str> {
        DescribeScheduledAuditError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScheduledAuditError {
    /// Creates a new `DescribeScheduledAuditError`.
    pub fn new(kind: DescribeScheduledAuditErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScheduledAuditError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScheduledAuditErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScheduledAuditError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScheduledAuditErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScheduledAuditErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledAuditErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledAuditErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledAuditErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledAuditErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledAuditErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledAuditErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledAuditErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeScheduledAuditError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScheduledAuditErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeScheduledAuditErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeScheduledAuditErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeScheduledAuditErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeScheduledAuditErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: DescribeSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSecurityProfileErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSecurityProfileErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSecurityProfileError {
    fn code(&self) -> Option<&str> {
        DescribeSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSecurityProfileError {
    /// Creates a new `DescribeSecurityProfileError`.
    pub fn new(kind: DescribeSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSecurityProfileErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStreamError {
    /// Kind of error that occurred.
    pub kind: DescribeStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStreamErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStreamErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStreamError {
    fn code(&self) -> Option<&str> {
        DescribeStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStreamError {
    /// Creates a new `DescribeStreamError`.
    pub fn new(kind: DescribeStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeStreamErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeStreamErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStreamErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStreamErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeStreamErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeStreamErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeStreamErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeStreamErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThingError {
    /// Kind of error that occurred.
    pub kind: DescribeThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThingErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThingErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeThingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeThingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeThingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeThingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThingErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThingError {
    fn code(&self) -> Option<&str> {
        DescribeThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThingError {
    /// Creates a new `DescribeThingError`.
    pub fn new(kind: DescribeThingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThingErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeThingErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeThingErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DescribeThingErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DescribeThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThingErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeThingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeThingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeThingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeThingErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThingErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeThingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThingGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeThingGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeThingGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThingGroupErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThingGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThingGroupErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeThingGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeThingGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeThingGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThingGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThingGroupError {
    fn code(&self) -> Option<&str> {
        DescribeThingGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThingGroupError {
    /// Creates a new `DescribeThingGroupError`.
    pub fn new(kind: DescribeThingGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThingGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThingGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThingGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThingGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThingGroupErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingGroupErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeThingGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThingGroupErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeThingGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeThingGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeThingGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThingGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeThingRegistrationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThingRegistrationTaskError {
    /// Kind of error that occurred.
    pub kind: DescribeThingRegistrationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeThingRegistrationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThingRegistrationTaskErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThingRegistrationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThingRegistrationTaskErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            DescribeThingRegistrationTaskErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeThingRegistrationTaskErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeThingRegistrationTaskErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThingRegistrationTaskErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeThingRegistrationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThingRegistrationTaskError {
    fn code(&self) -> Option<&str> {
        DescribeThingRegistrationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThingRegistrationTaskError {
    /// Creates a new `DescribeThingRegistrationTaskError`.
    pub fn new(
        kind: DescribeThingRegistrationTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThingRegistrationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThingRegistrationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThingRegistrationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThingRegistrationTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThingRegistrationTaskErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingRegistrationTaskErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingRegistrationTaskErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingRegistrationTaskErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingRegistrationTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingRegistrationTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingRegistrationTaskErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingRegistrationTaskErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingRegistrationTaskErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingRegistrationTaskErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeThingRegistrationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThingRegistrationTaskErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            DescribeThingRegistrationTaskErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeThingRegistrationTaskErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeThingRegistrationTaskErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThingRegistrationTaskErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeThingRegistrationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeThingTypeError {
    /// Kind of error that occurred.
    pub kind: DescribeThingTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeThingType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeThingTypeErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeThingTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeThingTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DescribeThingTypeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeThingTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeThingTypeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeThingTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeThingTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DescribeThingTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeThingTypeError {
    fn code(&self) -> Option<&str> {
        DescribeThingTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeThingTypeError {
    /// Creates a new `DescribeThingTypeError`.
    pub fn new(kind: DescribeThingTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeThingTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeThingTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeThingTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeThingTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeThingTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingTypeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingTypeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingTypeErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingTypeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingTypeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeThingTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeThingTypeErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DescribeThingTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeThingTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DescribeThingTypeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeThingTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeThingTypeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeThingTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeThingTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DescribeThingTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachPolicyError {
    /// Kind of error that occurred.
    pub kind: DetachPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachPolicyErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DetachPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachPolicyError {
    fn code(&self) -> Option<&str> {
        DetachPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachPolicyError {
    /// Creates a new `DetachPolicyError`.
    pub fn new(kind: DetachPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DetachPolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DetachPolicyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DetachPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            DetachPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetachPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DetachPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DetachPolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DetachPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachPrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachPrincipalPolicyError {
    /// Kind of error that occurred.
    pub kind: DetachPrincipalPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachPrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachPrincipalPolicyErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachPrincipalPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachPrincipalPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DetachPrincipalPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetachPrincipalPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetachPrincipalPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DetachPrincipalPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DetachPrincipalPolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DetachPrincipalPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachPrincipalPolicyError {
    fn code(&self) -> Option<&str> {
        DetachPrincipalPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachPrincipalPolicyError {
    /// Creates a new `DetachPrincipalPolicyError`.
    pub fn new(kind: DetachPrincipalPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachPrincipalPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachPrincipalPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachPrincipalPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachPrincipalPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachPrincipalPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPrincipalPolicyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPrincipalPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPrincipalPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPrincipalPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPrincipalPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPrincipalPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPrincipalPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPrincipalPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPrincipalPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachPrincipalPolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachPrincipalPolicyErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DetachPrincipalPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachPrincipalPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            DetachPrincipalPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetachPrincipalPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetachPrincipalPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DetachPrincipalPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DetachPrincipalPolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DetachPrincipalPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: DetachSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachSecurityProfileErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachSecurityProfileErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DetachSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetachSecurityProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetachSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DetachSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachSecurityProfileError {
    fn code(&self) -> Option<&str> {
        DetachSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachSecurityProfileError {
    /// Creates a new `DetachSecurityProfileError`.
    pub fn new(kind: DetachSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachSecurityProfileErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachSecurityProfileErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachSecurityProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachSecurityProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DetachSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachSecurityProfileErrorKind::InternalFailureException(_inner) => Some(_inner),
            DetachSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetachSecurityProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetachSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DetachSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachThingPrincipal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachThingPrincipalError {
    /// Kind of error that occurred.
    pub kind: DetachThingPrincipalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachThingPrincipal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachThingPrincipalErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachThingPrincipalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachThingPrincipalErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DetachThingPrincipalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DetachThingPrincipalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetachThingPrincipalErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DetachThingPrincipalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DetachThingPrincipalErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DetachThingPrincipalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachThingPrincipalError {
    fn code(&self) -> Option<&str> {
        DetachThingPrincipalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachThingPrincipalError {
    /// Creates a new `DetachThingPrincipalError`.
    pub fn new(kind: DetachThingPrincipalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachThingPrincipalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachThingPrincipalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachThingPrincipalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachThingPrincipalErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachThingPrincipalErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachThingPrincipalErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachThingPrincipalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachThingPrincipalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachThingPrincipalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachThingPrincipalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachThingPrincipalErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachThingPrincipalErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachThingPrincipalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachThingPrincipalErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachThingPrincipalErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachThingPrincipalErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DetachThingPrincipalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachThingPrincipalErrorKind::InternalFailureException(_inner) => Some(_inner),
            DetachThingPrincipalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DetachThingPrincipalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetachThingPrincipalErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DetachThingPrincipalErrorKind::ThrottlingException(_inner) => Some(_inner),
            DetachThingPrincipalErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DetachThingPrincipalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableTopicRuleError {
    /// Kind of error that occurred.
    pub kind: DisableTopicRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableTopicRuleErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableTopicRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => _inner.fmt(f),
            DisableTopicRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            DisableTopicRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisableTopicRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DisableTopicRuleErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DisableTopicRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableTopicRuleError {
    fn code(&self) -> Option<&str> {
        DisableTopicRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableTopicRuleError {
    /// Creates a new `DisableTopicRuleError`.
    pub fn new(kind: DisableTopicRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableTopicRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableTopicRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableTopicRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableTopicRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableTopicRuleErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableTopicRuleErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableTopicRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DisableTopicRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DisableTopicRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableTopicRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableTopicRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableTopicRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableTopicRuleErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableTopicRuleErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DisableTopicRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => Some(_inner),
            DisableTopicRuleErrorKind::InternalException(_inner) => Some(_inner),
            DisableTopicRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisableTopicRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DisableTopicRuleErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DisableTopicRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableTopicRuleError {
    /// Kind of error that occurred.
    pub kind: EnableTopicRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableTopicRuleErrorKind {
    /// <p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>
    ConflictingResourceUpdateException(crate::error::ConflictingResourceUpdateException),
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableTopicRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => _inner.fmt(f),
            EnableTopicRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            EnableTopicRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            EnableTopicRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            EnableTopicRuleErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            EnableTopicRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableTopicRuleError {
    fn code(&self) -> Option<&str> {
        EnableTopicRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableTopicRuleError {
    /// Creates a new `EnableTopicRuleError`.
    pub fn new(kind: EnableTopicRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableTopicRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableTopicRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableTopicRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableTopicRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableTopicRuleErrorKind::ConflictingResourceUpdateException`.
    pub fn is_conflicting_resource_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableTopicRuleErrorKind::ConflictingResourceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableTopicRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, EnableTopicRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `EnableTopicRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableTopicRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableTopicRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableTopicRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableTopicRuleErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableTopicRuleErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for EnableTopicRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableTopicRuleErrorKind::ConflictingResourceUpdateException(_inner) => Some(_inner),
            EnableTopicRuleErrorKind::InternalException(_inner) => Some(_inner),
            EnableTopicRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            EnableTopicRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            EnableTopicRuleErrorKind::UnauthorizedException(_inner) => Some(_inner),
            EnableTopicRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBehaviorModelTrainingSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBehaviorModelTrainingSummariesError {
    /// Kind of error that occurred.
    pub kind: GetBehaviorModelTrainingSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBehaviorModelTrainingSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBehaviorModelTrainingSummariesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBehaviorModelTrainingSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBehaviorModelTrainingSummariesErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetBehaviorModelTrainingSummariesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            GetBehaviorModelTrainingSummariesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetBehaviorModelTrainingSummariesErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetBehaviorModelTrainingSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBehaviorModelTrainingSummariesError {
    fn code(&self) -> Option<&str> {
        GetBehaviorModelTrainingSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBehaviorModelTrainingSummariesError {
    /// Creates a new `GetBehaviorModelTrainingSummariesError`.
    pub fn new(
        kind: GetBehaviorModelTrainingSummariesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBehaviorModelTrainingSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBehaviorModelTrainingSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBehaviorModelTrainingSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBehaviorModelTrainingSummariesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBehaviorModelTrainingSummariesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBehaviorModelTrainingSummariesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBehaviorModelTrainingSummariesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBehaviorModelTrainingSummariesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBehaviorModelTrainingSummariesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBehaviorModelTrainingSummariesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBehaviorModelTrainingSummariesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBehaviorModelTrainingSummariesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetBehaviorModelTrainingSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBehaviorModelTrainingSummariesErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            GetBehaviorModelTrainingSummariesErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            GetBehaviorModelTrainingSummariesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetBehaviorModelTrainingSummariesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetBehaviorModelTrainingSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBucketsAggregation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBucketsAggregationError {
    /// Kind of error that occurred.
    pub kind: GetBucketsAggregationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBucketsAggregation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBucketsAggregationErrorKind {
    /// <p>The index is not ready.</p>
    IndexNotReadyException(crate::error::IndexNotReadyException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregationException(crate::error::InvalidAggregationException),
    /// <p>The query is invalid.</p>
    InvalidQueryException(crate::error::InvalidQueryException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBucketsAggregationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBucketsAggregationErrorKind::IndexNotReadyException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::InvalidAggregationException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::InvalidQueryException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetBucketsAggregationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBucketsAggregationError {
    fn code(&self) -> Option<&str> {
        GetBucketsAggregationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBucketsAggregationError {
    /// Creates a new `GetBucketsAggregationError`.
    pub fn new(kind: GetBucketsAggregationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBucketsAggregationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBucketsAggregationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBucketsAggregationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBucketsAggregationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::IndexNotReadyException`.
    pub fn is_index_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::IndexNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::InvalidAggregationException`.
    pub fn is_invalid_aggregation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::InvalidAggregationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::InvalidQueryException`.
    pub fn is_invalid_query_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::InvalidQueryException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketsAggregationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketsAggregationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetBucketsAggregationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBucketsAggregationErrorKind::IndexNotReadyException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::InvalidAggregationException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::InvalidQueryException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetBucketsAggregationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCardinality` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCardinalityError {
    /// Kind of error that occurred.
    pub kind: GetCardinalityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCardinality` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCardinalityErrorKind {
    /// <p>The index is not ready.</p>
    IndexNotReadyException(crate::error::IndexNotReadyException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregationException(crate::error::InvalidAggregationException),
    /// <p>The query is invalid.</p>
    InvalidQueryException(crate::error::InvalidQueryException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCardinalityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCardinalityErrorKind::IndexNotReadyException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::InvalidAggregationException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::InvalidQueryException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetCardinalityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCardinalityError {
    fn code(&self) -> Option<&str> {
        GetCardinalityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCardinalityError {
    /// Creates a new `GetCardinalityError`.
    pub fn new(kind: GetCardinalityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCardinalityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCardinalityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCardinalityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCardinalityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::IndexNotReadyException`.
    pub fn is_index_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::IndexNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::InvalidAggregationException`.
    pub fn is_invalid_aggregation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::InvalidAggregationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::InvalidQueryException`.
    pub fn is_invalid_query_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::InvalidQueryException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetCardinalityErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetCardinalityErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCardinalityErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetCardinalityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCardinalityErrorKind::IndexNotReadyException(_inner) => Some(_inner),
            GetCardinalityErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetCardinalityErrorKind::InvalidAggregationException(_inner) => Some(_inner),
            GetCardinalityErrorKind::InvalidQueryException(_inner) => Some(_inner),
            GetCardinalityErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetCardinalityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCardinalityErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetCardinalityErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCardinalityErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetCardinalityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEffectivePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEffectivePoliciesError {
    /// Kind of error that occurred.
    pub kind: GetEffectivePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEffectivePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEffectivePoliciesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEffectivePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEffectivePoliciesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetEffectivePoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetEffectivePoliciesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetEffectivePoliciesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEffectivePoliciesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetEffectivePoliciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetEffectivePoliciesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetEffectivePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEffectivePoliciesError {
    fn code(&self) -> Option<&str> {
        GetEffectivePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEffectivePoliciesError {
    /// Creates a new `GetEffectivePoliciesError`.
    pub fn new(kind: GetEffectivePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEffectivePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEffectivePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEffectivePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEffectivePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEffectivePoliciesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePoliciesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEffectivePoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEffectivePoliciesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePoliciesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEffectivePoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEffectivePoliciesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePoliciesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEffectivePoliciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePoliciesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEffectivePoliciesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEffectivePoliciesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetEffectivePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEffectivePoliciesErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetEffectivePoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetEffectivePoliciesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetEffectivePoliciesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEffectivePoliciesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetEffectivePoliciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetEffectivePoliciesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetEffectivePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIndexingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIndexingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetIndexingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIndexingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIndexingConfigurationErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIndexingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIndexingConfigurationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetIndexingConfigurationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetIndexingConfigurationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetIndexingConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetIndexingConfigurationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetIndexingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIndexingConfigurationError {
    fn code(&self) -> Option<&str> {
        GetIndexingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIndexingConfigurationError {
    /// Creates a new `GetIndexingConfigurationError`.
    pub fn new(kind: GetIndexingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIndexingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIndexingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIndexingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIndexingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIndexingConfigurationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIndexingConfigurationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIndexingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIndexingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIndexingConfigurationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIndexingConfigurationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIndexingConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIndexingConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIndexingConfigurationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIndexingConfigurationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetIndexingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIndexingConfigurationErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetIndexingConfigurationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetIndexingConfigurationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetIndexingConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetIndexingConfigurationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetIndexingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobDocumentError {
    /// Kind of error that occurred.
    pub kind: GetJobDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobDocumentErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobDocumentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetJobDocumentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetJobDocumentErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetJobDocumentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetJobDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobDocumentError {
    fn code(&self) -> Option<&str> {
        GetJobDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobDocumentError {
    /// Creates a new `GetJobDocumentError`.
    pub fn new(kind: GetJobDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobDocumentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobDocumentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobDocumentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobDocumentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobDocumentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobDocumentErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobDocumentErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobDocumentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetJobDocumentErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetJobDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobDocumentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetJobDocumentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetJobDocumentErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetJobDocumentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetJobDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoggingOptionsError {
    /// Kind of error that occurred.
    pub kind: GetLoggingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoggingOptionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoggingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoggingOptionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetLoggingOptionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetLoggingOptionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetLoggingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoggingOptionsError {
    fn code(&self) -> Option<&str> {
        GetLoggingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoggingOptionsError {
    /// Creates a new `GetLoggingOptionsError`.
    pub fn new(kind: GetLoggingOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoggingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoggingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoggingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoggingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoggingOptionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, GetLoggingOptionsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `GetLoggingOptionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingOptionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoggingOptionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingOptionsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetLoggingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoggingOptionsErrorKind::InternalException(_inner) => Some(_inner),
            GetLoggingOptionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetLoggingOptionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetLoggingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOTAUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOTAUpdateError {
    /// Kind of error that occurred.
    pub kind: GetOTAUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOTAUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOTAUpdateErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOTAUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOTAUpdateErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetOTAUpdateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetOTAUpdateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetOTAUpdateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetOTAUpdateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetOTAUpdateErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetOTAUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOTAUpdateError {
    fn code(&self) -> Option<&str> {
        GetOTAUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOTAUpdateError {
    /// Creates a new `GetOTAUpdateError`.
    pub fn new(kind: GetOTAUpdateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOTAUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOTAUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOTAUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOTAUpdateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOTAUpdateErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOTAUpdateErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOTAUpdateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOTAUpdateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOTAUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOTAUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOTAUpdateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOTAUpdateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOTAUpdateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetOTAUpdateErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetOTAUpdateErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetOTAUpdateErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetOTAUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOTAUpdateErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetOTAUpdateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetOTAUpdateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetOTAUpdateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetOTAUpdateErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetOTAUpdateErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetOTAUpdateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPercentiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPercentilesError {
    /// Kind of error that occurred.
    pub kind: GetPercentilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPercentiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPercentilesErrorKind {
    /// <p>The index is not ready.</p>
    IndexNotReadyException(crate::error::IndexNotReadyException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregationException(crate::error::InvalidAggregationException),
    /// <p>The query is invalid.</p>
    InvalidQueryException(crate::error::InvalidQueryException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPercentilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPercentilesErrorKind::IndexNotReadyException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::InvalidAggregationException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::InvalidQueryException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetPercentilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPercentilesError {
    fn code(&self) -> Option<&str> {
        GetPercentilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPercentilesError {
    /// Creates a new `GetPercentilesError`.
    pub fn new(kind: GetPercentilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPercentilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPercentilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPercentilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPercentilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::IndexNotReadyException`.
    pub fn is_index_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::IndexNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::InvalidAggregationException`.
    pub fn is_invalid_aggregation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::InvalidAggregationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::InvalidQueryException`.
    pub fn is_invalid_query_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::InvalidQueryException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetPercentilesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetPercentilesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPercentilesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetPercentilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPercentilesErrorKind::IndexNotReadyException(_inner) => Some(_inner),
            GetPercentilesErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetPercentilesErrorKind::InvalidAggregationException(_inner) => Some(_inner),
            GetPercentilesErrorKind::InvalidQueryException(_inner) => Some(_inner),
            GetPercentilesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetPercentilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPercentilesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPercentilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPercentilesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetPercentilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyError {
    fn code(&self) -> Option<&str> {
        GetPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyError {
    /// Creates a new `GetPolicyError`.
    pub fn new(kind: GetPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPolicyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyVersionError {
    /// Kind of error that occurred.
    pub kind: GetPolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyVersionErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyVersionError {
    fn code(&self) -> Option<&str> {
        GetPolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyVersionError {
    /// Creates a new `GetPolicyVersionError`.
    pub fn new(kind: GetPolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetPolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegistrationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegistrationCodeError {
    /// Kind of error that occurred.
    pub kind: GetRegistrationCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegistrationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegistrationCodeErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegistrationCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegistrationCodeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetRegistrationCodeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetRegistrationCodeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetRegistrationCodeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRegistrationCodeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetRegistrationCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegistrationCodeError {
    fn code(&self) -> Option<&str> {
        GetRegistrationCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegistrationCodeError {
    /// Creates a new `GetRegistrationCodeError`.
    pub fn new(kind: GetRegistrationCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegistrationCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegistrationCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegistrationCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegistrationCodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegistrationCodeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistrationCodeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistrationCodeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistrationCodeErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistrationCodeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistrationCodeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistrationCodeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistrationCodeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistrationCodeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistrationCodeErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetRegistrationCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegistrationCodeErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetRegistrationCodeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetRegistrationCodeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetRegistrationCodeErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRegistrationCodeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetRegistrationCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStatisticsErrorKind {
    /// <p>The index is not ready.</p>
    IndexNotReadyException(crate::error::IndexNotReadyException),
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The aggregation is invalid.</p>
    InvalidAggregationException(crate::error::InvalidAggregationException),
    /// <p>The query is invalid.</p>
    InvalidQueryException(crate::error::InvalidQueryException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStatisticsErrorKind::IndexNotReadyException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::InvalidAggregationException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::InvalidQueryException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStatisticsError {
    fn code(&self) -> Option<&str> {
        GetStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStatisticsError {
    /// Creates a new `GetStatisticsError`.
    pub fn new(kind: GetStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::IndexNotReadyException`.
    pub fn is_index_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatisticsErrorKind::IndexNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatisticsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::InvalidAggregationException`.
    pub fn is_invalid_aggregation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatisticsErrorKind::InvalidAggregationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::InvalidQueryException`.
    pub fn is_invalid_query_exception(&self) -> bool {
        matches!(&self.kind, GetStatisticsErrorKind::InvalidQueryException(_))
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatisticsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatisticsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatisticsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetStatisticsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetStatisticsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetStatisticsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStatisticsErrorKind::IndexNotReadyException(_inner) => Some(_inner),
            GetStatisticsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetStatisticsErrorKind::InvalidAggregationException(_inner) => Some(_inner),
            GetStatisticsErrorKind::InvalidQueryException(_inner) => Some(_inner),
            GetStatisticsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetStatisticsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStatisticsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetStatisticsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetStatisticsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTopicRuleError {
    /// Kind of error that occurred.
    pub kind: GetTopicRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTopicRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTopicRuleErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTopicRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTopicRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetTopicRuleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetTopicRuleErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetTopicRuleErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetTopicRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTopicRuleError {
    fn code(&self) -> Option<&str> {
        GetTopicRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTopicRuleError {
    /// Creates a new `GetTopicRuleError`.
    pub fn new(kind: GetTopicRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTopicRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTopicRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTopicRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTopicRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTopicRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, GetTopicRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `GetTopicRuleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicRuleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTopicRuleErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicRuleErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTopicRuleErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetTopicRuleErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetTopicRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTopicRuleErrorKind::InternalException(_inner) => Some(_inner),
            GetTopicRuleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetTopicRuleErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetTopicRuleErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetTopicRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTopicRuleDestinationError {
    /// Kind of error that occurred.
    pub kind: GetTopicRuleDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTopicRuleDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTopicRuleDestinationErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTopicRuleDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTopicRuleDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetTopicRuleDestinationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetTopicRuleDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTopicRuleDestinationError {
    fn code(&self) -> Option<&str> {
        GetTopicRuleDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTopicRuleDestinationError {
    /// Creates a new `GetTopicRuleDestinationError`.
    pub fn new(kind: GetTopicRuleDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTopicRuleDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTopicRuleDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTopicRuleDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTopicRuleDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTopicRuleDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicRuleDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTopicRuleDestinationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicRuleDestinationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTopicRuleDestinationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicRuleDestinationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTopicRuleDestinationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicRuleDestinationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetTopicRuleDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTopicRuleDestinationErrorKind::InternalException(_inner) => Some(_inner),
            GetTopicRuleDestinationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetTopicRuleDestinationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetTopicRuleDestinationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetTopicRuleDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetV2LoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetV2LoggingOptionsError {
    /// Kind of error that occurred.
    pub kind: GetV2LoggingOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetV2LoggingOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetV2LoggingOptionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalException(crate::error::InternalException),
    /// <p>The resource is not configured.</p>
    NotConfiguredException(crate::error::NotConfiguredException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetV2LoggingOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetV2LoggingOptionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetV2LoggingOptionsErrorKind::NotConfiguredException(_inner) => _inner.fmt(f),
            GetV2LoggingOptionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetV2LoggingOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetV2LoggingOptionsError {
    fn code(&self) -> Option<&str> {
        GetV2LoggingOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetV2LoggingOptionsError {
    /// Creates a new `GetV2LoggingOptionsError`.
    pub fn new(kind: GetV2LoggingOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetV2LoggingOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetV2LoggingOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetV2LoggingOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetV2LoggingOptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetV2LoggingOptionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetV2LoggingOptionsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetV2LoggingOptionsErrorKind::NotConfiguredException`.
    pub fn is_not_configured_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetV2LoggingOptionsErrorKind::NotConfiguredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetV2LoggingOptionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetV2LoggingOptionsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetV2LoggingOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetV2LoggingOptionsErrorKind::InternalException(_inner) => Some(_inner),
            GetV2LoggingOptionsErrorKind::NotConfiguredException(_inner) => Some(_inner),
            GetV2LoggingOptionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetV2LoggingOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListActiveViolations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListActiveViolationsError {
    /// Kind of error that occurred.
    pub kind: ListActiveViolationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListActiveViolations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListActiveViolationsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListActiveViolationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListActiveViolationsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListActiveViolationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListActiveViolationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListActiveViolationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListActiveViolationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListActiveViolationsError {
    fn code(&self) -> Option<&str> {
        ListActiveViolationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListActiveViolationsError {
    /// Creates a new `ListActiveViolationsError`.
    pub fn new(kind: ListActiveViolationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListActiveViolationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListActiveViolationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListActiveViolationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListActiveViolationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListActiveViolationsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActiveViolationsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActiveViolationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActiveViolationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActiveViolationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActiveViolationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActiveViolationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActiveViolationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListActiveViolationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListActiveViolationsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListActiveViolationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListActiveViolationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListActiveViolationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListActiveViolationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttachedPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttachedPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListAttachedPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttachedPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttachedPoliciesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A limit has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttachedPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttachedPoliciesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAttachedPoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAttachedPoliciesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListAttachedPoliciesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAttachedPoliciesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAttachedPoliciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAttachedPoliciesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListAttachedPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttachedPoliciesError {
    fn code(&self) -> Option<&str> {
        ListAttachedPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttachedPoliciesError {
    /// Creates a new `ListAttachedPoliciesError`.
    pub fn new(kind: ListAttachedPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttachedPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttachedPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttachedPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttachedPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttachedPoliciesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedPoliciesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedPoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedPoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedPoliciesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedPoliciesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedPoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedPoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedPoliciesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedPoliciesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedPoliciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedPoliciesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedPoliciesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedPoliciesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListAttachedPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttachedPoliciesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAttachedPoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAttachedPoliciesErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListAttachedPoliciesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAttachedPoliciesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAttachedPoliciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAttachedPoliciesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListAttachedPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAuditFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAuditFindingsError {
    /// Kind of error that occurred.
    pub kind: ListAuditFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAuditFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAuditFindingsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAuditFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAuditFindingsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAuditFindingsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAuditFindingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAuditFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAuditFindingsError {
    fn code(&self) -> Option<&str> {
        ListAuditFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAuditFindingsError {
    /// Creates a new `ListAuditFindingsError`.
    pub fn new(kind: ListAuditFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAuditFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAuditFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAuditFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAuditFindingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAuditFindingsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditFindingsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditFindingsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditFindingsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditFindingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditFindingsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAuditFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAuditFindingsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAuditFindingsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAuditFindingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAuditFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAuditMitigationActionsExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAuditMitigationActionsExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListAuditMitigationActionsExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAuditMitigationActionsExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAuditMitigationActionsExecutionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAuditMitigationActionsExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAuditMitigationActionsExecutionsErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListAuditMitigationActionsExecutionsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListAuditMitigationActionsExecutionsErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListAuditMitigationActionsExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAuditMitigationActionsExecutionsError {
    fn code(&self) -> Option<&str> {
        ListAuditMitigationActionsExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAuditMitigationActionsExecutionsError {
    /// Creates a new `ListAuditMitigationActionsExecutionsError`.
    pub fn new(
        kind: ListAuditMitigationActionsExecutionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAuditMitigationActionsExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAuditMitigationActionsExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAuditMitigationActionsExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAuditMitigationActionsExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAuditMitigationActionsExecutionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditMitigationActionsExecutionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditMitigationActionsExecutionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditMitigationActionsExecutionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditMitigationActionsExecutionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditMitigationActionsExecutionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAuditMitigationActionsExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAuditMitigationActionsExecutionsErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            ListAuditMitigationActionsExecutionsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListAuditMitigationActionsExecutionsErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListAuditMitigationActionsExecutionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListAuditMitigationActionsTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAuditMitigationActionsTasksError {
    /// Kind of error that occurred.
    pub kind: ListAuditMitigationActionsTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAuditMitigationActionsTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAuditMitigationActionsTasksErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAuditMitigationActionsTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAuditMitigationActionsTasksErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListAuditMitigationActionsTasksErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListAuditMitigationActionsTasksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAuditMitigationActionsTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAuditMitigationActionsTasksError {
    fn code(&self) -> Option<&str> {
        ListAuditMitigationActionsTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAuditMitigationActionsTasksError {
    /// Creates a new `ListAuditMitigationActionsTasksError`.
    pub fn new(
        kind: ListAuditMitigationActionsTasksErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAuditMitigationActionsTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAuditMitigationActionsTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAuditMitigationActionsTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAuditMitigationActionsTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAuditMitigationActionsTasksErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditMitigationActionsTasksErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditMitigationActionsTasksErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditMitigationActionsTasksErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditMitigationActionsTasksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditMitigationActionsTasksErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAuditMitigationActionsTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAuditMitigationActionsTasksErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            ListAuditMitigationActionsTasksErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListAuditMitigationActionsTasksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAuditMitigationActionsTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAuditSuppressions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAuditSuppressionsError {
    /// Kind of error that occurred.
    pub kind: ListAuditSuppressionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAuditSuppressions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAuditSuppressionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAuditSuppressionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAuditSuppressionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAuditSuppressionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAuditSuppressionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAuditSuppressionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAuditSuppressionsError {
    fn code(&self) -> Option<&str> {
        ListAuditSuppressionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAuditSuppressionsError {
    /// Creates a new `ListAuditSuppressionsError`.
    pub fn new(kind: ListAuditSuppressionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAuditSuppressionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAuditSuppressionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAuditSuppressionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAuditSuppressionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAuditSuppressionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditSuppressionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditSuppressionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditSuppressionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditSuppressionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditSuppressionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAuditSuppressionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAuditSuppressionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAuditSuppressionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAuditSuppressionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAuditSuppressionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAuditTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAuditTasksError {
    /// Kind of error that occurred.
    pub kind: ListAuditTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAuditTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAuditTasksErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAuditTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAuditTasksErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAuditTasksErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAuditTasksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAuditTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAuditTasksError {
    fn code(&self) -> Option<&str> {
        ListAuditTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAuditTasksError {
    /// Creates a new `ListAuditTasksError`.
    pub fn new(kind: ListAuditTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAuditTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAuditTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAuditTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAuditTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAuditTasksErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditTasksErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditTasksErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuditTasksErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuditTasksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAuditTasksErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListAuditTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAuditTasksErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAuditTasksErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAuditTasksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAuditTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAuthorizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAuthorizersError {
    /// Kind of error that occurred.
    pub kind: ListAuthorizersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAuthorizers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAuthorizersErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAuthorizersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAuthorizersErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListAuthorizersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAuthorizersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAuthorizersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAuthorizersErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListAuthorizersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAuthorizersError {
    fn code(&self) -> Option<&str> {
        ListAuthorizersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAuthorizersError {
    /// Creates a new `ListAuthorizersError`.
    pub fn new(kind: ListAuthorizersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAuthorizersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAuthorizersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAuthorizersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAuthorizersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAuthorizersErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuthorizersErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuthorizersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuthorizersErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuthorizersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuthorizersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAuthorizersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAuthorizersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListAuthorizersErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAuthorizersErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListAuthorizersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAuthorizersErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListAuthorizersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAuthorizersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAuthorizersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAuthorizersErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListAuthorizersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBillingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBillingGroupsError {
    /// Kind of error that occurred.
    pub kind: ListBillingGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBillingGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBillingGroupsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBillingGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBillingGroupsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBillingGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBillingGroupsError {
    fn code(&self) -> Option<&str> {
        ListBillingGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBillingGroupsError {
    /// Creates a new `ListBillingGroupsError`.
    pub fn new(kind: ListBillingGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBillingGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBillingGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBillingGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBillingGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBillingGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBillingGroupsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListBillingGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBillingGroupsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBillingGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCACertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCACertificatesError {
    /// Kind of error that occurred.
    pub kind: ListCACertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCACertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCACertificatesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCACertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCACertificatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListCACertificatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListCACertificatesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListCACertificatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCACertificatesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListCACertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCACertificatesError {
    fn code(&self) -> Option<&str> {
        ListCACertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCACertificatesError {
    /// Creates a new `ListCACertificatesError`.
    pub fn new(kind: ListCACertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCACertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCACertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCACertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCACertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCACertificatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCACertificatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCACertificatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCACertificatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCACertificatesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCACertificatesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCACertificatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCACertificatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCACertificatesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCACertificatesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListCACertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCACertificatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListCACertificatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListCACertificatesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListCACertificatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCACertificatesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListCACertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCertificatesError {
    /// Kind of error that occurred.
    pub kind: ListCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCertificatesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCertificatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCertificatesError {
    fn code(&self) -> Option<&str> {
        ListCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCertificatesError {
    /// Creates a new `ListCertificatesError`.
    pub fn new(kind: ListCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCertificatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListCertificatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListCertificatesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListCertificatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCertificatesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCertificatesByCA` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCertificatesByCAError {
    /// Kind of error that occurred.
    pub kind: ListCertificatesByCAErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCertificatesByCA` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCertificatesByCAErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCertificatesByCAError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCertificatesByCAErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListCertificatesByCAErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListCertificatesByCAErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListCertificatesByCAErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCertificatesByCAErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListCertificatesByCAErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCertificatesByCAError {
    fn code(&self) -> Option<&str> {
        ListCertificatesByCAError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCertificatesByCAError {
    /// Creates a new `ListCertificatesByCAError`.
    pub fn new(kind: ListCertificatesByCAErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCertificatesByCAError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCertificatesByCAErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCertificatesByCAError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCertificatesByCAErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCertificatesByCAErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesByCAErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesByCAErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesByCAErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesByCAErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesByCAErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesByCAErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesByCAErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCertificatesByCAErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCertificatesByCAErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListCertificatesByCAError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCertificatesByCAErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListCertificatesByCAErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListCertificatesByCAErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListCertificatesByCAErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCertificatesByCAErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListCertificatesByCAErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomMetricsError {
    /// Kind of error that occurred.
    pub kind: ListCustomMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomMetricsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomMetricsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListCustomMetricsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListCustomMetricsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCustomMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomMetricsError {
    fn code(&self) -> Option<&str> {
        ListCustomMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomMetricsError {
    /// Creates a new `ListCustomMetricsError`.
    pub fn new(kind: ListCustomMetricsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomMetricsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCustomMetricsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomMetricsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomMetricsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomMetricsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomMetricsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomMetricsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListCustomMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomMetricsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListCustomMetricsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListCustomMetricsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCustomMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDetectMitigationActionsExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDetectMitigationActionsExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListDetectMitigationActionsExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDetectMitigationActionsExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDetectMitigationActionsExecutionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDetectMitigationActionsExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDetectMitigationActionsExecutionsErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListDetectMitigationActionsExecutionsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListDetectMitigationActionsExecutionsErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListDetectMitigationActionsExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDetectMitigationActionsExecutionsError {
    fn code(&self) -> Option<&str> {
        ListDetectMitigationActionsExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDetectMitigationActionsExecutionsError {
    /// Creates a new `ListDetectMitigationActionsExecutionsError`.
    pub fn new(
        kind: ListDetectMitigationActionsExecutionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDetectMitigationActionsExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDetectMitigationActionsExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDetectMitigationActionsExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDetectMitigationActionsExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDetectMitigationActionsExecutionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectMitigationActionsExecutionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectMitigationActionsExecutionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectMitigationActionsExecutionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectMitigationActionsExecutionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectMitigationActionsExecutionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListDetectMitigationActionsExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDetectMitigationActionsExecutionsErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            ListDetectMitigationActionsExecutionsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListDetectMitigationActionsExecutionsErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListDetectMitigationActionsExecutionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListDetectMitigationActionsTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDetectMitigationActionsTasksError {
    /// Kind of error that occurred.
    pub kind: ListDetectMitigationActionsTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDetectMitigationActionsTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDetectMitigationActionsTasksErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDetectMitigationActionsTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDetectMitigationActionsTasksErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListDetectMitigationActionsTasksErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListDetectMitigationActionsTasksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDetectMitigationActionsTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDetectMitigationActionsTasksError {
    fn code(&self) -> Option<&str> {
        ListDetectMitigationActionsTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDetectMitigationActionsTasksError {
    /// Creates a new `ListDetectMitigationActionsTasksError`.
    pub fn new(
        kind: ListDetectMitigationActionsTasksErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDetectMitigationActionsTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDetectMitigationActionsTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDetectMitigationActionsTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDetectMitigationActionsTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDetectMitigationActionsTasksErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectMitigationActionsTasksErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectMitigationActionsTasksErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectMitigationActionsTasksErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDetectMitigationActionsTasksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectMitigationActionsTasksErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListDetectMitigationActionsTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDetectMitigationActionsTasksErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            ListDetectMitigationActionsTasksErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListDetectMitigationActionsTasksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDetectMitigationActionsTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDimensions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDimensionsError {
    /// Kind of error that occurred.
    pub kind: ListDimensionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDimensions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDimensionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDimensionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDimensionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDimensionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDimensionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDimensionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDimensionsError {
    fn code(&self) -> Option<&str> {
        ListDimensionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDimensionsError {
    /// Creates a new `ListDimensionsError`.
    pub fn new(kind: ListDimensionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDimensionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDimensionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDimensionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDimensionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDimensionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDimensionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDimensionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDimensionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDimensionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDimensionsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDimensionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDimensionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDimensionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDimensionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDimensionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomainConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListDomainConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomainConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainConfigurationsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainConfigurationsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDomainConfigurationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDomainConfigurationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListDomainConfigurationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDomainConfigurationsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListDomainConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListDomainConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainConfigurationsError {
    /// Creates a new `ListDomainConfigurationsError`.
    pub fn new(kind: ListDomainConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainConfigurationsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainConfigurationsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainConfigurationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainConfigurationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainConfigurationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainConfigurationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainConfigurationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainConfigurationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDomainConfigurationsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainConfigurationsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListDomainConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainConfigurationsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDomainConfigurationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDomainConfigurationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListDomainConfigurationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDomainConfigurationsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListDomainConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFleetMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFleetMetricsError {
    /// Kind of error that occurred.
    pub kind: ListFleetMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFleetMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFleetMetricsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFleetMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFleetMetricsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListFleetMetricsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListFleetMetricsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListFleetMetricsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFleetMetricsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListFleetMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFleetMetricsError {
    fn code(&self) -> Option<&str> {
        ListFleetMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFleetMetricsError {
    /// Creates a new `ListFleetMetricsError`.
    pub fn new(kind: ListFleetMetricsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFleetMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFleetMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFleetMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFleetMetricsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFleetMetricsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFleetMetricsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFleetMetricsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFleetMetricsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFleetMetricsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFleetMetricsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFleetMetricsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFleetMetricsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFleetMetricsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFleetMetricsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListFleetMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFleetMetricsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListFleetMetricsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListFleetMetricsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListFleetMetricsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFleetMetricsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListFleetMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIndices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIndicesError {
    /// Kind of error that occurred.
    pub kind: ListIndicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIndices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIndicesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIndicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIndicesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListIndicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIndicesError {
    fn code(&self) -> Option<&str> {
        ListIndicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIndicesError {
    /// Creates a new `ListIndicesError`.
    pub fn new(kind: ListIndicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIndicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIndicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIndicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIndicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIndicesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListIndicesErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIndicesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListIndicesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListIndicesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListIndicesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListIndicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIndicesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListIndicesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListIndicesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListIndicesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIndicesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListIndicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobExecutionsForJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobExecutionsForJobError {
    /// Kind of error that occurred.
    pub kind: ListJobExecutionsForJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobExecutionsForJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobExecutionsForJobErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobExecutionsForJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobExecutionsForJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListJobExecutionsForJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListJobExecutionsForJobErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListJobExecutionsForJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListJobExecutionsForJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobExecutionsForJobError {
    fn code(&self) -> Option<&str> {
        ListJobExecutionsForJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobExecutionsForJobError {
    /// Creates a new `ListJobExecutionsForJobError`.
    pub fn new(kind: ListJobExecutionsForJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobExecutionsForJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobExecutionsForJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobExecutionsForJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobExecutionsForJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForJobErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForJobErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForJobErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListJobExecutionsForJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobExecutionsForJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListJobExecutionsForJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListJobExecutionsForJobErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListJobExecutionsForJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListJobExecutionsForJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobExecutionsForThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobExecutionsForThingError {
    /// Kind of error that occurred.
    pub kind: ListJobExecutionsForThingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobExecutionsForThing` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobExecutionsForThingErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobExecutionsForThingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobExecutionsForThingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListJobExecutionsForThingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListJobExecutionsForThingErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListJobExecutionsForThingErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListJobExecutionsForThingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobExecutionsForThingError {
    fn code(&self) -> Option<&str> {
        ListJobExecutionsForThingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobExecutionsForThingError {
    /// Creates a new `ListJobExecutionsForThingError`.
    pub fn new(kind: ListJobExecutionsForThingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobExecutionsForThingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobExecutionsForThingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobExecutionsForThingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobExecutionsForThingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForThingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForThingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForThingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForThingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForThingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForThingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobExecutionsForThingErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobExecutionsForThingErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListJobExecutionsForThingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobExecutionsForThingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListJobExecutionsForThingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListJobExecutionsForThingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListJobExecutionsForThingErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListJobExecutionsForThingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListJobsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListJobTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobTemplatesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobTemplatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobTemplatesError {
    fn code(&self) -> Option<&str> {
        ListJobTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobTemplatesError {
    /// Creates a new `ListJobTemplatesError`.
    pub fn new(kind: ListJobTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobTemplatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobTemplatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobTemplatesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListJobTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobTemplatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListManagedJobTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListManagedJobTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListManagedJobTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListManagedJobTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListManagedJobTemplatesErrorKind {
    /// <p>Internal error from the service that indicates an unexpected error or that the service is unavailable.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListManagedJobTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListManagedJobTemplatesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListManagedJobTemplatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListManagedJobTemplatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListManagedJobTemplatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListManagedJobTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListManagedJobTemplatesError {
    fn code(&self) -> Option<&str> {
        ListManagedJobTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListManagedJobTemplatesError {
    /// Creates a new `ListManagedJobTemplatesError`.
    pub fn new(kind: ListManagedJobTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListManagedJobTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListManagedJobTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListManagedJobTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListManagedJobTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListManagedJobTemplatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedJobTemplatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedJobTemplatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedJobTemplatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedJobTemplatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedJobTemplatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedJobTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedJobTemplatesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListManagedJobTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListManagedJobTemplatesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListManagedJobTemplatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListManagedJobTemplatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListManagedJobTemplatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListManagedJobTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMetricValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMetricValuesError {
    /// Kind of error that occurred.
    pub kind: ListMetricValuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMetricValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMetricValuesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMetricValuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMetricValuesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListMetricValuesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListMetricValuesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMetricValuesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMetricValuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMetricValuesError {
    fn code(&self) -> Option<&str> {
        ListMetricValuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMetricValuesError {
    /// Creates a new `ListMetricValuesError`.
    pub fn new(kind: ListMetricValuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMetricValuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMetricValuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMetricValuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMetricValuesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMetricValuesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricValuesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricValuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricValuesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricValuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricValuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricValuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricValuesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListMetricValuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMetricValuesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListMetricValuesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListMetricValuesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMetricValuesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMetricValuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMitigationActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMitigationActionsError {
    /// Kind of error that occurred.
    pub kind: ListMitigationActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMitigationActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMitigationActionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMitigationActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMitigationActionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListMitigationActionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListMitigationActionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMitigationActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMitigationActionsError {
    fn code(&self) -> Option<&str> {
        ListMitigationActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMitigationActionsError {
    /// Creates a new `ListMitigationActionsError`.
    pub fn new(kind: ListMitigationActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMitigationActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMitigationActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMitigationActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMitigationActionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMitigationActionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMitigationActionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMitigationActionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMitigationActionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMitigationActionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMitigationActionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListMitigationActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMitigationActionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListMitigationActionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListMitigationActionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMitigationActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOTAUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOTAUpdatesError {
    /// Kind of error that occurred.
    pub kind: ListOTAUpdatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOTAUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOTAUpdatesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOTAUpdatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOTAUpdatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListOTAUpdatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListOTAUpdatesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListOTAUpdatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListOTAUpdatesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListOTAUpdatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOTAUpdatesError {
    fn code(&self) -> Option<&str> {
        ListOTAUpdatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOTAUpdatesError {
    /// Creates a new `ListOTAUpdatesError`.
    pub fn new(kind: ListOTAUpdatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOTAUpdatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOTAUpdatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOTAUpdatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOTAUpdatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOTAUpdatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOTAUpdatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOTAUpdatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOTAUpdatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOTAUpdatesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOTAUpdatesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOTAUpdatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListOTAUpdatesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListOTAUpdatesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOTAUpdatesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListOTAUpdatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOTAUpdatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListOTAUpdatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListOTAUpdatesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListOTAUpdatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListOTAUpdatesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListOTAUpdatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOutgoingCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOutgoingCertificatesError {
    /// Kind of error that occurred.
    pub kind: ListOutgoingCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOutgoingCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOutgoingCertificatesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOutgoingCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOutgoingCertificatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListOutgoingCertificatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListOutgoingCertificatesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListOutgoingCertificatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListOutgoingCertificatesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListOutgoingCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOutgoingCertificatesError {
    fn code(&self) -> Option<&str> {
        ListOutgoingCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOutgoingCertificatesError {
    /// Creates a new `ListOutgoingCertificatesError`.
    pub fn new(kind: ListOutgoingCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOutgoingCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOutgoingCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOutgoingCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOutgoingCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOutgoingCertificatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingCertificatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOutgoingCertificatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingCertificatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOutgoingCertificatesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingCertificatesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOutgoingCertificatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingCertificatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOutgoingCertificatesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOutgoingCertificatesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListOutgoingCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOutgoingCertificatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListOutgoingCertificatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListOutgoingCertificatesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListOutgoingCertificatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListOutgoingCertificatesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListOutgoingCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPoliciesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPoliciesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPoliciesError {
    fn code(&self) -> Option<&str> {
        ListPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPoliciesError {
    /// Creates a new `ListPoliciesError`.
    pub fn new(kind: ListPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListPoliciesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListPoliciesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPoliciesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListPoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPoliciesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPoliciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPoliciesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicyPrincipals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPolicyPrincipalsError {
    /// Kind of error that occurred.
    pub kind: ListPolicyPrincipalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicyPrincipals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPolicyPrincipalsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPolicyPrincipalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPolicyPrincipalsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListPolicyPrincipalsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPolicyPrincipalsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPolicyPrincipalsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPolicyPrincipalsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPolicyPrincipalsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListPolicyPrincipalsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPolicyPrincipalsError {
    fn code(&self) -> Option<&str> {
        ListPolicyPrincipalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPolicyPrincipalsError {
    /// Creates a new `ListPolicyPrincipalsError`.
    pub fn new(kind: ListPolicyPrincipalsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPolicyPrincipalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPolicyPrincipalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPolicyPrincipalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPolicyPrincipalsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPolicyPrincipalsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyPrincipalsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyPrincipalsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyPrincipalsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyPrincipalsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyPrincipalsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyPrincipalsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyPrincipalsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyPrincipalsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyPrincipalsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyPrincipalsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyPrincipalsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListPolicyPrincipalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPolicyPrincipalsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListPolicyPrincipalsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPolicyPrincipalsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPolicyPrincipalsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPolicyPrincipalsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPolicyPrincipalsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListPolicyPrincipalsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPolicyVersionsError {
    /// Kind of error that occurred.
    pub kind: ListPolicyVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPolicyVersionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPolicyVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPolicyVersionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPolicyVersionsError {
    fn code(&self) -> Option<&str> {
        ListPolicyVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPolicyVersionsError {
    /// Creates a new `ListPolicyVersionsError`.
    pub fn new(kind: ListPolicyVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPolicyVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPolicyVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPolicyVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPolicyVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListPolicyVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPolicyVersionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPrincipalPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPrincipalPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListPrincipalPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPrincipalPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPrincipalPoliciesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPrincipalPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPrincipalPoliciesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListPrincipalPoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPrincipalPoliciesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPrincipalPoliciesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPrincipalPoliciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPrincipalPoliciesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListPrincipalPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPrincipalPoliciesError {
    fn code(&self) -> Option<&str> {
        ListPrincipalPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPrincipalPoliciesError {
    /// Creates a new `ListPrincipalPoliciesError`.
    pub fn new(kind: ListPrincipalPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPrincipalPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPrincipalPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPrincipalPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPrincipalPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPrincipalPoliciesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalPoliciesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalPoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalPoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalPoliciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalPoliciesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalPoliciesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalPoliciesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalPoliciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalPoliciesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalPoliciesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalPoliciesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListPrincipalPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPrincipalPoliciesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListPrincipalPoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPrincipalPoliciesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPrincipalPoliciesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPrincipalPoliciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPrincipalPoliciesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListPrincipalPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPrincipalThings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPrincipalThingsError {
    /// Kind of error that occurred.
    pub kind: ListPrincipalThingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPrincipalThings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPrincipalThingsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPrincipalThingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPrincipalThingsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListPrincipalThingsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPrincipalThingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPrincipalThingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListPrincipalThingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPrincipalThingsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListPrincipalThingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPrincipalThingsError {
    fn code(&self) -> Option<&str> {
        ListPrincipalThingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPrincipalThingsError {
    /// Creates a new `ListPrincipalThingsError`.
    pub fn new(kind: ListPrincipalThingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPrincipalThingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPrincipalThingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPrincipalThingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPrincipalThingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPrincipalThingsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalThingsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalThingsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalThingsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalThingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalThingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalThingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalThingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalThingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalThingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPrincipalThingsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPrincipalThingsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListPrincipalThingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPrincipalThingsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListPrincipalThingsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPrincipalThingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPrincipalThingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListPrincipalThingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPrincipalThingsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListPrincipalThingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProvisioningTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProvisioningTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListProvisioningTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProvisioningTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProvisioningTemplatesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProvisioningTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProvisioningTemplatesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListProvisioningTemplatesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListProvisioningTemplatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProvisioningTemplatesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListProvisioningTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProvisioningTemplatesError {
    fn code(&self) -> Option<&str> {
        ListProvisioningTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProvisioningTemplatesError {
    /// Creates a new `ListProvisioningTemplatesError`.
    pub fn new(kind: ListProvisioningTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProvisioningTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProvisioningTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProvisioningTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProvisioningTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplatesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplatesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplatesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplatesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplatesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplatesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListProvisioningTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProvisioningTemplatesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListProvisioningTemplatesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListProvisioningTemplatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProvisioningTemplatesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListProvisioningTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProvisioningTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProvisioningTemplateVersionsError {
    /// Kind of error that occurred.
    pub kind: ListProvisioningTemplateVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProvisioningTemplateVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProvisioningTemplateVersionsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProvisioningTemplateVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProvisioningTemplateVersionsErrorKind::InternalFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisioningTemplateVersionsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisioningTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisioningTemplateVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProvisioningTemplateVersionsErrorKind::UnauthorizedException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisioningTemplateVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProvisioningTemplateVersionsError {
    fn code(&self) -> Option<&str> {
        ListProvisioningTemplateVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProvisioningTemplateVersionsError {
    /// Creates a new `ListProvisioningTemplateVersionsError`.
    pub fn new(
        kind: ListProvisioningTemplateVersionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProvisioningTemplateVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProvisioningTemplateVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProvisioningTemplateVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProvisioningTemplateVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplateVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplateVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplateVersionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplateVersionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplateVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplateVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplateVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplateVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisioningTemplateVersionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisioningTemplateVersionsErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListProvisioningTemplateVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProvisioningTemplateVersionsErrorKind::InternalFailureException(_inner) => {
                Some(_inner)
            }
            ListProvisioningTemplateVersionsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListProvisioningTemplateVersionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListProvisioningTemplateVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProvisioningTemplateVersionsErrorKind::UnauthorizedException(_inner) => {
                Some(_inner)
            }
            ListProvisioningTemplateVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoleAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoleAliasesError {
    /// Kind of error that occurred.
    pub kind: ListRoleAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoleAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoleAliasesErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The service is temporarily unavailable.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The rate exceeds the limit.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoleAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoleAliasesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListRoleAliasesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListRoleAliasesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListRoleAliasesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRoleAliasesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListRoleAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoleAliasesError {
    fn code(&self) -> Option<&str> {
        ListRoleAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoleAliasesError {
    /// Creates a new `ListRoleAliasesError`.
    pub fn new(kind: ListRoleAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoleAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoleAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoleAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoleAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoleAliasesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoleAliasesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoleAliasesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoleAliasesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoleAliasesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoleAliasesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoleAliasesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListRoleAliasesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListRoleAliasesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoleAliasesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListRoleAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoleAliasesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListRoleAliasesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListRoleAliasesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListRoleAliasesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRoleAliasesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListRoleAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListScheduledAudits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListScheduledAuditsError {
    /// Kind of error that occurred.
    pub kind: ListScheduledAuditsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListScheduledAudits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListScheduledAuditsErrorKind {
    /// <p>An unexpected error has occurred.</p>
    InternalFailureException