// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptCertificateTransfer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_certificate_transfer`](crate::client::Client::accept_certificate_transfer).
///
/// See [`crate::client::fluent_builders::AcceptCertificateTransfer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptCertificateTransfer {
    _private: (),
}
impl AcceptCertificateTransfer {
    /// Creates a new builder-style object to manufacture [`AcceptCertificateTransferInput`](crate::input::AcceptCertificateTransferInput)
    pub fn builder() -> crate::input::accept_certificate_transfer_input::Builder {
        crate::input::accept_certificate_transfer_input::Builder::default()
    }
    /// Creates a new `AcceptCertificateTransfer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptCertificateTransfer {
    type Output = std::result::Result<
        crate::output::AcceptCertificateTransferOutput,
        crate::error::AcceptCertificateTransferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_certificate_transfer_error(response)
        } else {
            crate::operation_deser::parse_accept_certificate_transfer_response(response)
        }
    }
}

/// Operation shape for `AddThingToBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_thing_to_billing_group`](crate::client::Client::add_thing_to_billing_group).
///
/// See [`crate::client::fluent_builders::AddThingToBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddThingToBillingGroup {
    _private: (),
}
impl AddThingToBillingGroup {
    /// Creates a new builder-style object to manufacture [`AddThingToBillingGroupInput`](crate::input::AddThingToBillingGroupInput)
    pub fn builder() -> crate::input::add_thing_to_billing_group_input::Builder {
        crate::input::add_thing_to_billing_group_input::Builder::default()
    }
    /// Creates a new `AddThingToBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddThingToBillingGroup {
    type Output = std::result::Result<
        crate::output::AddThingToBillingGroupOutput,
        crate::error::AddThingToBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_thing_to_billing_group_error(response)
        } else {
            crate::operation_deser::parse_add_thing_to_billing_group_response(response)
        }
    }
}

/// Operation shape for `AddThingToThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_thing_to_thing_group`](crate::client::Client::add_thing_to_thing_group).
///
/// See [`crate::client::fluent_builders::AddThingToThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddThingToThingGroup {
    _private: (),
}
impl AddThingToThingGroup {
    /// Creates a new builder-style object to manufacture [`AddThingToThingGroupInput`](crate::input::AddThingToThingGroupInput)
    pub fn builder() -> crate::input::add_thing_to_thing_group_input::Builder {
        crate::input::add_thing_to_thing_group_input::Builder::default()
    }
    /// Creates a new `AddThingToThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddThingToThingGroup {
    type Output = std::result::Result<
        crate::output::AddThingToThingGroupOutput,
        crate::error::AddThingToThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_thing_to_thing_group_error(response)
        } else {
            crate::operation_deser::parse_add_thing_to_thing_group_response(response)
        }
    }
}

/// Operation shape for `AssociateTargetsWithJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_targets_with_job`](crate::client::Client::associate_targets_with_job).
///
/// See [`crate::client::fluent_builders::AssociateTargetsWithJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTargetsWithJob {
    _private: (),
}
impl AssociateTargetsWithJob {
    /// Creates a new builder-style object to manufacture [`AssociateTargetsWithJobInput`](crate::input::AssociateTargetsWithJobInput)
    pub fn builder() -> crate::input::associate_targets_with_job_input::Builder {
        crate::input::associate_targets_with_job_input::Builder::default()
    }
    /// Creates a new `AssociateTargetsWithJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTargetsWithJob {
    type Output = std::result::Result<
        crate::output::AssociateTargetsWithJobOutput,
        crate::error::AssociateTargetsWithJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_targets_with_job_error(response)
        } else {
            crate::operation_deser::parse_associate_targets_with_job_response(response)
        }
    }
}

/// Operation shape for `AttachPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_policy`](crate::client::Client::attach_policy).
///
/// See [`crate::client::fluent_builders::AttachPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachPolicy {
    _private: (),
}
impl AttachPolicy {
    /// Creates a new builder-style object to manufacture [`AttachPolicyInput`](crate::input::AttachPolicyInput)
    pub fn builder() -> crate::input::attach_policy_input::Builder {
        crate::input::attach_policy_input::Builder::default()
    }
    /// Creates a new `AttachPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachPolicy {
    type Output =
        std::result::Result<crate::output::AttachPolicyOutput, crate::error::AttachPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_policy_error(response)
        } else {
            crate::operation_deser::parse_attach_policy_response(response)
        }
    }
}

/// Operation shape for `AttachPrincipalPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_principal_policy`](crate::client::Client::attach_principal_policy).
///
/// See [`crate::client::fluent_builders::AttachPrincipalPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachPrincipalPolicy {
    _private: (),
}
impl AttachPrincipalPolicy {
    /// Creates a new builder-style object to manufacture [`AttachPrincipalPolicyInput`](crate::input::AttachPrincipalPolicyInput)
    pub fn builder() -> crate::input::attach_principal_policy_input::Builder {
        crate::input::attach_principal_policy_input::Builder::default()
    }
    /// Creates a new `AttachPrincipalPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachPrincipalPolicy {
    type Output = std::result::Result<
        crate::output::AttachPrincipalPolicyOutput,
        crate::error::AttachPrincipalPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_principal_policy_error(response)
        } else {
            crate::operation_deser::parse_attach_principal_policy_response(response)
        }
    }
}

/// Operation shape for `AttachSecurityProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_security_profile`](crate::client::Client::attach_security_profile).
///
/// See [`crate::client::fluent_builders::AttachSecurityProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachSecurityProfile {
    _private: (),
}
impl AttachSecurityProfile {
    /// Creates a new builder-style object to manufacture [`AttachSecurityProfileInput`](crate::input::AttachSecurityProfileInput)
    pub fn builder() -> crate::input::attach_security_profile_input::Builder {
        crate::input::attach_security_profile_input::Builder::default()
    }
    /// Creates a new `AttachSecurityProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachSecurityProfile {
    type Output = std::result::Result<
        crate::output::AttachSecurityProfileOutput,
        crate::error::AttachSecurityProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_security_profile_error(response)
        } else {
            crate::operation_deser::parse_attach_security_profile_response(response)
        }
    }
}

/// Operation shape for `AttachThingPrincipal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_thing_principal`](crate::client::Client::attach_thing_principal).
///
/// See [`crate::client::fluent_builders::AttachThingPrincipal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachThingPrincipal {
    _private: (),
}
impl AttachThingPrincipal {
    /// Creates a new builder-style object to manufacture [`AttachThingPrincipalInput`](crate::input::AttachThingPrincipalInput)
    pub fn builder() -> crate::input::attach_thing_principal_input::Builder {
        crate::input::attach_thing_principal_input::Builder::default()
    }
    /// Creates a new `AttachThingPrincipal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachThingPrincipal {
    type Output = std::result::Result<
        crate::output::AttachThingPrincipalOutput,
        crate::error::AttachThingPrincipalError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_thing_principal_error(response)
        } else {
            crate::operation_deser::parse_attach_thing_principal_response(response)
        }
    }
}

/// Operation shape for `CancelAuditMitigationActionsTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_audit_mitigation_actions_task`](crate::client::Client::cancel_audit_mitigation_actions_task).
///
/// See [`crate::client::fluent_builders::CancelAuditMitigationActionsTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelAuditMitigationActionsTask {
    _private: (),
}
impl CancelAuditMitigationActionsTask {
    /// Creates a new builder-style object to manufacture [`CancelAuditMitigationActionsTaskInput`](crate::input::CancelAuditMitigationActionsTaskInput)
    pub fn builder() -> crate::input::cancel_audit_mitigation_actions_task_input::Builder {
        crate::input::cancel_audit_mitigation_actions_task_input::Builder::default()
    }
    /// Creates a new `CancelAuditMitigationActionsTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelAuditMitigationActionsTask {
    type Output = std::result::Result<
        crate::output::CancelAuditMitigationActionsTaskOutput,
        crate::error::CancelAuditMitigationActionsTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_audit_mitigation_actions_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_audit_mitigation_actions_task_response(response)
        }
    }
}

/// Operation shape for `CancelAuditTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_audit_task`](crate::client::Client::cancel_audit_task).
///
/// See [`crate::client::fluent_builders::CancelAuditTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelAuditTask {
    _private: (),
}
impl CancelAuditTask {
    /// Creates a new builder-style object to manufacture [`CancelAuditTaskInput`](crate::input::CancelAuditTaskInput)
    pub fn builder() -> crate::input::cancel_audit_task_input::Builder {
        crate::input::cancel_audit_task_input::Builder::default()
    }
    /// Creates a new `CancelAuditTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelAuditTask {
    type Output = std::result::Result<
        crate::output::CancelAuditTaskOutput,
        crate::error::CancelAuditTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_audit_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_audit_task_response(response)
        }
    }
}

/// Operation shape for `CancelCertificateTransfer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_certificate_transfer`](crate::client::Client::cancel_certificate_transfer).
///
/// See [`crate::client::fluent_builders::CancelCertificateTransfer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelCertificateTransfer {
    _private: (),
}
impl CancelCertificateTransfer {
    /// Creates a new builder-style object to manufacture [`CancelCertificateTransferInput`](crate::input::CancelCertificateTransferInput)
    pub fn builder() -> crate::input::cancel_certificate_transfer_input::Builder {
        crate::input::cancel_certificate_transfer_input::Builder::default()
    }
    /// Creates a new `CancelCertificateTransfer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelCertificateTransfer {
    type Output = std::result::Result<
        crate::output::CancelCertificateTransferOutput,
        crate::error::CancelCertificateTransferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_certificate_transfer_error(response)
        } else {
            crate::operation_deser::parse_cancel_certificate_transfer_response(response)
        }
    }
}

/// Operation shape for `CancelDetectMitigationActionsTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_detect_mitigation_actions_task`](crate::client::Client::cancel_detect_mitigation_actions_task).
///
/// See [`crate::client::fluent_builders::CancelDetectMitigationActionsTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelDetectMitigationActionsTask {
    _private: (),
}
impl CancelDetectMitigationActionsTask {
    /// Creates a new builder-style object to manufacture [`CancelDetectMitigationActionsTaskInput`](crate::input::CancelDetectMitigationActionsTaskInput)
    pub fn builder() -> crate::input::cancel_detect_mitigation_actions_task_input::Builder {
        crate::input::cancel_detect_mitigation_actions_task_input::Builder::default()
    }
    /// Creates a new `CancelDetectMitigationActionsTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelDetectMitigationActionsTask {
    type Output = std::result::Result<
        crate::output::CancelDetectMitigationActionsTaskOutput,
        crate::error::CancelDetectMitigationActionsTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_detect_mitigation_actions_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_detect_mitigation_actions_task_response(response)
        }
    }
}

/// Operation shape for `CancelJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_job`](crate::client::Client::cancel_job).
///
/// See [`crate::client::fluent_builders::CancelJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelJob {
    _private: (),
}
impl CancelJob {
    /// Creates a new builder-style object to manufacture [`CancelJobInput`](crate::input::CancelJobInput)
    pub fn builder() -> crate::input::cancel_job_input::Builder {
        crate::input::cancel_job_input::Builder::default()
    }
    /// Creates a new `CancelJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelJob {
    type Output = std::result::Result<crate::output::CancelJobOutput, crate::error::CancelJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_job_response(response)
        }
    }
}

/// Operation shape for `CancelJobExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_job_execution`](crate::client::Client::cancel_job_execution).
///
/// See [`crate::client::fluent_builders::CancelJobExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelJobExecution {
    _private: (),
}
impl CancelJobExecution {
    /// Creates a new builder-style object to manufacture [`CancelJobExecutionInput`](crate::input::CancelJobExecutionInput)
    pub fn builder() -> crate::input::cancel_job_execution_input::Builder {
        crate::input::cancel_job_execution_input::Builder::default()
    }
    /// Creates a new `CancelJobExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelJobExecution {
    type Output = std::result::Result<
        crate::output::CancelJobExecutionOutput,
        crate::error::CancelJobExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_job_execution_error(response)
        } else {
            crate::operation_deser::parse_cancel_job_execution_response(response)
        }
    }
}

/// Operation shape for `ClearDefaultAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`clear_default_authorizer`](crate::client::Client::clear_default_authorizer).
///
/// See [`crate::client::fluent_builders::ClearDefaultAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ClearDefaultAuthorizer {
    _private: (),
}
impl ClearDefaultAuthorizer {
    /// Creates a new builder-style object to manufacture [`ClearDefaultAuthorizerInput`](crate::input::ClearDefaultAuthorizerInput)
    pub fn builder() -> crate::input::clear_default_authorizer_input::Builder {
        crate::input::clear_default_authorizer_input::Builder::default()
    }
    /// Creates a new `ClearDefaultAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ClearDefaultAuthorizer {
    type Output = std::result::Result<
        crate::output::ClearDefaultAuthorizerOutput,
        crate::error::ClearDefaultAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_clear_default_authorizer_error(response)
        } else {
            crate::operation_deser::parse_clear_default_authorizer_response(response)
        }
    }
}

/// Operation shape for `ConfirmTopicRuleDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`confirm_topic_rule_destination`](crate::client::Client::confirm_topic_rule_destination).
///
/// See [`crate::client::fluent_builders::ConfirmTopicRuleDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfirmTopicRuleDestination {
    _private: (),
}
impl ConfirmTopicRuleDestination {
    /// Creates a new builder-style object to manufacture [`ConfirmTopicRuleDestinationInput`](crate::input::ConfirmTopicRuleDestinationInput)
    pub fn builder() -> crate::input::confirm_topic_rule_destination_input::Builder {
        crate::input::confirm_topic_rule_destination_input::Builder::default()
    }
    /// Creates a new `ConfirmTopicRuleDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfirmTopicRuleDestination {
    type Output = std::result::Result<
        crate::output::ConfirmTopicRuleDestinationOutput,
        crate::error::ConfirmTopicRuleDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_confirm_topic_rule_destination_error(response)
        } else {
            crate::operation_deser::parse_confirm_topic_rule_destination_response(response)
        }
    }
}

/// Operation shape for `CreateAuditSuppression`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_audit_suppression`](crate::client::Client::create_audit_suppression).
///
/// See [`crate::client::fluent_builders::CreateAuditSuppression`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAuditSuppression {
    _private: (),
}
impl CreateAuditSuppression {
    /// Creates a new builder-style object to manufacture [`CreateAuditSuppressionInput`](crate::input::CreateAuditSuppressionInput)
    pub fn builder() -> crate::input::create_audit_suppression_input::Builder {
        crate::input::create_audit_suppression_input::Builder::default()
    }
    /// Creates a new `CreateAuditSuppression` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAuditSuppression {
    type Output = std::result::Result<
        crate::output::CreateAuditSuppressionOutput,
        crate::error::CreateAuditSuppressionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_audit_suppression_error(response)
        } else {
            crate::operation_deser::parse_create_audit_suppression_response(response)
        }
    }
}

/// Operation shape for `CreateAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_authorizer`](crate::client::Client::create_authorizer).
///
/// See [`crate::client::fluent_builders::CreateAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAuthorizer {
    _private: (),
}
impl CreateAuthorizer {
    /// Creates a new builder-style object to manufacture [`CreateAuthorizerInput`](crate::input::CreateAuthorizerInput)
    pub fn builder() -> crate::input::create_authorizer_input::Builder {
        crate::input::create_authorizer_input::Builder::default()
    }
    /// Creates a new `CreateAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAuthorizer {
    type Output = std::result::Result<
        crate::output::CreateAuthorizerOutput,
        crate::error::CreateAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_authorizer_error(response)
        } else {
            crate::operation_deser::parse_create_authorizer_response(response)
        }
    }
}

/// Operation shape for `CreateBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_billing_group`](crate::client::Client::create_billing_group).
///
/// See [`crate::client::fluent_builders::CreateBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBillingGroup {
    _private: (),
}
impl CreateBillingGroup {
    /// Creates a new builder-style object to manufacture [`CreateBillingGroupInput`](crate::input::CreateBillingGroupInput)
    pub fn builder() -> crate::input::create_billing_group_input::Builder {
        crate::input::create_billing_group_input::Builder::default()
    }
    /// Creates a new `CreateBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBillingGroup {
    type Output = std::result::Result<
        crate::output::CreateBillingGroupOutput,
        crate::error::CreateBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_billing_group_error(response)
        } else {
            crate::operation_deser::parse_create_billing_group_response(response)
        }
    }
}

/// Operation shape for `CreateCertificateFromCsr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_certificate_from_csr`](crate::client::Client::create_certificate_from_csr).
///
/// See [`crate::client::fluent_builders::CreateCertificateFromCsr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCertificateFromCsr {
    _private: (),
}
impl CreateCertificateFromCsr {
    /// Creates a new builder-style object to manufacture [`CreateCertificateFromCsrInput`](crate::input::CreateCertificateFromCsrInput)
    pub fn builder() -> crate::input::create_certificate_from_csr_input::Builder {
        crate::input::create_certificate_from_csr_input::Builder::default()
    }
    /// Creates a new `CreateCertificateFromCsr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCertificateFromCsr {
    type Output = std::result::Result<
        crate::output::CreateCertificateFromCsrOutput,
        crate::error::CreateCertificateFromCsrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_certificate_from_csr_error(response)
        } else {
            crate::operation_deser::parse_create_certificate_from_csr_response(response)
        }
    }
}

/// Operation shape for `CreateCustomMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_metric`](crate::client::Client::create_custom_metric).
///
/// See [`crate::client::fluent_builders::CreateCustomMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomMetric {
    _private: (),
}
impl CreateCustomMetric {
    /// Creates a new builder-style object to manufacture [`CreateCustomMetricInput`](crate::input::CreateCustomMetricInput)
    pub fn builder() -> crate::input::create_custom_metric_input::Builder {
        crate::input::create_custom_metric_input::Builder::default()
    }
    /// Creates a new `CreateCustomMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomMetric {
    type Output = std::result::Result<
        crate::output::CreateCustomMetricOutput,
        crate::error::CreateCustomMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_metric_error(response)
        } else {
            crate::operation_deser::parse_create_custom_metric_response(response)
        }
    }
}

/// Operation shape for `CreateDimension`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dimension`](crate::client::Client::create_dimension).
///
/// See [`crate::client::fluent_builders::CreateDimension`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDimension {
    _private: (),
}
impl CreateDimension {
    /// Creates a new builder-style object to manufacture [`CreateDimensionInput`](crate::input::CreateDimensionInput)
    pub fn builder() -> crate::input::create_dimension_input::Builder {
        crate::input::create_dimension_input::Builder::default()
    }
    /// Creates a new `CreateDimension` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDimension {
    type Output = std::result::Result<
        crate::output::CreateDimensionOutput,
        crate::error::CreateDimensionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dimension_error(response)
        } else {
            crate::operation_deser::parse_create_dimension_response(response)
        }
    }
}

/// Operation shape for `CreateDomainConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain_configuration`](crate::client::Client::create_domain_configuration).
///
/// See [`crate::client::fluent_builders::CreateDomainConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomainConfiguration {
    _private: (),
}
impl CreateDomainConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateDomainConfigurationInput`](crate::input::CreateDomainConfigurationInput)
    pub fn builder() -> crate::input::create_domain_configuration_input::Builder {
        crate::input::create_domain_configuration_input::Builder::default()
    }
    /// Creates a new `CreateDomainConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomainConfiguration {
    type Output = std::result::Result<
        crate::output::CreateDomainConfigurationOutput,
        crate::error::CreateDomainConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_domain_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateDynamicThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dynamic_thing_group`](crate::client::Client::create_dynamic_thing_group).
///
/// See [`crate::client::fluent_builders::CreateDynamicThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDynamicThingGroup {
    _private: (),
}
impl CreateDynamicThingGroup {
    /// Creates a new builder-style object to manufacture [`CreateDynamicThingGroupInput`](crate::input::CreateDynamicThingGroupInput)
    pub fn builder() -> crate::input::create_dynamic_thing_group_input::Builder {
        crate::input::create_dynamic_thing_group_input::Builder::default()
    }
    /// Creates a new `CreateDynamicThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDynamicThingGroup {
    type Output = std::result::Result<
        crate::output::CreateDynamicThingGroupOutput,
        crate::error::CreateDynamicThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dynamic_thing_group_error(response)
        } else {
            crate::operation_deser::parse_create_dynamic_thing_group_response(response)
        }
    }
}

/// Operation shape for `CreateFleetMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fleet_metric`](crate::client::Client::create_fleet_metric).
///
/// See [`crate::client::fluent_builders::CreateFleetMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFleetMetric {
    _private: (),
}
impl CreateFleetMetric {
    /// Creates a new builder-style object to manufacture [`CreateFleetMetricInput`](crate::input::CreateFleetMetricInput)
    pub fn builder() -> crate::input::create_fleet_metric_input::Builder {
        crate::input::create_fleet_metric_input::Builder::default()
    }
    /// Creates a new `CreateFleetMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFleetMetric {
    type Output = std::result::Result<
        crate::output::CreateFleetMetricOutput,
        crate::error::CreateFleetMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fleet_metric_error(response)
        } else {
            crate::operation_deser::parse_create_fleet_metric_response(response)
        }
    }
}

/// Operation shape for `CreateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job`](crate::client::Client::create_job).
///
/// See [`crate::client::fluent_builders::CreateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJob {
    _private: (),
}
impl CreateJob {
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
    /// Creates a new `CreateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJob {
    type Output = std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_job_error(response)
        } else {
            crate::operation_deser::parse_create_job_response(response)
        }
    }
}

/// Operation shape for `CreateJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job_template`](crate::client::Client::create_job_template).
///
/// See [`crate::client::fluent_builders::CreateJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJobTemplate {
    _private: (),
}
impl CreateJobTemplate {
    /// Creates a new builder-style object to manufacture [`CreateJobTemplateInput`](crate::input::CreateJobTemplateInput)
    pub fn builder() -> crate::input::create_job_template_input::Builder {
        crate::input::create_job_template_input::Builder::default()
    }
    /// Creates a new `CreateJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJobTemplate {
    type Output = std::result::Result<
        crate::output::CreateJobTemplateOutput,
        crate::error::CreateJobTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_job_template_error(response)
        } else {
            crate::operation_deser::parse_create_job_template_response(response)
        }
    }
}

/// Operation shape for `CreateKeysAndCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_keys_and_certificate`](crate::client::Client::create_keys_and_certificate).
///
/// See [`crate::client::fluent_builders::CreateKeysAndCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateKeysAndCertificate {
    _private: (),
}
impl CreateKeysAndCertificate {
    /// Creates a new builder-style object to manufacture [`CreateKeysAndCertificateInput`](crate::input::CreateKeysAndCertificateInput)
    pub fn builder() -> crate::input::create_keys_and_certificate_input::Builder {
        crate::input::create_keys_and_certificate_input::Builder::default()
    }
    /// Creates a new `CreateKeysAndCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateKeysAndCertificate {
    type Output = std::result::Result<
        crate::output::CreateKeysAndCertificateOutput,
        crate::error::CreateKeysAndCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_keys_and_certificate_error(response)
        } else {
            crate::operation_deser::parse_create_keys_and_certificate_response(response)
        }
    }
}

/// Operation shape for `CreateMitigationAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_mitigation_action`](crate::client::Client::create_mitigation_action).
///
/// See [`crate::client::fluent_builders::CreateMitigationAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMitigationAction {
    _private: (),
}
impl CreateMitigationAction {
    /// Creates a new builder-style object to manufacture [`CreateMitigationActionInput`](crate::input::CreateMitigationActionInput)
    pub fn builder() -> crate::input::create_mitigation_action_input::Builder {
        crate::input::create_mitigation_action_input::Builder::default()
    }
    /// Creates a new `CreateMitigationAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMitigationAction {
    type Output = std::result::Result<
        crate::output::CreateMitigationActionOutput,
        crate::error::CreateMitigationActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_mitigation_action_error(response)
        } else {
            crate::operation_deser::parse_create_mitigation_action_response(response)
        }
    }
}

/// Operation shape for `CreateOTAUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ota_update`](crate::client::Client::create_ota_update).
///
/// See [`crate::client::fluent_builders::CreateOTAUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOTAUpdate {
    _private: (),
}
impl CreateOTAUpdate {
    /// Creates a new builder-style object to manufacture [`CreateOtaUpdateInput`](crate::input::CreateOtaUpdateInput)
    pub fn builder() -> crate::input::create_ota_update_input::Builder {
        crate::input::create_ota_update_input::Builder::default()
    }
    /// Creates a new `CreateOTAUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOTAUpdate {
    type Output = std::result::Result<
        crate::output::CreateOtaUpdateOutput,
        crate::error::CreateOTAUpdateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ota_update_error(response)
        } else {
            crate::operation_deser::parse_create_ota_update_response(response)
        }
    }
}

/// Operation shape for `CreatePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_policy`](crate::client::Client::create_policy).
///
/// See [`crate::client::fluent_builders::CreatePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePolicy {
    _private: (),
}
impl CreatePolicy {
    /// Creates a new builder-style object to manufacture [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    pub fn builder() -> crate::input::create_policy_input::Builder {
        crate::input::create_policy_input::Builder::default()
    }
    /// Creates a new `CreatePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePolicy {
    type Output =
        std::result::Result<crate::output::CreatePolicyOutput, crate::error::CreatePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_policy_error(response)
        } else {
            crate::operation_deser::parse_create_policy_response(response)
        }
    }
}

/// Operation shape for `CreatePolicyVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_policy_version`](crate::client::Client::create_policy_version).
///
/// See [`crate::client::fluent_builders::CreatePolicyVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePolicyVersion {
    _private: (),
}
impl CreatePolicyVersion {
    /// Creates a new builder-style object to manufacture [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
    pub fn builder() -> crate::input::create_policy_version_input::Builder {
        crate::input::create_policy_version_input::Builder::default()
    }
    /// Creates a new `CreatePolicyVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePolicyVersion {
    type Output = std::result::Result<
        crate::output::CreatePolicyVersionOutput,
        crate::error::CreatePolicyVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_policy_version_error(response)
        } else {
            crate::operation_deser::parse_create_policy_version_response(response)
        }
    }
}

/// Operation shape for `CreateProvisioningClaim`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_provisioning_claim`](crate::client::Client::create_provisioning_claim).
///
/// See [`crate::client::fluent_builders::CreateProvisioningClaim`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProvisioningClaim {
    _private: (),
}
impl CreateProvisioningClaim {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningClaimInput`](crate::input::CreateProvisioningClaimInput)
    pub fn builder() -> crate::input::create_provisioning_claim_input::Builder {
        crate::input::create_provisioning_claim_input::Builder::default()
    }
    /// Creates a new `CreateProvisioningClaim` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProvisioningClaim {
    type Output = std::result::Result<
        crate::output::CreateProvisioningClaimOutput,
        crate::error::CreateProvisioningClaimError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_provisioning_claim_error(response)
        } else {
            crate::operation_deser::parse_create_provisioning_claim_response(response)
        }
    }
}

/// Operation shape for `CreateProvisioningTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_provisioning_template`](crate::client::Client::create_provisioning_template).
///
/// See [`crate::client::fluent_builders::CreateProvisioningTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProvisioningTemplate {
    _private: (),
}
impl CreateProvisioningTemplate {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningTemplateInput`](crate::input::CreateProvisioningTemplateInput)
    pub fn builder() -> crate::input::create_provisioning_template_input::Builder {
        crate::input::create_provisioning_template_input::Builder::default()
    }
    /// Creates a new `CreateProvisioningTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProvisioningTemplate {
    type Output = std::result::Result<
        crate::output::CreateProvisioningTemplateOutput,
        crate::error::CreateProvisioningTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_provisioning_template_error(response)
        } else {
            crate::operation_deser::parse_create_provisioning_template_response(response)
        }
    }
}

/// Operation shape for `CreateProvisioningTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_provisioning_template_version`](crate::client::Client::create_provisioning_template_version).
///
/// See [`crate::client::fluent_builders::CreateProvisioningTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProvisioningTemplateVersion {
    _private: (),
}
impl CreateProvisioningTemplateVersion {
    /// Creates a new builder-style object to manufacture [`CreateProvisioningTemplateVersionInput`](crate::input::CreateProvisioningTemplateVersionInput)
    pub fn builder() -> crate::input::create_provisioning_template_version_input::Builder {
        crate::input::create_provisioning_template_version_input::Builder::default()
    }
    /// Creates a new `CreateProvisioningTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProvisioningTemplateVersion {
    type Output = std::result::Result<
        crate::output::CreateProvisioningTemplateVersionOutput,
        crate::error::CreateProvisioningTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_provisioning_template_version_error(response)
        } else {
            crate::operation_deser::parse_create_provisioning_template_version_response(response)
        }
    }
}

/// Operation shape for `CreateRoleAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_role_alias`](crate::client::Client::create_role_alias).
///
/// See [`crate::client::fluent_builders::CreateRoleAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoleAlias {
    _private: (),
}
impl CreateRoleAlias {
    /// Creates a new builder-style object to manufacture [`CreateRoleAliasInput`](crate::input::CreateRoleAliasInput)
    pub fn builder() -> crate::input::create_role_alias_input::Builder {
        crate::input::create_role_alias_input::Builder::default()
    }
    /// Creates a new `CreateRoleAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoleAlias {
    type Output = std::result::Result<
        crate::output::CreateRoleAliasOutput,
        crate::error::CreateRoleAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_role_alias_error(response)
        } else {
            crate::operation_deser::parse_create_role_alias_response(response)
        }
    }
}

/// Operation shape for `CreateScheduledAudit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_scheduled_audit`](crate::client::Client::create_scheduled_audit).
///
/// See [`crate::client::fluent_builders::CreateScheduledAudit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateScheduledAudit {
    _private: (),
}
impl CreateScheduledAudit {
    /// Creates a new builder-style object to manufacture [`CreateScheduledAuditInput`](crate::input::CreateScheduledAuditInput)
    pub fn builder() -> crate::input::create_scheduled_audit_input::Builder {
        crate::input::create_scheduled_audit_input::Builder::default()
    }
    /// Creates a new `CreateScheduledAudit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateScheduledAudit {
    type Output = std::result::Result<
        crate::output::CreateScheduledAuditOutput,
        crate::error::CreateScheduledAuditError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_scheduled_audit_error(response)
        } else {
            crate::operation_deser::parse_create_scheduled_audit_response(response)
        }
    }
}

/// Operation shape for `CreateSecurityProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_security_profile`](crate::client::Client::create_security_profile).
///
/// See [`crate::client::fluent_builders::CreateSecurityProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSecurityProfile {
    _private: (),
}
impl CreateSecurityProfile {
    /// Creates a new builder-style object to manufacture [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
    pub fn builder() -> crate::input::create_security_profile_input::Builder {
        crate::input::create_security_profile_input::Builder::default()
    }
    /// Creates a new `CreateSecurityProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSecurityProfile {
    type Output = std::result::Result<
        crate::output::CreateSecurityProfileOutput,
        crate::error::CreateSecurityProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_security_profile_error(response)
        } else {
            crate::operation_deser::parse_create_security_profile_response(response)
        }
    }
}

/// Operation shape for `CreateStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stream`](crate::client::Client::create_stream).
///
/// See [`crate::client::fluent_builders::CreateStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStream {
    _private: (),
}
impl CreateStream {
    /// Creates a new builder-style object to manufacture [`CreateStreamInput`](crate::input::CreateStreamInput)
    pub fn builder() -> crate::input::create_stream_input::Builder {
        crate::input::create_stream_input::Builder::default()
    }
    /// Creates a new `CreateStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStream {
    type Output =
        std::result::Result<crate::output::CreateStreamOutput, crate::error::CreateStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stream_error(response)
        } else {
            crate::operation_deser::parse_create_stream_response(response)
        }
    }
}

/// Operation shape for `CreateThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_thing`](crate::client::Client::create_thing).
///
/// See [`crate::client::fluent_builders::CreateThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateThing {
    _private: (),
}
impl CreateThing {
    /// Creates a new builder-style object to manufacture [`CreateThingInput`](crate::input::CreateThingInput)
    pub fn builder() -> crate::input::create_thing_input::Builder {
        crate::input::create_thing_input::Builder::default()
    }
    /// Creates a new `CreateThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateThing {
    type Output =
        std::result::Result<crate::output::CreateThingOutput, crate::error::CreateThingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_thing_error(response)
        } else {
            crate::operation_deser::parse_create_thing_response(response)
        }
    }
}

/// Operation shape for `CreateThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_thing_group`](crate::client::Client::create_thing_group).
///
/// See [`crate::client::fluent_builders::CreateThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateThingGroup {
    _private: (),
}
impl CreateThingGroup {
    /// Creates a new builder-style object to manufacture [`CreateThingGroupInput`](crate::input::CreateThingGroupInput)
    pub fn builder() -> crate::input::create_thing_group_input::Builder {
        crate::input::create_thing_group_input::Builder::default()
    }
    /// Creates a new `CreateThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateThingGroup {
    type Output = std::result::Result<
        crate::output::CreateThingGroupOutput,
        crate::error::CreateThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_thing_group_error(response)
        } else {
            crate::operation_deser::parse_create_thing_group_response(response)
        }
    }
}

/// Operation shape for `CreateThingType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_thing_type`](crate::client::Client::create_thing_type).
///
/// See [`crate::client::fluent_builders::CreateThingType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateThingType {
    _private: (),
}
impl CreateThingType {
    /// Creates a new builder-style object to manufacture [`CreateThingTypeInput`](crate::input::CreateThingTypeInput)
    pub fn builder() -> crate::input::create_thing_type_input::Builder {
        crate::input::create_thing_type_input::Builder::default()
    }
    /// Creates a new `CreateThingType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateThingType {
    type Output = std::result::Result<
        crate::output::CreateThingTypeOutput,
        crate::error::CreateThingTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_thing_type_error(response)
        } else {
            crate::operation_deser::parse_create_thing_type_response(response)
        }
    }
}

/// Operation shape for `CreateTopicRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_topic_rule`](crate::client::Client::create_topic_rule).
///
/// See [`crate::client::fluent_builders::CreateTopicRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTopicRule {
    _private: (),
}
impl CreateTopicRule {
    /// Creates a new builder-style object to manufacture [`CreateTopicRuleInput`](crate::input::CreateTopicRuleInput)
    pub fn builder() -> crate::input::create_topic_rule_input::Builder {
        crate::input::create_topic_rule_input::Builder::default()
    }
    /// Creates a new `CreateTopicRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTopicRule {
    type Output = std::result::Result<
        crate::output::CreateTopicRuleOutput,
        crate::error::CreateTopicRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_topic_rule_error(response)
        } else {
            crate::operation_deser::parse_create_topic_rule_response(response)
        }
    }
}

/// Operation shape for `CreateTopicRuleDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_topic_rule_destination`](crate::client::Client::create_topic_rule_destination).
///
/// See [`crate::client::fluent_builders::CreateTopicRuleDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTopicRuleDestination {
    _private: (),
}
impl CreateTopicRuleDestination {
    /// Creates a new builder-style object to manufacture [`CreateTopicRuleDestinationInput`](crate::input::CreateTopicRuleDestinationInput)
    pub fn builder() -> crate::input::create_topic_rule_destination_input::Builder {
        crate::input::create_topic_rule_destination_input::Builder::default()
    }
    /// Creates a new `CreateTopicRuleDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTopicRuleDestination {
    type Output = std::result::Result<
        crate::output::CreateTopicRuleDestinationOutput,
        crate::error::CreateTopicRuleDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_topic_rule_destination_error(response)
        } else {
            crate::operation_deser::parse_create_topic_rule_destination_response(response)
        }
    }
}

/// Operation shape for `DeleteAccountAuditConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_account_audit_configuration`](crate::client::Client::delete_account_audit_configuration).
///
/// See [`crate::client::fluent_builders::DeleteAccountAuditConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccountAuditConfiguration {
    _private: (),
}
impl DeleteAccountAuditConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteAccountAuditConfigurationInput`](crate::input::DeleteAccountAuditConfigurationInput)
    pub fn builder() -> crate::input::delete_account_audit_configuration_input::Builder {
        crate::input::delete_account_audit_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteAccountAuditConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccountAuditConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteAccountAuditConfigurationOutput,
        crate::error::DeleteAccountAuditConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_account_audit_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_account_audit_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteAuditSuppression`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_audit_suppression`](crate::client::Client::delete_audit_suppression).
///
/// See [`crate::client::fluent_builders::DeleteAuditSuppression`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAuditSuppression {
    _private: (),
}
impl DeleteAuditSuppression {
    /// Creates a new builder-style object to manufacture [`DeleteAuditSuppressionInput`](crate::input::DeleteAuditSuppressionInput)
    pub fn builder() -> crate::input::delete_audit_suppression_input::Builder {
        crate::input::delete_audit_suppression_input::Builder::default()
    }
    /// Creates a new `DeleteAuditSuppression` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAuditSuppression {
    type Output = std::result::Result<
        crate::output::DeleteAuditSuppressionOutput,
        crate::error::DeleteAuditSuppressionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_audit_suppression_error(response)
        } else {
            crate::operation_deser::parse_delete_audit_suppression_response(response)
        }
    }
}

/// Operation shape for `DeleteAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_authorizer`](crate::client::Client::delete_authorizer).
///
/// See [`crate::client::fluent_builders::DeleteAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAuthorizer {
    _private: (),
}
impl DeleteAuthorizer {
    /// Creates a new builder-style object to manufacture [`DeleteAuthorizerInput`](crate::input::DeleteAuthorizerInput)
    pub fn builder() -> crate::input::delete_authorizer_input::Builder {
        crate::input::delete_authorizer_input::Builder::default()
    }
    /// Creates a new `DeleteAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAuthorizer {
    type Output = std::result::Result<
        crate::output::DeleteAuthorizerOutput,
        crate::error::DeleteAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_authorizer_error(response)
        } else {
            crate::operation_deser::parse_delete_authorizer_response(response)
        }
    }
}

/// Operation shape for `DeleteBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_billing_group`](crate::client::Client::delete_billing_group).
///
/// See [`crate::client::fluent_builders::DeleteBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBillingGroup {
    _private: (),
}
impl DeleteBillingGroup {
    /// Creates a new builder-style object to manufacture [`DeleteBillingGroupInput`](crate::input::DeleteBillingGroupInput)
    pub fn builder() -> crate::input::delete_billing_group_input::Builder {
        crate::input::delete_billing_group_input::Builder::default()
    }
    /// Creates a new `DeleteBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBillingGroup {
    type Output = std::result::Result<
        crate::output::DeleteBillingGroupOutput,
        crate::error::DeleteBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_billing_group_error(response)
        } else {
            crate::operation_deser::parse_delete_billing_group_response(response)
        }
    }
}

/// Operation shape for `DeleteCACertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ca_certificate`](crate::client::Client::delete_ca_certificate).
///
/// See [`crate::client::fluent_builders::DeleteCACertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCACertificate {
    _private: (),
}
impl DeleteCACertificate {
    /// Creates a new builder-style object to manufacture [`DeleteCaCertificateInput`](crate::input::DeleteCaCertificateInput)
    pub fn builder() -> crate::input::delete_ca_certificate_input::Builder {
        crate::input::delete_ca_certificate_input::Builder::default()
    }
    /// Creates a new `DeleteCACertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCACertificate {
    type Output = std::result::Result<
        crate::output::DeleteCaCertificateOutput,
        crate::error::DeleteCACertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ca_certificate_error(response)
        } else {
            crate::operation_deser::parse_delete_ca_certificate_response(response)
        }
    }
}

/// Operation shape for `DeleteCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_certificate`](crate::client::Client::delete_certificate).
///
/// See [`crate::client::fluent_builders::DeleteCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCertificate {
    _private: (),
}
impl DeleteCertificate {
    /// Creates a new builder-style object to manufacture [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    pub fn builder() -> crate::input::delete_certificate_input::Builder {
        crate::input::delete_certificate_input::Builder::default()
    }
    /// Creates a new `DeleteCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCertificate {
    type Output = std::result::Result<
        crate::output::DeleteCertificateOutput,
        crate::error::DeleteCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_certificate_error(response)
        } else {
            crate::operation_deser::parse_delete_certificate_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_metric`](crate::client::Client::delete_custom_metric).
///
/// See [`crate::client::fluent_builders::DeleteCustomMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomMetric {
    _private: (),
}
impl DeleteCustomMetric {
    /// Creates a new builder-style object to manufacture [`DeleteCustomMetricInput`](crate::input::DeleteCustomMetricInput)
    pub fn builder() -> crate::input::delete_custom_metric_input::Builder {
        crate::input::delete_custom_metric_input::Builder::default()
    }
    /// Creates a new `DeleteCustomMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomMetric {
    type Output = std::result::Result<
        crate::output::DeleteCustomMetricOutput,
        crate::error::DeleteCustomMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_metric_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_metric_response(response)
        }
    }
}

/// Operation shape for `DeleteDimension`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dimension`](crate::client::Client::delete_dimension).
///
/// See [`crate::client::fluent_builders::DeleteDimension`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDimension {
    _private: (),
}
impl DeleteDimension {
    /// Creates a new builder-style object to manufacture [`DeleteDimensionInput`](crate::input::DeleteDimensionInput)
    pub fn builder() -> crate::input::delete_dimension_input::Builder {
        crate::input::delete_dimension_input::Builder::default()
    }
    /// Creates a new `DeleteDimension` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDimension {
    type Output = std::result::Result<
        crate::output::DeleteDimensionOutput,
        crate::error::DeleteDimensionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dimension_error(response)
        } else {
            crate::operation_deser::parse_delete_dimension_response(response)
        }
    }
}

/// Operation shape for `DeleteDomainConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain_configuration`](crate::client::Client::delete_domain_configuration).
///
/// See [`crate::client::fluent_builders::DeleteDomainConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomainConfiguration {
    _private: (),
}
impl DeleteDomainConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteDomainConfigurationInput`](crate::input::DeleteDomainConfigurationInput)
    pub fn builder() -> crate::input::delete_domain_configuration_input::Builder {
        crate::input::delete_domain_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteDomainConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomainConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteDomainConfigurationOutput,
        crate::error::DeleteDomainConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteDynamicThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dynamic_thing_group`](crate::client::Client::delete_dynamic_thing_group).
///
/// See [`crate::client::fluent_builders::DeleteDynamicThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDynamicThingGroup {
    _private: (),
}
impl DeleteDynamicThingGroup {
    /// Creates a new builder-style object to manufacture [`DeleteDynamicThingGroupInput`](crate::input::DeleteDynamicThingGroupInput)
    pub fn builder() -> crate::input::delete_dynamic_thing_group_input::Builder {
        crate::input::delete_dynamic_thing_group_input::Builder::default()
    }
    /// Creates a new `DeleteDynamicThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDynamicThingGroup {
    type Output = std::result::Result<
        crate::output::DeleteDynamicThingGroupOutput,
        crate::error::DeleteDynamicThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dynamic_thing_group_error(response)
        } else {
            crate::operation_deser::parse_delete_dynamic_thing_group_response(response)
        }
    }
}

/// Operation shape for `DeleteFleetMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fleet_metric`](crate::client::Client::delete_fleet_metric).
///
/// See [`crate::client::fluent_builders::DeleteFleetMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFleetMetric {
    _private: (),
}
impl DeleteFleetMetric {
    /// Creates a new builder-style object to manufacture [`DeleteFleetMetricInput`](crate::input::DeleteFleetMetricInput)
    pub fn builder() -> crate::input::delete_fleet_metric_input::Builder {
        crate::input::delete_fleet_metric_input::Builder::default()
    }
    /// Creates a new `DeleteFleetMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFleetMetric {
    type Output = std::result::Result<
        crate::output::DeleteFleetMetricOutput,
        crate::error::DeleteFleetMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fleet_metric_error(response)
        } else {
            crate::operation_deser::parse_delete_fleet_metric_response(response)
        }
    }
}

/// Operation shape for `DeleteJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job`](crate::client::Client::delete_job).
///
/// See [`crate::client::fluent_builders::DeleteJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJob {
    _private: (),
}
impl DeleteJob {
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
    /// Creates a new `DeleteJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJob {
    type Output = std::result::Result<crate::output::DeleteJobOutput, crate::error::DeleteJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_job_error(response)
        } else {
            crate::operation_deser::parse_delete_job_response(response)
        }
    }
}

/// Operation shape for `DeleteJobExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job_execution`](crate::client::Client::delete_job_execution).
///
/// See [`crate::client::fluent_builders::DeleteJobExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJobExecution {
    _private: (),
}
impl DeleteJobExecution {
    /// Creates a new builder-style object to manufacture [`DeleteJobExecutionInput`](crate::input::DeleteJobExecutionInput)
    pub fn builder() -> crate::input::delete_job_execution_input::Builder {
        crate::input::delete_job_execution_input::Builder::default()
    }
    /// Creates a new `DeleteJobExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJobExecution {
    type Output = std::result::Result<
        crate::output::DeleteJobExecutionOutput,
        crate::error::DeleteJobExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_job_execution_error(response)
        } else {
            crate::operation_deser::parse_delete_job_execution_response(response)
        }
    }
}

/// Operation shape for `DeleteJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job_template`](crate::client::Client::delete_job_template).
///
/// See [`crate::client::fluent_builders::DeleteJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJobTemplate {
    _private: (),
}
impl DeleteJobTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteJobTemplateInput`](crate::input::DeleteJobTemplateInput)
    pub fn builder() -> crate::input::delete_job_template_input::Builder {
        crate::input::delete_job_template_input::Builder::default()
    }
    /// Creates a new `DeleteJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJobTemplate {
    type Output = std::result::Result<
        crate::output::DeleteJobTemplateOutput,
        crate::error::DeleteJobTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_job_template_error(response)
        } else {
            crate::operation_deser::parse_delete_job_template_response(response)
        }
    }
}

/// Operation shape for `DeleteMitigationAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_mitigation_action`](crate::client::Client::delete_mitigation_action).
///
/// See [`crate::client::fluent_builders::DeleteMitigationAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMitigationAction {
    _private: (),
}
impl DeleteMitigationAction {
    /// Creates a new builder-style object to manufacture [`DeleteMitigationActionInput`](crate::input::DeleteMitigationActionInput)
    pub fn builder() -> crate::input::delete_mitigation_action_input::Builder {
        crate::input::delete_mitigation_action_input::Builder::default()
    }
    /// Creates a new `DeleteMitigationAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMitigationAction {
    type Output = std::result::Result<
        crate::output::DeleteMitigationActionOutput,
        crate::error::DeleteMitigationActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_mitigation_action_error(response)
        } else {
            crate::operation_deser::parse_delete_mitigation_action_response(response)
        }
    }
}

/// Operation shape for `DeleteOTAUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ota_update`](crate::client::Client::delete_ota_update).
///
/// See [`crate::client::fluent_builders::DeleteOTAUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOTAUpdate {
    _private: (),
}
impl DeleteOTAUpdate {
    /// Creates a new builder-style object to manufacture [`DeleteOtaUpdateInput`](crate::input::DeleteOtaUpdateInput)
    pub fn builder() -> crate::input::delete_ota_update_input::Builder {
        crate::input::delete_ota_update_input::Builder::default()
    }
    /// Creates a new `DeleteOTAUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOTAUpdate {
    type Output = std::result::Result<
        crate::output::DeleteOtaUpdateOutput,
        crate::error::DeleteOTAUpdateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ota_update_error(response)
        } else {
            crate::operation_deser::parse_delete_ota_update_response(response)
        }
    }
}

/// Operation shape for `DeletePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_policy`](crate::client::Client::delete_policy).
///
/// See [`crate::client::fluent_builders::DeletePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePolicy {
    _private: (),
}
impl DeletePolicy {
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
    /// Creates a new `DeletePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePolicy {
    type Output =
        std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_policy_response(response)
        }
    }
}

/// Operation shape for `DeletePolicyVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_policy_version`](crate::client::Client::delete_policy_version).
///
/// See [`crate::client::fluent_builders::DeletePolicyVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePolicyVersion {
    _private: (),
}
impl DeletePolicyVersion {
    /// Creates a new builder-style object to manufacture [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
    pub fn builder() -> crate::input::delete_policy_version_input::Builder {
        crate::input::delete_policy_version_input::Builder::default()
    }
    /// Creates a new `DeletePolicyVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePolicyVersion {
    type Output = std::result::Result<
        crate::output::DeletePolicyVersionOutput,
        crate::error::DeletePolicyVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_policy_version_error(response)
        } else {
            crate::operation_deser::parse_delete_policy_version_response(response)
        }
    }
}

/// Operation shape for `DeleteProvisioningTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_provisioning_template`](crate::client::Client::delete_provisioning_template).
///
/// See [`crate::client::fluent_builders::DeleteProvisioningTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProvisioningTemplate {
    _private: (),
}
impl DeleteProvisioningTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningTemplateInput`](crate::input::DeleteProvisioningTemplateInput)
    pub fn builder() -> crate::input::delete_provisioning_template_input::Builder {
        crate::input::delete_provisioning_template_input::Builder::default()
    }
    /// Creates a new `DeleteProvisioningTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProvisioningTemplate {
    type Output = std::result::Result<
        crate::output::DeleteProvisioningTemplateOutput,
        crate::error::DeleteProvisioningTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_provisioning_template_error(response)
        } else {
            crate::operation_deser::parse_delete_provisioning_template_response(response)
        }
    }
}

/// Operation shape for `DeleteProvisioningTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_provisioning_template_version`](crate::client::Client::delete_provisioning_template_version).
///
/// See [`crate::client::fluent_builders::DeleteProvisioningTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProvisioningTemplateVersion {
    _private: (),
}
impl DeleteProvisioningTemplateVersion {
    /// Creates a new builder-style object to manufacture [`DeleteProvisioningTemplateVersionInput`](crate::input::DeleteProvisioningTemplateVersionInput)
    pub fn builder() -> crate::input::delete_provisioning_template_version_input::Builder {
        crate::input::delete_provisioning_template_version_input::Builder::default()
    }
    /// Creates a new `DeleteProvisioningTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProvisioningTemplateVersion {
    type Output = std::result::Result<
        crate::output::DeleteProvisioningTemplateVersionOutput,
        crate::error::DeleteProvisioningTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_provisioning_template_version_error(response)
        } else {
            crate::operation_deser::parse_delete_provisioning_template_version_response(response)
        }
    }
}

/// Operation shape for `DeleteRegistrationCode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_registration_code`](crate::client::Client::delete_registration_code).
///
/// See [`crate::client::fluent_builders::DeleteRegistrationCode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRegistrationCode {
    _private: (),
}
impl DeleteRegistrationCode {
    /// Creates a new builder-style object to manufacture [`DeleteRegistrationCodeInput`](crate::input::DeleteRegistrationCodeInput)
    pub fn builder() -> crate::input::delete_registration_code_input::Builder {
        crate::input::delete_registration_code_input::Builder::default()
    }
    /// Creates a new `DeleteRegistrationCode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRegistrationCode {
    type Output = std::result::Result<
        crate::output::DeleteRegistrationCodeOutput,
        crate::error::DeleteRegistrationCodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_registration_code_error(response)
        } else {
            crate::operation_deser::parse_delete_registration_code_response(response)
        }
    }
}

/// Operation shape for `DeleteRoleAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_role_alias`](crate::client::Client::delete_role_alias).
///
/// See [`crate::client::fluent_builders::DeleteRoleAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoleAlias {
    _private: (),
}
impl DeleteRoleAlias {
    /// Creates a new builder-style object to manufacture [`DeleteRoleAliasInput`](crate::input::DeleteRoleAliasInput)
    pub fn builder() -> crate::input::delete_role_alias_input::Builder {
        crate::input::delete_role_alias_input::Builder::default()
    }
    /// Creates a new `DeleteRoleAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoleAlias {
    type Output = std::result::Result<
        crate::output::DeleteRoleAliasOutput,
        crate::error::DeleteRoleAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_role_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_role_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteScheduledAudit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_scheduled_audit`](crate::client::Client::delete_scheduled_audit).
///
/// See [`crate::client::fluent_builders::DeleteScheduledAudit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteScheduledAudit {
    _private: (),
}
impl DeleteScheduledAudit {
    /// Creates a new builder-style object to manufacture [`DeleteScheduledAuditInput`](crate::input::DeleteScheduledAuditInput)
    pub fn builder() -> crate::input::delete_scheduled_audit_input::Builder {
        crate::input::delete_scheduled_audit_input::Builder::default()
    }
    /// Creates a new `DeleteScheduledAudit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteScheduledAudit {
    type Output = std::result::Result<
        crate::output::DeleteScheduledAuditOutput,
        crate::error::DeleteScheduledAuditError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_scheduled_audit_error(response)
        } else {
            crate::operation_deser::parse_delete_scheduled_audit_response(response)
        }
    }
}

/// Operation shape for `DeleteSecurityProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_security_profile`](crate::client::Client::delete_security_profile).
///
/// See [`crate::client::fluent_builders::DeleteSecurityProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSecurityProfile {
    _private: (),
}
impl DeleteSecurityProfile {
    /// Creates a new builder-style object to manufacture [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
    pub fn builder() -> crate::input::delete_security_profile_input::Builder {
        crate::input::delete_security_profile_input::Builder::default()
    }
    /// Creates a new `DeleteSecurityProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSecurityProfile {
    type Output = std::result::Result<
        crate::output::DeleteSecurityProfileOutput,
        crate::error::DeleteSecurityProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_security_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_security_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stream`](crate::client::Client::delete_stream).
///
/// See [`crate::client::fluent_builders::DeleteStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStream {
    _private: (),
}
impl DeleteStream {
    /// Creates a new builder-style object to manufacture [`DeleteStreamInput`](crate::input::DeleteStreamInput)
    pub fn builder() -> crate::input::delete_stream_input::Builder {
        crate::input::delete_stream_input::Builder::default()
    }
    /// Creates a new `DeleteStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStream {
    type Output =
        std::result::Result<crate::output::DeleteStreamOutput, crate::error::DeleteStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stream_error(response)
        } else {
            crate::operation_deser::parse_delete_stream_response(response)
        }
    }
}

/// Operation shape for `DeleteThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_thing`](crate::client::Client::delete_thing).
///
/// See [`crate::client::fluent_builders::DeleteThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteThing {
    _private: (),
}
impl DeleteThing {
    /// Creates a new builder-style object to manufacture [`DeleteThingInput`](crate::input::DeleteThingInput)
    pub fn builder() -> crate::input::delete_thing_input::Builder {
        crate::input::delete_thing_input::Builder::default()
    }
    /// Creates a new `DeleteThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteThing {
    type Output =
        std::result::Result<crate::output::DeleteThingOutput, crate::error::DeleteThingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_thing_error(response)
        } else {
            crate::operation_deser::parse_delete_thing_response(response)
        }
    }
}

/// Operation shape for `DeleteThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_thing_group`](crate::client::Client::delete_thing_group).
///
/// See [`crate::client::fluent_builders::DeleteThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteThingGroup {
    _private: (),
}
impl DeleteThingGroup {
    /// Creates a new builder-style object to manufacture [`DeleteThingGroupInput`](crate::input::DeleteThingGroupInput)
    pub fn builder() -> crate::input::delete_thing_group_input::Builder {
        crate::input::delete_thing_group_input::Builder::default()
    }
    /// Creates a new `DeleteThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteThingGroup {
    type Output = std::result::Result<
        crate::output::DeleteThingGroupOutput,
        crate::error::DeleteThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_thing_group_error(response)
        } else {
            crate::operation_deser::parse_delete_thing_group_response(response)
        }
    }
}

/// Operation shape for `DeleteThingType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_thing_type`](crate::client::Client::delete_thing_type).
///
/// See [`crate::client::fluent_builders::DeleteThingType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteThingType {
    _private: (),
}
impl DeleteThingType {
    /// Creates a new builder-style object to manufacture [`DeleteThingTypeInput`](crate::input::DeleteThingTypeInput)
    pub fn builder() -> crate::input::delete_thing_type_input::Builder {
        crate::input::delete_thing_type_input::Builder::default()
    }
    /// Creates a new `DeleteThingType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteThingType {
    type Output = std::result::Result<
        crate::output::DeleteThingTypeOutput,
        crate::error::DeleteThingTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_thing_type_error(response)
        } else {
            crate::operation_deser::parse_delete_thing_type_response(response)
        }
    }
}

/// Operation shape for `DeleteTopicRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_topic_rule`](crate::client::Client::delete_topic_rule).
///
/// See [`crate::client::fluent_builders::DeleteTopicRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTopicRule {
    _private: (),
}
impl DeleteTopicRule {
    /// Creates a new builder-style object to manufacture [`DeleteTopicRuleInput`](crate::input::DeleteTopicRuleInput)
    pub fn builder() -> crate::input::delete_topic_rule_input::Builder {
        crate::input::delete_topic_rule_input::Builder::default()
    }
    /// Creates a new `DeleteTopicRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTopicRule {
    type Output = std::result::Result<
        crate::output::DeleteTopicRuleOutput,
        crate::error::DeleteTopicRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_topic_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_topic_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteTopicRuleDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_topic_rule_destination`](crate::client::Client::delete_topic_rule_destination).
///
/// See [`crate::client::fluent_builders::DeleteTopicRuleDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTopicRuleDestination {
    _private: (),
}
impl DeleteTopicRuleDestination {
    /// Creates a new builder-style object to manufacture [`DeleteTopicRuleDestinationInput`](crate::input::DeleteTopicRuleDestinationInput)
    pub fn builder() -> crate::input::delete_topic_rule_destination_input::Builder {
        crate::input::delete_topic_rule_destination_input::Builder::default()
    }
    /// Creates a new `DeleteTopicRuleDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTopicRuleDestination {
    type Output = std::result::Result<
        crate::output::DeleteTopicRuleDestinationOutput,
        crate::error::DeleteTopicRuleDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_topic_rule_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_topic_rule_destination_response(response)
        }
    }
}

/// Operation shape for `DeleteV2LoggingLevel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_v2_logging_level`](crate::client::Client::delete_v2_logging_level).
///
/// See [`crate::client::fluent_builders::DeleteV2LoggingLevel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteV2LoggingLevel {
    _private: (),
}
impl DeleteV2LoggingLevel {
    /// Creates a new builder-style object to manufacture [`DeleteV2LoggingLevelInput`](crate::input::DeleteV2LoggingLevelInput)
    pub fn builder() -> crate::input::delete_v2_logging_level_input::Builder {
        crate::input::delete_v2_logging_level_input::Builder::default()
    }
    /// Creates a new `DeleteV2LoggingLevel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteV2LoggingLevel {
    type Output = std::result::Result<
        crate::output::DeleteV2LoggingLevelOutput,
        crate::error::DeleteV2LoggingLevelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_v2_logging_level_error(response)
        } else {
            crate::operation_deser::parse_delete_v2_logging_level_response(response)
        }
    }
}

/// Operation shape for `DeprecateThingType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprecate_thing_type`](crate::client::Client::deprecate_thing_type).
///
/// See [`crate::client::fluent_builders::DeprecateThingType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprecateThingType {
    _private: (),
}
impl DeprecateThingType {
    /// Creates a new builder-style object to manufacture [`DeprecateThingTypeInput`](crate::input::DeprecateThingTypeInput)
    pub fn builder() -> crate::input::deprecate_thing_type_input::Builder {
        crate::input::deprecate_thing_type_input::Builder::default()
    }
    /// Creates a new `DeprecateThingType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprecateThingType {
    type Output = std::result::Result<
        crate::output::DeprecateThingTypeOutput,
        crate::error::DeprecateThingTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprecate_thing_type_error(response)
        } else {
            crate::operation_deser::parse_deprecate_thing_type_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountAuditConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_audit_configuration`](crate::client::Client::describe_account_audit_configuration).
///
/// See [`crate::client::fluent_builders::DescribeAccountAuditConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAuditConfiguration {
    _private: (),
}
impl DescribeAccountAuditConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAuditConfigurationInput`](crate::input::DescribeAccountAuditConfigurationInput)
    pub fn builder() -> crate::input::describe_account_audit_configuration_input::Builder {
        crate::input::describe_account_audit_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAuditConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAuditConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeAccountAuditConfigurationOutput,
        crate::error::DescribeAccountAuditConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_audit_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_account_audit_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeAuditFinding`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_audit_finding`](crate::client::Client::describe_audit_finding).
///
/// See [`crate::client::fluent_builders::DescribeAuditFinding`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAuditFinding {
    _private: (),
}
impl DescribeAuditFinding {
    /// Creates a new builder-style object to manufacture [`DescribeAuditFindingInput`](crate::input::DescribeAuditFindingInput)
    pub fn builder() -> crate::input::describe_audit_finding_input::Builder {
        crate::input::describe_audit_finding_input::Builder::default()
    }
    /// Creates a new `DescribeAuditFinding` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAuditFinding {
    type Output = std::result::Result<
        crate::output::DescribeAuditFindingOutput,
        crate::error::DescribeAuditFindingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_audit_finding_error(response)
        } else {
            crate::operation_deser::parse_describe_audit_finding_response(response)
        }
    }
}

/// Operation shape for `DescribeAuditMitigationActionsTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_audit_mitigation_actions_task`](crate::client::Client::describe_audit_mitigation_actions_task).
///
/// See [`crate::client::fluent_builders::DescribeAuditMitigationActionsTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAuditMitigationActionsTask {
    _private: (),
}
impl DescribeAuditMitigationActionsTask {
    /// Creates a new builder-style object to manufacture [`DescribeAuditMitigationActionsTaskInput`](crate::input::DescribeAuditMitigationActionsTaskInput)
    pub fn builder() -> crate::input::describe_audit_mitigation_actions_task_input::Builder {
        crate::input::describe_audit_mitigation_actions_task_input::Builder::default()
    }
    /// Creates a new `DescribeAuditMitigationActionsTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAuditMitigationActionsTask {
    type Output = std::result::Result<
        crate::output::DescribeAuditMitigationActionsTaskOutput,
        crate::error::DescribeAuditMitigationActionsTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_audit_mitigation_actions_task_error(response)
        } else {
            crate::operation_deser::parse_describe_audit_mitigation_actions_task_response(response)
        }
    }
}

/// Operation shape for `DescribeAuditSuppression`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_audit_suppression`](crate::client::Client::describe_audit_suppression).
///
/// See [`crate::client::fluent_builders::DescribeAuditSuppression`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAuditSuppression {
    _private: (),
}
impl DescribeAuditSuppression {
    /// Creates a new builder-style object to manufacture [`DescribeAuditSuppressionInput`](crate::input::DescribeAuditSuppressionInput)
    pub fn builder() -> crate::input::describe_audit_suppression_input::Builder {
        crate::input::describe_audit_suppression_input::Builder::default()
    }
    /// Creates a new `DescribeAuditSuppression` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAuditSuppression {
    type Output = std::result::Result<
        crate::output::DescribeAuditSuppressionOutput,
        crate::error::DescribeAuditSuppressionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_audit_suppression_error(response)
        } else {
            crate::operation_deser::parse_describe_audit_suppression_response(response)
        }
    }
}

/// Operation shape for `DescribeAuditTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_audit_task`](crate::client::Client::describe_audit_task).
///
/// See [`crate::client::fluent_builders::DescribeAuditTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAuditTask {
    _private: (),
}
impl DescribeAuditTask {
    /// Creates a new builder-style object to manufacture [`DescribeAuditTaskInput`](crate::input::DescribeAuditTaskInput)
    pub fn builder() -> crate::input::describe_audit_task_input::Builder {
        crate::input::describe_audit_task_input::Builder::default()
    }
    /// Creates a new `DescribeAuditTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAuditTask {
    type Output = std::result::Result<
        crate::output::DescribeAuditTaskOutput,
        crate::error::DescribeAuditTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_audit_task_error(response)
        } else {
            crate::operation_deser::parse_describe_audit_task_response(response)
        }
    }
}

/// Operation shape for `DescribeAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_authorizer`](crate::client::Client::describe_authorizer).
///
/// See [`crate::client::fluent_builders::DescribeAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAuthorizer {
    _private: (),
}
impl DescribeAuthorizer {
    /// Creates a new builder-style object to manufacture [`DescribeAuthorizerInput`](crate::input::DescribeAuthorizerInput)
    pub fn builder() -> crate::input::describe_authorizer_input::Builder {
        crate::input::describe_authorizer_input::Builder::default()
    }
    /// Creates a new `DescribeAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAuthorizer {
    type Output = std::result::Result<
        crate::output::DescribeAuthorizerOutput,
        crate::error::DescribeAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_authorizer_error(response)
        } else {
            crate::operation_deser::parse_describe_authorizer_response(response)
        }
    }
}

/// Operation shape for `DescribeBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_billing_group`](crate::client::Client::describe_billing_group).
///
/// See [`crate::client::fluent_builders::DescribeBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBillingGroup {
    _private: (),
}
impl DescribeBillingGroup {
    /// Creates a new builder-style object to manufacture [`DescribeBillingGroupInput`](crate::input::DescribeBillingGroupInput)
    pub fn builder() -> crate::input::describe_billing_group_input::Builder {
        crate::input::describe_billing_group_input::Builder::default()
    }
    /// Creates a new `DescribeBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBillingGroup {
    type Output = std::result::Result<
        crate::output::DescribeBillingGroupOutput,
        crate::error::DescribeBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_billing_group_error(response)
        } else {
            crate::operation_deser::parse_describe_billing_group_response(response)
        }
    }
}

/// Operation shape for `DescribeCACertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ca_certificate`](crate::client::Client::describe_ca_certificate).
///
/// See [`crate::client::fluent_builders::DescribeCACertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCACertificate {
    _private: (),
}
impl DescribeCACertificate {
    /// Creates a new builder-style object to manufacture [`DescribeCaCertificateInput`](crate::input::DescribeCaCertificateInput)
    pub fn builder() -> crate::input::describe_ca_certificate_input::Builder {
        crate::input::describe_ca_certificate_input::Builder::default()
    }
    /// Creates a new `DescribeCACertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCACertificate {
    type Output = std::result::Result<
        crate::output::DescribeCaCertificateOutput,
        crate::error::DescribeCACertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ca_certificate_error(response)
        } else {
            crate::operation_deser::parse_describe_ca_certificate_response(response)
        }
    }
}

/// Operation shape for `DescribeCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_certificate`](crate::client::Client::describe_certificate).
///
/// See [`crate::client::fluent_builders::DescribeCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCertificate {
    _private: (),
}
impl DescribeCertificate {
    /// Creates a new builder-style object to manufacture [`DescribeCertificateInput`](crate::input::DescribeCertificateInput)
    pub fn builder() -> crate::input::describe_certificate_input::Builder {
        crate::input::describe_certificate_input::Builder::default()
    }
    /// Creates a new `DescribeCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCertificate {
    type Output = std::result::Result<
        crate::output::DescribeCertificateOutput,
        crate::error::DescribeCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_certificate_error(response)
        } else {
            crate::operation_deser::parse_describe_certificate_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_metric`](crate::client::Client::describe_custom_metric).
///
/// See [`crate::client::fluent_builders::DescribeCustomMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomMetric {
    _private: (),
}
impl DescribeCustomMetric {
    /// Creates a new builder-style object to manufacture [`DescribeCustomMetricInput`](crate::input::DescribeCustomMetricInput)
    pub fn builder() -> crate::input::describe_custom_metric_input::Builder {
        crate::input::describe_custom_metric_input::Builder::default()
    }
    /// Creates a new `DescribeCustomMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomMetric {
    type Output = std::result::Result<
        crate::output::DescribeCustomMetricOutput,
        crate::error::DescribeCustomMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_metric_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_metric_response(response)
        }
    }
}

/// Operation shape for `DescribeDefaultAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_default_authorizer`](crate::client::Client::describe_default_authorizer).
///
/// See [`crate::client::fluent_builders::DescribeDefaultAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDefaultAuthorizer {
    _private: (),
}
impl DescribeDefaultAuthorizer {
    /// Creates a new builder-style object to manufacture [`DescribeDefaultAuthorizerInput`](crate::input::DescribeDefaultAuthorizerInput)
    pub fn builder() -> crate::input::describe_default_authorizer_input::Builder {
        crate::input::describe_default_authorizer_input::Builder::default()
    }
    /// Creates a new `DescribeDefaultAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDefaultAuthorizer {
    type Output = std::result::Result<
        crate::output::DescribeDefaultAuthorizerOutput,
        crate::error::DescribeDefaultAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_default_authorizer_error(response)
        } else {
            crate::operation_deser::parse_describe_default_authorizer_response(response)
        }
    }
}

/// Operation shape for `DescribeDetectMitigationActionsTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_detect_mitigation_actions_task`](crate::client::Client::describe_detect_mitigation_actions_task).
///
/// See [`crate::client::fluent_builders::DescribeDetectMitigationActionsTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDetectMitigationActionsTask {
    _private: (),
}
impl DescribeDetectMitigationActionsTask {
    /// Creates a new builder-style object to manufacture [`DescribeDetectMitigationActionsTaskInput`](crate::input::DescribeDetectMitigationActionsTaskInput)
    pub fn builder() -> crate::input::describe_detect_mitigation_actions_task_input::Builder {
        crate::input::describe_detect_mitigation_actions_task_input::Builder::default()
    }
    /// Creates a new `DescribeDetectMitigationActionsTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDetectMitigationActionsTask {
    type Output = std::result::Result<
        crate::output::DescribeDetectMitigationActionsTaskOutput,
        crate::error::DescribeDetectMitigationActionsTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_detect_mitigation_actions_task_error(response)
        } else {
            crate::operation_deser::parse_describe_detect_mitigation_actions_task_response(response)
        }
    }
}

/// Operation shape for `DescribeDimension`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dimension`](crate::client::Client::describe_dimension).
///
/// See [`crate::client::fluent_builders::DescribeDimension`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDimension {
    _private: (),
}
impl DescribeDimension {
    /// Creates a new builder-style object to manufacture [`DescribeDimensionInput`](crate::input::DescribeDimensionInput)
    pub fn builder() -> crate::input::describe_dimension_input::Builder {
        crate::input::describe_dimension_input::Builder::default()
    }
    /// Creates a new `DescribeDimension` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDimension {
    type Output = std::result::Result<
        crate::output::DescribeDimensionOutput,
        crate::error::DescribeDimensionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dimension_error(response)
        } else {
            crate::operation_deser::parse_describe_dimension_response(response)
        }
    }
}

/// Operation shape for `DescribeDomainConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain_configuration`](crate::client::Client::describe_domain_configuration).
///
/// See [`crate::client::fluent_builders::DescribeDomainConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomainConfiguration {
    _private: (),
}
impl DescribeDomainConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeDomainConfigurationInput`](crate::input::DescribeDomainConfigurationInput)
    pub fn builder() -> crate::input::describe_domain_configuration_input::Builder {
        crate::input::describe_domain_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeDomainConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomainConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeDomainConfigurationOutput,
        crate::error::DescribeDomainConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint`](crate::client::Client::describe_endpoint).
///
/// See [`crate::client::fluent_builders::DescribeEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpoint {
    _private: (),
}
impl DescribeEndpoint {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    pub fn builder() -> crate::input::describe_endpoint_input::Builder {
        crate::input::describe_endpoint_input::Builder::default()
    }
    /// Creates a new `DescribeEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpoint {
    type Output = std::result::Result<
        crate::output::DescribeEndpointOutput,
        crate::error::DescribeEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_response(response)
        }
    }
}

/// Operation shape for `DescribeEventConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_configurations`](crate::client::Client::describe_event_configurations).
///
/// See [`crate::client::fluent_builders::DescribeEventConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventConfigurations {
    _private: (),
}
impl DescribeEventConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeEventConfigurationsInput`](crate::input::DescribeEventConfigurationsInput)
    pub fn builder() -> crate::input::describe_event_configurations_input::Builder {
        crate::input::describe_event_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeEventConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeEventConfigurationsOutput,
        crate::error::DescribeEventConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_event_configurations_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_metric`](crate::client::Client::describe_fleet_metric).
///
/// See [`crate::client::fluent_builders::DescribeFleetMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetMetric {
    _private: (),
}
impl DescribeFleetMetric {
    /// Creates a new builder-style object to manufacture [`DescribeFleetMetricInput`](crate::input::DescribeFleetMetricInput)
    pub fn builder() -> crate::input::describe_fleet_metric_input::Builder {
        crate::input::describe_fleet_metric_input::Builder::default()
    }
    /// Creates a new `DescribeFleetMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetMetric {
    type Output = std::result::Result<
        crate::output::DescribeFleetMetricOutput,
        crate::error::DescribeFleetMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_metric_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_metric_response(response)
        }
    }
}

/// Operation shape for `DescribeIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_index`](crate::client::Client::describe_index).
///
/// See [`crate::client::fluent_builders::DescribeIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIndex {
    _private: (),
}
impl DescribeIndex {
    /// Creates a new builder-style object to manufacture [`DescribeIndexInput`](crate::input::DescribeIndexInput)
    pub fn builder() -> crate::input::describe_index_input::Builder {
        crate::input::describe_index_input::Builder::default()
    }
    /// Creates a new `DescribeIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIndex {
    type Output =
        std::result::Result<crate::output::DescribeIndexOutput, crate::error::DescribeIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_index_error(response)
        } else {
            crate::operation_deser::parse_describe_index_response(response)
        }
    }
}

/// Operation shape for `DescribeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job`](crate::client::Client::describe_job).
///
/// See [`crate::client::fluent_builders::DescribeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJob {
    _private: (),
}
impl DescribeJob {
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
    /// Creates a new `DescribeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJob {
    type Output =
        std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_error(response)
        } else {
            crate::operation_deser::parse_describe_job_response(response)
        }
    }
}

/// Operation shape for `DescribeJobExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job_execution`](crate::client::Client::describe_job_execution).
///
/// See [`crate::client::fluent_builders::DescribeJobExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJobExecution {
    _private: (),
}
impl DescribeJobExecution {
    /// Creates a new builder-style object to manufacture [`DescribeJobExecutionInput`](crate::input::DescribeJobExecutionInput)
    pub fn builder() -> crate::input::describe_job_execution_input::Builder {
        crate::input::describe_job_execution_input::Builder::default()
    }
    /// Creates a new `DescribeJobExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJobExecution {
    type Output = std::result::Result<
        crate::output::DescribeJobExecutionOutput,
        crate::error::DescribeJobExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_job_execution_response(response)
        }
    }
}

/// Operation shape for `DescribeJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job_template`](crate::client::Client::describe_job_template).
///
/// See [`crate::client::fluent_builders::DescribeJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJobTemplate {
    _private: (),
}
impl DescribeJobTemplate {
    /// Creates a new builder-style object to manufacture [`DescribeJobTemplateInput`](crate::input::DescribeJobTemplateInput)
    pub fn builder() -> crate::input::describe_job_template_input::Builder {
        crate::input::describe_job_template_input::Builder::default()
    }
    /// Creates a new `DescribeJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJobTemplate {
    type Output = std::result::Result<
        crate::output::DescribeJobTemplateOutput,
        crate::error::DescribeJobTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_template_error(response)
        } else {
            crate::operation_deser::parse_describe_job_template_response(response)
        }
    }
}

/// Operation shape for `DescribeManagedJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_managed_job_template`](crate::client::Client::describe_managed_job_template).
///
/// See [`crate::client::fluent_builders::DescribeManagedJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeManagedJobTemplate {
    _private: (),
}
impl DescribeManagedJobTemplate {
    /// Creates a new builder-style object to manufacture [`DescribeManagedJobTemplateInput`](crate::input::DescribeManagedJobTemplateInput)
    pub fn builder() -> crate::input::describe_managed_job_template_input::Builder {
        crate::input::describe_managed_job_template_input::Builder::default()
    }
    /// Creates a new `DescribeManagedJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeManagedJobTemplate {
    type Output = std::result::Result<
        crate::output::DescribeManagedJobTemplateOutput,
        crate::error::DescribeManagedJobTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_managed_job_template_error(response)
        } else {
            crate::operation_deser::parse_describe_managed_job_template_response(response)
        }
    }
}

/// Operation shape for `DescribeMitigationAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_mitigation_action`](crate::client::Client::describe_mitigation_action).
///
/// See [`crate::client::fluent_builders::DescribeMitigationAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMitigationAction {
    _private: (),
}
impl DescribeMitigationAction {
    /// Creates a new builder-style object to manufacture [`DescribeMitigationActionInput`](crate::input::DescribeMitigationActionInput)
    pub fn builder() -> crate::input::describe_mitigation_action_input::Builder {
        crate::input::describe_mitigation_action_input::Builder::default()
    }
    /// Creates a new `DescribeMitigationAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMitigationAction {
    type Output = std::result::Result<
        crate::output::DescribeMitigationActionOutput,
        crate::error::DescribeMitigationActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_mitigation_action_error(response)
        } else {
            crate::operation_deser::parse_describe_mitigation_action_response(response)
        }
    }
}

/// Operation shape for `DescribeProvisioningTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_provisioning_template`](crate::client::Client::describe_provisioning_template).
///
/// See [`crate::client::fluent_builders::DescribeProvisioningTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProvisioningTemplate {
    _private: (),
}
impl DescribeProvisioningTemplate {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningTemplateInput`](crate::input::DescribeProvisioningTemplateInput)
    pub fn builder() -> crate::input::describe_provisioning_template_input::Builder {
        crate::input::describe_provisioning_template_input::Builder::default()
    }
    /// Creates a new `DescribeProvisioningTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProvisioningTemplate {
    type Output = std::result::Result<
        crate::output::DescribeProvisioningTemplateOutput,
        crate::error::DescribeProvisioningTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_provisioning_template_error(response)
        } else {
            crate::operation_deser::parse_describe_provisioning_template_response(response)
        }
    }
}

/// Operation shape for `DescribeProvisioningTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_provisioning_template_version`](crate::client::Client::describe_provisioning_template_version).
///
/// See [`crate::client::fluent_builders::DescribeProvisioningTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProvisioningTemplateVersion {
    _private: (),
}
impl DescribeProvisioningTemplateVersion {
    /// Creates a new builder-style object to manufacture [`DescribeProvisioningTemplateVersionInput`](crate::input::DescribeProvisioningTemplateVersionInput)
    pub fn builder() -> crate::input::describe_provisioning_template_version_input::Builder {
        crate::input::describe_provisioning_template_version_input::Builder::default()
    }
    /// Creates a new `DescribeProvisioningTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProvisioningTemplateVersion {
    type Output = std::result::Result<
        crate::output::DescribeProvisioningTemplateVersionOutput,
        crate::error::DescribeProvisioningTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_provisioning_template_version_error(response)
        } else {
            crate::operation_deser::parse_describe_provisioning_template_version_response(response)
        }
    }
}

/// Operation shape for `DescribeRoleAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_role_alias`](crate::client::Client::describe_role_alias).
///
/// See [`crate::client::fluent_builders::DescribeRoleAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRoleAlias {
    _private: (),
}
impl DescribeRoleAlias {
    /// Creates a new builder-style object to manufacture [`DescribeRoleAliasInput`](crate::input::DescribeRoleAliasInput)
    pub fn builder() -> crate::input::describe_role_alias_input::Builder {
        crate::input::describe_role_alias_input::Builder::default()
    }
    /// Creates a new `DescribeRoleAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRoleAlias {
    type Output = std::result::Result<
        crate::output::DescribeRoleAliasOutput,
        crate::error::DescribeRoleAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_role_alias_error(response)
        } else {
            crate::operation_deser::parse_describe_role_alias_response(response)
        }
    }
}

/// Operation shape for `DescribeScheduledAudit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scheduled_audit`](crate::client::Client::describe_scheduled_audit).
///
/// See [`crate::client::fluent_builders::DescribeScheduledAudit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScheduledAudit {
    _private: (),
}
impl DescribeScheduledAudit {
    /// Creates a new builder-style object to manufacture [`DescribeScheduledAuditInput`](crate::input::DescribeScheduledAuditInput)
    pub fn builder() -> crate::input::describe_scheduled_audit_input::Builder {
        crate::input::describe_scheduled_audit_input::Builder::default()
    }
    /// Creates a new `DescribeScheduledAudit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScheduledAudit {
    type Output = std::result::Result<
        crate::output::DescribeScheduledAuditOutput,
        crate::error::DescribeScheduledAuditError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scheduled_audit_error(response)
        } else {
            crate::operation_deser::parse_describe_scheduled_audit_response(response)
        }
    }
}

/// Operation shape for `DescribeSecurityProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_security_profile`](crate::client::Client::describe_security_profile).
///
/// See [`crate::client::fluent_builders::DescribeSecurityProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSecurityProfile {
    _private: (),
}
impl DescribeSecurityProfile {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
    pub fn builder() -> crate::input::describe_security_profile_input::Builder {
        crate::input::describe_security_profile_input::Builder::default()
    }
    /// Creates a new `DescribeSecurityProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSecurityProfile {
    type Output = std::result::Result<
        crate::output::DescribeSecurityProfileOutput,
        crate::error::DescribeSecurityProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_security_profile_error(response)
        } else {
            crate::operation_deser::parse_describe_security_profile_response(response)
        }
    }
}

/// Operation shape for `DescribeStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stream`](crate::client::Client::describe_stream).
///
/// See [`crate::client::fluent_builders::DescribeStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStream {
    _private: (),
}
impl DescribeStream {
    /// Creates a new builder-style object to manufacture [`DescribeStreamInput`](crate::input::DescribeStreamInput)
    pub fn builder() -> crate::input::describe_stream_input::Builder {
        crate::input::describe_stream_input::Builder::default()
    }
    /// Creates a new `DescribeStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStream {
    type Output =
        std::result::Result<crate::output::DescribeStreamOutput, crate::error::DescribeStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stream_error(response)
        } else {
            crate::operation_deser::parse_describe_stream_response(response)
        }
    }
}

/// Operation shape for `DescribeThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_thing`](crate::client::Client::describe_thing).
///
/// See [`crate::client::fluent_builders::DescribeThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeThing {
    _private: (),
}
impl DescribeThing {
    /// Creates a new builder-style object to manufacture [`DescribeThingInput`](crate::input::DescribeThingInput)
    pub fn builder() -> crate::input::describe_thing_input::Builder {
        crate::input::describe_thing_input::Builder::default()
    }
    /// Creates a new `DescribeThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeThing {
    type Output =
        std::result::Result<crate::output::DescribeThingOutput, crate::error::DescribeThingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_thing_error(response)
        } else {
            crate::operation_deser::parse_describe_thing_response(response)
        }
    }
}

/// Operation shape for `DescribeThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_thing_group`](crate::client::Client::describe_thing_group).
///
/// See [`crate::client::fluent_builders::DescribeThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeThingGroup {
    _private: (),
}
impl DescribeThingGroup {
    /// Creates a new builder-style object to manufacture [`DescribeThingGroupInput`](crate::input::DescribeThingGroupInput)
    pub fn builder() -> crate::input::describe_thing_group_input::Builder {
        crate::input::describe_thing_group_input::Builder::default()
    }
    /// Creates a new `DescribeThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeThingGroup {
    type Output = std::result::Result<
        crate::output::DescribeThingGroupOutput,
        crate::error::DescribeThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_thing_group_error(response)
        } else {
            crate::operation_deser::parse_describe_thing_group_response(response)
        }
    }
}

/// Operation shape for `DescribeThingRegistrationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_thing_registration_task`](crate::client::Client::describe_thing_registration_task).
///
/// See [`crate::client::fluent_builders::DescribeThingRegistrationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeThingRegistrationTask {
    _private: (),
}
impl DescribeThingRegistrationTask {
    /// Creates a new builder-style object to manufacture [`DescribeThingRegistrationTaskInput`](crate::input::DescribeThingRegistrationTaskInput)
    pub fn builder() -> crate::input::describe_thing_registration_task_input::Builder {
        crate::input::describe_thing_registration_task_input::Builder::default()
    }
    /// Creates a new `DescribeThingRegistrationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeThingRegistrationTask {
    type Output = std::result::Result<
        crate::output::DescribeThingRegistrationTaskOutput,
        crate::error::DescribeThingRegistrationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_thing_registration_task_error(response)
        } else {
            crate::operation_deser::parse_describe_thing_registration_task_response(response)
        }
    }
}

/// Operation shape for `DescribeThingType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_thing_type`](crate::client::Client::describe_thing_type).
///
/// See [`crate::client::fluent_builders::DescribeThingType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeThingType {
    _private: (),
}
impl DescribeThingType {
    /// Creates a new builder-style object to manufacture [`DescribeThingTypeInput`](crate::input::DescribeThingTypeInput)
    pub fn builder() -> crate::input::describe_thing_type_input::Builder {
        crate::input::describe_thing_type_input::Builder::default()
    }
    /// Creates a new `DescribeThingType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeThingType {
    type Output = std::result::Result<
        crate::output::DescribeThingTypeOutput,
        crate::error::DescribeThingTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_thing_type_error(response)
        } else {
            crate::operation_deser::parse_describe_thing_type_response(response)
        }
    }
}

/// Operation shape for `DetachPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_policy`](crate::client::Client::detach_policy).
///
/// See [`crate::client::fluent_builders::DetachPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachPolicy {
    _private: (),
}
impl DetachPolicy {
    /// Creates a new builder-style object to manufacture [`DetachPolicyInput`](crate::input::DetachPolicyInput)
    pub fn builder() -> crate::input::detach_policy_input::Builder {
        crate::input::detach_policy_input::Builder::default()
    }
    /// Creates a new `DetachPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachPolicy {
    type Output =
        std::result::Result<crate::output::DetachPolicyOutput, crate::error::DetachPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_policy_error(response)
        } else {
            crate::operation_deser::parse_detach_policy_response(response)
        }
    }
}

/// Operation shape for `DetachPrincipalPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_principal_policy`](crate::client::Client::detach_principal_policy).
///
/// See [`crate::client::fluent_builders::DetachPrincipalPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachPrincipalPolicy {
    _private: (),
}
impl DetachPrincipalPolicy {
    /// Creates a new builder-style object to manufacture [`DetachPrincipalPolicyInput`](crate::input::DetachPrincipalPolicyInput)
    pub fn builder() -> crate::input::detach_principal_policy_input::Builder {
        crate::input::detach_principal_policy_input::Builder::default()
    }
    /// Creates a new `DetachPrincipalPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachPrincipalPolicy {
    type Output = std::result::Result<
        crate::output::DetachPrincipalPolicyOutput,
        crate::error::DetachPrincipalPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_principal_policy_error(response)
        } else {
            crate::operation_deser::parse_detach_principal_policy_response(response)
        }
    }
}

/// Operation shape for `DetachSecurityProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_security_profile`](crate::client::Client::detach_security_profile).
///
/// See [`crate::client::fluent_builders::DetachSecurityProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachSecurityProfile {
    _private: (),
}
impl DetachSecurityProfile {
    /// Creates a new builder-style object to manufacture [`DetachSecurityProfileInput`](crate::input::DetachSecurityProfileInput)
    pub fn builder() -> crate::input::detach_security_profile_input::Builder {
        crate::input::detach_security_profile_input::Builder::default()
    }
    /// Creates a new `DetachSecurityProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachSecurityProfile {
    type Output = std::result::Result<
        crate::output::DetachSecurityProfileOutput,
        crate::error::DetachSecurityProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_security_profile_error(response)
        } else {
            crate::operation_deser::parse_detach_security_profile_response(response)
        }
    }
}

/// Operation shape for `DetachThingPrincipal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_thing_principal`](crate::client::Client::detach_thing_principal).
///
/// See [`crate::client::fluent_builders::DetachThingPrincipal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachThingPrincipal {
    _private: (),
}
impl DetachThingPrincipal {
    /// Creates a new builder-style object to manufacture [`DetachThingPrincipalInput`](crate::input::DetachThingPrincipalInput)
    pub fn builder() -> crate::input::detach_thing_principal_input::Builder {
        crate::input::detach_thing_principal_input::Builder::default()
    }
    /// Creates a new `DetachThingPrincipal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachThingPrincipal {
    type Output = std::result::Result<
        crate::output::DetachThingPrincipalOutput,
        crate::error::DetachThingPrincipalError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_thing_principal_error(response)
        } else {
            crate::operation_deser::parse_detach_thing_principal_response(response)
        }
    }
}

/// Operation shape for `DisableTopicRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_topic_rule`](crate::client::Client::disable_topic_rule).
///
/// See [`crate::client::fluent_builders::DisableTopicRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableTopicRule {
    _private: (),
}
impl DisableTopicRule {
    /// Creates a new builder-style object to manufacture [`DisableTopicRuleInput`](crate::input::DisableTopicRuleInput)
    pub fn builder() -> crate::input::disable_topic_rule_input::Builder {
        crate::input::disable_topic_rule_input::Builder::default()
    }
    /// Creates a new `DisableTopicRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableTopicRule {
    type Output = std::result::Result<
        crate::output::DisableTopicRuleOutput,
        crate::error::DisableTopicRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_topic_rule_error(response)
        } else {
            crate::operation_deser::parse_disable_topic_rule_response(response)
        }
    }
}

/// Operation shape for `EnableTopicRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_topic_rule`](crate::client::Client::enable_topic_rule).
///
/// See [`crate::client::fluent_builders::EnableTopicRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableTopicRule {
    _private: (),
}
impl EnableTopicRule {
    /// Creates a new builder-style object to manufacture [`EnableTopicRuleInput`](crate::input::EnableTopicRuleInput)
    pub fn builder() -> crate::input::enable_topic_rule_input::Builder {
        crate::input::enable_topic_rule_input::Builder::default()
    }
    /// Creates a new `EnableTopicRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableTopicRule {
    type Output = std::result::Result<
        crate::output::EnableTopicRuleOutput,
        crate::error::EnableTopicRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_topic_rule_error(response)
        } else {
            crate::operation_deser::parse_enable_topic_rule_response(response)
        }
    }
}

/// Operation shape for `GetBehaviorModelTrainingSummaries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_behavior_model_training_summaries`](crate::client::Client::get_behavior_model_training_summaries).
///
/// See [`crate::client::fluent_builders::GetBehaviorModelTrainingSummaries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBehaviorModelTrainingSummaries {
    _private: (),
}
impl GetBehaviorModelTrainingSummaries {
    /// Creates a new builder-style object to manufacture [`GetBehaviorModelTrainingSummariesInput`](crate::input::GetBehaviorModelTrainingSummariesInput)
    pub fn builder() -> crate::input::get_behavior_model_training_summaries_input::Builder {
        crate::input::get_behavior_model_training_summaries_input::Builder::default()
    }
    /// Creates a new `GetBehaviorModelTrainingSummaries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBehaviorModelTrainingSummaries {
    type Output = std::result::Result<
        crate::output::GetBehaviorModelTrainingSummariesOutput,
        crate::error::GetBehaviorModelTrainingSummariesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_behavior_model_training_summaries_error(response)
        } else {
            crate::operation_deser::parse_get_behavior_model_training_summaries_response(response)
        }
    }
}

/// Operation shape for `GetBucketsAggregation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_buckets_aggregation`](crate::client::Client::get_buckets_aggregation).
///
/// See [`crate::client::fluent_builders::GetBucketsAggregation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketsAggregation {
    _private: (),
}
impl GetBucketsAggregation {
    /// Creates a new builder-style object to manufacture [`GetBucketsAggregationInput`](crate::input::GetBucketsAggregationInput)
    pub fn builder() -> crate::input::get_buckets_aggregation_input::Builder {
        crate::input::get_buckets_aggregation_input::Builder::default()
    }
    /// Creates a new `GetBucketsAggregation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketsAggregation {
    type Output = std::result::Result<
        crate::output::GetBucketsAggregationOutput,
        crate::error::GetBucketsAggregationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_buckets_aggregation_error(response)
        } else {
            crate::operation_deser::parse_get_buckets_aggregation_response(response)
        }
    }
}

/// Operation shape for `GetCardinality`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cardinality`](crate::client::Client::get_cardinality).
///
/// See [`crate::client::fluent_builders::GetCardinality`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCardinality {
    _private: (),
}
impl GetCardinality {
    /// Creates a new builder-style object to manufacture [`GetCardinalityInput`](crate::input::GetCardinalityInput)
    pub fn builder() -> crate::input::get_cardinality_input::Builder {
        crate::input::get_cardinality_input::Builder::default()
    }
    /// Creates a new `GetCardinality` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCardinality {
    type Output =
        std::result::Result<crate::output::GetCardinalityOutput, crate::error::GetCardinalityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cardinality_error(response)
        } else {
            crate::operation_deser::parse_get_cardinality_response(response)
        }
    }
}

/// Operation shape for `GetEffectivePolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_effective_policies`](crate::client::Client::get_effective_policies).
///
/// See [`crate::client::fluent_builders::GetEffectivePolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEffectivePolicies {
    _private: (),
}
impl GetEffectivePolicies {
    /// Creates a new builder-style object to manufacture [`GetEffectivePoliciesInput`](crate::input::GetEffectivePoliciesInput)
    pub fn builder() -> crate::input::get_effective_policies_input::Builder {
        crate::input::get_effective_policies_input::Builder::default()
    }
    /// Creates a new `GetEffectivePolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEffectivePolicies {
    type Output = std::result::Result<
        crate::output::GetEffectivePoliciesOutput,
        crate::error::GetEffectivePoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_effective_policies_error(response)
        } else {
            crate::operation_deser::parse_get_effective_policies_response(response)
        }
    }
}

/// Operation shape for `GetIndexingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_indexing_configuration`](crate::client::Client::get_indexing_configuration).
///
/// See [`crate::client::fluent_builders::GetIndexingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIndexingConfiguration {
    _private: (),
}
impl GetIndexingConfiguration {
    /// Creates a new builder-style object to manufacture [`GetIndexingConfigurationInput`](crate::input::GetIndexingConfigurationInput)
    pub fn builder() -> crate::input::get_indexing_configuration_input::Builder {
        crate::input::get_indexing_configuration_input::Builder::default()
    }
    /// Creates a new `GetIndexingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIndexingConfiguration {
    type Output = std::result::Result<
        crate::output::GetIndexingConfigurationOutput,
        crate::error::GetIndexingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_indexing_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_indexing_configuration_response(response)
        }
    }
}

/// Operation shape for `GetJobDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_document`](crate::client::Client::get_job_document).
///
/// See [`crate::client::fluent_builders::GetJobDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobDocument {
    _private: (),
}
impl GetJobDocument {
    /// Creates a new builder-style object to manufacture [`GetJobDocumentInput`](crate::input::GetJobDocumentInput)
    pub fn builder() -> crate::input::get_job_document_input::Builder {
        crate::input::get_job_document_input::Builder::default()
    }
    /// Creates a new `GetJobDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobDocument {
    type Output =
        std::result::Result<crate::output::GetJobDocumentOutput, crate::error::GetJobDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_document_error(response)
        } else {
            crate::operation_deser::parse_get_job_document_response(response)
        }
    }
}

/// Operation shape for `GetLoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_logging_options`](crate::client::Client::get_logging_options).
///
/// See [`crate::client::fluent_builders::GetLoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoggingOptions {
    _private: (),
}
impl GetLoggingOptions {
    /// Creates a new builder-style object to manufacture [`GetLoggingOptionsInput`](crate::input::GetLoggingOptionsInput)
    pub fn builder() -> crate::input::get_logging_options_input::Builder {
        crate::input::get_logging_options_input::Builder::default()
    }
    /// Creates a new `GetLoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoggingOptions {
    type Output = std::result::Result<
        crate::output::GetLoggingOptionsOutput,
        crate::error::GetLoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_logging_options_error(response)
        } else {
            crate::operation_deser::parse_get_logging_options_response(response)
        }
    }
}

/// Operation shape for `GetOTAUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ota_update`](crate::client::Client::get_ota_update).
///
/// See [`crate::client::fluent_builders::GetOTAUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOTAUpdate {
    _private: (),
}
impl GetOTAUpdate {
    /// Creates a new builder-style object to manufacture [`GetOtaUpdateInput`](crate::input::GetOtaUpdateInput)
    pub fn builder() -> crate::input::get_ota_update_input::Builder {
        crate::input::get_ota_update_input::Builder::default()
    }
    /// Creates a new `GetOTAUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOTAUpdate {
    type Output =
        std::result::Result<crate::output::GetOtaUpdateOutput, crate::error::GetOTAUpdateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ota_update_error(response)
        } else {
            crate::operation_deser::parse_get_ota_update_response(response)
        }
    }
}

/// Operation shape for `GetPercentiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_percentiles`](crate::client::Client::get_percentiles).
///
/// See [`crate::client::fluent_builders::GetPercentiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPercentiles {
    _private: (),
}
impl GetPercentiles {
    /// Creates a new builder-style object to manufacture [`GetPercentilesInput`](crate::input::GetPercentilesInput)
    pub fn builder() -> crate::input::get_percentiles_input::Builder {
        crate::input::get_percentiles_input::Builder::default()
    }
    /// Creates a new `GetPercentiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPercentiles {
    type Output =
        std::result::Result<crate::output::GetPercentilesOutput, crate::error::GetPercentilesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_percentiles_error(response)
        } else {
            crate::operation_deser::parse_get_percentiles_response(response)
        }
    }
}

/// Operation shape for `GetPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_policy`](crate::client::Client::get_policy).
///
/// See [`crate::client::fluent_builders::GetPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPolicy {
    _private: (),
}
impl GetPolicy {
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
    /// Creates a new `GetPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPolicy {
    type Output = std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_policy_error(response)
        } else {
            crate::operation_deser::parse_get_policy_response(response)
        }
    }
}

/// Operation shape for `GetPolicyVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_policy_version`](crate::client::Client::get_policy_version).
///
/// See [`crate::client::fluent_builders::GetPolicyVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPolicyVersion {
    _private: (),
}
impl GetPolicyVersion {
    /// Creates a new builder-style object to manufacture [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
    pub fn builder() -> crate::input::get_policy_version_input::Builder {
        crate::input::get_policy_version_input::Builder::default()
    }
    /// Creates a new `GetPolicyVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPolicyVersion {
    type Output = std::result::Result<
        crate::output::GetPolicyVersionOutput,
        crate::error::GetPolicyVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_policy_version_error(response)
        } else {
            crate::operation_deser::parse_get_policy_version_response(response)
        }
    }
}

/// Operation shape for `GetRegistrationCode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_registration_code`](crate::client::Client::get_registration_code).
///
/// See [`crate::client::fluent_builders::GetRegistrationCode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegistrationCode {
    _private: (),
}
impl GetRegistrationCode {
    /// Creates a new builder-style object to manufacture [`GetRegistrationCodeInput`](crate::input::GetRegistrationCodeInput)
    pub fn builder() -> crate::input::get_registration_code_input::Builder {
        crate::input::get_registration_code_input::Builder::default()
    }
    /// Creates a new `GetRegistrationCode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegistrationCode {
    type Output = std::result::Result<
        crate::output::GetRegistrationCodeOutput,
        crate::error::GetRegistrationCodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_registration_code_error(response)
        } else {
            crate::operation_deser::parse_get_registration_code_response(response)
        }
    }
}

/// Operation shape for `GetStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_statistics`](crate::client::Client::get_statistics).
///
/// See [`crate::client::fluent_builders::GetStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStatistics {
    _private: (),
}
impl GetStatistics {
    /// Creates a new builder-style object to manufacture [`GetStatisticsInput`](crate::input::GetStatisticsInput)
    pub fn builder() -> crate::input::get_statistics_input::Builder {
        crate::input::get_statistics_input::Builder::default()
    }
    /// Creates a new `GetStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStatistics {
    type Output =
        std::result::Result<crate::output::GetStatisticsOutput, crate::error::GetStatisticsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_statistics_response(response)
        }
    }
}

/// Operation shape for `GetTopicRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_topic_rule`](crate::client::Client::get_topic_rule).
///
/// See [`crate::client::fluent_builders::GetTopicRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTopicRule {
    _private: (),
}
impl GetTopicRule {
    /// Creates a new builder-style object to manufacture [`GetTopicRuleInput`](crate::input::GetTopicRuleInput)
    pub fn builder() -> crate::input::get_topic_rule_input::Builder {
        crate::input::get_topic_rule_input::Builder::default()
    }
    /// Creates a new `GetTopicRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTopicRule {
    type Output =
        std::result::Result<crate::output::GetTopicRuleOutput, crate::error::GetTopicRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_topic_rule_error(response)
        } else {
            crate::operation_deser::parse_get_topic_rule_response(response)
        }
    }
}

/// Operation shape for `GetTopicRuleDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_topic_rule_destination`](crate::client::Client::get_topic_rule_destination).
///
/// See [`crate::client::fluent_builders::GetTopicRuleDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTopicRuleDestination {
    _private: (),
}
impl GetTopicRuleDestination {
    /// Creates a new builder-style object to manufacture [`GetTopicRuleDestinationInput`](crate::input::GetTopicRuleDestinationInput)
    pub fn builder() -> crate::input::get_topic_rule_destination_input::Builder {
        crate::input::get_topic_rule_destination_input::Builder::default()
    }
    /// Creates a new `GetTopicRuleDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTopicRuleDestination {
    type Output = std::result::Result<
        crate::output::GetTopicRuleDestinationOutput,
        crate::error::GetTopicRuleDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_topic_rule_destination_error(response)
        } else {
            crate::operation_deser::parse_get_topic_rule_destination_response(response)
        }
    }
}

/// Operation shape for `GetV2LoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_v2_logging_options`](crate::client::Client::get_v2_logging_options).
///
/// See [`crate::client::fluent_builders::GetV2LoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetV2LoggingOptions {
    _private: (),
}
impl GetV2LoggingOptions {
    /// Creates a new builder-style object to manufacture [`GetV2LoggingOptionsInput`](crate::input::GetV2LoggingOptionsInput)
    pub fn builder() -> crate::input::get_v2_logging_options_input::Builder {
        crate::input::get_v2_logging_options_input::Builder::default()
    }
    /// Creates a new `GetV2LoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetV2LoggingOptions {
    type Output = std::result::Result<
        crate::output::GetV2LoggingOptionsOutput,
        crate::error::GetV2LoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_v2_logging_options_error(response)
        } else {
            crate::operation_deser::parse_get_v2_logging_options_response(response)
        }
    }
}

/// Operation shape for `ListActiveViolations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_active_violations`](crate::client::Client::list_active_violations).
///
/// See [`crate::client::fluent_builders::ListActiveViolations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListActiveViolations {
    _private: (),
}
impl ListActiveViolations {
    /// Creates a new builder-style object to manufacture [`ListActiveViolationsInput`](crate::input::ListActiveViolationsInput)
    pub fn builder() -> crate::input::list_active_violations_input::Builder {
        crate::input::list_active_violations_input::Builder::default()
    }
    /// Creates a new `ListActiveViolations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListActiveViolations {
    type Output = std::result::Result<
        crate::output::ListActiveViolationsOutput,
        crate::error::ListActiveViolationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_active_violations_error(response)
        } else {
            crate::operation_deser::parse_list_active_violations_response(response)
        }
    }
}

/// Operation shape for `ListAttachedPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attached_policies`](crate::client::Client::list_attached_policies).
///
/// See [`crate::client::fluent_builders::ListAttachedPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttachedPolicies {
    _private: (),
}
impl ListAttachedPolicies {
    /// Creates a new builder-style object to manufacture [`ListAttachedPoliciesInput`](crate::input::ListAttachedPoliciesInput)
    pub fn builder() -> crate::input::list_attached_policies_input::Builder {
        crate::input::list_attached_policies_input::Builder::default()
    }
    /// Creates a new `ListAttachedPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttachedPolicies {
    type Output = std::result::Result<
        crate::output::ListAttachedPoliciesOutput,
        crate::error::ListAttachedPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attached_policies_error(response)
        } else {
            crate::operation_deser::parse_list_attached_policies_response(response)
        }
    }
}

/// Operation shape for `ListAuditFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_audit_findings`](crate::client::Client::list_audit_findings).
///
/// See [`crate::client::fluent_builders::ListAuditFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAuditFindings {
    _private: (),
}
impl ListAuditFindings {
    /// Creates a new builder-style object to manufacture [`ListAuditFindingsInput`](crate::input::ListAuditFindingsInput)
    pub fn builder() -> crate::input::list_audit_findings_input::Builder {
        crate::input::list_audit_findings_input::Builder::default()
    }
    /// Creates a new `ListAuditFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAuditFindings {
    type Output = std::result::Result<
        crate::output::ListAuditFindingsOutput,
        crate::error::ListAuditFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_audit_findings_error(response)
        } else {
            crate::operation_deser::parse_list_audit_findings_response(response)
        }
    }
}

/// Operation shape for `ListAuditMitigationActionsExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_audit_mitigation_actions_executions`](crate::client::Client::list_audit_mitigation_actions_executions).
///
/// See [`crate::client::fluent_builders::ListAuditMitigationActionsExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAuditMitigationActionsExecutions {
    _private: (),
}
impl ListAuditMitigationActionsExecutions {
    /// Creates a new builder-style object to manufacture [`ListAuditMitigationActionsExecutionsInput`](crate::input::ListAuditMitigationActionsExecutionsInput)
    pub fn builder() -> crate::input::list_audit_mitigation_actions_executions_input::Builder {
        crate::input::list_audit_mitigation_actions_executions_input::Builder::default()
    }
    /// Creates a new `ListAuditMitigationActionsExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAuditMitigationActionsExecutions {
    type Output = std::result::Result<
        crate::output::ListAuditMitigationActionsExecutionsOutput,
        crate::error::ListAuditMitigationActionsExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_audit_mitigation_actions_executions_error(response)
        } else {
            crate::operation_deser::parse_list_audit_mitigation_actions_executions_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListAuditMitigationActionsTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_audit_mitigation_actions_tasks`](crate::client::Client::list_audit_mitigation_actions_tasks).
///
/// See [`crate::client::fluent_builders::ListAuditMitigationActionsTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAuditMitigationActionsTasks {
    _private: (),
}
impl ListAuditMitigationActionsTasks {
    /// Creates a new builder-style object to manufacture [`ListAuditMitigationActionsTasksInput`](crate::input::ListAuditMitigationActionsTasksInput)
    pub fn builder() -> crate::input::list_audit_mitigation_actions_tasks_input::Builder {
        crate::input::list_audit_mitigation_actions_tasks_input::Builder::default()
    }
    /// Creates a new `ListAuditMitigationActionsTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAuditMitigationActionsTasks {
    type Output = std::result::Result<
        crate::output::ListAuditMitigationActionsTasksOutput,
        crate::error::ListAuditMitigationActionsTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_audit_mitigation_actions_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_audit_mitigation_actions_tasks_response(response)
        }
    }
}

/// Operation shape for `ListAuditSuppressions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_audit_suppressions`](crate::client::Client::list_audit_suppressions).
///
/// See [`crate::client::fluent_builders::ListAuditSuppressions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAuditSuppressions {
    _private: (),
}
impl ListAuditSuppressions {
    /// Creates a new builder-style object to manufacture [`ListAuditSuppressionsInput`](crate::input::ListAuditSuppressionsInput)
    pub fn builder() -> crate::input::list_audit_suppressions_input::Builder {
        crate::input::list_audit_suppressions_input::Builder::default()
    }
    /// Creates a new `ListAuditSuppressions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAuditSuppressions {
    type Output = std::result::Result<
        crate::output::ListAuditSuppressionsOutput,
        crate::error::ListAuditSuppressionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_audit_suppressions_error(response)
        } else {
            crate::operation_deser::parse_list_audit_suppressions_response(response)
        }
    }
}

/// Operation shape for `ListAuditTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_audit_tasks`](crate::client::Client::list_audit_tasks).
///
/// See [`crate::client::fluent_builders::ListAuditTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAuditTasks {
    _private: (),
}
impl ListAuditTasks {
    /// Creates a new builder-style object to manufacture [`ListAuditTasksInput`](crate::input::ListAuditTasksInput)
    pub fn builder() -> crate::input::list_audit_tasks_input::Builder {
        crate::input::list_audit_tasks_input::Builder::default()
    }
    /// Creates a new `ListAuditTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAuditTasks {
    type Output =
        std::result::Result<crate::output::ListAuditTasksOutput, crate::error::ListAuditTasksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_audit_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_audit_tasks_response(response)
        }
    }
}

/// Operation shape for `ListAuthorizers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_authorizers`](crate::client::Client::list_authorizers).
///
/// See [`crate::client::fluent_builders::ListAuthorizers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAuthorizers {
    _private: (),
}
impl ListAuthorizers {
    /// Creates a new builder-style object to manufacture [`ListAuthorizersInput`](crate::input::ListAuthorizersInput)
    pub fn builder() -> crate::input::list_authorizers_input::Builder {
        crate::input::list_authorizers_input::Builder::default()
    }
    /// Creates a new `ListAuthorizers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAuthorizers {
    type Output = std::result::Result<
        crate::output::ListAuthorizersOutput,
        crate::error::ListAuthorizersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_authorizers_error(response)
        } else {
            crate::operation_deser::parse_list_authorizers_response(response)
        }
    }
}

/// Operation shape for `ListBillingGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_billing_groups`](crate::client::Client::list_billing_groups).
///
/// See [`crate::client::fluent_builders::ListBillingGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBillingGroups {
    _private: (),
}
impl ListBillingGroups {
    /// Creates a new builder-style object to manufacture [`ListBillingGroupsInput`](crate::input::ListBillingGroupsInput)
    pub fn builder() -> crate::input::list_billing_groups_input::Builder {
        crate::input::list_billing_groups_input::Builder::default()
    }
    /// Creates a new `ListBillingGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBillingGroups {
    type Output = std::result::Result<
        crate::output::ListBillingGroupsOutput,
        crate::error::ListBillingGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_billing_groups_error(response)
        } else {
            crate::operation_deser::parse_list_billing_groups_response(response)
        }
    }
}

/// Operation shape for `ListCACertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ca_certificates`](crate::client::Client::list_ca_certificates).
///
/// See [`crate::client::fluent_builders::ListCACertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCACertificates {
    _private: (),
}
impl ListCACertificates {
    /// Creates a new builder-style object to manufacture [`ListCaCertificatesInput`](crate::input::ListCaCertificatesInput)
    pub fn builder() -> crate::input::list_ca_certificates_input::Builder {
        crate::input::list_ca_certificates_input::Builder::default()
    }
    /// Creates a new `ListCACertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCACertificates {
    type Output = std::result::Result<
        crate::output::ListCaCertificatesOutput,
        crate::error::ListCACertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ca_certificates_error(response)
        } else {
            crate::operation_deser::parse_list_ca_certificates_response(response)
        }
    }
}

/// Operation shape for `ListCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_certificates`](crate::client::Client::list_certificates).
///
/// See [`crate::client::fluent_builders::ListCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCertificates {
    _private: (),
}
impl ListCertificates {
    /// Creates a new builder-style object to manufacture [`ListCertificatesInput`](crate::input::ListCertificatesInput)
    pub fn builder() -> crate::input::list_certificates_input::Builder {
        crate::input::list_certificates_input::Builder::default()
    }
    /// Creates a new `ListCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCertificates {
    type Output = std::result::Result<
        crate::output::ListCertificatesOutput,
        crate::error::ListCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_certificates_error(response)
        } else {
            crate::operation_deser::parse_list_certificates_response(response)
        }
    }
}

/// Operation shape for `ListCertificatesByCA`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_certificates_by_ca`](crate::client::Client::list_certificates_by_ca).
///
/// See [`crate::client::fluent_builders::ListCertificatesByCA`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCertificatesByCA {
    _private: (),
}
impl ListCertificatesByCA {
    /// Creates a new builder-style object to manufacture [`ListCertificatesByCaInput`](crate::input::ListCertificatesByCaInput)
    pub fn builder() -> crate::input::list_certificates_by_ca_input::Builder {
        crate::input::list_certificates_by_ca_input::Builder::default()
    }
    /// Creates a new `ListCertificatesByCA` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCertificatesByCA {
    type Output = std::result::Result<
        crate::output::ListCertificatesByCaOutput,
        crate::error::ListCertificatesByCAError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_certificates_by_ca_error(response)
        } else {
            crate::operation_deser::parse_list_certificates_by_ca_response(response)
        }
    }
}

/// Operation shape for `ListCustomMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_metrics`](crate::client::Client::list_custom_metrics).
///
/// See [`crate::client::fluent_builders::ListCustomMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomMetrics {
    _private: (),
}
impl ListCustomMetrics {
    /// Creates a new builder-style object to manufacture [`ListCustomMetricsInput`](crate::input::ListCustomMetricsInput)
    pub fn builder() -> crate::input::list_custom_metrics_input::Builder {
        crate::input::list_custom_metrics_input::Builder::default()
    }
    /// Creates a new `ListCustomMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomMetrics {
    type Output = std::result::Result<
        crate::output::ListCustomMetricsOutput,
        crate::error::ListCustomMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_metrics_error(response)
        } else {
            crate::operation_deser::parse_list_custom_metrics_response(response)
        }
    }
}

/// Operation shape for `ListDetectMitigationActionsExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_detect_mitigation_actions_executions`](crate::client::Client::list_detect_mitigation_actions_executions).
///
/// See [`crate::client::fluent_builders::ListDetectMitigationActionsExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDetectMitigationActionsExecutions {
    _private: (),
}
impl ListDetectMitigationActionsExecutions {
    /// Creates a new builder-style object to manufacture [`ListDetectMitigationActionsExecutionsInput`](crate::input::ListDetectMitigationActionsExecutionsInput)
    pub fn builder() -> crate::input::list_detect_mitigation_actions_executions_input::Builder {
        crate::input::list_detect_mitigation_actions_executions_input::Builder::default()
    }
    /// Creates a new `ListDetectMitigationActionsExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDetectMitigationActionsExecutions {
    type Output = std::result::Result<
        crate::output::ListDetectMitigationActionsExecutionsOutput,
        crate::error::ListDetectMitigationActionsExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_detect_mitigation_actions_executions_error(response)
        } else {
            crate::operation_deser::parse_list_detect_mitigation_actions_executions_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListDetectMitigationActionsTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_detect_mitigation_actions_tasks`](crate::client::Client::list_detect_mitigation_actions_tasks).
///
/// See [`crate::client::fluent_builders::ListDetectMitigationActionsTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDetectMitigationActionsTasks {
    _private: (),
}
impl ListDetectMitigationActionsTasks {
    /// Creates a new builder-style object to manufacture [`ListDetectMitigationActionsTasksInput`](crate::input::ListDetectMitigationActionsTasksInput)
    pub fn builder() -> crate::input::list_detect_mitigation_actions_tasks_input::Builder {
        crate::input::list_detect_mitigation_actions_tasks_input::Builder::default()
    }
    /// Creates a new `ListDetectMitigationActionsTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDetectMitigationActionsTasks {
    type Output = std::result::Result<
        crate::output::ListDetectMitigationActionsTasksOutput,
        crate::error::ListDetectMitigationActionsTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_detect_mitigation_actions_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_detect_mitigation_actions_tasks_response(response)
        }
    }
}

/// Operation shape for `ListDimensions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dimensions`](crate::client::Client::list_dimensions).
///
/// See [`crate::client::fluent_builders::ListDimensions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDimensions {
    _private: (),
}
impl ListDimensions {
    /// Creates a new builder-style object to manufacture [`ListDimensionsInput`](crate::input::ListDimensionsInput)
    pub fn builder() -> crate::input::list_dimensions_input::Builder {
        crate::input::list_dimensions_input::Builder::default()
    }
    /// Creates a new `ListDimensions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDimensions {
    type Output =
        std::result::Result<crate::output::ListDimensionsOutput, crate::error::ListDimensionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dimensions_error(response)
        } else {
            crate::operation_deser::parse_list_dimensions_response(response)
        }
    }
}

/// Operation shape for `ListDomainConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domain_configurations`](crate::client::Client::list_domain_configurations).
///
/// See [`crate::client::fluent_builders::ListDomainConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomainConfigurations {
    _private: (),
}
impl ListDomainConfigurations {
    /// Creates a new builder-style object to manufacture [`ListDomainConfigurationsInput`](crate::input::ListDomainConfigurationsInput)
    pub fn builder() -> crate::input::list_domain_configurations_input::Builder {
        crate::input::list_domain_configurations_input::Builder::default()
    }
    /// Creates a new `ListDomainConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomainConfigurations {
    type Output = std::result::Result<
        crate::output::ListDomainConfigurationsOutput,
        crate::error::ListDomainConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domain_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_domain_configurations_response(response)
        }
    }
}

/// Operation shape for `ListFleetMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_fleet_metrics`](crate::client::Client::list_fleet_metrics).
///
/// See [`crate::client::fluent_builders::ListFleetMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFleetMetrics {
    _private: (),
}
impl ListFleetMetrics {
    /// Creates a new builder-style object to manufacture [`ListFleetMetricsInput`](crate::input::ListFleetMetricsInput)
    pub fn builder() -> crate::input::list_fleet_metrics_input::Builder {
        crate::input::list_fleet_metrics_input::Builder::default()
    }
    /// Creates a new `ListFleetMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFleetMetrics {
    type Output = std::result::Result<
        crate::output::ListFleetMetricsOutput,
        crate::error::ListFleetMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_fleet_metrics_error(response)
        } else {
            crate::operation_deser::parse_list_fleet_metrics_response(response)
        }
    }
}

/// Operation shape for `ListIndices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_indices`](crate::client::Client::list_indices).
///
/// See [`crate::client::fluent_builders::ListIndices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIndices {
    _private: (),
}
impl ListIndices {
    /// Creates a new builder-style object to manufacture [`ListIndicesInput`](crate::input::ListIndicesInput)
    pub fn builder() -> crate::input::list_indices_input::Builder {
        crate::input::list_indices_input::Builder::default()
    }
    /// Creates a new `ListIndices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIndices {
    type Output =
        std::result::Result<crate::output::ListIndicesOutput, crate::error::ListIndicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_indices_error(response)
        } else {
            crate::operation_deser::parse_list_indices_response(response)
        }
    }
}

/// Operation shape for `ListJobExecutionsForJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_job_executions_for_job`](crate::client::Client::list_job_executions_for_job).
///
/// See [`crate::client::fluent_builders::ListJobExecutionsForJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobExecutionsForJob {
    _private: (),
}
impl ListJobExecutionsForJob {
    /// Creates a new builder-style object to manufacture [`ListJobExecutionsForJobInput`](crate::input::ListJobExecutionsForJobInput)
    pub fn builder() -> crate::input::list_job_executions_for_job_input::Builder {
        crate::input::list_job_executions_for_job_input::Builder::default()
    }
    /// Creates a new `ListJobExecutionsForJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobExecutionsForJob {
    type Output = std::result::Result<
        crate::output::ListJobExecutionsForJobOutput,
        crate::error::ListJobExecutionsForJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_job_executions_for_job_error(response)
        } else {
            crate::operation_deser::parse_list_job_executions_for_job_response(response)
        }
    }
}

/// Operation shape for `ListJobExecutionsForThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_job_executions_for_thing`](crate::client::Client::list_job_executions_for_thing).
///
/// See [`crate::client::fluent_builders::ListJobExecutionsForThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobExecutionsForThing {
    _private: (),
}
impl ListJobExecutionsForThing {
    /// Creates a new builder-style object to manufacture [`ListJobExecutionsForThingInput`](crate::input::ListJobExecutionsForThingInput)
    pub fn builder() -> crate::input::list_job_executions_for_thing_input::Builder {
        crate::input::list_job_executions_for_thing_input::Builder::default()
    }
    /// Creates a new `ListJobExecutionsForThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobExecutionsForThing {
    type Output = std::result::Result<
        crate::output::ListJobExecutionsForThingOutput,
        crate::error::ListJobExecutionsForThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_job_executions_for_thing_error(response)
        } else {
            crate::operation_deser::parse_list_job_executions_for_thing_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListJobTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_job_templates`](crate::client::Client::list_job_templates).
///
/// See [`crate::client::fluent_builders::ListJobTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobTemplates {
    _private: (),
}
impl ListJobTemplates {
    /// Creates a new builder-style object to manufacture [`ListJobTemplatesInput`](crate::input::ListJobTemplatesInput)
    pub fn builder() -> crate::input::list_job_templates_input::Builder {
        crate::input::list_job_templates_input::Builder::default()
    }
    /// Creates a new `ListJobTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobTemplates {
    type Output = std::result::Result<
        crate::output::ListJobTemplatesOutput,
        crate::error::ListJobTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_job_templates_error(response)
        } else {
            crate::operation_deser::parse_list_job_templates_response(response)
        }
    }
}

/// Operation shape for `ListManagedJobTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_managed_job_templates`](crate::client::Client::list_managed_job_templates).
///
/// See [`crate::client::fluent_builders::ListManagedJobTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListManagedJobTemplates {
    _private: (),
}
impl ListManagedJobTemplates {
    /// Creates a new builder-style object to manufacture [`ListManagedJobTemplatesInput`](crate::input::ListManagedJobTemplatesInput)
    pub fn builder() -> crate::input::list_managed_job_templates_input::Builder {
        crate::input::list_managed_job_templates_input::Builder::default()
    }
    /// Creates a new `ListManagedJobTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListManagedJobTemplates {
    type Output = std::result::Result<
        crate::output::ListManagedJobTemplatesOutput,
        crate::error::ListManagedJobTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_managed_job_templates_error(response)
        } else {
            crate::operation_deser::parse_list_managed_job_templates_response(response)
        }
    }
}

/// Operation shape for `ListMetricValues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_metric_values`](crate::client::Client::list_metric_values).
///
/// See [`crate::client::fluent_builders::ListMetricValues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMetricValues {
    _private: (),
}
impl ListMetricValues {
    /// Creates a new builder-style object to manufacture [`ListMetricValuesInput`](crate::input::ListMetricValuesInput)
    pub fn builder() -> crate::input::list_metric_values_input::Builder {
        crate::input::list_metric_values_input::Builder::default()
    }
    /// Creates a new `ListMetricValues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMetricValues {
    type Output = std::result::Result<
        crate::output::ListMetricValuesOutput,
        crate::error::ListMetricValuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_metric_values_error(response)
        } else {
            crate::operation_deser::parse_list_metric_values_response(response)
        }
    }
}

/// Operation shape for `ListMitigationActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_mitigation_actions`](crate::client::Client::list_mitigation_actions).
///
/// See [`crate::client::fluent_builders::ListMitigationActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMitigationActions {
    _private: (),
}
impl ListMitigationActions {
    /// Creates a new builder-style object to manufacture [`ListMitigationActionsInput`](crate::input::ListMitigationActionsInput)
    pub fn builder() -> crate::input::list_mitigation_actions_input::Builder {
        crate::input::list_mitigation_actions_input::Builder::default()
    }
    /// Creates a new `ListMitigationActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMitigationActions {
    type Output = std::result::Result<
        crate::output::ListMitigationActionsOutput,
        crate::error::ListMitigationActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_mitigation_actions_error(response)
        } else {
            crate::operation_deser::parse_list_mitigation_actions_response(response)
        }
    }
}

/// Operation shape for `ListOTAUpdates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ota_updates`](crate::client::Client::list_ota_updates).
///
/// See [`crate::client::fluent_builders::ListOTAUpdates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOTAUpdates {
    _private: (),
}
impl ListOTAUpdates {
    /// Creates a new builder-style object to manufacture [`ListOtaUpdatesInput`](crate::input::ListOtaUpdatesInput)
    pub fn builder() -> crate::input::list_ota_updates_input::Builder {
        crate::input::list_ota_updates_input::Builder::default()
    }
    /// Creates a new `ListOTAUpdates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOTAUpdates {
    type Output =
        std::result::Result<crate::output::ListOtaUpdatesOutput, crate::error::ListOTAUpdatesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ota_updates_error(response)
        } else {
            crate::operation_deser::parse_list_ota_updates_response(response)
        }
    }
}

/// Operation shape for `ListOutgoingCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_outgoing_certificates`](crate::client::Client::list_outgoing_certificates).
///
/// See [`crate::client::fluent_builders::ListOutgoingCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOutgoingCertificates {
    _private: (),
}
impl ListOutgoingCertificates {
    /// Creates a new builder-style object to manufacture [`ListOutgoingCertificatesInput`](crate::input::ListOutgoingCertificatesInput)
    pub fn builder() -> crate::input::list_outgoing_certificates_input::Builder {
        crate::input::list_outgoing_certificates_input::Builder::default()
    }
    /// Creates a new `ListOutgoingCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOutgoingCertificates {
    type Output = std::result::Result<
        crate::output::ListOutgoingCertificatesOutput,
        crate::error::ListOutgoingCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_outgoing_certificates_error(response)
        } else {
            crate::operation_deser::parse_list_outgoing_certificates_response(response)
        }
    }
}

/// Operation shape for `ListPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policies`](crate::client::Client::list_policies).
///
/// See [`crate::client::fluent_builders::ListPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPolicies {
    _private: (),
}
impl ListPolicies {
    /// Creates a new builder-style object to manufacture [`ListPoliciesInput`](crate::input::ListPoliciesInput)
    pub fn builder() -> crate::input::list_policies_input::Builder {
        crate::input::list_policies_input::Builder::default()
    }
    /// Creates a new `ListPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPolicies {
    type Output =
        std::result::Result<crate::output::ListPoliciesOutput, crate::error::ListPoliciesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policies_error(response)
        } else {
            crate::operation_deser::parse_list_policies_response(response)
        }
    }
}

/// Operation shape for `ListPolicyPrincipals`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policy_principals`](crate::client::Client::list_policy_principals).
///
/// See [`crate::client::fluent_builders::ListPolicyPrincipals`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPolicyPrincipals {
    _private: (),
}
impl ListPolicyPrincipals {
    /// Creates a new builder-style object to manufacture [`ListPolicyPrincipalsInput`](crate::input::ListPolicyPrincipalsInput)
    pub fn builder() -> crate::input::list_policy_principals_input::Builder {
        crate::input::list_policy_principals_input::Builder::default()
    }
    /// Creates a new `ListPolicyPrincipals` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPolicyPrincipals {
    type Output = std::result::Result<
        crate::output::ListPolicyPrincipalsOutput,
        crate::error::ListPolicyPrincipalsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policy_principals_error(response)
        } else {
            crate::operation_deser::parse_list_policy_principals_response(response)
        }
    }
}

/// Operation shape for `ListPolicyVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_policy_versions`](crate::client::Client::list_policy_versions).
///
/// See [`crate::client::fluent_builders::ListPolicyVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPolicyVersions {
    _private: (),
}
impl ListPolicyVersions {
    /// Creates a new builder-style object to manufacture [`ListPolicyVersionsInput`](crate::input::ListPolicyVersionsInput)
    pub fn builder() -> crate::input::list_policy_versions_input::Builder {
        crate::input::list_policy_versions_input::Builder::default()
    }
    /// Creates a new `ListPolicyVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPolicyVersions {
    type Output = std::result::Result<
        crate::output::ListPolicyVersionsOutput,
        crate::error::ListPolicyVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_policy_versions_error(response)
        } else {
            crate::operation_deser::parse_list_policy_versions_response(response)
        }
    }
}

/// Operation shape for `ListPrincipalPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_principal_policies`](crate::client::Client::list_principal_policies).
///
/// See [`crate::client::fluent_builders::ListPrincipalPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPrincipalPolicies {
    _private: (),
}
impl ListPrincipalPolicies {
    /// Creates a new builder-style object to manufacture [`ListPrincipalPoliciesInput`](crate::input::ListPrincipalPoliciesInput)
    pub fn builder() -> crate::input::list_principal_policies_input::Builder {
        crate::input::list_principal_policies_input::Builder::default()
    }
    /// Creates a new `ListPrincipalPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPrincipalPolicies {
    type Output = std::result::Result<
        crate::output::ListPrincipalPoliciesOutput,
        crate::error::ListPrincipalPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_principal_policies_error(response)
        } else {
            crate::operation_deser::parse_list_principal_policies_response(response)
        }
    }
}

/// Operation shape for `ListPrincipalThings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_principal_things`](crate::client::Client::list_principal_things).
///
/// See [`crate::client::fluent_builders::ListPrincipalThings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPrincipalThings {
    _private: (),
}
impl ListPrincipalThings {
    /// Creates a new builder-style object to manufacture [`ListPrincipalThingsInput`](crate::input::ListPrincipalThingsInput)
    pub fn builder() -> crate::input::list_principal_things_input::Builder {
        crate::input::list_principal_things_input::Builder::default()
    }
    /// Creates a new `ListPrincipalThings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPrincipalThings {
    type Output = std::result::Result<
        crate::output::ListPrincipalThingsOutput,
        crate::error::ListPrincipalThingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_principal_things_error(response)
        } else {
            crate::operation_deser::parse_list_principal_things_response(response)
        }
    }
}

/// Operation shape for `ListProvisioningTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_provisioning_templates`](crate::client::Client::list_provisioning_templates).
///
/// See [`crate::client::fluent_builders::ListProvisioningTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProvisioningTemplates {
    _private: (),
}
impl ListProvisioningTemplates {
    /// Creates a new builder-style object to manufacture [`ListProvisioningTemplatesInput`](crate::input::ListProvisioningTemplatesInput)
    pub fn builder() -> crate::input::list_provisioning_templates_input::Builder {
        crate::input::list_provisioning_templates_input::Builder::default()
    }
    /// Creates a new `ListProvisioningTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProvisioningTemplates {
    type Output = std::result::Result<
        crate::output::ListProvisioningTemplatesOutput,
        crate::error::ListProvisioningTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_provisioning_templates_error(response)
        } else {
            crate::operation_deser::parse_list_provisioning_templates_response(response)
        }
    }
}

/// Operation shape for `ListProvisioningTemplateVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_provisioning_template_versions`](crate::client::Client::list_provisioning_template_versions).
///
/// See [`crate::client::fluent_builders::ListProvisioningTemplateVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProvisioningTemplateVersions {
    _private: (),
}
impl ListProvisioningTemplateVersions {
    /// Creates a new builder-style object to manufacture [`ListProvisioningTemplateVersionsInput`](crate::input::ListProvisioningTemplateVersionsInput)
    pub fn builder() -> crate::input::list_provisioning_template_versions_input::Builder {
        crate::input::list_provisioning_template_versions_input::Builder::default()
    }
    /// Creates a new `ListProvisioningTemplateVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProvisioningTemplateVersions {
    type Output = std::result::Result<
        crate::output::ListProvisioningTemplateVersionsOutput,
        crate::error::ListProvisioningTemplateVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_provisioning_template_versions_error(response)
        } else {
            crate::operation_deser::parse_list_provisioning_template_versions_response(response)
        }
    }
}

/// Operation shape for `ListRoleAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_role_aliases`](crate::client::Client::list_role_aliases).
///
/// See [`crate::client::fluent_builders::ListRoleAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRoleAliases {
    _private: (),
}
impl ListRoleAliases {
    /// Creates a new builder-style object to manufacture [`ListRoleAliasesInput`](crate::input::ListRoleAliasesInput)
    pub fn builder() -> crate::input::list_role_aliases_input::Builder {
        crate::input::list_role_aliases_input::Builder::default()
    }
    /// Creates a new `ListRoleAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRoleAliases {
    type Output = std::result::Result<
        crate::output::ListRoleAliasesOutput,
        crate::error::ListRoleAliasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_role_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_role_aliases_response(response)
        }
    }
}

/// Operation shape for `ListScheduledAudits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_scheduled_audits`](crate::client::Client::list_scheduled_audits).
///
/// See [`crate::client::fluent_builders::ListScheduledAudits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListScheduledAudits {
    _private: (),
}
impl ListScheduledAudits {
    /// Creates a new builder-style object to manufacture [`ListScheduledAuditsInput`](crate::input::ListScheduledAuditsInput)
    pub fn builder() -> crate::input::list_scheduled_audits_input::Builder {
        crate::input::list_scheduled_audits_input::Builder::default()
    }
    /// Creates a new `ListScheduledAudits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListScheduledAudits {
    type Output = std::result::Result<
        crate::output::ListScheduledAuditsOutput,
        crate::error::ListScheduledAuditsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_scheduled_audits_error(response)
        } else {
            crate::operation_deser::parse_list_scheduled_audits_response(response)
        }
    }
}

/// Operation shape for `ListSecurityProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_security_profiles`](crate::client::Client::list_security_profiles).
///
/// See [`crate::client::fluent_builders::ListSecurityProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSecurityProfiles {
    _private: (),
}
impl ListSecurityProfiles {
    /// Creates a new builder-style object to manufacture [`ListSecurityProfilesInput`](crate::input::ListSecurityProfilesInput)
    pub fn builder() -> crate::input::list_security_profiles_input::Builder {
        crate::input::list_security_profiles_input::Builder::default()
    }
    /// Creates a new `ListSecurityProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSecurityProfiles {
    type Output = std::result::Result<
        crate::output::ListSecurityProfilesOutput,
        crate::error::ListSecurityProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_security_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_security_profiles_response(response)
        }
    }
}

/// Operation shape for `ListSecurityProfilesForTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_security_profiles_for_target`](crate::client::Client::list_security_profiles_for_target).
///
/// See [`crate::client::fluent_builders::ListSecurityProfilesForTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSecurityProfilesForTarget {
    _private: (),
}
impl ListSecurityProfilesForTarget {
    /// Creates a new builder-style object to manufacture [`ListSecurityProfilesForTargetInput`](crate::input::ListSecurityProfilesForTargetInput)
    pub fn builder() -> crate::input::list_security_profiles_for_target_input::Builder {
        crate::input::list_security_profiles_for_target_input::Builder::default()
    }
    /// Creates a new `ListSecurityProfilesForTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSecurityProfilesForTarget {
    type Output = std::result::Result<
        crate::output::ListSecurityProfilesForTargetOutput,
        crate::error::ListSecurityProfilesForTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_security_profiles_for_target_error(response)
        } else {
            crate::operation_deser::parse_list_security_profiles_for_target_response(response)
        }
    }
}

/// Operation shape for `ListStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_streams`](crate::client::Client::list_streams).
///
/// See [`crate::client::fluent_builders::ListStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStreams {
    _private: (),
}
impl ListStreams {
    /// Creates a new builder-style object to manufacture [`ListStreamsInput`](crate::input::ListStreamsInput)
    pub fn builder() -> crate::input::list_streams_input::Builder {
        crate::input::list_streams_input::Builder::default()
    }
    /// Creates a new `ListStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStreams {
    type Output =
        std::result::Result<crate::output::ListStreamsOutput, crate::error::ListStreamsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_streams_error(response)
        } else {
            crate::operation_deser::parse_list_streams_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTargetsForPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_targets_for_policy`](crate::client::Client::list_targets_for_policy).
///
/// See [`crate::client::fluent_builders::ListTargetsForPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTargetsForPolicy {
    _private: (),
}
impl ListTargetsForPolicy {
    /// Creates a new builder-style object to manufacture [`ListTargetsForPolicyInput`](crate::input::ListTargetsForPolicyInput)
    pub fn builder() -> crate::input::list_targets_for_policy_input::Builder {
        crate::input::list_targets_for_policy_input::Builder::default()
    }
    /// Creates a new `ListTargetsForPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTargetsForPolicy {
    type Output = std::result::Result<
        crate::output::ListTargetsForPolicyOutput,
        crate::error::ListTargetsForPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_targets_for_policy_error(response)
        } else {
            crate::operation_deser::parse_list_targets_for_policy_response(response)
        }
    }
}

/// Operation shape for `ListTargetsForSecurityProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_targets_for_security_profile`](crate::client::Client::list_targets_for_security_profile).
///
/// See [`crate::client::fluent_builders::ListTargetsForSecurityProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTargetsForSecurityProfile {
    _private: (),
}
impl ListTargetsForSecurityProfile {
    /// Creates a new builder-style object to manufacture [`ListTargetsForSecurityProfileInput`](crate::input::ListTargetsForSecurityProfileInput)
    pub fn builder() -> crate::input::list_targets_for_security_profile_input::Builder {
        crate::input::list_targets_for_security_profile_input::Builder::default()
    }
    /// Creates a new `ListTargetsForSecurityProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTargetsForSecurityProfile {
    type Output = std::result::Result<
        crate::output::ListTargetsForSecurityProfileOutput,
        crate::error::ListTargetsForSecurityProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_targets_for_security_profile_error(response)
        } else {
            crate::operation_deser::parse_list_targets_for_security_profile_response(response)
        }
    }
}

/// Operation shape for `ListThingGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_thing_groups`](crate::client::Client::list_thing_groups).
///
/// See [`crate::client::fluent_builders::ListThingGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingGroups {
    _private: (),
}
impl ListThingGroups {
    /// Creates a new builder-style object to manufacture [`ListThingGroupsInput`](crate::input::ListThingGroupsInput)
    pub fn builder() -> crate::input::list_thing_groups_input::Builder {
        crate::input::list_thing_groups_input::Builder::default()
    }
    /// Creates a new `ListThingGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingGroups {
    type Output = std::result::Result<
        crate::output::ListThingGroupsOutput,
        crate::error::ListThingGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_thing_groups_error(response)
        } else {
            crate::operation_deser::parse_list_thing_groups_response(response)
        }
    }
}

/// Operation shape for `ListThingGroupsForThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_thing_groups_for_thing`](crate::client::Client::list_thing_groups_for_thing).
///
/// See [`crate::client::fluent_builders::ListThingGroupsForThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingGroupsForThing {
    _private: (),
}
impl ListThingGroupsForThing {
    /// Creates a new builder-style object to manufacture [`ListThingGroupsForThingInput`](crate::input::ListThingGroupsForThingInput)
    pub fn builder() -> crate::input::list_thing_groups_for_thing_input::Builder {
        crate::input::list_thing_groups_for_thing_input::Builder::default()
    }
    /// Creates a new `ListThingGroupsForThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingGroupsForThing {
    type Output = std::result::Result<
        crate::output::ListThingGroupsForThingOutput,
        crate::error::ListThingGroupsForThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_thing_groups_for_thing_error(response)
        } else {
            crate::operation_deser::parse_list_thing_groups_for_thing_response(response)
        }
    }
}

/// Operation shape for `ListThingPrincipals`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_thing_principals`](crate::client::Client::list_thing_principals).
///
/// See [`crate::client::fluent_builders::ListThingPrincipals`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingPrincipals {
    _private: (),
}
impl ListThingPrincipals {
    /// Creates a new builder-style object to manufacture [`ListThingPrincipalsInput`](crate::input::ListThingPrincipalsInput)
    pub fn builder() -> crate::input::list_thing_principals_input::Builder {
        crate::input::list_thing_principals_input::Builder::default()
    }
    /// Creates a new `ListThingPrincipals` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingPrincipals {
    type Output = std::result::Result<
        crate::output::ListThingPrincipalsOutput,
        crate::error::ListThingPrincipalsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_thing_principals_error(response)
        } else {
            crate::operation_deser::parse_list_thing_principals_response(response)
        }
    }
}

/// Operation shape for `ListThingRegistrationTaskReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_thing_registration_task_reports`](crate::client::Client::list_thing_registration_task_reports).
///
/// See [`crate::client::fluent_builders::ListThingRegistrationTaskReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingRegistrationTaskReports {
    _private: (),
}
impl ListThingRegistrationTaskReports {
    /// Creates a new builder-style object to manufacture [`ListThingRegistrationTaskReportsInput`](crate::input::ListThingRegistrationTaskReportsInput)
    pub fn builder() -> crate::input::list_thing_registration_task_reports_input::Builder {
        crate::input::list_thing_registration_task_reports_input::Builder::default()
    }
    /// Creates a new `ListThingRegistrationTaskReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingRegistrationTaskReports {
    type Output = std::result::Result<
        crate::output::ListThingRegistrationTaskReportsOutput,
        crate::error::ListThingRegistrationTaskReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_thing_registration_task_reports_error(response)
        } else {
            crate::operation_deser::parse_list_thing_registration_task_reports_response(response)
        }
    }
}

/// Operation shape for `ListThingRegistrationTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_thing_registration_tasks`](crate::client::Client::list_thing_registration_tasks).
///
/// See [`crate::client::fluent_builders::ListThingRegistrationTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingRegistrationTasks {
    _private: (),
}
impl ListThingRegistrationTasks {
    /// Creates a new builder-style object to manufacture [`ListThingRegistrationTasksInput`](crate::input::ListThingRegistrationTasksInput)
    pub fn builder() -> crate::input::list_thing_registration_tasks_input::Builder {
        crate::input::list_thing_registration_tasks_input::Builder::default()
    }
    /// Creates a new `ListThingRegistrationTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingRegistrationTasks {
    type Output = std::result::Result<
        crate::output::ListThingRegistrationTasksOutput,
        crate::error::ListThingRegistrationTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_thing_registration_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_thing_registration_tasks_response(response)
        }
    }
}

/// Operation shape for `ListThings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_things`](crate::client::Client::list_things).
///
/// See [`crate::client::fluent_builders::ListThings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThings {
    _private: (),
}
impl ListThings {
    /// Creates a new builder-style object to manufacture [`ListThingsInput`](crate::input::ListThingsInput)
    pub fn builder() -> crate::input::list_things_input::Builder {
        crate::input::list_things_input::Builder::default()
    }
    /// Creates a new `ListThings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThings {
    type Output =
        std::result::Result<crate::output::ListThingsOutput, crate::error::ListThingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_things_error(response)
        } else {
            crate::operation_deser::parse_list_things_response(response)
        }
    }
}

/// Operation shape for `ListThingsInBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_things_in_billing_group`](crate::client::Client::list_things_in_billing_group).
///
/// See [`crate::client::fluent_builders::ListThingsInBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingsInBillingGroup {
    _private: (),
}
impl ListThingsInBillingGroup {
    /// Creates a new builder-style object to manufacture [`ListThingsInBillingGroupInput`](crate::input::ListThingsInBillingGroupInput)
    pub fn builder() -> crate::input::list_things_in_billing_group_input::Builder {
        crate::input::list_things_in_billing_group_input::Builder::default()
    }
    /// Creates a new `ListThingsInBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingsInBillingGroup {
    type Output = std::result::Result<
        crate::output::ListThingsInBillingGroupOutput,
        crate::error::ListThingsInBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_things_in_billing_group_error(response)
        } else {
            crate::operation_deser::parse_list_things_in_billing_group_response(response)
        }
    }
}

/// Operation shape for `ListThingsInThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_things_in_thing_group`](crate::client::Client::list_things_in_thing_group).
///
/// See [`crate::client::fluent_builders::ListThingsInThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingsInThingGroup {
    _private: (),
}
impl ListThingsInThingGroup {
    /// Creates a new builder-style object to manufacture [`ListThingsInThingGroupInput`](crate::input::ListThingsInThingGroupInput)
    pub fn builder() -> crate::input::list_things_in_thing_group_input::Builder {
        crate::input::list_things_in_thing_group_input::Builder::default()
    }
    /// Creates a new `ListThingsInThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingsInThingGroup {
    type Output = std::result::Result<
        crate::output::ListThingsInThingGroupOutput,
        crate::error::ListThingsInThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_things_in_thing_group_error(response)
        } else {
            crate::operation_deser::parse_list_things_in_thing_group_response(response)
        }
    }
}

/// Operation shape for `ListThingTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_thing_types`](crate::client::Client::list_thing_types).
///
/// See [`crate::client::fluent_builders::ListThingTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThingTypes {
    _private: (),
}
impl ListThingTypes {
    /// Creates a new builder-style object to manufacture [`ListThingTypesInput`](crate::input::ListThingTypesInput)
    pub fn builder() -> crate::input::list_thing_types_input::Builder {
        crate::input::list_thing_types_input::Builder::default()
    }
    /// Creates a new `ListThingTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThingTypes {
    type Output =
        std::result::Result<crate::output::ListThingTypesOutput, crate::error::ListThingTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_thing_types_error(response)
        } else {
            crate::operation_deser::parse_list_thing_types_response(response)
        }
    }
}

/// Operation shape for `ListTopicRuleDestinations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_topic_rule_destinations`](crate::client::Client::list_topic_rule_destinations).
///
/// See [`crate::client::fluent_builders::ListTopicRuleDestinations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTopicRuleDestinations {
    _private: (),
}
impl ListTopicRuleDestinations {
    /// Creates a new builder-style object to manufacture [`ListTopicRuleDestinationsInput`](crate::input::ListTopicRuleDestinationsInput)
    pub fn builder() -> crate::input::list_topic_rule_destinations_input::Builder {
        crate::input::list_topic_rule_destinations_input::Builder::default()
    }
    /// Creates a new `ListTopicRuleDestinations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTopicRuleDestinations {
    type Output = std::result::Result<
        crate::output::ListTopicRuleDestinationsOutput,
        crate::error::ListTopicRuleDestinationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_topic_rule_destinations_error(response)
        } else {
            crate::operation_deser::parse_list_topic_rule_destinations_response(response)
        }
    }
}

/// Operation shape for `ListTopicRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_topic_rules`](crate::client::Client::list_topic_rules).
///
/// See [`crate::client::fluent_builders::ListTopicRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTopicRules {
    _private: (),
}
impl ListTopicRules {
    /// Creates a new builder-style object to manufacture [`ListTopicRulesInput`](crate::input::ListTopicRulesInput)
    pub fn builder() -> crate::input::list_topic_rules_input::Builder {
        crate::input::list_topic_rules_input::Builder::default()
    }
    /// Creates a new `ListTopicRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTopicRules {
    type Output =
        std::result::Result<crate::output::ListTopicRulesOutput, crate::error::ListTopicRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_topic_rules_error(response)
        } else {
            crate::operation_deser::parse_list_topic_rules_response(response)
        }
    }
}

/// Operation shape for `ListV2LoggingLevels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_v2_logging_levels`](crate::client::Client::list_v2_logging_levels).
///
/// See [`crate::client::fluent_builders::ListV2LoggingLevels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListV2LoggingLevels {
    _private: (),
}
impl ListV2LoggingLevels {
    /// Creates a new builder-style object to manufacture [`ListV2LoggingLevelsInput`](crate::input::ListV2LoggingLevelsInput)
    pub fn builder() -> crate::input::list_v2_logging_levels_input::Builder {
        crate::input::list_v2_logging_levels_input::Builder::default()
    }
    /// Creates a new `ListV2LoggingLevels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListV2LoggingLevels {
    type Output = std::result::Result<
        crate::output::ListV2LoggingLevelsOutput,
        crate::error::ListV2LoggingLevelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_v2_logging_levels_error(response)
        } else {
            crate::operation_deser::parse_list_v2_logging_levels_response(response)
        }
    }
}

/// Operation shape for `ListViolationEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_violation_events`](crate::client::Client::list_violation_events).
///
/// See [`crate::client::fluent_builders::ListViolationEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListViolationEvents {
    _private: (),
}
impl ListViolationEvents {
    /// Creates a new builder-style object to manufacture [`ListViolationEventsInput`](crate::input::ListViolationEventsInput)
    pub fn builder() -> crate::input::list_violation_events_input::Builder {
        crate::input::list_violation_events_input::Builder::default()
    }
    /// Creates a new `ListViolationEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListViolationEvents {
    type Output = std::result::Result<
        crate::output::ListViolationEventsOutput,
        crate::error::ListViolationEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_violation_events_error(response)
        } else {
            crate::operation_deser::parse_list_violation_events_response(response)
        }
    }
}

/// Operation shape for `PutVerificationStateOnViolation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_verification_state_on_violation`](crate::client::Client::put_verification_state_on_violation).
///
/// See [`crate::client::fluent_builders::PutVerificationStateOnViolation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutVerificationStateOnViolation {
    _private: (),
}
impl PutVerificationStateOnViolation {
    /// Creates a new builder-style object to manufacture [`PutVerificationStateOnViolationInput`](crate::input::PutVerificationStateOnViolationInput)
    pub fn builder() -> crate::input::put_verification_state_on_violation_input::Builder {
        crate::input::put_verification_state_on_violation_input::Builder::default()
    }
    /// Creates a new `PutVerificationStateOnViolation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutVerificationStateOnViolation {
    type Output = std::result::Result<
        crate::output::PutVerificationStateOnViolationOutput,
        crate::error::PutVerificationStateOnViolationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_verification_state_on_violation_error(response)
        } else {
            crate::operation_deser::parse_put_verification_state_on_violation_response(response)
        }
    }
}

/// Operation shape for `RegisterCACertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_ca_certificate`](crate::client::Client::register_ca_certificate).
///
/// See [`crate::client::fluent_builders::RegisterCACertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterCACertificate {
    _private: (),
}
impl RegisterCACertificate {
    /// Creates a new builder-style object to manufacture [`RegisterCaCertificateInput`](crate::input::RegisterCaCertificateInput)
    pub fn builder() -> crate::input::register_ca_certificate_input::Builder {
        crate::input::register_ca_certificate_input::Builder::default()
    }
    /// Creates a new `RegisterCACertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterCACertificate {
    type Output = std::result::Result<
        crate::output::RegisterCaCertificateOutput,
        crate::error::RegisterCACertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_ca_certificate_error(response)
        } else {
            crate::operation_deser::parse_register_ca_certificate_response(response)
        }
    }
}

/// Operation shape for `RegisterCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_certificate`](crate::client::Client::register_certificate).
///
/// See [`crate::client::fluent_builders::RegisterCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterCertificate {
    _private: (),
}
impl RegisterCertificate {
    /// Creates a new builder-style object to manufacture [`RegisterCertificateInput`](crate::input::RegisterCertificateInput)
    pub fn builder() -> crate::input::register_certificate_input::Builder {
        crate::input::register_certificate_input::Builder::default()
    }
    /// Creates a new `RegisterCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterCertificate {
    type Output = std::result::Result<
        crate::output::RegisterCertificateOutput,
        crate::error::RegisterCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_certificate_error(response)
        } else {
            crate::operation_deser::parse_register_certificate_response(response)
        }
    }
}

/// Operation shape for `RegisterCertificateWithoutCA`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_certificate_without_ca`](crate::client::Client::register_certificate_without_ca).
///
/// See [`crate::client::fluent_builders::RegisterCertificateWithoutCA`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterCertificateWithoutCA {
    _private: (),
}
impl RegisterCertificateWithoutCA {
    /// Creates a new builder-style object to manufacture [`RegisterCertificateWithoutCaInput`](crate::input::RegisterCertificateWithoutCaInput)
    pub fn builder() -> crate::input::register_certificate_without_ca_input::Builder {
        crate::input::register_certificate_without_ca_input::Builder::default()
    }
    /// Creates a new `RegisterCertificateWithoutCA` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterCertificateWithoutCA {
    type Output = std::result::Result<
        crate::output::RegisterCertificateWithoutCaOutput,
        crate::error::RegisterCertificateWithoutCAError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_certificate_without_ca_error(response)
        } else {
            crate::operation_deser::parse_register_certificate_without_ca_response(response)
        }
    }
}

/// Operation shape for `RegisterThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_thing`](crate::client::Client::register_thing).
///
/// See [`crate::client::fluent_builders::RegisterThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterThing {
    _private: (),
}
impl RegisterThing {
    /// Creates a new builder-style object to manufacture [`RegisterThingInput`](crate::input::RegisterThingInput)
    pub fn builder() -> crate::input::register_thing_input::Builder {
        crate::input::register_thing_input::Builder::default()
    }
    /// Creates a new `RegisterThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterThing {
    type Output =
        std::result::Result<crate::output::RegisterThingOutput, crate::error::RegisterThingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_thing_error(response)
        } else {
            crate::operation_deser::parse_register_thing_response(response)
        }
    }
}

/// Operation shape for `RejectCertificateTransfer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_certificate_transfer`](crate::client::Client::reject_certificate_transfer).
///
/// See [`crate::client::fluent_builders::RejectCertificateTransfer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectCertificateTransfer {
    _private: (),
}
impl RejectCertificateTransfer {
    /// Creates a new builder-style object to manufacture [`RejectCertificateTransferInput`](crate::input::RejectCertificateTransferInput)
    pub fn builder() -> crate::input::reject_certificate_transfer_input::Builder {
        crate::input::reject_certificate_transfer_input::Builder::default()
    }
    /// Creates a new `RejectCertificateTransfer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectCertificateTransfer {
    type Output = std::result::Result<
        crate::output::RejectCertificateTransferOutput,
        crate::error::RejectCertificateTransferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_certificate_transfer_error(response)
        } else {
            crate::operation_deser::parse_reject_certificate_transfer_response(response)
        }
    }
}

/// Operation shape for `RemoveThingFromBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_thing_from_billing_group`](crate::client::Client::remove_thing_from_billing_group).
///
/// See [`crate::client::fluent_builders::RemoveThingFromBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveThingFromBillingGroup {
    _private: (),
}
impl RemoveThingFromBillingGroup {
    /// Creates a new builder-style object to manufacture [`RemoveThingFromBillingGroupInput`](crate::input::RemoveThingFromBillingGroupInput)
    pub fn builder() -> crate::input::remove_thing_from_billing_group_input::Builder {
        crate::input::remove_thing_from_billing_group_input::Builder::default()
    }
    /// Creates a new `RemoveThingFromBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveThingFromBillingGroup {
    type Output = std::result::Result<
        crate::output::RemoveThingFromBillingGroupOutput,
        crate::error::RemoveThingFromBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_thing_from_billing_group_error(response)
        } else {
            crate::operation_deser::parse_remove_thing_from_billing_group_response(response)
        }
    }
}

/// Operation shape for `RemoveThingFromThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_thing_from_thing_group`](crate::client::Client::remove_thing_from_thing_group).
///
/// See [`crate::client::fluent_builders::RemoveThingFromThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveThingFromThingGroup {
    _private: (),
}
impl RemoveThingFromThingGroup {
    /// Creates a new builder-style object to manufacture [`RemoveThingFromThingGroupInput`](crate::input::RemoveThingFromThingGroupInput)
    pub fn builder() -> crate::input::remove_thing_from_thing_group_input::Builder {
        crate::input::remove_thing_from_thing_group_input::Builder::default()
    }
    /// Creates a new `RemoveThingFromThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveThingFromThingGroup {
    type Output = std::result::Result<
        crate::output::RemoveThingFromThingGroupOutput,
        crate::error::RemoveThingFromThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_thing_from_thing_group_error(response)
        } else {
            crate::operation_deser::parse_remove_thing_from_thing_group_response(response)
        }
    }
}

/// Operation shape for `ReplaceTopicRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replace_topic_rule`](crate::client::Client::replace_topic_rule).
///
/// See [`crate::client::fluent_builders::ReplaceTopicRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplaceTopicRule {
    _private: (),
}
impl ReplaceTopicRule {
    /// Creates a new builder-style object to manufacture [`ReplaceTopicRuleInput`](crate::input::ReplaceTopicRuleInput)
    pub fn builder() -> crate::input::replace_topic_rule_input::Builder {
        crate::input::replace_topic_rule_input::Builder::default()
    }
    /// Creates a new `ReplaceTopicRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplaceTopicRule {
    type Output = std::result::Result<
        crate::output::ReplaceTopicRuleOutput,
        crate::error::ReplaceTopicRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replace_topic_rule_error(response)
        } else {
            crate::operation_deser::parse_replace_topic_rule_response(response)
        }
    }
}

/// Operation shape for `SearchIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_index`](crate::client::Client::search_index).
///
/// See [`crate::client::fluent_builders::SearchIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchIndex {
    _private: (),
}
impl SearchIndex {
    /// Creates a new builder-style object to manufacture [`SearchIndexInput`](crate::input::SearchIndexInput)
    pub fn builder() -> crate::input::search_index_input::Builder {
        crate::input::search_index_input::Builder::default()
    }
    /// Creates a new `SearchIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchIndex {
    type Output =
        std::result::Result<crate::output::SearchIndexOutput, crate::error::SearchIndexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_index_error(response)
        } else {
            crate::operation_deser::parse_search_index_response(response)
        }
    }
}

/// Operation shape for `SetDefaultAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_default_authorizer`](crate::client::Client::set_default_authorizer).
///
/// See [`crate::client::fluent_builders::SetDefaultAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetDefaultAuthorizer {
    _private: (),
}
impl SetDefaultAuthorizer {
    /// Creates a new builder-style object to manufacture [`SetDefaultAuthorizerInput`](crate::input::SetDefaultAuthorizerInput)
    pub fn builder() -> crate::input::set_default_authorizer_input::Builder {
        crate::input::set_default_authorizer_input::Builder::default()
    }
    /// Creates a new `SetDefaultAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetDefaultAuthorizer {
    type Output = std::result::Result<
        crate::output::SetDefaultAuthorizerOutput,
        crate::error::SetDefaultAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_default_authorizer_error(response)
        } else {
            crate::operation_deser::parse_set_default_authorizer_response(response)
        }
    }
}

/// Operation shape for `SetDefaultPolicyVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_default_policy_version`](crate::client::Client::set_default_policy_version).
///
/// See [`crate::client::fluent_builders::SetDefaultPolicyVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetDefaultPolicyVersion {
    _private: (),
}
impl SetDefaultPolicyVersion {
    /// Creates a new builder-style object to manufacture [`SetDefaultPolicyVersionInput`](crate::input::SetDefaultPolicyVersionInput)
    pub fn builder() -> crate::input::set_default_policy_version_input::Builder {
        crate::input::set_default_policy_version_input::Builder::default()
    }
    /// Creates a new `SetDefaultPolicyVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetDefaultPolicyVersion {
    type Output = std::result::Result<
        crate::output::SetDefaultPolicyVersionOutput,
        crate::error::SetDefaultPolicyVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_default_policy_version_error(response)
        } else {
            crate::operation_deser::parse_set_default_policy_version_response(response)
        }
    }
}

/// Operation shape for `SetLoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_logging_options`](crate::client::Client::set_logging_options).
///
/// See [`crate::client::fluent_builders::SetLoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetLoggingOptions {
    _private: (),
}
impl SetLoggingOptions {
    /// Creates a new builder-style object to manufacture [`SetLoggingOptionsInput`](crate::input::SetLoggingOptionsInput)
    pub fn builder() -> crate::input::set_logging_options_input::Builder {
        crate::input::set_logging_options_input::Builder::default()
    }
    /// Creates a new `SetLoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetLoggingOptions {
    type Output = std::result::Result<
        crate::output::SetLoggingOptionsOutput,
        crate::error::SetLoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_logging_options_error(response)
        } else {
            crate::operation_deser::parse_set_logging_options_response(response)
        }
    }
}

/// Operation shape for `SetV2LoggingLevel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_v2_logging_level`](crate::client::Client::set_v2_logging_level).
///
/// See [`crate::client::fluent_builders::SetV2LoggingLevel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetV2LoggingLevel {
    _private: (),
}
impl SetV2LoggingLevel {
    /// Creates a new builder-style object to manufacture [`SetV2LoggingLevelInput`](crate::input::SetV2LoggingLevelInput)
    pub fn builder() -> crate::input::set_v2_logging_level_input::Builder {
        crate::input::set_v2_logging_level_input::Builder::default()
    }
    /// Creates a new `SetV2LoggingLevel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetV2LoggingLevel {
    type Output = std::result::Result<
        crate::output::SetV2LoggingLevelOutput,
        crate::error::SetV2LoggingLevelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_v2_logging_level_error(response)
        } else {
            crate::operation_deser::parse_set_v2_logging_level_response(response)
        }
    }
}

/// Operation shape for `SetV2LoggingOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_v2_logging_options`](crate::client::Client::set_v2_logging_options).
///
/// See [`crate::client::fluent_builders::SetV2LoggingOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetV2LoggingOptions {
    _private: (),
}
impl SetV2LoggingOptions {
    /// Creates a new builder-style object to manufacture [`SetV2LoggingOptionsInput`](crate::input::SetV2LoggingOptionsInput)
    pub fn builder() -> crate::input::set_v2_logging_options_input::Builder {
        crate::input::set_v2_logging_options_input::Builder::default()
    }
    /// Creates a new `SetV2LoggingOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetV2LoggingOptions {
    type Output = std::result::Result<
        crate::output::SetV2LoggingOptionsOutput,
        crate::error::SetV2LoggingOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_v2_logging_options_error(response)
        } else {
            crate::operation_deser::parse_set_v2_logging_options_response(response)
        }
    }
}

/// Operation shape for `StartAuditMitigationActionsTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_audit_mitigation_actions_task`](crate::client::Client::start_audit_mitigation_actions_task).
///
/// See [`crate::client::fluent_builders::StartAuditMitigationActionsTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAuditMitigationActionsTask {
    _private: (),
}
impl StartAuditMitigationActionsTask {
    /// Creates a new builder-style object to manufacture [`StartAuditMitigationActionsTaskInput`](crate::input::StartAuditMitigationActionsTaskInput)
    pub fn builder() -> crate::input::start_audit_mitigation_actions_task_input::Builder {
        crate::input::start_audit_mitigation_actions_task_input::Builder::default()
    }
    /// Creates a new `StartAuditMitigationActionsTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAuditMitigationActionsTask {
    type Output = std::result::Result<
        crate::output::StartAuditMitigationActionsTaskOutput,
        crate::error::StartAuditMitigationActionsTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_audit_mitigation_actions_task_error(response)
        } else {
            crate::operation_deser::parse_start_audit_mitigation_actions_task_response(response)
        }
    }
}

/// Operation shape for `StartDetectMitigationActionsTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_detect_mitigation_actions_task`](crate::client::Client::start_detect_mitigation_actions_task).
///
/// See [`crate::client::fluent_builders::StartDetectMitigationActionsTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDetectMitigationActionsTask {
    _private: (),
}
impl StartDetectMitigationActionsTask {
    /// Creates a new builder-style object to manufacture [`StartDetectMitigationActionsTaskInput`](crate::input::StartDetectMitigationActionsTaskInput)
    pub fn builder() -> crate::input::start_detect_mitigation_actions_task_input::Builder {
        crate::input::start_detect_mitigation_actions_task_input::Builder::default()
    }
    /// Creates a new `StartDetectMitigationActionsTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDetectMitigationActionsTask {
    type Output = std::result::Result<
        crate::output::StartDetectMitigationActionsTaskOutput,
        crate::error::StartDetectMitigationActionsTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_detect_mitigation_actions_task_error(response)
        } else {
            crate::operation_deser::parse_start_detect_mitigation_actions_task_response(response)
        }
    }
}

/// Operation shape for `StartOnDemandAuditTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_on_demand_audit_task`](crate::client::Client::start_on_demand_audit_task).
///
/// See [`crate::client::fluent_builders::StartOnDemandAuditTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartOnDemandAuditTask {
    _private: (),
}
impl StartOnDemandAuditTask {
    /// Creates a new builder-style object to manufacture [`StartOnDemandAuditTaskInput`](crate::input::StartOnDemandAuditTaskInput)
    pub fn builder() -> crate::input::start_on_demand_audit_task_input::Builder {
        crate::input::start_on_demand_audit_task_input::Builder::default()
    }
    /// Creates a new `StartOnDemandAuditTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartOnDemandAuditTask {
    type Output = std::result::Result<
        crate::output::StartOnDemandAuditTaskOutput,
        crate::error::StartOnDemandAuditTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_on_demand_audit_task_error(response)
        } else {
            crate::operation_deser::parse_start_on_demand_audit_task_response(response)
        }
    }
}

/// Operation shape for `StartThingRegistrationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_thing_registration_task`](crate::client::Client::start_thing_registration_task).
///
/// See [`crate::client::fluent_builders::StartThingRegistrationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartThingRegistrationTask {
    _private: (),
}
impl StartThingRegistrationTask {
    /// Creates a new builder-style object to manufacture [`StartThingRegistrationTaskInput`](crate::input::StartThingRegistrationTaskInput)
    pub fn builder() -> crate::input::start_thing_registration_task_input::Builder {
        crate::input::start_thing_registration_task_input::Builder::default()
    }
    /// Creates a new `StartThingRegistrationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartThingRegistrationTask {
    type Output = std::result::Result<
        crate::output::StartThingRegistrationTaskOutput,
        crate::error::StartThingRegistrationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_thing_registration_task_error(response)
        } else {
            crate::operation_deser::parse_start_thing_registration_task_response(response)
        }
    }
}

/// Operation shape for `StopThingRegistrationTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_thing_registration_task`](crate::client::Client::stop_thing_registration_task).
///
/// See [`crate::client::fluent_builders::StopThingRegistrationTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopThingRegistrationTask {
    _private: (),
}
impl StopThingRegistrationTask {
    /// Creates a new builder-style object to manufacture [`StopThingRegistrationTaskInput`](crate::input::StopThingRegistrationTaskInput)
    pub fn builder() -> crate::input::stop_thing_registration_task_input::Builder {
        crate::input::stop_thing_registration_task_input::Builder::default()
    }
    /// Creates a new `StopThingRegistrationTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopThingRegistrationTask {
    type Output = std::result::Result<
        crate::output::StopThingRegistrationTaskOutput,
        crate::error::StopThingRegistrationTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_thing_registration_task_error(response)
        } else {
            crate::operation_deser::parse_stop_thing_registration_task_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_authorization`](crate::client::Client::test_authorization).
///
/// See [`crate::client::fluent_builders::TestAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestAuthorization {
    _private: (),
}
impl TestAuthorization {
    /// Creates a new builder-style object to manufacture [`TestAuthorizationInput`](crate::input::TestAuthorizationInput)
    pub fn builder() -> crate::input::test_authorization_input::Builder {
        crate::input::test_authorization_input::Builder::default()
    }
    /// Creates a new `TestAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestAuthorization {
    type Output = std::result::Result<
        crate::output::TestAuthorizationOutput,
        crate::error::TestAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_authorization_error(response)
        } else {
            crate::operation_deser::parse_test_authorization_response(response)
        }
    }
}

/// Operation shape for `TestInvokeAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_invoke_authorizer`](crate::client::Client::test_invoke_authorizer).
///
/// See [`crate::client::fluent_builders::TestInvokeAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestInvokeAuthorizer {
    _private: (),
}
impl TestInvokeAuthorizer {
    /// Creates a new builder-style object to manufacture [`TestInvokeAuthorizerInput`](crate::input::TestInvokeAuthorizerInput)
    pub fn builder() -> crate::input::test_invoke_authorizer_input::Builder {
        crate::input::test_invoke_authorizer_input::Builder::default()
    }
    /// Creates a new `TestInvokeAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestInvokeAuthorizer {
    type Output = std::result::Result<
        crate::output::TestInvokeAuthorizerOutput,
        crate::error::TestInvokeAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_invoke_authorizer_error(response)
        } else {
            crate::operation_deser::parse_test_invoke_authorizer_response(response)
        }
    }
}

/// Operation shape for `TransferCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`transfer_certificate`](crate::client::Client::transfer_certificate).
///
/// See [`crate::client::fluent_builders::TransferCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TransferCertificate {
    _private: (),
}
impl TransferCertificate {
    /// Creates a new builder-style object to manufacture [`TransferCertificateInput`](crate::input::TransferCertificateInput)
    pub fn builder() -> crate::input::transfer_certificate_input::Builder {
        crate::input::transfer_certificate_input::Builder::default()
    }
    /// Creates a new `TransferCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TransferCertificate {
    type Output = std::result::Result<
        crate::output::TransferCertificateOutput,
        crate::error::TransferCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_transfer_certificate_error(response)
        } else {
            crate::operation_deser::parse_transfer_certificate_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccountAuditConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_account_audit_configuration`](crate::client::Client::update_account_audit_configuration).
///
/// See [`crate::client::fluent_builders::UpdateAccountAuditConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccountAuditConfiguration {
    _private: (),
}
impl UpdateAccountAuditConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateAccountAuditConfigurationInput`](crate::input::UpdateAccountAuditConfigurationInput)
    pub fn builder() -> crate::input::update_account_audit_configuration_input::Builder {
        crate::input::update_account_audit_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateAccountAuditConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccountAuditConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateAccountAuditConfigurationOutput,
        crate::error::UpdateAccountAuditConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_account_audit_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_account_audit_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateAuditSuppression`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_audit_suppression`](crate::client::Client::update_audit_suppression).
///
/// See [`crate::client::fluent_builders::UpdateAuditSuppression`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAuditSuppression {
    _private: (),
}
impl UpdateAuditSuppression {
    /// Creates a new builder-style object to manufacture [`UpdateAuditSuppressionInput`](crate::input::UpdateAuditSuppressionInput)
    pub fn builder() -> crate::input::update_audit_suppression_input::Builder {
        crate::input::update_audit_suppression_input::Builder::default()
    }
    /// Creates a new `UpdateAuditSuppression` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAuditSuppression {
    type Output = std::result::Result<
        crate::output::UpdateAuditSuppressionOutput,
        crate::error::UpdateAuditSuppressionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_audit_suppression_error(response)
        } else {
            crate::operation_deser::parse_update_audit_suppression_response(response)
        }
    }
}

/// Operation shape for `UpdateAuthorizer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_authorizer`](crate::client::Client::update_authorizer).
///
/// See [`crate::client::fluent_builders::UpdateAuthorizer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAuthorizer {
    _private: (),
}
impl UpdateAuthorizer {
    /// Creates a new builder-style object to manufacture [`UpdateAuthorizerInput`](crate::input::UpdateAuthorizerInput)
    pub fn builder() -> crate::input::update_authorizer_input::Builder {
        crate::input::update_authorizer_input::Builder::default()
    }
    /// Creates a new `UpdateAuthorizer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAuthorizer {
    type Output = std::result::Result<
        crate::output::UpdateAuthorizerOutput,
        crate::error::UpdateAuthorizerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_authorizer_error(response)
        } else {
            crate::operation_deser::parse_update_authorizer_response(response)
        }
    }
}

/// Operation shape for `UpdateBillingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_billing_group`](crate::client::Client::update_billing_group).
///
/// See [`crate::client::fluent_builders::UpdateBillingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBillingGroup {
    _private: (),
}
impl UpdateBillingGroup {
    /// Creates a new builder-style object to manufacture [`UpdateBillingGroupInput`](crate::input::UpdateBillingGroupInput)
    pub fn builder() -> crate::input::update_billing_group_input::Builder {
        crate::input::update_billing_group_input::Builder::default()
    }
    /// Creates a new `UpdateBillingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBillingGroup {
    type Output = std::result::Result<
        crate::output::UpdateBillingGroupOutput,
        crate::error::UpdateBillingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_billing_group_error(response)
        } else {
            crate::operation_deser::parse_update_billing_group_response(response)
        }
    }
}

/// Operation shape for `UpdateCACertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ca_certificate`](crate::client::Client::update_ca_certificate).
///
/// See [`crate::client::fluent_builders::UpdateCACertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCACertificate {
    _private: (),
}
impl UpdateCACertificate {
    /// Creates a new builder-style object to manufacture [`UpdateCaCertificateInput`](crate::input::UpdateCaCertificateInput)
    pub fn builder() -> crate::input::update_ca_certificate_input::Builder {
        crate::input::update_ca_certificate_input::Builder::default()
    }
    /// Creates a new `UpdateCACertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCACertificate {
    type Output = std::result::Result<
        crate::output::UpdateCaCertificateOutput,
        crate::error::UpdateCACertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ca_certificate_error(response)
        } else {
            crate::operation_deser::parse_update_ca_certificate_response(response)
        }
    }
}

/// Operation shape for `UpdateCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_certificate`](crate::client::Client::update_certificate).
///
/// See [`crate::client::fluent_builders::UpdateCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCertificate {
    _private: (),
}
impl UpdateCertificate {
    /// Creates a new builder-style object to manufacture [`UpdateCertificateInput`](crate::input::UpdateCertificateInput)
    pub fn builder() -> crate::input::update_certificate_input::Builder {
        crate::input::update_certificate_input::Builder::default()
    }
    /// Creates a new `UpdateCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCertificate {
    type Output = std::result::Result<
        crate::output::UpdateCertificateOutput,
        crate::error::UpdateCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_certificate_error(response)
        } else {
            crate::operation_deser::parse_update_certificate_response(response)
        }
    }
}

/// Operation shape for `UpdateCustomMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_custom_metric`](crate::client::Client::update_custom_metric).
///
/// See [`crate::client::fluent_builders::UpdateCustomMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCustomMetric {
    _private: (),
}
impl UpdateCustomMetric {
    /// Creates a new builder-style object to manufacture [`UpdateCustomMetricInput`](crate::input::UpdateCustomMetricInput)
    pub fn builder() -> crate::input::update_custom_metric_input::Builder {
        crate::input::update_custom_metric_input::Builder::default()
    }
    /// Creates a new `UpdateCustomMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCustomMetric {
    type Output = std::result::Result<
        crate::output::UpdateCustomMetricOutput,
        crate::error::UpdateCustomMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_custom_metric_error(response)
        } else {
            crate::operation_deser::parse_update_custom_metric_response(response)
        }
    }
}

/// Operation shape for `UpdateDimension`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dimension`](crate::client::Client::update_dimension).
///
/// See [`crate::client::fluent_builders::UpdateDimension`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDimension {
    _private: (),
}
impl UpdateDimension {
    /// Creates a new builder-style object to manufacture [`UpdateDimensionInput`](crate::input::UpdateDimensionInput)
    pub fn builder() -> crate::input::update_dimension_input::Builder {
        crate::input::update_dimension_input::Builder::default()
    }
    /// Creates a new `UpdateDimension` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDimension {
    type Output = std::result::Result<
        crate::output::UpdateDimensionOutput,
        crate::error::UpdateDimensionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dimension_error(response)
        } else {
            crate::operation_deser::parse_update_dimension_response(response)
        }
    }
}

/// Operation shape for `UpdateDomainConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain_configuration`](crate::client::Client::update_domain_configuration).
///
/// See [`crate::client::fluent_builders::UpdateDomainConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomainConfiguration {
    _private: (),
}
impl UpdateDomainConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateDomainConfigurationInput`](crate::input::UpdateDomainConfigurationInput)
    pub fn builder() -> crate::input::update_domain_configuration_input::Builder {
        crate::input::update_domain_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateDomainConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomainConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateDomainConfigurationOutput,
        crate::error::UpdateDomainConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_domain_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateDynamicThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dynamic_thing_group`](crate::client::Client::update_dynamic_thing_group).
///
/// See [`crate::client::fluent_builders::UpdateDynamicThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDynamicThingGroup {
    _private: (),
}
impl UpdateDynamicThingGroup {
    /// Creates a new builder-style object to manufacture [`UpdateDynamicThingGroupInput`](crate::input::UpdateDynamicThingGroupInput)
    pub fn builder() -> crate::input::update_dynamic_thing_group_input::Builder {
        crate::input::update_dynamic_thing_group_input::Builder::default()
    }
    /// Creates a new `UpdateDynamicThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDynamicThingGroup {
    type Output = std::result::Result<
        crate::output::UpdateDynamicThingGroupOutput,
        crate::error::UpdateDynamicThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dynamic_thing_group_error(response)
        } else {
            crate::operation_deser::parse_update_dynamic_thing_group_response(response)
        }
    }
}

/// Operation shape for `UpdateEventConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_event_configurations`](crate::client::Client::update_event_configurations).
///
/// See [`crate::client::fluent_builders::UpdateEventConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEventConfigurations {
    _private: (),
}
impl UpdateEventConfigurations {
    /// Creates a new builder-style object to manufacture [`UpdateEventConfigurationsInput`](crate::input::UpdateEventConfigurationsInput)
    pub fn builder() -> crate::input::update_event_configurations_input::Builder {
        crate::input::update_event_configurations_input::Builder::default()
    }
    /// Creates a new `UpdateEventConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEventConfigurations {
    type Output = std::result::Result<
        crate::output::UpdateEventConfigurationsOutput,
        crate::error::UpdateEventConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_event_configurations_error(response)
        } else {
            crate::operation_deser::parse_update_event_configurations_response(response)
        }
    }
}

/// Operation shape for `UpdateFleetMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_fleet_metric`](crate::client::Client::update_fleet_metric).
///
/// See [`crate::client::fluent_builders::UpdateFleetMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFleetMetric {
    _private: (),
}
impl UpdateFleetMetric {
    /// Creates a new builder-style object to manufacture [`UpdateFleetMetricInput`](crate::input::UpdateFleetMetricInput)
    pub fn builder() -> crate::input::update_fleet_metric_input::Builder {
        crate::input::update_fleet_metric_input::Builder::default()
    }
    /// Creates a new `UpdateFleetMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFleetMetric {
    type Output = std::result::Result<
        crate::output::UpdateFleetMetricOutput,
        crate::error::UpdateFleetMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_fleet_metric_error(response)
        } else {
            crate::operation_deser::parse_update_fleet_metric_response(response)
        }
    }
}

/// Operation shape for `UpdateIndexingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_indexing_configuration`](crate::client::Client::update_indexing_configuration).
///
/// See [`crate::client::fluent_builders::UpdateIndexingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIndexingConfiguration {
    _private: (),
}
impl UpdateIndexingConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateIndexingConfigurationInput`](crate::input::UpdateIndexingConfigurationInput)
    pub fn builder() -> crate::input::update_indexing_configuration_input::Builder {
        crate::input::update_indexing_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateIndexingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIndexingConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateIndexingConfigurationOutput,
        crate::error::UpdateIndexingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_indexing_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_indexing_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_job`](crate::client::Client::update_job).
///
/// See [`crate::client::fluent_builders::UpdateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateJob {
    _private: (),
}
impl UpdateJob {
    /// Creates a new builder-style object to manufacture [`UpdateJobInput`](crate::input::UpdateJobInput)
    pub fn builder() -> crate::input::update_job_input::Builder {
        crate::input::update_job_input::Builder::default()
    }
    /// Creates a new `UpdateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateJob {
    type Output = std::result::Result<crate::output::UpdateJobOutput, crate::error::UpdateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_job_error(response)
        } else {
            crate::operation_deser::parse_update_job_response(response)
        }
    }
}

/// Operation shape for `UpdateMitigationAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_mitigation_action`](crate::client::Client::update_mitigation_action).
///
/// See [`crate::client::fluent_builders::UpdateMitigationAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMitigationAction {
    _private: (),
}
impl UpdateMitigationAction {
    /// Creates a new builder-style object to manufacture [`UpdateMitigationActionInput`](crate::input::UpdateMitigationActionInput)
    pub fn builder() -> crate::input::update_mitigation_action_input::Builder {
        crate::input::update_mitigation_action_input::Builder::default()
    }
    /// Creates a new `UpdateMitigationAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMitigationAction {
    type Output = std::result::Result<
        crate::output::UpdateMitigationActionOutput,
        crate::error::UpdateMitigationActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_mitigation_action_error(response)
        } else {
            crate::operation_deser::parse_update_mitigation_action_response(response)
        }
    }
}

/// Operation shape for `UpdateProvisioningTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_provisioning_template`](crate::client::Client::update_provisioning_template).
///
/// See [`crate::client::fluent_builders::UpdateProvisioningTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProvisioningTemplate {
    _private: (),
}
impl UpdateProvisioningTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateProvisioningTemplateInput`](crate::input::UpdateProvisioningTemplateInput)
    pub fn builder() -> crate::input::update_provisioning_template_input::Builder {
        crate::input::update_provisioning_template_input::Builder::default()
    }
    /// Creates a new `UpdateProvisioningTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProvisioningTemplate {
    type Output = std::result::Result<
        crate::output::UpdateProvisioningTemplateOutput,
        crate::error::UpdateProvisioningTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_provisioning_template_error(response)
        } else {
            crate::operation_deser::parse_update_provisioning_template_response(response)
        }
    }
}

/// Operation shape for `UpdateRoleAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_role_alias`](crate::client::Client::update_role_alias).
///
/// See [`crate::client::fluent_builders::UpdateRoleAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRoleAlias {
    _private: (),
}
impl UpdateRoleAlias {
    /// Creates a new builder-style object to manufacture [`UpdateRoleAliasInput`](crate::input::UpdateRoleAliasInput)
    pub fn builder() -> crate::input::update_role_alias_input::Builder {
        crate::input::update_role_alias_input::Builder::default()
    }
    /// Creates a new `UpdateRoleAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRoleAlias {
    type Output = std::result::Result<
        crate::output::UpdateRoleAliasOutput,
        crate::error::UpdateRoleAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_role_alias_error(response)
        } else {
            crate::operation_deser::parse_update_role_alias_response(response)
        }
    }
}

/// Operation shape for `UpdateScheduledAudit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_scheduled_audit`](crate::client::Client::update_scheduled_audit).
///
/// See [`crate::client::fluent_builders::UpdateScheduledAudit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateScheduledAudit {
    _private: (),
}
impl UpdateScheduledAudit {
    /// Creates a new builder-style object to manufacture [`UpdateScheduledAuditInput`](crate::input::UpdateScheduledAuditInput)
    pub fn builder() -> crate::input::update_scheduled_audit_input::Builder {
        crate::input::update_scheduled_audit_input::Builder::default()
    }
    /// Creates a new `UpdateScheduledAudit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateScheduledAudit {
    type Output = std::result::Result<
        crate::output::UpdateScheduledAuditOutput,
        crate::error::UpdateScheduledAuditError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_scheduled_audit_error(response)
        } else {
            crate::operation_deser::parse_update_scheduled_audit_response(response)
        }
    }
}

/// Operation shape for `UpdateSecurityProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_security_profile`](crate::client::Client::update_security_profile).
///
/// See [`crate::client::fluent_builders::UpdateSecurityProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSecurityProfile {
    _private: (),
}
impl UpdateSecurityProfile {
    /// Creates a new builder-style object to manufacture [`UpdateSecurityProfileInput`](crate::input::UpdateSecurityProfileInput)
    pub fn builder() -> crate::input::update_security_profile_input::Builder {
        crate::input::update_security_profile_input::Builder::default()
    }
    /// Creates a new `UpdateSecurityProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSecurityProfile {
    type Output = std::result::Result<
        crate::output::UpdateSecurityProfileOutput,
        crate::error::UpdateSecurityProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_security_profile_error(response)
        } else {
            crate::operation_deser::parse_update_security_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stream`](crate::client::Client::update_stream).
///
/// See [`crate::client::fluent_builders::UpdateStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStream {
    _private: (),
}
impl UpdateStream {
    /// Creates a new builder-style object to manufacture [`UpdateStreamInput`](crate::input::UpdateStreamInput)
    pub fn builder() -> crate::input::update_stream_input::Builder {
        crate::input::update_stream_input::Builder::default()
    }
    /// Creates a new `UpdateStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStream {
    type Output =
        std::result::Result<crate::output::UpdateStreamOutput, crate::error::UpdateStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stream_error(response)
        } else {
            crate::operation_deser::parse_update_stream_response(response)
        }
    }
}

/// Operation shape for `UpdateThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_thing`](crate::client::Client::update_thing).
///
/// See [`crate::client::fluent_builders::UpdateThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThing {
    _private: (),
}
impl UpdateThing {
    /// Creates a new builder-style object to manufacture [`UpdateThingInput`](crate::input::UpdateThingInput)
    pub fn builder() -> crate::input::update_thing_input::Builder {
        crate::input::update_thing_input::Builder::default()
    }
    /// Creates a new `UpdateThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThing {
    type Output =
        std::result::Result<crate::output::UpdateThingOutput, crate::error::UpdateThingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_thing_error(response)
        } else {
            crate::operation_deser::parse_update_thing_response(response)
        }
    }
}

/// Operation shape for `UpdateThingGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_thing_group`](crate::client::Client::update_thing_group).
///
/// See [`crate::client::fluent_builders::UpdateThingGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThingGroup {
    _private: (),
}
impl UpdateThingGroup {
    /// Creates a new builder-style object to manufacture [`UpdateThingGroupInput`](crate::input::UpdateThingGroupInput)
    pub fn builder() -> crate::input::update_thing_group_input::Builder {
        crate::input::update_thing_group_input::Builder::default()
    }
    /// Creates a new `UpdateThingGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThingGroup {
    type Output = std::result::Result<
        crate::output::UpdateThingGroupOutput,
        crate::error::UpdateThingGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_thing_group_error(response)
        } else {
            crate::operation_deser::parse_update_thing_group_response(response)
        }
    }
}

/// Operation shape for `UpdateThingGroupsForThing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_thing_groups_for_thing`](crate::client::Client::update_thing_groups_for_thing).
///
/// See [`crate::client::fluent_builders::UpdateThingGroupsForThing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThingGroupsForThing {
    _private: (),
}
impl UpdateThingGroupsForThing {
    /// Creates a new builder-style object to manufacture [`UpdateThingGroupsForThingInput`](crate::input::UpdateThingGroupsForThingInput)
    pub fn builder() -> crate::input::update_thing_groups_for_thing_input::Builder {
        crate::input::update_thing_groups_for_thing_input::Builder::default()
    }
    /// Creates a new `UpdateThingGroupsForThing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThingGroupsForThing {
    type Output = std::result::Result<
        crate::output::UpdateThingGroupsForThingOutput,
        crate::error::UpdateThingGroupsForThingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_thing_groups_for_thing_error(response)
        } else {
            crate::operation_deser::parse_update_thing_groups_for_thing_response(response)
        }
    }
}

/// Operation shape for `UpdateTopicRuleDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_topic_rule_destination`](crate::client::Client::update_topic_rule_destination).
///
/// See [`crate::client::fluent_builders::UpdateTopicRuleDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTopicRuleDestination {
    _private: (),
}
impl UpdateTopicRuleDestination {
    /// Creates a new builder-style object to manufacture [`UpdateTopicRuleDestinationInput`](crate::input::UpdateTopicRuleDestinationInput)
    pub fn builder() -> crate::input::update_topic_rule_destination_input::Builder {
        crate::input::update_topic_rule_destination_input::Builder::default()
    }
    /// Creates a new `UpdateTopicRuleDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTopicRuleDestination {
    type Output = std::result::Result<
        crate::output::UpdateTopicRuleDestinationOutput,
        crate::error::UpdateTopicRuleDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_topic_rule_destination_error(response)
        } else {
            crate::operation_deser::parse_update_topic_rule_destination_response(response)
        }
    }
}

/// Operation shape for `ValidateSecurityProfileBehaviors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`validate_security_profile_behaviors`](crate::client::Client::validate_security_profile_behaviors).
///
/// See [`crate::client::fluent_builders::ValidateSecurityProfileBehaviors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ValidateSecurityProfileBehaviors {
    _private: (),
}
impl ValidateSecurityProfileBehaviors {
    /// Creates a new builder-style object to manufacture [`ValidateSecurityProfileBehaviorsInput`](crate::input::ValidateSecurityProfileBehaviorsInput)
    pub fn builder() -> crate::input::validate_security_profile_behaviors_input::Builder {
        crate::input::validate_security_profile_behaviors_input::Builder::default()
    }
    /// Creates a new `ValidateSecurityProfileBehaviors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ValidateSecurityProfileBehaviors {
    type Output = std::result::Result<
        crate::output::ValidateSecurityProfileBehaviorsOutput,
        crate::error::ValidateSecurityProfileBehaviorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_validate_security_profile_behaviors_error(response)
        } else {
            crate::operation_deser::parse_validate_security_profile_behaviors_response(response)
        }
    }
}
