// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about an error found in a behavior specification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationError {
    /// <p>The description of an error found in the behaviors.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl ValidationError {
    /// <p>The description of an error found in the behaviors.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for ValidationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationError");
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ValidationError`](crate::model::ValidationError)
pub mod validation_error {
    /// A builder for [`ValidationError`](crate::model::ValidationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The description of an error found in the behaviors.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The description of an error found in the behaviors.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationError`](crate::model::ValidationError)
        pub fn build(self) -> crate::model::ValidationError {
            crate::model::ValidationError {
                error_message: self.error_message,
            }
        }
    }
}
impl ValidationError {
    /// Creates a new builder-style object to manufacture [`ValidationError`](crate::model::ValidationError)
    pub fn builder() -> crate::model::validation_error::Builder {
        crate::model::validation_error::Builder::default()
    }
}

/// <p>A Device Defender security profile behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Behavior {
    /// <p>The name
    /// you've given to the behavior.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>What is measured by the behavior.</p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The dimension for a metric in your behavior. For example, using a
    /// <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. This can't be used with custom metrics.</p>
    pub metric_dimension: std::option::Option<crate::model::MetricDimension>,
    /// <p>The criteria that determine if a device is behaving normally in regard to
    /// the <code>metric</code>.</p>
    pub criteria: std::option::Option<crate::model::BehaviorCriteria>,
    /// <p>
    /// Suppresses alerts.
    /// </p>
    pub suppress_alerts: std::option::Option<bool>,
}
impl Behavior {
    /// <p>The name
    /// you've given to the behavior.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>What is measured by the behavior.</p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The dimension for a metric in your behavior. For example, using a
    /// <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. This can't be used with custom metrics.</p>
    pub fn metric_dimension(&self) -> std::option::Option<&crate::model::MetricDimension> {
        self.metric_dimension.as_ref()
    }
    /// <p>The criteria that determine if a device is behaving normally in regard to
    /// the <code>metric</code>.</p>
    pub fn criteria(&self) -> std::option::Option<&crate::model::BehaviorCriteria> {
        self.criteria.as_ref()
    }
    /// <p>
    /// Suppresses alerts.
    /// </p>
    pub fn suppress_alerts(&self) -> std::option::Option<bool> {
        self.suppress_alerts
    }
}
impl std::fmt::Debug for Behavior {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Behavior");
        formatter.field("name", &self.name);
        formatter.field("metric", &self.metric);
        formatter.field("metric_dimension", &self.metric_dimension);
        formatter.field("criteria", &self.criteria);
        formatter.field("suppress_alerts", &self.suppress_alerts);
        formatter.finish()
    }
}
/// See [`Behavior`](crate::model::Behavior)
pub mod behavior {
    /// A builder for [`Behavior`](crate::model::Behavior)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) metric_dimension: std::option::Option<crate::model::MetricDimension>,
        pub(crate) criteria: std::option::Option<crate::model::BehaviorCriteria>,
        pub(crate) suppress_alerts: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name
        /// you've given to the behavior.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name
        /// you've given to the behavior.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>What is measured by the behavior.</p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>What is measured by the behavior.</p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The dimension for a metric in your behavior. For example, using a
        /// <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. This can't be used with custom metrics.</p>
        pub fn metric_dimension(mut self, input: crate::model::MetricDimension) -> Self {
            self.metric_dimension = Some(input);
            self
        }
        /// <p>The dimension for a metric in your behavior. For example, using a
        /// <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. This can't be used with custom metrics.</p>
        pub fn set_metric_dimension(
            mut self,
            input: std::option::Option<crate::model::MetricDimension>,
        ) -> Self {
            self.metric_dimension = input;
            self
        }
        /// <p>The criteria that determine if a device is behaving normally in regard to
        /// the <code>metric</code>.</p>
        pub fn criteria(mut self, input: crate::model::BehaviorCriteria) -> Self {
            self.criteria = Some(input);
            self
        }
        /// <p>The criteria that determine if a device is behaving normally in regard to
        /// the <code>metric</code>.</p>
        pub fn set_criteria(
            mut self,
            input: std::option::Option<crate::model::BehaviorCriteria>,
        ) -> Self {
            self.criteria = input;
            self
        }
        /// <p>
        /// Suppresses alerts.
        /// </p>
        pub fn suppress_alerts(mut self, input: bool) -> Self {
            self.suppress_alerts = Some(input);
            self
        }
        /// <p>
        /// Suppresses alerts.
        /// </p>
        pub fn set_suppress_alerts(mut self, input: std::option::Option<bool>) -> Self {
            self.suppress_alerts = input;
            self
        }
        /// Consumes the builder and constructs a [`Behavior`](crate::model::Behavior)
        pub fn build(self) -> crate::model::Behavior {
            crate::model::Behavior {
                name: self.name,
                metric: self.metric,
                metric_dimension: self.metric_dimension,
                criteria: self.criteria,
                suppress_alerts: self.suppress_alerts,
            }
        }
    }
}
impl Behavior {
    /// Creates a new builder-style object to manufacture [`Behavior`](crate::model::Behavior)
    pub fn builder() -> crate::model::behavior::Builder {
        crate::model::behavior::Builder::default()
    }
}

/// <p>The criteria by which the behavior is determined to be normal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BehaviorCriteria {
    /// <p>The operator that relates the thing measured (<code>metric</code>) to the criteria
    /// (containing a <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and <code>greater-than-equals</code>
    /// </p>
    /// </li>
    /// </ul>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>The value to be compared with the <code>metric</code>.</p>
    pub value: std::option::Option<crate::model::MetricValue>,
    /// <p>Use this to specify the time duration over which the behavior is evaluated, for those criteria that
    /// have a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a
    /// <code>statisticalThreshhold</code> metric comparison, measurements from all devices are
    /// accumulated over this time duration before being used to calculate percentiles, and later,
    /// measurements from an individual device are also accumulated over this time duration before
    /// being given a percentile rank. Cannot be used with list-based metric datatypes.</p>
    pub duration_seconds: std::option::Option<i32>,
    /// <p>If a device is in violation of the behavior for the specified number of consecutive
    /// datapoints, an alarm occurs. If not specified, the default is 1.</p>
    pub consecutive_datapoints_to_alarm: std::option::Option<i32>,
    /// <p>If an alarm has occurred and the offending device is no longer in violation of the behavior
    /// for the specified number of consecutive datapoints, the alarm is cleared. If not specified,
    /// the default is 1.</p>
    pub consecutive_datapoints_to_clear: std::option::Option<i32>,
    /// <p>A statistical ranking (percentile)that
    /// indicates a threshold value by which a behavior is determined to be in compliance or in
    /// violation of the behavior.</p>
    pub statistical_threshold: std::option::Option<crate::model::StatisticalThreshold>,
    /// <p>
    /// The configuration of an ML Detect
    /// </p>
    pub ml_detection_config: std::option::Option<crate::model::MachineLearningDetectionConfig>,
}
impl BehaviorCriteria {
    /// <p>The operator that relates the thing measured (<code>metric</code>) to the criteria
    /// (containing a <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and <code>greater-than-equals</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>The value to be compared with the <code>metric</code>.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::MetricValue> {
        self.value.as_ref()
    }
    /// <p>Use this to specify the time duration over which the behavior is evaluated, for those criteria that
    /// have a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a
    /// <code>statisticalThreshhold</code> metric comparison, measurements from all devices are
    /// accumulated over this time duration before being used to calculate percentiles, and later,
    /// measurements from an individual device are also accumulated over this time duration before
    /// being given a percentile rank. Cannot be used with list-based metric datatypes.</p>
    pub fn duration_seconds(&self) -> std::option::Option<i32> {
        self.duration_seconds
    }
    /// <p>If a device is in violation of the behavior for the specified number of consecutive
    /// datapoints, an alarm occurs. If not specified, the default is 1.</p>
    pub fn consecutive_datapoints_to_alarm(&self) -> std::option::Option<i32> {
        self.consecutive_datapoints_to_alarm
    }
    /// <p>If an alarm has occurred and the offending device is no longer in violation of the behavior
    /// for the specified number of consecutive datapoints, the alarm is cleared. If not specified,
    /// the default is 1.</p>
    pub fn consecutive_datapoints_to_clear(&self) -> std::option::Option<i32> {
        self.consecutive_datapoints_to_clear
    }
    /// <p>A statistical ranking (percentile)that
    /// indicates a threshold value by which a behavior is determined to be in compliance or in
    /// violation of the behavior.</p>
    pub fn statistical_threshold(
        &self,
    ) -> std::option::Option<&crate::model::StatisticalThreshold> {
        self.statistical_threshold.as_ref()
    }
    /// <p>
    /// The configuration of an ML Detect
    /// </p>
    pub fn ml_detection_config(
        &self,
    ) -> std::option::Option<&crate::model::MachineLearningDetectionConfig> {
        self.ml_detection_config.as_ref()
    }
}
impl std::fmt::Debug for BehaviorCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BehaviorCriteria");
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("value", &self.value);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field(
            "consecutive_datapoints_to_alarm",
            &self.consecutive_datapoints_to_alarm,
        );
        formatter.field(
            "consecutive_datapoints_to_clear",
            &self.consecutive_datapoints_to_clear,
        );
        formatter.field("statistical_threshold", &self.statistical_threshold);
        formatter.field("ml_detection_config", &self.ml_detection_config);
        formatter.finish()
    }
}
/// See [`BehaviorCriteria`](crate::model::BehaviorCriteria)
pub mod behavior_criteria {
    /// A builder for [`BehaviorCriteria`](crate::model::BehaviorCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) value: std::option::Option<crate::model::MetricValue>,
        pub(crate) duration_seconds: std::option::Option<i32>,
        pub(crate) consecutive_datapoints_to_alarm: std::option::Option<i32>,
        pub(crate) consecutive_datapoints_to_clear: std::option::Option<i32>,
        pub(crate) statistical_threshold: std::option::Option<crate::model::StatisticalThreshold>,
        pub(crate) ml_detection_config:
            std::option::Option<crate::model::MachineLearningDetectionConfig>,
    }
    impl Builder {
        /// <p>The operator that relates the thing measured (<code>metric</code>) to the criteria
        /// (containing a <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and <code>greater-than-equals</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>The operator that relates the thing measured (<code>metric</code>) to the criteria
        /// (containing a <code>value</code> or <code>statisticalThreshold</code>). Valid operators include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>string-list</code>: <code>in-set</code> and <code>not-in-set</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>number-list</code>: <code>in-set</code> and <code>not-in-set</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ip-address-list</code>: <code>in-cidr-set</code> and <code>not-in-cidr-set</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>number</code>: <code>less-than</code>, <code>less-than-equals</code>, <code>greater-than</code>, and <code>greater-than-equals</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>The value to be compared with the <code>metric</code>.</p>
        pub fn value(mut self, input: crate::model::MetricValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value to be compared with the <code>metric</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::MetricValue>) -> Self {
            self.value = input;
            self
        }
        /// <p>Use this to specify the time duration over which the behavior is evaluated, for those criteria that
        /// have a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a
        /// <code>statisticalThreshhold</code> metric comparison, measurements from all devices are
        /// accumulated over this time duration before being used to calculate percentiles, and later,
        /// measurements from an individual device are also accumulated over this time duration before
        /// being given a percentile rank. Cannot be used with list-based metric datatypes.</p>
        pub fn duration_seconds(mut self, input: i32) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>Use this to specify the time duration over which the behavior is evaluated, for those criteria that
        /// have a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a
        /// <code>statisticalThreshhold</code> metric comparison, measurements from all devices are
        /// accumulated over this time duration before being used to calculate percentiles, and later,
        /// measurements from an individual device are also accumulated over this time duration before
        /// being given a percentile rank. Cannot be used with list-based metric datatypes.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>If a device is in violation of the behavior for the specified number of consecutive
        /// datapoints, an alarm occurs. If not specified, the default is 1.</p>
        pub fn consecutive_datapoints_to_alarm(mut self, input: i32) -> Self {
            self.consecutive_datapoints_to_alarm = Some(input);
            self
        }
        /// <p>If a device is in violation of the behavior for the specified number of consecutive
        /// datapoints, an alarm occurs. If not specified, the default is 1.</p>
        pub fn set_consecutive_datapoints_to_alarm(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.consecutive_datapoints_to_alarm = input;
            self
        }
        /// <p>If an alarm has occurred and the offending device is no longer in violation of the behavior
        /// for the specified number of consecutive datapoints, the alarm is cleared. If not specified,
        /// the default is 1.</p>
        pub fn consecutive_datapoints_to_clear(mut self, input: i32) -> Self {
            self.consecutive_datapoints_to_clear = Some(input);
            self
        }
        /// <p>If an alarm has occurred and the offending device is no longer in violation of the behavior
        /// for the specified number of consecutive datapoints, the alarm is cleared. If not specified,
        /// the default is 1.</p>
        pub fn set_consecutive_datapoints_to_clear(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.consecutive_datapoints_to_clear = input;
            self
        }
        /// <p>A statistical ranking (percentile)that
        /// indicates a threshold value by which a behavior is determined to be in compliance or in
        /// violation of the behavior.</p>
        pub fn statistical_threshold(mut self, input: crate::model::StatisticalThreshold) -> Self {
            self.statistical_threshold = Some(input);
            self
        }
        /// <p>A statistical ranking (percentile)that
        /// indicates a threshold value by which a behavior is determined to be in compliance or in
        /// violation of the behavior.</p>
        pub fn set_statistical_threshold(
            mut self,
            input: std::option::Option<crate::model::StatisticalThreshold>,
        ) -> Self {
            self.statistical_threshold = input;
            self
        }
        /// <p>
        /// The configuration of an ML Detect
        /// </p>
        pub fn ml_detection_config(
            mut self,
            input: crate::model::MachineLearningDetectionConfig,
        ) -> Self {
            self.ml_detection_config = Some(input);
            self
        }
        /// <p>
        /// The configuration of an ML Detect
        /// </p>
        pub fn set_ml_detection_config(
            mut self,
            input: std::option::Option<crate::model::MachineLearningDetectionConfig>,
        ) -> Self {
            self.ml_detection_config = input;
            self
        }
        /// Consumes the builder and constructs a [`BehaviorCriteria`](crate::model::BehaviorCriteria)
        pub fn build(self) -> crate::model::BehaviorCriteria {
            crate::model::BehaviorCriteria {
                comparison_operator: self.comparison_operator,
                value: self.value,
                duration_seconds: self.duration_seconds,
                consecutive_datapoints_to_alarm: self.consecutive_datapoints_to_alarm,
                consecutive_datapoints_to_clear: self.consecutive_datapoints_to_clear,
                statistical_threshold: self.statistical_threshold,
                ml_detection_config: self.ml_detection_config,
            }
        }
    }
}
impl BehaviorCriteria {
    /// Creates a new builder-style object to manufacture [`BehaviorCriteria`](crate::model::BehaviorCriteria)
    pub fn builder() -> crate::model::behavior_criteria::Builder {
        crate::model::behavior_criteria::Builder::default()
    }
}

/// <p>
/// The configuration of an ML Detect Security Profile.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MachineLearningDetectionConfig {
    /// <p>
    /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
    /// </p>
    pub confidence_level: std::option::Option<crate::model::ConfidenceLevel>,
}
impl MachineLearningDetectionConfig {
    /// <p>
    /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
    /// </p>
    pub fn confidence_level(&self) -> std::option::Option<&crate::model::ConfidenceLevel> {
        self.confidence_level.as_ref()
    }
}
impl std::fmt::Debug for MachineLearningDetectionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MachineLearningDetectionConfig");
        formatter.field("confidence_level", &self.confidence_level);
        formatter.finish()
    }
}
/// See [`MachineLearningDetectionConfig`](crate::model::MachineLearningDetectionConfig)
pub mod machine_learning_detection_config {
    /// A builder for [`MachineLearningDetectionConfig`](crate::model::MachineLearningDetectionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confidence_level: std::option::Option<crate::model::ConfidenceLevel>,
    }
    impl Builder {
        /// <p>
        /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
        /// </p>
        pub fn confidence_level(mut self, input: crate::model::ConfidenceLevel) -> Self {
            self.confidence_level = Some(input);
            self
        }
        /// <p>
        /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
        /// </p>
        pub fn set_confidence_level(
            mut self,
            input: std::option::Option<crate::model::ConfidenceLevel>,
        ) -> Self {
            self.confidence_level = input;
            self
        }
        /// Consumes the builder and constructs a [`MachineLearningDetectionConfig`](crate::model::MachineLearningDetectionConfig)
        pub fn build(self) -> crate::model::MachineLearningDetectionConfig {
            crate::model::MachineLearningDetectionConfig {
                confidence_level: self.confidence_level,
            }
        }
    }
}
impl MachineLearningDetectionConfig {
    /// Creates a new builder-style object to manufacture [`MachineLearningDetectionConfig`](crate::model::MachineLearningDetectionConfig)
    pub fn builder() -> crate::model::machine_learning_detection_config::Builder {
        crate::model::machine_learning_detection_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfidenceLevel {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfidenceLevel {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => ConfidenceLevel::High,
            "LOW" => ConfidenceLevel::Low,
            "MEDIUM" => ConfidenceLevel::Medium,
            other => ConfidenceLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfidenceLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfidenceLevel::from(s))
    }
}
impl ConfidenceLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfidenceLevel::High => "HIGH",
            ConfidenceLevel::Low => "LOW",
            ConfidenceLevel::Medium => "MEDIUM",
            ConfidenceLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for ConfidenceLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A statistical ranking (percentile) that
/// indicates a threshold value by which a behavior is determined to be in compliance or in
/// violation of the behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatisticalThreshold {
    /// <p>The percentile that
    /// resolves to a threshold value by which compliance with a behavior is determined. Metrics are
    /// collected over the specified period (<code>durationSeconds</code>) from all reporting devices
    /// in your account and statistical ranks are calculated. Then, the measurements from a device are
    /// collected over the same period. If the accumulated measurements from the device fall above or
    /// below (<code>comparisonOperator</code>) the value associated with the percentile specified,
    /// then the device is considered to be in compliance with the behavior, otherwise a violation
    /// occurs.</p>
    pub statistic: std::option::Option<std::string::String>,
}
impl StatisticalThreshold {
    /// <p>The percentile that
    /// resolves to a threshold value by which compliance with a behavior is determined. Metrics are
    /// collected over the specified period (<code>durationSeconds</code>) from all reporting devices
    /// in your account and statistical ranks are calculated. Then, the measurements from a device are
    /// collected over the same period. If the accumulated measurements from the device fall above or
    /// below (<code>comparisonOperator</code>) the value associated with the percentile specified,
    /// then the device is considered to be in compliance with the behavior, otherwise a violation
    /// occurs.</p>
    pub fn statistic(&self) -> std::option::Option<&str> {
        self.statistic.as_deref()
    }
}
impl std::fmt::Debug for StatisticalThreshold {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatisticalThreshold");
        formatter.field("statistic", &self.statistic);
        formatter.finish()
    }
}
/// See [`StatisticalThreshold`](crate::model::StatisticalThreshold)
pub mod statistical_threshold {
    /// A builder for [`StatisticalThreshold`](crate::model::StatisticalThreshold)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statistic: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The percentile that
        /// resolves to a threshold value by which compliance with a behavior is determined. Metrics are
        /// collected over the specified period (<code>durationSeconds</code>) from all reporting devices
        /// in your account and statistical ranks are calculated. Then, the measurements from a device are
        /// collected over the same period. If the accumulated measurements from the device fall above or
        /// below (<code>comparisonOperator</code>) the value associated with the percentile specified,
        /// then the device is considered to be in compliance with the behavior, otherwise a violation
        /// occurs.</p>
        pub fn statistic(mut self, input: impl Into<std::string::String>) -> Self {
            self.statistic = Some(input.into());
            self
        }
        /// <p>The percentile that
        /// resolves to a threshold value by which compliance with a behavior is determined. Metrics are
        /// collected over the specified period (<code>durationSeconds</code>) from all reporting devices
        /// in your account and statistical ranks are calculated. Then, the measurements from a device are
        /// collected over the same period. If the accumulated measurements from the device fall above or
        /// below (<code>comparisonOperator</code>) the value associated with the percentile specified,
        /// then the device is considered to be in compliance with the behavior, otherwise a violation
        /// occurs.</p>
        pub fn set_statistic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statistic = input;
            self
        }
        /// Consumes the builder and constructs a [`StatisticalThreshold`](crate::model::StatisticalThreshold)
        pub fn build(self) -> crate::model::StatisticalThreshold {
            crate::model::StatisticalThreshold {
                statistic: self.statistic,
            }
        }
    }
}
impl StatisticalThreshold {
    /// Creates a new builder-style object to manufacture [`StatisticalThreshold`](crate::model::StatisticalThreshold)
    pub fn builder() -> crate::model::statistical_threshold::Builder {
        crate::model::statistical_threshold::Builder::default()
    }
}

/// <p>The value to be compared with the <code>metric</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricValue {
    /// <p>If the <code>comparisonOperator</code> calls for a numeric value, use this
    /// to specify that numeric value to be compared with the <code>metric</code>.</p>
    pub count: std::option::Option<i64>,
    /// <p>If the <code>comparisonOperator</code> calls for a set of CIDRs, use this
    /// to specify that set to be compared with the <code>metric</code>.</p>
    pub cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If the <code>comparisonOperator</code> calls for a set of ports, use this
    /// to specify that set to be compared with the <code>metric</code>.</p>
    pub ports: std::option::Option<std::vec::Vec<i32>>,
    /// <p>
    /// The numeral value of a metric.
    /// </p>
    pub number: std::option::Option<f64>,
    /// <p>
    /// The numeral values of a metric.
    /// </p>
    pub numbers: std::option::Option<std::vec::Vec<f64>>,
    /// <p>
    /// The string values of a metric.
    /// </p>
    pub strings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl MetricValue {
    /// <p>If the <code>comparisonOperator</code> calls for a numeric value, use this
    /// to specify that numeric value to be compared with the <code>metric</code>.</p>
    pub fn count(&self) -> std::option::Option<i64> {
        self.count
    }
    /// <p>If the <code>comparisonOperator</code> calls for a set of CIDRs, use this
    /// to specify that set to be compared with the <code>metric</code>.</p>
    pub fn cidrs(&self) -> std::option::Option<&[std::string::String]> {
        self.cidrs.as_deref()
    }
    /// <p>If the <code>comparisonOperator</code> calls for a set of ports, use this
    /// to specify that set to be compared with the <code>metric</code>.</p>
    pub fn ports(&self) -> std::option::Option<&[i32]> {
        self.ports.as_deref()
    }
    /// <p>
    /// The numeral value of a metric.
    /// </p>
    pub fn number(&self) -> std::option::Option<f64> {
        self.number
    }
    /// <p>
    /// The numeral values of a metric.
    /// </p>
    pub fn numbers(&self) -> std::option::Option<&[f64]> {
        self.numbers.as_deref()
    }
    /// <p>
    /// The string values of a metric.
    /// </p>
    pub fn strings(&self) -> std::option::Option<&[std::string::String]> {
        self.strings.as_deref()
    }
}
impl std::fmt::Debug for MetricValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricValue");
        formatter.field("count", &self.count);
        formatter.field("cidrs", &self.cidrs);
        formatter.field("ports", &self.ports);
        formatter.field("number", &self.number);
        formatter.field("numbers", &self.numbers);
        formatter.field("strings", &self.strings);
        formatter.finish()
    }
}
/// See [`MetricValue`](crate::model::MetricValue)
pub mod metric_value {
    /// A builder for [`MetricValue`](crate::model::MetricValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i64>,
        pub(crate) cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ports: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) number: std::option::Option<f64>,
        pub(crate) numbers: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) strings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>If the <code>comparisonOperator</code> calls for a numeric value, use this
        /// to specify that numeric value to be compared with the <code>metric</code>.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>If the <code>comparisonOperator</code> calls for a numeric value, use this
        /// to specify that numeric value to be compared with the <code>metric</code>.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// Appends an item to `cidrs`.
        ///
        /// To override the contents of this collection use [`set_cidrs`](Self::set_cidrs).
        ///
        /// <p>If the <code>comparisonOperator</code> calls for a set of CIDRs, use this
        /// to specify that set to be compared with the <code>metric</code>.</p>
        pub fn cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidrs.unwrap_or_default();
            v.push(input.into());
            self.cidrs = Some(v);
            self
        }
        /// <p>If the <code>comparisonOperator</code> calls for a set of CIDRs, use this
        /// to specify that set to be compared with the <code>metric</code>.</p>
        pub fn set_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidrs = input;
            self
        }
        /// Appends an item to `ports`.
        ///
        /// To override the contents of this collection use [`set_ports`](Self::set_ports).
        ///
        /// <p>If the <code>comparisonOperator</code> calls for a set of ports, use this
        /// to specify that set to be compared with the <code>metric</code>.</p>
        pub fn ports(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.ports.unwrap_or_default();
            v.push(input.into());
            self.ports = Some(v);
            self
        }
        /// <p>If the <code>comparisonOperator</code> calls for a set of ports, use this
        /// to specify that set to be compared with the <code>metric</code>.</p>
        pub fn set_ports(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.ports = input;
            self
        }
        /// <p>
        /// The numeral value of a metric.
        /// </p>
        pub fn number(mut self, input: f64) -> Self {
            self.number = Some(input);
            self
        }
        /// <p>
        /// The numeral value of a metric.
        /// </p>
        pub fn set_number(mut self, input: std::option::Option<f64>) -> Self {
            self.number = input;
            self
        }
        /// Appends an item to `numbers`.
        ///
        /// To override the contents of this collection use [`set_numbers`](Self::set_numbers).
        ///
        /// <p>
        /// The numeral values of a metric.
        /// </p>
        pub fn numbers(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.numbers.unwrap_or_default();
            v.push(input.into());
            self.numbers = Some(v);
            self
        }
        /// <p>
        /// The numeral values of a metric.
        /// </p>
        pub fn set_numbers(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.numbers = input;
            self
        }
        /// Appends an item to `strings`.
        ///
        /// To override the contents of this collection use [`set_strings`](Self::set_strings).
        ///
        /// <p>
        /// The string values of a metric.
        /// </p>
        pub fn strings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.strings.unwrap_or_default();
            v.push(input.into());
            self.strings = Some(v);
            self
        }
        /// <p>
        /// The string values of a metric.
        /// </p>
        pub fn set_strings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.strings = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricValue`](crate::model::MetricValue)
        pub fn build(self) -> crate::model::MetricValue {
            crate::model::MetricValue {
                count: self.count,
                cidrs: self.cidrs,
                ports: self.ports,
                number: self.number,
                numbers: self.numbers,
                strings: self.strings,
            }
        }
    }
}
impl MetricValue {
    /// Creates a new builder-style object to manufacture [`MetricValue`](crate::model::MetricValue)
    pub fn builder() -> crate::model::metric_value::Builder {
        crate::model::metric_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanEquals,
    #[allow(missing_docs)] // documentation missing in model
    InCidrSet,
    #[allow(missing_docs)] // documentation missing in model
    InPortSet,
    #[allow(missing_docs)] // documentation missing in model
    InSet,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanEquals,
    #[allow(missing_docs)] // documentation missing in model
    NotInCidrSet,
    #[allow(missing_docs)] // documentation missing in model
    NotInPortSet,
    #[allow(missing_docs)] // documentation missing in model
    NotInSet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "greater-than" => ComparisonOperator::GreaterThan,
            "greater-than-equals" => ComparisonOperator::GreaterThanEquals,
            "in-cidr-set" => ComparisonOperator::InCidrSet,
            "in-port-set" => ComparisonOperator::InPortSet,
            "in-set" => ComparisonOperator::InSet,
            "less-than" => ComparisonOperator::LessThan,
            "less-than-equals" => ComparisonOperator::LessThanEquals,
            "not-in-cidr-set" => ComparisonOperator::NotInCidrSet,
            "not-in-port-set" => ComparisonOperator::NotInPortSet,
            "not-in-set" => ComparisonOperator::NotInSet,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::GreaterThan => "greater-than",
            ComparisonOperator::GreaterThanEquals => "greater-than-equals",
            ComparisonOperator::InCidrSet => "in-cidr-set",
            ComparisonOperator::InPortSet => "in-port-set",
            ComparisonOperator::InSet => "in-set",
            ComparisonOperator::LessThan => "less-than",
            ComparisonOperator::LessThanEquals => "less-than-equals",
            ComparisonOperator::NotInCidrSet => "not-in-cidr-set",
            ComparisonOperator::NotInPortSet => "not-in-port-set",
            ComparisonOperator::NotInSet => "not-in-set",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "greater-than",
            "greater-than-equals",
            "in-cidr-set",
            "in-port-set",
            "in-set",
            "less-than",
            "less-than-equals",
            "not-in-cidr-set",
            "not-in-port-set",
            "not-in-set",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The dimension of a metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDimension {
    /// <p>A unique identifier for the dimension.</p>
    pub dimension_name: std::option::Option<std::string::String>,
    /// <p>Defines how the <code>dimensionValues</code> of a dimension are interpreted. For example, for dimension type TOPIC_FILTER, the <code>IN</code> operator, a message will be counted only if its topic matches one of the topic filters. With <code>NOT_IN</code> operator, a message will be counted only if it doesn't match any of the topic filters. The operator is optional: if it's not provided (is <code>null</code>), it will be interpreted as <code>IN</code>.</p>
    pub operator: std::option::Option<crate::model::DimensionValueOperator>,
}
impl MetricDimension {
    /// <p>A unique identifier for the dimension.</p>
    pub fn dimension_name(&self) -> std::option::Option<&str> {
        self.dimension_name.as_deref()
    }
    /// <p>Defines how the <code>dimensionValues</code> of a dimension are interpreted. For example, for dimension type TOPIC_FILTER, the <code>IN</code> operator, a message will be counted only if its topic matches one of the topic filters. With <code>NOT_IN</code> operator, a message will be counted only if it doesn't match any of the topic filters. The operator is optional: if it's not provided (is <code>null</code>), it will be interpreted as <code>IN</code>.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::DimensionValueOperator> {
        self.operator.as_ref()
    }
}
impl std::fmt::Debug for MetricDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDimension");
        formatter.field("dimension_name", &self.dimension_name);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`MetricDimension`](crate::model::MetricDimension)
pub mod metric_dimension {
    /// A builder for [`MetricDimension`](crate::model::MetricDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_name: std::option::Option<std::string::String>,
        pub(crate) operator: std::option::Option<crate::model::DimensionValueOperator>,
    }
    impl Builder {
        /// <p>A unique identifier for the dimension.</p>
        pub fn dimension_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the dimension.</p>
        pub fn set_dimension_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_name = input;
            self
        }
        /// <p>Defines how the <code>dimensionValues</code> of a dimension are interpreted. For example, for dimension type TOPIC_FILTER, the <code>IN</code> operator, a message will be counted only if its topic matches one of the topic filters. With <code>NOT_IN</code> operator, a message will be counted only if it doesn't match any of the topic filters. The operator is optional: if it's not provided (is <code>null</code>), it will be interpreted as <code>IN</code>.</p>
        pub fn operator(mut self, input: crate::model::DimensionValueOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>Defines how the <code>dimensionValues</code> of a dimension are interpreted. For example, for dimension type TOPIC_FILTER, the <code>IN</code> operator, a message will be counted only if its topic matches one of the topic filters. With <code>NOT_IN</code> operator, a message will be counted only if it doesn't match any of the topic filters. The operator is optional: if it's not provided (is <code>null</code>), it will be interpreted as <code>IN</code>.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::DimensionValueOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDimension`](crate::model::MetricDimension)
        pub fn build(self) -> crate::model::MetricDimension {
            crate::model::MetricDimension {
                dimension_name: self.dimension_name,
                operator: self.operator,
            }
        }
    }
}
impl MetricDimension {
    /// Creates a new builder-style object to manufacture [`MetricDimension`](crate::model::MetricDimension)
    pub fn builder() -> crate::model::metric_dimension::Builder {
        crate::model::metric_dimension::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DimensionValueOperator {
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    NotIn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DimensionValueOperator {
    fn from(s: &str) -> Self {
        match s {
            "IN" => DimensionValueOperator::In,
            "NOT_IN" => DimensionValueOperator::NotIn,
            other => DimensionValueOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DimensionValueOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DimensionValueOperator::from(s))
    }
}
impl DimensionValueOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DimensionValueOperator::In => "IN",
            DimensionValueOperator::NotIn => "NOT_IN",
            DimensionValueOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IN", "NOT_IN"]
    }
}
impl AsRef<str> for DimensionValueOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TopicRuleDestinationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TopicRuleDestinationStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => TopicRuleDestinationStatus::Deleting,
            "DISABLED" => TopicRuleDestinationStatus::Disabled,
            "ENABLED" => TopicRuleDestinationStatus::Enabled,
            "ERROR" => TopicRuleDestinationStatus::Error,
            "IN_PROGRESS" => TopicRuleDestinationStatus::InProgress,
            other => TopicRuleDestinationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TopicRuleDestinationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TopicRuleDestinationStatus::from(s))
    }
}
impl TopicRuleDestinationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TopicRuleDestinationStatus::Deleting => "DELETING",
            TopicRuleDestinationStatus::Disabled => "DISABLED",
            TopicRuleDestinationStatus::Enabled => "ENABLED",
            TopicRuleDestinationStatus::Error => "ERROR",
            TopicRuleDestinationStatus::InProgress => "IN_PROGRESS",
            TopicRuleDestinationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETING", "DISABLED", "ENABLED", "ERROR", "IN_PROGRESS"]
    }
}
impl AsRef<str> for TopicRuleDestinationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Thing group properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingGroupProperties {
    /// <p>The thing group description.</p>
    pub thing_group_description: std::option::Option<std::string::String>,
    /// <p>The thing group attributes in JSON format.</p>
    pub attribute_payload: std::option::Option<crate::model::AttributePayload>,
}
impl ThingGroupProperties {
    /// <p>The thing group description.</p>
    pub fn thing_group_description(&self) -> std::option::Option<&str> {
        self.thing_group_description.as_deref()
    }
    /// <p>The thing group attributes in JSON format.</p>
    pub fn attribute_payload(&self) -> std::option::Option<&crate::model::AttributePayload> {
        self.attribute_payload.as_ref()
    }
}
impl std::fmt::Debug for ThingGroupProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingGroupProperties");
        formatter.field("thing_group_description", &self.thing_group_description);
        formatter.field("attribute_payload", &self.attribute_payload);
        formatter.finish()
    }
}
/// See [`ThingGroupProperties`](crate::model::ThingGroupProperties)
pub mod thing_group_properties {
    /// A builder for [`ThingGroupProperties`](crate::model::ThingGroupProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_description: std::option::Option<std::string::String>,
        pub(crate) attribute_payload: std::option::Option<crate::model::AttributePayload>,
    }
    impl Builder {
        /// <p>The thing group description.</p>
        pub fn thing_group_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_description = Some(input.into());
            self
        }
        /// <p>The thing group description.</p>
        pub fn set_thing_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_description = input;
            self
        }
        /// <p>The thing group attributes in JSON format.</p>
        pub fn attribute_payload(mut self, input: crate::model::AttributePayload) -> Self {
            self.attribute_payload = Some(input);
            self
        }
        /// <p>The thing group attributes in JSON format.</p>
        pub fn set_attribute_payload(
            mut self,
            input: std::option::Option<crate::model::AttributePayload>,
        ) -> Self {
            self.attribute_payload = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingGroupProperties`](crate::model::ThingGroupProperties)
        pub fn build(self) -> crate::model::ThingGroupProperties {
            crate::model::ThingGroupProperties {
                thing_group_description: self.thing_group_description,
                attribute_payload: self.attribute_payload,
            }
        }
    }
}
impl ThingGroupProperties {
    /// Creates a new builder-style object to manufacture [`ThingGroupProperties`](crate::model::ThingGroupProperties)
    pub fn builder() -> crate::model::thing_group_properties::Builder {
        crate::model::thing_group_properties::Builder::default()
    }
}

/// <p>The attribute payload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributePayload {
    /// <p>A JSON string containing up to three key-value pair in JSON format. For example:</p>
    /// <p>
    /// <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
    /// </p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with
    /// the attributes stored in the registry, instead of overwriting them.</p>
    /// <p>To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.</p>
    /// <note>
    /// <p>The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code> or <code>UpdateThingGroup</code>.</p>
    /// </note>
    pub merge: bool,
}
impl AttributePayload {
    /// <p>A JSON string containing up to three key-value pair in JSON format. For example:</p>
    /// <p>
    /// <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
    /// </p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with
    /// the attributes stored in the registry, instead of overwriting them.</p>
    /// <p>To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.</p>
    /// <note>
    /// <p>The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code> or <code>UpdateThingGroup</code>.</p>
    /// </note>
    pub fn merge(&self) -> bool {
        self.merge
    }
}
impl std::fmt::Debug for AttributePayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributePayload");
        formatter.field("attributes", &self.attributes);
        formatter.field("merge", &self.merge);
        formatter.finish()
    }
}
/// See [`AttributePayload`](crate::model::AttributePayload)
pub mod attribute_payload {
    /// A builder for [`AttributePayload`](crate::model::AttributePayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) merge: std::option::Option<bool>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A JSON string containing up to three key-value pair in JSON format. For example:</p>
        /// <p>
        /// <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
        /// </p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A JSON string containing up to three key-value pair in JSON format. For example:</p>
        /// <p>
        /// <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
        /// </p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with
        /// the attributes stored in the registry, instead of overwriting them.</p>
        /// <p>To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.</p>
        /// <note>
        /// <p>The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code> or <code>UpdateThingGroup</code>.</p>
        /// </note>
        pub fn merge(mut self, input: bool) -> Self {
            self.merge = Some(input);
            self
        }
        /// <p>Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with
        /// the attributes stored in the registry, instead of overwriting them.</p>
        /// <p>To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.</p>
        /// <note>
        /// <p>The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code> or <code>UpdateThingGroup</code>.</p>
        /// </note>
        pub fn set_merge(mut self, input: std::option::Option<bool>) -> Self {
            self.merge = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributePayload`](crate::model::AttributePayload)
        pub fn build(self) -> crate::model::AttributePayload {
            crate::model::AttributePayload {
                attributes: self.attributes,
                merge: self.merge.unwrap_or_default(),
            }
        }
    }
}
impl AttributePayload {
    /// Creates a new builder-style object to manufacture [`AttributePayload`](crate::model::AttributePayload)
    pub fn builder() -> crate::model::attribute_payload::Builder {
        crate::model::attribute_payload::Builder::default()
    }
}

/// <p>Represents a file to stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamFile {
    /// <p>The file ID.</p>
    pub file_id: std::option::Option<i32>,
    /// <p>The location of the file in S3.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl StreamFile {
    /// <p>The file ID.</p>
    pub fn file_id(&self) -> std::option::Option<i32> {
        self.file_id
    }
    /// <p>The location of the file in S3.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for StreamFile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamFile");
        formatter.field("file_id", &self.file_id);
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`StreamFile`](crate::model::StreamFile)
pub mod stream_file {
    /// A builder for [`StreamFile`](crate::model::StreamFile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_id: std::option::Option<i32>,
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The file ID.</p>
        pub fn file_id(mut self, input: i32) -> Self {
            self.file_id = Some(input);
            self
        }
        /// <p>The file ID.</p>
        pub fn set_file_id(mut self, input: std::option::Option<i32>) -> Self {
            self.file_id = input;
            self
        }
        /// <p>The location of the file in S3.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The location of the file in S3.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamFile`](crate::model::StreamFile)
        pub fn build(self) -> crate::model::StreamFile {
            crate::model::StreamFile {
                file_id: self.file_id,
                s3_location: self.s3_location,
            }
        }
    }
}
impl StreamFile {
    /// Creates a new builder-style object to manufacture [`StreamFile`](crate::model::StreamFile)
    pub fn builder() -> crate::model::stream_file::Builder {
        crate::model::stream_file::Builder::default()
    }
}

/// <p>The S3 location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The S3 bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The S3 key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The S3 bucket version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The S3 bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The S3 key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The S3 bucket version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The S3 key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The S3 key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The S3 bucket version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The S3 bucket version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                key: self.key,
                version: self.version,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>The metric you want to retain. Dimensions are optional.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricToRetain {
    /// <p>What is measured by the behavior.</p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The dimension of a metric. This can't be used with custom metrics.</p>
    pub metric_dimension: std::option::Option<crate::model::MetricDimension>,
}
impl MetricToRetain {
    /// <p>What is measured by the behavior.</p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The dimension of a metric. This can't be used with custom metrics.</p>
    pub fn metric_dimension(&self) -> std::option::Option<&crate::model::MetricDimension> {
        self.metric_dimension.as_ref()
    }
}
impl std::fmt::Debug for MetricToRetain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricToRetain");
        formatter.field("metric", &self.metric);
        formatter.field("metric_dimension", &self.metric_dimension);
        formatter.finish()
    }
}
/// See [`MetricToRetain`](crate::model::MetricToRetain)
pub mod metric_to_retain {
    /// A builder for [`MetricToRetain`](crate::model::MetricToRetain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) metric_dimension: std::option::Option<crate::model::MetricDimension>,
    }
    impl Builder {
        /// <p>What is measured by the behavior.</p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>What is measured by the behavior.</p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The dimension of a metric. This can't be used with custom metrics.</p>
        pub fn metric_dimension(mut self, input: crate::model::MetricDimension) -> Self {
            self.metric_dimension = Some(input);
            self
        }
        /// <p>The dimension of a metric. This can't be used with custom metrics.</p>
        pub fn set_metric_dimension(
            mut self,
            input: std::option::Option<crate::model::MetricDimension>,
        ) -> Self {
            self.metric_dimension = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricToRetain`](crate::model::MetricToRetain)
        pub fn build(self) -> crate::model::MetricToRetain {
            crate::model::MetricToRetain {
                metric: self.metric,
                metric_dimension: self.metric_dimension,
            }
        }
    }
}
impl MetricToRetain {
    /// Creates a new builder-style object to manufacture [`MetricToRetain`](crate::model::MetricToRetain)
    pub fn builder() -> crate::model::metric_to_retain::Builder {
        crate::model::metric_to_retain::Builder::default()
    }
}

/// <p>A structure containing the alert target ARN and the role ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlertTarget {
    /// <p>The Amazon Resource Name (ARN) of the notification target to which alerts are sent.</p>
    pub alert_target_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants permission to send alerts to the
    /// notification target.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl AlertTarget {
    /// <p>The Amazon Resource Name (ARN) of the notification target to which alerts are sent.</p>
    pub fn alert_target_arn(&self) -> std::option::Option<&str> {
        self.alert_target_arn.as_deref()
    }
    /// <p>The ARN of the role that grants permission to send alerts to the
    /// notification target.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for AlertTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlertTarget");
        formatter.field("alert_target_arn", &self.alert_target_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`AlertTarget`](crate::model::AlertTarget)
pub mod alert_target {
    /// A builder for [`AlertTarget`](crate::model::AlertTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_target_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notification target to which alerts are sent.</p>
        pub fn alert_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notification target to which alerts are sent.</p>
        pub fn set_alert_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alert_target_arn = input;
            self
        }
        /// <p>The ARN of the role that grants permission to send alerts to the
        /// notification target.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to send alerts to the
        /// notification target.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AlertTarget`](crate::model::AlertTarget)
        pub fn build(self) -> crate::model::AlertTarget {
            crate::model::AlertTarget {
                alert_target_arn: self.alert_target_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl AlertTarget {
    /// Creates a new builder-style object to manufacture [`AlertTarget`](crate::model::AlertTarget)
    pub fn builder() -> crate::model::alert_target::Builder {
        crate::model::alert_target::Builder::default()
    }
}

/// <p>The type of alert target: one of "SNS".</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlertTargetType {
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlertTargetType {
    fn from(s: &str) -> Self {
        match s {
            "SNS" => AlertTargetType::Sns,
            other => AlertTargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlertTargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlertTargetType::from(s))
    }
}
impl AlertTargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlertTargetType::Sns => "SNS",
            AlertTargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SNS"]
    }
}
impl AsRef<str> for AlertTargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DayOfWeek {
    #[allow(missing_docs)] // documentation missing in model
    Fri,
    #[allow(missing_docs)] // documentation missing in model
    Mon,
    #[allow(missing_docs)] // documentation missing in model
    Sat,
    #[allow(missing_docs)] // documentation missing in model
    Sun,
    #[allow(missing_docs)] // documentation missing in model
    Thu,
    #[allow(missing_docs)] // documentation missing in model
    Tue,
    #[allow(missing_docs)] // documentation missing in model
    Wed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DayOfWeek {
    fn from(s: &str) -> Self {
        match s {
            "FRI" => DayOfWeek::Fri,
            "MON" => DayOfWeek::Mon,
            "SAT" => DayOfWeek::Sat,
            "SUN" => DayOfWeek::Sun,
            "THU" => DayOfWeek::Thu,
            "TUE" => DayOfWeek::Tue,
            "WED" => DayOfWeek::Wed,
            other => DayOfWeek::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DayOfWeek {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DayOfWeek::from(s))
    }
}
impl DayOfWeek {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DayOfWeek::Fri => "FRI",
            DayOfWeek::Mon => "MON",
            DayOfWeek::Sat => "SAT",
            DayOfWeek::Sun => "SUN",
            DayOfWeek::Thu => "THU",
            DayOfWeek::Tue => "TUE",
            DayOfWeek::Wed => "WED",
            DayOfWeek::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRI", "MON", "SAT", "SUN", "THU", "TUE", "WED"]
    }
}
impl AsRef<str> for DayOfWeek {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditFrequency {
    #[allow(missing_docs)] // documentation missing in model
    Biweekly,
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditFrequency {
    fn from(s: &str) -> Self {
        match s {
            "BIWEEKLY" => AuditFrequency::Biweekly,
            "DAILY" => AuditFrequency::Daily,
            "MONTHLY" => AuditFrequency::Monthly,
            "WEEKLY" => AuditFrequency::Weekly,
            other => AuditFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditFrequency::from(s))
    }
}
impl AuditFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditFrequency::Biweekly => "BIWEEKLY",
            AuditFrequency::Daily => "DAILY",
            AuditFrequency::Monthly => "MONTHLY",
            AuditFrequency::Weekly => "WEEKLY",
            AuditFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BIWEEKLY", "DAILY", "MONTHLY", "WEEKLY"]
    }
}
impl AsRef<str> for AuditFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Structure that contains <code>payloadVersion</code> and
/// <code>targetArn</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningHook {
    /// <p>The payload that was sent to the target function.</p>
    /// <p>
    /// <i>Note:</i> Only Lambda functions are currently supported.</p>
    pub payload_version: std::option::Option<std::string::String>,
    /// <p>The ARN of the target function.</p>
    /// <p>
    /// <i>Note:</i> Only Lambda functions are currently supported.</p>
    pub target_arn: std::option::Option<std::string::String>,
}
impl ProvisioningHook {
    /// <p>The payload that was sent to the target function.</p>
    /// <p>
    /// <i>Note:</i> Only Lambda functions are currently supported.</p>
    pub fn payload_version(&self) -> std::option::Option<&str> {
        self.payload_version.as_deref()
    }
    /// <p>The ARN of the target function.</p>
    /// <p>
    /// <i>Note:</i> Only Lambda functions are currently supported.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
}
impl std::fmt::Debug for ProvisioningHook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningHook");
        formatter.field("payload_version", &self.payload_version);
        formatter.field("target_arn", &self.target_arn);
        formatter.finish()
    }
}
/// See [`ProvisioningHook`](crate::model::ProvisioningHook)
pub mod provisioning_hook {
    /// A builder for [`ProvisioningHook`](crate::model::ProvisioningHook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) payload_version: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The payload that was sent to the target function.</p>
        /// <p>
        /// <i>Note:</i> Only Lambda functions are currently supported.</p>
        pub fn payload_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_version = Some(input.into());
            self
        }
        /// <p>The payload that was sent to the target function.</p>
        /// <p>
        /// <i>Note:</i> Only Lambda functions are currently supported.</p>
        pub fn set_payload_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_version = input;
            self
        }
        /// <p>The ARN of the target function.</p>
        /// <p>
        /// <i>Note:</i> Only Lambda functions are currently supported.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the target function.</p>
        /// <p>
        /// <i>Note:</i> Only Lambda functions are currently supported.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningHook`](crate::model::ProvisioningHook)
        pub fn build(self) -> crate::model::ProvisioningHook {
            crate::model::ProvisioningHook {
                payload_version: self.payload_version,
                target_arn: self.target_arn,
            }
        }
    }
}
impl ProvisioningHook {
    /// Creates a new builder-style object to manufacture [`ProvisioningHook`](crate::model::ProvisioningHook)
    pub fn builder() -> crate::model::provisioning_hook::Builder {
        crate::model::provisioning_hook::Builder::default()
    }
}

/// <p>The set of parameters for this mitigation action. You can specify only one type of parameter (in other words, you can apply only one action for each defined mitigation action).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MitigationActionParams {
    /// <p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>
    pub update_device_certificate_params:
        std::option::Option<crate::model::UpdateDeviceCertificateParams>,
    /// <p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>
    pub update_ca_certificate_params: std::option::Option<crate::model::UpdateCaCertificateParams>,
    /// <p>Parameters to define a mitigation action that moves devices associated with a certificate to one or more specified thing groups, typically for quarantine.</p>
    pub add_things_to_thing_group_params:
        std::option::Option<crate::model::AddThingsToThingGroupParams>,
    /// <p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>
    pub replace_default_policy_version_params:
        std::option::Option<crate::model::ReplaceDefaultPolicyVersionParams>,
    /// <p>Parameters to define a mitigation action that enables Amazon Web Services IoT Core logging at a specified level of detail.</p>
    pub enable_io_t_logging_params: std::option::Option<crate::model::EnableIoTLoggingParams>,
    /// <p>Parameters to define a mitigation action that publishes findings to Amazon Simple Notification Service (Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>
    pub publish_finding_to_sns_params: std::option::Option<crate::model::PublishFindingToSnsParams>,
}
impl MitigationActionParams {
    /// <p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>
    pub fn update_device_certificate_params(
        &self,
    ) -> std::option::Option<&crate::model::UpdateDeviceCertificateParams> {
        self.update_device_certificate_params.as_ref()
    }
    /// <p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>
    pub fn update_ca_certificate_params(
        &self,
    ) -> std::option::Option<&crate::model::UpdateCaCertificateParams> {
        self.update_ca_certificate_params.as_ref()
    }
    /// <p>Parameters to define a mitigation action that moves devices associated with a certificate to one or more specified thing groups, typically for quarantine.</p>
    pub fn add_things_to_thing_group_params(
        &self,
    ) -> std::option::Option<&crate::model::AddThingsToThingGroupParams> {
        self.add_things_to_thing_group_params.as_ref()
    }
    /// <p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>
    pub fn replace_default_policy_version_params(
        &self,
    ) -> std::option::Option<&crate::model::ReplaceDefaultPolicyVersionParams> {
        self.replace_default_policy_version_params.as_ref()
    }
    /// <p>Parameters to define a mitigation action that enables Amazon Web Services IoT Core logging at a specified level of detail.</p>
    pub fn enable_io_t_logging_params(
        &self,
    ) -> std::option::Option<&crate::model::EnableIoTLoggingParams> {
        self.enable_io_t_logging_params.as_ref()
    }
    /// <p>Parameters to define a mitigation action that publishes findings to Amazon Simple Notification Service (Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>
    pub fn publish_finding_to_sns_params(
        &self,
    ) -> std::option::Option<&crate::model::PublishFindingToSnsParams> {
        self.publish_finding_to_sns_params.as_ref()
    }
}
impl std::fmt::Debug for MitigationActionParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MitigationActionParams");
        formatter.field(
            "update_device_certificate_params",
            &self.update_device_certificate_params,
        );
        formatter.field(
            "update_ca_certificate_params",
            &self.update_ca_certificate_params,
        );
        formatter.field(
            "add_things_to_thing_group_params",
            &self.add_things_to_thing_group_params,
        );
        formatter.field(
            "replace_default_policy_version_params",
            &self.replace_default_policy_version_params,
        );
        formatter.field(
            "enable_io_t_logging_params",
            &self.enable_io_t_logging_params,
        );
        formatter.field(
            "publish_finding_to_sns_params",
            &self.publish_finding_to_sns_params,
        );
        formatter.finish()
    }
}
/// See [`MitigationActionParams`](crate::model::MitigationActionParams)
pub mod mitigation_action_params {
    /// A builder for [`MitigationActionParams`](crate::model::MitigationActionParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_device_certificate_params:
            std::option::Option<crate::model::UpdateDeviceCertificateParams>,
        pub(crate) update_ca_certificate_params:
            std::option::Option<crate::model::UpdateCaCertificateParams>,
        pub(crate) add_things_to_thing_group_params:
            std::option::Option<crate::model::AddThingsToThingGroupParams>,
        pub(crate) replace_default_policy_version_params:
            std::option::Option<crate::model::ReplaceDefaultPolicyVersionParams>,
        pub(crate) enable_io_t_logging_params:
            std::option::Option<crate::model::EnableIoTLoggingParams>,
        pub(crate) publish_finding_to_sns_params:
            std::option::Option<crate::model::PublishFindingToSnsParams>,
    }
    impl Builder {
        /// <p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>
        pub fn update_device_certificate_params(
            mut self,
            input: crate::model::UpdateDeviceCertificateParams,
        ) -> Self {
            self.update_device_certificate_params = Some(input);
            self
        }
        /// <p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>
        pub fn set_update_device_certificate_params(
            mut self,
            input: std::option::Option<crate::model::UpdateDeviceCertificateParams>,
        ) -> Self {
            self.update_device_certificate_params = input;
            self
        }
        /// <p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>
        pub fn update_ca_certificate_params(
            mut self,
            input: crate::model::UpdateCaCertificateParams,
        ) -> Self {
            self.update_ca_certificate_params = Some(input);
            self
        }
        /// <p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>
        pub fn set_update_ca_certificate_params(
            mut self,
            input: std::option::Option<crate::model::UpdateCaCertificateParams>,
        ) -> Self {
            self.update_ca_certificate_params = input;
            self
        }
        /// <p>Parameters to define a mitigation action that moves devices associated with a certificate to one or more specified thing groups, typically for quarantine.</p>
        pub fn add_things_to_thing_group_params(
            mut self,
            input: crate::model::AddThingsToThingGroupParams,
        ) -> Self {
            self.add_things_to_thing_group_params = Some(input);
            self
        }
        /// <p>Parameters to define a mitigation action that moves devices associated with a certificate to one or more specified thing groups, typically for quarantine.</p>
        pub fn set_add_things_to_thing_group_params(
            mut self,
            input: std::option::Option<crate::model::AddThingsToThingGroupParams>,
        ) -> Self {
            self.add_things_to_thing_group_params = input;
            self
        }
        /// <p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>
        pub fn replace_default_policy_version_params(
            mut self,
            input: crate::model::ReplaceDefaultPolicyVersionParams,
        ) -> Self {
            self.replace_default_policy_version_params = Some(input);
            self
        }
        /// <p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>
        pub fn set_replace_default_policy_version_params(
            mut self,
            input: std::option::Option<crate::model::ReplaceDefaultPolicyVersionParams>,
        ) -> Self {
            self.replace_default_policy_version_params = input;
            self
        }
        /// <p>Parameters to define a mitigation action that enables Amazon Web Services IoT Core logging at a specified level of detail.</p>
        pub fn enable_io_t_logging_params(
            mut self,
            input: crate::model::EnableIoTLoggingParams,
        ) -> Self {
            self.enable_io_t_logging_params = Some(input);
            self
        }
        /// <p>Parameters to define a mitigation action that enables Amazon Web Services IoT Core logging at a specified level of detail.</p>
        pub fn set_enable_io_t_logging_params(
            mut self,
            input: std::option::Option<crate::model::EnableIoTLoggingParams>,
        ) -> Self {
            self.enable_io_t_logging_params = input;
            self
        }
        /// <p>Parameters to define a mitigation action that publishes findings to Amazon Simple Notification Service (Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>
        pub fn publish_finding_to_sns_params(
            mut self,
            input: crate::model::PublishFindingToSnsParams,
        ) -> Self {
            self.publish_finding_to_sns_params = Some(input);
            self
        }
        /// <p>Parameters to define a mitigation action that publishes findings to Amazon Simple Notification Service (Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>
        pub fn set_publish_finding_to_sns_params(
            mut self,
            input: std::option::Option<crate::model::PublishFindingToSnsParams>,
        ) -> Self {
            self.publish_finding_to_sns_params = input;
            self
        }
        /// Consumes the builder and constructs a [`MitigationActionParams`](crate::model::MitigationActionParams)
        pub fn build(self) -> crate::model::MitigationActionParams {
            crate::model::MitigationActionParams {
                update_device_certificate_params: self.update_device_certificate_params,
                update_ca_certificate_params: self.update_ca_certificate_params,
                add_things_to_thing_group_params: self.add_things_to_thing_group_params,
                replace_default_policy_version_params: self.replace_default_policy_version_params,
                enable_io_t_logging_params: self.enable_io_t_logging_params,
                publish_finding_to_sns_params: self.publish_finding_to_sns_params,
            }
        }
    }
}
impl MitigationActionParams {
    /// Creates a new builder-style object to manufacture [`MitigationActionParams`](crate::model::MitigationActionParams)
    pub fn builder() -> crate::model::mitigation_action_params::Builder {
        crate::model::mitigation_action_params::Builder::default()
    }
}

/// <p>Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishFindingToSnsParams {
    /// <p>The ARN of the topic to which you want to publish the findings.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl PublishFindingToSnsParams {
    /// <p>The ARN of the topic to which you want to publish the findings.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for PublishFindingToSnsParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishFindingToSnsParams");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`PublishFindingToSnsParams`](crate::model::PublishFindingToSnsParams)
pub mod publish_finding_to_sns_params {
    /// A builder for [`PublishFindingToSnsParams`](crate::model::PublishFindingToSnsParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic to which you want to publish the findings.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic to which you want to publish the findings.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishFindingToSnsParams`](crate::model::PublishFindingToSnsParams)
        pub fn build(self) -> crate::model::PublishFindingToSnsParams {
            crate::model::PublishFindingToSnsParams {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl PublishFindingToSnsParams {
    /// Creates a new builder-style object to manufacture [`PublishFindingToSnsParams`](crate::model::PublishFindingToSnsParams)
    pub fn builder() -> crate::model::publish_finding_to_sns_params::Builder {
        crate::model::publish_finding_to_sns_params::Builder::default()
    }
}

/// <p>Parameters used when defining a mitigation action that enable Amazon Web Services IoT Core logging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableIoTLoggingParams {
    /// <p>The Amazon Resource Name (ARN) of the IAM role used for logging.</p>
    pub role_arn_for_logging: std::option::Option<std::string::String>,
    /// <p>Specifies the type of information to be logged.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl EnableIoTLoggingParams {
    /// <p>The Amazon Resource Name (ARN) of the IAM role used for logging.</p>
    pub fn role_arn_for_logging(&self) -> std::option::Option<&str> {
        self.role_arn_for_logging.as_deref()
    }
    /// <p>Specifies the type of information to be logged.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for EnableIoTLoggingParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableIoTLoggingParams");
        formatter.field("role_arn_for_logging", &self.role_arn_for_logging);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`EnableIoTLoggingParams`](crate::model::EnableIoTLoggingParams)
pub mod enable_io_t_logging_params {
    /// A builder for [`EnableIoTLoggingParams`](crate::model::EnableIoTLoggingParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn_for_logging: std::option::Option<std::string::String>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role used for logging.</p>
        pub fn role_arn_for_logging(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn_for_logging = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used for logging.</p>
        pub fn set_role_arn_for_logging(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_arn_for_logging = input;
            self
        }
        /// <p>Specifies the type of information to be logged.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>Specifies the type of information to be logged.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableIoTLoggingParams`](crate::model::EnableIoTLoggingParams)
        pub fn build(self) -> crate::model::EnableIoTLoggingParams {
            crate::model::EnableIoTLoggingParams {
                role_arn_for_logging: self.role_arn_for_logging,
                log_level: self.log_level,
            }
        }
    }
}
impl EnableIoTLoggingParams {
    /// Creates a new builder-style object to manufacture [`EnableIoTLoggingParams`](crate::model::EnableIoTLoggingParams)
    pub fn builder() -> crate::model::enable_io_t_logging_params::Builder {
        crate::model::enable_io_t_logging_params::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogLevel {
    #[allow(missing_docs)] // documentation missing in model
    Debug,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogLevel {
    fn from(s: &str) -> Self {
        match s {
            "DEBUG" => LogLevel::Debug,
            "DISABLED" => LogLevel::Disabled,
            "ERROR" => LogLevel::Error,
            "INFO" => LogLevel::Info,
            "WARN" => LogLevel::Warn,
            other => LogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogLevel::from(s))
    }
}
impl LogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogLevel::Debug => "DEBUG",
            LogLevel::Disabled => "DISABLED",
            LogLevel::Error => "ERROR",
            LogLevel::Info => "INFO",
            LogLevel::Warn => "WARN",
            LogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEBUG", "DISABLED", "ERROR", "INFO", "WARN"]
    }
}
impl AsRef<str> for LogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplaceDefaultPolicyVersionParams {
    /// <p>The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.</p>
    pub template_name: std::option::Option<crate::model::PolicyTemplateName>,
}
impl ReplaceDefaultPolicyVersionParams {
    /// <p>The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.</p>
    pub fn template_name(&self) -> std::option::Option<&crate::model::PolicyTemplateName> {
        self.template_name.as_ref()
    }
}
impl std::fmt::Debug for ReplaceDefaultPolicyVersionParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplaceDefaultPolicyVersionParams");
        formatter.field("template_name", &self.template_name);
        formatter.finish()
    }
}
/// See [`ReplaceDefaultPolicyVersionParams`](crate::model::ReplaceDefaultPolicyVersionParams)
pub mod replace_default_policy_version_params {
    /// A builder for [`ReplaceDefaultPolicyVersionParams`](crate::model::ReplaceDefaultPolicyVersionParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_name: std::option::Option<crate::model::PolicyTemplateName>,
    }
    impl Builder {
        /// <p>The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.</p>
        pub fn template_name(mut self, input: crate::model::PolicyTemplateName) -> Self {
            self.template_name = Some(input);
            self
        }
        /// <p>The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<crate::model::PolicyTemplateName>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplaceDefaultPolicyVersionParams`](crate::model::ReplaceDefaultPolicyVersionParams)
        pub fn build(self) -> crate::model::ReplaceDefaultPolicyVersionParams {
            crate::model::ReplaceDefaultPolicyVersionParams {
                template_name: self.template_name,
            }
        }
    }
}
impl ReplaceDefaultPolicyVersionParams {
    /// Creates a new builder-style object to manufacture [`ReplaceDefaultPolicyVersionParams`](crate::model::ReplaceDefaultPolicyVersionParams)
    pub fn builder() -> crate::model::replace_default_policy_version_params::Builder {
        crate::model::replace_default_policy_version_params::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyTemplateName {
    #[allow(missing_docs)] // documentation missing in model
    BlankPolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyTemplateName {
    fn from(s: &str) -> Self {
        match s {
            "BLANK_POLICY" => PolicyTemplateName::BlankPolicy,
            other => PolicyTemplateName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyTemplateName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyTemplateName::from(s))
    }
}
impl PolicyTemplateName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyTemplateName::BlankPolicy => "BLANK_POLICY",
            PolicyTemplateName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BLANK_POLICY"]
    }
}
impl AsRef<str> for PolicyTemplateName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Parameters used when defining a mitigation action that move a set of things to a thing group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddThingsToThingGroupParams {
    /// <p>The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.</p>
    pub thing_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.</p>
    pub override_dynamic_groups: bool,
}
impl AddThingsToThingGroupParams {
    /// <p>The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.</p>
    pub fn thing_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.thing_group_names.as_deref()
    }
    /// <p>Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.</p>
    pub fn override_dynamic_groups(&self) -> bool {
        self.override_dynamic_groups
    }
}
impl std::fmt::Debug for AddThingsToThingGroupParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddThingsToThingGroupParams");
        formatter.field("thing_group_names", &self.thing_group_names);
        formatter.field("override_dynamic_groups", &self.override_dynamic_groups);
        formatter.finish()
    }
}
/// See [`AddThingsToThingGroupParams`](crate::model::AddThingsToThingGroupParams)
pub mod add_things_to_thing_group_params {
    /// A builder for [`AddThingsToThingGroupParams`](crate::model::AddThingsToThingGroupParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) override_dynamic_groups: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `thing_group_names`.
        ///
        /// To override the contents of this collection use [`set_thing_group_names`](Self::set_thing_group_names).
        ///
        /// <p>The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.</p>
        pub fn thing_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.thing_group_names.unwrap_or_default();
            v.push(input.into());
            self.thing_group_names = Some(v);
            self
        }
        /// <p>The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.</p>
        pub fn set_thing_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.thing_group_names = input;
            self
        }
        /// <p>Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.</p>
        pub fn override_dynamic_groups(mut self, input: bool) -> Self {
            self.override_dynamic_groups = Some(input);
            self
        }
        /// <p>Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.</p>
        pub fn set_override_dynamic_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.override_dynamic_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`AddThingsToThingGroupParams`](crate::model::AddThingsToThingGroupParams)
        pub fn build(self) -> crate::model::AddThingsToThingGroupParams {
            crate::model::AddThingsToThingGroupParams {
                thing_group_names: self.thing_group_names,
                override_dynamic_groups: self.override_dynamic_groups.unwrap_or_default(),
            }
        }
    }
}
impl AddThingsToThingGroupParams {
    /// Creates a new builder-style object to manufacture [`AddThingsToThingGroupParams`](crate::model::AddThingsToThingGroupParams)
    pub fn builder() -> crate::model::add_things_to_thing_group_params::Builder {
        crate::model::add_things_to_thing_group_params::Builder::default()
    }
}

/// <p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCaCertificateParams {
    /// <p>The action that you want to apply to the CA certificate. The only supported value is <code>DEACTIVATE</code>.</p>
    pub action: std::option::Option<crate::model::CaCertificateUpdateAction>,
}
impl UpdateCaCertificateParams {
    /// <p>The action that you want to apply to the CA certificate. The only supported value is <code>DEACTIVATE</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::CaCertificateUpdateAction> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for UpdateCaCertificateParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCaCertificateParams");
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`UpdateCaCertificateParams`](crate::model::UpdateCaCertificateParams)
pub mod update_ca_certificate_params {
    /// A builder for [`UpdateCaCertificateParams`](crate::model::UpdateCaCertificateParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::CaCertificateUpdateAction>,
    }
    impl Builder {
        /// <p>The action that you want to apply to the CA certificate. The only supported value is <code>DEACTIVATE</code>.</p>
        pub fn action(mut self, input: crate::model::CaCertificateUpdateAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that you want to apply to the CA certificate. The only supported value is <code>DEACTIVATE</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::CaCertificateUpdateAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCaCertificateParams`](crate::model::UpdateCaCertificateParams)
        pub fn build(self) -> crate::model::UpdateCaCertificateParams {
            crate::model::UpdateCaCertificateParams {
                action: self.action,
            }
        }
    }
}
impl UpdateCaCertificateParams {
    /// Creates a new builder-style object to manufacture [`UpdateCaCertificateParams`](crate::model::UpdateCaCertificateParams)
    pub fn builder() -> crate::model::update_ca_certificate_params::Builder {
        crate::model::update_ca_certificate_params::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CaCertificateUpdateAction {
    #[allow(missing_docs)] // documentation missing in model
    Deactivate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CaCertificateUpdateAction {
    fn from(s: &str) -> Self {
        match s {
            "DEACTIVATE" => CaCertificateUpdateAction::Deactivate,
            other => CaCertificateUpdateAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CaCertificateUpdateAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CaCertificateUpdateAction::from(s))
    }
}
impl CaCertificateUpdateAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CaCertificateUpdateAction::Deactivate => "DEACTIVATE",
            CaCertificateUpdateAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEACTIVATE"]
    }
}
impl AsRef<str> for CaCertificateUpdateAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceCertificateParams {
    /// <p>The action that you want to apply to the device certificate. The only supported value is <code>DEACTIVATE</code>.</p>
    pub action: std::option::Option<crate::model::DeviceCertificateUpdateAction>,
}
impl UpdateDeviceCertificateParams {
    /// <p>The action that you want to apply to the device certificate. The only supported value is <code>DEACTIVATE</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::DeviceCertificateUpdateAction> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for UpdateDeviceCertificateParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceCertificateParams");
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`UpdateDeviceCertificateParams`](crate::model::UpdateDeviceCertificateParams)
pub mod update_device_certificate_params {
    /// A builder for [`UpdateDeviceCertificateParams`](crate::model::UpdateDeviceCertificateParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::DeviceCertificateUpdateAction>,
    }
    impl Builder {
        /// <p>The action that you want to apply to the device certificate. The only supported value is <code>DEACTIVATE</code>.</p>
        pub fn action(mut self, input: crate::model::DeviceCertificateUpdateAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that you want to apply to the device certificate. The only supported value is <code>DEACTIVATE</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::DeviceCertificateUpdateAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceCertificateParams`](crate::model::UpdateDeviceCertificateParams)
        pub fn build(self) -> crate::model::UpdateDeviceCertificateParams {
            crate::model::UpdateDeviceCertificateParams {
                action: self.action,
            }
        }
    }
}
impl UpdateDeviceCertificateParams {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceCertificateParams`](crate::model::UpdateDeviceCertificateParams)
    pub fn builder() -> crate::model::update_device_certificate_params::Builder {
        crate::model::update_device_certificate_params::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceCertificateUpdateAction {
    #[allow(missing_docs)] // documentation missing in model
    Deactivate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceCertificateUpdateAction {
    fn from(s: &str) -> Self {
        match s {
            "DEACTIVATE" => DeviceCertificateUpdateAction::Deactivate,
            other => DeviceCertificateUpdateAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceCertificateUpdateAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceCertificateUpdateAction::from(s))
    }
}
impl DeviceCertificateUpdateAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceCertificateUpdateAction::Deactivate => "DEACTIVATE",
            DeviceCertificateUpdateAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEACTIVATE"]
    }
}
impl AsRef<str> for DeviceCertificateUpdateAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the amount of time each device has to finish its execution of the job.  A timer
/// is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job
/// execution status is not set to another terminal state before the timer expires, it will
/// be automatically set to <code>TIMED_OUT</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeoutConfig {
    /// <p>Specifies the amount of time, in minutes, this device has to finish execution of this job.  
    /// The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The
    /// in progress timer can't be updated and will apply to all job executions for the job. Whenever a job
    /// execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail
    /// and switch to the terminal <code>TIMED_OUT</code> status.</p>
    pub in_progress_timeout_in_minutes: std::option::Option<i64>,
}
impl TimeoutConfig {
    /// <p>Specifies the amount of time, in minutes, this device has to finish execution of this job.  
    /// The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The
    /// in progress timer can't be updated and will apply to all job executions for the job. Whenever a job
    /// execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail
    /// and switch to the terminal <code>TIMED_OUT</code> status.</p>
    pub fn in_progress_timeout_in_minutes(&self) -> std::option::Option<i64> {
        self.in_progress_timeout_in_minutes
    }
}
impl std::fmt::Debug for TimeoutConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeoutConfig");
        formatter.field(
            "in_progress_timeout_in_minutes",
            &self.in_progress_timeout_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`TimeoutConfig`](crate::model::TimeoutConfig)
pub mod timeout_config {
    /// A builder for [`TimeoutConfig`](crate::model::TimeoutConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) in_progress_timeout_in_minutes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies the amount of time, in minutes, this device has to finish execution of this job.  
        /// The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The
        /// in progress timer can't be updated and will apply to all job executions for the job. Whenever a job
        /// execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail
        /// and switch to the terminal <code>TIMED_OUT</code> status.</p>
        pub fn in_progress_timeout_in_minutes(mut self, input: i64) -> Self {
            self.in_progress_timeout_in_minutes = Some(input);
            self
        }
        /// <p>Specifies the amount of time, in minutes, this device has to finish execution of this job.  
        /// The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The
        /// in progress timer can't be updated and will apply to all job executions for the job. Whenever a job
        /// execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail
        /// and switch to the terminal <code>TIMED_OUT</code> status.</p>
        pub fn set_in_progress_timeout_in_minutes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.in_progress_timeout_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeoutConfig`](crate::model::TimeoutConfig)
        pub fn build(self) -> crate::model::TimeoutConfig {
            crate::model::TimeoutConfig {
                in_progress_timeout_in_minutes: self.in_progress_timeout_in_minutes,
            }
        }
    }
}
impl TimeoutConfig {
    /// Creates a new builder-style object to manufacture [`TimeoutConfig`](crate::model::TimeoutConfig)
    pub fn builder() -> crate::model::timeout_config::Builder {
        crate::model::timeout_config::Builder::default()
    }
}

/// <p>The criteria that determine when and how a job abort takes place.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortConfig {
    /// <p>The list of criteria that determine when and how to abort the job.</p>
    pub criteria_list: std::option::Option<std::vec::Vec<crate::model::AbortCriteria>>,
}
impl AbortConfig {
    /// <p>The list of criteria that determine when and how to abort the job.</p>
    pub fn criteria_list(&self) -> std::option::Option<&[crate::model::AbortCriteria]> {
        self.criteria_list.as_deref()
    }
}
impl std::fmt::Debug for AbortConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortConfig");
        formatter.field("criteria_list", &self.criteria_list);
        formatter.finish()
    }
}
/// See [`AbortConfig`](crate::model::AbortConfig)
pub mod abort_config {
    /// A builder for [`AbortConfig`](crate::model::AbortConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) criteria_list: std::option::Option<std::vec::Vec<crate::model::AbortCriteria>>,
    }
    impl Builder {
        /// Appends an item to `criteria_list`.
        ///
        /// To override the contents of this collection use [`set_criteria_list`](Self::set_criteria_list).
        ///
        /// <p>The list of criteria that determine when and how to abort the job.</p>
        pub fn criteria_list(mut self, input: impl Into<crate::model::AbortCriteria>) -> Self {
            let mut v = self.criteria_list.unwrap_or_default();
            v.push(input.into());
            self.criteria_list = Some(v);
            self
        }
        /// <p>The list of criteria that determine when and how to abort the job.</p>
        pub fn set_criteria_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AbortCriteria>>,
        ) -> Self {
            self.criteria_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortConfig`](crate::model::AbortConfig)
        pub fn build(self) -> crate::model::AbortConfig {
            crate::model::AbortConfig {
                criteria_list: self.criteria_list,
            }
        }
    }
}
impl AbortConfig {
    /// Creates a new builder-style object to manufacture [`AbortConfig`](crate::model::AbortConfig)
    pub fn builder() -> crate::model::abort_config::Builder {
        crate::model::abort_config::Builder::default()
    }
}

/// <p>The criteria that determine when and how a job abort takes place.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortCriteria {
    /// <p>The type of job execution failures that can initiate a job abort.</p>
    pub failure_type: std::option::Option<crate::model::JobExecutionFailureType>,
    /// <p>The type of job action to take to initiate the job abort.</p>
    pub action: std::option::Option<crate::model::AbortAction>,
    /// <p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p>
    /// <p>Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>
    pub threshold_percentage: std::option::Option<f64>,
    /// <p>The minimum number of things which must receive job execution notifications before the job
    /// can be aborted.</p>
    pub min_number_of_executed_things: std::option::Option<i32>,
}
impl AbortCriteria {
    /// <p>The type of job execution failures that can initiate a job abort.</p>
    pub fn failure_type(&self) -> std::option::Option<&crate::model::JobExecutionFailureType> {
        self.failure_type.as_ref()
    }
    /// <p>The type of job action to take to initiate the job abort.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::AbortAction> {
        self.action.as_ref()
    }
    /// <p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p>
    /// <p>Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>
    pub fn threshold_percentage(&self) -> std::option::Option<f64> {
        self.threshold_percentage
    }
    /// <p>The minimum number of things which must receive job execution notifications before the job
    /// can be aborted.</p>
    pub fn min_number_of_executed_things(&self) -> std::option::Option<i32> {
        self.min_number_of_executed_things
    }
}
impl std::fmt::Debug for AbortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortCriteria");
        formatter.field("failure_type", &self.failure_type);
        formatter.field("action", &self.action);
        formatter.field("threshold_percentage", &self.threshold_percentage);
        formatter.field(
            "min_number_of_executed_things",
            &self.min_number_of_executed_things,
        );
        formatter.finish()
    }
}
/// See [`AbortCriteria`](crate::model::AbortCriteria)
pub mod abort_criteria {
    /// A builder for [`AbortCriteria`](crate::model::AbortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_type: std::option::Option<crate::model::JobExecutionFailureType>,
        pub(crate) action: std::option::Option<crate::model::AbortAction>,
        pub(crate) threshold_percentage: std::option::Option<f64>,
        pub(crate) min_number_of_executed_things: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of job execution failures that can initiate a job abort.</p>
        pub fn failure_type(mut self, input: crate::model::JobExecutionFailureType) -> Self {
            self.failure_type = Some(input);
            self
        }
        /// <p>The type of job execution failures that can initiate a job abort.</p>
        pub fn set_failure_type(
            mut self,
            input: std::option::Option<crate::model::JobExecutionFailureType>,
        ) -> Self {
            self.failure_type = input;
            self
        }
        /// <p>The type of job action to take to initiate the job abort.</p>
        pub fn action(mut self, input: crate::model::AbortAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The type of job action to take to initiate the job abort.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::AbortAction>) -> Self {
            self.action = input;
            self
        }
        /// <p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p>
        /// <p>Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>
        pub fn threshold_percentage(mut self, input: f64) -> Self {
            self.threshold_percentage = Some(input);
            self
        }
        /// <p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p>
        /// <p>Amazon Web Services IoT Core supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>
        pub fn set_threshold_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold_percentage = input;
            self
        }
        /// <p>The minimum number of things which must receive job execution notifications before the job
        /// can be aborted.</p>
        pub fn min_number_of_executed_things(mut self, input: i32) -> Self {
            self.min_number_of_executed_things = Some(input);
            self
        }
        /// <p>The minimum number of things which must receive job execution notifications before the job
        /// can be aborted.</p>
        pub fn set_min_number_of_executed_things(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.min_number_of_executed_things = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortCriteria`](crate::model::AbortCriteria)
        pub fn build(self) -> crate::model::AbortCriteria {
            crate::model::AbortCriteria {
                failure_type: self.failure_type,
                action: self.action,
                threshold_percentage: self.threshold_percentage,
                min_number_of_executed_things: self.min_number_of_executed_things,
            }
        }
    }
}
impl AbortCriteria {
    /// Creates a new builder-style object to manufacture [`AbortCriteria`](crate::model::AbortCriteria)
    pub fn builder() -> crate::model::abort_criteria::Builder {
        crate::model::abort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AbortAction {
    #[allow(missing_docs)] // documentation missing in model
    Cancel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AbortAction {
    fn from(s: &str) -> Self {
        match s {
            "CANCEL" => AbortAction::Cancel,
            other => AbortAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AbortAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AbortAction::from(s))
    }
}
impl AbortAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AbortAction::Cancel => "CANCEL",
            AbortAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCEL"]
    }
}
impl AsRef<str> for AbortAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobExecutionFailureType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobExecutionFailureType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => JobExecutionFailureType::All,
            "FAILED" => JobExecutionFailureType::Failed,
            "REJECTED" => JobExecutionFailureType::Rejected,
            "TIMED_OUT" => JobExecutionFailureType::TimedOut,
            other => JobExecutionFailureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobExecutionFailureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobExecutionFailureType::from(s))
    }
}
impl JobExecutionFailureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobExecutionFailureType::All => "ALL",
            JobExecutionFailureType::Failed => "FAILED",
            JobExecutionFailureType::Rejected => "REJECTED",
            JobExecutionFailureType::TimedOut => "TIMED_OUT",
            JobExecutionFailureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "FAILED", "REJECTED", "TIMED_OUT"]
    }
}
impl AsRef<str> for JobExecutionFailureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Allows you to create a staged rollout of a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobExecutionsRolloutConfig {
    /// <p>The maximum number of things that will be notified of a pending job, per minute.
    /// This parameter allows you to create a staged rollout.</p>
    pub maximum_per_minute: std::option::Option<i32>,
    /// <p>The rate of increase for a job rollout.
    /// This parameter allows you to define an exponential rate for a job rollout.</p>
    pub exponential_rate: std::option::Option<crate::model::ExponentialRolloutRate>,
}
impl JobExecutionsRolloutConfig {
    /// <p>The maximum number of things that will be notified of a pending job, per minute.
    /// This parameter allows you to create a staged rollout.</p>
    pub fn maximum_per_minute(&self) -> std::option::Option<i32> {
        self.maximum_per_minute
    }
    /// <p>The rate of increase for a job rollout.
    /// This parameter allows you to define an exponential rate for a job rollout.</p>
    pub fn exponential_rate(&self) -> std::option::Option<&crate::model::ExponentialRolloutRate> {
        self.exponential_rate.as_ref()
    }
}
impl std::fmt::Debug for JobExecutionsRolloutConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobExecutionsRolloutConfig");
        formatter.field("maximum_per_minute", &self.maximum_per_minute);
        formatter.field("exponential_rate", &self.exponential_rate);
        formatter.finish()
    }
}
/// See [`JobExecutionsRolloutConfig`](crate::model::JobExecutionsRolloutConfig)
pub mod job_executions_rollout_config {
    /// A builder for [`JobExecutionsRolloutConfig`](crate::model::JobExecutionsRolloutConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_per_minute: std::option::Option<i32>,
        pub(crate) exponential_rate: std::option::Option<crate::model::ExponentialRolloutRate>,
    }
    impl Builder {
        /// <p>The maximum number of things that will be notified of a pending job, per minute.
        /// This parameter allows you to create a staged rollout.</p>
        pub fn maximum_per_minute(mut self, input: i32) -> Self {
            self.maximum_per_minute = Some(input);
            self
        }
        /// <p>The maximum number of things that will be notified of a pending job, per minute.
        /// This parameter allows you to create a staged rollout.</p>
        pub fn set_maximum_per_minute(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_per_minute = input;
            self
        }
        /// <p>The rate of increase for a job rollout.
        /// This parameter allows you to define an exponential rate for a job rollout.</p>
        pub fn exponential_rate(mut self, input: crate::model::ExponentialRolloutRate) -> Self {
            self.exponential_rate = Some(input);
            self
        }
        /// <p>The rate of increase for a job rollout.
        /// This parameter allows you to define an exponential rate for a job rollout.</p>
        pub fn set_exponential_rate(
            mut self,
            input: std::option::Option<crate::model::ExponentialRolloutRate>,
        ) -> Self {
            self.exponential_rate = input;
            self
        }
        /// Consumes the builder and constructs a [`JobExecutionsRolloutConfig`](crate::model::JobExecutionsRolloutConfig)
        pub fn build(self) -> crate::model::JobExecutionsRolloutConfig {
            crate::model::JobExecutionsRolloutConfig {
                maximum_per_minute: self.maximum_per_minute,
                exponential_rate: self.exponential_rate,
            }
        }
    }
}
impl JobExecutionsRolloutConfig {
    /// Creates a new builder-style object to manufacture [`JobExecutionsRolloutConfig`](crate::model::JobExecutionsRolloutConfig)
    pub fn builder() -> crate::model::job_executions_rollout_config::Builder {
        crate::model::job_executions_rollout_config::Builder::default()
    }
}

/// <p>Allows you to create an exponential rate of rollout for a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExponentialRolloutRate {
    /// <p>The minimum number of things that will be notified of a pending job, per minute at the start of job rollout.
    /// This parameter allows you to define the initial rate of rollout.</p>
    pub base_rate_per_minute: std::option::Option<i32>,
    /// <p>The exponential factor to increase the rate of rollout for a job.</p>
    /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
    pub increment_factor: f64,
    /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
    pub rate_increase_criteria: std::option::Option<crate::model::RateIncreaseCriteria>,
}
impl ExponentialRolloutRate {
    /// <p>The minimum number of things that will be notified of a pending job, per minute at the start of job rollout.
    /// This parameter allows you to define the initial rate of rollout.</p>
    pub fn base_rate_per_minute(&self) -> std::option::Option<i32> {
        self.base_rate_per_minute
    }
    /// <p>The exponential factor to increase the rate of rollout for a job.</p>
    /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
    pub fn increment_factor(&self) -> f64 {
        self.increment_factor
    }
    /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
    pub fn rate_increase_criteria(
        &self,
    ) -> std::option::Option<&crate::model::RateIncreaseCriteria> {
        self.rate_increase_criteria.as_ref()
    }
}
impl std::fmt::Debug for ExponentialRolloutRate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExponentialRolloutRate");
        formatter.field("base_rate_per_minute", &self.base_rate_per_minute);
        formatter.field("increment_factor", &self.increment_factor);
        formatter.field("rate_increase_criteria", &self.rate_increase_criteria);
        formatter.finish()
    }
}
/// See [`ExponentialRolloutRate`](crate::model::ExponentialRolloutRate)
pub mod exponential_rollout_rate {
    /// A builder for [`ExponentialRolloutRate`](crate::model::ExponentialRolloutRate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_rate_per_minute: std::option::Option<i32>,
        pub(crate) increment_factor: std::option::Option<f64>,
        pub(crate) rate_increase_criteria: std::option::Option<crate::model::RateIncreaseCriteria>,
    }
    impl Builder {
        /// <p>The minimum number of things that will be notified of a pending job, per minute at the start of job rollout.
        /// This parameter allows you to define the initial rate of rollout.</p>
        pub fn base_rate_per_minute(mut self, input: i32) -> Self {
            self.base_rate_per_minute = Some(input);
            self
        }
        /// <p>The minimum number of things that will be notified of a pending job, per minute at the start of job rollout.
        /// This parameter allows you to define the initial rate of rollout.</p>
        pub fn set_base_rate_per_minute(mut self, input: std::option::Option<i32>) -> Self {
            self.base_rate_per_minute = input;
            self
        }
        /// <p>The exponential factor to increase the rate of rollout for a job.</p>
        /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
        pub fn increment_factor(mut self, input: f64) -> Self {
            self.increment_factor = Some(input);
            self
        }
        /// <p>The exponential factor to increase the rate of rollout for a job.</p>
        /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
        pub fn set_increment_factor(mut self, input: std::option::Option<f64>) -> Self {
            self.increment_factor = input;
            self
        }
        /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
        pub fn rate_increase_criteria(mut self, input: crate::model::RateIncreaseCriteria) -> Self {
            self.rate_increase_criteria = Some(input);
            self
        }
        /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
        pub fn set_rate_increase_criteria(
            mut self,
            input: std::option::Option<crate::model::RateIncreaseCriteria>,
        ) -> Self {
            self.rate_increase_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`ExponentialRolloutRate`](crate::model::ExponentialRolloutRate)
        pub fn build(self) -> crate::model::ExponentialRolloutRate {
            crate::model::ExponentialRolloutRate {
                base_rate_per_minute: self.base_rate_per_minute,
                increment_factor: self.increment_factor.unwrap_or_default(),
                rate_increase_criteria: self.rate_increase_criteria,
            }
        }
    }
}
impl ExponentialRolloutRate {
    /// Creates a new builder-style object to manufacture [`ExponentialRolloutRate`](crate::model::ExponentialRolloutRate)
    pub fn builder() -> crate::model::exponential_rollout_rate::Builder {
        crate::model::exponential_rollout_rate::Builder::default()
    }
}

/// <p>Allows you to define a criteria to initiate the increase in rate of rollout for a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RateIncreaseCriteria {
    /// <p>The threshold for number of notified things that will initiate the increase in rate of rollout.</p>
    pub number_of_notified_things: std::option::Option<i32>,
    /// <p>The threshold for number of succeeded things that will initiate the increase in rate of rollout.</p>
    pub number_of_succeeded_things: std::option::Option<i32>,
}
impl RateIncreaseCriteria {
    /// <p>The threshold for number of notified things that will initiate the increase in rate of rollout.</p>
    pub fn number_of_notified_things(&self) -> std::option::Option<i32> {
        self.number_of_notified_things
    }
    /// <p>The threshold for number of succeeded things that will initiate the increase in rate of rollout.</p>
    pub fn number_of_succeeded_things(&self) -> std::option::Option<i32> {
        self.number_of_succeeded_things
    }
}
impl std::fmt::Debug for RateIncreaseCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RateIncreaseCriteria");
        formatter.field("number_of_notified_things", &self.number_of_notified_things);
        formatter.field(
            "number_of_succeeded_things",
            &self.number_of_succeeded_things,
        );
        formatter.finish()
    }
}
/// See [`RateIncreaseCriteria`](crate::model::RateIncreaseCriteria)
pub mod rate_increase_criteria {
    /// A builder for [`RateIncreaseCriteria`](crate::model::RateIncreaseCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_notified_things: std::option::Option<i32>,
        pub(crate) number_of_succeeded_things: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The threshold for number of notified things that will initiate the increase in rate of rollout.</p>
        pub fn number_of_notified_things(mut self, input: i32) -> Self {
            self.number_of_notified_things = Some(input);
            self
        }
        /// <p>The threshold for number of notified things that will initiate the increase in rate of rollout.</p>
        pub fn set_number_of_notified_things(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_notified_things = input;
            self
        }
        /// <p>The threshold for number of succeeded things that will initiate the increase in rate of rollout.</p>
        pub fn number_of_succeeded_things(mut self, input: i32) -> Self {
            self.number_of_succeeded_things = Some(input);
            self
        }
        /// <p>The threshold for number of succeeded things that will initiate the increase in rate of rollout.</p>
        pub fn set_number_of_succeeded_things(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_succeeded_things = input;
            self
        }
        /// Consumes the builder and constructs a [`RateIncreaseCriteria`](crate::model::RateIncreaseCriteria)
        pub fn build(self) -> crate::model::RateIncreaseCriteria {
            crate::model::RateIncreaseCriteria {
                number_of_notified_things: self.number_of_notified_things,
                number_of_succeeded_things: self.number_of_succeeded_things,
            }
        }
    }
}
impl RateIncreaseCriteria {
    /// Creates a new builder-style object to manufacture [`RateIncreaseCriteria`](crate::model::RateIncreaseCriteria)
    pub fn builder() -> crate::model::rate_increase_criteria::Builder {
        crate::model::rate_increase_criteria::Builder::default()
    }
}

/// <p>Configuration for pre-signed S3 URLs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PresignedUrlConfig {
    /// <p>The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
    /// data/updates are stored. The role must also grant permission for IoT to download the files.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
    /// seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.</p>
    pub expires_in_sec: std::option::Option<i64>,
}
impl PresignedUrlConfig {
    /// <p>The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
    /// data/updates are stored. The role must also grant permission for IoT to download the files.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
    /// seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.</p>
    pub fn expires_in_sec(&self) -> std::option::Option<i64> {
        self.expires_in_sec
    }
}
impl std::fmt::Debug for PresignedUrlConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PresignedUrlConfig");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("expires_in_sec", &self.expires_in_sec);
        formatter.finish()
    }
}
/// See [`PresignedUrlConfig`](crate::model::PresignedUrlConfig)
pub mod presigned_url_config {
    /// A builder for [`PresignedUrlConfig`](crate::model::PresignedUrlConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) expires_in_sec: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
        /// data/updates are stored. The role must also grant permission for IoT to download the files.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job
        /// data/updates are stored. The role must also grant permission for IoT to download the files.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
        /// seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.</p>
        pub fn expires_in_sec(mut self, input: i64) -> Self {
            self.expires_in_sec = Some(input);
            self
        }
        /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600
        /// seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.</p>
        pub fn set_expires_in_sec(mut self, input: std::option::Option<i64>) -> Self {
            self.expires_in_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`PresignedUrlConfig`](crate::model::PresignedUrlConfig)
        pub fn build(self) -> crate::model::PresignedUrlConfig {
            crate::model::PresignedUrlConfig {
                role_arn: self.role_arn,
                expires_in_sec: self.expires_in_sec,
            }
        }
    }
}
impl PresignedUrlConfig {
    /// Creates a new builder-style object to manufacture [`PresignedUrlConfig`](crate::model::PresignedUrlConfig)
    pub fn builder() -> crate::model::presigned_url_config::Builder {
        crate::model::presigned_url_config::Builder::default()
    }
}

/// <p>Thing group indexing configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingGroupIndexingConfiguration {
    /// <p>Thing group indexing mode.</p>
    pub thing_group_indexing_mode: std::option::Option<crate::model::ThingGroupIndexingMode>,
    /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
    /// service.</p>
    pub managed_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
    /// <p>A list of thing group fields to index. This list cannot contain any managed fields. Use
    /// the GetIndexingConfiguration API to get a list of managed fields.</p>
    /// <p>Contains custom field names and their data type.</p>
    pub custom_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
}
impl ThingGroupIndexingConfiguration {
    /// <p>Thing group indexing mode.</p>
    pub fn thing_group_indexing_mode(
        &self,
    ) -> std::option::Option<&crate::model::ThingGroupIndexingMode> {
        self.thing_group_indexing_mode.as_ref()
    }
    /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
    /// service.</p>
    pub fn managed_fields(&self) -> std::option::Option<&[crate::model::Field]> {
        self.managed_fields.as_deref()
    }
    /// <p>A list of thing group fields to index. This list cannot contain any managed fields. Use
    /// the GetIndexingConfiguration API to get a list of managed fields.</p>
    /// <p>Contains custom field names and their data type.</p>
    pub fn custom_fields(&self) -> std::option::Option<&[crate::model::Field]> {
        self.custom_fields.as_deref()
    }
}
impl std::fmt::Debug for ThingGroupIndexingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingGroupIndexingConfiguration");
        formatter.field("thing_group_indexing_mode", &self.thing_group_indexing_mode);
        formatter.field("managed_fields", &self.managed_fields);
        formatter.field("custom_fields", &self.custom_fields);
        formatter.finish()
    }
}
/// See [`ThingGroupIndexingConfiguration`](crate::model::ThingGroupIndexingConfiguration)
pub mod thing_group_indexing_configuration {
    /// A builder for [`ThingGroupIndexingConfiguration`](crate::model::ThingGroupIndexingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_indexing_mode:
            std::option::Option<crate::model::ThingGroupIndexingMode>,
        pub(crate) managed_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
        pub(crate) custom_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
    }
    impl Builder {
        /// <p>Thing group indexing mode.</p>
        pub fn thing_group_indexing_mode(
            mut self,
            input: crate::model::ThingGroupIndexingMode,
        ) -> Self {
            self.thing_group_indexing_mode = Some(input);
            self
        }
        /// <p>Thing group indexing mode.</p>
        pub fn set_thing_group_indexing_mode(
            mut self,
            input: std::option::Option<crate::model::ThingGroupIndexingMode>,
        ) -> Self {
            self.thing_group_indexing_mode = input;
            self
        }
        /// Appends an item to `managed_fields`.
        ///
        /// To override the contents of this collection use [`set_managed_fields`](Self::set_managed_fields).
        ///
        /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
        /// service.</p>
        pub fn managed_fields(mut self, input: impl Into<crate::model::Field>) -> Self {
            let mut v = self.managed_fields.unwrap_or_default();
            v.push(input.into());
            self.managed_fields = Some(v);
            self
        }
        /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
        /// service.</p>
        pub fn set_managed_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.managed_fields = input;
            self
        }
        /// Appends an item to `custom_fields`.
        ///
        /// To override the contents of this collection use [`set_custom_fields`](Self::set_custom_fields).
        ///
        /// <p>A list of thing group fields to index. This list cannot contain any managed fields. Use
        /// the GetIndexingConfiguration API to get a list of managed fields.</p>
        /// <p>Contains custom field names and their data type.</p>
        pub fn custom_fields(mut self, input: impl Into<crate::model::Field>) -> Self {
            let mut v = self.custom_fields.unwrap_or_default();
            v.push(input.into());
            self.custom_fields = Some(v);
            self
        }
        /// <p>A list of thing group fields to index. This list cannot contain any managed fields. Use
        /// the GetIndexingConfiguration API to get a list of managed fields.</p>
        /// <p>Contains custom field names and their data type.</p>
        pub fn set_custom_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.custom_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingGroupIndexingConfiguration`](crate::model::ThingGroupIndexingConfiguration)
        pub fn build(self) -> crate::model::ThingGroupIndexingConfiguration {
            crate::model::ThingGroupIndexingConfiguration {
                thing_group_indexing_mode: self.thing_group_indexing_mode,
                managed_fields: self.managed_fields,
                custom_fields: self.custom_fields,
            }
        }
    }
}
impl ThingGroupIndexingConfiguration {
    /// Creates a new builder-style object to manufacture [`ThingGroupIndexingConfiguration`](crate::model::ThingGroupIndexingConfiguration)
    pub fn builder() -> crate::model::thing_group_indexing_configuration::Builder {
        crate::model::thing_group_indexing_configuration::Builder::default()
    }
}

/// <p>Describes the name and data type at a field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Field {
    /// <p>The name of the field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the field.</p>
    pub r#type: std::option::Option<crate::model::FieldType>,
}
impl Field {
    /// <p>The name of the field.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data type of the field.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FieldType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Field {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Field");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Field`](crate::model::Field)
pub mod field {
    /// A builder for [`Field`](crate::model::Field)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FieldType>,
    }
    impl Builder {
        /// <p>The name of the field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the field.</p>
        pub fn r#type(mut self, input: crate::model::FieldType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The data type of the field.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FieldType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Field`](crate::model::Field)
        pub fn build(self) -> crate::model::Field {
            crate::model::Field {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl Field {
    /// Creates a new builder-style object to manufacture [`Field`](crate::model::Field)
    pub fn builder() -> crate::model::field::Builder {
        crate::model::field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FieldType {
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FieldType {
    fn from(s: &str) -> Self {
        match s {
            "Boolean" => FieldType::Boolean,
            "Number" => FieldType::Number,
            "String" => FieldType::String,
            other => FieldType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FieldType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FieldType::from(s))
    }
}
impl FieldType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FieldType::Boolean => "Boolean",
            FieldType::Number => "Number",
            FieldType::String => "String",
            FieldType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Boolean", "Number", "String"]
    }
}
impl AsRef<str> for FieldType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThingGroupIndexingMode {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    On,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThingGroupIndexingMode {
    fn from(s: &str) -> Self {
        match s {
            "OFF" => ThingGroupIndexingMode::Off,
            "ON" => ThingGroupIndexingMode::On,
            other => ThingGroupIndexingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThingGroupIndexingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThingGroupIndexingMode::from(s))
    }
}
impl ThingGroupIndexingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThingGroupIndexingMode::Off => "OFF",
            ThingGroupIndexingMode::On => "ON",
            ThingGroupIndexingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFF", "ON"]
    }
}
impl AsRef<str> for ThingGroupIndexingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The thing indexing configuration. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html">Managing
/// Thing Indexing</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingIndexingConfiguration {
    /// <p>Thing indexing mode. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>REGISTRY – Your thing index contains registry data only.</p>
    /// </li>
    /// <li>
    /// <p>REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.</p>
    /// </li>
    /// <li>
    /// <p>OFF - Thing indexing is disabled.</p>
    /// </li>
    /// </ul>
    pub thing_indexing_mode: std::option::Option<crate::model::ThingIndexingMode>,
    /// <p>Thing connectivity indexing mode. Valid values are: </p>
    /// <ul>
    /// <li>
    /// <p>STATUS – Your thing index contains connectivity status. To enable thing
    /// connectivity indexing, <i>thingIndexMode</i> must not be set to
    /// OFF.</p>
    /// </li>
    /// <li>
    /// <p>OFF - Thing connectivity status indexing is disabled.</p>
    /// </li>
    /// </ul>
    pub thing_connectivity_indexing_mode:
        std::option::Option<crate::model::ThingConnectivityIndexingMode>,
    /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
    /// service.</p>
    pub managed_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
    /// <p>Contains custom field names and their data type.</p>
    pub custom_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
}
impl ThingIndexingConfiguration {
    /// <p>Thing indexing mode. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>REGISTRY – Your thing index contains registry data only.</p>
    /// </li>
    /// <li>
    /// <p>REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.</p>
    /// </li>
    /// <li>
    /// <p>OFF - Thing indexing is disabled.</p>
    /// </li>
    /// </ul>
    pub fn thing_indexing_mode(&self) -> std::option::Option<&crate::model::ThingIndexingMode> {
        self.thing_indexing_mode.as_ref()
    }
    /// <p>Thing connectivity indexing mode. Valid values are: </p>
    /// <ul>
    /// <li>
    /// <p>STATUS – Your thing index contains connectivity status. To enable thing
    /// connectivity indexing, <i>thingIndexMode</i> must not be set to
    /// OFF.</p>
    /// </li>
    /// <li>
    /// <p>OFF - Thing connectivity status indexing is disabled.</p>
    /// </li>
    /// </ul>
    pub fn thing_connectivity_indexing_mode(
        &self,
    ) -> std::option::Option<&crate::model::ThingConnectivityIndexingMode> {
        self.thing_connectivity_indexing_mode.as_ref()
    }
    /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
    /// service.</p>
    pub fn managed_fields(&self) -> std::option::Option<&[crate::model::Field]> {
        self.managed_fields.as_deref()
    }
    /// <p>Contains custom field names and their data type.</p>
    pub fn custom_fields(&self) -> std::option::Option<&[crate::model::Field]> {
        self.custom_fields.as_deref()
    }
}
impl std::fmt::Debug for ThingIndexingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingIndexingConfiguration");
        formatter.field("thing_indexing_mode", &self.thing_indexing_mode);
        formatter.field(
            "thing_connectivity_indexing_mode",
            &self.thing_connectivity_indexing_mode,
        );
        formatter.field("managed_fields", &self.managed_fields);
        formatter.field("custom_fields", &self.custom_fields);
        formatter.finish()
    }
}
/// See [`ThingIndexingConfiguration`](crate::model::ThingIndexingConfiguration)
pub mod thing_indexing_configuration {
    /// A builder for [`ThingIndexingConfiguration`](crate::model::ThingIndexingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_indexing_mode: std::option::Option<crate::model::ThingIndexingMode>,
        pub(crate) thing_connectivity_indexing_mode:
            std::option::Option<crate::model::ThingConnectivityIndexingMode>,
        pub(crate) managed_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
        pub(crate) custom_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
    }
    impl Builder {
        /// <p>Thing indexing mode. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>REGISTRY – Your thing index contains registry data only.</p>
        /// </li>
        /// <li>
        /// <p>REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.</p>
        /// </li>
        /// <li>
        /// <p>OFF - Thing indexing is disabled.</p>
        /// </li>
        /// </ul>
        pub fn thing_indexing_mode(mut self, input: crate::model::ThingIndexingMode) -> Self {
            self.thing_indexing_mode = Some(input);
            self
        }
        /// <p>Thing indexing mode. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>REGISTRY – Your thing index contains registry data only.</p>
        /// </li>
        /// <li>
        /// <p>REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.</p>
        /// </li>
        /// <li>
        /// <p>OFF - Thing indexing is disabled.</p>
        /// </li>
        /// </ul>
        pub fn set_thing_indexing_mode(
            mut self,
            input: std::option::Option<crate::model::ThingIndexingMode>,
        ) -> Self {
            self.thing_indexing_mode = input;
            self
        }
        /// <p>Thing connectivity indexing mode. Valid values are: </p>
        /// <ul>
        /// <li>
        /// <p>STATUS – Your thing index contains connectivity status. To enable thing
        /// connectivity indexing, <i>thingIndexMode</i> must not be set to
        /// OFF.</p>
        /// </li>
        /// <li>
        /// <p>OFF - Thing connectivity status indexing is disabled.</p>
        /// </li>
        /// </ul>
        pub fn thing_connectivity_indexing_mode(
            mut self,
            input: crate::model::ThingConnectivityIndexingMode,
        ) -> Self {
            self.thing_connectivity_indexing_mode = Some(input);
            self
        }
        /// <p>Thing connectivity indexing mode. Valid values are: </p>
        /// <ul>
        /// <li>
        /// <p>STATUS – Your thing index contains connectivity status. To enable thing
        /// connectivity indexing, <i>thingIndexMode</i> must not be set to
        /// OFF.</p>
        /// </li>
        /// <li>
        /// <p>OFF - Thing connectivity status indexing is disabled.</p>
        /// </li>
        /// </ul>
        pub fn set_thing_connectivity_indexing_mode(
            mut self,
            input: std::option::Option<crate::model::ThingConnectivityIndexingMode>,
        ) -> Self {
            self.thing_connectivity_indexing_mode = input;
            self
        }
        /// Appends an item to `managed_fields`.
        ///
        /// To override the contents of this collection use [`set_managed_fields`](Self::set_managed_fields).
        ///
        /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
        /// service.</p>
        pub fn managed_fields(mut self, input: impl Into<crate::model::Field>) -> Self {
            let mut v = self.managed_fields.unwrap_or_default();
            v.push(input.into());
            self.managed_fields = Some(v);
            self
        }
        /// <p>Contains fields that are indexed and whose types are already known by the Fleet Indexing
        /// service.</p>
        pub fn set_managed_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.managed_fields = input;
            self
        }
        /// Appends an item to `custom_fields`.
        ///
        /// To override the contents of this collection use [`set_custom_fields`](Self::set_custom_fields).
        ///
        /// <p>Contains custom field names and their data type.</p>
        pub fn custom_fields(mut self, input: impl Into<crate::model::Field>) -> Self {
            let mut v = self.custom_fields.unwrap_or_default();
            v.push(input.into());
            self.custom_fields = Some(v);
            self
        }
        /// <p>Contains custom field names and their data type.</p>
        pub fn set_custom_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.custom_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingIndexingConfiguration`](crate::model::ThingIndexingConfiguration)
        pub fn build(self) -> crate::model::ThingIndexingConfiguration {
            crate::model::ThingIndexingConfiguration {
                thing_indexing_mode: self.thing_indexing_mode,
                thing_connectivity_indexing_mode: self.thing_connectivity_indexing_mode,
                managed_fields: self.managed_fields,
                custom_fields: self.custom_fields,
            }
        }
    }
}
impl ThingIndexingConfiguration {
    /// Creates a new builder-style object to manufacture [`ThingIndexingConfiguration`](crate::model::ThingIndexingConfiguration)
    pub fn builder() -> crate::model::thing_indexing_configuration::Builder {
        crate::model::thing_indexing_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThingConnectivityIndexingMode {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThingConnectivityIndexingMode {
    fn from(s: &str) -> Self {
        match s {
            "OFF" => ThingConnectivityIndexingMode::Off,
            "STATUS" => ThingConnectivityIndexingMode::Status,
            other => ThingConnectivityIndexingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThingConnectivityIndexingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThingConnectivityIndexingMode::from(s))
    }
}
impl ThingConnectivityIndexingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThingConnectivityIndexingMode::Off => "OFF",
            ThingConnectivityIndexingMode::Status => "STATUS",
            ThingConnectivityIndexingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFF", "STATUS"]
    }
}
impl AsRef<str> for ThingConnectivityIndexingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThingIndexingMode {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    Registry,
    #[allow(missing_docs)] // documentation missing in model
    RegistryAndShadow,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThingIndexingMode {
    fn from(s: &str) -> Self {
        match s {
            "OFF" => ThingIndexingMode::Off,
            "REGISTRY" => ThingIndexingMode::Registry,
            "REGISTRY_AND_SHADOW" => ThingIndexingMode::RegistryAndShadow,
            other => ThingIndexingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThingIndexingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThingIndexingMode::from(s))
    }
}
impl ThingIndexingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThingIndexingMode::Off => "OFF",
            ThingIndexingMode::Registry => "REGISTRY",
            ThingIndexingMode::RegistryAndShadow => "REGISTRY_AND_SHADOW",
            ThingIndexingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFF", "REGISTRY", "REGISTRY_AND_SHADOW"]
    }
}
impl AsRef<str> for ThingIndexingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetMetricUnit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabits,
    #[allow(missing_docs)] // documentation missing in model
    GigabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabytes,
    #[allow(missing_docs)] // documentation missing in model
    GigabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobits,
    #[allow(missing_docs)] // documentation missing in model
    KilobitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    #[allow(missing_docs)] // documentation missing in model
    KilobytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabits,
    #[allow(missing_docs)] // documentation missing in model
    MegabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabytes,
    #[allow(missing_docs)] // documentation missing in model
    MegabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Microseconds,
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    Terabits,
    #[allow(missing_docs)] // documentation missing in model
    TerabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    #[allow(missing_docs)] // documentation missing in model
    TerabytesSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetMetricUnit {
    fn from(s: &str) -> Self {
        match s {
            "Bits" => FleetMetricUnit::Bits,
            "Bits/Second" => FleetMetricUnit::BitsSecond,
            "Bytes" => FleetMetricUnit::Bytes,
            "Bytes/Second" => FleetMetricUnit::BytesSecond,
            "Count" => FleetMetricUnit::Count,
            "Count/Second" => FleetMetricUnit::CountSecond,
            "Gigabits" => FleetMetricUnit::Gigabits,
            "Gigabits/Second" => FleetMetricUnit::GigabitsSecond,
            "Gigabytes" => FleetMetricUnit::Gigabytes,
            "Gigabytes/Second" => FleetMetricUnit::GigabytesSecond,
            "Kilobits" => FleetMetricUnit::Kilobits,
            "Kilobits/Second" => FleetMetricUnit::KilobitsSecond,
            "Kilobytes" => FleetMetricUnit::Kilobytes,
            "Kilobytes/Second" => FleetMetricUnit::KilobytesSecond,
            "Megabits" => FleetMetricUnit::Megabits,
            "Megabits/Second" => FleetMetricUnit::MegabitsSecond,
            "Megabytes" => FleetMetricUnit::Megabytes,
            "Megabytes/Second" => FleetMetricUnit::MegabytesSecond,
            "Microseconds" => FleetMetricUnit::Microseconds,
            "Milliseconds" => FleetMetricUnit::Milliseconds,
            "None" => FleetMetricUnit::None,
            "Percent" => FleetMetricUnit::Percent,
            "Seconds" => FleetMetricUnit::Seconds,
            "Terabits" => FleetMetricUnit::Terabits,
            "Terabits/Second" => FleetMetricUnit::TerabitsSecond,
            "Terabytes" => FleetMetricUnit::Terabytes,
            "Terabytes/Second" => FleetMetricUnit::TerabytesSecond,
            other => FleetMetricUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetMetricUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetMetricUnit::from(s))
    }
}
impl FleetMetricUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetMetricUnit::Bits => "Bits",
            FleetMetricUnit::BitsSecond => "Bits/Second",
            FleetMetricUnit::Bytes => "Bytes",
            FleetMetricUnit::BytesSecond => "Bytes/Second",
            FleetMetricUnit::Count => "Count",
            FleetMetricUnit::CountSecond => "Count/Second",
            FleetMetricUnit::Gigabits => "Gigabits",
            FleetMetricUnit::GigabitsSecond => "Gigabits/Second",
            FleetMetricUnit::Gigabytes => "Gigabytes",
            FleetMetricUnit::GigabytesSecond => "Gigabytes/Second",
            FleetMetricUnit::Kilobits => "Kilobits",
            FleetMetricUnit::KilobitsSecond => "Kilobits/Second",
            FleetMetricUnit::Kilobytes => "Kilobytes",
            FleetMetricUnit::KilobytesSecond => "Kilobytes/Second",
            FleetMetricUnit::Megabits => "Megabits",
            FleetMetricUnit::MegabitsSecond => "Megabits/Second",
            FleetMetricUnit::Megabytes => "Megabytes",
            FleetMetricUnit::MegabytesSecond => "Megabytes/Second",
            FleetMetricUnit::Microseconds => "Microseconds",
            FleetMetricUnit::Milliseconds => "Milliseconds",
            FleetMetricUnit::None => "None",
            FleetMetricUnit::Percent => "Percent",
            FleetMetricUnit::Seconds => "Seconds",
            FleetMetricUnit::Terabits => "Terabits",
            FleetMetricUnit::TerabitsSecond => "Terabits/Second",
            FleetMetricUnit::Terabytes => "Terabytes",
            FleetMetricUnit::TerabytesSecond => "Terabytes/Second",
            FleetMetricUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bits",
            "Bits/Second",
            "Bytes",
            "Bytes/Second",
            "Count",
            "Count/Second",
            "Gigabits",
            "Gigabits/Second",
            "Gigabytes",
            "Gigabytes/Second",
            "Kilobits",
            "Kilobits/Second",
            "Kilobytes",
            "Kilobytes/Second",
            "Megabits",
            "Megabits/Second",
            "Megabytes",
            "Megabytes/Second",
            "Microseconds",
            "Milliseconds",
            "None",
            "Percent",
            "Seconds",
            "Terabits",
            "Terabits/Second",
            "Terabytes",
            "Terabytes/Second",
        ]
    }
}
impl AsRef<str> for FleetMetricUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The type of aggregation queries.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregationType {
    /// <p>The name of the aggregation type.</p>
    pub name: std::option::Option<crate::model::AggregationTypeName>,
    /// <p>A list of the values of aggregation types.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AggregationType {
    /// <p>The name of the aggregation type.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::AggregationTypeName> {
        self.name.as_ref()
    }
    /// <p>A list of the values of aggregation types.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for AggregationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregationType");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`AggregationType`](crate::model::AggregationType)
pub mod aggregation_type {
    /// A builder for [`AggregationType`](crate::model::AggregationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::AggregationTypeName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the aggregation type.</p>
        pub fn name(mut self, input: crate::model::AggregationTypeName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the aggregation type.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::AggregationTypeName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of the values of aggregation types.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of the values of aggregation types.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregationType`](crate::model::AggregationType)
        pub fn build(self) -> crate::model::AggregationType {
            crate::model::AggregationType {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl AggregationType {
    /// Creates a new builder-style object to manufacture [`AggregationType`](crate::model::AggregationType)
    pub fn builder() -> crate::model::aggregation_type::Builder {
        crate::model::aggregation_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregationTypeName {
    #[allow(missing_docs)] // documentation missing in model
    Cardinality,
    #[allow(missing_docs)] // documentation missing in model
    Percentiles,
    #[allow(missing_docs)] // documentation missing in model
    Statistics,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregationTypeName {
    fn from(s: &str) -> Self {
        match s {
            "Cardinality" => AggregationTypeName::Cardinality,
            "Percentiles" => AggregationTypeName::Percentiles,
            "Statistics" => AggregationTypeName::Statistics,
            other => AggregationTypeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregationTypeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregationTypeName::from(s))
    }
}
impl AggregationTypeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregationTypeName::Cardinality => "Cardinality",
            AggregationTypeName::Percentiles => "Percentiles",
            AggregationTypeName::Statistics => "Statistics",
            AggregationTypeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Cardinality", "Percentiles", "Statistics"]
    }
}
impl AsRef<str> for AggregationTypeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Configuration {
    /// <p>True to enable the configuration.</p>
    pub enabled: bool,
}
impl Configuration {
    /// <p>True to enable the configuration.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for Configuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Configuration");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`Configuration`](crate::model::Configuration)
pub mod configuration {
    /// A builder for [`Configuration`](crate::model::Configuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>True to enable the configuration.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True to enable the configuration.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`Configuration`](crate::model::Configuration)
        pub fn build(self) -> crate::model::Configuration {
            crate::model::Configuration {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl Configuration {
    /// Creates a new builder-style object to manufacture [`Configuration`](crate::model::Configuration)
    pub fn builder() -> crate::model::configuration::Builder {
        crate::model::configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventType {
    #[allow(missing_docs)] // documentation missing in model
    CaCertificate,
    #[allow(missing_docs)] // documentation missing in model
    Certificate,
    #[allow(missing_docs)] // documentation missing in model
    Job,
    #[allow(missing_docs)] // documentation missing in model
    JobExecution,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    #[allow(missing_docs)] // documentation missing in model
    Thing,
    #[allow(missing_docs)] // documentation missing in model
    ThingGroup,
    #[allow(missing_docs)] // documentation missing in model
    ThingGroupHierarchy,
    #[allow(missing_docs)] // documentation missing in model
    ThingGroupMembership,
    #[allow(missing_docs)] // documentation missing in model
    ThingType,
    #[allow(missing_docs)] // documentation missing in model
    ThingTypeAssociation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventType {
    fn from(s: &str) -> Self {
        match s {
            "CA_CERTIFICATE" => EventType::CaCertificate,
            "CERTIFICATE" => EventType::Certificate,
            "JOB" => EventType::Job,
            "JOB_EXECUTION" => EventType::JobExecution,
            "POLICY" => EventType::Policy,
            "THING" => EventType::Thing,
            "THING_GROUP" => EventType::ThingGroup,
            "THING_GROUP_HIERARCHY" => EventType::ThingGroupHierarchy,
            "THING_GROUP_MEMBERSHIP" => EventType::ThingGroupMembership,
            "THING_TYPE" => EventType::ThingType,
            "THING_TYPE_ASSOCIATION" => EventType::ThingTypeAssociation,
            other => EventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventType::from(s))
    }
}
impl EventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventType::CaCertificate => "CA_CERTIFICATE",
            EventType::Certificate => "CERTIFICATE",
            EventType::Job => "JOB",
            EventType::JobExecution => "JOB_EXECUTION",
            EventType::Policy => "POLICY",
            EventType::Thing => "THING",
            EventType::ThingGroup => "THING_GROUP",
            EventType::ThingGroupHierarchy => "THING_GROUP_HIERARCHY",
            EventType::ThingGroupMembership => "THING_GROUP_MEMBERSHIP",
            EventType::ThingType => "THING_TYPE",
            EventType::ThingTypeAssociation => "THING_TYPE_ASSOCIATION",
            EventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CA_CERTIFICATE",
            "CERTIFICATE",
            "JOB",
            "JOB_EXECUTION",
            "POLICY",
            "THING",
            "THING_GROUP",
            "THING_GROUP_HIERARCHY",
            "THING_GROUP_MEMBERSHIP",
            "THING_TYPE",
            "THING_TYPE_ASSOCIATION",
        ]
    }
}
impl AsRef<str> for EventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DomainConfigurationStatus::Disabled,
            "ENABLED" => DomainConfigurationStatus::Enabled,
            other => DomainConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainConfigurationStatus::from(s))
    }
}
impl DomainConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainConfigurationStatus::Disabled => "DISABLED",
            DomainConfigurationStatus::Enabled => "ENABLED",
            DomainConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DomainConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that specifies the authorization service for a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizerConfig {
    /// <p>The name of the authorization service for a domain configuration.</p>
    pub default_authorizer_name: std::option::Option<std::string::String>,
    /// <p>A Boolean that specifies whether the domain configuration's authorization service can be overridden.</p>
    pub allow_authorizer_override: std::option::Option<bool>,
}
impl AuthorizerConfig {
    /// <p>The name of the authorization service for a domain configuration.</p>
    pub fn default_authorizer_name(&self) -> std::option::Option<&str> {
        self.default_authorizer_name.as_deref()
    }
    /// <p>A Boolean that specifies whether the domain configuration's authorization service can be overridden.</p>
    pub fn allow_authorizer_override(&self) -> std::option::Option<bool> {
        self.allow_authorizer_override
    }
}
impl std::fmt::Debug for AuthorizerConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizerConfig");
        formatter.field("default_authorizer_name", &self.default_authorizer_name);
        formatter.field("allow_authorizer_override", &self.allow_authorizer_override);
        formatter.finish()
    }
}
/// See [`AuthorizerConfig`](crate::model::AuthorizerConfig)
pub mod authorizer_config {
    /// A builder for [`AuthorizerConfig`](crate::model::AuthorizerConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_authorizer_name: std::option::Option<std::string::String>,
        pub(crate) allow_authorizer_override: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the authorization service for a domain configuration.</p>
        pub fn default_authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_authorizer_name = Some(input.into());
            self
        }
        /// <p>The name of the authorization service for a domain configuration.</p>
        pub fn set_default_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_authorizer_name = input;
            self
        }
        /// <p>A Boolean that specifies whether the domain configuration's authorization service can be overridden.</p>
        pub fn allow_authorizer_override(mut self, input: bool) -> Self {
            self.allow_authorizer_override = Some(input);
            self
        }
        /// <p>A Boolean that specifies whether the domain configuration's authorization service can be overridden.</p>
        pub fn set_allow_authorizer_override(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_authorizer_override = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizerConfig`](crate::model::AuthorizerConfig)
        pub fn build(self) -> crate::model::AuthorizerConfig {
            crate::model::AuthorizerConfig {
                default_authorizer_name: self.default_authorizer_name,
                allow_authorizer_override: self.allow_authorizer_override,
            }
        }
    }
}
impl AuthorizerConfig {
    /// Creates a new builder-style object to manufacture [`AuthorizerConfig`](crate::model::AuthorizerConfig)
    pub fn builder() -> crate::model::authorizer_config::Builder {
        crate::model::authorizer_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DimensionType {
    #[allow(missing_docs)] // documentation missing in model
    TopicFilter,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DimensionType {
    fn from(s: &str) -> Self {
        match s {
            "TOPIC_FILTER" => DimensionType::TopicFilter,
            other => DimensionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DimensionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DimensionType::from(s))
    }
}
impl DimensionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DimensionType::TopicFilter => "TOPIC_FILTER",
            DimensionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TOPIC_FILTER"]
    }
}
impl AsRef<str> for DimensionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomMetricType {
    #[allow(missing_docs)] // documentation missing in model
    IpAddressList,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    NumberList,
    #[allow(missing_docs)] // documentation missing in model
    StringList,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomMetricType {
    fn from(s: &str) -> Self {
        match s {
            "ip-address-list" => CustomMetricType::IpAddressList,
            "number" => CustomMetricType::Number,
            "number-list" => CustomMetricType::NumberList,
            "string-list" => CustomMetricType::StringList,
            other => CustomMetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomMetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomMetricType::from(s))
    }
}
impl CustomMetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomMetricType::IpAddressList => "ip-address-list",
            CustomMetricType::Number => "number",
            CustomMetricType::NumberList => "number-list",
            CustomMetricType::StringList => "string-list",
            CustomMetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ip-address-list", "number", "number-list", "string-list"]
    }
}
impl AsRef<str> for CustomMetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    PendingActivation,
    #[allow(missing_docs)] // documentation missing in model
    PendingTransfer,
    #[allow(missing_docs)] // documentation missing in model
    RegisterInactive,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CertificateStatus::Active,
            "INACTIVE" => CertificateStatus::Inactive,
            "PENDING_ACTIVATION" => CertificateStatus::PendingActivation,
            "PENDING_TRANSFER" => CertificateStatus::PendingTransfer,
            "REGISTER_INACTIVE" => CertificateStatus::RegisterInactive,
            "REVOKED" => CertificateStatus::Revoked,
            other => CertificateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateStatus::from(s))
    }
}
impl CertificateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateStatus::Active => "ACTIVE",
            CertificateStatus::Inactive => "INACTIVE",
            CertificateStatus::PendingActivation => "PENDING_ACTIVATION",
            CertificateStatus::PendingTransfer => "PENDING_TRANSFER",
            CertificateStatus::RegisterInactive => "REGISTER_INACTIVE",
            CertificateStatus::Revoked => "REVOKED",
            CertificateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "INACTIVE",
            "PENDING_ACTIVATION",
            "PENDING_TRANSFER",
            "REGISTER_INACTIVE",
            "REVOKED",
        ]
    }
}
impl AsRef<str> for CertificateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The registration configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistrationConfig {
    /// <p>The template body.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>The ARN of the role.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl RegistrationConfig {
    /// <p>The template body.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>The ARN of the role.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for RegistrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistrationConfig");
        formatter.field("template_body", &self.template_body);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`RegistrationConfig`](crate::model::RegistrationConfig)
pub mod registration_config {
    /// A builder for [`RegistrationConfig`](crate::model::RegistrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The template body.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The template body.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The ARN of the role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistrationConfig`](crate::model::RegistrationConfig)
        pub fn build(self) -> crate::model::RegistrationConfig {
            crate::model::RegistrationConfig {
                template_body: self.template_body,
                role_arn: self.role_arn,
            }
        }
    }
}
impl RegistrationConfig {
    /// Creates a new builder-style object to manufacture [`RegistrationConfig`](crate::model::RegistrationConfig)
    pub fn builder() -> crate::model::registration_config::Builder {
        crate::model::registration_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoRegistrationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disable,
    #[allow(missing_docs)] // documentation missing in model
    Enable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoRegistrationStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE" => AutoRegistrationStatus::Disable,
            "ENABLE" => AutoRegistrationStatus::Enable,
            other => AutoRegistrationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoRegistrationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoRegistrationStatus::from(s))
    }
}
impl AutoRegistrationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoRegistrationStatus::Disable => "DISABLE",
            AutoRegistrationStatus::Enable => "ENABLE",
            AutoRegistrationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE", "ENABLE"]
    }
}
impl AsRef<str> for AutoRegistrationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CaCertificateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CaCertificateStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CaCertificateStatus::Active,
            "INACTIVE" => CaCertificateStatus::Inactive,
            other => CaCertificateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CaCertificateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CaCertificateStatus::from(s))
    }
}
impl CaCertificateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CaCertificateStatus::Active => "ACTIVE",
            CaCertificateStatus::Inactive => "INACTIVE",
            CaCertificateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for CaCertificateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The properties of a billing group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BillingGroupProperties {
    /// <p>The description of the billing group.</p>
    pub billing_group_description: std::option::Option<std::string::String>,
}
impl BillingGroupProperties {
    /// <p>The description of the billing group.</p>
    pub fn billing_group_description(&self) -> std::option::Option<&str> {
        self.billing_group_description.as_deref()
    }
}
impl std::fmt::Debug for BillingGroupProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BillingGroupProperties");
        formatter.field("billing_group_description", &self.billing_group_description);
        formatter.finish()
    }
}
/// See [`BillingGroupProperties`](crate::model::BillingGroupProperties)
pub mod billing_group_properties {
    /// A builder for [`BillingGroupProperties`](crate::model::BillingGroupProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_group_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The description of the billing group.</p>
        pub fn billing_group_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_group_description = Some(input.into());
            self
        }
        /// <p>The description of the billing group.</p>
        pub fn set_billing_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_group_description = input;
            self
        }
        /// Consumes the builder and constructs a [`BillingGroupProperties`](crate::model::BillingGroupProperties)
        pub fn build(self) -> crate::model::BillingGroupProperties {
            crate::model::BillingGroupProperties {
                billing_group_description: self.billing_group_description,
            }
        }
    }
}
impl BillingGroupProperties {
    /// Creates a new builder-style object to manufacture [`BillingGroupProperties`](crate::model::BillingGroupProperties)
    pub fn builder() -> crate::model::billing_group_properties::Builder {
        crate::model::billing_group_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthorizerStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthorizerStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AuthorizerStatus::Active,
            "INACTIVE" => AuthorizerStatus::Inactive,
            other => AuthorizerStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthorizerStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthorizerStatus::from(s))
    }
}
impl AuthorizerStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthorizerStatus::Active => "ACTIVE",
            AuthorizerStatus::Inactive => "INACTIVE",
            AuthorizerStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for AuthorizerStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information that identifies the noncompliant resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceIdentifier {
    /// <p>The ID of the certificate attached to the resource.</p>
    pub device_certificate_id: std::option::Option<std::string::String>,
    /// <p>The ID of the CA certificate used to authorize the certificate.</p>
    pub ca_certificate_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Cognito identity pool.</p>
    pub cognito_identity_pool_id: std::option::Option<std::string::String>,
    /// <p>The client ID.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The version of the policy associated with the resource.</p>
    pub policy_version_identifier: std::option::Option<crate::model::PolicyVersionIdentifier>,
    /// <p>The account with which the resource is associated.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that has overly permissive actions.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the role alias that has overly permissive actions.</p>
    pub role_alias_arn: std::option::Option<std::string::String>,
}
impl ResourceIdentifier {
    /// <p>The ID of the certificate attached to the resource.</p>
    pub fn device_certificate_id(&self) -> std::option::Option<&str> {
        self.device_certificate_id.as_deref()
    }
    /// <p>The ID of the CA certificate used to authorize the certificate.</p>
    pub fn ca_certificate_id(&self) -> std::option::Option<&str> {
        self.ca_certificate_id.as_deref()
    }
    /// <p>The ID of the Amazon Cognito identity pool.</p>
    pub fn cognito_identity_pool_id(&self) -> std::option::Option<&str> {
        self.cognito_identity_pool_id.as_deref()
    }
    /// <p>The client ID.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The version of the policy associated with the resource.</p>
    pub fn policy_version_identifier(
        &self,
    ) -> std::option::Option<&crate::model::PolicyVersionIdentifier> {
        self.policy_version_identifier.as_ref()
    }
    /// <p>The account with which the resource is associated.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
    /// <p>The ARN of the IAM role that has overly permissive actions.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The ARN of the role alias that has overly permissive actions.</p>
    pub fn role_alias_arn(&self) -> std::option::Option<&str> {
        self.role_alias_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceIdentifier");
        formatter.field("device_certificate_id", &self.device_certificate_id);
        formatter.field("ca_certificate_id", &self.ca_certificate_id);
        formatter.field("cognito_identity_pool_id", &self.cognito_identity_pool_id);
        formatter.field("client_id", &self.client_id);
        formatter.field("policy_version_identifier", &self.policy_version_identifier);
        formatter.field("account", &self.account);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("role_alias_arn", &self.role_alias_arn);
        formatter.finish()
    }
}
/// See [`ResourceIdentifier`](crate::model::ResourceIdentifier)
pub mod resource_identifier {
    /// A builder for [`ResourceIdentifier`](crate::model::ResourceIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_certificate_id: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_id: std::option::Option<std::string::String>,
        pub(crate) cognito_identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) policy_version_identifier:
            std::option::Option<crate::model::PolicyVersionIdentifier>,
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) role_alias_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the certificate attached to the resource.</p>
        pub fn device_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate attached to the resource.</p>
        pub fn set_device_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_certificate_id = input;
            self
        }
        /// <p>The ID of the CA certificate used to authorize the certificate.</p>
        pub fn ca_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the CA certificate used to authorize the certificate.</p>
        pub fn set_ca_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_id = input;
            self
        }
        /// <p>The ID of the Amazon Cognito identity pool.</p>
        pub fn cognito_identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cognito_identity_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito identity pool.</p>
        pub fn set_cognito_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cognito_identity_pool_id = input;
            self
        }
        /// <p>The client ID.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The version of the policy associated with the resource.</p>
        pub fn policy_version_identifier(
            mut self,
            input: crate::model::PolicyVersionIdentifier,
        ) -> Self {
            self.policy_version_identifier = Some(input);
            self
        }
        /// <p>The version of the policy associated with the resource.</p>
        pub fn set_policy_version_identifier(
            mut self,
            input: std::option::Option<crate::model::PolicyVersionIdentifier>,
        ) -> Self {
            self.policy_version_identifier = input;
            self
        }
        /// <p>The account with which the resource is associated.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The account with which the resource is associated.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>The ARN of the IAM role that has overly permissive actions.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that has overly permissive actions.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The ARN of the role alias that has overly permissive actions.</p>
        pub fn role_alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_alias_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role alias that has overly permissive actions.</p>
        pub fn set_role_alias_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.role_alias_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceIdentifier`](crate::model::ResourceIdentifier)
        pub fn build(self) -> crate::model::ResourceIdentifier {
            crate::model::ResourceIdentifier {
                device_certificate_id: self.device_certificate_id,
                ca_certificate_id: self.ca_certificate_id,
                cognito_identity_pool_id: self.cognito_identity_pool_id,
                client_id: self.client_id,
                policy_version_identifier: self.policy_version_identifier,
                account: self.account,
                iam_role_arn: self.iam_role_arn,
                role_alias_arn: self.role_alias_arn,
            }
        }
    }
}
impl ResourceIdentifier {
    /// Creates a new builder-style object to manufacture [`ResourceIdentifier`](crate::model::ResourceIdentifier)
    pub fn builder() -> crate::model::resource_identifier::Builder {
        crate::model::resource_identifier::Builder::default()
    }
}

/// <p>Information about the version of the policy associated with the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyVersionIdentifier {
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The ID of the version of the policy associated with the resource.</p>
    pub policy_version_id: std::option::Option<std::string::String>,
}
impl PolicyVersionIdentifier {
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The ID of the version of the policy associated with the resource.</p>
    pub fn policy_version_id(&self) -> std::option::Option<&str> {
        self.policy_version_id.as_deref()
    }
}
impl std::fmt::Debug for PolicyVersionIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyVersionIdentifier");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_version_id", &self.policy_version_id);
        formatter.finish()
    }
}
/// See [`PolicyVersionIdentifier`](crate::model::PolicyVersionIdentifier)
pub mod policy_version_identifier {
    /// A builder for [`PolicyVersionIdentifier`](crate::model::PolicyVersionIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The ID of the version of the policy associated with the resource.</p>
        pub fn policy_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_version_id = Some(input.into());
            self
        }
        /// <p>The ID of the version of the policy associated with the resource.</p>
        pub fn set_policy_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyVersionIdentifier`](crate::model::PolicyVersionIdentifier)
        pub fn build(self) -> crate::model::PolicyVersionIdentifier {
            crate::model::PolicyVersionIdentifier {
                policy_name: self.policy_name,
                policy_version_id: self.policy_version_id,
            }
        }
    }
}
impl PolicyVersionIdentifier {
    /// Creates a new builder-style object to manufacture [`PolicyVersionIdentifier`](crate::model::PolicyVersionIdentifier)
    pub fn builder() -> crate::model::policy_version_identifier::Builder {
        crate::model::policy_version_identifier::Builder::default()
    }
}

/// <p>Which audit checks are enabled and disabled for this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditCheckConfiguration {
    /// <p>True if this audit check is enabled for this account.</p>
    pub enabled: bool,
}
impl AuditCheckConfiguration {
    /// <p>True if this audit check is enabled for this account.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for AuditCheckConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditCheckConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`AuditCheckConfiguration`](crate::model::AuditCheckConfiguration)
pub mod audit_check_configuration {
    /// A builder for [`AuditCheckConfiguration`](crate::model::AuditCheckConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>True if this audit check is enabled for this account.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if this audit check is enabled for this account.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditCheckConfiguration`](crate::model::AuditCheckConfiguration)
        pub fn build(self) -> crate::model::AuditCheckConfiguration {
            crate::model::AuditCheckConfiguration {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl AuditCheckConfiguration {
    /// Creates a new builder-style object to manufacture [`AuditCheckConfiguration`](crate::model::AuditCheckConfiguration)
    pub fn builder() -> crate::model::audit_check_configuration::Builder {
        crate::model::audit_check_configuration::Builder::default()
    }
}

/// <p>Information about the targets to which audit notifications are sent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditNotificationTarget {
    /// <p>The ARN of the target (SNS topic) to which audit notifications are sent.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants permission to send notifications to the target.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>True if notifications to the target are enabled.</p>
    pub enabled: bool,
}
impl AuditNotificationTarget {
    /// <p>The ARN of the target (SNS topic) to which audit notifications are sent.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The ARN of the role that grants permission to send notifications to the target.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>True if notifications to the target are enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for AuditNotificationTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditNotificationTarget");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`AuditNotificationTarget`](crate::model::AuditNotificationTarget)
pub mod audit_notification_target {
    /// A builder for [`AuditNotificationTarget`](crate::model::AuditNotificationTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the target (SNS topic) to which audit notifications are sent.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the target (SNS topic) to which audit notifications are sent.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The ARN of the role that grants permission to send notifications to the target.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to send notifications to the target.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>True if notifications to the target are enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if notifications to the target are enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditNotificationTarget`](crate::model::AuditNotificationTarget)
        pub fn build(self) -> crate::model::AuditNotificationTarget {
            crate::model::AuditNotificationTarget {
                target_arn: self.target_arn,
                role_arn: self.role_arn,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl AuditNotificationTarget {
    /// Creates a new builder-style object to manufacture [`AuditNotificationTarget`](crate::model::AuditNotificationTarget)
    pub fn builder() -> crate::model::audit_notification_target::Builder {
        crate::model::audit_notification_target::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditNotificationType {
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditNotificationType {
    fn from(s: &str) -> Self {
        match s {
            "SNS" => AuditNotificationType::Sns,
            other => AuditNotificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditNotificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditNotificationType::from(s))
    }
}
impl AuditNotificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditNotificationType::Sns => "SNS",
            AuditNotificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SNS"]
    }
}
impl AsRef<str> for AuditNotificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the TLS context to use for the test authorizer request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TlsContext {
    /// <p>The value of the <code>serverName</code> key in a TLS authorization request.</p>
    pub server_name: std::option::Option<std::string::String>,
}
impl TlsContext {
    /// <p>The value of the <code>serverName</code> key in a TLS authorization request.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
}
impl std::fmt::Debug for TlsContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TlsContext");
        formatter.field("server_name", &self.server_name);
        formatter.finish()
    }
}
/// See [`TlsContext`](crate::model::TlsContext)
pub mod tls_context {
    /// A builder for [`TlsContext`](crate::model::TlsContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of the <code>serverName</code> key in a TLS authorization request.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The value of the <code>serverName</code> key in a TLS authorization request.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TlsContext`](crate::model::TlsContext)
        pub fn build(self) -> crate::model::TlsContext {
            crate::model::TlsContext {
                server_name: self.server_name,
            }
        }
    }
}
impl TlsContext {
    /// Creates a new builder-style object to manufacture [`TlsContext`](crate::model::TlsContext)
    pub fn builder() -> crate::model::tls_context::Builder {
        crate::model::tls_context::Builder::default()
    }
}

/// <p>Specifies the MQTT context to use for the test authorizer request</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MqttContext {
    /// <p>The value of the <code>username</code> key in an MQTT authorization request.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The value of the <code>password</code> key in an MQTT authorization request.</p>
    pub password: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The value of the <code>clientId</code> key in an MQTT authorization request.</p>
    pub client_id: std::option::Option<std::string::String>,
}
impl MqttContext {
    /// <p>The value of the <code>username</code> key in an MQTT authorization request.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The value of the <code>password</code> key in an MQTT authorization request.</p>
    pub fn password(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.password.as_ref()
    }
    /// <p>The value of the <code>clientId</code> key in an MQTT authorization request.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
}
impl std::fmt::Debug for MqttContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MqttContext");
        formatter.field("username", &self.username);
        formatter.field("password", &self.password);
        formatter.field("client_id", &self.client_id);
        formatter.finish()
    }
}
/// See [`MqttContext`](crate::model::MqttContext)
pub mod mqtt_context {
    /// A builder for [`MqttContext`](crate::model::MqttContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of the <code>username</code> key in an MQTT authorization request.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The value of the <code>username</code> key in an MQTT authorization request.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The value of the <code>password</code> key in an MQTT authorization request.</p>
        pub fn password(mut self, input: aws_smithy_types::Blob) -> Self {
            self.password = Some(input);
            self
        }
        /// <p>The value of the <code>password</code> key in an MQTT authorization request.</p>
        pub fn set_password(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.password = input;
            self
        }
        /// <p>The value of the <code>clientId</code> key in an MQTT authorization request.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The value of the <code>clientId</code> key in an MQTT authorization request.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MqttContext`](crate::model::MqttContext)
        pub fn build(self) -> crate::model::MqttContext {
            crate::model::MqttContext {
                username: self.username,
                password: self.password,
                client_id: self.client_id,
            }
        }
    }
}
impl MqttContext {
    /// Creates a new builder-style object to manufacture [`MqttContext`](crate::model::MqttContext)
    pub fn builder() -> crate::model::mqtt_context::Builder {
        crate::model::mqtt_context::Builder::default()
    }
}

/// <p>Specifies the HTTP context to use for the test authorizer request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpContext {
    /// <p>The header keys and values in an HTTP authorization request.</p>
    pub headers:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The query string keys and values in an HTTP authorization request.</p>
    pub query_string: std::option::Option<std::string::String>,
}
impl HttpContext {
    /// <p>The header keys and values in an HTTP authorization request.</p>
    pub fn headers(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.headers.as_ref()
    }
    /// <p>The query string keys and values in an HTTP authorization request.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
}
impl std::fmt::Debug for HttpContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpContext");
        formatter.field("headers", &self.headers);
        formatter.field("query_string", &self.query_string);
        formatter.finish()
    }
}
/// See [`HttpContext`](crate::model::HttpContext)
pub mod http_context {
    /// A builder for [`HttpContext`](crate::model::HttpContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) headers: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) query_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>The header keys and values in an HTTP authorization request.</p>
        pub fn headers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.headers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.headers = Some(hash_map);
            self
        }
        /// <p>The header keys and values in an HTTP authorization request.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.headers = input;
            self
        }
        /// <p>The query string keys and values in an HTTP authorization request.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The query string keys and values in an HTTP authorization request.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpContext`](crate::model::HttpContext)
        pub fn build(self) -> crate::model::HttpContext {
            crate::model::HttpContext {
                headers: self.headers,
                query_string: self.query_string,
            }
        }
    }
}
impl HttpContext {
    /// Creates a new builder-style object to manufacture [`HttpContext`](crate::model::HttpContext)
    pub fn builder() -> crate::model::http_context::Builder {
        crate::model::http_context::Builder::default()
    }
}

/// <p>The authorizer result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthResult {
    /// <p>Authorization information.</p>
    pub auth_info: std::option::Option<crate::model::AuthInfo>,
    /// <p>The policies and statements that allowed the specified action.</p>
    pub allowed: std::option::Option<crate::model::Allowed>,
    /// <p>The policies and statements that denied the specified action.</p>
    pub denied: std::option::Option<crate::model::Denied>,
    /// <p>The final authorization decision of this scenario. Multiple statements are taken into
    /// account when determining the authorization decision. An explicit deny statement can
    /// override multiple allow statements.</p>
    pub auth_decision: std::option::Option<crate::model::AuthDecision>,
    /// <p>Contains any missing context values found while evaluating policy.</p>
    pub missing_context_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AuthResult {
    /// <p>Authorization information.</p>
    pub fn auth_info(&self) -> std::option::Option<&crate::model::AuthInfo> {
        self.auth_info.as_ref()
    }
    /// <p>The policies and statements that allowed the specified action.</p>
    pub fn allowed(&self) -> std::option::Option<&crate::model::Allowed> {
        self.allowed.as_ref()
    }
    /// <p>The policies and statements that denied the specified action.</p>
    pub fn denied(&self) -> std::option::Option<&crate::model::Denied> {
        self.denied.as_ref()
    }
    /// <p>The final authorization decision of this scenario. Multiple statements are taken into
    /// account when determining the authorization decision. An explicit deny statement can
    /// override multiple allow statements.</p>
    pub fn auth_decision(&self) -> std::option::Option<&crate::model::AuthDecision> {
        self.auth_decision.as_ref()
    }
    /// <p>Contains any missing context values found while evaluating policy.</p>
    pub fn missing_context_values(&self) -> std::option::Option<&[std::string::String]> {
        self.missing_context_values.as_deref()
    }
}
impl std::fmt::Debug for AuthResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthResult");
        formatter.field("auth_info", &self.auth_info);
        formatter.field("allowed", &self.allowed);
        formatter.field("denied", &self.denied);
        formatter.field("auth_decision", &self.auth_decision);
        formatter.field("missing_context_values", &self.missing_context_values);
        formatter.finish()
    }
}
/// See [`AuthResult`](crate::model::AuthResult)
pub mod auth_result {
    /// A builder for [`AuthResult`](crate::model::AuthResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_info: std::option::Option<crate::model::AuthInfo>,
        pub(crate) allowed: std::option::Option<crate::model::Allowed>,
        pub(crate) denied: std::option::Option<crate::model::Denied>,
        pub(crate) auth_decision: std::option::Option<crate::model::AuthDecision>,
        pub(crate) missing_context_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Authorization information.</p>
        pub fn auth_info(mut self, input: crate::model::AuthInfo) -> Self {
            self.auth_info = Some(input);
            self
        }
        /// <p>Authorization information.</p>
        pub fn set_auth_info(mut self, input: std::option::Option<crate::model::AuthInfo>) -> Self {
            self.auth_info = input;
            self
        }
        /// <p>The policies and statements that allowed the specified action.</p>
        pub fn allowed(mut self, input: crate::model::Allowed) -> Self {
            self.allowed = Some(input);
            self
        }
        /// <p>The policies and statements that allowed the specified action.</p>
        pub fn set_allowed(mut self, input: std::option::Option<crate::model::Allowed>) -> Self {
            self.allowed = input;
            self
        }
        /// <p>The policies and statements that denied the specified action.</p>
        pub fn denied(mut self, input: crate::model::Denied) -> Self {
            self.denied = Some(input);
            self
        }
        /// <p>The policies and statements that denied the specified action.</p>
        pub fn set_denied(mut self, input: std::option::Option<crate::model::Denied>) -> Self {
            self.denied = input;
            self
        }
        /// <p>The final authorization decision of this scenario. Multiple statements are taken into
        /// account when determining the authorization decision. An explicit deny statement can
        /// override multiple allow statements.</p>
        pub fn auth_decision(mut self, input: crate::model::AuthDecision) -> Self {
            self.auth_decision = Some(input);
            self
        }
        /// <p>The final authorization decision of this scenario. Multiple statements are taken into
        /// account when determining the authorization decision. An explicit deny statement can
        /// override multiple allow statements.</p>
        pub fn set_auth_decision(
            mut self,
            input: std::option::Option<crate::model::AuthDecision>,
        ) -> Self {
            self.auth_decision = input;
            self
        }
        /// Appends an item to `missing_context_values`.
        ///
        /// To override the contents of this collection use [`set_missing_context_values`](Self::set_missing_context_values).
        ///
        /// <p>Contains any missing context values found while evaluating policy.</p>
        pub fn missing_context_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.missing_context_values.unwrap_or_default();
            v.push(input.into());
            self.missing_context_values = Some(v);
            self
        }
        /// <p>Contains any missing context values found while evaluating policy.</p>
        pub fn set_missing_context_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.missing_context_values = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthResult`](crate::model::AuthResult)
        pub fn build(self) -> crate::model::AuthResult {
            crate::model::AuthResult {
                auth_info: self.auth_info,
                allowed: self.allowed,
                denied: self.denied,
                auth_decision: self.auth_decision,
                missing_context_values: self.missing_context_values,
            }
        }
    }
}
impl AuthResult {
    /// Creates a new builder-style object to manufacture [`AuthResult`](crate::model::AuthResult)
    pub fn builder() -> crate::model::auth_result::Builder {
        crate::model::auth_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthDecision {
    #[allow(missing_docs)] // documentation missing in model
    Allowed,
    #[allow(missing_docs)] // documentation missing in model
    ExplicitDeny,
    #[allow(missing_docs)] // documentation missing in model
    ImplicitDeny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthDecision {
    fn from(s: &str) -> Self {
        match s {
            "ALLOWED" => AuthDecision::Allowed,
            "EXPLICIT_DENY" => AuthDecision::ExplicitDeny,
            "IMPLICIT_DENY" => AuthDecision::ImplicitDeny,
            other => AuthDecision::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthDecision {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthDecision::from(s))
    }
}
impl AuthDecision {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthDecision::Allowed => "ALLOWED",
            AuthDecision::ExplicitDeny => "EXPLICIT_DENY",
            AuthDecision::ImplicitDeny => "IMPLICIT_DENY",
            AuthDecision::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOWED", "EXPLICIT_DENY", "IMPLICIT_DENY"]
    }
}
impl AsRef<str> for AuthDecision {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information that denied the authorization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Denied {
    /// <p>Information that implicitly denies the authorization. When a policy doesn't
    /// explicitly deny or allow an action on a resource it is considered an implicit
    /// deny.</p>
    pub implicit_deny: std::option::Option<crate::model::ImplicitDeny>,
    /// <p>Information that explicitly denies the authorization. </p>
    pub explicit_deny: std::option::Option<crate::model::ExplicitDeny>,
}
impl Denied {
    /// <p>Information that implicitly denies the authorization. When a policy doesn't
    /// explicitly deny or allow an action on a resource it is considered an implicit
    /// deny.</p>
    pub fn implicit_deny(&self) -> std::option::Option<&crate::model::ImplicitDeny> {
        self.implicit_deny.as_ref()
    }
    /// <p>Information that explicitly denies the authorization. </p>
    pub fn explicit_deny(&self) -> std::option::Option<&crate::model::ExplicitDeny> {
        self.explicit_deny.as_ref()
    }
}
impl std::fmt::Debug for Denied {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Denied");
        formatter.field("implicit_deny", &self.implicit_deny);
        formatter.field("explicit_deny", &self.explicit_deny);
        formatter.finish()
    }
}
/// See [`Denied`](crate::model::Denied)
pub mod denied {
    /// A builder for [`Denied`](crate::model::Denied)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) implicit_deny: std::option::Option<crate::model::ImplicitDeny>,
        pub(crate) explicit_deny: std::option::Option<crate::model::ExplicitDeny>,
    }
    impl Builder {
        /// <p>Information that implicitly denies the authorization. When a policy doesn't
        /// explicitly deny or allow an action on a resource it is considered an implicit
        /// deny.</p>
        pub fn implicit_deny(mut self, input: crate::model::ImplicitDeny) -> Self {
            self.implicit_deny = Some(input);
            self
        }
        /// <p>Information that implicitly denies the authorization. When a policy doesn't
        /// explicitly deny or allow an action on a resource it is considered an implicit
        /// deny.</p>
        pub fn set_implicit_deny(
            mut self,
            input: std::option::Option<crate::model::ImplicitDeny>,
        ) -> Self {
            self.implicit_deny = input;
            self
        }
        /// <p>Information that explicitly denies the authorization. </p>
        pub fn explicit_deny(mut self, input: crate::model::ExplicitDeny) -> Self {
            self.explicit_deny = Some(input);
            self
        }
        /// <p>Information that explicitly denies the authorization. </p>
        pub fn set_explicit_deny(
            mut self,
            input: std::option::Option<crate::model::ExplicitDeny>,
        ) -> Self {
            self.explicit_deny = input;
            self
        }
        /// Consumes the builder and constructs a [`Denied`](crate::model::Denied)
        pub fn build(self) -> crate::model::Denied {
            crate::model::Denied {
                implicit_deny: self.implicit_deny,
                explicit_deny: self.explicit_deny,
            }
        }
    }
}
impl Denied {
    /// Creates a new builder-style object to manufacture [`Denied`](crate::model::Denied)
    pub fn builder() -> crate::model::denied::Builder {
        crate::model::denied::Builder::default()
    }
}

/// <p>Information that explicitly denies authorization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExplicitDeny {
    /// <p>The policies that denied the authorization.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
}
impl ExplicitDeny {
    /// <p>The policies that denied the authorization.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::Policy]> {
        self.policies.as_deref()
    }
}
impl std::fmt::Debug for ExplicitDeny {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExplicitDeny");
        formatter.field("policies", &self.policies);
        formatter.finish()
    }
}
/// See [`ExplicitDeny`](crate::model::ExplicitDeny)
pub mod explicit_deny {
    /// A builder for [`ExplicitDeny`](crate::model::ExplicitDeny)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>The policies that denied the authorization.</p>
        pub fn policies(mut self, input: impl Into<crate::model::Policy>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>The policies that denied the authorization.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// Consumes the builder and constructs a [`ExplicitDeny`](crate::model::ExplicitDeny)
        pub fn build(self) -> crate::model::ExplicitDeny {
            crate::model::ExplicitDeny {
                policies: self.policies,
            }
        }
    }
}
impl ExplicitDeny {
    /// Creates a new builder-style object to manufacture [`ExplicitDeny`](crate::model::ExplicitDeny)
    pub fn builder() -> crate::model::explicit_deny::Builder {
        crate::model::explicit_deny::Builder::default()
    }
}

/// <p>Describes an IoT policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Policy {
    /// <p>The policy name.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy ARN.</p>
    pub policy_arn: std::option::Option<std::string::String>,
}
impl Policy {
    /// <p>The policy name.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy ARN.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
}
impl std::fmt::Debug for Policy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Policy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.finish()
    }
}
/// See [`Policy`](crate::model::Policy)
pub mod policy {
    /// A builder for [`Policy`](crate::model::Policy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy ARN.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The policy ARN.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Policy`](crate::model::Policy)
        pub fn build(self) -> crate::model::Policy {
            crate::model::Policy {
                policy_name: self.policy_name,
                policy_arn: self.policy_arn,
            }
        }
    }
}
impl Policy {
    /// Creates a new builder-style object to manufacture [`Policy`](crate::model::Policy)
    pub fn builder() -> crate::model::policy::Builder {
        crate::model::policy::Builder::default()
    }
}

/// <p>Information that implicitly denies authorization. When policy doesn't explicitly deny
/// or allow an action on a resource it is considered an implicit deny.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImplicitDeny {
    /// <p>Policies that don't contain a matching allow or deny statement for the specified
    /// action on the specified resource. </p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
}
impl ImplicitDeny {
    /// <p>Policies that don't contain a matching allow or deny statement for the specified
    /// action on the specified resource. </p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::Policy]> {
        self.policies.as_deref()
    }
}
impl std::fmt::Debug for ImplicitDeny {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImplicitDeny");
        formatter.field("policies", &self.policies);
        formatter.finish()
    }
}
/// See [`ImplicitDeny`](crate::model::ImplicitDeny)
pub mod implicit_deny {
    /// A builder for [`ImplicitDeny`](crate::model::ImplicitDeny)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>Policies that don't contain a matching allow or deny statement for the specified
        /// action on the specified resource. </p>
        pub fn policies(mut self, input: impl Into<crate::model::Policy>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>Policies that don't contain a matching allow or deny statement for the specified
        /// action on the specified resource. </p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// Consumes the builder and constructs a [`ImplicitDeny`](crate::model::ImplicitDeny)
        pub fn build(self) -> crate::model::ImplicitDeny {
            crate::model::ImplicitDeny {
                policies: self.policies,
            }
        }
    }
}
impl ImplicitDeny {
    /// Creates a new builder-style object to manufacture [`ImplicitDeny`](crate::model::ImplicitDeny)
    pub fn builder() -> crate::model::implicit_deny::Builder {
        crate::model::implicit_deny::Builder::default()
    }
}

/// <p>Contains information that allowed the authorization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Allowed {
    /// <p>A list of policies that allowed the authentication.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
}
impl Allowed {
    /// <p>A list of policies that allowed the authentication.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::Policy]> {
        self.policies.as_deref()
    }
}
impl std::fmt::Debug for Allowed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Allowed");
        formatter.field("policies", &self.policies);
        formatter.finish()
    }
}
/// See [`Allowed`](crate::model::Allowed)
pub mod allowed {
    /// A builder for [`Allowed`](crate::model::Allowed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>A list of policies that allowed the authentication.</p>
        pub fn policies(mut self, input: impl Into<crate::model::Policy>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>A list of policies that allowed the authentication.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// Consumes the builder and constructs a [`Allowed`](crate::model::Allowed)
        pub fn build(self) -> crate::model::Allowed {
            crate::model::Allowed {
                policies: self.policies,
            }
        }
    }
}
impl Allowed {
    /// Creates a new builder-style object to manufacture [`Allowed`](crate::model::Allowed)
    pub fn builder() -> crate::model::allowed::Builder {
        crate::model::allowed::Builder::default()
    }
}

/// <p>A collection of authorization information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthInfo {
    /// <p>The type of action for which the principal is being authorized.</p>
    pub action_type: std::option::Option<crate::model::ActionType>,
    /// <p>The resources for which the principal is being authorized to perform the specified
    /// action.</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AuthInfo {
    /// <p>The type of action for which the principal is being authorized.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::ActionType> {
        self.action_type.as_ref()
    }
    /// <p>The resources for which the principal is being authorized to perform the specified
    /// action.</p>
    pub fn resources(&self) -> std::option::Option<&[std::string::String]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for AuthInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthInfo");
        formatter.field("action_type", &self.action_type);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`AuthInfo`](crate::model::AuthInfo)
pub mod auth_info {
    /// A builder for [`AuthInfo`](crate::model::AuthInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of action for which the principal is being authorized.</p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of action for which the principal is being authorized.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>The resources for which the principal is being authorized to perform the specified
        /// action.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>The resources for which the principal is being authorized to perform the specified
        /// action.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthInfo`](crate::model::AuthInfo)
        pub fn build(self) -> crate::model::AuthInfo {
            crate::model::AuthInfo {
                action_type: self.action_type,
                resources: self.resources,
            }
        }
    }
}
impl AuthInfo {
    /// Creates a new builder-style object to manufacture [`AuthInfo`](crate::model::AuthInfo)
    pub fn builder() -> crate::model::auth_info::Builder {
        crate::model::auth_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionType {
    #[allow(missing_docs)] // documentation missing in model
    Connect,
    #[allow(missing_docs)] // documentation missing in model
    Publish,
    #[allow(missing_docs)] // documentation missing in model
    Receive,
    #[allow(missing_docs)] // documentation missing in model
    Subscribe,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionType {
    fn from(s: &str) -> Self {
        match s {
            "CONNECT" => ActionType::Connect,
            "PUBLISH" => ActionType::Publish,
            "RECEIVE" => ActionType::Receive,
            "SUBSCRIBE" => ActionType::Subscribe,
            other => ActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionType::from(s))
    }
}
impl ActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionType::Connect => "CONNECT",
            ActionType::Publish => "PUBLISH",
            ActionType::Receive => "RECEIVE",
            ActionType::Subscribe => "SUBSCRIBE",
            ActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECT", "PUBLISH", "RECEIVE", "SUBSCRIBE"]
    }
}
impl AsRef<str> for ActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of key/value pairs that are used to manage the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag's key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag's key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag's key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag's key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>
/// Specifies the time period of which violation events occurred between.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViolationEventOccurrenceRange {
    /// <p>
    /// The start date and time of a time period in which violation events occurred.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The end date and time of a time period in which violation events occurred.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl ViolationEventOccurrenceRange {
    /// <p>
    /// The start date and time of a time period in which violation events occurred.
    /// </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>
    /// The end date and time of a time period in which violation events occurred.
    /// </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for ViolationEventOccurrenceRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViolationEventOccurrenceRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`ViolationEventOccurrenceRange`](crate::model::ViolationEventOccurrenceRange)
pub mod violation_event_occurrence_range {
    /// A builder for [`ViolationEventOccurrenceRange`](crate::model::ViolationEventOccurrenceRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>
        /// The start date and time of a time period in which violation events occurred.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>
        /// The start date and time of a time period in which violation events occurred.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>
        /// The end date and time of a time period in which violation events occurred.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>
        /// The end date and time of a time period in which violation events occurred.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ViolationEventOccurrenceRange`](crate::model::ViolationEventOccurrenceRange)
        pub fn build(self) -> crate::model::ViolationEventOccurrenceRange {
            crate::model::ViolationEventOccurrenceRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl ViolationEventOccurrenceRange {
    /// Creates a new builder-style object to manufacture [`ViolationEventOccurrenceRange`](crate::model::ViolationEventOccurrenceRange)
    pub fn builder() -> crate::model::violation_event_occurrence_range::Builder {
        crate::model::violation_event_occurrence_range::Builder::default()
    }
}

/// <p>
/// The target of a mitigation action task.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectMitigationActionsTaskTarget {
    /// <p>
    /// The unique identifiers of the violations.
    /// </p>
    pub violation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// The name of the security profile.
    /// </p>
    pub security_profile_name: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the behavior.
    /// </p>
    pub behavior_name: std::option::Option<std::string::String>,
}
impl DetectMitigationActionsTaskTarget {
    /// <p>
    /// The unique identifiers of the violations.
    /// </p>
    pub fn violation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.violation_ids.as_deref()
    }
    /// <p>
    /// The name of the security profile.
    /// </p>
    pub fn security_profile_name(&self) -> std::option::Option<&str> {
        self.security_profile_name.as_deref()
    }
    /// <p>
    /// The name of the behavior.
    /// </p>
    pub fn behavior_name(&self) -> std::option::Option<&str> {
        self.behavior_name.as_deref()
    }
}
impl std::fmt::Debug for DetectMitigationActionsTaskTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectMitigationActionsTaskTarget");
        formatter.field("violation_ids", &self.violation_ids);
        formatter.field("security_profile_name", &self.security_profile_name);
        formatter.field("behavior_name", &self.behavior_name);
        formatter.finish()
    }
}
/// See [`DetectMitigationActionsTaskTarget`](crate::model::DetectMitigationActionsTaskTarget)
pub mod detect_mitigation_actions_task_target {
    /// A builder for [`DetectMitigationActionsTaskTarget`](crate::model::DetectMitigationActionsTaskTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) behavior_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `violation_ids`.
        ///
        /// To override the contents of this collection use [`set_violation_ids`](Self::set_violation_ids).
        ///
        /// <p>
        /// The unique identifiers of the violations.
        /// </p>
        pub fn violation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.violation_ids.unwrap_or_default();
            v.push(input.into());
            self.violation_ids = Some(v);
            self
        }
        /// <p>
        /// The unique identifiers of the violations.
        /// </p>
        pub fn set_violation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.violation_ids = input;
            self
        }
        /// <p>
        /// The name of the security profile.
        /// </p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the security profile.
        /// </p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>
        /// The name of the behavior.
        /// </p>
        pub fn behavior_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.behavior_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the behavior.
        /// </p>
        pub fn set_behavior_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.behavior_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectMitigationActionsTaskTarget`](crate::model::DetectMitigationActionsTaskTarget)
        pub fn build(self) -> crate::model::DetectMitigationActionsTaskTarget {
            crate::model::DetectMitigationActionsTaskTarget {
                violation_ids: self.violation_ids,
                security_profile_name: self.security_profile_name,
                behavior_name: self.behavior_name,
            }
        }
    }
}
impl DetectMitigationActionsTaskTarget {
    /// Creates a new builder-style object to manufacture [`DetectMitigationActionsTaskTarget`](crate::model::DetectMitigationActionsTaskTarget)
    pub fn builder() -> crate::model::detect_mitigation_actions_task_target::Builder {
        crate::model::detect_mitigation_actions_task_target::Builder::default()
    }
}

/// <p>Used in MitigationActionParams, this information identifies the target findings to which the mitigation actions are applied. Only one entry appears.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditMitigationActionsTaskTarget {
    /// <p>If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.</p>
    pub audit_task_id: std::option::Option<std::string::String>,
    /// <p>If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.</p>
    pub finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.</p>
    pub audit_check_to_reason_code_filter: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl AuditMitigationActionsTaskTarget {
    /// <p>If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.</p>
    pub fn audit_task_id(&self) -> std::option::Option<&str> {
        self.audit_task_id.as_deref()
    }
    /// <p>If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.</p>
    pub fn finding_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_ids.as_deref()
    }
    /// <p>Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.</p>
    pub fn audit_check_to_reason_code_filter(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    > {
        self.audit_check_to_reason_code_filter.as_ref()
    }
}
impl std::fmt::Debug for AuditMitigationActionsTaskTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditMitigationActionsTaskTarget");
        formatter.field("audit_task_id", &self.audit_task_id);
        formatter.field("finding_ids", &self.finding_ids);
        formatter.field(
            "audit_check_to_reason_code_filter",
            &self.audit_check_to_reason_code_filter,
        );
        formatter.finish()
    }
}
/// See [`AuditMitigationActionsTaskTarget`](crate::model::AuditMitigationActionsTaskTarget)
pub mod audit_mitigation_actions_task_target {
    /// A builder for [`AuditMitigationActionsTaskTarget`](crate::model::AuditMitigationActionsTaskTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audit_task_id: std::option::Option<std::string::String>,
        pub(crate) finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) audit_check_to_reason_code_filter: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.</p>
        pub fn audit_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.audit_task_id = Some(input.into());
            self
        }
        /// <p>If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.</p>
        pub fn set_audit_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audit_task_id = input;
            self
        }
        /// Appends an item to `finding_ids`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.</p>
        pub fn finding_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_ids.unwrap_or_default();
            v.push(input.into());
            self.finding_ids = Some(v);
            self
        }
        /// <p>If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_ids = input;
            self
        }
        /// Adds a key-value pair to `audit_check_to_reason_code_filter`.
        ///
        /// To override the contents of this collection use [`set_audit_check_to_reason_code_filter`](Self::set_audit_check_to_reason_code_filter).
        ///
        /// <p>Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.</p>
        pub fn audit_check_to_reason_code_filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.audit_check_to_reason_code_filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.audit_check_to_reason_code_filter = Some(hash_map);
            self
        }
        /// <p>Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.</p>
        pub fn set_audit_check_to_reason_code_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.audit_check_to_reason_code_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditMitigationActionsTaskTarget`](crate::model::AuditMitigationActionsTaskTarget)
        pub fn build(self) -> crate::model::AuditMitigationActionsTaskTarget {
            crate::model::AuditMitigationActionsTaskTarget {
                audit_task_id: self.audit_task_id,
                finding_ids: self.finding_ids,
                audit_check_to_reason_code_filter: self.audit_check_to_reason_code_filter,
            }
        }
    }
}
impl AuditMitigationActionsTaskTarget {
    /// Creates a new builder-style object to manufacture [`AuditMitigationActionsTaskTarget`](crate::model::AuditMitigationActionsTaskTarget)
    pub fn builder() -> crate::model::audit_mitigation_actions_task_target::Builder {
        crate::model::audit_mitigation_actions_task_target::Builder::default()
    }
}

/// <p>A log target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogTarget {
    /// <p>The target type.</p>
    pub target_type: std::option::Option<crate::model::LogTargetType>,
    /// <p>The target name.</p>
    pub target_name: std::option::Option<std::string::String>,
}
impl LogTarget {
    /// <p>The target type.</p>
    pub fn target_type(&self) -> std::option::Option<&crate::model::LogTargetType> {
        self.target_type.as_ref()
    }
    /// <p>The target name.</p>
    pub fn target_name(&self) -> std::option::Option<&str> {
        self.target_name.as_deref()
    }
}
impl std::fmt::Debug for LogTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogTarget");
        formatter.field("target_type", &self.target_type);
        formatter.field("target_name", &self.target_name);
        formatter.finish()
    }
}
/// See [`LogTarget`](crate::model::LogTarget)
pub mod log_target {
    /// A builder for [`LogTarget`](crate::model::LogTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_type: std::option::Option<crate::model::LogTargetType>,
        pub(crate) target_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The target type.</p>
        pub fn target_type(mut self, input: crate::model::LogTargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The target type.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::LogTargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The target name.</p>
        pub fn target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_name = Some(input.into());
            self
        }
        /// <p>The target name.</p>
        pub fn set_target_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LogTarget`](crate::model::LogTarget)
        pub fn build(self) -> crate::model::LogTarget {
            crate::model::LogTarget {
                target_type: self.target_type,
                target_name: self.target_name,
            }
        }
    }
}
impl LogTarget {
    /// Creates a new builder-style object to manufacture [`LogTarget`](crate::model::LogTarget)
    pub fn builder() -> crate::model::log_target::Builder {
        crate::model::log_target::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogTargetType {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    ThingGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogTargetType {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => LogTargetType::Default,
            "THING_GROUP" => LogTargetType::ThingGroup,
            other => LogTargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogTargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogTargetType::from(s))
    }
}
impl LogTargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogTargetType::Default => "DEFAULT",
            LogTargetType::ThingGroup => "THING_GROUP",
            LogTargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "THING_GROUP"]
    }
}
impl AsRef<str> for LogTargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the logging options payload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingOptionsPayload {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The log level.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl LoggingOptionsPayload {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The log level.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for LoggingOptionsPayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingOptionsPayload");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`LoggingOptionsPayload`](crate::model::LoggingOptionsPayload)
pub mod logging_options_payload {
    /// A builder for [`LoggingOptionsPayload`](crate::model::LoggingOptionsPayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The log level.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The log level.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingOptionsPayload`](crate::model::LoggingOptionsPayload)
        pub fn build(self) -> crate::model::LoggingOptionsPayload {
            crate::model::LoggingOptionsPayload {
                role_arn: self.role_arn,
                log_level: self.log_level,
            }
        }
    }
}
impl LoggingOptionsPayload {
    /// Creates a new builder-style object to manufacture [`LoggingOptionsPayload`](crate::model::LoggingOptionsPayload)
    pub fn builder() -> crate::model::logging_options_payload::Builder {
        crate::model::logging_options_payload::Builder::default()
    }
}

/// <p>The thing group search index document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingGroupDocument {
    /// <p>The thing group name.</p>
    pub thing_group_name: std::option::Option<std::string::String>,
    /// <p>The thing group ID.</p>
    pub thing_group_id: std::option::Option<std::string::String>,
    /// <p>The thing group description.</p>
    pub thing_group_description: std::option::Option<std::string::String>,
    /// <p>The thing group attributes.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Parent group names.</p>
    pub parent_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ThingGroupDocument {
    /// <p>The thing group name.</p>
    pub fn thing_group_name(&self) -> std::option::Option<&str> {
        self.thing_group_name.as_deref()
    }
    /// <p>The thing group ID.</p>
    pub fn thing_group_id(&self) -> std::option::Option<&str> {
        self.thing_group_id.as_deref()
    }
    /// <p>The thing group description.</p>
    pub fn thing_group_description(&self) -> std::option::Option<&str> {
        self.thing_group_description.as_deref()
    }
    /// <p>The thing group attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>Parent group names.</p>
    pub fn parent_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.parent_group_names.as_deref()
    }
}
impl std::fmt::Debug for ThingGroupDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingGroupDocument");
        formatter.field("thing_group_name", &self.thing_group_name);
        formatter.field("thing_group_id", &self.thing_group_id);
        formatter.field("thing_group_description", &self.thing_group_description);
        formatter.field("attributes", &self.attributes);
        formatter.field("parent_group_names", &self.parent_group_names);
        formatter.finish()
    }
}
/// See [`ThingGroupDocument`](crate::model::ThingGroupDocument)
pub mod thing_group_document {
    /// A builder for [`ThingGroupDocument`](crate::model::ThingGroupDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_id: std::option::Option<std::string::String>,
        pub(crate) thing_group_description: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) parent_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The thing group name.</p>
        pub fn thing_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_name = Some(input.into());
            self
        }
        /// <p>The thing group name.</p>
        pub fn set_thing_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_name = input;
            self
        }
        /// <p>The thing group ID.</p>
        pub fn thing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_id = Some(input.into());
            self
        }
        /// <p>The thing group ID.</p>
        pub fn set_thing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_id = input;
            self
        }
        /// <p>The thing group description.</p>
        pub fn thing_group_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_description = Some(input.into());
            self
        }
        /// <p>The thing group description.</p>
        pub fn set_thing_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_description = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The thing group attributes.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The thing group attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `parent_group_names`.
        ///
        /// To override the contents of this collection use [`set_parent_group_names`](Self::set_parent_group_names).
        ///
        /// <p>Parent group names.</p>
        pub fn parent_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parent_group_names.unwrap_or_default();
            v.push(input.into());
            self.parent_group_names = Some(v);
            self
        }
        /// <p>Parent group names.</p>
        pub fn set_parent_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parent_group_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingGroupDocument`](crate::model::ThingGroupDocument)
        pub fn build(self) -> crate::model::ThingGroupDocument {
            crate::model::ThingGroupDocument {
                thing_group_name: self.thing_group_name,
                thing_group_id: self.thing_group_id,
                thing_group_description: self.thing_group_description,
                attributes: self.attributes,
                parent_group_names: self.parent_group_names,
            }
        }
    }
}
impl ThingGroupDocument {
    /// Creates a new builder-style object to manufacture [`ThingGroupDocument`](crate::model::ThingGroupDocument)
    pub fn builder() -> crate::model::thing_group_document::Builder {
        crate::model::thing_group_document::Builder::default()
    }
}

/// <p>The thing search index document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingDocument {
    /// <p>The thing name.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The thing ID.</p>
    pub thing_id: std::option::Option<std::string::String>,
    /// <p>The thing type name.</p>
    pub thing_type_name: std::option::Option<std::string::String>,
    /// <p>Thing group names.</p>
    pub thing_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The attributes.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The shadow.</p>
    pub shadow: std::option::Option<std::string::String>,
    /// <p>Indicates whether the thing is connected to the Amazon Web Services IoT Core service.</p>
    pub connectivity: std::option::Option<crate::model::ThingConnectivity>,
}
impl ThingDocument {
    /// <p>The thing name.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The thing ID.</p>
    pub fn thing_id(&self) -> std::option::Option<&str> {
        self.thing_id.as_deref()
    }
    /// <p>The thing type name.</p>
    pub fn thing_type_name(&self) -> std::option::Option<&str> {
        self.thing_type_name.as_deref()
    }
    /// <p>Thing group names.</p>
    pub fn thing_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.thing_group_names.as_deref()
    }
    /// <p>The attributes.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>The shadow.</p>
    pub fn shadow(&self) -> std::option::Option<&str> {
        self.shadow.as_deref()
    }
    /// <p>Indicates whether the thing is connected to the Amazon Web Services IoT Core service.</p>
    pub fn connectivity(&self) -> std::option::Option<&crate::model::ThingConnectivity> {
        self.connectivity.as_ref()
    }
}
impl std::fmt::Debug for ThingDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingDocument");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("thing_id", &self.thing_id);
        formatter.field("thing_type_name", &self.thing_type_name);
        formatter.field("thing_group_names", &self.thing_group_names);
        formatter.field("attributes", &self.attributes);
        formatter.field("shadow", &self.shadow);
        formatter.field("connectivity", &self.connectivity);
        formatter.finish()
    }
}
/// See [`ThingDocument`](crate::model::ThingDocument)
pub mod thing_document {
    /// A builder for [`ThingDocument`](crate::model::ThingDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) thing_id: std::option::Option<std::string::String>,
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) thing_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) shadow: std::option::Option<std::string::String>,
        pub(crate) connectivity: std::option::Option<crate::model::ThingConnectivity>,
    }
    impl Builder {
        /// <p>The thing name.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The thing name.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The thing ID.</p>
        pub fn thing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_id = Some(input.into());
            self
        }
        /// <p>The thing ID.</p>
        pub fn set_thing_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_id = input;
            self
        }
        /// <p>The thing type name.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The thing type name.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// Appends an item to `thing_group_names`.
        ///
        /// To override the contents of this collection use [`set_thing_group_names`](Self::set_thing_group_names).
        ///
        /// <p>Thing group names.</p>
        pub fn thing_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.thing_group_names.unwrap_or_default();
            v.push(input.into());
            self.thing_group_names = Some(v);
            self
        }
        /// <p>Thing group names.</p>
        pub fn set_thing_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.thing_group_names = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The shadow.</p>
        pub fn shadow(mut self, input: impl Into<std::string::String>) -> Self {
            self.shadow = Some(input.into());
            self
        }
        /// <p>The shadow.</p>
        pub fn set_shadow(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shadow = input;
            self
        }
        /// <p>Indicates whether the thing is connected to the Amazon Web Services IoT Core service.</p>
        pub fn connectivity(mut self, input: crate::model::ThingConnectivity) -> Self {
            self.connectivity = Some(input);
            self
        }
        /// <p>Indicates whether the thing is connected to the Amazon Web Services IoT Core service.</p>
        pub fn set_connectivity(
            mut self,
            input: std::option::Option<crate::model::ThingConnectivity>,
        ) -> Self {
            self.connectivity = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingDocument`](crate::model::ThingDocument)
        pub fn build(self) -> crate::model::ThingDocument {
            crate::model::ThingDocument {
                thing_name: self.thing_name,
                thing_id: self.thing_id,
                thing_type_name: self.thing_type_name,
                thing_group_names: self.thing_group_names,
                attributes: self.attributes,
                shadow: self.shadow,
                connectivity: self.connectivity,
            }
        }
    }
}
impl ThingDocument {
    /// Creates a new builder-style object to manufacture [`ThingDocument`](crate::model::ThingDocument)
    pub fn builder() -> crate::model::thing_document::Builder {
        crate::model::thing_document::Builder::default()
    }
}

/// <p>The connectivity status of the thing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingConnectivity {
    /// <p>True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not
    /// connected.</p>
    pub connected: bool,
    /// <p>The epoch time (in milliseconds) when the thing last connected or disconnected. If the
    /// thing has been disconnected for approximately an hour, the time value might be missing.</p>
    pub timestamp: std::option::Option<i64>,
    /// <p>The reason why the client is disconnected. If the thing has been disconnected for approximately an hour, the <code>disconnectReason</code> value might be missing.</p>
    pub disconnect_reason: std::option::Option<std::string::String>,
}
impl ThingConnectivity {
    /// <p>True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not
    /// connected.</p>
    pub fn connected(&self) -> bool {
        self.connected
    }
    /// <p>The epoch time (in milliseconds) when the thing last connected or disconnected. If the
    /// thing has been disconnected for approximately an hour, the time value might be missing.</p>
    pub fn timestamp(&self) -> std::option::Option<i64> {
        self.timestamp
    }
    /// <p>The reason why the client is disconnected. If the thing has been disconnected for approximately an hour, the <code>disconnectReason</code> value might be missing.</p>
    pub fn disconnect_reason(&self) -> std::option::Option<&str> {
        self.disconnect_reason.as_deref()
    }
}
impl std::fmt::Debug for ThingConnectivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingConnectivity");
        formatter.field("connected", &self.connected);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("disconnect_reason", &self.disconnect_reason);
        formatter.finish()
    }
}
/// See [`ThingConnectivity`](crate::model::ThingConnectivity)
pub mod thing_connectivity {
    /// A builder for [`ThingConnectivity`](crate::model::ThingConnectivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connected: std::option::Option<bool>,
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) disconnect_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not
        /// connected.</p>
        pub fn connected(mut self, input: bool) -> Self {
            self.connected = Some(input);
            self
        }
        /// <p>True if the thing is connected to the Amazon Web Services IoT Core service; false if it is not
        /// connected.</p>
        pub fn set_connected(mut self, input: std::option::Option<bool>) -> Self {
            self.connected = input;
            self
        }
        /// <p>The epoch time (in milliseconds) when the thing last connected or disconnected. If the
        /// thing has been disconnected for approximately an hour, the time value might be missing.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The epoch time (in milliseconds) when the thing last connected or disconnected. If the
        /// thing has been disconnected for approximately an hour, the time value might be missing.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The reason why the client is disconnected. If the thing has been disconnected for approximately an hour, the <code>disconnectReason</code> value might be missing.</p>
        pub fn disconnect_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.disconnect_reason = Some(input.into());
            self
        }
        /// <p>The reason why the client is disconnected. If the thing has been disconnected for approximately an hour, the <code>disconnectReason</code> value might be missing.</p>
        pub fn set_disconnect_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disconnect_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingConnectivity`](crate::model::ThingConnectivity)
        pub fn build(self) -> crate::model::ThingConnectivity {
            crate::model::ThingConnectivity {
                connected: self.connected.unwrap_or_default(),
                timestamp: self.timestamp,
                disconnect_reason: self.disconnect_reason,
            }
        }
    }
}
impl ThingConnectivity {
    /// Creates a new builder-style object to manufacture [`ThingConnectivity`](crate::model::ThingConnectivity)
    pub fn builder() -> crate::model::thing_connectivity::Builder {
        crate::model::thing_connectivity::Builder::default()
    }
}

/// <p>Describes a rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicRulePayload {
    /// <p>The SQL statement used to query the topic. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL
    /// Reference</a> in the <i>IoT Developer Guide</i>.</p>
    pub sql: std::option::Option<std::string::String>,
    /// <p>The description of the rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The actions associated with the rule.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>Specifies whether the rule is disabled.</p>
    pub rule_disabled: std::option::Option<bool>,
    /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
    pub aws_iot_sql_version: std::option::Option<std::string::String>,
    /// <p>The action to take when an error occurs.</p>
    pub error_action: std::option::Option<crate::model::Action>,
}
impl TopicRulePayload {
    /// <p>The SQL statement used to query the topic. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL
    /// Reference</a> in the <i>IoT Developer Guide</i>.</p>
    pub fn sql(&self) -> std::option::Option<&str> {
        self.sql.as_deref()
    }
    /// <p>The description of the rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The actions associated with the rule.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::Action]> {
        self.actions.as_deref()
    }
    /// <p>Specifies whether the rule is disabled.</p>
    pub fn rule_disabled(&self) -> std::option::Option<bool> {
        self.rule_disabled
    }
    /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
    pub fn aws_iot_sql_version(&self) -> std::option::Option<&str> {
        self.aws_iot_sql_version.as_deref()
    }
    /// <p>The action to take when an error occurs.</p>
    pub fn error_action(&self) -> std::option::Option<&crate::model::Action> {
        self.error_action.as_ref()
    }
}
impl std::fmt::Debug for TopicRulePayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicRulePayload");
        formatter.field("sql", &self.sql);
        formatter.field("description", &self.description);
        formatter.field("actions", &self.actions);
        formatter.field("rule_disabled", &self.rule_disabled);
        formatter.field("aws_iot_sql_version", &self.aws_iot_sql_version);
        formatter.field("error_action", &self.error_action);
        formatter.finish()
    }
}
/// See [`TopicRulePayload`](crate::model::TopicRulePayload)
pub mod topic_rule_payload {
    /// A builder for [`TopicRulePayload`](crate::model::TopicRulePayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sql: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) rule_disabled: std::option::Option<bool>,
        pub(crate) aws_iot_sql_version: std::option::Option<std::string::String>,
        pub(crate) error_action: std::option::Option<crate::model::Action>,
    }
    impl Builder {
        /// <p>The SQL statement used to query the topic. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL
        /// Reference</a> in the <i>IoT Developer Guide</i>.</p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql = Some(input.into());
            self
        }
        /// <p>The SQL statement used to query the topic. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">IoT SQL
        /// Reference</a> in the <i>IoT Developer Guide</i>.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql = input;
            self
        }
        /// <p>The description of the rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions associated with the rule.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions associated with the rule.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn rule_disabled(mut self, input: bool) -> Self {
            self.rule_disabled = Some(input);
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn set_rule_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.rule_disabled = input;
            self
        }
        /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
        pub fn aws_iot_sql_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_iot_sql_version = Some(input.into());
            self
        }
        /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
        pub fn set_aws_iot_sql_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_iot_sql_version = input;
            self
        }
        /// <p>The action to take when an error occurs.</p>
        pub fn error_action(mut self, input: crate::model::Action) -> Self {
            self.error_action = Some(input);
            self
        }
        /// <p>The action to take when an error occurs.</p>
        pub fn set_error_action(
            mut self,
            input: std::option::Option<crate::model::Action>,
        ) -> Self {
            self.error_action = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicRulePayload`](crate::model::TopicRulePayload)
        pub fn build(self) -> crate::model::TopicRulePayload {
            crate::model::TopicRulePayload {
                sql: self.sql,
                description: self.description,
                actions: self.actions,
                rule_disabled: self.rule_disabled,
                aws_iot_sql_version: self.aws_iot_sql_version,
                error_action: self.error_action,
            }
        }
    }
}
impl TopicRulePayload {
    /// Creates a new builder-style object to manufacture [`TopicRulePayload`](crate::model::TopicRulePayload)
    pub fn builder() -> crate::model::topic_rule_payload::Builder {
        crate::model::topic_rule_payload::Builder::default()
    }
}

/// <p>Describes the actions associated with a rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>Write to a DynamoDB table.</p>
    pub dynamo_db: std::option::Option<crate::model::DynamoDbAction>,
    /// <p>Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows
    /// you to write each attribute in an MQTT message payload into a separate DynamoDB
    /// column.</p>
    pub dynamo_d_bv2: std::option::Option<crate::model::DynamoDBv2Action>,
    /// <p>Invoke a Lambda function.</p>
    pub lambda: std::option::Option<crate::model::LambdaAction>,
    /// <p>Publish to an Amazon SNS topic.</p>
    pub sns: std::option::Option<crate::model::SnsAction>,
    /// <p>Publish to an Amazon SQS queue.</p>
    pub sqs: std::option::Option<crate::model::SqsAction>,
    /// <p>Write data to an Amazon Kinesis stream.</p>
    pub kinesis: std::option::Option<crate::model::KinesisAction>,
    /// <p>Publish to another MQTT topic.</p>
    pub republish: std::option::Option<crate::model::RepublishAction>,
    /// <p>Write to an Amazon S3 bucket.</p>
    pub s3: std::option::Option<crate::model::S3Action>,
    /// <p>Write to an Amazon Kinesis Firehose stream.</p>
    pub firehose: std::option::Option<crate::model::FirehoseAction>,
    /// <p>Capture a CloudWatch metric.</p>
    pub cloudwatch_metric: std::option::Option<crate::model::CloudwatchMetricAction>,
    /// <p>Change the state of a CloudWatch alarm.</p>
    pub cloudwatch_alarm: std::option::Option<crate::model::CloudwatchAlarmAction>,
    /// <p>Send data to CloudWatch Logs.</p>
    pub cloudwatch_logs: std::option::Option<crate::model::CloudwatchLogsAction>,
    /// <p>Write data to an Amazon OpenSearch Service domain.</p>   
    /// <note>
    /// <p>The <code>Elasticsearch</code> action can only be used by existing rule actions.
    /// To create a new rule action or to update an existing rule action, use the
    /// <code>OpenSearch</code> rule action instead. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a>.</p>
    /// </note>
    pub elasticsearch: std::option::Option<crate::model::ElasticsearchAction>,
    /// <p>Send a message to a Salesforce IoT Cloud Input Stream.</p>
    pub salesforce: std::option::Option<crate::model::SalesforceAction>,
    /// <p>Sends message data to an IoT Analytics channel.</p>
    pub iot_analytics: std::option::Option<crate::model::IotAnalyticsAction>,
    /// <p>Sends an input to an IoT Events detector.</p>
    pub iot_events: std::option::Option<crate::model::IotEventsAction>,
    /// <p>Sends data from the MQTT message that triggered the rule to IoT SiteWise asset
    /// properties.</p>
    pub iot_site_wise: std::option::Option<crate::model::IotSiteWiseAction>,
    /// <p>Starts execution of a Step Functions state machine.</p>
    pub step_functions: std::option::Option<crate::model::StepFunctionsAction>,
    /// <p>The Timestream rule action writes attributes (measures) from an MQTT message
    /// into an Amazon Timestream table. For more information, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a>
    /// topic rule action documentation.</p>
    pub timestream: std::option::Option<crate::model::TimestreamAction>,
    /// <p>Send data to an HTTPS endpoint.</p>
    pub http: std::option::Option<crate::model::HttpAction>,
    /// <p>Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.</p>
    pub kafka: std::option::Option<crate::model::KafkaAction>,
    /// <p>Write data to an Amazon OpenSearch Service domain.</p>
    pub open_search: std::option::Option<crate::model::OpenSearchAction>,
}
impl Action {
    /// <p>Write to a DynamoDB table.</p>
    pub fn dynamo_db(&self) -> std::option::Option<&crate::model::DynamoDbAction> {
        self.dynamo_db.as_ref()
    }
    /// <p>Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows
    /// you to write each attribute in an MQTT message payload into a separate DynamoDB
    /// column.</p>
    pub fn dynamo_d_bv2(&self) -> std::option::Option<&crate::model::DynamoDBv2Action> {
        self.dynamo_d_bv2.as_ref()
    }
    /// <p>Invoke a Lambda function.</p>
    pub fn lambda(&self) -> std::option::Option<&crate::model::LambdaAction> {
        self.lambda.as_ref()
    }
    /// <p>Publish to an Amazon SNS topic.</p>
    pub fn sns(&self) -> std::option::Option<&crate::model::SnsAction> {
        self.sns.as_ref()
    }
    /// <p>Publish to an Amazon SQS queue.</p>
    pub fn sqs(&self) -> std::option::Option<&crate::model::SqsAction> {
        self.sqs.as_ref()
    }
    /// <p>Write data to an Amazon Kinesis stream.</p>
    pub fn kinesis(&self) -> std::option::Option<&crate::model::KinesisAction> {
        self.kinesis.as_ref()
    }
    /// <p>Publish to another MQTT topic.</p>
    pub fn republish(&self) -> std::option::Option<&crate::model::RepublishAction> {
        self.republish.as_ref()
    }
    /// <p>Write to an Amazon S3 bucket.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Action> {
        self.s3.as_ref()
    }
    /// <p>Write to an Amazon Kinesis Firehose stream.</p>
    pub fn firehose(&self) -> std::option::Option<&crate::model::FirehoseAction> {
        self.firehose.as_ref()
    }
    /// <p>Capture a CloudWatch metric.</p>
    pub fn cloudwatch_metric(&self) -> std::option::Option<&crate::model::CloudwatchMetricAction> {
        self.cloudwatch_metric.as_ref()
    }
    /// <p>Change the state of a CloudWatch alarm.</p>
    pub fn cloudwatch_alarm(&self) -> std::option::Option<&crate::model::CloudwatchAlarmAction> {
        self.cloudwatch_alarm.as_ref()
    }
    /// <p>Send data to CloudWatch Logs.</p>
    pub fn cloudwatch_logs(&self) -> std::option::Option<&crate::model::CloudwatchLogsAction> {
        self.cloudwatch_logs.as_ref()
    }
    /// <p>Write data to an Amazon OpenSearch Service domain.</p>   
    /// <note>
    /// <p>The <code>Elasticsearch</code> action can only be used by existing rule actions.
    /// To create a new rule action or to update an existing rule action, use the
    /// <code>OpenSearch</code> rule action instead. For more information, see
    /// <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a>.</p>
    /// </note>
    pub fn elasticsearch(&self) -> std::option::Option<&crate::model::ElasticsearchAction> {
        self.elasticsearch.as_ref()
    }
    /// <p>Send a message to a Salesforce IoT Cloud Input Stream.</p>
    pub fn salesforce(&self) -> std::option::Option<&crate::model::SalesforceAction> {
        self.salesforce.as_ref()
    }
    /// <p>Sends message data to an IoT Analytics channel.</p>
    pub fn iot_analytics(&self) -> std::option::Option<&crate::model::IotAnalyticsAction> {
        self.iot_analytics.as_ref()
    }
    /// <p>Sends an input to an IoT Events detector.</p>
    pub fn iot_events(&self) -> std::option::Option<&crate::model::IotEventsAction> {
        self.iot_events.as_ref()
    }
    /// <p>Sends data from the MQTT message that triggered the rule to IoT SiteWise asset
    /// properties.</p>
    pub fn iot_site_wise(&self) -> std::option::Option<&crate::model::IotSiteWiseAction> {
        self.iot_site_wise.as_ref()
    }
    /// <p>Starts execution of a Step Functions state machine.</p>
    pub fn step_functions(&self) -> std::option::Option<&crate::model::StepFunctionsAction> {
        self.step_functions.as_ref()
    }
    /// <p>The Timestream rule action writes attributes (measures) from an MQTT message
    /// into an Amazon Timestream table. For more information, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a>
    /// topic rule action documentation.</p>
    pub fn timestream(&self) -> std::option::Option<&crate::model::TimestreamAction> {
        self.timestream.as_ref()
    }
    /// <p>Send data to an HTTPS endpoint.</p>
    pub fn http(&self) -> std::option::Option<&crate::model::HttpAction> {
        self.http.as_ref()
    }
    /// <p>Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.</p>
    pub fn kafka(&self) -> std::option::Option<&crate::model::KafkaAction> {
        self.kafka.as_ref()
    }
    /// <p>Write data to an Amazon OpenSearch Service domain.</p>
    pub fn open_search(&self) -> std::option::Option<&crate::model::OpenSearchAction> {
        self.open_search.as_ref()
    }
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("dynamo_db", &self.dynamo_db);
        formatter.field("dynamo_d_bv2", &self.dynamo_d_bv2);
        formatter.field("lambda", &self.lambda);
        formatter.field("sns", &self.sns);
        formatter.field("sqs", &self.sqs);
        formatter.field("kinesis", &self.kinesis);
        formatter.field("republish", &self.republish);
        formatter.field("s3", &self.s3);
        formatter.field("firehose", &self.firehose);
        formatter.field("cloudwatch_metric", &self.cloudwatch_metric);
        formatter.field("cloudwatch_alarm", &self.cloudwatch_alarm);
        formatter.field("cloudwatch_logs", &self.cloudwatch_logs);
        formatter.field("elasticsearch", &self.elasticsearch);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("iot_analytics", &self.iot_analytics);
        formatter.field("iot_events", &self.iot_events);
        formatter.field("iot_site_wise", &self.iot_site_wise);
        formatter.field("step_functions", &self.step_functions);
        formatter.field("timestream", &self.timestream);
        formatter.field("http", &self.http);
        formatter.field("kafka", &self.kafka);
        formatter.field("open_search", &self.open_search);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dynamo_db: std::option::Option<crate::model::DynamoDbAction>,
        pub(crate) dynamo_d_bv2: std::option::Option<crate::model::DynamoDBv2Action>,
        pub(crate) lambda: std::option::Option<crate::model::LambdaAction>,
        pub(crate) sns: std::option::Option<crate::model::SnsAction>,
        pub(crate) sqs: std::option::Option<crate::model::SqsAction>,
        pub(crate) kinesis: std::option::Option<crate::model::KinesisAction>,
        pub(crate) republish: std::option::Option<crate::model::RepublishAction>,
        pub(crate) s3: std::option::Option<crate::model::S3Action>,
        pub(crate) firehose: std::option::Option<crate::model::FirehoseAction>,
        pub(crate) cloudwatch_metric: std::option::Option<crate::model::CloudwatchMetricAction>,
        pub(crate) cloudwatch_alarm: std::option::Option<crate::model::CloudwatchAlarmAction>,
        pub(crate) cloudwatch_logs: std::option::Option<crate::model::CloudwatchLogsAction>,
        pub(crate) elasticsearch: std::option::Option<crate::model::ElasticsearchAction>,
        pub(crate) salesforce: std::option::Option<crate::model::SalesforceAction>,
        pub(crate) iot_analytics: std::option::Option<crate::model::IotAnalyticsAction>,
        pub(crate) iot_events: std::option::Option<crate::model::IotEventsAction>,
        pub(crate) iot_site_wise: std::option::Option<crate::model::IotSiteWiseAction>,
        pub(crate) step_functions: std::option::Option<crate::model::StepFunctionsAction>,
        pub(crate) timestream: std::option::Option<crate::model::TimestreamAction>,
        pub(crate) http: std::option::Option<crate::model::HttpAction>,
        pub(crate) kafka: std::option::Option<crate::model::KafkaAction>,
        pub(crate) open_search: std::option::Option<crate::model::OpenSearchAction>,
    }
    impl Builder {
        /// <p>Write to a DynamoDB table.</p>
        pub fn dynamo_db(mut self, input: crate::model::DynamoDbAction) -> Self {
            self.dynamo_db = Some(input);
            self
        }
        /// <p>Write to a DynamoDB table.</p>
        pub fn set_dynamo_db(
            mut self,
            input: std::option::Option<crate::model::DynamoDbAction>,
        ) -> Self {
            self.dynamo_db = input;
            self
        }
        /// <p>Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows
        /// you to write each attribute in an MQTT message payload into a separate DynamoDB
        /// column.</p>
        pub fn dynamo_d_bv2(mut self, input: crate::model::DynamoDBv2Action) -> Self {
            self.dynamo_d_bv2 = Some(input);
            self
        }
        /// <p>Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows
        /// you to write each attribute in an MQTT message payload into a separate DynamoDB
        /// column.</p>
        pub fn set_dynamo_d_bv2(
            mut self,
            input: std::option::Option<crate::model::DynamoDBv2Action>,
        ) -> Self {
            self.dynamo_d_bv2 = input;
            self
        }
        /// <p>Invoke a Lambda function.</p>
        pub fn lambda(mut self, input: crate::model::LambdaAction) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>Invoke a Lambda function.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::LambdaAction>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// <p>Publish to an Amazon SNS topic.</p>
        pub fn sns(mut self, input: crate::model::SnsAction) -> Self {
            self.sns = Some(input);
            self
        }
        /// <p>Publish to an Amazon SNS topic.</p>
        pub fn set_sns(mut self, input: std::option::Option<crate::model::SnsAction>) -> Self {
            self.sns = input;
            self
        }
        /// <p>Publish to an Amazon SQS queue.</p>
        pub fn sqs(mut self, input: crate::model::SqsAction) -> Self {
            self.sqs = Some(input);
            self
        }
        /// <p>Publish to an Amazon SQS queue.</p>
        pub fn set_sqs(mut self, input: std::option::Option<crate::model::SqsAction>) -> Self {
            self.sqs = input;
            self
        }
        /// <p>Write data to an Amazon Kinesis stream.</p>
        pub fn kinesis(mut self, input: crate::model::KinesisAction) -> Self {
            self.kinesis = Some(input);
            self
        }
        /// <p>Write data to an Amazon Kinesis stream.</p>
        pub fn set_kinesis(
            mut self,
            input: std::option::Option<crate::model::KinesisAction>,
        ) -> Self {
            self.kinesis = input;
            self
        }
        /// <p>Publish to another MQTT topic.</p>
        pub fn republish(mut self, input: crate::model::RepublishAction) -> Self {
            self.republish = Some(input);
            self
        }
        /// <p>Publish to another MQTT topic.</p>
        pub fn set_republish(
            mut self,
            input: std::option::Option<crate::model::RepublishAction>,
        ) -> Self {
            self.republish = input;
            self
        }
        /// <p>Write to an Amazon S3 bucket.</p>
        pub fn s3(mut self, input: crate::model::S3Action) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>Write to an Amazon S3 bucket.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Action>) -> Self {
            self.s3 = input;
            self
        }
        /// <p>Write to an Amazon Kinesis Firehose stream.</p>
        pub fn firehose(mut self, input: crate::model::FirehoseAction) -> Self {
            self.firehose = Some(input);
            self
        }
        /// <p>Write to an Amazon Kinesis Firehose stream.</p>
        pub fn set_firehose(
            mut self,
            input: std::option::Option<crate::model::FirehoseAction>,
        ) -> Self {
            self.firehose = input;
            self
        }
        /// <p>Capture a CloudWatch metric.</p>
        pub fn cloudwatch_metric(mut self, input: crate::model::CloudwatchMetricAction) -> Self {
            self.cloudwatch_metric = Some(input);
            self
        }
        /// <p>Capture a CloudWatch metric.</p>
        pub fn set_cloudwatch_metric(
            mut self,
            input: std::option::Option<crate::model::CloudwatchMetricAction>,
        ) -> Self {
            self.cloudwatch_metric = input;
            self
        }
        /// <p>Change the state of a CloudWatch alarm.</p>
        pub fn cloudwatch_alarm(mut self, input: crate::model::CloudwatchAlarmAction) -> Self {
            self.cloudwatch_alarm = Some(input);
            self
        }
        /// <p>Change the state of a CloudWatch alarm.</p>
        pub fn set_cloudwatch_alarm(
            mut self,
            input: std::option::Option<crate::model::CloudwatchAlarmAction>,
        ) -> Self {
            self.cloudwatch_alarm = input;
            self
        }
        /// <p>Send data to CloudWatch Logs.</p>
        pub fn cloudwatch_logs(mut self, input: crate::model::CloudwatchLogsAction) -> Self {
            self.cloudwatch_logs = Some(input);
            self
        }
        /// <p>Send data to CloudWatch Logs.</p>
        pub fn set_cloudwatch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudwatchLogsAction>,
        ) -> Self {
            self.cloudwatch_logs = input;
            self
        }
        /// <p>Write data to an Amazon OpenSearch Service domain.</p>   
        /// <note>
        /// <p>The <code>Elasticsearch</code> action can only be used by existing rule actions.
        /// To create a new rule action or to update an existing rule action, use the
        /// <code>OpenSearch</code> rule action instead. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a>.</p>
        /// </note>
        pub fn elasticsearch(mut self, input: crate::model::ElasticsearchAction) -> Self {
            self.elasticsearch = Some(input);
            self
        }
        /// <p>Write data to an Amazon OpenSearch Service domain.</p>   
        /// <note>
        /// <p>The <code>Elasticsearch</code> action can only be used by existing rule actions.
        /// To create a new rule action or to update an existing rule action, use the
        /// <code>OpenSearch</code> rule action instead. For more information, see
        /// <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a>.</p>
        /// </note>
        pub fn set_elasticsearch(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchAction>,
        ) -> Self {
            self.elasticsearch = input;
            self
        }
        /// <p>Send a message to a Salesforce IoT Cloud Input Stream.</p>
        pub fn salesforce(mut self, input: crate::model::SalesforceAction) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p>Send a message to a Salesforce IoT Cloud Input Stream.</p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceAction>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p>Sends message data to an IoT Analytics channel.</p>
        pub fn iot_analytics(mut self, input: crate::model::IotAnalyticsAction) -> Self {
            self.iot_analytics = Some(input);
            self
        }
        /// <p>Sends message data to an IoT Analytics channel.</p>
        pub fn set_iot_analytics(
            mut self,
            input: std::option::Option<crate::model::IotAnalyticsAction>,
        ) -> Self {
            self.iot_analytics = input;
            self
        }
        /// <p>Sends an input to an IoT Events detector.</p>
        pub fn iot_events(mut self, input: crate::model::IotEventsAction) -> Self {
            self.iot_events = Some(input);
            self
        }
        /// <p>Sends an input to an IoT Events detector.</p>
        pub fn set_iot_events(
            mut self,
            input: std::option::Option<crate::model::IotEventsAction>,
        ) -> Self {
            self.iot_events = input;
            self
        }
        /// <p>Sends data from the MQTT message that triggered the rule to IoT SiteWise asset
        /// properties.</p>
        pub fn iot_site_wise(mut self, input: crate::model::IotSiteWiseAction) -> Self {
            self.iot_site_wise = Some(input);
            self
        }
        /// <p>Sends data from the MQTT message that triggered the rule to IoT SiteWise asset
        /// properties.</p>
        pub fn set_iot_site_wise(
            mut self,
            input: std::option::Option<crate::model::IotSiteWiseAction>,
        ) -> Self {
            self.iot_site_wise = input;
            self
        }
        /// <p>Starts execution of a Step Functions state machine.</p>
        pub fn step_functions(mut self, input: crate::model::StepFunctionsAction) -> Self {
            self.step_functions = Some(input);
            self
        }
        /// <p>Starts execution of a Step Functions state machine.</p>
        pub fn set_step_functions(
            mut self,
            input: std::option::Option<crate::model::StepFunctionsAction>,
        ) -> Self {
            self.step_functions = input;
            self
        }
        /// <p>The Timestream rule action writes attributes (measures) from an MQTT message
        /// into an Amazon Timestream table. For more information, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a>
        /// topic rule action documentation.</p>
        pub fn timestream(mut self, input: crate::model::TimestreamAction) -> Self {
            self.timestream = Some(input);
            self
        }
        /// <p>The Timestream rule action writes attributes (measures) from an MQTT message
        /// into an Amazon Timestream table. For more information, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a>
        /// topic rule action documentation.</p>
        pub fn set_timestream(
            mut self,
            input: std::option::Option<crate::model::TimestreamAction>,
        ) -> Self {
            self.timestream = input;
            self
        }
        /// <p>Send data to an HTTPS endpoint.</p>
        pub fn http(mut self, input: crate::model::HttpAction) -> Self {
            self.http = Some(input);
            self
        }
        /// <p>Send data to an HTTPS endpoint.</p>
        pub fn set_http(mut self, input: std::option::Option<crate::model::HttpAction>) -> Self {
            self.http = input;
            self
        }
        /// <p>Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.</p>
        pub fn kafka(mut self, input: crate::model::KafkaAction) -> Self {
            self.kafka = Some(input);
            self
        }
        /// <p>Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.</p>
        pub fn set_kafka(mut self, input: std::option::Option<crate::model::KafkaAction>) -> Self {
            self.kafka = input;
            self
        }
        /// <p>Write data to an Amazon OpenSearch Service domain.</p>
        pub fn open_search(mut self, input: crate::model::OpenSearchAction) -> Self {
            self.open_search = Some(input);
            self
        }
        /// <p>Write data to an Amazon OpenSearch Service domain.</p>
        pub fn set_open_search(
            mut self,
            input: std::option::Option<crate::model::OpenSearchAction>,
        ) -> Self {
            self.open_search = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                dynamo_db: self.dynamo_db,
                dynamo_d_bv2: self.dynamo_d_bv2,
                lambda: self.lambda,
                sns: self.sns,
                sqs: self.sqs,
                kinesis: self.kinesis,
                republish: self.republish,
                s3: self.s3,
                firehose: self.firehose,
                cloudwatch_metric: self.cloudwatch_metric,
                cloudwatch_alarm: self.cloudwatch_alarm,
                cloudwatch_logs: self.cloudwatch_logs,
                elasticsearch: self.elasticsearch,
                salesforce: self.salesforce,
                iot_analytics: self.iot_analytics,
                iot_events: self.iot_events,
                iot_site_wise: self.iot_site_wise,
                step_functions: self.step_functions,
                timestream: self.timestream,
                http: self.http,
                kafka: self.kafka,
                open_search: self.open_search,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Describes an action that writes data to an Amazon OpenSearch Service
/// domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpenSearchAction {
    /// <p>The IAM role ARN that has access to OpenSearch.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint of your OpenSearch domain.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The OpenSearch index where you want to store your data.</p>
    pub index: std::option::Option<std::string::String>,
    /// <p>The type of document you are storing.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the document you are storing.</p>
    pub id: std::option::Option<std::string::String>,
}
impl OpenSearchAction {
    /// <p>The IAM role ARN that has access to OpenSearch.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The endpoint of your OpenSearch domain.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The OpenSearch index where you want to store your data.</p>
    pub fn index(&self) -> std::option::Option<&str> {
        self.index.as_deref()
    }
    /// <p>The type of document you are storing.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The unique identifier for the document you are storing.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for OpenSearchAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpenSearchAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("index", &self.index);
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`OpenSearchAction`](crate::model::OpenSearchAction)
pub mod open_search_action {
    /// A builder for [`OpenSearchAction`](crate::model::OpenSearchAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) index: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role ARN that has access to OpenSearch.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role ARN that has access to OpenSearch.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The endpoint of your OpenSearch domain.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of your OpenSearch domain.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The OpenSearch index where you want to store your data.</p>
        pub fn index(mut self, input: impl Into<std::string::String>) -> Self {
            self.index = Some(input.into());
            self
        }
        /// <p>The OpenSearch index where you want to store your data.</p>
        pub fn set_index(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index = input;
            self
        }
        /// <p>The type of document you are storing.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of document you are storing.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The unique identifier for the document you are storing.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the document you are storing.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`OpenSearchAction`](crate::model::OpenSearchAction)
        pub fn build(self) -> crate::model::OpenSearchAction {
            crate::model::OpenSearchAction {
                role_arn: self.role_arn,
                endpoint: self.endpoint,
                index: self.index,
                r#type: self.r#type,
                id: self.id,
            }
        }
    }
}
impl OpenSearchAction {
    /// Creates a new builder-style object to manufacture [`OpenSearchAction`](crate::model::OpenSearchAction)
    pub fn builder() -> crate::model::open_search_action::Builder {
        crate::model::open_search_action::Builder::default()
    }
}

/// <p>Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaAction {
    /// <p>The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.</p>
    pub destination_arn: std::option::Option<std::string::String>,
    /// <p>The Kafka topic for messages to be sent to the Kafka broker.</p>
    pub topic: std::option::Option<std::string::String>,
    /// <p>The Kafka message key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The Kafka message partition.</p>
    pub partition: std::option::Option<std::string::String>,
    /// <p>Properties of the Apache Kafka producer client.</p>
    pub client_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl KafkaAction {
    /// <p>The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.</p>
    pub fn destination_arn(&self) -> std::option::Option<&str> {
        self.destination_arn.as_deref()
    }
    /// <p>The Kafka topic for messages to be sent to the Kafka broker.</p>
    pub fn topic(&self) -> std::option::Option<&str> {
        self.topic.as_deref()
    }
    /// <p>The Kafka message key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The Kafka message partition.</p>
    pub fn partition(&self) -> std::option::Option<&str> {
        self.partition.as_deref()
    }
    /// <p>Properties of the Apache Kafka producer client.</p>
    pub fn client_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.client_properties.as_ref()
    }
}
impl std::fmt::Debug for KafkaAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaAction");
        formatter.field("destination_arn", &self.destination_arn);
        formatter.field("topic", &self.topic);
        formatter.field("key", &self.key);
        formatter.field("partition", &self.partition);
        formatter.field("client_properties", &self.client_properties);
        formatter.finish()
    }
}
/// See [`KafkaAction`](crate::model::KafkaAction)
pub mod kafka_action {
    /// A builder for [`KafkaAction`](crate::model::KafkaAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) topic: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) partition: std::option::Option<std::string::String>,
        pub(crate) client_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of Kafka action's VPC <code>TopicRuleDestination</code>.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p>The Kafka topic for messages to be sent to the Kafka broker.</p>
        pub fn topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic = Some(input.into());
            self
        }
        /// <p>The Kafka topic for messages to be sent to the Kafka broker.</p>
        pub fn set_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic = input;
            self
        }
        /// <p>The Kafka message key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The Kafka message key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The Kafka message partition.</p>
        pub fn partition(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition = Some(input.into());
            self
        }
        /// <p>The Kafka message partition.</p>
        pub fn set_partition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partition = input;
            self
        }
        /// Adds a key-value pair to `client_properties`.
        ///
        /// To override the contents of this collection use [`set_client_properties`](Self::set_client_properties).
        ///
        /// <p>Properties of the Apache Kafka producer client.</p>
        pub fn client_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.client_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.client_properties = Some(hash_map);
            self
        }
        /// <p>Properties of the Apache Kafka producer client.</p>
        pub fn set_client_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.client_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaAction`](crate::model::KafkaAction)
        pub fn build(self) -> crate::model::KafkaAction {
            crate::model::KafkaAction {
                destination_arn: self.destination_arn,
                topic: self.topic,
                key: self.key,
                partition: self.partition,
                client_properties: self.client_properties,
            }
        }
    }
}
impl KafkaAction {
    /// Creates a new builder-style object to manufacture [`KafkaAction`](crate::model::KafkaAction)
    pub fn builder() -> crate::model::kafka_action::Builder {
        crate::model::kafka_action::Builder::default()
    }
}

/// <p>Send data to an HTTPS endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpAction {
    /// <p>The endpoint URL. If substitution templates are used in the URL, you must also specify a
    /// <code>confirmationUrl</code>. If this is a new destination, a new
    /// <code>TopicRuleDestination</code> is created if possible.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The URL to which IoT sends a confirmation message. The value of the confirmation URL
    /// must be a prefix of the endpoint URL. If you do not specify a confirmation URL IoT uses
    /// the endpoint URL as the confirmation URL. If you use substitution templates in the
    /// confirmationUrl, you must create and enable topic rule destinations that match each
    /// possible value of the substitution template before traffic is allowed to your endpoint
    /// URL.</p>
    pub confirmation_url: std::option::Option<std::string::String>,
    /// <p>The HTTP headers to send with the message data.</p>
    pub headers: std::option::Option<std::vec::Vec<crate::model::HttpActionHeader>>,
    /// <p>The authentication method to use when sending data to an HTTPS endpoint.</p>
    pub auth: std::option::Option<crate::model::HttpAuthorization>,
}
impl HttpAction {
    /// <p>The endpoint URL. If substitution templates are used in the URL, you must also specify a
    /// <code>confirmationUrl</code>. If this is a new destination, a new
    /// <code>TopicRuleDestination</code> is created if possible.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The URL to which IoT sends a confirmation message. The value of the confirmation URL
    /// must be a prefix of the endpoint URL. If you do not specify a confirmation URL IoT uses
    /// the endpoint URL as the confirmation URL. If you use substitution templates in the
    /// confirmationUrl, you must create and enable topic rule destinations that match each
    /// possible value of the substitution template before traffic is allowed to your endpoint
    /// URL.</p>
    pub fn confirmation_url(&self) -> std::option::Option<&str> {
        self.confirmation_url.as_deref()
    }
    /// <p>The HTTP headers to send with the message data.</p>
    pub fn headers(&self) -> std::option::Option<&[crate::model::HttpActionHeader]> {
        self.headers.as_deref()
    }
    /// <p>The authentication method to use when sending data to an HTTPS endpoint.</p>
    pub fn auth(&self) -> std::option::Option<&crate::model::HttpAuthorization> {
        self.auth.as_ref()
    }
}
impl std::fmt::Debug for HttpAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpAction");
        formatter.field("url", &self.url);
        formatter.field("confirmation_url", &self.confirmation_url);
        formatter.field("headers", &self.headers);
        formatter.field("auth", &self.auth);
        formatter.finish()
    }
}
/// See [`HttpAction`](crate::model::HttpAction)
pub mod http_action {
    /// A builder for [`HttpAction`](crate::model::HttpAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) confirmation_url: std::option::Option<std::string::String>,
        pub(crate) headers: std::option::Option<std::vec::Vec<crate::model::HttpActionHeader>>,
        pub(crate) auth: std::option::Option<crate::model::HttpAuthorization>,
    }
    impl Builder {
        /// <p>The endpoint URL. If substitution templates are used in the URL, you must also specify a
        /// <code>confirmationUrl</code>. If this is a new destination, a new
        /// <code>TopicRuleDestination</code> is created if possible.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The endpoint URL. If substitution templates are used in the URL, you must also specify a
        /// <code>confirmationUrl</code>. If this is a new destination, a new
        /// <code>TopicRuleDestination</code> is created if possible.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The URL to which IoT sends a confirmation message. The value of the confirmation URL
        /// must be a prefix of the endpoint URL. If you do not specify a confirmation URL IoT uses
        /// the endpoint URL as the confirmation URL. If you use substitution templates in the
        /// confirmationUrl, you must create and enable topic rule destinations that match each
        /// possible value of the substitution template before traffic is allowed to your endpoint
        /// URL.</p>
        pub fn confirmation_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.confirmation_url = Some(input.into());
            self
        }
        /// <p>The URL to which IoT sends a confirmation message. The value of the confirmation URL
        /// must be a prefix of the endpoint URL. If you do not specify a confirmation URL IoT uses
        /// the endpoint URL as the confirmation URL. If you use substitution templates in the
        /// confirmationUrl, you must create and enable topic rule destinations that match each
        /// possible value of the substitution template before traffic is allowed to your endpoint
        /// URL.</p>
        pub fn set_confirmation_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.confirmation_url = input;
            self
        }
        /// Appends an item to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>The HTTP headers to send with the message data.</p>
        pub fn headers(mut self, input: impl Into<crate::model::HttpActionHeader>) -> Self {
            let mut v = self.headers.unwrap_or_default();
            v.push(input.into());
            self.headers = Some(v);
            self
        }
        /// <p>The HTTP headers to send with the message data.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpActionHeader>>,
        ) -> Self {
            self.headers = input;
            self
        }
        /// <p>The authentication method to use when sending data to an HTTPS endpoint.</p>
        pub fn auth(mut self, input: crate::model::HttpAuthorization) -> Self {
            self.auth = Some(input);
            self
        }
        /// <p>The authentication method to use when sending data to an HTTPS endpoint.</p>
        pub fn set_auth(
            mut self,
            input: std::option::Option<crate::model::HttpAuthorization>,
        ) -> Self {
            self.auth = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpAction`](crate::model::HttpAction)
        pub fn build(self) -> crate::model::HttpAction {
            crate::model::HttpAction {
                url: self.url,
                confirmation_url: self.confirmation_url,
                headers: self.headers,
                auth: self.auth,
            }
        }
    }
}
impl HttpAction {
    /// Creates a new builder-style object to manufacture [`HttpAction`](crate::model::HttpAction)
    pub fn builder() -> crate::model::http_action::Builder {
        crate::model::http_action::Builder::default()
    }
}

/// <p>The authorization method used to send messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpAuthorization {
    /// <p>Use Sig V4 authorization. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature
    /// Version 4 Signing Process</a>.</p>
    pub sigv4: std::option::Option<crate::model::SigV4Authorization>,
}
impl HttpAuthorization {
    /// <p>Use Sig V4 authorization. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature
    /// Version 4 Signing Process</a>.</p>
    pub fn sigv4(&self) -> std::option::Option<&crate::model::SigV4Authorization> {
        self.sigv4.as_ref()
    }
}
impl std::fmt::Debug for HttpAuthorization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpAuthorization");
        formatter.field("sigv4", &self.sigv4);
        formatter.finish()
    }
}
/// See [`HttpAuthorization`](crate::model::HttpAuthorization)
pub mod http_authorization {
    /// A builder for [`HttpAuthorization`](crate::model::HttpAuthorization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sigv4: std::option::Option<crate::model::SigV4Authorization>,
    }
    impl Builder {
        /// <p>Use Sig V4 authorization. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature
        /// Version 4 Signing Process</a>.</p>
        pub fn sigv4(mut self, input: crate::model::SigV4Authorization) -> Self {
            self.sigv4 = Some(input);
            self
        }
        /// <p>Use Sig V4 authorization. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature
        /// Version 4 Signing Process</a>.</p>
        pub fn set_sigv4(
            mut self,
            input: std::option::Option<crate::model::SigV4Authorization>,
        ) -> Self {
            self.sigv4 = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpAuthorization`](crate::model::HttpAuthorization)
        pub fn build(self) -> crate::model::HttpAuthorization {
            crate::model::HttpAuthorization { sigv4: self.sigv4 }
        }
    }
}
impl HttpAuthorization {
    /// Creates a new builder-style object to manufacture [`HttpAuthorization`](crate::model::HttpAuthorization)
    pub fn builder() -> crate::model::http_authorization::Builder {
        crate::model::http_authorization::Builder::default()
    }
}

/// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 signing process</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigV4Authorization {
    /// <p>The signing region.</p>
    pub signing_region: std::option::Option<std::string::String>,
    /// <p>The service name to use while signing with Sig V4.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the signing role.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl SigV4Authorization {
    /// <p>The signing region.</p>
    pub fn signing_region(&self) -> std::option::Option<&str> {
        self.signing_region.as_deref()
    }
    /// <p>The service name to use while signing with Sig V4.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The ARN of the signing role.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for SigV4Authorization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigV4Authorization");
        formatter.field("signing_region", &self.signing_region);
        formatter.field("service_name", &self.service_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`SigV4Authorization`](crate::model::SigV4Authorization)
pub mod sig_v4_authorization {
    /// A builder for [`SigV4Authorization`](crate::model::SigV4Authorization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signing_region: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The signing region.</p>
        pub fn signing_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_region = Some(input.into());
            self
        }
        /// <p>The signing region.</p>
        pub fn set_signing_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_region = input;
            self
        }
        /// <p>The service name to use while signing with Sig V4.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The service name to use while signing with Sig V4.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The ARN of the signing role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SigV4Authorization`](crate::model::SigV4Authorization)
        pub fn build(self) -> crate::model::SigV4Authorization {
            crate::model::SigV4Authorization {
                signing_region: self.signing_region,
                service_name: self.service_name,
                role_arn: self.role_arn,
            }
        }
    }
}
impl SigV4Authorization {
    /// Creates a new builder-style object to manufacture [`SigV4Authorization`](crate::model::SigV4Authorization)
    pub fn builder() -> crate::model::sig_v4_authorization::Builder {
        crate::model::sig_v4_authorization::Builder::default()
    }
}

/// <p>The HTTP action header.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpActionHeader {
    /// <p>The HTTP header key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The HTTP header value. Substitution templates are supported.</p>
    pub value: std::option::Option<std::string::String>,
}
impl HttpActionHeader {
    /// <p>The HTTP header key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The HTTP header value. Substitution templates are supported.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for HttpActionHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpActionHeader");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`HttpActionHeader`](crate::model::HttpActionHeader)
pub mod http_action_header {
    /// A builder for [`HttpActionHeader`](crate::model::HttpActionHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP header key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The HTTP header key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The HTTP header value. Substitution templates are supported.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The HTTP header value. Substitution templates are supported.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpActionHeader`](crate::model::HttpActionHeader)
        pub fn build(self) -> crate::model::HttpActionHeader {
            crate::model::HttpActionHeader {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl HttpActionHeader {
    /// Creates a new builder-style object to manufacture [`HttpActionHeader`](crate::model::HttpActionHeader)
    pub fn builder() -> crate::model::http_action_header::Builder {
        crate::model::http_action_header::Builder::default()
    }
}

/// <p>The Timestream rule action writes attributes (measures) from an MQTT message
/// into an Amazon Timestream table. For more information, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a>
/// topic rule action documentation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestreamAction {
    /// <p>The ARN of the role that grants permission to write to the
    /// Amazon Timestream database table.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of an Amazon Timestream database.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the database table into which to write the measure records.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Metadata attributes of the time series that are written in each measure record.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::TimestreamDimension>>,
    /// <p>Specifies an application-defined value to replace the default value assigned to the
    /// Timestream record's timestamp in the <code>time</code> column.</p>
    /// <p>You can use this property to specify the value and the precision of the Timestream
    /// record's timestamp. You can specify a value from the message payload or a value computed by
    /// a substitution template.</p>
    /// <p>If omitted, the topic rule action assigns the timestamp, in milliseconds, at the time it
    /// processed the rule. </p>
    pub timestamp: std::option::Option<crate::model::TimestreamTimestamp>,
}
impl TimestreamAction {
    /// <p>The ARN of the role that grants permission to write to the
    /// Amazon Timestream database table.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The name of an Amazon Timestream database.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the database table into which to write the measure records.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Metadata attributes of the time series that are written in each measure record.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::TimestreamDimension]> {
        self.dimensions.as_deref()
    }
    /// <p>Specifies an application-defined value to replace the default value assigned to the
    /// Timestream record's timestamp in the <code>time</code> column.</p>
    /// <p>You can use this property to specify the value and the precision of the Timestream
    /// record's timestamp. You can specify a value from the message payload or a value computed by
    /// a substitution template.</p>
    /// <p>If omitted, the topic rule action assigns the timestamp, in milliseconds, at the time it
    /// processed the rule. </p>
    pub fn timestamp(&self) -> std::option::Option<&crate::model::TimestreamTimestamp> {
        self.timestamp.as_ref()
    }
}
impl std::fmt::Debug for TimestreamAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestreamAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("timestamp", &self.timestamp);
        formatter.finish()
    }
}
/// See [`TimestreamAction`](crate::model::TimestreamAction)
pub mod timestream_action {
    /// A builder for [`TimestreamAction`](crate::model::TimestreamAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) dimensions:
            std::option::Option<std::vec::Vec<crate::model::TimestreamDimension>>,
        pub(crate) timestamp: std::option::Option<crate::model::TimestreamTimestamp>,
    }
    impl Builder {
        /// <p>The ARN of the role that grants permission to write to the
        /// Amazon Timestream database table.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants permission to write to the
        /// Amazon Timestream database table.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of an Amazon Timestream database.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon Timestream database.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the database table into which to write the measure records.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the database table into which to write the measure records.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>Metadata attributes of the time series that are written in each measure record.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::TimestreamDimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>Metadata attributes of the time series that are written in each measure record.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimestreamDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>Specifies an application-defined value to replace the default value assigned to the
        /// Timestream record's timestamp in the <code>time</code> column.</p>
        /// <p>You can use this property to specify the value and the precision of the Timestream
        /// record's timestamp. You can specify a value from the message payload or a value computed by
        /// a substitution template.</p>
        /// <p>If omitted, the topic rule action assigns the timestamp, in milliseconds, at the time it
        /// processed the rule. </p>
        pub fn timestamp(mut self, input: crate::model::TimestreamTimestamp) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Specifies an application-defined value to replace the default value assigned to the
        /// Timestream record's timestamp in the <code>time</code> column.</p>
        /// <p>You can use this property to specify the value and the precision of the Timestream
        /// record's timestamp. You can specify a value from the message payload or a value computed by
        /// a substitution template.</p>
        /// <p>If omitted, the topic rule action assigns the timestamp, in milliseconds, at the time it
        /// processed the rule. </p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<crate::model::TimestreamTimestamp>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestreamAction`](crate::model::TimestreamAction)
        pub fn build(self) -> crate::model::TimestreamAction {
            crate::model::TimestreamAction {
                role_arn: self.role_arn,
                database_name: self.database_name,
                table_name: self.table_name,
                dimensions: self.dimensions,
                timestamp: self.timestamp,
            }
        }
    }
}
impl TimestreamAction {
    /// Creates a new builder-style object to manufacture [`TimestreamAction`](crate::model::TimestreamAction)
    pub fn builder() -> crate::model::timestream_action::Builder {
        crate::model::timestream_action::Builder::default()
    }
}

/// <p>Describes how to interpret an application-defined timestamp value from an MQTT message
/// payload and the precision of that value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestreamTimestamp {
    /// <p>An expression that returns a long epoch time value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The precision of the timestamp value that results from the expression
    /// described in <code>value</code>.</p>
    /// <p>Valid values:  <code>SECONDS</code> | <code>MILLISECONDS</code> |
    /// <code>MICROSECONDS</code> | <code>NANOSECONDS</code>. The default is
    /// <code>MILLISECONDS</code>.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl TimestreamTimestamp {
    /// <p>An expression that returns a long epoch time value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The precision of the timestamp value that results from the expression
    /// described in <code>value</code>.</p>
    /// <p>Valid values:  <code>SECONDS</code> | <code>MILLISECONDS</code> |
    /// <code>MICROSECONDS</code> | <code>NANOSECONDS</code>. The default is
    /// <code>MILLISECONDS</code>.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for TimestreamTimestamp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestreamTimestamp");
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`TimestreamTimestamp`](crate::model::TimestreamTimestamp)
pub mod timestream_timestamp {
    /// A builder for [`TimestreamTimestamp`](crate::model::TimestreamTimestamp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An expression that returns a long epoch time value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>An expression that returns a long epoch time value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The precision of the timestamp value that results from the expression
        /// described in <code>value</code>.</p>
        /// <p>Valid values:  <code>SECONDS</code> | <code>MILLISECONDS</code> |
        /// <code>MICROSECONDS</code> | <code>NANOSECONDS</code>. The default is
        /// <code>MILLISECONDS</code>.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The precision of the timestamp value that results from the expression
        /// described in <code>value</code>.</p>
        /// <p>Valid values:  <code>SECONDS</code> | <code>MILLISECONDS</code> |
        /// <code>MICROSECONDS</code> | <code>NANOSECONDS</code>. The default is
        /// <code>MILLISECONDS</code>.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestreamTimestamp`](crate::model::TimestreamTimestamp)
        pub fn build(self) -> crate::model::TimestreamTimestamp {
            crate::model::TimestreamTimestamp {
                value: self.value,
                unit: self.unit,
            }
        }
    }
}
impl TimestreamTimestamp {
    /// Creates a new builder-style object to manufacture [`TimestreamTimestamp`](crate::model::TimestreamTimestamp)
    pub fn builder() -> crate::model::timestream_timestamp::Builder {
        crate::model::timestream_timestamp::Builder::default()
    }
}

/// <p>Metadata attributes of the time series that are written in each measure record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestreamDimension {
    /// <p>The metadata dimension name. This is the name of the column in the
    /// Amazon Timestream database table record.</p>
    /// <p>Dimensions cannot be named: <code>measure_name</code>,
    /// <code>measure_value</code>, or <code>time</code>.
    /// These  names are reserved. Dimension names cannot start
    /// with <code>ts_</code> or <code>measure_value</code> and
    /// they cannot contain the colon (<code>:</code>)
    /// character.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value to write in this column of the database record.</p>
    pub value: std::option::Option<std::string::String>,
}
impl TimestreamDimension {
    /// <p>The metadata dimension name. This is the name of the column in the
    /// Amazon Timestream database table record.</p>
    /// <p>Dimensions cannot be named: <code>measure_name</code>,
    /// <code>measure_value</code>, or <code>time</code>.
    /// These  names are reserved. Dimension names cannot start
    /// with <code>ts_</code> or <code>measure_value</code> and
    /// they cannot contain the colon (<code>:</code>)
    /// character.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value to write in this column of the database record.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for TimestreamDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestreamDimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`TimestreamDimension`](crate::model::TimestreamDimension)
pub mod timestream_dimension {
    /// A builder for [`TimestreamDimension`](crate::model::TimestreamDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metadata dimension name. This is the name of the column in the
        /// Amazon Timestream database table record.</p>
        /// <p>Dimensions cannot be named: <code>measure_name</code>,
        /// <code>measure_value</code>, or <code>time</code>.
        /// These  names are reserved. Dimension names cannot start
        /// with <code>ts_</code> or <code>measure_value</code> and
        /// they cannot contain the colon (<code>:</code>)
        /// character.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The metadata dimension name. This is the name of the column in the
        /// Amazon Timestream database table record.</p>
        /// <p>Dimensions cannot be named: <code>measure_name</code>,
        /// <code>measure_value</code>, or <code>time</code>.
        /// These  names are reserved. Dimension names cannot start
        /// with <code>ts_</code> or <code>measure_value</code> and
        /// they cannot contain the colon (<code>:</code>)
        /// character.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value to write in this column of the database record.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value to write in this column of the database record.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestreamDimension`](crate::model::TimestreamDimension)
        pub fn build(self) -> crate::model::TimestreamDimension {
            crate::model::TimestreamDimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl TimestreamDimension {
    /// Creates a new builder-style object to manufacture [`TimestreamDimension`](crate::model::TimestreamDimension)
    pub fn builder() -> crate::model::timestream_dimension::Builder {
        crate::model::timestream_dimension::Builder::default()
    }
}

/// <p>Starts execution of a Step Functions state machine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepFunctionsAction {
    /// <p>(Optional) A name will be given to the state machine execution consisting of this
    /// prefix followed by a UUID. Step Functions automatically creates a unique name for each state
    /// machine execution if one is not provided.</p>
    pub execution_name_prefix: std::option::Option<std::string::String>,
    /// <p>The name of the Step Functions state machine whose execution will be started.</p>
    pub state_machine_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the role that grants IoT permission to start execution of a state machine
    /// ("Action":"states:StartExecution").</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl StepFunctionsAction {
    /// <p>(Optional) A name will be given to the state machine execution consisting of this
    /// prefix followed by a UUID. Step Functions automatically creates a unique name for each state
    /// machine execution if one is not provided.</p>
    pub fn execution_name_prefix(&self) -> std::option::Option<&str> {
        self.execution_name_prefix.as_deref()
    }
    /// <p>The name of the Step Functions state machine whose execution will be started.</p>
    pub fn state_machine_name(&self) -> std::option::Option<&str> {
        self.state_machine_name.as_deref()
    }
    /// <p>The ARN of the role that grants IoT permission to start execution of a state machine
    /// ("Action":"states:StartExecution").</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for StepFunctionsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepFunctionsAction");
        formatter.field("execution_name_prefix", &self.execution_name_prefix);
        formatter.field("state_machine_name", &self.state_machine_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`StepFunctionsAction`](crate::model::StepFunctionsAction)
pub mod step_functions_action {
    /// A builder for [`StepFunctionsAction`](crate::model::StepFunctionsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_name_prefix: std::option::Option<std::string::String>,
        pub(crate) state_machine_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Optional) A name will be given to the state machine execution consisting of this
        /// prefix followed by a UUID. Step Functions automatically creates a unique name for each state
        /// machine execution if one is not provided.</p>
        pub fn execution_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_name_prefix = Some(input.into());
            self
        }
        /// <p>(Optional) A name will be given to the state machine execution consisting of this
        /// prefix followed by a UUID. Step Functions automatically creates a unique name for each state
        /// machine execution if one is not provided.</p>
        pub fn set_execution_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_name_prefix = input;
            self
        }
        /// <p>The name of the Step Functions state machine whose execution will be started.</p>
        pub fn state_machine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_machine_name = Some(input.into());
            self
        }
        /// <p>The name of the Step Functions state machine whose execution will be started.</p>
        pub fn set_state_machine_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_machine_name = input;
            self
        }
        /// <p>The ARN of the role that grants IoT permission to start execution of a state machine
        /// ("Action":"states:StartExecution").</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT permission to start execution of a state machine
        /// ("Action":"states:StartExecution").</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StepFunctionsAction`](crate::model::StepFunctionsAction)
        pub fn build(self) -> crate::model::StepFunctionsAction {
            crate::model::StepFunctionsAction {
                execution_name_prefix: self.execution_name_prefix,
                state_machine_name: self.state_machine_name,
                role_arn: self.role_arn,
            }
        }
    }
}
impl StepFunctionsAction {
    /// Creates a new builder-style object to manufacture [`StepFunctionsAction`](crate::model::StepFunctionsAction)
    pub fn builder() -> crate::model::step_functions_action::Builder {
        crate::model::step_functions_action::Builder::default()
    }
}

/// <p>Describes an action to send data from an MQTT message that triggered the rule to IoT
/// SiteWise asset properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotSiteWiseAction {
    /// <p>A list of asset property value entries.</p>
    pub put_asset_property_value_entries:
        std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
    /// <p>The ARN of the role that grants IoT permission to send an asset property value to IoT SiteWise. (<code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust
    /// policy can restrict access to specific asset hierarchy paths.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl IotSiteWiseAction {
    /// <p>A list of asset property value entries.</p>
    pub fn put_asset_property_value_entries(
        &self,
    ) -> std::option::Option<&[crate::model::PutAssetPropertyValueEntry]> {
        self.put_asset_property_value_entries.as_deref()
    }
    /// <p>The ARN of the role that grants IoT permission to send an asset property value to IoT SiteWise. (<code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust
    /// policy can restrict access to specific asset hierarchy paths.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for IotSiteWiseAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotSiteWiseAction");
        formatter.field(
            "put_asset_property_value_entries",
            &self.put_asset_property_value_entries,
        );
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
pub mod iot_site_wise_action {
    /// A builder for [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) put_asset_property_value_entries:
            std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `put_asset_property_value_entries`.
        ///
        /// To override the contents of this collection use [`set_put_asset_property_value_entries`](Self::set_put_asset_property_value_entries).
        ///
        /// <p>A list of asset property value entries.</p>
        pub fn put_asset_property_value_entries(
            mut self,
            input: impl Into<crate::model::PutAssetPropertyValueEntry>,
        ) -> Self {
            let mut v = self.put_asset_property_value_entries.unwrap_or_default();
            v.push(input.into());
            self.put_asset_property_value_entries = Some(v);
            self
        }
        /// <p>A list of asset property value entries.</p>
        pub fn set_put_asset_property_value_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutAssetPropertyValueEntry>>,
        ) -> Self {
            self.put_asset_property_value_entries = input;
            self
        }
        /// <p>The ARN of the role that grants IoT permission to send an asset property value to IoT SiteWise. (<code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust
        /// policy can restrict access to specific asset hierarchy paths.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT permission to send an asset property value to IoT SiteWise. (<code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust
        /// policy can restrict access to specific asset hierarchy paths.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
        pub fn build(self) -> crate::model::IotSiteWiseAction {
            crate::model::IotSiteWiseAction {
                put_asset_property_value_entries: self.put_asset_property_value_entries,
                role_arn: self.role_arn,
            }
        }
    }
}
impl IotSiteWiseAction {
    /// Creates a new builder-style object to manufacture [`IotSiteWiseAction`](crate::model::IotSiteWiseAction)
    pub fn builder() -> crate::model::iot_site_wise_action::Builder {
        crate::model::iot_site_wise_action::Builder::default()
    }
}

/// <p>An asset property value entry containing the following information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAssetPropertyValueEntry {
    /// <p>Optional. A unique identifier for this entry that you can define to better track which
    /// message caused an error in case of failure. Accepts substitution templates. Defaults to a new
    /// UUID.</p>
    pub entry_id: std::option::Option<std::string::String>,
    /// <p>The ID of the IoT SiteWise asset. You must specify either a <code>propertyAlias</code>
    /// or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
    /// templates.</p>
    pub asset_id: std::option::Option<std::string::String>,
    /// <p>The ID of the asset's property. You must specify either a <code>propertyAlias</code> or
    /// both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
    /// templates.</p>
    pub property_id: std::option::Option<std::string::String>,
    /// <p>The name of the property alias associated with your asset property. You must specify
    /// either a <code>propertyAlias</code> or both an <code>aliasId</code> and a
    /// <code>propertyId</code>. Accepts substitution templates.</p>
    pub property_alias: std::option::Option<std::string::String>,
    /// <p>A list of property values to insert that each contain timestamp, quality, and value (TQV)
    /// information.</p>
    pub property_values: std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
}
impl PutAssetPropertyValueEntry {
    /// <p>Optional. A unique identifier for this entry that you can define to better track which
    /// message caused an error in case of failure. Accepts substitution templates. Defaults to a new
    /// UUID.</p>
    pub fn entry_id(&self) -> std::option::Option<&str> {
        self.entry_id.as_deref()
    }
    /// <p>The ID of the IoT SiteWise asset. You must specify either a <code>propertyAlias</code>
    /// or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
    /// templates.</p>
    pub fn asset_id(&self) -> std::option::Option<&str> {
        self.asset_id.as_deref()
    }
    /// <p>The ID of the asset's property. You must specify either a <code>propertyAlias</code> or
    /// both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
    /// templates.</p>
    pub fn property_id(&self) -> std::option::Option<&str> {
        self.property_id.as_deref()
    }
    /// <p>The name of the property alias associated with your asset property. You must specify
    /// either a <code>propertyAlias</code> or both an <code>aliasId</code> and a
    /// <code>propertyId</code>. Accepts substitution templates.</p>
    pub fn property_alias(&self) -> std::option::Option<&str> {
        self.property_alias.as_deref()
    }
    /// <p>A list of property values to insert that each contain timestamp, quality, and value (TQV)
    /// information.</p>
    pub fn property_values(&self) -> std::option::Option<&[crate::model::AssetPropertyValue]> {
        self.property_values.as_deref()
    }
}
impl std::fmt::Debug for PutAssetPropertyValueEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAssetPropertyValueEntry");
        formatter.field("entry_id", &self.entry_id);
        formatter.field("asset_id", &self.asset_id);
        formatter.field("property_id", &self.property_id);
        formatter.field("property_alias", &self.property_alias);
        formatter.field("property_values", &self.property_values);
        formatter.finish()
    }
}
/// See [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
pub mod put_asset_property_value_entry {
    /// A builder for [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_id: std::option::Option<std::string::String>,
        pub(crate) asset_id: std::option::Option<std::string::String>,
        pub(crate) property_id: std::option::Option<std::string::String>,
        pub(crate) property_alias: std::option::Option<std::string::String>,
        pub(crate) property_values:
            std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
    }
    impl Builder {
        /// <p>Optional. A unique identifier for this entry that you can define to better track which
        /// message caused an error in case of failure. Accepts substitution templates. Defaults to a new
        /// UUID.</p>
        pub fn entry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry_id = Some(input.into());
            self
        }
        /// <p>Optional. A unique identifier for this entry that you can define to better track which
        /// message caused an error in case of failure. Accepts substitution templates. Defaults to a new
        /// UUID.</p>
        pub fn set_entry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry_id = input;
            self
        }
        /// <p>The ID of the IoT SiteWise asset. You must specify either a <code>propertyAlias</code>
        /// or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
        /// templates.</p>
        pub fn asset_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_id = Some(input.into());
            self
        }
        /// <p>The ID of the IoT SiteWise asset. You must specify either a <code>propertyAlias</code>
        /// or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
        /// templates.</p>
        pub fn set_asset_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_id = input;
            self
        }
        /// <p>The ID of the asset's property. You must specify either a <code>propertyAlias</code> or
        /// both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
        /// templates.</p>
        pub fn property_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_id = Some(input.into());
            self
        }
        /// <p>The ID of the asset's property. You must specify either a <code>propertyAlias</code> or
        /// both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
        /// templates.</p>
        pub fn set_property_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.property_id = input;
            self
        }
        /// <p>The name of the property alias associated with your asset property. You must specify
        /// either a <code>propertyAlias</code> or both an <code>aliasId</code> and a
        /// <code>propertyId</code>. Accepts substitution templates.</p>
        pub fn property_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.property_alias = Some(input.into());
            self
        }
        /// <p>The name of the property alias associated with your asset property. You must specify
        /// either a <code>propertyAlias</code> or both an <code>aliasId</code> and a
        /// <code>propertyId</code>. Accepts substitution templates.</p>
        pub fn set_property_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.property_alias = input;
            self
        }
        /// Appends an item to `property_values`.
        ///
        /// To override the contents of this collection use [`set_property_values`](Self::set_property_values).
        ///
        /// <p>A list of property values to insert that each contain timestamp, quality, and value (TQV)
        /// information.</p>
        pub fn property_values(
            mut self,
            input: impl Into<crate::model::AssetPropertyValue>,
        ) -> Self {
            let mut v = self.property_values.unwrap_or_default();
            v.push(input.into());
            self.property_values = Some(v);
            self
        }
        /// <p>A list of property values to insert that each contain timestamp, quality, and value (TQV)
        /// information.</p>
        pub fn set_property_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetPropertyValue>>,
        ) -> Self {
            self.property_values = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
        pub fn build(self) -> crate::model::PutAssetPropertyValueEntry {
            crate::model::PutAssetPropertyValueEntry {
                entry_id: self.entry_id,
                asset_id: self.asset_id,
                property_id: self.property_id,
                property_alias: self.property_alias,
                property_values: self.property_values,
            }
        }
    }
}
impl PutAssetPropertyValueEntry {
    /// Creates a new builder-style object to manufacture [`PutAssetPropertyValueEntry`](crate::model::PutAssetPropertyValueEntry)
    pub fn builder() -> crate::model::put_asset_property_value_entry::Builder {
        crate::model::put_asset_property_value_entry::Builder::default()
    }
}

/// <p>An asset property value entry containing the following information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetPropertyValue {
    /// <p>The value of the asset property.</p>
    pub value: std::option::Option<crate::model::AssetPropertyVariant>,
    /// <p>The asset property value timestamp.</p>
    pub timestamp: std::option::Option<crate::model::AssetPropertyTimestamp>,
    /// <p>Optional. A string that describes the quality of the value. Accepts substitution
    /// templates. Must be <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.</p>
    pub quality: std::option::Option<std::string::String>,
}
impl AssetPropertyValue {
    /// <p>The value of the asset property.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::AssetPropertyVariant> {
        self.value.as_ref()
    }
    /// <p>The asset property value timestamp.</p>
    pub fn timestamp(&self) -> std::option::Option<&crate::model::AssetPropertyTimestamp> {
        self.timestamp.as_ref()
    }
    /// <p>Optional. A string that describes the quality of the value. Accepts substitution
    /// templates. Must be <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.</p>
    pub fn quality(&self) -> std::option::Option<&str> {
        self.quality.as_deref()
    }
}
impl std::fmt::Debug for AssetPropertyValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetPropertyValue");
        formatter.field("value", &self.value);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("quality", &self.quality);
        formatter.finish()
    }
}
/// See [`AssetPropertyValue`](crate::model::AssetPropertyValue)
pub mod asset_property_value {
    /// A builder for [`AssetPropertyValue`](crate::model::AssetPropertyValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::AssetPropertyVariant>,
        pub(crate) timestamp: std::option::Option<crate::model::AssetPropertyTimestamp>,
        pub(crate) quality: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of the asset property.</p>
        pub fn value(mut self, input: crate::model::AssetPropertyVariant) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the asset property.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::AssetPropertyVariant>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>The asset property value timestamp.</p>
        pub fn timestamp(mut self, input: crate::model::AssetPropertyTimestamp) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The asset property value timestamp.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<crate::model::AssetPropertyTimestamp>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Optional. A string that describes the quality of the value. Accepts substitution
        /// templates. Must be <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.</p>
        pub fn quality(mut self, input: impl Into<std::string::String>) -> Self {
            self.quality = Some(input.into());
            self
        }
        /// <p>Optional. A string that describes the quality of the value. Accepts substitution
        /// templates. Must be <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.</p>
        pub fn set_quality(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quality = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetPropertyValue`](crate::model::AssetPropertyValue)
        pub fn build(self) -> crate::model::AssetPropertyValue {
            crate::model::AssetPropertyValue {
                value: self.value,
                timestamp: self.timestamp,
                quality: self.quality,
            }
        }
    }
}
impl AssetPropertyValue {
    /// Creates a new builder-style object to manufacture [`AssetPropertyValue`](crate::model::AssetPropertyValue)
    pub fn builder() -> crate::model::asset_property_value::Builder {
        crate::model::asset_property_value::Builder::default()
    }
}

/// <p>An asset property timestamp entry containing the following information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetPropertyTimestamp {
    /// <p>A string that contains the time in seconds since epoch. Accepts substitution
    /// templates.</p>
    pub time_in_seconds: std::option::Option<std::string::String>,
    /// <p>Optional. A string that contains the nanosecond time offset. Accepts substitution
    /// templates.</p>
    pub offset_in_nanos: std::option::Option<std::string::String>,
}
impl AssetPropertyTimestamp {
    /// <p>A string that contains the time in seconds since epoch. Accepts substitution
    /// templates.</p>
    pub fn time_in_seconds(&self) -> std::option::Option<&str> {
        self.time_in_seconds.as_deref()
    }
    /// <p>Optional. A string that contains the nanosecond time offset. Accepts substitution
    /// templates.</p>
    pub fn offset_in_nanos(&self) -> std::option::Option<&str> {
        self.offset_in_nanos.as_deref()
    }
}
impl std::fmt::Debug for AssetPropertyTimestamp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetPropertyTimestamp");
        formatter.field("time_in_seconds", &self.time_in_seconds);
        formatter.field("offset_in_nanos", &self.offset_in_nanos);
        formatter.finish()
    }
}
/// See [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
pub mod asset_property_timestamp {
    /// A builder for [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_in_seconds: std::option::Option<std::string::String>,
        pub(crate) offset_in_nanos: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string that contains the time in seconds since epoch. Accepts substitution
        /// templates.</p>
        pub fn time_in_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_in_seconds = Some(input.into());
            self
        }
        /// <p>A string that contains the time in seconds since epoch. Accepts substitution
        /// templates.</p>
        pub fn set_time_in_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_in_seconds = input;
            self
        }
        /// <p>Optional. A string that contains the nanosecond time offset. Accepts substitution
        /// templates.</p>
        pub fn offset_in_nanos(mut self, input: impl Into<std::string::String>) -> Self {
            self.offset_in_nanos = Some(input.into());
            self
        }
        /// <p>Optional. A string that contains the nanosecond time offset. Accepts substitution
        /// templates.</p>
        pub fn set_offset_in_nanos(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offset_in_nanos = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
        pub fn build(self) -> crate::model::AssetPropertyTimestamp {
            crate::model::AssetPropertyTimestamp {
                time_in_seconds: self.time_in_seconds,
                offset_in_nanos: self.offset_in_nanos,
            }
        }
    }
}
impl AssetPropertyTimestamp {
    /// Creates a new builder-style object to manufacture [`AssetPropertyTimestamp`](crate::model::AssetPropertyTimestamp)
    pub fn builder() -> crate::model::asset_property_timestamp::Builder {
        crate::model::asset_property_timestamp::Builder::default()
    }
}

/// <p>Contains an asset property value (of a single type).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AssetPropertyVariant {
    /// <p>Optional. A string that contains the boolean value (<code>true</code> or
    /// <code>false</code>) of the value entry. Accepts substitution templates.</p>
    BooleanValue(std::string::String),
    /// <p>Optional. A string that contains the double value of the value entry. Accepts substitution
    /// templates.</p>
    DoubleValue(std::string::String),
    /// <p>Optional. A string that contains the integer value of the value entry. Accepts
    /// substitution templates.</p>
    IntegerValue(std::string::String),
    /// <p>Optional. The string value of the value entry. Accepts substitution templates.</p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AssetPropertyVariant {
    /// Tries to convert the enum instance into [`BooleanValue`](crate::model::AssetPropertyVariant::BooleanValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_boolean_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AssetPropertyVariant::BooleanValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BooleanValue`](crate::model::AssetPropertyVariant::BooleanValue).
    pub fn is_boolean_value(&self) -> bool {
        self.as_boolean_value().is_ok()
    }
    /// Tries to convert the enum instance into [`DoubleValue`](crate::model::AssetPropertyVariant::DoubleValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_double_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AssetPropertyVariant::DoubleValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`DoubleValue`](crate::model::AssetPropertyVariant::DoubleValue).
    pub fn is_double_value(&self) -> bool {
        self.as_double_value().is_ok()
    }
    /// Tries to convert the enum instance into [`IntegerValue`](crate::model::AssetPropertyVariant::IntegerValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_integer_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AssetPropertyVariant::IntegerValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`IntegerValue`](crate::model::AssetPropertyVariant::IntegerValue).
    pub fn is_integer_value(&self) -> bool {
        self.as_integer_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::AssetPropertyVariant::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AssetPropertyVariant::StringValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::AssetPropertyVariant::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Sends an input to an IoT Events detector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotEventsAction {
    /// <p>The name of the IoT Events input.</p>
    pub input_name: std::option::Option<std::string::String>,
    /// <p>The ID of the message. The default <code>messageId</code> is a new UUID value.</p>
    /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
    /// <code>messageId</code>--a new UUID value will be assigned.</p>
    /// <p>Assign a value to this property to ensure that only one input (message) with a given
    /// <code>messageId</code> will be processed by an IoT Events detector.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>Whether to process the event actions as a batch. The default value is
    /// <code>false</code>.</p>
    /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
    /// <code>messageId</code>. </p>
    /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
    /// to an Array, each Array element is treated as a separate message when it's sent to IoT
    /// Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
    /// <code>BatchPutMessage</code>
    /// </a>.  The resulting array can't have more
    /// than 10 messages.</p>
    pub batch_mode: std::option::Option<bool>,
    /// <p>The ARN of the role that grants IoT permission to send an input to an IoT
    /// Events detector. ("Action":"iotevents:BatchPutMessage").</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl IotEventsAction {
    /// <p>The name of the IoT Events input.</p>
    pub fn input_name(&self) -> std::option::Option<&str> {
        self.input_name.as_deref()
    }
    /// <p>The ID of the message. The default <code>messageId</code> is a new UUID value.</p>
    /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
    /// <code>messageId</code>--a new UUID value will be assigned.</p>
    /// <p>Assign a value to this property to ensure that only one input (message) with a given
    /// <code>messageId</code> will be processed by an IoT Events detector.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>Whether to process the event actions as a batch. The default value is
    /// <code>false</code>.</p>
    /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
    /// <code>messageId</code>. </p>
    /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
    /// to an Array, each Array element is treated as a separate message when it's sent to IoT
    /// Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
    /// <code>BatchPutMessage</code>
    /// </a>.  The resulting array can't have more
    /// than 10 messages.</p>
    pub fn batch_mode(&self) -> std::option::Option<bool> {
        self.batch_mode
    }
    /// <p>The ARN of the role that grants IoT permission to send an input to an IoT
    /// Events detector. ("Action":"iotevents:BatchPutMessage").</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for IotEventsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotEventsAction");
        formatter.field("input_name", &self.input_name);
        formatter.field("message_id", &self.message_id);
        formatter.field("batch_mode", &self.batch_mode);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`IotEventsAction`](crate::model::IotEventsAction)
pub mod iot_events_action {
    /// A builder for [`IotEventsAction`](crate::model::IotEventsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_name: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) batch_mode: std::option::Option<bool>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IoT Events input.</p>
        pub fn input_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT Events input.</p>
        pub fn set_input_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_name = input;
            self
        }
        /// <p>The ID of the message. The default <code>messageId</code> is a new UUID value.</p>
        /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
        /// <code>messageId</code>--a new UUID value will be assigned.</p>
        /// <p>Assign a value to this property to ensure that only one input (message) with a given
        /// <code>messageId</code> will be processed by an IoT Events detector.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>The ID of the message. The default <code>messageId</code> is a new UUID value.</p>
        /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
        /// <code>messageId</code>--a new UUID value will be assigned.</p>
        /// <p>Assign a value to this property to ensure that only one input (message) with a given
        /// <code>messageId</code> will be processed by an IoT Events detector.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>Whether to process the event actions as a batch. The default value is
        /// <code>false</code>.</p>
        /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
        /// <code>messageId</code>. </p>
        /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
        /// to an Array, each Array element is treated as a separate message when it's sent to IoT
        /// Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
        /// <code>BatchPutMessage</code>
        /// </a>.  The resulting array can't have more
        /// than 10 messages.</p>
        pub fn batch_mode(mut self, input: bool) -> Self {
            self.batch_mode = Some(input);
            self
        }
        /// <p>Whether to process the event actions as a batch. The default value is
        /// <code>false</code>.</p>
        /// <p>When <code>batchMode</code> is <code>true</code>, you can't specify a
        /// <code>messageId</code>. </p>
        /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
        /// to an Array, each Array element is treated as a separate message when it's sent to IoT
        /// Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
        /// <code>BatchPutMessage</code>
        /// </a>.  The resulting array can't have more
        /// than 10 messages.</p>
        pub fn set_batch_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.batch_mode = input;
            self
        }
        /// <p>The ARN of the role that grants IoT permission to send an input to an IoT
        /// Events detector. ("Action":"iotevents:BatchPutMessage").</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that grants IoT permission to send an input to an IoT
        /// Events detector. ("Action":"iotevents:BatchPutMessage").</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`IotEventsAction`](crate::model::IotEventsAction)
        pub fn build(self) -> crate::model::IotEventsAction {
            crate::model::IotEventsAction {
                input_name: self.input_name,
                message_id: self.message_id,
                batch_mode: self.batch_mode,
                role_arn: self.role_arn,
            }
        }
    }
}
impl IotEventsAction {
    /// Creates a new builder-style object to manufacture [`IotEventsAction`](crate::model::IotEventsAction)
    pub fn builder() -> crate::model::iot_events_action::Builder {
        crate::model::iot_events_action::Builder::default()
    }
}

/// <p>Sends message data to an IoT Analytics channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IotAnalyticsAction {
    /// <p>(deprecated) The ARN of the IoT Analytics channel to which message data will be
    /// sent.</p>
    pub channel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the IoT Analytics channel to which message data will be sent.</p>
    pub channel_name: std::option::Option<std::string::String>,
    /// <p>Whether to process the action as a batch. The default value is
    /// <code>false</code>.</p>
    /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
    /// to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html">
    /// <code>BatchPutMessage</code>
    /// </a> to the IoT Analytics channel. The resulting array can't have more
    /// than 100 messages.</p>
    pub batch_mode: std::option::Option<bool>,
    /// <p>The ARN of the role which has a policy that grants IoT Analytics permission to send
    /// message data via IoT Analytics (iotanalytics:BatchPutMessage).</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl IotAnalyticsAction {
    /// <p>(deprecated) The ARN of the IoT Analytics channel to which message data will be
    /// sent.</p>
    pub fn channel_arn(&self) -> std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The name of the IoT Analytics channel to which message data will be sent.</p>
    pub fn channel_name(&self) -> std::option::Option<&str> {
        self.channel_name.as_deref()
    }
    /// <p>Whether to process the action as a batch. The default value is
    /// <code>false</code>.</p>
    /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
    /// to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html">
    /// <code>BatchPutMessage</code>
    /// </a> to the IoT Analytics channel. The resulting array can't have more
    /// than 100 messages.</p>
    pub fn batch_mode(&self) -> std::option::Option<bool> {
        self.batch_mode
    }
    /// <p>The ARN of the role which has a policy that grants IoT Analytics permission to send
    /// message data via IoT Analytics (iotanalytics:BatchPutMessage).</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for IotAnalyticsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IotAnalyticsAction");
        formatter.field("channel_arn", &self.channel_arn);
        formatter.field("channel_name", &self.channel_name);
        formatter.field("batch_mode", &self.batch_mode);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`IotAnalyticsAction`](crate::model::IotAnalyticsAction)
pub mod iot_analytics_action {
    /// A builder for [`IotAnalyticsAction`](crate::model::IotAnalyticsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_arn: std::option::Option<std::string::String>,
        pub(crate) channel_name: std::option::Option<std::string::String>,
        pub(crate) batch_mode: std::option::Option<bool>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(deprecated) The ARN of the IoT Analytics channel to which message data will be
        /// sent.</p>
        pub fn channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_arn = Some(input.into());
            self
        }
        /// <p>(deprecated) The ARN of the IoT Analytics channel to which message data will be
        /// sent.</p>
        pub fn set_channel_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_arn = input;
            self
        }
        /// <p>The name of the IoT Analytics channel to which message data will be sent.</p>
        pub fn channel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT Analytics channel to which message data will be sent.</p>
        pub fn set_channel_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_name = input;
            self
        }
        /// <p>Whether to process the action as a batch. The default value is
        /// <code>false</code>.</p>
        /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
        /// to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html">
        /// <code>BatchPutMessage</code>
        /// </a> to the IoT Analytics channel. The resulting array can't have more
        /// than 100 messages.</p>
        pub fn batch_mode(mut self, input: bool) -> Self {
            self.batch_mode = Some(input);
            self
        }
        /// <p>Whether to process the action as a batch. The default value is
        /// <code>false</code>.</p>
        /// <p>When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates
        /// to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html">
        /// <code>BatchPutMessage</code>
        /// </a> to the IoT Analytics channel. The resulting array can't have more
        /// than 100 messages.</p>
        pub fn set_batch_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.batch_mode = input;
            self
        }
        /// <p>The ARN of the role which has a policy that grants IoT Analytics permission to send
        /// message data via IoT Analytics (iotanalytics:BatchPutMessage).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role which has a policy that grants IoT Analytics permission to send
        /// message data via IoT Analytics (iotanalytics:BatchPutMessage).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`IotAnalyticsAction`](crate::model::IotAnalyticsAction)
        pub fn build(self) -> crate::model::IotAnalyticsAction {
            crate::model::IotAnalyticsAction {
                channel_arn: self.channel_arn,
                channel_name: self.channel_name,
                batch_mode: self.batch_mode,
                role_arn: self.role_arn,
            }
        }
    }
}
impl IotAnalyticsAction {
    /// Creates a new builder-style object to manufacture [`IotAnalyticsAction`](crate::model::IotAnalyticsAction)
    pub fn builder() -> crate::model::iot_analytics_action::Builder {
        crate::model::iot_analytics_action::Builder::default()
    }
}

/// <p>Describes an action to write a message to a Salesforce IoT Cloud Input
/// Stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceAction {
    /// <p>The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The
    /// token is available from the Salesforce IoT Cloud platform after creation of the Input
    /// Stream.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from
    /// the Salesforce IoT Cloud platform after creation of the Input Stream.</p>
    pub url: std::option::Option<std::string::String>,
}
impl SalesforceAction {
    /// <p>The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The
    /// token is available from the Salesforce IoT Cloud platform after creation of the Input
    /// Stream.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
    /// <p>The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from
    /// the Salesforce IoT Cloud platform after creation of the Input Stream.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for SalesforceAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceAction");
        formatter.field("token", &self.token);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`SalesforceAction`](crate::model::SalesforceAction)
pub mod salesforce_action {
    /// A builder for [`SalesforceAction`](crate::model::SalesforceAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The
        /// token is available from the Salesforce IoT Cloud platform after creation of the Input
        /// Stream.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The
        /// token is available from the Salesforce IoT Cloud platform after creation of the Input
        /// Stream.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from
        /// the Salesforce IoT Cloud platform after creation of the Input Stream.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from
        /// the Salesforce IoT Cloud platform after creation of the Input Stream.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceAction`](crate::model::SalesforceAction)
        pub fn build(self) -> crate::model::SalesforceAction {
            crate::model::SalesforceAction {
                token: self.token,
                url: self.url,
            }
        }
    }
}
impl SalesforceAction {
    /// Creates a new builder-style object to manufacture [`SalesforceAction`](crate::model::SalesforceAction)
    pub fn builder() -> crate::model::salesforce_action::Builder {
        crate::model::salesforce_action::Builder::default()
    }
}

/// <p>Describes an action that writes data to an Amazon OpenSearch Service
/// domain.</p>  
/// <note>
/// <p>The <code>Elasticsearch</code> action can only be used by existing rule actions. To create a
/// new rule action or to update an existing rule action, use the
/// <code>OpenSearch</code> rule action instead. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchAction {
    /// <p>The IAM role ARN that has access to OpenSearch.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint of your OpenSearch domain.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The index where you want to store your data.</p>
    pub index: std::option::Option<std::string::String>,
    /// <p>The type of document you are storing.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the document you are storing.</p>
    pub id: std::option::Option<std::string::String>,
}
impl ElasticsearchAction {
    /// <p>The IAM role ARN that has access to OpenSearch.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The endpoint of your OpenSearch domain.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The index where you want to store your data.</p>
    pub fn index(&self) -> std::option::Option<&str> {
        self.index.as_deref()
    }
    /// <p>The type of document you are storing.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The unique identifier for the document you are storing.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ElasticsearchAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("index", &self.index);
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`ElasticsearchAction`](crate::model::ElasticsearchAction)
pub mod elasticsearch_action {
    /// A builder for [`ElasticsearchAction`](crate::model::ElasticsearchAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) index: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role ARN that has access to OpenSearch.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role ARN that has access to OpenSearch.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The endpoint of your OpenSearch domain.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of your OpenSearch domain.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The index where you want to store your data.</p>
        pub fn index(mut self, input: impl Into<std::string::String>) -> Self {
            self.index = Some(input.into());
            self
        }
        /// <p>The index where you want to store your data.</p>
        pub fn set_index(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index = input;
            self
        }
        /// <p>The type of document you are storing.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of document you are storing.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The unique identifier for the document you are storing.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the document you are storing.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchAction`](crate::model::ElasticsearchAction)
        pub fn build(self) -> crate::model::ElasticsearchAction {
            crate::model::ElasticsearchAction {
                role_arn: self.role_arn,
                endpoint: self.endpoint,
                index: self.index,
                r#type: self.r#type,
                id: self.id,
            }
        }
    }
}
impl ElasticsearchAction {
    /// Creates a new builder-style object to manufacture [`ElasticsearchAction`](crate::model::ElasticsearchAction)
    pub fn builder() -> crate::model::elasticsearch_action::Builder {
        crate::model::elasticsearch_action::Builder::default()
    }
}

/// <p>Describes an action that sends data to CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudwatchLogsAction {
    /// <p>The IAM role that allows access to the CloudWatch log.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The CloudWatch log group to which the action sends data.</p>
    pub log_group_name: std::option::Option<std::string::String>,
}
impl CloudwatchLogsAction {
    /// <p>The IAM role that allows access to the CloudWatch log.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The CloudWatch log group to which the action sends data.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
}
impl std::fmt::Debug for CloudwatchLogsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudwatchLogsAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`CloudwatchLogsAction`](crate::model::CloudwatchLogsAction)
pub mod cloudwatch_logs_action {
    /// A builder for [`CloudwatchLogsAction`](crate::model::CloudwatchLogsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role that allows access to the CloudWatch log.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that allows access to the CloudWatch log.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The CloudWatch log group to which the action sends data.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The CloudWatch log group to which the action sends data.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudwatchLogsAction`](crate::model::CloudwatchLogsAction)
        pub fn build(self) -> crate::model::CloudwatchLogsAction {
            crate::model::CloudwatchLogsAction {
                role_arn: self.role_arn,
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl CloudwatchLogsAction {
    /// Creates a new builder-style object to manufacture [`CloudwatchLogsAction`](crate::model::CloudwatchLogsAction)
    pub fn builder() -> crate::model::cloudwatch_logs_action::Builder {
        crate::model::cloudwatch_logs_action::Builder::default()
    }
}

/// <p>Describes an action that updates a CloudWatch alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudwatchAlarmAction {
    /// <p>The IAM role that allows access to the CloudWatch alarm.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The CloudWatch alarm name.</p>
    pub alarm_name: std::option::Option<std::string::String>,
    /// <p>The reason for the alarm change.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The value of the alarm state. Acceptable values are: OK, ALARM,
    /// INSUFFICIENT_DATA.</p>
    pub state_value: std::option::Option<std::string::String>,
}
impl CloudwatchAlarmAction {
    /// <p>The IAM role that allows access to the CloudWatch alarm.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The CloudWatch alarm name.</p>
    pub fn alarm_name(&self) -> std::option::Option<&str> {
        self.alarm_name.as_deref()
    }
    /// <p>The reason for the alarm change.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The value of the alarm state. Acceptable values are: OK, ALARM,
    /// INSUFFICIENT_DATA.</p>
    pub fn state_value(&self) -> std::option::Option<&str> {
        self.state_value.as_deref()
    }
}
impl std::fmt::Debug for CloudwatchAlarmAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudwatchAlarmAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("alarm_name", &self.alarm_name);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_value", &self.state_value);
        formatter.finish()
    }
}
/// See [`CloudwatchAlarmAction`](crate::model::CloudwatchAlarmAction)
pub mod cloudwatch_alarm_action {
    /// A builder for [`CloudwatchAlarmAction`](crate::model::CloudwatchAlarmAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_name: std::option::Option<std::string::String>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role that allows access to the CloudWatch alarm.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that allows access to the CloudWatch alarm.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The CloudWatch alarm name.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The CloudWatch alarm name.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// <p>The reason for the alarm change.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the alarm change.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The value of the alarm state. Acceptable values are: OK, ALARM,
        /// INSUFFICIENT_DATA.</p>
        pub fn state_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_value = Some(input.into());
            self
        }
        /// <p>The value of the alarm state. Acceptable values are: OK, ALARM,
        /// INSUFFICIENT_DATA.</p>
        pub fn set_state_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudwatchAlarmAction`](crate::model::CloudwatchAlarmAction)
        pub fn build(self) -> crate::model::CloudwatchAlarmAction {
            crate::model::CloudwatchAlarmAction {
                role_arn: self.role_arn,
                alarm_name: self.alarm_name,
                state_reason: self.state_reason,
                state_value: self.state_value,
            }
        }
    }
}
impl CloudwatchAlarmAction {
    /// Creates a new builder-style object to manufacture [`CloudwatchAlarmAction`](crate::model::CloudwatchAlarmAction)
    pub fn builder() -> crate::model::cloudwatch_alarm_action::Builder {
        crate::model::cloudwatch_alarm_action::Builder::default()
    }
}

/// <p>Describes an action that captures a CloudWatch metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudwatchMetricAction {
    /// <p>The IAM role that allows access to the CloudWatch metric.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The CloudWatch metric namespace name.</p>
    pub metric_namespace: std::option::Option<std::string::String>,
    /// <p>The CloudWatch metric name.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The CloudWatch metric value.</p>
    pub metric_value: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
    /// unit</a> supported by CloudWatch.</p>
    pub metric_unit: std::option::Option<std::string::String>,
    /// <p>An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a>.</p>
    pub metric_timestamp: std::option::Option<std::string::String>,
}
impl CloudwatchMetricAction {
    /// <p>The IAM role that allows access to the CloudWatch metric.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The CloudWatch metric namespace name.</p>
    pub fn metric_namespace(&self) -> std::option::Option<&str> {
        self.metric_namespace.as_deref()
    }
    /// <p>The CloudWatch metric name.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The CloudWatch metric value.</p>
    pub fn metric_value(&self) -> std::option::Option<&str> {
        self.metric_value.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
    /// unit</a> supported by CloudWatch.</p>
    pub fn metric_unit(&self) -> std::option::Option<&str> {
        self.metric_unit.as_deref()
    }
    /// <p>An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a>.</p>
    pub fn metric_timestamp(&self) -> std::option::Option<&str> {
        self.metric_timestamp.as_deref()
    }
}
impl std::fmt::Debug for CloudwatchMetricAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudwatchMetricAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("metric_namespace", &self.metric_namespace);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_value", &self.metric_value);
        formatter.field("metric_unit", &self.metric_unit);
        formatter.field("metric_timestamp", &self.metric_timestamp);
        formatter.finish()
    }
}
/// See [`CloudwatchMetricAction`](crate::model::CloudwatchMetricAction)
pub mod cloudwatch_metric_action {
    /// A builder for [`CloudwatchMetricAction`](crate::model::CloudwatchMetricAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) metric_namespace: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_value: std::option::Option<std::string::String>,
        pub(crate) metric_unit: std::option::Option<std::string::String>,
        pub(crate) metric_timestamp: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM role that allows access to the CloudWatch metric.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that allows access to the CloudWatch metric.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The CloudWatch metric namespace name.</p>
        pub fn metric_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_namespace = Some(input.into());
            self
        }
        /// <p>The CloudWatch metric namespace name.</p>
        pub fn set_metric_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_namespace = input;
            self
        }
        /// <p>The CloudWatch metric name.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The CloudWatch metric name.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The CloudWatch metric value.</p>
        pub fn metric_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_value = Some(input.into());
            self
        }
        /// <p>The CloudWatch metric value.</p>
        pub fn set_metric_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_value = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
        /// unit</a> supported by CloudWatch.</p>
        pub fn metric_unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_unit = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
        /// unit</a> supported by CloudWatch.</p>
        pub fn set_metric_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_unit = input;
            self
        }
        /// <p>An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a>.</p>
        pub fn metric_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_timestamp = Some(input.into());
            self
        }
        /// <p>An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a>.</p>
        pub fn set_metric_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudwatchMetricAction`](crate::model::CloudwatchMetricAction)
        pub fn build(self) -> crate::model::CloudwatchMetricAction {
            crate::model::CloudwatchMetricAction {
                role_arn: self.role_arn,
                metric_namespace: self.metric_namespace,
                metric_name: self.metric_name,
                metric_value: self.metric_value,
                metric_unit: self.metric_unit,
                metric_timestamp: self.metric_timestamp,
            }
        }
    }
}
impl CloudwatchMetricAction {
    /// Creates a new builder-style object to manufacture [`CloudwatchMetricAction`](crate::model::CloudwatchMetricAction)
    pub fn builder() -> crate::model::cloudwatch_metric_action::Builder {
        crate::model::cloudwatch_metric_action::Builder::default()
    }
}

/// <p>Describes an action that writes data to an Amazon Kinesis Firehose stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirehoseAction {
    /// <p>The IAM role that grants access to the Amazon Kinesis Firehose stream.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The delivery stream name.</p>
    pub delivery_stream_name: std::option::Option<std::string::String>,
    /// <p>A character separator that will be used to separate records written to the Firehose
    /// stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ','
    /// (comma).</p>
    pub separator: std::option::Option<std::string::String>,
    /// <p>Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
    /// <code>PutRecordBatch</code>
    /// </a>.  The default value is
    /// <code>false</code>.</p>
    /// <p>When <code>batchMode</code> is <code>true</code> and the rule's SQL statement
    /// evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
    /// <code>PutRecordBatch</code>
    /// </a> request. The resulting array can't have more
    /// than 500 records.</p>
    pub batch_mode: std::option::Option<bool>,
}
impl FirehoseAction {
    /// <p>The IAM role that grants access to the Amazon Kinesis Firehose stream.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The delivery stream name.</p>
    pub fn delivery_stream_name(&self) -> std::option::Option<&str> {
        self.delivery_stream_name.as_deref()
    }
    /// <p>A character separator that will be used to separate records written to the Firehose
    /// stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ','
    /// (comma).</p>
    pub fn separator(&self) -> std::option::Option<&str> {
        self.separator.as_deref()
    }
    /// <p>Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
    /// <code>PutRecordBatch</code>
    /// </a>.  The default value is
    /// <code>false</code>.</p>
    /// <p>When <code>batchMode</code> is <code>true</code> and the rule's SQL statement
    /// evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
    /// <code>PutRecordBatch</code>
    /// </a> request. The resulting array can't have more
    /// than 500 records.</p>
    pub fn batch_mode(&self) -> std::option::Option<bool> {
        self.batch_mode
    }
}
impl std::fmt::Debug for FirehoseAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirehoseAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("delivery_stream_name", &self.delivery_stream_name);
        formatter.field("separator", &self.separator);
        formatter.field("batch_mode", &self.batch_mode);
        formatter.finish()
    }
}
/// See [`FirehoseAction`](crate::model::FirehoseAction)
pub mod firehose_action {
    /// A builder for [`FirehoseAction`](crate::model::FirehoseAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) delivery_stream_name: std::option::Option<std::string::String>,
        pub(crate) separator: std::option::Option<std::string::String>,
        pub(crate) batch_mode: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The IAM role that grants access to the Amazon Kinesis Firehose stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that grants access to the Amazon Kinesis Firehose stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The delivery stream name.</p>
        pub fn delivery_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delivery_stream_name = Some(input.into());
            self
        }
        /// <p>The delivery stream name.</p>
        pub fn set_delivery_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delivery_stream_name = input;
            self
        }
        /// <p>A character separator that will be used to separate records written to the Firehose
        /// stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ','
        /// (comma).</p>
        pub fn separator(mut self, input: impl Into<std::string::String>) -> Self {
            self.separator = Some(input.into());
            self
        }
        /// <p>A character separator that will be used to separate records written to the Firehose
        /// stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ','
        /// (comma).</p>
        pub fn set_separator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.separator = input;
            self
        }
        /// <p>Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
        /// <code>PutRecordBatch</code>
        /// </a>.  The default value is
        /// <code>false</code>.</p>
        /// <p>When <code>batchMode</code> is <code>true</code> and the rule's SQL statement
        /// evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
        /// <code>PutRecordBatch</code>
        /// </a> request. The resulting array can't have more
        /// than 500 records.</p>
        pub fn batch_mode(mut self, input: bool) -> Self {
            self.batch_mode = Some(input);
            self
        }
        /// <p>Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
        /// <code>PutRecordBatch</code>
        /// </a>.  The default value is
        /// <code>false</code>.</p>
        /// <p>When <code>batchMode</code> is <code>true</code> and the rule's SQL statement
        /// evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
        /// <code>PutRecordBatch</code>
        /// </a> request. The resulting array can't have more
        /// than 500 records.</p>
        pub fn set_batch_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.batch_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`FirehoseAction`](crate::model::FirehoseAction)
        pub fn build(self) -> crate::model::FirehoseAction {
            crate::model::FirehoseAction {
                role_arn: self.role_arn,
                delivery_stream_name: self.delivery_stream_name,
                separator: self.separator,
                batch_mode: self.batch_mode,
            }
        }
    }
}
impl FirehoseAction {
    /// Creates a new builder-style object to manufacture [`FirehoseAction`](crate::model::FirehoseAction)
    pub fn builder() -> crate::model::firehose_action::Builder {
        crate::model::firehose_action::Builder::default()
    }
}

/// <p>Describes an action to write data to an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Action {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3</a>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 canned ACL that controls access to the object identified by the object
    /// key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.</p>
    pub canned_acl: std::option::Option<crate::model::CannedAccessControlList>,
}
impl S3Action {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3</a>.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The Amazon S3 canned ACL that controls access to the object identified by the object
    /// key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.</p>
    pub fn canned_acl(&self) -> std::option::Option<&crate::model::CannedAccessControlList> {
        self.canned_acl.as_ref()
    }
}
impl std::fmt::Debug for S3Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Action");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("key", &self.key);
        formatter.field("canned_acl", &self.canned_acl);
        formatter.finish()
    }
}
/// See [`S3Action`](crate::model::S3Action)
pub mod s3_action {
    /// A builder for [`S3Action`](crate::model::S3Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) canned_acl: std::option::Option<crate::model::CannedAccessControlList>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3</a>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3</a>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The Amazon S3 canned ACL that controls access to the object identified by the object
        /// key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.</p>
        pub fn canned_acl(mut self, input: crate::model::CannedAccessControlList) -> Self {
            self.canned_acl = Some(input);
            self
        }
        /// <p>The Amazon S3 canned ACL that controls access to the object identified by the object
        /// key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.</p>
        pub fn set_canned_acl(
            mut self,
            input: std::option::Option<crate::model::CannedAccessControlList>,
        ) -> Self {
            self.canned_acl = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Action`](crate::model::S3Action)
        pub fn build(self) -> crate::model::S3Action {
            crate::model::S3Action {
                role_arn: self.role_arn,
                bucket_name: self.bucket_name,
                key: self.key,
                canned_acl: self.canned_acl,
            }
        }
    }
}
impl S3Action {
    /// Creates a new builder-style object to manufacture [`S3Action`](crate::model::S3Action)
    pub fn builder() -> crate::model::s3_action::Builder {
        crate::model::s3_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CannedAccessControlList {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    AwsExecRead,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerFullControl,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerRead,
    #[allow(missing_docs)] // documentation missing in model
    LogDeliveryWrite,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CannedAccessControlList {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => CannedAccessControlList::AuthenticatedRead,
            "aws-exec-read" => CannedAccessControlList::AwsExecRead,
            "bucket-owner-full-control" => CannedAccessControlList::BucketOwnerFullControl,
            "bucket-owner-read" => CannedAccessControlList::BucketOwnerRead,
            "log-delivery-write" => CannedAccessControlList::LogDeliveryWrite,
            "private" => CannedAccessControlList::Private,
            "public-read" => CannedAccessControlList::PublicRead,
            "public-read-write" => CannedAccessControlList::PublicReadWrite,
            other => CannedAccessControlList::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CannedAccessControlList {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CannedAccessControlList::from(s))
    }
}
impl CannedAccessControlList {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CannedAccessControlList::AuthenticatedRead => "authenticated-read",
            CannedAccessControlList::AwsExecRead => "aws-exec-read",
            CannedAccessControlList::BucketOwnerFullControl => "bucket-owner-full-control",
            CannedAccessControlList::BucketOwnerRead => "bucket-owner-read",
            CannedAccessControlList::LogDeliveryWrite => "log-delivery-write",
            CannedAccessControlList::Private => "private",
            CannedAccessControlList::PublicRead => "public-read",
            CannedAccessControlList::PublicReadWrite => "public-read-write",
            CannedAccessControlList::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "aws-exec-read",
            "bucket-owner-full-control",
            "bucket-owner-read",
            "log-delivery-write",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for CannedAccessControlList {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an action to republish to another topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepublishAction {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the MQTT topic.</p>
    pub topic: std::option::Option<std::string::String>,
    /// <p>The Quality of Service (QoS) level to use when republishing messages. The default value
    /// is 0.</p>
    pub qos: std::option::Option<i32>,
}
impl RepublishAction {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The name of the MQTT topic.</p>
    pub fn topic(&self) -> std::option::Option<&str> {
        self.topic.as_deref()
    }
    /// <p>The Quality of Service (QoS) level to use when republishing messages. The default value
    /// is 0.</p>
    pub fn qos(&self) -> std::option::Option<i32> {
        self.qos
    }
}
impl std::fmt::Debug for RepublishAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepublishAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("topic", &self.topic);
        formatter.field("qos", &self.qos);
        formatter.finish()
    }
}
/// See [`RepublishAction`](crate::model::RepublishAction)
pub mod republish_action {
    /// A builder for [`RepublishAction`](crate::model::RepublishAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) topic: std::option::Option<std::string::String>,
        pub(crate) qos: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the MQTT topic.</p>
        pub fn topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic = Some(input.into());
            self
        }
        /// <p>The name of the MQTT topic.</p>
        pub fn set_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic = input;
            self
        }
        /// <p>The Quality of Service (QoS) level to use when republishing messages. The default value
        /// is 0.</p>
        pub fn qos(mut self, input: i32) -> Self {
            self.qos = Some(input);
            self
        }
        /// <p>The Quality of Service (QoS) level to use when republishing messages. The default value
        /// is 0.</p>
        pub fn set_qos(mut self, input: std::option::Option<i32>) -> Self {
            self.qos = input;
            self
        }
        /// Consumes the builder and constructs a [`RepublishAction`](crate::model::RepublishAction)
        pub fn build(self) -> crate::model::RepublishAction {
            crate::model::RepublishAction {
                role_arn: self.role_arn,
                topic: self.topic,
                qos: self.qos,
            }
        }
    }
}
impl RepublishAction {
    /// Creates a new builder-style object to manufacture [`RepublishAction`](crate::model::RepublishAction)
    pub fn builder() -> crate::model::republish_action::Builder {
        crate::model::republish_action::Builder::default()
    }
}

/// <p>Describes an action to write data to an Amazon Kinesis stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisAction {
    /// <p>The ARN of the IAM role that grants access to the Amazon Kinesis stream.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Kinesis stream.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The partition key.</p>
    pub partition_key: std::option::Option<std::string::String>,
}
impl KinesisAction {
    /// <p>The ARN of the IAM role that grants access to the Amazon Kinesis stream.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The name of the Amazon Kinesis stream.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The partition key.</p>
    pub fn partition_key(&self) -> std::option::Option<&str> {
        self.partition_key.as_deref()
    }
}
impl std::fmt::Debug for KinesisAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("stream_name", &self.stream_name);
        formatter.field("partition_key", &self.partition_key);
        formatter.finish()
    }
}
/// See [`KinesisAction`](crate::model::KinesisAction)
pub mod kinesis_action {
    /// A builder for [`KinesisAction`](crate::model::KinesisAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) partition_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants access to the Amazon Kinesis stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access to the Amazon Kinesis stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the Amazon Kinesis stream.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Kinesis stream.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The partition key.</p>
        pub fn partition_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition_key = Some(input.into());
            self
        }
        /// <p>The partition key.</p>
        pub fn set_partition_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partition_key = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisAction`](crate::model::KinesisAction)
        pub fn build(self) -> crate::model::KinesisAction {
            crate::model::KinesisAction {
                role_arn: self.role_arn,
                stream_name: self.stream_name,
                partition_key: self.partition_key,
            }
        }
    }
}
impl KinesisAction {
    /// Creates a new builder-style object to manufacture [`KinesisAction`](crate::model::KinesisAction)
    pub fn builder() -> crate::model::kinesis_action::Builder {
        crate::model::kinesis_action::Builder::default()
    }
}

/// <p>Describes an action to publish data to an Amazon SQS queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqsAction {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The URL of the Amazon SQS queue.</p>
    pub queue_url: std::option::Option<std::string::String>,
    /// <p>Specifies whether to use Base64 encoding.</p>
    pub use_base64: std::option::Option<bool>,
}
impl SqsAction {
    /// <p>The ARN of the IAM role that grants access.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The URL of the Amazon SQS queue.</p>
    pub fn queue_url(&self) -> std::option::Option<&str> {
        self.queue_url.as_deref()
    }
    /// <p>Specifies whether to use Base64 encoding.</p>
    pub fn use_base64(&self) -> std::option::Option<bool> {
        self.use_base64
    }
}
impl std::fmt::Debug for SqsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqsAction");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("queue_url", &self.queue_url);
        formatter.field("use_base64", &self.use_base64);
        formatter.finish()
    }
}
/// See [`SqsAction`](crate::model::SqsAction)
pub mod sqs_action {
    /// A builder for [`SqsAction`](crate::model::SqsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) queue_url: std::option::Option<std::string::String>,
        pub(crate) use_base64: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The URL of the Amazon SQS queue.</p>
        pub fn queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the Amazon SQS queue.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_url = input;
            self
        }
        /// <p>Specifies whether to use Base64 encoding.</p>
        pub fn use_base64(mut self, input: bool) -> Self {
            self.use_base64 = Some(input);
            self
        }
        /// <p>Specifies whether to use Base64 encoding.</p>
        pub fn set_use_base64(mut self, input: std::option::Option<bool>) -> Self {
            self.use_base64 = input;
            self
        }
        /// Consumes the builder and constructs a [`SqsAction`](crate::model::SqsAction)
        pub fn build(self) -> crate::model::SqsAction {
            crate::model::SqsAction {
                role_arn: self.role_arn,
                queue_url: self.queue_url,
                use_base64: self.use_base64,
            }
        }
    }
}
impl SqsAction {
    /// Creates a new builder-style object to manufacture [`SqsAction`](crate::model::SqsAction)
    pub fn builder() -> crate::model::sqs_action::Builder {
        crate::model::sqs_action::Builder::default()
    }
}

/// <p>Describes an action to publish to an Amazon SNS topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsAction {
    /// <p>The ARN of the SNS topic.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that grants access.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>(Optional) The message format of the message to publish. Accepted values are "JSON"
    /// and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine
    /// if the payload should be parsed and relevant platform-specific bits of the payload should
    /// be extracted. To read more about SNS message formats, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.</p>
    pub message_format: std::option::Option<crate::model::MessageFormat>,
}
impl SnsAction {
    /// <p>The ARN of the SNS topic.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The ARN of the IAM role that grants access.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>(Optional) The message format of the message to publish. Accepted values are "JSON"
    /// and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine
    /// if the payload should be parsed and relevant platform-specific bits of the payload should
    /// be extracted. To read more about SNS message formats, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.</p>
    pub fn message_format(&self) -> std::option::Option<&crate::model::MessageFormat> {
        self.message_format.as_ref()
    }
}
impl std::fmt::Debug for SnsAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsAction");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("message_format", &self.message_format);
        formatter.finish()
    }
}
/// See [`SnsAction`](crate::model::SnsAction)
pub mod sns_action {
    /// A builder for [`SnsAction`](crate::model::SnsAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) message_format: std::option::Option<crate::model::MessageFormat>,
    }
    impl Builder {
        /// <p>The ARN of the SNS topic.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SNS topic.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>(Optional) The message format of the message to publish. Accepted values are "JSON"
        /// and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine
        /// if the payload should be parsed and relevant platform-specific bits of the payload should
        /// be extracted. To read more about SNS message formats, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.</p>
        pub fn message_format(mut self, input: crate::model::MessageFormat) -> Self {
            self.message_format = Some(input);
            self
        }
        /// <p>(Optional) The message format of the message to publish. Accepted values are "JSON"
        /// and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine
        /// if the payload should be parsed and relevant platform-specific bits of the payload should
        /// be extracted. To read more about SNS message formats, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.</p>
        pub fn set_message_format(
            mut self,
            input: std::option::Option<crate::model::MessageFormat>,
        ) -> Self {
            self.message_format = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsAction`](crate::model::SnsAction)
        pub fn build(self) -> crate::model::SnsAction {
            crate::model::SnsAction {
                target_arn: self.target_arn,
                role_arn: self.role_arn,
                message_format: self.message_format,
            }
        }
    }
}
impl SnsAction {
    /// Creates a new builder-style object to manufacture [`SnsAction`](crate::model::SnsAction)
    pub fn builder() -> crate::model::sns_action::Builder {
        crate::model::sns_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Raw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageFormat {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => MessageFormat::Json,
            "RAW" => MessageFormat::Raw,
            other => MessageFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageFormat::from(s))
    }
}
impl MessageFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageFormat::Json => "JSON",
            MessageFormat::Raw => "RAW",
            MessageFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "RAW"]
    }
}
impl AsRef<str> for MessageFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an action to invoke a Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaAction {
    /// <p>The ARN of the Lambda function.</p>
    pub function_arn: std::option::Option<std::string::String>,
}
impl LambdaAction {
    /// <p>The ARN of the Lambda function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaAction");
        formatter.field("function_arn", &self.function_arn);
        formatter.finish()
    }
}
/// See [`LambdaAction`](crate::model::LambdaAction)
pub mod lambda_action {
    /// A builder for [`LambdaAction`](crate::model::LambdaAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Lambda function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaAction`](crate::model::LambdaAction)
        pub fn build(self) -> crate::model::LambdaAction {
            crate::model::LambdaAction {
                function_arn: self.function_arn,
            }
        }
    }
}
impl LambdaAction {
    /// Creates a new builder-style object to manufacture [`LambdaAction`](crate::model::LambdaAction)
    pub fn builder() -> crate::model::lambda_action::Builder {
        crate::model::lambda_action::Builder::default()
    }
}

/// <p>Describes an action to write to a DynamoDB table.</p>
/// <p>This DynamoDB action writes each attribute in the message payload into it's own
/// column in the DynamoDB table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamoDBv2Action {
    /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the DynamoDB table to which the message data will be written. For
    /// example:</p>
    /// <p>
    /// <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName":
    /// "my-table" } } }</code>
    /// </p>
    /// <p>Each attribute in the message payload will be written to a separate column in the
    /// DynamoDB database.</p>
    pub put_item: std::option::Option<crate::model::PutItemInput>,
}
impl DynamoDBv2Action {
    /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Specifies the DynamoDB table to which the message data will be written. For
    /// example:</p>
    /// <p>
    /// <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName":
    /// "my-table" } } }</code>
    /// </p>
    /// <p>Each attribute in the message payload will be written to a separate column in the
    /// DynamoDB database.</p>
    pub fn put_item(&self) -> std::option::Option<&crate::model::PutItemInput> {
        self.put_item.as_ref()
    }
}
impl std::fmt::Debug for DynamoDBv2Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamoDBv2Action");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("put_item", &self.put_item);
        formatter.finish()
    }
}
/// See [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
pub mod dynamo_d_bv2_action {
    /// A builder for [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) put_item: std::option::Option<crate::model::PutItemInput>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Specifies the DynamoDB table to which the message data will be written. For
        /// example:</p>
        /// <p>
        /// <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName":
        /// "my-table" } } }</code>
        /// </p>
        /// <p>Each attribute in the message payload will be written to a separate column in the
        /// DynamoDB database.</p>
        pub fn put_item(mut self, input: crate::model::PutItemInput) -> Self {
            self.put_item = Some(input);
            self
        }
        /// <p>Specifies the DynamoDB table to which the message data will be written. For
        /// example:</p>
        /// <p>
        /// <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName":
        /// "my-table" } } }</code>
        /// </p>
        /// <p>Each attribute in the message payload will be written to a separate column in the
        /// DynamoDB database.</p>
        pub fn set_put_item(
            mut self,
            input: std::option::Option<crate::model::PutItemInput>,
        ) -> Self {
            self.put_item = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
        pub fn build(self) -> crate::model::DynamoDBv2Action {
            crate::model::DynamoDBv2Action {
                role_arn: self.role_arn,
                put_item: self.put_item,
            }
        }
    }
}
impl DynamoDBv2Action {
    /// Creates a new builder-style object to manufacture [`DynamoDBv2Action`](crate::model::DynamoDBv2Action)
    pub fn builder() -> crate::model::dynamo_d_bv2_action::Builder {
        crate::model::dynamo_d_bv2_action::Builder::default()
    }
}

/// <p>The input for the DynamoActionVS action that specifies the DynamoDB table to which
/// the message data will be written.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutItemInput {
    /// <p>The table where the message data will be written.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl PutItemInput {
    /// <p>The table where the message data will be written.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for PutItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutItemInput");
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}
/// See [`PutItemInput`](crate::model::PutItemInput)
pub mod put_item_input {
    /// A builder for [`PutItemInput`](crate::model::PutItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The table where the message data will be written.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The table where the message data will be written.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutItemInput`](crate::model::PutItemInput)
        pub fn build(self) -> crate::model::PutItemInput {
            crate::model::PutItemInput {
                table_name: self.table_name,
            }
        }
    }
}
impl PutItemInput {
    /// Creates a new builder-style object to manufacture [`PutItemInput`](crate::model::PutItemInput)
    pub fn builder() -> crate::model::put_item_input::Builder {
        crate::model::put_item_input::Builder::default()
    }
}

/// <p>Describes an action to write to a DynamoDB table.</p>
/// <p>The <code>tableName</code>, <code>hashKeyField</code>, and <code>rangeKeyField</code>
/// values must match the values used when you created the table.</p>
/// <p>The <code>hashKeyValue</code> and <code>rangeKeyvalue</code> fields use a
/// substitution template syntax. These templates provide data at runtime. The syntax is as
/// follows: ${<i>sql-expression</i>}.</p>
/// <p>You can specify any valid expression in a WHERE or SELECT clause, including JSON
/// properties, comparisons, calculations, and functions. For example, the following field uses
/// the third level of the topic:</p>
/// <p>
/// <code>"hashKeyValue": "${topic(3)}"</code>
/// </p>
/// <p>The following field uses the timestamp:</p>
/// <p>
/// <code>"rangeKeyValue": "${timestamp()}"</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamoDbAction {
    /// <p>The name of the DynamoDB table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The type of operation to be performed. This follows the substitution template, so it
    /// can be <code>${operation}</code>, but the substitution must result in one of the following:
    /// <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.</p>
    pub operation: std::option::Option<std::string::String>,
    /// <p>The hash key name.</p>
    pub hash_key_field: std::option::Option<std::string::String>,
    /// <p>The hash key value.</p>
    pub hash_key_value: std::option::Option<std::string::String>,
    /// <p>The hash key type. Valid values are "STRING" or "NUMBER"</p>
    pub hash_key_type: std::option::Option<crate::model::DynamoKeyType>,
    /// <p>The range key name.</p>
    pub range_key_field: std::option::Option<std::string::String>,
    /// <p>The range key value.</p>
    pub range_key_value: std::option::Option<std::string::String>,
    /// <p>The range key type. Valid values are "STRING" or "NUMBER"</p>
    pub range_key_type: std::option::Option<crate::model::DynamoKeyType>,
    /// <p>The action payload. This name can be customized.</p>
    pub payload_field: std::option::Option<std::string::String>,
}
impl DynamoDbAction {
    /// <p>The name of the DynamoDB table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The type of operation to be performed. This follows the substitution template, so it
    /// can be <code>${operation}</code>, but the substitution must result in one of the following:
    /// <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.</p>
    pub fn operation(&self) -> std::option::Option<&str> {
        self.operation.as_deref()
    }
    /// <p>The hash key name.</p>
    pub fn hash_key_field(&self) -> std::option::Option<&str> {
        self.hash_key_field.as_deref()
    }
    /// <p>The hash key value.</p>
    pub fn hash_key_value(&self) -> std::option::Option<&str> {
        self.hash_key_value.as_deref()
    }
    /// <p>The hash key type. Valid values are "STRING" or "NUMBER"</p>
    pub fn hash_key_type(&self) -> std::option::Option<&crate::model::DynamoKeyType> {
        self.hash_key_type.as_ref()
    }
    /// <p>The range key name.</p>
    pub fn range_key_field(&self) -> std::option::Option<&str> {
        self.range_key_field.as_deref()
    }
    /// <p>The range key value.</p>
    pub fn range_key_value(&self) -> std::option::Option<&str> {
        self.range_key_value.as_deref()
    }
    /// <p>The range key type. Valid values are "STRING" or "NUMBER"</p>
    pub fn range_key_type(&self) -> std::option::Option<&crate::model::DynamoKeyType> {
        self.range_key_type.as_ref()
    }
    /// <p>The action payload. This name can be customized.</p>
    pub fn payload_field(&self) -> std::option::Option<&str> {
        self.payload_field.as_deref()
    }
}
impl std::fmt::Debug for DynamoDbAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamoDbAction");
        formatter.field("table_name", &self.table_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("operation", &self.operation);
        formatter.field("hash_key_field", &self.hash_key_field);
        formatter.field("hash_key_value", &self.hash_key_value);
        formatter.field("hash_key_type", &self.hash_key_type);
        formatter.field("range_key_field", &self.range_key_field);
        formatter.field("range_key_value", &self.range_key_value);
        formatter.field("range_key_type", &self.range_key_type);
        formatter.field("payload_field", &self.payload_field);
        formatter.finish()
    }
}
/// See [`DynamoDbAction`](crate::model::DynamoDbAction)
pub mod dynamo_db_action {
    /// A builder for [`DynamoDbAction`](crate::model::DynamoDbAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<std::string::String>,
        pub(crate) hash_key_field: std::option::Option<std::string::String>,
        pub(crate) hash_key_value: std::option::Option<std::string::String>,
        pub(crate) hash_key_type: std::option::Option<crate::model::DynamoKeyType>,
        pub(crate) range_key_field: std::option::Option<std::string::String>,
        pub(crate) range_key_value: std::option::Option<std::string::String>,
        pub(crate) range_key_type: std::option::Option<crate::model::DynamoKeyType>,
        pub(crate) payload_field: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants access to the DynamoDB table.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The type of operation to be performed. This follows the substitution template, so it
        /// can be <code>${operation}</code>, but the substitution must result in one of the following:
        /// <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.</p>
        pub fn operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation = Some(input.into());
            self
        }
        /// <p>The type of operation to be performed. This follows the substitution template, so it
        /// can be <code>${operation}</code>, but the substitution must result in one of the following:
        /// <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.</p>
        pub fn set_operation(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation = input;
            self
        }
        /// <p>The hash key name.</p>
        pub fn hash_key_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash_key_field = Some(input.into());
            self
        }
        /// <p>The hash key name.</p>
        pub fn set_hash_key_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hash_key_field = input;
            self
        }
        /// <p>The hash key value.</p>
        pub fn hash_key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash_key_value = Some(input.into());
            self
        }
        /// <p>The hash key value.</p>
        pub fn set_hash_key_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hash_key_value = input;
            self
        }
        /// <p>The hash key type. Valid values are "STRING" or "NUMBER"</p>
        pub fn hash_key_type(mut self, input: crate::model::DynamoKeyType) -> Self {
            self.hash_key_type = Some(input);
            self
        }
        /// <p>The hash key type. Valid values are "STRING" or "NUMBER"</p>
        pub fn set_hash_key_type(
            mut self,
            input: std::option::Option<crate::model::DynamoKeyType>,
        ) -> Self {
            self.hash_key_type = input;
            self
        }
        /// <p>The range key name.</p>
        pub fn range_key_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.range_key_field = Some(input.into());
            self
        }
        /// <p>The range key name.</p>
        pub fn set_range_key_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.range_key_field = input;
            self
        }
        /// <p>The range key value.</p>
        pub fn range_key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.range_key_value = Some(input.into());
            self
        }
        /// <p>The range key value.</p>
        pub fn set_range_key_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.range_key_value = input;
            self
        }
        /// <p>The range key type. Valid values are "STRING" or "NUMBER"</p>
        pub fn range_key_type(mut self, input: crate::model::DynamoKeyType) -> Self {
            self.range_key_type = Some(input);
            self
        }
        /// <p>The range key type. Valid values are "STRING" or "NUMBER"</p>
        pub fn set_range_key_type(
            mut self,
            input: std::option::Option<crate::model::DynamoKeyType>,
        ) -> Self {
            self.range_key_type = input;
            self
        }
        /// <p>The action payload. This name can be customized.</p>
        pub fn payload_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_field = Some(input.into());
            self
        }
        /// <p>The action payload. This name can be customized.</p>
        pub fn set_payload_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.payload_field = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamoDbAction`](crate::model::DynamoDbAction)
        pub fn build(self) -> crate::model::DynamoDbAction {
            crate::model::DynamoDbAction {
                table_name: self.table_name,
                role_arn: self.role_arn,
                operation: self.operation,
                hash_key_field: self.hash_key_field,
                hash_key_value: self.hash_key_value,
                hash_key_type: self.hash_key_type,
                range_key_field: self.range_key_field,
                range_key_value: self.range_key_value,
                range_key_type: self.range_key_type,
                payload_field: self.payload_field,
            }
        }
    }
}
impl DynamoDbAction {
    /// Creates a new builder-style object to manufacture [`DynamoDbAction`](crate::model::DynamoDbAction)
    pub fn builder() -> crate::model::dynamo_db_action::Builder {
        crate::model::dynamo_db_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DynamoKeyType {
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DynamoKeyType {
    fn from(s: &str) -> Self {
        match s {
            "NUMBER" => DynamoKeyType::Number,
            "STRING" => DynamoKeyType::String,
            other => DynamoKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DynamoKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DynamoKeyType::from(s))
    }
}
impl DynamoKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DynamoKeyType::Number => "NUMBER",
            DynamoKeyType::String => "STRING",
            DynamoKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NUMBER", "STRING"]
    }
}
impl AsRef<str> for DynamoKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `VerificationState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VerificationState {
    #[allow(missing_docs)] // documentation missing in model
    BenignPositive,
    #[allow(missing_docs)] // documentation missing in model
    FalsePositive,
    #[allow(missing_docs)] // documentation missing in model
    TruePositive,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VerificationState {
    fn from(s: &str) -> Self {
        match s {
            "BENIGN_POSITIVE" => VerificationState::BenignPositive,
            "FALSE_POSITIVE" => VerificationState::FalsePositive,
            "TRUE_POSITIVE" => VerificationState::TruePositive,
            "UNKNOWN" => VerificationState::UnknownValue,
            other => VerificationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VerificationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VerificationState::from(s))
    }
}
impl VerificationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VerificationState::BenignPositive => "BENIGN_POSITIVE",
            VerificationState::FalsePositive => "FALSE_POSITIVE",
            VerificationState::TruePositive => "TRUE_POSITIVE",
            VerificationState::UnknownValue => "UNKNOWN",
            VerificationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BENIGN_POSITIVE",
            "FALSE_POSITIVE",
            "TRUE_POSITIVE",
            "UNKNOWN",
        ]
    }
}
impl AsRef<str> for VerificationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Device Defender security profile behavior violation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViolationEvent {
    /// <p>The ID of the violation event.</p>
    pub violation_id: std::option::Option<std::string::String>,
    /// <p>The name of the thing responsible for the violation event.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The name of the security profile whose behavior was violated.</p>
    pub security_profile_name: std::option::Option<std::string::String>,
    /// <p>The behavior that was violated.</p>
    pub behavior: std::option::Option<crate::model::Behavior>,
    /// <p>The value of the metric (the measurement).</p>
    pub metric_value: std::option::Option<crate::model::MetricValue>,
    /// <p>
    /// The details of a violation event.
    /// </p>
    pub violation_event_additional_info:
        std::option::Option<crate::model::ViolationEventAdditionalInfo>,
    /// <p>The type of violation event.</p>
    pub violation_event_type: std::option::Option<crate::model::ViolationEventType>,
    /// <p>The verification state of the violation (detect alarm).</p>
    pub verification_state: std::option::Option<crate::model::VerificationState>,
    /// <p>The description of the verification state of the violation.</p>
    pub verification_state_description: std::option::Option<std::string::String>,
    /// <p>The time the violation event occurred.</p>
    pub violation_event_time: std::option::Option<aws_smithy_types::Instant>,
}
impl ViolationEvent {
    /// <p>The ID of the violation event.</p>
    pub fn violation_id(&self) -> std::option::Option<&str> {
        self.violation_id.as_deref()
    }
    /// <p>The name of the thing responsible for the violation event.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The name of the security profile whose behavior was violated.</p>
    pub fn security_profile_name(&self) -> std::option::Option<&str> {
        self.security_profile_name.as_deref()
    }
    /// <p>The behavior that was violated.</p>
    pub fn behavior(&self) -> std::option::Option<&crate::model::Behavior> {
        self.behavior.as_ref()
    }
    /// <p>The value of the metric (the measurement).</p>
    pub fn metric_value(&self) -> std::option::Option<&crate::model::MetricValue> {
        self.metric_value.as_ref()
    }
    /// <p>
    /// The details of a violation event.
    /// </p>
    pub fn violation_event_additional_info(
        &self,
    ) -> std::option::Option<&crate::model::ViolationEventAdditionalInfo> {
        self.violation_event_additional_info.as_ref()
    }
    /// <p>The type of violation event.</p>
    pub fn violation_event_type(&self) -> std::option::Option<&crate::model::ViolationEventType> {
        self.violation_event_type.as_ref()
    }
    /// <p>The verification state of the violation (detect alarm).</p>
    pub fn verification_state(&self) -> std::option::Option<&crate::model::VerificationState> {
        self.verification_state.as_ref()
    }
    /// <p>The description of the verification state of the violation.</p>
    pub fn verification_state_description(&self) -> std::option::Option<&str> {
        self.verification_state_description.as_deref()
    }
    /// <p>The time the violation event occurred.</p>
    pub fn violation_event_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.violation_event_time.as_ref()
    }
}
impl std::fmt::Debug for ViolationEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViolationEvent");
        formatter.field("violation_id", &self.violation_id);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("security_profile_name", &self.security_profile_name);
        formatter.field("behavior", &self.behavior);
        formatter.field("metric_value", &self.metric_value);
        formatter.field(
            "violation_event_additional_info",
            &self.violation_event_additional_info,
        );
        formatter.field("violation_event_type", &self.violation_event_type);
        formatter.field("verification_state", &self.verification_state);
        formatter.field(
            "verification_state_description",
            &self.verification_state_description,
        );
        formatter.field("violation_event_time", &self.violation_event_time);
        formatter.finish()
    }
}
/// See [`ViolationEvent`](crate::model::ViolationEvent)
pub mod violation_event {
    /// A builder for [`ViolationEvent`](crate::model::ViolationEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) behavior: std::option::Option<crate::model::Behavior>,
        pub(crate) metric_value: std::option::Option<crate::model::MetricValue>,
        pub(crate) violation_event_additional_info:
            std::option::Option<crate::model::ViolationEventAdditionalInfo>,
        pub(crate) violation_event_type: std::option::Option<crate::model::ViolationEventType>,
        pub(crate) verification_state: std::option::Option<crate::model::VerificationState>,
        pub(crate) verification_state_description: std::option::Option<std::string::String>,
        pub(crate) violation_event_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the violation event.</p>
        pub fn violation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_id = Some(input.into());
            self
        }
        /// <p>The ID of the violation event.</p>
        pub fn set_violation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.violation_id = input;
            self
        }
        /// <p>The name of the thing responsible for the violation event.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing responsible for the violation event.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The name of the security profile whose behavior was violated.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the security profile whose behavior was violated.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The behavior that was violated.</p>
        pub fn behavior(mut self, input: crate::model::Behavior) -> Self {
            self.behavior = Some(input);
            self
        }
        /// <p>The behavior that was violated.</p>
        pub fn set_behavior(mut self, input: std::option::Option<crate::model::Behavior>) -> Self {
            self.behavior = input;
            self
        }
        /// <p>The value of the metric (the measurement).</p>
        pub fn metric_value(mut self, input: crate::model::MetricValue) -> Self {
            self.metric_value = Some(input);
            self
        }
        /// <p>The value of the metric (the measurement).</p>
        pub fn set_metric_value(
            mut self,
            input: std::option::Option<crate::model::MetricValue>,
        ) -> Self {
            self.metric_value = input;
            self
        }
        /// <p>
        /// The details of a violation event.
        /// </p>
        pub fn violation_event_additional_info(
            mut self,
            input: crate::model::ViolationEventAdditionalInfo,
        ) -> Self {
            self.violation_event_additional_info = Some(input);
            self
        }
        /// <p>
        /// The details of a violation event.
        /// </p>
        pub fn set_violation_event_additional_info(
            mut self,
            input: std::option::Option<crate::model::ViolationEventAdditionalInfo>,
        ) -> Self {
            self.violation_event_additional_info = input;
            self
        }
        /// <p>The type of violation event.</p>
        pub fn violation_event_type(mut self, input: crate::model::ViolationEventType) -> Self {
            self.violation_event_type = Some(input);
            self
        }
        /// <p>The type of violation event.</p>
        pub fn set_violation_event_type(
            mut self,
            input: std::option::Option<crate::model::ViolationEventType>,
        ) -> Self {
            self.violation_event_type = input;
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.verification_state = Some(input);
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.verification_state = input;
            self
        }
        /// <p>The description of the verification state of the violation.</p>
        pub fn verification_state_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.verification_state_description = Some(input.into());
            self
        }
        /// <p>The description of the verification state of the violation.</p>
        pub fn set_verification_state_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verification_state_description = input;
            self
        }
        /// <p>The time the violation event occurred.</p>
        pub fn violation_event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.violation_event_time = Some(input);
            self
        }
        /// <p>The time the violation event occurred.</p>
        pub fn set_violation_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.violation_event_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ViolationEvent`](crate::model::ViolationEvent)
        pub fn build(self) -> crate::model::ViolationEvent {
            crate::model::ViolationEvent {
                violation_id: self.violation_id,
                thing_name: self.thing_name,
                security_profile_name: self.security_profile_name,
                behavior: self.behavior,
                metric_value: self.metric_value,
                violation_event_additional_info: self.violation_event_additional_info,
                violation_event_type: self.violation_event_type,
                verification_state: self.verification_state,
                verification_state_description: self.verification_state_description,
                violation_event_time: self.violation_event_time,
            }
        }
    }
}
impl ViolationEvent {
    /// Creates a new builder-style object to manufacture [`ViolationEvent`](crate::model::ViolationEvent)
    pub fn builder() -> crate::model::violation_event::Builder {
        crate::model::violation_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ViolationEventType {
    #[allow(missing_docs)] // documentation missing in model
    AlarmCleared,
    #[allow(missing_docs)] // documentation missing in model
    AlarmInvalidated,
    #[allow(missing_docs)] // documentation missing in model
    InAlarm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ViolationEventType {
    fn from(s: &str) -> Self {
        match s {
            "alarm-cleared" => ViolationEventType::AlarmCleared,
            "alarm-invalidated" => ViolationEventType::AlarmInvalidated,
            "in-alarm" => ViolationEventType::InAlarm,
            other => ViolationEventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ViolationEventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ViolationEventType::from(s))
    }
}
impl ViolationEventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ViolationEventType::AlarmCleared => "alarm-cleared",
            ViolationEventType::AlarmInvalidated => "alarm-invalidated",
            ViolationEventType::InAlarm => "in-alarm",
            ViolationEventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["alarm-cleared", "alarm-invalidated", "in-alarm"]
    }
}
impl AsRef<str> for ViolationEventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// The details of a violation event.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViolationEventAdditionalInfo {
    /// <p>
    /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
    /// </p>
    pub confidence_level: std::option::Option<crate::model::ConfidenceLevel>,
}
impl ViolationEventAdditionalInfo {
    /// <p>
    /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
    /// </p>
    pub fn confidence_level(&self) -> std::option::Option<&crate::model::ConfidenceLevel> {
        self.confidence_level.as_ref()
    }
}
impl std::fmt::Debug for ViolationEventAdditionalInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViolationEventAdditionalInfo");
        formatter.field("confidence_level", &self.confidence_level);
        formatter.finish()
    }
}
/// See [`ViolationEventAdditionalInfo`](crate::model::ViolationEventAdditionalInfo)
pub mod violation_event_additional_info {
    /// A builder for [`ViolationEventAdditionalInfo`](crate::model::ViolationEventAdditionalInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confidence_level: std::option::Option<crate::model::ConfidenceLevel>,
    }
    impl Builder {
        /// <p>
        /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
        /// </p>
        pub fn confidence_level(mut self, input: crate::model::ConfidenceLevel) -> Self {
            self.confidence_level = Some(input);
            self
        }
        /// <p>
        /// The sensitivity of anomalous behavior evaluation. Can be <code>Low</code>, <code>Medium</code>, or <code>High</code>.
        /// </p>
        pub fn set_confidence_level(
            mut self,
            input: std::option::Option<crate::model::ConfidenceLevel>,
        ) -> Self {
            self.confidence_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ViolationEventAdditionalInfo`](crate::model::ViolationEventAdditionalInfo)
        pub fn build(self) -> crate::model::ViolationEventAdditionalInfo {
            crate::model::ViolationEventAdditionalInfo {
                confidence_level: self.confidence_level,
            }
        }
    }
}
impl ViolationEventAdditionalInfo {
    /// Creates a new builder-style object to manufacture [`ViolationEventAdditionalInfo`](crate::model::ViolationEventAdditionalInfo)
    pub fn builder() -> crate::model::violation_event_additional_info::Builder {
        crate::model::violation_event_additional_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BehaviorCriteriaType {
    #[allow(missing_docs)] // documentation missing in model
    MachineLearning,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    #[allow(missing_docs)] // documentation missing in model
    Statistical,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BehaviorCriteriaType {
    fn from(s: &str) -> Self {
        match s {
            "MACHINE_LEARNING" => BehaviorCriteriaType::MachineLearning,
            "STATIC" => BehaviorCriteriaType::Static,
            "STATISTICAL" => BehaviorCriteriaType::Statistical,
            other => BehaviorCriteriaType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BehaviorCriteriaType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BehaviorCriteriaType::from(s))
    }
}
impl BehaviorCriteriaType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BehaviorCriteriaType::MachineLearning => "MACHINE_LEARNING",
            BehaviorCriteriaType::Static => "STATIC",
            BehaviorCriteriaType::Statistical => "STATISTICAL",
            BehaviorCriteriaType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MACHINE_LEARNING", "STATIC", "STATISTICAL"]
    }
}
impl AsRef<str> for BehaviorCriteriaType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The target configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogTargetConfiguration {
    /// <p>A log target</p>
    pub log_target: std::option::Option<crate::model::LogTarget>,
    /// <p>The logging level.</p>
    pub log_level: std::option::Option<crate::model::LogLevel>,
}
impl LogTargetConfiguration {
    /// <p>A log target</p>
    pub fn log_target(&self) -> std::option::Option<&crate::model::LogTarget> {
        self.log_target.as_ref()
    }
    /// <p>The logging level.</p>
    pub fn log_level(&self) -> std::option::Option<&crate::model::LogLevel> {
        self.log_level.as_ref()
    }
}
impl std::fmt::Debug for LogTargetConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogTargetConfiguration");
        formatter.field("log_target", &self.log_target);
        formatter.field("log_level", &self.log_level);
        formatter.finish()
    }
}
/// See [`LogTargetConfiguration`](crate::model::LogTargetConfiguration)
pub mod log_target_configuration {
    /// A builder for [`LogTargetConfiguration`](crate::model::LogTargetConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_target: std::option::Option<crate::model::LogTarget>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
    }
    impl Builder {
        /// <p>A log target</p>
        pub fn log_target(mut self, input: crate::model::LogTarget) -> Self {
            self.log_target = Some(input);
            self
        }
        /// <p>A log target</p>
        pub fn set_log_target(
            mut self,
            input: std::option::Option<crate::model::LogTarget>,
        ) -> Self {
            self.log_target = input;
            self
        }
        /// <p>The logging level.</p>
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// <p>The logging level.</p>
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// Consumes the builder and constructs a [`LogTargetConfiguration`](crate::model::LogTargetConfiguration)
        pub fn build(self) -> crate::model::LogTargetConfiguration {
            crate::model::LogTargetConfiguration {
                log_target: self.log_target,
                log_level: self.log_level,
            }
        }
    }
}
impl LogTargetConfiguration {
    /// Creates a new builder-style object to manufacture [`LogTargetConfiguration`](crate::model::LogTargetConfiguration)
    pub fn builder() -> crate::model::log_target_configuration::Builder {
        crate::model::log_target_configuration::Builder::default()
    }
}

/// <p>Describes a rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicRuleListItem {
    /// <p>The rule ARN.</p>
    pub rule_arn: std::option::Option<std::string::String>,
    /// <p>The name of the rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The pattern for the topic names that apply.</p>
    pub topic_pattern: std::option::Option<std::string::String>,
    /// <p>The date and time the rule was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies whether the rule is disabled.</p>
    pub rule_disabled: std::option::Option<bool>,
}
impl TopicRuleListItem {
    /// <p>The rule ARN.</p>
    pub fn rule_arn(&self) -> std::option::Option<&str> {
        self.rule_arn.as_deref()
    }
    /// <p>The name of the rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The pattern for the topic names that apply.</p>
    pub fn topic_pattern(&self) -> std::option::Option<&str> {
        self.topic_pattern.as_deref()
    }
    /// <p>The date and time the rule was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>Specifies whether the rule is disabled.</p>
    pub fn rule_disabled(&self) -> std::option::Option<bool> {
        self.rule_disabled
    }
}
impl std::fmt::Debug for TopicRuleListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicRuleListItem");
        formatter.field("rule_arn", &self.rule_arn);
        formatter.field("rule_name", &self.rule_name);
        formatter.field("topic_pattern", &self.topic_pattern);
        formatter.field("created_at", &self.created_at);
        formatter.field("rule_disabled", &self.rule_disabled);
        formatter.finish()
    }
}
/// See [`TopicRuleListItem`](crate::model::TopicRuleListItem)
pub mod topic_rule_list_item {
    /// A builder for [`TopicRuleListItem`](crate::model::TopicRuleListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_arn: std::option::Option<std::string::String>,
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) topic_pattern: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) rule_disabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The rule ARN.</p>
        pub fn rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_arn = Some(input.into());
            self
        }
        /// <p>The rule ARN.</p>
        pub fn set_rule_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_arn = input;
            self
        }
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The pattern for the topic names that apply.</p>
        pub fn topic_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_pattern = Some(input.into());
            self
        }
        /// <p>The pattern for the topic names that apply.</p>
        pub fn set_topic_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.topic_pattern = input;
            self
        }
        /// <p>The date and time the rule was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time the rule was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn rule_disabled(mut self, input: bool) -> Self {
            self.rule_disabled = Some(input);
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn set_rule_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.rule_disabled = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicRuleListItem`](crate::model::TopicRuleListItem)
        pub fn build(self) -> crate::model::TopicRuleListItem {
            crate::model::TopicRuleListItem {
                rule_arn: self.rule_arn,
                rule_name: self.rule_name,
                topic_pattern: self.topic_pattern,
                created_at: self.created_at,
                rule_disabled: self.rule_disabled,
            }
        }
    }
}
impl TopicRuleListItem {
    /// Creates a new builder-style object to manufacture [`TopicRuleListItem`](crate::model::TopicRuleListItem)
    pub fn builder() -> crate::model::topic_rule_list_item::Builder {
        crate::model::topic_rule_list_item::Builder::default()
    }
}

/// <p>Information about the topic rule destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicRuleDestinationSummary {
    /// <p>The topic rule destination ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the topic rule destination. Valid values are:</p>
    /// <dl>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>A topic rule destination was created but has not been confirmed. You can set
    /// <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// <dt>ENABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
    /// set <code>status</code> to <code>DISABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>DISABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
    /// can set <code>status</code> to <code>ENABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>ERROR</dt>
    /// <dd>
    /// <p>Confirmation could not be completed, for example if the confirmation timed out.
    /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
    /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::TopicRuleDestinationStatus>,
    /// <p>The date and time when the topic rule destination was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the topic rule destination was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The reason the topic rule destination is in the current status.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Information about the HTTP URL.</p>
    pub http_url_summary: std::option::Option<crate::model::HttpUrlDestinationSummary>,
    /// <p>Information about the virtual private cloud (VPC) connection.</p>
    pub vpc_destination_summary: std::option::Option<crate::model::VpcDestinationSummary>,
}
impl TopicRuleDestinationSummary {
    /// <p>The topic rule destination ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the topic rule destination. Valid values are:</p>
    /// <dl>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>A topic rule destination was created but has not been confirmed. You can set
    /// <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// <dt>ENABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
    /// set <code>status</code> to <code>DISABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>DISABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
    /// can set <code>status</code> to <code>ENABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>ERROR</dt>
    /// <dd>
    /// <p>Confirmation could not be completed, for example if the confirmation timed out.
    /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
    /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::TopicRuleDestinationStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time when the topic rule destination was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The date and time when the topic rule destination was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The reason the topic rule destination is in the current status.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>Information about the HTTP URL.</p>
    pub fn http_url_summary(
        &self,
    ) -> std::option::Option<&crate::model::HttpUrlDestinationSummary> {
        self.http_url_summary.as_ref()
    }
    /// <p>Information about the virtual private cloud (VPC) connection.</p>
    pub fn vpc_destination_summary(
        &self,
    ) -> std::option::Option<&crate::model::VpcDestinationSummary> {
        self.vpc_destination_summary.as_ref()
    }
}
impl std::fmt::Debug for TopicRuleDestinationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicRuleDestinationSummary");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("http_url_summary", &self.http_url_summary);
        formatter.field("vpc_destination_summary", &self.vpc_destination_summary);
        formatter.finish()
    }
}
/// See [`TopicRuleDestinationSummary`](crate::model::TopicRuleDestinationSummary)
pub mod topic_rule_destination_summary {
    /// A builder for [`TopicRuleDestinationSummary`](crate::model::TopicRuleDestinationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TopicRuleDestinationStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) http_url_summary: std::option::Option<crate::model::HttpUrlDestinationSummary>,
        pub(crate) vpc_destination_summary:
            std::option::Option<crate::model::VpcDestinationSummary>,
    }
    impl Builder {
        /// <p>The topic rule destination ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The topic rule destination ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the topic rule destination. Valid values are:</p>
        /// <dl>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>A topic rule destination was created but has not been confirmed. You can set
        /// <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// <dt>ENABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
        /// set <code>status</code> to <code>DISABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>DISABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
        /// can set <code>status</code> to <code>ENABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>ERROR</dt>
        /// <dd>
        /// <p>Confirmation could not be completed, for example if the confirmation timed out.
        /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
        /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::TopicRuleDestinationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the topic rule destination. Valid values are:</p>
        /// <dl>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>A topic rule destination was created but has not been confirmed. You can set
        /// <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// <dt>ENABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
        /// set <code>status</code> to <code>DISABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>DISABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
        /// can set <code>status</code> to <code>ENABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>ERROR</dt>
        /// <dd>
        /// <p>Confirmation could not be completed, for example if the confirmation timed out.
        /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
        /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TopicRuleDestinationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the topic rule destination was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time when the topic rule destination was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time when the topic rule destination was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The date and time when the topic rule destination was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The reason the topic rule destination is in the current status.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason the topic rule destination is in the current status.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Information about the HTTP URL.</p>
        pub fn http_url_summary(mut self, input: crate::model::HttpUrlDestinationSummary) -> Self {
            self.http_url_summary = Some(input);
            self
        }
        /// <p>Information about the HTTP URL.</p>
        pub fn set_http_url_summary(
            mut self,
            input: std::option::Option<crate::model::HttpUrlDestinationSummary>,
        ) -> Self {
            self.http_url_summary = input;
            self
        }
        /// <p>Information about the virtual private cloud (VPC) connection.</p>
        pub fn vpc_destination_summary(
            mut self,
            input: crate::model::VpcDestinationSummary,
        ) -> Self {
            self.vpc_destination_summary = Some(input);
            self
        }
        /// <p>Information about the virtual private cloud (VPC) connection.</p>
        pub fn set_vpc_destination_summary(
            mut self,
            input: std::option::Option<crate::model::VpcDestinationSummary>,
        ) -> Self {
            self.vpc_destination_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicRuleDestinationSummary`](crate::model::TopicRuleDestinationSummary)
        pub fn build(self) -> crate::model::TopicRuleDestinationSummary {
            crate::model::TopicRuleDestinationSummary {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                status_reason: self.status_reason,
                http_url_summary: self.http_url_summary,
                vpc_destination_summary: self.vpc_destination_summary,
            }
        }
    }
}
impl TopicRuleDestinationSummary {
    /// Creates a new builder-style object to manufacture [`TopicRuleDestinationSummary`](crate::model::TopicRuleDestinationSummary)
    pub fn builder() -> crate::model::topic_rule_destination_summary::Builder {
        crate::model::topic_rule_destination_summary::Builder::default()
    }
}

/// <p>The summary of a virtual private cloud (VPC) destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcDestinationSummary {
    /// <p>The subnet IDs of the VPC destination.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The security groups of the VPC destination.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl VpcDestinationSummary {
    /// <p>The subnet IDs of the VPC destination.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The security groups of the VPC destination.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The ID of the VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for VpcDestinationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcDestinationSummary");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`VpcDestinationSummary`](crate::model::VpcDestinationSummary)
pub mod vpc_destination_summary {
    /// A builder for [`VpcDestinationSummary`](crate::model::VpcDestinationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnet IDs of the VPC destination.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnet IDs of the VPC destination.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups of the VPC destination.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups of the VPC destination.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcDestinationSummary`](crate::model::VpcDestinationSummary)
        pub fn build(self) -> crate::model::VpcDestinationSummary {
            crate::model::VpcDestinationSummary {
                subnet_ids: self.subnet_ids,
                security_groups: self.security_groups,
                vpc_id: self.vpc_id,
                role_arn: self.role_arn,
            }
        }
    }
}
impl VpcDestinationSummary {
    /// Creates a new builder-style object to manufacture [`VpcDestinationSummary`](crate::model::VpcDestinationSummary)
    pub fn builder() -> crate::model::vpc_destination_summary::Builder {
        crate::model::vpc_destination_summary::Builder::default()
    }
}

/// <p>Information about an HTTP URL destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpUrlDestinationSummary {
    /// <p>The URL used to confirm ownership of or access to the HTTP topic rule destination
    /// URL.</p>
    pub confirmation_url: std::option::Option<std::string::String>,
}
impl HttpUrlDestinationSummary {
    /// <p>The URL used to confirm ownership of or access to the HTTP topic rule destination
    /// URL.</p>
    pub fn confirmation_url(&self) -> std::option::Option<&str> {
        self.confirmation_url.as_deref()
    }
}
impl std::fmt::Debug for HttpUrlDestinationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpUrlDestinationSummary");
        formatter.field("confirmation_url", &self.confirmation_url);
        formatter.finish()
    }
}
/// See [`HttpUrlDestinationSummary`](crate::model::HttpUrlDestinationSummary)
pub mod http_url_destination_summary {
    /// A builder for [`HttpUrlDestinationSummary`](crate::model::HttpUrlDestinationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confirmation_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL used to confirm ownership of or access to the HTTP topic rule destination
        /// URL.</p>
        pub fn confirmation_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.confirmation_url = Some(input.into());
            self
        }
        /// <p>The URL used to confirm ownership of or access to the HTTP topic rule destination
        /// URL.</p>
        pub fn set_confirmation_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.confirmation_url = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpUrlDestinationSummary`](crate::model::HttpUrlDestinationSummary)
        pub fn build(self) -> crate::model::HttpUrlDestinationSummary {
            crate::model::HttpUrlDestinationSummary {
                confirmation_url: self.confirmation_url,
            }
        }
    }
}
impl HttpUrlDestinationSummary {
    /// Creates a new builder-style object to manufacture [`HttpUrlDestinationSummary`](crate::model::HttpUrlDestinationSummary)
    pub fn builder() -> crate::model::http_url_destination_summary::Builder {
        crate::model::http_url_destination_summary::Builder::default()
    }
}

/// <p>The definition of the thing type, including thing type name and description.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingTypeDefinition {
    /// <p>The name of the thing type.</p>
    pub thing_type_name: std::option::Option<std::string::String>,
    /// <p>The thing type ARN.</p>
    pub thing_type_arn: std::option::Option<std::string::String>,
    /// <p>The ThingTypeProperties for the thing type.</p>
    pub thing_type_properties: std::option::Option<crate::model::ThingTypeProperties>,
    /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and
    /// time, a value indicating whether the thing type is deprecated, and a date and time when it was
    /// deprecated.</p>
    pub thing_type_metadata: std::option::Option<crate::model::ThingTypeMetadata>,
}
impl ThingTypeDefinition {
    /// <p>The name of the thing type.</p>
    pub fn thing_type_name(&self) -> std::option::Option<&str> {
        self.thing_type_name.as_deref()
    }
    /// <p>The thing type ARN.</p>
    pub fn thing_type_arn(&self) -> std::option::Option<&str> {
        self.thing_type_arn.as_deref()
    }
    /// <p>The ThingTypeProperties for the thing type.</p>
    pub fn thing_type_properties(&self) -> std::option::Option<&crate::model::ThingTypeProperties> {
        self.thing_type_properties.as_ref()
    }
    /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and
    /// time, a value indicating whether the thing type is deprecated, and a date and time when it was
    /// deprecated.</p>
    pub fn thing_type_metadata(&self) -> std::option::Option<&crate::model::ThingTypeMetadata> {
        self.thing_type_metadata.as_ref()
    }
}
impl std::fmt::Debug for ThingTypeDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingTypeDefinition");
        formatter.field("thing_type_name", &self.thing_type_name);
        formatter.field("thing_type_arn", &self.thing_type_arn);
        formatter.field("thing_type_properties", &self.thing_type_properties);
        formatter.field("thing_type_metadata", &self.thing_type_metadata);
        formatter.finish()
    }
}
/// See [`ThingTypeDefinition`](crate::model::ThingTypeDefinition)
pub mod thing_type_definition {
    /// A builder for [`ThingTypeDefinition`](crate::model::ThingTypeDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) thing_type_arn: std::option::Option<std::string::String>,
        pub(crate) thing_type_properties: std::option::Option<crate::model::ThingTypeProperties>,
        pub(crate) thing_type_metadata: std::option::Option<crate::model::ThingTypeMetadata>,
    }
    impl Builder {
        /// <p>The name of the thing type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// <p>The thing type ARN.</p>
        pub fn thing_type_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_arn = Some(input.into());
            self
        }
        /// <p>The thing type ARN.</p>
        pub fn set_thing_type_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_arn = input;
            self
        }
        /// <p>The ThingTypeProperties for the thing type.</p>
        pub fn thing_type_properties(mut self, input: crate::model::ThingTypeProperties) -> Self {
            self.thing_type_properties = Some(input);
            self
        }
        /// <p>The ThingTypeProperties for the thing type.</p>
        pub fn set_thing_type_properties(
            mut self,
            input: std::option::Option<crate::model::ThingTypeProperties>,
        ) -> Self {
            self.thing_type_properties = input;
            self
        }
        /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and
        /// time, a value indicating whether the thing type is deprecated, and a date and time when it was
        /// deprecated.</p>
        pub fn thing_type_metadata(mut self, input: crate::model::ThingTypeMetadata) -> Self {
            self.thing_type_metadata = Some(input);
            self
        }
        /// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and
        /// time, a value indicating whether the thing type is deprecated, and a date and time when it was
        /// deprecated.</p>
        pub fn set_thing_type_metadata(
            mut self,
            input: std::option::Option<crate::model::ThingTypeMetadata>,
        ) -> Self {
            self.thing_type_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingTypeDefinition`](crate::model::ThingTypeDefinition)
        pub fn build(self) -> crate::model::ThingTypeDefinition {
            crate::model::ThingTypeDefinition {
                thing_type_name: self.thing_type_name,
                thing_type_arn: self.thing_type_arn,
                thing_type_properties: self.thing_type_properties,
                thing_type_metadata: self.thing_type_metadata,
            }
        }
    }
}
impl ThingTypeDefinition {
    /// Creates a new builder-style object to manufacture [`ThingTypeDefinition`](crate::model::ThingTypeDefinition)
    pub fn builder() -> crate::model::thing_type_definition::Builder {
        crate::model::thing_type_definition::Builder::default()
    }
}

/// <p>The ThingTypeMetadata contains additional information about the thing type including: creation date and
/// time, a value indicating whether the thing type is deprecated, and a date and time when time was
/// deprecated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingTypeMetadata {
    /// <p>Whether the thing type is deprecated. If <b>true</b>, no new things could be
    /// associated with this type.</p>
    pub deprecated: bool,
    /// <p>The date and time when the thing type was deprecated.</p>
    pub deprecation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the thing type was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl ThingTypeMetadata {
    /// <p>Whether the thing type is deprecated. If <b>true</b>, no new things could be
    /// associated with this type.</p>
    pub fn deprecated(&self) -> bool {
        self.deprecated
    }
    /// <p>The date and time when the thing type was deprecated.</p>
    pub fn deprecation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.deprecation_date.as_ref()
    }
    /// <p>The date and time when the thing type was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for ThingTypeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingTypeMetadata");
        formatter.field("deprecated", &self.deprecated);
        formatter.field("deprecation_date", &self.deprecation_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`ThingTypeMetadata`](crate::model::ThingTypeMetadata)
pub mod thing_type_metadata {
    /// A builder for [`ThingTypeMetadata`](crate::model::ThingTypeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deprecated: std::option::Option<bool>,
        pub(crate) deprecation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Whether the thing type is deprecated. If <b>true</b>, no new things could be
        /// associated with this type.</p>
        pub fn deprecated(mut self, input: bool) -> Self {
            self.deprecated = Some(input);
            self
        }
        /// <p>Whether the thing type is deprecated. If <b>true</b>, no new things could be
        /// associated with this type.</p>
        pub fn set_deprecated(mut self, input: std::option::Option<bool>) -> Self {
            self.deprecated = input;
            self
        }
        /// <p>The date and time when the thing type was deprecated.</p>
        pub fn deprecation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deprecation_date = Some(input);
            self
        }
        /// <p>The date and time when the thing type was deprecated.</p>
        pub fn set_deprecation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deprecation_date = input;
            self
        }
        /// <p>The date and time when the thing type was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time when the thing type was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingTypeMetadata`](crate::model::ThingTypeMetadata)
        pub fn build(self) -> crate::model::ThingTypeMetadata {
            crate::model::ThingTypeMetadata {
                deprecated: self.deprecated.unwrap_or_default(),
                deprecation_date: self.deprecation_date,
                creation_date: self.creation_date,
            }
        }
    }
}
impl ThingTypeMetadata {
    /// Creates a new builder-style object to manufacture [`ThingTypeMetadata`](crate::model::ThingTypeMetadata)
    pub fn builder() -> crate::model::thing_type_metadata::Builder {
        crate::model::thing_type_metadata::Builder::default()
    }
}

/// <p>The ThingTypeProperties contains information about the thing type including: a thing type description,
/// and a list of searchable thing attribute names.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingTypeProperties {
    /// <p>The description of the thing type.</p>
    pub thing_type_description: std::option::Option<std::string::String>,
    /// <p>A list of searchable thing attribute names.</p>
    pub searchable_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ThingTypeProperties {
    /// <p>The description of the thing type.</p>
    pub fn thing_type_description(&self) -> std::option::Option<&str> {
        self.thing_type_description.as_deref()
    }
    /// <p>A list of searchable thing attribute names.</p>
    pub fn searchable_attributes(&self) -> std::option::Option<&[std::string::String]> {
        self.searchable_attributes.as_deref()
    }
}
impl std::fmt::Debug for ThingTypeProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingTypeProperties");
        formatter.field("thing_type_description", &self.thing_type_description);
        formatter.field("searchable_attributes", &self.searchable_attributes);
        formatter.finish()
    }
}
/// See [`ThingTypeProperties`](crate::model::ThingTypeProperties)
pub mod thing_type_properties {
    /// A builder for [`ThingTypeProperties`](crate::model::ThingTypeProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_type_description: std::option::Option<std::string::String>,
        pub(crate) searchable_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The description of the thing type.</p>
        pub fn thing_type_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_description = Some(input.into());
            self
        }
        /// <p>The description of the thing type.</p>
        pub fn set_thing_type_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_description = input;
            self
        }
        /// Appends an item to `searchable_attributes`.
        ///
        /// To override the contents of this collection use [`set_searchable_attributes`](Self::set_searchable_attributes).
        ///
        /// <p>A list of searchable thing attribute names.</p>
        pub fn searchable_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.searchable_attributes.unwrap_or_default();
            v.push(input.into());
            self.searchable_attributes = Some(v);
            self
        }
        /// <p>A list of searchable thing attribute names.</p>
        pub fn set_searchable_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.searchable_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingTypeProperties`](crate::model::ThingTypeProperties)
        pub fn build(self) -> crate::model::ThingTypeProperties {
            crate::model::ThingTypeProperties {
                thing_type_description: self.thing_type_description,
                searchable_attributes: self.searchable_attributes,
            }
        }
    }
}
impl ThingTypeProperties {
    /// Creates a new builder-style object to manufacture [`ThingTypeProperties`](crate::model::ThingTypeProperties)
    pub fn builder() -> crate::model::thing_type_properties::Builder {
        crate::model::thing_type_properties::Builder::default()
    }
}

/// <p>The properties of the thing, including thing name, thing type name, and a list of thing
/// attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThingAttribute {
    /// <p>The name of the thing.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The name of the thing type, if the thing has been associated with a type.</p>
    pub thing_type_name: std::option::Option<std::string::String>,
    /// <p>The thing ARN.</p>
    pub thing_arn: std::option::Option<std::string::String>,
    /// <p>A list of thing attributes which are name-value pairs.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The version of the thing record in the registry.</p>
    pub version: i64,
}
impl ThingAttribute {
    /// <p>The name of the thing.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The name of the thing type, if the thing has been associated with a type.</p>
    pub fn thing_type_name(&self) -> std::option::Option<&str> {
        self.thing_type_name.as_deref()
    }
    /// <p>The thing ARN.</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
    /// <p>A list of thing attributes which are name-value pairs.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>The version of the thing record in the registry.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
}
impl std::fmt::Debug for ThingAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThingAttribute");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("thing_type_name", &self.thing_type_name);
        formatter.field("thing_arn", &self.thing_arn);
        formatter.field("attributes", &self.attributes);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ThingAttribute`](crate::model::ThingAttribute)
pub mod thing_attribute {
    /// A builder for [`ThingAttribute`](crate::model::ThingAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) thing_type_name: std::option::Option<std::string::String>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The name of the thing type, if the thing has been associated with a type.</p>
        pub fn thing_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_type_name = Some(input.into());
            self
        }
        /// <p>The name of the thing type, if the thing has been associated with a type.</p>
        pub fn set_thing_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_type_name = input;
            self
        }
        /// <p>The thing ARN.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The thing ARN.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of thing attributes which are name-value pairs.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A list of thing attributes which are name-value pairs.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The version of the thing record in the registry.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the thing record in the registry.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ThingAttribute`](crate::model::ThingAttribute)
        pub fn build(self) -> crate::model::ThingAttribute {
            crate::model::ThingAttribute {
                thing_name: self.thing_name,
                thing_type_name: self.thing_type_name,
                thing_arn: self.thing_arn,
                attributes: self.attributes,
                version: self.version.unwrap_or_default(),
            }
        }
    }
}
impl ThingAttribute {
    /// Creates a new builder-style object to manufacture [`ThingAttribute`](crate::model::ThingAttribute)
    pub fn builder() -> crate::model::thing_attribute::Builder {
        crate::model::thing_attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => Status::Cancelled,
            "Cancelling" => Status::Cancelling,
            "Completed" => Status::Completed,
            "Failed" => Status::Failed,
            "InProgress" => Status::InProgress,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Cancelled => "Cancelled",
            Status::Cancelling => "Cancelling",
            Status::Completed => "Completed",
            Status::Failed => "Failed",
            Status::InProgress => "InProgress",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Cancelling",
            "Completed",
            "Failed",
            "InProgress",
        ]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportType {
    #[allow(missing_docs)] // documentation missing in model
    Errors,
    #[allow(missing_docs)] // documentation missing in model
    Results,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportType {
    fn from(s: &str) -> Self {
        match s {
            "ERRORS" => ReportType::Errors,
            "RESULTS" => ReportType::Results,
            other => ReportType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportType::from(s))
    }
}
impl ReportType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportType::Errors => "ERRORS",
            ReportType::Results => "RESULTS",
            ReportType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERRORS", "RESULTS"]
    }
}
impl AsRef<str> for ReportType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The name and ARN of a group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupNameAndArn {
    /// <p>The group name.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The group ARN.</p>
    pub group_arn: std::option::Option<std::string::String>,
}
impl GroupNameAndArn {
    /// <p>The group name.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The group ARN.</p>
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
}
impl std::fmt::Debug for GroupNameAndArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupNameAndArn");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_arn", &self.group_arn);
        formatter.finish()
    }
}
/// See [`GroupNameAndArn`](crate::model::GroupNameAndArn)
pub mod group_name_and_arn {
    /// A builder for [`GroupNameAndArn`](crate::model::GroupNameAndArn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The group name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The group name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The group ARN.</p>
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// <p>The group ARN.</p>
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupNameAndArn`](crate::model::GroupNameAndArn)
        pub fn build(self) -> crate::model::GroupNameAndArn {
            crate::model::GroupNameAndArn {
                group_name: self.group_name,
                group_arn: self.group_arn,
            }
        }
    }
}
impl GroupNameAndArn {
    /// Creates a new builder-style object to manufacture [`GroupNameAndArn`](crate::model::GroupNameAndArn)
    pub fn builder() -> crate::model::group_name_and_arn::Builder {
        crate::model::group_name_and_arn::Builder::default()
    }
}

/// <p>A target to which an alert is sent when a security profile behavior is
/// violated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityProfileTarget {
    /// <p>The ARN of the security profile.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl SecurityProfileTarget {
    /// <p>The ARN of the security profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for SecurityProfileTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityProfileTarget");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`SecurityProfileTarget`](crate::model::SecurityProfileTarget)
pub mod security_profile_target {
    /// A builder for [`SecurityProfileTarget`](crate::model::SecurityProfileTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the security profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the security profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityProfileTarget`](crate::model::SecurityProfileTarget)
        pub fn build(self) -> crate::model::SecurityProfileTarget {
            crate::model::SecurityProfileTarget { arn: self.arn }
        }
    }
}
impl SecurityProfileTarget {
    /// Creates a new builder-style object to manufacture [`SecurityProfileTarget`](crate::model::SecurityProfileTarget)
    pub fn builder() -> crate::model::security_profile_target::Builder {
        crate::model::security_profile_target::Builder::default()
    }
}

/// <p>A summary of a stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamSummary {
    /// <p>The stream ID.</p>
    pub stream_id: std::option::Option<std::string::String>,
    /// <p>The stream ARN.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The stream version.</p>
    pub stream_version: std::option::Option<i32>,
    /// <p>A description of the stream.</p>
    pub description: std::option::Option<std::string::String>,
}
impl StreamSummary {
    /// <p>The stream ID.</p>
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// <p>The stream ARN.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The stream version.</p>
    pub fn stream_version(&self) -> std::option::Option<i32> {
        self.stream_version
    }
    /// <p>A description of the stream.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for StreamSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamSummary");
        formatter.field("stream_id", &self.stream_id);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("stream_version", &self.stream_version);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`StreamSummary`](crate::model::StreamSummary)
pub mod stream_summary {
    /// A builder for [`StreamSummary`](crate::model::StreamSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) stream_version: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>The stream ARN.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The stream ARN.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The stream version.</p>
        pub fn stream_version(mut self, input: i32) -> Self {
            self.stream_version = Some(input);
            self
        }
        /// <p>The stream version.</p>
        pub fn set_stream_version(mut self, input: std::option::Option<i32>) -> Self {
            self.stream_version = input;
            self
        }
        /// <p>A description of the stream.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the stream.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamSummary`](crate::model::StreamSummary)
        pub fn build(self) -> crate::model::StreamSummary {
            crate::model::StreamSummary {
                stream_id: self.stream_id,
                stream_arn: self.stream_arn,
                stream_version: self.stream_version,
                description: self.description,
            }
        }
    }
}
impl StreamSummary {
    /// Creates a new builder-style object to manufacture [`StreamSummary`](crate::model::StreamSummary)
    pub fn builder() -> crate::model::stream_summary::Builder {
        crate::model::stream_summary::Builder::default()
    }
}

/// <p>Information about a security profile and the target associated with it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityProfileTargetMapping {
    /// <p>Information that identifies the security profile.</p>
    pub security_profile_identifier: std::option::Option<crate::model::SecurityProfileIdentifier>,
    /// <p>Information about the target (thing group) associated with the security profile.</p>
    pub target: std::option::Option<crate::model::SecurityProfileTarget>,
}
impl SecurityProfileTargetMapping {
    /// <p>Information that identifies the security profile.</p>
    pub fn security_profile_identifier(
        &self,
    ) -> std::option::Option<&crate::model::SecurityProfileIdentifier> {
        self.security_profile_identifier.as_ref()
    }
    /// <p>Information about the target (thing group) associated with the security profile.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::SecurityProfileTarget> {
        self.target.as_ref()
    }
}
impl std::fmt::Debug for SecurityProfileTargetMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityProfileTargetMapping");
        formatter.field(
            "security_profile_identifier",
            &self.security_profile_identifier,
        );
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`SecurityProfileTargetMapping`](crate::model::SecurityProfileTargetMapping)
pub mod security_profile_target_mapping {
    /// A builder for [`SecurityProfileTargetMapping`](crate::model::SecurityProfileTargetMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_identifier:
            std::option::Option<crate::model::SecurityProfileIdentifier>,
        pub(crate) target: std::option::Option<crate::model::SecurityProfileTarget>,
    }
    impl Builder {
        /// <p>Information that identifies the security profile.</p>
        pub fn security_profile_identifier(
            mut self,
            input: crate::model::SecurityProfileIdentifier,
        ) -> Self {
            self.security_profile_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the security profile.</p>
        pub fn set_security_profile_identifier(
            mut self,
            input: std::option::Option<crate::model::SecurityProfileIdentifier>,
        ) -> Self {
            self.security_profile_identifier = input;
            self
        }
        /// <p>Information about the target (thing group) associated with the security profile.</p>
        pub fn target(mut self, input: crate::model::SecurityProfileTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>Information about the target (thing group) associated with the security profile.</p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::SecurityProfileTarget>,
        ) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityProfileTargetMapping`](crate::model::SecurityProfileTargetMapping)
        pub fn build(self) -> crate::model::SecurityProfileTargetMapping {
            crate::model::SecurityProfileTargetMapping {
                security_profile_identifier: self.security_profile_identifier,
                target: self.target,
            }
        }
    }
}
impl SecurityProfileTargetMapping {
    /// Creates a new builder-style object to manufacture [`SecurityProfileTargetMapping`](crate::model::SecurityProfileTargetMapping)
    pub fn builder() -> crate::model::security_profile_target_mapping::Builder {
        crate::model::security_profile_target_mapping::Builder::default()
    }
}

/// <p>Identifying information for a Device Defender security profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityProfileIdentifier {
    /// <p>The name you've given to the security profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the security profile.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl SecurityProfileIdentifier {
    /// <p>The name you've given to the security profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the security profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for SecurityProfileIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityProfileIdentifier");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`SecurityProfileIdentifier`](crate::model::SecurityProfileIdentifier)
pub mod security_profile_identifier {
    /// A builder for [`SecurityProfileIdentifier`](crate::model::SecurityProfileIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name you've given to the security profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name you've given to the security profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the security profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the security profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityProfileIdentifier`](crate::model::SecurityProfileIdentifier)
        pub fn build(self) -> crate::model::SecurityProfileIdentifier {
            crate::model::SecurityProfileIdentifier {
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl SecurityProfileIdentifier {
    /// Creates a new builder-style object to manufacture [`SecurityProfileIdentifier`](crate::model::SecurityProfileIdentifier)
    pub fn builder() -> crate::model::security_profile_identifier::Builder {
        crate::model::security_profile_identifier::Builder::default()
    }
}

/// <p>Information about the scheduled audit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledAuditMetadata {
    /// <p>The name of the scheduled audit.</p>
    pub scheduled_audit_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the scheduled audit.</p>
    pub scheduled_audit_arn: std::option::Option<std::string::String>,
    /// <p>How often the scheduled audit occurs.</p>
    pub frequency: std::option::Option<crate::model::AuditFrequency>,
    /// <p>The day of the month on which the scheduled audit is run (if the
    /// <code>frequency</code> is "MONTHLY").
    /// If days 29-31 are specified, and the month does not have that many
    /// days, the audit takes place on the "LAST" day of the month.</p>
    pub day_of_month: std::option::Option<std::string::String>,
    /// <p>The day of the week on which the scheduled audit is run (if the
    /// <code>frequency</code> is "WEEKLY" or "BIWEEKLY").</p>
    pub day_of_week: std::option::Option<crate::model::DayOfWeek>,
}
impl ScheduledAuditMetadata {
    /// <p>The name of the scheduled audit.</p>
    pub fn scheduled_audit_name(&self) -> std::option::Option<&str> {
        self.scheduled_audit_name.as_deref()
    }
    /// <p>The ARN of the scheduled audit.</p>
    pub fn scheduled_audit_arn(&self) -> std::option::Option<&str> {
        self.scheduled_audit_arn.as_deref()
    }
    /// <p>How often the scheduled audit occurs.</p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::AuditFrequency> {
        self.frequency.as_ref()
    }
    /// <p>The day of the month on which the scheduled audit is run (if the
    /// <code>frequency</code> is "MONTHLY").
    /// If days 29-31 are specified, and the month does not have that many
    /// days, the audit takes place on the "LAST" day of the month.</p>
    pub fn day_of_month(&self) -> std::option::Option<&str> {
        self.day_of_month.as_deref()
    }
    /// <p>The day of the week on which the scheduled audit is run (if the
    /// <code>frequency</code> is "WEEKLY" or "BIWEEKLY").</p>
    pub fn day_of_week(&self) -> std::option::Option<&crate::model::DayOfWeek> {
        self.day_of_week.as_ref()
    }
}
impl std::fmt::Debug for ScheduledAuditMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledAuditMetadata");
        formatter.field("scheduled_audit_name", &self.scheduled_audit_name);
        formatter.field("scheduled_audit_arn", &self.scheduled_audit_arn);
        formatter.field("frequency", &self.frequency);
        formatter.field("day_of_month", &self.day_of_month);
        formatter.field("day_of_week", &self.day_of_week);
        formatter.finish()
    }
}
/// See [`ScheduledAuditMetadata`](crate::model::ScheduledAuditMetadata)
pub mod scheduled_audit_metadata {
    /// A builder for [`ScheduledAuditMetadata`](crate::model::ScheduledAuditMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_audit_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_audit_arn: std::option::Option<std::string::String>,
        pub(crate) frequency: std::option::Option<crate::model::AuditFrequency>,
        pub(crate) day_of_month: std::option::Option<std::string::String>,
        pub(crate) day_of_week: std::option::Option<crate::model::DayOfWeek>,
    }
    impl Builder {
        /// <p>The name of the scheduled audit.</p>
        pub fn scheduled_audit_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled audit.</p>
        pub fn set_scheduled_audit_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_name = input;
            self
        }
        /// <p>The ARN of the scheduled audit.</p>
        pub fn scheduled_audit_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_audit_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the scheduled audit.</p>
        pub fn set_scheduled_audit_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_audit_arn = input;
            self
        }
        /// <p>How often the scheduled audit occurs.</p>
        pub fn frequency(mut self, input: crate::model::AuditFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>How often the scheduled audit occurs.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AuditFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// <p>The day of the month on which the scheduled audit is run (if the
        /// <code>frequency</code> is "MONTHLY").
        /// If days 29-31 are specified, and the month does not have that many
        /// days, the audit takes place on the "LAST" day of the month.</p>
        pub fn day_of_month(mut self, input: impl Into<std::string::String>) -> Self {
            self.day_of_month = Some(input.into());
            self
        }
        /// <p>The day of the month on which the scheduled audit is run (if the
        /// <code>frequency</code> is "MONTHLY").
        /// If days 29-31 are specified, and the month does not have that many
        /// days, the audit takes place on the "LAST" day of the month.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.day_of_month = input;
            self
        }
        /// <p>The day of the week on which the scheduled audit is run (if the
        /// <code>frequency</code> is "WEEKLY" or "BIWEEKLY").</p>
        pub fn day_of_week(mut self, input: crate::model::DayOfWeek) -> Self {
            self.day_of_week = Some(input);
            self
        }
        /// <p>The day of the week on which the scheduled audit is run (if the
        /// <code>frequency</code> is "WEEKLY" or "BIWEEKLY").</p>
        pub fn set_day_of_week(
            mut self,
            input: std::option::Option<crate::model::DayOfWeek>,
        ) -> Self {
            self.day_of_week = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledAuditMetadata`](crate::model::ScheduledAuditMetadata)
        pub fn build(self) -> crate::model::ScheduledAuditMetadata {
            crate::model::ScheduledAuditMetadata {
                scheduled_audit_name: self.scheduled_audit_name,
                scheduled_audit_arn: self.scheduled_audit_arn,
                frequency: self.frequency,
                day_of_month: self.day_of_month,
                day_of_week: self.day_of_week,
            }
        }
    }
}
impl ScheduledAuditMetadata {
    /// Creates a new builder-style object to manufacture [`ScheduledAuditMetadata`](crate::model::ScheduledAuditMetadata)
    pub fn builder() -> crate::model::scheduled_audit_metadata::Builder {
        crate::model::scheduled_audit_metadata::Builder::default()
    }
}

/// <p>A summary of information about a fleet provision template version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningTemplateVersionSummary {
    /// <p>The ID of the fleet privisioning template version.</p>
    pub version_id: std::option::Option<i32>,
    /// <p>The date when the fleet provisioning template version was created</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>True if the fleet provisioning template version is the default version, otherwise
    /// false.</p>
    pub is_default_version: bool,
}
impl ProvisioningTemplateVersionSummary {
    /// <p>The ID of the fleet privisioning template version.</p>
    pub fn version_id(&self) -> std::option::Option<i32> {
        self.version_id
    }
    /// <p>The date when the fleet provisioning template version was created</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>True if the fleet provisioning template version is the default version, otherwise
    /// false.</p>
    pub fn is_default_version(&self) -> bool {
        self.is_default_version
    }
}
impl std::fmt::Debug for ProvisioningTemplateVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningTemplateVersionSummary");
        formatter.field("version_id", &self.version_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.finish()
    }
}
/// See [`ProvisioningTemplateVersionSummary`](crate::model::ProvisioningTemplateVersionSummary)
pub mod provisioning_template_version_summary {
    /// A builder for [`ProvisioningTemplateVersionSummary`](crate::model::ProvisioningTemplateVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_id: std::option::Option<i32>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) is_default_version: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the fleet privisioning template version.</p>
        pub fn version_id(mut self, input: i32) -> Self {
            self.version_id = Some(input);
            self
        }
        /// <p>The ID of the fleet privisioning template version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<i32>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The date when the fleet provisioning template version was created</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the fleet provisioning template version was created</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>True if the fleet provisioning template version is the default version, otherwise
        /// false.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>True if the fleet provisioning template version is the default version, otherwise
        /// false.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningTemplateVersionSummary`](crate::model::ProvisioningTemplateVersionSummary)
        pub fn build(self) -> crate::model::ProvisioningTemplateVersionSummary {
            crate::model::ProvisioningTemplateVersionSummary {
                version_id: self.version_id,
                creation_date: self.creation_date,
                is_default_version: self.is_default_version.unwrap_or_default(),
            }
        }
    }
}
impl ProvisioningTemplateVersionSummary {
    /// Creates a new builder-style object to manufacture [`ProvisioningTemplateVersionSummary`](crate::model::ProvisioningTemplateVersionSummary)
    pub fn builder() -> crate::model::provisioning_template_version_summary::Builder {
        crate::model::provisioning_template_version_summary::Builder::default()
    }
}

/// <p>A summary of information about a fleet provisioning template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningTemplateSummary {
    /// <p>The ARN of the fleet provisioning template.</p>
    pub template_arn: std::option::Option<std::string::String>,
    /// <p>The name of the fleet provisioning template.</p>
    pub template_name: std::option::Option<std::string::String>,
    /// <p>The description of the fleet provisioning template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date when the fleet provisioning template summary was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the fleet provisioning template summary was last modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>True if the fleet provision template is enabled, otherwise false.</p>
    pub enabled: bool,
}
impl ProvisioningTemplateSummary {
    /// <p>The ARN of the fleet provisioning template.</p>
    pub fn template_arn(&self) -> std::option::Option<&str> {
        self.template_arn.as_deref()
    }
    /// <p>The name of the fleet provisioning template.</p>
    pub fn template_name(&self) -> std::option::Option<&str> {
        self.template_name.as_deref()
    }
    /// <p>The description of the fleet provisioning template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date when the fleet provisioning template summary was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>The date when the fleet provisioning template summary was last modified.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_date.as_ref()
    }
    /// <p>True if the fleet provision template is enabled, otherwise false.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for ProvisioningTemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningTemplateSummary");
        formatter.field("template_arn", &self.template_arn);
        formatter.field("template_name", &self.template_name);
        formatter.field("description", &self.description);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`ProvisioningTemplateSummary`](crate::model::ProvisioningTemplateSummary)
pub mod provisioning_template_summary {
    /// A builder for [`ProvisioningTemplateSummary`](crate::model::ProvisioningTemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_arn: std::option::Option<std::string::String>,
        pub(crate) template_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the fleet provisioning template.</p>
        pub fn template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the fleet provisioning template.</p>
        pub fn set_template_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_arn = input;
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet provisioning template.</p>
        pub fn set_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_name = input;
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the fleet provisioning template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date when the fleet provisioning template summary was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the fleet provisioning template summary was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date when the fleet provisioning template summary was last modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date when the fleet provisioning template summary was last modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>True if the fleet provision template is enabled, otherwise false.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>True if the fleet provision template is enabled, otherwise false.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningTemplateSummary`](crate::model::ProvisioningTemplateSummary)
        pub fn build(self) -> crate::model::ProvisioningTemplateSummary {
            crate::model::ProvisioningTemplateSummary {
                template_arn: self.template_arn,
                template_name: self.template_name,
                description: self.description,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl ProvisioningTemplateSummary {
    /// Creates a new builder-style object to manufacture [`ProvisioningTemplateSummary`](crate::model::ProvisioningTemplateSummary)
    pub fn builder() -> crate::model::provisioning_template_summary::Builder {
        crate::model::provisioning_template_summary::Builder::default()
    }
}

/// <p>Describes a policy version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyVersion {
    /// <p>The policy version ID.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the policy version is the default.</p>
    pub is_default_version: bool,
    /// <p>The date and time the policy was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl PolicyVersion {
    /// <p>The policy version ID.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Specifies whether the policy version is the default.</p>
    pub fn is_default_version(&self) -> bool {
        self.is_default_version
    }
    /// <p>The date and time the policy was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for PolicyVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyVersion");
        formatter.field("version_id", &self.version_id);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`PolicyVersion`](crate::model::PolicyVersion)
pub mod policy_version {
    /// A builder for [`PolicyVersion`](crate::model::PolicyVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) is_default_version: std::option::Option<bool>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The policy version ID.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The policy version ID.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies whether the policy version is the default.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>Specifies whether the policy version is the default.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// <p>The date and time the policy was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time the policy was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyVersion`](crate::model::PolicyVersion)
        pub fn build(self) -> crate::model::PolicyVersion {
            crate::model::PolicyVersion {
                version_id: self.version_id,
                is_default_version: self.is_default_version.unwrap_or_default(),
                create_date: self.create_date,
            }
        }
    }
}
impl PolicyVersion {
    /// Creates a new builder-style object to manufacture [`PolicyVersion`](crate::model::PolicyVersion)
    pub fn builder() -> crate::model::policy_version::Builder {
        crate::model::policy_version::Builder::default()
    }
}

/// <p>A certificate that has been transferred but not yet accepted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutgoingCertificate {
    /// <p>The certificate ARN.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The certificate ID.</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account to which the transfer was made.</p>
    pub transferred_to: std::option::Option<std::string::String>,
    /// <p>The date the transfer was initiated.</p>
    pub transfer_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The transfer message.</p>
    pub transfer_message: std::option::Option<std::string::String>,
    /// <p>The certificate creation date.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl OutgoingCertificate {
    /// <p>The certificate ARN.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The certificate ID.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The Amazon Web Services account to which the transfer was made.</p>
    pub fn transferred_to(&self) -> std::option::Option<&str> {
        self.transferred_to.as_deref()
    }
    /// <p>The date the transfer was initiated.</p>
    pub fn transfer_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.transfer_date.as_ref()
    }
    /// <p>The transfer message.</p>
    pub fn transfer_message(&self) -> std::option::Option<&str> {
        self.transfer_message.as_deref()
    }
    /// <p>The certificate creation date.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for OutgoingCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutgoingCertificate");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("transferred_to", &self.transferred_to);
        formatter.field("transfer_date", &self.transfer_date);
        formatter.field("transfer_message", &self.transfer_message);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`OutgoingCertificate`](crate::model::OutgoingCertificate)
pub mod outgoing_certificate {
    /// A builder for [`OutgoingCertificate`](crate::model::OutgoingCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) transferred_to: std::option::Option<std::string::String>,
        pub(crate) transfer_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) transfer_message: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The certificate ARN.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The certificate ARN.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The certificate ID.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The certificate ID.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The Amazon Web Services account to which the transfer was made.</p>
        pub fn transferred_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.transferred_to = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account to which the transfer was made.</p>
        pub fn set_transferred_to(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transferred_to = input;
            self
        }
        /// <p>The date the transfer was initiated.</p>
        pub fn transfer_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.transfer_date = Some(input);
            self
        }
        /// <p>The date the transfer was initiated.</p>
        pub fn set_transfer_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.transfer_date = input;
            self
        }
        /// <p>The transfer message.</p>
        pub fn transfer_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.transfer_message = Some(input.into());
            self
        }
        /// <p>The transfer message.</p>
        pub fn set_transfer_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transfer_message = input;
            self
        }
        /// <p>The certificate creation date.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The certificate creation date.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`OutgoingCertificate`](crate::model::OutgoingCertificate)
        pub fn build(self) -> crate::model::OutgoingCertificate {
            crate::model::OutgoingCertificate {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
                transferred_to: self.transferred_to,
                transfer_date: self.transfer_date,
                transfer_message: self.transfer_message,
                creation_date: self.creation_date,
            }
        }
    }
}
impl OutgoingCertificate {
    /// Creates a new builder-style object to manufacture [`OutgoingCertificate`](crate::model::OutgoingCertificate)
    pub fn builder() -> crate::model::outgoing_certificate::Builder {
        crate::model::outgoing_certificate::Builder::default()
    }
}

/// <p>An OTA update summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtaUpdateSummary {
    /// <p>The OTA update ID.</p>
    pub ota_update_id: std::option::Option<std::string::String>,
    /// <p>The OTA update ARN.</p>
    pub ota_update_arn: std::option::Option<std::string::String>,
    /// <p>The date when the OTA update was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl OtaUpdateSummary {
    /// <p>The OTA update ID.</p>
    pub fn ota_update_id(&self) -> std::option::Option<&str> {
        self.ota_update_id.as_deref()
    }
    /// <p>The OTA update ARN.</p>
    pub fn ota_update_arn(&self) -> std::option::Option<&str> {
        self.ota_update_arn.as_deref()
    }
    /// <p>The date when the OTA update was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for OtaUpdateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtaUpdateSummary");
        formatter.field("ota_update_id", &self.ota_update_id);
        formatter.field("ota_update_arn", &self.ota_update_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`OtaUpdateSummary`](crate::model::OtaUpdateSummary)
pub mod ota_update_summary {
    /// A builder for [`OtaUpdateSummary`](crate::model::OtaUpdateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_update_id: std::option::Option<std::string::String>,
        pub(crate) ota_update_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The OTA update ID.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_id = Some(input.into());
            self
        }
        /// <p>The OTA update ID.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_id = input;
            self
        }
        /// <p>The OTA update ARN.</p>
        pub fn ota_update_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_arn = Some(input.into());
            self
        }
        /// <p>The OTA update ARN.</p>
        pub fn set_ota_update_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_arn = input;
            self
        }
        /// <p>The date when the OTA update was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the OTA update was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`OtaUpdateSummary`](crate::model::OtaUpdateSummary)
        pub fn build(self) -> crate::model::OtaUpdateSummary {
            crate::model::OtaUpdateSummary {
                ota_update_id: self.ota_update_id,
                ota_update_arn: self.ota_update_arn,
                creation_date: self.creation_date,
            }
        }
    }
}
impl OtaUpdateSummary {
    /// Creates a new builder-style object to manufacture [`OtaUpdateSummary`](crate::model::OtaUpdateSummary)
    pub fn builder() -> crate::model::ota_update_summary::Builder {
        crate::model::ota_update_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OtaUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    CreatePending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OtaUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => OtaUpdateStatus::CreateComplete,
            "CREATE_FAILED" => OtaUpdateStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => OtaUpdateStatus::CreateInProgress,
            "CREATE_PENDING" => OtaUpdateStatus::CreatePending,
            other => OtaUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OtaUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OtaUpdateStatus::from(s))
    }
}
impl OtaUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OtaUpdateStatus::CreateComplete => "CREATE_COMPLETE",
            OtaUpdateStatus::CreateFailed => "CREATE_FAILED",
            OtaUpdateStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            OtaUpdateStatus::CreatePending => "CREATE_PENDING",
            OtaUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "CREATE_PENDING",
        ]
    }
}
impl AsRef<str> for OtaUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information that identifies a mitigation action. This information is returned by ListMitigationActions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MitigationActionIdentifier {
    /// <p>The friendly name of the mitigation action.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The IAM role ARN used to apply this mitigation action.</p>
    pub action_arn: std::option::Option<std::string::String>,
    /// <p>The date when this mitigation action was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl MitigationActionIdentifier {
    /// <p>The friendly name of the mitigation action.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The IAM role ARN used to apply this mitigation action.</p>
    pub fn action_arn(&self) -> std::option::Option<&str> {
        self.action_arn.as_deref()
    }
    /// <p>The date when this mitigation action was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for MitigationActionIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MitigationActionIdentifier");
        formatter.field("action_name", &self.action_name);
        formatter.field("action_arn", &self.action_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`MitigationActionIdentifier`](crate::model::MitigationActionIdentifier)
pub mod mitigation_action_identifier {
    /// A builder for [`MitigationActionIdentifier`](crate::model::MitigationActionIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) action_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The friendly name of the mitigation action.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the mitigation action.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The IAM role ARN used to apply this mitigation action.</p>
        pub fn action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_arn = Some(input.into());
            self
        }
        /// <p>The IAM role ARN used to apply this mitigation action.</p>
        pub fn set_action_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_arn = input;
            self
        }
        /// <p>The date when this mitigation action was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when this mitigation action was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`MitigationActionIdentifier`](crate::model::MitigationActionIdentifier)
        pub fn build(self) -> crate::model::MitigationActionIdentifier {
            crate::model::MitigationActionIdentifier {
                action_name: self.action_name,
                action_arn: self.action_arn,
                creation_date: self.creation_date,
            }
        }
    }
}
impl MitigationActionIdentifier {
    /// Creates a new builder-style object to manufacture [`MitigationActionIdentifier`](crate::model::MitigationActionIdentifier)
    pub fn builder() -> crate::model::mitigation_action_identifier::Builder {
        crate::model::mitigation_action_identifier::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MitigationActionType {
    #[allow(missing_docs)] // documentation missing in model
    AddThingsToThingGroup,
    #[allow(missing_docs)] // documentation missing in model
    EnableIotLogging,
    #[allow(missing_docs)] // documentation missing in model
    PublishFindingToSns,
    #[allow(missing_docs)] // documentation missing in model
    ReplaceDefaultPolicyVersion,
    #[allow(missing_docs)] // documentation missing in model
    UpdateCaCertificate,
    #[allow(missing_docs)] // documentation missing in model
    UpdateDeviceCertificate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MitigationActionType {
    fn from(s: &str) -> Self {
        match s {
            "ADD_THINGS_TO_THING_GROUP" => MitigationActionType::AddThingsToThingGroup,
            "ENABLE_IOT_LOGGING" => MitigationActionType::EnableIotLogging,
            "PUBLISH_FINDING_TO_SNS" => MitigationActionType::PublishFindingToSns,
            "REPLACE_DEFAULT_POLICY_VERSION" => MitigationActionType::ReplaceDefaultPolicyVersion,
            "UPDATE_CA_CERTIFICATE" => MitigationActionType::UpdateCaCertificate,
            "UPDATE_DEVICE_CERTIFICATE" => MitigationActionType::UpdateDeviceCertificate,
            other => MitigationActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MitigationActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MitigationActionType::from(s))
    }
}
impl MitigationActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MitigationActionType::AddThingsToThingGroup => "ADD_THINGS_TO_THING_GROUP",
            MitigationActionType::EnableIotLogging => "ENABLE_IOT_LOGGING",
            MitigationActionType::PublishFindingToSns => "PUBLISH_FINDING_TO_SNS",
            MitigationActionType::ReplaceDefaultPolicyVersion => "REPLACE_DEFAULT_POLICY_VERSION",
            MitigationActionType::UpdateCaCertificate => "UPDATE_CA_CERTIFICATE",
            MitigationActionType::UpdateDeviceCertificate => "UPDATE_DEVICE_CERTIFICATE",
            MitigationActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADD_THINGS_TO_THING_GROUP",
            "ENABLE_IOT_LOGGING",
            "PUBLISH_FINDING_TO_SNS",
            "REPLACE_DEFAULT_POLICY_VERSION",
            "UPDATE_CA_CERTIFICATE",
            "UPDATE_DEVICE_CERTIFICATE",
        ]
    }
}
impl AsRef<str> for MitigationActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information about the job template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobTemplateSummary {
    /// <p>The ARN of the job template.</p>
    pub job_template_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the job template.</p>
    pub job_template_id: std::option::Option<std::string::String>,
    /// <p>A description of the job template.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The time, in seconds since the epoch, when the job template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
}
impl JobTemplateSummary {
    /// <p>The ARN of the job template.</p>
    pub fn job_template_arn(&self) -> std::option::Option<&str> {
        self.job_template_arn.as_deref()
    }
    /// <p>The unique identifier of the job template.</p>
    pub fn job_template_id(&self) -> std::option::Option<&str> {
        self.job_template_id.as_deref()
    }
    /// <p>A description of the job template.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The time, in seconds since the epoch, when the job template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for JobTemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobTemplateSummary");
        formatter.field("job_template_arn", &self.job_template_arn);
        formatter.field("job_template_id", &self.job_template_id);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`JobTemplateSummary`](crate::model::JobTemplateSummary)
pub mod job_template_summary {
    /// A builder for [`JobTemplateSummary`](crate::model::JobTemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template_arn: std::option::Option<std::string::String>,
        pub(crate) job_template_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the job template.</p>
        pub fn job_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the job template.</p>
        pub fn set_job_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_arn = input;
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn job_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_template_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the job template.</p>
        pub fn set_job_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_template_id = input;
            self
        }
        /// <p>A description of the job template.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the job template.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`JobTemplateSummary`](crate::model::JobTemplateSummary)
        pub fn build(self) -> crate::model::JobTemplateSummary {
            crate::model::JobTemplateSummary {
                job_template_arn: self.job_template_arn,
                job_template_id: self.job_template_id,
                description: self.description,
                created_at: self.created_at,
            }
        }
    }
}
impl JobTemplateSummary {
    /// Creates a new builder-style object to manufacture [`JobTemplateSummary`](crate::model::JobTemplateSummary)
    pub fn builder() -> crate::model::job_template_summary::Builder {
        crate::model::job_template_summary::Builder::default()
    }
}

/// <p>The job summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobSummary {
    /// <p>The job ARN.</p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The ID of the thing group.</p>
    pub thing_group_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
    /// specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
    /// when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
    /// target group, even after the job was completed by all things originally in the group.</p>
    pub target_selection: std::option::Option<crate::model::TargetSelection>,
    /// <p>The job summary status.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>The time, in seconds since the epoch, when the job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in seconds since the epoch, when the job was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in seconds since the epoch, when the job completed.</p>
    pub completed_at: std::option::Option<aws_smithy_types::Instant>,
}
impl JobSummary {
    /// <p>The job ARN.</p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The ID of the thing group.</p>
    pub fn thing_group_id(&self) -> std::option::Option<&str> {
        self.thing_group_id.as_deref()
    }
    /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
    /// specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
    /// when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
    /// target group, even after the job was completed by all things originally in the group.</p>
    pub fn target_selection(&self) -> std::option::Option<&crate::model::TargetSelection> {
        self.target_selection.as_ref()
    }
    /// <p>The job summary status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in seconds since the epoch, when the job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The time, in seconds since the epoch, when the job was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The time, in seconds since the epoch, when the job completed.</p>
    pub fn completed_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.completed_at.as_ref()
    }
}
impl std::fmt::Debug for JobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobSummary");
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_id", &self.job_id);
        formatter.field("thing_group_id", &self.thing_group_id);
        formatter.field("target_selection", &self.target_selection);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.finish()
    }
}
/// See [`JobSummary`](crate::model::JobSummary)
pub mod job_summary {
    /// A builder for [`JobSummary`](crate::model::JobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) thing_group_id: std::option::Option<std::string::String>,
        pub(crate) target_selection: std::option::Option<crate::model::TargetSelection>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The job ARN.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The job ARN.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The ID of the thing group.</p>
        pub fn thing_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the thing group.</p>
        pub fn set_thing_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_id = input;
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
        /// specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
        /// when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
        /// target group, even after the job was completed by all things originally in the group.</p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.target_selection = Some(input);
            self
        }
        /// <p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
        /// specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
        /// when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
        /// target group, even after the job was completed by all things originally in the group.</p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.target_selection = input;
            self
        }
        /// <p>The job summary status.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The job summary status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job completed.</p>
        pub fn completed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job completed.</p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`JobSummary`](crate::model::JobSummary)
        pub fn build(self) -> crate::model::JobSummary {
            crate::model::JobSummary {
                job_arn: self.job_arn,
                job_id: self.job_id,
                thing_group_id: self.thing_group_id,
                target_selection: self.target_selection,
                status: self.status,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                completed_at: self.completed_at,
            }
        }
    }
}
impl JobSummary {
    /// Creates a new builder-style object to manufacture [`JobSummary`](crate::model::JobSummary)
    pub fn builder() -> crate::model::job_summary::Builder {
        crate::model::job_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    DeletionInProgress,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => JobStatus::Canceled,
            "COMPLETED" => JobStatus::Completed,
            "DELETION_IN_PROGRESS" => JobStatus::DeletionInProgress,
            "IN_PROGRESS" => JobStatus::InProgress,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Canceled => "CANCELED",
            JobStatus::Completed => "COMPLETED",
            JobStatus::DeletionInProgress => "DELETION_IN_PROGRESS",
            JobStatus::InProgress => "IN_PROGRESS",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "COMPLETED",
            "DELETION_IN_PROGRESS",
            "IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetSelection {
    #[allow(missing_docs)] // documentation missing in model
    Continuous,
    #[allow(missing_docs)] // documentation missing in model
    Snapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetSelection {
    fn from(s: &str) -> Self {
        match s {
            "CONTINUOUS" => TargetSelection::Continuous,
            "SNAPSHOT" => TargetSelection::Snapshot,
            other => TargetSelection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetSelection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetSelection::from(s))
    }
}
impl TargetSelection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetSelection::Continuous => "CONTINUOUS",
            TargetSelection::Snapshot => "SNAPSHOT",
            TargetSelection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTINUOUS", "SNAPSHOT"]
    }
}
impl AsRef<str> for TargetSelection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The job execution summary for a thing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobExecutionSummaryForThing {
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>Contains a subset of information about a job execution.</p>
    pub job_execution_summary: std::option::Option<crate::model::JobExecutionSummary>,
}
impl JobExecutionSummaryForThing {
    /// <p>The unique identifier you assigned to this job when it was created.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>Contains a subset of information about a job execution.</p>
    pub fn job_execution_summary(&self) -> std::option::Option<&crate::model::JobExecutionSummary> {
        self.job_execution_summary.as_ref()
    }
}
impl std::fmt::Debug for JobExecutionSummaryForThing {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobExecutionSummaryForThing");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_execution_summary", &self.job_execution_summary);
        formatter.finish()
    }
}
/// See [`JobExecutionSummaryForThing`](crate::model::JobExecutionSummaryForThing)
pub mod job_execution_summary_for_thing {
    /// A builder for [`JobExecutionSummaryForThing`](crate::model::JobExecutionSummaryForThing)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_execution_summary: std::option::Option<crate::model::JobExecutionSummary>,
    }
    impl Builder {
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier you assigned to this job when it was created.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Contains a subset of information about a job execution.</p>
        pub fn job_execution_summary(mut self, input: crate::model::JobExecutionSummary) -> Self {
            self.job_execution_summary = Some(input);
            self
        }
        /// <p>Contains a subset of information about a job execution.</p>
        pub fn set_job_execution_summary(
            mut self,
            input: std::option::Option<crate::model::JobExecutionSummary>,
        ) -> Self {
            self.job_execution_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`JobExecutionSummaryForThing`](crate::model::JobExecutionSummaryForThing)
        pub fn build(self) -> crate::model::JobExecutionSummaryForThing {
            crate::model::JobExecutionSummaryForThing {
                job_id: self.job_id,
                job_execution_summary: self.job_execution_summary,
            }
        }
    }
}
impl JobExecutionSummaryForThing {
    /// Creates a new builder-style object to manufacture [`JobExecutionSummaryForThing`](crate::model::JobExecutionSummaryForThing)
    pub fn builder() -> crate::model::job_execution_summary_for_thing::Builder {
        crate::model::job_execution_summary_for_thing::Builder::default()
    }
}

/// <p>The job execution summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobExecutionSummary {
    /// <p>The status of the job execution.</p>
    pub status: std::option::Option<crate::model::JobExecutionStatus>,
    /// <p>The time, in seconds since the epoch, when the job execution was queued.</p>
    pub queued_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in seconds since the epoch, when the job execution started.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time, in seconds since the epoch, when the job execution was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on
    /// this particular device. It can be used later in commands which return or update job execution
    /// information.</p>
    pub execution_number: std::option::Option<i64>,
}
impl JobExecutionSummary {
    /// <p>The status of the job execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in seconds since the epoch, when the job execution was queued.</p>
    pub fn queued_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.queued_at.as_ref()
    }
    /// <p>The time, in seconds since the epoch, when the job execution started.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started_at.as_ref()
    }
    /// <p>The time, in seconds since the epoch, when the job execution was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on
    /// this particular device. It can be used later in commands which return or update job execution
    /// information.</p>
    pub fn execution_number(&self) -> std::option::Option<i64> {
        self.execution_number
    }
}
impl std::fmt::Debug for JobExecutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobExecutionSummary");
        formatter.field("status", &self.status);
        formatter.field("queued_at", &self.queued_at);
        formatter.field("started_at", &self.started_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("execution_number", &self.execution_number);
        formatter.finish()
    }
}
/// See [`JobExecutionSummary`](crate::model::JobExecutionSummary)
pub mod job_execution_summary {
    /// A builder for [`JobExecutionSummary`](crate::model::JobExecutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::JobExecutionStatus>,
        pub(crate) queued_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The status of the job execution.</p>
        pub fn status(mut self, input: crate::model::JobExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the job execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::JobExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job execution was queued.</p>
        pub fn queued_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.queued_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job execution was queued.</p>
        pub fn set_queued_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.queued_at = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job execution started.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job execution started.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The time, in seconds since the epoch, when the job execution was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in seconds since the epoch, when the job execution was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on
        /// this particular device. It can be used later in commands which return or update job execution
        /// information.</p>
        pub fn execution_number(mut self, input: i64) -> Self {
            self.execution_number = Some(input);
            self
        }
        /// <p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on
        /// this particular device. It can be used later in commands which return or update job execution
        /// information.</p>
        pub fn set_execution_number(mut self, input: std::option::Option<i64>) -> Self {
            self.execution_number = input;
            self
        }
        /// Consumes the builder and constructs a [`JobExecutionSummary`](crate::model::JobExecutionSummary)
        pub fn build(self) -> crate::model::JobExecutionSummary {
            crate::model::JobExecutionSummary {
                status: self.status,
                queued_at: self.queued_at,
                started_at: self.started_at,
                last_updated_at: self.last_updated_at,
                execution_number: self.execution_number,
            }
        }
    }
}
impl JobExecutionSummary {
    /// Creates a new builder-style object to manufacture [`JobExecutionSummary`](crate::model::JobExecutionSummary)
    pub fn builder() -> crate::model::job_execution_summary::Builder {
        crate::model::job_execution_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Removed,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => JobExecutionStatus::Canceled,
            "FAILED" => JobExecutionStatus::Failed,
            "IN_PROGRESS" => JobExecutionStatus::InProgress,
            "QUEUED" => JobExecutionStatus::Queued,
            "REJECTED" => JobExecutionStatus::Rejected,
            "REMOVED" => JobExecutionStatus::Removed,
            "SUCCEEDED" => JobExecutionStatus::Succeeded,
            "TIMED_OUT" => JobExecutionStatus::TimedOut,
            other => JobExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobExecutionStatus::from(s))
    }
}
impl JobExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobExecutionStatus::Canceled => "CANCELED",
            JobExecutionStatus::Failed => "FAILED",
            JobExecutionStatus::InProgress => "IN_PROGRESS",
            JobExecutionStatus::Queued => "QUEUED",
            JobExecutionStatus::Rejected => "REJECTED",
            JobExecutionStatus::Removed => "REMOVED",
            JobExecutionStatus::Succeeded => "SUCCEEDED",
            JobExecutionStatus::TimedOut => "TIMED_OUT",
            JobExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "FAILED",
            "IN_PROGRESS",
            "QUEUED",
            "REJECTED",
            "REMOVED",
            "SUCCEEDED",
            "TIMED_OUT",
        ]
    }
}
impl AsRef<str> for JobExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a summary of information about job executions for a specific job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobExecutionSummaryForJob {
    /// <p>The ARN of the thing on which the job execution is running.</p>
    pub thing_arn: std::option::Option<std::string::String>,
    /// <p>Contains a subset of information about a job execution.</p>
    pub job_execution_summary: std::option::Option<crate::model::JobExecutionSummary>,
}
impl JobExecutionSummaryForJob {
    /// <p>The ARN of the thing on which the job execution is running.</p>
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
    /// <p>Contains a subset of information about a job execution.</p>
    pub fn job_execution_summary(&self) -> std::option::Option<&crate::model::JobExecutionSummary> {
        self.job_execution_summary.as_ref()
    }
}
impl std::fmt::Debug for JobExecutionSummaryForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobExecutionSummaryForJob");
        formatter.field("thing_arn", &self.thing_arn);
        formatter.field("job_execution_summary", &self.job_execution_summary);
        formatter.finish()
    }
}
/// See [`JobExecutionSummaryForJob`](crate::model::JobExecutionSummaryForJob)
pub mod job_execution_summary_for_job {
    /// A builder for [`JobExecutionSummaryForJob`](crate::model::JobExecutionSummaryForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_arn: std::option::Option<std::string::String>,
        pub(crate) job_execution_summary: std::option::Option<crate::model::JobExecutionSummary>,
    }
    impl Builder {
        /// <p>The ARN of the thing on which the job execution is running.</p>
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the thing on which the job execution is running.</p>
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// <p>Contains a subset of information about a job execution.</p>
        pub fn job_execution_summary(mut self, input: crate::model::JobExecutionSummary) -> Self {
            self.job_execution_summary = Some(input);
            self
        }
        /// <p>Contains a subset of information about a job execution.</p>
        pub fn set_job_execution_summary(
            mut self,
            input: std::option::Option<crate::model::JobExecutionSummary>,
        ) -> Self {
            self.job_execution_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`JobExecutionSummaryForJob`](crate::model::JobExecutionSummaryForJob)
        pub fn build(self) -> crate::model::JobExecutionSummaryForJob {
            crate::model::JobExecutionSummaryForJob {
                thing_arn: self.thing_arn,
                job_execution_summary: self.job_execution_summary,
            }
        }
    }
}
impl JobExecutionSummaryForJob {
    /// Creates a new builder-style object to manufacture [`JobExecutionSummaryForJob`](crate::model::JobExecutionSummaryForJob)
    pub fn builder() -> crate::model::job_execution_summary_for_job::Builder {
        crate::model::job_execution_summary_for_job::Builder::default()
    }
}

/// <p>The name and ARN of a fleet metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FleetMetricNameAndArn {
    /// <p>The fleet metric name.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The fleet metric ARN.</p>
    pub metric_arn: std::option::Option<std::string::String>,
}
impl FleetMetricNameAndArn {
    /// <p>The fleet metric name.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The fleet metric ARN.</p>
    pub fn metric_arn(&self) -> std::option::Option<&str> {
        self.metric_arn.as_deref()
    }
}
impl std::fmt::Debug for FleetMetricNameAndArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FleetMetricNameAndArn");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_arn", &self.metric_arn);
        formatter.finish()
    }
}
/// See [`FleetMetricNameAndArn`](crate::model::FleetMetricNameAndArn)
pub mod fleet_metric_name_and_arn {
    /// A builder for [`FleetMetricNameAndArn`](crate::model::FleetMetricNameAndArn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The fleet metric name.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The fleet metric name.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The fleet metric ARN.</p>
        pub fn metric_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_arn = Some(input.into());
            self
        }
        /// <p>The fleet metric ARN.</p>
        pub fn set_metric_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`FleetMetricNameAndArn`](crate::model::FleetMetricNameAndArn)
        pub fn build(self) -> crate::model::FleetMetricNameAndArn {
            crate::model::FleetMetricNameAndArn {
                metric_name: self.metric_name,
                metric_arn: self.metric_arn,
            }
        }
    }
}
impl FleetMetricNameAndArn {
    /// Creates a new builder-style object to manufacture [`FleetMetricNameAndArn`](crate::model::FleetMetricNameAndArn)
    pub fn builder() -> crate::model::fleet_metric_name_and_arn::Builder {
        crate::model::fleet_metric_name_and_arn::Builder::default()
    }
}

/// <p>The summary of a domain configuration. A domain configuration specifies custom IoT-specific information about a domain.
/// A domain configuration can be associated with an Amazon Web Services-managed domain
/// (for example, dbc123defghijk.iot.us-west-2.amazonaws.com), a customer managed domain, or a default endpoint.</p>
/// <ul>
/// <li>
/// <p>Data</p>
/// </li>
/// <li>
/// <p>Jobs</p>
/// </li>
/// <li>
/// <p>CredentialProvider</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainConfigurationSummary {
    /// <p>The name of the domain configuration. This value must be unique to a region.</p>
    pub domain_configuration_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the domain configuration.</p>
    pub domain_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The type of service delivered by the endpoint.</p>
    pub service_type: std::option::Option<crate::model::ServiceType>,
}
impl DomainConfigurationSummary {
    /// <p>The name of the domain configuration. This value must be unique to a region.</p>
    pub fn domain_configuration_name(&self) -> std::option::Option<&str> {
        self.domain_configuration_name.as_deref()
    }
    /// <p>The ARN of the domain configuration.</p>
    pub fn domain_configuration_arn(&self) -> std::option::Option<&str> {
        self.domain_configuration_arn.as_deref()
    }
    /// <p>The type of service delivered by the endpoint.</p>
    pub fn service_type(&self) -> std::option::Option<&crate::model::ServiceType> {
        self.service_type.as_ref()
    }
}
impl std::fmt::Debug for DomainConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainConfigurationSummary");
        formatter.field("domain_configuration_name", &self.domain_configuration_name);
        formatter.field("domain_configuration_arn", &self.domain_configuration_arn);
        formatter.field("service_type", &self.service_type);
        formatter.finish()
    }
}
/// See [`DomainConfigurationSummary`](crate::model::DomainConfigurationSummary)
pub mod domain_configuration_summary {
    /// A builder for [`DomainConfigurationSummary`](crate::model::DomainConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_configuration_name: std::option::Option<std::string::String>,
        pub(crate) domain_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) service_type: std::option::Option<crate::model::ServiceType>,
    }
    impl Builder {
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn domain_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the domain configuration. This value must be unique to a region.</p>
        pub fn set_domain_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_name = input;
            self
        }
        /// <p>The ARN of the domain configuration.</p>
        pub fn domain_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_configuration_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the domain configuration.</p>
        pub fn set_domain_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_configuration_arn = input;
            self
        }
        /// <p>The type of service delivered by the endpoint.</p>
        pub fn service_type(mut self, input: crate::model::ServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The type of service delivered by the endpoint.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::ServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainConfigurationSummary`](crate::model::DomainConfigurationSummary)
        pub fn build(self) -> crate::model::DomainConfigurationSummary {
            crate::model::DomainConfigurationSummary {
                domain_configuration_name: self.domain_configuration_name,
                domain_configuration_arn: self.domain_configuration_arn,
                service_type: self.service_type,
            }
        }
    }
}
impl DomainConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`DomainConfigurationSummary`](crate::model::DomainConfigurationSummary)
    pub fn builder() -> crate::model::domain_configuration_summary::Builder {
        crate::model::domain_configuration_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceType {
    #[allow(missing_docs)] // documentation missing in model
    CredentialProvider,
    #[allow(missing_docs)] // documentation missing in model
    Data,
    #[allow(missing_docs)] // documentation missing in model
    Jobs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceType {
    fn from(s: &str) -> Self {
        match s {
            "CREDENTIAL_PROVIDER" => ServiceType::CredentialProvider,
            "DATA" => ServiceType::Data,
            "JOBS" => ServiceType::Jobs,
            other => ServiceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceType::from(s))
    }
}
impl ServiceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceType::CredentialProvider => "CREDENTIAL_PROVIDER",
            ServiceType::Data => "DATA",
            ServiceType::Jobs => "JOBS",
            ServiceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREDENTIAL_PROVIDER", "DATA", "JOBS"]
    }
}
impl AsRef<str> for ServiceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// The summary of the mitigation action tasks.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectMitigationActionsTaskSummary {
    /// <p>
    /// The unique identifier of the task.
    /// </p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>
    /// The status of the task.
    /// </p>
    pub task_status: std::option::Option<crate::model::DetectMitigationActionsTaskStatus>,
    /// <p>
    /// The date the task started.
    /// </p>
    pub task_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The date the task ended.
    /// </p>
    pub task_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// Specifies the ML Detect findings to which the mitigation actions are applied.
    /// </p>
    pub target: std::option::Option<crate::model::DetectMitigationActionsTaskTarget>,
    /// <p>
    /// Specifies the time period of which violation events occurred between.
    /// </p>
    pub violation_event_occurrence_range:
        std::option::Option<crate::model::ViolationEventOccurrenceRange>,
    /// <p>
    /// Includes only active violations.
    /// </p>
    pub only_active_violations_included: bool,
    /// <p>
    /// Includes suppressed alerts.
    /// </p>
    pub suppressed_alerts_included: bool,
    /// <p>
    /// The definition of the actions.
    /// </p>
    pub actions_definition: std::option::Option<std::vec::Vec<crate::model::MitigationAction>>,
    /// <p>
    /// The statistics of a mitigation action task.
    /// </p>
    pub task_statistics: std::option::Option<crate::model::DetectMitigationActionsTaskStatistics>,
}
impl DetectMitigationActionsTaskSummary {
    /// <p>
    /// The unique identifier of the task.
    /// </p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>
    /// The status of the task.
    /// </p>
    pub fn task_status(
        &self,
    ) -> std::option::Option<&crate::model::DetectMitigationActionsTaskStatus> {
        self.task_status.as_ref()
    }
    /// <p>
    /// The date the task started.
    /// </p>
    pub fn task_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.task_start_time.as_ref()
    }
    /// <p>
    /// The date the task ended.
    /// </p>
    pub fn task_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.task_end_time.as_ref()
    }
    /// <p>
    /// Specifies the ML Detect findings to which the mitigation actions are applied.
    /// </p>
    pub fn target(&self) -> std::option::Option<&crate::model::DetectMitigationActionsTaskTarget> {
        self.target.as_ref()
    }
    /// <p>
    /// Specifies the time period of which violation events occurred between.
    /// </p>
    pub fn violation_event_occurrence_range(
        &self,
    ) -> std::option::Option<&crate::model::ViolationEventOccurrenceRange> {
        self.violation_event_occurrence_range.as_ref()
    }
    /// <p>
    /// Includes only active violations.
    /// </p>
    pub fn only_active_violations_included(&self) -> bool {
        self.only_active_violations_included
    }
    /// <p>
    /// Includes suppressed alerts.
    /// </p>
    pub fn suppressed_alerts_included(&self) -> bool {
        self.suppressed_alerts_included
    }
    /// <p>
    /// The definition of the actions.
    /// </p>
    pub fn actions_definition(&self) -> std::option::Option<&[crate::model::MitigationAction]> {
        self.actions_definition.as_deref()
    }
    /// <p>
    /// The statistics of a mitigation action task.
    /// </p>
    pub fn task_statistics(
        &self,
    ) -> std::option::Option<&crate::model::DetectMitigationActionsTaskStatistics> {
        self.task_statistics.as_ref()
    }
}
impl std::fmt::Debug for DetectMitigationActionsTaskSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectMitigationActionsTaskSummary");
        formatter.field("task_id", &self.task_id);
        formatter.field("task_status", &self.task_status);
        formatter.field("task_start_time", &self.task_start_time);
        formatter.field("task_end_time", &self.task_end_time);
        formatter.field("target", &self.target);
        formatter.field(
            "violation_event_occurrence_range",
            &self.violation_event_occurrence_range,
        );
        formatter.field(
            "only_active_violations_included",
            &self.only_active_violations_included,
        );
        formatter.field(
            "suppressed_alerts_included",
            &self.suppressed_alerts_included,
        );
        formatter.field("actions_definition", &self.actions_definition);
        formatter.field("task_statistics", &self.task_statistics);
        formatter.finish()
    }
}
/// See [`DetectMitigationActionsTaskSummary`](crate::model::DetectMitigationActionsTaskSummary)
pub mod detect_mitigation_actions_task_summary {
    /// A builder for [`DetectMitigationActionsTaskSummary`](crate::model::DetectMitigationActionsTaskSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) task_status:
            std::option::Option<crate::model::DetectMitigationActionsTaskStatus>,
        pub(crate) task_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) task_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) target: std::option::Option<crate::model::DetectMitigationActionsTaskTarget>,
        pub(crate) violation_event_occurrence_range:
            std::option::Option<crate::model::ViolationEventOccurrenceRange>,
        pub(crate) only_active_violations_included: std::option::Option<bool>,
        pub(crate) suppressed_alerts_included: std::option::Option<bool>,
        pub(crate) actions_definition:
            std::option::Option<std::vec::Vec<crate::model::MitigationAction>>,
        pub(crate) task_statistics:
            std::option::Option<crate::model::DetectMitigationActionsTaskStatistics>,
    }
    impl Builder {
        /// <p>
        /// The unique identifier of the task.
        /// </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier of the task.
        /// </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>
        /// The status of the task.
        /// </p>
        pub fn task_status(
            mut self,
            input: crate::model::DetectMitigationActionsTaskStatus,
        ) -> Self {
            self.task_status = Some(input);
            self
        }
        /// <p>
        /// The status of the task.
        /// </p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::DetectMitigationActionsTaskStatus>,
        ) -> Self {
            self.task_status = input;
            self
        }
        /// <p>
        /// The date the task started.
        /// </p>
        pub fn task_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.task_start_time = Some(input);
            self
        }
        /// <p>
        /// The date the task started.
        /// </p>
        pub fn set_task_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.task_start_time = input;
            self
        }
        /// <p>
        /// The date the task ended.
        /// </p>
        pub fn task_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.task_end_time = Some(input);
            self
        }
        /// <p>
        /// The date the task ended.
        /// </p>
        pub fn set_task_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.task_end_time = input;
            self
        }
        /// <p>
        /// Specifies the ML Detect findings to which the mitigation actions are applied.
        /// </p>
        pub fn target(mut self, input: crate::model::DetectMitigationActionsTaskTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>
        /// Specifies the ML Detect findings to which the mitigation actions are applied.
        /// </p>
        pub fn set_target(
            mut self,
            input: std::option::Option<crate::model::DetectMitigationActionsTaskTarget>,
        ) -> Self {
            self.target = input;
            self
        }
        /// <p>
        /// Specifies the time period of which violation events occurred between.
        /// </p>
        pub fn violation_event_occurrence_range(
            mut self,
            input: crate::model::ViolationEventOccurrenceRange,
        ) -> Self {
            self.violation_event_occurrence_range = Some(input);
            self
        }
        /// <p>
        /// Specifies the time period of which violation events occurred between.
        /// </p>
        pub fn set_violation_event_occurrence_range(
            mut self,
            input: std::option::Option<crate::model::ViolationEventOccurrenceRange>,
        ) -> Self {
            self.violation_event_occurrence_range = input;
            self
        }
        /// <p>
        /// Includes only active violations.
        /// </p>
        pub fn only_active_violations_included(mut self, input: bool) -> Self {
            self.only_active_violations_included = Some(input);
            self
        }
        /// <p>
        /// Includes only active violations.
        /// </p>
        pub fn set_only_active_violations_included(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.only_active_violations_included = input;
            self
        }
        /// <p>
        /// Includes suppressed alerts.
        /// </p>
        pub fn suppressed_alerts_included(mut self, input: bool) -> Self {
            self.suppressed_alerts_included = Some(input);
            self
        }
        /// <p>
        /// Includes suppressed alerts.
        /// </p>
        pub fn set_suppressed_alerts_included(mut self, input: std::option::Option<bool>) -> Self {
            self.suppressed_alerts_included = input;
            self
        }
        /// Appends an item to `actions_definition`.
        ///
        /// To override the contents of this collection use [`set_actions_definition`](Self::set_actions_definition).
        ///
        /// <p>
        /// The definition of the actions.
        /// </p>
        pub fn actions_definition(
            mut self,
            input: impl Into<crate::model::MitigationAction>,
        ) -> Self {
            let mut v = self.actions_definition.unwrap_or_default();
            v.push(input.into());
            self.actions_definition = Some(v);
            self
        }
        /// <p>
        /// The definition of the actions.
        /// </p>
        pub fn set_actions_definition(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MitigationAction>>,
        ) -> Self {
            self.actions_definition = input;
            self
        }
        /// <p>
        /// The statistics of a mitigation action task.
        /// </p>
        pub fn task_statistics(
            mut self,
            input: crate::model::DetectMitigationActionsTaskStatistics,
        ) -> Self {
            self.task_statistics = Some(input);
            self
        }
        /// <p>
        /// The statistics of a mitigation action task.
        /// </p>
        pub fn set_task_statistics(
            mut self,
            input: std::option::Option<crate::model::DetectMitigationActionsTaskStatistics>,
        ) -> Self {
            self.task_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectMitigationActionsTaskSummary`](crate::model::DetectMitigationActionsTaskSummary)
        pub fn build(self) -> crate::model::DetectMitigationActionsTaskSummary {
            crate::model::DetectMitigationActionsTaskSummary {
                task_id: self.task_id,
                task_status: self.task_status,
                task_start_time: self.task_start_time,
                task_end_time: self.task_end_time,
                target: self.target,
                violation_event_occurrence_range: self.violation_event_occurrence_range,
                only_active_violations_included: self
                    .only_active_violations_included
                    .unwrap_or_default(),
                suppressed_alerts_included: self.suppressed_alerts_included.unwrap_or_default(),
                actions_definition: self.actions_definition,
                task_statistics: self.task_statistics,
            }
        }
    }
}
impl DetectMitigationActionsTaskSummary {
    /// Creates a new builder-style object to manufacture [`DetectMitigationActionsTaskSummary`](crate::model::DetectMitigationActionsTaskSummary)
    pub fn builder() -> crate::model::detect_mitigation_actions_task_summary::Builder {
        crate::model::detect_mitigation_actions_task_summary::Builder::default()
    }
}

/// <p>
/// The statistics of a mitigation action task.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectMitigationActionsTaskStatistics {
    /// <p>
    /// The actions that were performed.
    /// </p>
    pub actions_executed: std::option::Option<i64>,
    /// <p>
    /// The actions that were skipped.
    /// </p>
    pub actions_skipped: std::option::Option<i64>,
    /// <p>
    /// The actions that failed.
    /// </p>
    pub actions_failed: std::option::Option<i64>,
}
impl DetectMitigationActionsTaskStatistics {
    /// <p>
    /// The actions that were performed.
    /// </p>
    pub fn actions_executed(&self) -> std::option::Option<i64> {
        self.actions_executed
    }
    /// <p>
    /// The actions that were skipped.
    /// </p>
    pub fn actions_skipped(&self) -> std::option::Option<i64> {
        self.actions_skipped
    }
    /// <p>
    /// The actions that failed.
    /// </p>
    pub fn actions_failed(&self) -> std::option::Option<i64> {
        self.actions_failed
    }
}
impl std::fmt::Debug for DetectMitigationActionsTaskStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectMitigationActionsTaskStatistics");
        formatter.field("actions_executed", &self.actions_executed);
        formatter.field("actions_skipped", &self.actions_skipped);
        formatter.field("actions_failed", &self.actions_failed);
        formatter.finish()
    }
}
/// See [`DetectMitigationActionsTaskStatistics`](crate::model::DetectMitigationActionsTaskStatistics)
pub mod detect_mitigation_actions_task_statistics {
    /// A builder for [`DetectMitigationActionsTaskStatistics`](crate::model::DetectMitigationActionsTaskStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions_executed: std::option::Option<i64>,
        pub(crate) actions_skipped: std::option::Option<i64>,
        pub(crate) actions_failed: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>
        /// The actions that were performed.
        /// </p>
        pub fn actions_executed(mut self, input: i64) -> Self {
            self.actions_executed = Some(input);
            self
        }
        /// <p>
        /// The actions that were performed.
        /// </p>
        pub fn set_actions_executed(mut self, input: std::option::Option<i64>) -> Self {
            self.actions_executed = input;
            self
        }
        /// <p>
        /// The actions that were skipped.
        /// </p>
        pub fn actions_skipped(mut self, input: i64) -> Self {
            self.actions_skipped = Some(input);
            self
        }
        /// <p>
        /// The actions that were skipped.
        /// </p>
        pub fn set_actions_skipped(mut self, input: std::option::Option<i64>) -> Self {
            self.actions_skipped = input;
            self
        }
        /// <p>
        /// The actions that failed.
        /// </p>
        pub fn actions_failed(mut self, input: i64) -> Self {
            self.actions_failed = Some(input);
            self
        }
        /// <p>
        /// The actions that failed.
        /// </p>
        pub fn set_actions_failed(mut self, input: std::option::Option<i64>) -> Self {
            self.actions_failed = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectMitigationActionsTaskStatistics`](crate::model::DetectMitigationActionsTaskStatistics)
        pub fn build(self) -> crate::model::DetectMitigationActionsTaskStatistics {
            crate::model::DetectMitigationActionsTaskStatistics {
                actions_executed: self.actions_executed,
                actions_skipped: self.actions_skipped,
                actions_failed: self.actions_failed,
            }
        }
    }
}
impl DetectMitigationActionsTaskStatistics {
    /// Creates a new builder-style object to manufacture [`DetectMitigationActionsTaskStatistics`](crate::model::DetectMitigationActionsTaskStatistics)
    pub fn builder() -> crate::model::detect_mitigation_actions_task_statistics::Builder {
        crate::model::detect_mitigation_actions_task_statistics::Builder::default()
    }
}

/// <p>Describes which changes should be applied as part of a mitigation action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MitigationAction {
    /// <p>A user-friendly name for the mitigation action.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the mitigation action.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The IAM role ARN used to apply this mitigation action.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.</p>
    pub action_params: std::option::Option<crate::model::MitigationActionParams>,
}
impl MitigationAction {
    /// <p>A user-friendly name for the mitigation action.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A unique identifier for the mitigation action.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The IAM role ARN used to apply this mitigation action.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.</p>
    pub fn action_params(&self) -> std::option::Option<&crate::model::MitigationActionParams> {
        self.action_params.as_ref()
    }
}
impl std::fmt::Debug for MitigationAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MitigationAction");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("action_params", &self.action_params);
        formatter.finish()
    }
}
/// See [`MitigationAction`](crate::model::MitigationAction)
pub mod mitigation_action {
    /// A builder for [`MitigationAction`](crate::model::MitigationAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) action_params: std::option::Option<crate::model::MitigationActionParams>,
    }
    impl Builder {
        /// <p>A user-friendly name for the mitigation action.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-friendly name for the mitigation action.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique identifier for the mitigation action.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the mitigation action.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The IAM role ARN used to apply this mitigation action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role ARN used to apply this mitigation action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.</p>
        pub fn action_params(mut self, input: crate::model::MitigationActionParams) -> Self {
            self.action_params = Some(input);
            self
        }
        /// <p>The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.</p>
        pub fn set_action_params(
            mut self,
            input: std::option::Option<crate::model::MitigationActionParams>,
        ) -> Self {
            self.action_params = input;
            self
        }
        /// Consumes the builder and constructs a [`MitigationAction`](crate::model::MitigationAction)
        pub fn build(self) -> crate::model::MitigationAction {
            crate::model::MitigationAction {
                name: self.name,
                id: self.id,
                role_arn: self.role_arn,
                action_params: self.action_params,
            }
        }
    }
}
impl MitigationAction {
    /// Creates a new builder-style object to manufacture [`MitigationAction`](crate::model::MitigationAction)
    pub fn builder() -> crate::model::mitigation_action::Builder {
        crate::model::mitigation_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetectMitigationActionsTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetectMitigationActionsTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => DetectMitigationActionsTaskStatus::Canceled,
            "FAILED" => DetectMitigationActionsTaskStatus::Failed,
            "IN_PROGRESS" => DetectMitigationActionsTaskStatus::InProgress,
            "SUCCESSFUL" => DetectMitigationActionsTaskStatus::Successful,
            other => DetectMitigationActionsTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetectMitigationActionsTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetectMitigationActionsTaskStatus::from(s))
    }
}
impl DetectMitigationActionsTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetectMitigationActionsTaskStatus::Canceled => "CANCELED",
            DetectMitigationActionsTaskStatus::Failed => "FAILED",
            DetectMitigationActionsTaskStatus::InProgress => "IN_PROGRESS",
            DetectMitigationActionsTaskStatus::Successful => "SUCCESSFUL",
            DetectMitigationActionsTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELED", "FAILED", "IN_PROGRESS", "SUCCESSFUL"]
    }
}
impl AsRef<str> for DetectMitigationActionsTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Describes which mitigation actions should be executed.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectMitigationActionExecution {
    /// <p>
    /// The unique identifier of the task.
    /// </p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>
    /// The unique identifier of the violation.
    /// </p>
    pub violation_id: std::option::Option<std::string::String>,
    /// <p>
    /// The friendly name that uniquely identifies the mitigation action.
    /// </p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the thing.
    /// </p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>
    /// The date a mitigation action was started.
    /// </p>
    pub execution_start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The date a mitigation action ended.
    /// </p>
    pub execution_end_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The status of a mitigation action.
    /// </p>
    pub status: std::option::Option<crate::model::DetectMitigationActionExecutionStatus>,
    /// <p>
    /// The error code of a mitigation action.
    /// </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>
    /// The message of a mitigation action.
    /// </p>
    pub message: std::option::Option<std::string::String>,
}
impl DetectMitigationActionExecution {
    /// <p>
    /// The unique identifier of the task.
    /// </p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>
    /// The unique identifier of the violation.
    /// </p>
    pub fn violation_id(&self) -> std::option::Option<&str> {
        self.violation_id.as_deref()
    }
    /// <p>
    /// The friendly name that uniquely identifies the mitigation action.
    /// </p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>
    /// The name of the thing.
    /// </p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>
    /// The date a mitigation action was started.
    /// </p>
    pub fn execution_start_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.execution_start_date.as_ref()
    }
    /// <p>
    /// The date a mitigation action ended.
    /// </p>
    pub fn execution_end_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.execution_end_date.as_ref()
    }
    /// <p>
    /// The status of a mitigation action.
    /// </p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::DetectMitigationActionExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>
    /// The error code of a mitigation action.
    /// </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>
    /// The message of a mitigation action.
    /// </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DetectMitigationActionExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectMitigationActionExecution");
        formatter.field("task_id", &self.task_id);
        formatter.field("violation_id", &self.violation_id);
        formatter.field("action_name", &self.action_name);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("execution_start_date", &self.execution_start_date);
        formatter.field("execution_end_date", &self.execution_end_date);
        formatter.field("status", &self.status);
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DetectMitigationActionExecution`](crate::model::DetectMitigationActionExecution)
pub mod detect_mitigation_action_execution {
    /// A builder for [`DetectMitigationActionExecution`](crate::model::DetectMitigationActionExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) violation_id: std::option::Option<std::string::String>,
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) execution_start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_end_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::DetectMitigationActionExecutionStatus>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The unique identifier of the task.
        /// </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier of the task.
        /// </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>
        /// The unique identifier of the violation.
        /// </p>
        pub fn violation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier of the violation.
        /// </p>
        pub fn set_violation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.violation_id = input;
            self
        }
        /// <p>
        /// The friendly name that uniquely identifies the mitigation action.
        /// </p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>
        /// The friendly name that uniquely identifies the mitigation action.
        /// </p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>
        /// The name of the thing.
        /// </p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the thing.
        /// </p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>
        /// The date a mitigation action was started.
        /// </p>
        pub fn execution_start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_start_date = Some(input);
            self
        }
        /// <p>
        /// The date a mitigation action was started.
        /// </p>
        pub fn set_execution_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_start_date = input;
            self
        }
        /// <p>
        /// The date a mitigation action ended.
        /// </p>
        pub fn execution_end_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_end_date = Some(input);
            self
        }
        /// <p>
        /// The date a mitigation action ended.
        /// </p>
        pub fn set_execution_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_end_date = input;
            self
        }
        /// <p>
        /// The status of a mitigation action.
        /// </p>
        pub fn status(
            mut self,
            input: crate::model::DetectMitigationActionExecutionStatus,
        ) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of a mitigation action.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetectMitigationActionExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// The error code of a mitigation action.
        /// </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>
        /// The error code of a mitigation action.
        /// </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>
        /// The message of a mitigation action.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>
        /// The message of a mitigation action.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectMitigationActionExecution`](crate::model::DetectMitigationActionExecution)
        pub fn build(self) -> crate::model::DetectMitigationActionExecution {
            crate::model::DetectMitigationActionExecution {
                task_id: self.task_id,
                violation_id: self.violation_id,
                action_name: self.action_name,
                thing_name: self.thing_name,
                execution_start_date: self.execution_start_date,
                execution_end_date: self.execution_end_date,
                status: self.status,
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl DetectMitigationActionExecution {
    /// Creates a new builder-style object to manufacture [`DetectMitigationActionExecution`](crate::model::DetectMitigationActionExecution)
    pub fn builder() -> crate::model::detect_mitigation_action_execution::Builder {
        crate::model::detect_mitigation_action_execution::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetectMitigationActionExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetectMitigationActionExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DetectMitigationActionExecutionStatus::Failed,
            "IN_PROGRESS" => DetectMitigationActionExecutionStatus::InProgress,
            "SKIPPED" => DetectMitigationActionExecutionStatus::Skipped,
            "SUCCESSFUL" => DetectMitigationActionExecutionStatus::Successful,
            other => DetectMitigationActionExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetectMitigationActionExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetectMitigationActionExecutionStatus::from(s))
    }
}
impl DetectMitigationActionExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetectMitigationActionExecutionStatus::Failed => "FAILED",
            DetectMitigationActionExecutionStatus::InProgress => "IN_PROGRESS",
            DetectMitigationActionExecutionStatus::Skipped => "SKIPPED",
            DetectMitigationActionExecutionStatus::Successful => "SUCCESSFUL",
            DetectMitigationActionExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SKIPPED", "SUCCESSFUL"]
    }
}
impl AsRef<str> for DetectMitigationActionExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>The ARN of the certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the
    /// certificate ID.)</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The status of the certificate.</p>
    /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    pub status: std::option::Option<crate::model::CertificateStatus>,
    /// <p>The mode of the certificate.</p>
    pub certificate_mode: std::option::Option<crate::model::CertificateMode>,
    /// <p>The date and time the certificate was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl Certificate {
    /// <p>The ARN of the certificate.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The ID of the certificate. (The last part of the certificate ARN contains the
    /// certificate ID.)</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The status of the certificate.</p>
    /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CertificateStatus> {
        self.status.as_ref()
    }
    /// <p>The mode of the certificate.</p>
    pub fn certificate_mode(&self) -> std::option::Option<&crate::model::CertificateMode> {
        self.certificate_mode.as_ref()
    }
    /// <p>The date and time the certificate was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("status", &self.status);
        formatter.field("certificate_mode", &self.certificate_mode);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CertificateStatus>,
        pub(crate) certificate_mode: std::option::Option<crate::model::CertificateMode>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the
        /// certificate ID.)</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the certificate. (The last part of the certificate ARN contains the
        /// certificate ID.)</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The status of the certificate.</p>
        /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
        pub fn status(mut self, input: crate::model::CertificateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the certificate.</p>
        /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The mode of the certificate.</p>
        pub fn certificate_mode(mut self, input: crate::model::CertificateMode) -> Self {
            self.certificate_mode = Some(input);
            self
        }
        /// <p>The mode of the certificate.</p>
        pub fn set_certificate_mode(
            mut self,
            input: std::option::Option<crate::model::CertificateMode>,
        ) -> Self {
            self.certificate_mode = input;
            self
        }
        /// <p>The date and time the certificate was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time the certificate was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
                status: self.status,
                certificate_mode: self.certificate_mode,
                creation_date: self.creation_date,
            }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateMode {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    SniOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateMode {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => CertificateMode::Default,
            "SNI_ONLY" => CertificateMode::SniOnly,
            other => CertificateMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateMode::from(s))
    }
}
impl CertificateMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateMode::Default => "DEFAULT",
            CertificateMode::SniOnly => "SNI_ONLY",
            CertificateMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "SNI_ONLY"]
    }
}
impl AsRef<str> for CertificateMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A CA certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaCertificate {
    /// <p>The ARN of the CA certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the CA certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The status of the CA certificate.</p>
    /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    pub status: std::option::Option<crate::model::CaCertificateStatus>,
    /// <p>The date the CA certificate was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl CaCertificate {
    /// <p>The ARN of the CA certificate.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The ID of the CA certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The status of the CA certificate.</p>
    /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CaCertificateStatus> {
        self.status.as_ref()
    }
    /// <p>The date the CA certificate was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for CaCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaCertificate");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`CaCertificate`](crate::model::CaCertificate)
pub mod ca_certificate {
    /// A builder for [`CaCertificate`](crate::model::CaCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CaCertificateStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the CA certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the CA certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The ID of the CA certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the CA certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The status of the CA certificate.</p>
        /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
        pub fn status(mut self, input: crate::model::CaCertificateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the CA certificate.</p>
        /// <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CaCertificateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date the CA certificate was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the CA certificate was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`CaCertificate`](crate::model::CaCertificate)
        pub fn build(self) -> crate::model::CaCertificate {
            crate::model::CaCertificate {
                certificate_arn: self.certificate_arn,
                certificate_id: self.certificate_id,
                status: self.status,
                creation_date: self.creation_date,
            }
        }
    }
}
impl CaCertificate {
    /// Creates a new builder-style object to manufacture [`CaCertificate`](crate::model::CaCertificate)
    pub fn builder() -> crate::model::ca_certificate::Builder {
        crate::model::ca_certificate::Builder::default()
    }
}

/// <p>The authorizer summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizerSummary {
    /// <p>The authorizer name.</p>
    pub authorizer_name: std::option::Option<std::string::String>,
    /// <p>The authorizer ARN.</p>
    pub authorizer_arn: std::option::Option<std::string::String>,
}
impl AuthorizerSummary {
    /// <p>The authorizer name.</p>
    pub fn authorizer_name(&self) -> std::option::Option<&str> {
        self.authorizer_name.as_deref()
    }
    /// <p>The authorizer ARN.</p>
    pub fn authorizer_arn(&self) -> std::option::Option<&str> {
        self.authorizer_arn.as_deref()
    }
}
impl std::fmt::Debug for AuthorizerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizerSummary");
        formatter.field("authorizer_name", &self.authorizer_name);
        formatter.field("authorizer_arn", &self.authorizer_arn);
        formatter.finish()
    }
}
/// See [`AuthorizerSummary`](crate::model::AuthorizerSummary)
pub mod authorizer_summary {
    /// A builder for [`AuthorizerSummary`](crate::model::AuthorizerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_name: std::option::Option<std::string::String>,
        pub(crate) authorizer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The authorizer name.</p>
        pub fn authorizer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_name = Some(input.into());
            self
        }
        /// <p>The authorizer name.</p>
        pub fn set_authorizer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_name = input;
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn authorizer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_arn = Some(input.into());
            self
        }
        /// <p>The authorizer ARN.</p>
        pub fn set_authorizer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizerSummary`](crate::model::AuthorizerSummary)
        pub fn build(self) -> crate::model::AuthorizerSummary {
            crate::model::AuthorizerSummary {
                authorizer_name: self.authorizer_name,
                authorizer_arn: self.authorizer_arn,
            }
        }
    }
}
impl AuthorizerSummary {
    /// Creates a new builder-style object to manufacture [`AuthorizerSummary`](crate::model::AuthorizerSummary)
    pub fn builder() -> crate::model::authorizer_summary::Builder {
        crate::model::authorizer_summary::Builder::default()
    }
}

/// <p>The audits that were performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditTaskMetadata {
    /// <p>The ID of this audit.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The status of this audit. One of "IN_PROGRESS", "COMPLETED",
    /// "FAILED", or "CANCELED".</p>
    pub task_status: std::option::Option<crate::model::AuditTaskStatus>,
    /// <p>The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
    pub task_type: std::option::Option<crate::model::AuditTaskType>,
}
impl AuditTaskMetadata {
    /// <p>The ID of this audit.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The status of this audit. One of "IN_PROGRESS", "COMPLETED",
    /// "FAILED", or "CANCELED".</p>
    pub fn task_status(&self) -> std::option::Option<&crate::model::AuditTaskStatus> {
        self.task_status.as_ref()
    }
    /// <p>The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
    pub fn task_type(&self) -> std::option::Option<&crate::model::AuditTaskType> {
        self.task_type.as_ref()
    }
}
impl std::fmt::Debug for AuditTaskMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditTaskMetadata");
        formatter.field("task_id", &self.task_id);
        formatter.field("task_status", &self.task_status);
        formatter.field("task_type", &self.task_type);
        formatter.finish()
    }
}
/// See [`AuditTaskMetadata`](crate::model::AuditTaskMetadata)
pub mod audit_task_metadata {
    /// A builder for [`AuditTaskMetadata`](crate::model::AuditTaskMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) task_status: std::option::Option<crate::model::AuditTaskStatus>,
        pub(crate) task_type: std::option::Option<crate::model::AuditTaskType>,
    }
    impl Builder {
        /// <p>The ID of this audit.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of this audit.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The status of this audit. One of "IN_PROGRESS", "COMPLETED",
        /// "FAILED", or "CANCELED".</p>
        pub fn task_status(mut self, input: crate::model::AuditTaskStatus) -> Self {
            self.task_status = Some(input);
            self
        }
        /// <p>The status of this audit. One of "IN_PROGRESS", "COMPLETED",
        /// "FAILED", or "CANCELED".</p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::AuditTaskStatus>,
        ) -> Self {
            self.task_status = input;
            self
        }
        /// <p>The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
        pub fn task_type(mut self, input: crate::model::AuditTaskType) -> Self {
            self.task_type = Some(input);
            self
        }
        /// <p>The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>
        pub fn set_task_type(
            mut self,
            input: std::option::Option<crate::model::AuditTaskType>,
        ) -> Self {
            self.task_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditTaskMetadata`](crate::model::AuditTaskMetadata)
        pub fn build(self) -> crate::model::AuditTaskMetadata {
            crate::model::AuditTaskMetadata {
                task_id: self.task_id,
                task_status: self.task_status,
                task_type: self.task_type,
            }
        }
    }
}
impl AuditTaskMetadata {
    /// Creates a new builder-style object to manufacture [`AuditTaskMetadata`](crate::model::AuditTaskMetadata)
    pub fn builder() -> crate::model::audit_task_metadata::Builder {
        crate::model::audit_task_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditTaskType {
    #[allow(missing_docs)] // documentation missing in model
    OnDemandAuditTask,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledAuditTask,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditTaskType {
    fn from(s: &str) -> Self {
        match s {
            "ON_DEMAND_AUDIT_TASK" => AuditTaskType::OnDemandAuditTask,
            "SCHEDULED_AUDIT_TASK" => AuditTaskType::ScheduledAuditTask,
            other => AuditTaskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditTaskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditTaskType::from(s))
    }
}
impl AuditTaskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditTaskType::OnDemandAuditTask => "ON_DEMAND_AUDIT_TASK",
            AuditTaskType::ScheduledAuditTask => "SCHEDULED_AUDIT_TASK",
            AuditTaskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ON_DEMAND_AUDIT_TASK", "SCHEDULED_AUDIT_TASK"]
    }
}
impl AsRef<str> for AuditTaskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => AuditTaskStatus::Canceled,
            "COMPLETED" => AuditTaskStatus::Completed,
            "FAILED" => AuditTaskStatus::Failed,
            "IN_PROGRESS" => AuditTaskStatus::InProgress,
            other => AuditTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditTaskStatus::from(s))
    }
}
impl AuditTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditTaskStatus::Canceled => "CANCELED",
            AuditTaskStatus::Completed => "COMPLETED",
            AuditTaskStatus::Failed => "FAILED",
            AuditTaskStatus::InProgress => "IN_PROGRESS",
            AuditTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELED", "COMPLETED", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for AuditTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Filters out specific findings of a Device Defender audit. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditSuppression {
    /// <p>An audit check name. Checks must be enabled
    /// for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list
    /// of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code>
    /// to select which checks are enabled.)</p>
    pub check_name: std::option::Option<std::string::String>,
    /// <p>Information that identifies the noncompliant resource.</p>
    pub resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
    /// <p>
    /// The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to.
    /// </p>
    pub expiration_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// Indicates whether a suppression should exist indefinitely or not.
    /// </p>
    pub suppress_indefinitely: std::option::Option<bool>,
    /// <p>
    /// The description of the audit suppression.
    /// </p>
    pub description: std::option::Option<std::string::String>,
}
impl AuditSuppression {
    /// <p>An audit check name. Checks must be enabled
    /// for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list
    /// of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code>
    /// to select which checks are enabled.)</p>
    pub fn check_name(&self) -> std::option::Option<&str> {
        self.check_name.as_deref()
    }
    /// <p>Information that identifies the noncompliant resource.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&crate::model::ResourceIdentifier> {
        self.resource_identifier.as_ref()
    }
    /// <p>
    /// The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to.
    /// </p>
    pub fn expiration_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expiration_date.as_ref()
    }
    /// <p>
    /// Indicates whether a suppression should exist indefinitely or not.
    /// </p>
    pub fn suppress_indefinitely(&self) -> std::option::Option<bool> {
        self.suppress_indefinitely
    }
    /// <p>
    /// The description of the audit suppression.
    /// </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for AuditSuppression {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditSuppression");
        formatter.field("check_name", &self.check_name);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("suppress_indefinitely", &self.suppress_indefinitely);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`AuditSuppression`](crate::model::AuditSuppression)
pub mod audit_suppression {
    /// A builder for [`AuditSuppression`](crate::model::AuditSuppression)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) check_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) suppress_indefinitely: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An audit check name. Checks must be enabled
        /// for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list
        /// of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code>
        /// to select which checks are enabled.)</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_name = Some(input.into());
            self
        }
        /// <p>An audit check name. Checks must be enabled
        /// for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list
        /// of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code>
        /// to select which checks are enabled.)</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_name = input;
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>
        /// The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to.
        /// </p>
        pub fn expiration_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>
        /// The expiration date (epoch timestamp in seconds) that you want the suppression to adhere to.
        /// </p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p>
        /// Indicates whether a suppression should exist indefinitely or not.
        /// </p>
        pub fn suppress_indefinitely(mut self, input: bool) -> Self {
            self.suppress_indefinitely = Some(input);
            self
        }
        /// <p>
        /// Indicates whether a suppression should exist indefinitely or not.
        /// </p>
        pub fn set_suppress_indefinitely(mut self, input: std::option::Option<bool>) -> Self {
            self.suppress_indefinitely = input;
            self
        }
        /// <p>
        /// The description of the audit suppression.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// The description of the audit suppression.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditSuppression`](crate::model::AuditSuppression)
        pub fn build(self) -> crate::model::AuditSuppression {
            crate::model::AuditSuppression {
                check_name: self.check_name,
                resource_identifier: self.resource_identifier,
                expiration_date: self.expiration_date,
                suppress_indefinitely: self.suppress_indefinitely,
                description: self.description,
            }
        }
    }
}
impl AuditSuppression {
    /// Creates a new builder-style object to manufacture [`AuditSuppression`](crate::model::AuditSuppression)
    pub fn builder() -> crate::model::audit_suppression::Builder {
        crate::model::audit_suppression::Builder::default()
    }
}

/// <p>Information about an audit mitigation actions task that is returned by <code>ListAuditMitigationActionsTasks</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditMitigationActionsTaskMetadata {
    /// <p>The unique identifier for the task.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The time at which the audit mitigation actions task was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current state of the audit mitigation actions task.</p>
    pub task_status: std::option::Option<crate::model::AuditMitigationActionsTaskStatus>,
}
impl AuditMitigationActionsTaskMetadata {
    /// <p>The unique identifier for the task.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The time at which the audit mitigation actions task was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The current state of the audit mitigation actions task.</p>
    pub fn task_status(
        &self,
    ) -> std::option::Option<&crate::model::AuditMitigationActionsTaskStatus> {
        self.task_status.as_ref()
    }
}
impl std::fmt::Debug for AuditMitigationActionsTaskMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditMitigationActionsTaskMetadata");
        formatter.field("task_id", &self.task_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("task_status", &self.task_status);
        formatter.finish()
    }
}
/// See [`AuditMitigationActionsTaskMetadata`](crate::model::AuditMitigationActionsTaskMetadata)
pub mod audit_mitigation_actions_task_metadata {
    /// A builder for [`AuditMitigationActionsTaskMetadata`](crate::model::AuditMitigationActionsTaskMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) task_status: std::option::Option<crate::model::AuditMitigationActionsTaskStatus>,
    }
    impl Builder {
        /// <p>The unique identifier for the task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The time at which the audit mitigation actions task was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time at which the audit mitigation actions task was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The current state of the audit mitigation actions task.</p>
        pub fn task_status(
            mut self,
            input: crate::model::AuditMitigationActionsTaskStatus,
        ) -> Self {
            self.task_status = Some(input);
            self
        }
        /// <p>The current state of the audit mitigation actions task.</p>
        pub fn set_task_status(
            mut self,
            input: std::option::Option<crate::model::AuditMitigationActionsTaskStatus>,
        ) -> Self {
            self.task_status = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditMitigationActionsTaskMetadata`](crate::model::AuditMitigationActionsTaskMetadata)
        pub fn build(self) -> crate::model::AuditMitigationActionsTaskMetadata {
            crate::model::AuditMitigationActionsTaskMetadata {
                task_id: self.task_id,
                start_time: self.start_time,
                task_status: self.task_status,
            }
        }
    }
}
impl AuditMitigationActionsTaskMetadata {
    /// Creates a new builder-style object to manufacture [`AuditMitigationActionsTaskMetadata`](crate::model::AuditMitigationActionsTaskMetadata)
    pub fn builder() -> crate::model::audit_mitigation_actions_task_metadata::Builder {
        crate::model::audit_mitigation_actions_task_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditMitigationActionsTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditMitigationActionsTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => AuditMitigationActionsTaskStatus::Canceled,
            "COMPLETED" => AuditMitigationActionsTaskStatus::Completed,
            "FAILED" => AuditMitigationActionsTaskStatus::Failed,
            "IN_PROGRESS" => AuditMitigationActionsTaskStatus::InProgress,
            other => AuditMitigationActionsTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditMitigationActionsTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditMitigationActionsTaskStatus::from(s))
    }
}
impl AuditMitigationActionsTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditMitigationActionsTaskStatus::Canceled => "CANCELED",
            AuditMitigationActionsTaskStatus::Completed => "COMPLETED",
            AuditMitigationActionsTaskStatus::Failed => "FAILED",
            AuditMitigationActionsTaskStatus::InProgress => "IN_PROGRESS",
            AuditMitigationActionsTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELED", "COMPLETED", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for AuditMitigationActionsTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returned by ListAuditMitigationActionsTask, this object contains information that describes a mitigation action that has been started.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditMitigationActionExecutionMetadata {
    /// <p>The unique identifier for the task that applies the mitigation action.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the findings to which the task and associated mitigation action are applied.</p>
    pub finding_id: std::option::Option<std::string::String>,
    /// <p>The friendly name of the mitigation action being applied by the task.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the mitigation action being applied by the task.</p>
    pub action_id: std::option::Option<std::string::String>,
    /// <p>The current status of the task being executed.</p>
    pub status: std::option::Option<crate::model::AuditMitigationActionsExecutionStatus>,
    /// <p>The date and time when the task was started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the task was completed or canceled. Blank if the task is still running.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If an error occurred, the code that indicates which type of error occurred.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>If an error occurred, a message that describes the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl AuditMitigationActionExecutionMetadata {
    /// <p>The unique identifier for the task that applies the mitigation action.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The unique identifier for the findings to which the task and associated mitigation action are applied.</p>
    pub fn finding_id(&self) -> std::option::Option<&str> {
        self.finding_id.as_deref()
    }
    /// <p>The friendly name of the mitigation action being applied by the task.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The unique identifier for the mitigation action being applied by the task.</p>
    pub fn action_id(&self) -> std::option::Option<&str> {
        self.action_id.as_deref()
    }
    /// <p>The current status of the task being executed.</p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::AuditMitigationActionsExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time when the task was started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The date and time when the task was completed or canceled. Blank if the task is still running.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>If an error occurred, the code that indicates which type of error occurred.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>If an error occurred, a message that describes the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for AuditMitigationActionExecutionMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditMitigationActionExecutionMetadata");
        formatter.field("task_id", &self.task_id);
        formatter.field("finding_id", &self.finding_id);
        formatter.field("action_name", &self.action_name);
        formatter.field("action_id", &self.action_id);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`AuditMitigationActionExecutionMetadata`](crate::model::AuditMitigationActionExecutionMetadata)
pub mod audit_mitigation_action_execution_metadata {
    /// A builder for [`AuditMitigationActionExecutionMetadata`](crate::model::AuditMitigationActionExecutionMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) finding_id: std::option::Option<std::string::String>,
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) action_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AuditMitigationActionsExecutionStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the task that applies the mitigation action.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the task that applies the mitigation action.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The unique identifier for the findings to which the task and associated mitigation action are applied.</p>
        pub fn finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the findings to which the task and associated mitigation action are applied.</p>
        pub fn set_finding_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.finding_id = input;
            self
        }
        /// <p>The friendly name of the mitigation action being applied by the task.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the mitigation action being applied by the task.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The unique identifier for the mitigation action being applied by the task.</p>
        pub fn action_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the mitigation action being applied by the task.</p>
        pub fn set_action_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_id = input;
            self
        }
        /// <p>The current status of the task being executed.</p>
        pub fn status(
            mut self,
            input: crate::model::AuditMitigationActionsExecutionStatus,
        ) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the task being executed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuditMitigationActionsExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the task was started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time when the task was started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time when the task was completed or canceled. Blank if the task is still running.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time when the task was completed or canceled. Blank if the task is still running.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>If an error occurred, the code that indicates which type of error occurred.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>If an error occurred, the code that indicates which type of error occurred.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>If an error occurred, a message that describes the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If an error occurred, a message that describes the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditMitigationActionExecutionMetadata`](crate::model::AuditMitigationActionExecutionMetadata)
        pub fn build(self) -> crate::model::AuditMitigationActionExecutionMetadata {
            crate::model::AuditMitigationActionExecutionMetadata {
                task_id: self.task_id,
                finding_id: self.finding_id,
                action_name: self.action_name,
                action_id: self.action_id,
                status: self.status,
                start_time: self.start_time,
                end_time: self.end_time,
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl AuditMitigationActionExecutionMetadata {
    /// Creates a new builder-style object to manufacture [`AuditMitigationActionExecutionMetadata`](crate::model::AuditMitigationActionExecutionMetadata)
    pub fn builder() -> crate::model::audit_mitigation_action_execution_metadata::Builder {
        crate::model::audit_mitigation_action_execution_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditMitigationActionsExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditMitigationActionsExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => AuditMitigationActionsExecutionStatus::Canceled,
            "COMPLETED" => AuditMitigationActionsExecutionStatus::Completed,
            "FAILED" => AuditMitigationActionsExecutionStatus::Failed,
            "IN_PROGRESS" => AuditMitigationActionsExecutionStatus::InProgress,
            "PENDING" => AuditMitigationActionsExecutionStatus::Pending,
            "SKIPPED" => AuditMitigationActionsExecutionStatus::Skipped,
            other => AuditMitigationActionsExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditMitigationActionsExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditMitigationActionsExecutionStatus::from(s))
    }
}
impl AuditMitigationActionsExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditMitigationActionsExecutionStatus::Canceled => "CANCELED",
            AuditMitigationActionsExecutionStatus::Completed => "COMPLETED",
            AuditMitigationActionsExecutionStatus::Failed => "FAILED",
            AuditMitigationActionsExecutionStatus::InProgress => "IN_PROGRESS",
            AuditMitigationActionsExecutionStatus::Pending => "PENDING",
            AuditMitigationActionsExecutionStatus::Skipped => "SKIPPED",
            AuditMitigationActionsExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "COMPLETED",
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "SKIPPED",
        ]
    }
}
impl AsRef<str> for AuditMitigationActionsExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The findings (results) of the audit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuditFinding {
    /// <p>A unique identifier for this set of audit findings. This identifier is used to apply
    /// mitigation tasks to one or more sets of findings.</p>
    pub finding_id: std::option::Option<std::string::String>,
    /// <p>The ID of the audit that generated this result (finding).</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The audit check that generated this result.</p>
    pub check_name: std::option::Option<std::string::String>,
    /// <p>The time the audit started.</p>
    pub task_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the result (finding) was discovered.</p>
    pub finding_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The severity of the result (finding).</p>
    pub severity: std::option::Option<crate::model::AuditFindingSeverity>,
    /// <p>The resource that was found to be noncompliant with the
    /// audit check.</p>
    pub non_compliant_resource: std::option::Option<crate::model::NonCompliantResource>,
    /// <p>The list of related resources.</p>
    pub related_resources: std::option::Option<std::vec::Vec<crate::model::RelatedResource>>,
    /// <p>The reason the resource was noncompliant.</p>
    pub reason_for_non_compliance: std::option::Option<std::string::String>,
    /// <p>A code that indicates the reason that the resource was noncompliant.</p>
    pub reason_for_non_compliance_code: std::option::Option<std::string::String>,
    /// <p>
    /// Indicates whether the audit finding was suppressed or not during reporting.
    /// </p>
    pub is_suppressed: std::option::Option<bool>,
}
impl AuditFinding {
    /// <p>A unique identifier for this set of audit findings. This identifier is used to apply
    /// mitigation tasks to one or more sets of findings.</p>
    pub fn finding_id(&self) -> std::option::Option<&str> {
        self.finding_id.as_deref()
    }
    /// <p>The ID of the audit that generated this result (finding).</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The audit check that generated this result.</p>
    pub fn check_name(&self) -> std::option::Option<&str> {
        self.check_name.as_deref()
    }
    /// <p>The time the audit started.</p>
    pub fn task_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.task_start_time.as_ref()
    }
    /// <p>The time the result (finding) was discovered.</p>
    pub fn finding_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.finding_time.as_ref()
    }
    /// <p>The severity of the result (finding).</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::AuditFindingSeverity> {
        self.severity.as_ref()
    }
    /// <p>The resource that was found to be noncompliant with the
    /// audit check.</p>
    pub fn non_compliant_resource(
        &self,
    ) -> std::option::Option<&crate::model::NonCompliantResource> {
        self.non_compliant_resource.as_ref()
    }
    /// <p>The list of related resources.</p>
    pub fn related_resources(&self) -> std::option::Option<&[crate::model::RelatedResource]> {
        self.related_resources.as_deref()
    }
    /// <p>The reason the resource was noncompliant.</p>
    pub fn reason_for_non_compliance(&self) -> std::option::Option<&str> {
        self.reason_for_non_compliance.as_deref()
    }
    /// <p>A code that indicates the reason that the resource was noncompliant.</p>
    pub fn reason_for_non_compliance_code(&self) -> std::option::Option<&str> {
        self.reason_for_non_compliance_code.as_deref()
    }
    /// <p>
    /// Indicates whether the audit finding was suppressed or not during reporting.
    /// </p>
    pub fn is_suppressed(&self) -> std::option::Option<bool> {
        self.is_suppressed
    }
}
impl std::fmt::Debug for AuditFinding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuditFinding");
        formatter.field("finding_id", &self.finding_id);
        formatter.field("task_id", &self.task_id);
        formatter.field("check_name", &self.check_name);
        formatter.field("task_start_time", &self.task_start_time);
        formatter.field("finding_time", &self.finding_time);
        formatter.field("severity", &self.severity);
        formatter.field("non_compliant_resource", &self.non_compliant_resource);
        formatter.field("related_resources", &self.related_resources);
        formatter.field("reason_for_non_compliance", &self.reason_for_non_compliance);
        formatter.field(
            "reason_for_non_compliance_code",
            &self.reason_for_non_compliance_code,
        );
        formatter.field("is_suppressed", &self.is_suppressed);
        formatter.finish()
    }
}
/// See [`AuditFinding`](crate::model::AuditFinding)
pub mod audit_finding {
    /// A builder for [`AuditFinding`](crate::model::AuditFinding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_id: std::option::Option<std::string::String>,
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) check_name: std::option::Option<std::string::String>,
        pub(crate) task_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) finding_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) severity: std::option::Option<crate::model::AuditFindingSeverity>,
        pub(crate) non_compliant_resource: std::option::Option<crate::model::NonCompliantResource>,
        pub(crate) related_resources:
            std::option::Option<std::vec::Vec<crate::model::RelatedResource>>,
        pub(crate) reason_for_non_compliance: std::option::Option<std::string::String>,
        pub(crate) reason_for_non_compliance_code: std::option::Option<std::string::String>,
        pub(crate) is_suppressed: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A unique identifier for this set of audit findings. This identifier is used to apply
        /// mitigation tasks to one or more sets of findings.</p>
        pub fn finding_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for this set of audit findings. This identifier is used to apply
        /// mitigation tasks to one or more sets of findings.</p>
        pub fn set_finding_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.finding_id = input;
            self
        }
        /// <p>The ID of the audit that generated this result (finding).</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the audit that generated this result (finding).</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The audit check that generated this result.</p>
        pub fn check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.check_name = Some(input.into());
            self
        }
        /// <p>The audit check that generated this result.</p>
        pub fn set_check_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.check_name = input;
            self
        }
        /// <p>The time the audit started.</p>
        pub fn task_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.task_start_time = Some(input);
            self
        }
        /// <p>The time the audit started.</p>
        pub fn set_task_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.task_start_time = input;
            self
        }
        /// <p>The time the result (finding) was discovered.</p>
        pub fn finding_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.finding_time = Some(input);
            self
        }
        /// <p>The time the result (finding) was discovered.</p>
        pub fn set_finding_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.finding_time = input;
            self
        }
        /// <p>The severity of the result (finding).</p>
        pub fn severity(mut self, input: crate::model::AuditFindingSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the result (finding).</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::AuditFindingSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The resource that was found to be noncompliant with the
        /// audit check.</p>
        pub fn non_compliant_resource(mut self, input: crate::model::NonCompliantResource) -> Self {
            self.non_compliant_resource = Some(input);
            self
        }
        /// <p>The resource that was found to be noncompliant with the
        /// audit check.</p>
        pub fn set_non_compliant_resource(
            mut self,
            input: std::option::Option<crate::model::NonCompliantResource>,
        ) -> Self {
            self.non_compliant_resource = input;
            self
        }
        /// Appends an item to `related_resources`.
        ///
        /// To override the contents of this collection use [`set_related_resources`](Self::set_related_resources).
        ///
        /// <p>The list of related resources.</p>
        pub fn related_resources(
            mut self,
            input: impl Into<crate::model::RelatedResource>,
        ) -> Self {
            let mut v = self.related_resources.unwrap_or_default();
            v.push(input.into());
            self.related_resources = Some(v);
            self
        }
        /// <p>The list of related resources.</p>
        pub fn set_related_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedResource>>,
        ) -> Self {
            self.related_resources = input;
            self
        }
        /// <p>The reason the resource was noncompliant.</p>
        pub fn reason_for_non_compliance(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason_for_non_compliance = Some(input.into());
            self
        }
        /// <p>The reason the resource was noncompliant.</p>
        pub fn set_reason_for_non_compliance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reason_for_non_compliance = input;
            self
        }
        /// <p>A code that indicates the reason that the resource was noncompliant.</p>
        pub fn reason_for_non_compliance_code(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reason_for_non_compliance_code = Some(input.into());
            self
        }
        /// <p>A code that indicates the reason that the resource was noncompliant.</p>
        pub fn set_reason_for_non_compliance_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reason_for_non_compliance_code = input;
            self
        }
        /// <p>
        /// Indicates whether the audit finding was suppressed or not during reporting.
        /// </p>
        pub fn is_suppressed(mut self, input: bool) -> Self {
            self.is_suppressed = Some(input);
            self
        }
        /// <p>
        /// Indicates whether the audit finding was suppressed or not during reporting.
        /// </p>
        pub fn set_is_suppressed(mut self, input: std::option::Option<bool>) -> Self {
            self.is_suppressed = input;
            self
        }
        /// Consumes the builder and constructs a [`AuditFinding`](crate::model::AuditFinding)
        pub fn build(self) -> crate::model::AuditFinding {
            crate::model::AuditFinding {
                finding_id: self.finding_id,
                task_id: self.task_id,
                check_name: self.check_name,
                task_start_time: self.task_start_time,
                finding_time: self.finding_time,
                severity: self.severity,
                non_compliant_resource: self.non_compliant_resource,
                related_resources: self.related_resources,
                reason_for_non_compliance: self.reason_for_non_compliance,
                reason_for_non_compliance_code: self.reason_for_non_compliance_code,
                is_suppressed: self.is_suppressed,
            }
        }
    }
}
impl AuditFinding {
    /// Creates a new builder-style object to manufacture [`AuditFinding`](crate::model::AuditFinding)
    pub fn builder() -> crate::model::audit_finding::Builder {
        crate::model::audit_finding::Builder::default()
    }
}

/// <p>Information about a related resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelatedResource {
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Information that identifies the resource.</p>
    pub resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
    /// <p>Other information about the resource.</p>
    pub additional_info:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl RelatedResource {
    /// <p>The type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Information that identifies the resource.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&crate::model::ResourceIdentifier> {
        self.resource_identifier.as_ref()
    }
    /// <p>Other information about the resource.</p>
    pub fn additional_info(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.additional_info.as_ref()
    }
}
impl std::fmt::Debug for RelatedResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelatedResource");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("additional_info", &self.additional_info);
        formatter.finish()
    }
}
/// See [`RelatedResource`](crate::model::RelatedResource)
pub mod related_resource {
    /// A builder for [`RelatedResource`](crate::model::RelatedResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
        pub(crate) additional_info: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Information that identifies the resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Adds a key-value pair to `additional_info`.
        ///
        /// To override the contents of this collection use [`set_additional_info`](Self::set_additional_info).
        ///
        /// <p>Other information about the resource.</p>
        pub fn additional_info(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_info.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_info = Some(hash_map);
            self
        }
        /// <p>Other information about the resource.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_info = input;
            self
        }
        /// Consumes the builder and constructs a [`RelatedResource`](crate::model::RelatedResource)
        pub fn build(self) -> crate::model::RelatedResource {
            crate::model::RelatedResource {
                resource_type: self.resource_type,
                resource_identifier: self.resource_identifier,
                additional_info: self.additional_info,
            }
        }
    }
}
impl RelatedResource {
    /// Creates a new builder-style object to manufacture [`RelatedResource`](crate::model::RelatedResource)
    pub fn builder() -> crate::model::related_resource::Builder {
        crate::model::related_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AccountSettings,
    #[allow(missing_docs)] // documentation missing in model
    CaCertificate,
    #[allow(missing_docs)] // documentation missing in model
    ClientId,
    #[allow(missing_docs)] // documentation missing in model
    CognitoIdentityPool,
    #[allow(missing_docs)] // documentation missing in model
    DeviceCertificate,
    #[allow(missing_docs)] // documentation missing in model
    IamRole,
    #[allow(missing_docs)] // documentation missing in model
    IotPolicy,
    #[allow(missing_docs)] // documentation missing in model
    RoleAlias,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_SETTINGS" => ResourceType::AccountSettings,
            "CA_CERTIFICATE" => ResourceType::CaCertificate,
            "CLIENT_ID" => ResourceType::ClientId,
            "COGNITO_IDENTITY_POOL" => ResourceType::CognitoIdentityPool,
            "DEVICE_CERTIFICATE" => ResourceType::DeviceCertificate,
            "IAM_ROLE" => ResourceType::IamRole,
            "IOT_POLICY" => ResourceType::IotPolicy,
            "ROLE_ALIAS" => ResourceType::RoleAlias,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::AccountSettings => "ACCOUNT_SETTINGS",
            ResourceType::CaCertificate => "CA_CERTIFICATE",
            ResourceType::ClientId => "CLIENT_ID",
            ResourceType::CognitoIdentityPool => "COGNITO_IDENTITY_POOL",
            ResourceType::DeviceCertificate => "DEVICE_CERTIFICATE",
            ResourceType::IamRole => "IAM_ROLE",
            ResourceType::IotPolicy => "IOT_POLICY",
            ResourceType::RoleAlias => "ROLE_ALIAS",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_SETTINGS",
            "CA_CERTIFICATE",
            "CLIENT_ID",
            "COGNITO_IDENTITY_POOL",
            "DEVICE_CERTIFICATE",
            "IAM_ROLE",
            "IOT_POLICY",
            "ROLE_ALIAS",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the resource that was noncompliant with the audit check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NonCompliantResource {
    /// <p>The type of the noncompliant resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Information that identifies the noncompliant resource.</p>
    pub resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
    /// <p>Other information about the noncompliant resource.</p>
    pub additional_info:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl NonCompliantResource {
    /// <p>The type of the noncompliant resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Information that identifies the noncompliant resource.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&crate::model::ResourceIdentifier> {
        self.resource_identifier.as_ref()
    }
    /// <p>Other information about the noncompliant resource.</p>
    pub fn additional_info(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.additional_info.as_ref()
    }
}
impl std::fmt::Debug for NonCompliantResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NonCompliantResource");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("additional_info", &self.additional_info);
        formatter.finish()
    }
}
/// See [`NonCompliantResource`](crate::model::NonCompliantResource)
pub mod non_compliant_resource {
    /// A builder for [`NonCompliantResource`](crate::model::NonCompliantResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_identifier: std::option::Option<crate::model::ResourceIdentifier>,
        pub(crate) additional_info: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The type of the noncompliant resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the noncompliant resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn resource_identifier(mut self, input: crate::model::ResourceIdentifier) -> Self {
            self.resource_identifier = Some(input);
            self
        }
        /// <p>Information that identifies the noncompliant resource.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<crate::model::ResourceIdentifier>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Adds a key-value pair to `additional_info`.
        ///
        /// To override the contents of this collection use [`set_additional_info`](Self::set_additional_info).
        ///
        /// <p>Other information about the noncompliant resource.</p>
        pub fn additional_info(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_info.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_info = Some(hash_map);
            self
        }
        /// <p>Other information about the noncompliant resource.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_info = input;
            self
        }
        /// Consumes the builder and constructs a [`NonCompliantResource`](crate::model::NonCompliantResource)
        pub fn build(self) -> crate::model::NonCompliantResource {
            crate::model::NonCompliantResource {
                resource_type: self.resource_type,
                resource_identifier: self.resource_identifier,
                additional_info: self.additional_info,
            }
        }
    }
}
impl NonCompliantResource {
    /// Creates a new builder-style object to manufacture [`NonCompliantResource`](crate::model::NonCompliantResource)
    pub fn builder() -> crate::model::non_compliant_resource::Builder {
        crate::model::non_compliant_resource::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuditFindingSeverity {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuditFindingSeverity {
    fn from(s: &str) -> Self {
        match s {
            "CRITICAL" => AuditFindingSeverity::Critical,
            "HIGH" => AuditFindingSeverity::High,
            "LOW" => AuditFindingSeverity::Low,
            "MEDIUM" => AuditFindingSeverity::Medium,
            other => AuditFindingSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuditFindingSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuditFindingSeverity::from(s))
    }
}
impl AuditFindingSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuditFindingSeverity::Critical => "CRITICAL",
            AuditFindingSeverity::High => "HIGH",
            AuditFindingSeverity::Low => "LOW",
            AuditFindingSeverity::Medium => "MEDIUM",
            AuditFindingSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CRITICAL", "HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for AuditFindingSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an active Device Defender security profile behavior violation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveViolation {
    /// <p>The ID of the active violation.</p>
    pub violation_id: std::option::Option<std::string::String>,
    /// <p>The name of the thing responsible for the active violation.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The security profile with the behavior is in violation.</p>
    pub security_profile_name: std::option::Option<std::string::String>,
    /// <p>The behavior that is being violated.</p>
    pub behavior: std::option::Option<crate::model::Behavior>,
    /// <p>The value of the metric (the measurement) that caused the most recent violation.</p>
    pub last_violation_value: std::option::Option<crate::model::MetricValue>,
    /// <p>
    /// The details of a violation event.
    /// </p>
    pub violation_event_additional_info:
        std::option::Option<crate::model::ViolationEventAdditionalInfo>,
    /// <p>The verification state of the violation (detect alarm).</p>
    pub verification_state: std::option::Option<crate::model::VerificationState>,
    /// <p>The description of the verification state of the violation.</p>
    pub verification_state_description: std::option::Option<std::string::String>,
    /// <p>The time the most recent violation occurred.</p>
    pub last_violation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the violation started.</p>
    pub violation_start_time: std::option::Option<aws_smithy_types::Instant>,
}
impl ActiveViolation {
    /// <p>The ID of the active violation.</p>
    pub fn violation_id(&self) -> std::option::Option<&str> {
        self.violation_id.as_deref()
    }
    /// <p>The name of the thing responsible for the active violation.</p>
    pub fn thing_name(&self) -> std::option::Option<&str> {
        self.thing_name.as_deref()
    }
    /// <p>The security profile with the behavior is in violation.</p>
    pub fn security_profile_name(&self) -> std::option::Option<&str> {
        self.security_profile_name.as_deref()
    }
    /// <p>The behavior that is being violated.</p>
    pub fn behavior(&self) -> std::option::Option<&crate::model::Behavior> {
        self.behavior.as_ref()
    }
    /// <p>The value of the metric (the measurement) that caused the most recent violation.</p>
    pub fn last_violation_value(&self) -> std::option::Option<&crate::model::MetricValue> {
        self.last_violation_value.as_ref()
    }
    /// <p>
    /// The details of a violation event.
    /// </p>
    pub fn violation_event_additional_info(
        &self,
    ) -> std::option::Option<&crate::model::ViolationEventAdditionalInfo> {
        self.violation_event_additional_info.as_ref()
    }
    /// <p>The verification state of the violation (detect alarm).</p>
    pub fn verification_state(&self) -> std::option::Option<&crate::model::VerificationState> {
        self.verification_state.as_ref()
    }
    /// <p>The description of the verification state of the violation.</p>
    pub fn verification_state_description(&self) -> std::option::Option<&str> {
        self.verification_state_description.as_deref()
    }
    /// <p>The time the most recent violation occurred.</p>
    pub fn last_violation_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_violation_time.as_ref()
    }
    /// <p>The time the violation started.</p>
    pub fn violation_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.violation_start_time.as_ref()
    }
}
impl std::fmt::Debug for ActiveViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveViolation");
        formatter.field("violation_id", &self.violation_id);
        formatter.field("thing_name", &self.thing_name);
        formatter.field("security_profile_name", &self.security_profile_name);
        formatter.field("behavior", &self.behavior);
        formatter.field("last_violation_value", &self.last_violation_value);
        formatter.field(
            "violation_event_additional_info",
            &self.violation_event_additional_info,
        );
        formatter.field("verification_state", &self.verification_state);
        formatter.field(
            "verification_state_description",
            &self.verification_state_description,
        );
        formatter.field("last_violation_time", &self.last_violation_time);
        formatter.field("violation_start_time", &self.violation_start_time);
        formatter.finish()
    }
}
/// See [`ActiveViolation`](crate::model::ActiveViolation)
pub mod active_violation {
    /// A builder for [`ActiveViolation`](crate::model::ActiveViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) violation_id: std::option::Option<std::string::String>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) behavior: std::option::Option<crate::model::Behavior>,
        pub(crate) last_violation_value: std::option::Option<crate::model::MetricValue>,
        pub(crate) violation_event_additional_info:
            std::option::Option<crate::model::ViolationEventAdditionalInfo>,
        pub(crate) verification_state: std::option::Option<crate::model::VerificationState>,
        pub(crate) verification_state_description: std::option::Option<std::string::String>,
        pub(crate) last_violation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) violation_start_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the active violation.</p>
        pub fn violation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.violation_id = Some(input.into());
            self
        }
        /// <p>The ID of the active violation.</p>
        pub fn set_violation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.violation_id = input;
            self
        }
        /// <p>The name of the thing responsible for the active violation.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the thing responsible for the active violation.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The security profile with the behavior is in violation.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The security profile with the behavior is in violation.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The behavior that is being violated.</p>
        pub fn behavior(mut self, input: crate::model::Behavior) -> Self {
            self.behavior = Some(input);
            self
        }
        /// <p>The behavior that is being violated.</p>
        pub fn set_behavior(mut self, input: std::option::Option<crate::model::Behavior>) -> Self {
            self.behavior = input;
            self
        }
        /// <p>The value of the metric (the measurement) that caused the most recent violation.</p>
        pub fn last_violation_value(mut self, input: crate::model::MetricValue) -> Self {
            self.last_violation_value = Some(input);
            self
        }
        /// <p>The value of the metric (the measurement) that caused the most recent violation.</p>
        pub fn set_last_violation_value(
            mut self,
            input: std::option::Option<crate::model::MetricValue>,
        ) -> Self {
            self.last_violation_value = input;
            self
        }
        /// <p>
        /// The details of a violation event.
        /// </p>
        pub fn violation_event_additional_info(
            mut self,
            input: crate::model::ViolationEventAdditionalInfo,
        ) -> Self {
            self.violation_event_additional_info = Some(input);
            self
        }
        /// <p>
        /// The details of a violation event.
        /// </p>
        pub fn set_violation_event_additional_info(
            mut self,
            input: std::option::Option<crate::model::ViolationEventAdditionalInfo>,
        ) -> Self {
            self.violation_event_additional_info = input;
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn verification_state(mut self, input: crate::model::VerificationState) -> Self {
            self.verification_state = Some(input);
            self
        }
        /// <p>The verification state of the violation (detect alarm).</p>
        pub fn set_verification_state(
            mut self,
            input: std::option::Option<crate::model::VerificationState>,
        ) -> Self {
            self.verification_state = input;
            self
        }
        /// <p>The description of the verification state of the violation.</p>
        pub fn verification_state_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.verification_state_description = Some(input.into());
            self
        }
        /// <p>The description of the verification state of the violation.</p>
        pub fn set_verification_state_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.verification_state_description = input;
            self
        }
        /// <p>The time the most recent violation occurred.</p>
        pub fn last_violation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_violation_time = Some(input);
            self
        }
        /// <p>The time the most recent violation occurred.</p>
        pub fn set_last_violation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_violation_time = input;
            self
        }
        /// <p>The time the violation started.</p>
        pub fn violation_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.violation_start_time = Some(input);
            self
        }
        /// <p>The time the violation started.</p>
        pub fn set_violation_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.violation_start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveViolation`](crate::model::ActiveViolation)
        pub fn build(self) -> crate::model::ActiveViolation {
            crate::model::ActiveViolation {
                violation_id: self.violation_id,
                thing_name: self.thing_name,
                security_profile_name: self.security_profile_name,
                behavior: self.behavior,
                last_violation_value: self.last_violation_value,
                violation_event_additional_info: self.violation_event_additional_info,
                verification_state: self.verification_state,
                verification_state_description: self.verification_state_description,
                last_violation_time: self.last_violation_time,
                violation_start_time: self.violation_start_time,
            }
        }
    }
}
impl ActiveViolation {
    /// Creates a new builder-style object to manufacture [`ActiveViolation`](crate::model::ActiveViolation)
    pub fn builder() -> crate::model::active_violation::Builder {
        crate::model::active_violation::Builder::default()
    }
}

/// <p>A topic rule destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicRuleDestination {
    /// <p>The topic rule destination URL.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the topic rule destination. Valid values are:</p>
    /// <dl>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>A topic rule destination was created but has not been confirmed. You can set
    /// <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// <dt>ENABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
    /// set <code>status</code> to <code>DISABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>DISABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
    /// can set <code>status</code> to <code>ENABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>ERROR</dt>
    /// <dd>
    /// <p>Confirmation could not be completed, for example if the confirmation timed out.
    /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
    /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::TopicRuleDestinationStatus>,
    /// <p>The date and time when the topic rule destination was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the topic rule destination was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Additional details or reason why the topic rule destination is in the current
    /// status.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Properties of the HTTP URL.</p>
    pub http_url_properties: std::option::Option<crate::model::HttpUrlDestinationProperties>,
    /// <p>Properties of the virtual private cloud (VPC) connection.</p>
    pub vpc_properties: std::option::Option<crate::model::VpcDestinationProperties>,
}
impl TopicRuleDestination {
    /// <p>The topic rule destination URL.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the topic rule destination. Valid values are:</p>
    /// <dl>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>A topic rule destination was created but has not been confirmed. You can set
    /// <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// <dt>ENABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
    /// set <code>status</code> to <code>DISABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>DISABLED</dt>
    /// <dd>
    /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
    /// can set <code>status</code> to <code>ENABLED</code> by calling
    /// <code>UpdateTopicRuleDestination</code>.</p>
    /// </dd>
    /// <dt>ERROR</dt>
    /// <dd>
    /// <p>Confirmation could not be completed, for example if the confirmation timed out.
    /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
    /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
    /// <code>UpdateTopicRuleDestination</code>. Calling
    /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
    /// be sent to your confirmation endpoint.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::TopicRuleDestinationStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time when the topic rule destination was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The date and time when the topic rule destination was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>Additional details or reason why the topic rule destination is in the current
    /// status.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>Properties of the HTTP URL.</p>
    pub fn http_url_properties(
        &self,
    ) -> std::option::Option<&crate::model::HttpUrlDestinationProperties> {
        self.http_url_properties.as_ref()
    }
    /// <p>Properties of the virtual private cloud (VPC) connection.</p>
    pub fn vpc_properties(&self) -> std::option::Option<&crate::model::VpcDestinationProperties> {
        self.vpc_properties.as_ref()
    }
}
impl std::fmt::Debug for TopicRuleDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicRuleDestination");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("http_url_properties", &self.http_url_properties);
        formatter.field("vpc_properties", &self.vpc_properties);
        formatter.finish()
    }
}
/// See [`TopicRuleDestination`](crate::model::TopicRuleDestination)
pub mod topic_rule_destination {
    /// A builder for [`TopicRuleDestination`](crate::model::TopicRuleDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TopicRuleDestinationStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) http_url_properties:
            std::option::Option<crate::model::HttpUrlDestinationProperties>,
        pub(crate) vpc_properties: std::option::Option<crate::model::VpcDestinationProperties>,
    }
    impl Builder {
        /// <p>The topic rule destination URL.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The topic rule destination URL.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the topic rule destination. Valid values are:</p>
        /// <dl>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>A topic rule destination was created but has not been confirmed. You can set
        /// <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// <dt>ENABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
        /// set <code>status</code> to <code>DISABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>DISABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
        /// can set <code>status</code> to <code>ENABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>ERROR</dt>
        /// <dd>
        /// <p>Confirmation could not be completed, for example if the confirmation timed out.
        /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
        /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::TopicRuleDestinationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the topic rule destination. Valid values are:</p>
        /// <dl>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>A topic rule destination was created but has not been confirmed. You can set
        /// <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// <dt>ENABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is allowed. You can
        /// set <code>status</code> to <code>DISABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>DISABLED</dt>
        /// <dd>
        /// <p>Confirmation was completed, and traffic to this destination is not allowed. You
        /// can set <code>status</code> to <code>ENABLED</code> by calling
        /// <code>UpdateTopicRuleDestination</code>.</p>
        /// </dd>
        /// <dt>ERROR</dt>
        /// <dd>
        /// <p>Confirmation could not be completed, for example if the confirmation timed out.
        /// You can call <code>GetTopicRuleDestination</code> for details about the error. You
        /// can set <code>status</code> to <code>IN_PROGRESS</code> by calling
        /// <code>UpdateTopicRuleDestination</code>. Calling
        /// <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to
        /// be sent to your confirmation endpoint.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TopicRuleDestinationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the topic rule destination was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time when the topic rule destination was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time when the topic rule destination was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The date and time when the topic rule destination was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>Additional details or reason why the topic rule destination is in the current
        /// status.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>Additional details or reason why the topic rule destination is in the current
        /// status.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Properties of the HTTP URL.</p>
        pub fn http_url_properties(
            mut self,
            input: crate::model::HttpUrlDestinationProperties,
        ) -> Self {
            self.http_url_properties = Some(input);
            self
        }
        /// <p>Properties of the HTTP URL.</p>
        pub fn set_http_url_properties(
            mut self,
            input: std::option::Option<crate::model::HttpUrlDestinationProperties>,
        ) -> Self {
            self.http_url_properties = input;
            self
        }
        /// <p>Properties of the virtual private cloud (VPC) connection.</p>
        pub fn vpc_properties(mut self, input: crate::model::VpcDestinationProperties) -> Self {
            self.vpc_properties = Some(input);
            self
        }
        /// <p>Properties of the virtual private cloud (VPC) connection.</p>
        pub fn set_vpc_properties(
            mut self,
            input: std::option::Option<crate::model::VpcDestinationProperties>,
        ) -> Self {
            self.vpc_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicRuleDestination`](crate::model::TopicRuleDestination)
        pub fn build(self) -> crate::model::TopicRuleDestination {
            crate::model::TopicRuleDestination {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                status_reason: self.status_reason,
                http_url_properties: self.http_url_properties,
                vpc_properties: self.vpc_properties,
            }
        }
    }
}
impl TopicRuleDestination {
    /// Creates a new builder-style object to manufacture [`TopicRuleDestination`](crate::model::TopicRuleDestination)
    pub fn builder() -> crate::model::topic_rule_destination::Builder {
        crate::model::topic_rule_destination::Builder::default()
    }
}

/// <p>The properties of a virtual private cloud (VPC) destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcDestinationProperties {
    /// <p>The subnet IDs of the VPC destination.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The security groups of the VPC destination.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl VpcDestinationProperties {
    /// <p>The subnet IDs of the VPC destination.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The security groups of the VPC destination.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The ID of the VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for VpcDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcDestinationProperties");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`VpcDestinationProperties`](crate::model::VpcDestinationProperties)
pub mod vpc_destination_properties {
    /// A builder for [`VpcDestinationProperties`](crate::model::VpcDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnet IDs of the VPC destination.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnet IDs of the VPC destination.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups of the VPC destination.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups of the VPC destination.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcDestinationProperties`](crate::model::VpcDestinationProperties)
        pub fn build(self) -> crate::model::VpcDestinationProperties {
            crate::model::VpcDestinationProperties {
                subnet_ids: self.subnet_ids,
                security_groups: self.security_groups,
                vpc_id: self.vpc_id,
                role_arn: self.role_arn,
            }
        }
    }
}
impl VpcDestinationProperties {
    /// Creates a new builder-style object to manufacture [`VpcDestinationProperties`](crate::model::VpcDestinationProperties)
    pub fn builder() -> crate::model::vpc_destination_properties::Builder {
        crate::model::vpc_destination_properties::Builder::default()
    }
}

/// <p>HTTP URL destination properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpUrlDestinationProperties {
    /// <p>The URL used to confirm the HTTP topic rule destination URL.</p>
    pub confirmation_url: std::option::Option<std::string::String>,
}
impl HttpUrlDestinationProperties {
    /// <p>The URL used to confirm the HTTP topic rule destination URL.</p>
    pub fn confirmation_url(&self) -> std::option::Option<&str> {
        self.confirmation_url.as_deref()
    }
}
impl std::fmt::Debug for HttpUrlDestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpUrlDestinationProperties");
        formatter.field("confirmation_url", &self.confirmation_url);
        formatter.finish()
    }
}
/// See [`HttpUrlDestinationProperties`](crate::model::HttpUrlDestinationProperties)
pub mod http_url_destination_properties {
    /// A builder for [`HttpUrlDestinationProperties`](crate::model::HttpUrlDestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confirmation_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL used to confirm the HTTP topic rule destination URL.</p>
        pub fn confirmation_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.confirmation_url = Some(input.into());
            self
        }
        /// <p>The URL used to confirm the HTTP topic rule destination URL.</p>
        pub fn set_confirmation_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.confirmation_url = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpUrlDestinationProperties`](crate::model::HttpUrlDestinationProperties)
        pub fn build(self) -> crate::model::HttpUrlDestinationProperties {
            crate::model::HttpUrlDestinationProperties {
                confirmation_url: self.confirmation_url,
            }
        }
    }
}
impl HttpUrlDestinationProperties {
    /// Creates a new builder-style object to manufacture [`HttpUrlDestinationProperties`](crate::model::HttpUrlDestinationProperties)
    pub fn builder() -> crate::model::http_url_destination_properties::Builder {
        crate::model::http_url_destination_properties::Builder::default()
    }
}

/// <p>Describes a rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicRule {
    /// <p>The name of the rule.</p>
    pub rule_name: std::option::Option<std::string::String>,
    /// <p>The SQL statement used to query the topic. When using a SQL query with multiple
    /// lines, be sure to escape the newline characters.</p>
    pub sql: std::option::Option<std::string::String>,
    /// <p>The description of the rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time the rule was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The actions associated with the rule.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>Specifies whether the rule is disabled.</p>
    pub rule_disabled: std::option::Option<bool>,
    /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
    pub aws_iot_sql_version: std::option::Option<std::string::String>,
    /// <p>The action to perform when an error occurs.</p>
    pub error_action: std::option::Option<crate::model::Action>,
}
impl TopicRule {
    /// <p>The name of the rule.</p>
    pub fn rule_name(&self) -> std::option::Option<&str> {
        self.rule_name.as_deref()
    }
    /// <p>The SQL statement used to query the topic. When using a SQL query with multiple
    /// lines, be sure to escape the newline characters.</p>
    pub fn sql(&self) -> std::option::Option<&str> {
        self.sql.as_deref()
    }
    /// <p>The description of the rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time the rule was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The actions associated with the rule.</p>
    pub fn actions(&self) -> std::option::Option<&[crate::model::Action]> {
        self.actions.as_deref()
    }
    /// <p>Specifies whether the rule is disabled.</p>
    pub fn rule_disabled(&self) -> std::option::Option<bool> {
        self.rule_disabled
    }
    /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
    pub fn aws_iot_sql_version(&self) -> std::option::Option<&str> {
        self.aws_iot_sql_version.as_deref()
    }
    /// <p>The action to perform when an error occurs.</p>
    pub fn error_action(&self) -> std::option::Option<&crate::model::Action> {
        self.error_action.as_ref()
    }
}
impl std::fmt::Debug for TopicRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicRule");
        formatter.field("rule_name", &self.rule_name);
        formatter.field("sql", &self.sql);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("actions", &self.actions);
        formatter.field("rule_disabled", &self.rule_disabled);
        formatter.field("aws_iot_sql_version", &self.aws_iot_sql_version);
        formatter.field("error_action", &self.error_action);
        formatter.finish()
    }
}
/// See [`TopicRule`](crate::model::TopicRule)
pub mod topic_rule {
    /// A builder for [`TopicRule`](crate::model::TopicRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_name: std::option::Option<std::string::String>,
        pub(crate) sql: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) rule_disabled: std::option::Option<bool>,
        pub(crate) aws_iot_sql_version: std::option::Option<std::string::String>,
        pub(crate) error_action: std::option::Option<crate::model::Action>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_name = input;
            self
        }
        /// <p>The SQL statement used to query the topic. When using a SQL query with multiple
        /// lines, be sure to escape the newline characters.</p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql = Some(input.into());
            self
        }
        /// <p>The SQL statement used to query the topic. When using a SQL query with multiple
        /// lines, be sure to escape the newline characters.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql = input;
            self
        }
        /// <p>The description of the rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time the rule was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time the rule was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions associated with the rule.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions associated with the rule.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn rule_disabled(mut self, input: bool) -> Self {
            self.rule_disabled = Some(input);
            self
        }
        /// <p>Specifies whether the rule is disabled.</p>
        pub fn set_rule_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.rule_disabled = input;
            self
        }
        /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
        pub fn aws_iot_sql_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_iot_sql_version = Some(input.into());
            self
        }
        /// <p>The version of the SQL rules engine to use when evaluating the rule.</p>
        pub fn set_aws_iot_sql_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_iot_sql_version = input;
            self
        }
        /// <p>The action to perform when an error occurs.</p>
        pub fn error_action(mut self, input: crate::model::Action) -> Self {
            self.error_action = Some(input);
            self
        }
        /// <p>The action to perform when an error occurs.</p>
        pub fn set_error_action(
            mut self,
            input: std::option::Option<crate::model::Action>,
        ) -> Self {
            self.error_action = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicRule`](crate::model::TopicRule)
        pub fn build(self) -> crate::model::TopicRule {
            crate::model::TopicRule {
                rule_name: self.rule_name,
                sql: self.sql,
                description: self.description,
                created_at: self.created_at,
                actions: self.actions,
                rule_disabled: self.rule_disabled,
                aws_iot_sql_version: self.aws_iot_sql_version,
                error_action: self.error_action,
            }
        }
    }
}
impl TopicRule {
    /// Creates a new builder-style object to manufacture [`TopicRule`](crate::model::TopicRule)
    pub fn builder() -> crate::model::topic_rule::Builder {
        crate::model::topic_rule::Builder::default()
    }
}

/// <p>A map of key-value pairs for all supported statistics. Currently, only count is
/// supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Statistics {
    /// <p>The count of things that match the query.</p>
    pub count: i32,
    /// <p>The average of the aggregated field values.</p>
    pub average: std::option::Option<f64>,
    /// <p>The sum of the aggregated field values.</p>
    pub sum: std::option::Option<f64>,
    /// <p>The minimum aggregated field value.</p>
    pub minimum: std::option::Option<f64>,
    /// <p>The maximum aggregated field value.</p>
    pub maximum: std::option::Option<f64>,
    /// <p>The sum of the squares of the aggregated field values.</p>
    pub sum_of_squares: std::option::Option<f64>,
    /// <p>The variance of the aggregated field values.</p>
    pub variance: std::option::Option<f64>,
    /// <p>The standard deviation of the aggregated field values.</p>
    pub std_deviation: std::option::Option<f64>,
}
impl Statistics {
    /// <p>The count of things that match the query.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
    /// <p>The average of the aggregated field values.</p>
    pub fn average(&self) -> std::option::Option<f64> {
        self.average
    }
    /// <p>The sum of the aggregated field values.</p>
    pub fn sum(&self) -> std::option::Option<f64> {
        self.sum
    }
    /// <p>The minimum aggregated field value.</p>
    pub fn minimum(&self) -> std::option::Option<f64> {
        self.minimum
    }
    /// <p>The maximum aggregated field value.</p>
    pub fn maximum(&self) -> std::option::Option<f64> {
        self.maximum
    }
    /// <p>The sum of the squares of the aggregated field values.</p>
    pub fn sum_of_squares(&self) -> std::option::Option<f64> {
        self.sum_of_squares
    }
    /// <p>The variance of the aggregated field values.</p>
    pub fn variance(&self) -> std::option::Option<f64> {
        self.variance
    }
    /// <p>The standard deviation of the aggregated field values.</p>
    pub fn std_deviation(&self) -> std::option::Option<f64> {
        self.std_deviation
    }
}
impl std::fmt::Debug for Statistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Statistics");
        formatter.field("count", &self.count);
        formatter.field("average", &self.average);
        formatter.field("sum", &self.sum);
        formatter.field("minimum", &self.minimum);
        formatter.field("maximum", &self.maximum);
        formatter.field("sum_of_squares", &self.sum_of_squares);
        formatter.field("variance", &self.variance);
        formatter.field("std_deviation", &self.std_deviation);
        formatter.finish()
    }
}
/// See [`Statistics`](crate::model::Statistics)
pub mod statistics {
    /// A builder for [`Statistics`](crate::model::Statistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i32>,
        pub(crate) average: std::option::Option<f64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
        pub(crate) maximum: std::option::Option<f64>,
        pub(crate) sum_of_squares: std::option::Option<f64>,
        pub(crate) variance: std::option::Option<f64>,
        pub(crate) std_deviation: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The count of things that match the query.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The count of things that match the query.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The average of the aggregated field values.</p>
        pub fn average(mut self, input: f64) -> Self {
            self.average = Some(input);
            self
        }
        /// <p>The average of the aggregated field values.</p>
        pub fn set_average(mut self, input: std::option::Option<f64>) -> Self {
            self.average = input;
            self
        }
        /// <p>The sum of the aggregated field values.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The sum of the aggregated field values.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The minimum aggregated field value.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>The minimum aggregated field value.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>The maximum aggregated field value.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum aggregated field value.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// <p>The sum of the squares of the aggregated field values.</p>
        pub fn sum_of_squares(mut self, input: f64) -> Self {
            self.sum_of_squares = Some(input);
            self
        }
        /// <p>The sum of the squares of the aggregated field values.</p>
        pub fn set_sum_of_squares(mut self, input: std::option::Option<f64>) -> Self {
            self.sum_of_squares = input;
            self
        }
        /// <p>The variance of the aggregated field values.</p>
        pub fn variance(mut self, input: f64) -> Self {
            self.variance = Some(input);
            self
        }
        /// <p>The variance of the aggregated field values.</p>
        pub fn set_variance(mut self, input: std::option::Option<f64>) -> Self {
            self.variance = input;
            self
        }
        /// <p>The standard deviation of the aggregated field values.</p>
        pub fn std_deviation(mut self, input: f64) -> Self {
            self.std_deviation = Some(input);
            self
        }
        /// <p>The standard deviation of the aggregated field values.</p>
        pub fn set_std_deviation(mut self, input: std::option::Option<f64>) -> Self {
            self.std_deviation = input;
            self
        }
        /// Consumes the builder and constructs a [`Statistics`](crate::model::Statistics)
        pub fn build(self) -> crate::model::Statistics {
            crate::model::Statistics {
                count: self.count.unwrap_or_default(),
                average: self.average,
                sum: self.sum,
                minimum: self.minimum,
                maximum: self.maximum,
                sum_of_squares: self.sum_of_squares,
                variance: self.variance,
                std_deviation: self.std_deviation,
            }
        }
    }
}
impl Statistics {
    /// Creates a new builder-style object to manufacture [`Statistics`](crate::model::Statistics)
    pub fn builder() -> crate::model::statistics::Builder {
        crate::model::statistics::Builder::default()
    }
}

/// <p>Describes the percentile and percentile value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PercentPair {
    /// <p>The percentile.</p>
    pub percent: f64,
    /// <p>The value of the percentile.</p>
    pub value: f64,
}
impl PercentPair {
    /// <p>The percentile.</p>
    pub fn percent(&self) -> f64 {
        self.percent
    }
    /// <p>The value of the percentile.</p>
    pub fn value(&self) -> f64 {
        self.value
    }
}
impl std::fmt::Debug for PercentPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PercentPair");
        formatter.field("percent", &self.percent);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PercentPair`](crate::model::PercentPair)
pub mod percent_pair {
    /// A builder for [`PercentPair`](crate::model::PercentPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percent: std::option::Option<f64>,
        pub(crate) value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The percentile.</p>
        pub fn percent(mut self, input: f64) -> Self {
            self.percent = Some(input);
            self
        }
        /// <p>The percentile.</p>
        pub fn set_percent(mut self, input: std::option::Option<f64>) -> Self {
            self.percent = input;
            self
        }
        /// <p>The value of the percentile.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the percentile.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PercentPair`](crate::model::PercentPair)
        pub fn build(self) -> crate::model::PercentPair {
            crate::model::PercentPair {
                percent: self.percent.unwrap_or_default(),
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl PercentPair {
    /// Creates a new builder-style object to manufacture [`PercentPair`](crate::model::PercentPair)
    pub fn builder() -> crate::model::percent_pair::Builder {
        crate::model::percent_pair::Builder::default()
    }
}

/// <p>Information about an OTA update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtaUpdateInfo {
    /// <p>The OTA update ID.</p>
    pub ota_update_id: std::option::Option<std::string::String>,
    /// <p>The OTA update ARN.</p>
    pub ota_update_arn: std::option::Option<std::string::String>,
    /// <p>The date when the OTA update was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the OTA update was last updated.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A description of the OTA update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The targets of the OTA update.</p>
    pub targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
    /// HTTP and MQTT are specified, the target device can choose the protocol.</p>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
    /// <p>Configuration for the rollout of OTA updates.</p>
    pub aws_job_executions_rollout_config:
        std::option::Option<crate::model::AwsJobExecutionsRolloutConfig>,
    /// <p>Configuration information for pre-signed URLs. Valid when <code>protocols</code>
    /// contains HTTP.</p>
    pub aws_job_presigned_url_config: std::option::Option<crate::model::AwsJobPresignedUrlConfig>,
    /// <p>Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
    /// things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also
    /// be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when
    /// the thing is added to a target group, even after the OTA update was completed by all things originally in
    /// the group. </p>
    pub target_selection: std::option::Option<crate::model::TargetSelection>,
    /// <p>A list of files associated with the OTA update.</p>
    pub ota_update_files: std::option::Option<std::vec::Vec<crate::model::OtaUpdateFile>>,
    /// <p>The status of the OTA update.</p>
    pub ota_update_status: std::option::Option<crate::model::OtaUpdateStatus>,
    /// <p>The IoT job ID associated with the OTA update.</p>
    pub aws_iot_job_id: std::option::Option<std::string::String>,
    /// <p>The IoT job ARN associated with the OTA update.</p>
    pub aws_iot_job_arn: std::option::Option<std::string::String>,
    /// <p>Error information associated with the OTA update.</p>
    pub error_info: std::option::Option<crate::model::ErrorInfo>,
    /// <p>A collection of name/value pairs</p>
    pub additional_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl OtaUpdateInfo {
    /// <p>The OTA update ID.</p>
    pub fn ota_update_id(&self) -> std::option::Option<&str> {
        self.ota_update_id.as_deref()
    }
    /// <p>The OTA update ARN.</p>
    pub fn ota_update_arn(&self) -> std::option::Option<&str> {
        self.ota_update_arn.as_deref()
    }
    /// <p>The date when the OTA update was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>The date when the OTA update was last updated.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_date.as_ref()
    }
    /// <p>A description of the OTA update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The targets of the OTA update.</p>
    pub fn targets(&self) -> std::option::Option<&[std::string::String]> {
        self.targets.as_deref()
    }
    /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
    /// HTTP and MQTT are specified, the target device can choose the protocol.</p>
    pub fn protocols(&self) -> std::option::Option<&[crate::model::Protocol]> {
        self.protocols.as_deref()
    }
    /// <p>Configuration for the rollout of OTA updates.</p>
    pub fn aws_job_executions_rollout_config(
        &self,
    ) -> std::option::Option<&crate::model::AwsJobExecutionsRolloutConfig> {
        self.aws_job_executions_rollout_config.as_ref()
    }
    /// <p>Configuration information for pre-signed URLs. Valid when <code>protocols</code>
    /// contains HTTP.</p>
    pub fn aws_job_presigned_url_config(
        &self,
    ) -> std::option::Option<&crate::model::AwsJobPresignedUrlConfig> {
        self.aws_job_presigned_url_config.as_ref()
    }
    /// <p>Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
    /// things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also
    /// be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when
    /// the thing is added to a target group, even after the OTA update was completed by all things originally in
    /// the group. </p>
    pub fn target_selection(&self) -> std::option::Option<&crate::model::TargetSelection> {
        self.target_selection.as_ref()
    }
    /// <p>A list of files associated with the OTA update.</p>
    pub fn ota_update_files(&self) -> std::option::Option<&[crate::model::OtaUpdateFile]> {
        self.ota_update_files.as_deref()
    }
    /// <p>The status of the OTA update.</p>
    pub fn ota_update_status(&self) -> std::option::Option<&crate::model::OtaUpdateStatus> {
        self.ota_update_status.as_ref()
    }
    /// <p>The IoT job ID associated with the OTA update.</p>
    pub fn aws_iot_job_id(&self) -> std::option::Option<&str> {
        self.aws_iot_job_id.as_deref()
    }
    /// <p>The IoT job ARN associated with the OTA update.</p>
    pub fn aws_iot_job_arn(&self) -> std::option::Option<&str> {
        self.aws_iot_job_arn.as_deref()
    }
    /// <p>Error information associated with the OTA update.</p>
    pub fn error_info(&self) -> std::option::Option<&crate::model::ErrorInfo> {
        self.error_info.as_ref()
    }
    /// <p>A collection of name/value pairs</p>
    pub fn additional_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.additional_parameters.as_ref()
    }
}
impl std::fmt::Debug for OtaUpdateInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtaUpdateInfo");
        formatter.field("ota_update_id", &self.ota_update_id);
        formatter.field("ota_update_arn", &self.ota_update_arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("description", &self.description);
        formatter.field("targets", &self.targets);
        formatter.field("protocols", &self.protocols);
        formatter.field(
            "aws_job_executions_rollout_config",
            &self.aws_job_executions_rollout_config,
        );
        formatter.field(
            "aws_job_presigned_url_config",
            &self.aws_job_presigned_url_config,
        );
        formatter.field("target_selection", &self.target_selection);
        formatter.field("ota_update_files", &self.ota_update_files);
        formatter.field("ota_update_status", &self.ota_update_status);
        formatter.field("aws_iot_job_id", &self.aws_iot_job_id);
        formatter.field("aws_iot_job_arn", &self.aws_iot_job_arn);
        formatter.field("error_info", &self.error_info);
        formatter.field("additional_parameters", &self.additional_parameters);
        formatter.finish()
    }
}
/// See [`OtaUpdateInfo`](crate::model::OtaUpdateInfo)
pub mod ota_update_info {
    /// A builder for [`OtaUpdateInfo`](crate::model::OtaUpdateInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ota_update_id: std::option::Option<std::string::String>,
        pub(crate) ota_update_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        pub(crate) aws_job_executions_rollout_config:
            std::option::Option<crate::model::AwsJobExecutionsRolloutConfig>,
        pub(crate) aws_job_presigned_url_config:
            std::option::Option<crate::model::AwsJobPresignedUrlConfig>,
        pub(crate) target_selection: std::option::Option<crate::model::TargetSelection>,
        pub(crate) ota_update_files:
            std::option::Option<std::vec::Vec<crate::model::OtaUpdateFile>>,
        pub(crate) ota_update_status: std::option::Option<crate::model::OtaUpdateStatus>,
        pub(crate) aws_iot_job_id: std::option::Option<std::string::String>,
        pub(crate) aws_iot_job_arn: std::option::Option<std::string::String>,
        pub(crate) error_info: std::option::Option<crate::model::ErrorInfo>,
        pub(crate) additional_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The OTA update ID.</p>
        pub fn ota_update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_id = Some(input.into());
            self
        }
        /// <p>The OTA update ID.</p>
        pub fn set_ota_update_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_id = input;
            self
        }
        /// <p>The OTA update ARN.</p>
        pub fn ota_update_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ota_update_arn = Some(input.into());
            self
        }
        /// <p>The OTA update ARN.</p>
        pub fn set_ota_update_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ota_update_arn = input;
            self
        }
        /// <p>The date when the OTA update was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the OTA update was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date when the OTA update was last updated.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date when the OTA update was last updated.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>A description of the OTA update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the OTA update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets of the OTA update.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets of the OTA update.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
        /// HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn protocols(mut self, input: impl Into<crate::model::Protocol>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
        /// HTTP and MQTT are specified, the target device can choose the protocol.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn aws_job_executions_rollout_config(
            mut self,
            input: crate::model::AwsJobExecutionsRolloutConfig,
        ) -> Self {
            self.aws_job_executions_rollout_config = Some(input);
            self
        }
        /// <p>Configuration for the rollout of OTA updates.</p>
        pub fn set_aws_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobExecutionsRolloutConfig>,
        ) -> Self {
            self.aws_job_executions_rollout_config = input;
            self
        }
        /// <p>Configuration information for pre-signed URLs. Valid when <code>protocols</code>
        /// contains HTTP.</p>
        pub fn aws_job_presigned_url_config(
            mut self,
            input: crate::model::AwsJobPresignedUrlConfig,
        ) -> Self {
            self.aws_job_presigned_url_config = Some(input);
            self
        }
        /// <p>Configuration information for pre-signed URLs. Valid when <code>protocols</code>
        /// contains HTTP.</p>
        pub fn set_aws_job_presigned_url_config(
            mut self,
            input: std::option::Option<crate::model::AwsJobPresignedUrlConfig>,
        ) -> Self {
            self.aws_job_presigned_url_config = input;
            self
        }
        /// <p>Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
        /// things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also
        /// be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when
        /// the thing is added to a target group, even after the OTA update was completed by all things originally in
        /// the group. </p>
        pub fn target_selection(mut self, input: crate::model::TargetSelection) -> Self {
            self.target_selection = Some(input);
            self
        }
        /// <p>Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
        /// things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also
        /// be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when
        /// the thing is added to a target group, even after the OTA update was completed by all things originally in
        /// the group. </p>
        pub fn set_target_selection(
            mut self,
            input: std::option::Option<crate::model::TargetSelection>,
        ) -> Self {
            self.target_selection = input;
            self
        }
        /// Appends an item to `ota_update_files`.
        ///
        /// To override the contents of this collection use [`set_ota_update_files`](Self::set_ota_update_files).
        ///
        /// <p>A list of files associated with the OTA update.</p>
        pub fn ota_update_files(mut self, input: impl Into<crate::model::OtaUpdateFile>) -> Self {
            let mut v = self.ota_update_files.unwrap_or_default();
            v.push(input.into());
            self.ota_update_files = Some(v);
            self
        }
        /// <p>A list of files associated with the OTA update.</p>
        pub fn set_ota_update_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OtaUpdateFile>>,
        ) -> Self {
            self.ota_update_files = input;
            self
        }
        /// <p>The status of the OTA update.</p>
        pub fn ota_update_status(mut self, input: crate::model::OtaUpdateStatus) -> Self {
            self.ota_update_status = Some(input);
            self
        }
        /// <p>The status of the OTA update.</p>
        pub fn set_ota_update_status(
            mut self,
            input: std::option::Option<crate::model::OtaUpdateStatus>,
        ) -> Self {
            self.ota_update_status = input;
            self
        }
        /// <p>The IoT job ID associated with the OTA update.</p>
        pub fn aws_iot_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_iot_job_id = Some(input.into());
            self
        }
        /// <p>The IoT job ID associated with the OTA update.</p>
        pub fn set_aws_iot_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_iot_job_id = input;
            self
        }
        /// <p>The IoT job ARN associated with the OTA update.</p>
        pub fn aws_iot_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_iot_job_arn = Some(input.into());
            self
        }
        /// <p>The IoT job ARN associated with the OTA update.</p>
        pub fn set_aws_iot_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_iot_job_arn = input;
            self
        }
        /// <p>Error information associated with the OTA update.</p>
        pub fn error_info(mut self, input: crate::model::ErrorInfo) -> Self {
            self.error_info = Some(input);
            self
        }
        /// <p>Error information associated with the OTA update.</p>
        pub fn set_error_info(
            mut self,
            input: std::option::Option<crate::model::ErrorInfo>,
        ) -> Self {
            self.error_info = input;
            self
        }
        /// Adds a key-value pair to `additional_parameters`.
        ///
        /// To override the contents of this collection use [`set_additional_parameters`](Self::set_additional_parameters).
        ///
        /// <p>A collection of name/value pairs</p>
        pub fn additional_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.additional_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.additional_parameters = Some(hash_map);
            self
        }
        /// <p>A collection of name/value pairs</p>
        pub fn set_additional_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.additional_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`OtaUpdateInfo`](crate::model::OtaUpdateInfo)
        pub fn build(self) -> crate::model::OtaUpdateInfo {
            crate::model::OtaUpdateInfo {
                ota_update_id: self.ota_update_id,
                ota_update_arn: self.ota_update_arn,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                description: self.description,
                targets: self.targets,
                protocols: self.protocols,
                aws_job_executions_rollout_config: self.aws_job_executions_rollout_config,
                aws_job_presigned_url_config: self.aws_job_presigned_url_config,
                target_selection: self.target_selection,
                ota_update_files: self.ota_update_files,
                ota_update_status: self.ota_update_status,
                aws_iot_job_id: self.aws_iot_job_id,
                aws_iot_job_arn: self.aws_iot_job_arn,
                error_info: self.error_info,
                additional_parameters: self.additional_parameters,
            }
        }
    }
}
impl OtaUpdateInfo {
    /// Creates a new builder-style object to manufacture [`OtaUpdateInfo`](crate::model::OtaUpdateInfo)
    pub fn builder() -> crate::model::ota_update_info::Builder {
        crate::model::ota_update_info::Builder::default()
    }
}

/// <p>Error information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorInfo {
    /// <p>The error code.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ErrorInfo {
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorInfo");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ErrorInfo`](crate::model::ErrorInfo)
pub mod error_info {
    /// A builder for [`ErrorInfo`](crate::model::ErrorInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorInfo`](crate::model::ErrorInfo)
        pub fn build(self) -> crate::model::ErrorInfo {
            crate::model::ErrorInfo {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ErrorInfo {
    /// Creates a new builder-style object to manufacture [`ErrorInfo`](crate::model::ErrorInfo)
    pub fn builder() -> crate::model::error_info::Builder {
        crate::model::error_info::Builder::default()
    }
}

/// <p>Describes a file to be associated with an OTA update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtaUpdateFile {
    /// <p>The name of the file.</p>
    pub file_name: std::option::Option<std::string::String>,
    /// <p>An integer value you can include in the job document to allow your devices to identify the type of file received
    /// from the cloud.</p>
    pub file_type: std::option::Option<i32>,
    /// <p>The file version.</p>
    pub file_version: std::option::Option<std::string::String>,
    /// <p>The location of the updated firmware.</p>
    pub file_location: std::option::Option<crate::model::FileLocation>,
    /// <p>The code signing method of the file.</p>
    pub code_signing: std::option::Option<crate::model::CodeSigning>,
    /// <p>A list of name/attribute pairs.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl OtaUpdateFile {
    /// <p>The name of the file.</p>
    pub fn file_name(&self) -> std::option::Option<&str> {
        self.file_name.as_deref()
    }
    /// <p>An integer value you can include in the job document to allow your devices to identify the type of file received
    /// from the cloud.</p>
    pub fn file_type(&self) -> std::option::Option<i32> {
        self.file_type
    }
    /// <p>The file version.</p>
    pub fn file_version(&self) -> std::option::Option<&str> {
        self.file_version.as_deref()
    }
    /// <p>The location of the updated firmware.</p>
    pub fn file_location(&self) -> std::option::Option<&crate::model::FileLocation> {
        self.file_location.as_ref()
    }
    /// <p>The code signing method of the file.</p>
    pub fn code_signing(&self) -> std::option::Option<&crate::model::CodeSigning> {
        self.code_signing.as_ref()
    }
    /// <p>A list of name/attribute pairs.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for OtaUpdateFile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtaUpdateFile");
        formatter.field("file_name", &self.file_name);
        formatter.field("file_type", &self.file_type);
        formatter.field("file_version", &self.file_version);
        formatter.field("file_location", &self.file_location);
        formatter.field("code_signing", &self.code_signing);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`OtaUpdateFile`](crate::model::OtaUpdateFile)
pub mod ota_update_file {
    /// A builder for [`OtaUpdateFile`](crate::model::OtaUpdateFile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_name: std::option::Option<std::string::String>,
        pub(crate) file_type: std::option::Option<i32>,
        pub(crate) file_version: std::option::Option<std::string::String>,
        pub(crate) file_location: std::option::Option<crate::model::FileLocation>,
        pub(crate) code_signing: std::option::Option<crate::model::CodeSigning>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the file.</p>
        pub fn file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_name = Some(input.into());
            self
        }
        /// <p>The name of the file.</p>
        pub fn set_file_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_name = input;
            self
        }
        /// <p>An integer value you can include in the job document to allow your devices to identify the type of file received
        /// from the cloud.</p>
        pub fn file_type(mut self, input: i32) -> Self {
            self.file_type = Some(input);
            self
        }
        /// <p>An integer value you can include in the job document to allow your devices to identify the type of file received
        /// from the cloud.</p>
        pub fn set_file_type(mut self, input: std::option::Option<i32>) -> Self {
            self.file_type = input;
            self
        }
        /// <p>The file version.</p>
        pub fn file_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_version = Some(input.into());
            self
        }
        /// <p>The file version.</p>
        pub fn set_file_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_version = input;
            self
        }
        /// <p>The location of the updated firmware.</p>
        pub fn file_location(mut self, input: crate::model::FileLocation) -> Self {
            self.file_location = Some(input);
            self
        }
        /// <p>The location of the updated firmware.</p>
        pub fn set_file_location(
            mut self,
            input: std::option::Option<crate::model::FileLocation>,
        ) -> Self {
            self.file_location = input;
            self
        }
        /// <p>The code signing method of the file.</p>
        pub fn code_signing(mut self, input: crate::model::CodeSigning) -> Self {
            self.code_signing = Some(input);
            self
        }
        /// <p>The code signing method of the file.</p>
        pub fn set_code_signing(
            mut self,
            input: std::option::Option<crate::model::CodeSigning>,
        ) -> Self {
            self.code_signing = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of name/attribute pairs.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A list of name/attribute pairs.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`OtaUpdateFile`](crate::model::OtaUpdateFile)
        pub fn build(self) -> crate::model::OtaUpdateFile {
            crate::model::OtaUpdateFile {
                file_name: self.file_name,
                file_type: self.file_type,
                file_version: self.file_version,
                file_location: self.file_location,
                code_signing: self.code_signing,
                attributes: self.attributes,
            }
        }
    }
}
impl OtaUpdateFile {
    /// Creates a new builder-style object to manufacture [`OtaUpdateFile`](crate::model::OtaUpdateFile)
    pub fn builder() -> crate::model::ota_update_file::Builder {
        crate::model::ota_update_file::Builder::default()
    }
}

/// <p>Describes the method to use when code signing a file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeSigning {
    /// <p>The ID of the <code>AWSSignerJob</code> which was created to sign the file.</p>
    pub aws_signer_job_id: std::option::Option<std::string::String>,
    /// <p>Describes the code-signing job.</p>
    pub start_signing_job_parameter: std::option::Option<crate::model::StartSigningJobParameter>,
    /// <p>A custom method for code signing a file.</p>
    pub custom_code_signing: std::option::Option<crate::model::CustomCodeSigning>,
}
impl CodeSigning {
    /// <p>The ID of the <code>AWSSignerJob</code> which was created to sign the file.</p>
    pub fn aws_signer_job_id(&self) -> std::option::Option<&str> {
        self.aws_signer_job_id.as_deref()
    }
    /// <p>Describes the code-signing job.</p>
    pub fn start_signing_job_parameter(
        &self,
    ) -> std::option::Option<&crate::model::StartSigningJobParameter> {
        self.start_signing_job_parameter.as_ref()
    }
    /// <p>A custom method for code signing a file.</p>
    pub fn custom_code_signing(&self) -> std::option::Option<&crate::model::CustomCodeSigning> {
        self.custom_code_signing.as_ref()
    }
}
impl std::fmt::Debug for CodeSigning {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeSigning");
        formatter.field("aws_signer_job_id", &self.aws_signer_job_id);
        formatter.field(
            "start_signing_job_parameter",
            &self.start_signing_job_parameter,
        );
        formatter.field("custom_code_signing", &self.custom_code_signing);
        formatter.finish()
    }
}
/// See [`CodeSigning`](crate::model::CodeSigning)
pub mod code_signing {
    /// A builder for [`CodeSigning`](crate::model::CodeSigning)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_signer_job_id: std::option::Option<std::string::String>,
        pub(crate) start_signing_job_parameter:
            std::option::Option<crate::model::StartSigningJobParameter>,
        pub(crate) custom_code_signing: std::option::Option<crate::model::CustomCodeSigning>,
    }
    impl Builder {
        /// <p>The ID of the <code>AWSSignerJob</code> which was created to sign the file.</p>
        pub fn aws_signer_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_signer_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>AWSSignerJob</code> which was created to sign the file.</p>
        pub fn set_aws_signer_job_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_signer_job_id = input;
            self
        }
        /// <p>Describes the code-signing job.</p>
        pub fn start_signing_job_parameter(
            mut self,
            input: crate::model::StartSigningJobParameter,
        ) -> Self {
            self.start_signing_job_parameter = Some(input);
            self
        }
        /// <p>Describes the code-signing job.</p>
        pub fn set_start_signing_job_parameter(
            mut self,
            input: std::option::Option<crate::model::StartSigningJobParameter>,
        ) -> Self {
            self.start_signing_job_parameter = input;
            self
        }
        /// <p>A custom method for code signing a file.</p>
        pub fn custom_code_signing(mut self, input: crate::model::CustomCodeSigning) -> Self {
            self.custom_code_signing = Some(input);
            self
        }
        /// <p>A custom method for code signing a file.</p>
        pub fn set_custom_code_signing(
            mut self,
            input: std::option::Option<crate::model::CustomCodeSigning>,
        ) -> Self {
            self.custom_code_signing = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeSigning`](crate::model::CodeSigning)
        pub fn build(self) -> crate::model::CodeSigning {
            crate::model::CodeSigning {
                aws_signer_job_id: self.aws_signer_job_id,
                start_signing_job_parameter: self.start_signing_job_parameter,
                custom_code_signing: self.custom_code_signing,
            }
        }
    }
}
impl CodeSigning {
    /// Creates a new builder-style object to manufacture [`CodeSigning`](crate::model::CodeSigning)
    pub fn builder() -> crate::model::code_signing::Builder {
        crate::model::code_signing::Builder::default()
    }
}

/// <p>Describes a custom method used to code sign a file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomCodeSigning {
    /// <p>The signature for the file.</p>
    pub signature: std::option::Option<crate::model::CodeSigningSignature>,
    /// <p>The certificate chain.</p>
    pub certificate_chain: std::option::Option<crate::model::CodeSigningCertificateChain>,
    /// <p>The hash algorithm used to code sign the file.</p>
    pub hash_algorithm: std::option::Option<std::string::String>,
    /// <p>The signature algorithm used to code sign the file.</p>
    pub signature_algorithm: std::option::Option<std::string::String>,
}
impl CustomCodeSigning {
    /// <p>The signature for the file.</p>
    pub fn signature(&self) -> std::option::Option<&crate::model::CodeSigningSignature> {
        self.signature.as_ref()
    }
    /// <p>The certificate chain.</p>
    pub fn certificate_chain(
        &self,
    ) -> std::option::Option<&crate::model::CodeSigningCertificateChain> {
        self.certificate_chain.as_ref()
    }
    /// <p>The hash algorithm used to code sign the file.</p>
    pub fn hash_algorithm(&self) -> std::option::Option<&str> {
        self.hash_algorithm.as_deref()
    }
    /// <p>The signature algorithm used to code sign the file.</p>
    pub fn signature_algorithm(&self) -> std::option::Option<&str> {
        self.signature_algorithm.as_deref()
    }
}
impl std::fmt::Debug for CustomCodeSigning {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomCodeSigning");
        formatter.field("signature", &self.signature);
        formatter.field("certificate_chain", &self.certificate_chain);
        formatter.field("hash_algorithm", &self.hash_algorithm);
        formatter.field("signature_algorithm", &self.signature_algorithm);
        formatter.finish()
    }
}
/// See [`CustomCodeSigning`](crate::model::CustomCodeSigning)
pub mod custom_code_signing {
    /// A builder for [`CustomCodeSigning`](crate::model::CustomCodeSigning)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signature: std::option::Option<crate::model::CodeSigningSignature>,
        pub(crate) certificate_chain:
            std::option::Option<crate::model::CodeSigningCertificateChain>,
        pub(crate) hash_algorithm: std::option::Option<std::string::String>,
        pub(crate) signature_algorithm: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The signature for the file.</p>
        pub fn signature(mut self, input: crate::model::CodeSigningSignature) -> Self {
            self.signature = Some(input);
            self
        }
        /// <p>The signature for the file.</p>
        pub fn set_signature(
            mut self,
            input: std::option::Option<crate::model::CodeSigningSignature>,
        ) -> Self {
            self.signature = input;
            self
        }
        /// <p>The certificate chain.</p>
        pub fn certificate_chain(
            mut self,
            input: crate::model::CodeSigningCertificateChain,
        ) -> Self {
            self.certificate_chain = Some(input);
            self
        }
        /// <p>The certificate chain.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<crate::model::CodeSigningCertificateChain>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// <p>The hash algorithm used to code sign the file.</p>
        pub fn hash_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash_algorithm = Some(input.into());
            self
        }
        /// <p>The hash algorithm used to code sign the file.</p>
        pub fn set_hash_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hash_algorithm = input;
            self
        }
        /// <p>The signature algorithm used to code sign the file.</p>
        pub fn signature_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_algorithm = Some(input.into());
            self
        }
        /// <p>The signature algorithm used to code sign the file.</p>
        pub fn set_signature_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomCodeSigning`](crate::model::CustomCodeSigning)
        pub fn build(self) -> crate::model::CustomCodeSigning {
            crate::model::CustomCodeSigning {
                signature: self.signature,
                certificate_chain: self.certificate_chain,
                hash_algorithm: self.hash_algorithm,
                signature_algorithm: self.signature_algorithm,
            }
        }
    }
}
impl CustomCodeSigning {
    /// Creates a new builder-style object to manufacture [`CustomCodeSigning`](crate::model::CustomCodeSigning)
    pub fn builder() -> crate::model::custom_code_signing::Builder {
        crate::model::custom_code_signing::Builder::default()
    }
}

/// <p>Describes the certificate chain being used when code signing a file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeSigningCertificateChain {
    /// <p>The name of the certificate.</p>
    pub certificate_name: std::option::Option<std::string::String>,
    /// <p>A base64 encoded binary representation of the code signing certificate chain.</p>
    pub inline_document: std::option::Option<std::string::String>,
}
impl CodeSigningCertificateChain {
    /// <p>The name of the certificate.</p>
    pub fn certificate_name(&self) -> std::option::Option<&str> {
        self.certificate_name.as_deref()
    }
    /// <p>A base64 encoded binary representation of the code signing certificate chain.</p>
    pub fn inline_document(&self) -> std::option::Option<&str> {
        self.inline_document.as_deref()
    }
}
impl std::fmt::Debug for CodeSigningCertificateChain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeSigningCertificateChain");
        formatter.field("certificate_name", &self.certificate_name);
        formatter.field("inline_document", &self.inline_document);
        formatter.finish()
    }
}
/// See [`CodeSigningCertificateChain`](crate::model::CodeSigningCertificateChain)
pub mod code_signing_certificate_chain {
    /// A builder for [`CodeSigningCertificateChain`](crate::model::CodeSigningCertificateChain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) inline_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the certificate.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>A base64 encoded binary representation of the code signing certificate chain.</p>
        pub fn inline_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inline_document = Some(input.into());
            self
        }
        /// <p>A base64 encoded binary representation of the code signing certificate chain.</p>
        pub fn set_inline_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inline_document = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeSigningCertificateChain`](crate::model::CodeSigningCertificateChain)
        pub fn build(self) -> crate::model::CodeSigningCertificateChain {
            crate::model::CodeSigningCertificateChain {
                certificate_name: self.certificate_name,
                inline_document: self.inline_document,
            }
        }
    }
}
impl CodeSigningCertificateChain {
    /// Creates a new builder-style object to manufacture [`CodeSigningCertificateChain`](crate::model::CodeSigningCertificateChain)
    pub fn builder() -> crate::model::code_signing_certificate_chain::Builder {
        crate::model::code_signing_certificate_chain::Builder::default()
    }
}

/// <p>Describes the signature for a file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeSigningSignature {
    /// <p>A base64 encoded binary representation of the code signing signature.</p>
    pub inline_document: std::option::Option<aws_smithy_types::Blob>,
}
impl CodeSigningSignature {
    /// <p>A base64 encoded binary representation of the code signing signature.</p>
    pub fn inline_document(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.inline_document.as_ref()
    }
}
impl std::fmt::Debug for CodeSigningSignature {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeSigningSignature");
        formatter.field("inline_document", &self.inline_document);
        formatter.finish()
    }
}
/// See [`CodeSigningSignature`](crate::model::CodeSigningSignature)
pub mod code_signing_signature {
    /// A builder for [`CodeSigningSignature`](crate::model::CodeSigningSignature)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inline_document: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>A base64 encoded binary representation of the code signing signature.</p>
        pub fn inline_document(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inline_document = Some(input);
            self
        }
        /// <p>A base64 encoded binary representation of the code signing signature.</p>
        pub fn set_inline_document(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inline_document = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeSigningSignature`](crate::model::CodeSigningSignature)
        pub fn build(self) -> crate::model::CodeSigningSignature {
            crate::model::CodeSigningSignature {
                inline_document: self.inline_document,
            }
        }
    }
}
impl CodeSigningSignature {
    /// Creates a new builder-style object to manufacture [`CodeSigningSignature`](crate::model::CodeSigningSignature)
    pub fn builder() -> crate::model::code_signing_signature::Builder {
        crate::model::code_signing_signature::Builder::default()
    }
}

/// <p>Information required to start a signing job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSigningJobParameter {
    /// <p>Describes the code-signing profile.</p>
    pub signing_profile_parameter: std::option::Option<crate::model::SigningProfileParameter>,
    /// <p>The code-signing profile name.</p>
    pub signing_profile_name: std::option::Option<std::string::String>,
    /// <p>The location to write the code-signed file.</p>
    pub destination: std::option::Option<crate::model::Destination>,
}
impl StartSigningJobParameter {
    /// <p>Describes the code-signing profile.</p>
    pub fn signing_profile_parameter(
        &self,
    ) -> std::option::Option<&crate::model::SigningProfileParameter> {
        self.signing_profile_parameter.as_ref()
    }
    /// <p>The code-signing profile name.</p>
    pub fn signing_profile_name(&self) -> std::option::Option<&str> {
        self.signing_profile_name.as_deref()
    }
    /// <p>The location to write the code-signed file.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
}
impl std::fmt::Debug for StartSigningJobParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSigningJobParameter");
        formatter.field("signing_profile_parameter", &self.signing_profile_parameter);
        formatter.field("signing_profile_name", &self.signing_profile_name);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`StartSigningJobParameter`](crate::model::StartSigningJobParameter)
pub mod start_signing_job_parameter {
    /// A builder for [`StartSigningJobParameter`](crate::model::StartSigningJobParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signing_profile_parameter:
            std::option::Option<crate::model::SigningProfileParameter>,
        pub(crate) signing_profile_name: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
    }
    impl Builder {
        /// <p>Describes the code-signing profile.</p>
        pub fn signing_profile_parameter(
            mut self,
            input: crate::model::SigningProfileParameter,
        ) -> Self {
            self.signing_profile_parameter = Some(input);
            self
        }
        /// <p>Describes the code-signing profile.</p>
        pub fn set_signing_profile_parameter(
            mut self,
            input: std::option::Option<crate::model::SigningProfileParameter>,
        ) -> Self {
            self.signing_profile_parameter = input;
            self
        }
        /// <p>The code-signing profile name.</p>
        pub fn signing_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_profile_name = Some(input.into());
            self
        }
        /// <p>The code-signing profile name.</p>
        pub fn set_signing_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_name = input;
            self
        }
        /// <p>The location to write the code-signed file.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The location to write the code-signed file.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSigningJobParameter`](crate::model::StartSigningJobParameter)
        pub fn build(self) -> crate::model::StartSigningJobParameter {
            crate::model::StartSigningJobParameter {
                signing_profile_parameter: self.signing_profile_parameter,
                signing_profile_name: self.signing_profile_name,
                destination: self.destination,
            }
        }
    }
}
impl StartSigningJobParameter {
    /// Creates a new builder-style object to manufacture [`StartSigningJobParameter`](crate::model::StartSigningJobParameter)
    pub fn builder() -> crate::model::start_signing_job_parameter::Builder {
        crate::model::start_signing_job_parameter::Builder::default()
    }
}

/// <p>Describes the location of the updated firmware.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>Describes the location in S3 of the updated firmware.</p>
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
}
impl Destination {
    /// <p>Describes the location in S3 of the updated firmware.</p>
    pub fn s3_destination(&self) -> std::option::Option<&crate::model::S3Destination> {
        self.s3_destination.as_ref()
    }
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("s3_destination", &self.s3_destination);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>Describes the location in S3 of the updated firmware.</p>
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>Describes the location in S3 of the updated firmware.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                s3_destination: self.s3_destination,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

/// <p>Describes the location of updated firmware in S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Destination {
    /// <p>The S3 bucket that contains the updated firmware.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The S3 prefix.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3Destination {
    /// <p>The S3 bucket that contains the updated firmware.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The S3 prefix.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Destination");
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3Destination`](crate::model::S3Destination)
pub mod s3_destination {
    /// A builder for [`S3Destination`](crate::model::S3Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket that contains the updated firmware.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket that contains the updated firmware.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The S3 prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The S3 prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Destination`](crate::model::S3Destination)
        pub fn build(self) -> crate::model::S3Destination {
            crate::model::S3Destination {
                bucket: self.bucket,
                prefix: self.prefix,
            }
        }
    }
}
impl S3Destination {
    /// Creates a new builder-style object to manufacture [`S3Destination`](crate::model::S3Destination)
    pub fn builder() -> crate::model::s3_destination::Builder {
        crate::model::s3_destination::Builder::default()
    }
}

/// <p>Describes the code-signing profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningProfileParameter {
    /// <p>Certificate ARN.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The hardware platform of your device.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The location of the code-signing certificate on your device.</p>
    pub certificate_path_on_device: std::option::Option<std::string::String>,
}
impl SigningProfileParameter {
    /// <p>Certificate ARN.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The hardware platform of your device.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The location of the code-signing certificate on your device.</p>
    pub fn certificate_path_on_device(&self) -> std::option::Option<&str> {
        self.certificate_path_on_device.as_deref()
    }
}
impl std::fmt::Debug for SigningProfileParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningProfileParameter");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("platform", &self.platform);
        formatter.field(
            "certificate_path_on_device",
            &self.certificate_path_on_device,
        );
        formatter.finish()
    }
}
/// See [`SigningProfileParameter`](crate::model::SigningProfileParameter)
pub mod signing_profile_parameter {
    /// A builder for [`SigningProfileParameter`](crate::model::SigningProfileParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) certificate_path_on_device: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Certificate ARN.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>Certificate ARN.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The hardware platform of your device.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The hardware platform of your device.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The location of the code-signing certificate on your device.</p>
        pub fn certificate_path_on_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_path_on_device = Some(input.into());
            self
        }
        /// <p>The location of the code-signing certificate on your device.</p>
        pub fn set_certificate_path_on_device(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_path_on_device = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningProfileParameter`](crate::model::SigningProfileParameter)
        pub fn build(self) -> crate::model::SigningProfileParameter {
            crate::model::SigningProfileParameter {
                certificate_arn: self.certificate_arn,
                platform: self.platform,
                certificate_path_on_device: self.certificate_path_on_device,
            }
        }
    }
}
impl SigningProfileParameter {
    /// Creates a new builder-style object to manufacture [`SigningProfileParameter`](crate::model::SigningProfileParameter)
    pub fn builder() -> crate::model::signing_profile_parameter::Builder {
        crate::model::signing_profile_parameter::Builder::default()
    }
}

/// <p>The location of the OTA update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileLocation {
    /// <p>The stream that contains the OTA update.</p>
    pub stream: std::option::Option<crate::model::Stream>,
    /// <p>The location of the updated firmware in S3.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
}
impl FileLocation {
    /// <p>The stream that contains the OTA update.</p>
    pub fn stream(&self) -> std::option::Option<&crate::model::Stream> {
        self.stream.as_ref()
    }
    /// <p>The location of the updated firmware in S3.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
}
impl std::fmt::Debug for FileLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileLocation");
        formatter.field("stream", &self.stream);
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`FileLocation`](crate::model::FileLocation)
pub mod file_location {
    /// A builder for [`FileLocation`](crate::model::FileLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream: std::option::Option<crate::model::Stream>,
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>The stream that contains the OTA update.</p>
        pub fn stream(mut self, input: crate::model::Stream) -> Self {
            self.stream = Some(input);
            self
        }
        /// <p>The stream that contains the OTA update.</p>
        pub fn set_stream(mut self, input: std::option::Option<crate::model::Stream>) -> Self {
            self.stream = input;
            self
        }
        /// <p>The location of the updated firmware in S3.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>The location of the updated firmware in S3.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`FileLocation`](crate::model::FileLocation)
        pub fn build(self) -> crate::model::FileLocation {
            crate::model::FileLocation {
                stream: self.stream,
                s3_location: self.s3_location,
            }
        }
    }
}
impl FileLocation {
    /// Creates a new builder-style object to manufacture [`FileLocation`](crate::model::FileLocation)
    pub fn builder() -> crate::model::file_location::Builder {
        crate::model::file_location::Builder::default()
    }
}

/// <p>Describes a group of files that can be streamed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stream {
    /// <p>The stream ID.</p>
    pub stream_id: std::option::Option<std::string::String>,
    /// <p>The ID of a file associated with a stream.</p>
    pub file_id: std::option::Option<i32>,
}
impl Stream {
    /// <p>The stream ID.</p>
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// <p>The ID of a file associated with a stream.</p>
    pub fn file_id(&self) -> std::option::Option<i32> {
        self.file_id
    }
}
impl std::fmt::Debug for Stream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stream");
        formatter.field("stream_id", &self.stream_id);
        formatter.field("file_id", &self.file_id);
        formatter.finish()
    }
}
/// See [`Stream`](crate::model::Stream)
pub mod stream {
    /// A builder for [`Stream`](crate::model::Stream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) file_id: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The stream ID.</p>
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// <p>The stream ID.</p>
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// <p>The ID of a file associated with a stream.</p>
        pub fn file_id(mut self, input: i32) -> Self {
            self.file_id = Some(input);
            self
        }
        /// <p>The ID of a file associated with a stream.</p>
        pub fn set_file_id(mut self, input: std::option::Option<i32>) -> Self {
            self.file_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Stream`](crate::model::Stream)
        pub fn build(self) -> crate::model::Stream {
            crate::model::Stream {
                stream_id: self.stream_id,
                file_id: self.file_id,
            }
        }
    }
}
impl Stream {
    /// Creates a new builder-style object to manufacture [`Stream`](crate::model::Stream)
    pub fn builder() -> crate::model::stream::Builder {
        crate::model::stream::Builder::default()
    }
}

/// <p>Configuration information for pre-signed URLs. Valid when <code>protocols</code>
/// contains HTTP.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsJobPresignedUrlConfig {
    /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800
    /// seconds. Pre-signed URLs are generated when a request for the job document is received.</p>
    pub expires_in_sec: std::option::Option<i64>,
}
impl AwsJobPresignedUrlConfig {
    /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800
    /// seconds. Pre-signed URLs are generated when a request for the job document is received.</p>
    pub fn expires_in_sec(&self) -> std::option::Option<i64> {
        self.expires_in_sec
    }
}
impl std::fmt::Debug for AwsJobPresignedUrlConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsJobPresignedUrlConfig");
        formatter.field("expires_in_sec", &self.expires_in_sec);
        formatter.finish()
    }
}
/// See [`AwsJobPresignedUrlConfig`](crate::model::AwsJobPresignedUrlConfig)
pub mod aws_job_presigned_url_config {
    /// A builder for [`AwsJobPresignedUrlConfig`](crate::model::AwsJobPresignedUrlConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expires_in_sec: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800
        /// seconds. Pre-signed URLs are generated when a request for the job document is received.</p>
        pub fn expires_in_sec(mut self, input: i64) -> Self {
            self.expires_in_sec = Some(input);
            self
        }
        /// <p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800
        /// seconds. Pre-signed URLs are generated when a request for the job document is received.</p>
        pub fn set_expires_in_sec(mut self, input: std::option::Option<i64>) -> Self {
            self.expires_in_sec = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsJobPresignedUrlConfig`](crate::model::AwsJobPresignedUrlConfig)
        pub fn build(self) -> crate::model::AwsJobPresignedUrlConfig {
            crate::model::AwsJobPresignedUrlConfig {
                expires_in_sec: self.expires_in_sec,
            }
        }
    }
}
impl AwsJobPresignedUrlConfig {
    /// Creates a new builder-style object to manufacture [`AwsJobPresignedUrlConfig`](crate::model::AwsJobPresignedUrlConfig)
    pub fn builder() -> crate::model::aws_job_presigned_url_config::Builder {
        crate::model::aws_job_presigned_url_config::Builder::default()
    }
}

/// <p>Configuration for the rollout of OTA updates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsJobExecutionsRolloutConfig {
    /// <p>The maximum number of OTA update job executions started per minute.</p>
    pub maximum_per_minute: std::option::Option<i32>,
    /// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate
    /// increase for a job rollout.</p>
    pub exponential_rate: std::option::Option<crate::model::AwsJobExponentialRolloutRate>,
}
impl AwsJobExecutionsRolloutConfig {
    /// <p>The maximum number of OTA update job executions started per minute.</p>
    pub fn maximum_per_minute(&self) -> std::option::Option<i32> {
        self.maximum_per_minute
    }
    /// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate
    /// increase for a job rollout.</p>
    pub fn exponential_rate(
        &self,
    ) -> std::option::Option<&crate::model::AwsJobExponentialRolloutRate> {
        self.exponential_rate.as_ref()
    }
}
impl std::fmt::Debug for AwsJobExecutionsRolloutConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsJobExecutionsRolloutConfig");
        formatter.field("maximum_per_minute", &self.maximum_per_minute);
        formatter.field("exponential_rate", &self.exponential_rate);
        formatter.finish()
    }
}
/// See [`AwsJobExecutionsRolloutConfig`](crate::model::AwsJobExecutionsRolloutConfig)
pub mod aws_job_executions_rollout_config {
    /// A builder for [`AwsJobExecutionsRolloutConfig`](crate::model::AwsJobExecutionsRolloutConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_per_minute: std::option::Option<i32>,
        pub(crate) exponential_rate:
            std::option::Option<crate::model::AwsJobExponentialRolloutRate>,
    }
    impl Builder {
        /// <p>The maximum number of OTA update job executions started per minute.</p>
        pub fn maximum_per_minute(mut self, input: i32) -> Self {
            self.maximum_per_minute = Some(input);
            self
        }
        /// <p>The maximum number of OTA update job executions started per minute.</p>
        pub fn set_maximum_per_minute(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_per_minute = input;
            self
        }
        /// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate
        /// increase for a job rollout.</p>
        pub fn exponential_rate(
            mut self,
            input: crate::model::AwsJobExponentialRolloutRate,
        ) -> Self {
            self.exponential_rate = Some(input);
            self
        }
        /// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate
        /// increase for a job rollout.</p>
        pub fn set_exponential_rate(
            mut self,
            input: std::option::Option<crate::model::AwsJobExponentialRolloutRate>,
        ) -> Self {
            self.exponential_rate = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsJobExecutionsRolloutConfig`](crate::model::AwsJobExecutionsRolloutConfig)
        pub fn build(self) -> crate::model::AwsJobExecutionsRolloutConfig {
            crate::model::AwsJobExecutionsRolloutConfig {
                maximum_per_minute: self.maximum_per_minute,
                exponential_rate: self.exponential_rate,
            }
        }
    }
}
impl AwsJobExecutionsRolloutConfig {
    /// Creates a new builder-style object to manufacture [`AwsJobExecutionsRolloutConfig`](crate::model::AwsJobExecutionsRolloutConfig)
    pub fn builder() -> crate::model::aws_job_executions_rollout_config::Builder {
        crate::model::aws_job_executions_rollout_config::Builder::default()
    }
}

/// <p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate
/// increase for a job rollout.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsJobExponentialRolloutRate {
    /// <p>The minimum number of things that will be notified of a pending job, per minute, at the start
    /// of the job rollout. This is the initial rate of the rollout.</p>
    pub base_rate_per_minute: std::option::Option<i32>,
    /// <p>The rate of increase for a job rollout. The number of things notified is multiplied by this
    /// factor.</p>
    pub increment_factor: f64,
    /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
    /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
    pub rate_increase_criteria: std::option::Option<crate::model::AwsJobRateIncreaseCriteria>,
}
impl AwsJobExponentialRolloutRate {
    /// <p>The minimum number of things that will be notified of a pending job, per minute, at the start
    /// of the job rollout. This is the initial rate of the rollout.</p>
    pub fn base_rate_per_minute(&self) -> std::option::Option<i32> {
        self.base_rate_per_minute
    }
    /// <p>The rate of increase for a job rollout. The number of things notified is multiplied by this
    /// factor.</p>
    pub fn increment_factor(&self) -> f64 {
        self.increment_factor
    }
    /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
    /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
    pub fn rate_increase_criteria(
        &self,
    ) -> std::option::Option<&crate::model::AwsJobRateIncreaseCriteria> {
        self.rate_increase_criteria.as_ref()
    }
}
impl std::fmt::Debug for AwsJobExponentialRolloutRate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsJobExponentialRolloutRate");
        formatter.field("base_rate_per_minute", &self.base_rate_per_minute);
        formatter.field("increment_factor", &self.increment_factor);
        formatter.field("rate_increase_criteria", &self.rate_increase_criteria);
        formatter.finish()
    }
}
/// See [`AwsJobExponentialRolloutRate`](crate::model::AwsJobExponentialRolloutRate)
pub mod aws_job_exponential_rollout_rate {
    /// A builder for [`AwsJobExponentialRolloutRate`](crate::model::AwsJobExponentialRolloutRate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_rate_per_minute: std::option::Option<i32>,
        pub(crate) increment_factor: std::option::Option<f64>,
        pub(crate) rate_increase_criteria:
            std::option::Option<crate::model::AwsJobRateIncreaseCriteria>,
    }
    impl Builder {
        /// <p>The minimum number of things that will be notified of a pending job, per minute, at the start
        /// of the job rollout. This is the initial rate of the rollout.</p>
        pub fn base_rate_per_minute(mut self, input: i32) -> Self {
            self.base_rate_per_minute = Some(input);
            self
        }
        /// <p>The minimum number of things that will be notified of a pending job, per minute, at the start
        /// of the job rollout. This is the initial rate of the rollout.</p>
        pub fn set_base_rate_per_minute(mut self, input: std::option::Option<i32>) -> Self {
            self.base_rate_per_minute = input;
            self
        }
        /// <p>The rate of increase for a job rollout. The number of things notified is multiplied by this
        /// factor.</p>
        pub fn increment_factor(mut self, input: f64) -> Self {
            self.increment_factor = Some(input);
            self
        }
        /// <p>The rate of increase for a job rollout. The number of things notified is multiplied by this
        /// factor.</p>
        pub fn set_increment_factor(mut self, input: std::option::Option<f64>) -> Self {
            self.increment_factor = input;
            self
        }
        /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
        /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
        pub fn rate_increase_criteria(
            mut self,
            input: crate::model::AwsJobRateIncreaseCriteria,
        ) -> Self {
            self.rate_increase_criteria = Some(input);
            self
        }
        /// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
        /// <p>Amazon Web Services IoT Core supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>
        pub fn set_rate_increase_criteria(
            mut self,
            input: std::option::Option<crate::model::AwsJobRateIncreaseCriteria>,
        ) -> Self {
            self.rate_increase_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsJobExponentialRolloutRate`](crate::model::AwsJobExponentialRolloutRate)
        pub fn build(self) -> crate::model::AwsJobExponentialRolloutRate {
            crate::model::AwsJobExponentialRolloutRate {
                base_rate_per_minute: self.base_rate_per_minute,
                increment_factor: self.increment_factor.unwrap_or_default(),
                rate_increase_criteria: self.rate_increase_criteria,
            }
        }
    }
}
impl AwsJobExponentialRolloutRate {
    /// Creates a new builder-style object to manufacture [`AwsJobExponentialRolloutRate`](crate::model::AwsJobExponentialRolloutRate)
    pub fn builder() -> crate::model::aws_job_exponential_rollout_rate::Builder {
        crate::model::aws_job_exponential_rollout_rate::Builder::default()
    }
}

/// <p>The criteria to initiate the increase in rate of rollout for a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsJobRateIncreaseCriteria {
    /// <p>When this number of things have been notified, it will initiate an increase in the rollout
    /// rate.</p>
    pub number_of_notified_things: std::option::Option<i32>,
    /// <p>When this number of things have succeeded in their job execution, it will initiate an
    /// increase in the rollout rate.</p>
    pub number_of_succeeded_things: std::option::Option<i32>,
}
impl AwsJobRateIncreaseCriteria {
    /// <p>When this number of things have been notified, it will initiate an increase in the rollout
    /// rate.</p>
    pub fn number_of_notified_things(&self) -> std::option::Option<i32> {
        self.number_of_notified_things
    }
    /// <p>When this number of things have succeeded in their job execution, it will initiate an
    /// increase in the rollout rate.</p>
    pub fn number_of_succeeded_things(&self) -> std::option::Option<i32> {
        self.number_of_succeeded_things
    }
}
impl std::fmt::Debug for AwsJobRateIncreaseCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsJobRateIncreaseCriteria");
        formatter.field("number_of_notified_things", &self.number_of_notified_things);
        formatter.field(
            "number_of_succeeded_things",
            &self.number_of_succeeded_things,
        );
        formatter.finish()
    }
}
/// See [`AwsJobRateIncreaseCriteria`](crate::model::AwsJobRateIncreaseCriteria)
pub mod aws_job_rate_increase_criteria {
    /// A builder for [`AwsJobRateIncreaseCriteria`](crate::model::AwsJobRateIncreaseCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_notified_things: std::option::Option<i32>,
        pub(crate) number_of_succeeded_things: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>When this number of things have been notified, it will initiate an increase in the rollout
        /// rate.</p>
        pub fn number_of_notified_things(mut self, input: i32) -> Self {
            self.number_of_notified_things = Some(input);
            self
        }
        /// <p>When this number of things have been notified, it will initiate an increase in the rollout
        /// rate.</p>
        pub fn set_number_of_notified_things(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_notified_things = input;
            self
        }
        /// <p>When this number of things have succeeded in their job execution, it will initiate an
        /// increase in the rollout rate.</p>
        pub fn number_of_succeeded_things(mut self, input: i32) -> Self {
            self.number_of_succeeded_things = Some(input);
            self
        }
        /// <p>When this number of things have succeeded in their job execution, it will initiate an
        /// increase in the rollout rate.</p>
        pub fn set_number_of_succeeded_things(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_succeeded_things = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsJobRateIncreaseCriteria`](crate::model::AwsJobRateIncreaseCriteria)
        pub fn build(self) -> crate::model::AwsJobRateIncreaseCriteria {
            crate::model::AwsJobRateIncreaseCriteria {
                number_of_notified_things: self.number_of_notified_things,
                number_of_succeeded_things: self.number_of_succeeded_things,
            }
        }
    }
}
impl AwsJobRateIncreaseCriteria {
    /// Creates a new builder-style object to manufacture [`AwsJobRateIncreaseCriteria`](crate::model::AwsJobRateIncreaseCriteria)
    pub fn builder() -> crate::model::aws_job_rate_increase_criteria::Builder {
        crate::model::aws_job_rate_increase_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Protocol {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Mqtt,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Protocol {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => Protocol::Http,
            "MQTT" => Protocol::Mqtt,
            other => Protocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Protocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Protocol::from(s))
    }
}
impl Protocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Protocol::Http => "HTTP",
            Protocol::Mqtt => "MQTT",
            Protocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "MQTT"]
    }
}
impl AsRef<str> for Protocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The policy that has the effect on the authorization results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EffectivePolicy {
    /// <p>The policy name.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy ARN.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The IAM policy document.</p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl EffectivePolicy {
    /// <p>The policy name.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy ARN.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The IAM policy document.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for EffectivePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EffectivePolicy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}
/// See [`EffectivePolicy`](crate::model::EffectivePolicy)
pub mod effective_policy {
    /// A builder for [`EffectivePolicy`](crate::model::EffectivePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy ARN.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The policy ARN.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The IAM policy document.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The IAM policy document.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`EffectivePolicy`](crate::model::EffectivePolicy)
        pub fn build(self) -> crate::model::EffectivePolicy {
            crate::model::EffectivePolicy {
                policy_name: self.policy_name,
                policy_arn: self.policy_arn,
                policy_document: self.policy_document,
            }
        }
    }
}
impl EffectivePolicy {
    /// Creates a new builder-style object to manufacture [`EffectivePolicy`](crate::model::EffectivePolicy)
    pub fn builder() -> crate::model::effective_policy::Builder {
        crate::model::effective_policy::Builder::default()
    }
}

/// <p>A count of documents that meets a specific aggregation criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bucket {
    /// <p>The value counted for the particular bucket.</p>
    pub key_value: std::option::Option<std::string::String>,
    /// <p>The number of documents that have the value counted for the particular bucket.</p>
    pub count: i32,
}
impl Bucket {
    /// <p>The value counted for the particular bucket.</p>
    pub fn key_value(&self) -> std::option::Option<&str> {
        self.key_value.as_deref()
    }
    /// <p>The number of documents that have the value counted for the particular bucket.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
}
impl std::fmt::Debug for Bucket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bucket");
        formatter.field("key_value", &self.key_value);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`Bucket`](crate::model::Bucket)
pub mod bucket {
    /// A builder for [`Bucket`](crate::model::Bucket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_value: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The value counted for the particular bucket.</p>
        pub fn key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_value = Some(input.into());
            self
        }
        /// <p>The value counted for the particular bucket.</p>
        pub fn set_key_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_value = input;
            self
        }
        /// <p>The number of documents that have the value counted for the particular bucket.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of documents that have the value counted for the particular bucket.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`Bucket`](crate::model::Bucket)
        pub fn build(self) -> crate::model::Bucket {
            crate::model::Bucket {
                key_value: self.key_value,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl Bucket {
    /// Creates a new builder-style object to manufacture [`Bucket`](crate::model::Bucket)
    pub fn builder() -> crate::model::bucket::Builder {
        crate::model::bucket::Builder::default()
    }
}

/// <p>The type of bucketed aggregation performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketsAggregationType {
    /// <p>Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the number of occurrences of an aggregation field value.</p>
    pub terms_aggregation: std::option::Option<crate::model::TermsAggregation>,
}
impl BucketsAggregationType {
    /// <p>Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the number of occurrences of an aggregation field value.</p>
    pub fn terms_aggregation(&self) -> std::option::Option<&crate::model::TermsAggregation> {
        self.terms_aggregation.as_ref()
    }
}
impl std::fmt::Debug for BucketsAggregationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketsAggregationType");
        formatter.field("terms_aggregation", &self.terms_aggregation);
        formatter.finish()
    }
}
/// See [`BucketsAggregationType`](crate::model::BucketsAggregationType)
pub mod buckets_aggregation_type {
    /// A builder for [`BucketsAggregationType`](crate::model::BucketsAggregationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) terms_aggregation: std::option::Option<crate::model::TermsAggregation>,
    }
    impl Builder {
        /// <p>Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the number of occurrences of an aggregation field value.</p>
        pub fn terms_aggregation(mut self, input: crate::model::TermsAggregation) -> Self {
            self.terms_aggregation = Some(input);
            self
        }
        /// <p>Performs an aggregation that will return a list of buckets. The list of buckets is a ranked list of the number of occurrences of an aggregation field value.</p>
        pub fn set_terms_aggregation(
            mut self,
            input: std::option::Option<crate::model::TermsAggregation>,
        ) -> Self {
            self.terms_aggregation = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketsAggregationType`](crate::model::BucketsAggregationType)
        pub fn build(self) -> crate::model::BucketsAggregationType {
            crate::model::BucketsAggregationType {
                terms_aggregation: self.terms_aggregation,
            }
        }
    }
}
impl BucketsAggregationType {
    /// Creates a new builder-style object to manufacture [`BucketsAggr