// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Inspector2
///
/// Client for invoking operations on Inspector2. Each operation on Inspector2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_inspector2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_inspector2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_inspector2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateMember`](crate::client::fluent_builders::AssociateMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::AssociateMember::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::AssociateMember::set_account_id): <p>The Amazon Web Services account ID of the member account to be associated.</p>
    /// - On success, responds with [`AssociateMemberOutput`](crate::output::AssociateMemberOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::AssociateMemberOutput::account_id): <p>The Amazon Web Services account ID of the successfully associated member account.</p>
    /// - On failure, responds with [`SdkError<AssociateMemberError>`](crate::error::AssociateMemberError)
    pub fn associate_member(&self) -> fluent_builders::AssociateMember {
        fluent_builders::AssociateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetAccountStatus`](crate::client::fluent_builders::BatchGetAccountStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetAccountStatus::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetAccountStatus::set_account_ids): <p>The 12-digit Amazon Web Services account IDs of the accounts to retrieve Amazon Inspector status for.</p>
    /// - On success, responds with [`BatchGetAccountStatusOutput`](crate::output::BatchGetAccountStatusOutput) with field(s):
    ///   - [`accounts(Option<Vec<AccountState>>)`](crate::output::BatchGetAccountStatusOutput::accounts): <p>An array of objects that provide details on the status of Amazon Inspector for each of the requested accounts.</p>
    ///   - [`failed_accounts(Option<Vec<FailedAccount>>)`](crate::output::BatchGetAccountStatusOutput::failed_accounts): <p>An array of objects detailing any accounts that failed to enable Amazon Inspector and why.</p>
    /// - On failure, responds with [`SdkError<BatchGetAccountStatusError>`](crate::error::BatchGetAccountStatusError)
    pub fn batch_get_account_status(&self) -> fluent_builders::BatchGetAccountStatus {
        fluent_builders::BatchGetAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetFreeTrialInfo`](crate::client::fluent_builders::BatchGetFreeTrialInfo) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetFreeTrialInfo::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetFreeTrialInfo::set_account_ids): <p>The account IDs to get free trial status for.</p>
    /// - On success, responds with [`BatchGetFreeTrialInfoOutput`](crate::output::BatchGetFreeTrialInfoOutput) with field(s):
    ///   - [`accounts(Option<Vec<FreeTrialAccountInfo>>)`](crate::output::BatchGetFreeTrialInfoOutput::accounts): <p>An array of objects that provide Amazon Inspector free trial details for each of the requested accounts. </p>
    ///   - [`failed_accounts(Option<Vec<FreeTrialInfoError>>)`](crate::output::BatchGetFreeTrialInfoOutput::failed_accounts): <p>An array of objects detailing any accounts that free trial data could not be returned for.</p>
    /// - On failure, responds with [`SdkError<BatchGetFreeTrialInfoError>`](crate::error::BatchGetFreeTrialInfoError)
    pub fn batch_get_free_trial_info(&self) -> fluent_builders::BatchGetFreeTrialInfo {
        fluent_builders::BatchGetFreeTrialInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelFindingsReport`](crate::client::fluent_builders::CancelFindingsReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::CancelFindingsReport::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::CancelFindingsReport::set_report_id): <p>The ID of the report to be canceled.</p>
    /// - On success, responds with [`CancelFindingsReportOutput`](crate::output::CancelFindingsReportOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::CancelFindingsReportOutput::report_id): <p>The ID of the canceled report.</p>
    /// - On failure, responds with [`SdkError<CancelFindingsReportError>`](crate::error::CancelFindingsReportError)
    pub fn cancel_findings_report(&self) -> fluent_builders::CancelFindingsReport {
        fluent_builders::CancelFindingsReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFilter`](crate::client::fluent_builders::CreateFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action(FilterAction)`](crate::client::fluent_builders::CreateFilter::action) / [`set_action(Option<FilterAction>)`](crate::client::fluent_builders::CreateFilter::set_action): <p>Defines the action that is to be applied to the findings that match the filter.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFilter::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFilter::set_description): <p>A description of the filter.</p>
    ///   - [`filter_criteria(FilterCriteria)`](crate::client::fluent_builders::CreateFilter::filter_criteria) / [`set_filter_criteria(Option<FilterCriteria>)`](crate::client::fluent_builders::CreateFilter::set_filter_criteria): <p>Defines the criteria to be used in the filter for querying findings.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFilter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFilter::set_name): <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFilter::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFilter::set_tags): <p>A list of tags for the filter.</p>
    /// - On success, responds with [`CreateFilterOutput`](crate::output::CreateFilterOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateFilterOutput::arn): <p>The Amazon Resource Number (ARN) of the successfully created filter.</p>
    /// - On failure, responds with [`SdkError<CreateFilterError>`](crate::error::CreateFilterError)
    pub fn create_filter(&self) -> fluent_builders::CreateFilter {
        fluent_builders::CreateFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFindingsReport`](crate::client::fluent_builders::CreateFindingsReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_criteria(FilterCriteria)`](crate::client::fluent_builders::CreateFindingsReport::filter_criteria) / [`set_filter_criteria(Option<FilterCriteria>)`](crate::client::fluent_builders::CreateFindingsReport::set_filter_criteria): <p>The filter criteria to apply to the results of the finding report.</p>
    ///   - [`report_format(ReportFormat)`](crate::client::fluent_builders::CreateFindingsReport::report_format) / [`set_report_format(Option<ReportFormat>)`](crate::client::fluent_builders::CreateFindingsReport::set_report_format): <p>The format to generate the report in.</p>
    ///   - [`s3_destination(Destination)`](crate::client::fluent_builders::CreateFindingsReport::s3_destination) / [`set_s3_destination(Option<Destination>)`](crate::client::fluent_builders::CreateFindingsReport::set_s3_destination): <p>The Amazon S3 export destination for the report.</p>
    /// - On success, responds with [`CreateFindingsReportOutput`](crate::output::CreateFindingsReportOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::CreateFindingsReportOutput::report_id): <p>The ID of the report.</p>
    /// - On failure, responds with [`SdkError<CreateFindingsReportError>`](crate::error::CreateFindingsReportError)
    pub fn create_findings_report(&self) -> fluent_builders::CreateFindingsReport {
        fluent_builders::CreateFindingsReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFilter`](crate::client::fluent_builders::DeleteFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFilter::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteFilter::set_arn): <p>The Amazon Resource Number (ARN) of the filter to be deleted.</p>
    /// - On success, responds with [`DeleteFilterOutput`](crate::output::DeleteFilterOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteFilterOutput::arn): <p>The Amazon Resource Number (ARN) of the filter that has been deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteFilterError>`](crate::error::DeleteFilterError)
    pub fn delete_filter(&self) -> fluent_builders::DeleteFilter {
        fluent_builders::DeleteFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationConfiguration`](crate::client::fluent_builders::DescribeOrganizationConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeOrganizationConfiguration::send) it.

    /// - On success, responds with [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput) with field(s):
    ///   - [`auto_enable(Option<AutoEnable>)`](crate::output::DescribeOrganizationConfigurationOutput::auto_enable): <p>The scan types are automatically enabled for new members of your organization.</p>
    ///   - [`max_account_limit_reached(Option<bool>)`](crate::output::DescribeOrganizationConfigurationOutput::max_account_limit_reached): <p>Represents whether your organization has reached the maximum Amazon Web Services account limit for Amazon Inspector.</p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationConfigurationError>`](crate::error::DescribeOrganizationConfigurationError)
    pub fn describe_organization_configuration(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfiguration {
        fluent_builders::DescribeOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Disable`](crate::client::fluent_builders::Disable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::Disable::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::Disable::set_account_ids): <p>An array of account IDs you want to disable Amazon Inspector scans for.</p>
    ///   - [`resource_types(Vec<ResourceScanType>)`](crate::client::fluent_builders::Disable::resource_types) / [`set_resource_types(Option<Vec<ResourceScanType>>)`](crate::client::fluent_builders::Disable::set_resource_types): <p>The resource scan types you want to disable.</p>
    /// - On success, responds with [`DisableOutput`](crate::output::DisableOutput) with field(s):
    ///   - [`accounts(Option<Vec<Account>>)`](crate::output::DisableOutput::accounts): <p>Information on the accounts that have had Amazon Inspector scans successfully disabled. Details are provided for each account.</p>
    ///   - [`failed_accounts(Option<Vec<FailedAccount>>)`](crate::output::DisableOutput::failed_accounts): <p>Information on any accounts for which Amazon Inspector scans could not be disabled. Details are provided for each account.</p>
    /// - On failure, responds with [`SdkError<DisableError>`](crate::error::DisableError)
    pub fn disable(&self) -> fluent_builders::Disable {
        fluent_builders::Disable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableDelegatedAdminAccount`](crate::client::fluent_builders::DisableDelegatedAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delegated_admin_account_id(impl Into<String>)`](crate::client::fluent_builders::DisableDelegatedAdminAccount::delegated_admin_account_id) / [`set_delegated_admin_account_id(Option<String>)`](crate::client::fluent_builders::DisableDelegatedAdminAccount::set_delegated_admin_account_id): <p>The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.</p>
    /// - On success, responds with [`DisableDelegatedAdminAccountOutput`](crate::output::DisableDelegatedAdminAccountOutput) with field(s):
    ///   - [`delegated_admin_account_id(Option<String>)`](crate::output::DisableDelegatedAdminAccountOutput::delegated_admin_account_id): <p>The Amazon Web Services account ID of the successfully disabled delegated administrator.</p>
    /// - On failure, responds with [`SdkError<DisableDelegatedAdminAccountError>`](crate::error::DisableDelegatedAdminAccountError)
    pub fn disable_delegated_admin_account(&self) -> fluent_builders::DisableDelegatedAdminAccount {
        fluent_builders::DisableDelegatedAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMember`](crate::client::fluent_builders::DisassociateMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMember::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DisassociateMember::set_account_id): <p>The Amazon Web Services account ID of the member account to disassociate.</p>
    /// - On success, responds with [`DisassociateMemberOutput`](crate::output::DisassociateMemberOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::DisassociateMemberOutput::account_id): <p>The Amazon Web Services account ID of the successfully disassociated member.</p>
    /// - On failure, responds with [`SdkError<DisassociateMemberError>`](crate::error::DisassociateMemberError)
    pub fn disassociate_member(&self) -> fluent_builders::DisassociateMember {
        fluent_builders::DisassociateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Enable`](crate::client::fluent_builders::Enable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::Enable::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::Enable::set_account_ids): <p>A list of account IDs you want to enable Amazon Inspector scans for.</p>
    ///   - [`resource_types(Vec<ResourceScanType>)`](crate::client::fluent_builders::Enable::resource_types) / [`set_resource_types(Option<Vec<ResourceScanType>>)`](crate::client::fluent_builders::Enable::set_resource_types): <p>The resource scan types you want to enable.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::Enable::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::Enable::set_client_token): <p>The idempotency token for the request.</p>
    /// - On success, responds with [`EnableOutput`](crate::output::EnableOutput) with field(s):
    ///   - [`accounts(Option<Vec<Account>>)`](crate::output::EnableOutput::accounts): <p>Information on the accounts that have had Amazon Inspector scans successfully enabled. Details are provided for each account.</p>
    ///   - [`failed_accounts(Option<Vec<FailedAccount>>)`](crate::output::EnableOutput::failed_accounts): <p>Information on any accounts for which Amazon Inspector scans could not be enabled. Details are provided for each account.</p>
    /// - On failure, responds with [`SdkError<EnableError>`](crate::error::EnableError)
    pub fn enable(&self) -> fluent_builders::Enable {
        fluent_builders::Enable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableDelegatedAdminAccount`](crate::client::fluent_builders::EnableDelegatedAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delegated_admin_account_id(impl Into<String>)`](crate::client::fluent_builders::EnableDelegatedAdminAccount::delegated_admin_account_id) / [`set_delegated_admin_account_id(Option<String>)`](crate::client::fluent_builders::EnableDelegatedAdminAccount::set_delegated_admin_account_id): <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::EnableDelegatedAdminAccount::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::EnableDelegatedAdminAccount::set_client_token): <p>The idempotency token for the request.</p>
    /// - On success, responds with [`EnableDelegatedAdminAccountOutput`](crate::output::EnableDelegatedAdminAccountOutput) with field(s):
    ///   - [`delegated_admin_account_id(Option<String>)`](crate::output::EnableDelegatedAdminAccountOutput::delegated_admin_account_id): <p>The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.</p>
    /// - On failure, responds with [`SdkError<EnableDelegatedAdminAccountError>`](crate::error::EnableDelegatedAdminAccountError)
    pub fn enable_delegated_admin_account(&self) -> fluent_builders::EnableDelegatedAdminAccount {
        fluent_builders::EnableDelegatedAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDelegatedAdminAccount`](crate::client::fluent_builders::GetDelegatedAdminAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetDelegatedAdminAccount::send) it.

    /// - On success, responds with [`GetDelegatedAdminAccountOutput`](crate::output::GetDelegatedAdminAccountOutput) with field(s):
    ///   - [`delegated_admin(Option<DelegatedAdmin>)`](crate::output::GetDelegatedAdminAccountOutput::delegated_admin): <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
    /// - On failure, responds with [`SdkError<GetDelegatedAdminAccountError>`](crate::error::GetDelegatedAdminAccountError)
    pub fn get_delegated_admin_account(&self) -> fluent_builders::GetDelegatedAdminAccount {
        fluent_builders::GetDelegatedAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFindingsReportStatus`](crate::client::fluent_builders::GetFindingsReportStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_id(impl Into<String>)`](crate::client::fluent_builders::GetFindingsReportStatus::report_id) / [`set_report_id(Option<String>)`](crate::client::fluent_builders::GetFindingsReportStatus::set_report_id): <p>The ID of the report to retrieve the status of.</p>
    /// - On success, responds with [`GetFindingsReportStatusOutput`](crate::output::GetFindingsReportStatusOutput) with field(s):
    ///   - [`report_id(Option<String>)`](crate::output::GetFindingsReportStatusOutput::report_id): <p>The ID of the report.</p>
    ///   - [`status(Option<ExternalReportStatus>)`](crate::output::GetFindingsReportStatusOutput::status): <p>The status of the report.</p>
    ///   - [`error_code(Option<ReportingErrorCode>)`](crate::output::GetFindingsReportStatusOutput::error_code): <p>The error code of the report.</p>
    ///   - [`error_message(Option<String>)`](crate::output::GetFindingsReportStatusOutput::error_message): <p>The error message of the report.</p>
    ///   - [`destination(Option<Destination>)`](crate::output::GetFindingsReportStatusOutput::destination): <p>The destination of the report.</p>
    ///   - [`filter_criteria(Option<FilterCriteria>)`](crate::output::GetFindingsReportStatusOutput::filter_criteria): <p>The filter criteria associated with the report.</p>
    /// - On failure, responds with [`SdkError<GetFindingsReportStatusError>`](crate::error::GetFindingsReportStatusError)
    pub fn get_findings_report_status(&self) -> fluent_builders::GetFindingsReportStatus {
        fluent_builders::GetFindingsReportStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMember`](crate::client::fluent_builders::GetMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetMember::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetMember::set_account_id): <p>The Amazon Web Services account ID of the member account to retrieve information on.</p>
    /// - On success, responds with [`GetMemberOutput`](crate::output::GetMemberOutput) with field(s):
    ///   - [`member(Option<Member>)`](crate::output::GetMemberOutput::member): <p>Details of the retrieved member account.</p>
    /// - On failure, responds with [`SdkError<GetMemberError>`](crate::error::GetMemberError)
    pub fn get_member(&self) -> fluent_builders::GetMember {
        fluent_builders::GetMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountPermissions`](crate::client::fluent_builders::ListAccountPermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountPermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service(Service)`](crate::client::fluent_builders::ListAccountPermissions::service) / [`set_service(Option<Service>)`](crate::client::fluent_builders::ListAccountPermissions::set_service): <p>The service scan type to check permissions for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountPermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccountPermissions::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountPermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountPermissions::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On success, responds with [`ListAccountPermissionsOutput`](crate::output::ListAccountPermissionsOutput) with field(s):
    ///   - [`permissions(Option<Vec<Permission>>)`](crate::output::ListAccountPermissionsOutput::permissions): <p>Contains details on the permissions an account has to configure Amazon Inspector.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountPermissionsOutput::next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On failure, responds with [`SdkError<ListAccountPermissionsError>`](crate::error::ListAccountPermissionsError)
    pub fn list_account_permissions(&self) -> fluent_builders::ListAccountPermissions {
        fluent_builders::ListAccountPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCoverage`](crate::client::fluent_builders::ListCoverage) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCoverage::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCoverage::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCoverage::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCoverage::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCoverage::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    ///   - [`filter_criteria(CoverageFilterCriteria)`](crate::client::fluent_builders::ListCoverage::filter_criteria) / [`set_filter_criteria(Option<CoverageFilterCriteria>)`](crate::client::fluent_builders::ListCoverage::set_filter_criteria): <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
    /// - On success, responds with [`ListCoverageOutput`](crate::output::ListCoverageOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListCoverageOutput::next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    ///   - [`covered_resources(Option<Vec<CoveredResource>>)`](crate::output::ListCoverageOutput::covered_resources): <p>An object that contains details on the covered resources in your environment.</p>
    /// - On failure, responds with [`SdkError<ListCoverageError>`](crate::error::ListCoverageError)
    pub fn list_coverage(&self) -> fluent_builders::ListCoverage {
        fluent_builders::ListCoverage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCoverageStatistics`](crate::client::fluent_builders::ListCoverageStatistics) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCoverageStatistics::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_criteria(CoverageFilterCriteria)`](crate::client::fluent_builders::ListCoverageStatistics::filter_criteria) / [`set_filter_criteria(Option<CoverageFilterCriteria>)`](crate::client::fluent_builders::ListCoverageStatistics::set_filter_criteria): <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
    ///   - [`group_by(GroupKey)`](crate::client::fluent_builders::ListCoverageStatistics::group_by) / [`set_group_by(Option<GroupKey>)`](crate::client::fluent_builders::ListCoverageStatistics::set_group_by): <p>The value to group the results by.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCoverageStatistics::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCoverageStatistics::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On success, responds with [`ListCoverageStatisticsOutput`](crate::output::ListCoverageStatisticsOutput) with field(s):
    ///   - [`counts_by_group(Option<Vec<Counts>>)`](crate::output::ListCoverageStatisticsOutput::counts_by_group): <p>An array with the number for each group.</p>
    ///   - [`total_counts(Option<i64>)`](crate::output::ListCoverageStatisticsOutput::total_counts): <p>The total number for all groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCoverageStatisticsOutput::next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On failure, responds with [`SdkError<ListCoverageStatisticsError>`](crate::error::ListCoverageStatisticsError)
    pub fn list_coverage_statistics(&self) -> fluent_builders::ListCoverageStatistics {
        fluent_builders::ListCoverageStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDelegatedAdminAccounts`](crate::client::fluent_builders::ListDelegatedAdminAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDelegatedAdminAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDelegatedAdminAccounts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDelegatedAdminAccounts::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDelegatedAdminAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDelegatedAdminAccounts::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On success, responds with [`ListDelegatedAdminAccountsOutput`](crate::output::ListDelegatedAdminAccountsOutput) with field(s):
    ///   - [`delegated_admin_accounts(Option<Vec<DelegatedAdminAccount>>)`](crate::output::ListDelegatedAdminAccountsOutput::delegated_admin_accounts): <p>Details of the Amazon Inspector delegated administrator of your organization.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDelegatedAdminAccountsOutput::next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On failure, responds with [`SdkError<ListDelegatedAdminAccountsError>`](crate::error::ListDelegatedAdminAccountsError)
    pub fn list_delegated_admin_accounts(&self) -> fluent_builders::ListDelegatedAdminAccounts {
        fluent_builders::ListDelegatedAdminAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFilters`](crate::client::fluent_builders::ListFilters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFilters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`arns(Vec<String>)`](crate::client::fluent_builders::ListFilters::arns) / [`set_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListFilters::set_arns): <p>The Amazon resource number (ARN) of the filter.</p>
    ///   - [`action(FilterAction)`](crate::client::fluent_builders::ListFilters::action) / [`set_action(Option<FilterAction>)`](crate::client::fluent_builders::ListFilters::set_action): <p>The action the filter applies to matched findings.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFilters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFilters::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFilters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFilters::set_max_results): <p>The maximum number of results to return in the response.</p>
    /// - On success, responds with [`ListFiltersOutput`](crate::output::ListFiltersOutput) with field(s):
    ///   - [`filters(Option<Vec<Filter>>)`](crate::output::ListFiltersOutput::filters): <p>Contains details on the filters associated with your account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFiltersOutput::next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On failure, responds with [`SdkError<ListFiltersError>`](crate::error::ListFiltersError)
    pub fn list_filters(&self) -> fluent_builders::ListFilters {
        fluent_builders::ListFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFindingAggregations`](crate::client::fluent_builders::ListFindingAggregations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFindingAggregations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`aggregation_type(AggregationType)`](crate::client::fluent_builders::ListFindingAggregations::aggregation_type) / [`set_aggregation_type(Option<AggregationType>)`](crate::client::fluent_builders::ListFindingAggregations::set_aggregation_type): <p>The type of the aggregation request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFindingAggregations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFindingAggregations::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFindingAggregations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFindingAggregations::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`account_ids(Vec<StringFilter>)`](crate::client::fluent_builders::ListFindingAggregations::account_ids) / [`set_account_ids(Option<Vec<StringFilter>>)`](crate::client::fluent_builders::ListFindingAggregations::set_account_ids): <p>The Amazon Web Services account IDs to retrieve finding aggregation data for.</p>
    ///   - [`aggregation_request(AggregationRequest)`](crate::client::fluent_builders::ListFindingAggregations::aggregation_request) / [`set_aggregation_request(Option<AggregationRequest>)`](crate::client::fluent_builders::ListFindingAggregations::set_aggregation_request): <p>Details of the aggregation request that is used to filter your aggregation results.</p>
    /// - On success, responds with [`ListFindingAggregationsOutput`](crate::output::ListFindingAggregationsOutput) with field(s):
    ///   - [`aggregation_type(Option<AggregationType>)`](crate::output::ListFindingAggregationsOutput::aggregation_type): <p>The type of aggregation to perform.</p>
    ///   - [`responses(Option<Vec<AggregationResponse>>)`](crate::output::ListFindingAggregationsOutput::responses): <p>Objects that contain the results of an aggregation operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFindingAggregationsOutput::next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On failure, responds with [`SdkError<ListFindingAggregationsError>`](crate::error::ListFindingAggregationsError)
    pub fn list_finding_aggregations(&self) -> fluent_builders::ListFindingAggregations {
        fluent_builders::ListFindingAggregations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFindings`](crate::client::fluent_builders::ListFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFindings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFindings::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFindings::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    ///   - [`filter_criteria(FilterCriteria)`](crate::client::fluent_builders::ListFindings::filter_criteria) / [`set_filter_criteria(Option<FilterCriteria>)`](crate::client::fluent_builders::ListFindings::set_filter_criteria): <p>Details on the filters to apply to your finding results.</p>
    ///   - [`sort_criteria(SortCriteria)`](crate::client::fluent_builders::ListFindings::sort_criteria) / [`set_sort_criteria(Option<SortCriteria>)`](crate::client::fluent_builders::ListFindings::set_sort_criteria): <p>Details on the sort criteria to apply to your finding results.</p>
    /// - On success, responds with [`ListFindingsOutput`](crate::output::ListFindingsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFindingsOutput::next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    ///   - [`findings(Option<Vec<Finding>>)`](crate::output::ListFindingsOutput::findings): <p>Contains details on the findings in your environment.</p>
    /// - On failure, responds with [`SdkError<ListFindingsError>`](crate::error::ListFindingsError)
    pub fn list_findings(&self) -> fluent_builders::ListFindings {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMembers`](crate::client::fluent_builders::ListMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`only_associated(bool)`](crate::client::fluent_builders::ListMembers::only_associated) / [`set_only_associated(Option<bool>)`](crate::client::fluent_builders::ListMembers::set_only_associated): <p>Specifies whether to list only currently associated members if <code>True</code> or to list all members within the organization if <code>False</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMembers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMembers::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMembers::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    /// - On success, responds with [`ListMembersOutput`](crate::output::ListMembersOutput) with field(s):
    ///   - [`members(Option<Vec<Member>>)`](crate::output::ListMembersOutput::members): <p>An object that contains details for each member account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMembersOutput::next_token): <p>The pagination parameter to be used on the next list operation to retrieve more items.</p>
    /// - On failure, responds with [`SdkError<ListMembersError>`](crate::error::ListMembersError)
    pub fn list_members(&self) -> fluent_builders::ListMembers {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon resource number (ARN) of the resource to list tags of.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags associated with the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsageTotals`](crate::client::fluent_builders::ListUsageTotals) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUsageTotals::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsageTotals::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUsageTotals::set_max_results): <p>The maximum number of results to return in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsageTotals::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsageTotals::set_next_token): <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::ListUsageTotals::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListUsageTotals::set_account_ids): <p>The Amazon Web Services account IDs to retrieve usage totals for.</p>
    /// - On success, responds with [`ListUsageTotalsOutput`](crate::output::ListUsageTotalsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListUsageTotalsOutput::next_token): <p>The pagination parameter to be used on the next list operation to retrieve more items.</p>
    ///   - [`totals(Option<Vec<UsageTotal>>)`](crate::output::ListUsageTotalsOutput::totals): <p>An object with details on the total usage for the requested account.</p>
    /// - On failure, responds with [`SdkError<ListUsageTotalsError>`](crate::error::ListUsageTotalsError)
    pub fn list_usage_totals(&self) -> fluent_builders::ListUsageTotals {
        fluent_builders::ListUsageTotals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to apply a tag to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to be added to a resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFilter`](crate::client::fluent_builders::UpdateFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action(FilterAction)`](crate::client::fluent_builders::UpdateFilter::action) / [`set_action(Option<FilterAction>)`](crate::client::fluent_builders::UpdateFilter::set_action): <p>Specifies the action that is to be applied to the findings that match the filter.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFilter::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFilter::set_description): <p>A description of the filter.</p>
    ///   - [`filter_criteria(FilterCriteria)`](crate::client::fluent_builders::UpdateFilter::filter_criteria) / [`set_filter_criteria(Option<FilterCriteria>)`](crate::client::fluent_builders::UpdateFilter::set_filter_criteria): <p>Defines the criteria to be update in the filter.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFilter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFilter::set_name): <p>The name of the filter.</p>
    ///   - [`filter_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFilter::filter_arn) / [`set_filter_arn(Option<String>)`](crate::client::fluent_builders::UpdateFilter::set_filter_arn): <p>The Amazon Resource Number (ARN) of the filter to update.</p>
    /// - On success, responds with [`UpdateFilterOutput`](crate::output::UpdateFilterOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateFilterOutput::arn): <p>The Amazon Resource Number (ARN) of the successfully updated filter.</p>
    /// - On failure, responds with [`SdkError<UpdateFilterError>`](crate::error::UpdateFilterError)
    pub fn update_filter(&self) -> fluent_builders::UpdateFilter {
        fluent_builders::UpdateFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOrganizationConfiguration`](crate::client::fluent_builders::UpdateOrganizationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_enable(AutoEnable)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::auto_enable) / [`set_auto_enable(Option<AutoEnable>)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::set_auto_enable): <p>Defines which scan types are enabled automatically for new members of your Amazon Inspector organization.</p>
    /// - On success, responds with [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput) with field(s):
    ///   - [`auto_enable(Option<AutoEnable>)`](crate::output::UpdateOrganizationConfigurationOutput::auto_enable): <p>The updated status of scan types automatically enabled for new members of your Amazon Inspector organization.</p>
    /// - On failure, responds with [`SdkError<UpdateOrganizationConfigurationError>`](crate::error::UpdateOrganizationConfigurationError)
    pub fn update_organization_configuration(
        &self,
    ) -> fluent_builders::UpdateOrganizationConfiguration {
        fluent_builders::UpdateOrganizationConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateMember`.
    ///
    /// <p>Associates an Amazon Web Services account with an Amazon Inspector delegated administrator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_member_input::Builder,
    }
    impl AssociateMember {
        /// Creates a new `AssociateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the member account to be associated.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account to be associated.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetAccountStatus`.
    ///
    /// <p>Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetAccountStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_account_status_input::Builder,
    }
    impl BatchGetAccountStatus {
        /// Creates a new `BatchGetAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetAccountStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 12-digit Amazon Web Services account IDs of the accounts to retrieve Amazon Inspector status for.</p>
        pub fn account_ids(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>The 12-digit Amazon Web Services account IDs of the accounts to retrieve Amazon Inspector status for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetFreeTrialInfo`.
    ///
    /// <p>Gets free trial status for multiple Amazon Web Services accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetFreeTrialInfo {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_free_trial_info_input::Builder,
    }
    impl BatchGetFreeTrialInfo {
        /// Creates a new `BatchGetFreeTrialInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetFreeTrialInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetFreeTrialInfoError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account IDs to get free trial status for.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The account IDs to get free trial status for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelFindingsReport`.
    ///
    /// <p>Cancels the given findings report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelFindingsReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_findings_report_input::Builder,
    }
    impl CancelFindingsReport {
        /// Creates a new `CancelFindingsReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelFindingsReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelFindingsReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the report to be canceled.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>The ID of the report to be canceled.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFilter`.
    ///
    /// <p>Creates a filter resource using specified filter criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_filter_input::Builder,
    }
    impl CreateFilter {
        /// Creates a new `CreateFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Defines the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A description of the filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Defines the criteria to be used in the filter for querying findings.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>Defines the criteria to be used in the filter for querying findings.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags for the filter.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags for the filter.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFindingsReport`.
    ///
    /// <p>Creates a finding report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFindingsReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_findings_report_input::Builder,
    }
    impl CreateFindingsReport {
        /// Creates a new `CreateFindingsReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFindingsReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFindingsReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The filter criteria to apply to the results of the finding report.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>The filter criteria to apply to the results of the finding report.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The format to generate the report in.</p>
        pub fn report_format(mut self, input: crate::model::ReportFormat) -> Self {
            self.inner = self.inner.report_format(input);
            self
        }
        /// <p>The format to generate the report in.</p>
        pub fn set_report_format(
            mut self,
            input: std::option::Option<crate::model::ReportFormat>,
        ) -> Self {
            self.inner = self.inner.set_report_format(input);
            self
        }
        /// <p>The Amazon S3 export destination for the report.</p>
        pub fn s3_destination(mut self, input: crate::model::Destination) -> Self {
            self.inner = self.inner.s3_destination(input);
            self
        }
        /// <p>The Amazon S3 export destination for the report.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFilter`.
    ///
    /// <p>Deletes a filter resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_filter_input::Builder,
    }
    impl DeleteFilter {
        /// Creates a new `DeleteFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to be deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfiguration`.
    ///
    /// <p>Describe Amazon Inspector configuration settings for an Amazon Web Services organization</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_organization_configuration_input::Builder,
    }
    impl DescribeOrganizationConfiguration {
        /// Creates a new `DescribeOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `Disable`.
    ///
    /// <p>Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Disable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_input::Builder,
    }
    impl Disable {
        /// Creates a new `Disable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An array of account IDs you want to disable Amazon Inspector scans for.</p>
        pub fn account_ids(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>An array of account IDs you want to disable Amazon Inspector scans for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `resourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The resource scan types you want to disable.</p>
        pub fn resource_types(mut self, input: crate::model::ResourceScanType) -> Self {
            self.inner = self.inner.resource_types(input);
            self
        }
        /// <p>The resource scan types you want to disable.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceScanType>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDelegatedAdminAccount`.
    ///
    /// <p>Disables the Amazon Inspector delegated administrator for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableDelegatedAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_delegated_admin_account_input::Builder,
    }
    impl DisableDelegatedAdminAccount {
        /// Creates a new `DisableDelegatedAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDelegatedAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDelegatedAdminAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.</p>
        pub fn delegated_admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegated_admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.</p>
        pub fn set_delegated_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegated_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMember`.
    ///
    /// <p>Disassociates a member account from an Amazon Inspector delegated administrator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_member_input::Builder,
    }
    impl DisassociateMember {
        /// Creates a new `DisassociateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the member account to disassociate.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account to disassociate.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Enable`.
    ///
    /// <p>Enables Amazon Inspector scans for one or more Amazon Web Services accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Enable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_input::Builder,
    }
    impl Enable {
        /// Creates a new `Enable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A list of account IDs you want to enable Amazon Inspector scans for.</p>
        pub fn account_ids(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>A list of account IDs you want to enable Amazon Inspector scans for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `resourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The resource scan types you want to enable.</p>
        pub fn resource_types(mut self, input: crate::model::ResourceScanType) -> Self {
            self.inner = self.inner.resource_types(input);
            self
        }
        /// <p>The resource scan types you want to enable.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceScanType>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDelegatedAdminAccount`.
    ///
    /// <p>Enables the Amazon Inspector delegated administrator for your Organizations organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableDelegatedAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_delegated_admin_account_input::Builder,
    }
    impl EnableDelegatedAdminAccount {
        /// Creates a new `EnableDelegatedAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDelegatedAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDelegatedAdminAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
        pub fn delegated_admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegated_admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
        pub fn set_delegated_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegated_admin_account_id(input);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDelegatedAdminAccount`.
    ///
    /// <p>Retrieves information about the Amazon Inspector delegated administrator for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDelegatedAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_delegated_admin_account_input::Builder,
    }
    impl GetDelegatedAdminAccount {
        /// Creates a new `GetDelegatedAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDelegatedAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDelegatedAdminAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetFindingsReportStatus`.
    ///
    /// <p>Gets the status of a findings report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindingsReportStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_findings_report_status_input::Builder,
    }
    impl GetFindingsReportStatus {
        /// Creates a new `GetFindingsReportStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsReportStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsReportStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the report to retrieve the status of.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>The ID of the report to retrieve the status of.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMember`.
    ///
    /// <p>Gets member information for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_member_input::Builder,
    }
    impl GetMember {
        /// Creates a new `GetMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the member account to retrieve information on.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account to retrieve information on.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountPermissions`.
    ///
    /// <p>Lists the permissions an account has to configure Amazon Inspector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_account_permissions_input::Builder,
    }
    impl ListAccountPermissions {
        /// Creates a new `ListAccountPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountPermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountPermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountPermissionsPaginator {
            crate::paginator::ListAccountPermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The service scan type to check permissions for.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.inner = self.inner.service(input);
            self
        }
        /// <p>The service scan type to check permissions for.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoverage`.
    ///
    /// <p>Lists coverage details for you environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoverage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_coverage_input::Builder,
    }
    impl ListCoverage {
        /// Creates a new `ListCoverage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoverageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoverageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoveragePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoveragePaginator {
            crate::paginator::ListCoveragePaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn filter_criteria(mut self, input: crate::model::CoverageFilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::CoverageFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoverageStatistics`.
    ///
    /// <p>Lists Amazon Inspector coverage statistics for your environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoverageStatistics {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_coverage_statistics_input::Builder,
    }
    impl ListCoverageStatistics {
        /// Creates a new `ListCoverageStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoverageStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoverageStatisticsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoverageStatisticsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoverageStatisticsPaginator {
            crate::paginator::ListCoverageStatisticsPaginator::new(self.handle, self.inner)
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn filter_criteria(mut self, input: crate::model::CoverageFilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::CoverageFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The value to group the results by.</p>
        pub fn group_by(mut self, input: crate::model::GroupKey) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>The value to group the results by.</p>
        pub fn set_group_by(mut self, input: std::option::Option<crate::model::GroupKey>) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDelegatedAdminAccounts`.
    ///
    /// <p>Lists information about the Amazon Inspector delegated administrator of your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDelegatedAdminAccounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_delegated_admin_accounts_input::Builder,
    }
    impl ListDelegatedAdminAccounts {
        /// Creates a new `ListDelegatedAdminAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDelegatedAdminAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDelegatedAdminAccountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDelegatedAdminAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDelegatedAdminAccountsPaginator {
            crate::paginator::ListDelegatedAdminAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFilters`.
    ///
    /// <p>Lists the filters associated with your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFilters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_filters_input::Builder,
    }
    impl ListFilters {
        /// Creates a new `ListFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFiltersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFiltersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFiltersPaginator {
            crate::paginator::ListFiltersPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The Amazon resource number (ARN) of the filter.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(input.into());
            self
        }
        /// <p>The Amazon resource number (ARN) of the filter.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
        /// <p>The action the filter applies to matched findings.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>The action the filter applies to matched findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindingAggregations`.
    ///
    /// <p>Lists aggregated finding data for your environment based on specific criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindingAggregations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_finding_aggregations_input::Builder,
    }
    impl ListFindingAggregations {
        /// Creates a new `ListFindingAggregations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingAggregationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingAggregationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingAggregationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingAggregationsPaginator {
            crate::paginator::ListFindingAggregationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The type of the aggregation request.</p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.inner = self.inner.aggregation_type(input);
            self
        }
        /// <p>The type of the aggregation request.</p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_type(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The Amazon Web Services account IDs to retrieve finding aggregation data for.</p>
        pub fn account_ids(mut self, input: crate::model::StringFilter) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>The Amazon Web Services account IDs to retrieve finding aggregation data for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p>Details of the aggregation request that is used to filter your aggregation results.</p>
        pub fn aggregation_request(mut self, input: crate::model::AggregationRequest) -> Self {
            self.inner = self.inner.aggregation_request(input);
            self
        }
        /// <p>Details of the aggregation request that is used to filter your aggregation results.</p>
        pub fn set_aggregation_request(
            mut self,
            input: std::option::Option<crate::model::AggregationRequest>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Lists findings for your environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl ListFindings {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingsPaginator {
            crate::paginator::ListFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Details on the filters to apply to your finding results.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>Details on the filters to apply to your finding results.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>Details on the sort criteria to apply to your finding results.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>Details on the sort criteria to apply to your finding results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>List members associated with the Amazon Inspector delegated administrator for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_members_input::Builder,
    }
    impl ListMembers {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMembersPaginator {
            crate::paginator::ListMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies whether to list only currently associated members if <code>True</code> or to list all members within the organization if <code>False</code>.</p>
        pub fn only_associated(mut self, input: bool) -> Self {
            self.inner = self.inner.only_associated(input);
            self
        }
        /// <p>Specifies whether to list only currently associated members if <code>True</code> or to list all members within the organization if <code>False</code>.</p>
        pub fn set_only_associated(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_only_associated(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags attached to a given resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource number (ARN) of the resource to list tags of.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon resource number (ARN) of the resource to list tags of.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsageTotals`.
    ///
    /// <p>Lists the Amazon Inspector usage totals over the last 30 days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsageTotals {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_usage_totals_input::Builder,
    }
    impl ListUsageTotals {
        /// Creates a new `ListUsageTotals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsageTotalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsageTotalsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsageTotalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsageTotalsPaginator {
            crate::paginator::ListUsageTotalsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The Amazon Web Services account IDs to retrieve usage totals for.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The Amazon Web Services account IDs to retrieve usage totals for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply a tag to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply a tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be added to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFilter`.
    ///
    /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_filter_input::Builder,
    }
    impl UpdateFilter {
        /// Creates a new `UpdateFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A description of the filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Defines the criteria to be update in the filter.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>Defines the criteria to be update in the filter.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to update.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to update.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationConfiguration`.
    ///
    /// <p>Updates the configurations for your Amazon Inspector organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOrganizationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_organization_configuration_input::Builder,
    }
    impl UpdateOrganizationConfiguration {
        /// Creates a new `UpdateOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines which scan types are enabled automatically for new members of your Amazon Inspector organization.</p>
        pub fn auto_enable(mut self, input: crate::model::AutoEnable) -> Self {
            self.inner = self.inner.auto_enable(input);
            self
        }
        /// <p>Defines which scan types are enabled automatically for new members of your Amazon Inspector organization.</p>
        pub fn set_auto_enable(
            mut self,
            input: std::option::Option<crate::model::AutoEnable>,
        ) -> Self {
            self.inner = self.inner.set_auto_enable(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
