// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Inspector2
///
/// Client for invoking operations on Inspector2. Each operation on Inspector2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_inspector2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_inspector2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_inspector2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateMember` operation.
    ///
    /// See [`AssociateMember`](crate::client::fluent_builders::AssociateMember) for more information about the
    /// operation and its arguments.
    pub fn associate_member(&self) -> fluent_builders::AssociateMember<C, M, R> {
        fluent_builders::AssociateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetAccountStatus` operation.
    ///
    /// See [`BatchGetAccountStatus`](crate::client::fluent_builders::BatchGetAccountStatus) for more information about the
    /// operation and its arguments.
    pub fn batch_get_account_status(&self) -> fluent_builders::BatchGetAccountStatus<C, M, R> {
        fluent_builders::BatchGetAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetFreeTrialInfo` operation.
    ///
    /// See [`BatchGetFreeTrialInfo`](crate::client::fluent_builders::BatchGetFreeTrialInfo) for more information about the
    /// operation and its arguments.
    pub fn batch_get_free_trial_info(&self) -> fluent_builders::BatchGetFreeTrialInfo<C, M, R> {
        fluent_builders::BatchGetFreeTrialInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelFindingsReport` operation.
    ///
    /// See [`CancelFindingsReport`](crate::client::fluent_builders::CancelFindingsReport) for more information about the
    /// operation and its arguments.
    pub fn cancel_findings_report(&self) -> fluent_builders::CancelFindingsReport<C, M, R> {
        fluent_builders::CancelFindingsReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFilter` operation.
    ///
    /// See [`CreateFilter`](crate::client::fluent_builders::CreateFilter) for more information about the
    /// operation and its arguments.
    pub fn create_filter(&self) -> fluent_builders::CreateFilter<C, M, R> {
        fluent_builders::CreateFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFindingsReport` operation.
    ///
    /// See [`CreateFindingsReport`](crate::client::fluent_builders::CreateFindingsReport) for more information about the
    /// operation and its arguments.
    pub fn create_findings_report(&self) -> fluent_builders::CreateFindingsReport<C, M, R> {
        fluent_builders::CreateFindingsReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFilter` operation.
    ///
    /// See [`DeleteFilter`](crate::client::fluent_builders::DeleteFilter) for more information about the
    /// operation and its arguments.
    pub fn delete_filter(&self) -> fluent_builders::DeleteFilter<C, M, R> {
        fluent_builders::DeleteFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationConfiguration` operation.
    ///
    /// See [`DescribeOrganizationConfiguration`](crate::client::fluent_builders::DescribeOrganizationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_organization_configuration(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfiguration<C, M, R> {
        fluent_builders::DescribeOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Disable` operation.
    ///
    /// See [`Disable`](crate::client::fluent_builders::Disable) for more information about the
    /// operation and its arguments.
    pub fn disable(&self) -> fluent_builders::Disable<C, M, R> {
        fluent_builders::Disable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableDelegatedAdminAccount` operation.
    ///
    /// See [`DisableDelegatedAdminAccount`](crate::client::fluent_builders::DisableDelegatedAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn disable_delegated_admin_account(
        &self,
    ) -> fluent_builders::DisableDelegatedAdminAccount<C, M, R> {
        fluent_builders::DisableDelegatedAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateMember` operation.
    ///
    /// See [`DisassociateMember`](crate::client::fluent_builders::DisassociateMember) for more information about the
    /// operation and its arguments.
    pub fn disassociate_member(&self) -> fluent_builders::DisassociateMember<C, M, R> {
        fluent_builders::DisassociateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Enable` operation.
    ///
    /// See [`Enable`](crate::client::fluent_builders::Enable) for more information about the
    /// operation and its arguments.
    pub fn enable(&self) -> fluent_builders::Enable<C, M, R> {
        fluent_builders::Enable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableDelegatedAdminAccount` operation.
    ///
    /// See [`EnableDelegatedAdminAccount`](crate::client::fluent_builders::EnableDelegatedAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn enable_delegated_admin_account(
        &self,
    ) -> fluent_builders::EnableDelegatedAdminAccount<C, M, R> {
        fluent_builders::EnableDelegatedAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDelegatedAdminAccount` operation.
    ///
    /// See [`GetDelegatedAdminAccount`](crate::client::fluent_builders::GetDelegatedAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn get_delegated_admin_account(
        &self,
    ) -> fluent_builders::GetDelegatedAdminAccount<C, M, R> {
        fluent_builders::GetDelegatedAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindingsReportStatus` operation.
    ///
    /// See [`GetFindingsReportStatus`](crate::client::fluent_builders::GetFindingsReportStatus) for more information about the
    /// operation and its arguments.
    pub fn get_findings_report_status(&self) -> fluent_builders::GetFindingsReportStatus<C, M, R> {
        fluent_builders::GetFindingsReportStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMember` operation.
    ///
    /// See [`GetMember`](crate::client::fluent_builders::GetMember) for more information about the
    /// operation and its arguments.
    pub fn get_member(&self) -> fluent_builders::GetMember<C, M, R> {
        fluent_builders::GetMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountPermissions` operation.
    ///
    /// See [`ListAccountPermissions`](crate::client::fluent_builders::ListAccountPermissions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAccountPermissions::into_paginator).
    pub fn list_account_permissions(&self) -> fluent_builders::ListAccountPermissions<C, M, R> {
        fluent_builders::ListAccountPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCoverage` operation.
    ///
    /// See [`ListCoverage`](crate::client::fluent_builders::ListCoverage) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCoverage::into_paginator).
    pub fn list_coverage(&self) -> fluent_builders::ListCoverage<C, M, R> {
        fluent_builders::ListCoverage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCoverageStatistics` operation.
    ///
    /// See [`ListCoverageStatistics`](crate::client::fluent_builders::ListCoverageStatistics) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCoverageStatistics::into_paginator).
    pub fn list_coverage_statistics(&self) -> fluent_builders::ListCoverageStatistics<C, M, R> {
        fluent_builders::ListCoverageStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDelegatedAdminAccounts` operation.
    ///
    /// See [`ListDelegatedAdminAccounts`](crate::client::fluent_builders::ListDelegatedAdminAccounts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDelegatedAdminAccounts::into_paginator).
    pub fn list_delegated_admin_accounts(
        &self,
    ) -> fluent_builders::ListDelegatedAdminAccounts<C, M, R> {
        fluent_builders::ListDelegatedAdminAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFilters` operation.
    ///
    /// See [`ListFilters`](crate::client::fluent_builders::ListFilters) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFilters::into_paginator).
    pub fn list_filters(&self) -> fluent_builders::ListFilters<C, M, R> {
        fluent_builders::ListFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindingAggregations` operation.
    ///
    /// See [`ListFindingAggregations`](crate::client::fluent_builders::ListFindingAggregations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFindingAggregations::into_paginator).
    pub fn list_finding_aggregations(&self) -> fluent_builders::ListFindingAggregations<C, M, R> {
        fluent_builders::ListFindingAggregations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindings` operation.
    ///
    /// See [`ListFindings`](crate::client::fluent_builders::ListFindings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFindings::into_paginator).
    pub fn list_findings(&self) -> fluent_builders::ListFindings<C, M, R> {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMembers` operation.
    ///
    /// See [`ListMembers`](crate::client::fluent_builders::ListMembers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListMembers::into_paginator).
    pub fn list_members(&self) -> fluent_builders::ListMembers<C, M, R> {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsageTotals` operation.
    ///
    /// See [`ListUsageTotals`](crate::client::fluent_builders::ListUsageTotals) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListUsageTotals::into_paginator).
    pub fn list_usage_totals(&self) -> fluent_builders::ListUsageTotals<C, M, R> {
        fluent_builders::ListUsageTotals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFilter` operation.
    ///
    /// See [`UpdateFilter`](crate::client::fluent_builders::UpdateFilter) for more information about the
    /// operation and its arguments.
    pub fn update_filter(&self) -> fluent_builders::UpdateFilter<C, M, R> {
        fluent_builders::UpdateFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOrganizationConfiguration` operation.
    ///
    /// See [`UpdateOrganizationConfiguration`](crate::client::fluent_builders::UpdateOrganizationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_organization_configuration(
        &self,
    ) -> fluent_builders::UpdateOrganizationConfiguration<C, M, R> {
        fluent_builders::UpdateOrganizationConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateMember`.
    ///
    /// <p>Associates an Amazon Web Services account with an Amazon Inspector delegated administrator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_member_input::Builder,
    }
    impl<C, M, R> AssociateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateMemberInputOperationOutputAlias,
                crate::output::AssociateMemberOutput,
                crate::error::AssociateMemberError,
                crate::input::AssociateMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the member account to be associated.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account to be associated.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetAccountStatus`.
    ///
    /// <p>Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetAccountStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_account_status_input::Builder,
    }
    impl<C, M, R> BatchGetAccountStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetAccountStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetAccountStatusInputOperationOutputAlias,
                crate::output::BatchGetAccountStatusOutput,
                crate::error::BatchGetAccountStatusError,
                crate::input::BatchGetAccountStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 12-digit Amazon Web Services account IDs of the accounts to retrieve Amazon Inspector status for.</p>
        pub fn account_ids(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>The 12-digit Amazon Web Services account IDs of the accounts to retrieve Amazon Inspector status for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetFreeTrialInfo`.
    ///
    /// <p>Gets free trial status for multiple Amazon Web Services accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetFreeTrialInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_free_trial_info_input::Builder,
    }
    impl<C, M, R> BatchGetFreeTrialInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetFreeTrialInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetFreeTrialInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetFreeTrialInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetFreeTrialInfoInputOperationOutputAlias,
                crate::output::BatchGetFreeTrialInfoOutput,
                crate::error::BatchGetFreeTrialInfoError,
                crate::input::BatchGetFreeTrialInfoInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account IDs to get free trial status for.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The account IDs to get free trial status for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelFindingsReport`.
    ///
    /// <p>Cancels the given findings report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelFindingsReport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_findings_report_input::Builder,
    }
    impl<C, M, R> CancelFindingsReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelFindingsReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelFindingsReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelFindingsReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelFindingsReportInputOperationOutputAlias,
                crate::output::CancelFindingsReportOutput,
                crate::error::CancelFindingsReportError,
                crate::input::CancelFindingsReportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the report to be canceled.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>The ID of the report to be canceled.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFilter`.
    ///
    /// <p>Creates a filter resource using specified filter criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_filter_input::Builder,
    }
    impl<C, M, R> CreateFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFilterInputOperationOutputAlias,
                crate::output::CreateFilterOutput,
                crate::error::CreateFilterError,
                crate::input::CreateFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Defines the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A description of the filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Defines the criteria to be used in the filter for querying findings.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>Defines the criteria to be used in the filter for querying findings.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags for the filter.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags for the filter.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFindingsReport`.
    ///
    /// <p>Creates a finding report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFindingsReport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_findings_report_input::Builder,
    }
    impl<C, M, R> CreateFindingsReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFindingsReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFindingsReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFindingsReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFindingsReportInputOperationOutputAlias,
                crate::output::CreateFindingsReportOutput,
                crate::error::CreateFindingsReportError,
                crate::input::CreateFindingsReportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The filter criteria to apply to the results of the finding report.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>The filter criteria to apply to the results of the finding report.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The format to generate the report in.</p>
        pub fn report_format(mut self, input: crate::model::ReportFormat) -> Self {
            self.inner = self.inner.report_format(input);
            self
        }
        /// <p>The format to generate the report in.</p>
        pub fn set_report_format(
            mut self,
            input: std::option::Option<crate::model::ReportFormat>,
        ) -> Self {
            self.inner = self.inner.set_report_format(input);
            self
        }
        /// <p>The Amazon S3 export destination for the report.</p>
        pub fn s3_destination(mut self, input: crate::model::Destination) -> Self {
            self.inner = self.inner.s3_destination(input);
            self
        }
        /// <p>The Amazon S3 export destination for the report.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFilter`.
    ///
    /// <p>Deletes a filter resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_filter_input::Builder,
    }
    impl<C, M, R> DeleteFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFilterInputOperationOutputAlias,
                crate::output::DeleteFilterOutput,
                crate::error::DeleteFilterError,
                crate::input::DeleteFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to be deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to be deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfiguration`.
    ///
    /// <p>Describe Amazon Inspector configuration settings for an Amazon Web Services organization</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_configuration_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConfigurationInputOperationOutputAlias,
                crate::output::DescribeOrganizationConfigurationOutput,
                crate::error::DescribeOrganizationConfigurationError,
                crate::input::DescribeOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `Disable`.
    ///
    /// <p>Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Disable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_input::Builder,
    }
    impl<C, M, R> Disable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Disable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableInputOperationOutputAlias,
                crate::output::DisableOutput,
                crate::error::DisableError,
                crate::input::DisableInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An array of account IDs you want to disable Amazon Inspector scans for.</p>
        pub fn account_ids(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>An array of account IDs you want to disable Amazon Inspector scans for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `resourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The resource scan types you want to disable.</p>
        pub fn resource_types(mut self, input: crate::model::ResourceScanType) -> Self {
            self.inner = self.inner.resource_types(input);
            self
        }
        /// <p>The resource scan types you want to disable.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceScanType>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDelegatedAdminAccount`.
    ///
    /// <p>Disables the Amazon Inspector delegated administrator for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableDelegatedAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_delegated_admin_account_input::Builder,
    }
    impl<C, M, R> DisableDelegatedAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableDelegatedAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDelegatedAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDelegatedAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableDelegatedAdminAccountInputOperationOutputAlias,
                crate::output::DisableDelegatedAdminAccountOutput,
                crate::error::DisableDelegatedAdminAccountError,
                crate::input::DisableDelegatedAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.</p>
        pub fn delegated_admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegated_admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.</p>
        pub fn set_delegated_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegated_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMember`.
    ///
    /// <p>Disassociates a member account from an Amazon Inspector delegated administrator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_member_input::Builder,
    }
    impl<C, M, R> DisassociateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMemberInputOperationOutputAlias,
                crate::output::DisassociateMemberOutput,
                crate::error::DisassociateMemberError,
                crate::input::DisassociateMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the member account to disassociate.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account to disassociate.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Enable`.
    ///
    /// <p>Enables Amazon Inspector scans for one or more Amazon Web Services accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Enable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_input::Builder,
    }
    impl<C, M, R> Enable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Enable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableInputOperationOutputAlias,
                crate::output::EnableOutput,
                crate::error::EnableError,
                crate::input::EnableInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A list of account IDs you want to enable Amazon Inspector scans for.</p>
        pub fn account_ids(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>A list of account IDs you want to enable Amazon Inspector scans for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `resourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The resource scan types you want to enable.</p>
        pub fn resource_types(mut self, input: crate::model::ResourceScanType) -> Self {
            self.inner = self.inner.resource_types(input);
            self
        }
        /// <p>The resource scan types you want to enable.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceScanType>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDelegatedAdminAccount`.
    ///
    /// <p>Enables the Amazon Inspector delegated administrator for your Organizations organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableDelegatedAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_delegated_admin_account_input::Builder,
    }
    impl<C, M, R> EnableDelegatedAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableDelegatedAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDelegatedAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDelegatedAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableDelegatedAdminAccountInputOperationOutputAlias,
                crate::output::EnableDelegatedAdminAccountOutput,
                crate::error::EnableDelegatedAdminAccountError,
                crate::input::EnableDelegatedAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
        pub fn delegated_admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegated_admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
        pub fn set_delegated_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegated_admin_account_id(input);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDelegatedAdminAccount`.
    ///
    /// <p>Retrieves information about the Amazon Inspector delegated administrator for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDelegatedAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_delegated_admin_account_input::Builder,
    }
    impl<C, M, R> GetDelegatedAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDelegatedAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDelegatedAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDelegatedAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDelegatedAdminAccountInputOperationOutputAlias,
                crate::output::GetDelegatedAdminAccountOutput,
                crate::error::GetDelegatedAdminAccountError,
                crate::input::GetDelegatedAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetFindingsReportStatus`.
    ///
    /// <p>Gets the status of a findings report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindingsReportStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_report_status_input::Builder,
    }
    impl<C, M, R> GetFindingsReportStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingsReportStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsReportStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsReportStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsReportStatusInputOperationOutputAlias,
                crate::output::GetFindingsReportStatusOutput,
                crate::error::GetFindingsReportStatusError,
                crate::input::GetFindingsReportStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the report to retrieve the status of.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_id(input.into());
            self
        }
        /// <p>The ID of the report to retrieve the status of.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMember`.
    ///
    /// <p>Gets member information for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_member_input::Builder,
    }
    impl<C, M, R> GetMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMemberInputOperationOutputAlias,
                crate::output::GetMemberOutput,
                crate::error::GetMemberError,
                crate::input::GetMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the member account to retrieve information on.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account to retrieve information on.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountPermissions`.
    ///
    /// <p>Lists the permissions an account has to configure Amazon Inspector.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountPermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_account_permissions_input::Builder,
    }
    impl<C, M, R> ListAccountPermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountPermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountPermissionsInputOperationOutputAlias,
                crate::output::ListAccountPermissionsOutput,
                crate::error::ListAccountPermissionsError,
                crate::input::ListAccountPermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountPermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountPermissionsPaginator<C, M, R> {
            crate::paginator::ListAccountPermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The service scan type to check permissions for.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.inner = self.inner.service(input);
            self
        }
        /// <p>The service scan type to check permissions for.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoverage`.
    ///
    /// <p>Lists coverage details for you environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoverage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_coverage_input::Builder,
    }
    impl<C, M, R> ListCoverage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCoverage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoverageOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoverageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCoverageInputOperationOutputAlias,
                crate::output::ListCoverageOutput,
                crate::error::ListCoverageError,
                crate::input::ListCoverageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoveragePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoveragePaginator<C, M, R> {
            crate::paginator::ListCoveragePaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn filter_criteria(mut self, input: crate::model::CoverageFilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::CoverageFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoverageStatistics`.
    ///
    /// <p>Lists Amazon Inspector coverage statistics for your environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoverageStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_coverage_statistics_input::Builder,
    }
    impl<C, M, R> ListCoverageStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCoverageStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoverageStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoverageStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCoverageStatisticsInputOperationOutputAlias,
                crate::output::ListCoverageStatisticsOutput,
                crate::error::ListCoverageStatisticsError,
                crate::input::ListCoverageStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoverageStatisticsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoverageStatisticsPaginator<C, M, R> {
            crate::paginator::ListCoverageStatisticsPaginator::new(self.handle, self.inner)
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn filter_criteria(mut self, input: crate::model::CoverageFilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>An object that contains details on the filters to apply to the coverage data for your environment.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::CoverageFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The value to group the results by.</p>
        pub fn group_by(mut self, input: crate::model::GroupKey) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>The value to group the results by.</p>
        pub fn set_group_by(mut self, input: std::option::Option<crate::model::GroupKey>) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDelegatedAdminAccounts`.
    ///
    /// <p>Lists information about the Amazon Inspector delegated administrator of your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDelegatedAdminAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_delegated_admin_accounts_input::Builder,
    }
    impl<C, M, R> ListDelegatedAdminAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDelegatedAdminAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDelegatedAdminAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDelegatedAdminAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDelegatedAdminAccountsInputOperationOutputAlias,
                crate::output::ListDelegatedAdminAccountsOutput,
                crate::error::ListDelegatedAdminAccountsError,
                crate::input::ListDelegatedAdminAccountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDelegatedAdminAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDelegatedAdminAccountsPaginator<C, M, R> {
            crate::paginator::ListDelegatedAdminAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFilters`.
    ///
    /// <p>Lists the filters associated with your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFilters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_filters_input::Builder,
    }
    impl<C, M, R> ListFilters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFiltersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFiltersInputOperationOutputAlias,
                crate::output::ListFiltersOutput,
                crate::error::ListFiltersError,
                crate::input::ListFiltersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFiltersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFiltersPaginator<C, M, R> {
            crate::paginator::ListFiltersPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The Amazon resource number (ARN) of the filter.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(input.into());
            self
        }
        /// <p>The Amazon resource number (ARN) of the filter.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
        /// <p>The action the filter applies to matched findings.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>The action the filter applies to matched findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindingAggregations`.
    ///
    /// <p>Lists aggregated finding data for your environment based on specific criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindingAggregations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_finding_aggregations_input::Builder,
    }
    impl<C, M, R> ListFindingAggregations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindingAggregations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingAggregationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingAggregationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingAggregationsInputOperationOutputAlias,
                crate::output::ListFindingAggregationsOutput,
                crate::error::ListFindingAggregationsError,
                crate::input::ListFindingAggregationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingAggregationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingAggregationsPaginator<C, M, R> {
            crate::paginator::ListFindingAggregationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The type of the aggregation request.</p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.inner = self.inner.aggregation_type(input);
            self
        }
        /// <p>The type of the aggregation request.</p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_type(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The Amazon Web Services account IDs to retrieve finding aggregation data for.</p>
        pub fn account_ids(mut self, input: crate::model::StringFilter) -> Self {
            self.inner = self.inner.account_ids(input);
            self
        }
        /// <p>The Amazon Web Services account IDs to retrieve finding aggregation data for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p>Details of the aggregation request that is used to filter your aggregation results.</p>
        pub fn aggregation_request(mut self, input: crate::model::AggregationRequest) -> Self {
            self.inner = self.inner.aggregation_request(input);
            self
        }
        /// <p>Details of the aggregation request that is used to filter your aggregation results.</p>
        pub fn set_aggregation_request(
            mut self,
            input: std::option::Option<crate::model::AggregationRequest>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Lists findings for your environment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl<C, M, R> ListFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsInputOperationOutputAlias,
                crate::output::ListFindingsOutput,
                crate::error::ListFindingsError,
                crate::input::ListFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingsPaginator<C, M, R> {
            crate::paginator::ListFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Details on the filters to apply to your finding results.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>Details on the filters to apply to your finding results.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>Details on the sort criteria to apply to your finding results.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>Details on the sort criteria to apply to your finding results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>List members associated with the Amazon Inspector delegated administrator for your organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_members_input::Builder,
    }
    impl<C, M, R> ListMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMembersInputOperationOutputAlias,
                crate::output::ListMembersOutput,
                crate::error::ListMembersError,
                crate::input::ListMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMembersPaginator<C, M, R> {
            crate::paginator::ListMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies whether to list only currently associated members if <code>True</code> or to list all members within the organization if <code>False</code>.</p>
        pub fn only_associated(mut self, input: bool) -> Self {
            self.inner = self.inner.only_associated(input);
            self
        }
        /// <p>Specifies whether to list only currently associated members if <code>True</code> or to list all members within the organization if <code>False</code>.</p>
        pub fn set_only_associated(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_only_associated(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags attached to a given resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource number (ARN) of the resource to list tags of.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon resource number (ARN) of the resource to list tags of.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsageTotals`.
    ///
    /// <p>Lists the Amazon Inspector usage totals over the last 30 days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsageTotals<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_usage_totals_input::Builder,
    }
    impl<C, M, R> ListUsageTotals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsageTotals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsageTotalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsageTotalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsageTotalsInputOperationOutputAlias,
                crate::output::ListUsageTotalsOutput,
                crate::error::ListUsageTotalsError,
                crate::input::ListUsageTotalsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsageTotalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsageTotalsPaginator<C, M, R> {
            crate::paginator::ListUsageTotalsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The Amazon Web Services account IDs to retrieve usage totals for.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The Amazon Web Services account IDs to retrieve usage totals for.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply a tag to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to apply a tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be added to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFilter`.
    ///
    /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_filter_input::Builder,
    }
    impl<C, M, R> UpdateFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFilterInputOperationOutputAlias,
                crate::output::UpdateFilterOutput,
                crate::error::UpdateFilterError,
                crate::input::UpdateFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A description of the filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Defines the criteria to be update in the filter.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>Defines the criteria to be update in the filter.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to update.</p>
        pub fn filter_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the filter to update.</p>
        pub fn set_filter_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationConfiguration`.
    ///
    /// <p>Updates the configurations for your Amazon Inspector organization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_organization_configuration_input::Builder,
    }
    impl<C, M, R> UpdateOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOrganizationConfigurationInputOperationOutputAlias,
                crate::output::UpdateOrganizationConfigurationOutput,
                crate::error::UpdateOrganizationConfigurationError,
                crate::input::UpdateOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines which scan types are enabled automatically for new members of your Amazon Inspector organization.</p>
        pub fn auto_enable(mut self, input: crate::model::AutoEnable) -> Self {
            self.inner = self.inner.auto_enable(input);
            self
        }
        /// <p>Defines which scan types are enabled automatically for new members of your Amazon Inspector organization.</p>
        pub fn set_auto_enable(
            mut self,
            input: std::option::Option<crate::model::AutoEnable>,
        ) -> Self {
            self.inner = self.inner.set_auto_enable(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
