// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOrganizationConfigurationOutput {
    /// <p>The updated status of scan types automatically enabled for new members of your Amazon Inspector organization.</p>
    pub auto_enable: std::option::Option<crate::model::AutoEnable>,
}
impl UpdateOrganizationConfigurationOutput {
    /// <p>The updated status of scan types automatically enabled for new members of your Amazon Inspector organization.</p>
    pub fn auto_enable(&self) -> std::option::Option<&crate::model::AutoEnable> {
        self.auto_enable.as_ref()
    }
}
impl std::fmt::Debug for UpdateOrganizationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOrganizationConfigurationOutput");
        formatter.field("auto_enable", &self.auto_enable);
        formatter.finish()
    }
}
/// See [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput)
pub mod update_organization_configuration_output {
    /// A builder for [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_enable: std::option::Option<crate::model::AutoEnable>,
    }
    impl Builder {
        /// <p>The updated status of scan types automatically enabled for new members of your Amazon Inspector organization.</p>
        pub fn auto_enable(mut self, input: crate::model::AutoEnable) -> Self {
            self.auto_enable = Some(input);
            self
        }
        /// <p>The updated status of scan types automatically enabled for new members of your Amazon Inspector organization.</p>
        pub fn set_auto_enable(
            mut self,
            input: std::option::Option<crate::model::AutoEnable>,
        ) -> Self {
            self.auto_enable = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateOrganizationConfigurationOutput {
            crate::output::UpdateOrganizationConfigurationOutput {
                auto_enable: self.auto_enable,
            }
        }
    }
}
impl UpdateOrganizationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput)
    pub fn builder() -> crate::output::update_organization_configuration_output::Builder {
        crate::output::update_organization_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFilterOutput {
    /// <p>The Amazon Resource Number (ARN) of the successfully updated filter.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl UpdateFilterOutput {
    /// <p>The Amazon Resource Number (ARN) of the successfully updated filter.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFilterOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`UpdateFilterOutput`](crate::output::UpdateFilterOutput)
pub mod update_filter_output {
    /// A builder for [`UpdateFilterOutput`](crate::output::UpdateFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the successfully updated filter.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the successfully updated filter.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFilterOutput`](crate::output::UpdateFilterOutput)
        pub fn build(self) -> crate::output::UpdateFilterOutput {
            crate::output::UpdateFilterOutput { arn: self.arn }
        }
    }
}
impl UpdateFilterOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFilterOutput`](crate::output::UpdateFilterOutput)
    pub fn builder() -> crate::output::update_filter_output::Builder {
        crate::output::update_filter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsageTotalsOutput {
    /// <p>The pagination parameter to be used on the next list operation to retrieve more items.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An object with details on the total usage for the requested account.</p>
    pub totals: std::option::Option<std::vec::Vec<crate::model::UsageTotal>>,
}
impl ListUsageTotalsOutput {
    /// <p>The pagination parameter to be used on the next list operation to retrieve more items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An object with details on the total usage for the requested account.</p>
    pub fn totals(&self) -> std::option::Option<&[crate::model::UsageTotal]> {
        self.totals.as_deref()
    }
}
impl std::fmt::Debug for ListUsageTotalsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsageTotalsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("totals", &self.totals);
        formatter.finish()
    }
}
/// See [`ListUsageTotalsOutput`](crate::output::ListUsageTotalsOutput)
pub mod list_usage_totals_output {
    /// A builder for [`ListUsageTotalsOutput`](crate::output::ListUsageTotalsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) totals: std::option::Option<std::vec::Vec<crate::model::UsageTotal>>,
    }
    impl Builder {
        /// <p>The pagination parameter to be used on the next list operation to retrieve more items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination parameter to be used on the next list operation to retrieve more items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `totals`.
        ///
        /// To override the contents of this collection use [`set_totals`](Self::set_totals).
        ///
        /// <p>An object with details on the total usage for the requested account.</p>
        pub fn totals(mut self, input: impl Into<crate::model::UsageTotal>) -> Self {
            let mut v = self.totals.unwrap_or_default();
            v.push(input.into());
            self.totals = Some(v);
            self
        }
        /// <p>An object with details on the total usage for the requested account.</p>
        pub fn set_totals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageTotal>>,
        ) -> Self {
            self.totals = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsageTotalsOutput`](crate::output::ListUsageTotalsOutput)
        pub fn build(self) -> crate::output::ListUsageTotalsOutput {
            crate::output::ListUsageTotalsOutput {
                next_token: self.next_token,
                totals: self.totals,
            }
        }
    }
}
impl ListUsageTotalsOutput {
    /// Creates a new builder-style object to manufacture [`ListUsageTotalsOutput`](crate::output::ListUsageTotalsOutput)
    pub fn builder() -> crate::output::list_usage_totals_output::Builder {
        crate::output::list_usage_totals_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMembersOutput {
    /// <p>An object that contains details for each member account.</p>
    pub members: std::option::Option<std::vec::Vec<crate::model::Member>>,
    /// <p>The pagination parameter to be used on the next list operation to retrieve more
    /// items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMembersOutput {
    /// <p>An object that contains details for each member account.</p>
    pub fn members(&self) -> std::option::Option<&[crate::model::Member]> {
        self.members.as_deref()
    }
    /// <p>The pagination parameter to be used on the next list operation to retrieve more
    /// items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMembersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMembersOutput");
        formatter.field("members", &self.members);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMembersOutput`](crate::output::ListMembersOutput)
pub mod list_members_output {
    /// A builder for [`ListMembersOutput`](crate::output::ListMembersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) members: std::option::Option<std::vec::Vec<crate::model::Member>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `members`.
        ///
        /// To override the contents of this collection use [`set_members`](Self::set_members).
        ///
        /// <p>An object that contains details for each member account.</p>
        pub fn members(mut self, input: impl Into<crate::model::Member>) -> Self {
            let mut v = self.members.unwrap_or_default();
            v.push(input.into());
            self.members = Some(v);
            self
        }
        /// <p>An object that contains details for each member account.</p>
        pub fn set_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Member>>,
        ) -> Self {
            self.members = input;
            self
        }
        /// <p>The pagination parameter to be used on the next list operation to retrieve more
        /// items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination parameter to be used on the next list operation to retrieve more
        /// items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMembersOutput`](crate::output::ListMembersOutput)
        pub fn build(self) -> crate::output::ListMembersOutput {
            crate::output::ListMembersOutput {
                members: self.members,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMembersOutput {
    /// Creates a new builder-style object to manufacture [`ListMembersOutput`](crate::output::ListMembersOutput)
    pub fn builder() -> crate::output::list_members_output::Builder {
        crate::output::list_members_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsOutput {
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Contains details on the findings in your environment.</p>
    pub findings: std::option::Option<std::vec::Vec<crate::model::Finding>>,
}
impl ListFindingsOutput {
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Contains details on the findings in your environment.</p>
    pub fn findings(&self) -> std::option::Option<&[crate::model::Finding]> {
        self.findings.as_deref()
    }
}
impl std::fmt::Debug for ListFindingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("findings", &self.findings);
        formatter.finish()
    }
}
/// See [`ListFindingsOutput`](crate::output::ListFindingsOutput)
pub mod list_findings_output {
    /// A builder for [`ListFindingsOutput`](crate::output::ListFindingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) findings: std::option::Option<std::vec::Vec<crate::model::Finding>>,
    }
    impl Builder {
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `findings`.
        ///
        /// To override the contents of this collection use [`set_findings`](Self::set_findings).
        ///
        /// <p>Contains details on the findings in your environment.</p>
        pub fn findings(mut self, input: impl Into<crate::model::Finding>) -> Self {
            let mut v = self.findings.unwrap_or_default();
            v.push(input.into());
            self.findings = Some(v);
            self
        }
        /// <p>Contains details on the findings in your environment.</p>
        pub fn set_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Finding>>,
        ) -> Self {
            self.findings = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsOutput`](crate::output::ListFindingsOutput)
        pub fn build(self) -> crate::output::ListFindingsOutput {
            crate::output::ListFindingsOutput {
                next_token: self.next_token,
                findings: self.findings,
            }
        }
    }
}
impl ListFindingsOutput {
    /// Creates a new builder-style object to manufacture [`ListFindingsOutput`](crate::output::ListFindingsOutput)
    pub fn builder() -> crate::output::list_findings_output::Builder {
        crate::output::list_findings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingAggregationsOutput {
    /// <p>The type of aggregation to perform.</p>
    pub aggregation_type: std::option::Option<crate::model::AggregationType>,
    /// <p>Objects that contain the results of an aggregation operation.</p>
    pub responses: std::option::Option<std::vec::Vec<crate::model::AggregationResponse>>,
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFindingAggregationsOutput {
    /// <p>The type of aggregation to perform.</p>
    pub fn aggregation_type(&self) -> std::option::Option<&crate::model::AggregationType> {
        self.aggregation_type.as_ref()
    }
    /// <p>Objects that contain the results of an aggregation operation.</p>
    pub fn responses(&self) -> std::option::Option<&[crate::model::AggregationResponse]> {
        self.responses.as_deref()
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFindingAggregationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingAggregationsOutput");
        formatter.field("aggregation_type", &self.aggregation_type);
        formatter.field("responses", &self.responses);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFindingAggregationsOutput`](crate::output::ListFindingAggregationsOutput)
pub mod list_finding_aggregations_output {
    /// A builder for [`ListFindingAggregationsOutput`](crate::output::ListFindingAggregationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aggregation_type: std::option::Option<crate::model::AggregationType>,
        pub(crate) responses: std::option::Option<std::vec::Vec<crate::model::AggregationResponse>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of aggregation to perform.</p>
        pub fn aggregation_type(mut self, input: crate::model::AggregationType) -> Self {
            self.aggregation_type = Some(input);
            self
        }
        /// <p>The type of aggregation to perform.</p>
        pub fn set_aggregation_type(
            mut self,
            input: std::option::Option<crate::model::AggregationType>,
        ) -> Self {
            self.aggregation_type = input;
            self
        }
        /// Appends an item to `responses`.
        ///
        /// To override the contents of this collection use [`set_responses`](Self::set_responses).
        ///
        /// <p>Objects that contain the results of an aggregation operation.</p>
        pub fn responses(mut self, input: impl Into<crate::model::AggregationResponse>) -> Self {
            let mut v = self.responses.unwrap_or_default();
            v.push(input.into());
            self.responses = Some(v);
            self
        }
        /// <p>Objects that contain the results of an aggregation operation.</p>
        pub fn set_responses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregationResponse>>,
        ) -> Self {
            self.responses = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingAggregationsOutput`](crate::output::ListFindingAggregationsOutput)
        pub fn build(self) -> crate::output::ListFindingAggregationsOutput {
            crate::output::ListFindingAggregationsOutput {
                aggregation_type: self.aggregation_type,
                responses: self.responses,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFindingAggregationsOutput {
    /// Creates a new builder-style object to manufacture [`ListFindingAggregationsOutput`](crate::output::ListFindingAggregationsOutput)
    pub fn builder() -> crate::output::list_finding_aggregations_output::Builder {
        crate::output::list_finding_aggregations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFiltersOutput {
    /// <p>Contains details on the filters associated with your account.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFiltersOutput {
    /// <p>Contains details on the filters associated with your account.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFiltersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFiltersOutput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFiltersOutput`](crate::output::ListFiltersOutput)
pub mod list_filters_output {
    /// A builder for [`ListFiltersOutput`](crate::output::ListFiltersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Contains details on the filters associated with your account.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Contains details on the filters associated with your account.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFiltersOutput`](crate::output::ListFiltersOutput)
        pub fn build(self) -> crate::output::ListFiltersOutput {
            crate::output::ListFiltersOutput {
                filters: self.filters,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFiltersOutput {
    /// Creates a new builder-style object to manufacture [`ListFiltersOutput`](crate::output::ListFiltersOutput)
    pub fn builder() -> crate::output::list_filters_output::Builder {
        crate::output::list_filters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDelegatedAdminAccountsOutput {
    /// <p>Details of the Amazon Inspector delegated administrator of your organization.</p>
    pub delegated_admin_accounts:
        std::option::Option<std::vec::Vec<crate::model::DelegatedAdminAccount>>,
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDelegatedAdminAccountsOutput {
    /// <p>Details of the Amazon Inspector delegated administrator of your organization.</p>
    pub fn delegated_admin_accounts(
        &self,
    ) -> std::option::Option<&[crate::model::DelegatedAdminAccount]> {
        self.delegated_admin_accounts.as_deref()
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDelegatedAdminAccountsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDelegatedAdminAccountsOutput");
        formatter.field("delegated_admin_accounts", &self.delegated_admin_accounts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDelegatedAdminAccountsOutput`](crate::output::ListDelegatedAdminAccountsOutput)
pub mod list_delegated_admin_accounts_output {
    /// A builder for [`ListDelegatedAdminAccountsOutput`](crate::output::ListDelegatedAdminAccountsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegated_admin_accounts:
            std::option::Option<std::vec::Vec<crate::model::DelegatedAdminAccount>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `delegated_admin_accounts`.
        ///
        /// To override the contents of this collection use [`set_delegated_admin_accounts`](Self::set_delegated_admin_accounts).
        ///
        /// <p>Details of the Amazon Inspector delegated administrator of your organization.</p>
        pub fn delegated_admin_accounts(
            mut self,
            input: impl Into<crate::model::DelegatedAdminAccount>,
        ) -> Self {
            let mut v = self.delegated_admin_accounts.unwrap_or_default();
            v.push(input.into());
            self.delegated_admin_accounts = Some(v);
            self
        }
        /// <p>Details of the Amazon Inspector delegated administrator of your organization.</p>
        pub fn set_delegated_admin_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DelegatedAdminAccount>>,
        ) -> Self {
            self.delegated_admin_accounts = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDelegatedAdminAccountsOutput`](crate::output::ListDelegatedAdminAccountsOutput)
        pub fn build(self) -> crate::output::ListDelegatedAdminAccountsOutput {
            crate::output::ListDelegatedAdminAccountsOutput {
                delegated_admin_accounts: self.delegated_admin_accounts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDelegatedAdminAccountsOutput {
    /// Creates a new builder-style object to manufacture [`ListDelegatedAdminAccountsOutput`](crate::output::ListDelegatedAdminAccountsOutput)
    pub fn builder() -> crate::output::list_delegated_admin_accounts_output::Builder {
        crate::output::list_delegated_admin_accounts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoverageStatisticsOutput {
    /// <p>An array with the number for each group.</p>
    pub counts_by_group: std::option::Option<std::vec::Vec<crate::model::Counts>>,
    /// <p>The total number for all groups.</p>
    pub total_counts: std::option::Option<i64>,
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCoverageStatisticsOutput {
    /// <p>An array with the number for each group.</p>
    pub fn counts_by_group(&self) -> std::option::Option<&[crate::model::Counts]> {
        self.counts_by_group.as_deref()
    }
    /// <p>The total number for all groups.</p>
    pub fn total_counts(&self) -> std::option::Option<i64> {
        self.total_counts
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCoverageStatisticsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoverageStatisticsOutput");
        formatter.field("counts_by_group", &self.counts_by_group);
        formatter.field("total_counts", &self.total_counts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCoverageStatisticsOutput`](crate::output::ListCoverageStatisticsOutput)
pub mod list_coverage_statistics_output {
    /// A builder for [`ListCoverageStatisticsOutput`](crate::output::ListCoverageStatisticsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) counts_by_group: std::option::Option<std::vec::Vec<crate::model::Counts>>,
        pub(crate) total_counts: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `counts_by_group`.
        ///
        /// To override the contents of this collection use [`set_counts_by_group`](Self::set_counts_by_group).
        ///
        /// <p>An array with the number for each group.</p>
        pub fn counts_by_group(mut self, input: impl Into<crate::model::Counts>) -> Self {
            let mut v = self.counts_by_group.unwrap_or_default();
            v.push(input.into());
            self.counts_by_group = Some(v);
            self
        }
        /// <p>An array with the number for each group.</p>
        pub fn set_counts_by_group(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Counts>>,
        ) -> Self {
            self.counts_by_group = input;
            self
        }
        /// <p>The total number for all groups.</p>
        pub fn total_counts(mut self, input: i64) -> Self {
            self.total_counts = Some(input);
            self
        }
        /// <p>The total number for all groups.</p>
        pub fn set_total_counts(mut self, input: std::option::Option<i64>) -> Self {
            self.total_counts = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoverageStatisticsOutput`](crate::output::ListCoverageStatisticsOutput)
        pub fn build(self) -> crate::output::ListCoverageStatisticsOutput {
            crate::output::ListCoverageStatisticsOutput {
                counts_by_group: self.counts_by_group,
                total_counts: self.total_counts,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCoverageStatisticsOutput {
    /// Creates a new builder-style object to manufacture [`ListCoverageStatisticsOutput`](crate::output::ListCoverageStatisticsOutput)
    pub fn builder() -> crate::output::list_coverage_statistics_output::Builder {
        crate::output::list_coverage_statistics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoverageOutput {
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An object that contains details on the covered resources in your environment.</p>
    pub covered_resources: std::option::Option<std::vec::Vec<crate::model::CoveredResource>>,
}
impl ListCoverageOutput {
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An object that contains details on the covered resources in your environment.</p>
    pub fn covered_resources(&self) -> std::option::Option<&[crate::model::CoveredResource]> {
        self.covered_resources.as_deref()
    }
}
impl std::fmt::Debug for ListCoverageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoverageOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("covered_resources", &self.covered_resources);
        formatter.finish()
    }
}
/// See [`ListCoverageOutput`](crate::output::ListCoverageOutput)
pub mod list_coverage_output {
    /// A builder for [`ListCoverageOutput`](crate::output::ListCoverageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) covered_resources:
            std::option::Option<std::vec::Vec<crate::model::CoveredResource>>,
    }
    impl Builder {
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `covered_resources`.
        ///
        /// To override the contents of this collection use [`set_covered_resources`](Self::set_covered_resources).
        ///
        /// <p>An object that contains details on the covered resources in your environment.</p>
        pub fn covered_resources(
            mut self,
            input: impl Into<crate::model::CoveredResource>,
        ) -> Self {
            let mut v = self.covered_resources.unwrap_or_default();
            v.push(input.into());
            self.covered_resources = Some(v);
            self
        }
        /// <p>An object that contains details on the covered resources in your environment.</p>
        pub fn set_covered_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoveredResource>>,
        ) -> Self {
            self.covered_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoverageOutput`](crate::output::ListCoverageOutput)
        pub fn build(self) -> crate::output::ListCoverageOutput {
            crate::output::ListCoverageOutput {
                next_token: self.next_token,
                covered_resources: self.covered_resources,
            }
        }
    }
}
impl ListCoverageOutput {
    /// Creates a new builder-style object to manufacture [`ListCoverageOutput`](crate::output::ListCoverageOutput)
    pub fn builder() -> crate::output::list_coverage_output::Builder {
        crate::output::list_coverage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountPermissionsOutput {
    /// <p>Contains details on the permissions an account has to configure Amazon Inspector.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountPermissionsOutput {
    /// <p>Contains details on the permissions an account has to configure Amazon Inspector.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::Permission]> {
        self.permissions.as_deref()
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value
    /// of this parameter to null for the first request to a list action. For subsequent calls, use
    /// the <code>NextToken</code> value returned from the previous request to continue listing
    /// results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountPermissionsOutput");
        formatter.field("permissions", &self.permissions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccountPermissionsOutput`](crate::output::ListAccountPermissionsOutput)
pub mod list_account_permissions_output {
    /// A builder for [`ListAccountPermissionsOutput`](crate::output::ListAccountPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Contains details on the permissions an account has to configure Amazon Inspector.</p>
        pub fn permissions(mut self, input: impl Into<crate::model::Permission>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>Contains details on the permissions an account has to configure Amazon Inspector.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value
        /// of this parameter to null for the first request to a list action. For subsequent calls, use
        /// the <code>NextToken</code> value returned from the previous request to continue listing
        /// results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountPermissionsOutput`](crate::output::ListAccountPermissionsOutput)
        pub fn build(self) -> crate::output::ListAccountPermissionsOutput {
            crate::output::ListAccountPermissionsOutput {
                permissions: self.permissions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccountPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccountPermissionsOutput`](crate::output::ListAccountPermissionsOutput)
    pub fn builder() -> crate::output::list_account_permissions_output::Builder {
        crate::output::list_account_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMemberOutput {
    /// <p>Details of the retrieved member account.</p>
    pub member: std::option::Option<crate::model::Member>,
}
impl GetMemberOutput {
    /// <p>Details of the retrieved member account.</p>
    pub fn member(&self) -> std::option::Option<&crate::model::Member> {
        self.member.as_ref()
    }
}
impl std::fmt::Debug for GetMemberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMemberOutput");
        formatter.field("member", &self.member);
        formatter.finish()
    }
}
/// See [`GetMemberOutput`](crate::output::GetMemberOutput)
pub mod get_member_output {
    /// A builder for [`GetMemberOutput`](crate::output::GetMemberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member: std::option::Option<crate::model::Member>,
    }
    impl Builder {
        /// <p>Details of the retrieved member account.</p>
        pub fn member(mut self, input: crate::model::Member) -> Self {
            self.member = Some(input);
            self
        }
        /// <p>Details of the retrieved member account.</p>
        pub fn set_member(mut self, input: std::option::Option<crate::model::Member>) -> Self {
            self.member = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMemberOutput`](crate::output::GetMemberOutput)
        pub fn build(self) -> crate::output::GetMemberOutput {
            crate::output::GetMemberOutput {
                member: self.member,
            }
        }
    }
}
impl GetMemberOutput {
    /// Creates a new builder-style object to manufacture [`GetMemberOutput`](crate::output::GetMemberOutput)
    pub fn builder() -> crate::output::get_member_output::Builder {
        crate::output::get_member_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsReportStatusOutput {
    /// <p>The ID of the report.</p>
    pub report_id: std::option::Option<std::string::String>,
    /// <p>The status of the report.</p>
    pub status: std::option::Option<crate::model::ExternalReportStatus>,
    /// <p>The error code of the report.</p>
    pub error_code: std::option::Option<crate::model::ReportingErrorCode>,
    /// <p>The error message of the report.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The destination of the report.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>The filter criteria associated with the report.</p>
    pub filter_criteria: std::option::Option<crate::model::FilterCriteria>,
}
impl GetFindingsReportStatusOutput {
    /// <p>The ID of the report.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
    /// <p>The status of the report.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExternalReportStatus> {
        self.status.as_ref()
    }
    /// <p>The error code of the report.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ReportingErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message of the report.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The destination of the report.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>The filter criteria associated with the report.</p>
    pub fn filter_criteria(&self) -> std::option::Option<&crate::model::FilterCriteria> {
        self.filter_criteria.as_ref()
    }
}
impl std::fmt::Debug for GetFindingsReportStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsReportStatusOutput");
        formatter.field("report_id", &self.report_id);
        formatter.field("status", &self.status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("destination", &self.destination);
        formatter.field("filter_criteria", &self.filter_criteria);
        formatter.finish()
    }
}
/// See [`GetFindingsReportStatusOutput`](crate::output::GetFindingsReportStatusOutput)
pub mod get_findings_report_status_output {
    /// A builder for [`GetFindingsReportStatusOutput`](crate::output::GetFindingsReportStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ExternalReportStatus>,
        pub(crate) error_code: std::option::Option<crate::model::ReportingErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) filter_criteria: std::option::Option<crate::model::FilterCriteria>,
    }
    impl Builder {
        /// <p>The ID of the report.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>The ID of the report.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// <p>The status of the report.</p>
        pub fn status(mut self, input: crate::model::ExternalReportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the report.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExternalReportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The error code of the report.</p>
        pub fn error_code(mut self, input: crate::model::ReportingErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code of the report.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ReportingErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message of the report.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message of the report.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The destination of the report.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination of the report.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The filter criteria associated with the report.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.filter_criteria = Some(input);
            self
        }
        /// <p>The filter criteria associated with the report.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.filter_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsReportStatusOutput`](crate::output::GetFindingsReportStatusOutput)
        pub fn build(self) -> crate::output::GetFindingsReportStatusOutput {
            crate::output::GetFindingsReportStatusOutput {
                report_id: self.report_id,
                status: self.status,
                error_code: self.error_code,
                error_message: self.error_message,
                destination: self.destination,
                filter_criteria: self.filter_criteria,
            }
        }
    }
}
impl GetFindingsReportStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetFindingsReportStatusOutput`](crate::output::GetFindingsReportStatusOutput)
    pub fn builder() -> crate::output::get_findings_report_status_output::Builder {
        crate::output::get_findings_report_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDelegatedAdminAccountOutput {
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
    pub delegated_admin: std::option::Option<crate::model::DelegatedAdmin>,
}
impl GetDelegatedAdminAccountOutput {
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
    pub fn delegated_admin(&self) -> std::option::Option<&crate::model::DelegatedAdmin> {
        self.delegated_admin.as_ref()
    }
}
impl std::fmt::Debug for GetDelegatedAdminAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDelegatedAdminAccountOutput");
        formatter.field("delegated_admin", &self.delegated_admin);
        formatter.finish()
    }
}
/// See [`GetDelegatedAdminAccountOutput`](crate::output::GetDelegatedAdminAccountOutput)
pub mod get_delegated_admin_account_output {
    /// A builder for [`GetDelegatedAdminAccountOutput`](crate::output::GetDelegatedAdminAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegated_admin: std::option::Option<crate::model::DelegatedAdmin>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
        pub fn delegated_admin(mut self, input: crate::model::DelegatedAdmin) -> Self {
            self.delegated_admin = Some(input);
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator.</p>
        pub fn set_delegated_admin(
            mut self,
            input: std::option::Option<crate::model::DelegatedAdmin>,
        ) -> Self {
            self.delegated_admin = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDelegatedAdminAccountOutput`](crate::output::GetDelegatedAdminAccountOutput)
        pub fn build(self) -> crate::output::GetDelegatedAdminAccountOutput {
            crate::output::GetDelegatedAdminAccountOutput {
                delegated_admin: self.delegated_admin,
            }
        }
    }
}
impl GetDelegatedAdminAccountOutput {
    /// Creates a new builder-style object to manufacture [`GetDelegatedAdminAccountOutput`](crate::output::GetDelegatedAdminAccountOutput)
    pub fn builder() -> crate::output::get_delegated_admin_account_output::Builder {
        crate::output::get_delegated_admin_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableDelegatedAdminAccountOutput {
    /// <p>The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.</p>
    pub delegated_admin_account_id: std::option::Option<std::string::String>,
}
impl EnableDelegatedAdminAccountOutput {
    /// <p>The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.</p>
    pub fn delegated_admin_account_id(&self) -> std::option::Option<&str> {
        self.delegated_admin_account_id.as_deref()
    }
}
impl std::fmt::Debug for EnableDelegatedAdminAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableDelegatedAdminAccountOutput");
        formatter.field(
            "delegated_admin_account_id",
            &self.delegated_admin_account_id,
        );
        formatter.finish()
    }
}
/// See [`EnableDelegatedAdminAccountOutput`](crate::output::EnableDelegatedAdminAccountOutput)
pub mod enable_delegated_admin_account_output {
    /// A builder for [`EnableDelegatedAdminAccountOutput`](crate::output::EnableDelegatedAdminAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegated_admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.</p>
        pub fn delegated_admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegated_admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the successfully Amazon Inspector delegated administrator.</p>
        pub fn set_delegated_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegated_admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableDelegatedAdminAccountOutput`](crate::output::EnableDelegatedAdminAccountOutput)
        pub fn build(self) -> crate::output::EnableDelegatedAdminAccountOutput {
            crate::output::EnableDelegatedAdminAccountOutput {
                delegated_admin_account_id: self.delegated_admin_account_id,
            }
        }
    }
}
impl EnableDelegatedAdminAccountOutput {
    /// Creates a new builder-style object to manufacture [`EnableDelegatedAdminAccountOutput`](crate::output::EnableDelegatedAdminAccountOutput)
    pub fn builder() -> crate::output::enable_delegated_admin_account_output::Builder {
        crate::output::enable_delegated_admin_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableOutput {
    /// <p>Information on the accounts that have had Amazon Inspector scans successfully enabled. Details are
    /// provided for each account.</p>
    pub accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
    /// <p>Information on any accounts for which Amazon Inspector scans could not be enabled. Details are
    /// provided for each account.</p>
    pub failed_accounts: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
}
impl EnableOutput {
    /// <p>Information on the accounts that have had Amazon Inspector scans successfully enabled. Details are
    /// provided for each account.</p>
    pub fn accounts(&self) -> std::option::Option<&[crate::model::Account]> {
        self.accounts.as_deref()
    }
    /// <p>Information on any accounts for which Amazon Inspector scans could not be enabled. Details are
    /// provided for each account.</p>
    pub fn failed_accounts(&self) -> std::option::Option<&[crate::model::FailedAccount]> {
        self.failed_accounts.as_deref()
    }
}
impl std::fmt::Debug for EnableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableOutput");
        formatter.field("accounts", &self.accounts);
        formatter.field("failed_accounts", &self.failed_accounts);
        formatter.finish()
    }
}
/// See [`EnableOutput`](crate::output::EnableOutput)
pub mod enable_output {
    /// A builder for [`EnableOutput`](crate::output::EnableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
        pub(crate) failed_accounts: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>Information on the accounts that have had Amazon Inspector scans successfully enabled. Details are
        /// provided for each account.</p>
        pub fn accounts(mut self, input: impl Into<crate::model::Account>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>Information on the accounts that have had Amazon Inspector scans successfully enabled. Details are
        /// provided for each account.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Account>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// Appends an item to `failed_accounts`.
        ///
        /// To override the contents of this collection use [`set_failed_accounts`](Self::set_failed_accounts).
        ///
        /// <p>Information on any accounts for which Amazon Inspector scans could not be enabled. Details are
        /// provided for each account.</p>
        pub fn failed_accounts(mut self, input: impl Into<crate::model::FailedAccount>) -> Self {
            let mut v = self.failed_accounts.unwrap_or_default();
            v.push(input.into());
            self.failed_accounts = Some(v);
            self
        }
        /// <p>Information on any accounts for which Amazon Inspector scans could not be enabled. Details are
        /// provided for each account.</p>
        pub fn set_failed_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
        ) -> Self {
            self.failed_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableOutput`](crate::output::EnableOutput)
        pub fn build(self) -> crate::output::EnableOutput {
            crate::output::EnableOutput {
                accounts: self.accounts,
                failed_accounts: self.failed_accounts,
            }
        }
    }
}
impl EnableOutput {
    /// Creates a new builder-style object to manufacture [`EnableOutput`](crate::output::EnableOutput)
    pub fn builder() -> crate::output::enable_output::Builder {
        crate::output::enable_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMemberOutput {
    /// <p>The Amazon Web Services account ID of the successfully disassociated member.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DisassociateMemberOutput {
    /// <p>The Amazon Web Services account ID of the successfully disassociated member.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateMemberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMemberOutput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`DisassociateMemberOutput`](crate::output::DisassociateMemberOutput)
pub mod disassociate_member_output {
    /// A builder for [`DisassociateMemberOutput`](crate::output::DisassociateMemberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the successfully disassociated member.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the successfully disassociated member.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMemberOutput`](crate::output::DisassociateMemberOutput)
        pub fn build(self) -> crate::output::DisassociateMemberOutput {
            crate::output::DisassociateMemberOutput {
                account_id: self.account_id,
            }
        }
    }
}
impl DisassociateMemberOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateMemberOutput`](crate::output::DisassociateMemberOutput)
    pub fn builder() -> crate::output::disassociate_member_output::Builder {
        crate::output::disassociate_member_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableDelegatedAdminAccountOutput {
    /// <p>The Amazon Web Services account ID of the successfully disabled delegated administrator.</p>
    pub delegated_admin_account_id: std::option::Option<std::string::String>,
}
impl DisableDelegatedAdminAccountOutput {
    /// <p>The Amazon Web Services account ID of the successfully disabled delegated administrator.</p>
    pub fn delegated_admin_account_id(&self) -> std::option::Option<&str> {
        self.delegated_admin_account_id.as_deref()
    }
}
impl std::fmt::Debug for DisableDelegatedAdminAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableDelegatedAdminAccountOutput");
        formatter.field(
            "delegated_admin_account_id",
            &self.delegated_admin_account_id,
        );
        formatter.finish()
    }
}
/// See [`DisableDelegatedAdminAccountOutput`](crate::output::DisableDelegatedAdminAccountOutput)
pub mod disable_delegated_admin_account_output {
    /// A builder for [`DisableDelegatedAdminAccountOutput`](crate::output::DisableDelegatedAdminAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegated_admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the successfully disabled delegated administrator.</p>
        pub fn delegated_admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegated_admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the successfully disabled delegated administrator.</p>
        pub fn set_delegated_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegated_admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableDelegatedAdminAccountOutput`](crate::output::DisableDelegatedAdminAccountOutput)
        pub fn build(self) -> crate::output::DisableDelegatedAdminAccountOutput {
            crate::output::DisableDelegatedAdminAccountOutput {
                delegated_admin_account_id: self.delegated_admin_account_id,
            }
        }
    }
}
impl DisableDelegatedAdminAccountOutput {
    /// Creates a new builder-style object to manufacture [`DisableDelegatedAdminAccountOutput`](crate::output::DisableDelegatedAdminAccountOutput)
    pub fn builder() -> crate::output::disable_delegated_admin_account_output::Builder {
        crate::output::disable_delegated_admin_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableOutput {
    /// <p>Information on the accounts that have had Amazon Inspector scans successfully disabled. Details are
    /// provided for each account.</p>
    pub accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
    /// <p>Information on any accounts for which Amazon Inspector scans could not be disabled. Details are
    /// provided for each account.</p>
    pub failed_accounts: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
}
impl DisableOutput {
    /// <p>Information on the accounts that have had Amazon Inspector scans successfully disabled. Details are
    /// provided for each account.</p>
    pub fn accounts(&self) -> std::option::Option<&[crate::model::Account]> {
        self.accounts.as_deref()
    }
    /// <p>Information on any accounts for which Amazon Inspector scans could not be disabled. Details are
    /// provided for each account.</p>
    pub fn failed_accounts(&self) -> std::option::Option<&[crate::model::FailedAccount]> {
        self.failed_accounts.as_deref()
    }
}
impl std::fmt::Debug for DisableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableOutput");
        formatter.field("accounts", &self.accounts);
        formatter.field("failed_accounts", &self.failed_accounts);
        formatter.finish()
    }
}
/// See [`DisableOutput`](crate::output::DisableOutput)
pub mod disable_output {
    /// A builder for [`DisableOutput`](crate::output::DisableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<crate::model::Account>>,
        pub(crate) failed_accounts: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>Information on the accounts that have had Amazon Inspector scans successfully disabled. Details are
        /// provided for each account.</p>
        pub fn accounts(mut self, input: impl Into<crate::model::Account>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>Information on the accounts that have had Amazon Inspector scans successfully disabled. Details are
        /// provided for each account.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Account>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// Appends an item to `failed_accounts`.
        ///
        /// To override the contents of this collection use [`set_failed_accounts`](Self::set_failed_accounts).
        ///
        /// <p>Information on any accounts for which Amazon Inspector scans could not be disabled. Details are
        /// provided for each account.</p>
        pub fn failed_accounts(mut self, input: impl Into<crate::model::FailedAccount>) -> Self {
            let mut v = self.failed_accounts.unwrap_or_default();
            v.push(input.into());
            self.failed_accounts = Some(v);
            self
        }
        /// <p>Information on any accounts for which Amazon Inspector scans could not be disabled. Details are
        /// provided for each account.</p>
        pub fn set_failed_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
        ) -> Self {
            self.failed_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableOutput`](crate::output::DisableOutput)
        pub fn build(self) -> crate::output::DisableOutput {
            crate::output::DisableOutput {
                accounts: self.accounts,
                failed_accounts: self.failed_accounts,
            }
        }
    }
}
impl DisableOutput {
    /// Creates a new builder-style object to manufacture [`DisableOutput`](crate::output::DisableOutput)
    pub fn builder() -> crate::output::disable_output::Builder {
        crate::output::disable_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConfigurationOutput {
    /// <p>The scan types are automatically enabled for new members of your organization.</p>
    pub auto_enable: std::option::Option<crate::model::AutoEnable>,
    /// <p>Represents whether your organization has reached the maximum Amazon Web Services account limit for Amazon Inspector.</p>
    pub max_account_limit_reached: std::option::Option<bool>,
}
impl DescribeOrganizationConfigurationOutput {
    /// <p>The scan types are automatically enabled for new members of your organization.</p>
    pub fn auto_enable(&self) -> std::option::Option<&crate::model::AutoEnable> {
        self.auto_enable.as_ref()
    }
    /// <p>Represents whether your organization has reached the maximum Amazon Web Services account limit for Amazon Inspector.</p>
    pub fn max_account_limit_reached(&self) -> std::option::Option<bool> {
        self.max_account_limit_reached
    }
}
impl std::fmt::Debug for DescribeOrganizationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConfigurationOutput");
        formatter.field("auto_enable", &self.auto_enable);
        formatter.field("max_account_limit_reached", &self.max_account_limit_reached);
        formatter.finish()
    }
}
/// See [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput)
pub mod describe_organization_configuration_output {
    /// A builder for [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_enable: std::option::Option<crate::model::AutoEnable>,
        pub(crate) max_account_limit_reached: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The scan types are automatically enabled for new members of your organization.</p>
        pub fn auto_enable(mut self, input: crate::model::AutoEnable) -> Self {
            self.auto_enable = Some(input);
            self
        }
        /// <p>The scan types are automatically enabled for new members of your organization.</p>
        pub fn set_auto_enable(
            mut self,
            input: std::option::Option<crate::model::AutoEnable>,
        ) -> Self {
            self.auto_enable = input;
            self
        }
        /// <p>Represents whether your organization has reached the maximum Amazon Web Services account limit for Amazon Inspector.</p>
        pub fn max_account_limit_reached(mut self, input: bool) -> Self {
            self.max_account_limit_reached = Some(input);
            self
        }
        /// <p>Represents whether your organization has reached the maximum Amazon Web Services account limit for Amazon Inspector.</p>
        pub fn set_max_account_limit_reached(mut self, input: std::option::Option<bool>) -> Self {
            self.max_account_limit_reached = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeOrganizationConfigurationOutput {
            crate::output::DescribeOrganizationConfigurationOutput {
                auto_enable: self.auto_enable,
                max_account_limit_reached: self.max_account_limit_reached,
            }
        }
    }
}
impl DescribeOrganizationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput)
    pub fn builder() -> crate::output::describe_organization_configuration_output::Builder {
        crate::output::describe_organization_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFilterOutput {
    /// <p>The Amazon Resource Number (ARN) of the filter that has been deleted.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteFilterOutput {
    /// <p>The Amazon Resource Number (ARN) of the filter that has been deleted.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFilterOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
pub mod delete_filter_output {
    /// A builder for [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the filter that has been deleted.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the filter that has been deleted.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
        pub fn build(self) -> crate::output::DeleteFilterOutput {
            crate::output::DeleteFilterOutput { arn: self.arn }
        }
    }
}
impl DeleteFilterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFilterOutput`](crate::output::DeleteFilterOutput)
    pub fn builder() -> crate::output::delete_filter_output::Builder {
        crate::output::delete_filter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFindingsReportOutput {
    /// <p>The ID of the report.</p>
    pub report_id: std::option::Option<std::string::String>,
}
impl CreateFindingsReportOutput {
    /// <p>The ID of the report.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
}
impl std::fmt::Debug for CreateFindingsReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFindingsReportOutput");
        formatter.field("report_id", &self.report_id);
        formatter.finish()
    }
}
/// See [`CreateFindingsReportOutput`](crate::output::CreateFindingsReportOutput)
pub mod create_findings_report_output {
    /// A builder for [`CreateFindingsReportOutput`](crate::output::CreateFindingsReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the report.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>The ID of the report.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFindingsReportOutput`](crate::output::CreateFindingsReportOutput)
        pub fn build(self) -> crate::output::CreateFindingsReportOutput {
            crate::output::CreateFindingsReportOutput {
                report_id: self.report_id,
            }
        }
    }
}
impl CreateFindingsReportOutput {
    /// Creates a new builder-style object to manufacture [`CreateFindingsReportOutput`](crate::output::CreateFindingsReportOutput)
    pub fn builder() -> crate::output::create_findings_report_output::Builder {
        crate::output::create_findings_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFilterOutput {
    /// <p>The Amazon Resource Number (ARN) of the successfully created filter.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl CreateFilterOutput {
    /// <p>The Amazon Resource Number (ARN) of the successfully created filter.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for CreateFilterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFilterOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CreateFilterOutput`](crate::output::CreateFilterOutput)
pub mod create_filter_output {
    /// A builder for [`CreateFilterOutput`](crate::output::CreateFilterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the successfully created filter.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the successfully created filter.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFilterOutput`](crate::output::CreateFilterOutput)
        pub fn build(self) -> crate::output::CreateFilterOutput {
            crate::output::CreateFilterOutput { arn: self.arn }
        }
    }
}
impl CreateFilterOutput {
    /// Creates a new builder-style object to manufacture [`CreateFilterOutput`](crate::output::CreateFilterOutput)
    pub fn builder() -> crate::output::create_filter_output::Builder {
        crate::output::create_filter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelFindingsReportOutput {
    /// <p>The ID of the canceled report.</p>
    pub report_id: std::option::Option<std::string::String>,
}
impl CancelFindingsReportOutput {
    /// <p>The ID of the canceled report.</p>
    pub fn report_id(&self) -> std::option::Option<&str> {
        self.report_id.as_deref()
    }
}
impl std::fmt::Debug for CancelFindingsReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelFindingsReportOutput");
        formatter.field("report_id", &self.report_id);
        formatter.finish()
    }
}
/// See [`CancelFindingsReportOutput`](crate::output::CancelFindingsReportOutput)
pub mod cancel_findings_report_output {
    /// A builder for [`CancelFindingsReportOutput`](crate::output::CancelFindingsReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the canceled report.</p>
        pub fn report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_id = Some(input.into());
            self
        }
        /// <p>The ID of the canceled report.</p>
        pub fn set_report_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelFindingsReportOutput`](crate::output::CancelFindingsReportOutput)
        pub fn build(self) -> crate::output::CancelFindingsReportOutput {
            crate::output::CancelFindingsReportOutput {
                report_id: self.report_id,
            }
        }
    }
}
impl CancelFindingsReportOutput {
    /// Creates a new builder-style object to manufacture [`CancelFindingsReportOutput`](crate::output::CancelFindingsReportOutput)
    pub fn builder() -> crate::output::cancel_findings_report_output::Builder {
        crate::output::cancel_findings_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetFreeTrialInfoOutput {
    /// <p>An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
    /// </p>
    pub accounts: std::option::Option<std::vec::Vec<crate::model::FreeTrialAccountInfo>>,
    /// <p>An array of objects detailing any accounts that free trial data could not be returned for.</p>
    pub failed_accounts: std::option::Option<std::vec::Vec<crate::model::FreeTrialInfoError>>,
}
impl BatchGetFreeTrialInfoOutput {
    /// <p>An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
    /// </p>
    pub fn accounts(&self) -> std::option::Option<&[crate::model::FreeTrialAccountInfo]> {
        self.accounts.as_deref()
    }
    /// <p>An array of objects detailing any accounts that free trial data could not be returned for.</p>
    pub fn failed_accounts(&self) -> std::option::Option<&[crate::model::FreeTrialInfoError]> {
        self.failed_accounts.as_deref()
    }
}
impl std::fmt::Debug for BatchGetFreeTrialInfoOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetFreeTrialInfoOutput");
        formatter.field("accounts", &self.accounts);
        formatter.field("failed_accounts", &self.failed_accounts);
        formatter.finish()
    }
}
/// See [`BatchGetFreeTrialInfoOutput`](crate::output::BatchGetFreeTrialInfoOutput)
pub mod batch_get_free_trial_info_output {
    /// A builder for [`BatchGetFreeTrialInfoOutput`](crate::output::BatchGetFreeTrialInfoOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<crate::model::FreeTrialAccountInfo>>,
        pub(crate) failed_accounts:
            std::option::Option<std::vec::Vec<crate::model::FreeTrialInfoError>>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
        /// </p>
        pub fn accounts(mut self, input: impl Into<crate::model::FreeTrialAccountInfo>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
        /// </p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FreeTrialAccountInfo>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// Appends an item to `failed_accounts`.
        ///
        /// To override the contents of this collection use [`set_failed_accounts`](Self::set_failed_accounts).
        ///
        /// <p>An array of objects detailing any accounts that free trial data could not be returned for.</p>
        pub fn failed_accounts(
            mut self,
            input: impl Into<crate::model::FreeTrialInfoError>,
        ) -> Self {
            let mut v = self.failed_accounts.unwrap_or_default();
            v.push(input.into());
            self.failed_accounts = Some(v);
            self
        }
        /// <p>An array of objects detailing any accounts that free trial data could not be returned for.</p>
        pub fn set_failed_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FreeTrialInfoError>>,
        ) -> Self {
            self.failed_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetFreeTrialInfoOutput`](crate::output::BatchGetFreeTrialInfoOutput)
        pub fn build(self) -> crate::output::BatchGetFreeTrialInfoOutput {
            crate::output::BatchGetFreeTrialInfoOutput {
                accounts: self.accounts,
                failed_accounts: self.failed_accounts,
            }
        }
    }
}
impl BatchGetFreeTrialInfoOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetFreeTrialInfoOutput`](crate::output::BatchGetFreeTrialInfoOutput)
    pub fn builder() -> crate::output::batch_get_free_trial_info_output::Builder {
        crate::output::batch_get_free_trial_info_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetAccountStatusOutput {
    /// <p>An array of objects that provide details on the status of Amazon Inspector for each of the requested accounts.</p>
    pub accounts: std::option::Option<std::vec::Vec<crate::model::AccountState>>,
    /// <p>An array of objects detailing any accounts that failed to enable Amazon Inspector and why.</p>
    pub failed_accounts: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
}
impl BatchGetAccountStatusOutput {
    /// <p>An array of objects that provide details on the status of Amazon Inspector for each of the requested accounts.</p>
    pub fn accounts(&self) -> std::option::Option<&[crate::model::AccountState]> {
        self.accounts.as_deref()
    }
    /// <p>An array of objects detailing any accounts that failed to enable Amazon Inspector and why.</p>
    pub fn failed_accounts(&self) -> std::option::Option<&[crate::model::FailedAccount]> {
        self.failed_accounts.as_deref()
    }
}
impl std::fmt::Debug for BatchGetAccountStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetAccountStatusOutput");
        formatter.field("accounts", &self.accounts);
        formatter.field("failed_accounts", &self.failed_accounts);
        formatter.finish()
    }
}
/// See [`BatchGetAccountStatusOutput`](crate::output::BatchGetAccountStatusOutput)
pub mod batch_get_account_status_output {
    /// A builder for [`BatchGetAccountStatusOutput`](crate::output::BatchGetAccountStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<crate::model::AccountState>>,
        pub(crate) failed_accounts: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>An array of objects that provide details on the status of Amazon Inspector for each of the requested accounts.</p>
        pub fn accounts(mut self, input: impl Into<crate::model::AccountState>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>An array of objects that provide details on the status of Amazon Inspector for each of the requested accounts.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountState>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// Appends an item to `failed_accounts`.
        ///
        /// To override the contents of this collection use [`set_failed_accounts`](Self::set_failed_accounts).
        ///
        /// <p>An array of objects detailing any accounts that failed to enable Amazon Inspector and why.</p>
        pub fn failed_accounts(mut self, input: impl Into<crate::model::FailedAccount>) -> Self {
            let mut v = self.failed_accounts.unwrap_or_default();
            v.push(input.into());
            self.failed_accounts = Some(v);
            self
        }
        /// <p>An array of objects detailing any accounts that failed to enable Amazon Inspector and why.</p>
        pub fn set_failed_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedAccount>>,
        ) -> Self {
            self.failed_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetAccountStatusOutput`](crate::output::BatchGetAccountStatusOutput)
        pub fn build(self) -> crate::output::BatchGetAccountStatusOutput {
            crate::output::BatchGetAccountStatusOutput {
                accounts: self.accounts,
                failed_accounts: self.failed_accounts,
            }
        }
    }
}
impl BatchGetAccountStatusOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetAccountStatusOutput`](crate::output::BatchGetAccountStatusOutput)
    pub fn builder() -> crate::output::batch_get_account_status_output::Builder {
        crate::output::batch_get_account_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateMemberOutput {
    /// <p>The Amazon Web Services account ID of the successfully associated member account.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl AssociateMemberOutput {
    /// <p>The Amazon Web Services account ID of the successfully associated member account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateMemberOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateMemberOutput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`AssociateMemberOutput`](crate::output::AssociateMemberOutput)
pub mod associate_member_output {
    /// A builder for [`AssociateMemberOutput`](crate::output::AssociateMemberOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the successfully associated member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the successfully associated member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateMemberOutput`](crate::output::AssociateMemberOutput)
        pub fn build(self) -> crate::output::AssociateMemberOutput {
            crate::output::AssociateMemberOutput {
                account_id: self.account_id,
            }
        }
    }
}
impl AssociateMemberOutput {
    /// Creates a new builder-style object to manufacture [`AssociateMemberOutput`](crate::output::AssociateMemberOutput)
    pub fn builder() -> crate::output::associate_member_output::Builder {
        crate::output::associate_member_output::Builder::default()
    }
}
