// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateMemberError {
    /// Kind of error that occurred.
    pub kind: AssociateMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateMemberErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateMemberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateMemberError {
    fn code(&self) -> Option<&str> {
        AssociateMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            AssociateMemberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl AssociateMemberError {
    /// Creates a new `AssociateMemberError`.
    pub fn new(kind: AssociateMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateMemberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AssociateMemberErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `AssociateMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AssociateMemberErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AssociateMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateMemberErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateMemberErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetAccountStatusError {
    /// Kind of error that occurred.
    pub kind: BatchGetAccountStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetAccountStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetAccountStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetAccountStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchGetAccountStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchGetAccountStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchGetAccountStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchGetAccountStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetAccountStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetAccountStatusError {
    fn code(&self) -> Option<&str> {
        BatchGetAccountStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            BatchGetAccountStatusErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl BatchGetAccountStatusError {
    /// Creates a new `BatchGetAccountStatusError`.
    pub fn new(kind: BatchGetAccountStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetAccountStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetAccountStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetAccountStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetAccountStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetAccountStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetAccountStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetAccountStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetAccountStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetAccountStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetAccountStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetAccountStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetAccountStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetAccountStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetAccountStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetAccountStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetAccountStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchGetAccountStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetAccountStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchGetAccountStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchGetAccountStatusErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetAccountStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetFreeTrialInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetFreeTrialInfoError {
    /// Kind of error that occurred.
    pub kind: BatchGetFreeTrialInfoErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetFreeTrialInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetFreeTrialInfoErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetFreeTrialInfoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetFreeTrialInfoErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchGetFreeTrialInfoErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchGetFreeTrialInfoErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchGetFreeTrialInfoErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetFreeTrialInfoErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetFreeTrialInfoError {
    fn code(&self) -> Option<&str> {
        BatchGetFreeTrialInfoError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            BatchGetFreeTrialInfoErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl BatchGetFreeTrialInfoError {
    /// Creates a new `BatchGetFreeTrialInfoError`.
    pub fn new(kind: BatchGetFreeTrialInfoErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetFreeTrialInfoError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetFreeTrialInfoErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetFreeTrialInfoError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetFreeTrialInfoErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetFreeTrialInfoErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFreeTrialInfoErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetFreeTrialInfoErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFreeTrialInfoErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetFreeTrialInfoErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFreeTrialInfoErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetFreeTrialInfoErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetFreeTrialInfoErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetFreeTrialInfoError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetFreeTrialInfoErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchGetFreeTrialInfoErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetFreeTrialInfoErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchGetFreeTrialInfoErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetFreeTrialInfoErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelFindingsReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelFindingsReportError {
    /// Kind of error that occurred.
    pub kind: CancelFindingsReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelFindingsReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelFindingsReportErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelFindingsReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelFindingsReportErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelFindingsReportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelFindingsReportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelFindingsReportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelFindingsReportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelFindingsReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelFindingsReportError {
    fn code(&self) -> Option<&str> {
        CancelFindingsReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CancelFindingsReportErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CancelFindingsReportError {
    /// Creates a new `CancelFindingsReportError`.
    pub fn new(kind: CancelFindingsReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelFindingsReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelFindingsReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelFindingsReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelFindingsReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelFindingsReportErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelFindingsReportErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelFindingsReportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelFindingsReportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelFindingsReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelFindingsReportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelFindingsReportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelFindingsReportErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelFindingsReportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelFindingsReportErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelFindingsReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelFindingsReportErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelFindingsReportErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelFindingsReportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelFindingsReportErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelFindingsReportErrorKind::ValidationException(_inner) => Some(_inner),
            CancelFindingsReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFilterError {
    /// Kind of error that occurred.
    pub kind: CreateFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFilterErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>One or more tags submitted as part of the request is not valid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have exceeded your service quota. To perform the requested action, remove some of
    /// the relevant resources, or use Service Quotas to request a service quota increase.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFilterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFilterError {
    fn code(&self) -> Option<&str> {
        CreateFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateFilterErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateFilterError {
    /// Creates a new `CreateFilterError`.
    pub fn new(kind: CreateFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFilterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFilterErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFilterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFilterErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateFilterErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateFilterErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateFilterErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFilterErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFindingsReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFindingsReportError {
    /// Kind of error that occurred.
    pub kind: CreateFindingsReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFindingsReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFindingsReportErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFindingsReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFindingsReportErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFindingsReportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateFindingsReportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFindingsReportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFindingsReportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFindingsReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFindingsReportError {
    fn code(&self) -> Option<&str> {
        CreateFindingsReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateFindingsReportErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateFindingsReportError {
    /// Creates a new `CreateFindingsReportError`.
    pub fn new(kind: CreateFindingsReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFindingsReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFindingsReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFindingsReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFindingsReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFindingsReportErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsReportErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsReportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsReportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsReportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsReportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsReportErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsReportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsReportErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateFindingsReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFindingsReportErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFindingsReportErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateFindingsReportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFindingsReportErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFindingsReportErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFindingsReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFilterError {
    /// Kind of error that occurred.
    pub kind: DeleteFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFilterErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFilterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFilterError {
    fn code(&self) -> Option<&str> {
        DeleteFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteFilterErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteFilterError {
    /// Creates a new `DeleteFilterError`.
    pub fn new(kind: DeleteFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteFilterErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFilterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteFilterErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteFilterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFilterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFilterErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFilterErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFilterErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeOrganizationConfigurationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeOrganizationConfigurationError {
    /// Creates a new `DescribeOrganizationConfigurationError`.
    pub fn new(
        kind: DescribeOrganizationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeOrganizationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeOrganizationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Disable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableError {
    /// Kind of error that occurred.
    pub kind: DisableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Disable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisableErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableError {
    fn code(&self) -> Option<&str> {
        DisableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DisableErrorKind::InternalServerException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl DisableError {
    /// Creates a new `DisableError`.
    pub fn new(kind: DisableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DisableErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DisableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DisableErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DisableErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, DisableErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DisableErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DisableErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DisableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DisableErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DisableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableErrorKind::InternalServerException(_inner) => Some(_inner),
            DisableErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisableErrorKind::ValidationException(_inner) => Some(_inner),
            DisableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableDelegatedAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableDelegatedAdminAccountError {
    /// Kind of error that occurred.
    pub kind: DisableDelegatedAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableDelegatedAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableDelegatedAdminAccountErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableDelegatedAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableDelegatedAdminAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableDelegatedAdminAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisableDelegatedAdminAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisableDelegatedAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisableDelegatedAdminAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisableDelegatedAdminAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisableDelegatedAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableDelegatedAdminAccountError {
    fn code(&self) -> Option<&str> {
        DisableDelegatedAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DisableDelegatedAdminAccountErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DisableDelegatedAdminAccountError {
    /// Creates a new `DisableDelegatedAdminAccountError`.
    pub fn new(kind: DisableDelegatedAdminAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableDelegatedAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableDelegatedAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableDelegatedAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableDelegatedAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableDelegatedAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDelegatedAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDelegatedAdminAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDelegatedAdminAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDelegatedAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDelegatedAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDelegatedAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDelegatedAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDelegatedAdminAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDelegatedAdminAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDelegatedAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableDelegatedAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisableDelegatedAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableDelegatedAdminAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableDelegatedAdminAccountErrorKind::ConflictException(_inner) => Some(_inner),
            DisableDelegatedAdminAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            DisableDelegatedAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisableDelegatedAdminAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisableDelegatedAdminAccountErrorKind::ValidationException(_inner) => Some(_inner),
            DisableDelegatedAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateMemberError {
    /// Kind of error that occurred.
    pub kind: DisassociateMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateMemberErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateMemberError {
    fn code(&self) -> Option<&str> {
        DisassociateMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DisassociateMemberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DisassociateMemberError {
    /// Creates a new `DisassociateMemberError`.
    pub fn new(kind: DisassociateMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Enable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableError {
    /// Kind of error that occurred.
    pub kind: EnableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Enable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            EnableErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            EnableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EnableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableError {
    fn code(&self) -> Option<&str> {
        EnableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            EnableErrorKind::InternalServerException(inner) => Some(inner.retryable_error_kind()),
            _ => None,
        }
    }
}
impl EnableError {
    /// Creates a new `EnableError`.
    pub fn new(kind: EnableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, EnableErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `EnableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, EnableErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `EnableErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, EnableErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `EnableErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, EnableErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `EnableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, EnableErrorKind::ValidationException(_))
    }
}
impl std::error::Error for EnableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableErrorKind::InternalServerException(_inner) => Some(_inner),
            EnableErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableErrorKind::ThrottlingException(_inner) => Some(_inner),
            EnableErrorKind::ValidationException(_inner) => Some(_inner),
            EnableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableDelegatedAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableDelegatedAdminAccountError {
    /// Kind of error that occurred.
    pub kind: EnableDelegatedAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableDelegatedAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableDelegatedAdminAccountErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A conflict occurred.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableDelegatedAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableDelegatedAdminAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableDelegatedAdminAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            EnableDelegatedAdminAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            EnableDelegatedAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            EnableDelegatedAdminAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            EnableDelegatedAdminAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EnableDelegatedAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableDelegatedAdminAccountError {
    fn code(&self) -> Option<&str> {
        EnableDelegatedAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            EnableDelegatedAdminAccountErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl EnableDelegatedAdminAccountError {
    /// Creates a new `EnableDelegatedAdminAccountError`.
    pub fn new(kind: EnableDelegatedAdminAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableDelegatedAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableDelegatedAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableDelegatedAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableDelegatedAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableDelegatedAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDelegatedAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDelegatedAdminAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDelegatedAdminAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDelegatedAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDelegatedAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDelegatedAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDelegatedAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDelegatedAdminAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDelegatedAdminAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDelegatedAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableDelegatedAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for EnableDelegatedAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableDelegatedAdminAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableDelegatedAdminAccountErrorKind::ConflictException(_inner) => Some(_inner),
            EnableDelegatedAdminAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            EnableDelegatedAdminAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableDelegatedAdminAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            EnableDelegatedAdminAccountErrorKind::ValidationException(_inner) => Some(_inner),
            EnableDelegatedAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDelegatedAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDelegatedAdminAccountError {
    /// Kind of error that occurred.
    pub kind: GetDelegatedAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDelegatedAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDelegatedAdminAccountErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDelegatedAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDelegatedAdminAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDelegatedAdminAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDelegatedAdminAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDelegatedAdminAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDelegatedAdminAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDelegatedAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDelegatedAdminAccountError {
    fn code(&self) -> Option<&str> {
        GetDelegatedAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetDelegatedAdminAccountErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetDelegatedAdminAccountError {
    /// Creates a new `GetDelegatedAdminAccountError`.
    pub fn new(kind: GetDelegatedAdminAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDelegatedAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDelegatedAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDelegatedAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDelegatedAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDelegatedAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDelegatedAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDelegatedAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDelegatedAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDelegatedAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDelegatedAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDelegatedAdminAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDelegatedAdminAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDelegatedAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDelegatedAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetDelegatedAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDelegatedAdminAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDelegatedAdminAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDelegatedAdminAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDelegatedAdminAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDelegatedAdminAccountErrorKind::ValidationException(_inner) => Some(_inner),
            GetDelegatedAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFindingsReportStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingsReportStatusError {
    /// Kind of error that occurred.
    pub kind: GetFindingsReportStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindingsReportStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingsReportStatusErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingsReportStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingsReportStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFindingsReportStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetFindingsReportStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFindingsReportStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetFindingsReportStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFindingsReportStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingsReportStatusError {
    fn code(&self) -> Option<&str> {
        GetFindingsReportStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetFindingsReportStatusErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetFindingsReportStatusError {
    /// Creates a new `GetFindingsReportStatusError`.
    pub fn new(kind: GetFindingsReportStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingsReportStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingsReportStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingsReportStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingsReportStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingsReportStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsReportStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsReportStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsReportStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsReportStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsReportStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetFindingsReportStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingsReportStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFindingsReportStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            GetFindingsReportStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFindingsReportStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetFindingsReportStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetFindingsReportStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMemberError {
    /// Kind of error that occurred.
    pub kind: GetMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMemberErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMemberError {
    fn code(&self) -> Option<&str> {
        GetMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            GetMemberErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl GetMemberError {
    /// Creates a new `GetMemberError`.
    pub fn new(kind: GetMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMemberErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMemberErrorKind::ValidationException(_inner) => Some(_inner),
            GetMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountPermissionsError {
    /// Kind of error that occurred.
    pub kind: ListAccountPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountPermissionsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountPermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAccountPermissionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAccountPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAccountPermissionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAccountPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountPermissionsError {
    fn code(&self) -> Option<&str> {
        ListAccountPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListAccountPermissionsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListAccountPermissionsError {
    /// Creates a new `ListAccountPermissionsError`.
    pub fn new(kind: ListAccountPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountPermissionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountPermissionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountPermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountPermissionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountPermissionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAccountPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountPermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAccountPermissionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAccountPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAccountPermissionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAccountPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCoverage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCoverageError {
    /// Kind of error that occurred.
    pub kind: ListCoverageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCoverage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCoverageErrorKind {
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCoverageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCoverageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCoverageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCoverageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCoverageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCoverageError {
    fn code(&self) -> Option<&str> {
        ListCoverageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListCoverageErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListCoverageError {
    /// Creates a new `ListCoverageError`.
    pub fn new(kind: ListCoverageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCoverageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCoverageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCoverageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCoverageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCoverageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoverageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoverageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListCoverageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListCoverageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListCoverageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListCoverageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCoverageErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCoverageErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCoverageErrorKind::ValidationException(_inner) => Some(_inner),
            ListCoverageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCoverageStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCoverageStatisticsError {
    /// Kind of error that occurred.
    pub kind: ListCoverageStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCoverageStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCoverageStatisticsErrorKind {
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCoverageStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCoverageStatisticsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCoverageStatisticsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCoverageStatisticsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCoverageStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCoverageStatisticsError {
    fn code(&self) -> Option<&str> {
        ListCoverageStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListCoverageStatisticsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListCoverageStatisticsError {
    /// Creates a new `ListCoverageStatisticsError`.
    pub fn new(kind: ListCoverageStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCoverageStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCoverageStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCoverageStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCoverageStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCoverageStatisticsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoverageStatisticsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoverageStatisticsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoverageStatisticsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoverageStatisticsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoverageStatisticsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListCoverageStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCoverageStatisticsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCoverageStatisticsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCoverageStatisticsErrorKind::ValidationException(_inner) => Some(_inner),
            ListCoverageStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDelegatedAdminAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDelegatedAdminAccountsError {
    /// Kind of error that occurred.
    pub kind: ListDelegatedAdminAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDelegatedAdminAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDelegatedAdminAccountsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDelegatedAdminAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDelegatedAdminAccountsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDelegatedAdminAccountsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDelegatedAdminAccountsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDelegatedAdminAccountsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDelegatedAdminAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDelegatedAdminAccountsError {
    fn code(&self) -> Option<&str> {
        ListDelegatedAdminAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListDelegatedAdminAccountsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListDelegatedAdminAccountsError {
    /// Creates a new `ListDelegatedAdminAccountsError`.
    pub fn new(kind: ListDelegatedAdminAccountsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDelegatedAdminAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDelegatedAdminAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDelegatedAdminAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDelegatedAdminAccountsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDelegatedAdminAccountsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdminAccountsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdminAccountsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdminAccountsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdminAccountsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdminAccountsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDelegatedAdminAccountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDelegatedAdminAccountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDelegatedAdminAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDelegatedAdminAccountsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDelegatedAdminAccountsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDelegatedAdminAccountsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDelegatedAdminAccountsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDelegatedAdminAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFiltersError {
    /// Kind of error that occurred.
    pub kind: ListFiltersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFiltersErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFiltersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFiltersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFiltersError {
    fn code(&self) -> Option<&str> {
        ListFiltersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListFiltersErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListFiltersError {
    /// Creates a new `ListFiltersError`.
    pub fn new(kind: ListFiltersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFiltersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFiltersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFiltersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFiltersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListFiltersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListFiltersErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFiltersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFiltersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFiltersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFiltersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFiltersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFiltersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFiltersErrorKind::ValidationException(_inner) => Some(_inner),
            ListFiltersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFindingAggregations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFindingAggregationsError {
    /// Kind of error that occurred.
    pub kind: ListFindingAggregationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFindingAggregations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFindingAggregationsErrorKind {
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFindingAggregationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFindingAggregationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFindingAggregationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFindingAggregationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFindingAggregationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFindingAggregationsError {
    fn code(&self) -> Option<&str> {
        ListFindingAggregationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListFindingAggregationsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListFindingAggregationsError {
    /// Creates a new `ListFindingAggregationsError`.
    pub fn new(kind: ListFindingAggregationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFindingAggregationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFindingAggregationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFindingAggregationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFindingAggregationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFindingAggregationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingAggregationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingAggregationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingAggregationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingAggregationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingAggregationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFindingAggregationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFindingAggregationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFindingAggregationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFindingAggregationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFindingAggregationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFindingsError {
    /// Kind of error that occurred.
    pub kind: ListFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFindingsErrorKind {
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFindingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFindingsError {
    fn code(&self) -> Option<&str> {
        ListFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListFindingsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListFindingsError {
    /// Creates a new `ListFindingsError`.
    pub fn new(kind: ListFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFindingsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFindingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFindingsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMembersError {
    /// Kind of error that occurred.
    pub kind: ListMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMembersErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMembersError {
    fn code(&self) -> Option<&str> {
        ListMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListMembersErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListMembersError {
    /// Creates a new `ListMembersError`.
    pub fn new(kind: ListMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMembersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMembersErrorKind::ValidationException(_inner) => Some(_inner),
            ListMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsageTotals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsageTotalsError {
    /// Kind of error that occurred.
    pub kind: ListUsageTotalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsageTotals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsageTotalsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsageTotalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsageTotalsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListUsageTotalsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListUsageTotalsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUsageTotalsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListUsageTotalsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsageTotalsError {
    fn code(&self) -> Option<&str> {
        ListUsageTotalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListUsageTotalsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListUsageTotalsError {
    /// Creates a new `ListUsageTotalsError`.
    pub fn new(kind: ListUsageTotalsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsageTotalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsageTotalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsageTotalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsageTotalsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsageTotalsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageTotalsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsageTotalsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageTotalsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsageTotalsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListUsageTotalsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListUsageTotalsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListUsageTotalsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListUsageTotalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsageTotalsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListUsageTotalsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListUsageTotalsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUsageTotalsErrorKind::ValidationException(_inner) => Some(_inner),
            ListUsageTotalsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>One or more tags submitted as part of the request is not valid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFilterError {
    /// Kind of error that occurred.
    pub kind: UpdateFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFilterErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFilterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateFilterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFilterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFilterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFilterError {
    fn code(&self) -> Option<&str> {
        UpdateFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateFilterErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateFilterError {
    /// Creates a new `UpdateFilterError`.
    pub fn new(kind: UpdateFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFilterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateFilterErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateFilterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFilterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFilterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateFilterErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateFilterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateFilterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFilterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateFilterErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFilterErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFilterErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOrganizationConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateOrganizationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOrganizationConfigurationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request has failed validation due to missing required fields or having invalid
    /// inputs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOrganizationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateOrganizationConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateOrganizationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOrganizationConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateOrganizationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateOrganizationConfigurationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateOrganizationConfigurationError {
    /// Creates a new `UpdateOrganizationConfigurationError`.
    pub fn new(
        kind: UpdateOrganizationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOrganizationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOrganizationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOrganizationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOrganizationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateOrganizationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request has failed validation due to missing required fields or having invalid
/// inputs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the validation failure.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The fields that failed validation.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason for the validation failure.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The fields that failed validation.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the validation failure.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the validation failure.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>The fields that failed validation.</p>
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>The fields that failed validation.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The limit on the number of requests per second was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The request has failed due to an internal failure of the Amazon Inspector service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The number of seconds to wait before retrying the request.</p>
    pub retry_after_seconds: std::option::Option<i32>,
}
impl InternalServerException {
    /// <p>The number of seconds to wait before retrying the request.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The number of seconds to wait before retrying the request.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The number of seconds to wait before retrying the request.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The operation tried to access an invalid resource. Make sure the resource is specified correctly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>One or more tags submitted as part of the request is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>A conflict occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the conflicting resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the conflicting resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The ID of the conflicting resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the conflicting resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the conflicting resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the conflicting resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the conflicting resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the conflicting resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You have exceeded your service quota. To perform the requested action, remove some of
/// the relevant resources, or use Service Quotas to request a service quota increase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that exceeds a service quota.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The ID of the resource that exceeds a service quota.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that exceeds a service quota.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that exceeds a service quota.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
