// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_member`](crate::client::Client::associate_member).
///
/// See [`crate::client::fluent_builders::AssociateMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateMember {
    _private: (),
}
impl AssociateMember {
    /// Creates a new builder-style object to manufacture [`AssociateMemberInput`](crate::input::AssociateMemberInput)
    pub fn builder() -> crate::input::associate_member_input::Builder {
        crate::input::associate_member_input::Builder::default()
    }
    /// Creates a new `AssociateMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateMember {
    type Output = std::result::Result<
        crate::output::AssociateMemberOutput,
        crate::error::AssociateMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_member_error(response)
        } else {
            crate::operation_deser::parse_associate_member_response(response)
        }
    }
}

/// Operation shape for `BatchGetAccountStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_account_status`](crate::client::Client::batch_get_account_status).
///
/// See [`crate::client::fluent_builders::BatchGetAccountStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetAccountStatus {
    _private: (),
}
impl BatchGetAccountStatus {
    /// Creates a new builder-style object to manufacture [`BatchGetAccountStatusInput`](crate::input::BatchGetAccountStatusInput)
    pub fn builder() -> crate::input::batch_get_account_status_input::Builder {
        crate::input::batch_get_account_status_input::Builder::default()
    }
    /// Creates a new `BatchGetAccountStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetAccountStatus {
    type Output = std::result::Result<
        crate::output::BatchGetAccountStatusOutput,
        crate::error::BatchGetAccountStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_account_status_error(response)
        } else {
            crate::operation_deser::parse_batch_get_account_status_response(response)
        }
    }
}

/// Operation shape for `BatchGetFreeTrialInfo`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_free_trial_info`](crate::client::Client::batch_get_free_trial_info).
///
/// See [`crate::client::fluent_builders::BatchGetFreeTrialInfo`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetFreeTrialInfo {
    _private: (),
}
impl BatchGetFreeTrialInfo {
    /// Creates a new builder-style object to manufacture [`BatchGetFreeTrialInfoInput`](crate::input::BatchGetFreeTrialInfoInput)
    pub fn builder() -> crate::input::batch_get_free_trial_info_input::Builder {
        crate::input::batch_get_free_trial_info_input::Builder::default()
    }
    /// Creates a new `BatchGetFreeTrialInfo` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetFreeTrialInfo {
    type Output = std::result::Result<
        crate::output::BatchGetFreeTrialInfoOutput,
        crate::error::BatchGetFreeTrialInfoError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_free_trial_info_error(response)
        } else {
            crate::operation_deser::parse_batch_get_free_trial_info_response(response)
        }
    }
}

/// Operation shape for `CancelFindingsReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_findings_report`](crate::client::Client::cancel_findings_report).
///
/// See [`crate::client::fluent_builders::CancelFindingsReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelFindingsReport {
    _private: (),
}
impl CancelFindingsReport {
    /// Creates a new builder-style object to manufacture [`CancelFindingsReportInput`](crate::input::CancelFindingsReportInput)
    pub fn builder() -> crate::input::cancel_findings_report_input::Builder {
        crate::input::cancel_findings_report_input::Builder::default()
    }
    /// Creates a new `CancelFindingsReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelFindingsReport {
    type Output = std::result::Result<
        crate::output::CancelFindingsReportOutput,
        crate::error::CancelFindingsReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_findings_report_error(response)
        } else {
            crate::operation_deser::parse_cancel_findings_report_response(response)
        }
    }
}

/// Operation shape for `CreateFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_filter`](crate::client::Client::create_filter).
///
/// See [`crate::client::fluent_builders::CreateFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFilter {
    _private: (),
}
impl CreateFilter {
    /// Creates a new builder-style object to manufacture [`CreateFilterInput`](crate::input::CreateFilterInput)
    pub fn builder() -> crate::input::create_filter_input::Builder {
        crate::input::create_filter_input::Builder::default()
    }
    /// Creates a new `CreateFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFilter {
    type Output =
        std::result::Result<crate::output::CreateFilterOutput, crate::error::CreateFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_filter_error(response)
        } else {
            crate::operation_deser::parse_create_filter_response(response)
        }
    }
}

/// Operation shape for `CreateFindingsReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_findings_report`](crate::client::Client::create_findings_report).
///
/// See [`crate::client::fluent_builders::CreateFindingsReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFindingsReport {
    _private: (),
}
impl CreateFindingsReport {
    /// Creates a new builder-style object to manufacture [`CreateFindingsReportInput`](crate::input::CreateFindingsReportInput)
    pub fn builder() -> crate::input::create_findings_report_input::Builder {
        crate::input::create_findings_report_input::Builder::default()
    }
    /// Creates a new `CreateFindingsReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFindingsReport {
    type Output = std::result::Result<
        crate::output::CreateFindingsReportOutput,
        crate::error::CreateFindingsReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_findings_report_error(response)
        } else {
            crate::operation_deser::parse_create_findings_report_response(response)
        }
    }
}

/// Operation shape for `DeleteFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_filter`](crate::client::Client::delete_filter).
///
/// See [`crate::client::fluent_builders::DeleteFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFilter {
    _private: (),
}
impl DeleteFilter {
    /// Creates a new builder-style object to manufacture [`DeleteFilterInput`](crate::input::DeleteFilterInput)
    pub fn builder() -> crate::input::delete_filter_input::Builder {
        crate::input::delete_filter_input::Builder::default()
    }
    /// Creates a new `DeleteFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFilter {
    type Output =
        std::result::Result<crate::output::DeleteFilterOutput, crate::error::DeleteFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_filter_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_configuration`](crate::client::Client::describe_organization_configuration).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConfiguration {
    _private: (),
}
impl DescribeOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConfigurationOutput,
        crate::error::DescribeOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_configuration_response(response)
        }
    }
}

/// Operation shape for `Disable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable`](crate::client::Client::disable).
///
/// See [`crate::client::fluent_builders::Disable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Disable {
    _private: (),
}
impl Disable {
    /// Creates a new builder-style object to manufacture [`DisableInput`](crate::input::DisableInput)
    pub fn builder() -> crate::input::disable_input::Builder {
        crate::input::disable_input::Builder::default()
    }
    /// Creates a new `Disable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Disable {
    type Output = std::result::Result<crate::output::DisableOutput, crate::error::DisableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_error(response)
        } else {
            crate::operation_deser::parse_disable_response(response)
        }
    }
}

/// Operation shape for `DisableDelegatedAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_delegated_admin_account`](crate::client::Client::disable_delegated_admin_account).
///
/// See [`crate::client::fluent_builders::DisableDelegatedAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableDelegatedAdminAccount {
    _private: (),
}
impl DisableDelegatedAdminAccount {
    /// Creates a new builder-style object to manufacture [`DisableDelegatedAdminAccountInput`](crate::input::DisableDelegatedAdminAccountInput)
    pub fn builder() -> crate::input::disable_delegated_admin_account_input::Builder {
        crate::input::disable_delegated_admin_account_input::Builder::default()
    }
    /// Creates a new `DisableDelegatedAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableDelegatedAdminAccount {
    type Output = std::result::Result<
        crate::output::DisableDelegatedAdminAccountOutput,
        crate::error::DisableDelegatedAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_delegated_admin_account_error(response)
        } else {
            crate::operation_deser::parse_disable_delegated_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_member`](crate::client::Client::disassociate_member).
///
/// See [`crate::client::fluent_builders::DisassociateMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateMember {
    _private: (),
}
impl DisassociateMember {
    /// Creates a new builder-style object to manufacture [`DisassociateMemberInput`](crate::input::DisassociateMemberInput)
    pub fn builder() -> crate::input::disassociate_member_input::Builder {
        crate::input::disassociate_member_input::Builder::default()
    }
    /// Creates a new `DisassociateMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateMember {
    type Output = std::result::Result<
        crate::output::DisassociateMemberOutput,
        crate::error::DisassociateMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_member_error(response)
        } else {
            crate::operation_deser::parse_disassociate_member_response(response)
        }
    }
}

/// Operation shape for `Enable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable`](crate::client::Client::enable).
///
/// See [`crate::client::fluent_builders::Enable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Enable {
    _private: (),
}
impl Enable {
    /// Creates a new builder-style object to manufacture [`EnableInput`](crate::input::EnableInput)
    pub fn builder() -> crate::input::enable_input::Builder {
        crate::input::enable_input::Builder::default()
    }
    /// Creates a new `Enable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Enable {
    type Output = std::result::Result<crate::output::EnableOutput, crate::error::EnableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_error(response)
        } else {
            crate::operation_deser::parse_enable_response(response)
        }
    }
}

/// Operation shape for `EnableDelegatedAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_delegated_admin_account`](crate::client::Client::enable_delegated_admin_account).
///
/// See [`crate::client::fluent_builders::EnableDelegatedAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableDelegatedAdminAccount {
    _private: (),
}
impl EnableDelegatedAdminAccount {
    /// Creates a new builder-style object to manufacture [`EnableDelegatedAdminAccountInput`](crate::input::EnableDelegatedAdminAccountInput)
    pub fn builder() -> crate::input::enable_delegated_admin_account_input::Builder {
        crate::input::enable_delegated_admin_account_input::Builder::default()
    }
    /// Creates a new `EnableDelegatedAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableDelegatedAdminAccount {
    type Output = std::result::Result<
        crate::output::EnableDelegatedAdminAccountOutput,
        crate::error::EnableDelegatedAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_delegated_admin_account_error(response)
        } else {
            crate::operation_deser::parse_enable_delegated_admin_account_response(response)
        }
    }
}

/// Operation shape for `GetDelegatedAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_delegated_admin_account`](crate::client::Client::get_delegated_admin_account).
///
/// See [`crate::client::fluent_builders::GetDelegatedAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDelegatedAdminAccount {
    _private: (),
}
impl GetDelegatedAdminAccount {
    /// Creates a new builder-style object to manufacture [`GetDelegatedAdminAccountInput`](crate::input::GetDelegatedAdminAccountInput)
    pub fn builder() -> crate::input::get_delegated_admin_account_input::Builder {
        crate::input::get_delegated_admin_account_input::Builder::default()
    }
    /// Creates a new `GetDelegatedAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDelegatedAdminAccount {
    type Output = std::result::Result<
        crate::output::GetDelegatedAdminAccountOutput,
        crate::error::GetDelegatedAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_delegated_admin_account_error(response)
        } else {
            crate::operation_deser::parse_get_delegated_admin_account_response(response)
        }
    }
}

/// Operation shape for `GetFindingsReportStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings_report_status`](crate::client::Client::get_findings_report_status).
///
/// See [`crate::client::fluent_builders::GetFindingsReportStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindingsReportStatus {
    _private: (),
}
impl GetFindingsReportStatus {
    /// Creates a new builder-style object to manufacture [`GetFindingsReportStatusInput`](crate::input::GetFindingsReportStatusInput)
    pub fn builder() -> crate::input::get_findings_report_status_input::Builder {
        crate::input::get_findings_report_status_input::Builder::default()
    }
    /// Creates a new `GetFindingsReportStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindingsReportStatus {
    type Output = std::result::Result<
        crate::output::GetFindingsReportStatusOutput,
        crate::error::GetFindingsReportStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_report_status_error(response)
        } else {
            crate::operation_deser::parse_get_findings_report_status_response(response)
        }
    }
}

/// Operation shape for `GetMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_member`](crate::client::Client::get_member).
///
/// See [`crate::client::fluent_builders::GetMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMember {
    _private: (),
}
impl GetMember {
    /// Creates a new builder-style object to manufacture [`GetMemberInput`](crate::input::GetMemberInput)
    pub fn builder() -> crate::input::get_member_input::Builder {
        crate::input::get_member_input::Builder::default()
    }
    /// Creates a new `GetMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMember {
    type Output = std::result::Result<crate::output::GetMemberOutput, crate::error::GetMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_member_error(response)
        } else {
            crate::operation_deser::parse_get_member_response(response)
        }
    }
}

/// Operation shape for `ListAccountPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_account_permissions`](crate::client::Client::list_account_permissions).
///
/// See [`crate::client::fluent_builders::ListAccountPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountPermissions {
    _private: (),
}
impl ListAccountPermissions {
    /// Creates a new builder-style object to manufacture [`ListAccountPermissionsInput`](crate::input::ListAccountPermissionsInput)
    pub fn builder() -> crate::input::list_account_permissions_input::Builder {
        crate::input::list_account_permissions_input::Builder::default()
    }
    /// Creates a new `ListAccountPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountPermissions {
    type Output = std::result::Result<
        crate::output::ListAccountPermissionsOutput,
        crate::error::ListAccountPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_account_permissions_error(response)
        } else {
            crate::operation_deser::parse_list_account_permissions_response(response)
        }
    }
}

/// Operation shape for `ListCoverage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_coverage`](crate::client::Client::list_coverage).
///
/// See [`crate::client::fluent_builders::ListCoverage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCoverage {
    _private: (),
}
impl ListCoverage {
    /// Creates a new builder-style object to manufacture [`ListCoverageInput`](crate::input::ListCoverageInput)
    pub fn builder() -> crate::input::list_coverage_input::Builder {
        crate::input::list_coverage_input::Builder::default()
    }
    /// Creates a new `ListCoverage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCoverage {
    type Output =
        std::result::Result<crate::output::ListCoverageOutput, crate::error::ListCoverageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_coverage_error(response)
        } else {
            crate::operation_deser::parse_list_coverage_response(response)
        }
    }
}

/// Operation shape for `ListCoverageStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_coverage_statistics`](crate::client::Client::list_coverage_statistics).
///
/// See [`crate::client::fluent_builders::ListCoverageStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCoverageStatistics {
    _private: (),
}
impl ListCoverageStatistics {
    /// Creates a new builder-style object to manufacture [`ListCoverageStatisticsInput`](crate::input::ListCoverageStatisticsInput)
    pub fn builder() -> crate::input::list_coverage_statistics_input::Builder {
        crate::input::list_coverage_statistics_input::Builder::default()
    }
    /// Creates a new `ListCoverageStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCoverageStatistics {
    type Output = std::result::Result<
        crate::output::ListCoverageStatisticsOutput,
        crate::error::ListCoverageStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_coverage_statistics_error(response)
        } else {
            crate::operation_deser::parse_list_coverage_statistics_response(response)
        }
    }
}

/// Operation shape for `ListDelegatedAdminAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_delegated_admin_accounts`](crate::client::Client::list_delegated_admin_accounts).
///
/// See [`crate::client::fluent_builders::ListDelegatedAdminAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDelegatedAdminAccounts {
    _private: (),
}
impl ListDelegatedAdminAccounts {
    /// Creates a new builder-style object to manufacture [`ListDelegatedAdminAccountsInput`](crate::input::ListDelegatedAdminAccountsInput)
    pub fn builder() -> crate::input::list_delegated_admin_accounts_input::Builder {
        crate::input::list_delegated_admin_accounts_input::Builder::default()
    }
    /// Creates a new `ListDelegatedAdminAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDelegatedAdminAccounts {
    type Output = std::result::Result<
        crate::output::ListDelegatedAdminAccountsOutput,
        crate::error::ListDelegatedAdminAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_delegated_admin_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_delegated_admin_accounts_response(response)
        }
    }
}

/// Operation shape for `ListFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_filters`](crate::client::Client::list_filters).
///
/// See [`crate::client::fluent_builders::ListFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFilters {
    _private: (),
}
impl ListFilters {
    /// Creates a new builder-style object to manufacture [`ListFiltersInput`](crate::input::ListFiltersInput)
    pub fn builder() -> crate::input::list_filters_input::Builder {
        crate::input::list_filters_input::Builder::default()
    }
    /// Creates a new `ListFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFilters {
    type Output =
        std::result::Result<crate::output::ListFiltersOutput, crate::error::ListFiltersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_filters_error(response)
        } else {
            crate::operation_deser::parse_list_filters_response(response)
        }
    }
}

/// Operation shape for `ListFindingAggregations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_finding_aggregations`](crate::client::Client::list_finding_aggregations).
///
/// See [`crate::client::fluent_builders::ListFindingAggregations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindingAggregations {
    _private: (),
}
impl ListFindingAggregations {
    /// Creates a new builder-style object to manufacture [`ListFindingAggregationsInput`](crate::input::ListFindingAggregationsInput)
    pub fn builder() -> crate::input::list_finding_aggregations_input::Builder {
        crate::input::list_finding_aggregations_input::Builder::default()
    }
    /// Creates a new `ListFindingAggregations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindingAggregations {
    type Output = std::result::Result<
        crate::output::ListFindingAggregationsOutput,
        crate::error::ListFindingAggregationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_finding_aggregations_error(response)
        } else {
            crate::operation_deser::parse_list_finding_aggregations_response(response)
        }
    }
}

/// Operation shape for `ListFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_findings`](crate::client::Client::list_findings).
///
/// See [`crate::client::fluent_builders::ListFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindings {
    _private: (),
}
impl ListFindings {
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
    /// Creates a new `ListFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindings {
    type Output =
        std::result::Result<crate::output::ListFindingsOutput, crate::error::ListFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_findings_error(response)
        } else {
            crate::operation_deser::parse_list_findings_response(response)
        }
    }
}

/// Operation shape for `ListMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_members`](crate::client::Client::list_members).
///
/// See [`crate::client::fluent_builders::ListMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMembers {
    _private: (),
}
impl ListMembers {
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
    /// Creates a new `ListMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMembers {
    type Output =
        std::result::Result<crate::output::ListMembersOutput, crate::error::ListMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_members_error(response)
        } else {
            crate::operation_deser::parse_list_members_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListUsageTotals`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_usage_totals`](crate::client::Client::list_usage_totals).
///
/// See [`crate::client::fluent_builders::ListUsageTotals`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsageTotals {
    _private: (),
}
impl ListUsageTotals {
    /// Creates a new builder-style object to manufacture [`ListUsageTotalsInput`](crate::input::ListUsageTotalsInput)
    pub fn builder() -> crate::input::list_usage_totals_input::Builder {
        crate::input::list_usage_totals_input::Builder::default()
    }
    /// Creates a new `ListUsageTotals` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsageTotals {
    type Output = std::result::Result<
        crate::output::ListUsageTotalsOutput,
        crate::error::ListUsageTotalsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_usage_totals_error(response)
        } else {
            crate::operation_deser::parse_list_usage_totals_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_filter`](crate::client::Client::update_filter).
///
/// See [`crate::client::fluent_builders::UpdateFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFilter {
    _private: (),
}
impl UpdateFilter {
    /// Creates a new builder-style object to manufacture [`UpdateFilterInput`](crate::input::UpdateFilterInput)
    pub fn builder() -> crate::input::update_filter_input::Builder {
        crate::input::update_filter_input::Builder::default()
    }
    /// Creates a new `UpdateFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFilter {
    type Output =
        std::result::Result<crate::output::UpdateFilterOutput, crate::error::UpdateFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_filter_error(response)
        } else {
            crate::operation_deser::parse_update_filter_response(response)
        }
    }
}

/// Operation shape for `UpdateOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_organization_configuration`](crate::client::Client::update_organization_configuration).
///
/// See [`crate::client::fluent_builders::UpdateOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOrganizationConfiguration {
    _private: (),
}
impl UpdateOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateOrganizationConfigurationOutput,
        crate::error::UpdateOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_organization_configuration_response(response)
        }
    }
}
