// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object that describes a validation exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the validation exception.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The validation exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the validation exception.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The validation exception message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the validation exception.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the validation exception.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The validation exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The validation exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANNOT_PARSE", "FIELD_VALIDATION_FAILED", "OTHER"]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents which scan types are automatically enabled for new members of your Amazon Inspector organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoEnable {
    /// <p>Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.</p>
    pub ec2: std::option::Option<bool>,
    /// <p>Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.</p>
    pub ecr: std::option::Option<bool>,
}
impl AutoEnable {
    /// <p>Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.</p>
    pub fn ec2(&self) -> std::option::Option<bool> {
        self.ec2
    }
    /// <p>Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.</p>
    pub fn ecr(&self) -> std::option::Option<bool> {
        self.ecr
    }
}
impl std::fmt::Debug for AutoEnable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoEnable");
        formatter.field("ec2", &self.ec2);
        formatter.field("ecr", &self.ecr);
        formatter.finish()
    }
}
/// See [`AutoEnable`](crate::model::AutoEnable)
pub mod auto_enable {
    /// A builder for [`AutoEnable`](crate::model::AutoEnable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2: std::option::Option<bool>,
        pub(crate) ecr: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.</p>
        pub fn ec2(mut self, input: bool) -> Self {
            self.ec2 = Some(input);
            self
        }
        /// <p>Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector organization.</p>
        pub fn set_ec2(mut self, input: std::option::Option<bool>) -> Self {
            self.ec2 = input;
            self
        }
        /// <p>Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.</p>
        pub fn ecr(mut self, input: bool) -> Self {
            self.ecr = Some(input);
            self
        }
        /// <p>Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector organization.</p>
        pub fn set_ecr(mut self, input: std::option::Option<bool>) -> Self {
            self.ecr = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoEnable`](crate::model::AutoEnable)
        pub fn build(self) -> crate::model::AutoEnable {
            crate::model::AutoEnable {
                ec2: self.ec2,
                ecr: self.ecr,
            }
        }
    }
}
impl AutoEnable {
    /// Creates a new builder-style object to manufacture [`AutoEnable`](crate::model::AutoEnable)
    pub fn builder() -> crate::model::auto_enable::Builder {
        crate::model::auto_enable::Builder::default()
    }
}

/// <p>Details on the criteria used to define the filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterCriteria {
    /// <p>Details on the finding ARNs used to filter findings.</p>
    pub finding_arn: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details of the Amazon Web Services account IDs used to filter findings.</p>
    pub aws_account_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the finding types used to filter findings.</p>
    pub finding_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the severity used to filter findings.</p>
    pub severity: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the date and time a finding was first seen used to filter findings.</p>
    pub first_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>Details on the date and time a finding was last seen used to filter findings.</p>
    pub last_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>Details on the date and time a finding was last updated at used to filter findings.</p>
    pub updated_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>Details on the finding status types used to filter findings.</p>
    pub finding_status: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the finding title used to filter findings.</p>
    pub title: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The Amazon Inspector score to filter on.</p>
    pub inspector_score: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
    /// <p>Details on the resource types used to filter findings.</p>
    pub resource_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the resource IDs used to filter findings.</p>
    pub resource_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the resource tags used to filter findings.</p>
    pub resource_tags: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
    /// <p>Details of the Amazon EC2 instance image IDs used to filter findings.</p>
    pub ec2_instance_image_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details of the Amazon EC2 instance VPC IDs used to filter findings.</p>
    pub ec2_instance_vpc_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details of the Amazon EC2 instance subnet IDs used to filter findings.</p>
    pub ec2_instance_subnet_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the Amazon ECR image push date and time used to filter findings.</p>
    pub ecr_image_pushed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
    /// <p>Details of the Amazon ECR image architecture types used to filter findings.</p>
    pub ecr_image_architecture: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the Amazon ECR registry used to filter findings.</p>
    pub ecr_image_registry: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the name of the Amazon ECR repository used to filter findings.</p>
    pub ecr_image_repository_name: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The tags attached to the Amazon ECR container image.</p>
    pub ecr_image_tags: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details of the Amazon ECR image hashes used to filter findings.</p>
    pub ecr_image_hash: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the port ranges used to filter findings.</p>
    pub port_range: std::option::Option<std::vec::Vec<crate::model::PortRangeFilter>>,
    /// <p>Details on the ingress source addresses used to filter findings.</p>
    pub network_protocol: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details of the component IDs used to filter findings.</p>
    pub component_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details of the component types used to filter findings.</p>
    pub component_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the vulnerability ID used to filter findings.</p>
    pub vulnerability_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the vulnerability type used to filter findings.</p>
    pub vulnerability_source: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the vendor severity used to filter findings.</p>
    pub vendor_severity: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>Details on the vulnerable packages used to filter findings.</p>
    pub vulnerable_packages: std::option::Option<std::vec::Vec<crate::model::PackageFilter>>,
    /// <p>Details on the related vulnerabilities used to filter findings.</p>
    pub related_vulnerabilities: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
}
impl FilterCriteria {
    /// <p>Details on the finding ARNs used to filter findings.</p>
    pub fn finding_arn(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.finding_arn.as_deref()
    }
    /// <p>Details of the Amazon Web Services account IDs used to filter findings.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.aws_account_id.as_deref()
    }
    /// <p>Details on the finding types used to filter findings.</p>
    pub fn finding_type(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.finding_type.as_deref()
    }
    /// <p>Details on the severity used to filter findings.</p>
    pub fn severity(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.severity.as_deref()
    }
    /// <p>Details on the date and time a finding was first seen used to filter findings.</p>
    pub fn first_observed_at(&self) -> std::option::Option<&[crate::model::DateFilter]> {
        self.first_observed_at.as_deref()
    }
    /// <p>Details on the date and time a finding was last seen used to filter findings.</p>
    pub fn last_observed_at(&self) -> std::option::Option<&[crate::model::DateFilter]> {
        self.last_observed_at.as_deref()
    }
    /// <p>Details on the date and time a finding was last updated at used to filter findings.</p>
    pub fn updated_at(&self) -> std::option::Option<&[crate::model::DateFilter]> {
        self.updated_at.as_deref()
    }
    /// <p>Details on the finding status types used to filter findings.</p>
    pub fn finding_status(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.finding_status.as_deref()
    }
    /// <p>Details on the finding title used to filter findings.</p>
    pub fn title(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.title.as_deref()
    }
    /// <p>The Amazon Inspector score to filter on.</p>
    pub fn inspector_score(&self) -> std::option::Option<&[crate::model::NumberFilter]> {
        self.inspector_score.as_deref()
    }
    /// <p>Details on the resource types used to filter findings.</p>
    pub fn resource_type(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.resource_type.as_deref()
    }
    /// <p>Details on the resource IDs used to filter findings.</p>
    pub fn resource_id(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.resource_id.as_deref()
    }
    /// <p>Details on the resource tags used to filter findings.</p>
    pub fn resource_tags(&self) -> std::option::Option<&[crate::model::MapFilter]> {
        self.resource_tags.as_deref()
    }
    /// <p>Details of the Amazon EC2 instance image IDs used to filter findings.</p>
    pub fn ec2_instance_image_id(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ec2_instance_image_id.as_deref()
    }
    /// <p>Details of the Amazon EC2 instance VPC IDs used to filter findings.</p>
    pub fn ec2_instance_vpc_id(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ec2_instance_vpc_id.as_deref()
    }
    /// <p>Details of the Amazon EC2 instance subnet IDs used to filter findings.</p>
    pub fn ec2_instance_subnet_id(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ec2_instance_subnet_id.as_deref()
    }
    /// <p>Details on the Amazon ECR image push date and time used to filter findings.</p>
    pub fn ecr_image_pushed_at(&self) -> std::option::Option<&[crate::model::DateFilter]> {
        self.ecr_image_pushed_at.as_deref()
    }
    /// <p>Details of the Amazon ECR image architecture types used to filter findings.</p>
    pub fn ecr_image_architecture(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ecr_image_architecture.as_deref()
    }
    /// <p>Details on the Amazon ECR registry used to filter findings.</p>
    pub fn ecr_image_registry(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ecr_image_registry.as_deref()
    }
    /// <p>Details on the name of the Amazon ECR repository used to filter findings.</p>
    pub fn ecr_image_repository_name(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ecr_image_repository_name.as_deref()
    }
    /// <p>The tags attached to the Amazon ECR container image.</p>
    pub fn ecr_image_tags(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ecr_image_tags.as_deref()
    }
    /// <p>Details of the Amazon ECR image hashes used to filter findings.</p>
    pub fn ecr_image_hash(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.ecr_image_hash.as_deref()
    }
    /// <p>Details on the port ranges used to filter findings.</p>
    pub fn port_range(&self) -> std::option::Option<&[crate::model::PortRangeFilter]> {
        self.port_range.as_deref()
    }
    /// <p>Details on the ingress source addresses used to filter findings.</p>
    pub fn network_protocol(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.network_protocol.as_deref()
    }
    /// <p>Details of the component IDs used to filter findings.</p>
    pub fn component_id(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.component_id.as_deref()
    }
    /// <p>Details of the component types used to filter findings.</p>
    pub fn component_type(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.component_type.as_deref()
    }
    /// <p>Details on the vulnerability ID used to filter findings.</p>
    pub fn vulnerability_id(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.vulnerability_id.as_deref()
    }
    /// <p>Details on the vulnerability type used to filter findings.</p>
    pub fn vulnerability_source(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.vulnerability_source.as_deref()
    }
    /// <p>Details on the vendor severity used to filter findings.</p>
    pub fn vendor_severity(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.vendor_severity.as_deref()
    }
    /// <p>Details on the vulnerable packages used to filter findings.</p>
    pub fn vulnerable_packages(&self) -> std::option::Option<&[crate::model::PackageFilter]> {
        self.vulnerable_packages.as_deref()
    }
    /// <p>Details on the related vulnerabilities used to filter findings.</p>
    pub fn related_vulnerabilities(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.related_vulnerabilities.as_deref()
    }
}
impl std::fmt::Debug for FilterCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterCriteria");
        formatter.field("finding_arn", &self.finding_arn);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("finding_type", &self.finding_type);
        formatter.field("severity", &self.severity);
        formatter.field("first_observed_at", &self.first_observed_at);
        formatter.field("last_observed_at", &self.last_observed_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("finding_status", &self.finding_status);
        formatter.field("title", &self.title);
        formatter.field("inspector_score", &self.inspector_score);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("ec2_instance_image_id", &self.ec2_instance_image_id);
        formatter.field("ec2_instance_vpc_id", &self.ec2_instance_vpc_id);
        formatter.field("ec2_instance_subnet_id", &self.ec2_instance_subnet_id);
        formatter.field("ecr_image_pushed_at", &self.ecr_image_pushed_at);
        formatter.field("ecr_image_architecture", &self.ecr_image_architecture);
        formatter.field("ecr_image_registry", &self.ecr_image_registry);
        formatter.field("ecr_image_repository_name", &self.ecr_image_repository_name);
        formatter.field("ecr_image_tags", &self.ecr_image_tags);
        formatter.field("ecr_image_hash", &self.ecr_image_hash);
        formatter.field("port_range", &self.port_range);
        formatter.field("network_protocol", &self.network_protocol);
        formatter.field("component_id", &self.component_id);
        formatter.field("component_type", &self.component_type);
        formatter.field("vulnerability_id", &self.vulnerability_id);
        formatter.field("vulnerability_source", &self.vulnerability_source);
        formatter.field("vendor_severity", &self.vendor_severity);
        formatter.field("vulnerable_packages", &self.vulnerable_packages);
        formatter.field("related_vulnerabilities", &self.related_vulnerabilities);
        formatter.finish()
    }
}
/// See [`FilterCriteria`](crate::model::FilterCriteria)
pub mod filter_criteria {
    /// A builder for [`FilterCriteria`](crate::model::FilterCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_arn: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) aws_account_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) finding_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) severity: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) first_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) last_observed_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) updated_at: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) finding_status: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) title: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) inspector_score: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        pub(crate) resource_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_tags: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        pub(crate) ec2_instance_image_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) ec2_instance_vpc_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) ec2_instance_subnet_id:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) ecr_image_pushed_at:
            std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        pub(crate) ecr_image_architecture:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) ecr_image_registry:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) ecr_image_repository_name:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) ecr_image_tags: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) ecr_image_hash: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) port_range: std::option::Option<std::vec::Vec<crate::model::PortRangeFilter>>,
        pub(crate) network_protocol: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) component_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) component_type: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) vulnerability_id: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) vulnerability_source:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) vendor_severity: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) vulnerable_packages:
            std::option::Option<std::vec::Vec<crate::model::PackageFilter>>,
        pub(crate) related_vulnerabilities:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    }
    impl Builder {
        /// Appends an item to `finding_arn`.
        ///
        /// To override the contents of this collection use [`set_finding_arn`](Self::set_finding_arn).
        ///
        /// <p>Details on the finding ARNs used to filter findings.</p>
        pub fn finding_arn(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.finding_arn.unwrap_or_default();
            v.push(input);
            self.finding_arn = Some(v);
            self
        }
        /// <p>Details on the finding ARNs used to filter findings.</p>
        pub fn set_finding_arn(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_arn = input;
            self
        }
        /// Appends an item to `aws_account_id`.
        ///
        /// To override the contents of this collection use [`set_aws_account_id`](Self::set_aws_account_id).
        ///
        /// <p>Details of the Amazon Web Services account IDs used to filter findings.</p>
        pub fn aws_account_id(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.aws_account_id.unwrap_or_default();
            v.push(input);
            self.aws_account_id = Some(v);
            self
        }
        /// <p>Details of the Amazon Web Services account IDs used to filter findings.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Appends an item to `finding_type`.
        ///
        /// To override the contents of this collection use [`set_finding_type`](Self::set_finding_type).
        ///
        /// <p>Details on the finding types used to filter findings.</p>
        pub fn finding_type(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.finding_type.unwrap_or_default();
            v.push(input);
            self.finding_type = Some(v);
            self
        }
        /// <p>Details on the finding types used to filter findings.</p>
        pub fn set_finding_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_type = input;
            self
        }
        /// Appends an item to `severity`.
        ///
        /// To override the contents of this collection use [`set_severity`](Self::set_severity).
        ///
        /// <p>Details on the severity used to filter findings.</p>
        pub fn severity(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.severity.unwrap_or_default();
            v.push(input);
            self.severity = Some(v);
            self
        }
        /// <p>Details on the severity used to filter findings.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// Appends an item to `first_observed_at`.
        ///
        /// To override the contents of this collection use [`set_first_observed_at`](Self::set_first_observed_at).
        ///
        /// <p>Details on the date and time a finding was first seen used to filter findings.</p>
        pub fn first_observed_at(mut self, input: crate::model::DateFilter) -> Self {
            let mut v = self.first_observed_at.unwrap_or_default();
            v.push(input);
            self.first_observed_at = Some(v);
            self
        }
        /// <p>Details on the date and time a finding was first seen used to filter findings.</p>
        pub fn set_first_observed_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.first_observed_at = input;
            self
        }
        /// Appends an item to `last_observed_at`.
        ///
        /// To override the contents of this collection use [`set_last_observed_at`](Self::set_last_observed_at).
        ///
        /// <p>Details on the date and time a finding was last seen used to filter findings.</p>
        pub fn last_observed_at(mut self, input: crate::model::DateFilter) -> Self {
            let mut v = self.last_observed_at.unwrap_or_default();
            v.push(input);
            self.last_observed_at = Some(v);
            self
        }
        /// <p>Details on the date and time a finding was last seen used to filter findings.</p>
        pub fn set_last_observed_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.last_observed_at = input;
            self
        }
        /// Appends an item to `updated_at`.
        ///
        /// To override the contents of this collection use [`set_updated_at`](Self::set_updated_at).
        ///
        /// <p>Details on the date and time a finding was last updated at used to filter findings.</p>
        pub fn updated_at(mut self, input: crate::model::DateFilter) -> Self {
            let mut v = self.updated_at.unwrap_or_default();
            v.push(input);
            self.updated_at = Some(v);
            self
        }
        /// <p>Details on the date and time a finding was last updated at used to filter findings.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Appends an item to `finding_status`.
        ///
        /// To override the contents of this collection use [`set_finding_status`](Self::set_finding_status).
        ///
        /// <p>Details on the finding status types used to filter findings.</p>
        pub fn finding_status(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.finding_status.unwrap_or_default();
            v.push(input);
            self.finding_status = Some(v);
            self
        }
        /// <p>Details on the finding status types used to filter findings.</p>
        pub fn set_finding_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.finding_status = input;
            self
        }
        /// Appends an item to `title`.
        ///
        /// To override the contents of this collection use [`set_title`](Self::set_title).
        ///
        /// <p>Details on the finding title used to filter findings.</p>
        pub fn title(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.title.unwrap_or_default();
            v.push(input);
            self.title = Some(v);
            self
        }
        /// <p>Details on the finding title used to filter findings.</p>
        pub fn set_title(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.title = input;
            self
        }
        /// Appends an item to `inspector_score`.
        ///
        /// To override the contents of this collection use [`set_inspector_score`](Self::set_inspector_score).
        ///
        /// <p>The Amazon Inspector score to filter on.</p>
        pub fn inspector_score(mut self, input: crate::model::NumberFilter) -> Self {
            let mut v = self.inspector_score.unwrap_or_default();
            v.push(input);
            self.inspector_score = Some(v);
            self
        }
        /// <p>The Amazon Inspector score to filter on.</p>
        pub fn set_inspector_score(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberFilter>>,
        ) -> Self {
            self.inspector_score = input;
            self
        }
        /// Appends an item to `resource_type`.
        ///
        /// To override the contents of this collection use [`set_resource_type`](Self::set_resource_type).
        ///
        /// <p>Details on the resource types used to filter findings.</p>
        pub fn resource_type(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.resource_type.unwrap_or_default();
            v.push(input);
            self.resource_type = Some(v);
            self
        }
        /// <p>Details on the resource types used to filter findings.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_id`.
        ///
        /// To override the contents of this collection use [`set_resource_id`](Self::set_resource_id).
        ///
        /// <p>Details on the resource IDs used to filter findings.</p>
        pub fn resource_id(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.resource_id.unwrap_or_default();
            v.push(input);
            self.resource_id = Some(v);
            self
        }
        /// <p>Details on the resource IDs used to filter findings.</p>
        pub fn set_resource_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>Details on the resource tags used to filter findings.</p>
        pub fn resource_tags(mut self, input: crate::model::MapFilter) -> Self {
            let mut v = self.resource_tags.unwrap_or_default();
            v.push(input);
            self.resource_tags = Some(v);
            self
        }
        /// <p>Details on the resource tags used to filter findings.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Appends an item to `ec2_instance_image_id`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_image_id`](Self::set_ec2_instance_image_id).
        ///
        /// <p>Details of the Amazon EC2 instance image IDs used to filter findings.</p>
        pub fn ec2_instance_image_id(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ec2_instance_image_id.unwrap_or_default();
            v.push(input);
            self.ec2_instance_image_id = Some(v);
            self
        }
        /// <p>Details of the Amazon EC2 instance image IDs used to filter findings.</p>
        pub fn set_ec2_instance_image_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ec2_instance_image_id = input;
            self
        }
        /// Appends an item to `ec2_instance_vpc_id`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_vpc_id`](Self::set_ec2_instance_vpc_id).
        ///
        /// <p>Details of the Amazon EC2 instance VPC IDs used to filter findings.</p>
        pub fn ec2_instance_vpc_id(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ec2_instance_vpc_id.unwrap_or_default();
            v.push(input);
            self.ec2_instance_vpc_id = Some(v);
            self
        }
        /// <p>Details of the Amazon EC2 instance VPC IDs used to filter findings.</p>
        pub fn set_ec2_instance_vpc_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ec2_instance_vpc_id = input;
            self
        }
        /// Appends an item to `ec2_instance_subnet_id`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_subnet_id`](Self::set_ec2_instance_subnet_id).
        ///
        /// <p>Details of the Amazon EC2 instance subnet IDs used to filter findings.</p>
        pub fn ec2_instance_subnet_id(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ec2_instance_subnet_id.unwrap_or_default();
            v.push(input);
            self.ec2_instance_subnet_id = Some(v);
            self
        }
        /// <p>Details of the Amazon EC2 instance subnet IDs used to filter findings.</p>
        pub fn set_ec2_instance_subnet_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ec2_instance_subnet_id = input;
            self
        }
        /// Appends an item to `ecr_image_pushed_at`.
        ///
        /// To override the contents of this collection use [`set_ecr_image_pushed_at`](Self::set_ecr_image_pushed_at).
        ///
        /// <p>Details on the Amazon ECR image push date and time used to filter findings.</p>
        pub fn ecr_image_pushed_at(mut self, input: crate::model::DateFilter) -> Self {
            let mut v = self.ecr_image_pushed_at.unwrap_or_default();
            v.push(input);
            self.ecr_image_pushed_at = Some(v);
            self
        }
        /// <p>Details on the Amazon ECR image push date and time used to filter findings.</p>
        pub fn set_ecr_image_pushed_at(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateFilter>>,
        ) -> Self {
            self.ecr_image_pushed_at = input;
            self
        }
        /// Appends an item to `ecr_image_architecture`.
        ///
        /// To override the contents of this collection use [`set_ecr_image_architecture`](Self::set_ecr_image_architecture).
        ///
        /// <p>Details of the Amazon ECR image architecture types used to filter findings.</p>
        pub fn ecr_image_architecture(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ecr_image_architecture.unwrap_or_default();
            v.push(input);
            self.ecr_image_architecture = Some(v);
            self
        }
        /// <p>Details of the Amazon ECR image architecture types used to filter findings.</p>
        pub fn set_ecr_image_architecture(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ecr_image_architecture = input;
            self
        }
        /// Appends an item to `ecr_image_registry`.
        ///
        /// To override the contents of this collection use [`set_ecr_image_registry`](Self::set_ecr_image_registry).
        ///
        /// <p>Details on the Amazon ECR registry used to filter findings.</p>
        pub fn ecr_image_registry(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ecr_image_registry.unwrap_or_default();
            v.push(input);
            self.ecr_image_registry = Some(v);
            self
        }
        /// <p>Details on the Amazon ECR registry used to filter findings.</p>
        pub fn set_ecr_image_registry(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ecr_image_registry = input;
            self
        }
        /// Appends an item to `ecr_image_repository_name`.
        ///
        /// To override the contents of this collection use [`set_ecr_image_repository_name`](Self::set_ecr_image_repository_name).
        ///
        /// <p>Details on the name of the Amazon ECR repository used to filter findings.</p>
        pub fn ecr_image_repository_name(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ecr_image_repository_name.unwrap_or_default();
            v.push(input);
            self.ecr_image_repository_name = Some(v);
            self
        }
        /// <p>Details on the name of the Amazon ECR repository used to filter findings.</p>
        pub fn set_ecr_image_repository_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ecr_image_repository_name = input;
            self
        }
        /// Appends an item to `ecr_image_tags`.
        ///
        /// To override the contents of this collection use [`set_ecr_image_tags`](Self::set_ecr_image_tags).
        ///
        /// <p>The tags attached to the Amazon ECR container image.</p>
        pub fn ecr_image_tags(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ecr_image_tags.unwrap_or_default();
            v.push(input);
            self.ecr_image_tags = Some(v);
            self
        }
        /// <p>The tags attached to the Amazon ECR container image.</p>
        pub fn set_ecr_image_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ecr_image_tags = input;
            self
        }
        /// Appends an item to `ecr_image_hash`.
        ///
        /// To override the contents of this collection use [`set_ecr_image_hash`](Self::set_ecr_image_hash).
        ///
        /// <p>Details of the Amazon ECR image hashes used to filter findings.</p>
        pub fn ecr_image_hash(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.ecr_image_hash.unwrap_or_default();
            v.push(input);
            self.ecr_image_hash = Some(v);
            self
        }
        /// <p>Details of the Amazon ECR image hashes used to filter findings.</p>
        pub fn set_ecr_image_hash(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.ecr_image_hash = input;
            self
        }
        /// Appends an item to `port_range`.
        ///
        /// To override the contents of this collection use [`set_port_range`](Self::set_port_range).
        ///
        /// <p>Details on the port ranges used to filter findings.</p>
        pub fn port_range(mut self, input: crate::model::PortRangeFilter) -> Self {
            let mut v = self.port_range.unwrap_or_default();
            v.push(input);
            self.port_range = Some(v);
            self
        }
        /// <p>Details on the port ranges used to filter findings.</p>
        pub fn set_port_range(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRangeFilter>>,
        ) -> Self {
            self.port_range = input;
            self
        }
        /// Appends an item to `network_protocol`.
        ///
        /// To override the contents of this collection use [`set_network_protocol`](Self::set_network_protocol).
        ///
        /// <p>Details on the ingress source addresses used to filter findings.</p>
        pub fn network_protocol(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.network_protocol.unwrap_or_default();
            v.push(input);
            self.network_protocol = Some(v);
            self
        }
        /// <p>Details on the ingress source addresses used to filter findings.</p>
        pub fn set_network_protocol(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.network_protocol = input;
            self
        }
        /// Appends an item to `component_id`.
        ///
        /// To override the contents of this collection use [`set_component_id`](Self::set_component_id).
        ///
        /// <p>Details of the component IDs used to filter findings.</p>
        pub fn component_id(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.component_id.unwrap_or_default();
            v.push(input);
            self.component_id = Some(v);
            self
        }
        /// <p>Details of the component IDs used to filter findings.</p>
        pub fn set_component_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.component_id = input;
            self
        }
        /// Appends an item to `component_type`.
        ///
        /// To override the contents of this collection use [`set_component_type`](Self::set_component_type).
        ///
        /// <p>Details of the component types used to filter findings.</p>
        pub fn component_type(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.component_type.unwrap_or_default();
            v.push(input);
            self.component_type = Some(v);
            self
        }
        /// <p>Details of the component types used to filter findings.</p>
        pub fn set_component_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.component_type = input;
            self
        }
        /// Appends an item to `vulnerability_id`.
        ///
        /// To override the contents of this collection use [`set_vulnerability_id`](Self::set_vulnerability_id).
        ///
        /// <p>Details on the vulnerability ID used to filter findings.</p>
        pub fn vulnerability_id(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.vulnerability_id.unwrap_or_default();
            v.push(input);
            self.vulnerability_id = Some(v);
            self
        }
        /// <p>Details on the vulnerability ID used to filter findings.</p>
        pub fn set_vulnerability_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.vulnerability_id = input;
            self
        }
        /// Appends an item to `vulnerability_source`.
        ///
        /// To override the contents of this collection use [`set_vulnerability_source`](Self::set_vulnerability_source).
        ///
        /// <p>Details on the vulnerability type used to filter findings.</p>
        pub fn vulnerability_source(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.vulnerability_source.unwrap_or_default();
            v.push(input);
            self.vulnerability_source = Some(v);
            self
        }
        /// <p>Details on the vulnerability type used to filter findings.</p>
        pub fn set_vulnerability_source(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.vulnerability_source = input;
            self
        }
        /// Appends an item to `vendor_severity`.
        ///
        /// To override the contents of this collection use [`set_vendor_severity`](Self::set_vendor_severity).
        ///
        /// <p>Details on the vendor severity used to filter findings.</p>
        pub fn vendor_severity(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.vendor_severity.unwrap_or_default();
            v.push(input);
            self.vendor_severity = Some(v);
            self
        }
        /// <p>Details on the vendor severity used to filter findings.</p>
        pub fn set_vendor_severity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.vendor_severity = input;
            self
        }
        /// Appends an item to `vulnerable_packages`.
        ///
        /// To override the contents of this collection use [`set_vulnerable_packages`](Self::set_vulnerable_packages).
        ///
        /// <p>Details on the vulnerable packages used to filter findings.</p>
        pub fn vulnerable_packages(mut self, input: crate::model::PackageFilter) -> Self {
            let mut v = self.vulnerable_packages.unwrap_or_default();
            v.push(input);
            self.vulnerable_packages = Some(v);
            self
        }
        /// <p>Details on the vulnerable packages used to filter findings.</p>
        pub fn set_vulnerable_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageFilter>>,
        ) -> Self {
            self.vulnerable_packages = input;
            self
        }
        /// Appends an item to `related_vulnerabilities`.
        ///
        /// To override the contents of this collection use [`set_related_vulnerabilities`](Self::set_related_vulnerabilities).
        ///
        /// <p>Details on the related vulnerabilities used to filter findings.</p>
        pub fn related_vulnerabilities(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.related_vulnerabilities.unwrap_or_default();
            v.push(input);
            self.related_vulnerabilities = Some(v);
            self
        }
        /// <p>Details on the related vulnerabilities used to filter findings.</p>
        pub fn set_related_vulnerabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.related_vulnerabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterCriteria`](crate::model::FilterCriteria)
        pub fn build(self) -> crate::model::FilterCriteria {
            crate::model::FilterCriteria {
                finding_arn: self.finding_arn,
                aws_account_id: self.aws_account_id,
                finding_type: self.finding_type,
                severity: self.severity,
                first_observed_at: self.first_observed_at,
                last_observed_at: self.last_observed_at,
                updated_at: self.updated_at,
                finding_status: self.finding_status,
                title: self.title,
                inspector_score: self.inspector_score,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                resource_tags: self.resource_tags,
                ec2_instance_image_id: self.ec2_instance_image_id,
                ec2_instance_vpc_id: self.ec2_instance_vpc_id,
                ec2_instance_subnet_id: self.ec2_instance_subnet_id,
                ecr_image_pushed_at: self.ecr_image_pushed_at,
                ecr_image_architecture: self.ecr_image_architecture,
                ecr_image_registry: self.ecr_image_registry,
                ecr_image_repository_name: self.ecr_image_repository_name,
                ecr_image_tags: self.ecr_image_tags,
                ecr_image_hash: self.ecr_image_hash,
                port_range: self.port_range,
                network_protocol: self.network_protocol,
                component_id: self.component_id,
                component_type: self.component_type,
                vulnerability_id: self.vulnerability_id,
                vulnerability_source: self.vulnerability_source,
                vendor_severity: self.vendor_severity,
                vulnerable_packages: self.vulnerable_packages,
                related_vulnerabilities: self.related_vulnerabilities,
            }
        }
    }
}
impl FilterCriteria {
    /// Creates a new builder-style object to manufacture [`FilterCriteria`](crate::model::FilterCriteria)
    pub fn builder() -> crate::model::filter_criteria::Builder {
        crate::model::filter_criteria::Builder::default()
    }
}

/// <p>An object that describes the details of a string filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StringFilter {
    /// <p>The operator to use when comparing values in the filter</p>
    pub comparison: std::option::Option<crate::model::StringComparison>,
    /// <p>The value to filter on.</p>
    pub value: std::option::Option<std::string::String>,
}
impl StringFilter {
    /// <p>The operator to use when comparing values in the filter</p>
    pub fn comparison(&self) -> std::option::Option<&crate::model::StringComparison> {
        self.comparison.as_ref()
    }
    /// <p>The value to filter on.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for StringFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StringFilter");
        formatter.field("comparison", &self.comparison);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`StringFilter`](crate::model::StringFilter)
pub mod string_filter {
    /// A builder for [`StringFilter`](crate::model::StringFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison: std::option::Option<crate::model::StringComparison>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The operator to use when comparing values in the filter</p>
        pub fn comparison(mut self, input: crate::model::StringComparison) -> Self {
            self.comparison = Some(input);
            self
        }
        /// <p>The operator to use when comparing values in the filter</p>
        pub fn set_comparison(
            mut self,
            input: std::option::Option<crate::model::StringComparison>,
        ) -> Self {
            self.comparison = input;
            self
        }
        /// <p>The value to filter on.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value to filter on.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`StringFilter`](crate::model::StringFilter)
        pub fn build(self) -> crate::model::StringFilter {
            crate::model::StringFilter {
                comparison: self.comparison,
                value: self.value,
            }
        }
    }
}
impl StringFilter {
    /// Creates a new builder-style object to manufacture [`StringFilter`](crate::model::StringFilter)
    pub fn builder() -> crate::model::string_filter::Builder {
        crate::model::string_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StringComparison {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    NotEquals,
    #[allow(missing_docs)] // documentation missing in model
    Prefix,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StringComparison {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => StringComparison::Equals,
            "NOT_EQUALS" => StringComparison::NotEquals,
            "PREFIX" => StringComparison::Prefix,
            other => StringComparison::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StringComparison {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StringComparison::from(s))
    }
}
impl StringComparison {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StringComparison::Equals => "EQUALS",
            StringComparison::NotEquals => "NOT_EQUALS",
            StringComparison::Prefix => "PREFIX",
            StringComparison::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS", "NOT_EQUALS", "PREFIX"]
    }
}
impl AsRef<str> for StringComparison {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information on the details of a package filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageFilter {
    /// <p>An object that contains details on the name of the package to filter on.</p>
    pub name: std::option::Option<crate::model::StringFilter>,
    /// <p>The package version to filter on.</p>
    pub version: std::option::Option<crate::model::StringFilter>,
    /// <p>An object that contains details on the package epoch to filter on.</p>
    pub epoch: std::option::Option<crate::model::NumberFilter>,
    /// <p>An object that contains details on the package release to filter on.</p>
    pub release: std::option::Option<crate::model::StringFilter>,
    /// <p>An object that contains details on the package architecture type to filter on.</p>
    pub architecture: std::option::Option<crate::model::StringFilter>,
    /// <p>An object that contains details on the source layer hash to filter on.</p>
    pub source_layer_hash: std::option::Option<crate::model::StringFilter>,
}
impl PackageFilter {
    /// <p>An object that contains details on the name of the package to filter on.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::StringFilter> {
        self.name.as_ref()
    }
    /// <p>The package version to filter on.</p>
    pub fn version(&self) -> std::option::Option<&crate::model::StringFilter> {
        self.version.as_ref()
    }
    /// <p>An object that contains details on the package epoch to filter on.</p>
    pub fn epoch(&self) -> std::option::Option<&crate::model::NumberFilter> {
        self.epoch.as_ref()
    }
    /// <p>An object that contains details on the package release to filter on.</p>
    pub fn release(&self) -> std::option::Option<&crate::model::StringFilter> {
        self.release.as_ref()
    }
    /// <p>An object that contains details on the package architecture type to filter on.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::StringFilter> {
        self.architecture.as_ref()
    }
    /// <p>An object that contains details on the source layer hash to filter on.</p>
    pub fn source_layer_hash(&self) -> std::option::Option<&crate::model::StringFilter> {
        self.source_layer_hash.as_ref()
    }
}
impl std::fmt::Debug for PackageFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageFilter");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("epoch", &self.epoch);
        formatter.field("release", &self.release);
        formatter.field("architecture", &self.architecture);
        formatter.field("source_layer_hash", &self.source_layer_hash);
        formatter.finish()
    }
}
/// See [`PackageFilter`](crate::model::PackageFilter)
pub mod package_filter {
    /// A builder for [`PackageFilter`](crate::model::PackageFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::StringFilter>,
        pub(crate) version: std::option::Option<crate::model::StringFilter>,
        pub(crate) epoch: std::option::Option<crate::model::NumberFilter>,
        pub(crate) release: std::option::Option<crate::model::StringFilter>,
        pub(crate) architecture: std::option::Option<crate::model::StringFilter>,
        pub(crate) source_layer_hash: std::option::Option<crate::model::StringFilter>,
    }
    impl Builder {
        /// <p>An object that contains details on the name of the package to filter on.</p>
        pub fn name(mut self, input: crate::model::StringFilter) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>An object that contains details on the name of the package to filter on.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::StringFilter>) -> Self {
            self.name = input;
            self
        }
        /// <p>The package version to filter on.</p>
        pub fn version(mut self, input: crate::model::StringFilter) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The package version to filter on.</p>
        pub fn set_version(
            mut self,
            input: std::option::Option<crate::model::StringFilter>,
        ) -> Self {
            self.version = input;
            self
        }
        /// <p>An object that contains details on the package epoch to filter on.</p>
        pub fn epoch(mut self, input: crate::model::NumberFilter) -> Self {
            self.epoch = Some(input);
            self
        }
        /// <p>An object that contains details on the package epoch to filter on.</p>
        pub fn set_epoch(mut self, input: std::option::Option<crate::model::NumberFilter>) -> Self {
            self.epoch = input;
            self
        }
        /// <p>An object that contains details on the package release to filter on.</p>
        pub fn release(mut self, input: crate::model::StringFilter) -> Self {
            self.release = Some(input);
            self
        }
        /// <p>An object that contains details on the package release to filter on.</p>
        pub fn set_release(
            mut self,
            input: std::option::Option<crate::model::StringFilter>,
        ) -> Self {
            self.release = input;
            self
        }
        /// <p>An object that contains details on the package architecture type to filter on.</p>
        pub fn architecture(mut self, input: crate::model::StringFilter) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>An object that contains details on the package architecture type to filter on.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::StringFilter>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// <p>An object that contains details on the source layer hash to filter on.</p>
        pub fn source_layer_hash(mut self, input: crate::model::StringFilter) -> Self {
            self.source_layer_hash = Some(input);
            self
        }
        /// <p>An object that contains details on the source layer hash to filter on.</p>
        pub fn set_source_layer_hash(
            mut self,
            input: std::option::Option<crate::model::StringFilter>,
        ) -> Self {
            self.source_layer_hash = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageFilter`](crate::model::PackageFilter)
        pub fn build(self) -> crate::model::PackageFilter {
            crate::model::PackageFilter {
                name: self.name,
                version: self.version,
                epoch: self.epoch,
                release: self.release,
                architecture: self.architecture,
                source_layer_hash: self.source_layer_hash,
            }
        }
    }
}
impl PackageFilter {
    /// Creates a new builder-style object to manufacture [`PackageFilter`](crate::model::PackageFilter)
    pub fn builder() -> crate::model::package_filter::Builder {
        crate::model::package_filter::Builder::default()
    }
}

/// <p>An object that describes the details of a number filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NumberFilter {
    /// <p>The highest number to be included in the filter.</p>
    pub upper_inclusive: std::option::Option<f64>,
    /// <p>The lowest number to be included in the filter.</p>
    pub lower_inclusive: std::option::Option<f64>,
}
impl NumberFilter {
    /// <p>The highest number to be included in the filter.</p>
    pub fn upper_inclusive(&self) -> std::option::Option<f64> {
        self.upper_inclusive
    }
    /// <p>The lowest number to be included in the filter.</p>
    pub fn lower_inclusive(&self) -> std::option::Option<f64> {
        self.lower_inclusive
    }
}
impl std::fmt::Debug for NumberFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NumberFilter");
        formatter.field("upper_inclusive", &self.upper_inclusive);
        formatter.field("lower_inclusive", &self.lower_inclusive);
        formatter.finish()
    }
}
/// See [`NumberFilter`](crate::model::NumberFilter)
pub mod number_filter {
    /// A builder for [`NumberFilter`](crate::model::NumberFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upper_inclusive: std::option::Option<f64>,
        pub(crate) lower_inclusive: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The highest number to be included in the filter.</p>
        pub fn upper_inclusive(mut self, input: f64) -> Self {
            self.upper_inclusive = Some(input);
            self
        }
        /// <p>The highest number to be included in the filter.</p>
        pub fn set_upper_inclusive(mut self, input: std::option::Option<f64>) -> Self {
            self.upper_inclusive = input;
            self
        }
        /// <p>The lowest number to be included in the filter.</p>
        pub fn lower_inclusive(mut self, input: f64) -> Self {
            self.lower_inclusive = Some(input);
            self
        }
        /// <p>The lowest number to be included in the filter.</p>
        pub fn set_lower_inclusive(mut self, input: std::option::Option<f64>) -> Self {
            self.lower_inclusive = input;
            self
        }
        /// Consumes the builder and constructs a [`NumberFilter`](crate::model::NumberFilter)
        pub fn build(self) -> crate::model::NumberFilter {
            crate::model::NumberFilter {
                upper_inclusive: self.upper_inclusive,
                lower_inclusive: self.lower_inclusive,
            }
        }
    }
}
impl NumberFilter {
    /// Creates a new builder-style object to manufacture [`NumberFilter`](crate::model::NumberFilter)
    pub fn builder() -> crate::model::number_filter::Builder {
        crate::model::number_filter::Builder::default()
    }
}

/// <p>An object that describes the details of a port range filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortRangeFilter {
    /// <p>The port number the port range begins at.</p>
    pub begin_inclusive: std::option::Option<i32>,
    /// <p>The port number the port range ends at.</p>
    pub end_inclusive: std::option::Option<i32>,
}
impl PortRangeFilter {
    /// <p>The port number the port range begins at.</p>
    pub fn begin_inclusive(&self) -> std::option::Option<i32> {
        self.begin_inclusive
    }
    /// <p>The port number the port range ends at.</p>
    pub fn end_inclusive(&self) -> std::option::Option<i32> {
        self.end_inclusive
    }
}
impl std::fmt::Debug for PortRangeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortRangeFilter");
        formatter.field("begin_inclusive", &self.begin_inclusive);
        formatter.field("end_inclusive", &self.end_inclusive);
        formatter.finish()
    }
}
/// See [`PortRangeFilter`](crate::model::PortRangeFilter)
pub mod port_range_filter {
    /// A builder for [`PortRangeFilter`](crate::model::PortRangeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin_inclusive: std::option::Option<i32>,
        pub(crate) end_inclusive: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The port number the port range begins at.</p>
        pub fn begin_inclusive(mut self, input: i32) -> Self {
            self.begin_inclusive = Some(input);
            self
        }
        /// <p>The port number the port range begins at.</p>
        pub fn set_begin_inclusive(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_inclusive = input;
            self
        }
        /// <p>The port number the port range ends at.</p>
        pub fn end_inclusive(mut self, input: i32) -> Self {
            self.end_inclusive = Some(input);
            self
        }
        /// <p>The port number the port range ends at.</p>
        pub fn set_end_inclusive(mut self, input: std::option::Option<i32>) -> Self {
            self.end_inclusive = input;
            self
        }
        /// Consumes the builder and constructs a [`PortRangeFilter`](crate::model::PortRangeFilter)
        pub fn build(self) -> crate::model::PortRangeFilter {
            crate::model::PortRangeFilter {
                begin_inclusive: self.begin_inclusive,
                end_inclusive: self.end_inclusive,
            }
        }
    }
}
impl PortRangeFilter {
    /// Creates a new builder-style object to manufacture [`PortRangeFilter`](crate::model::PortRangeFilter)
    pub fn builder() -> crate::model::port_range_filter::Builder {
        crate::model::port_range_filter::Builder::default()
    }
}

/// <p>Contains details on the time range used to filter findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateFilter {
    /// <p>A timestamp representing the start of the time period filtered on.</p>
    pub start_inclusive: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp representing the end of the time period filtered on.</p>
    pub end_inclusive: std::option::Option<aws_smithy_types::DateTime>,
}
impl DateFilter {
    /// <p>A timestamp representing the start of the time period filtered on.</p>
    pub fn start_inclusive(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_inclusive.as_ref()
    }
    /// <p>A timestamp representing the end of the time period filtered on.</p>
    pub fn end_inclusive(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_inclusive.as_ref()
    }
}
impl std::fmt::Debug for DateFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateFilter");
        formatter.field("start_inclusive", &self.start_inclusive);
        formatter.field("end_inclusive", &self.end_inclusive);
        formatter.finish()
    }
}
/// See [`DateFilter`](crate::model::DateFilter)
pub mod date_filter {
    /// A builder for [`DateFilter`](crate::model::DateFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_inclusive: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_inclusive: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A timestamp representing the start of the time period filtered on.</p>
        pub fn start_inclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_inclusive = Some(input);
            self
        }
        /// <p>A timestamp representing the start of the time period filtered on.</p>
        pub fn set_start_inclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_inclusive = input;
            self
        }
        /// <p>A timestamp representing the end of the time period filtered on.</p>
        pub fn end_inclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_inclusive = Some(input);
            self
        }
        /// <p>A timestamp representing the end of the time period filtered on.</p>
        pub fn set_end_inclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_inclusive = input;
            self
        }
        /// Consumes the builder and constructs a [`DateFilter`](crate::model::DateFilter)
        pub fn build(self) -> crate::model::DateFilter {
            crate::model::DateFilter {
                start_inclusive: self.start_inclusive,
                end_inclusive: self.end_inclusive,
            }
        }
    }
}
impl DateFilter {
    /// Creates a new builder-style object to manufacture [`DateFilter`](crate::model::DateFilter)
    pub fn builder() -> crate::model::date_filter::Builder {
        crate::model::date_filter::Builder::default()
    }
}

/// <p>An object that describes details of a map filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MapFilter {
    /// <p>The operator to use when comparing values in the filter.</p>
    pub comparison: std::option::Option<crate::model::MapComparison>,
    /// <p>The tag key used in the filter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value used in the filter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl MapFilter {
    /// <p>The operator to use when comparing values in the filter.</p>
    pub fn comparison(&self) -> std::option::Option<&crate::model::MapComparison> {
        self.comparison.as_ref()
    }
    /// <p>The tag key used in the filter.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value used in the filter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MapFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MapFilter");
        formatter.field("comparison", &self.comparison);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MapFilter`](crate::model::MapFilter)
pub mod map_filter {
    /// A builder for [`MapFilter`](crate::model::MapFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison: std::option::Option<crate::model::MapComparison>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The operator to use when comparing values in the filter.</p>
        pub fn comparison(mut self, input: crate::model::MapComparison) -> Self {
            self.comparison = Some(input);
            self
        }
        /// <p>The operator to use when comparing values in the filter.</p>
        pub fn set_comparison(
            mut self,
            input: std::option::Option<crate::model::MapComparison>,
        ) -> Self {
            self.comparison = input;
            self
        }
        /// <p>The tag key used in the filter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key used in the filter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value used in the filter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value used in the filter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MapFilter`](crate::model::MapFilter)
        pub fn build(self) -> crate::model::MapFilter {
            crate::model::MapFilter {
                comparison: self.comparison,
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl MapFilter {
    /// Creates a new builder-style object to manufacture [`MapFilter`](crate::model::MapFilter)
    pub fn builder() -> crate::model::map_filter::Builder {
        crate::model::map_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MapComparison {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MapComparison {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => MapComparison::Equals,
            other => MapComparison::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MapComparison {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MapComparison::from(s))
    }
}
impl MapComparison {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MapComparison::Equals => "EQUALS",
            MapComparison::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS"]
    }
}
impl AsRef<str> for MapComparison {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterAction {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Suppress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterAction {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => FilterAction::None,
            "SUPPRESS" => FilterAction::Suppress,
            other => FilterAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterAction::from(s))
    }
}
impl FilterAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterAction::None => "NONE",
            FilterAction::Suppress => "SUPPRESS",
            FilterAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SUPPRESS"]
    }
}
impl AsRef<str> for FilterAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The total of usage for an account ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageTotal {
    /// <p>The account ID of the account that usage data was retrieved for.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object representing the total usage for an account.</p>
    pub usage: std::option::Option<std::vec::Vec<crate::model::Usage>>,
}
impl UsageTotal {
    /// <p>The account ID of the account that usage data was retrieved for.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object representing the total usage for an account.</p>
    pub fn usage(&self) -> std::option::Option<&[crate::model::Usage]> {
        self.usage.as_deref()
    }
}
impl std::fmt::Debug for UsageTotal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageTotal");
        formatter.field("account_id", &self.account_id);
        formatter.field("usage", &self.usage);
        formatter.finish()
    }
}
/// See [`UsageTotal`](crate::model::UsageTotal)
pub mod usage_total {
    /// A builder for [`UsageTotal`](crate::model::UsageTotal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) usage: std::option::Option<std::vec::Vec<crate::model::Usage>>,
    }
    impl Builder {
        /// <p>The account ID of the account that usage data was retrieved for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the account that usage data was retrieved for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `usage`.
        ///
        /// To override the contents of this collection use [`set_usage`](Self::set_usage).
        ///
        /// <p>An object representing the total usage for an account.</p>
        pub fn usage(mut self, input: crate::model::Usage) -> Self {
            let mut v = self.usage.unwrap_or_default();
            v.push(input);
            self.usage = Some(v);
            self
        }
        /// <p>An object representing the total usage for an account.</p>
        pub fn set_usage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Usage>>,
        ) -> Self {
            self.usage = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageTotal`](crate::model::UsageTotal)
        pub fn build(self) -> crate::model::UsageTotal {
            crate::model::UsageTotal {
                account_id: self.account_id,
                usage: self.usage,
            }
        }
    }
}
impl UsageTotal {
    /// Creates a new builder-style object to manufacture [`UsageTotal`](crate::model::UsageTotal)
    pub fn builder() -> crate::model::usage_total::Builder {
        crate::model::usage_total::Builder::default()
    }
}

/// <p>Contains usage information about the cost of Amazon Inspector operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Usage {
    /// <p>The type scan.</p>
    pub r#type: std::option::Option<crate::model::UsageType>,
    /// <p>The total of usage.</p>
    pub total: f64,
    /// <p>The estimated monthly cost of Amazon Inspector.</p>
    pub estimated_monthly_cost: f64,
    /// <p>The currency type used when calculating usage data.</p>
    pub currency: std::option::Option<crate::model::Currency>,
}
impl Usage {
    /// <p>The type scan.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UsageType> {
        self.r#type.as_ref()
    }
    /// <p>The total of usage.</p>
    pub fn total(&self) -> f64 {
        self.total
    }
    /// <p>The estimated monthly cost of Amazon Inspector.</p>
    pub fn estimated_monthly_cost(&self) -> f64 {
        self.estimated_monthly_cost
    }
    /// <p>The currency type used when calculating usage data.</p>
    pub fn currency(&self) -> std::option::Option<&crate::model::Currency> {
        self.currency.as_ref()
    }
}
impl std::fmt::Debug for Usage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Usage");
        formatter.field("r#type", &self.r#type);
        formatter.field("total", &self.total);
        formatter.field("estimated_monthly_cost", &self.estimated_monthly_cost);
        formatter.field("currency", &self.currency);
        formatter.finish()
    }
}
/// See [`Usage`](crate::model::Usage)
pub mod usage {
    /// A builder for [`Usage`](crate::model::Usage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::UsageType>,
        pub(crate) total: std::option::Option<f64>,
        pub(crate) estimated_monthly_cost: std::option::Option<f64>,
        pub(crate) currency: std::option::Option<crate::model::Currency>,
    }
    impl Builder {
        /// <p>The type scan.</p>
        pub fn r#type(mut self, input: crate::model::UsageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type scan.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UsageType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The total of usage.</p>
        pub fn total(mut self, input: f64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total of usage.</p>
        pub fn set_total(mut self, input: std::option::Option<f64>) -> Self {
            self.total = input;
            self
        }
        /// <p>The estimated monthly cost of Amazon Inspector.</p>
        pub fn estimated_monthly_cost(mut self, input: f64) -> Self {
            self.estimated_monthly_cost = Some(input);
            self
        }
        /// <p>The estimated monthly cost of Amazon Inspector.</p>
        pub fn set_estimated_monthly_cost(mut self, input: std::option::Option<f64>) -> Self {
            self.estimated_monthly_cost = input;
            self
        }
        /// <p>The currency type used when calculating usage data.</p>
        pub fn currency(mut self, input: crate::model::Currency) -> Self {
            self.currency = Some(input);
            self
        }
        /// <p>The currency type used when calculating usage data.</p>
        pub fn set_currency(mut self, input: std::option::Option<crate::model::Currency>) -> Self {
            self.currency = input;
            self
        }
        /// Consumes the builder and constructs a [`Usage`](crate::model::Usage)
        pub fn build(self) -> crate::model::Usage {
            crate::model::Usage {
                r#type: self.r#type,
                total: self.total.unwrap_or_default(),
                estimated_monthly_cost: self.estimated_monthly_cost.unwrap_or_default(),
                currency: self.currency,
            }
        }
    }
}
impl Usage {
    /// Creates a new builder-style object to manufacture [`Usage`](crate::model::Usage)
    pub fn builder() -> crate::model::usage::Builder {
        crate::model::usage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Currency {
    #[allow(missing_docs)] // documentation missing in model
    Usd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Currency {
    fn from(s: &str) -> Self {
        match s {
            "USD" => Currency::Usd,
            other => Currency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Currency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Currency::from(s))
    }
}
impl Currency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Currency::Usd => "USD",
            Currency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["USD"]
    }
}
impl AsRef<str> for Currency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2InstanceHours,
    #[allow(missing_docs)] // documentation missing in model
    EcrInitialScan,
    #[allow(missing_docs)] // documentation missing in model
    EcrRescan,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageType {
    fn from(s: &str) -> Self {
        match s {
            "EC2_INSTANCE_HOURS" => UsageType::Ec2InstanceHours,
            "ECR_INITIAL_SCAN" => UsageType::EcrInitialScan,
            "ECR_RESCAN" => UsageType::EcrRescan,
            other => UsageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageType::from(s))
    }
}
impl UsageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageType::Ec2InstanceHours => "EC2_INSTANCE_HOURS",
            UsageType::EcrInitialScan => "ECR_INITIAL_SCAN",
            UsageType::EcrRescan => "ECR_RESCAN",
            UsageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2_INSTANCE_HOURS", "ECR_INITIAL_SCAN", "ECR_RESCAN"]
    }
}
impl AsRef<str> for UsageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details on a member account in your organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Member {
    /// <p>The Amazon Web Services account ID of the member account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The status of the member account.</p>
    pub relationship_status: std::option::Option<crate::model::RelationshipStatus>,
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.</p>
    pub delegated_admin_account_id: std::option::Option<std::string::String>,
    /// <p>A timestamp showing when the status of this member was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl Member {
    /// <p>The Amazon Web Services account ID of the member account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The status of the member account.</p>
    pub fn relationship_status(&self) -> std::option::Option<&crate::model::RelationshipStatus> {
        self.relationship_status.as_ref()
    }
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.</p>
    pub fn delegated_admin_account_id(&self) -> std::option::Option<&str> {
        self.delegated_admin_account_id.as_deref()
    }
    /// <p>A timestamp showing when the status of this member was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for Member {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Member");
        formatter.field("account_id", &self.account_id);
        formatter.field("relationship_status", &self.relationship_status);
        formatter.field(
            "delegated_admin_account_id",
            &self.delegated_admin_account_id,
        );
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Member`](crate::model::Member)
pub mod member {
    /// A builder for [`Member`](crate::model::Member)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) relationship_status: std::option::Option<crate::model::RelationshipStatus>,
        pub(crate) delegated_admin_account_id: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The status of the member account.</p>
        pub fn relationship_status(mut self, input: crate::model::RelationshipStatus) -> Self {
            self.relationship_status = Some(input);
            self
        }
        /// <p>The status of the member account.</p>
        pub fn set_relationship_status(
            mut self,
            input: std::option::Option<crate::model::RelationshipStatus>,
        ) -> Self {
            self.relationship_status = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.</p>
        pub fn delegated_admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegated_admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for this member account.</p>
        pub fn set_delegated_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegated_admin_account_id = input;
            self
        }
        /// <p>A timestamp showing when the status of this member was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>A timestamp showing when the status of this member was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Member`](crate::model::Member)
        pub fn build(self) -> crate::model::Member {
            crate::model::Member {
                account_id: self.account_id,
                relationship_status: self.relationship_status,
                delegated_admin_account_id: self.delegated_admin_account_id,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Member {
    /// Creates a new builder-style object to manufacture [`Member`](crate::model::Member)
    pub fn builder() -> crate::model::member::Builder {
        crate::model::member::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationshipStatus {
    #[allow(missing_docs)] // documentation missing in model
    AccountSuspended,
    #[allow(missing_docs)] // documentation missing in model
    CannotCreateDetectorInOrgMaster,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    EmailVerificationFailed,
    #[allow(missing_docs)] // documentation missing in model
    EmailVerificationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Invited,
    #[allow(missing_docs)] // documentation missing in model
    RegionDisabled,
    #[allow(missing_docs)] // documentation missing in model
    Removed,
    #[allow(missing_docs)] // documentation missing in model
    Resigned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationshipStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_SUSPENDED" => RelationshipStatus::AccountSuspended,
            "CANNOT_CREATE_DETECTOR_IN_ORG_MASTER" => {
                RelationshipStatus::CannotCreateDetectorInOrgMaster
            }
            "CREATED" => RelationshipStatus::Created,
            "DELETED" => RelationshipStatus::Deleted,
            "DISABLED" => RelationshipStatus::Disabled,
            "EMAIL_VERIFICATION_FAILED" => RelationshipStatus::EmailVerificationFailed,
            "EMAIL_VERIFICATION_IN_PROGRESS" => RelationshipStatus::EmailVerificationInProgress,
            "ENABLED" => RelationshipStatus::Enabled,
            "INVITED" => RelationshipStatus::Invited,
            "REGION_DISABLED" => RelationshipStatus::RegionDisabled,
            "REMOVED" => RelationshipStatus::Removed,
            "RESIGNED" => RelationshipStatus::Resigned,
            other => RelationshipStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationshipStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationshipStatus::from(s))
    }
}
impl RelationshipStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationshipStatus::AccountSuspended => "ACCOUNT_SUSPENDED",
            RelationshipStatus::CannotCreateDetectorInOrgMaster => {
                "CANNOT_CREATE_DETECTOR_IN_ORG_MASTER"
            }
            RelationshipStatus::Created => "CREATED",
            RelationshipStatus::Deleted => "DELETED",
            RelationshipStatus::Disabled => "DISABLED",
            RelationshipStatus::EmailVerificationFailed => "EMAIL_VERIFICATION_FAILED",
            RelationshipStatus::EmailVerificationInProgress => "EMAIL_VERIFICATION_IN_PROGRESS",
            RelationshipStatus::Enabled => "ENABLED",
            RelationshipStatus::Invited => "INVITED",
            RelationshipStatus::RegionDisabled => "REGION_DISABLED",
            RelationshipStatus::Removed => "REMOVED",
            RelationshipStatus::Resigned => "RESIGNED",
            RelationshipStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_SUSPENDED",
            "CANNOT_CREATE_DETECTOR_IN_ORG_MASTER",
            "CREATED",
            "DELETED",
            "DISABLED",
            "EMAIL_VERIFICATION_FAILED",
            "EMAIL_VERIFICATION_IN_PROGRESS",
            "ENABLED",
            "INVITED",
            "REGION_DISABLED",
            "REMOVED",
            "RESIGNED",
        ]
    }
}
impl AsRef<str> for RelationshipStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about an Amazon Inspector finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Finding {
    /// <p>The Amazon Resource Number (ARN) of the finding.</p>
    pub finding_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID associated with the finding.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The type of the finding.</p>
    pub r#type: std::option::Option<crate::model::FindingType>,
    /// <p>The description of the finding.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The title of the finding.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>An object that contains the details about how to remediate a finding.</p>
    pub remediation: std::option::Option<crate::model::Remediation>,
    /// <p>The severity of the finding.</p>
    pub severity: std::option::Option<crate::model::Severity>,
    /// <p>The date and time that the finding was first observed.</p>
    pub first_observed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the finding was last observed.</p>
    pub last_observed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the finding was last updated at.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the finding.</p>
    pub status: std::option::Option<crate::model::FindingStatus>,
    /// <p>Contains information on the resources involved in a finding.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>The Amazon Inspector score given to the finding.</p>
    pub inspector_score: std::option::Option<f64>,
    /// <p>An object that contains details of the Amazon Inspector score.</p>
    pub inspector_score_details: std::option::Option<crate::model::InspectorScoreDetails>,
    /// <p>An object that contains the details of a network reachability finding.</p>
    pub network_reachability_details: std::option::Option<crate::model::NetworkReachabilityDetails>,
    /// <p>An object that contains the details of a package vulnerability finding.</p>
    pub package_vulnerability_details:
        std::option::Option<crate::model::PackageVulnerabilityDetails>,
}
impl Finding {
    /// <p>The Amazon Resource Number (ARN) of the finding.</p>
    pub fn finding_arn(&self) -> std::option::Option<&str> {
        self.finding_arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID associated with the finding.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The type of the finding.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FindingType> {
        self.r#type.as_ref()
    }
    /// <p>The description of the finding.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The title of the finding.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>An object that contains the details about how to remediate a finding.</p>
    pub fn remediation(&self) -> std::option::Option<&crate::model::Remediation> {
        self.remediation.as_ref()
    }
    /// <p>The severity of the finding.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::Severity> {
        self.severity.as_ref()
    }
    /// <p>The date and time that the finding was first observed.</p>
    pub fn first_observed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.first_observed_at.as_ref()
    }
    /// <p>The date and time that the finding was last observed.</p>
    pub fn last_observed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_observed_at.as_ref()
    }
    /// <p>The date and time the finding was last updated at.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The status of the finding.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FindingStatus> {
        self.status.as_ref()
    }
    /// <p>Contains information on the resources involved in a finding.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>The Amazon Inspector score given to the finding.</p>
    pub fn inspector_score(&self) -> std::option::Option<f64> {
        self.inspector_score
    }
    /// <p>An object that contains details of the Amazon Inspector score.</p>
    pub fn inspector_score_details(
        &self,
    ) -> std::option::Option<&crate::model::InspectorScoreDetails> {
        self.inspector_score_details.as_ref()
    }
    /// <p>An object that contains the details of a network reachability finding.</p>
    pub fn network_reachability_details(
        &self,
    ) -> std::option::Option<&crate::model::NetworkReachabilityDetails> {
        self.network_reachability_details.as_ref()
    }
    /// <p>An object that contains the details of a package vulnerability finding.</p>
    pub fn package_vulnerability_details(
        &self,
    ) -> std::option::Option<&crate::model::PackageVulnerabilityDetails> {
        self.package_vulnerability_details.as_ref()
    }
}
impl std::fmt::Debug for Finding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Finding");
        formatter.field("finding_arn", &self.finding_arn);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("title", &self.title);
        formatter.field("remediation", &self.remediation);
        formatter.field("severity", &self.severity);
        formatter.field("first_observed_at", &self.first_observed_at);
        formatter.field("last_observed_at", &self.last_observed_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("status", &self.status);
        formatter.field("resources", &self.resources);
        formatter.field("inspector_score", &self.inspector_score);
        formatter.field("inspector_score_details", &self.inspector_score_details);
        formatter.field(
            "network_reachability_details",
            &self.network_reachability_details,
        );
        formatter.field(
            "package_vulnerability_details",
            &self.package_vulnerability_details,
        );
        formatter.finish()
    }
}
/// See [`Finding`](crate::model::Finding)
pub mod finding {
    /// A builder for [`Finding`](crate::model::Finding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_arn: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FindingType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) remediation: std::option::Option<crate::model::Remediation>,
        pub(crate) severity: std::option::Option<crate::model::Severity>,
        pub(crate) first_observed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_observed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::FindingStatus>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) inspector_score: std::option::Option<f64>,
        pub(crate) inspector_score_details:
            std::option::Option<crate::model::InspectorScoreDetails>,
        pub(crate) network_reachability_details:
            std::option::Option<crate::model::NetworkReachabilityDetails>,
        pub(crate) package_vulnerability_details:
            std::option::Option<crate::model::PackageVulnerabilityDetails>,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) of the finding.</p>
        pub fn finding_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.finding_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the finding.</p>
        pub fn set_finding_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.finding_arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID associated with the finding.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the finding.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The type of the finding.</p>
        pub fn r#type(mut self, input: crate::model::FindingType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the finding.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FindingType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the finding.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the finding.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The title of the finding.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the finding.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>An object that contains the details about how to remediate a finding.</p>
        pub fn remediation(mut self, input: crate::model::Remediation) -> Self {
            self.remediation = Some(input);
            self
        }
        /// <p>An object that contains the details about how to remediate a finding.</p>
        pub fn set_remediation(
            mut self,
            input: std::option::Option<crate::model::Remediation>,
        ) -> Self {
            self.remediation = input;
            self
        }
        /// <p>The severity of the finding.</p>
        pub fn severity(mut self, input: crate::model::Severity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the finding.</p>
        pub fn set_severity(mut self, input: std::option::Option<crate::model::Severity>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The date and time that the finding was first observed.</p>
        pub fn first_observed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.first_observed_at = Some(input);
            self
        }
        /// <p>The date and time that the finding was first observed.</p>
        pub fn set_first_observed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.first_observed_at = input;
            self
        }
        /// <p>The date and time that the finding was last observed.</p>
        pub fn last_observed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_observed_at = Some(input);
            self
        }
        /// <p>The date and time that the finding was last observed.</p>
        pub fn set_last_observed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_observed_at = input;
            self
        }
        /// <p>The date and time the finding was last updated at.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time the finding was last updated at.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The status of the finding.</p>
        pub fn status(mut self, input: crate::model::FindingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the finding.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FindingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Contains information on the resources involved in a finding.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>Contains information on the resources involved in a finding.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>The Amazon Inspector score given to the finding.</p>
        pub fn inspector_score(mut self, input: f64) -> Self {
            self.inspector_score = Some(input);
            self
        }
        /// <p>The Amazon Inspector score given to the finding.</p>
        pub fn set_inspector_score(mut self, input: std::option::Option<f64>) -> Self {
            self.inspector_score = input;
            self
        }
        /// <p>An object that contains details of the Amazon Inspector score.</p>
        pub fn inspector_score_details(
            mut self,
            input: crate::model::InspectorScoreDetails,
        ) -> Self {
            self.inspector_score_details = Some(input);
            self
        }
        /// <p>An object that contains details of the Amazon Inspector score.</p>
        pub fn set_inspector_score_details(
            mut self,
            input: std::option::Option<crate::model::InspectorScoreDetails>,
        ) -> Self {
            self.inspector_score_details = input;
            self
        }
        /// <p>An object that contains the details of a network reachability finding.</p>
        pub fn network_reachability_details(
            mut self,
            input: crate::model::NetworkReachabilityDetails,
        ) -> Self {
            self.network_reachability_details = Some(input);
            self
        }
        /// <p>An object that contains the details of a network reachability finding.</p>
        pub fn set_network_reachability_details(
            mut self,
            input: std::option::Option<crate::model::NetworkReachabilityDetails>,
        ) -> Self {
            self.network_reachability_details = input;
            self
        }
        /// <p>An object that contains the details of a package vulnerability finding.</p>
        pub fn package_vulnerability_details(
            mut self,
            input: crate::model::PackageVulnerabilityDetails,
        ) -> Self {
            self.package_vulnerability_details = Some(input);
            self
        }
        /// <p>An object that contains the details of a package vulnerability finding.</p>
        pub fn set_package_vulnerability_details(
            mut self,
            input: std::option::Option<crate::model::PackageVulnerabilityDetails>,
        ) -> Self {
            self.package_vulnerability_details = input;
            self
        }
        /// Consumes the builder and constructs a [`Finding`](crate::model::Finding)
        pub fn build(self) -> crate::model::Finding {
            crate::model::Finding {
                finding_arn: self.finding_arn,
                aws_account_id: self.aws_account_id,
                r#type: self.r#type,
                description: self.description,
                title: self.title,
                remediation: self.remediation,
                severity: self.severity,
                first_observed_at: self.first_observed_at,
                last_observed_at: self.last_observed_at,
                updated_at: self.updated_at,
                status: self.status,
                resources: self.resources,
                inspector_score: self.inspector_score,
                inspector_score_details: self.inspector_score_details,
                network_reachability_details: self.network_reachability_details,
                package_vulnerability_details: self.package_vulnerability_details,
            }
        }
    }
}
impl Finding {
    /// Creates a new builder-style object to manufacture [`Finding`](crate::model::Finding)
    pub fn builder() -> crate::model::finding::Builder {
        crate::model::finding::Builder::default()
    }
}

/// <p>Information about a package vulnerability finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageVulnerabilityDetails {
    /// <p>The ID given to this vulnerability.</p>
    pub vulnerability_id: std::option::Option<std::string::String>,
    /// <p>The packages impacted by this vulnerability.</p>
    pub vulnerable_packages: std::option::Option<std::vec::Vec<crate::model::VulnerablePackage>>,
    /// <p>The source of the vulnerability information.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>An object that contains details about the CVSS score of a finding.</p>
    pub cvss: std::option::Option<std::vec::Vec<crate::model::CvssScore>>,
    /// <p>One or more vulnerabilities related to the one identified in this finding.</p>
    pub related_vulnerabilities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A URL to the source of the vulnerability information.</p>
    pub source_url: std::option::Option<std::string::String>,
    /// <p>The severity the vendor has given to this vulnerability type.</p>
    pub vendor_severity: std::option::Option<std::string::String>,
    /// <p>The date and time that this vulnerability was first added to the vendor's database.</p>
    pub vendor_created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the vendor last updated this vulnerability in their database.</p>
    pub vendor_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>One or more URLs that contain details about this vulnerability type.</p>
    pub reference_urls: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PackageVulnerabilityDetails {
    /// <p>The ID given to this vulnerability.</p>
    pub fn vulnerability_id(&self) -> std::option::Option<&str> {
        self.vulnerability_id.as_deref()
    }
    /// <p>The packages impacted by this vulnerability.</p>
    pub fn vulnerable_packages(&self) -> std::option::Option<&[crate::model::VulnerablePackage]> {
        self.vulnerable_packages.as_deref()
    }
    /// <p>The source of the vulnerability information.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>An object that contains details about the CVSS score of a finding.</p>
    pub fn cvss(&self) -> std::option::Option<&[crate::model::CvssScore]> {
        self.cvss.as_deref()
    }
    /// <p>One or more vulnerabilities related to the one identified in this finding.</p>
    pub fn related_vulnerabilities(&self) -> std::option::Option<&[std::string::String]> {
        self.related_vulnerabilities.as_deref()
    }
    /// <p>A URL to the source of the vulnerability information.</p>
    pub fn source_url(&self) -> std::option::Option<&str> {
        self.source_url.as_deref()
    }
    /// <p>The severity the vendor has given to this vulnerability type.</p>
    pub fn vendor_severity(&self) -> std::option::Option<&str> {
        self.vendor_severity.as_deref()
    }
    /// <p>The date and time that this vulnerability was first added to the vendor's database.</p>
    pub fn vendor_created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.vendor_created_at.as_ref()
    }
    /// <p>The date and time the vendor last updated this vulnerability in their database.</p>
    pub fn vendor_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.vendor_updated_at.as_ref()
    }
    /// <p>One or more URLs that contain details about this vulnerability type.</p>
    pub fn reference_urls(&self) -> std::option::Option<&[std::string::String]> {
        self.reference_urls.as_deref()
    }
}
impl std::fmt::Debug for PackageVulnerabilityDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageVulnerabilityDetails");
        formatter.field("vulnerability_id", &self.vulnerability_id);
        formatter.field("vulnerable_packages", &self.vulnerable_packages);
        formatter.field("source", &self.source);
        formatter.field("cvss", &self.cvss);
        formatter.field("related_vulnerabilities", &self.related_vulnerabilities);
        formatter.field("source_url", &self.source_url);
        formatter.field("vendor_severity", &self.vendor_severity);
        formatter.field("vendor_created_at", &self.vendor_created_at);
        formatter.field("vendor_updated_at", &self.vendor_updated_at);
        formatter.field("reference_urls", &self.reference_urls);
        formatter.finish()
    }
}
/// See [`PackageVulnerabilityDetails`](crate::model::PackageVulnerabilityDetails)
pub mod package_vulnerability_details {
    /// A builder for [`PackageVulnerabilityDetails`](crate::model::PackageVulnerabilityDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vulnerability_id: std::option::Option<std::string::String>,
        pub(crate) vulnerable_packages:
            std::option::Option<std::vec::Vec<crate::model::VulnerablePackage>>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) cvss: std::option::Option<std::vec::Vec<crate::model::CvssScore>>,
        pub(crate) related_vulnerabilities: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_url: std::option::Option<std::string::String>,
        pub(crate) vendor_severity: std::option::Option<std::string::String>,
        pub(crate) vendor_created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) vendor_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) reference_urls: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID given to this vulnerability.</p>
        pub fn vulnerability_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vulnerability_id = Some(input.into());
            self
        }
        /// <p>The ID given to this vulnerability.</p>
        pub fn set_vulnerability_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vulnerability_id = input;
            self
        }
        /// Appends an item to `vulnerable_packages`.
        ///
        /// To override the contents of this collection use [`set_vulnerable_packages`](Self::set_vulnerable_packages).
        ///
        /// <p>The packages impacted by this vulnerability.</p>
        pub fn vulnerable_packages(mut self, input: crate::model::VulnerablePackage) -> Self {
            let mut v = self.vulnerable_packages.unwrap_or_default();
            v.push(input);
            self.vulnerable_packages = Some(v);
            self
        }
        /// <p>The packages impacted by this vulnerability.</p>
        pub fn set_vulnerable_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VulnerablePackage>>,
        ) -> Self {
            self.vulnerable_packages = input;
            self
        }
        /// <p>The source of the vulnerability information.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the vulnerability information.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `cvss`.
        ///
        /// To override the contents of this collection use [`set_cvss`](Self::set_cvss).
        ///
        /// <p>An object that contains details about the CVSS score of a finding.</p>
        pub fn cvss(mut self, input: crate::model::CvssScore) -> Self {
            let mut v = self.cvss.unwrap_or_default();
            v.push(input);
            self.cvss = Some(v);
            self
        }
        /// <p>An object that contains details about the CVSS score of a finding.</p>
        pub fn set_cvss(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CvssScore>>,
        ) -> Self {
            self.cvss = input;
            self
        }
        /// Appends an item to `related_vulnerabilities`.
        ///
        /// To override the contents of this collection use [`set_related_vulnerabilities`](Self::set_related_vulnerabilities).
        ///
        /// <p>One or more vulnerabilities related to the one identified in this finding.</p>
        pub fn related_vulnerabilities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.related_vulnerabilities.unwrap_or_default();
            v.push(input.into());
            self.related_vulnerabilities = Some(v);
            self
        }
        /// <p>One or more vulnerabilities related to the one identified in this finding.</p>
        pub fn set_related_vulnerabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.related_vulnerabilities = input;
            self
        }
        /// <p>A URL to the source of the vulnerability information.</p>
        pub fn source_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_url = Some(input.into());
            self
        }
        /// <p>A URL to the source of the vulnerability information.</p>
        pub fn set_source_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_url = input;
            self
        }
        /// <p>The severity the vendor has given to this vulnerability type.</p>
        pub fn vendor_severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.vendor_severity = Some(input.into());
            self
        }
        /// <p>The severity the vendor has given to this vulnerability type.</p>
        pub fn set_vendor_severity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vendor_severity = input;
            self
        }
        /// <p>The date and time that this vulnerability was first added to the vendor's database.</p>
        pub fn vendor_created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.vendor_created_at = Some(input);
            self
        }
        /// <p>The date and time that this vulnerability was first added to the vendor's database.</p>
        pub fn set_vendor_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.vendor_created_at = input;
            self
        }
        /// <p>The date and time the vendor last updated this vulnerability in their database.</p>
        pub fn vendor_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.vendor_updated_at = Some(input);
            self
        }
        /// <p>The date and time the vendor last updated this vulnerability in their database.</p>
        pub fn set_vendor_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.vendor_updated_at = input;
            self
        }
        /// Appends an item to `reference_urls`.
        ///
        /// To override the contents of this collection use [`set_reference_urls`](Self::set_reference_urls).
        ///
        /// <p>One or more URLs that contain details about this vulnerability type.</p>
        pub fn reference_urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reference_urls.unwrap_or_default();
            v.push(input.into());
            self.reference_urls = Some(v);
            self
        }
        /// <p>One or more URLs that contain details about this vulnerability type.</p>
        pub fn set_reference_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reference_urls = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageVulnerabilityDetails`](crate::model::PackageVulnerabilityDetails)
        pub fn build(self) -> crate::model::PackageVulnerabilityDetails {
            crate::model::PackageVulnerabilityDetails {
                vulnerability_id: self.vulnerability_id,
                vulnerable_packages: self.vulnerable_packages,
                source: self.source,
                cvss: self.cvss,
                related_vulnerabilities: self.related_vulnerabilities,
                source_url: self.source_url,
                vendor_severity: self.vendor_severity,
                vendor_created_at: self.vendor_created_at,
                vendor_updated_at: self.vendor_updated_at,
                reference_urls: self.reference_urls,
            }
        }
    }
}
impl PackageVulnerabilityDetails {
    /// Creates a new builder-style object to manufacture [`PackageVulnerabilityDetails`](crate::model::PackageVulnerabilityDetails)
    pub fn builder() -> crate::model::package_vulnerability_details::Builder {
        crate::model::package_vulnerability_details::Builder::default()
    }
}

/// <p>The CVSS score for a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CvssScore {
    /// <p>The base CVSS score used for the finding.</p>
    pub base_score: std::option::Option<f64>,
    /// <p>The vector string of the CVSS score.</p>
    pub scoring_vector: std::option::Option<std::string::String>,
    /// <p>The version of CVSS used for the score.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The source of the CVSS score.</p>
    pub source: std::option::Option<std::string::String>,
}
impl CvssScore {
    /// <p>The base CVSS score used for the finding.</p>
    pub fn base_score(&self) -> std::option::Option<f64> {
        self.base_score
    }
    /// <p>The vector string of the CVSS score.</p>
    pub fn scoring_vector(&self) -> std::option::Option<&str> {
        self.scoring_vector.as_deref()
    }
    /// <p>The version of CVSS used for the score.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The source of the CVSS score.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
}
impl std::fmt::Debug for CvssScore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CvssScore");
        formatter.field("base_score", &self.base_score);
        formatter.field("scoring_vector", &self.scoring_vector);
        formatter.field("version", &self.version);
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`CvssScore`](crate::model::CvssScore)
pub mod cvss_score {
    /// A builder for [`CvssScore`](crate::model::CvssScore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_score: std::option::Option<f64>,
        pub(crate) scoring_vector: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The base CVSS score used for the finding.</p>
        pub fn base_score(mut self, input: f64) -> Self {
            self.base_score = Some(input);
            self
        }
        /// <p>The base CVSS score used for the finding.</p>
        pub fn set_base_score(mut self, input: std::option::Option<f64>) -> Self {
            self.base_score = input;
            self
        }
        /// <p>The vector string of the CVSS score.</p>
        pub fn scoring_vector(mut self, input: impl Into<std::string::String>) -> Self {
            self.scoring_vector = Some(input.into());
            self
        }
        /// <p>The vector string of the CVSS score.</p>
        pub fn set_scoring_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scoring_vector = input;
            self
        }
        /// <p>The version of CVSS used for the score.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of CVSS used for the score.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The source of the CVSS score.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the CVSS score.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`CvssScore`](crate::model::CvssScore)
        pub fn build(self) -> crate::model::CvssScore {
            crate::model::CvssScore {
                base_score: self.base_score,
                scoring_vector: self.scoring_vector,
                version: self.version,
                source: self.source,
            }
        }
    }
}
impl CvssScore {
    /// Creates a new builder-style object to manufacture [`CvssScore`](crate::model::CvssScore)
    pub fn builder() -> crate::model::cvss_score::Builder {
        crate::model::cvss_score::Builder::default()
    }
}

/// <p>Information on the vulnerable package identified by a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VulnerablePackage {
    /// <p>The name of the vulnerable package.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the vulnerable package.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The source layer hash of the vulnerable package.</p>
    pub source_layer_hash: std::option::Option<std::string::String>,
    /// <p>The epoch of the vulnerable package.</p>
    pub epoch: i32,
    /// <p>The release of the vulnerable package.</p>
    pub release: std::option::Option<std::string::String>,
    /// <p>The architecture of the vulnerable package.</p>
    pub arch: std::option::Option<std::string::String>,
    /// <p>The package manager of the vulnerable package.</p>
    pub package_manager: std::option::Option<crate::model::PackageManager>,
    /// <p>The file path of the vulnerable package.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The version of the package that contains the vulnerability fix.</p>
    pub fixed_in_version: std::option::Option<std::string::String>,
}
impl VulnerablePackage {
    /// <p>The name of the vulnerable package.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the vulnerable package.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The source layer hash of the vulnerable package.</p>
    pub fn source_layer_hash(&self) -> std::option::Option<&str> {
        self.source_layer_hash.as_deref()
    }
    /// <p>The epoch of the vulnerable package.</p>
    pub fn epoch(&self) -> i32 {
        self.epoch
    }
    /// <p>The release of the vulnerable package.</p>
    pub fn release(&self) -> std::option::Option<&str> {
        self.release.as_deref()
    }
    /// <p>The architecture of the vulnerable package.</p>
    pub fn arch(&self) -> std::option::Option<&str> {
        self.arch.as_deref()
    }
    /// <p>The package manager of the vulnerable package.</p>
    pub fn package_manager(&self) -> std::option::Option<&crate::model::PackageManager> {
        self.package_manager.as_ref()
    }
    /// <p>The file path of the vulnerable package.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The version of the package that contains the vulnerability fix.</p>
    pub fn fixed_in_version(&self) -> std::option::Option<&str> {
        self.fixed_in_version.as_deref()
    }
}
impl std::fmt::Debug for VulnerablePackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VulnerablePackage");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("source_layer_hash", &self.source_layer_hash);
        formatter.field("epoch", &self.epoch);
        formatter.field("release", &self.release);
        formatter.field("arch", &self.arch);
        formatter.field("package_manager", &self.package_manager);
        formatter.field("file_path", &self.file_path);
        formatter.field("fixed_in_version", &self.fixed_in_version);
        formatter.finish()
    }
}
/// See [`VulnerablePackage`](crate::model::VulnerablePackage)
pub mod vulnerable_package {
    /// A builder for [`VulnerablePackage`](crate::model::VulnerablePackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) source_layer_hash: std::option::Option<std::string::String>,
        pub(crate) epoch: std::option::Option<i32>,
        pub(crate) release: std::option::Option<std::string::String>,
        pub(crate) arch: std::option::Option<std::string::String>,
        pub(crate) package_manager: std::option::Option<crate::model::PackageManager>,
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) fixed_in_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the vulnerable package.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the vulnerable package.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the vulnerable package.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the vulnerable package.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The source layer hash of the vulnerable package.</p>
        pub fn source_layer_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_layer_hash = Some(input.into());
            self
        }
        /// <p>The source layer hash of the vulnerable package.</p>
        pub fn set_source_layer_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_layer_hash = input;
            self
        }
        /// <p>The epoch of the vulnerable package.</p>
        pub fn epoch(mut self, input: i32) -> Self {
            self.epoch = Some(input);
            self
        }
        /// <p>The epoch of the vulnerable package.</p>
        pub fn set_epoch(mut self, input: std::option::Option<i32>) -> Self {
            self.epoch = input;
            self
        }
        /// <p>The release of the vulnerable package.</p>
        pub fn release(mut self, input: impl Into<std::string::String>) -> Self {
            self.release = Some(input.into());
            self
        }
        /// <p>The release of the vulnerable package.</p>
        pub fn set_release(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.release = input;
            self
        }
        /// <p>The architecture of the vulnerable package.</p>
        pub fn arch(mut self, input: impl Into<std::string::String>) -> Self {
            self.arch = Some(input.into());
            self
        }
        /// <p>The architecture of the vulnerable package.</p>
        pub fn set_arch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arch = input;
            self
        }
        /// <p>The package manager of the vulnerable package.</p>
        pub fn package_manager(mut self, input: crate::model::PackageManager) -> Self {
            self.package_manager = Some(input);
            self
        }
        /// <p>The package manager of the vulnerable package.</p>
        pub fn set_package_manager(
            mut self,
            input: std::option::Option<crate::model::PackageManager>,
        ) -> Self {
            self.package_manager = input;
            self
        }
        /// <p>The file path of the vulnerable package.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The file path of the vulnerable package.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The version of the package that contains the vulnerability fix.</p>
        pub fn fixed_in_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.fixed_in_version = Some(input.into());
            self
        }
        /// <p>The version of the package that contains the vulnerability fix.</p>
        pub fn set_fixed_in_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fixed_in_version = input;
            self
        }
        /// Consumes the builder and constructs a [`VulnerablePackage`](crate::model::VulnerablePackage)
        pub fn build(self) -> crate::model::VulnerablePackage {
            crate::model::VulnerablePackage {
                name: self.name,
                version: self.version,
                source_layer_hash: self.source_layer_hash,
                epoch: self.epoch.unwrap_or_default(),
                release: self.release,
                arch: self.arch,
                package_manager: self.package_manager,
                file_path: self.file_path,
                fixed_in_version: self.fixed_in_version,
            }
        }
    }
}
impl VulnerablePackage {
    /// Creates a new builder-style object to manufacture [`VulnerablePackage`](crate::model::VulnerablePackage)
    pub fn builder() -> crate::model::vulnerable_package::Builder {
        crate::model::vulnerable_package::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageManager {
    #[allow(missing_docs)] // documentation missing in model
    Bundler,
    #[allow(missing_docs)] // documentation missing in model
    Cargo,
    #[allow(missing_docs)] // documentation missing in model
    Composer,
    #[allow(missing_docs)] // documentation missing in model
    Gobinary,
    #[allow(missing_docs)] // documentation missing in model
    Gomod,
    #[allow(missing_docs)] // documentation missing in model
    Jar,
    #[allow(missing_docs)] // documentation missing in model
    Npm,
    #[allow(missing_docs)] // documentation missing in model
    Nuget,
    #[allow(missing_docs)] // documentation missing in model
    Os,
    #[allow(missing_docs)] // documentation missing in model
    Pipenv,
    #[allow(missing_docs)] // documentation missing in model
    Poetry,
    #[allow(missing_docs)] // documentation missing in model
    Yarn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageManager {
    fn from(s: &str) -> Self {
        match s {
            "BUNDLER" => PackageManager::Bundler,
            "CARGO" => PackageManager::Cargo,
            "COMPOSER" => PackageManager::Composer,
            "GOBINARY" => PackageManager::Gobinary,
            "GOMOD" => PackageManager::Gomod,
            "JAR" => PackageManager::Jar,
            "NPM" => PackageManager::Npm,
            "NUGET" => PackageManager::Nuget,
            "OS" => PackageManager::Os,
            "PIPENV" => PackageManager::Pipenv,
            "POETRY" => PackageManager::Poetry,
            "YARN" => PackageManager::Yarn,
            other => PackageManager::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageManager {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageManager::from(s))
    }
}
impl PackageManager {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageManager::Bundler => "BUNDLER",
            PackageManager::Cargo => "CARGO",
            PackageManager::Composer => "COMPOSER",
            PackageManager::Gobinary => "GOBINARY",
            PackageManager::Gomod => "GOMOD",
            PackageManager::Jar => "JAR",
            PackageManager::Npm => "NPM",
            PackageManager::Nuget => "NUGET",
            PackageManager::Os => "OS",
            PackageManager::Pipenv => "PIPENV",
            PackageManager::Poetry => "POETRY",
            PackageManager::Yarn => "YARN",
            PackageManager::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BUNDLER", "CARGO", "COMPOSER", "GOBINARY", "GOMOD", "JAR", "NPM", "NUGET", "OS",
            "PIPENV", "POETRY", "YARN",
        ]
    }
}
impl AsRef<str> for PackageManager {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the details of a network reachability finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkReachabilityDetails {
    /// <p>An object that contains details about the open port range associated with a finding.</p>
    pub open_port_range: std::option::Option<crate::model::PortRange>,
    /// <p>The protocol associated with a finding.</p>
    pub protocol: std::option::Option<crate::model::NetworkProtocol>,
    /// <p>An object that contains details about a network path associated with a finding.</p>
    pub network_path: std::option::Option<crate::model::NetworkPath>,
}
impl NetworkReachabilityDetails {
    /// <p>An object that contains details about the open port range associated with a finding.</p>
    pub fn open_port_range(&self) -> std::option::Option<&crate::model::PortRange> {
        self.open_port_range.as_ref()
    }
    /// <p>The protocol associated with a finding.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::NetworkProtocol> {
        self.protocol.as_ref()
    }
    /// <p>An object that contains details about a network path associated with a finding.</p>
    pub fn network_path(&self) -> std::option::Option<&crate::model::NetworkPath> {
        self.network_path.as_ref()
    }
}
impl std::fmt::Debug for NetworkReachabilityDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkReachabilityDetails");
        formatter.field("open_port_range", &self.open_port_range);
        formatter.field("protocol", &self.protocol);
        formatter.field("network_path", &self.network_path);
        formatter.finish()
    }
}
/// See [`NetworkReachabilityDetails`](crate::model::NetworkReachabilityDetails)
pub mod network_reachability_details {
    /// A builder for [`NetworkReachabilityDetails`](crate::model::NetworkReachabilityDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_port_range: std::option::Option<crate::model::PortRange>,
        pub(crate) protocol: std::option::Option<crate::model::NetworkProtocol>,
        pub(crate) network_path: std::option::Option<crate::model::NetworkPath>,
    }
    impl Builder {
        /// <p>An object that contains details about the open port range associated with a finding.</p>
        pub fn open_port_range(mut self, input: crate::model::PortRange) -> Self {
            self.open_port_range = Some(input);
            self
        }
        /// <p>An object that contains details about the open port range associated with a finding.</p>
        pub fn set_open_port_range(
            mut self,
            input: std::option::Option<crate::model::PortRange>,
        ) -> Self {
            self.open_port_range = input;
            self
        }
        /// <p>The protocol associated with a finding.</p>
        pub fn protocol(mut self, input: crate::model::NetworkProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol associated with a finding.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::NetworkProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>An object that contains details about a network path associated with a finding.</p>
        pub fn network_path(mut self, input: crate::model::NetworkPath) -> Self {
            self.network_path = Some(input);
            self
        }
        /// <p>An object that contains details about a network path associated with a finding.</p>
        pub fn set_network_path(
            mut self,
            input: std::option::Option<crate::model::NetworkPath>,
        ) -> Self {
            self.network_path = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkReachabilityDetails`](crate::model::NetworkReachabilityDetails)
        pub fn build(self) -> crate::model::NetworkReachabilityDetails {
            crate::model::NetworkReachabilityDetails {
                open_port_range: self.open_port_range,
                protocol: self.protocol,
                network_path: self.network_path,
            }
        }
    }
}
impl NetworkReachabilityDetails {
    /// Creates a new builder-style object to manufacture [`NetworkReachabilityDetails`](crate::model::NetworkReachabilityDetails)
    pub fn builder() -> crate::model::network_reachability_details::Builder {
        crate::model::network_reachability_details::Builder::default()
    }
}

/// <p>Information on the network path associated with a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkPath {
    /// <p>The details on the steps in the network path.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::Step>>,
}
impl NetworkPath {
    /// <p>The details on the steps in the network path.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::Step]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for NetworkPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkPath");
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`NetworkPath`](crate::model::NetworkPath)
pub mod network_path {
    /// A builder for [`NetworkPath`](crate::model::NetworkPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::Step>>,
    }
    impl Builder {
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>The details on the steps in the network path.</p>
        pub fn steps(mut self, input: crate::model::Step) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>The details on the steps in the network path.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Step>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkPath`](crate::model::NetworkPath)
        pub fn build(self) -> crate::model::NetworkPath {
            crate::model::NetworkPath { steps: self.steps }
        }
    }
}
impl NetworkPath {
    /// Creates a new builder-style object to manufacture [`NetworkPath`](crate::model::NetworkPath)
    pub fn builder() -> crate::model::network_path::Builder {
        crate::model::network_path::Builder::default()
    }
}

/// <p>Details about the step associated with a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Step {
    /// <p>The component ID.</p>
    pub component_id: std::option::Option<std::string::String>,
    /// <p>The component type.</p>
    pub component_type: std::option::Option<std::string::String>,
}
impl Step {
    /// <p>The component ID.</p>
    pub fn component_id(&self) -> std::option::Option<&str> {
        self.component_id.as_deref()
    }
    /// <p>The component type.</p>
    pub fn component_type(&self) -> std::option::Option<&str> {
        self.component_type.as_deref()
    }
}
impl std::fmt::Debug for Step {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Step");
        formatter.field("component_id", &self.component_id);
        formatter.field("component_type", &self.component_type);
        formatter.finish()
    }
}
/// See [`Step`](crate::model::Step)
pub mod step {
    /// A builder for [`Step`](crate::model::Step)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_id: std::option::Option<std::string::String>,
        pub(crate) component_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The component ID.</p>
        pub fn component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_id = Some(input.into());
            self
        }
        /// <p>The component ID.</p>
        pub fn set_component_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.component_id = input;
            self
        }
        /// <p>The component type.</p>
        pub fn component_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_type = Some(input.into());
            self
        }
        /// <p>The component type.</p>
        pub fn set_component_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Step`](crate::model::Step)
        pub fn build(self) -> crate::model::Step {
            crate::model::Step {
                component_id: self.component_id,
                component_type: self.component_type,
            }
        }
    }
}
impl Step {
    /// Creates a new builder-style object to manufacture [`Step`](crate::model::Step)
    pub fn builder() -> crate::model::step::Builder {
        crate::model::step::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkProtocol {
    fn from(s: &str) -> Self {
        match s {
            "TCP" => NetworkProtocol::Tcp,
            "UDP" => NetworkProtocol::Udp,
            other => NetworkProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkProtocol::from(s))
    }
}
impl NetworkProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkProtocol::Tcp => "TCP",
            NetworkProtocol::Udp => "UDP",
            NetworkProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TCP", "UDP"]
    }
}
impl AsRef<str> for NetworkProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the port range associated with a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortRange {
    /// <p>The beginning port in a port range.</p>
    pub begin: std::option::Option<i32>,
    /// <p>The ending port in a port range.</p>
    pub end: std::option::Option<i32>,
}
impl PortRange {
    /// <p>The beginning port in a port range.</p>
    pub fn begin(&self) -> std::option::Option<i32> {
        self.begin
    }
    /// <p>The ending port in a port range.</p>
    pub fn end(&self) -> std::option::Option<i32> {
        self.end
    }
}
impl std::fmt::Debug for PortRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortRange");
        formatter.field("begin", &self.begin);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`PortRange`](crate::model::PortRange)
pub mod port_range {
    /// A builder for [`PortRange`](crate::model::PortRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin: std::option::Option<i32>,
        pub(crate) end: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The beginning port in a port range.</p>
        pub fn begin(mut self, input: i32) -> Self {
            self.begin = Some(input);
            self
        }
        /// <p>The beginning port in a port range.</p>
        pub fn set_begin(mut self, input: std::option::Option<i32>) -> Self {
            self.begin = input;
            self
        }
        /// <p>The ending port in a port range.</p>
        pub fn end(mut self, input: i32) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The ending port in a port range.</p>
        pub fn set_end(mut self, input: std::option::Option<i32>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`PortRange`](crate::model::PortRange)
        pub fn build(self) -> crate::model::PortRange {
            crate::model::PortRange {
                begin: self.begin,
                end: self.end,
            }
        }
    }
}
impl PortRange {
    /// Creates a new builder-style object to manufacture [`PortRange`](crate::model::PortRange)
    pub fn builder() -> crate::model::port_range::Builder {
        crate::model::port_range::Builder::default()
    }
}

/// <p>Information about the Amazon Inspector score given to a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InspectorScoreDetails {
    /// <p>An object that contains details about the CVSS score given to a finding.</p>
    pub adjusted_cvss: std::option::Option<crate::model::CvssScoreDetails>,
}
impl InspectorScoreDetails {
    /// <p>An object that contains details about the CVSS score given to a finding.</p>
    pub fn adjusted_cvss(&self) -> std::option::Option<&crate::model::CvssScoreDetails> {
        self.adjusted_cvss.as_ref()
    }
}
impl std::fmt::Debug for InspectorScoreDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InspectorScoreDetails");
        formatter.field("adjusted_cvss", &self.adjusted_cvss);
        formatter.finish()
    }
}
/// See [`InspectorScoreDetails`](crate::model::InspectorScoreDetails)
pub mod inspector_score_details {
    /// A builder for [`InspectorScoreDetails`](crate::model::InspectorScoreDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adjusted_cvss: std::option::Option<crate::model::CvssScoreDetails>,
    }
    impl Builder {
        /// <p>An object that contains details about the CVSS score given to a finding.</p>
        pub fn adjusted_cvss(mut self, input: crate::model::CvssScoreDetails) -> Self {
            self.adjusted_cvss = Some(input);
            self
        }
        /// <p>An object that contains details about the CVSS score given to a finding.</p>
        pub fn set_adjusted_cvss(
            mut self,
            input: std::option::Option<crate::model::CvssScoreDetails>,
        ) -> Self {
            self.adjusted_cvss = input;
            self
        }
        /// Consumes the builder and constructs a [`InspectorScoreDetails`](crate::model::InspectorScoreDetails)
        pub fn build(self) -> crate::model::InspectorScoreDetails {
            crate::model::InspectorScoreDetails {
                adjusted_cvss: self.adjusted_cvss,
            }
        }
    }
}
impl InspectorScoreDetails {
    /// Creates a new builder-style object to manufacture [`InspectorScoreDetails`](crate::model::InspectorScoreDetails)
    pub fn builder() -> crate::model::inspector_score_details::Builder {
        crate::model::inspector_score_details::Builder::default()
    }
}

/// <p>Information about the CVSS score.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CvssScoreDetails {
    /// <p>The source for the CVSS score.</p>
    pub score_source: std::option::Option<std::string::String>,
    /// <p>The source of the CVSS data.</p>
    pub cvss_source: std::option::Option<std::string::String>,
    /// <p>The CVSS version used in scoring.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The CVSS score.</p>
    pub score: std::option::Option<f64>,
    /// <p>The vector for the CVSS score.</p>
    pub scoring_vector: std::option::Option<std::string::String>,
    /// <p>An object that contains details about adjustment Amazon Inspector made to the CVSS score.</p>
    pub adjustments: std::option::Option<std::vec::Vec<crate::model::CvssScoreAdjustment>>,
}
impl CvssScoreDetails {
    /// <p>The source for the CVSS score.</p>
    pub fn score_source(&self) -> std::option::Option<&str> {
        self.score_source.as_deref()
    }
    /// <p>The source of the CVSS data.</p>
    pub fn cvss_source(&self) -> std::option::Option<&str> {
        self.cvss_source.as_deref()
    }
    /// <p>The CVSS version used in scoring.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The CVSS score.</p>
    pub fn score(&self) -> std::option::Option<f64> {
        self.score
    }
    /// <p>The vector for the CVSS score.</p>
    pub fn scoring_vector(&self) -> std::option::Option<&str> {
        self.scoring_vector.as_deref()
    }
    /// <p>An object that contains details about adjustment Amazon Inspector made to the CVSS score.</p>
    pub fn adjustments(&self) -> std::option::Option<&[crate::model::CvssScoreAdjustment]> {
        self.adjustments.as_deref()
    }
}
impl std::fmt::Debug for CvssScoreDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CvssScoreDetails");
        formatter.field("score_source", &self.score_source);
        formatter.field("cvss_source", &self.cvss_source);
        formatter.field("version", &self.version);
        formatter.field("score", &self.score);
        formatter.field("scoring_vector", &self.scoring_vector);
        formatter.field("adjustments", &self.adjustments);
        formatter.finish()
    }
}
/// See [`CvssScoreDetails`](crate::model::CvssScoreDetails)
pub mod cvss_score_details {
    /// A builder for [`CvssScoreDetails`](crate::model::CvssScoreDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score_source: std::option::Option<std::string::String>,
        pub(crate) cvss_source: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) score: std::option::Option<f64>,
        pub(crate) scoring_vector: std::option::Option<std::string::String>,
        pub(crate) adjustments:
            std::option::Option<std::vec::Vec<crate::model::CvssScoreAdjustment>>,
    }
    impl Builder {
        /// <p>The source for the CVSS score.</p>
        pub fn score_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.score_source = Some(input.into());
            self
        }
        /// <p>The source for the CVSS score.</p>
        pub fn set_score_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.score_source = input;
            self
        }
        /// <p>The source of the CVSS data.</p>
        pub fn cvss_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.cvss_source = Some(input.into());
            self
        }
        /// <p>The source of the CVSS data.</p>
        pub fn set_cvss_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cvss_source = input;
            self
        }
        /// <p>The CVSS version used in scoring.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The CVSS version used in scoring.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The CVSS score.</p>
        pub fn score(mut self, input: f64) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The CVSS score.</p>
        pub fn set_score(mut self, input: std::option::Option<f64>) -> Self {
            self.score = input;
            self
        }
        /// <p>The vector for the CVSS score.</p>
        pub fn scoring_vector(mut self, input: impl Into<std::string::String>) -> Self {
            self.scoring_vector = Some(input.into());
            self
        }
        /// <p>The vector for the CVSS score.</p>
        pub fn set_scoring_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scoring_vector = input;
            self
        }
        /// Appends an item to `adjustments`.
        ///
        /// To override the contents of this collection use [`set_adjustments`](Self::set_adjustments).
        ///
        /// <p>An object that contains details about adjustment Amazon Inspector made to the CVSS score.</p>
        pub fn adjustments(mut self, input: crate::model::CvssScoreAdjustment) -> Self {
            let mut v = self.adjustments.unwrap_or_default();
            v.push(input);
            self.adjustments = Some(v);
            self
        }
        /// <p>An object that contains details about adjustment Amazon Inspector made to the CVSS score.</p>
        pub fn set_adjustments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CvssScoreAdjustment>>,
        ) -> Self {
            self.adjustments = input;
            self
        }
        /// Consumes the builder and constructs a [`CvssScoreDetails`](crate::model::CvssScoreDetails)
        pub fn build(self) -> crate::model::CvssScoreDetails {
            crate::model::CvssScoreDetails {
                score_source: self.score_source,
                cvss_source: self.cvss_source,
                version: self.version,
                score: self.score,
                scoring_vector: self.scoring_vector,
                adjustments: self.adjustments,
            }
        }
    }
}
impl CvssScoreDetails {
    /// Creates a new builder-style object to manufacture [`CvssScoreDetails`](crate::model::CvssScoreDetails)
    pub fn builder() -> crate::model::cvss_score_details::Builder {
        crate::model::cvss_score_details::Builder::default()
    }
}

/// <p>Details on adjustments Amazon Inspector made to the CVSS score for a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CvssScoreAdjustment {
    /// <p>The metric used to adjust the CVSS score.</p>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The reason the CVSS score has been adjustment.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl CvssScoreAdjustment {
    /// <p>The metric used to adjust the CVSS score.</p>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The reason the CVSS score has been adjustment.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for CvssScoreAdjustment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CvssScoreAdjustment");
        formatter.field("metric", &self.metric);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`CvssScoreAdjustment`](crate::model::CvssScoreAdjustment)
pub mod cvss_score_adjustment {
    /// A builder for [`CvssScoreAdjustment`](crate::model::CvssScoreAdjustment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric used to adjust the CVSS score.</p>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>The metric used to adjust the CVSS score.</p>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The reason the CVSS score has been adjustment.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason the CVSS score has been adjustment.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`CvssScoreAdjustment`](crate::model::CvssScoreAdjustment)
        pub fn build(self) -> crate::model::CvssScoreAdjustment {
            crate::model::CvssScoreAdjustment {
                metric: self.metric,
                reason: self.reason,
            }
        }
    }
}
impl CvssScoreAdjustment {
    /// Creates a new builder-style object to manufacture [`CvssScoreAdjustment`](crate::model::CvssScoreAdjustment)
    pub fn builder() -> crate::model::cvss_score_adjustment::Builder {
        crate::model::cvss_score_adjustment::Builder::default()
    }
}

/// <p>Details about the resource involved in a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The type of resource.</p>
    pub r#type: std::option::Option<crate::model::ResourceType>,
    /// <p>The ID of the resource.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The partition of the resource.</p>
    pub partition: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region the impacted resource is located in.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The tags attached to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An object that contains details about the resource involved in a finding.</p>
    pub details: std::option::Option<crate::model::ResourceDetails>,
}
impl Resource {
    /// <p>The type of resource.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.r#type.as_ref()
    }
    /// <p>The ID of the resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The partition of the resource.</p>
    pub fn partition(&self) -> std::option::Option<&str> {
        self.partition.as_deref()
    }
    /// <p>The Amazon Web Services Region the impacted resource is located in.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The tags attached to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>An object that contains details about the resource involved in a finding.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::ResourceDetails> {
        self.details.as_ref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("partition", &self.partition);
        formatter.field("region", &self.region);
        formatter.field("tags", &self.tags);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ResourceType>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) partition: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) details: std::option::Option<crate::model::ResourceDetails>,
    }
    impl Builder {
        /// <p>The type of resource.</p>
        pub fn r#type(mut self, input: crate::model::ResourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ResourceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The partition of the resource.</p>
        pub fn partition(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition = Some(input.into());
            self
        }
        /// <p>The partition of the resource.</p>
        pub fn set_partition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partition = input;
            self
        }
        /// <p>The Amazon Web Services Region the impacted resource is located in.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region the impacted resource is located in.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags attached to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An object that contains details about the resource involved in a finding.</p>
        pub fn details(mut self, input: crate::model::ResourceDetails) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>An object that contains details about the resource involved in a finding.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::ResourceDetails>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                r#type: self.r#type,
                id: self.id,
                partition: self.partition,
                region: self.region,
                tags: self.tags,
                details: self.details,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>Contains details about the resource involved in the finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDetails {
    /// <p>An object that contains details about the Amazon EC2 instance involved in the finding.</p>
    pub aws_ec2_instance: std::option::Option<crate::model::AwsEc2InstanceDetails>,
    /// <p>An object that contains details about the Amazon ECR container image involved in the finding.</p>
    pub aws_ecr_container_image: std::option::Option<crate::model::AwsEcrContainerImageDetails>,
}
impl ResourceDetails {
    /// <p>An object that contains details about the Amazon EC2 instance involved in the finding.</p>
    pub fn aws_ec2_instance(&self) -> std::option::Option<&crate::model::AwsEc2InstanceDetails> {
        self.aws_ec2_instance.as_ref()
    }
    /// <p>An object that contains details about the Amazon ECR container image involved in the finding.</p>
    pub fn aws_ecr_container_image(
        &self,
    ) -> std::option::Option<&crate::model::AwsEcrContainerImageDetails> {
        self.aws_ecr_container_image.as_ref()
    }
}
impl std::fmt::Debug for ResourceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDetails");
        formatter.field("aws_ec2_instance", &self.aws_ec2_instance);
        formatter.field("aws_ecr_container_image", &self.aws_ecr_container_image);
        formatter.finish()
    }
}
/// See [`ResourceDetails`](crate::model::ResourceDetails)
pub mod resource_details {
    /// A builder for [`ResourceDetails`](crate::model::ResourceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_ec2_instance: std::option::Option<crate::model::AwsEc2InstanceDetails>,
        pub(crate) aws_ecr_container_image:
            std::option::Option<crate::model::AwsEcrContainerImageDetails>,
    }
    impl Builder {
        /// <p>An object that contains details about the Amazon EC2 instance involved in the finding.</p>
        pub fn aws_ec2_instance(mut self, input: crate::model::AwsEc2InstanceDetails) -> Self {
            self.aws_ec2_instance = Some(input);
            self
        }
        /// <p>An object that contains details about the Amazon EC2 instance involved in the finding.</p>
        pub fn set_aws_ec2_instance(
            mut self,
            input: std::option::Option<crate::model::AwsEc2InstanceDetails>,
        ) -> Self {
            self.aws_ec2_instance = input;
            self
        }
        /// <p>An object that contains details about the Amazon ECR container image involved in the finding.</p>
        pub fn aws_ecr_container_image(
            mut self,
            input: crate::model::AwsEcrContainerImageDetails,
        ) -> Self {
            self.aws_ecr_container_image = Some(input);
            self
        }
        /// <p>An object that contains details about the Amazon ECR container image involved in the finding.</p>
        pub fn set_aws_ecr_container_image(
            mut self,
            input: std::option::Option<crate::model::AwsEcrContainerImageDetails>,
        ) -> Self {
            self.aws_ecr_container_image = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDetails`](crate::model::ResourceDetails)
        pub fn build(self) -> crate::model::ResourceDetails {
            crate::model::ResourceDetails {
                aws_ec2_instance: self.aws_ec2_instance,
                aws_ecr_container_image: self.aws_ecr_container_image,
            }
        }
    }
}
impl ResourceDetails {
    /// Creates a new builder-style object to manufacture [`ResourceDetails`](crate::model::ResourceDetails)
    pub fn builder() -> crate::model::resource_details::Builder {
        crate::model::resource_details::Builder::default()
    }
}

/// <p>The image details of the Amazon ECR container image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcrContainerImageDetails {
    /// <p>The name of the repository the Amazon ECR container image resides in.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The image tags attached to the Amazon ECR container image.</p>
    pub image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time the Amazon ECR container image was pushed.</p>
    pub pushed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The image author of the Amazon ECR container image.</p>
    pub author: std::option::Option<std::string::String>,
    /// <p>The architecture of the Amazon ECR container image.</p>
    pub architecture: std::option::Option<std::string::String>,
    /// <p>The image hash of the Amazon ECR container image.</p>
    pub image_hash: std::option::Option<std::string::String>,
    /// <p>The registry the Amazon ECR container image belongs to.</p>
    pub registry: std::option::Option<std::string::String>,
    /// <p>The platform of the Amazon ECR container image.</p>
    pub platform: std::option::Option<std::string::String>,
}
impl AwsEcrContainerImageDetails {
    /// <p>The name of the repository the Amazon ECR container image resides in.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The image tags attached to the Amazon ECR container image.</p>
    pub fn image_tags(&self) -> std::option::Option<&[std::string::String]> {
        self.image_tags.as_deref()
    }
    /// <p>The date and time the Amazon ECR container image was pushed.</p>
    pub fn pushed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.pushed_at.as_ref()
    }
    /// <p>The image author of the Amazon ECR container image.</p>
    pub fn author(&self) -> std::option::Option<&str> {
        self.author.as_deref()
    }
    /// <p>The architecture of the Amazon ECR container image.</p>
    pub fn architecture(&self) -> std::option::Option<&str> {
        self.architecture.as_deref()
    }
    /// <p>The image hash of the Amazon ECR container image.</p>
    pub fn image_hash(&self) -> std::option::Option<&str> {
        self.image_hash.as_deref()
    }
    /// <p>The registry the Amazon ECR container image belongs to.</p>
    pub fn registry(&self) -> std::option::Option<&str> {
        self.registry.as_deref()
    }
    /// <p>The platform of the Amazon ECR container image.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
}
impl std::fmt::Debug for AwsEcrContainerImageDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcrContainerImageDetails");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_tags", &self.image_tags);
        formatter.field("pushed_at", &self.pushed_at);
        formatter.field("author", &self.author);
        formatter.field("architecture", &self.architecture);
        formatter.field("image_hash", &self.image_hash);
        formatter.field("registry", &self.registry);
        formatter.field("platform", &self.platform);
        formatter.finish()
    }
}
/// See [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
pub mod aws_ecr_container_image_details {
    /// A builder for [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) pushed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<std::string::String>,
        pub(crate) image_hash: std::option::Option<std::string::String>,
        pub(crate) registry: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository the Amazon ECR container image resides in.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository the Amazon ECR container image resides in.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `image_tags`.
        ///
        /// To override the contents of this collection use [`set_image_tags`](Self::set_image_tags).
        ///
        /// <p>The image tags attached to the Amazon ECR container image.</p>
        pub fn image_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.image_tags.unwrap_or_default();
            v.push(input.into());
            self.image_tags = Some(v);
            self
        }
        /// <p>The image tags attached to the Amazon ECR container image.</p>
        pub fn set_image_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.image_tags = input;
            self
        }
        /// <p>The date and time the Amazon ECR container image was pushed.</p>
        pub fn pushed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.pushed_at = Some(input);
            self
        }
        /// <p>The date and time the Amazon ECR container image was pushed.</p>
        pub fn set_pushed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.pushed_at = input;
            self
        }
        /// <p>The image author of the Amazon ECR container image.</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The image author of the Amazon ECR container image.</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p>The architecture of the Amazon ECR container image.</p>
        pub fn architecture(mut self, input: impl Into<std::string::String>) -> Self {
            self.architecture = Some(input.into());
            self
        }
        /// <p>The architecture of the Amazon ECR container image.</p>
        pub fn set_architecture(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The image hash of the Amazon ECR container image.</p>
        pub fn image_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_hash = Some(input.into());
            self
        }
        /// <p>The image hash of the Amazon ECR container image.</p>
        pub fn set_image_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_hash = input;
            self
        }
        /// <p>The registry the Amazon ECR container image belongs to.</p>
        pub fn registry(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry = Some(input.into());
            self
        }
        /// <p>The registry the Amazon ECR container image belongs to.</p>
        pub fn set_registry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry = input;
            self
        }
        /// <p>The platform of the Amazon ECR container image.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform of the Amazon ECR container image.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
        pub fn build(self) -> crate::model::AwsEcrContainerImageDetails {
            crate::model::AwsEcrContainerImageDetails {
                repository_name: self.repository_name,
                image_tags: self.image_tags,
                pushed_at: self.pushed_at,
                author: self.author,
                architecture: self.architecture,
                image_hash: self.image_hash,
                registry: self.registry,
                platform: self.platform,
            }
        }
    }
}
impl AwsEcrContainerImageDetails {
    /// Creates a new builder-style object to manufacture [`AwsEcrContainerImageDetails`](crate::model::AwsEcrContainerImageDetails)
    pub fn builder() -> crate::model::aws_ecr_container_image_details::Builder {
        crate::model::aws_ecr_container_image_details::Builder::default()
    }
}

/// <p>Details of the Amazon EC2 instance involved in a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEc2InstanceDetails {
    /// <p>The type of the Amazon EC2 instance.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The image ID of the Amazon EC2 instance.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The IPv4 addresses of the Amazon EC2 instance.</p>
    pub ip_v4_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IPv6 addresses of the Amazon EC2 instance.</p>
    pub ip_v6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the key pair used to launch the Amazon EC2 instance.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>The IAM instance profile ARN of the Amazon EC2 instance.</p>
    pub iam_instance_profile_arn: std::option::Option<std::string::String>,
    /// <p>The VPC ID of the Amazon EC2 instance.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The subnet ID of the Amazon EC2 instance.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The date and time the Amazon EC2 instance was launched at.</p>
    pub launched_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The platform of the Amazon EC2 instance.</p>
    pub platform: std::option::Option<std::string::String>,
}
impl AwsEc2InstanceDetails {
    /// <p>The type of the Amazon EC2 instance.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The image ID of the Amazon EC2 instance.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The IPv4 addresses of the Amazon EC2 instance.</p>
    pub fn ip_v4_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_v4_addresses.as_deref()
    }
    /// <p>The IPv6 addresses of the Amazon EC2 instance.</p>
    pub fn ip_v6_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_v6_addresses.as_deref()
    }
    /// <p>The name of the key pair used to launch the Amazon EC2 instance.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>The IAM instance profile ARN of the Amazon EC2 instance.</p>
    pub fn iam_instance_profile_arn(&self) -> std::option::Option<&str> {
        self.iam_instance_profile_arn.as_deref()
    }
    /// <p>The VPC ID of the Amazon EC2 instance.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The subnet ID of the Amazon EC2 instance.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The date and time the Amazon EC2 instance was launched at.</p>
    pub fn launched_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.launched_at.as_ref()
    }
    /// <p>The platform of the Amazon EC2 instance.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
}
impl std::fmt::Debug for AwsEc2InstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEc2InstanceDetails");
        formatter.field("r#type", &self.r#type);
        formatter.field("image_id", &self.image_id);
        formatter.field("ip_v4_addresses", &self.ip_v4_addresses);
        formatter.field("ip_v6_addresses", &self.ip_v6_addresses);
        formatter.field("key_name", &self.key_name);
        formatter.field("iam_instance_profile_arn", &self.iam_instance_profile_arn);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("launched_at", &self.launched_at);
        formatter.field("platform", &self.platform);
        formatter.finish()
    }
}
/// See [`AwsEc2InstanceDetails`](crate::model::AwsEc2InstanceDetails)
pub mod aws_ec2_instance_details {
    /// A builder for [`AwsEc2InstanceDetails`](crate::model::AwsEc2InstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) ip_v4_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ip_v6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) iam_instance_profile_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) launched_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) platform: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the Amazon EC2 instance.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the Amazon EC2 instance.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The image ID of the Amazon EC2 instance.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The image ID of the Amazon EC2 instance.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// Appends an item to `ip_v4_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_v4_addresses`](Self::set_ip_v4_addresses).
        ///
        /// <p>The IPv4 addresses of the Amazon EC2 instance.</p>
        pub fn ip_v4_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_v4_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_v4_addresses = Some(v);
            self
        }
        /// <p>The IPv4 addresses of the Amazon EC2 instance.</p>
        pub fn set_ip_v4_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_v4_addresses = input;
            self
        }
        /// Appends an item to `ip_v6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_v6_addresses`](Self::set_ip_v6_addresses).
        ///
        /// <p>The IPv6 addresses of the Amazon EC2 instance.</p>
        pub fn ip_v6_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_v6_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_v6_addresses = Some(v);
            self
        }
        /// <p>The IPv6 addresses of the Amazon EC2 instance.</p>
        pub fn set_ip_v6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_v6_addresses = input;
            self
        }
        /// <p>The name of the key pair used to launch the Amazon EC2 instance.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair used to launch the Amazon EC2 instance.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// <p>The IAM instance profile ARN of the Amazon EC2 instance.</p>
        pub fn iam_instance_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_instance_profile_arn = Some(input.into());
            self
        }
        /// <p>The IAM instance profile ARN of the Amazon EC2 instance.</p>
        pub fn set_iam_instance_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_instance_profile_arn = input;
            self
        }
        /// <p>The VPC ID of the Amazon EC2 instance.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID of the Amazon EC2 instance.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The subnet ID of the Amazon EC2 instance.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID of the Amazon EC2 instance.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The date and time the Amazon EC2 instance was launched at.</p>
        pub fn launched_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.launched_at = Some(input);
            self
        }
        /// <p>The date and time the Amazon EC2 instance was launched at.</p>
        pub fn set_launched_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.launched_at = input;
            self
        }
        /// <p>The platform of the Amazon EC2 instance.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform of the Amazon EC2 instance.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEc2InstanceDetails`](crate::model::AwsEc2InstanceDetails)
        pub fn build(self) -> crate::model::AwsEc2InstanceDetails {
            crate::model::AwsEc2InstanceDetails {
                r#type: self.r#type,
                image_id: self.image_id,
                ip_v4_addresses: self.ip_v4_addresses,
                ip_v6_addresses: self.ip_v6_addresses,
                key_name: self.key_name,
                iam_instance_profile_arn: self.iam_instance_profile_arn,
                vpc_id: self.vpc_id,
                subnet_id: self.subnet_id,
                launched_at: self.launched_at,
                platform: self.platform,
            }
        }
    }
}
impl AwsEc2InstanceDetails {
    /// Creates a new builder-style object to manufacture [`AwsEc2InstanceDetails`](crate::model::AwsEc2InstanceDetails)
    pub fn builder() -> crate::model::aws_ec2_instance_details::Builder {
        crate::model::aws_ec2_instance_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AwsEc2Instance,
    #[allow(missing_docs)] // documentation missing in model
    AwsEcrContainerImage,
    #[allow(missing_docs)] // documentation missing in model
    AwsEcrRepository,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_EC2_INSTANCE" => ResourceType::AwsEc2Instance,
            "AWS_ECR_CONTAINER_IMAGE" => ResourceType::AwsEcrContainerImage,
            "AWS_ECR_REPOSITORY" => ResourceType::AwsEcrRepository,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::AwsEc2Instance => "AWS_EC2_INSTANCE",
            ResourceType::AwsEcrContainerImage => "AWS_ECR_CONTAINER_IMAGE",
            ResourceType::AwsEcrRepository => "AWS_ECR_REPOSITORY",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_EC2_INSTANCE",
            "AWS_ECR_CONTAINER_IMAGE",
            "AWS_ECR_REPOSITORY",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Suppressed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => FindingStatus::Active,
            "CLOSED" => FindingStatus::Closed,
            "SUPPRESSED" => FindingStatus::Suppressed,
            other => FindingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingStatus::from(s))
    }
}
impl FindingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingStatus::Active => "ACTIVE",
            FindingStatus::Closed => "CLOSED",
            FindingStatus::Suppressed => "SUPPRESSED",
            FindingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CLOSED", "SUPPRESSED"]
    }
}
impl AsRef<str> for FindingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Severity {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Informational,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Untriaged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Severity {
    fn from(s: &str) -> Self {
        match s {
            "CRITICAL" => Severity::Critical,
            "HIGH" => Severity::High,
            "INFORMATIONAL" => Severity::Informational,
            "LOW" => Severity::Low,
            "MEDIUM" => Severity::Medium,
            "UNTRIAGED" => Severity::Untriaged,
            other => Severity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Severity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Severity::from(s))
    }
}
impl Severity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Severity::Critical => "CRITICAL",
            Severity::High => "HIGH",
            Severity::Informational => "INFORMATIONAL",
            Severity::Low => "LOW",
            Severity::Medium => "MEDIUM",
            Severity::Untriaged => "UNTRIAGED",
            Severity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CRITICAL",
            "HIGH",
            "INFORMATIONAL",
            "LOW",
            "MEDIUM",
            "UNTRIAGED",
        ]
    }
}
impl AsRef<str> for Severity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information on how to remediate a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Remediation {
    /// <p>An object that contains information about the recommended course of action to remediate the finding.</p>
    pub recommendation: std::option::Option<crate::model::Recommendation>,
}
impl Remediation {
    /// <p>An object that contains information about the recommended course of action to remediate the finding.</p>
    pub fn recommendation(&self) -> std::option::Option<&crate::model::Recommendation> {
        self.recommendation.as_ref()
    }
}
impl std::fmt::Debug for Remediation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Remediation");
        formatter.field("recommendation", &self.recommendation);
        formatter.finish()
    }
}
/// See [`Remediation`](crate::model::Remediation)
pub mod remediation {
    /// A builder for [`Remediation`](crate::model::Remediation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation: std::option::Option<crate::model::Recommendation>,
    }
    impl Builder {
        /// <p>An object that contains information about the recommended course of action to remediate the finding.</p>
        pub fn recommendation(mut self, input: crate::model::Recommendation) -> Self {
            self.recommendation = Some(input);
            self
        }
        /// <p>An object that contains information about the recommended course of action to remediate the finding.</p>
        pub fn set_recommendation(
            mut self,
            input: std::option::Option<crate::model::Recommendation>,
        ) -> Self {
            self.recommendation = input;
            self
        }
        /// Consumes the builder and constructs a [`Remediation`](crate::model::Remediation)
        pub fn build(self) -> crate::model::Remediation {
            crate::model::Remediation {
                recommendation: self.recommendation,
            }
        }
    }
}
impl Remediation {
    /// Creates a new builder-style object to manufacture [`Remediation`](crate::model::Remediation)
    pub fn builder() -> crate::model::remediation::Builder {
        crate::model::remediation::Builder::default()
    }
}

/// <p>Details about the recommended course of action to remediate the finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recommendation {
    /// <p>The recommended course of action to remediate the finding.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The URL address to the CVE remediation recommendations.</p>
    pub url: std::option::Option<std::string::String>,
}
impl Recommendation {
    /// <p>The recommended course of action to remediate the finding.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The URL address to the CVE remediation recommendations.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for Recommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recommendation");
        formatter.field("text", &self.text);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`Recommendation`](crate::model::Recommendation)
pub mod recommendation {
    /// A builder for [`Recommendation`](crate::model::Recommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The recommended course of action to remediate the finding.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The recommended course of action to remediate the finding.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The URL address to the CVE remediation recommendations.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL address to the CVE remediation recommendations.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`Recommendation`](crate::model::Recommendation)
        pub fn build(self) -> crate::model::Recommendation {
            crate::model::Recommendation {
                text: self.text,
                url: self.url,
            }
        }
    }
}
impl Recommendation {
    /// Creates a new builder-style object to manufacture [`Recommendation`](crate::model::Recommendation)
    pub fn builder() -> crate::model::recommendation::Builder {
        crate::model::recommendation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingType {
    #[allow(missing_docs)] // documentation missing in model
    NetworkReachability,
    #[allow(missing_docs)] // documentation missing in model
    PackageVulnerability,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingType {
    fn from(s: &str) -> Self {
        match s {
            "NETWORK_REACHABILITY" => FindingType::NetworkReachability,
            "PACKAGE_VULNERABILITY" => FindingType::PackageVulnerability,
            other => FindingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingType::from(s))
    }
}
impl FindingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingType::NetworkReachability => "NETWORK_REACHABILITY",
            FindingType::PackageVulnerability => "PACKAGE_VULNERABILITY",
            FindingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NETWORK_REACHABILITY", "PACKAGE_VULNERABILITY"]
    }
}
impl AsRef<str> for FindingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the criteria used to sort finding results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortCriteria {
    /// <p>The finding detail field by which results are sorted.</p>
    pub field: std::option::Option<crate::model::SortField>,
    /// <p>The order by which findings are sorted.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
}
impl SortCriteria {
    /// <p>The finding detail field by which results are sorted.</p>
    pub fn field(&self) -> std::option::Option<&crate::model::SortField> {
        self.field.as_ref()
    }
    /// <p>The order by which findings are sorted.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for SortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortCriteria");
        formatter.field("field", &self.field);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}
/// See [`SortCriteria`](crate::model::SortCriteria)
pub mod sort_criteria {
    /// A builder for [`SortCriteria`](crate::model::SortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<crate::model::SortField>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The finding detail field by which results are sorted.</p>
        pub fn field(mut self, input: crate::model::SortField) -> Self {
            self.field = Some(input);
            self
        }
        /// <p>The finding detail field by which results are sorted.</p>
        pub fn set_field(mut self, input: std::option::Option<crate::model::SortField>) -> Self {
            self.field = input;
            self
        }
        /// <p>The order by which findings are sorted.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order by which findings are sorted.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`SortCriteria`](crate::model::SortCriteria)
        pub fn build(self) -> crate::model::SortCriteria {
            crate::model::SortCriteria {
                field: self.field,
                sort_order: self.sort_order,
            }
        }
    }
}
impl SortCriteria {
    /// Creates a new builder-style object to manufacture [`SortCriteria`](crate::model::SortCriteria)
    pub fn builder() -> crate::model::sort_criteria::Builder {
        crate::model::sort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => SortOrder::Asc,
            "DESC" => SortOrder::Desc,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Asc => "ASC",
            SortOrder::Desc => "DESC",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortField {
    #[allow(missing_docs)] // documentation missing in model
    AwsAccountId,
    #[allow(missing_docs)] // documentation missing in model
    ComponentType,
    #[allow(missing_docs)] // documentation missing in model
    EcrImagePushedAt,
    #[allow(missing_docs)] // documentation missing in model
    EcrImageRegistry,
    #[allow(missing_docs)] // documentation missing in model
    EcrImageRepositoryName,
    #[allow(missing_docs)] // documentation missing in model
    FindingStatus,
    #[allow(missing_docs)] // documentation missing in model
    FindingType,
    #[allow(missing_docs)] // documentation missing in model
    FirstObservedAt,
    #[allow(missing_docs)] // documentation missing in model
    InspectorScore,
    #[allow(missing_docs)] // documentation missing in model
    LastObservedAt,
    #[allow(missing_docs)] // documentation missing in model
    NetworkProtocol,
    #[allow(missing_docs)] // documentation missing in model
    ResourceType,
    #[allow(missing_docs)] // documentation missing in model
    Severity,
    #[allow(missing_docs)] // documentation missing in model
    VendorSeverity,
    #[allow(missing_docs)] // documentation missing in model
    VulnerabilityId,
    #[allow(missing_docs)] // documentation missing in model
    VulnerabilitySource,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortField {
    fn from(s: &str) -> Self {
        match s {
            "AWS_ACCOUNT_ID" => SortField::AwsAccountId,
            "COMPONENT_TYPE" => SortField::ComponentType,
            "ECR_IMAGE_PUSHED_AT" => SortField::EcrImagePushedAt,
            "ECR_IMAGE_REGISTRY" => SortField::EcrImageRegistry,
            "ECR_IMAGE_REPOSITORY_NAME" => SortField::EcrImageRepositoryName,
            "FINDING_STATUS" => SortField::FindingStatus,
            "FINDING_TYPE" => SortField::FindingType,
            "FIRST_OBSERVED_AT" => SortField::FirstObservedAt,
            "INSPECTOR_SCORE" => SortField::InspectorScore,
            "LAST_OBSERVED_AT" => SortField::LastObservedAt,
            "NETWORK_PROTOCOL" => SortField::NetworkProtocol,
            "RESOURCE_TYPE" => SortField::ResourceType,
            "SEVERITY" => SortField::Severity,
            "VENDOR_SEVERITY" => SortField::VendorSeverity,
            "VULNERABILITY_ID" => SortField::VulnerabilityId,
            "VULNERABILITY_SOURCE" => SortField::VulnerabilitySource,
            other => SortField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortField::from(s))
    }
}
impl SortField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortField::AwsAccountId => "AWS_ACCOUNT_ID",
            SortField::ComponentType => "COMPONENT_TYPE",
            SortField::EcrImagePushedAt => "ECR_IMAGE_PUSHED_AT",
            SortField::EcrImageRegistry => "ECR_IMAGE_REGISTRY",
            SortField::EcrImageRepositoryName => "ECR_IMAGE_REPOSITORY_NAME",
            SortField::FindingStatus => "FINDING_STATUS",
            SortField::FindingType => "FINDING_TYPE",
            SortField::FirstObservedAt => "FIRST_OBSERVED_AT",
            SortField::InspectorScore => "INSPECTOR_SCORE",
            SortField::LastObservedAt => "LAST_OBSERVED_AT",
            SortField::NetworkProtocol => "NETWORK_PROTOCOL",
            SortField::ResourceType => "RESOURCE_TYPE",
            SortField::Severity => "SEVERITY",
            SortField::VendorSeverity => "VENDOR_SEVERITY",
            SortField::VulnerabilityId => "VULNERABILITY_ID",
            SortField::VulnerabilitySource => "VULNERABILITY_SOURCE",
            SortField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_ACCOUNT_ID",
            "COMPONENT_TYPE",
            "ECR_IMAGE_PUSHED_AT",
            "ECR_IMAGE_REGISTRY",
            "ECR_IMAGE_REPOSITORY_NAME",
            "FINDING_STATUS",
            "FINDING_TYPE",
            "FIRST_OBSERVED_AT",
            "INSPECTOR_SCORE",
            "LAST_OBSERVED_AT",
            "NETWORK_PROTOCOL",
            "RESOURCE_TYPE",
            "SEVERITY",
            "VENDOR_SEVERITY",
            "VULNERABILITY_ID",
            "VULNERABILITY_SOURCE",
        ]
    }
}
impl AsRef<str> for SortField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains details about the results of an aggregation type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AggregationResponse {
    /// <p>An object that contains details about an aggregation response based on Amazon Web Services account IDs.</p>
    AccountAggregation(crate::model::AccountAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).</p>
    AmiAggregation(crate::model::AmiAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on Amazon ECR container images.</p>
    AwsEcrContainerAggregation(crate::model::AwsEcrContainerAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on Amazon EC2 instances.</p>
    Ec2InstanceAggregation(crate::model::Ec2InstanceAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on finding types.</p>
    FindingTypeAggregation(crate::model::FindingTypeAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on container image layers.</p>
    ImageLayerAggregation(crate::model::ImageLayerAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on operating system package type.</p>
    PackageAggregation(crate::model::PackageAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on Amazon ECR repositories.</p>
    RepositoryAggregation(crate::model::RepositoryAggregationResponse),
    /// <p>An object that contains details about an aggregation response based on finding title.</p>
    TitleAggregation(crate::model::TitleAggregationResponse),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AggregationResponse {
    /// Tries to convert the enum instance into [`AccountAggregation`](crate::model::AggregationResponse::AccountAggregation), extracting the inner [`AccountAggregationResponse`](crate::model::AccountAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_account_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::AccountAggregationResponse, &Self> {
        if let AggregationResponse::AccountAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AccountAggregation`](crate::model::AggregationResponse::AccountAggregation).
    pub fn is_account_aggregation(&self) -> bool {
        self.as_account_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`AmiAggregation`](crate::model::AggregationResponse::AmiAggregation), extracting the inner [`AmiAggregationResponse`](crate::model::AmiAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ami_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::AmiAggregationResponse, &Self> {
        if let AggregationResponse::AmiAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AmiAggregation`](crate::model::AggregationResponse::AmiAggregation).
    pub fn is_ami_aggregation(&self) -> bool {
        self.as_ami_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`AwsEcrContainerAggregation`](crate::model::AggregationResponse::AwsEcrContainerAggregation), extracting the inner [`AwsEcrContainerAggregationResponse`](crate::model::AwsEcrContainerAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aws_ecr_container_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::AwsEcrContainerAggregationResponse, &Self> {
        if let AggregationResponse::AwsEcrContainerAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AwsEcrContainerAggregation`](crate::model::AggregationResponse::AwsEcrContainerAggregation).
    pub fn is_aws_ecr_container_aggregation(&self) -> bool {
        self.as_aws_ecr_container_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`Ec2InstanceAggregation`](crate::model::AggregationResponse::Ec2InstanceAggregation), extracting the inner [`Ec2InstanceAggregationResponse`](crate::model::Ec2InstanceAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ec2_instance_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::Ec2InstanceAggregationResponse, &Self> {
        if let AggregationResponse::Ec2InstanceAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Ec2InstanceAggregation`](crate::model::AggregationResponse::Ec2InstanceAggregation).
    pub fn is_ec2_instance_aggregation(&self) -> bool {
        self.as_ec2_instance_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`FindingTypeAggregation`](crate::model::AggregationResponse::FindingTypeAggregation), extracting the inner [`FindingTypeAggregationResponse`](crate::model::FindingTypeAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_finding_type_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::FindingTypeAggregationResponse, &Self> {
        if let AggregationResponse::FindingTypeAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`FindingTypeAggregation`](crate::model::AggregationResponse::FindingTypeAggregation).
    pub fn is_finding_type_aggregation(&self) -> bool {
        self.as_finding_type_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`ImageLayerAggregation`](crate::model::AggregationResponse::ImageLayerAggregation), extracting the inner [`ImageLayerAggregationResponse`](crate::model::ImageLayerAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_image_layer_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::ImageLayerAggregationResponse, &Self> {
        if let AggregationResponse::ImageLayerAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ImageLayerAggregation`](crate::model::AggregationResponse::ImageLayerAggregation).
    pub fn is_image_layer_aggregation(&self) -> bool {
        self.as_image_layer_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`PackageAggregation`](crate::model::AggregationResponse::PackageAggregation), extracting the inner [`PackageAggregationResponse`](crate::model::PackageAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_package_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::PackageAggregationResponse, &Self> {
        if let AggregationResponse::PackageAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`PackageAggregation`](crate::model::AggregationResponse::PackageAggregation).
    pub fn is_package_aggregation(&self) -> bool {
        self.as_package_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`RepositoryAggregation`](crate::model::AggregationResponse::RepositoryAggregation), extracting the inner [`RepositoryAggregationResponse`](crate::model::RepositoryAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_repository_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::RepositoryAggregationResponse, &Self> {
        if let AggregationResponse::RepositoryAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`RepositoryAggregation`](crate::model::AggregationResponse::RepositoryAggregation).
    pub fn is_repository_aggregation(&self) -> bool {
        self.as_repository_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`TitleAggregation`](crate::model::AggregationResponse::TitleAggregation), extracting the inner [`TitleAggregationResponse`](crate::model::TitleAggregationResponse).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_title_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::TitleAggregationResponse, &Self> {
        if let AggregationResponse::TitleAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`TitleAggregation`](crate::model::AggregationResponse::TitleAggregation).
    pub fn is_title_aggregation(&self) -> bool {
        self.as_title_aggregation().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A response that contains details on the results of a finding aggregation by title.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TitleAggregationResponse {
    /// <p>The title that the findings were aggregated on.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The vulnerability ID of the finding.</p>
    pub vulnerability_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object that represent the count of matched findings per severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
}
impl TitleAggregationResponse {
    /// <p>The title that the findings were aggregated on.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The vulnerability ID of the finding.</p>
    pub fn vulnerability_id(&self) -> std::option::Option<&str> {
        self.vulnerability_id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object that represent the count of matched findings per severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
}
impl std::fmt::Debug for TitleAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TitleAggregationResponse");
        formatter.field("title", &self.title);
        formatter.field("vulnerability_id", &self.vulnerability_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.finish()
    }
}
/// See [`TitleAggregationResponse`](crate::model::TitleAggregationResponse)
pub mod title_aggregation_response {
    /// A builder for [`TitleAggregationResponse`](crate::model::TitleAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) vulnerability_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
    }
    impl Builder {
        /// <p>The title that the findings were aggregated on.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title that the findings were aggregated on.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The vulnerability ID of the finding.</p>
        pub fn vulnerability_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vulnerability_id = Some(input.into());
            self
        }
        /// <p>The vulnerability ID of the finding.</p>
        pub fn set_vulnerability_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vulnerability_id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An object that represent the count of matched findings per severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>An object that represent the count of matched findings per severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`TitleAggregationResponse`](crate::model::TitleAggregationResponse)
        pub fn build(self) -> crate::model::TitleAggregationResponse {
            crate::model::TitleAggregationResponse {
                title: self.title,
                vulnerability_id: self.vulnerability_id,
                account_id: self.account_id,
                severity_counts: self.severity_counts,
            }
        }
    }
}
impl TitleAggregationResponse {
    /// Creates a new builder-style object to manufacture [`TitleAggregationResponse`](crate::model::TitleAggregationResponse)
    pub fn builder() -> crate::model::title_aggregation_response::Builder {
        crate::model::title_aggregation_response::Builder::default()
    }
}

/// <p>An object that contains the counts of aggregated finding per severity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SeverityCounts {
    /// <p>The total count of findings from all severities.</p>
    pub all: std::option::Option<i64>,
    /// <p>The total count of medium severity findings.</p>
    pub medium: std::option::Option<i64>,
    /// <p>The total count of high severity findings.</p>
    pub high: std::option::Option<i64>,
    /// <p>The total count of critical severity findings.</p>
    pub critical: std::option::Option<i64>,
}
impl SeverityCounts {
    /// <p>The total count of findings from all severities.</p>
    pub fn all(&self) -> std::option::Option<i64> {
        self.all
    }
    /// <p>The total count of medium severity findings.</p>
    pub fn medium(&self) -> std::option::Option<i64> {
        self.medium
    }
    /// <p>The total count of high severity findings.</p>
    pub fn high(&self) -> std::option::Option<i64> {
        self.high
    }
    /// <p>The total count of critical severity findings.</p>
    pub fn critical(&self) -> std::option::Option<i64> {
        self.critical
    }
}
impl std::fmt::Debug for SeverityCounts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SeverityCounts");
        formatter.field("all", &self.all);
        formatter.field("medium", &self.medium);
        formatter.field("high", &self.high);
        formatter.field("critical", &self.critical);
        formatter.finish()
    }
}
/// See [`SeverityCounts`](crate::model::SeverityCounts)
pub mod severity_counts {
    /// A builder for [`SeverityCounts`](crate::model::SeverityCounts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) all: std::option::Option<i64>,
        pub(crate) medium: std::option::Option<i64>,
        pub(crate) high: std::option::Option<i64>,
        pub(crate) critical: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total count of findings from all severities.</p>
        pub fn all(mut self, input: i64) -> Self {
            self.all = Some(input);
            self
        }
        /// <p>The total count of findings from all severities.</p>
        pub fn set_all(mut self, input: std::option::Option<i64>) -> Self {
            self.all = input;
            self
        }
        /// <p>The total count of medium severity findings.</p>
        pub fn medium(mut self, input: i64) -> Self {
            self.medium = Some(input);
            self
        }
        /// <p>The total count of medium severity findings.</p>
        pub fn set_medium(mut self, input: std::option::Option<i64>) -> Self {
            self.medium = input;
            self
        }
        /// <p>The total count of high severity findings.</p>
        pub fn high(mut self, input: i64) -> Self {
            self.high = Some(input);
            self
        }
        /// <p>The total count of high severity findings.</p>
        pub fn set_high(mut self, input: std::option::Option<i64>) -> Self {
            self.high = input;
            self
        }
        /// <p>The total count of critical severity findings.</p>
        pub fn critical(mut self, input: i64) -> Self {
            self.critical = Some(input);
            self
        }
        /// <p>The total count of critical severity findings.</p>
        pub fn set_critical(mut self, input: std::option::Option<i64>) -> Self {
            self.critical = input;
            self
        }
        /// Consumes the builder and constructs a [`SeverityCounts`](crate::model::SeverityCounts)
        pub fn build(self) -> crate::model::SeverityCounts {
            crate::model::SeverityCounts {
                all: self.all,
                medium: self.medium,
                high: self.high,
                critical: self.critical,
            }
        }
    }
}
impl SeverityCounts {
    /// Creates a new builder-style object to manufacture [`SeverityCounts`](crate::model::SeverityCounts)
    pub fn builder() -> crate::model::severity_counts::Builder {
        crate::model::severity_counts::Builder::default()
    }
}

/// <p>A response that contains details on the results of a finding aggregation by repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryAggregationResponse {
    /// <p>The name of the repository associated with the findings.</p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object that represent the count of matched findings per severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
    /// <p>The number of container images impacted by the findings.</p>
    pub affected_images: std::option::Option<i64>,
}
impl RepositoryAggregationResponse {
    /// <p>The name of the repository associated with the findings.</p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object that represent the count of matched findings per severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
    /// <p>The number of container images impacted by the findings.</p>
    pub fn affected_images(&self) -> std::option::Option<i64> {
        self.affected_images
    }
}
impl std::fmt::Debug for RepositoryAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryAggregationResponse");
        formatter.field("repository", &self.repository);
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.field("affected_images", &self.affected_images);
        formatter.finish()
    }
}
/// See [`RepositoryAggregationResponse`](crate::model::RepositoryAggregationResponse)
pub mod repository_aggregation_response {
    /// A builder for [`RepositoryAggregationResponse`](crate::model::RepositoryAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
        pub(crate) affected_images: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the repository associated with the findings.</p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>The name of the repository associated with the findings.</p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An object that represent the count of matched findings per severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>An object that represent the count of matched findings per severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// <p>The number of container images impacted by the findings.</p>
        pub fn affected_images(mut self, input: i64) -> Self {
            self.affected_images = Some(input);
            self
        }
        /// <p>The number of container images impacted by the findings.</p>
        pub fn set_affected_images(mut self, input: std::option::Option<i64>) -> Self {
            self.affected_images = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryAggregationResponse`](crate::model::RepositoryAggregationResponse)
        pub fn build(self) -> crate::model::RepositoryAggregationResponse {
            crate::model::RepositoryAggregationResponse {
                repository: self.repository,
                account_id: self.account_id,
                severity_counts: self.severity_counts,
                affected_images: self.affected_images,
            }
        }
    }
}
impl RepositoryAggregationResponse {
    /// Creates a new builder-style object to manufacture [`RepositoryAggregationResponse`](crate::model::RepositoryAggregationResponse)
    pub fn builder() -> crate::model::repository_aggregation_response::Builder {
        crate::model::repository_aggregation_response::Builder::default()
    }
}

/// <p>A response that contains the results of a finding aggregation by image layer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageAggregationResponse {
    /// <p>The name of the operating system package.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object that contains the count of matched findings per severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
}
impl PackageAggregationResponse {
    /// <p>The name of the operating system package.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object that contains the count of matched findings per severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
}
impl std::fmt::Debug for PackageAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageAggregationResponse");
        formatter.field("package_name", &self.package_name);
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.finish()
    }
}
/// See [`PackageAggregationResponse`](crate::model::PackageAggregationResponse)
pub mod package_aggregation_response {
    /// A builder for [`PackageAggregationResponse`](crate::model::PackageAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
    }
    impl Builder {
        /// <p>The name of the operating system package.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The name of the operating system package.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An object that contains the count of matched findings per severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>An object that contains the count of matched findings per severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageAggregationResponse`](crate::model::PackageAggregationResponse)
        pub fn build(self) -> crate::model::PackageAggregationResponse {
            crate::model::PackageAggregationResponse {
                package_name: self.package_name,
                account_id: self.account_id,
                severity_counts: self.severity_counts,
            }
        }
    }
}
impl PackageAggregationResponse {
    /// Creates a new builder-style object to manufacture [`PackageAggregationResponse`](crate::model::PackageAggregationResponse)
    pub fn builder() -> crate::model::package_aggregation_response::Builder {
        crate::model::package_aggregation_response::Builder::default()
    }
}

/// <p>A response that contains the results of a finding aggregation by image layer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageLayerAggregationResponse {
    /// <p>The repository the layer resides in.</p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>The resource ID of the container image layer.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The layer hash.</p>
    pub layer_hash: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the container image hosting the layer image.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object that represents the count of matched findings per severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
}
impl ImageLayerAggregationResponse {
    /// <p>The repository the layer resides in.</p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>The resource ID of the container image layer.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The layer hash.</p>
    pub fn layer_hash(&self) -> std::option::Option<&str> {
        self.layer_hash.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the container image hosting the layer image.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object that represents the count of matched findings per severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
}
impl std::fmt::Debug for ImageLayerAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageLayerAggregationResponse");
        formatter.field("repository", &self.repository);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("layer_hash", &self.layer_hash);
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.finish()
    }
}
/// See [`ImageLayerAggregationResponse`](crate::model::ImageLayerAggregationResponse)
pub mod image_layer_aggregation_response {
    /// A builder for [`ImageLayerAggregationResponse`](crate::model::ImageLayerAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) layer_hash: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
    }
    impl Builder {
        /// <p>The repository the layer resides in.</p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>The repository the layer resides in.</p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>The resource ID of the container image layer.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the container image layer.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The layer hash.</p>
        pub fn layer_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_hash = Some(input.into());
            self
        }
        /// <p>The layer hash.</p>
        pub fn set_layer_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_hash = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the container image hosting the layer image.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the container image hosting the layer image.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An object that represents the count of matched findings per severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>An object that represents the count of matched findings per severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageLayerAggregationResponse`](crate::model::ImageLayerAggregationResponse)
        pub fn build(self) -> crate::model::ImageLayerAggregationResponse {
            crate::model::ImageLayerAggregationResponse {
                repository: self.repository,
                resource_id: self.resource_id,
                layer_hash: self.layer_hash,
                account_id: self.account_id,
                severity_counts: self.severity_counts,
            }
        }
    }
}
impl ImageLayerAggregationResponse {
    /// Creates a new builder-style object to manufacture [`ImageLayerAggregationResponse`](crate::model::ImageLayerAggregationResponse)
    pub fn builder() -> crate::model::image_layer_aggregation_response::Builder {
        crate::model::image_layer_aggregation_response::Builder::default()
    }
}

/// <p>A response that contains the results of a finding type aggregation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingTypeAggregationResponse {
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The value to sort results by.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
}
impl FindingTypeAggregationResponse {
    /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The value to sort results by.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
}
impl std::fmt::Debug for FindingTypeAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingTypeAggregationResponse");
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.finish()
    }
}
/// See [`FindingTypeAggregationResponse`](crate::model::FindingTypeAggregationResponse)
pub mod finding_type_aggregation_response {
    /// A builder for [`FindingTypeAggregationResponse`](crate::model::FindingTypeAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account associated with the findings.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingTypeAggregationResponse`](crate::model::FindingTypeAggregationResponse)
        pub fn build(self) -> crate::model::FindingTypeAggregationResponse {
            crate::model::FindingTypeAggregationResponse {
                account_id: self.account_id,
                severity_counts: self.severity_counts,
            }
        }
    }
}
impl FindingTypeAggregationResponse {
    /// Creates a new builder-style object to manufacture [`FindingTypeAggregationResponse`](crate::model::FindingTypeAggregationResponse)
    pub fn builder() -> crate::model::finding_type_aggregation_response::Builder {
        crate::model::finding_type_aggregation_response::Builder::default()
    }
}

/// <p>A response that contains the results of a finding aggregation by Amazon EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceAggregationResponse {
    /// <p>The Amazon EC2 instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Machine Image (AMI) of the Amazon EC2 instance.</p>
    pub ami: std::option::Option<std::string::String>,
    /// <p>The operating system of the Amazon EC2 instance.</p>
    pub operating_system: std::option::Option<std::string::String>,
    /// <p>The tags attached to the instance.</p>
    pub instance_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Web Services account the Amazon EC2 instance belongs to.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object that contains the count of matched findings per severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
    /// <p>The number of network findings for the Amazon EC2 instance.</p>
    pub network_findings: std::option::Option<i64>,
}
impl Ec2InstanceAggregationResponse {
    /// <p>The Amazon EC2 instance ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The Amazon Machine Image (AMI) of the Amazon EC2 instance.</p>
    pub fn ami(&self) -> std::option::Option<&str> {
        self.ami.as_deref()
    }
    /// <p>The operating system of the Amazon EC2 instance.</p>
    pub fn operating_system(&self) -> std::option::Option<&str> {
        self.operating_system.as_deref()
    }
    /// <p>The tags attached to the instance.</p>
    pub fn instance_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.instance_tags.as_ref()
    }
    /// <p>The Amazon Web Services account the Amazon EC2 instance belongs to.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object that contains the count of matched findings per severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
    /// <p>The number of network findings for the Amazon EC2 instance.</p>
    pub fn network_findings(&self) -> std::option::Option<i64> {
        self.network_findings
    }
}
impl std::fmt::Debug for Ec2InstanceAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceAggregationResponse");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("ami", &self.ami);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("instance_tags", &self.instance_tags);
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.field("network_findings", &self.network_findings);
        formatter.finish()
    }
}
/// See [`Ec2InstanceAggregationResponse`](crate::model::Ec2InstanceAggregationResponse)
pub mod ec2_instance_aggregation_response {
    /// A builder for [`Ec2InstanceAggregationResponse`](crate::model::Ec2InstanceAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) ami: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<std::string::String>,
        pub(crate) instance_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
        pub(crate) network_findings: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon EC2 instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The Amazon Machine Image (AMI) of the Amazon EC2 instance.</p>
        pub fn ami(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami = Some(input.into());
            self
        }
        /// <p>The Amazon Machine Image (AMI) of the Amazon EC2 instance.</p>
        pub fn set_ami(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami = input;
            self
        }
        /// <p>The operating system of the Amazon EC2 instance.</p>
        pub fn operating_system(mut self, input: impl Into<std::string::String>) -> Self {
            self.operating_system = Some(input.into());
            self
        }
        /// <p>The operating system of the Amazon EC2 instance.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// Adds a key-value pair to `instance_tags`.
        ///
        /// To override the contents of this collection use [`set_instance_tags`](Self::set_instance_tags).
        ///
        /// <p>The tags attached to the instance.</p>
        pub fn instance_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.instance_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.instance_tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the instance.</p>
        pub fn set_instance_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.instance_tags = input;
            self
        }
        /// <p>The Amazon Web Services account the Amazon EC2 instance belongs to.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account the Amazon EC2 instance belongs to.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An object that contains the count of matched findings per severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>An object that contains the count of matched findings per severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// <p>The number of network findings for the Amazon EC2 instance.</p>
        pub fn network_findings(mut self, input: i64) -> Self {
            self.network_findings = Some(input);
            self
        }
        /// <p>The number of network findings for the Amazon EC2 instance.</p>
        pub fn set_network_findings(mut self, input: std::option::Option<i64>) -> Self {
            self.network_findings = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceAggregationResponse`](crate::model::Ec2InstanceAggregationResponse)
        pub fn build(self) -> crate::model::Ec2InstanceAggregationResponse {
            crate::model::Ec2InstanceAggregationResponse {
                instance_id: self.instance_id,
                ami: self.ami,
                operating_system: self.operating_system,
                instance_tags: self.instance_tags,
                account_id: self.account_id,
                severity_counts: self.severity_counts,
                network_findings: self.network_findings,
            }
        }
    }
}
impl Ec2InstanceAggregationResponse {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceAggregationResponse`](crate::model::Ec2InstanceAggregationResponse)
    pub fn builder() -> crate::model::ec2_instance_aggregation_response::Builder {
        crate::model::ec2_instance_aggregation_response::Builder::default()
    }
}

/// <p>An aggregation of information about Amazon ECR containers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcrContainerAggregationResponse {
    /// <p>The resource ID of the container.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The SHA value of the container image.</p>
    pub image_sha: std::option::Option<std::string::String>,
    /// <p>The container repository.</p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>The architecture of the container.</p>
    pub architecture: std::option::Option<std::string::String>,
    /// <p>The container image stags.</p>
    pub image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Web Services account ID of the account that owns the container.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The number of finding by severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
}
impl AwsEcrContainerAggregationResponse {
    /// <p>The resource ID of the container.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The SHA value of the container image.</p>
    pub fn image_sha(&self) -> std::option::Option<&str> {
        self.image_sha.as_deref()
    }
    /// <p>The container repository.</p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>The architecture of the container.</p>
    pub fn architecture(&self) -> std::option::Option<&str> {
        self.architecture.as_deref()
    }
    /// <p>The container image stags.</p>
    pub fn image_tags(&self) -> std::option::Option<&[std::string::String]> {
        self.image_tags.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the account that owns the container.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The number of finding by severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
}
impl std::fmt::Debug for AwsEcrContainerAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcrContainerAggregationResponse");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("image_sha", &self.image_sha);
        formatter.field("repository", &self.repository);
        formatter.field("architecture", &self.architecture);
        formatter.field("image_tags", &self.image_tags);
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.finish()
    }
}
/// See [`AwsEcrContainerAggregationResponse`](crate::model::AwsEcrContainerAggregationResponse)
pub mod aws_ecr_container_aggregation_response {
    /// A builder for [`AwsEcrContainerAggregationResponse`](crate::model::AwsEcrContainerAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) image_sha: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<std::string::String>,
        pub(crate) image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
    }
    impl Builder {
        /// <p>The resource ID of the container.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the container.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The SHA value of the container image.</p>
        pub fn image_sha(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_sha = Some(input.into());
            self
        }
        /// <p>The SHA value of the container image.</p>
        pub fn set_image_sha(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_sha = input;
            self
        }
        /// <p>The container repository.</p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>The container repository.</p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>The architecture of the container.</p>
        pub fn architecture(mut self, input: impl Into<std::string::String>) -> Self {
            self.architecture = Some(input.into());
            self
        }
        /// <p>The architecture of the container.</p>
        pub fn set_architecture(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.architecture = input;
            self
        }
        /// Appends an item to `image_tags`.
        ///
        /// To override the contents of this collection use [`set_image_tags`](Self::set_image_tags).
        ///
        /// <p>The container image stags.</p>
        pub fn image_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.image_tags.unwrap_or_default();
            v.push(input.into());
            self.image_tags = Some(v);
            self
        }
        /// <p>The container image stags.</p>
        pub fn set_image_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.image_tags = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the account that owns the container.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the account that owns the container.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The number of finding by severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>The number of finding by severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcrContainerAggregationResponse`](crate::model::AwsEcrContainerAggregationResponse)
        pub fn build(self) -> crate::model::AwsEcrContainerAggregationResponse {
            crate::model::AwsEcrContainerAggregationResponse {
                resource_id: self.resource_id,
                image_sha: self.image_sha,
                repository: self.repository,
                architecture: self.architecture,
                image_tags: self.image_tags,
                account_id: self.account_id,
                severity_counts: self.severity_counts,
            }
        }
    }
}
impl AwsEcrContainerAggregationResponse {
    /// Creates a new builder-style object to manufacture [`AwsEcrContainerAggregationResponse`](crate::model::AwsEcrContainerAggregationResponse)
    pub fn builder() -> crate::model::aws_ecr_container_aggregation_response::Builder {
        crate::model::aws_ecr_container_aggregation_response::Builder::default()
    }
}

/// <p>A response that contains the results of a finding aggregation by AMI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmiAggregationResponse {
    /// <p>The ID of the AMI that findings were aggregated for.</p>
    pub ami: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID that the AMI belongs.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object that contains the count of matched findings per severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
    /// <p>The IDs of Amazon EC2 instances using this AMI.</p>
    pub affected_instances: std::option::Option<i64>,
}
impl AmiAggregationResponse {
    /// <p>The ID of the AMI that findings were aggregated for.</p>
    pub fn ami(&self) -> std::option::Option<&str> {
        self.ami.as_deref()
    }
    /// <p>The Amazon Web Services account ID that the AMI belongs.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object that contains the count of matched findings per severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
    /// <p>The IDs of Amazon EC2 instances using this AMI.</p>
    pub fn affected_instances(&self) -> std::option::Option<i64> {
        self.affected_instances
    }
}
impl std::fmt::Debug for AmiAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmiAggregationResponse");
        formatter.field("ami", &self.ami);
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.field("affected_instances", &self.affected_instances);
        formatter.finish()
    }
}
/// See [`AmiAggregationResponse`](crate::model::AmiAggregationResponse)
pub mod ami_aggregation_response {
    /// A builder for [`AmiAggregationResponse`](crate::model::AmiAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ami: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
        pub(crate) affected_instances: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID of the AMI that findings were aggregated for.</p>
        pub fn ami(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami = Some(input.into());
            self
        }
        /// <p>The ID of the AMI that findings were aggregated for.</p>
        pub fn set_ami(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami = input;
            self
        }
        /// <p>The Amazon Web Services account ID that the AMI belongs.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that the AMI belongs.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An object that contains the count of matched findings per severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>An object that contains the count of matched findings per severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// <p>The IDs of Amazon EC2 instances using this AMI.</p>
        pub fn affected_instances(mut self, input: i64) -> Self {
            self.affected_instances = Some(input);
            self
        }
        /// <p>The IDs of Amazon EC2 instances using this AMI.</p>
        pub fn set_affected_instances(mut self, input: std::option::Option<i64>) -> Self {
            self.affected_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`AmiAggregationResponse`](crate::model::AmiAggregationResponse)
        pub fn build(self) -> crate::model::AmiAggregationResponse {
            crate::model::AmiAggregationResponse {
                ami: self.ami,
                account_id: self.account_id,
                severity_counts: self.severity_counts,
                affected_instances: self.affected_instances,
            }
        }
    }
}
impl AmiAggregationResponse {
    /// Creates a new builder-style object to manufacture [`AmiAggregationResponse`](crate::model::AmiAggregationResponse)
    pub fn builder() -> crate::model::ami_aggregation_response::Builder {
        crate::model::ami_aggregation_response::Builder::default()
    }
}

/// <p>An aggregation of findings by Amazon Web Services account ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAggregationResponse {
    /// <p>The Amazon Web Services account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The number of findings by severity.</p>
    pub severity_counts: std::option::Option<crate::model::SeverityCounts>,
}
impl AccountAggregationResponse {
    /// <p>The Amazon Web Services account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The number of findings by severity.</p>
    pub fn severity_counts(&self) -> std::option::Option<&crate::model::SeverityCounts> {
        self.severity_counts.as_ref()
    }
}
impl std::fmt::Debug for AccountAggregationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAggregationResponse");
        formatter.field("account_id", &self.account_id);
        formatter.field("severity_counts", &self.severity_counts);
        formatter.finish()
    }
}
/// See [`AccountAggregationResponse`](crate::model::AccountAggregationResponse)
pub mod account_aggregation_response {
    /// A builder for [`AccountAggregationResponse`](crate::model::AccountAggregationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) severity_counts: std::option::Option<crate::model::SeverityCounts>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The number of findings by severity.</p>
        pub fn severity_counts(mut self, input: crate::model::SeverityCounts) -> Self {
            self.severity_counts = Some(input);
            self
        }
        /// <p>The number of findings by severity.</p>
        pub fn set_severity_counts(
            mut self,
            input: std::option::Option<crate::model::SeverityCounts>,
        ) -> Self {
            self.severity_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAggregationResponse`](crate::model::AccountAggregationResponse)
        pub fn build(self) -> crate::model::AccountAggregationResponse {
            crate::model::AccountAggregationResponse {
                account_id: self.account_id,
                severity_counts: self.severity_counts,
            }
        }
    }
}
impl AccountAggregationResponse {
    /// Creates a new builder-style object to manufacture [`AccountAggregationResponse`](crate::model::AccountAggregationResponse)
    pub fn builder() -> crate::model::account_aggregation_response::Builder {
        crate::model::account_aggregation_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregationType {
    #[allow(missing_docs)] // documentation missing in model
    Account,
    #[allow(missing_docs)] // documentation missing in model
    Ami,
    #[allow(missing_docs)] // documentation missing in model
    AwsEc2Instance,
    #[allow(missing_docs)] // documentation missing in model
    AwsEcrContainer,
    #[allow(missing_docs)] // documentation missing in model
    FindingType,
    #[allow(missing_docs)] // documentation missing in model
    ImageLayer,
    #[allow(missing_docs)] // documentation missing in model
    Package,
    #[allow(missing_docs)] // documentation missing in model
    Repository,
    #[allow(missing_docs)] // documentation missing in model
    Title,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregationType {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT" => AggregationType::Account,
            "AMI" => AggregationType::Ami,
            "AWS_EC2_INSTANCE" => AggregationType::AwsEc2Instance,
            "AWS_ECR_CONTAINER" => AggregationType::AwsEcrContainer,
            "FINDING_TYPE" => AggregationType::FindingType,
            "IMAGE_LAYER" => AggregationType::ImageLayer,
            "PACKAGE" => AggregationType::Package,
            "REPOSITORY" => AggregationType::Repository,
            "TITLE" => AggregationType::Title,
            other => AggregationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregationType::from(s))
    }
}
impl AggregationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregationType::Account => "ACCOUNT",
            AggregationType::Ami => "AMI",
            AggregationType::AwsEc2Instance => "AWS_EC2_INSTANCE",
            AggregationType::AwsEcrContainer => "AWS_ECR_CONTAINER",
            AggregationType::FindingType => "FINDING_TYPE",
            AggregationType::ImageLayer => "IMAGE_LAYER",
            AggregationType::Package => "PACKAGE",
            AggregationType::Repository => "REPOSITORY",
            AggregationType::Title => "TITLE",
            AggregationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT",
            "AMI",
            "AWS_EC2_INSTANCE",
            "AWS_ECR_CONTAINER",
            "FINDING_TYPE",
            "IMAGE_LAYER",
            "PACKAGE",
            "REPOSITORY",
            "TITLE",
        ]
    }
}
impl AsRef<str> for AggregationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about an aggregation request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AggregationRequest {
    /// <p>An object that contains details about an aggregation request based on Amazon Web Services account IDs.</p>
    AccountAggregation(crate::model::AccountAggregation),
    /// <p>An object that contains details about an aggregation request based on Amazon Machine Images (AMIs).</p>
    AmiAggregation(crate::model::AmiAggregation),
    /// <p>An object that contains details about an aggregation request based on Amazon ECR container images.</p>
    AwsEcrContainerAggregation(crate::model::AwsEcrContainerAggregation),
    /// <p>An object that contains details about an aggregation request based on Amazon EC2 instances.</p>
    Ec2InstanceAggregation(crate::model::Ec2InstanceAggregation),
    /// <p>An object that contains details about an aggregation request based on finding types.</p>
    FindingTypeAggregation(crate::model::FindingTypeAggregation),
    /// <p>An object that contains details about an aggregation request based on container image layers.</p>
    ImageLayerAggregation(crate::model::ImageLayerAggregation),
    /// <p>An object that contains details about an aggregation request based on operating system package type.</p>
    PackageAggregation(crate::model::PackageAggregation),
    /// <p>An object that contains details about an aggregation request based on Amazon ECR repositories.</p>
    RepositoryAggregation(crate::model::RepositoryAggregation),
    /// <p>An object that contains details about an aggregation request based on finding title.</p>
    TitleAggregation(crate::model::TitleAggregation),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AggregationRequest {
    /// Tries to convert the enum instance into [`AccountAggregation`](crate::model::AggregationRequest::AccountAggregation), extracting the inner [`AccountAggregation`](crate::model::AccountAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_account_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::AccountAggregation, &Self> {
        if let AggregationRequest::AccountAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AccountAggregation`](crate::model::AggregationRequest::AccountAggregation).
    pub fn is_account_aggregation(&self) -> bool {
        self.as_account_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`AmiAggregation`](crate::model::AggregationRequest::AmiAggregation), extracting the inner [`AmiAggregation`](crate::model::AmiAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ami_aggregation(&self) -> std::result::Result<&crate::model::AmiAggregation, &Self> {
        if let AggregationRequest::AmiAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AmiAggregation`](crate::model::AggregationRequest::AmiAggregation).
    pub fn is_ami_aggregation(&self) -> bool {
        self.as_ami_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`AwsEcrContainerAggregation`](crate::model::AggregationRequest::AwsEcrContainerAggregation), extracting the inner [`AwsEcrContainerAggregation`](crate::model::AwsEcrContainerAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aws_ecr_container_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::AwsEcrContainerAggregation, &Self> {
        if let AggregationRequest::AwsEcrContainerAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AwsEcrContainerAggregation`](crate::model::AggregationRequest::AwsEcrContainerAggregation).
    pub fn is_aws_ecr_container_aggregation(&self) -> bool {
        self.as_aws_ecr_container_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`Ec2InstanceAggregation`](crate::model::AggregationRequest::Ec2InstanceAggregation), extracting the inner [`Ec2InstanceAggregation`](crate::model::Ec2InstanceAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ec2_instance_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::Ec2InstanceAggregation, &Self> {
        if let AggregationRequest::Ec2InstanceAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Ec2InstanceAggregation`](crate::model::AggregationRequest::Ec2InstanceAggregation).
    pub fn is_ec2_instance_aggregation(&self) -> bool {
        self.as_ec2_instance_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`FindingTypeAggregation`](crate::model::AggregationRequest::FindingTypeAggregation), extracting the inner [`FindingTypeAggregation`](crate::model::FindingTypeAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_finding_type_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::FindingTypeAggregation, &Self> {
        if let AggregationRequest::FindingTypeAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`FindingTypeAggregation`](crate::model::AggregationRequest::FindingTypeAggregation).
    pub fn is_finding_type_aggregation(&self) -> bool {
        self.as_finding_type_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`ImageLayerAggregation`](crate::model::AggregationRequest::ImageLayerAggregation), extracting the inner [`ImageLayerAggregation`](crate::model::ImageLayerAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_image_layer_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::ImageLayerAggregation, &Self> {
        if let AggregationRequest::ImageLayerAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ImageLayerAggregation`](crate::model::AggregationRequest::ImageLayerAggregation).
    pub fn is_image_layer_aggregation(&self) -> bool {
        self.as_image_layer_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`PackageAggregation`](crate::model::AggregationRequest::PackageAggregation), extracting the inner [`PackageAggregation`](crate::model::PackageAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_package_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::PackageAggregation, &Self> {
        if let AggregationRequest::PackageAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`PackageAggregation`](crate::model::AggregationRequest::PackageAggregation).
    pub fn is_package_aggregation(&self) -> bool {
        self.as_package_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`RepositoryAggregation`](crate::model::AggregationRequest::RepositoryAggregation), extracting the inner [`RepositoryAggregation`](crate::model::RepositoryAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_repository_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::RepositoryAggregation, &Self> {
        if let AggregationRequest::RepositoryAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`RepositoryAggregation`](crate::model::AggregationRequest::RepositoryAggregation).
    pub fn is_repository_aggregation(&self) -> bool {
        self.as_repository_aggregation().is_ok()
    }
    /// Tries to convert the enum instance into [`TitleAggregation`](crate::model::AggregationRequest::TitleAggregation), extracting the inner [`TitleAggregation`](crate::model::TitleAggregation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_title_aggregation(
        &self,
    ) -> std::result::Result<&crate::model::TitleAggregation, &Self> {
        if let AggregationRequest::TitleAggregation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`TitleAggregation`](crate::model::AggregationRequest::TitleAggregation).
    pub fn is_title_aggregation(&self) -> bool {
        self.as_title_aggregation().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>The details that define an aggregation based on finding title.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TitleAggregation {
    /// <p>The finding titles to aggregate on.</p>
    pub titles: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The vulnerability IDs of the findings.</p>
    pub vulnerability_ids: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The resource type to aggregate on.</p>
    pub resource_type: std::option::Option<crate::model::AggregationResourceType>,
    /// <p>The order to sort results by.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort results by.</p>
    pub sort_by: std::option::Option<crate::model::TitleSortBy>,
}
impl TitleAggregation {
    /// <p>The finding titles to aggregate on.</p>
    pub fn titles(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.titles.as_deref()
    }
    /// <p>The vulnerability IDs of the findings.</p>
    pub fn vulnerability_ids(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.vulnerability_ids.as_deref()
    }
    /// <p>The resource type to aggregate on.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::AggregationResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The order to sort results by.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort results by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::TitleSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for TitleAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TitleAggregation");
        formatter.field("titles", &self.titles);
        formatter.field("vulnerability_ids", &self.vulnerability_ids);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`TitleAggregation`](crate::model::TitleAggregation)
pub mod title_aggregation {
    /// A builder for [`TitleAggregation`](crate::model::TitleAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) titles: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) vulnerability_ids:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_type: std::option::Option<crate::model::AggregationResourceType>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::TitleSortBy>,
    }
    impl Builder {
        /// Appends an item to `titles`.
        ///
        /// To override the contents of this collection use [`set_titles`](Self::set_titles).
        ///
        /// <p>The finding titles to aggregate on.</p>
        pub fn titles(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.titles.unwrap_or_default();
            v.push(input);
            self.titles = Some(v);
            self
        }
        /// <p>The finding titles to aggregate on.</p>
        pub fn set_titles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.titles = input;
            self
        }
        /// Appends an item to `vulnerability_ids`.
        ///
        /// To override the contents of this collection use [`set_vulnerability_ids`](Self::set_vulnerability_ids).
        ///
        /// <p>The vulnerability IDs of the findings.</p>
        pub fn vulnerability_ids(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.vulnerability_ids.unwrap_or_default();
            v.push(input);
            self.vulnerability_ids = Some(v);
            self
        }
        /// <p>The vulnerability IDs of the findings.</p>
        pub fn set_vulnerability_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.vulnerability_ids = input;
            self
        }
        /// <p>The resource type to aggregate on.</p>
        pub fn resource_type(mut self, input: crate::model::AggregationResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type to aggregate on.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::AggregationResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn sort_by(mut self, input: crate::model::TitleSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::TitleSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`TitleAggregation`](crate::model::TitleAggregation)
        pub fn build(self) -> crate::model::TitleAggregation {
            crate::model::TitleAggregation {
                titles: self.titles,
                vulnerability_ids: self.vulnerability_ids,
                resource_type: self.resource_type,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl TitleAggregation {
    /// Creates a new builder-style object to manufacture [`TitleAggregation`](crate::model::TitleAggregation)
    pub fn builder() -> crate::model::title_aggregation::Builder {
        crate::model::title_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TitleSortBy {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TitleSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => TitleSortBy::All,
            "CRITICAL" => TitleSortBy::Critical,
            "HIGH" => TitleSortBy::High,
            other => TitleSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TitleSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TitleSortBy::from(s))
    }
}
impl TitleSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TitleSortBy::All => "ALL",
            TitleSortBy::Critical => "CRITICAL",
            TitleSortBy::High => "HIGH",
            TitleSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for TitleSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregationResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AwsEc2Instance,
    #[allow(missing_docs)] // documentation missing in model
    AwsEcrContainerImage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregationResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_EC2_INSTANCE" => AggregationResourceType::AwsEc2Instance,
            "AWS_ECR_CONTAINER_IMAGE" => AggregationResourceType::AwsEcrContainerImage,
            other => AggregationResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregationResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregationResourceType::from(s))
    }
}
impl AggregationResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregationResourceType::AwsEc2Instance => "AWS_EC2_INSTANCE",
            AggregationResourceType::AwsEcrContainerImage => "AWS_ECR_CONTAINER_IMAGE",
            AggregationResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_EC2_INSTANCE", "AWS_ECR_CONTAINER_IMAGE"]
    }
}
impl AsRef<str> for AggregationResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details that define an aggregation based on repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryAggregation {
    /// <p>The names of repositories to aggregate findings on.</p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The order to sort results by.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort results by.</p>
    pub sort_by: std::option::Option<crate::model::RepositorySortBy>,
}
impl RepositoryAggregation {
    /// <p>The names of repositories to aggregate findings on.</p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.repositories.as_deref()
    }
    /// <p>The order to sort results by.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort results by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::RepositorySortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for RepositoryAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryAggregation");
        formatter.field("repositories", &self.repositories);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`RepositoryAggregation`](crate::model::RepositoryAggregation)
pub mod repository_aggregation {
    /// A builder for [`RepositoryAggregation`](crate::model::RepositoryAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::RepositorySortBy>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>The names of repositories to aggregate findings on.</p>
        pub fn repositories(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input);
            self.repositories = Some(v);
            self
        }
        /// <p>The names of repositories to aggregate findings on.</p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn sort_by(mut self, input: crate::model::RepositorySortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::RepositorySortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryAggregation`](crate::model::RepositoryAggregation)
        pub fn build(self) -> crate::model::RepositoryAggregation {
            crate::model::RepositoryAggregation {
                repositories: self.repositories,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl RepositoryAggregation {
    /// Creates a new builder-style object to manufacture [`RepositoryAggregation`](crate::model::RepositoryAggregation)
    pub fn builder() -> crate::model::repository_aggregation::Builder {
        crate::model::repository_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RepositorySortBy {
    #[allow(missing_docs)] // documentation missing in model
    AffectedImages,
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RepositorySortBy {
    fn from(s: &str) -> Self {
        match s {
            "AFFECTED_IMAGES" => RepositorySortBy::AffectedImages,
            "ALL" => RepositorySortBy::All,
            "CRITICAL" => RepositorySortBy::Critical,
            "HIGH" => RepositorySortBy::High,
            other => RepositorySortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RepositorySortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RepositorySortBy::from(s))
    }
}
impl RepositorySortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RepositorySortBy::AffectedImages => "AFFECTED_IMAGES",
            RepositorySortBy::All => "ALL",
            RepositorySortBy::Critical => "CRITICAL",
            RepositorySortBy::High => "HIGH",
            RepositorySortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AFFECTED_IMAGES", "ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for RepositorySortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details that define an aggregation based on operating system package type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageAggregation {
    /// <p>The names of packages to aggregate findings on.</p>
    pub package_names: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The order to sort results by.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort results by.</p>
    pub sort_by: std::option::Option<crate::model::PackageSortBy>,
}
impl PackageAggregation {
    /// <p>The names of packages to aggregate findings on.</p>
    pub fn package_names(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.package_names.as_deref()
    }
    /// <p>The order to sort results by.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort results by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::PackageSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for PackageAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageAggregation");
        formatter.field("package_names", &self.package_names);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`PackageAggregation`](crate::model::PackageAggregation)
pub mod package_aggregation {
    /// A builder for [`PackageAggregation`](crate::model::PackageAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_names: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::PackageSortBy>,
    }
    impl Builder {
        /// Appends an item to `package_names`.
        ///
        /// To override the contents of this collection use [`set_package_names`](Self::set_package_names).
        ///
        /// <p>The names of packages to aggregate findings on.</p>
        pub fn package_names(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.package_names.unwrap_or_default();
            v.push(input);
            self.package_names = Some(v);
            self
        }
        /// <p>The names of packages to aggregate findings on.</p>
        pub fn set_package_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.package_names = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn sort_by(mut self, input: crate::model::PackageSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::PackageSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageAggregation`](crate::model::PackageAggregation)
        pub fn build(self) -> crate::model::PackageAggregation {
            crate::model::PackageAggregation {
                package_names: self.package_names,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl PackageAggregation {
    /// Creates a new builder-style object to manufacture [`PackageAggregation`](crate::model::PackageAggregation)
    pub fn builder() -> crate::model::package_aggregation::Builder {
        crate::model::package_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageSortBy {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => PackageSortBy::All,
            "CRITICAL" => PackageSortBy::Critical,
            "HIGH" => PackageSortBy::High,
            other => PackageSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageSortBy::from(s))
    }
}
impl PackageSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageSortBy::All => "ALL",
            PackageSortBy::Critical => "CRITICAL",
            PackageSortBy::High => "HIGH",
            PackageSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for PackageSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details that define an aggregation based on container image layers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageLayerAggregation {
    /// <p>The repository associated with the container image hosting the layers.</p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The ID of the container image layer.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The hashes associated with the layers.</p>
    pub layer_hashes: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The order to sort results by.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort results by.</p>
    pub sort_by: std::option::Option<crate::model::ImageLayerSortBy>,
}
impl ImageLayerAggregation {
    /// <p>The repository associated with the container image hosting the layers.</p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.repositories.as_deref()
    }
    /// <p>The ID of the container image layer.</p>
    pub fn resource_ids(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.resource_ids.as_deref()
    }
    /// <p>The hashes associated with the layers.</p>
    pub fn layer_hashes(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.layer_hashes.as_deref()
    }
    /// <p>The order to sort results by.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort results by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::ImageLayerSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for ImageLayerAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageLayerAggregation");
        formatter.field("repositories", &self.repositories);
        formatter.field("resource_ids", &self.resource_ids);
        formatter.field("layer_hashes", &self.layer_hashes);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`ImageLayerAggregation`](crate::model::ImageLayerAggregation)
pub mod image_layer_aggregation {
    /// A builder for [`ImageLayerAggregation`](crate::model::ImageLayerAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) layer_hashes: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::ImageLayerSortBy>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>The repository associated with the container image hosting the layers.</p>
        pub fn repositories(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input);
            self.repositories = Some(v);
            self
        }
        /// <p>The repository associated with the container image hosting the layers.</p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The ID of the container image layer.</p>
        pub fn resource_ids(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input);
            self.resource_ids = Some(v);
            self
        }
        /// <p>The ID of the container image layer.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Appends an item to `layer_hashes`.
        ///
        /// To override the contents of this collection use [`set_layer_hashes`](Self::set_layer_hashes).
        ///
        /// <p>The hashes associated with the layers.</p>
        pub fn layer_hashes(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.layer_hashes.unwrap_or_default();
            v.push(input);
            self.layer_hashes = Some(v);
            self
        }
        /// <p>The hashes associated with the layers.</p>
        pub fn set_layer_hashes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.layer_hashes = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn sort_by(mut self, input: crate::model::ImageLayerSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ImageLayerSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageLayerAggregation`](crate::model::ImageLayerAggregation)
        pub fn build(self) -> crate::model::ImageLayerAggregation {
            crate::model::ImageLayerAggregation {
                repositories: self.repositories,
                resource_ids: self.resource_ids,
                layer_hashes: self.layer_hashes,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl ImageLayerAggregation {
    /// Creates a new builder-style object to manufacture [`ImageLayerAggregation`](crate::model::ImageLayerAggregation)
    pub fn builder() -> crate::model::image_layer_aggregation::Builder {
        crate::model::image_layer_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageLayerSortBy {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageLayerSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ImageLayerSortBy::All,
            "CRITICAL" => ImageLayerSortBy::Critical,
            "HIGH" => ImageLayerSortBy::High,
            other => ImageLayerSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageLayerSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageLayerSortBy::from(s))
    }
}
impl ImageLayerSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageLayerSortBy::All => "ALL",
            ImageLayerSortBy::Critical => "CRITICAL",
            ImageLayerSortBy::High => "HIGH",
            ImageLayerSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for ImageLayerSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details that define an aggregation based on finding type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingTypeAggregation {
    /// <p>The finding type to aggregate.</p>
    pub finding_type: std::option::Option<crate::model::AggregationFindingType>,
    /// <p>The resource type to aggregate.</p>
    pub resource_type: std::option::Option<crate::model::AggregationResourceType>,
    /// <p>The order to sort results by.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort results by.</p>
    pub sort_by: std::option::Option<crate::model::FindingTypeSortBy>,
}
impl FindingTypeAggregation {
    /// <p>The finding type to aggregate.</p>
    pub fn finding_type(&self) -> std::option::Option<&crate::model::AggregationFindingType> {
        self.finding_type.as_ref()
    }
    /// <p>The resource type to aggregate.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::AggregationResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The order to sort results by.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort results by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::FindingTypeSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for FindingTypeAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingTypeAggregation");
        formatter.field("finding_type", &self.finding_type);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`FindingTypeAggregation`](crate::model::FindingTypeAggregation)
pub mod finding_type_aggregation {
    /// A builder for [`FindingTypeAggregation`](crate::model::FindingTypeAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_type: std::option::Option<crate::model::AggregationFindingType>,
        pub(crate) resource_type: std::option::Option<crate::model::AggregationResourceType>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::FindingTypeSortBy>,
    }
    impl Builder {
        /// <p>The finding type to aggregate.</p>
        pub fn finding_type(mut self, input: crate::model::AggregationFindingType) -> Self {
            self.finding_type = Some(input);
            self
        }
        /// <p>The finding type to aggregate.</p>
        pub fn set_finding_type(
            mut self,
            input: std::option::Option<crate::model::AggregationFindingType>,
        ) -> Self {
            self.finding_type = input;
            self
        }
        /// <p>The resource type to aggregate.</p>
        pub fn resource_type(mut self, input: crate::model::AggregationResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type to aggregate.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::AggregationResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn sort_by(mut self, input: crate::model::FindingTypeSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::FindingTypeSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingTypeAggregation`](crate::model::FindingTypeAggregation)
        pub fn build(self) -> crate::model::FindingTypeAggregation {
            crate::model::FindingTypeAggregation {
                finding_type: self.finding_type,
                resource_type: self.resource_type,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl FindingTypeAggregation {
    /// Creates a new builder-style object to manufacture [`FindingTypeAggregation`](crate::model::FindingTypeAggregation)
    pub fn builder() -> crate::model::finding_type_aggregation::Builder {
        crate::model::finding_type_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingTypeSortBy {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingTypeSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => FindingTypeSortBy::All,
            "CRITICAL" => FindingTypeSortBy::Critical,
            "HIGH" => FindingTypeSortBy::High,
            other => FindingTypeSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingTypeSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingTypeSortBy::from(s))
    }
}
impl FindingTypeSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingTypeSortBy::All => "ALL",
            FindingTypeSortBy::Critical => "CRITICAL",
            FindingTypeSortBy::High => "HIGH",
            FindingTypeSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for FindingTypeSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregationFindingType {
    #[allow(missing_docs)] // documentation missing in model
    NetworkReachability,
    #[allow(missing_docs)] // documentation missing in model
    PackageVulnerability,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregationFindingType {
    fn from(s: &str) -> Self {
        match s {
            "NETWORK_REACHABILITY" => AggregationFindingType::NetworkReachability,
            "PACKAGE_VULNERABILITY" => AggregationFindingType::PackageVulnerability,
            other => AggregationFindingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregationFindingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregationFindingType::from(s))
    }
}
impl AggregationFindingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregationFindingType::NetworkReachability => "NETWORK_REACHABILITY",
            AggregationFindingType::PackageVulnerability => "PACKAGE_VULNERABILITY",
            AggregationFindingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NETWORK_REACHABILITY", "PACKAGE_VULNERABILITY"]
    }
}
impl AsRef<str> for AggregationFindingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details that define an aggregation based on Amazon EC2 instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceAggregation {
    /// <p>The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.</p>
    pub amis: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.</p>
    pub operating_systems: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The Amazon EC2 instance IDs to aggregate findings for.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The Amazon EC2 instance tags to aggregate findings for.</p>
    pub instance_tags: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
    /// <p>The order to sort results by.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort results by.</p>
    pub sort_by: std::option::Option<crate::model::Ec2InstanceSortBy>,
}
impl Ec2InstanceAggregation {
    /// <p>The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.</p>
    pub fn amis(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.amis.as_deref()
    }
    /// <p>The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.</p>
    pub fn operating_systems(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.operating_systems.as_deref()
    }
    /// <p>The Amazon EC2 instance IDs to aggregate findings for.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.instance_ids.as_deref()
    }
    /// <p>The Amazon EC2 instance tags to aggregate findings for.</p>
    pub fn instance_tags(&self) -> std::option::Option<&[crate::model::MapFilter]> {
        self.instance_tags.as_deref()
    }
    /// <p>The order to sort results by.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort results by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::Ec2InstanceSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for Ec2InstanceAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceAggregation");
        formatter.field("amis", &self.amis);
        formatter.field("operating_systems", &self.operating_systems);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("instance_tags", &self.instance_tags);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`Ec2InstanceAggregation`](crate::model::Ec2InstanceAggregation)
pub mod ec2_instance_aggregation {
    /// A builder for [`Ec2InstanceAggregation`](crate::model::Ec2InstanceAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amis: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) operating_systems:
            std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) instance_tags: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::Ec2InstanceSortBy>,
    }
    impl Builder {
        /// Appends an item to `amis`.
        ///
        /// To override the contents of this collection use [`set_amis`](Self::set_amis).
        ///
        /// <p>The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.</p>
        pub fn amis(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.amis.unwrap_or_default();
            v.push(input);
            self.amis = Some(v);
            self
        }
        /// <p>The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.</p>
        pub fn set_amis(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.amis = input;
            self
        }
        /// Appends an item to `operating_systems`.
        ///
        /// To override the contents of this collection use [`set_operating_systems`](Self::set_operating_systems).
        ///
        /// <p>The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.</p>
        pub fn operating_systems(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.operating_systems.unwrap_or_default();
            v.push(input);
            self.operating_systems = Some(v);
            self
        }
        /// <p>The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.</p>
        pub fn set_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.operating_systems = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The Amazon EC2 instance IDs to aggregate findings for.</p>
        pub fn instance_ids(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input);
            self.instance_ids = Some(v);
            self
        }
        /// <p>The Amazon EC2 instance IDs to aggregate findings for.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Appends an item to `instance_tags`.
        ///
        /// To override the contents of this collection use [`set_instance_tags`](Self::set_instance_tags).
        ///
        /// <p>The Amazon EC2 instance tags to aggregate findings for.</p>
        pub fn instance_tags(mut self, input: crate::model::MapFilter) -> Self {
            let mut v = self.instance_tags.unwrap_or_default();
            v.push(input);
            self.instance_tags = Some(v);
            self
        }
        /// <p>The Amazon EC2 instance tags to aggregate findings for.</p>
        pub fn set_instance_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MapFilter>>,
        ) -> Self {
            self.instance_tags = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn sort_by(mut self, input: crate::model::Ec2InstanceSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceAggregation`](crate::model::Ec2InstanceAggregation)
        pub fn build(self) -> crate::model::Ec2InstanceAggregation {
            crate::model::Ec2InstanceAggregation {
                amis: self.amis,
                operating_systems: self.operating_systems,
                instance_ids: self.instance_ids,
                instance_tags: self.instance_tags,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl Ec2InstanceAggregation {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceAggregation`](crate::model::Ec2InstanceAggregation)
    pub fn builder() -> crate::model::ec2_instance_aggregation::Builder {
        crate::model::ec2_instance_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Ec2InstanceSortBy {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    NetworkFindings,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Ec2InstanceSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Ec2InstanceSortBy::All,
            "CRITICAL" => Ec2InstanceSortBy::Critical,
            "HIGH" => Ec2InstanceSortBy::High,
            "NETWORK_FINDINGS" => Ec2InstanceSortBy::NetworkFindings,
            other => Ec2InstanceSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Ec2InstanceSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Ec2InstanceSortBy::from(s))
    }
}
impl Ec2InstanceSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Ec2InstanceSortBy::All => "ALL",
            Ec2InstanceSortBy::Critical => "CRITICAL",
            Ec2InstanceSortBy::High => "HIGH",
            Ec2InstanceSortBy::NetworkFindings => "NETWORK_FINDINGS",
            Ec2InstanceSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CRITICAL", "HIGH", "NETWORK_FINDINGS"]
    }
}
impl AsRef<str> for Ec2InstanceSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An aggregation of information about Amazon ECR containers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsEcrContainerAggregation {
    /// <p>The container resource IDs.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The image SHA values.</p>
    pub image_shas: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The container repositories.</p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The architecture of the containers.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The image tags.</p>
    pub image_tags: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The sort order (ascending or descending).</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort by.</p>
    pub sort_by: std::option::Option<crate::model::AwsEcrContainerSortBy>,
}
impl AwsEcrContainerAggregation {
    /// <p>The container resource IDs.</p>
    pub fn resource_ids(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.resource_ids.as_deref()
    }
    /// <p>The image SHA values.</p>
    pub fn image_shas(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.image_shas.as_deref()
    }
    /// <p>The container repositories.</p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.repositories.as_deref()
    }
    /// <p>The architecture of the containers.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.architectures.as_deref()
    }
    /// <p>The image tags.</p>
    pub fn image_tags(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.image_tags.as_deref()
    }
    /// <p>The sort order (ascending or descending).</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::AwsEcrContainerSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for AwsEcrContainerAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsEcrContainerAggregation");
        formatter.field("resource_ids", &self.resource_ids);
        formatter.field("image_shas", &self.image_shas);
        formatter.field("repositories", &self.repositories);
        formatter.field("architectures", &self.architectures);
        formatter.field("image_tags", &self.image_tags);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`AwsEcrContainerAggregation`](crate::model::AwsEcrContainerAggregation)
pub mod aws_ecr_container_aggregation {
    /// A builder for [`AwsEcrContainerAggregation`](crate::model::AwsEcrContainerAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) image_shas: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) repositories: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) image_tags: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::AwsEcrContainerSortBy>,
    }
    impl Builder {
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The container resource IDs.</p>
        pub fn resource_ids(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input);
            self.resource_ids = Some(v);
            self
        }
        /// <p>The container resource IDs.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Appends an item to `image_shas`.
        ///
        /// To override the contents of this collection use [`set_image_shas`](Self::set_image_shas).
        ///
        /// <p>The image SHA values.</p>
        pub fn image_shas(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.image_shas.unwrap_or_default();
            v.push(input);
            self.image_shas = Some(v);
            self
        }
        /// <p>The image SHA values.</p>
        pub fn set_image_shas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.image_shas = input;
            self
        }
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>The container repositories.</p>
        pub fn repositories(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input);
            self.repositories = Some(v);
            self
        }
        /// <p>The container repositories.</p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The architecture of the containers.</p>
        pub fn architectures(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input);
            self.architectures = Some(v);
            self
        }
        /// <p>The architecture of the containers.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Appends an item to `image_tags`.
        ///
        /// To override the contents of this collection use [`set_image_tags`](Self::set_image_tags).
        ///
        /// <p>The image tags.</p>
        pub fn image_tags(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.image_tags.unwrap_or_default();
            v.push(input);
            self.image_tags = Some(v);
            self
        }
        /// <p>The image tags.</p>
        pub fn set_image_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.image_tags = input;
            self
        }
        /// <p>The sort order (ascending or descending).</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The sort order (ascending or descending).</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort by.</p>
        pub fn sort_by(mut self, input: crate::model::AwsEcrContainerSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AwsEcrContainerSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsEcrContainerAggregation`](crate::model::AwsEcrContainerAggregation)
        pub fn build(self) -> crate::model::AwsEcrContainerAggregation {
            crate::model::AwsEcrContainerAggregation {
                resource_ids: self.resource_ids,
                image_shas: self.image_shas,
                repositories: self.repositories,
                architectures: self.architectures,
                image_tags: self.image_tags,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl AwsEcrContainerAggregation {
    /// Creates a new builder-style object to manufacture [`AwsEcrContainerAggregation`](crate::model::AwsEcrContainerAggregation)
    pub fn builder() -> crate::model::aws_ecr_container_aggregation::Builder {
        crate::model::aws_ecr_container_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AwsEcrContainerSortBy {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AwsEcrContainerSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => AwsEcrContainerSortBy::All,
            "CRITICAL" => AwsEcrContainerSortBy::Critical,
            "HIGH" => AwsEcrContainerSortBy::High,
            other => AwsEcrContainerSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AwsEcrContainerSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AwsEcrContainerSortBy::from(s))
    }
}
impl AwsEcrContainerSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AwsEcrContainerSortBy::All => "ALL",
            AwsEcrContainerSortBy::Critical => "CRITICAL",
            AwsEcrContainerSortBy::High => "HIGH",
            AwsEcrContainerSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for AwsEcrContainerSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details that define an aggregation based on Amazon machine images (AMIs).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmiAggregation {
    /// <p>The IDs of AMIs to aggregate findings for.</p>
    pub amis: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
    /// <p>The order to sort results by.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort results by.</p>
    pub sort_by: std::option::Option<crate::model::AmiSortBy>,
}
impl AmiAggregation {
    /// <p>The IDs of AMIs to aggregate findings for.</p>
    pub fn amis(&self) -> std::option::Option<&[crate::model::StringFilter]> {
        self.amis.as_deref()
    }
    /// <p>The order to sort results by.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort results by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::AmiSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for AmiAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmiAggregation");
        formatter.field("amis", &self.amis);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`AmiAggregation`](crate::model::AmiAggregation)
pub mod ami_aggregation {
    /// A builder for [`AmiAggregation`](crate::model::AmiAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amis: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::AmiSortBy>,
    }
    impl Builder {
        /// Appends an item to `amis`.
        ///
        /// To override the contents of this collection use [`set_amis`](Self::set_amis).
        ///
        /// <p>The IDs of AMIs to aggregate findings for.</p>
        pub fn amis(mut self, input: crate::model::StringFilter) -> Self {
            let mut v = self.amis.unwrap_or_default();
            v.push(input);
            self.amis = Some(v);
            self
        }
        /// <p>The IDs of AMIs to aggregate findings for.</p>
        pub fn set_amis(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StringFilter>>,
        ) -> Self {
            self.amis = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn sort_by(mut self, input: crate::model::AmiSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort results by.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::AmiSortBy>) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`AmiAggregation`](crate::model::AmiAggregation)
        pub fn build(self) -> crate::model::AmiAggregation {
            crate::model::AmiAggregation {
                amis: self.amis,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl AmiAggregation {
    /// Creates a new builder-style object to manufacture [`AmiAggregation`](crate::model::AmiAggregation)
    pub fn builder() -> crate::model::ami_aggregation::Builder {
        crate::model::ami_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AmiSortBy {
    #[allow(missing_docs)] // documentation missing in model
    AffectedInstances,
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AmiSortBy {
    fn from(s: &str) -> Self {
        match s {
            "AFFECTED_INSTANCES" => AmiSortBy::AffectedInstances,
            "ALL" => AmiSortBy::All,
            "CRITICAL" => AmiSortBy::Critical,
            "HIGH" => AmiSortBy::High,
            other => AmiSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AmiSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AmiSortBy::from(s))
    }
}
impl AmiSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AmiSortBy::AffectedInstances => "AFFECTED_INSTANCES",
            AmiSortBy::All => "ALL",
            AmiSortBy::Critical => "CRITICAL",
            AmiSortBy::High => "HIGH",
            AmiSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AFFECTED_INSTANCES", "ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for AmiSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains details about an aggregation response based on Amazon Web Services accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAggregation {
    /// <p>The type of finding.</p>
    pub finding_type: std::option::Option<crate::model::AggregationFindingType>,
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<crate::model::AggregationResourceType>,
    /// <p>The sort order (ascending or descending).</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The value to sort by.</p>
    pub sort_by: std::option::Option<crate::model::AccountSortBy>,
}
impl AccountAggregation {
    /// <p>The type of finding.</p>
    pub fn finding_type(&self) -> std::option::Option<&crate::model::AggregationFindingType> {
        self.finding_type.as_ref()
    }
    /// <p>The type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::AggregationResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The sort order (ascending or descending).</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The value to sort by.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::AccountSortBy> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for AccountAggregation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAggregation");
        formatter.field("finding_type", &self.finding_type);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}
/// See [`AccountAggregation`](crate::model::AccountAggregation)
pub mod account_aggregation {
    /// A builder for [`AccountAggregation`](crate::model::AccountAggregation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_type: std::option::Option<crate::model::AggregationFindingType>,
        pub(crate) resource_type: std::option::Option<crate::model::AggregationResourceType>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) sort_by: std::option::Option<crate::model::AccountSortBy>,
    }
    impl Builder {
        /// <p>The type of finding.</p>
        pub fn finding_type(mut self, input: crate::model::AggregationFindingType) -> Self {
            self.finding_type = Some(input);
            self
        }
        /// <p>The type of finding.</p>
        pub fn set_finding_type(
            mut self,
            input: std::option::Option<crate::model::AggregationFindingType>,
        ) -> Self {
            self.finding_type = input;
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::AggregationResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::AggregationResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The sort order (ascending or descending).</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The sort order (ascending or descending).</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The value to sort by.</p>
        pub fn sort_by(mut self, input: crate::model::AccountSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value to sort by.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AccountSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAggregation`](crate::model::AccountAggregation)
        pub fn build(self) -> crate::model::AccountAggregation {
            crate::model::AccountAggregation {
                finding_type: self.finding_type,
                resource_type: self.resource_type,
                sort_order: self.sort_order,
                sort_by: self.sort_by,
            }
        }
    }
}
impl AccountAggregation {
    /// Creates a new builder-style object to manufacture [`AccountAggregation`](crate::model::AccountAggregation)
    pub fn builder() -> crate::model::account_aggregation::Builder {
        crate::model::account_aggregation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountSortBy {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => AccountSortBy::All,
            "CRITICAL" => AccountSortBy::Critical,
            "HIGH" => AccountSortBy::High,
            other => AccountSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountSortBy::from(s))
    }
}
impl AccountSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountSortBy::All => "ALL",
            AccountSortBy::Critical => "CRITICAL",
            AccountSortBy::High => "HIGH",
            AccountSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "CRITICAL", "HIGH"]
    }
}
impl AsRef<str> for AccountSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The Amazon Resource Number (ARN) associated with this filter.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the account that created the filter.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The name of the filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Details on the filter criteria associated with this filter.</p>
    pub criteria: std::option::Option<crate::model::FilterCriteria>,
    /// <p>The action that is to be applied to the findings that match the filter.</p>
    pub action: std::option::Option<crate::model::FilterAction>,
    /// <p>The date and time this filter was created at.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the filter was last updated at.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A description of the filter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The reason for the filter.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The tags attached to the filter.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Filter {
    /// <p>The Amazon Resource Number (ARN) associated with this filter.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the account that created the filter.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The name of the filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Details on the filter criteria associated with this filter.</p>
    pub fn criteria(&self) -> std::option::Option<&crate::model::FilterCriteria> {
        self.criteria.as_ref()
    }
    /// <p>The action that is to be applied to the findings that match the filter.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::FilterAction> {
        self.action.as_ref()
    }
    /// <p>The date and time this filter was created at.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The date and time the filter was last updated at.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>A description of the filter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The reason for the filter.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>The tags attached to the filter.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("arn", &self.arn);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("name", &self.name);
        formatter.field("criteria", &self.criteria);
        formatter.field("action", &self.action);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("description", &self.description);
        formatter.field("reason", &self.reason);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) criteria: std::option::Option<crate::model::FilterCriteria>,
        pub(crate) action: std::option::Option<crate::model::FilterAction>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Number (ARN) associated with this filter.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) associated with this filter.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the account that created the filter.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the account that created the filter.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Details on the filter criteria associated with this filter.</p>
        pub fn criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.criteria = Some(input);
            self
        }
        /// <p>Details on the filter criteria associated with this filter.</p>
        pub fn set_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.criteria = input;
            self
        }
        /// <p>The action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The date and time this filter was created at.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time this filter was created at.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time the filter was last updated at.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time the filter was last updated at.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>A description of the filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The reason for the filter.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the filter.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags attached to the filter.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the filter.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                arn: self.arn,
                owner_id: self.owner_id,
                name: self.name,
                criteria: self.criteria,
                action: self.action,
                created_at: self.created_at,
                updated_at: self.updated_at,
                description: self.description,
                reason: self.reason,
                tags: self.tags,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Details of the Amazon Inspector delegated administrator for your organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegatedAdminAccount {
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon Inspector delegated administrator.</p>
    pub status: std::option::Option<crate::model::DelegatedAdminStatus>,
}
impl DelegatedAdminAccount {
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The status of the Amazon Inspector delegated administrator.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DelegatedAdminStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DelegatedAdminAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegatedAdminAccount");
        formatter.field("account_id", &self.account_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DelegatedAdminAccount`](crate::model::DelegatedAdminAccount)
pub mod delegated_admin_account {
    /// A builder for [`DelegatedAdminAccount`](crate::model::DelegatedAdminAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DelegatedAdminStatus>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The status of the Amazon Inspector delegated administrator.</p>
        pub fn status(mut self, input: crate::model::DelegatedAdminStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the Amazon Inspector delegated administrator.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DelegatedAdminStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegatedAdminAccount`](crate::model::DelegatedAdminAccount)
        pub fn build(self) -> crate::model::DelegatedAdminAccount {
            crate::model::DelegatedAdminAccount {
                account_id: self.account_id,
                status: self.status,
            }
        }
    }
}
impl DelegatedAdminAccount {
    /// Creates a new builder-style object to manufacture [`DelegatedAdminAccount`](crate::model::DelegatedAdminAccount)
    pub fn builder() -> crate::model::delegated_admin_account::Builder {
        crate::model::delegated_admin_account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DelegatedAdminStatus {
    #[allow(missing_docs)] // documentation missing in model
    DisableInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DelegatedAdminStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE_IN_PROGRESS" => DelegatedAdminStatus::DisableInProgress,
            "ENABLED" => DelegatedAdminStatus::Enabled,
            other => DelegatedAdminStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DelegatedAdminStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DelegatedAdminStatus::from(s))
    }
}
impl DelegatedAdminStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DelegatedAdminStatus::DisableInProgress => "DISABLE_IN_PROGRESS",
            DelegatedAdminStatus::Enabled => "ENABLED",
            DelegatedAdminStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE_IN_PROGRESS", "ENABLED"]
    }
}
impl AsRef<str> for DelegatedAdminStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>a structure that contains information on the count of resources within a group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Counts {
    /// <p>The number of resources.</p>
    pub count: i64,
    /// <p>The key associated with this group</p>
    pub group_key: std::option::Option<crate::model::GroupKey>,
}
impl Counts {
    /// <p>The number of resources.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
    /// <p>The key associated with this group</p>
    pub fn group_key(&self) -> std::option::Option<&crate::model::GroupKey> {
        self.group_key.as_ref()
    }
}
impl std::fmt::Debug for Counts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Counts");
        formatter.field("count", &self.count);
        formatter.field("group_key", &self.group_key);
        formatter.finish()
    }
}
/// See [`Counts`](crate::model::Counts)
pub mod counts {
    /// A builder for [`Counts`](crate::model::Counts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i64>,
        pub(crate) group_key: std::option::Option<crate::model::GroupKey>,
    }
    impl Builder {
        /// <p>The number of resources.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of resources.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The key associated with this group</p>
        pub fn group_key(mut self, input: crate::model::GroupKey) -> Self {
            self.group_key = Some(input);
            self
        }
        /// <p>The key associated with this group</p>
        pub fn set_group_key(mut self, input: std::option::Option<crate::model::GroupKey>) -> Self {
            self.group_key = input;
            self
        }
        /// Consumes the builder and constructs a [`Counts`](crate::model::Counts)
        pub fn build(self) -> crate::model::Counts {
            crate::model::Counts {
                count: self.count.unwrap_or_default(),
                group_key: self.group_key,
            }
        }
    }
}
impl Counts {
    /// Creates a new builder-style object to manufacture [`Counts`](crate::model::Counts)
    pub fn builder() -> crate::model::counts::Builder {
        crate::model::counts::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GroupKey {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    EcrRepositoryName,
    #[allow(missing_docs)] // documentation missing in model
    ResourceType,
    #[allow(missing_docs)] // documentation missing in model
    ScanStatusCode,
    #[allow(missing_docs)] // documentation missing in model
    ScanStatusReason,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GroupKey {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_ID" => GroupKey::AccountId,
            "ECR_REPOSITORY_NAME" => GroupKey::EcrRepositoryName,
            "RESOURCE_TYPE" => GroupKey::ResourceType,
            "SCAN_STATUS_CODE" => GroupKey::ScanStatusCode,
            "SCAN_STATUS_REASON" => GroupKey::ScanStatusReason,
            other => GroupKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GroupKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GroupKey::from(s))
    }
}
impl GroupKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GroupKey::AccountId => "ACCOUNT_ID",
            GroupKey::EcrRepositoryName => "ECR_REPOSITORY_NAME",
            GroupKey::ResourceType => "RESOURCE_TYPE",
            GroupKey::ScanStatusCode => "SCAN_STATUS_CODE",
            GroupKey::ScanStatusReason => "SCAN_STATUS_REASON",
            GroupKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_ID",
            "ECR_REPOSITORY_NAME",
            "RESOURCE_TYPE",
            "SCAN_STATUS_CODE",
            "SCAN_STATUS_REASON",
        ]
    }
}
impl AsRef<str> for GroupKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that identifies filter criteria for <code>GetCoverageStatistics</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoverageFilterCriteria {
    /// <p>The scan status code to filter on.</p>
    pub scan_status_code: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>The scan status reason to filter on.</p>
    pub scan_status_reason: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>An array of Amazon Web Services account IDs to return coverage statistics for.</p>
    pub account_id: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>An array of Amazon Web Services resource IDs to return coverage statistics for.</p>
    pub resource_id: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>An array of Amazon Web Services resource types to return coverage statistics for.</p>
    pub resource_type: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>An array of Amazon Inspector scan types to return coverage statistics for.</p>
    pub scan_type: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>The Amazon ECR repository name to filter on.</p>
    pub ecr_repository_name: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>The Amazon ECR image tags to filter on.</p>
    pub ecr_image_tags: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
    /// <p>The Amazon EC2 instance tags to filter on.</p>
    pub ec2_instance_tags: std::option::Option<std::vec::Vec<crate::model::CoverageMapFilter>>,
}
impl CoverageFilterCriteria {
    /// <p>The scan status code to filter on.</p>
    pub fn scan_status_code(&self) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.scan_status_code.as_deref()
    }
    /// <p>The scan status reason to filter on.</p>
    pub fn scan_status_reason(&self) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.scan_status_reason.as_deref()
    }
    /// <p>An array of Amazon Web Services account IDs to return coverage statistics for.</p>
    pub fn account_id(&self) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.account_id.as_deref()
    }
    /// <p>An array of Amazon Web Services resource IDs to return coverage statistics for.</p>
    pub fn resource_id(&self) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.resource_id.as_deref()
    }
    /// <p>An array of Amazon Web Services resource types to return coverage statistics for.</p>
    pub fn resource_type(&self) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.resource_type.as_deref()
    }
    /// <p>An array of Amazon Inspector scan types to return coverage statistics for.</p>
    pub fn scan_type(&self) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.scan_type.as_deref()
    }
    /// <p>The Amazon ECR repository name to filter on.</p>
    pub fn ecr_repository_name(
        &self,
    ) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.ecr_repository_name.as_deref()
    }
    /// <p>The Amazon ECR image tags to filter on.</p>
    pub fn ecr_image_tags(&self) -> std::option::Option<&[crate::model::CoverageStringFilter]> {
        self.ecr_image_tags.as_deref()
    }
    /// <p>The Amazon EC2 instance tags to filter on.</p>
    pub fn ec2_instance_tags(&self) -> std::option::Option<&[crate::model::CoverageMapFilter]> {
        self.ec2_instance_tags.as_deref()
    }
}
impl std::fmt::Debug for CoverageFilterCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoverageFilterCriteria");
        formatter.field("scan_status_code", &self.scan_status_code);
        formatter.field("scan_status_reason", &self.scan_status_reason);
        formatter.field("account_id", &self.account_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("scan_type", &self.scan_type);
        formatter.field("ecr_repository_name", &self.ecr_repository_name);
        formatter.field("ecr_image_tags", &self.ecr_image_tags);
        formatter.field("ec2_instance_tags", &self.ec2_instance_tags);
        formatter.finish()
    }
}
/// See [`CoverageFilterCriteria`](crate::model::CoverageFilterCriteria)
pub mod coverage_filter_criteria {
    /// A builder for [`CoverageFilterCriteria`](crate::model::CoverageFilterCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scan_status_code:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) scan_status_reason:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) account_id:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) resource_id:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) resource_type:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) scan_type:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) ecr_repository_name:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) ecr_image_tags:
            std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        pub(crate) ec2_instance_tags:
            std::option::Option<std::vec::Vec<crate::model::CoverageMapFilter>>,
    }
    impl Builder {
        /// Appends an item to `scan_status_code`.
        ///
        /// To override the contents of this collection use [`set_scan_status_code`](Self::set_scan_status_code).
        ///
        /// <p>The scan status code to filter on.</p>
        pub fn scan_status_code(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.scan_status_code.unwrap_or_default();
            v.push(input);
            self.scan_status_code = Some(v);
            self
        }
        /// <p>The scan status code to filter on.</p>
        pub fn set_scan_status_code(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.scan_status_code = input;
            self
        }
        /// Appends an item to `scan_status_reason`.
        ///
        /// To override the contents of this collection use [`set_scan_status_reason`](Self::set_scan_status_reason).
        ///
        /// <p>The scan status reason to filter on.</p>
        pub fn scan_status_reason(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.scan_status_reason.unwrap_or_default();
            v.push(input);
            self.scan_status_reason = Some(v);
            self
        }
        /// <p>The scan status reason to filter on.</p>
        pub fn set_scan_status_reason(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.scan_status_reason = input;
            self
        }
        /// Appends an item to `account_id`.
        ///
        /// To override the contents of this collection use [`set_account_id`](Self::set_account_id).
        ///
        /// <p>An array of Amazon Web Services account IDs to return coverage statistics for.</p>
        pub fn account_id(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.account_id.unwrap_or_default();
            v.push(input);
            self.account_id = Some(v);
            self
        }
        /// <p>An array of Amazon Web Services account IDs to return coverage statistics for.</p>
        pub fn set_account_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `resource_id`.
        ///
        /// To override the contents of this collection use [`set_resource_id`](Self::set_resource_id).
        ///
        /// <p>An array of Amazon Web Services resource IDs to return coverage statistics for.</p>
        pub fn resource_id(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.resource_id.unwrap_or_default();
            v.push(input);
            self.resource_id = Some(v);
            self
        }
        /// <p>An array of Amazon Web Services resource IDs to return coverage statistics for.</p>
        pub fn set_resource_id(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `resource_type`.
        ///
        /// To override the contents of this collection use [`set_resource_type`](Self::set_resource_type).
        ///
        /// <p>An array of Amazon Web Services resource types to return coverage statistics for.</p>
        pub fn resource_type(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.resource_type.unwrap_or_default();
            v.push(input);
            self.resource_type = Some(v);
            self
        }
        /// <p>An array of Amazon Web Services resource types to return coverage statistics for.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `scan_type`.
        ///
        /// To override the contents of this collection use [`set_scan_type`](Self::set_scan_type).
        ///
        /// <p>An array of Amazon Inspector scan types to return coverage statistics for.</p>
        pub fn scan_type(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.scan_type.unwrap_or_default();
            v.push(input);
            self.scan_type = Some(v);
            self
        }
        /// <p>An array of Amazon Inspector scan types to return coverage statistics for.</p>
        pub fn set_scan_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.scan_type = input;
            self
        }
        /// Appends an item to `ecr_repository_name`.
        ///
        /// To override the contents of this collection use [`set_ecr_repository_name`](Self::set_ecr_repository_name).
        ///
        /// <p>The Amazon ECR repository name to filter on.</p>
        pub fn ecr_repository_name(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.ecr_repository_name.unwrap_or_default();
            v.push(input);
            self.ecr_repository_name = Some(v);
            self
        }
        /// <p>The Amazon ECR repository name to filter on.</p>
        pub fn set_ecr_repository_name(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.ecr_repository_name = input;
            self
        }
        /// Appends an item to `ecr_image_tags`.
        ///
        /// To override the contents of this collection use [`set_ecr_image_tags`](Self::set_ecr_image_tags).
        ///
        /// <p>The Amazon ECR image tags to filter on.</p>
        pub fn ecr_image_tags(mut self, input: crate::model::CoverageStringFilter) -> Self {
            let mut v = self.ecr_image_tags.unwrap_or_default();
            v.push(input);
            self.ecr_image_tags = Some(v);
            self
        }
        /// <p>The Amazon ECR image tags to filter on.</p>
        pub fn set_ecr_image_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageStringFilter>>,
        ) -> Self {
            self.ecr_image_tags = input;
            self
        }
        /// Appends an item to `ec2_instance_tags`.
        ///
        /// To override the contents of this collection use [`set_ec2_instance_tags`](Self::set_ec2_instance_tags).
        ///
        /// <p>The Amazon EC2 instance tags to filter on.</p>
        pub fn ec2_instance_tags(mut self, input: crate::model::CoverageMapFilter) -> Self {
            let mut v = self.ec2_instance_tags.unwrap_or_default();
            v.push(input);
            self.ec2_instance_tags = Some(v);
            self
        }
        /// <p>The Amazon EC2 instance tags to filter on.</p>
        pub fn set_ec2_instance_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageMapFilter>>,
        ) -> Self {
            self.ec2_instance_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CoverageFilterCriteria`](crate::model::CoverageFilterCriteria)
        pub fn build(self) -> crate::model::CoverageFilterCriteria {
            crate::model::CoverageFilterCriteria {
                scan_status_code: self.scan_status_code,
                scan_status_reason: self.scan_status_reason,
                account_id: self.account_id,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                scan_type: self.scan_type,
                ecr_repository_name: self.ecr_repository_name,
                ecr_image_tags: self.ecr_image_tags,
                ec2_instance_tags: self.ec2_instance_tags,
            }
        }
    }
}
impl CoverageFilterCriteria {
    /// Creates a new builder-style object to manufacture [`CoverageFilterCriteria`](crate::model::CoverageFilterCriteria)
    pub fn builder() -> crate::model::coverage_filter_criteria::Builder {
        crate::model::coverage_filter_criteria::Builder::default()
    }
}

/// <p>Contains details of a coverage map filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoverageMapFilter {
    /// <p>The operator to compare coverage on.</p>
    pub comparison: std::option::Option<crate::model::CoverageMapComparison>,
    /// <p>The tag key associated with the coverage map filter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value associated with the coverage map filter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl CoverageMapFilter {
    /// <p>The operator to compare coverage on.</p>
    pub fn comparison(&self) -> std::option::Option<&crate::model::CoverageMapComparison> {
        self.comparison.as_ref()
    }
    /// <p>The tag key associated with the coverage map filter.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value associated with the coverage map filter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for CoverageMapFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoverageMapFilter");
        formatter.field("comparison", &self.comparison);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CoverageMapFilter`](crate::model::CoverageMapFilter)
pub mod coverage_map_filter {
    /// A builder for [`CoverageMapFilter`](crate::model::CoverageMapFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison: std::option::Option<crate::model::CoverageMapComparison>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The operator to compare coverage on.</p>
        pub fn comparison(mut self, input: crate::model::CoverageMapComparison) -> Self {
            self.comparison = Some(input);
            self
        }
        /// <p>The operator to compare coverage on.</p>
        pub fn set_comparison(
            mut self,
            input: std::option::Option<crate::model::CoverageMapComparison>,
        ) -> Self {
            self.comparison = input;
            self
        }
        /// <p>The tag key associated with the coverage map filter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key associated with the coverage map filter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value associated with the coverage map filter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value associated with the coverage map filter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CoverageMapFilter`](crate::model::CoverageMapFilter)
        pub fn build(self) -> crate::model::CoverageMapFilter {
            crate::model::CoverageMapFilter {
                comparison: self.comparison,
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl CoverageMapFilter {
    /// Creates a new builder-style object to manufacture [`CoverageMapFilter`](crate::model::CoverageMapFilter)
    pub fn builder() -> crate::model::coverage_map_filter::Builder {
        crate::model::coverage_map_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CoverageMapComparison {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CoverageMapComparison {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => CoverageMapComparison::Equals,
            other => CoverageMapComparison::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CoverageMapComparison {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CoverageMapComparison::from(s))
    }
}
impl CoverageMapComparison {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CoverageMapComparison::Equals => "EQUALS",
            CoverageMapComparison::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS"]
    }
}
impl AsRef<str> for CoverageMapComparison {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details of a coverage string filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoverageStringFilter {
    /// <p>The operator to compare strings on.</p>
    pub comparison: std::option::Option<crate::model::CoverageStringComparison>,
    /// <p>The value to compare strings on.</p>
    pub value: std::option::Option<std::string::String>,
}
impl CoverageStringFilter {
    /// <p>The operator to compare strings on.</p>
    pub fn comparison(&self) -> std::option::Option<&crate::model::CoverageStringComparison> {
        self.comparison.as_ref()
    }
    /// <p>The value to compare strings on.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for CoverageStringFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoverageStringFilter");
        formatter.field("comparison", &self.comparison);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CoverageStringFilter`](crate::model::CoverageStringFilter)
pub mod coverage_string_filter {
    /// A builder for [`CoverageStringFilter`](crate::model::CoverageStringFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparison: std::option::Option<crate::model::CoverageStringComparison>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The operator to compare strings on.</p>
        pub fn comparison(mut self, input: crate::model::CoverageStringComparison) -> Self {
            self.comparison = Some(input);
            self
        }
        /// <p>The operator to compare strings on.</p>
        pub fn set_comparison(
            mut self,
            input: std::option::Option<crate::model::CoverageStringComparison>,
        ) -> Self {
            self.comparison = input;
            self
        }
        /// <p>The value to compare strings on.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value to compare strings on.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CoverageStringFilter`](crate::model::CoverageStringFilter)
        pub fn build(self) -> crate::model::CoverageStringFilter {
            crate::model::CoverageStringFilter {
                comparison: self.comparison,
                value: self.value,
            }
        }
    }
}
impl CoverageStringFilter {
    /// Creates a new builder-style object to manufacture [`CoverageStringFilter`](crate::model::CoverageStringFilter)
    pub fn builder() -> crate::model::coverage_string_filter::Builder {
        crate::model::coverage_string_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CoverageStringComparison {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    NotEquals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CoverageStringComparison {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => CoverageStringComparison::Equals,
            "NOT_EQUALS" => CoverageStringComparison::NotEquals,
            other => CoverageStringComparison::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CoverageStringComparison {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CoverageStringComparison::from(s))
    }
}
impl CoverageStringComparison {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CoverageStringComparison::Equals => "EQUALS",
            CoverageStringComparison::NotEquals => "NOT_EQUALS",
            CoverageStringComparison::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS", "NOT_EQUALS"]
    }
}
impl AsRef<str> for CoverageStringComparison {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains details about a resource covered by Amazon Inspector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoveredResource {
    /// <p>The type of the covered resource.</p>
    pub resource_type: std::option::Option<crate::model::CoverageResourceType>,
    /// <p>The ID of the covered resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the covered resource.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Inspector scan type covering the resource.</p>
    pub scan_type: std::option::Option<crate::model::ScanType>,
    /// <p>The status of the scan covering the resource.</p>
    pub scan_status: std::option::Option<crate::model::ScanStatus>,
    /// <p>An object that contains details about the metadata.</p>
    pub resource_metadata: std::option::Option<crate::model::ResourceScanMetadata>,
}
impl CoveredResource {
    /// <p>The type of the covered resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::CoverageResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the covered resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the covered resource.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Inspector scan type covering the resource.</p>
    pub fn scan_type(&self) -> std::option::Option<&crate::model::ScanType> {
        self.scan_type.as_ref()
    }
    /// <p>The status of the scan covering the resource.</p>
    pub fn scan_status(&self) -> std::option::Option<&crate::model::ScanStatus> {
        self.scan_status.as_ref()
    }
    /// <p>An object that contains details about the metadata.</p>
    pub fn resource_metadata(&self) -> std::option::Option<&crate::model::ResourceScanMetadata> {
        self.resource_metadata.as_ref()
    }
}
impl std::fmt::Debug for CoveredResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoveredResource");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("scan_type", &self.scan_type);
        formatter.field("scan_status", &self.scan_status);
        formatter.field("resource_metadata", &self.resource_metadata);
        formatter.finish()
    }
}
/// See [`CoveredResource`](crate::model::CoveredResource)
pub mod covered_resource {
    /// A builder for [`CoveredResource`](crate::model::CoveredResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::CoverageResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) scan_type: std::option::Option<crate::model::ScanType>,
        pub(crate) scan_status: std::option::Option<crate::model::ScanStatus>,
        pub(crate) resource_metadata: std::option::Option<crate::model::ResourceScanMetadata>,
    }
    impl Builder {
        /// <p>The type of the covered resource.</p>
        pub fn resource_type(mut self, input: crate::model::CoverageResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the covered resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::CoverageResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the covered resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the covered resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the covered resource.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the covered resource.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Inspector scan type covering the resource.</p>
        pub fn scan_type(mut self, input: crate::model::ScanType) -> Self {
            self.scan_type = Some(input);
            self
        }
        /// <p>The Amazon Inspector scan type covering the resource.</p>
        pub fn set_scan_type(mut self, input: std::option::Option<crate::model::ScanType>) -> Self {
            self.scan_type = input;
            self
        }
        /// <p>The status of the scan covering the resource.</p>
        pub fn scan_status(mut self, input: crate::model::ScanStatus) -> Self {
            self.scan_status = Some(input);
            self
        }
        /// <p>The status of the scan covering the resource.</p>
        pub fn set_scan_status(
            mut self,
            input: std::option::Option<crate::model::ScanStatus>,
        ) -> Self {
            self.scan_status = input;
            self
        }
        /// <p>An object that contains details about the metadata.</p>
        pub fn resource_metadata(mut self, input: crate::model::ResourceScanMetadata) -> Self {
            self.resource_metadata = Some(input);
            self
        }
        /// <p>An object that contains details about the metadata.</p>
        pub fn set_resource_metadata(
            mut self,
            input: std::option::Option<crate::model::ResourceScanMetadata>,
        ) -> Self {
            self.resource_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CoveredResource`](crate::model::CoveredResource)
        pub fn build(self) -> crate::model::CoveredResource {
            crate::model::CoveredResource {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                account_id: self.account_id,
                scan_type: self.scan_type,
                scan_status: self.scan_status,
                resource_metadata: self.resource_metadata,
            }
        }
    }
}
impl CoveredResource {
    /// Creates a new builder-style object to manufacture [`CoveredResource`](crate::model::CoveredResource)
    pub fn builder() -> crate::model::covered_resource::Builder {
        crate::model::covered_resource::Builder::default()
    }
}

/// <p>An object that contains details about the metadata for an Amazon ECR resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceScanMetadata {
    /// <p>An object that contains details about the repository an Amazon ECR image resides in.</p>
    pub ecr_repository: std::option::Option<crate::model::EcrRepositoryMetadata>,
    /// <p>An object that contains details about the container metadata for an Amazon ECR image.</p>
    pub ecr_image: std::option::Option<crate::model::EcrContainerImageMetadata>,
    /// <p>An object that contains metadata details for an Amazon EC2 instance.</p>
    pub ec2: std::option::Option<crate::model::Ec2Metadata>,
}
impl ResourceScanMetadata {
    /// <p>An object that contains details about the repository an Amazon ECR image resides in.</p>
    pub fn ecr_repository(&self) -> std::option::Option<&crate::model::EcrRepositoryMetadata> {
        self.ecr_repository.as_ref()
    }
    /// <p>An object that contains details about the container metadata for an Amazon ECR image.</p>
    pub fn ecr_image(&self) -> std::option::Option<&crate::model::EcrContainerImageMetadata> {
        self.ecr_image.as_ref()
    }
    /// <p>An object that contains metadata details for an Amazon EC2 instance.</p>
    pub fn ec2(&self) -> std::option::Option<&crate::model::Ec2Metadata> {
        self.ec2.as_ref()
    }
}
impl std::fmt::Debug for ResourceScanMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceScanMetadata");
        formatter.field("ecr_repository", &self.ecr_repository);
        formatter.field("ecr_image", &self.ecr_image);
        formatter.field("ec2", &self.ec2);
        formatter.finish()
    }
}
/// See [`ResourceScanMetadata`](crate::model::ResourceScanMetadata)
pub mod resource_scan_metadata {
    /// A builder for [`ResourceScanMetadata`](crate::model::ResourceScanMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ecr_repository: std::option::Option<crate::model::EcrRepositoryMetadata>,
        pub(crate) ecr_image: std::option::Option<crate::model::EcrContainerImageMetadata>,
        pub(crate) ec2: std::option::Option<crate::model::Ec2Metadata>,
    }
    impl Builder {
        /// <p>An object that contains details about the repository an Amazon ECR image resides in.</p>
        pub fn ecr_repository(mut self, input: crate::model::EcrRepositoryMetadata) -> Self {
            self.ecr_repository = Some(input);
            self
        }
        /// <p>An object that contains details about the repository an Amazon ECR image resides in.</p>
        pub fn set_ecr_repository(
            mut self,
            input: std::option::Option<crate::model::EcrRepositoryMetadata>,
        ) -> Self {
            self.ecr_repository = input;
            self
        }
        /// <p>An object that contains details about the container metadata for an Amazon ECR image.</p>
        pub fn ecr_image(mut self, input: crate::model::EcrContainerImageMetadata) -> Self {
            self.ecr_image = Some(input);
            self
        }
        /// <p>An object that contains details about the container metadata for an Amazon ECR image.</p>
        pub fn set_ecr_image(
            mut self,
            input: std::option::Option<crate::model::EcrContainerImageMetadata>,
        ) -> Self {
            self.ecr_image = input;
            self
        }
        /// <p>An object that contains metadata details for an Amazon EC2 instance.</p>
        pub fn ec2(mut self, input: crate::model::Ec2Metadata) -> Self {
            self.ec2 = Some(input);
            self
        }
        /// <p>An object that contains metadata details for an Amazon EC2 instance.</p>
        pub fn set_ec2(mut self, input: std::option::Option<crate::model::Ec2Metadata>) -> Self {
            self.ec2 = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceScanMetadata`](crate::model::ResourceScanMetadata)
        pub fn build(self) -> crate::model::ResourceScanMetadata {
            crate::model::ResourceScanMetadata {
                ecr_repository: self.ecr_repository,
                ecr_image: self.ecr_image,
                ec2: self.ec2,
            }
        }
    }
}
impl ResourceScanMetadata {
    /// Creates a new builder-style object to manufacture [`ResourceScanMetadata`](crate::model::ResourceScanMetadata)
    pub fn builder() -> crate::model::resource_scan_metadata::Builder {
        crate::model::resource_scan_metadata::Builder::default()
    }
}

/// <p>Meta data details of an Amazon EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2Metadata {
    /// <p>The tags attached to the instance.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the Amazon Machine Image (AMI) used to launch the instance.</p>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The platform of the instance.</p>
    pub platform: std::option::Option<crate::model::Ec2Platform>,
}
impl Ec2Metadata {
    /// <p>The tags attached to the instance.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The ID of the Amazon Machine Image (AMI) used to launch the instance.</p>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The platform of the instance.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Ec2Platform> {
        self.platform.as_ref()
    }
}
impl std::fmt::Debug for Ec2Metadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2Metadata");
        formatter.field("tags", &self.tags);
        formatter.field("ami_id", &self.ami_id);
        formatter.field("platform", &self.platform);
        formatter.finish()
    }
}
/// See [`Ec2Metadata`](crate::model::Ec2Metadata)
pub mod ec2_metadata {
    /// A builder for [`Ec2Metadata`](crate::model::Ec2Metadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Ec2Platform>,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags attached to the instance.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) used to launch the instance.</p>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) used to launch the instance.</p>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The platform of the instance.</p>
        pub fn platform(mut self, input: crate::model::Ec2Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the instance.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::Ec2Platform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2Metadata`](crate::model::Ec2Metadata)
        pub fn build(self) -> crate::model::Ec2Metadata {
            crate::model::Ec2Metadata {
                tags: self.tags,
                ami_id: self.ami_id,
                platform: self.platform,
            }
        }
    }
}
impl Ec2Metadata {
    /// Creates a new builder-style object to manufacture [`Ec2Metadata`](crate::model::Ec2Metadata)
    pub fn builder() -> crate::model::ec2_metadata::Builder {
        crate::model::ec2_metadata::Builder::default()
    }
}

/// _Note: `Ec2Platform::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Ec2Platform {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Ec2Platform {
    fn from(s: &str) -> Self {
        match s {
            "LINUX" => Ec2Platform::Linux,
            "UNKNOWN" => Ec2Platform::UnknownValue,
            "WINDOWS" => Ec2Platform::Windows,
            other => Ec2Platform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Ec2Platform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Ec2Platform::from(s))
    }
}
impl Ec2Platform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Ec2Platform::Linux => "LINUX",
            Ec2Platform::UnknownValue => "UNKNOWN",
            Ec2Platform::Windows => "WINDOWS",
            Ec2Platform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINUX", "UNKNOWN", "WINDOWS"]
    }
}
impl AsRef<str> for Ec2Platform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information on the Amazon ECR image metadata associated with a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EcrContainerImageMetadata {
    /// <p>Tags associated with the Amazon ECR image metadata.</p>
    pub tags: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EcrContainerImageMetadata {
    /// <p>Tags associated with the Amazon ECR image metadata.</p>
    pub fn tags(&self) -> std::option::Option<&[std::string::String]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for EcrContainerImageMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EcrContainerImageMetadata");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`EcrContainerImageMetadata`](crate::model::EcrContainerImageMetadata)
pub mod ecr_container_image_metadata {
    /// A builder for [`EcrContainerImageMetadata`](crate::model::EcrContainerImageMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the Amazon ECR image metadata.</p>
        pub fn tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags associated with the Amazon ECR image metadata.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`EcrContainerImageMetadata`](crate::model::EcrContainerImageMetadata)
        pub fn build(self) -> crate::model::EcrContainerImageMetadata {
            crate::model::EcrContainerImageMetadata { tags: self.tags }
        }
    }
}
impl EcrContainerImageMetadata {
    /// Creates a new builder-style object to manufacture [`EcrContainerImageMetadata`](crate::model::EcrContainerImageMetadata)
    pub fn builder() -> crate::model::ecr_container_image_metadata::Builder {
        crate::model::ecr_container_image_metadata::Builder::default()
    }
}

/// <p>Information on the Amazon ECR repository metadata associated with a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EcrRepositoryMetadata {
    /// <p>The name of the Amazon ECR repository.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The frequency of scans.</p>
    pub scan_frequency: std::option::Option<crate::model::EcrScanFrequency>,
}
impl EcrRepositoryMetadata {
    /// <p>The name of the Amazon ECR repository.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The frequency of scans.</p>
    pub fn scan_frequency(&self) -> std::option::Option<&crate::model::EcrScanFrequency> {
        self.scan_frequency.as_ref()
    }
}
impl std::fmt::Debug for EcrRepositoryMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EcrRepositoryMetadata");
        formatter.field("name", &self.name);
        formatter.field("scan_frequency", &self.scan_frequency);
        formatter.finish()
    }
}
/// See [`EcrRepositoryMetadata`](crate::model::EcrRepositoryMetadata)
pub mod ecr_repository_metadata {
    /// A builder for [`EcrRepositoryMetadata`](crate::model::EcrRepositoryMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) scan_frequency: std::option::Option<crate::model::EcrScanFrequency>,
    }
    impl Builder {
        /// <p>The name of the Amazon ECR repository.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon ECR repository.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The frequency of scans.</p>
        pub fn scan_frequency(mut self, input: crate::model::EcrScanFrequency) -> Self {
            self.scan_frequency = Some(input);
            self
        }
        /// <p>The frequency of scans.</p>
        pub fn set_scan_frequency(
            mut self,
            input: std::option::Option<crate::model::EcrScanFrequency>,
        ) -> Self {
            self.scan_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`EcrRepositoryMetadata`](crate::model::EcrRepositoryMetadata)
        pub fn build(self) -> crate::model::EcrRepositoryMetadata {
            crate::model::EcrRepositoryMetadata {
                name: self.name,
                scan_frequency: self.scan_frequency,
            }
        }
    }
}
impl EcrRepositoryMetadata {
    /// Creates a new builder-style object to manufacture [`EcrRepositoryMetadata`](crate::model::EcrRepositoryMetadata)
    pub fn builder() -> crate::model::ecr_repository_metadata::Builder {
        crate::model::ecr_repository_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EcrScanFrequency {
    #[allow(missing_docs)] // documentation missing in model
    ContinuousScan,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    #[allow(missing_docs)] // documentation missing in model
    ScanOnPush,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EcrScanFrequency {
    fn from(s: &str) -> Self {
        match s {
            "CONTINUOUS_SCAN" => EcrScanFrequency::ContinuousScan,
            "MANUAL" => EcrScanFrequency::Manual,
            "SCAN_ON_PUSH" => EcrScanFrequency::ScanOnPush,
            other => EcrScanFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EcrScanFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EcrScanFrequency::from(s))
    }
}
impl EcrScanFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EcrScanFrequency::ContinuousScan => "CONTINUOUS_SCAN",
            EcrScanFrequency::Manual => "MANUAL",
            EcrScanFrequency::ScanOnPush => "SCAN_ON_PUSH",
            EcrScanFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTINUOUS_SCAN", "MANUAL", "SCAN_ON_PUSH"]
    }
}
impl AsRef<str> for EcrScanFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of the scan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScanStatus {
    /// <p>The status code of the scan.</p>
    pub status_code: std::option::Option<crate::model::ScanStatusCode>,
    /// <p>The reason for the scan.</p>
    pub reason: std::option::Option<crate::model::ScanStatusReason>,
}
impl ScanStatus {
    /// <p>The status code of the scan.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::ScanStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>The reason for the scan.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ScanStatusReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for ScanStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScanStatus");
        formatter.field("status_code", &self.status_code);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ScanStatus`](crate::model::ScanStatus)
pub mod scan_status {
    /// A builder for [`ScanStatus`](crate::model::ScanStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<crate::model::ScanStatusCode>,
        pub(crate) reason: std::option::Option<crate::model::ScanStatusReason>,
    }
    impl Builder {
        /// <p>The status code of the scan.</p>
        pub fn status_code(mut self, input: crate::model::ScanStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status code of the scan.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::ScanStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>The reason for the scan.</p>
        pub fn reason(mut self, input: crate::model::ScanStatusReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the scan.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ScanStatusReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ScanStatus`](crate::model::ScanStatus)
        pub fn build(self) -> crate::model::ScanStatus {
            crate::model::ScanStatus {
                status_code: self.status_code,
                reason: self.reason,
            }
        }
    }
}
impl ScanStatus {
    /// Creates a new builder-style object to manufacture [`ScanStatus`](crate::model::ScanStatus)
    pub fn builder() -> crate::model::scan_status::Builder {
        crate::model::scan_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScanStatusReason {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    Ec2InstanceStopped,
    #[allow(missing_docs)] // documentation missing in model
    ImageSizeExceeded,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    NoResourcesFound,
    #[allow(missing_docs)] // documentation missing in model
    PendingInitialScan,
    #[allow(missing_docs)] // documentation missing in model
    ResourceTerminated,
    #[allow(missing_docs)] // documentation missing in model
    ScanEligibilityExpired,
    #[allow(missing_docs)] // documentation missing in model
    ScanFrequencyManual,
    #[allow(missing_docs)] // documentation missing in model
    ScanFrequencyScanOnPush,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    #[allow(missing_docs)] // documentation missing in model
    UnmanagedEc2Instance,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedOs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScanStatusReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => ScanStatusReason::AccessDenied,
            "EC2_INSTANCE_STOPPED" => ScanStatusReason::Ec2InstanceStopped,
            "IMAGE_SIZE_EXCEEDED" => ScanStatusReason::ImageSizeExceeded,
            "INTERNAL_ERROR" => ScanStatusReason::InternalError,
            "NO_RESOURCES_FOUND" => ScanStatusReason::NoResourcesFound,
            "PENDING_INITIAL_SCAN" => ScanStatusReason::PendingInitialScan,
            "RESOURCE_TERMINATED" => ScanStatusReason::ResourceTerminated,
            "SCAN_ELIGIBILITY_EXPIRED" => ScanStatusReason::ScanEligibilityExpired,
            "SCAN_FREQUENCY_MANUAL" => ScanStatusReason::ScanFrequencyManual,
            "SCAN_FREQUENCY_SCAN_ON_PUSH" => ScanStatusReason::ScanFrequencyScanOnPush,
            "SUCCESSFUL" => ScanStatusReason::Successful,
            "UNMANAGED_EC2_INSTANCE" => ScanStatusReason::UnmanagedEc2Instance,
            "UNSUPPORTED_OS" => ScanStatusReason::UnsupportedOs,
            other => ScanStatusReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScanStatusReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScanStatusReason::from(s))
    }
}
impl ScanStatusReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScanStatusReason::AccessDenied => "ACCESS_DENIED",
            ScanStatusReason::Ec2InstanceStopped => "EC2_INSTANCE_STOPPED",
            ScanStatusReason::ImageSizeExceeded => "IMAGE_SIZE_EXCEEDED",
            ScanStatusReason::InternalError => "INTERNAL_ERROR",
            ScanStatusReason::NoResourcesFound => "NO_RESOURCES_FOUND",
            ScanStatusReason::PendingInitialScan => "PENDING_INITIAL_SCAN",
            ScanStatusReason::ResourceTerminated => "RESOURCE_TERMINATED",
            ScanStatusReason::ScanEligibilityExpired => "SCAN_ELIGIBILITY_EXPIRED",
            ScanStatusReason::ScanFrequencyManual => "SCAN_FREQUENCY_MANUAL",
            ScanStatusReason::ScanFrequencyScanOnPush => "SCAN_FREQUENCY_SCAN_ON_PUSH",
            ScanStatusReason::Successful => "SUCCESSFUL",
            ScanStatusReason::UnmanagedEc2Instance => "UNMANAGED_EC2_INSTANCE",
            ScanStatusReason::UnsupportedOs => "UNSUPPORTED_OS",
            ScanStatusReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "EC2_INSTANCE_STOPPED",
            "IMAGE_SIZE_EXCEEDED",
            "INTERNAL_ERROR",
            "NO_RESOURCES_FOUND",
            "PENDING_INITIAL_SCAN",
            "RESOURCE_TERMINATED",
            "SCAN_ELIGIBILITY_EXPIRED",
            "SCAN_FREQUENCY_MANUAL",
            "SCAN_FREQUENCY_SCAN_ON_PUSH",
            "SUCCESSFUL",
            "UNMANAGED_EC2_INSTANCE",
            "UNSUPPORTED_OS",
        ]
    }
}
impl AsRef<str> for ScanStatusReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScanStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScanStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ScanStatusCode::Active,
            "INACTIVE" => ScanStatusCode::Inactive,
            other => ScanStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScanStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScanStatusCode::from(s))
    }
}
impl ScanStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScanStatusCode::Active => "ACTIVE",
            ScanStatusCode::Inactive => "INACTIVE",
            ScanStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for ScanStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScanType {
    #[allow(missing_docs)] // documentation missing in model
    Network,
    #[allow(missing_docs)] // documentation missing in model
    Package,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScanType {
    fn from(s: &str) -> Self {
        match s {
            "NETWORK" => ScanType::Network,
            "PACKAGE" => ScanType::Package,
            other => ScanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScanType::from(s))
    }
}
impl ScanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScanType::Network => "NETWORK",
            ScanType::Package => "PACKAGE",
            ScanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NETWORK", "PACKAGE"]
    }
}
impl AsRef<str> for ScanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CoverageResourceType {
    #[allow(missing_docs)] // documentation missing in model
    AwsEc2Instance,
    #[allow(missing_docs)] // documentation missing in model
    AwsEcrContainerImage,
    #[allow(missing_docs)] // documentation missing in model
    AwsEcrRepository,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CoverageResourceType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_EC2_INSTANCE" => CoverageResourceType::AwsEc2Instance,
            "AWS_ECR_CONTAINER_IMAGE" => CoverageResourceType::AwsEcrContainerImage,
            "AWS_ECR_REPOSITORY" => CoverageResourceType::AwsEcrRepository,
            other => CoverageResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CoverageResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CoverageResourceType::from(s))
    }
}
impl CoverageResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CoverageResourceType::AwsEc2Instance => "AWS_EC2_INSTANCE",
            CoverageResourceType::AwsEcrContainerImage => "AWS_ECR_CONTAINER_IMAGE",
            CoverageResourceType::AwsEcrRepository => "AWS_ECR_REPOSITORY",
            CoverageResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_EC2_INSTANCE",
            "AWS_ECR_CONTAINER_IMAGE",
            "AWS_ECR_REPOSITORY",
        ]
    }
}
impl AsRef<str> for CoverageResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information on the permissions an account has within Amazon Inspector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Permission {
    /// <p>The services that the permissions allow an account to perform the given operations for.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>The operations that can be performed with the given permissions.</p>
    pub operation: std::option::Option<crate::model::Operation>,
}
impl Permission {
    /// <p>The services that the permissions allow an account to perform the given operations for.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
    /// <p>The operations that can be performed with the given permissions.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::Operation> {
        self.operation.as_ref()
    }
}
impl std::fmt::Debug for Permission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Permission");
        formatter.field("service", &self.service);
        formatter.field("operation", &self.operation);
        formatter.finish()
    }
}
/// See [`Permission`](crate::model::Permission)
pub mod permission {
    /// A builder for [`Permission`](crate::model::Permission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) operation: std::option::Option<crate::model::Operation>,
    }
    impl Builder {
        /// <p>The services that the permissions allow an account to perform the given operations for.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The services that the permissions allow an account to perform the given operations for.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>The operations that can be performed with the given permissions.</p>
        pub fn operation(mut self, input: crate::model::Operation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The operations that can be performed with the given permissions.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::Operation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// Consumes the builder and constructs a [`Permission`](crate::model::Permission)
        pub fn build(self) -> crate::model::Permission {
            crate::model::Permission {
                service: self.service,
                operation: self.operation,
            }
        }
    }
}
impl Permission {
    /// Creates a new builder-style object to manufacture [`Permission`](crate::model::Permission)
    pub fn builder() -> crate::model::permission::Builder {
        crate::model::permission::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Operation {
    #[allow(missing_docs)] // documentation missing in model
    DisableRepository,
    #[allow(missing_docs)] // documentation missing in model
    DisableScanning,
    #[allow(missing_docs)] // documentation missing in model
    EnableRepository,
    #[allow(missing_docs)] // documentation missing in model
    EnableScanning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Operation {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE_REPOSITORY" => Operation::DisableRepository,
            "DISABLE_SCANNING" => Operation::DisableScanning,
            "ENABLE_REPOSITORY" => Operation::EnableRepository,
            "ENABLE_SCANNING" => Operation::EnableScanning,
            other => Operation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Operation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Operation::from(s))
    }
}
impl Operation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Operation::DisableRepository => "DISABLE_REPOSITORY",
            Operation::DisableScanning => "DISABLE_SCANNING",
            Operation::EnableRepository => "ENABLE_REPOSITORY",
            Operation::EnableScanning => "ENABLE_SCANNING",
            Operation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DISABLE_REPOSITORY",
            "DISABLE_SCANNING",
            "ENABLE_REPOSITORY",
            "ENABLE_SCANNING",
        ]
    }
}
impl AsRef<str> for Operation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Service {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Ecr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Service {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => Service::Ec2,
            "ECR" => Service::Ecr,
            other => Service::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Service {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Service::from(s))
    }
}
impl Service {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Service::Ec2 => "EC2",
            Service::Ecr => "ECR",
            Service::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "ECR"]
    }
}
impl AsRef<str> for Service {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details of the Amazon S3 bucket and KMS key used to export findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>The name of the Amazon S3 bucket to export findings to.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix of the KMS key used to export findings.</p>
    pub key_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the KMS key used to encrypt data when exporting findings.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl Destination {
    /// <p>The name of the Amazon S3 bucket to export findings to.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix of the KMS key used to export findings.</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
    /// <p>The ARN of the KMS key used to encrypt data when exporting findings.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket to export findings to.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket to export findings to.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix of the KMS key used to export findings.</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the KMS key used to export findings.</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// <p>The ARN of the KMS key used to encrypt data when exporting findings.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the KMS key used to encrypt data when exporting findings.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                bucket_name: self.bucket_name,
                key_prefix: self.key_prefix,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportingErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPermissions,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportingErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_ERROR" => ReportingErrorCode::InternalError,
            "INVALID_PERMISSIONS" => ReportingErrorCode::InvalidPermissions,
            other => ReportingErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportingErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportingErrorCode::from(s))
    }
}
impl ReportingErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportingErrorCode::InternalError => "INTERNAL_ERROR",
            ReportingErrorCode::InvalidPermissions => "INVALID_PERMISSIONS",
            ReportingErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_ERROR", "INVALID_PERMISSIONS"]
    }
}
impl AsRef<str> for ReportingErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExternalReportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExternalReportStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => ExternalReportStatus::Cancelled,
            "FAILED" => ExternalReportStatus::Failed,
            "IN_PROGRESS" => ExternalReportStatus::InProgress,
            "SUCCEEDED" => ExternalReportStatus::Succeeded,
            other => ExternalReportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExternalReportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExternalReportStatus::from(s))
    }
}
impl ExternalReportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExternalReportStatus::Cancelled => "CANCELLED",
            ExternalReportStatus::Failed => "FAILED",
            ExternalReportStatus::InProgress => "IN_PROGRESS",
            ExternalReportStatus::Succeeded => "SUCCEEDED",
            ExternalReportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for ExternalReportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of the Amazon Inspector delegated administrator for your organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegatedAdmin {
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon Inspector delegated administrator.</p>
    pub relationship_status: std::option::Option<crate::model::RelationshipStatus>,
}
impl DelegatedAdmin {
    /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The status of the Amazon Inspector delegated administrator.</p>
    pub fn relationship_status(&self) -> std::option::Option<&crate::model::RelationshipStatus> {
        self.relationship_status.as_ref()
    }
}
impl std::fmt::Debug for DelegatedAdmin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegatedAdmin");
        formatter.field("account_id", &self.account_id);
        formatter.field("relationship_status", &self.relationship_status);
        formatter.finish()
    }
}
/// See [`DelegatedAdmin`](crate::model::DelegatedAdmin)
pub mod delegated_admin {
    /// A builder for [`DelegatedAdmin`](crate::model::DelegatedAdmin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) relationship_status: std::option::Option<crate::model::RelationshipStatus>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Inspector delegated administrator for your organization.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The status of the Amazon Inspector delegated administrator.</p>
        pub fn relationship_status(mut self, input: crate::model::RelationshipStatus) -> Self {
            self.relationship_status = Some(input);
            self
        }
        /// <p>The status of the Amazon Inspector delegated administrator.</p>
        pub fn set_relationship_status(
            mut self,
            input: std::option::Option<crate::model::RelationshipStatus>,
        ) -> Self {
            self.relationship_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegatedAdmin`](crate::model::DelegatedAdmin)
        pub fn build(self) -> crate::model::DelegatedAdmin {
            crate::model::DelegatedAdmin {
                account_id: self.account_id,
                relationship_status: self.relationship_status,
            }
        }
    }
}
impl DelegatedAdmin {
    /// Creates a new builder-style object to manufacture [`DelegatedAdmin`](crate::model::DelegatedAdmin)
    pub fn builder() -> crate::model::delegated_admin::Builder {
        crate::model::delegated_admin::Builder::default()
    }
}

/// <p>An object with details on why an account failed to enable Amazon Inspector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedAccount {
    /// <p>The Amazon Web Services account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The status of Amazon Inspector for the account.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
    pub resource_status: std::option::Option<crate::model::ResourceStatus>,
    /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FailedAccount {
    /// <p>The Amazon Web Services account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The status of Amazon Inspector for the account.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
    pub fn resource_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.resource_status.as_ref()
    }
    /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FailedAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedAccount");
        formatter.field("account_id", &self.account_id);
        formatter.field("status", &self.status);
        formatter.field("resource_status", &self.resource_status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailedAccount`](crate::model::FailedAccount)
pub mod failed_account {
    /// A builder for [`FailedAccount`](crate::model::FailedAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) resource_status: std::option::Option<crate::model::ResourceStatus>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The status of Amazon Inspector for the account.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of Amazon Inspector for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
        pub fn resource_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.resource_status = Some(input);
            self
        }
        /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
        pub fn set_resource_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.resource_status = input;
            self
        }
        /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedAccount`](crate::model::FailedAccount)
        pub fn build(self) -> crate::model::FailedAccount {
            crate::model::FailedAccount {
                account_id: self.account_id,
                status: self.status,
                resource_status: self.resource_status,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl FailedAccount {
    /// Creates a new builder-style object to manufacture [`FailedAccount`](crate::model::FailedAccount)
    pub fn builder() -> crate::model::failed_account::Builder {
        crate::model::failed_account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    AlreadyEnabled,
    #[allow(missing_docs)] // documentation missing in model
    DisableInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DisassociateAllMembers,
    #[allow(missing_docs)] // documentation missing in model
    EnableInProgress,
    #[allow(missing_docs)] // documentation missing in model
    EventbridgeThrottled,
    #[allow(missing_docs)] // documentation missing in model
    EventbridgeUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ResourceScanNotDisabled,
    #[allow(missing_docs)] // documentation missing in model
    SsmThrottled,
    #[allow(missing_docs)] // documentation missing in model
    SsmUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    SuspendInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => ErrorCode::AccessDenied,
            "ALREADY_ENABLED" => ErrorCode::AlreadyEnabled,
            "DISABLE_IN_PROGRESS" => ErrorCode::DisableInProgress,
            "DISASSOCIATE_ALL_MEMBERS" => ErrorCode::DisassociateAllMembers,
            "ENABLE_IN_PROGRESS" => ErrorCode::EnableInProgress,
            "EVENTBRIDGE_THROTTLED" => ErrorCode::EventbridgeThrottled,
            "EVENTBRIDGE_UNAVAILABLE" => ErrorCode::EventbridgeUnavailable,
            "INTERNAL_ERROR" => ErrorCode::InternalError,
            "RESOURCE_NOT_FOUND" => ErrorCode::ResourceNotFound,
            "RESOURCE_SCAN_NOT_DISABLED" => ErrorCode::ResourceScanNotDisabled,
            "SSM_THROTTLED" => ErrorCode::SsmThrottled,
            "SSM_UNAVAILABLE" => ErrorCode::SsmUnavailable,
            "SUSPEND_IN_PROGRESS" => ErrorCode::SuspendInProgress,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::AccessDenied => "ACCESS_DENIED",
            ErrorCode::AlreadyEnabled => "ALREADY_ENABLED",
            ErrorCode::DisableInProgress => "DISABLE_IN_PROGRESS",
            ErrorCode::DisassociateAllMembers => "DISASSOCIATE_ALL_MEMBERS",
            ErrorCode::EnableInProgress => "ENABLE_IN_PROGRESS",
            ErrorCode::EventbridgeThrottled => "EVENTBRIDGE_THROTTLED",
            ErrorCode::EventbridgeUnavailable => "EVENTBRIDGE_UNAVAILABLE",
            ErrorCode::InternalError => "INTERNAL_ERROR",
            ErrorCode::ResourceNotFound => "RESOURCE_NOT_FOUND",
            ErrorCode::ResourceScanNotDisabled => "RESOURCE_SCAN_NOT_DISABLED",
            ErrorCode::SsmThrottled => "SSM_THROTTLED",
            ErrorCode::SsmUnavailable => "SSM_UNAVAILABLE",
            ErrorCode::SuspendInProgress => "SUSPEND_IN_PROGRESS",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "ALREADY_ENABLED",
            "DISABLE_IN_PROGRESS",
            "DISASSOCIATE_ALL_MEMBERS",
            "ENABLE_IN_PROGRESS",
            "EVENTBRIDGE_THROTTLED",
            "EVENTBRIDGE_UNAVAILABLE",
            "INTERNAL_ERROR",
            "RESOURCE_NOT_FOUND",
            "RESOURCE_SCAN_NOT_DISABLED",
            "SSM_THROTTLED",
            "SSM_UNAVAILABLE",
            "SUSPEND_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details the status of Amazon Inspector for each resource type Amazon Inspector scans.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceStatus {
    /// <p>The status of Amazon Inspector scanning for Amazon EC2 resources.</p>
    pub ec2: std::option::Option<crate::model::Status>,
    /// <p>The status of Amazon Inspector scanning for Amazon ECR resources.</p>
    pub ecr: std::option::Option<crate::model::Status>,
}
impl ResourceStatus {
    /// <p>The status of Amazon Inspector scanning for Amazon EC2 resources.</p>
    pub fn ec2(&self) -> std::option::Option<&crate::model::Status> {
        self.ec2.as_ref()
    }
    /// <p>The status of Amazon Inspector scanning for Amazon ECR resources.</p>
    pub fn ecr(&self) -> std::option::Option<&crate::model::Status> {
        self.ecr.as_ref()
    }
}
impl std::fmt::Debug for ResourceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceStatus");
        formatter.field("ec2", &self.ec2);
        formatter.field("ecr", &self.ecr);
        formatter.finish()
    }
}
/// See [`ResourceStatus`](crate::model::ResourceStatus)
pub mod resource_status {
    /// A builder for [`ResourceStatus`](crate::model::ResourceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2: std::option::Option<crate::model::Status>,
        pub(crate) ecr: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>The status of Amazon Inspector scanning for Amazon EC2 resources.</p>
        pub fn ec2(mut self, input: crate::model::Status) -> Self {
            self.ec2 = Some(input);
            self
        }
        /// <p>The status of Amazon Inspector scanning for Amazon EC2 resources.</p>
        pub fn set_ec2(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.ec2 = input;
            self
        }
        /// <p>The status of Amazon Inspector scanning for Amazon ECR resources.</p>
        pub fn ecr(mut self, input: crate::model::Status) -> Self {
            self.ecr = Some(input);
            self
        }
        /// <p>The status of Amazon Inspector scanning for Amazon ECR resources.</p>
        pub fn set_ecr(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.ecr = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceStatus`](crate::model::ResourceStatus)
        pub fn build(self) -> crate::model::ResourceStatus {
            crate::model::ResourceStatus {
                ec2: self.ec2,
                ecr: self.ecr,
            }
        }
    }
}
impl ResourceStatus {
    /// Creates a new builder-style object to manufacture [`ResourceStatus`](crate::model::ResourceStatus)
    pub fn builder() -> crate::model::resource_status::Builder {
        crate::model::resource_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    #[allow(missing_docs)] // documentation missing in model
    Suspending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Status::Disabled,
            "DISABLING" => Status::Disabling,
            "ENABLED" => Status::Enabled,
            "ENABLING" => Status::Enabling,
            "SUSPENDED" => Status::Suspended,
            "SUSPENDING" => Status::Suspending,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Disabled => "DISABLED",
            Status::Disabling => "DISABLING",
            Status::Enabled => "ENABLED",
            Status::Enabling => "ENABLING",
            Status::Suspended => "SUSPENDED",
            Status::Suspending => "SUSPENDING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DISABLED",
            "DISABLING",
            "ENABLED",
            "ENABLING",
            "SUSPENDED",
            "SUSPENDING",
        ]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An Amazon Web Services account within your environment that Amazon Inspector has been enabled for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Account {
    /// <p>The ID of the Amazon Web Services account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The status of Amazon Inspector for the account.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>Details of the status of Amazon Inspector scans by resource type.</p>
    pub resource_status: std::option::Option<crate::model::ResourceStatus>,
}
impl Account {
    /// <p>The ID of the Amazon Web Services account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The status of Amazon Inspector for the account.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>Details of the status of Amazon Inspector scans by resource type.</p>
    pub fn resource_status(&self) -> std::option::Option<&crate::model::ResourceStatus> {
        self.resource_status.as_ref()
    }
}
impl std::fmt::Debug for Account {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Account");
        formatter.field("account_id", &self.account_id);
        formatter.field("status", &self.status);
        formatter.field("resource_status", &self.resource_status);
        formatter.finish()
    }
}
/// See [`Account`](crate::model::Account)
pub mod account {
    /// A builder for [`Account`](crate::model::Account)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) resource_status: std::option::Option<crate::model::ResourceStatus>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The status of Amazon Inspector for the account.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of Amazon Inspector for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>Details of the status of Amazon Inspector scans by resource type.</p>
        pub fn resource_status(mut self, input: crate::model::ResourceStatus) -> Self {
            self.resource_status = Some(input);
            self
        }
        /// <p>Details of the status of Amazon Inspector scans by resource type.</p>
        pub fn set_resource_status(
            mut self,
            input: std::option::Option<crate::model::ResourceStatus>,
        ) -> Self {
            self.resource_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Account`](crate::model::Account)
        pub fn build(self) -> crate::model::Account {
            crate::model::Account {
                account_id: self.account_id,
                status: self.status,
                resource_status: self.resource_status,
            }
        }
    }
}
impl Account {
    /// Creates a new builder-style object to manufacture [`Account`](crate::model::Account)
    pub fn builder() -> crate::model::account::Builder {
        crate::model::account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceScanType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Ecr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceScanType {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => ResourceScanType::Ec2,
            "ECR" => ResourceScanType::Ecr,
            other => ResourceScanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceScanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceScanType::from(s))
    }
}
impl ResourceScanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceScanType::Ec2 => "EC2",
            ResourceScanType::Ecr => "ECR",
            ResourceScanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "ECR"]
    }
}
impl AsRef<str> for ResourceScanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => ReportFormat::Csv,
            "JSON" => ReportFormat::Json,
            other => ReportFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportFormat::from(s))
    }
}
impl ReportFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportFormat::Csv => "CSV",
            ReportFormat::Json => "JSON",
            ReportFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "JSON"]
    }
}
impl AsRef<str> for ReportFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an error received while accessing free trail data for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FreeTrialInfoError {
    /// <p>The account associated with the Amazon Inspector free trial information.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub code: std::option::Option<crate::model::FreeTrialInfoErrorCode>,
    /// <p>The error message returned.</p>
    pub message: std::option::Option<std::string::String>,
}
impl FreeTrialInfoError {
    /// <p>The account associated with the Amazon Inspector free trial information.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::FreeTrialInfoErrorCode> {
        self.code.as_ref()
    }
    /// <p>The error message returned.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for FreeTrialInfoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FreeTrialInfoError");
        formatter.field("account_id", &self.account_id);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`FreeTrialInfoError`](crate::model::FreeTrialInfoError)
pub mod free_trial_info_error {
    /// A builder for [`FreeTrialInfoError`](crate::model::FreeTrialInfoError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<crate::model::FreeTrialInfoErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account associated with the Amazon Inspector free trial information.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account associated with the Amazon Inspector free trial information.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The error code.</p>
        pub fn code(mut self, input: crate::model::FreeTrialInfoErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::FreeTrialInfoErrorCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message returned.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message returned.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FreeTrialInfoError`](crate::model::FreeTrialInfoError)
        pub fn build(self) -> crate::model::FreeTrialInfoError {
            crate::model::FreeTrialInfoError {
                account_id: self.account_id,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl FreeTrialInfoError {
    /// Creates a new builder-style object to manufacture [`FreeTrialInfoError`](crate::model::FreeTrialInfoError)
    pub fn builder() -> crate::model::free_trial_info_error::Builder {
        crate::model::free_trial_info_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FreeTrialInfoErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FreeTrialInfoErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => FreeTrialInfoErrorCode::AccessDenied,
            "INTERNAL_ERROR" => FreeTrialInfoErrorCode::InternalError,
            other => FreeTrialInfoErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FreeTrialInfoErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FreeTrialInfoErrorCode::from(s))
    }
}
impl FreeTrialInfoErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FreeTrialInfoErrorCode::AccessDenied => "ACCESS_DENIED",
            FreeTrialInfoErrorCode::InternalError => "INTERNAL_ERROR",
            FreeTrialInfoErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCESS_DENIED", "INTERNAL_ERROR"]
    }
}
impl AsRef<str> for FreeTrialInfoErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the Amazon Inspector free trial for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FreeTrialAccountInfo {
    /// <p>The account associated with the Amazon Inspector free trial information.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Contains information about the Amazon Inspector free trial for an account.</p>
    pub free_trial_info: std::option::Option<std::vec::Vec<crate::model::FreeTrialInfo>>,
}
impl FreeTrialAccountInfo {
    /// <p>The account associated with the Amazon Inspector free trial information.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Contains information about the Amazon Inspector free trial for an account.</p>
    pub fn free_trial_info(&self) -> std::option::Option<&[crate::model::FreeTrialInfo]> {
        self.free_trial_info.as_deref()
    }
}
impl std::fmt::Debug for FreeTrialAccountInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FreeTrialAccountInfo");
        formatter.field("account_id", &self.account_id);
        formatter.field("free_trial_info", &self.free_trial_info);
        formatter.finish()
    }
}
/// See [`FreeTrialAccountInfo`](crate::model::FreeTrialAccountInfo)
pub mod free_trial_account_info {
    /// A builder for [`FreeTrialAccountInfo`](crate::model::FreeTrialAccountInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) free_trial_info: std::option::Option<std::vec::Vec<crate::model::FreeTrialInfo>>,
    }
    impl Builder {
        /// <p>The account associated with the Amazon Inspector free trial information.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account associated with the Amazon Inspector free trial information.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `free_trial_info`.
        ///
        /// To override the contents of this collection use [`set_free_trial_info`](Self::set_free_trial_info).
        ///
        /// <p>Contains information about the Amazon Inspector free trial for an account.</p>
        pub fn free_trial_info(mut self, input: crate::model::FreeTrialInfo) -> Self {
            let mut v = self.free_trial_info.unwrap_or_default();
            v.push(input);
            self.free_trial_info = Some(v);
            self
        }
        /// <p>Contains information about the Amazon Inspector free trial for an account.</p>
        pub fn set_free_trial_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FreeTrialInfo>>,
        ) -> Self {
            self.free_trial_info = input;
            self
        }
        /// Consumes the builder and constructs a [`FreeTrialAccountInfo`](crate::model::FreeTrialAccountInfo)
        pub fn build(self) -> crate::model::FreeTrialAccountInfo {
            crate::model::FreeTrialAccountInfo {
                account_id: self.account_id,
                free_trial_info: self.free_trial_info,
            }
        }
    }
}
impl FreeTrialAccountInfo {
    /// Creates a new builder-style object to manufacture [`FreeTrialAccountInfo`](crate::model::FreeTrialAccountInfo)
    pub fn builder() -> crate::model::free_trial_account_info::Builder {
        crate::model::free_trial_account_info::Builder::default()
    }
}

/// <p>An object that contains information about the Amazon Inspector free trial for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FreeTrialInfo {
    /// <p>The type of scan covered by the Amazon Inspector free trail.</p>
    pub r#type: std::option::Option<crate::model::FreeTrialType>,
    /// <p>The date and time that the Amazon Inspector free trail started for a given account.</p>
    pub start: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the Amazon Inspector free trail ends for a given account.</p>
    pub end: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The order to sort results by.</p>
    pub status: std::option::Option<crate::model::FreeTrialStatus>,
}
impl FreeTrialInfo {
    /// <p>The type of scan covered by the Amazon Inspector free trail.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FreeTrialType> {
        self.r#type.as_ref()
    }
    /// <p>The date and time that the Amazon Inspector free trail started for a given account.</p>
    pub fn start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start.as_ref()
    }
    /// <p>The date and time that the Amazon Inspector free trail ends for a given account.</p>
    pub fn end(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end.as_ref()
    }
    /// <p>The order to sort results by.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FreeTrialStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for FreeTrialInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FreeTrialInfo");
        formatter.field("r#type", &self.r#type);
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`FreeTrialInfo`](crate::model::FreeTrialInfo)
pub mod free_trial_info {
    /// A builder for [`FreeTrialInfo`](crate::model::FreeTrialInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FreeTrialType>,
        pub(crate) start: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::FreeTrialStatus>,
    }
    impl Builder {
        /// <p>The type of scan covered by the Amazon Inspector free trail.</p>
        pub fn r#type(mut self, input: crate::model::FreeTrialType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of scan covered by the Amazon Inspector free trail.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FreeTrialType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date and time that the Amazon Inspector free trail started for a given account.</p>
        pub fn start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The date and time that the Amazon Inspector free trail started for a given account.</p>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.start = input;
            self
        }
        /// <p>The date and time that the Amazon Inspector free trail ends for a given account.</p>
        pub fn end(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The date and time that the Amazon Inspector free trail ends for a given account.</p>
        pub fn set_end(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.end = input;
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn status(mut self, input: crate::model::FreeTrialStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The order to sort results by.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FreeTrialStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`FreeTrialInfo`](crate::model::FreeTrialInfo)
        pub fn build(self) -> crate::model::FreeTrialInfo {
            crate::model::FreeTrialInfo {
                r#type: self.r#type,
                start: self.start,
                end: self.end,
                status: self.status,
            }
        }
    }
}
impl FreeTrialInfo {
    /// Creates a new builder-style object to manufacture [`FreeTrialInfo`](crate::model::FreeTrialInfo)
    pub fn builder() -> crate::model::free_trial_info::Builder {
        crate::model::free_trial_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FreeTrialStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FreeTrialStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => FreeTrialStatus::Active,
            "INACTIVE" => FreeTrialStatus::Inactive,
            other => FreeTrialStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FreeTrialStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FreeTrialStatus::from(s))
    }
}
impl FreeTrialStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FreeTrialStatus::Active => "ACTIVE",
            FreeTrialStatus::Inactive => "INACTIVE",
            FreeTrialStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for FreeTrialStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FreeTrialType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    Ecr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FreeTrialType {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => FreeTrialType::Ec2,
            "ECR" => FreeTrialType::Ecr,
            other => FreeTrialType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FreeTrialType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FreeTrialType::from(s))
    }
}
impl FreeTrialType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FreeTrialType::Ec2 => "EC2",
            FreeTrialType::Ecr => "ECR",
            FreeTrialType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "ECR"]
    }
}
impl AsRef<str> for FreeTrialType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object with details the status of an Amazon Web Services account within your Amazon Inspector environment</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountState {
    /// <p>The Amazon Web Services account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An object detailing the status of Amazon Inspector for the account.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
    pub resource_state: std::option::Option<crate::model::ResourceState>,
}
impl AccountState {
    /// <p>The Amazon Web Services account ID.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An object detailing the status of Amazon Inspector for the account.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
    pub fn resource_state(&self) -> std::option::Option<&crate::model::ResourceState> {
        self.resource_state.as_ref()
    }
}
impl std::fmt::Debug for AccountState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountState");
        formatter.field("account_id", &self.account_id);
        formatter.field("state", &self.state);
        formatter.field("resource_state", &self.resource_state);
        formatter.finish()
    }
}
/// See [`AccountState`](crate::model::AccountState)
pub mod account_state {
    /// A builder for [`AccountState`](crate::model::AccountState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) resource_state: std::option::Option<crate::model::ResourceState>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An object detailing the status of Amazon Inspector for the account.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>An object detailing the status of Amazon Inspector for the account.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
        pub fn resource_state(mut self, input: crate::model::ResourceState) -> Self {
            self.resource_state = Some(input);
            self
        }
        /// <p>An object detailing which resources Amazon Inspector is enabled to scan for the account.</p>
        pub fn set_resource_state(
            mut self,
            input: std::option::Option<crate::model::ResourceState>,
        ) -> Self {
            self.resource_state = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountState`](crate::model::AccountState)
        pub fn build(self) -> crate::model::AccountState {
            crate::model::AccountState {
                account_id: self.account_id,
                state: self.state,
                resource_state: self.resource_state,
            }
        }
    }
}
impl AccountState {
    /// Creates a new builder-style object to manufacture [`AccountState`](crate::model::AccountState)
    pub fn builder() -> crate::model::account_state::Builder {
        crate::model::account_state::Builder::default()
    }
}

/// <p>Details the state of Amazon Inspector for each resource type Amazon Inspector scans.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceState {
    /// <p>An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.</p>
    pub ec2: std::option::Option<crate::model::State>,
    /// <p>An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.</p>
    pub ecr: std::option::Option<crate::model::State>,
}
impl ResourceState {
    /// <p>An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.</p>
    pub fn ec2(&self) -> std::option::Option<&crate::model::State> {
        self.ec2.as_ref()
    }
    /// <p>An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.</p>
    pub fn ecr(&self) -> std::option::Option<&crate::model::State> {
        self.ecr.as_ref()
    }
}
impl std::fmt::Debug for ResourceState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceState");
        formatter.field("ec2", &self.ec2);
        formatter.field("ecr", &self.ecr);
        formatter.finish()
    }
}
/// See [`ResourceState`](crate::model::ResourceState)
pub mod resource_state {
    /// A builder for [`ResourceState`](crate::model::ResourceState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2: std::option::Option<crate::model::State>,
        pub(crate) ecr: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// <p>An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.</p>
        pub fn ec2(mut self, input: crate::model::State) -> Self {
            self.ec2 = Some(input);
            self
        }
        /// <p>An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.</p>
        pub fn set_ec2(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.ec2 = input;
            self
        }
        /// <p>An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.</p>
        pub fn ecr(mut self, input: crate::model::State) -> Self {
            self.ecr = Some(input);
            self
        }
        /// <p>An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.</p>
        pub fn set_ecr(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.ecr = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceState`](crate::model::ResourceState)
        pub fn build(self) -> crate::model::ResourceState {
            crate::model::ResourceState {
                ec2: self.ec2,
                ecr: self.ecr,
            }
        }
    }
}
impl ResourceState {
    /// Creates a new builder-style object to manufacture [`ResourceState`](crate::model::ResourceState)
    pub fn builder() -> crate::model::resource_state::Builder {
        crate::model::resource_state::Builder::default()
    }
}

/// <p>An object that described the state of Amazon Inspector scans for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct State {
    /// <p>The status of Amazon Inspector for the account.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl State {
    /// <p>The status of Amazon Inspector for the account.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for State {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("State");
        formatter.field("status", &self.status);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`State`](crate::model::State)
pub mod state {
    /// A builder for [`State`](crate::model::State)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of Amazon Inspector for the account.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of Amazon Inspector for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code explaining why the account failed to enable Amazon Inspector.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message received when the account failed to enable Amazon Inspector.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`State`](crate::model::State)
        pub fn build(self) -> crate::model::State {
            crate::model::State {
                status: self.status,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl State {
    /// Creates a new builder-style object to manufacture [`State`](crate::model::State)
    pub fn builder() -> crate::model::state::Builder {
        crate::model::state::Builder::default()
    }
}
