// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddAttributesToFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_attributes_to_findings`](crate::client::Client::add_attributes_to_findings).
///
/// See [`crate::client::fluent_builders::AddAttributesToFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddAttributesToFindings {
    _private: (),
}
impl AddAttributesToFindings {
    /// Creates a new builder-style object to manufacture [`AddAttributesToFindingsInput`](crate::input::AddAttributesToFindingsInput)
    pub fn builder() -> crate::input::add_attributes_to_findings_input::Builder {
        crate::input::add_attributes_to_findings_input::Builder::default()
    }
    /// Creates a new `AddAttributesToFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddAttributesToFindings {
    type Output = std::result::Result<
        crate::output::AddAttributesToFindingsOutput,
        crate::error::AddAttributesToFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_attributes_to_findings_error(response)
        } else {
            crate::operation_deser::parse_add_attributes_to_findings_response(response)
        }
    }
}

/// Operation shape for `CreateAssessmentTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_assessment_target`](crate::client::Client::create_assessment_target).
///
/// See [`crate::client::fluent_builders::CreateAssessmentTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssessmentTarget {
    _private: (),
}
impl CreateAssessmentTarget {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentTargetInput`](crate::input::CreateAssessmentTargetInput)
    pub fn builder() -> crate::input::create_assessment_target_input::Builder {
        crate::input::create_assessment_target_input::Builder::default()
    }
    /// Creates a new `CreateAssessmentTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssessmentTarget {
    type Output = std::result::Result<
        crate::output::CreateAssessmentTargetOutput,
        crate::error::CreateAssessmentTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_assessment_target_error(response)
        } else {
            crate::operation_deser::parse_create_assessment_target_response(response)
        }
    }
}

/// Operation shape for `CreateAssessmentTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_assessment_template`](crate::client::Client::create_assessment_template).
///
/// See [`crate::client::fluent_builders::CreateAssessmentTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssessmentTemplate {
    _private: (),
}
impl CreateAssessmentTemplate {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentTemplateInput`](crate::input::CreateAssessmentTemplateInput)
    pub fn builder() -> crate::input::create_assessment_template_input::Builder {
        crate::input::create_assessment_template_input::Builder::default()
    }
    /// Creates a new `CreateAssessmentTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssessmentTemplate {
    type Output = std::result::Result<
        crate::output::CreateAssessmentTemplateOutput,
        crate::error::CreateAssessmentTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_assessment_template_error(response)
        } else {
            crate::operation_deser::parse_create_assessment_template_response(response)
        }
    }
}

/// Operation shape for `CreateExclusionsPreview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_exclusions_preview`](crate::client::Client::create_exclusions_preview).
///
/// See [`crate::client::fluent_builders::CreateExclusionsPreview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExclusionsPreview {
    _private: (),
}
impl CreateExclusionsPreview {
    /// Creates a new builder-style object to manufacture [`CreateExclusionsPreviewInput`](crate::input::CreateExclusionsPreviewInput)
    pub fn builder() -> crate::input::create_exclusions_preview_input::Builder {
        crate::input::create_exclusions_preview_input::Builder::default()
    }
    /// Creates a new `CreateExclusionsPreview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExclusionsPreview {
    type Output = std::result::Result<
        crate::output::CreateExclusionsPreviewOutput,
        crate::error::CreateExclusionsPreviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_exclusions_preview_error(response)
        } else {
            crate::operation_deser::parse_create_exclusions_preview_response(response)
        }
    }
}

/// Operation shape for `CreateResourceGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_group`](crate::client::Client::create_resource_group).
///
/// See [`crate::client::fluent_builders::CreateResourceGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourceGroup {
    _private: (),
}
impl CreateResourceGroup {
    /// Creates a new builder-style object to manufacture [`CreateResourceGroupInput`](crate::input::CreateResourceGroupInput)
    pub fn builder() -> crate::input::create_resource_group_input::Builder {
        crate::input::create_resource_group_input::Builder::default()
    }
    /// Creates a new `CreateResourceGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourceGroup {
    type Output = std::result::Result<
        crate::output::CreateResourceGroupOutput,
        crate::error::CreateResourceGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_group_error(response)
        } else {
            crate::operation_deser::parse_create_resource_group_response(response)
        }
    }
}

/// Operation shape for `DeleteAssessmentRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assessment_run`](crate::client::Client::delete_assessment_run).
///
/// See [`crate::client::fluent_builders::DeleteAssessmentRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssessmentRun {
    _private: (),
}
impl DeleteAssessmentRun {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentRunInput`](crate::input::DeleteAssessmentRunInput)
    pub fn builder() -> crate::input::delete_assessment_run_input::Builder {
        crate::input::delete_assessment_run_input::Builder::default()
    }
    /// Creates a new `DeleteAssessmentRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssessmentRun {
    type Output = std::result::Result<
        crate::output::DeleteAssessmentRunOutput,
        crate::error::DeleteAssessmentRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_assessment_run_error(response)
        } else {
            crate::operation_deser::parse_delete_assessment_run_response(response)
        }
    }
}

/// Operation shape for `DeleteAssessmentTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assessment_target`](crate::client::Client::delete_assessment_target).
///
/// See [`crate::client::fluent_builders::DeleteAssessmentTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssessmentTarget {
    _private: (),
}
impl DeleteAssessmentTarget {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentTargetInput`](crate::input::DeleteAssessmentTargetInput)
    pub fn builder() -> crate::input::delete_assessment_target_input::Builder {
        crate::input::delete_assessment_target_input::Builder::default()
    }
    /// Creates a new `DeleteAssessmentTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssessmentTarget {
    type Output = std::result::Result<
        crate::output::DeleteAssessmentTargetOutput,
        crate::error::DeleteAssessmentTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_assessment_target_error(response)
        } else {
            crate::operation_deser::parse_delete_assessment_target_response(response)
        }
    }
}

/// Operation shape for `DeleteAssessmentTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assessment_template`](crate::client::Client::delete_assessment_template).
///
/// See [`crate::client::fluent_builders::DeleteAssessmentTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssessmentTemplate {
    _private: (),
}
impl DeleteAssessmentTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentTemplateInput`](crate::input::DeleteAssessmentTemplateInput)
    pub fn builder() -> crate::input::delete_assessment_template_input::Builder {
        crate::input::delete_assessment_template_input::Builder::default()
    }
    /// Creates a new `DeleteAssessmentTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssessmentTemplate {
    type Output = std::result::Result<
        crate::output::DeleteAssessmentTemplateOutput,
        crate::error::DeleteAssessmentTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_assessment_template_error(response)
        } else {
            crate::operation_deser::parse_delete_assessment_template_response(response)
        }
    }
}

/// Operation shape for `DescribeAssessmentRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_assessment_runs`](crate::client::Client::describe_assessment_runs).
///
/// See [`crate::client::fluent_builders::DescribeAssessmentRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssessmentRuns {
    _private: (),
}
impl DescribeAssessmentRuns {
    /// Creates a new builder-style object to manufacture [`DescribeAssessmentRunsInput`](crate::input::DescribeAssessmentRunsInput)
    pub fn builder() -> crate::input::describe_assessment_runs_input::Builder {
        crate::input::describe_assessment_runs_input::Builder::default()
    }
    /// Creates a new `DescribeAssessmentRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssessmentRuns {
    type Output = std::result::Result<
        crate::output::DescribeAssessmentRunsOutput,
        crate::error::DescribeAssessmentRunsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_assessment_runs_error(response)
        } else {
            crate::operation_deser::parse_describe_assessment_runs_response(response)
        }
    }
}

/// Operation shape for `DescribeAssessmentTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_assessment_targets`](crate::client::Client::describe_assessment_targets).
///
/// See [`crate::client::fluent_builders::DescribeAssessmentTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssessmentTargets {
    _private: (),
}
impl DescribeAssessmentTargets {
    /// Creates a new builder-style object to manufacture [`DescribeAssessmentTargetsInput`](crate::input::DescribeAssessmentTargetsInput)
    pub fn builder() -> crate::input::describe_assessment_targets_input::Builder {
        crate::input::describe_assessment_targets_input::Builder::default()
    }
    /// Creates a new `DescribeAssessmentTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssessmentTargets {
    type Output = std::result::Result<
        crate::output::DescribeAssessmentTargetsOutput,
        crate::error::DescribeAssessmentTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_assessment_targets_error(response)
        } else {
            crate::operation_deser::parse_describe_assessment_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeAssessmentTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_assessment_templates`](crate::client::Client::describe_assessment_templates).
///
/// See [`crate::client::fluent_builders::DescribeAssessmentTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssessmentTemplates {
    _private: (),
}
impl DescribeAssessmentTemplates {
    /// Creates a new builder-style object to manufacture [`DescribeAssessmentTemplatesInput`](crate::input::DescribeAssessmentTemplatesInput)
    pub fn builder() -> crate::input::describe_assessment_templates_input::Builder {
        crate::input::describe_assessment_templates_input::Builder::default()
    }
    /// Creates a new `DescribeAssessmentTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssessmentTemplates {
    type Output = std::result::Result<
        crate::output::DescribeAssessmentTemplatesOutput,
        crate::error::DescribeAssessmentTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_assessment_templates_error(response)
        } else {
            crate::operation_deser::parse_describe_assessment_templates_response(response)
        }
    }
}

/// Operation shape for `DescribeCrossAccountAccessRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cross_account_access_role`](crate::client::Client::describe_cross_account_access_role).
///
/// See [`crate::client::fluent_builders::DescribeCrossAccountAccessRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCrossAccountAccessRole {
    _private: (),
}
impl DescribeCrossAccountAccessRole {
    /// Creates a new builder-style object to manufacture [`DescribeCrossAccountAccessRoleInput`](crate::input::DescribeCrossAccountAccessRoleInput)
    pub fn builder() -> crate::input::describe_cross_account_access_role_input::Builder {
        crate::input::describe_cross_account_access_role_input::Builder::default()
    }
    /// Creates a new `DescribeCrossAccountAccessRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCrossAccountAccessRole {
    type Output = std::result::Result<
        crate::output::DescribeCrossAccountAccessRoleOutput,
        crate::error::DescribeCrossAccountAccessRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cross_account_access_role_error(response)
        } else {
            crate::operation_deser::parse_describe_cross_account_access_role_response(response)
        }
    }
}

/// Operation shape for `DescribeExclusions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_exclusions`](crate::client::Client::describe_exclusions).
///
/// See [`crate::client::fluent_builders::DescribeExclusions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExclusions {
    _private: (),
}
impl DescribeExclusions {
    /// Creates a new builder-style object to manufacture [`DescribeExclusionsInput`](crate::input::DescribeExclusionsInput)
    pub fn builder() -> crate::input::describe_exclusions_input::Builder {
        crate::input::describe_exclusions_input::Builder::default()
    }
    /// Creates a new `DescribeExclusions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExclusions {
    type Output = std::result::Result<
        crate::output::DescribeExclusionsOutput,
        crate::error::DescribeExclusionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_exclusions_error(response)
        } else {
            crate::operation_deser::parse_describe_exclusions_response(response)
        }
    }
}

/// Operation shape for `DescribeFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_findings`](crate::client::Client::describe_findings).
///
/// See [`crate::client::fluent_builders::DescribeFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFindings {
    _private: (),
}
impl DescribeFindings {
    /// Creates a new builder-style object to manufacture [`DescribeFindingsInput`](crate::input::DescribeFindingsInput)
    pub fn builder() -> crate::input::describe_findings_input::Builder {
        crate::input::describe_findings_input::Builder::default()
    }
    /// Creates a new `DescribeFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFindings {
    type Output = std::result::Result<
        crate::output::DescribeFindingsOutput,
        crate::error::DescribeFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_findings_error(response)
        } else {
            crate::operation_deser::parse_describe_findings_response(response)
        }
    }
}

/// Operation shape for `DescribeResourceGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource_groups`](crate::client::Client::describe_resource_groups).
///
/// See [`crate::client::fluent_builders::DescribeResourceGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResourceGroups {
    _private: (),
}
impl DescribeResourceGroups {
    /// Creates a new builder-style object to manufacture [`DescribeResourceGroupsInput`](crate::input::DescribeResourceGroupsInput)
    pub fn builder() -> crate::input::describe_resource_groups_input::Builder {
        crate::input::describe_resource_groups_input::Builder::default()
    }
    /// Creates a new `DescribeResourceGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResourceGroups {
    type Output = std::result::Result<
        crate::output::DescribeResourceGroupsOutput,
        crate::error::DescribeResourceGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeRulesPackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_rules_packages`](crate::client::Client::describe_rules_packages).
///
/// See [`crate::client::fluent_builders::DescribeRulesPackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRulesPackages {
    _private: (),
}
impl DescribeRulesPackages {
    /// Creates a new builder-style object to manufacture [`DescribeRulesPackagesInput`](crate::input::DescribeRulesPackagesInput)
    pub fn builder() -> crate::input::describe_rules_packages_input::Builder {
        crate::input::describe_rules_packages_input::Builder::default()
    }
    /// Creates a new `DescribeRulesPackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRulesPackages {
    type Output = std::result::Result<
        crate::output::DescribeRulesPackagesOutput,
        crate::error::DescribeRulesPackagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_rules_packages_error(response)
        } else {
            crate::operation_deser::parse_describe_rules_packages_response(response)
        }
    }
}

/// Operation shape for `GetAssessmentReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_assessment_report`](crate::client::Client::get_assessment_report).
///
/// See [`crate::client::fluent_builders::GetAssessmentReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssessmentReport {
    _private: (),
}
impl GetAssessmentReport {
    /// Creates a new builder-style object to manufacture [`GetAssessmentReportInput`](crate::input::GetAssessmentReportInput)
    pub fn builder() -> crate::input::get_assessment_report_input::Builder {
        crate::input::get_assessment_report_input::Builder::default()
    }
    /// Creates a new `GetAssessmentReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssessmentReport {
    type Output = std::result::Result<
        crate::output::GetAssessmentReportOutput,
        crate::error::GetAssessmentReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_assessment_report_error(response)
        } else {
            crate::operation_deser::parse_get_assessment_report_response(response)
        }
    }
}

/// Operation shape for `GetExclusionsPreview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_exclusions_preview`](crate::client::Client::get_exclusions_preview).
///
/// See [`crate::client::fluent_builders::GetExclusionsPreview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExclusionsPreview {
    _private: (),
}
impl GetExclusionsPreview {
    /// Creates a new builder-style object to manufacture [`GetExclusionsPreviewInput`](crate::input::GetExclusionsPreviewInput)
    pub fn builder() -> crate::input::get_exclusions_preview_input::Builder {
        crate::input::get_exclusions_preview_input::Builder::default()
    }
    /// Creates a new `GetExclusionsPreview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExclusionsPreview {
    type Output = std::result::Result<
        crate::output::GetExclusionsPreviewOutput,
        crate::error::GetExclusionsPreviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_exclusions_preview_error(response)
        } else {
            crate::operation_deser::parse_get_exclusions_preview_response(response)
        }
    }
}

/// Operation shape for `GetTelemetryMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_telemetry_metadata`](crate::client::Client::get_telemetry_metadata).
///
/// See [`crate::client::fluent_builders::GetTelemetryMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTelemetryMetadata {
    _private: (),
}
impl GetTelemetryMetadata {
    /// Creates a new builder-style object to manufacture [`GetTelemetryMetadataInput`](crate::input::GetTelemetryMetadataInput)
    pub fn builder() -> crate::input::get_telemetry_metadata_input::Builder {
        crate::input::get_telemetry_metadata_input::Builder::default()
    }
    /// Creates a new `GetTelemetryMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTelemetryMetadata {
    type Output = std::result::Result<
        crate::output::GetTelemetryMetadataOutput,
        crate::error::GetTelemetryMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_telemetry_metadata_error(response)
        } else {
            crate::operation_deser::parse_get_telemetry_metadata_response(response)
        }
    }
}

/// Operation shape for `ListAssessmentRunAgents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assessment_run_agents`](crate::client::Client::list_assessment_run_agents).
///
/// See [`crate::client::fluent_builders::ListAssessmentRunAgents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssessmentRunAgents {
    _private: (),
}
impl ListAssessmentRunAgents {
    /// Creates a new builder-style object to manufacture [`ListAssessmentRunAgentsInput`](crate::input::ListAssessmentRunAgentsInput)
    pub fn builder() -> crate::input::list_assessment_run_agents_input::Builder {
        crate::input::list_assessment_run_agents_input::Builder::default()
    }
    /// Creates a new `ListAssessmentRunAgents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssessmentRunAgents {
    type Output = std::result::Result<
        crate::output::ListAssessmentRunAgentsOutput,
        crate::error::ListAssessmentRunAgentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assessment_run_agents_error(response)
        } else {
            crate::operation_deser::parse_list_assessment_run_agents_response(response)
        }
    }
}

/// Operation shape for `ListAssessmentRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assessment_runs`](crate::client::Client::list_assessment_runs).
///
/// See [`crate::client::fluent_builders::ListAssessmentRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssessmentRuns {
    _private: (),
}
impl ListAssessmentRuns {
    /// Creates a new builder-style object to manufacture [`ListAssessmentRunsInput`](crate::input::ListAssessmentRunsInput)
    pub fn builder() -> crate::input::list_assessment_runs_input::Builder {
        crate::input::list_assessment_runs_input::Builder::default()
    }
    /// Creates a new `ListAssessmentRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssessmentRuns {
    type Output = std::result::Result<
        crate::output::ListAssessmentRunsOutput,
        crate::error::ListAssessmentRunsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assessment_runs_error(response)
        } else {
            crate::operation_deser::parse_list_assessment_runs_response(response)
        }
    }
}

/// Operation shape for `ListAssessmentTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assessment_targets`](crate::client::Client::list_assessment_targets).
///
/// See [`crate::client::fluent_builders::ListAssessmentTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssessmentTargets {
    _private: (),
}
impl ListAssessmentTargets {
    /// Creates a new builder-style object to manufacture [`ListAssessmentTargetsInput`](crate::input::ListAssessmentTargetsInput)
    pub fn builder() -> crate::input::list_assessment_targets_input::Builder {
        crate::input::list_assessment_targets_input::Builder::default()
    }
    /// Creates a new `ListAssessmentTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssessmentTargets {
    type Output = std::result::Result<
        crate::output::ListAssessmentTargetsOutput,
        crate::error::ListAssessmentTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assessment_targets_error(response)
        } else {
            crate::operation_deser::parse_list_assessment_targets_response(response)
        }
    }
}

/// Operation shape for `ListAssessmentTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assessment_templates`](crate::client::Client::list_assessment_templates).
///
/// See [`crate::client::fluent_builders::ListAssessmentTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssessmentTemplates {
    _private: (),
}
impl ListAssessmentTemplates {
    /// Creates a new builder-style object to manufacture [`ListAssessmentTemplatesInput`](crate::input::ListAssessmentTemplatesInput)
    pub fn builder() -> crate::input::list_assessment_templates_input::Builder {
        crate::input::list_assessment_templates_input::Builder::default()
    }
    /// Creates a new `ListAssessmentTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssessmentTemplates {
    type Output = std::result::Result<
        crate::output::ListAssessmentTemplatesOutput,
        crate::error::ListAssessmentTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assessment_templates_error(response)
        } else {
            crate::operation_deser::parse_list_assessment_templates_response(response)
        }
    }
}

/// Operation shape for `ListEventSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_event_subscriptions`](crate::client::Client::list_event_subscriptions).
///
/// See [`crate::client::fluent_builders::ListEventSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEventSubscriptions {
    _private: (),
}
impl ListEventSubscriptions {
    /// Creates a new builder-style object to manufacture [`ListEventSubscriptionsInput`](crate::input::ListEventSubscriptionsInput)
    pub fn builder() -> crate::input::list_event_subscriptions_input::Builder {
        crate::input::list_event_subscriptions_input::Builder::default()
    }
    /// Creates a new `ListEventSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEventSubscriptions {
    type Output = std::result::Result<
        crate::output::ListEventSubscriptionsOutput,
        crate::error::ListEventSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_event_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_list_event_subscriptions_response(response)
        }
    }
}

/// Operation shape for `ListExclusions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_exclusions`](crate::client::Client::list_exclusions).
///
/// See [`crate::client::fluent_builders::ListExclusions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExclusions {
    _private: (),
}
impl ListExclusions {
    /// Creates a new builder-style object to manufacture [`ListExclusionsInput`](crate::input::ListExclusionsInput)
    pub fn builder() -> crate::input::list_exclusions_input::Builder {
        crate::input::list_exclusions_input::Builder::default()
    }
    /// Creates a new `ListExclusions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExclusions {
    type Output =
        std::result::Result<crate::output::ListExclusionsOutput, crate::error::ListExclusionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_exclusions_error(response)
        } else {
            crate::operation_deser::parse_list_exclusions_response(response)
        }
    }
}

/// Operation shape for `ListFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_findings`](crate::client::Client::list_findings).
///
/// See [`crate::client::fluent_builders::ListFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindings {
    _private: (),
}
impl ListFindings {
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
    /// Creates a new `ListFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindings {
    type Output =
        std::result::Result<crate::output::ListFindingsOutput, crate::error::ListFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_findings_error(response)
        } else {
            crate::operation_deser::parse_list_findings_response(response)
        }
    }
}

/// Operation shape for `ListRulesPackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rules_packages`](crate::client::Client::list_rules_packages).
///
/// See [`crate::client::fluent_builders::ListRulesPackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRulesPackages {
    _private: (),
}
impl ListRulesPackages {
    /// Creates a new builder-style object to manufacture [`ListRulesPackagesInput`](crate::input::ListRulesPackagesInput)
    pub fn builder() -> crate::input::list_rules_packages_input::Builder {
        crate::input::list_rules_packages_input::Builder::default()
    }
    /// Creates a new `ListRulesPackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRulesPackages {
    type Output = std::result::Result<
        crate::output::ListRulesPackagesOutput,
        crate::error::ListRulesPackagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rules_packages_error(response)
        } else {
            crate::operation_deser::parse_list_rules_packages_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PreviewAgents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`preview_agents`](crate::client::Client::preview_agents).
///
/// See [`crate::client::fluent_builders::PreviewAgents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PreviewAgents {
    _private: (),
}
impl PreviewAgents {
    /// Creates a new builder-style object to manufacture [`PreviewAgentsInput`](crate::input::PreviewAgentsInput)
    pub fn builder() -> crate::input::preview_agents_input::Builder {
        crate::input::preview_agents_input::Builder::default()
    }
    /// Creates a new `PreviewAgents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PreviewAgents {
    type Output =
        std::result::Result<crate::output::PreviewAgentsOutput, crate::error::PreviewAgentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_preview_agents_error(response)
        } else {
            crate::operation_deser::parse_preview_agents_response(response)
        }
    }
}

/// Operation shape for `RegisterCrossAccountAccessRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_cross_account_access_role`](crate::client::Client::register_cross_account_access_role).
///
/// See [`crate::client::fluent_builders::RegisterCrossAccountAccessRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterCrossAccountAccessRole {
    _private: (),
}
impl RegisterCrossAccountAccessRole {
    /// Creates a new builder-style object to manufacture [`RegisterCrossAccountAccessRoleInput`](crate::input::RegisterCrossAccountAccessRoleInput)
    pub fn builder() -> crate::input::register_cross_account_access_role_input::Builder {
        crate::input::register_cross_account_access_role_input::Builder::default()
    }
    /// Creates a new `RegisterCrossAccountAccessRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterCrossAccountAccessRole {
    type Output = std::result::Result<
        crate::output::RegisterCrossAccountAccessRoleOutput,
        crate::error::RegisterCrossAccountAccessRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_cross_account_access_role_error(response)
        } else {
            crate::operation_deser::parse_register_cross_account_access_role_response(response)
        }
    }
}

/// Operation shape for `RemoveAttributesFromFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_attributes_from_findings`](crate::client::Client::remove_attributes_from_findings).
///
/// See [`crate::client::fluent_builders::RemoveAttributesFromFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveAttributesFromFindings {
    _private: (),
}
impl RemoveAttributesFromFindings {
    /// Creates a new builder-style object to manufacture [`RemoveAttributesFromFindingsInput`](crate::input::RemoveAttributesFromFindingsInput)
    pub fn builder() -> crate::input::remove_attributes_from_findings_input::Builder {
        crate::input::remove_attributes_from_findings_input::Builder::default()
    }
    /// Creates a new `RemoveAttributesFromFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveAttributesFromFindings {
    type Output = std::result::Result<
        crate::output::RemoveAttributesFromFindingsOutput,
        crate::error::RemoveAttributesFromFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_attributes_from_findings_error(response)
        } else {
            crate::operation_deser::parse_remove_attributes_from_findings_response(response)
        }
    }
}

/// Operation shape for `SetTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_tags_for_resource`](crate::client::Client::set_tags_for_resource).
///
/// See [`crate::client::fluent_builders::SetTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetTagsForResource {
    _private: (),
}
impl SetTagsForResource {
    /// Creates a new builder-style object to manufacture [`SetTagsForResourceInput`](crate::input::SetTagsForResourceInput)
    pub fn builder() -> crate::input::set_tags_for_resource_input::Builder {
        crate::input::set_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `SetTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetTagsForResource {
    type Output = std::result::Result<
        crate::output::SetTagsForResourceOutput,
        crate::error::SetTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_set_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `StartAssessmentRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_assessment_run`](crate::client::Client::start_assessment_run).
///
/// See [`crate::client::fluent_builders::StartAssessmentRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAssessmentRun {
    _private: (),
}
impl StartAssessmentRun {
    /// Creates a new builder-style object to manufacture [`StartAssessmentRunInput`](crate::input::StartAssessmentRunInput)
    pub fn builder() -> crate::input::start_assessment_run_input::Builder {
        crate::input::start_assessment_run_input::Builder::default()
    }
    /// Creates a new `StartAssessmentRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAssessmentRun {
    type Output = std::result::Result<
        crate::output::StartAssessmentRunOutput,
        crate::error::StartAssessmentRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_assessment_run_error(response)
        } else {
            crate::operation_deser::parse_start_assessment_run_response(response)
        }
    }
}

/// Operation shape for `StopAssessmentRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_assessment_run`](crate::client::Client::stop_assessment_run).
///
/// See [`crate::client::fluent_builders::StopAssessmentRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopAssessmentRun {
    _private: (),
}
impl StopAssessmentRun {
    /// Creates a new builder-style object to manufacture [`StopAssessmentRunInput`](crate::input::StopAssessmentRunInput)
    pub fn builder() -> crate::input::stop_assessment_run_input::Builder {
        crate::input::stop_assessment_run_input::Builder::default()
    }
    /// Creates a new `StopAssessmentRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopAssessmentRun {
    type Output = std::result::Result<
        crate::output::StopAssessmentRunOutput,
        crate::error::StopAssessmentRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_assessment_run_error(response)
        } else {
            crate::operation_deser::parse_stop_assessment_run_response(response)
        }
    }
}

/// Operation shape for `SubscribeToEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`subscribe_to_event`](crate::client::Client::subscribe_to_event).
///
/// See [`crate::client::fluent_builders::SubscribeToEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SubscribeToEvent {
    _private: (),
}
impl SubscribeToEvent {
    /// Creates a new builder-style object to manufacture [`SubscribeToEventInput`](crate::input::SubscribeToEventInput)
    pub fn builder() -> crate::input::subscribe_to_event_input::Builder {
        crate::input::subscribe_to_event_input::Builder::default()
    }
    /// Creates a new `SubscribeToEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SubscribeToEvent {
    type Output = std::result::Result<
        crate::output::SubscribeToEventOutput,
        crate::error::SubscribeToEventError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_subscribe_to_event_error(response)
        } else {
            crate::operation_deser::parse_subscribe_to_event_response(response)
        }
    }
}

/// Operation shape for `UnsubscribeFromEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unsubscribe_from_event`](crate::client::Client::unsubscribe_from_event).
///
/// See [`crate::client::fluent_builders::UnsubscribeFromEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnsubscribeFromEvent {
    _private: (),
}
impl UnsubscribeFromEvent {
    /// Creates a new builder-style object to manufacture [`UnsubscribeFromEventInput`](crate::input::UnsubscribeFromEventInput)
    pub fn builder() -> crate::input::unsubscribe_from_event_input::Builder {
        crate::input::unsubscribe_from_event_input::Builder::default()
    }
    /// Creates a new `UnsubscribeFromEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnsubscribeFromEvent {
    type Output = std::result::Result<
        crate::output::UnsubscribeFromEventOutput,
        crate::error::UnsubscribeFromEventError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unsubscribe_from_event_error(response)
        } else {
            crate::operation_deser::parse_unsubscribe_from_event_response(response)
        }
    }
}

/// Operation shape for `UpdateAssessmentTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_assessment_target`](crate::client::Client::update_assessment_target).
///
/// See [`crate::client::fluent_builders::UpdateAssessmentTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssessmentTarget {
    _private: (),
}
impl UpdateAssessmentTarget {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentTargetInput`](crate::input::UpdateAssessmentTargetInput)
    pub fn builder() -> crate::input::update_assessment_target_input::Builder {
        crate::input::update_assessment_target_input::Builder::default()
    }
    /// Creates a new `UpdateAssessmentTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssessmentTarget {
    type Output = std::result::Result<
        crate::output::UpdateAssessmentTargetOutput,
        crate::error::UpdateAssessmentTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_assessment_target_error(response)
        } else {
            crate::operation_deser::parse_update_assessment_target_response(response)
        }
    }
}
