// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NoSuchEntityErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AssessmentRunDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentTargetDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentTemplateDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    FindingDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    IamRoleDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    ResourceGroupDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    RulesPackageDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    SnsTopicDoesNotExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NoSuchEntityErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ASSESSMENT_RUN_DOES_NOT_EXIST" => NoSuchEntityErrorCode::AssessmentRunDoesNotExist,
            "ASSESSMENT_TARGET_DOES_NOT_EXIST" => {
                NoSuchEntityErrorCode::AssessmentTargetDoesNotExist
            }
            "ASSESSMENT_TEMPLATE_DOES_NOT_EXIST" => {
                NoSuchEntityErrorCode::AssessmentTemplateDoesNotExist
            }
            "FINDING_DOES_NOT_EXIST" => NoSuchEntityErrorCode::FindingDoesNotExist,
            "IAM_ROLE_DOES_NOT_EXIST" => NoSuchEntityErrorCode::IamRoleDoesNotExist,
            "RESOURCE_GROUP_DOES_NOT_EXIST" => NoSuchEntityErrorCode::ResourceGroupDoesNotExist,
            "RULES_PACKAGE_DOES_NOT_EXIST" => NoSuchEntityErrorCode::RulesPackageDoesNotExist,
            "SNS_TOPIC_DOES_NOT_EXIST" => NoSuchEntityErrorCode::SnsTopicDoesNotExist,
            other => NoSuchEntityErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NoSuchEntityErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NoSuchEntityErrorCode::from(s))
    }
}
impl NoSuchEntityErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NoSuchEntityErrorCode::AssessmentRunDoesNotExist => "ASSESSMENT_RUN_DOES_NOT_EXIST",
            NoSuchEntityErrorCode::AssessmentTargetDoesNotExist => {
                "ASSESSMENT_TARGET_DOES_NOT_EXIST"
            }
            NoSuchEntityErrorCode::AssessmentTemplateDoesNotExist => {
                "ASSESSMENT_TEMPLATE_DOES_NOT_EXIST"
            }
            NoSuchEntityErrorCode::FindingDoesNotExist => "FINDING_DOES_NOT_EXIST",
            NoSuchEntityErrorCode::IamRoleDoesNotExist => "IAM_ROLE_DOES_NOT_EXIST",
            NoSuchEntityErrorCode::ResourceGroupDoesNotExist => "RESOURCE_GROUP_DOES_NOT_EXIST",
            NoSuchEntityErrorCode::RulesPackageDoesNotExist => "RULES_PACKAGE_DOES_NOT_EXIST",
            NoSuchEntityErrorCode::SnsTopicDoesNotExist => "SNS_TOPIC_DOES_NOT_EXIST",
            NoSuchEntityErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSESSMENT_RUN_DOES_NOT_EXIST",
            "ASSESSMENT_TARGET_DOES_NOT_EXIST",
            "ASSESSMENT_TEMPLATE_DOES_NOT_EXIST",
            "FINDING_DOES_NOT_EXIST",
            "IAM_ROLE_DOES_NOT_EXIST",
            "RESOURCE_GROUP_DOES_NOT_EXIST",
            "RULES_PACKAGE_DOES_NOT_EXIST",
            "SNS_TOPIC_DOES_NOT_EXIST",
        ]
    }
}
impl AsRef<str> for NoSuchEntityErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InvalidInputErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AssessmentTargetNameAlreadyTaken,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentTemplateNameAlreadyTaken,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAgentId,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentRunArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentRunCompletionTimeRange,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentRunDurationRange,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentRunStartTimeRange,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentRunState,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentRunStateChangeTimeRange,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTargetArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTargetName,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTargetNamePattern,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTemplateArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTemplateDuration,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTemplateDurationRange,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTemplateName,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAssessmentTemplateNamePattern,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAttribute,
    #[allow(missing_docs)] // documentation missing in model
    InvalidAutoScalingGroup,
    #[allow(missing_docs)] // documentation missing in model
    InvalidEvent,
    #[allow(missing_docs)] // documentation missing in model
    InvalidFindingArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidIamRoleArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidLocale,
    #[allow(missing_docs)] // documentation missing in model
    InvalidMaxResults,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfAgentIds,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfAssessmentRunArns,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfAssessmentRunStates,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfAssessmentTargetArns,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfAssessmentTemplateArns,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfAttributes,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfAutoScalingGroups,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfFindingArns,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfResourceGroupArns,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfResourceGroupTags,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfRulesPackageArns,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfRuleNames,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfSeverities,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfTags,
    #[allow(missing_docs)] // documentation missing in model
    InvalidNumberOfUserAttributes,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPaginationToken,
    #[allow(missing_docs)] // documentation missing in model
    InvalidResourceArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidResourceGroupArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidResourceGroupTagKey,
    #[allow(missing_docs)] // documentation missing in model
    InvalidResourceGroupTagValue,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRulesPackageArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidRuleName,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSeverity,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSnsTopicArn,
    #[allow(missing_docs)] // documentation missing in model
    InvalidTag,
    #[allow(missing_docs)] // documentation missing in model
    InvalidTagKey,
    #[allow(missing_docs)] // documentation missing in model
    InvalidTagValue,
    #[allow(missing_docs)] // documentation missing in model
    InvalidUserAttribute,
    #[allow(missing_docs)] // documentation missing in model
    InvalidUserAttributeKey,
    #[allow(missing_docs)] // documentation missing in model
    InvalidUserAttributeValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InvalidInputErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ASSESSMENT_TARGET_NAME_ALREADY_TAKEN" => {
                InvalidInputErrorCode::AssessmentTargetNameAlreadyTaken
            }
            "ASSESSMENT_TEMPLATE_NAME_ALREADY_TAKEN" => {
                InvalidInputErrorCode::AssessmentTemplateNameAlreadyTaken
            }
            "INVALID_AGENT_ID" => InvalidInputErrorCode::InvalidAgentId,
            "INVALID_ASSESSMENT_RUN_ARN" => InvalidInputErrorCode::InvalidAssessmentRunArn,
            "INVALID_ASSESSMENT_RUN_COMPLETION_TIME_RANGE" => {
                InvalidInputErrorCode::InvalidAssessmentRunCompletionTimeRange
            }
            "INVALID_ASSESSMENT_RUN_DURATION_RANGE" => {
                InvalidInputErrorCode::InvalidAssessmentRunDurationRange
            }
            "INVALID_ASSESSMENT_RUN_START_TIME_RANGE" => {
                InvalidInputErrorCode::InvalidAssessmentRunStartTimeRange
            }
            "INVALID_ASSESSMENT_RUN_STATE" => InvalidInputErrorCode::InvalidAssessmentRunState,
            "INVALID_ASSESSMENT_RUN_STATE_CHANGE_TIME_RANGE" => {
                InvalidInputErrorCode::InvalidAssessmentRunStateChangeTimeRange
            }
            "INVALID_ASSESSMENT_TARGET_ARN" => InvalidInputErrorCode::InvalidAssessmentTargetArn,
            "INVALID_ASSESSMENT_TARGET_NAME" => InvalidInputErrorCode::InvalidAssessmentTargetName,
            "INVALID_ASSESSMENT_TARGET_NAME_PATTERN" => {
                InvalidInputErrorCode::InvalidAssessmentTargetNamePattern
            }
            "INVALID_ASSESSMENT_TEMPLATE_ARN" => {
                InvalidInputErrorCode::InvalidAssessmentTemplateArn
            }
            "INVALID_ASSESSMENT_TEMPLATE_DURATION" => {
                InvalidInputErrorCode::InvalidAssessmentTemplateDuration
            }
            "INVALID_ASSESSMENT_TEMPLATE_DURATION_RANGE" => {
                InvalidInputErrorCode::InvalidAssessmentTemplateDurationRange
            }
            "INVALID_ASSESSMENT_TEMPLATE_NAME" => {
                InvalidInputErrorCode::InvalidAssessmentTemplateName
            }
            "INVALID_ASSESSMENT_TEMPLATE_NAME_PATTERN" => {
                InvalidInputErrorCode::InvalidAssessmentTemplateNamePattern
            }
            "INVALID_ATTRIBUTE" => InvalidInputErrorCode::InvalidAttribute,
            "INVALID_AUTO_SCALING_GROUP" => InvalidInputErrorCode::InvalidAutoScalingGroup,
            "INVALID_EVENT" => InvalidInputErrorCode::InvalidEvent,
            "INVALID_FINDING_ARN" => InvalidInputErrorCode::InvalidFindingArn,
            "INVALID_IAM_ROLE_ARN" => InvalidInputErrorCode::InvalidIamRoleArn,
            "INVALID_LOCALE" => InvalidInputErrorCode::InvalidLocale,
            "INVALID_MAX_RESULTS" => InvalidInputErrorCode::InvalidMaxResults,
            "INVALID_NUMBER_OF_AGENT_IDS" => InvalidInputErrorCode::InvalidNumberOfAgentIds,
            "INVALID_NUMBER_OF_ASSESSMENT_RUN_ARNS" => {
                InvalidInputErrorCode::InvalidNumberOfAssessmentRunArns
            }
            "INVALID_NUMBER_OF_ASSESSMENT_RUN_STATES" => {
                InvalidInputErrorCode::InvalidNumberOfAssessmentRunStates
            }
            "INVALID_NUMBER_OF_ASSESSMENT_TARGET_ARNS" => {
                InvalidInputErrorCode::InvalidNumberOfAssessmentTargetArns
            }
            "INVALID_NUMBER_OF_ASSESSMENT_TEMPLATE_ARNS" => {
                InvalidInputErrorCode::InvalidNumberOfAssessmentTemplateArns
            }
            "INVALID_NUMBER_OF_ATTRIBUTES" => InvalidInputErrorCode::InvalidNumberOfAttributes,
            "INVALID_NUMBER_OF_AUTO_SCALING_GROUPS" => {
                InvalidInputErrorCode::InvalidNumberOfAutoScalingGroups
            }
            "INVALID_NUMBER_OF_FINDING_ARNS" => InvalidInputErrorCode::InvalidNumberOfFindingArns,
            "INVALID_NUMBER_OF_RESOURCE_GROUP_ARNS" => {
                InvalidInputErrorCode::InvalidNumberOfResourceGroupArns
            }
            "INVALID_NUMBER_OF_RESOURCE_GROUP_TAGS" => {
                InvalidInputErrorCode::InvalidNumberOfResourceGroupTags
            }
            "INVALID_NUMBER_OF_RULES_PACKAGE_ARNS" => {
                InvalidInputErrorCode::InvalidNumberOfRulesPackageArns
            }
            "INVALID_NUMBER_OF_RULE_NAMES" => InvalidInputErrorCode::InvalidNumberOfRuleNames,
            "INVALID_NUMBER_OF_SEVERITIES" => InvalidInputErrorCode::InvalidNumberOfSeverities,
            "INVALID_NUMBER_OF_TAGS" => InvalidInputErrorCode::InvalidNumberOfTags,
            "INVALID_NUMBER_OF_USER_ATTRIBUTES" => {
                InvalidInputErrorCode::InvalidNumberOfUserAttributes
            }
            "INVALID_PAGINATION_TOKEN" => InvalidInputErrorCode::InvalidPaginationToken,
            "INVALID_RESOURCE_ARN" => InvalidInputErrorCode::InvalidResourceArn,
            "INVALID_RESOURCE_GROUP_ARN" => InvalidInputErrorCode::InvalidResourceGroupArn,
            "INVALID_RESOURCE_GROUP_TAG_KEY" => InvalidInputErrorCode::InvalidResourceGroupTagKey,
            "INVALID_RESOURCE_GROUP_TAG_VALUE" => {
                InvalidInputErrorCode::InvalidResourceGroupTagValue
            }
            "INVALID_RULES_PACKAGE_ARN" => InvalidInputErrorCode::InvalidRulesPackageArn,
            "INVALID_RULE_NAME" => InvalidInputErrorCode::InvalidRuleName,
            "INVALID_SEVERITY" => InvalidInputErrorCode::InvalidSeverity,
            "INVALID_SNS_TOPIC_ARN" => InvalidInputErrorCode::InvalidSnsTopicArn,
            "INVALID_TAG" => InvalidInputErrorCode::InvalidTag,
            "INVALID_TAG_KEY" => InvalidInputErrorCode::InvalidTagKey,
            "INVALID_TAG_VALUE" => InvalidInputErrorCode::InvalidTagValue,
            "INVALID_USER_ATTRIBUTE" => InvalidInputErrorCode::InvalidUserAttribute,
            "INVALID_USER_ATTRIBUTE_KEY" => InvalidInputErrorCode::InvalidUserAttributeKey,
            "INVALID_USER_ATTRIBUTE_VALUE" => InvalidInputErrorCode::InvalidUserAttributeValue,
            other => InvalidInputErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InvalidInputErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InvalidInputErrorCode::from(s))
    }
}
impl InvalidInputErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InvalidInputErrorCode::AssessmentTargetNameAlreadyTaken => {
                "ASSESSMENT_TARGET_NAME_ALREADY_TAKEN"
            }
            InvalidInputErrorCode::AssessmentTemplateNameAlreadyTaken => {
                "ASSESSMENT_TEMPLATE_NAME_ALREADY_TAKEN"
            }
            InvalidInputErrorCode::InvalidAgentId => "INVALID_AGENT_ID",
            InvalidInputErrorCode::InvalidAssessmentRunArn => "INVALID_ASSESSMENT_RUN_ARN",
            InvalidInputErrorCode::InvalidAssessmentRunCompletionTimeRange => {
                "INVALID_ASSESSMENT_RUN_COMPLETION_TIME_RANGE"
            }
            InvalidInputErrorCode::InvalidAssessmentRunDurationRange => {
                "INVALID_ASSESSMENT_RUN_DURATION_RANGE"
            }
            InvalidInputErrorCode::InvalidAssessmentRunStartTimeRange => {
                "INVALID_ASSESSMENT_RUN_START_TIME_RANGE"
            }
            InvalidInputErrorCode::InvalidAssessmentRunState => "INVALID_ASSESSMENT_RUN_STATE",
            InvalidInputErrorCode::InvalidAssessmentRunStateChangeTimeRange => {
                "INVALID_ASSESSMENT_RUN_STATE_CHANGE_TIME_RANGE"
            }
            InvalidInputErrorCode::InvalidAssessmentTargetArn => "INVALID_ASSESSMENT_TARGET_ARN",
            InvalidInputErrorCode::InvalidAssessmentTargetName => "INVALID_ASSESSMENT_TARGET_NAME",
            InvalidInputErrorCode::InvalidAssessmentTargetNamePattern => {
                "INVALID_ASSESSMENT_TARGET_NAME_PATTERN"
            }
            InvalidInputErrorCode::InvalidAssessmentTemplateArn => {
                "INVALID_ASSESSMENT_TEMPLATE_ARN"
            }
            InvalidInputErrorCode::InvalidAssessmentTemplateDuration => {
                "INVALID_ASSESSMENT_TEMPLATE_DURATION"
            }
            InvalidInputErrorCode::InvalidAssessmentTemplateDurationRange => {
                "INVALID_ASSESSMENT_TEMPLATE_DURATION_RANGE"
            }
            InvalidInputErrorCode::InvalidAssessmentTemplateName => {
                "INVALID_ASSESSMENT_TEMPLATE_NAME"
            }
            InvalidInputErrorCode::InvalidAssessmentTemplateNamePattern => {
                "INVALID_ASSESSMENT_TEMPLATE_NAME_PATTERN"
            }
            InvalidInputErrorCode::InvalidAttribute => "INVALID_ATTRIBUTE",
            InvalidInputErrorCode::InvalidAutoScalingGroup => "INVALID_AUTO_SCALING_GROUP",
            InvalidInputErrorCode::InvalidEvent => "INVALID_EVENT",
            InvalidInputErrorCode::InvalidFindingArn => "INVALID_FINDING_ARN",
            InvalidInputErrorCode::InvalidIamRoleArn => "INVALID_IAM_ROLE_ARN",
            InvalidInputErrorCode::InvalidLocale => "INVALID_LOCALE",
            InvalidInputErrorCode::InvalidMaxResults => "INVALID_MAX_RESULTS",
            InvalidInputErrorCode::InvalidNumberOfAgentIds => "INVALID_NUMBER_OF_AGENT_IDS",
            InvalidInputErrorCode::InvalidNumberOfAssessmentRunArns => {
                "INVALID_NUMBER_OF_ASSESSMENT_RUN_ARNS"
            }
            InvalidInputErrorCode::InvalidNumberOfAssessmentRunStates => {
                "INVALID_NUMBER_OF_ASSESSMENT_RUN_STATES"
            }
            InvalidInputErrorCode::InvalidNumberOfAssessmentTargetArns => {
                "INVALID_NUMBER_OF_ASSESSMENT_TARGET_ARNS"
            }
            InvalidInputErrorCode::InvalidNumberOfAssessmentTemplateArns => {
                "INVALID_NUMBER_OF_ASSESSMENT_TEMPLATE_ARNS"
            }
            InvalidInputErrorCode::InvalidNumberOfAttributes => "INVALID_NUMBER_OF_ATTRIBUTES",
            InvalidInputErrorCode::InvalidNumberOfAutoScalingGroups => {
                "INVALID_NUMBER_OF_AUTO_SCALING_GROUPS"
            }
            InvalidInputErrorCode::InvalidNumberOfFindingArns => "INVALID_NUMBER_OF_FINDING_ARNS",
            InvalidInputErrorCode::InvalidNumberOfResourceGroupArns => {
                "INVALID_NUMBER_OF_RESOURCE_GROUP_ARNS"
            }
            InvalidInputErrorCode::InvalidNumberOfResourceGroupTags => {
                "INVALID_NUMBER_OF_RESOURCE_GROUP_TAGS"
            }
            InvalidInputErrorCode::InvalidNumberOfRulesPackageArns => {
                "INVALID_NUMBER_OF_RULES_PACKAGE_ARNS"
            }
            InvalidInputErrorCode::InvalidNumberOfRuleNames => "INVALID_NUMBER_OF_RULE_NAMES",
            InvalidInputErrorCode::InvalidNumberOfSeverities => "INVALID_NUMBER_OF_SEVERITIES",
            InvalidInputErrorCode::InvalidNumberOfTags => "INVALID_NUMBER_OF_TAGS",
            InvalidInputErrorCode::InvalidNumberOfUserAttributes => {
                "INVALID_NUMBER_OF_USER_ATTRIBUTES"
            }
            InvalidInputErrorCode::InvalidPaginationToken => "INVALID_PAGINATION_TOKEN",
            InvalidInputErrorCode::InvalidResourceArn => "INVALID_RESOURCE_ARN",
            InvalidInputErrorCode::InvalidResourceGroupArn => "INVALID_RESOURCE_GROUP_ARN",
            InvalidInputErrorCode::InvalidResourceGroupTagKey => "INVALID_RESOURCE_GROUP_TAG_KEY",
            InvalidInputErrorCode::InvalidResourceGroupTagValue => {
                "INVALID_RESOURCE_GROUP_TAG_VALUE"
            }
            InvalidInputErrorCode::InvalidRulesPackageArn => "INVALID_RULES_PACKAGE_ARN",
            InvalidInputErrorCode::InvalidRuleName => "INVALID_RULE_NAME",
            InvalidInputErrorCode::InvalidSeverity => "INVALID_SEVERITY",
            InvalidInputErrorCode::InvalidSnsTopicArn => "INVALID_SNS_TOPIC_ARN",
            InvalidInputErrorCode::InvalidTag => "INVALID_TAG",
            InvalidInputErrorCode::InvalidTagKey => "INVALID_TAG_KEY",
            InvalidInputErrorCode::InvalidTagValue => "INVALID_TAG_VALUE",
            InvalidInputErrorCode::InvalidUserAttribute => "INVALID_USER_ATTRIBUTE",
            InvalidInputErrorCode::InvalidUserAttributeKey => "INVALID_USER_ATTRIBUTE_KEY",
            InvalidInputErrorCode::InvalidUserAttributeValue => "INVALID_USER_ATTRIBUTE_VALUE",
            InvalidInputErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSESSMENT_TARGET_NAME_ALREADY_TAKEN",
            "ASSESSMENT_TEMPLATE_NAME_ALREADY_TAKEN",
            "INVALID_AGENT_ID",
            "INVALID_ASSESSMENT_RUN_ARN",
            "INVALID_ASSESSMENT_RUN_COMPLETION_TIME_RANGE",
            "INVALID_ASSESSMENT_RUN_DURATION_RANGE",
            "INVALID_ASSESSMENT_RUN_START_TIME_RANGE",
            "INVALID_ASSESSMENT_RUN_STATE",
            "INVALID_ASSESSMENT_RUN_STATE_CHANGE_TIME_RANGE",
            "INVALID_ASSESSMENT_TARGET_ARN",
            "INVALID_ASSESSMENT_TARGET_NAME",
            "INVALID_ASSESSMENT_TARGET_NAME_PATTERN",
            "INVALID_ASSESSMENT_TEMPLATE_ARN",
            "INVALID_ASSESSMENT_TEMPLATE_DURATION",
            "INVALID_ASSESSMENT_TEMPLATE_DURATION_RANGE",
            "INVALID_ASSESSMENT_TEMPLATE_NAME",
            "INVALID_ASSESSMENT_TEMPLATE_NAME_PATTERN",
            "INVALID_ATTRIBUTE",
            "INVALID_AUTO_SCALING_GROUP",
            "INVALID_EVENT",
            "INVALID_FINDING_ARN",
            "INVALID_IAM_ROLE_ARN",
            "INVALID_LOCALE",
            "INVALID_MAX_RESULTS",
            "INVALID_NUMBER_OF_AGENT_IDS",
            "INVALID_NUMBER_OF_ASSESSMENT_RUN_ARNS",
            "INVALID_NUMBER_OF_ASSESSMENT_RUN_STATES",
            "INVALID_NUMBER_OF_ASSESSMENT_TARGET_ARNS",
            "INVALID_NUMBER_OF_ASSESSMENT_TEMPLATE_ARNS",
            "INVALID_NUMBER_OF_ATTRIBUTES",
            "INVALID_NUMBER_OF_AUTO_SCALING_GROUPS",
            "INVALID_NUMBER_OF_FINDING_ARNS",
            "INVALID_NUMBER_OF_RESOURCE_GROUP_ARNS",
            "INVALID_NUMBER_OF_RESOURCE_GROUP_TAGS",
            "INVALID_NUMBER_OF_RULES_PACKAGE_ARNS",
            "INVALID_NUMBER_OF_RULE_NAMES",
            "INVALID_NUMBER_OF_SEVERITIES",
            "INVALID_NUMBER_OF_TAGS",
            "INVALID_NUMBER_OF_USER_ATTRIBUTES",
            "INVALID_PAGINATION_TOKEN",
            "INVALID_RESOURCE_ARN",
            "INVALID_RESOURCE_GROUP_ARN",
            "INVALID_RESOURCE_GROUP_TAG_KEY",
            "INVALID_RESOURCE_GROUP_TAG_VALUE",
            "INVALID_RULES_PACKAGE_ARN",
            "INVALID_RULE_NAME",
            "INVALID_SEVERITY",
            "INVALID_SNS_TOPIC_ARN",
            "INVALID_TAG",
            "INVALID_TAG_KEY",
            "INVALID_TAG_VALUE",
            "INVALID_USER_ATTRIBUTE",
            "INVALID_USER_ATTRIBUTE_KEY",
            "INVALID_USER_ATTRIBUTE_VALUE",
        ]
    }
}
impl AsRef<str> for InvalidInputErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessDeniedErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToAssessmentRun,
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToAssessmentTarget,
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToAssessmentTemplate,
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToFinding,
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToIamRole,
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToResourceGroup,
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToRulesPackage,
    #[allow(missing_docs)] // documentation missing in model
    AccessDeniedToSnsTopic,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessDeniedErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED_TO_ASSESSMENT_RUN" => AccessDeniedErrorCode::AccessDeniedToAssessmentRun,
            "ACCESS_DENIED_TO_ASSESSMENT_TARGET" => {
                AccessDeniedErrorCode::AccessDeniedToAssessmentTarget
            }
            "ACCESS_DENIED_TO_ASSESSMENT_TEMPLATE" => {
                AccessDeniedErrorCode::AccessDeniedToAssessmentTemplate
            }
            "ACCESS_DENIED_TO_FINDING" => AccessDeniedErrorCode::AccessDeniedToFinding,
            "ACCESS_DENIED_TO_IAM_ROLE" => AccessDeniedErrorCode::AccessDeniedToIamRole,
            "ACCESS_DENIED_TO_RESOURCE_GROUP" => AccessDeniedErrorCode::AccessDeniedToResourceGroup,
            "ACCESS_DENIED_TO_RULES_PACKAGE" => AccessDeniedErrorCode::AccessDeniedToRulesPackage,
            "ACCESS_DENIED_TO_SNS_TOPIC" => AccessDeniedErrorCode::AccessDeniedToSnsTopic,
            other => AccessDeniedErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessDeniedErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessDeniedErrorCode::from(s))
    }
}
impl AccessDeniedErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessDeniedErrorCode::AccessDeniedToAssessmentRun => "ACCESS_DENIED_TO_ASSESSMENT_RUN",
            AccessDeniedErrorCode::AccessDeniedToAssessmentTarget => {
                "ACCESS_DENIED_TO_ASSESSMENT_TARGET"
            }
            AccessDeniedErrorCode::AccessDeniedToAssessmentTemplate => {
                "ACCESS_DENIED_TO_ASSESSMENT_TEMPLATE"
            }
            AccessDeniedErrorCode::AccessDeniedToFinding => "ACCESS_DENIED_TO_FINDING",
            AccessDeniedErrorCode::AccessDeniedToIamRole => "ACCESS_DENIED_TO_IAM_ROLE",
            AccessDeniedErrorCode::AccessDeniedToResourceGroup => "ACCESS_DENIED_TO_RESOURCE_GROUP",
            AccessDeniedErrorCode::AccessDeniedToRulesPackage => "ACCESS_DENIED_TO_RULES_PACKAGE",
            AccessDeniedErrorCode::AccessDeniedToSnsTopic => "ACCESS_DENIED_TO_SNS_TOPIC",
            AccessDeniedErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED_TO_ASSESSMENT_RUN",
            "ACCESS_DENIED_TO_ASSESSMENT_TARGET",
            "ACCESS_DENIED_TO_ASSESSMENT_TEMPLATE",
            "ACCESS_DENIED_TO_FINDING",
            "ACCESS_DENIED_TO_IAM_ROLE",
            "ACCESS_DENIED_TO_RESOURCE_GROUP",
            "ACCESS_DENIED_TO_RULES_PACKAGE",
            "ACCESS_DENIED_TO_SNS_TOPIC",
        ]
    }
}
impl AsRef<str> for AccessDeniedErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InspectorEvent {
    #[allow(missing_docs)] // documentation missing in model
    AssessmentRunCompleted,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentRunStarted,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentRunStateChanged,
    #[allow(missing_docs)] // documentation missing in model
    FindingReported,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InspectorEvent {
    fn from(s: &str) -> Self {
        match s {
            "ASSESSMENT_RUN_COMPLETED" => InspectorEvent::AssessmentRunCompleted,
            "ASSESSMENT_RUN_STARTED" => InspectorEvent::AssessmentRunStarted,
            "ASSESSMENT_RUN_STATE_CHANGED" => InspectorEvent::AssessmentRunStateChanged,
            "FINDING_REPORTED" => InspectorEvent::FindingReported,
            "OTHER" => InspectorEvent::Other,
            other => InspectorEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InspectorEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InspectorEvent::from(s))
    }
}
impl InspectorEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InspectorEvent::AssessmentRunCompleted => "ASSESSMENT_RUN_COMPLETED",
            InspectorEvent::AssessmentRunStarted => "ASSESSMENT_RUN_STARTED",
            InspectorEvent::AssessmentRunStateChanged => "ASSESSMENT_RUN_STATE_CHANGED",
            InspectorEvent::FindingReported => "FINDING_REPORTED",
            InspectorEvent::Other => "OTHER",
            InspectorEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSESSMENT_RUN_COMPLETED",
            "ASSESSMENT_RUN_STARTED",
            "ASSESSMENT_RUN_STATE_CHANGED",
            "FINDING_REPORTED",
            "OTHER",
        ]
    }
}
impl AsRef<str> for InspectorEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LimitExceededErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AssessmentRunLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentTargetLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentTemplateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    EventSubscriptionLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ResourceGroupLimitExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LimitExceededErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ASSESSMENT_RUN_LIMIT_EXCEEDED" => LimitExceededErrorCode::AssessmentRunLimitExceeded,
            "ASSESSMENT_TARGET_LIMIT_EXCEEDED" => {
                LimitExceededErrorCode::AssessmentTargetLimitExceeded
            }
            "ASSESSMENT_TEMPLATE_LIMIT_EXCEEDED" => {
                LimitExceededErrorCode::AssessmentTemplateLimitExceeded
            }
            "EVENT_SUBSCRIPTION_LIMIT_EXCEEDED" => {
                LimitExceededErrorCode::EventSubscriptionLimitExceeded
            }
            "RESOURCE_GROUP_LIMIT_EXCEEDED" => LimitExceededErrorCode::ResourceGroupLimitExceeded,
            other => LimitExceededErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LimitExceededErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LimitExceededErrorCode::from(s))
    }
}
impl LimitExceededErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LimitExceededErrorCode::AssessmentRunLimitExceeded => "ASSESSMENT_RUN_LIMIT_EXCEEDED",
            LimitExceededErrorCode::AssessmentTargetLimitExceeded => {
                "ASSESSMENT_TARGET_LIMIT_EXCEEDED"
            }
            LimitExceededErrorCode::AssessmentTemplateLimitExceeded => {
                "ASSESSMENT_TEMPLATE_LIMIT_EXCEEDED"
            }
            LimitExceededErrorCode::EventSubscriptionLimitExceeded => {
                "EVENT_SUBSCRIPTION_LIMIT_EXCEEDED"
            }
            LimitExceededErrorCode::ResourceGroupLimitExceeded => "RESOURCE_GROUP_LIMIT_EXCEEDED",
            LimitExceededErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSESSMENT_RUN_LIMIT_EXCEEDED",
            "ASSESSMENT_TARGET_LIMIT_EXCEEDED",
            "ASSESSMENT_TEMPLATE_LIMIT_EXCEEDED",
            "EVENT_SUBSCRIPTION_LIMIT_EXCEEDED",
            "RESOURCE_GROUP_LIMIT_EXCEEDED",
        ]
    }
}
impl AsRef<str> for LimitExceededErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StopAction {
    #[allow(missing_docs)] // documentation missing in model
    SkipEvaluation,
    #[allow(missing_docs)] // documentation missing in model
    StartEvaluation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StopAction {
    fn from(s: &str) -> Self {
        match s {
            "SKIP_EVALUATION" => StopAction::SkipEvaluation,
            "START_EVALUATION" => StopAction::StartEvaluation,
            other => StopAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StopAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StopAction::from(s))
    }
}
impl StopAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StopAction::SkipEvaluation => "SKIP_EVALUATION",
            StopAction::StartEvaluation => "START_EVALUATION",
            StopAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SKIP_EVALUATION", "START_EVALUATION"]
    }
}
impl AsRef<str> for StopAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InvalidCrossAccountRoleErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    RoleDoesNotExistOrInvalidTrustRelationship,
    #[allow(missing_docs)] // documentation missing in model
    RoleDoesNotHaveCorrectPolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InvalidCrossAccountRoleErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ROLE_DOES_NOT_EXIST_OR_INVALID_TRUST_RELATIONSHIP" => {
                InvalidCrossAccountRoleErrorCode::RoleDoesNotExistOrInvalidTrustRelationship
            }
            "ROLE_DOES_NOT_HAVE_CORRECT_POLICY" => {
                InvalidCrossAccountRoleErrorCode::RoleDoesNotHaveCorrectPolicy
            }
            other => InvalidCrossAccountRoleErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InvalidCrossAccountRoleErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InvalidCrossAccountRoleErrorCode::from(s))
    }
}
impl InvalidCrossAccountRoleErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InvalidCrossAccountRoleErrorCode::RoleDoesNotExistOrInvalidTrustRelationship => {
                "ROLE_DOES_NOT_EXIST_OR_INVALID_TRUST_RELATIONSHIP"
            }
            InvalidCrossAccountRoleErrorCode::RoleDoesNotHaveCorrectPolicy => {
                "ROLE_DOES_NOT_HAVE_CORRECT_POLICY"
            }
            InvalidCrossAccountRoleErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ROLE_DOES_NOT_EXIST_OR_INVALID_TRUST_RELATIONSHIP",
            "ROLE_DOES_NOT_HAVE_CORRECT_POLICY",
        ]
    }
}
impl AsRef<str> for InvalidCrossAccountRoleErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Used in the exception error that is thrown if you start an assessment run for an
/// assessment target that includes an EC2 instance that is already participating in another
/// started assessment run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentAlreadyRunningAssessment {
    /// <p>ID of the agent that is running on an EC2 instance that is already participating in
    /// another started assessment run.</p>
    pub agent_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the assessment run that has already been started.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
}
impl AgentAlreadyRunningAssessment {
    /// <p>ID of the agent that is running on an EC2 instance that is already participating in
    /// another started assessment run.</p>
    pub fn agent_id(&self) -> std::option::Option<&str> {
        self.agent_id.as_deref()
    }
    /// <p>The ARN of the assessment run that has already been started.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
}
impl std::fmt::Debug for AgentAlreadyRunningAssessment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentAlreadyRunningAssessment");
        formatter.field("agent_id", &self.agent_id);
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.finish()
    }
}
/// See [`AgentAlreadyRunningAssessment`](crate::model::AgentAlreadyRunningAssessment)
pub mod agent_already_running_assessment {
    /// A builder for [`AgentAlreadyRunningAssessment`](crate::model::AgentAlreadyRunningAssessment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_id: std::option::Option<std::string::String>,
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the agent that is running on an EC2 instance that is already participating in
        /// another started assessment run.</p>
        pub fn agent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_id = Some(input.into());
            self
        }
        /// <p>ID of the agent that is running on an EC2 instance that is already participating in
        /// another started assessment run.</p>
        pub fn set_agent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_id = input;
            self
        }
        /// <p>The ARN of the assessment run that has already been started.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment run that has already been started.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentAlreadyRunningAssessment`](crate::model::AgentAlreadyRunningAssessment)
        pub fn build(self) -> crate::model::AgentAlreadyRunningAssessment {
            crate::model::AgentAlreadyRunningAssessment {
                agent_id: self.agent_id,
                assessment_run_arn: self.assessment_run_arn,
            }
        }
    }
}
impl AgentAlreadyRunningAssessment {
    /// Creates a new builder-style object to manufacture [`AgentAlreadyRunningAssessment`](crate::model::AgentAlreadyRunningAssessment)
    pub fn builder() -> crate::model::agent_already_running_assessment::Builder {
        crate::model::agent_already_running_assessment::Builder::default()
    }
}

/// <p>A key and value pair. This data type is used as a request parameter in the <a>SetTagsForResource</a> action and a response element in the <a>ListTagsForResource</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value assigned to a tag key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A value assigned to a tag key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value assigned to a tag key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value assigned to a tag key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Includes details about the failed items.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedItemDetails {
    /// <p>The status code of a failed item.</p>
    pub failure_code: std::option::Option<crate::model::FailedItemErrorCode>,
    /// <p>Indicates whether you can immediately retry a request for this item for a specified
    /// resource.</p>
    pub retryable: std::option::Option<bool>,
}
impl FailedItemDetails {
    /// <p>The status code of a failed item.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::FailedItemErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>Indicates whether you can immediately retry a request for this item for a specified
    /// resource.</p>
    pub fn retryable(&self) -> std::option::Option<bool> {
        self.retryable
    }
}
impl std::fmt::Debug for FailedItemDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedItemDetails");
        formatter.field("failure_code", &self.failure_code);
        formatter.field("retryable", &self.retryable);
        formatter.finish()
    }
}
/// See [`FailedItemDetails`](crate::model::FailedItemDetails)
pub mod failed_item_details {
    /// A builder for [`FailedItemDetails`](crate::model::FailedItemDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_code: std::option::Option<crate::model::FailedItemErrorCode>,
        pub(crate) retryable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The status code of a failed item.</p>
        pub fn failure_code(mut self, input: crate::model::FailedItemErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The status code of a failed item.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::FailedItemErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>Indicates whether you can immediately retry a request for this item for a specified
        /// resource.</p>
        pub fn retryable(mut self, input: bool) -> Self {
            self.retryable = Some(input);
            self
        }
        /// <p>Indicates whether you can immediately retry a request for this item for a specified
        /// resource.</p>
        pub fn set_retryable(mut self, input: std::option::Option<bool>) -> Self {
            self.retryable = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedItemDetails`](crate::model::FailedItemDetails)
        pub fn build(self) -> crate::model::FailedItemDetails {
            crate::model::FailedItemDetails {
                failure_code: self.failure_code,
                retryable: self.retryable,
            }
        }
    }
}
impl FailedItemDetails {
    /// Creates a new builder-style object to manufacture [`FailedItemDetails`](crate::model::FailedItemDetails)
    pub fn builder() -> crate::model::failed_item_details::Builder {
        crate::model::failed_item_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailedItemErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    DuplicateArn,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidArn,
    #[allow(missing_docs)] // documentation missing in model
    ItemDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailedItemErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => FailedItemErrorCode::AccessDenied,
            "DUPLICATE_ARN" => FailedItemErrorCode::DuplicateArn,
            "INTERNAL_ERROR" => FailedItemErrorCode::InternalError,
            "INVALID_ARN" => FailedItemErrorCode::InvalidArn,
            "ITEM_DOES_NOT_EXIST" => FailedItemErrorCode::ItemDoesNotExist,
            "LIMIT_EXCEEDED" => FailedItemErrorCode::LimitExceeded,
            other => FailedItemErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailedItemErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailedItemErrorCode::from(s))
    }
}
impl FailedItemErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailedItemErrorCode::AccessDenied => "ACCESS_DENIED",
            FailedItemErrorCode::DuplicateArn => "DUPLICATE_ARN",
            FailedItemErrorCode::InternalError => "INTERNAL_ERROR",
            FailedItemErrorCode::InvalidArn => "INVALID_ARN",
            FailedItemErrorCode::ItemDoesNotExist => "ITEM_DOES_NOT_EXIST",
            FailedItemErrorCode::LimitExceeded => "LIMIT_EXCEEDED",
            FailedItemErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "DUPLICATE_ARN",
            "INTERNAL_ERROR",
            "INVALID_ARN",
            "ITEM_DOES_NOT_EXIST",
            "LIMIT_EXCEEDED",
        ]
    }
}
impl AsRef<str> for FailedItemErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Used as a response element in the <a>PreviewAgents</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentPreview {
    /// <p>The hostname of the EC2 instance on which the Amazon Inspector Agent is
    /// installed.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The ID of the EC2 instance where the agent is installed.</p>
    pub agent_id: std::option::Option<std::string::String>,
    /// <p>The Auto Scaling group for the EC2 instance where the agent is installed.</p>
    pub auto_scaling_group: std::option::Option<std::string::String>,
    /// <p>The health status of the Amazon Inspector Agent.</p>
    pub agent_health: std::option::Option<crate::model::AgentHealth>,
    /// <p>The version of the Amazon Inspector Agent.</p>
    pub agent_version: std::option::Option<std::string::String>,
    /// <p>The operating system running on the EC2 instance on which the Amazon Inspector Agent
    /// is installed.</p>
    pub operating_system: std::option::Option<std::string::String>,
    /// <p>The kernel version of the operating system running on the EC2 instance on which the
    /// Amazon Inspector Agent is installed.</p>
    pub kernel_version: std::option::Option<std::string::String>,
    /// <p>The IP address of the EC2 instance on which the Amazon Inspector Agent is
    /// installed.</p>
    pub ipv4_address: std::option::Option<std::string::String>,
}
impl AgentPreview {
    /// <p>The hostname of the EC2 instance on which the Amazon Inspector Agent is
    /// installed.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>The ID of the EC2 instance where the agent is installed.</p>
    pub fn agent_id(&self) -> std::option::Option<&str> {
        self.agent_id.as_deref()
    }
    /// <p>The Auto Scaling group for the EC2 instance where the agent is installed.</p>
    pub fn auto_scaling_group(&self) -> std::option::Option<&str> {
        self.auto_scaling_group.as_deref()
    }
    /// <p>The health status of the Amazon Inspector Agent.</p>
    pub fn agent_health(&self) -> std::option::Option<&crate::model::AgentHealth> {
        self.agent_health.as_ref()
    }
    /// <p>The version of the Amazon Inspector Agent.</p>
    pub fn agent_version(&self) -> std::option::Option<&str> {
        self.agent_version.as_deref()
    }
    /// <p>The operating system running on the EC2 instance on which the Amazon Inspector Agent
    /// is installed.</p>
    pub fn operating_system(&self) -> std::option::Option<&str> {
        self.operating_system.as_deref()
    }
    /// <p>The kernel version of the operating system running on the EC2 instance on which the
    /// Amazon Inspector Agent is installed.</p>
    pub fn kernel_version(&self) -> std::option::Option<&str> {
        self.kernel_version.as_deref()
    }
    /// <p>The IP address of the EC2 instance on which the Amazon Inspector Agent is
    /// installed.</p>
    pub fn ipv4_address(&self) -> std::option::Option<&str> {
        self.ipv4_address.as_deref()
    }
}
impl std::fmt::Debug for AgentPreview {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentPreview");
        formatter.field("hostname", &self.hostname);
        formatter.field("agent_id", &self.agent_id);
        formatter.field("auto_scaling_group", &self.auto_scaling_group);
        formatter.field("agent_health", &self.agent_health);
        formatter.field("agent_version", &self.agent_version);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("kernel_version", &self.kernel_version);
        formatter.field("ipv4_address", &self.ipv4_address);
        formatter.finish()
    }
}
/// See [`AgentPreview`](crate::model::AgentPreview)
pub mod agent_preview {
    /// A builder for [`AgentPreview`](crate::model::AgentPreview)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) agent_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group: std::option::Option<std::string::String>,
        pub(crate) agent_health: std::option::Option<crate::model::AgentHealth>,
        pub(crate) agent_version: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<std::string::String>,
        pub(crate) kernel_version: std::option::Option<std::string::String>,
        pub(crate) ipv4_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The hostname of the EC2 instance on which the Amazon Inspector Agent is
        /// installed.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The hostname of the EC2 instance on which the Amazon Inspector Agent is
        /// installed.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The ID of the EC2 instance where the agent is installed.</p>
        pub fn agent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_id = Some(input.into());
            self
        }
        /// <p>The ID of the EC2 instance where the agent is installed.</p>
        pub fn set_agent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_id = input;
            self
        }
        /// <p>The Auto Scaling group for the EC2 instance where the agent is installed.</p>
        pub fn auto_scaling_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group = Some(input.into());
            self
        }
        /// <p>The Auto Scaling group for the EC2 instance where the agent is installed.</p>
        pub fn set_auto_scaling_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group = input;
            self
        }
        /// <p>The health status of the Amazon Inspector Agent.</p>
        pub fn agent_health(mut self, input: crate::model::AgentHealth) -> Self {
            self.agent_health = Some(input);
            self
        }
        /// <p>The health status of the Amazon Inspector Agent.</p>
        pub fn set_agent_health(
            mut self,
            input: std::option::Option<crate::model::AgentHealth>,
        ) -> Self {
            self.agent_health = input;
            self
        }
        /// <p>The version of the Amazon Inspector Agent.</p>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The version of the Amazon Inspector Agent.</p>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// <p>The operating system running on the EC2 instance on which the Amazon Inspector Agent
        /// is installed.</p>
        pub fn operating_system(mut self, input: impl Into<std::string::String>) -> Self {
            self.operating_system = Some(input.into());
            self
        }
        /// <p>The operating system running on the EC2 instance on which the Amazon Inspector Agent
        /// is installed.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>The kernel version of the operating system running on the EC2 instance on which the
        /// Amazon Inspector Agent is installed.</p>
        pub fn kernel_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.kernel_version = Some(input.into());
            self
        }
        /// <p>The kernel version of the operating system running on the EC2 instance on which the
        /// Amazon Inspector Agent is installed.</p>
        pub fn set_kernel_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kernel_version = input;
            self
        }
        /// <p>The IP address of the EC2 instance on which the Amazon Inspector Agent is
        /// installed.</p>
        pub fn ipv4_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv4_address = Some(input.into());
            self
        }
        /// <p>The IP address of the EC2 instance on which the Amazon Inspector Agent is
        /// installed.</p>
        pub fn set_ipv4_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv4_address = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentPreview`](crate::model::AgentPreview)
        pub fn build(self) -> crate::model::AgentPreview {
            crate::model::AgentPreview {
                hostname: self.hostname,
                agent_id: self.agent_id,
                auto_scaling_group: self.auto_scaling_group,
                agent_health: self.agent_health,
                agent_version: self.agent_version,
                operating_system: self.operating_system,
                kernel_version: self.kernel_version,
                ipv4_address: self.ipv4_address,
            }
        }
    }
}
impl AgentPreview {
    /// Creates a new builder-style object to manufacture [`AgentPreview`](crate::model::AgentPreview)
    pub fn builder() -> crate::model::agent_preview::Builder {
        crate::model::agent_preview::Builder::default()
    }
}

/// _Note: `AgentHealth::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentHealth {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentHealth {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => AgentHealth::Healthy,
            "UNHEALTHY" => AgentHealth::Unhealthy,
            "UNKNOWN" => AgentHealth::UnknownValue,
            other => AgentHealth::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentHealth {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentHealth::from(s))
    }
}
impl AgentHealth {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentHealth::Healthy => "HEALTHY",
            AgentHealth::Unhealthy => "UNHEALTHY",
            AgentHealth::UnknownValue => "UNKNOWN",
            AgentHealth::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "UNHEALTHY", "UNKNOWN"]
    }
}
impl AsRef<str> for AgentHealth {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This data type is used as a request parameter in the <a>ListFindings</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingFilter {
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.</p>
    pub agent_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data
    /// type.</p>
    pub auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.</p>
    pub rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.</p>
    pub severities: std::option::Option<std::vec::Vec<crate::model::Severity>>,
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data
    /// type.</p>
    pub rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For a record to match a filter, the list of values that are specified for this data
    /// type property must be contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must be contained in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data
    /// type.</p>
    pub user_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The time range during which the finding is generated.</p>
    pub creation_time_range: std::option::Option<crate::model::TimestampRange>,
}
impl FindingFilter {
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.</p>
    pub fn agent_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.agent_ids.as_deref()
    }
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data
    /// type.</p>
    pub fn auto_scaling_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_scaling_groups.as_deref()
    }
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.</p>
    pub fn rule_names(&self) -> std::option::Option<&[std::string::String]> {
        self.rule_names.as_deref()
    }
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.</p>
    pub fn severities(&self) -> std::option::Option<&[crate::model::Severity]> {
        self.severities.as_deref()
    }
    /// <p>For a record to match a filter, one of the values that is specified for this data
    /// type property must be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data
    /// type.</p>
    pub fn rules_package_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rules_package_arns.as_deref()
    }
    /// <p>For a record to match a filter, the list of values that are specified for this data
    /// type property must be contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must be contained in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data
    /// type.</p>
    pub fn user_attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.user_attributes.as_deref()
    }
    /// <p>The time range during which the finding is generated.</p>
    pub fn creation_time_range(&self) -> std::option::Option<&crate::model::TimestampRange> {
        self.creation_time_range.as_ref()
    }
}
impl std::fmt::Debug for FindingFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingFilter");
        formatter.field("agent_ids", &self.agent_ids);
        formatter.field("auto_scaling_groups", &self.auto_scaling_groups);
        formatter.field("rule_names", &self.rule_names);
        formatter.field("severities", &self.severities);
        formatter.field("rules_package_arns", &self.rules_package_arns);
        formatter.field("attributes", &self.attributes);
        formatter.field("user_attributes", &self.user_attributes);
        formatter.field("creation_time_range", &self.creation_time_range);
        formatter.finish()
    }
}
/// See [`FindingFilter`](crate::model::FindingFilter)
pub mod finding_filter {
    /// A builder for [`FindingFilter`](crate::model::FindingFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rule_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) severities: std::option::Option<std::vec::Vec<crate::model::Severity>>,
        pub(crate) rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) creation_time_range: std::option::Option<crate::model::TimestampRange>,
    }
    impl Builder {
        /// Appends an item to `agent_ids`.
        ///
        /// To override the contents of this collection use [`set_agent_ids`](Self::set_agent_ids).
        ///
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.</p>
        pub fn agent_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.agent_ids.unwrap_or_default();
            v.push(input.into());
            self.agent_ids = Some(v);
            self
        }
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>agentId</b> property of the <a>Finding</a> data type.</p>
        pub fn set_agent_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.agent_ids = input;
            self
        }
        /// Appends an item to `auto_scaling_groups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data
        /// type.</p>
        pub fn auto_scaling_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_scaling_groups.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_groups = Some(v);
            self
        }
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>autoScalingGroup</b> property of the <a>Finding</a> data
        /// type.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_scaling_groups = input;
            self
        }
        /// Appends an item to `rule_names`.
        ///
        /// To override the contents of this collection use [`set_rule_names`](Self::set_rule_names).
        ///
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.</p>
        pub fn rule_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rule_names.unwrap_or_default();
            v.push(input.into());
            self.rule_names = Some(v);
            self
        }
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.</p>
        pub fn set_rule_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rule_names = input;
            self
        }
        /// Appends an item to `severities`.
        ///
        /// To override the contents of this collection use [`set_severities`](Self::set_severities).
        ///
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.</p>
        pub fn severities(mut self, input: impl Into<crate::model::Severity>) -> Self {
            let mut v = self.severities.unwrap_or_default();
            v.push(input.into());
            self.severities = Some(v);
            self
        }
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.</p>
        pub fn set_severities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Severity>>,
        ) -> Self {
            self.severities = input;
            self
        }
        /// Appends an item to `rules_package_arns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data
        /// type.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rules_package_arns.unwrap_or_default();
            v.push(input.into());
            self.rules_package_arns = Some(v);
            self
        }
        /// <p>For a record to match a filter, one of the values that is specified for this data
        /// type property must be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data
        /// type.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rules_package_arns = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>For a record to match a filter, the list of values that are specified for this data
        /// type property must be contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>For a record to match a filter, the list of values that are specified for this data
        /// type property must be contained in the list of values of the <b>attributes</b> property of the <a>Finding</a> data type.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must be contained in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data
        /// type.</p>
        pub fn user_attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input.into());
            self.user_attributes = Some(v);
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must be contained in the list of values of the <b>userAttributes</b> property of the <a>Finding</a> data
        /// type.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// <p>The time range during which the finding is generated.</p>
        pub fn creation_time_range(mut self, input: crate::model::TimestampRange) -> Self {
            self.creation_time_range = Some(input);
            self
        }
        /// <p>The time range during which the finding is generated.</p>
        pub fn set_creation_time_range(
            mut self,
            input: std::option::Option<crate::model::TimestampRange>,
        ) -> Self {
            self.creation_time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingFilter`](crate::model::FindingFilter)
        pub fn build(self) -> crate::model::FindingFilter {
            crate::model::FindingFilter {
                agent_ids: self.agent_ids,
                auto_scaling_groups: self.auto_scaling_groups,
                rule_names: self.rule_names,
                severities: self.severities,
                rules_package_arns: self.rules_package_arns,
                attributes: self.attributes,
                user_attributes: self.user_attributes,
                creation_time_range: self.creation_time_range,
            }
        }
    }
}
impl FindingFilter {
    /// Creates a new builder-style object to manufacture [`FindingFilter`](crate::model::FindingFilter)
    pub fn builder() -> crate::model::finding_filter::Builder {
        crate::model::finding_filter::Builder::default()
    }
}

/// <p>This data type is used in the <a>AssessmentRunFilter</a> data
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestampRange {
    /// <p>The minimum value of the timestamp range.</p>
    pub begin_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The maximum value of the timestamp range.</p>
    pub end_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimestampRange {
    /// <p>The minimum value of the timestamp range.</p>
    pub fn begin_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.begin_date.as_ref()
    }
    /// <p>The maximum value of the timestamp range.</p>
    pub fn end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date.as_ref()
    }
}
impl std::fmt::Debug for TimestampRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestampRange");
        formatter.field("begin_date", &self.begin_date);
        formatter.field("end_date", &self.end_date);
        formatter.finish()
    }
}
/// See [`TimestampRange`](crate::model::TimestampRange)
pub mod timestamp_range {
    /// A builder for [`TimestampRange`](crate::model::TimestampRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The minimum value of the timestamp range.</p>
        pub fn begin_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.begin_date = Some(input);
            self
        }
        /// <p>The minimum value of the timestamp range.</p>
        pub fn set_begin_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.begin_date = input;
            self
        }
        /// <p>The maximum value of the timestamp range.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The maximum value of the timestamp range.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestampRange`](crate::model::TimestampRange)
        pub fn build(self) -> crate::model::TimestampRange {
            crate::model::TimestampRange {
                begin_date: self.begin_date,
                end_date: self.end_date,
            }
        }
    }
}
impl TimestampRange {
    /// Creates a new builder-style object to manufacture [`TimestampRange`](crate::model::TimestampRange)
    pub fn builder() -> crate::model::timestamp_range::Builder {
        crate::model::timestamp_range::Builder::default()
    }
}

/// <p>This data type is used as a request parameter in the <a>AddAttributesToFindings</a> and <a>CreateAssessmentTemplate</a>
/// actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attribute {
    /// <p>The attribute key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value assigned to the attribute key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Attribute {
    /// <p>The attribute key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value assigned to the attribute key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Attribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attribute");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Attribute`](crate::model::Attribute)
pub mod attribute {
    /// A builder for [`Attribute`](crate::model::Attribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attribute key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The attribute key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value assigned to the attribute key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value assigned to the attribute key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Attribute`](crate::model::Attribute)
        pub fn build(self) -> crate::model::Attribute {
            crate::model::Attribute {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Attribute {
    /// Creates a new builder-style object to manufacture [`Attribute`](crate::model::Attribute)
    pub fn builder() -> crate::model::attribute::Builder {
        crate::model::attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Severity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Informational,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Undefined,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Severity {
    fn from(s: &str) -> Self {
        match s {
            "High" => Severity::High,
            "Informational" => Severity::Informational,
            "Low" => Severity::Low,
            "Medium" => Severity::Medium,
            "Undefined" => Severity::Undefined,
            other => Severity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Severity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Severity::from(s))
    }
}
impl Severity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Severity::High => "High",
            Severity::Informational => "Informational",
            Severity::Low => "Low",
            Severity::Medium => "Medium",
            Severity::Undefined => "Undefined",
            Severity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["High", "Informational", "Low", "Medium", "Undefined"]
    }
}
impl AsRef<str> for Severity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This data type is used as a response element in the <a>ListEventSubscriptions</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subscription {
    /// <p>The ARN of the assessment template that is used during the event for which the SNS
    /// notification is sent.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS
    /// notifications are sent.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The list of existing event subscriptions.</p>
    pub event_subscriptions: std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
}
impl Subscription {
    /// <p>The ARN of the assessment template that is used during the event for which the SNS
    /// notification is sent.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS
    /// notifications are sent.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The list of existing event subscriptions.</p>
    pub fn event_subscriptions(&self) -> std::option::Option<&[crate::model::EventSubscription]> {
        self.event_subscriptions.as_deref()
    }
}
impl std::fmt::Debug for Subscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subscription");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("event_subscriptions", &self.event_subscriptions);
        formatter.finish()
    }
}
/// See [`Subscription`](crate::model::Subscription)
pub mod subscription {
    /// A builder for [`Subscription`](crate::model::Subscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) event_subscriptions:
            std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
    }
    impl Builder {
        /// <p>The ARN of the assessment template that is used during the event for which the SNS
        /// notification is sent.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template that is used during the event for which the SNS
        /// notification is sent.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS
        /// notifications are sent.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS
        /// notifications are sent.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Appends an item to `event_subscriptions`.
        ///
        /// To override the contents of this collection use [`set_event_subscriptions`](Self::set_event_subscriptions).
        ///
        /// <p>The list of existing event subscriptions.</p>
        pub fn event_subscriptions(
            mut self,
            input: impl Into<crate::model::EventSubscription>,
        ) -> Self {
            let mut v = self.event_subscriptions.unwrap_or_default();
            v.push(input.into());
            self.event_subscriptions = Some(v);
            self
        }
        /// <p>The list of existing event subscriptions.</p>
        pub fn set_event_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
        ) -> Self {
            self.event_subscriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`Subscription`](crate::model::Subscription)
        pub fn build(self) -> crate::model::Subscription {
            crate::model::Subscription {
                resource_arn: self.resource_arn,
                topic_arn: self.topic_arn,
                event_subscriptions: self.event_subscriptions,
            }
        }
    }
}
impl Subscription {
    /// Creates a new builder-style object to manufacture [`Subscription`](crate::model::Subscription)
    pub fn builder() -> crate::model::subscription::Builder {
        crate::model::subscription::Builder::default()
    }
}

/// <p>This data type is used in the <a>Subscription</a> data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscription {
    /// <p>The event for which Amazon Simple Notification Service (SNS) notifications are
    /// sent.</p>
    pub event: std::option::Option<crate::model::InspectorEvent>,
    /// <p>The time at which <a>SubscribeToEvent</a> is called.</p>
    pub subscribed_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl EventSubscription {
    /// <p>The event for which Amazon Simple Notification Service (SNS) notifications are
    /// sent.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::InspectorEvent> {
        self.event.as_ref()
    }
    /// <p>The time at which <a>SubscribeToEvent</a> is called.</p>
    pub fn subscribed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.subscribed_at.as_ref()
    }
}
impl std::fmt::Debug for EventSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscription");
        formatter.field("event", &self.event);
        formatter.field("subscribed_at", &self.subscribed_at);
        formatter.finish()
    }
}
/// See [`EventSubscription`](crate::model::EventSubscription)
pub mod event_subscription {
    /// A builder for [`EventSubscription`](crate::model::EventSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event: std::option::Option<crate::model::InspectorEvent>,
        pub(crate) subscribed_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The event for which Amazon Simple Notification Service (SNS) notifications are
        /// sent.</p>
        pub fn event(mut self, input: crate::model::InspectorEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The event for which Amazon Simple Notification Service (SNS) notifications are
        /// sent.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.event = input;
            self
        }
        /// <p>The time at which <a>SubscribeToEvent</a> is called.</p>
        pub fn subscribed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.subscribed_at = Some(input);
            self
        }
        /// <p>The time at which <a>SubscribeToEvent</a> is called.</p>
        pub fn set_subscribed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.subscribed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscription`](crate::model::EventSubscription)
        pub fn build(self) -> crate::model::EventSubscription {
            crate::model::EventSubscription {
                event: self.event,
                subscribed_at: self.subscribed_at,
            }
        }
    }
}
impl EventSubscription {
    /// Creates a new builder-style object to manufacture [`EventSubscription`](crate::model::EventSubscription)
    pub fn builder() -> crate::model::event_subscription::Builder {
        crate::model::event_subscription::Builder::default()
    }
}

/// <p>Used as the request parameter in the <a>ListAssessmentTemplates</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentTemplateFilter {
    /// <p>For a record to match a filter, an explicit value or a string that contains a
    /// wildcard that is specified for this data type property must match the value of the
    /// <b>assessmentTemplateName</b> property of the <a>AssessmentTemplate</a> data type.</p>
    pub name_pattern: std::option::Option<std::string::String>,
    /// <p>For a record to match a filter, the value specified for this data type property must
    /// inclusively match any value between the specified minimum and maximum values of the
    /// <b>durationInSeconds</b> property of the <a>AssessmentTemplate</a> data type.</p>
    pub duration_range: std::option::Option<crate::model::DurationRange>,
    /// <p>For a record to match a filter, the values that are specified for this data type
    /// property must be contained in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data
    /// type.</p>
    pub rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AssessmentTemplateFilter {
    /// <p>For a record to match a filter, an explicit value or a string that contains a
    /// wildcard that is specified for this data type property must match the value of the
    /// <b>assessmentTemplateName</b> property of the <a>AssessmentTemplate</a> data type.</p>
    pub fn name_pattern(&self) -> std::option::Option<&str> {
        self.name_pattern.as_deref()
    }
    /// <p>For a record to match a filter, the value specified for this data type property must
    /// inclusively match any value between the specified minimum and maximum values of the
    /// <b>durationInSeconds</b> property of the <a>AssessmentTemplate</a> data type.</p>
    pub fn duration_range(&self) -> std::option::Option<&crate::model::DurationRange> {
        self.duration_range.as_ref()
    }
    /// <p>For a record to match a filter, the values that are specified for this data type
    /// property must be contained in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data
    /// type.</p>
    pub fn rules_package_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rules_package_arns.as_deref()
    }
}
impl std::fmt::Debug for AssessmentTemplateFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentTemplateFilter");
        formatter.field("name_pattern", &self.name_pattern);
        formatter.field("duration_range", &self.duration_range);
        formatter.field("rules_package_arns", &self.rules_package_arns);
        formatter.finish()
    }
}
/// See [`AssessmentTemplateFilter`](crate::model::AssessmentTemplateFilter)
pub mod assessment_template_filter {
    /// A builder for [`AssessmentTemplateFilter`](crate::model::AssessmentTemplateFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_pattern: std::option::Option<std::string::String>,
        pub(crate) duration_range: std::option::Option<crate::model::DurationRange>,
        pub(crate) rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>For a record to match a filter, an explicit value or a string that contains a
        /// wildcard that is specified for this data type property must match the value of the
        /// <b>assessmentTemplateName</b> property of the <a>AssessmentTemplate</a> data type.</p>
        pub fn name_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_pattern = Some(input.into());
            self
        }
        /// <p>For a record to match a filter, an explicit value or a string that contains a
        /// wildcard that is specified for this data type property must match the value of the
        /// <b>assessmentTemplateName</b> property of the <a>AssessmentTemplate</a> data type.</p>
        pub fn set_name_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_pattern = input;
            self
        }
        /// <p>For a record to match a filter, the value specified for this data type property must
        /// inclusively match any value between the specified minimum and maximum values of the
        /// <b>durationInSeconds</b> property of the <a>AssessmentTemplate</a> data type.</p>
        pub fn duration_range(mut self, input: crate::model::DurationRange) -> Self {
            self.duration_range = Some(input);
            self
        }
        /// <p>For a record to match a filter, the value specified for this data type property must
        /// inclusively match any value between the specified minimum and maximum values of the
        /// <b>durationInSeconds</b> property of the <a>AssessmentTemplate</a> data type.</p>
        pub fn set_duration_range(
            mut self,
            input: std::option::Option<crate::model::DurationRange>,
        ) -> Self {
            self.duration_range = input;
            self
        }
        /// Appends an item to `rules_package_arns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>For a record to match a filter, the values that are specified for this data type
        /// property must be contained in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data
        /// type.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rules_package_arns.unwrap_or_default();
            v.push(input.into());
            self.rules_package_arns = Some(v);
            self
        }
        /// <p>For a record to match a filter, the values that are specified for this data type
        /// property must be contained in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data
        /// type.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rules_package_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentTemplateFilter`](crate::model::AssessmentTemplateFilter)
        pub fn build(self) -> crate::model::AssessmentTemplateFilter {
            crate::model::AssessmentTemplateFilter {
                name_pattern: self.name_pattern,
                duration_range: self.duration_range,
                rules_package_arns: self.rules_package_arns,
            }
        }
    }
}
impl AssessmentTemplateFilter {
    /// Creates a new builder-style object to manufacture [`AssessmentTemplateFilter`](crate::model::AssessmentTemplateFilter)
    pub fn builder() -> crate::model::assessment_template_filter::Builder {
        crate::model::assessment_template_filter::Builder::default()
    }
}

/// <p>This data type is used in the <a>AssessmentTemplateFilter</a> data
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DurationRange {
    /// <p>The minimum value of the duration range. Must be greater than zero.</p>
    pub min_seconds: i32,
    /// <p>The maximum value of the duration range. Must be less than or equal to 604800 seconds
    /// (1 week).</p>
    pub max_seconds: i32,
}
impl DurationRange {
    /// <p>The minimum value of the duration range. Must be greater than zero.</p>
    pub fn min_seconds(&self) -> i32 {
        self.min_seconds
    }
    /// <p>The maximum value of the duration range. Must be less than or equal to 604800 seconds
    /// (1 week).</p>
    pub fn max_seconds(&self) -> i32 {
        self.max_seconds
    }
}
impl std::fmt::Debug for DurationRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DurationRange");
        formatter.field("min_seconds", &self.min_seconds);
        formatter.field("max_seconds", &self.max_seconds);
        formatter.finish()
    }
}
/// See [`DurationRange`](crate::model::DurationRange)
pub mod duration_range {
    /// A builder for [`DurationRange`](crate::model::DurationRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_seconds: std::option::Option<i32>,
        pub(crate) max_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum value of the duration range. Must be greater than zero.</p>
        pub fn min_seconds(mut self, input: i32) -> Self {
            self.min_seconds = Some(input);
            self
        }
        /// <p>The minimum value of the duration range. Must be greater than zero.</p>
        pub fn set_min_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.min_seconds = input;
            self
        }
        /// <p>The maximum value of the duration range. Must be less than or equal to 604800 seconds
        /// (1 week).</p>
        pub fn max_seconds(mut self, input: i32) -> Self {
            self.max_seconds = Some(input);
            self
        }
        /// <p>The maximum value of the duration range. Must be less than or equal to 604800 seconds
        /// (1 week).</p>
        pub fn set_max_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`DurationRange`](crate::model::DurationRange)
        pub fn build(self) -> crate::model::DurationRange {
            crate::model::DurationRange {
                min_seconds: self.min_seconds.unwrap_or_default(),
                max_seconds: self.max_seconds.unwrap_or_default(),
            }
        }
    }
}
impl DurationRange {
    /// Creates a new builder-style object to manufacture [`DurationRange`](crate::model::DurationRange)
    pub fn builder() -> crate::model::duration_range::Builder {
        crate::model::duration_range::Builder::default()
    }
}

/// <p>Used as the request parameter in the <a>ListAssessmentTargets</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentTargetFilter {
    /// <p>For a record to match a filter, an explicit value or a string that contains a
    /// wildcard that is specified for this data type property must match the value of the
    /// <b>assessmentTargetName</b> property of the <a>AssessmentTarget</a> data type.</p>
    pub assessment_target_name_pattern: std::option::Option<std::string::String>,
}
impl AssessmentTargetFilter {
    /// <p>For a record to match a filter, an explicit value or a string that contains a
    /// wildcard that is specified for this data type property must match the value of the
    /// <b>assessmentTargetName</b> property of the <a>AssessmentTarget</a> data type.</p>
    pub fn assessment_target_name_pattern(&self) -> std::option::Option<&str> {
        self.assessment_target_name_pattern.as_deref()
    }
}
impl std::fmt::Debug for AssessmentTargetFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentTargetFilter");
        formatter.field(
            "assessment_target_name_pattern",
            &self.assessment_target_name_pattern,
        );
        formatter.finish()
    }
}
/// See [`AssessmentTargetFilter`](crate::model::AssessmentTargetFilter)
pub mod assessment_target_filter {
    /// A builder for [`AssessmentTargetFilter`](crate::model::AssessmentTargetFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_target_name_pattern: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>For a record to match a filter, an explicit value or a string that contains a
        /// wildcard that is specified for this data type property must match the value of the
        /// <b>assessmentTargetName</b> property of the <a>AssessmentTarget</a> data type.</p>
        pub fn assessment_target_name_pattern(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.assessment_target_name_pattern = Some(input.into());
            self
        }
        /// <p>For a record to match a filter, an explicit value or a string that contains a
        /// wildcard that is specified for this data type property must match the value of the
        /// <b>assessmentTargetName</b> property of the <a>AssessmentTarget</a> data type.</p>
        pub fn set_assessment_target_name_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_target_name_pattern = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentTargetFilter`](crate::model::AssessmentTargetFilter)
        pub fn build(self) -> crate::model::AssessmentTargetFilter {
            crate::model::AssessmentTargetFilter {
                assessment_target_name_pattern: self.assessment_target_name_pattern,
            }
        }
    }
}
impl AssessmentTargetFilter {
    /// Creates a new builder-style object to manufacture [`AssessmentTargetFilter`](crate::model::AssessmentTargetFilter)
    pub fn builder() -> crate::model::assessment_target_filter::Builder {
        crate::model::assessment_target_filter::Builder::default()
    }
}

/// <p>Used as the request parameter in the <a>ListAssessmentRuns</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentRunFilter {
    /// <p>For a record to match a filter, an explicit value or a string containing a wildcard
    /// that is specified for this data type property must match the value of the <b>assessmentRunName</b> property of the <a>AssessmentRun</a>
    /// data type.</p>
    pub name_pattern: std::option::Option<std::string::String>,
    /// <p>For a record to match a filter, one of the values specified for this data type
    /// property must be the exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
    /// type.</p>
    pub states: std::option::Option<std::vec::Vec<crate::model::AssessmentRunState>>,
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must inclusively match any value between the specified minimum and maximum values
    /// of the <b>durationInSeconds</b> property of the <a>AssessmentRun</a> data type.</p>
    pub duration_range: std::option::Option<crate::model::DurationRange>,
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must be contained in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data
    /// type.</p>
    pub rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must inclusively match any value between the specified minimum and maximum values
    /// of the <b>startTime</b> property of the <a>AssessmentRun</a> data type.</p>
    pub start_time_range: std::option::Option<crate::model::TimestampRange>,
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must inclusively match any value between the specified minimum and maximum values
    /// of the <b>completedAt</b> property of the <a>AssessmentRun</a> data type.</p>
    pub completion_time_range: std::option::Option<crate::model::TimestampRange>,
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must match the <b>stateChangedAt</b> property of the
    /// <a>AssessmentRun</a> data type.</p>
    pub state_change_time_range: std::option::Option<crate::model::TimestampRange>,
}
impl AssessmentRunFilter {
    /// <p>For a record to match a filter, an explicit value or a string containing a wildcard
    /// that is specified for this data type property must match the value of the <b>assessmentRunName</b> property of the <a>AssessmentRun</a>
    /// data type.</p>
    pub fn name_pattern(&self) -> std::option::Option<&str> {
        self.name_pattern.as_deref()
    }
    /// <p>For a record to match a filter, one of the values specified for this data type
    /// property must be the exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
    /// type.</p>
    pub fn states(&self) -> std::option::Option<&[crate::model::AssessmentRunState]> {
        self.states.as_deref()
    }
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must inclusively match any value between the specified minimum and maximum values
    /// of the <b>durationInSeconds</b> property of the <a>AssessmentRun</a> data type.</p>
    pub fn duration_range(&self) -> std::option::Option<&crate::model::DurationRange> {
        self.duration_range.as_ref()
    }
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must be contained in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data
    /// type.</p>
    pub fn rules_package_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rules_package_arns.as_deref()
    }
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must inclusively match any value between the specified minimum and maximum values
    /// of the <b>startTime</b> property of the <a>AssessmentRun</a> data type.</p>
    pub fn start_time_range(&self) -> std::option::Option<&crate::model::TimestampRange> {
        self.start_time_range.as_ref()
    }
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must inclusively match any value between the specified minimum and maximum values
    /// of the <b>completedAt</b> property of the <a>AssessmentRun</a> data type.</p>
    pub fn completion_time_range(&self) -> std::option::Option<&crate::model::TimestampRange> {
        self.completion_time_range.as_ref()
    }
    /// <p>For a record to match a filter, the value that is specified for this data type
    /// property must match the <b>stateChangedAt</b> property of the
    /// <a>AssessmentRun</a> data type.</p>
    pub fn state_change_time_range(&self) -> std::option::Option<&crate::model::TimestampRange> {
        self.state_change_time_range.as_ref()
    }
}
impl std::fmt::Debug for AssessmentRunFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentRunFilter");
        formatter.field("name_pattern", &self.name_pattern);
        formatter.field("states", &self.states);
        formatter.field("duration_range", &self.duration_range);
        formatter.field("rules_package_arns", &self.rules_package_arns);
        formatter.field("start_time_range", &self.start_time_range);
        formatter.field("completion_time_range", &self.completion_time_range);
        formatter.field("state_change_time_range", &self.state_change_time_range);
        formatter.finish()
    }
}
/// See [`AssessmentRunFilter`](crate::model::AssessmentRunFilter)
pub mod assessment_run_filter {
    /// A builder for [`AssessmentRunFilter`](crate::model::AssessmentRunFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_pattern: std::option::Option<std::string::String>,
        pub(crate) states: std::option::Option<std::vec::Vec<crate::model::AssessmentRunState>>,
        pub(crate) duration_range: std::option::Option<crate::model::DurationRange>,
        pub(crate) rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) start_time_range: std::option::Option<crate::model::TimestampRange>,
        pub(crate) completion_time_range: std::option::Option<crate::model::TimestampRange>,
        pub(crate) state_change_time_range: std::option::Option<crate::model::TimestampRange>,
    }
    impl Builder {
        /// <p>For a record to match a filter, an explicit value or a string containing a wildcard
        /// that is specified for this data type property must match the value of the <b>assessmentRunName</b> property of the <a>AssessmentRun</a>
        /// data type.</p>
        pub fn name_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_pattern = Some(input.into());
            self
        }
        /// <p>For a record to match a filter, an explicit value or a string containing a wildcard
        /// that is specified for this data type property must match the value of the <b>assessmentRunName</b> property of the <a>AssessmentRun</a>
        /// data type.</p>
        pub fn set_name_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name_pattern = input;
            self
        }
        /// Appends an item to `states`.
        ///
        /// To override the contents of this collection use [`set_states`](Self::set_states).
        ///
        /// <p>For a record to match a filter, one of the values specified for this data type
        /// property must be the exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
        /// type.</p>
        pub fn states(mut self, input: impl Into<crate::model::AssessmentRunState>) -> Self {
            let mut v = self.states.unwrap_or_default();
            v.push(input.into());
            self.states = Some(v);
            self
        }
        /// <p>For a record to match a filter, one of the values specified for this data type
        /// property must be the exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
        /// type.</p>
        pub fn set_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentRunState>>,
        ) -> Self {
            self.states = input;
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must inclusively match any value between the specified minimum and maximum values
        /// of the <b>durationInSeconds</b> property of the <a>AssessmentRun</a> data type.</p>
        pub fn duration_range(mut self, input: crate::model::DurationRange) -> Self {
            self.duration_range = Some(input);
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must inclusively match any value between the specified minimum and maximum values
        /// of the <b>durationInSeconds</b> property of the <a>AssessmentRun</a> data type.</p>
        pub fn set_duration_range(
            mut self,
            input: std::option::Option<crate::model::DurationRange>,
        ) -> Self {
            self.duration_range = input;
            self
        }
        /// Appends an item to `rules_package_arns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must be contained in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data
        /// type.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rules_package_arns.unwrap_or_default();
            v.push(input.into());
            self.rules_package_arns = Some(v);
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must be contained in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data
        /// type.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rules_package_arns = input;
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must inclusively match any value between the specified minimum and maximum values
        /// of the <b>startTime</b> property of the <a>AssessmentRun</a> data type.</p>
        pub fn start_time_range(mut self, input: crate::model::TimestampRange) -> Self {
            self.start_time_range = Some(input);
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must inclusively match any value between the specified minimum and maximum values
        /// of the <b>startTime</b> property of the <a>AssessmentRun</a> data type.</p>
        pub fn set_start_time_range(
            mut self,
            input: std::option::Option<crate::model::TimestampRange>,
        ) -> Self {
            self.start_time_range = input;
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must inclusively match any value between the specified minimum and maximum values
        /// of the <b>completedAt</b> property of the <a>AssessmentRun</a> data type.</p>
        pub fn completion_time_range(mut self, input: crate::model::TimestampRange) -> Self {
            self.completion_time_range = Some(input);
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must inclusively match any value between the specified minimum and maximum values
        /// of the <b>completedAt</b> property of the <a>AssessmentRun</a> data type.</p>
        pub fn set_completion_time_range(
            mut self,
            input: std::option::Option<crate::model::TimestampRange>,
        ) -> Self {
            self.completion_time_range = input;
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must match the <b>stateChangedAt</b> property of the
        /// <a>AssessmentRun</a> data type.</p>
        pub fn state_change_time_range(mut self, input: crate::model::TimestampRange) -> Self {
            self.state_change_time_range = Some(input);
            self
        }
        /// <p>For a record to match a filter, the value that is specified for this data type
        /// property must match the <b>stateChangedAt</b> property of the
        /// <a>AssessmentRun</a> data type.</p>
        pub fn set_state_change_time_range(
            mut self,
            input: std::option::Option<crate::model::TimestampRange>,
        ) -> Self {
            self.state_change_time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentRunFilter`](crate::model::AssessmentRunFilter)
        pub fn build(self) -> crate::model::AssessmentRunFilter {
            crate::model::AssessmentRunFilter {
                name_pattern: self.name_pattern,
                states: self.states,
                duration_range: self.duration_range,
                rules_package_arns: self.rules_package_arns,
                start_time_range: self.start_time_range,
                completion_time_range: self.completion_time_range,
                state_change_time_range: self.state_change_time_range,
            }
        }
    }
}
impl AssessmentRunFilter {
    /// Creates a new builder-style object to manufacture [`AssessmentRunFilter`](crate::model::AssessmentRunFilter)
    pub fn builder() -> crate::model::assessment_run_filter::Builder {
        crate::model::assessment_run_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentRunState {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    CollectingData,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    DataCollected,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    EvaluatingRules,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    StartDataCollectionInProgress,
    #[allow(missing_docs)] // documentation missing in model
    StartDataCollectionPending,
    #[allow(missing_docs)] // documentation missing in model
    StartEvaluatingRulesPending,
    #[allow(missing_docs)] // documentation missing in model
    StopDataCollectionPending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentRunState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => AssessmentRunState::Canceled,
            "COLLECTING_DATA" => AssessmentRunState::CollectingData,
            "COMPLETED" => AssessmentRunState::Completed,
            "COMPLETED_WITH_ERRORS" => AssessmentRunState::CompletedWithErrors,
            "CREATED" => AssessmentRunState::Created,
            "DATA_COLLECTED" => AssessmentRunState::DataCollected,
            "ERROR" => AssessmentRunState::Error,
            "EVALUATING_RULES" => AssessmentRunState::EvaluatingRules,
            "FAILED" => AssessmentRunState::Failed,
            "START_DATA_COLLECTION_IN_PROGRESS" => {
                AssessmentRunState::StartDataCollectionInProgress
            }
            "START_DATA_COLLECTION_PENDING" => AssessmentRunState::StartDataCollectionPending,
            "START_EVALUATING_RULES_PENDING" => AssessmentRunState::StartEvaluatingRulesPending,
            "STOP_DATA_COLLECTION_PENDING" => AssessmentRunState::StopDataCollectionPending,
            other => AssessmentRunState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentRunState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentRunState::from(s))
    }
}
impl AssessmentRunState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentRunState::Canceled => "CANCELED",
            AssessmentRunState::CollectingData => "COLLECTING_DATA",
            AssessmentRunState::Completed => "COMPLETED",
            AssessmentRunState::CompletedWithErrors => "COMPLETED_WITH_ERRORS",
            AssessmentRunState::Created => "CREATED",
            AssessmentRunState::DataCollected => "DATA_COLLECTED",
            AssessmentRunState::Error => "ERROR",
            AssessmentRunState::EvaluatingRules => "EVALUATING_RULES",
            AssessmentRunState::Failed => "FAILED",
            AssessmentRunState::StartDataCollectionInProgress => {
                "START_DATA_COLLECTION_IN_PROGRESS"
            }
            AssessmentRunState::StartDataCollectionPending => "START_DATA_COLLECTION_PENDING",
            AssessmentRunState::StartEvaluatingRulesPending => "START_EVALUATING_RULES_PENDING",
            AssessmentRunState::StopDataCollectionPending => "STOP_DATA_COLLECTION_PENDING",
            AssessmentRunState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "COLLECTING_DATA",
            "COMPLETED",
            "COMPLETED_WITH_ERRORS",
            "CREATED",
            "DATA_COLLECTED",
            "ERROR",
            "EVALUATING_RULES",
            "FAILED",
            "START_DATA_COLLECTION_IN_PROGRESS",
            "START_DATA_COLLECTION_PENDING",
            "START_EVALUATING_RULES_PENDING",
            "STOP_DATA_COLLECTION_PENDING",
        ]
    }
}
impl AsRef<str> for AssessmentRunState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an Amazon Inspector agent. This data type is used as a
/// response element in the <a>ListAssessmentRunAgents</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentRunAgent {
    /// <p>The AWS account of the EC2 instance where the agent is installed.</p>
    pub agent_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the assessment run that is associated with the agent.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>The current health state of the agent.</p>
    pub agent_health: std::option::Option<crate::model::AgentHealth>,
    /// <p>The detailed health state of the agent.</p>
    pub agent_health_code: std::option::Option<crate::model::AgentHealthCode>,
    /// <p>The description for the agent health code.</p>
    pub agent_health_details: std::option::Option<std::string::String>,
    /// <p>The Auto Scaling group of the EC2 instance that is specified by the agent
    /// ID.</p>
    pub auto_scaling_group: std::option::Option<std::string::String>,
    /// <p>The Amazon Inspector application data metrics that are collected by the
    /// agent.</p>
    pub telemetry_metadata: std::option::Option<std::vec::Vec<crate::model::TelemetryMetadata>>,
}
impl AssessmentRunAgent {
    /// <p>The AWS account of the EC2 instance where the agent is installed.</p>
    pub fn agent_id(&self) -> std::option::Option<&str> {
        self.agent_id.as_deref()
    }
    /// <p>The ARN of the assessment run that is associated with the agent.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
    /// <p>The current health state of the agent.</p>
    pub fn agent_health(&self) -> std::option::Option<&crate::model::AgentHealth> {
        self.agent_health.as_ref()
    }
    /// <p>The detailed health state of the agent.</p>
    pub fn agent_health_code(&self) -> std::option::Option<&crate::model::AgentHealthCode> {
        self.agent_health_code.as_ref()
    }
    /// <p>The description for the agent health code.</p>
    pub fn agent_health_details(&self) -> std::option::Option<&str> {
        self.agent_health_details.as_deref()
    }
    /// <p>The Auto Scaling group of the EC2 instance that is specified by the agent
    /// ID.</p>
    pub fn auto_scaling_group(&self) -> std::option::Option<&str> {
        self.auto_scaling_group.as_deref()
    }
    /// <p>The Amazon Inspector application data metrics that are collected by the
    /// agent.</p>
    pub fn telemetry_metadata(&self) -> std::option::Option<&[crate::model::TelemetryMetadata]> {
        self.telemetry_metadata.as_deref()
    }
}
impl std::fmt::Debug for AssessmentRunAgent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentRunAgent");
        formatter.field("agent_id", &self.agent_id);
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.field("agent_health", &self.agent_health);
        formatter.field("agent_health_code", &self.agent_health_code);
        formatter.field("agent_health_details", &self.agent_health_details);
        formatter.field("auto_scaling_group", &self.auto_scaling_group);
        formatter.field("telemetry_metadata", &self.telemetry_metadata);
        formatter.finish()
    }
}
/// See [`AssessmentRunAgent`](crate::model::AssessmentRunAgent)
pub mod assessment_run_agent {
    /// A builder for [`AssessmentRunAgent`](crate::model::AssessmentRunAgent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_id: std::option::Option<std::string::String>,
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) agent_health: std::option::Option<crate::model::AgentHealth>,
        pub(crate) agent_health_code: std::option::Option<crate::model::AgentHealthCode>,
        pub(crate) agent_health_details: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group: std::option::Option<std::string::String>,
        pub(crate) telemetry_metadata:
            std::option::Option<std::vec::Vec<crate::model::TelemetryMetadata>>,
    }
    impl Builder {
        /// <p>The AWS account of the EC2 instance where the agent is installed.</p>
        pub fn agent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_id = Some(input.into());
            self
        }
        /// <p>The AWS account of the EC2 instance where the agent is installed.</p>
        pub fn set_agent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_id = input;
            self
        }
        /// <p>The ARN of the assessment run that is associated with the agent.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment run that is associated with the agent.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// <p>The current health state of the agent.</p>
        pub fn agent_health(mut self, input: crate::model::AgentHealth) -> Self {
            self.agent_health = Some(input);
            self
        }
        /// <p>The current health state of the agent.</p>
        pub fn set_agent_health(
            mut self,
            input: std::option::Option<crate::model::AgentHealth>,
        ) -> Self {
            self.agent_health = input;
            self
        }
        /// <p>The detailed health state of the agent.</p>
        pub fn agent_health_code(mut self, input: crate::model::AgentHealthCode) -> Self {
            self.agent_health_code = Some(input);
            self
        }
        /// <p>The detailed health state of the agent.</p>
        pub fn set_agent_health_code(
            mut self,
            input: std::option::Option<crate::model::AgentHealthCode>,
        ) -> Self {
            self.agent_health_code = input;
            self
        }
        /// <p>The description for the agent health code.</p>
        pub fn agent_health_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_health_details = Some(input.into());
            self
        }
        /// <p>The description for the agent health code.</p>
        pub fn set_agent_health_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_health_details = input;
            self
        }
        /// <p>The Auto Scaling group of the EC2 instance that is specified by the agent
        /// ID.</p>
        pub fn auto_scaling_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group = Some(input.into());
            self
        }
        /// <p>The Auto Scaling group of the EC2 instance that is specified by the agent
        /// ID.</p>
        pub fn set_auto_scaling_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group = input;
            self
        }
        /// Appends an item to `telemetry_metadata`.
        ///
        /// To override the contents of this collection use [`set_telemetry_metadata`](Self::set_telemetry_metadata).
        ///
        /// <p>The Amazon Inspector application data metrics that are collected by the
        /// agent.</p>
        pub fn telemetry_metadata(
            mut self,
            input: impl Into<crate::model::TelemetryMetadata>,
        ) -> Self {
            let mut v = self.telemetry_metadata.unwrap_or_default();
            v.push(input.into());
            self.telemetry_metadata = Some(v);
            self
        }
        /// <p>The Amazon Inspector application data metrics that are collected by the
        /// agent.</p>
        pub fn set_telemetry_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TelemetryMetadata>>,
        ) -> Self {
            self.telemetry_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentRunAgent`](crate::model::AssessmentRunAgent)
        pub fn build(self) -> crate::model::AssessmentRunAgent {
            crate::model::AssessmentRunAgent {
                agent_id: self.agent_id,
                assessment_run_arn: self.assessment_run_arn,
                agent_health: self.agent_health,
                agent_health_code: self.agent_health_code,
                agent_health_details: self.agent_health_details,
                auto_scaling_group: self.auto_scaling_group,
                telemetry_metadata: self.telemetry_metadata,
            }
        }
    }
}
impl AssessmentRunAgent {
    /// Creates a new builder-style object to manufacture [`AssessmentRunAgent`](crate::model::AssessmentRunAgent)
    pub fn builder() -> crate::model::assessment_run_agent::Builder {
        crate::model::assessment_run_agent::Builder::default()
    }
}

/// <p>The metadata about the Amazon Inspector application data metrics collected by the
/// agent. This data type is used as the response element in the <a>GetTelemetryMetadata</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TelemetryMetadata {
    /// <p>A specific type of behavioral data that is collected by the agent.</p>
    pub message_type: std::option::Option<std::string::String>,
    /// <p>The count of messages that the agent sends to the Amazon Inspector service.</p>
    pub count: std::option::Option<i64>,
    /// <p>The data size of messages that the agent sends to the Amazon Inspector
    /// service.</p>
    pub data_size: std::option::Option<i64>,
}
impl TelemetryMetadata {
    /// <p>A specific type of behavioral data that is collected by the agent.</p>
    pub fn message_type(&self) -> std::option::Option<&str> {
        self.message_type.as_deref()
    }
    /// <p>The count of messages that the agent sends to the Amazon Inspector service.</p>
    pub fn count(&self) -> std::option::Option<i64> {
        self.count
    }
    /// <p>The data size of messages that the agent sends to the Amazon Inspector
    /// service.</p>
    pub fn data_size(&self) -> std::option::Option<i64> {
        self.data_size
    }
}
impl std::fmt::Debug for TelemetryMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TelemetryMetadata");
        formatter.field("message_type", &self.message_type);
        formatter.field("count", &self.count);
        formatter.field("data_size", &self.data_size);
        formatter.finish()
    }
}
/// See [`TelemetryMetadata`](crate::model::TelemetryMetadata)
pub mod telemetry_metadata {
    /// A builder for [`TelemetryMetadata`](crate::model::TelemetryMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_type: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i64>,
        pub(crate) data_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>A specific type of behavioral data that is collected by the agent.</p>
        pub fn message_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_type = Some(input.into());
            self
        }
        /// <p>A specific type of behavioral data that is collected by the agent.</p>
        pub fn set_message_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_type = input;
            self
        }
        /// <p>The count of messages that the agent sends to the Amazon Inspector service.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The count of messages that the agent sends to the Amazon Inspector service.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The data size of messages that the agent sends to the Amazon Inspector
        /// service.</p>
        pub fn data_size(mut self, input: i64) -> Self {
            self.data_size = Some(input);
            self
        }
        /// <p>The data size of messages that the agent sends to the Amazon Inspector
        /// service.</p>
        pub fn set_data_size(mut self, input: std::option::Option<i64>) -> Self {
            self.data_size = input;
            self
        }
        /// Consumes the builder and constructs a [`TelemetryMetadata`](crate::model::TelemetryMetadata)
        pub fn build(self) -> crate::model::TelemetryMetadata {
            crate::model::TelemetryMetadata {
                message_type: self.message_type,
                count: self.count,
                data_size: self.data_size,
            }
        }
    }
}
impl TelemetryMetadata {
    /// Creates a new builder-style object to manufacture [`TelemetryMetadata`](crate::model::TelemetryMetadata)
    pub fn builder() -> crate::model::telemetry_metadata::Builder {
        crate::model::telemetry_metadata::Builder::default()
    }
}

/// _Note: `AgentHealthCode::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentHealthCode {
    #[allow(missing_docs)] // documentation missing in model
    Idle,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Shutdown,
    #[allow(missing_docs)] // documentation missing in model
    Throttled,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentHealthCode {
    fn from(s: &str) -> Self {
        match s {
            "IDLE" => AgentHealthCode::Idle,
            "RUNNING" => AgentHealthCode::Running,
            "SHUTDOWN" => AgentHealthCode::Shutdown,
            "THROTTLED" => AgentHealthCode::Throttled,
            "UNHEALTHY" => AgentHealthCode::Unhealthy,
            "UNKNOWN" => AgentHealthCode::UnknownValue,
            other => AgentHealthCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentHealthCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentHealthCode::from(s))
    }
}
impl AgentHealthCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentHealthCode::Idle => "IDLE",
            AgentHealthCode::Running => "RUNNING",
            AgentHealthCode::Shutdown => "SHUTDOWN",
            AgentHealthCode::Throttled => "THROTTLED",
            AgentHealthCode::Unhealthy => "UNHEALTHY",
            AgentHealthCode::UnknownValue => "UNKNOWN",
            AgentHealthCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "IDLE",
            "RUNNING",
            "SHUTDOWN",
            "THROTTLED",
            "UNHEALTHY",
            "UNKNOWN",
        ]
    }
}
impl AsRef<str> for AgentHealthCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an Amazon Inspector agent. This data type is used as a
/// request parameter in the <a>ListAssessmentRunAgents</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentFilter {
    /// <p>The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.</p>
    pub agent_healths: std::option::Option<std::vec::Vec<crate::model::AgentHealth>>,
    /// <p>The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>. </p>
    pub agent_health_codes: std::option::Option<std::vec::Vec<crate::model::AgentHealthCode>>,
}
impl AgentFilter {
    /// <p>The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.</p>
    pub fn agent_healths(&self) -> std::option::Option<&[crate::model::AgentHealth]> {
        self.agent_healths.as_deref()
    }
    /// <p>The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>. </p>
    pub fn agent_health_codes(&self) -> std::option::Option<&[crate::model::AgentHealthCode]> {
        self.agent_health_codes.as_deref()
    }
}
impl std::fmt::Debug for AgentFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentFilter");
        formatter.field("agent_healths", &self.agent_healths);
        formatter.field("agent_health_codes", &self.agent_health_codes);
        formatter.finish()
    }
}
/// See [`AgentFilter`](crate::model::AgentFilter)
pub mod agent_filter {
    /// A builder for [`AgentFilter`](crate::model::AgentFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_healths: std::option::Option<std::vec::Vec<crate::model::AgentHealth>>,
        pub(crate) agent_health_codes:
            std::option::Option<std::vec::Vec<crate::model::AgentHealthCode>>,
    }
    impl Builder {
        /// Appends an item to `agent_healths`.
        ///
        /// To override the contents of this collection use [`set_agent_healths`](Self::set_agent_healths).
        ///
        /// <p>The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.</p>
        pub fn agent_healths(mut self, input: impl Into<crate::model::AgentHealth>) -> Self {
            let mut v = self.agent_healths.unwrap_or_default();
            v.push(input.into());
            self.agent_healths = Some(v);
            self
        }
        /// <p>The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.</p>
        pub fn set_agent_healths(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentHealth>>,
        ) -> Self {
            self.agent_healths = input;
            self
        }
        /// Appends an item to `agent_health_codes`.
        ///
        /// To override the contents of this collection use [`set_agent_health_codes`](Self::set_agent_health_codes).
        ///
        /// <p>The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>. </p>
        pub fn agent_health_codes(
            mut self,
            input: impl Into<crate::model::AgentHealthCode>,
        ) -> Self {
            let mut v = self.agent_health_codes.unwrap_or_default();
            v.push(input.into());
            self.agent_health_codes = Some(v);
            self
        }
        /// <p>The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>. </p>
        pub fn set_agent_health_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentHealthCode>>,
        ) -> Self {
            self.agent_health_codes = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentFilter`](crate::model::AgentFilter)
        pub fn build(self) -> crate::model::AgentFilter {
            crate::model::AgentFilter {
                agent_healths: self.agent_healths,
                agent_health_codes: self.agent_health_codes,
            }
        }
    }
}
impl AgentFilter {
    /// Creates a new builder-style object to manufacture [`AgentFilter`](crate::model::AgentFilter)
    pub fn builder() -> crate::model::agent_filter::Builder {
        crate::model::agent_filter::Builder::default()
    }
}

/// <p>Contains information about what is excluded from an assessment run given the current
/// state of the assessment template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExclusionPreview {
    /// <p>The name of the exclusion preview.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The description of the exclusion preview.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The recommendation for the exclusion preview.</p>
    pub recommendation: std::option::Option<std::string::String>,
    /// <p>The AWS resources for which the exclusion preview pertains.</p>
    pub scopes: std::option::Option<std::vec::Vec<crate::model::Scope>>,
    /// <p>The system-defined attributes for the exclusion preview.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl ExclusionPreview {
    /// <p>The name of the exclusion preview.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The description of the exclusion preview.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The recommendation for the exclusion preview.</p>
    pub fn recommendation(&self) -> std::option::Option<&str> {
        self.recommendation.as_deref()
    }
    /// <p>The AWS resources for which the exclusion preview pertains.</p>
    pub fn scopes(&self) -> std::option::Option<&[crate::model::Scope]> {
        self.scopes.as_deref()
    }
    /// <p>The system-defined attributes for the exclusion preview.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for ExclusionPreview {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExclusionPreview");
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("recommendation", &self.recommendation);
        formatter.field("scopes", &self.scopes);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`ExclusionPreview`](crate::model::ExclusionPreview)
pub mod exclusion_preview {
    /// A builder for [`ExclusionPreview`](crate::model::ExclusionPreview)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommendation: std::option::Option<std::string::String>,
        pub(crate) scopes: std::option::Option<std::vec::Vec<crate::model::Scope>>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// <p>The name of the exclusion preview.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The name of the exclusion preview.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The description of the exclusion preview.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the exclusion preview.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The recommendation for the exclusion preview.</p>
        pub fn recommendation(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation = Some(input.into());
            self
        }
        /// <p>The recommendation for the exclusion preview.</p>
        pub fn set_recommendation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation = input;
            self
        }
        /// Appends an item to `scopes`.
        ///
        /// To override the contents of this collection use [`set_scopes`](Self::set_scopes).
        ///
        /// <p>The AWS resources for which the exclusion preview pertains.</p>
        pub fn scopes(mut self, input: impl Into<crate::model::Scope>) -> Self {
            let mut v = self.scopes.unwrap_or_default();
            v.push(input.into());
            self.scopes = Some(v);
            self
        }
        /// <p>The AWS resources for which the exclusion preview pertains.</p>
        pub fn set_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Scope>>,
        ) -> Self {
            self.scopes = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The system-defined attributes for the exclusion preview.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The system-defined attributes for the exclusion preview.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ExclusionPreview`](crate::model::ExclusionPreview)
        pub fn build(self) -> crate::model::ExclusionPreview {
            crate::model::ExclusionPreview {
                title: self.title,
                description: self.description,
                recommendation: self.recommendation,
                scopes: self.scopes,
                attributes: self.attributes,
            }
        }
    }
}
impl ExclusionPreview {
    /// Creates a new builder-style object to manufacture [`ExclusionPreview`](crate::model::ExclusionPreview)
    pub fn builder() -> crate::model::exclusion_preview::Builder {
        crate::model::exclusion_preview::Builder::default()
    }
}

/// <p>This data type contains key-value pairs that identify various Amazon
/// resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Scope {
    /// <p>The type of the scope.</p>
    pub key: std::option::Option<crate::model::ScopeType>,
    /// <p>The resource identifier for the specified scope type.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Scope {
    /// <p>The type of the scope.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::ScopeType> {
        self.key.as_ref()
    }
    /// <p>The resource identifier for the specified scope type.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Scope {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Scope");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Scope`](crate::model::Scope)
pub mod scope {
    /// A builder for [`Scope`](crate::model::Scope)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::ScopeType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the scope.</p>
        pub fn key(mut self, input: crate::model::ScopeType) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The type of the scope.</p>
        pub fn set_key(mut self, input: std::option::Option<crate::model::ScopeType>) -> Self {
            self.key = input;
            self
        }
        /// <p>The resource identifier for the specified scope type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The resource identifier for the specified scope type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Scope`](crate::model::Scope)
        pub fn build(self) -> crate::model::Scope {
            crate::model::Scope {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Scope {
    /// Creates a new builder-style object to manufacture [`Scope`](crate::model::Scope)
    pub fn builder() -> crate::model::scope::Builder {
        crate::model::scope::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScopeType {
    #[allow(missing_docs)] // documentation missing in model
    InstanceId,
    #[allow(missing_docs)] // documentation missing in model
    RulesPackageArn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScopeType {
    fn from(s: &str) -> Self {
        match s {
            "INSTANCE_ID" => ScopeType::InstanceId,
            "RULES_PACKAGE_ARN" => ScopeType::RulesPackageArn,
            other => ScopeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScopeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScopeType::from(s))
    }
}
impl ScopeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScopeType::InstanceId => "INSTANCE_ID",
            ScopeType::RulesPackageArn => "RULES_PACKAGE_ARN",
            ScopeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSTANCE_ID", "RULES_PACKAGE_ARN"]
    }
}
impl AsRef<str> for ScopeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PreviewStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    WorkInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PreviewStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => PreviewStatus::Completed,
            "WORK_IN_PROGRESS" => PreviewStatus::WorkInProgress,
            other => PreviewStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PreviewStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PreviewStatus::from(s))
    }
}
impl PreviewStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PreviewStatus::Completed => "COMPLETED",
            PreviewStatus::WorkInProgress => "WORK_IN_PROGRESS",
            PreviewStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "WORK_IN_PROGRESS"]
    }
}
impl AsRef<str> for PreviewStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Locale {
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Locale {
    fn from(s: &str) -> Self {
        match s {
            "EN_US" => Locale::EnUs,
            other => Locale::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Locale {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Locale::from(s))
    }
}
impl Locale {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Locale::EnUs => "EN_US",
            Locale::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EN_US"]
    }
}
impl AsRef<str> for Locale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    WorkInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => ReportStatus::Completed,
            "FAILED" => ReportStatus::Failed,
            "WORK_IN_PROGRESS" => ReportStatus::WorkInProgress,
            other => ReportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportStatus::from(s))
    }
}
impl ReportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportStatus::Completed => "COMPLETED",
            ReportStatus::Failed => "FAILED",
            ReportStatus::WorkInProgress => "WORK_IN_PROGRESS",
            ReportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "WORK_IN_PROGRESS"]
    }
}
impl AsRef<str> for ReportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportType {
    #[allow(missing_docs)] // documentation missing in model
    Finding,
    #[allow(missing_docs)] // documentation missing in model
    Full,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportType {
    fn from(s: &str) -> Self {
        match s {
            "FINDING" => ReportType::Finding,
            "FULL" => ReportType::Full,
            other => ReportType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportType::from(s))
    }
}
impl ReportType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportType::Finding => "FINDING",
            ReportType::Full => "FULL",
            ReportType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FINDING", "FULL"]
    }
}
impl AsRef<str> for ReportType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportFileFormat {
    #[allow(missing_docs)] // documentation missing in model
    Html,
    #[allow(missing_docs)] // documentation missing in model
    Pdf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportFileFormat {
    fn from(s: &str) -> Self {
        match s {
            "HTML" => ReportFileFormat::Html,
            "PDF" => ReportFileFormat::Pdf,
            other => ReportFileFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportFileFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportFileFormat::from(s))
    }
}
impl ReportFileFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportFileFormat::Html => "HTML",
            ReportFileFormat::Pdf => "PDF",
            ReportFileFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTML", "PDF"]
    }
}
impl AsRef<str> for ReportFileFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an Amazon Inspector rules package. This data type is used
/// as the response element in the <a>DescribeRulesPackages</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RulesPackage {
    /// <p>The ARN of the rules package.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the rules package.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version ID of the rules package.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The provider of the rules package.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The description of the rules package.</p>
    pub description: std::option::Option<std::string::String>,
}
impl RulesPackage {
    /// <p>The ARN of the rules package.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the rules package.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version ID of the rules package.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The provider of the rules package.</p>
    pub fn provider(&self) -> std::option::Option<&str> {
        self.provider.as_deref()
    }
    /// <p>The description of the rules package.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for RulesPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RulesPackage");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("provider", &self.provider);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`RulesPackage`](crate::model::RulesPackage)
pub mod rules_package {
    /// A builder for [`RulesPackage`](crate::model::RulesPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the rules package.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the rules package.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the rules package.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rules package.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version ID of the rules package.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version ID of the rules package.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The provider of the rules package.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The provider of the rules package.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The description of the rules package.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the rules package.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`RulesPackage`](crate::model::RulesPackage)
        pub fn build(self) -> crate::model::RulesPackage {
            crate::model::RulesPackage {
                arn: self.arn,
                name: self.name,
                version: self.version,
                provider: self.provider,
                description: self.description,
            }
        }
    }
}
impl RulesPackage {
    /// Creates a new builder-style object to manufacture [`RulesPackage`](crate::model::RulesPackage)
    pub fn builder() -> crate::model::rules_package::Builder {
        crate::model::rules_package::Builder::default()
    }
}

/// <p>Contains information about a resource group. The resource group defines a set of tags
/// that, when queried, identify the AWS resources that make up the assessment target. This
/// data type is used as the response element in the <a>DescribeResourceGroups</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceGroup {
    /// <p>The ARN of the resource group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags (key and value pairs) of the resource group. This data type property is used
    /// in the <a>CreateResourceGroup</a> action.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
    /// <p>The time at which resource group is created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl ResourceGroup {
    /// <p>The ARN of the resource group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The tags (key and value pairs) of the resource group. This data type property is used
    /// in the <a>CreateResourceGroup</a> action.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::ResourceGroupTag]> {
        self.tags.as_deref()
    }
    /// <p>The time at which resource group is created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for ResourceGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceGroup");
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`ResourceGroup`](crate::model::ResourceGroup)
pub mod resource_group {
    /// A builder for [`ResourceGroup`](crate::model::ResourceGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the resource group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags (key and value pairs) of the resource group. This data type property is used
        /// in the <a>CreateResourceGroup</a> action.</p>
        pub fn tags(mut self, input: impl Into<crate::model::ResourceGroupTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags (key and value pairs) of the resource group. This data type property is used
        /// in the <a>CreateResourceGroup</a> action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The time at which resource group is created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which resource group is created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceGroup`](crate::model::ResourceGroup)
        pub fn build(self) -> crate::model::ResourceGroup {
            crate::model::ResourceGroup {
                arn: self.arn,
                tags: self.tags,
                created_at: self.created_at,
            }
        }
    }
}
impl ResourceGroup {
    /// Creates a new builder-style object to manufacture [`ResourceGroup`](crate::model::ResourceGroup)
    pub fn builder() -> crate::model::resource_group::Builder {
        crate::model::resource_group::Builder::default()
    }
}

/// <p>This data type is used as one of the elements of the <a>ResourceGroup</a>
/// data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceGroupTag {
    /// <p>A tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value assigned to a tag key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ResourceGroupTag {
    /// <p>A tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value assigned to a tag key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ResourceGroupTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceGroupTag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ResourceGroupTag`](crate::model::ResourceGroupTag)
pub mod resource_group_tag {
    /// A builder for [`ResourceGroupTag`](crate::model::ResourceGroupTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value assigned to a tag key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value assigned to a tag key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceGroupTag`](crate::model::ResourceGroupTag)
        pub fn build(self) -> crate::model::ResourceGroupTag {
            crate::model::ResourceGroupTag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ResourceGroupTag {
    /// Creates a new builder-style object to manufacture [`ResourceGroupTag`](crate::model::ResourceGroupTag)
    pub fn builder() -> crate::model::resource_group_tag::Builder {
        crate::model::resource_group_tag::Builder::default()
    }
}

/// <p>Contains information about an Amazon Inspector finding. This data type is used as the
/// response element in the <a>DescribeFindings</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Finding {
    /// <p>The ARN that specifies the finding.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The schema version of this data type.</p>
    pub schema_version: i32,
    /// <p>The data element is set to "Inspector".</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>This data type is used in the <a>Finding</a> data type.</p>
    pub service_attributes: std::option::Option<crate::model::InspectorServiceAttributes>,
    /// <p>The type of the host from which the finding is generated.</p>
    pub asset_type: std::option::Option<crate::model::AssetType>,
    /// <p>A collection of attributes of the host from which the finding is generated.</p>
    pub asset_attributes: std::option::Option<crate::model::AssetAttributes>,
    /// <p>The ID of the finding.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the finding.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The description of the finding.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The recommendation for the finding.</p>
    pub recommendation: std::option::Option<std::string::String>,
    /// <p>The finding severity. Values can be set to High, Medium, Low, and
    /// Informational.</p>
    pub severity: std::option::Option<crate::model::Severity>,
    /// <p>The numeric value of the finding severity.</p>
    pub numeric_severity: f64,
    /// <p>This data element is currently not used.</p>
    pub confidence: i32,
    /// <p>This data element is currently not used.</p>
    pub indicator_of_compromise: std::option::Option<bool>,
    /// <p>The system-defined attributes for the finding.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The user-defined attributes that are assigned to the finding.</p>
    pub user_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The time when the finding was generated.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when <a>AddAttributesToFindings</a> is called.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl Finding {
    /// <p>The ARN that specifies the finding.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The schema version of this data type.</p>
    pub fn schema_version(&self) -> i32 {
        self.schema_version
    }
    /// <p>The data element is set to "Inspector".</p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p>This data type is used in the <a>Finding</a> data type.</p>
    pub fn service_attributes(
        &self,
    ) -> std::option::Option<&crate::model::InspectorServiceAttributes> {
        self.service_attributes.as_ref()
    }
    /// <p>The type of the host from which the finding is generated.</p>
    pub fn asset_type(&self) -> std::option::Option<&crate::model::AssetType> {
        self.asset_type.as_ref()
    }
    /// <p>A collection of attributes of the host from which the finding is generated.</p>
    pub fn asset_attributes(&self) -> std::option::Option<&crate::model::AssetAttributes> {
        self.asset_attributes.as_ref()
    }
    /// <p>The ID of the finding.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The name of the finding.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The description of the finding.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The recommendation for the finding.</p>
    pub fn recommendation(&self) -> std::option::Option<&str> {
        self.recommendation.as_deref()
    }
    /// <p>The finding severity. Values can be set to High, Medium, Low, and
    /// Informational.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::Severity> {
        self.severity.as_ref()
    }
    /// <p>The numeric value of the finding severity.</p>
    pub fn numeric_severity(&self) -> f64 {
        self.numeric_severity
    }
    /// <p>This data element is currently not used.</p>
    pub fn confidence(&self) -> i32 {
        self.confidence
    }
    /// <p>This data element is currently not used.</p>
    pub fn indicator_of_compromise(&self) -> std::option::Option<bool> {
        self.indicator_of_compromise
    }
    /// <p>The system-defined attributes for the finding.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
    /// <p>The user-defined attributes that are assigned to the finding.</p>
    pub fn user_attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.user_attributes.as_deref()
    }
    /// <p>The time when the finding was generated.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when <a>AddAttributesToFindings</a> is called.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for Finding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Finding");
        formatter.field("arn", &self.arn);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("service", &self.service);
        formatter.field("service_attributes", &self.service_attributes);
        formatter.field("asset_type", &self.asset_type);
        formatter.field("asset_attributes", &self.asset_attributes);
        formatter.field("id", &self.id);
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("recommendation", &self.recommendation);
        formatter.field("severity", &self.severity);
        formatter.field("numeric_severity", &self.numeric_severity);
        formatter.field("confidence", &self.confidence);
        formatter.field("indicator_of_compromise", &self.indicator_of_compromise);
        formatter.field("attributes", &self.attributes);
        formatter.field("user_attributes", &self.user_attributes);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Finding`](crate::model::Finding)
pub mod finding {
    /// A builder for [`Finding`](crate::model::Finding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<i32>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) service_attributes:
            std::option::Option<crate::model::InspectorServiceAttributes>,
        pub(crate) asset_type: std::option::Option<crate::model::AssetType>,
        pub(crate) asset_attributes: std::option::Option<crate::model::AssetAttributes>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommendation: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::Severity>,
        pub(crate) numeric_severity: std::option::Option<f64>,
        pub(crate) confidence: std::option::Option<i32>,
        pub(crate) indicator_of_compromise: std::option::Option<bool>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) user_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN that specifies the finding.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the finding.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The schema version of this data type.</p>
        pub fn schema_version(mut self, input: i32) -> Self {
            self.schema_version = Some(input);
            self
        }
        /// <p>The schema version of this data type.</p>
        pub fn set_schema_version(mut self, input: std::option::Option<i32>) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The data element is set to "Inspector".</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The data element is set to "Inspector".</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>This data type is used in the <a>Finding</a> data type.</p>
        pub fn service_attributes(
            mut self,
            input: crate::model::InspectorServiceAttributes,
        ) -> Self {
            self.service_attributes = Some(input);
            self
        }
        /// <p>This data type is used in the <a>Finding</a> data type.</p>
        pub fn set_service_attributes(
            mut self,
            input: std::option::Option<crate::model::InspectorServiceAttributes>,
        ) -> Self {
            self.service_attributes = input;
            self
        }
        /// <p>The type of the host from which the finding is generated.</p>
        pub fn asset_type(mut self, input: crate::model::AssetType) -> Self {
            self.asset_type = Some(input);
            self
        }
        /// <p>The type of the host from which the finding is generated.</p>
        pub fn set_asset_type(
            mut self,
            input: std::option::Option<crate::model::AssetType>,
        ) -> Self {
            self.asset_type = input;
            self
        }
        /// <p>A collection of attributes of the host from which the finding is generated.</p>
        pub fn asset_attributes(mut self, input: crate::model::AssetAttributes) -> Self {
            self.asset_attributes = Some(input);
            self
        }
        /// <p>A collection of attributes of the host from which the finding is generated.</p>
        pub fn set_asset_attributes(
            mut self,
            input: std::option::Option<crate::model::AssetAttributes>,
        ) -> Self {
            self.asset_attributes = input;
            self
        }
        /// <p>The ID of the finding.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the finding.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the finding.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The name of the finding.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The description of the finding.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the finding.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The recommendation for the finding.</p>
        pub fn recommendation(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation = Some(input.into());
            self
        }
        /// <p>The recommendation for the finding.</p>
        pub fn set_recommendation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation = input;
            self
        }
        /// <p>The finding severity. Values can be set to High, Medium, Low, and
        /// Informational.</p>
        pub fn severity(mut self, input: crate::model::Severity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The finding severity. Values can be set to High, Medium, Low, and
        /// Informational.</p>
        pub fn set_severity(mut self, input: std::option::Option<crate::model::Severity>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The numeric value of the finding severity.</p>
        pub fn numeric_severity(mut self, input: f64) -> Self {
            self.numeric_severity = Some(input);
            self
        }
        /// <p>The numeric value of the finding severity.</p>
        pub fn set_numeric_severity(mut self, input: std::option::Option<f64>) -> Self {
            self.numeric_severity = input;
            self
        }
        /// <p>This data element is currently not used.</p>
        pub fn confidence(mut self, input: i32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>This data element is currently not used.</p>
        pub fn set_confidence(mut self, input: std::option::Option<i32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>This data element is currently not used.</p>
        pub fn indicator_of_compromise(mut self, input: bool) -> Self {
            self.indicator_of_compromise = Some(input);
            self
        }
        /// <p>This data element is currently not used.</p>
        pub fn set_indicator_of_compromise(mut self, input: std::option::Option<bool>) -> Self {
            self.indicator_of_compromise = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The system-defined attributes for the finding.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The system-defined attributes for the finding.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `user_attributes`.
        ///
        /// To override the contents of this collection use [`set_user_attributes`](Self::set_user_attributes).
        ///
        /// <p>The user-defined attributes that are assigned to the finding.</p>
        pub fn user_attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.user_attributes.unwrap_or_default();
            v.push(input.into());
            self.user_attributes = Some(v);
            self
        }
        /// <p>The user-defined attributes that are assigned to the finding.</p>
        pub fn set_user_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.user_attributes = input;
            self
        }
        /// <p>The time when the finding was generated.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the finding was generated.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when <a>AddAttributesToFindings</a> is called.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time when <a>AddAttributesToFindings</a> is called.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Finding`](crate::model::Finding)
        pub fn build(self) -> crate::model::Finding {
            crate::model::Finding {
                arn: self.arn,
                schema_version: self.schema_version.unwrap_or_default(),
                service: self.service,
                service_attributes: self.service_attributes,
                asset_type: self.asset_type,
                asset_attributes: self.asset_attributes,
                id: self.id,
                title: self.title,
                description: self.description,
                recommendation: self.recommendation,
                severity: self.severity,
                numeric_severity: self.numeric_severity.unwrap_or_default(),
                confidence: self.confidence.unwrap_or_default(),
                indicator_of_compromise: self.indicator_of_compromise,
                attributes: self.attributes,
                user_attributes: self.user_attributes,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Finding {
    /// Creates a new builder-style object to manufacture [`Finding`](crate::model::Finding)
    pub fn builder() -> crate::model::finding::Builder {
        crate::model::finding::Builder::default()
    }
}

/// <p>A collection of attributes of the host from which the finding is generated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetAttributes {
    /// <p>The schema version of this data type.</p>
    pub schema_version: i32,
    /// <p>The ID of the agent that is installed on the EC2 instance where the finding is
    /// generated.</p>
    pub agent_id: std::option::Option<std::string::String>,
    /// <p>The Auto Scaling group of the EC2 instance where the finding is generated.</p>
    pub auto_scaling_group: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where
    /// the finding is generated.</p>
    pub ami_id: std::option::Option<std::string::String>,
    /// <p>The hostname of the EC2 instance where the finding is generated.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The list of IP v4 addresses of the EC2 instance where the finding is
    /// generated.</p>
    pub ipv4_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags related to the EC2 instance where the finding is generated.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>An array of the network interfaces interacting with the EC2 instance where the
    /// finding is generated.</p>
    pub network_interfaces: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
}
impl AssetAttributes {
    /// <p>The schema version of this data type.</p>
    pub fn schema_version(&self) -> i32 {
        self.schema_version
    }
    /// <p>The ID of the agent that is installed on the EC2 instance where the finding is
    /// generated.</p>
    pub fn agent_id(&self) -> std::option::Option<&str> {
        self.agent_id.as_deref()
    }
    /// <p>The Auto Scaling group of the EC2 instance where the finding is generated.</p>
    pub fn auto_scaling_group(&self) -> std::option::Option<&str> {
        self.auto_scaling_group.as_deref()
    }
    /// <p>The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where
    /// the finding is generated.</p>
    pub fn ami_id(&self) -> std::option::Option<&str> {
        self.ami_id.as_deref()
    }
    /// <p>The hostname of the EC2 instance where the finding is generated.</p>
    pub fn hostname(&self) -> std::option::Option<&str> {
        self.hostname.as_deref()
    }
    /// <p>The list of IP v4 addresses of the EC2 instance where the finding is
    /// generated.</p>
    pub fn ipv4_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ipv4_addresses.as_deref()
    }
    /// <p>The tags related to the EC2 instance where the finding is generated.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>An array of the network interfaces interacting with the EC2 instance where the
    /// finding is generated.</p>
    pub fn network_interfaces(&self) -> std::option::Option<&[crate::model::NetworkInterface]> {
        self.network_interfaces.as_deref()
    }
}
impl std::fmt::Debug for AssetAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetAttributes");
        formatter.field("schema_version", &self.schema_version);
        formatter.field("agent_id", &self.agent_id);
        formatter.field("auto_scaling_group", &self.auto_scaling_group);
        formatter.field("ami_id", &self.ami_id);
        formatter.field("hostname", &self.hostname);
        formatter.field("ipv4_addresses", &self.ipv4_addresses);
        formatter.field("tags", &self.tags);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.finish()
    }
}
/// See [`AssetAttributes`](crate::model::AssetAttributes)
pub mod asset_attributes {
    /// A builder for [`AssetAttributes`](crate::model::AssetAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_version: std::option::Option<i32>,
        pub(crate) agent_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group: std::option::Option<std::string::String>,
        pub(crate) ami_id: std::option::Option<std::string::String>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) ipv4_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    }
    impl Builder {
        /// <p>The schema version of this data type.</p>
        pub fn schema_version(mut self, input: i32) -> Self {
            self.schema_version = Some(input);
            self
        }
        /// <p>The schema version of this data type.</p>
        pub fn set_schema_version(mut self, input: std::option::Option<i32>) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The ID of the agent that is installed on the EC2 instance where the finding is
        /// generated.</p>
        pub fn agent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_id = Some(input.into());
            self
        }
        /// <p>The ID of the agent that is installed on the EC2 instance where the finding is
        /// generated.</p>
        pub fn set_agent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_id = input;
            self
        }
        /// <p>The Auto Scaling group of the EC2 instance where the finding is generated.</p>
        pub fn auto_scaling_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group = Some(input.into());
            self
        }
        /// <p>The Auto Scaling group of the EC2 instance where the finding is generated.</p>
        pub fn set_auto_scaling_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group = input;
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where
        /// the finding is generated.</p>
        pub fn ami_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where
        /// the finding is generated.</p>
        pub fn set_ami_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ami_id = input;
            self
        }
        /// <p>The hostname of the EC2 instance where the finding is generated.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The hostname of the EC2 instance where the finding is generated.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// Appends an item to `ipv4_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv4_addresses`](Self::set_ipv4_addresses).
        ///
        /// <p>The list of IP v4 addresses of the EC2 instance where the finding is
        /// generated.</p>
        pub fn ipv4_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv4_addresses.unwrap_or_default();
            v.push(input.into());
            self.ipv4_addresses = Some(v);
            self
        }
        /// <p>The list of IP v4 addresses of the EC2 instance where the finding is
        /// generated.</p>
        pub fn set_ipv4_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv4_addresses = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags related to the EC2 instance where the finding is generated.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags related to the EC2 instance where the finding is generated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>An array of the network interfaces interacting with the EC2 instance where the
        /// finding is generated.</p>
        pub fn network_interfaces(
            mut self,
            input: impl Into<crate::model::NetworkInterface>,
        ) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input.into());
            self.network_interfaces = Some(v);
            self
        }
        /// <p>An array of the network interfaces interacting with the EC2 instance where the
        /// finding is generated.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetAttributes`](crate::model::AssetAttributes)
        pub fn build(self) -> crate::model::AssetAttributes {
            crate::model::AssetAttributes {
                schema_version: self.schema_version.unwrap_or_default(),
                agent_id: self.agent_id,
                auto_scaling_group: self.auto_scaling_group,
                ami_id: self.ami_id,
                hostname: self.hostname,
                ipv4_addresses: self.ipv4_addresses,
                tags: self.tags,
                network_interfaces: self.network_interfaces,
            }
        }
    }
}
impl AssetAttributes {
    /// Creates a new builder-style object to manufacture [`AssetAttributes`](crate::model::AssetAttributes)
    pub fn builder() -> crate::model::asset_attributes::Builder {
        crate::model::asset_attributes::Builder::default()
    }
}

/// <p>Contains information about the network interfaces interacting with an EC2 instance.
/// This data type is used as one of the elements of the <a>AssetAttributes</a> data
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The ID of a subnet associated with the network interface.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The ID of a VPC associated with the network interface.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The name of a private DNS associated with the network interface.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The private IP address associated with the network interface.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>A list of the private IP addresses associated with the network interface. Includes
    /// the privateDnsName and privateIpAddress.</p>
    pub private_ip_addresses: std::option::Option<std::vec::Vec<crate::model::PrivateIp>>,
    /// <p>The name of a public DNS associated with the network interface.</p>
    pub public_dns_name: std::option::Option<std::string::String>,
    /// <p>The public IP address from which the network interface is reachable.</p>
    pub public_ip: std::option::Option<std::string::String>,
    /// <p>The IP addresses associated with the network interface.</p>
    pub ipv6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of the security groups associated with the network interface. Includes the
    /// groupId and groupName.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroup>>,
}
impl NetworkInterface {
    /// <p>The ID of the network interface.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>The ID of a subnet associated with the network interface.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The ID of a VPC associated with the network interface.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The name of a private DNS associated with the network interface.</p>
    pub fn private_dns_name(&self) -> std::option::Option<&str> {
        self.private_dns_name.as_deref()
    }
    /// <p>The private IP address associated with the network interface.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>A list of the private IP addresses associated with the network interface. Includes
    /// the privateDnsName and privateIpAddress.</p>
    pub fn private_ip_addresses(&self) -> std::option::Option<&[crate::model::PrivateIp]> {
        self.private_ip_addresses.as_deref()
    }
    /// <p>The name of a public DNS associated with the network interface.</p>
    pub fn public_dns_name(&self) -> std::option::Option<&str> {
        self.public_dns_name.as_deref()
    }
    /// <p>The public IP address from which the network interface is reachable.</p>
    pub fn public_ip(&self) -> std::option::Option<&str> {
        self.public_ip.as_deref()
    }
    /// <p>The IP addresses associated with the network interface.</p>
    pub fn ipv6_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ipv6_addresses.as_deref()
    }
    /// <p>A list of the security groups associated with the network interface. Includes the
    /// groupId and groupName.</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::SecurityGroup]> {
        self.security_groups.as_deref()
    }
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("private_ip_addresses", &self.private_ip_addresses);
        formatter.field("public_dns_name", &self.public_dns_name);
        formatter.field("public_ip", &self.public_ip);
        formatter.field("ipv6_addresses", &self.ipv6_addresses);
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) private_ip_addresses:
            std::option::Option<std::vec::Vec<crate::model::PrivateIp>>,
        pub(crate) public_dns_name: std::option::Option<std::string::String>,
        pub(crate) public_ip: std::option::Option<std::string::String>,
        pub(crate) ipv6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroup>>,
    }
    impl Builder {
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The ID of a subnet associated with the network interface.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of a subnet associated with the network interface.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The ID of a VPC associated with the network interface.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of a VPC associated with the network interface.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The name of a private DNS associated with the network interface.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The name of a private DNS associated with the network interface.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The private IP address associated with the network interface.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address associated with the network interface.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Appends an item to `private_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>A list of the private IP addresses associated with the network interface. Includes
        /// the privateDnsName and privateIpAddress.</p>
        pub fn private_ip_addresses(mut self, input: impl Into<crate::model::PrivateIp>) -> Self {
            let mut v = self.private_ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.private_ip_addresses = Some(v);
            self
        }
        /// <p>A list of the private IP addresses associated with the network interface. Includes
        /// the privateDnsName and privateIpAddress.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrivateIp>>,
        ) -> Self {
            self.private_ip_addresses = input;
            self
        }
        /// <p>The name of a public DNS associated with the network interface.</p>
        pub fn public_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_dns_name = Some(input.into());
            self
        }
        /// <p>The name of a public DNS associated with the network interface.</p>
        pub fn set_public_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_dns_name = input;
            self
        }
        /// <p>The public IP address from which the network interface is reachable.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>The public IP address from which the network interface is reachable.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>The IP addresses associated with the network interface.</p>
        pub fn ipv6_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input.into());
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>The IP addresses associated with the network interface.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list of the security groups associated with the network interface. Includes the
        /// groupId and groupName.</p>
        pub fn security_groups(mut self, input: impl Into<crate::model::SecurityGroup>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list of the security groups associated with the network interface. Includes the
        /// groupId and groupName.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityGroup>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                network_interface_id: self.network_interface_id,
                subnet_id: self.subnet_id,
                vpc_id: self.vpc_id,
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
                private_ip_addresses: self.private_ip_addresses,
                public_dns_name: self.public_dns_name,
                public_ip: self.public_ip,
                ipv6_addresses: self.ipv6_addresses,
                security_groups: self.security_groups,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>Contains information about a security group associated with a network interface. This
/// data type is used as one of the elements of the <a>NetworkInterface</a> data
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroup {
    /// <p>The name of the security group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The ID of the security group.</p>
    pub group_id: std::option::Option<std::string::String>,
}
impl SecurityGroup {
    /// <p>The name of the security group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The ID of the security group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroup");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}
/// See [`SecurityGroup`](crate::model::SecurityGroup)
pub mod security_group {
    /// A builder for [`SecurityGroup`](crate::model::SecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the security group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the security group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroup`](crate::model::SecurityGroup)
        pub fn build(self) -> crate::model::SecurityGroup {
            crate::model::SecurityGroup {
                group_name: self.group_name,
                group_id: self.group_id,
            }
        }
    }
}
impl SecurityGroup {
    /// Creates a new builder-style object to manufacture [`SecurityGroup`](crate::model::SecurityGroup)
    pub fn builder() -> crate::model::security_group::Builder {
        crate::model::security_group::Builder::default()
    }
}

/// <p>Contains information about a private IP address associated with a network interface. This
/// data type is used as a response element in the <a>DescribeFindings</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateIp {
    /// <p>The DNS name of the private IP address.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The full IP address of the network inteface.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
}
impl PrivateIp {
    /// <p>The DNS name of the private IP address.</p>
    pub fn private_dns_name(&self) -> std::option::Option<&str> {
        self.private_dns_name.as_deref()
    }
    /// <p>The full IP address of the network inteface.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
}
impl std::fmt::Debug for PrivateIp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateIp");
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.finish()
    }
}
/// See [`PrivateIp`](crate::model::PrivateIp)
pub mod private_ip {
    /// A builder for [`PrivateIp`](crate::model::PrivateIp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DNS name of the private IP address.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name of the private IP address.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The full IP address of the network inteface.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The full IP address of the network inteface.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateIp`](crate::model::PrivateIp)
        pub fn build(self) -> crate::model::PrivateIp {
            crate::model::PrivateIp {
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
            }
        }
    }
}
impl PrivateIp {
    /// Creates a new builder-style object to manufacture [`PrivateIp`](crate::model::PrivateIp)
    pub fn builder() -> crate::model::private_ip::Builder {
        crate::model::private_ip::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssetType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2Instance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssetType {
    fn from(s: &str) -> Self {
        match s {
            "ec2-instance" => AssetType::Ec2Instance,
            other => AssetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssetType::from(s))
    }
}
impl AssetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssetType::Ec2Instance => "ec2-instance",
            AssetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ec2-instance"]
    }
}
impl AsRef<str> for AssetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This data type is used in the <a>Finding</a> data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InspectorServiceAttributes {
    /// <p>The schema version of this data type.</p>
    pub schema_version: i32,
    /// <p>The ARN of the assessment run during which the finding is generated.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the rules package that is used to generate the finding.</p>
    pub rules_package_arn: std::option::Option<std::string::String>,
}
impl InspectorServiceAttributes {
    /// <p>The schema version of this data type.</p>
    pub fn schema_version(&self) -> i32 {
        self.schema_version
    }
    /// <p>The ARN of the assessment run during which the finding is generated.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
    /// <p>The ARN of the rules package that is used to generate the finding.</p>
    pub fn rules_package_arn(&self) -> std::option::Option<&str> {
        self.rules_package_arn.as_deref()
    }
}
impl std::fmt::Debug for InspectorServiceAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InspectorServiceAttributes");
        formatter.field("schema_version", &self.schema_version);
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.field("rules_package_arn", &self.rules_package_arn);
        formatter.finish()
    }
}
/// See [`InspectorServiceAttributes`](crate::model::InspectorServiceAttributes)
pub mod inspector_service_attributes {
    /// A builder for [`InspectorServiceAttributes`](crate::model::InspectorServiceAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_version: std::option::Option<i32>,
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) rules_package_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The schema version of this data type.</p>
        pub fn schema_version(mut self, input: i32) -> Self {
            self.schema_version = Some(input);
            self
        }
        /// <p>The schema version of this data type.</p>
        pub fn set_schema_version(mut self, input: std::option::Option<i32>) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The ARN of the assessment run during which the finding is generated.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment run during which the finding is generated.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// <p>The ARN of the rules package that is used to generate the finding.</p>
        pub fn rules_package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.rules_package_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the rules package that is used to generate the finding.</p>
        pub fn set_rules_package_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rules_package_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`InspectorServiceAttributes`](crate::model::InspectorServiceAttributes)
        pub fn build(self) -> crate::model::InspectorServiceAttributes {
            crate::model::InspectorServiceAttributes {
                schema_version: self.schema_version.unwrap_or_default(),
                assessment_run_arn: self.assessment_run_arn,
                rules_package_arn: self.rules_package_arn,
            }
        }
    }
}
impl InspectorServiceAttributes {
    /// Creates a new builder-style object to manufacture [`InspectorServiceAttributes`](crate::model::InspectorServiceAttributes)
    pub fn builder() -> crate::model::inspector_service_attributes::Builder {
        crate::model::inspector_service_attributes::Builder::default()
    }
}

/// <p>Contains information about what was excluded from an assessment run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Exclusion {
    /// <p>The ARN that specifies the exclusion.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the exclusion.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The description of the exclusion.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The recommendation for the exclusion.</p>
    pub recommendation: std::option::Option<std::string::String>,
    /// <p>The AWS resources for which the exclusion pertains.</p>
    pub scopes: std::option::Option<std::vec::Vec<crate::model::Scope>>,
    /// <p>The system-defined attributes for the exclusion.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl Exclusion {
    /// <p>The ARN that specifies the exclusion.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the exclusion.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The description of the exclusion.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The recommendation for the exclusion.</p>
    pub fn recommendation(&self) -> std::option::Option<&str> {
        self.recommendation.as_deref()
    }
    /// <p>The AWS resources for which the exclusion pertains.</p>
    pub fn scopes(&self) -> std::option::Option<&[crate::model::Scope]> {
        self.scopes.as_deref()
    }
    /// <p>The system-defined attributes for the exclusion.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for Exclusion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Exclusion");
        formatter.field("arn", &self.arn);
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("recommendation", &self.recommendation);
        formatter.field("scopes", &self.scopes);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`Exclusion`](crate::model::Exclusion)
pub mod exclusion {
    /// A builder for [`Exclusion`](crate::model::Exclusion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommendation: std::option::Option<std::string::String>,
        pub(crate) scopes: std::option::Option<std::vec::Vec<crate::model::Scope>>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// <p>The ARN that specifies the exclusion.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the exclusion.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the exclusion.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The name of the exclusion.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The description of the exclusion.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the exclusion.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The recommendation for the exclusion.</p>
        pub fn recommendation(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation = Some(input.into());
            self
        }
        /// <p>The recommendation for the exclusion.</p>
        pub fn set_recommendation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation = input;
            self
        }
        /// Appends an item to `scopes`.
        ///
        /// To override the contents of this collection use [`set_scopes`](Self::set_scopes).
        ///
        /// <p>The AWS resources for which the exclusion pertains.</p>
        pub fn scopes(mut self, input: impl Into<crate::model::Scope>) -> Self {
            let mut v = self.scopes.unwrap_or_default();
            v.push(input.into());
            self.scopes = Some(v);
            self
        }
        /// <p>The AWS resources for which the exclusion pertains.</p>
        pub fn set_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Scope>>,
        ) -> Self {
            self.scopes = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The system-defined attributes for the exclusion.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The system-defined attributes for the exclusion.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Exclusion`](crate::model::Exclusion)
        pub fn build(self) -> crate::model::Exclusion {
            crate::model::Exclusion {
                arn: self.arn,
                title: self.title,
                description: self.description,
                recommendation: self.recommendation,
                scopes: self.scopes,
                attributes: self.attributes,
            }
        }
    }
}
impl Exclusion {
    /// Creates a new builder-style object to manufacture [`Exclusion`](crate::model::Exclusion)
    pub fn builder() -> crate::model::exclusion::Builder {
        crate::model::exclusion::Builder::default()
    }
}

/// <p>Contains information about an Amazon Inspector assessment template. This data type is
/// used as the response element in the <a>DescribeAssessmentTemplates</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentTemplate {
    /// <p>The ARN of the assessment template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the assessment template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the assessment target that corresponds to this assessment
    /// template.</p>
    pub assessment_target_arn: std::option::Option<std::string::String>,
    /// <p>The duration in seconds specified for this assessment template. The default value is
    /// 3600 seconds (one hour). The maximum value is 86400 seconds (one day).</p>
    pub duration_in_seconds: i32,
    /// <p>The rules packages that are specified for this assessment template.</p>
    pub rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user-defined attributes that are assigned to every generated finding from the
    /// assessment run that uses this assessment template.</p>
    pub user_attributes_for_findings: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The Amazon Resource Name (ARN) of the most recent assessment run associated with this
    /// assessment template. This value exists only when the value of assessmentRunCount is
    /// greaterpa than zero.</p>
    pub last_assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>The number of existing assessment runs associated with this assessment template. This
    /// value can be zero or a positive integer.</p>
    pub assessment_run_count: std::option::Option<i32>,
    /// <p>The time at which the assessment template is created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl AssessmentTemplate {
    /// <p>The ARN of the assessment template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the assessment template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the assessment target that corresponds to this assessment
    /// template.</p>
    pub fn assessment_target_arn(&self) -> std::option::Option<&str> {
        self.assessment_target_arn.as_deref()
    }
    /// <p>The duration in seconds specified for this assessment template. The default value is
    /// 3600 seconds (one hour). The maximum value is 86400 seconds (one day).</p>
    pub fn duration_in_seconds(&self) -> i32 {
        self.duration_in_seconds
    }
    /// <p>The rules packages that are specified for this assessment template.</p>
    pub fn rules_package_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rules_package_arns.as_deref()
    }
    /// <p>The user-defined attributes that are assigned to every generated finding from the
    /// assessment run that uses this assessment template.</p>
    pub fn user_attributes_for_findings(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.user_attributes_for_findings.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the most recent assessment run associated with this
    /// assessment template. This value exists only when the value of assessmentRunCount is
    /// greaterpa than zero.</p>
    pub fn last_assessment_run_arn(&self) -> std::option::Option<&str> {
        self.last_assessment_run_arn.as_deref()
    }
    /// <p>The number of existing assessment runs associated with this assessment template. This
    /// value can be zero or a positive integer.</p>
    pub fn assessment_run_count(&self) -> std::option::Option<i32> {
        self.assessment_run_count
    }
    /// <p>The time at which the assessment template is created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for AssessmentTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentTemplate");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("assessment_target_arn", &self.assessment_target_arn);
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.field("rules_package_arns", &self.rules_package_arns);
        formatter.field(
            "user_attributes_for_findings",
            &self.user_attributes_for_findings,
        );
        formatter.field("last_assessment_run_arn", &self.last_assessment_run_arn);
        formatter.field("assessment_run_count", &self.assessment_run_count);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`AssessmentTemplate`](crate::model::AssessmentTemplate)
pub mod assessment_template {
    /// A builder for [`AssessmentTemplate`](crate::model::AssessmentTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) assessment_target_arn: std::option::Option<std::string::String>,
        pub(crate) duration_in_seconds: std::option::Option<i32>,
        pub(crate) rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_attributes_for_findings:
            std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) last_assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_run_count: std::option::Option<i32>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN of the assessment template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the assessment template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the assessment template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the assessment target that corresponds to this assessment
        /// template.</p>
        pub fn assessment_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment target that corresponds to this assessment
        /// template.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_target_arn = input;
            self
        }
        /// <p>The duration in seconds specified for this assessment template. The default value is
        /// 3600 seconds (one hour). The maximum value is 86400 seconds (one day).</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>The duration in seconds specified for this assessment template. The default value is
        /// 3600 seconds (one hour). The maximum value is 86400 seconds (one day).</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Appends an item to `rules_package_arns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The rules packages that are specified for this assessment template.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rules_package_arns.unwrap_or_default();
            v.push(input.into());
            self.rules_package_arns = Some(v);
            self
        }
        /// <p>The rules packages that are specified for this assessment template.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rules_package_arns = input;
            self
        }
        /// Appends an item to `user_attributes_for_findings`.
        ///
        /// To override the contents of this collection use [`set_user_attributes_for_findings`](Self::set_user_attributes_for_findings).
        ///
        /// <p>The user-defined attributes that are assigned to every generated finding from the
        /// assessment run that uses this assessment template.</p>
        pub fn user_attributes_for_findings(
            mut self,
            input: impl Into<crate::model::Attribute>,
        ) -> Self {
            let mut v = self.user_attributes_for_findings.unwrap_or_default();
            v.push(input.into());
            self.user_attributes_for_findings = Some(v);
            self
        }
        /// <p>The user-defined attributes that are assigned to every generated finding from the
        /// assessment run that uses this assessment template.</p>
        pub fn set_user_attributes_for_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.user_attributes_for_findings = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the most recent assessment run associated with this
        /// assessment template. This value exists only when the value of assessmentRunCount is
        /// greaterpa than zero.</p>
        pub fn last_assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the most recent assessment run associated with this
        /// assessment template. This value exists only when the value of assessmentRunCount is
        /// greaterpa than zero.</p>
        pub fn set_last_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_assessment_run_arn = input;
            self
        }
        /// <p>The number of existing assessment runs associated with this assessment template. This
        /// value can be zero or a positive integer.</p>
        pub fn assessment_run_count(mut self, input: i32) -> Self {
            self.assessment_run_count = Some(input);
            self
        }
        /// <p>The number of existing assessment runs associated with this assessment template. This
        /// value can be zero or a positive integer.</p>
        pub fn set_assessment_run_count(mut self, input: std::option::Option<i32>) -> Self {
            self.assessment_run_count = input;
            self
        }
        /// <p>The time at which the assessment template is created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the assessment template is created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentTemplate`](crate::model::AssessmentTemplate)
        pub fn build(self) -> crate::model::AssessmentTemplate {
            crate::model::AssessmentTemplate {
                arn: self.arn,
                name: self.name,
                assessment_target_arn: self.assessment_target_arn,
                duration_in_seconds: self.duration_in_seconds.unwrap_or_default(),
                rules_package_arns: self.rules_package_arns,
                user_attributes_for_findings: self.user_attributes_for_findings,
                last_assessment_run_arn: self.last_assessment_run_arn,
                assessment_run_count: self.assessment_run_count,
                created_at: self.created_at,
            }
        }
    }
}
impl AssessmentTemplate {
    /// Creates a new builder-style object to manufacture [`AssessmentTemplate`](crate::model::AssessmentTemplate)
    pub fn builder() -> crate::model::assessment_template::Builder {
        crate::model::assessment_template::Builder::default()
    }
}

/// <p>Contains information about an Amazon Inspector application. This data type is used as
/// the response element in the <a>DescribeAssessmentTargets</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentTarget {
    /// <p>The ARN that specifies the Amazon Inspector assessment target.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Inspector assessment target.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN that specifies the resource group that is associated with the assessment
    /// target.</p>
    pub resource_group_arn: std::option::Option<std::string::String>,
    /// <p>The time at which the assessment target is created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which <a>UpdateAssessmentTarget</a> is called.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl AssessmentTarget {
    /// <p>The ARN that specifies the Amazon Inspector assessment target.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the Amazon Inspector assessment target.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN that specifies the resource group that is associated with the assessment
    /// target.</p>
    pub fn resource_group_arn(&self) -> std::option::Option<&str> {
        self.resource_group_arn.as_deref()
    }
    /// <p>The time at which the assessment target is created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time at which <a>UpdateAssessmentTarget</a> is called.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for AssessmentTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentTarget");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("resource_group_arn", &self.resource_group_arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`AssessmentTarget`](crate::model::AssessmentTarget)
pub mod assessment_target {
    /// A builder for [`AssessmentTarget`](crate::model::AssessmentTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_group_arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ARN that specifies the Amazon Inspector assessment target.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the Amazon Inspector assessment target.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the Amazon Inspector assessment target.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Inspector assessment target.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN that specifies the resource group that is associated with the assessment
        /// target.</p>
        pub fn resource_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the resource group that is associated with the assessment
        /// target.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_arn = input;
            self
        }
        /// <p>The time at which the assessment target is created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the assessment target is created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which <a>UpdateAssessmentTarget</a> is called.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time at which <a>UpdateAssessmentTarget</a> is called.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentTarget`](crate::model::AssessmentTarget)
        pub fn build(self) -> crate::model::AssessmentTarget {
            crate::model::AssessmentTarget {
                arn: self.arn,
                name: self.name,
                resource_group_arn: self.resource_group_arn,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl AssessmentTarget {
    /// Creates a new builder-style object to manufacture [`AssessmentTarget`](crate::model::AssessmentTarget)
    pub fn builder() -> crate::model::assessment_target::Builder {
        crate::model::assessment_target::Builder::default()
    }
}

/// <p>A snapshot of an Amazon Inspector assessment run that contains the findings of the
/// assessment run .</p>
/// <p>Used as the response element in the <a>DescribeAssessmentRuns</a>
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentRun {
    /// <p>The ARN of the assessment run.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The auto-generated name for the assessment run.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the assessment template that is associated with the assessment
    /// run.</p>
    pub assessment_template_arn: std::option::Option<std::string::String>,
    /// <p>The state of the assessment run.</p>
    pub state: std::option::Option<crate::model::AssessmentRunState>,
    /// <p>The duration of the assessment run.</p>
    pub duration_in_seconds: i32,
    /// <p>The rules packages selected for the assessment run.</p>
    pub rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user-defined attributes that are assigned to every generated finding.</p>
    pub user_attributes_for_findings: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
    pub started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The assessment run completion time that corresponds to the rules packages evaluation
    /// completion time or failure.</p>
    pub completed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when the assessment run's state changed.</p>
    pub state_changed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A Boolean value (true or false) that specifies whether the process of collecting data
    /// from the agents is completed.</p>
    pub data_collected: std::option::Option<bool>,
    /// <p>A list of the assessment run state changes.</p>
    pub state_changes: std::option::Option<std::vec::Vec<crate::model::AssessmentRunStateChange>>,
    /// <p>A list of notifications for the event subscriptions. A notification about a
    /// particular generated finding is added to this list only once.</p>
    pub notifications: std::option::Option<std::vec::Vec<crate::model::AssessmentRunNotification>>,
    /// <p>Provides a total count of generated findings per severity.</p>
    pub finding_counts: std::option::Option<std::collections::HashMap<crate::model::Severity, i32>>,
}
impl AssessmentRun {
    /// <p>The ARN of the assessment run.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The auto-generated name for the assessment run.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the assessment template that is associated with the assessment
    /// run.</p>
    pub fn assessment_template_arn(&self) -> std::option::Option<&str> {
        self.assessment_template_arn.as_deref()
    }
    /// <p>The state of the assessment run.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::AssessmentRunState> {
        self.state.as_ref()
    }
    /// <p>The duration of the assessment run.</p>
    pub fn duration_in_seconds(&self) -> i32 {
        self.duration_in_seconds
    }
    /// <p>The rules packages selected for the assessment run.</p>
    pub fn rules_package_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rules_package_arns.as_deref()
    }
    /// <p>The user-defined attributes that are assigned to every generated finding.</p>
    pub fn user_attributes_for_findings(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.user_attributes_for_findings.as_deref()
    }
    /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_at.as_ref()
    }
    /// <p>The assessment run completion time that corresponds to the rules packages evaluation
    /// completion time or failure.</p>
    pub fn completed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completed_at.as_ref()
    }
    /// <p>The last time when the assessment run's state changed.</p>
    pub fn state_changed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.state_changed_at.as_ref()
    }
    /// <p>A Boolean value (true or false) that specifies whether the process of collecting data
    /// from the agents is completed.</p>
    pub fn data_collected(&self) -> std::option::Option<bool> {
        self.data_collected
    }
    /// <p>A list of the assessment run state changes.</p>
    pub fn state_changes(&self) -> std::option::Option<&[crate::model::AssessmentRunStateChange]> {
        self.state_changes.as_deref()
    }
    /// <p>A list of notifications for the event subscriptions. A notification about a
    /// particular generated finding is added to this list only once.</p>
    pub fn notifications(&self) -> std::option::Option<&[crate::model::AssessmentRunNotification]> {
        self.notifications.as_deref()
    }
    /// <p>Provides a total count of generated findings per severity.</p>
    pub fn finding_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::Severity, i32>> {
        self.finding_counts.as_ref()
    }
}
impl std::fmt::Debug for AssessmentRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentRun");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("assessment_template_arn", &self.assessment_template_arn);
        formatter.field("state", &self.state);
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.field("rules_package_arns", &self.rules_package_arns);
        formatter.field(
            "user_attributes_for_findings",
            &self.user_attributes_for_findings,
        );
        formatter.field("created_at", &self.created_at);
        formatter.field("started_at", &self.started_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.field("state_changed_at", &self.state_changed_at);
        formatter.field("data_collected", &self.data_collected);
        formatter.field("state_changes", &self.state_changes);
        formatter.field("notifications", &self.notifications);
        formatter.field("finding_counts", &self.finding_counts);
        formatter.finish()
    }
}
/// See [`AssessmentRun`](crate::model::AssessmentRun)
pub mod assessment_run {
    /// A builder for [`AssessmentRun`](crate::model::AssessmentRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) assessment_template_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::AssessmentRunState>,
        pub(crate) duration_in_seconds: std::option::Option<i32>,
        pub(crate) rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_attributes_for_findings:
            std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state_changed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_collected: std::option::Option<bool>,
        pub(crate) state_changes:
            std::option::Option<std::vec::Vec<crate::model::AssessmentRunStateChange>>,
        pub(crate) notifications:
            std::option::Option<std::vec::Vec<crate::model::AssessmentRunNotification>>,
        pub(crate) finding_counts:
            std::option::Option<std::collections::HashMap<crate::model::Severity, i32>>,
    }
    impl Builder {
        /// <p>The ARN of the assessment run.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment run.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The auto-generated name for the assessment run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The auto-generated name for the assessment run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the assessment template that is associated with the assessment
        /// run.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template that is associated with the assessment
        /// run.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_template_arn = input;
            self
        }
        /// <p>The state of the assessment run.</p>
        pub fn state(mut self, input: crate::model::AssessmentRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the assessment run.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AssessmentRunState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The duration of the assessment run.</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>The duration of the assessment run.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Appends an item to `rules_package_arns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The rules packages selected for the assessment run.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rules_package_arns.unwrap_or_default();
            v.push(input.into());
            self.rules_package_arns = Some(v);
            self
        }
        /// <p>The rules packages selected for the assessment run.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rules_package_arns = input;
            self
        }
        /// Appends an item to `user_attributes_for_findings`.
        ///
        /// To override the contents of this collection use [`set_user_attributes_for_findings`](Self::set_user_attributes_for_findings).
        ///
        /// <p>The user-defined attributes that are assigned to every generated finding.</p>
        pub fn user_attributes_for_findings(
            mut self,
            input: impl Into<crate::model::Attribute>,
        ) -> Self {
            let mut v = self.user_attributes_for_findings.unwrap_or_default();
            v.push(input.into());
            self.user_attributes_for_findings = Some(v);
            self
        }
        /// <p>The user-defined attributes that are assigned to every generated finding.</p>
        pub fn set_user_attributes_for_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.user_attributes_for_findings = input;
            self
        }
        /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
        pub fn started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time when <a>StartAssessmentRun</a> was called.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The assessment run completion time that corresponds to the rules packages evaluation
        /// completion time or failure.</p>
        pub fn completed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>The assessment run completion time that corresponds to the rules packages evaluation
        /// completion time or failure.</p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// <p>The last time when the assessment run's state changed.</p>
        pub fn state_changed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.state_changed_at = Some(input);
            self
        }
        /// <p>The last time when the assessment run's state changed.</p>
        pub fn set_state_changed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.state_changed_at = input;
            self
        }
        /// <p>A Boolean value (true or false) that specifies whether the process of collecting data
        /// from the agents is completed.</p>
        pub fn data_collected(mut self, input: bool) -> Self {
            self.data_collected = Some(input);
            self
        }
        /// <p>A Boolean value (true or false) that specifies whether the process of collecting data
        /// from the agents is completed.</p>
        pub fn set_data_collected(mut self, input: std::option::Option<bool>) -> Self {
            self.data_collected = input;
            self
        }
        /// Appends an item to `state_changes`.
        ///
        /// To override the contents of this collection use [`set_state_changes`](Self::set_state_changes).
        ///
        /// <p>A list of the assessment run state changes.</p>
        pub fn state_changes(
            mut self,
            input: impl Into<crate::model::AssessmentRunStateChange>,
        ) -> Self {
            let mut v = self.state_changes.unwrap_or_default();
            v.push(input.into());
            self.state_changes = Some(v);
            self
        }
        /// <p>A list of the assessment run state changes.</p>
        pub fn set_state_changes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentRunStateChange>>,
        ) -> Self {
            self.state_changes = input;
            self
        }
        /// Appends an item to `notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p>A list of notifications for the event subscriptions. A notification about a
        /// particular generated finding is added to this list only once.</p>
        pub fn notifications(
            mut self,
            input: impl Into<crate::model::AssessmentRunNotification>,
        ) -> Self {
            let mut v = self.notifications.unwrap_or_default();
            v.push(input.into());
            self.notifications = Some(v);
            self
        }
        /// <p>A list of notifications for the event subscriptions. A notification about a
        /// particular generated finding is added to this list only once.</p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentRunNotification>>,
        ) -> Self {
            self.notifications = input;
            self
        }
        /// Adds a key-value pair to `finding_counts`.
        ///
        /// To override the contents of this collection use [`set_finding_counts`](Self::set_finding_counts).
        ///
        /// <p>Provides a total count of generated findings per severity.</p>
        pub fn finding_counts(
            mut self,
            k: impl Into<crate::model::Severity>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.finding_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.finding_counts = Some(hash_map);
            self
        }
        /// <p>Provides a total count of generated findings per severity.</p>
        pub fn set_finding_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<crate::model::Severity, i32>>,
        ) -> Self {
            self.finding_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentRun`](crate::model::AssessmentRun)
        pub fn build(self) -> crate::model::AssessmentRun {
            crate::model::AssessmentRun {
                arn: self.arn,
                name: self.name,
                assessment_template_arn: self.assessment_template_arn,
                state: self.state,
                duration_in_seconds: self.duration_in_seconds.unwrap_or_default(),
                rules_package_arns: self.rules_package_arns,
                user_attributes_for_findings: self.user_attributes_for_findings,
                created_at: self.created_at,
                started_at: self.started_at,
                completed_at: self.completed_at,
                state_changed_at: self.state_changed_at,
                data_collected: self.data_collected,
                state_changes: self.state_changes,
                notifications: self.notifications,
                finding_counts: self.finding_counts,
            }
        }
    }
}
impl AssessmentRun {
    /// Creates a new builder-style object to manufacture [`AssessmentRun`](crate::model::AssessmentRun)
    pub fn builder() -> crate::model::assessment_run::Builder {
        crate::model::assessment_run::Builder::default()
    }
}

/// <p>Used as one of the elements of the <a>AssessmentRun</a> data
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentRunNotification {
    /// <p>The date of the notification.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The event for which a notification is sent.</p>
    pub event: std::option::Option<crate::model::InspectorEvent>,
    /// <p>The message included in the notification.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Boolean value that specifies whether the notification represents an
    /// error.</p>
    pub error: std::option::Option<bool>,
    /// <p>The SNS topic to which the SNS notification is sent.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The status code of the SNS notification.</p>
    pub sns_publish_status_code:
        std::option::Option<crate::model::AssessmentRunNotificationSnsStatusCode>,
}
impl AssessmentRunNotification {
    /// <p>The date of the notification.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>The event for which a notification is sent.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::InspectorEvent> {
        self.event.as_ref()
    }
    /// <p>The message included in the notification.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The Boolean value that specifies whether the notification represents an
    /// error.</p>
    pub fn error(&self) -> std::option::Option<bool> {
        self.error
    }
    /// <p>The SNS topic to which the SNS notification is sent.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The status code of the SNS notification.</p>
    pub fn sns_publish_status_code(
        &self,
    ) -> std::option::Option<&crate::model::AssessmentRunNotificationSnsStatusCode> {
        self.sns_publish_status_code.as_ref()
    }
}
impl std::fmt::Debug for AssessmentRunNotification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentRunNotification");
        formatter.field("date", &self.date);
        formatter.field("event", &self.event);
        formatter.field("message", &self.message);
        formatter.field("error", &self.error);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("sns_publish_status_code", &self.sns_publish_status_code);
        formatter.finish()
    }
}
/// See [`AssessmentRunNotification`](crate::model::AssessmentRunNotification)
pub mod assessment_run_notification {
    /// A builder for [`AssessmentRunNotification`](crate::model::AssessmentRunNotification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event: std::option::Option<crate::model::InspectorEvent>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<bool>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) sns_publish_status_code:
            std::option::Option<crate::model::AssessmentRunNotificationSnsStatusCode>,
    }
    impl Builder {
        /// <p>The date of the notification.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>The date of the notification.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>The event for which a notification is sent.</p>
        pub fn event(mut self, input: crate::model::InspectorEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The event for which a notification is sent.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.event = input;
            self
        }
        /// <p>The message included in the notification.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message included in the notification.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Boolean value that specifies whether the notification represents an
        /// error.</p>
        pub fn error(mut self, input: bool) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>The Boolean value that specifies whether the notification represents an
        /// error.</p>
        pub fn set_error(mut self, input: std::option::Option<bool>) -> Self {
            self.error = input;
            self
        }
        /// <p>The SNS topic to which the SNS notification is sent.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The SNS topic to which the SNS notification is sent.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The status code of the SNS notification.</p>
        pub fn sns_publish_status_code(
            mut self,
            input: crate::model::AssessmentRunNotificationSnsStatusCode,
        ) -> Self {
            self.sns_publish_status_code = Some(input);
            self
        }
        /// <p>The status code of the SNS notification.</p>
        pub fn set_sns_publish_status_code(
            mut self,
            input: std::option::Option<crate::model::AssessmentRunNotificationSnsStatusCode>,
        ) -> Self {
            self.sns_publish_status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentRunNotification`](crate::model::AssessmentRunNotification)
        pub fn build(self) -> crate::model::AssessmentRunNotification {
            crate::model::AssessmentRunNotification {
                date: self.date,
                event: self.event,
                message: self.message,
                error: self.error,
                sns_topic_arn: self.sns_topic_arn,
                sns_publish_status_code: self.sns_publish_status_code,
            }
        }
    }
}
impl AssessmentRunNotification {
    /// Creates a new builder-style object to manufacture [`AssessmentRunNotification`](crate::model::AssessmentRunNotification)
    pub fn builder() -> crate::model::assessment_run_notification::Builder {
        crate::model::assessment_run_notification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentRunNotificationSnsStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TopicDoesNotExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentRunNotificationSnsStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => AssessmentRunNotificationSnsStatusCode::AccessDenied,
            "INTERNAL_ERROR" => AssessmentRunNotificationSnsStatusCode::InternalError,
            "SUCCESS" => AssessmentRunNotificationSnsStatusCode::Success,
            "TOPIC_DOES_NOT_EXIST" => AssessmentRunNotificationSnsStatusCode::TopicDoesNotExist,
            other => AssessmentRunNotificationSnsStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentRunNotificationSnsStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentRunNotificationSnsStatusCode::from(s))
    }
}
impl AssessmentRunNotificationSnsStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentRunNotificationSnsStatusCode::AccessDenied => "ACCESS_DENIED",
            AssessmentRunNotificationSnsStatusCode::InternalError => "INTERNAL_ERROR",
            AssessmentRunNotificationSnsStatusCode::Success => "SUCCESS",
            AssessmentRunNotificationSnsStatusCode::TopicDoesNotExist => "TOPIC_DOES_NOT_EXIST",
            AssessmentRunNotificationSnsStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "INTERNAL_ERROR",
            "SUCCESS",
            "TOPIC_DOES_NOT_EXIST",
        ]
    }
}
impl AsRef<str> for AssessmentRunNotificationSnsStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Used as one of the elements of the <a>AssessmentRun</a> data
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentRunStateChange {
    /// <p>The last time the assessment run state changed.</p>
    pub state_changed_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The assessment run state.</p>
    pub state: std::option::Option<crate::model::AssessmentRunState>,
}
impl AssessmentRunStateChange {
    /// <p>The last time the assessment run state changed.</p>
    pub fn state_changed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.state_changed_at.as_ref()
    }
    /// <p>The assessment run state.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::AssessmentRunState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for AssessmentRunStateChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentRunStateChange");
        formatter.field("state_changed_at", &self.state_changed_at);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`AssessmentRunStateChange`](crate::model::AssessmentRunStateChange)
pub mod assessment_run_state_change {
    /// A builder for [`AssessmentRunStateChange`](crate::model::AssessmentRunStateChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state_changed_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) state: std::option::Option<crate::model::AssessmentRunState>,
    }
    impl Builder {
        /// <p>The last time the assessment run state changed.</p>
        pub fn state_changed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.state_changed_at = Some(input);
            self
        }
        /// <p>The last time the assessment run state changed.</p>
        pub fn set_state_changed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.state_changed_at = input;
            self
        }
        /// <p>The assessment run state.</p>
        pub fn state(mut self, input: crate::model::AssessmentRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The assessment run state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AssessmentRunState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentRunStateChange`](crate::model::AssessmentRunStateChange)
        pub fn build(self) -> crate::model::AssessmentRunStateChange {
            crate::model::AssessmentRunStateChange {
                state_changed_at: self.state_changed_at,
                state: self.state,
            }
        }
    }
}
impl AssessmentRunStateChange {
    /// Creates a new builder-style object to manufacture [`AssessmentRunStateChange`](crate::model::AssessmentRunStateChange)
    pub fn builder() -> crate::model::assessment_run_state_change::Builder {
        crate::model::assessment_run_state_change::Builder::default()
    }
}
