// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddAttributesToFindingsInput`](crate::input::AddAttributesToFindingsInput)
pub mod add_attributes_to_findings_input {
    /// A builder for [`AddAttributesToFindingsInput`](crate::input::AddAttributesToFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// Appends an item to `finding_arns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
        pub fn finding_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_arns.unwrap_or_default();
            v.push(input.into());
            self.finding_arns = Some(v);
            self
        }
        /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_arns = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The array of attributes that you want to assign to specified findings.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The array of attributes that you want to assign to specified findings.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`AddAttributesToFindingsInput`](crate::input::AddAttributesToFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddAttributesToFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddAttributesToFindingsInput {
                finding_arns: self.finding_arns,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type AddAttributesToFindingsInputOperationOutputAlias =
    crate::operation::AddAttributesToFindings;
#[doc(hidden)]
pub type AddAttributesToFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddAttributesToFindingsInput {
    /// Consumes the builder and constructs an Operation<[`AddAttributesToFindings`](crate::operation::AddAttributesToFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddAttributesToFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddAttributesToFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddAttributesToFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddAttributesToFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.AddAttributesToFindings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_attributes_to_findings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddAttributesToFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddAttributesToFindings",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddAttributesToFindingsInput`](crate::input::AddAttributesToFindingsInput)
    pub fn builder() -> crate::input::add_attributes_to_findings_input::Builder {
        crate::input::add_attributes_to_findings_input::Builder::default()
    }
}

/// See [`CreateAssessmentTargetInput`](crate::input::CreateAssessmentTargetInput)
pub mod create_assessment_target_input {
    /// A builder for [`CreateAssessmentTargetInput`](crate::input::CreateAssessmentTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_target_name: std::option::Option<std::string::String>,
        pub(crate) resource_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-defined name that identifies the assessment target that you want to create.
        /// The name must be unique within the AWS account.</p>
        pub fn assessment_target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_target_name = Some(input.into());
            self
        }
        /// <p>The user-defined name that identifies the assessment target that you want to create.
        /// The name must be unique within the AWS account.</p>
        pub fn set_assessment_target_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_target_name = input;
            self
        }
        /// <p>The ARN that specifies the resource group that is used to create the assessment
        /// target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
        /// and region are included in the assessment target.</p>
        pub fn resource_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the resource group that is used to create the assessment
        /// target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
        /// and region are included in the assessment target.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentTargetInput`](crate::input::CreateAssessmentTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssessmentTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssessmentTargetInput {
                assessment_target_name: self.assessment_target_name,
                resource_group_arn: self.resource_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssessmentTargetInputOperationOutputAlias = crate::operation::CreateAssessmentTarget;
#[doc(hidden)]
pub type CreateAssessmentTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssessmentTargetInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssessmentTarget`](crate::operation::CreateAssessmentTarget)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssessmentTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssessmentTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssessmentTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssessmentTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.CreateAssessmentTarget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_assessment_target(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssessmentTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssessmentTarget",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssessmentTargetInput`](crate::input::CreateAssessmentTargetInput)
    pub fn builder() -> crate::input::create_assessment_target_input::Builder {
        crate::input::create_assessment_target_input::Builder::default()
    }
}

/// See [`CreateAssessmentTemplateInput`](crate::input::CreateAssessmentTemplateInput)
pub mod create_assessment_template_input {
    /// A builder for [`CreateAssessmentTemplateInput`](crate::input::CreateAssessmentTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_target_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_template_name: std::option::Option<std::string::String>,
        pub(crate) duration_in_seconds: std::option::Option<i32>,
        pub(crate) rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_attributes_for_findings:
            std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment target for which you want to create the
        /// assessment template.</p>
        pub fn assessment_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment target for which you want to create the
        /// assessment template.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_target_arn = input;
            self
        }
        /// <p>The user-defined name that identifies the assessment template that you want to
        /// create. You can create several assessment templates for an assessment target. The names of
        /// the assessment templates that correspond to a particular assessment target must be
        /// unique.</p>
        pub fn assessment_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_template_name = Some(input.into());
            self
        }
        /// <p>The user-defined name that identifies the assessment template that you want to
        /// create. You can create several assessment templates for an assessment target. The names of
        /// the assessment templates that correspond to a particular assessment target must be
        /// unique.</p>
        pub fn set_assessment_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_template_name = input;
            self
        }
        /// <p>The duration of the assessment run in seconds.</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>The duration of the assessment run in seconds.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Appends an item to `rules_package_arns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The ARNs that specify the rules packages that you want to attach to the assessment
        /// template.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rules_package_arns.unwrap_or_default();
            v.push(input.into());
            self.rules_package_arns = Some(v);
            self
        }
        /// <p>The ARNs that specify the rules packages that you want to attach to the assessment
        /// template.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rules_package_arns = input;
            self
        }
        /// Appends an item to `user_attributes_for_findings`.
        ///
        /// To override the contents of this collection use [`set_user_attributes_for_findings`](Self::set_user_attributes_for_findings).
        ///
        /// <p>The user-defined attributes that are assigned to every finding that is generated by
        /// the assessment run that uses this assessment template. An attribute is a key and value pair
        /// (an <a>Attribute</a> object). Within an assessment template, each key must be
        /// unique.</p>
        pub fn user_attributes_for_findings(
            mut self,
            input: impl Into<crate::model::Attribute>,
        ) -> Self {
            let mut v = self.user_attributes_for_findings.unwrap_or_default();
            v.push(input.into());
            self.user_attributes_for_findings = Some(v);
            self
        }
        /// <p>The user-defined attributes that are assigned to every finding that is generated by
        /// the assessment run that uses this assessment template. An attribute is a key and value pair
        /// (an <a>Attribute</a> object). Within an assessment template, each key must be
        /// unique.</p>
        pub fn set_user_attributes_for_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.user_attributes_for_findings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentTemplateInput`](crate::input::CreateAssessmentTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssessmentTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssessmentTemplateInput {
                assessment_target_arn: self.assessment_target_arn,
                assessment_template_name: self.assessment_template_name,
                duration_in_seconds: self.duration_in_seconds.unwrap_or_default(),
                rules_package_arns: self.rules_package_arns,
                user_attributes_for_findings: self.user_attributes_for_findings,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssessmentTemplateInputOperationOutputAlias =
    crate::operation::CreateAssessmentTemplate;
#[doc(hidden)]
pub type CreateAssessmentTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssessmentTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssessmentTemplate`](crate::operation::CreateAssessmentTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssessmentTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssessmentTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssessmentTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssessmentTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.CreateAssessmentTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_assessment_template(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssessmentTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssessmentTemplate",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssessmentTemplateInput`](crate::input::CreateAssessmentTemplateInput)
    pub fn builder() -> crate::input::create_assessment_template_input::Builder {
        crate::input::create_assessment_template_input::Builder::default()
    }
}

/// See [`CreateExclusionsPreviewInput`](crate::input::CreateExclusionsPreviewInput)
pub mod create_exclusions_preview_input {
    /// A builder for [`CreateExclusionsPreviewInput`](crate::input::CreateExclusionsPreviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_template_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment template for which you want to create an
        /// exclusions preview.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template for which you want to create an
        /// exclusions preview.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_template_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExclusionsPreviewInput`](crate::input::CreateExclusionsPreviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateExclusionsPreviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateExclusionsPreviewInput {
                assessment_template_arn: self.assessment_template_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateExclusionsPreviewInputOperationOutputAlias =
    crate::operation::CreateExclusionsPreview;
#[doc(hidden)]
pub type CreateExclusionsPreviewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateExclusionsPreviewInput {
    /// Consumes the builder and constructs an Operation<[`CreateExclusionsPreview`](crate::operation::CreateExclusionsPreview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateExclusionsPreview,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateExclusionsPreviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateExclusionsPreviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateExclusionsPreviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.CreateExclusionsPreview",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_exclusions_preview(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateExclusionsPreview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateExclusionsPreview",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateExclusionsPreviewInput`](crate::input::CreateExclusionsPreviewInput)
    pub fn builder() -> crate::input::create_exclusions_preview_input::Builder {
        crate::input::create_exclusions_preview_input::Builder::default()
    }
}

/// See [`CreateResourceGroupInput`](crate::input::CreateResourceGroupInput)
pub mod create_resource_group_input {
    /// A builder for [`CreateResourceGroupInput`](crate::input::CreateResourceGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_tags:
            std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
    }
    impl Builder {
        /// Appends an item to `resource_group_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_group_tags`](Self::set_resource_group_tags).
        ///
        /// <p>A collection of keys and an array of possible values,
        /// '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
        /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
        pub fn resource_group_tags(
            mut self,
            input: impl Into<crate::model::ResourceGroupTag>,
        ) -> Self {
            let mut v = self.resource_group_tags.unwrap_or_default();
            v.push(input.into());
            self.resource_group_tags = Some(v);
            self
        }
        /// <p>A collection of keys and an array of possible values,
        /// '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
        /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
        pub fn set_resource_group_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
        ) -> Self {
            self.resource_group_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceGroupInput`](crate::input::CreateResourceGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceGroupInput {
                resource_group_tags: self.resource_group_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceGroupInputOperationOutputAlias = crate::operation::CreateResourceGroup;
#[doc(hidden)]
pub type CreateResourceGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResourceGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourceGroup`](crate::operation::CreateResourceGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourceGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.CreateResourceGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resource_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourceGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourceGroup",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceGroupInput`](crate::input::CreateResourceGroupInput)
    pub fn builder() -> crate::input::create_resource_group_input::Builder {
        crate::input::create_resource_group_input::Builder::default()
    }
}

/// See [`DeleteAssessmentRunInput`](crate::input::DeleteAssessmentRunInput)
pub mod delete_assessment_run_input {
    /// A builder for [`DeleteAssessmentRunInput`](crate::input::DeleteAssessmentRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment run that you want to delete.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run that you want to delete.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssessmentRunInput`](crate::input::DeleteAssessmentRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssessmentRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssessmentRunInput {
                assessment_run_arn: self.assessment_run_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssessmentRunInputOperationOutputAlias = crate::operation::DeleteAssessmentRun;
#[doc(hidden)]
pub type DeleteAssessmentRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssessmentRunInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssessmentRun`](crate::operation::DeleteAssessmentRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssessmentRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssessmentRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssessmentRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssessmentRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DeleteAssessmentRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_assessment_run(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssessmentRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssessmentRun",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentRunInput`](crate::input::DeleteAssessmentRunInput)
    pub fn builder() -> crate::input::delete_assessment_run_input::Builder {
        crate::input::delete_assessment_run_input::Builder::default()
    }
}

/// See [`DeleteAssessmentTargetInput`](crate::input::DeleteAssessmentTargetInput)
pub mod delete_assessment_target_input {
    /// A builder for [`DeleteAssessmentTargetInput`](crate::input::DeleteAssessmentTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_target_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment target that you want to delete.</p>
        pub fn assessment_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment target that you want to delete.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_target_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssessmentTargetInput`](crate::input::DeleteAssessmentTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssessmentTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssessmentTargetInput {
                assessment_target_arn: self.assessment_target_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssessmentTargetInputOperationOutputAlias = crate::operation::DeleteAssessmentTarget;
#[doc(hidden)]
pub type DeleteAssessmentTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssessmentTargetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssessmentTarget`](crate::operation::DeleteAssessmentTarget)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssessmentTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssessmentTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssessmentTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssessmentTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DeleteAssessmentTarget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_assessment_target(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssessmentTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssessmentTarget",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentTargetInput`](crate::input::DeleteAssessmentTargetInput)
    pub fn builder() -> crate::input::delete_assessment_target_input::Builder {
        crate::input::delete_assessment_target_input::Builder::default()
    }
}

/// See [`DeleteAssessmentTemplateInput`](crate::input::DeleteAssessmentTemplateInput)
pub mod delete_assessment_template_input {
    /// A builder for [`DeleteAssessmentTemplateInput`](crate::input::DeleteAssessmentTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_template_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment template that you want to delete.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template that you want to delete.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_template_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssessmentTemplateInput`](crate::input::DeleteAssessmentTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssessmentTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssessmentTemplateInput {
                assessment_template_arn: self.assessment_template_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssessmentTemplateInputOperationOutputAlias =
    crate::operation::DeleteAssessmentTemplate;
#[doc(hidden)]
pub type DeleteAssessmentTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssessmentTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssessmentTemplate`](crate::operation::DeleteAssessmentTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssessmentTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssessmentTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssessmentTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssessmentTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DeleteAssessmentTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_assessment_template(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssessmentTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssessmentTemplate",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentTemplateInput`](crate::input::DeleteAssessmentTemplateInput)
    pub fn builder() -> crate::input::delete_assessment_template_input::Builder {
        crate::input::delete_assessment_template_input::Builder::default()
    }
}

/// See [`DescribeAssessmentRunsInput`](crate::input::DescribeAssessmentRunsInput)
pub mod describe_assessment_runs_input {
    /// A builder for [`DescribeAssessmentRunsInput`](crate::input::DescribeAssessmentRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `assessment_run_arns`.
        ///
        /// To override the contents of this collection use [`set_assessment_run_arns`](Self::set_assessment_run_arns).
        ///
        /// <p>The ARN that specifies the assessment run that you want to describe.</p>
        pub fn assessment_run_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.assessment_run_arns.unwrap_or_default();
            v.push(input.into());
            self.assessment_run_arns = Some(v);
            self
        }
        /// <p>The ARN that specifies the assessment run that you want to describe.</p>
        pub fn set_assessment_run_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.assessment_run_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssessmentRunsInput`](crate::input::DescribeAssessmentRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssessmentRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssessmentRunsInput {
                assessment_run_arns: self.assessment_run_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssessmentRunsInputOperationOutputAlias = crate::operation::DescribeAssessmentRuns;
#[doc(hidden)]
pub type DescribeAssessmentRunsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssessmentRunsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssessmentRuns`](crate::operation::DescribeAssessmentRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssessmentRuns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssessmentRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssessmentRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssessmentRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeAssessmentRuns",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_assessment_runs(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssessmentRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssessmentRuns",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssessmentRunsInput`](crate::input::DescribeAssessmentRunsInput)
    pub fn builder() -> crate::input::describe_assessment_runs_input::Builder {
        crate::input::describe_assessment_runs_input::Builder::default()
    }
}

/// See [`DescribeAssessmentTargetsInput`](crate::input::DescribeAssessmentTargetsInput)
pub mod describe_assessment_targets_input {
    /// A builder for [`DescribeAssessmentTargetsInput`](crate::input::DescribeAssessmentTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `assessment_target_arns`.
        ///
        /// To override the contents of this collection use [`set_assessment_target_arns`](Self::set_assessment_target_arns).
        ///
        /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
        pub fn assessment_target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.assessment_target_arns.unwrap_or_default();
            v.push(input.into());
            self.assessment_target_arns = Some(v);
            self
        }
        /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
        pub fn set_assessment_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.assessment_target_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssessmentTargetsInput`](crate::input::DescribeAssessmentTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssessmentTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssessmentTargetsInput {
                assessment_target_arns: self.assessment_target_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssessmentTargetsInputOperationOutputAlias =
    crate::operation::DescribeAssessmentTargets;
#[doc(hidden)]
pub type DescribeAssessmentTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssessmentTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssessmentTargets`](crate::operation::DescribeAssessmentTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssessmentTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssessmentTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssessmentTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssessmentTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeAssessmentTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_assessment_targets(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssessmentTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssessmentTargets",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssessmentTargetsInput`](crate::input::DescribeAssessmentTargetsInput)
    pub fn builder() -> crate::input::describe_assessment_targets_input::Builder {
        crate::input::describe_assessment_targets_input::Builder::default()
    }
}

/// See [`DescribeAssessmentTemplatesInput`](crate::input::DescribeAssessmentTemplatesInput)
pub mod describe_assessment_templates_input {
    /// A builder for [`DescribeAssessmentTemplatesInput`](crate::input::DescribeAssessmentTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_template_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `assessment_template_arns`.
        ///
        /// To override the contents of this collection use [`set_assessment_template_arns`](Self::set_assessment_template_arns).
        ///
        pub fn assessment_template_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.assessment_template_arns.unwrap_or_default();
            v.push(input.into());
            self.assessment_template_arns = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_assessment_template_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.assessment_template_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssessmentTemplatesInput`](crate::input::DescribeAssessmentTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssessmentTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssessmentTemplatesInput {
                assessment_template_arns: self.assessment_template_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssessmentTemplatesInputOperationOutputAlias =
    crate::operation::DescribeAssessmentTemplates;
#[doc(hidden)]
pub type DescribeAssessmentTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssessmentTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssessmentTemplates`](crate::operation::DescribeAssessmentTemplates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssessmentTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssessmentTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssessmentTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssessmentTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeAssessmentTemplates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_assessment_templates(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssessmentTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssessmentTemplates",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssessmentTemplatesInput`](crate::input::DescribeAssessmentTemplatesInput)
    pub fn builder() -> crate::input::describe_assessment_templates_input::Builder {
        crate::input::describe_assessment_templates_input::Builder::default()
    }
}

/// See [`DescribeCrossAccountAccessRoleInput`](crate::input::DescribeCrossAccountAccessRoleInput)
pub mod describe_cross_account_access_role_input {
    /// A builder for [`DescribeCrossAccountAccessRoleInput`](crate::input::DescribeCrossAccountAccessRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeCrossAccountAccessRoleInput`](crate::input::DescribeCrossAccountAccessRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCrossAccountAccessRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCrossAccountAccessRoleInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeCrossAccountAccessRoleInputOperationOutputAlias =
    crate::operation::DescribeCrossAccountAccessRole;
#[doc(hidden)]
pub type DescribeCrossAccountAccessRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCrossAccountAccessRoleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCrossAccountAccessRole`](crate::operation::DescribeCrossAccountAccessRole)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCrossAccountAccessRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCrossAccountAccessRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCrossAccountAccessRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCrossAccountAccessRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeCrossAccountAccessRole",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cross_account_access_role(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCrossAccountAccessRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCrossAccountAccessRole",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCrossAccountAccessRoleInput`](crate::input::DescribeCrossAccountAccessRoleInput)
    pub fn builder() -> crate::input::describe_cross_account_access_role_input::Builder {
        crate::input::describe_cross_account_access_role_input::Builder::default()
    }
}

/// See [`DescribeExclusionsInput`](crate::input::DescribeExclusionsInput)
pub mod describe_exclusions_input {
    /// A builder for [`DescribeExclusionsInput`](crate::input::DescribeExclusionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exclusion_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
    }
    impl Builder {
        /// Appends an item to `exclusion_arns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_arns`](Self::set_exclusion_arns).
        ///
        /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
        pub fn exclusion_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusion_arns.unwrap_or_default();
            v.push(input.into());
            self.exclusion_arns = Some(v);
            self
        }
        /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
        pub fn set_exclusion_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusion_arns = input;
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExclusionsInput`](crate::input::DescribeExclusionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeExclusionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeExclusionsInput {
                exclusion_arns: self.exclusion_arns,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeExclusionsInputOperationOutputAlias = crate::operation::DescribeExclusions;
#[doc(hidden)]
pub type DescribeExclusionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeExclusionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeExclusions`](crate::operation::DescribeExclusions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeExclusions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeExclusionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeExclusionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeExclusionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeExclusions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_exclusions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeExclusions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeExclusions",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeExclusionsInput`](crate::input::DescribeExclusionsInput)
    pub fn builder() -> crate::input::describe_exclusions_input::Builder {
        crate::input::describe_exclusions_input::Builder::default()
    }
}

/// See [`DescribeFindingsInput`](crate::input::DescribeFindingsInput)
pub mod describe_findings_input {
    /// A builder for [`DescribeFindingsInput`](crate::input::DescribeFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
    }
    impl Builder {
        /// Appends an item to `finding_arns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARN that specifies the finding that you want to describe.</p>
        pub fn finding_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_arns.unwrap_or_default();
            v.push(input.into());
            self.finding_arns = Some(v);
            self
        }
        /// <p>The ARN that specifies the finding that you want to describe.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_arns = input;
            self
        }
        /// <p>The locale into which you want to translate a finding description, recommendation,
        /// and the short description that identifies the finding.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale into which you want to translate a finding description, recommendation,
        /// and the short description that identifies the finding.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFindingsInput`](crate::input::DescribeFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFindingsInput {
                finding_arns: self.finding_arns,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFindingsInputOperationOutputAlias = crate::operation::DescribeFindings;
#[doc(hidden)]
pub type DescribeFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFindingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFindings`](crate::operation::DescribeFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeFindings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFindings",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFindingsInput`](crate::input::DescribeFindingsInput)
    pub fn builder() -> crate::input::describe_findings_input::Builder {
        crate::input::describe_findings_input::Builder::default()
    }
}

/// See [`DescribeResourceGroupsInput`](crate::input::DescribeResourceGroupsInput)
pub mod describe_resource_groups_input {
    /// A builder for [`DescribeResourceGroupsInput`](crate::input::DescribeResourceGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `resource_group_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_group_arns`](Self::set_resource_group_arns).
        ///
        /// <p>The ARN that specifies the resource group that you want to describe.</p>
        pub fn resource_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_group_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_group_arns = Some(v);
            self
        }
        /// <p>The ARN that specifies the resource group that you want to describe.</p>
        pub fn set_resource_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_group_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourceGroupsInput`](crate::input::DescribeResourceGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourceGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourceGroupsInput {
                resource_group_arns: self.resource_group_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourceGroupsInputOperationOutputAlias = crate::operation::DescribeResourceGroups;
#[doc(hidden)]
pub type DescribeResourceGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeResourceGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResourceGroups`](crate::operation::DescribeResourceGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResourceGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeResourceGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeResourceGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeResourceGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeResourceGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_resource_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResourceGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResourceGroups",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourceGroupsInput`](crate::input::DescribeResourceGroupsInput)
    pub fn builder() -> crate::input::describe_resource_groups_input::Builder {
        crate::input::describe_resource_groups_input::Builder::default()
    }
}

/// See [`DescribeRulesPackagesInput`](crate::input::DescribeRulesPackagesInput)
pub mod describe_rules_packages_input {
    /// A builder for [`DescribeRulesPackagesInput`](crate::input::DescribeRulesPackagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
    }
    impl Builder {
        /// Appends an item to `rules_package_arns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The ARN that specifies the rules package that you want to describe.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rules_package_arns.unwrap_or_default();
            v.push(input.into());
            self.rules_package_arns = Some(v);
            self
        }
        /// <p>The ARN that specifies the rules package that you want to describe.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rules_package_arns = input;
            self
        }
        /// <p>The locale that you want to translate a rules package description into.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale that you want to translate a rules package description into.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRulesPackagesInput`](crate::input::DescribeRulesPackagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRulesPackagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRulesPackagesInput {
                rules_package_arns: self.rules_package_arns,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRulesPackagesInputOperationOutputAlias = crate::operation::DescribeRulesPackages;
#[doc(hidden)]
pub type DescribeRulesPackagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRulesPackagesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRulesPackages`](crate::operation::DescribeRulesPackages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRulesPackages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRulesPackagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRulesPackagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRulesPackagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.DescribeRulesPackages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_rules_packages(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRulesPackages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRulesPackages",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRulesPackagesInput`](crate::input::DescribeRulesPackagesInput)
    pub fn builder() -> crate::input::describe_rules_packages_input::Builder {
        crate::input::describe_rules_packages_input::Builder::default()
    }
}

/// See [`GetAssessmentReportInput`](crate::input::GetAssessmentReportInput)
pub mod get_assessment_report_input {
    /// A builder for [`GetAssessmentReportInput`](crate::input::GetAssessmentReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) report_file_format: std::option::Option<crate::model::ReportFileFormat>,
        pub(crate) report_type: std::option::Option<crate::model::ReportType>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment run for which you want to generate a
        /// report.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run for which you want to generate a
        /// report.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// <p>Specifies the file format (html or pdf) of the assessment report that you want to
        /// generate.</p>
        pub fn report_file_format(mut self, input: crate::model::ReportFileFormat) -> Self {
            self.report_file_format = Some(input);
            self
        }
        /// <p>Specifies the file format (html or pdf) of the assessment report that you want to
        /// generate.</p>
        pub fn set_report_file_format(
            mut self,
            input: std::option::Option<crate::model::ReportFileFormat>,
        ) -> Self {
            self.report_file_format = input;
            self
        }
        /// <p>Specifies the type of the assessment report that you want to generate. There are two
        /// types of assessment reports: a finding report and a full report. For more information, see
        /// <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
        pub fn report_type(mut self, input: crate::model::ReportType) -> Self {
            self.report_type = Some(input);
            self
        }
        /// <p>Specifies the type of the assessment report that you want to generate. There are two
        /// types of assessment reports: a finding report and a full report. For more information, see
        /// <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
        pub fn set_report_type(
            mut self,
            input: std::option::Option<crate::model::ReportType>,
        ) -> Self {
            self.report_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssessmentReportInput`](crate::input::GetAssessmentReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssessmentReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssessmentReportInput {
                assessment_run_arn: self.assessment_run_arn,
                report_file_format: self.report_file_format,
                report_type: self.report_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssessmentReportInputOperationOutputAlias = crate::operation::GetAssessmentReport;
#[doc(hidden)]
pub type GetAssessmentReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssessmentReportInput {
    /// Consumes the builder and constructs an Operation<[`GetAssessmentReport`](crate::operation::GetAssessmentReport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssessmentReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssessmentReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssessmentReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssessmentReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.GetAssessmentReport",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_assessment_report(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssessmentReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssessmentReport",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssessmentReportInput`](crate::input::GetAssessmentReportInput)
    pub fn builder() -> crate::input::get_assessment_report_input::Builder {
        crate::input::get_assessment_report_input::Builder::default()
    }
}

/// See [`GetExclusionsPreviewInput`](crate::input::GetExclusionsPreviewInput)
pub mod get_exclusions_preview_input {
    /// A builder for [`GetExclusionsPreviewInput`](crate::input::GetExclusionsPreviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_template_arn: std::option::Option<std::string::String>,
        pub(crate) preview_token: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment template for which the exclusions preview was
        /// requested.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template for which the exclusions preview was
        /// requested.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_template_arn = input;
            self
        }
        /// <p>The unique identifier associated of the exclusions preview.</p>
        pub fn preview_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.preview_token = Some(input.into());
            self
        }
        /// <p>The unique identifier associated of the exclusions preview.</p>
        pub fn set_preview_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preview_token = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to
        /// the action fill nextToken in the request with the value of nextToken from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to
        /// the action fill nextToken in the request with the value of nextToken from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExclusionsPreviewInput`](crate::input::GetExclusionsPreviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExclusionsPreviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExclusionsPreviewInput {
                assessment_template_arn: self.assessment_template_arn,
                preview_token: self.preview_token,
                next_token: self.next_token,
                max_results: self.max_results,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExclusionsPreviewInputOperationOutputAlias = crate::operation::GetExclusionsPreview;
#[doc(hidden)]
pub type GetExclusionsPreviewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetExclusionsPreviewInput {
    /// Consumes the builder and constructs an Operation<[`GetExclusionsPreview`](crate::operation::GetExclusionsPreview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExclusionsPreview,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetExclusionsPreviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetExclusionsPreviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetExclusionsPreviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.GetExclusionsPreview",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_exclusions_preview(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExclusionsPreview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExclusionsPreview",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetExclusionsPreviewInput`](crate::input::GetExclusionsPreviewInput)
    pub fn builder() -> crate::input::get_exclusions_preview_input::Builder {
        crate::input::get_exclusions_preview_input::Builder::default()
    }
}

/// See [`GetTelemetryMetadataInput`](crate::input::GetTelemetryMetadataInput)
pub mod get_telemetry_metadata_input {
    /// A builder for [`GetTelemetryMetadataInput`](crate::input::GetTelemetryMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment run that has the telemetry data that you want
        /// to obtain.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run that has the telemetry data that you want
        /// to obtain.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTelemetryMetadataInput`](crate::input::GetTelemetryMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTelemetryMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTelemetryMetadataInput {
                assessment_run_arn: self.assessment_run_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTelemetryMetadataInputOperationOutputAlias = crate::operation::GetTelemetryMetadata;
#[doc(hidden)]
pub type GetTelemetryMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTelemetryMetadataInput {
    /// Consumes the builder and constructs an Operation<[`GetTelemetryMetadata`](crate::operation::GetTelemetryMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTelemetryMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTelemetryMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTelemetryMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTelemetryMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.GetTelemetryMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_telemetry_metadata(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTelemetryMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTelemetryMetadata",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTelemetryMetadataInput`](crate::input::GetTelemetryMetadataInput)
    pub fn builder() -> crate::input::get_telemetry_metadata_input::Builder {
        crate::input::get_telemetry_metadata_input::Builder::default()
    }
}

/// See [`ListAssessmentRunAgentsInput`](crate::input::ListAssessmentRunAgentsInput)
pub mod list_assessment_run_agents_input {
    /// A builder for [`ListAssessmentRunAgentsInput`](crate::input::ListAssessmentRunAgentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::AgentFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, input: crate::model::AgentFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::AgentFilter>) -> Self {
            self.filter = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRunAgents</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRunAgents</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentRunAgentsInput`](crate::input::ListAssessmentRunAgentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentRunAgentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentRunAgentsInput {
                assessment_run_arn: self.assessment_run_arn,
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentRunAgentsInputOperationOutputAlias =
    crate::operation::ListAssessmentRunAgents;
#[doc(hidden)]
pub type ListAssessmentRunAgentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssessmentRunAgentsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessmentRunAgents`](crate::operation::ListAssessmentRunAgents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessmentRunAgents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentRunAgentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentRunAgentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentRunAgentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListAssessmentRunAgents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_assessment_run_agents(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessmentRunAgents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessmentRunAgents",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentRunAgentsInput`](crate::input::ListAssessmentRunAgentsInput)
    pub fn builder() -> crate::input::list_assessment_run_agents_input::Builder {
        crate::input::list_assessment_run_agents_input::Builder::default()
    }
}

/// See [`ListAssessmentRunsInput`](crate::input::ListAssessmentRunsInput)
pub mod list_assessment_runs_input {
    /// A builder for [`ListAssessmentRunsInput`](crate::input::ListAssessmentRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_template_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filter: std::option::Option<crate::model::AssessmentRunFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `assessment_template_arns`.
        ///
        /// To override the contents of this collection use [`set_assessment_template_arns`](Self::set_assessment_template_arns).
        ///
        /// <p>The ARNs that specify the assessment templates whose assessment runs you want to
        /// list.</p>
        pub fn assessment_template_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.assessment_template_arns.unwrap_or_default();
            v.push(input.into());
            self.assessment_template_arns = Some(v);
            self
        }
        /// <p>The ARNs that specify the assessment templates whose assessment runs you want to
        /// list.</p>
        pub fn set_assessment_template_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.assessment_template_arns = input;
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, input: crate::model::AssessmentRunFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentRunFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRuns</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRuns</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentRunsInput`](crate::input::ListAssessmentRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentRunsInput {
                assessment_template_arns: self.assessment_template_arns,
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentRunsInputOperationOutputAlias = crate::operation::ListAssessmentRuns;
#[doc(hidden)]
pub type ListAssessmentRunsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssessmentRunsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessmentRuns`](crate::operation::ListAssessmentRuns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessmentRuns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListAssessmentRuns",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_assessment_runs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessmentRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessmentRuns",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentRunsInput`](crate::input::ListAssessmentRunsInput)
    pub fn builder() -> crate::input::list_assessment_runs_input::Builder {
        crate::input::list_assessment_runs_input::Builder::default()
    }
}

/// See [`ListAssessmentTargetsInput`](crate::input::ListAssessmentTargetsInput)
pub mod list_assessment_targets_input {
    /// A builder for [`ListAssessmentTargetsInput`](crate::input::ListAssessmentTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::AssessmentTargetFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, input: crate::model::AssessmentTargetFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentTargetFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTargets</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTargets</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentTargetsInput`](crate::input::ListAssessmentTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentTargetsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentTargetsInputOperationOutputAlias = crate::operation::ListAssessmentTargets;
#[doc(hidden)]
pub type ListAssessmentTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssessmentTargetsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessmentTargets`](crate::operation::ListAssessmentTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessmentTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListAssessmentTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_assessment_targets(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessmentTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessmentTargets",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentTargetsInput`](crate::input::ListAssessmentTargetsInput)
    pub fn builder() -> crate::input::list_assessment_targets_input::Builder {
        crate::input::list_assessment_targets_input::Builder::default()
    }
}

/// See [`ListAssessmentTemplatesInput`](crate::input::ListAssessmentTemplatesInput)
pub mod list_assessment_templates_input {
    /// A builder for [`ListAssessmentTemplatesInput`](crate::input::ListAssessmentTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filter: std::option::Option<crate::model::AssessmentTemplateFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `assessment_target_arns`.
        ///
        /// To override the contents of this collection use [`set_assessment_target_arns`](Self::set_assessment_target_arns).
        ///
        /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you
        /// want to list.</p>
        pub fn assessment_target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.assessment_target_arns.unwrap_or_default();
            v.push(input.into());
            self.assessment_target_arns = Some(v);
            self
        }
        /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you
        /// want to list.</p>
        pub fn set_assessment_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.assessment_target_arns = input;
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, input: crate::model::AssessmentTemplateFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentTemplateFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTemplates</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTemplates</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentTemplatesInput`](crate::input::ListAssessmentTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentTemplatesInput {
                assessment_target_arns: self.assessment_target_arns,
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentTemplatesInputOperationOutputAlias =
    crate::operation::ListAssessmentTemplates;
#[doc(hidden)]
pub type ListAssessmentTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssessmentTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessmentTemplates`](crate::operation::ListAssessmentTemplates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessmentTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListAssessmentTemplates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_assessment_templates(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessmentTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessmentTemplates",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentTemplatesInput`](crate::input::ListAssessmentTemplatesInput)
    pub fn builder() -> crate::input::list_assessment_templates_input::Builder {
        crate::input::list_assessment_templates_input::Builder::default()
    }
}

/// See [`ListEventSubscriptionsInput`](crate::input::ListEventSubscriptionsInput)
pub mod list_event_subscriptions_input {
    /// A builder for [`ListEventSubscriptionsInput`](crate::input::ListEventSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the assessment template for which you want to list the existing event
        /// subscriptions.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template for which you want to list the existing event
        /// subscriptions.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListEventSubscriptions</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListEventSubscriptions</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventSubscriptionsInput`](crate::input::ListEventSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventSubscriptionsInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventSubscriptionsInputOperationOutputAlias = crate::operation::ListEventSubscriptions;
#[doc(hidden)]
pub type ListEventSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEventSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`ListEventSubscriptions`](crate::operation::ListEventSubscriptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEventSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEventSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEventSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListEventSubscriptions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_event_subscriptions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventSubscriptions",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEventSubscriptionsInput`](crate::input::ListEventSubscriptionsInput)
    pub fn builder() -> crate::input::list_event_subscriptions_input::Builder {
        crate::input::list_event_subscriptions_input::Builder::default()
    }
}

/// See [`ListExclusionsInput`](crate::input::ListExclusionsInput)
pub mod list_exclusions_input {
    /// A builder for [`ListExclusionsInput`](crate::input::ListExclusionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the assessment run that generated the exclusions that you want to
        /// list.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment run that generated the exclusions that you want to
        /// list.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the ListExclusionsRequest action. Subsequent calls to the
        /// action fill nextToken in the request with the value of nextToken from the previous response
        /// to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the ListExclusionsRequest action. Subsequent calls to the
        /// action fill nextToken in the request with the value of nextToken from the previous response
        /// to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExclusionsInput`](crate::input::ListExclusionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExclusionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExclusionsInput {
                assessment_run_arn: self.assessment_run_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExclusionsInputOperationOutputAlias = crate::operation::ListExclusions;
#[doc(hidden)]
pub type ListExclusionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListExclusionsInput {
    /// Consumes the builder and constructs an Operation<[`ListExclusions`](crate::operation::ListExclusions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExclusions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExclusionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExclusionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExclusionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListExclusions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_exclusions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExclusions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExclusions",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExclusionsInput`](crate::input::ListExclusionsInput)
    pub fn builder() -> crate::input::list_exclusions_input::Builder {
        crate::input::list_exclusions_input::Builder::default()
    }
}

/// See [`ListFindingsInput`](crate::input::ListFindingsInput)
pub mod list_findings_input {
    /// A builder for [`ListFindingsInput`](crate::input::ListFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filter: std::option::Option<crate::model::FindingFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `assessment_run_arns`.
        ///
        /// To override the contents of this collection use [`set_assessment_run_arns`](Self::set_assessment_run_arns).
        ///
        /// <p>The ARNs of the assessment runs that generate the findings that you want to
        /// list.</p>
        pub fn assessment_run_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.assessment_run_arns.unwrap_or_default();
            v.push(input.into());
            self.assessment_run_arns = Some(v);
            self
        }
        /// <p>The ARNs of the assessment runs that generate the findings that you want to
        /// list.</p>
        pub fn set_assessment_run_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.assessment_run_arns = input;
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, input: crate::model::FindingFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::FindingFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListFindings</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListFindings</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsInput`](crate::input::ListFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFindingsInput {
                assessment_run_arns: self.assessment_run_arns,
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFindingsInputOperationOutputAlias = crate::operation::ListFindings;
#[doc(hidden)]
pub type ListFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFindingsInput {
    /// Consumes the builder and constructs an Operation<[`ListFindings`](crate::operation::ListFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListFindings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFindings",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
}

/// See [`ListRulesPackagesInput`](crate::input::ListRulesPackagesInput)
pub mod list_rules_packages_input {
    /// A builder for [`ListRulesPackagesInput`](crate::input::ListRulesPackagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListRulesPackages</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListRulesPackages</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesPackagesInput`](crate::input::ListRulesPackagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRulesPackagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRulesPackagesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRulesPackagesInputOperationOutputAlias = crate::operation::ListRulesPackages;
#[doc(hidden)]
pub type ListRulesPackagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRulesPackagesInput {
    /// Consumes the builder and constructs an Operation<[`ListRulesPackages`](crate::operation::ListRulesPackages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRulesPackages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRulesPackagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRulesPackagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRulesPackagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListRulesPackages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_rules_packages(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRulesPackages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRulesPackages",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRulesPackagesInput`](crate::input::ListRulesPackagesInput)
    pub fn builder() -> crate::input::list_rules_packages_input::Builder {
        crate::input::list_rules_packages_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PreviewAgentsInput`](crate::input::PreviewAgentsInput)
pub mod preview_agents_input {
    /// A builder for [`PreviewAgentsInput`](crate::input::PreviewAgentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preview_agents_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the assessment target whose agents you want to preview.</p>
        pub fn preview_agents_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.preview_agents_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment target whose agents you want to preview.</p>
        pub fn set_preview_agents_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preview_agents_arn = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>PreviewAgents</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>PreviewAgents</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`PreviewAgentsInput`](crate::input::PreviewAgentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PreviewAgentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PreviewAgentsInput {
                preview_agents_arn: self.preview_agents_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type PreviewAgentsInputOperationOutputAlias = crate::operation::PreviewAgents;
#[doc(hidden)]
pub type PreviewAgentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PreviewAgentsInput {
    /// Consumes the builder and constructs an Operation<[`PreviewAgents`](crate::operation::PreviewAgents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PreviewAgents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PreviewAgentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PreviewAgentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PreviewAgentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.PreviewAgents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_preview_agents(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PreviewAgents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PreviewAgents",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PreviewAgentsInput`](crate::input::PreviewAgentsInput)
    pub fn builder() -> crate::input::preview_agents_input::Builder {
        crate::input::preview_agents_input::Builder::default()
    }
}

/// See [`RegisterCrossAccountAccessRoleInput`](crate::input::RegisterCrossAccountAccessRoleInput)
pub mod register_cross_account_access_role_input {
    /// A builder for [`RegisterCrossAccountAccessRoleInput`](crate::input::RegisterCrossAccountAccessRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to
        /// perform security assessments. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to
        /// perform security assessments. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterCrossAccountAccessRoleInput`](crate::input::RegisterCrossAccountAccessRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterCrossAccountAccessRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterCrossAccountAccessRoleInput {
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterCrossAccountAccessRoleInputOperationOutputAlias =
    crate::operation::RegisterCrossAccountAccessRole;
#[doc(hidden)]
pub type RegisterCrossAccountAccessRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterCrossAccountAccessRoleInput {
    /// Consumes the builder and constructs an Operation<[`RegisterCrossAccountAccessRole`](crate::operation::RegisterCrossAccountAccessRole)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterCrossAccountAccessRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterCrossAccountAccessRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterCrossAccountAccessRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterCrossAccountAccessRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.RegisterCrossAccountAccessRole",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_cross_account_access_role(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterCrossAccountAccessRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterCrossAccountAccessRole",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterCrossAccountAccessRoleInput`](crate::input::RegisterCrossAccountAccessRoleInput)
    pub fn builder() -> crate::input::register_cross_account_access_role_input::Builder {
        crate::input::register_cross_account_access_role_input::Builder::default()
    }
}

/// See [`RemoveAttributesFromFindingsInput`](crate::input::RemoveAttributesFromFindingsInput)
pub mod remove_attributes_from_findings_input {
    /// A builder for [`RemoveAttributesFromFindingsInput`](crate::input::RemoveAttributesFromFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attribute_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `finding_arns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
        pub fn finding_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_arns.unwrap_or_default();
            v.push(input.into());
            self.finding_arns = Some(v);
            self
        }
        /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_arns = input;
            self
        }
        /// Appends an item to `attribute_keys`.
        ///
        /// To override the contents of this collection use [`set_attribute_keys`](Self::set_attribute_keys).
        ///
        /// <p>The array of attribute keys that you want to remove from specified
        /// findings.</p>
        pub fn attribute_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_keys.unwrap_or_default();
            v.push(input.into());
            self.attribute_keys = Some(v);
            self
        }
        /// <p>The array of attribute keys that you want to remove from specified
        /// findings.</p>
        pub fn set_attribute_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAttributesFromFindingsInput`](crate::input::RemoveAttributesFromFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveAttributesFromFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveAttributesFromFindingsInput {
                finding_arns: self.finding_arns,
                attribute_keys: self.attribute_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveAttributesFromFindingsInputOperationOutputAlias =
    crate::operation::RemoveAttributesFromFindings;
#[doc(hidden)]
pub type RemoveAttributesFromFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveAttributesFromFindingsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveAttributesFromFindings`](crate::operation::RemoveAttributesFromFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveAttributesFromFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveAttributesFromFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveAttributesFromFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveAttributesFromFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.RemoveAttributesFromFindings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_attributes_from_findings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveAttributesFromFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveAttributesFromFindings",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveAttributesFromFindingsInput`](crate::input::RemoveAttributesFromFindingsInput)
    pub fn builder() -> crate::input::remove_attributes_from_findings_input::Builder {
        crate::input::remove_attributes_from_findings_input::Builder::default()
    }
}

/// See [`SetTagsForResourceInput`](crate::input::SetTagsForResourceInput)
pub mod set_tags_for_resource_input {
    /// A builder for [`SetTagsForResourceInput`](crate::input::SetTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the assessment template that you want to set tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template that you want to set tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs that you want to set to the assessment
        /// template.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of key and value pairs that you want to set to the assessment
        /// template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTagsForResourceInput`](crate::input::SetTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetTagsForResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type SetTagsForResourceInputOperationOutputAlias = crate::operation::SetTagsForResource;
#[doc(hidden)]
pub type SetTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`SetTagsForResource`](crate::operation::SetTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.SetTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_tags_for_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetTagsForResource",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetTagsForResourceInput`](crate::input::SetTagsForResourceInput)
    pub fn builder() -> crate::input::set_tags_for_resource_input::Builder {
        crate::input::set_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartAssessmentRunInput`](crate::input::StartAssessmentRunInput)
pub mod start_assessment_run_input {
    /// A builder for [`StartAssessmentRunInput`](crate::input::StartAssessmentRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_template_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_run_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the assessment template of the assessment run that you want to
        /// start.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_template_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template of the assessment run that you want to
        /// start.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_template_arn = input;
            self
        }
        /// <p>You can specify the name for the assessment run. The name must be unique for the
        /// assessment template whose ARN is used to start the assessment run.</p>
        pub fn assessment_run_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_name = Some(input.into());
            self
        }
        /// <p>You can specify the name for the assessment run. The name must be unique for the
        /// assessment template whose ARN is used to start the assessment run.</p>
        pub fn set_assessment_run_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAssessmentRunInput`](crate::input::StartAssessmentRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartAssessmentRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartAssessmentRunInput {
                assessment_template_arn: self.assessment_template_arn,
                assessment_run_name: self.assessment_run_name,
            })
        }
    }
}
#[doc(hidden)]
pub type StartAssessmentRunInputOperationOutputAlias = crate::operation::StartAssessmentRun;
#[doc(hidden)]
pub type StartAssessmentRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartAssessmentRunInput {
    /// Consumes the builder and constructs an Operation<[`StartAssessmentRun`](crate::operation::StartAssessmentRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartAssessmentRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartAssessmentRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartAssessmentRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartAssessmentRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.StartAssessmentRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_assessment_run(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartAssessmentRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartAssessmentRun",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartAssessmentRunInput`](crate::input::StartAssessmentRunInput)
    pub fn builder() -> crate::input::start_assessment_run_input::Builder {
        crate::input::start_assessment_run_input::Builder::default()
    }
}

/// See [`StopAssessmentRunInput`](crate::input::StopAssessmentRunInput)
pub mod stop_assessment_run_input {
    /// A builder for [`StopAssessmentRunInput`](crate::input::StopAssessmentRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) stop_action: std::option::Option<crate::model::StopAction>,
    }
    impl Builder {
        /// <p>The ARN of the assessment run that you want to stop.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment run that you want to stop.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_arn = input;
            self
        }
        /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
        /// START_EVALUATION (the default value), stops the AWS agent from collecting data and begins
        /// the results evaluation and the findings generation process. SKIP_EVALUATION cancels the
        /// assessment run immediately, after which no findings are generated.</p>
        pub fn stop_action(mut self, input: crate::model::StopAction) -> Self {
            self.stop_action = Some(input);
            self
        }
        /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
        /// START_EVALUATION (the default value), stops the AWS agent from collecting data and begins
        /// the results evaluation and the findings generation process. SKIP_EVALUATION cancels the
        /// assessment run immediately, after which no findings are generated.</p>
        pub fn set_stop_action(
            mut self,
            input: std::option::Option<crate::model::StopAction>,
        ) -> Self {
            self.stop_action = input;
            self
        }
        /// Consumes the builder and constructs a [`StopAssessmentRunInput`](crate::input::StopAssessmentRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopAssessmentRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopAssessmentRunInput {
                assessment_run_arn: self.assessment_run_arn,
                stop_action: self.stop_action,
            })
        }
    }
}
#[doc(hidden)]
pub type StopAssessmentRunInputOperationOutputAlias = crate::operation::StopAssessmentRun;
#[doc(hidden)]
pub type StopAssessmentRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopAssessmentRunInput {
    /// Consumes the builder and constructs an Operation<[`StopAssessmentRun`](crate::operation::StopAssessmentRun)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopAssessmentRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopAssessmentRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopAssessmentRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopAssessmentRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.StopAssessmentRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_assessment_run(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopAssessmentRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopAssessmentRun",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopAssessmentRunInput`](crate::input::StopAssessmentRunInput)
    pub fn builder() -> crate::input::stop_assessment_run_input::Builder {
        crate::input::stop_assessment_run_input::Builder::default()
    }
}

/// See [`SubscribeToEventInput`](crate::input::SubscribeToEventInput)
pub mod subscribe_to_event_input {
    /// A builder for [`SubscribeToEventInput`](crate::input::SubscribeToEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) event: std::option::Option<crate::model::InspectorEvent>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to receive SNS notifications.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to receive SNS notifications.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The event for which you want to receive SNS notifications.</p>
        pub fn event(mut self, input: crate::model::InspectorEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The event for which you want to receive SNS notifications.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.event = input;
            self
        }
        /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscribeToEventInput`](crate::input::SubscribeToEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SubscribeToEventInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SubscribeToEventInput {
                resource_arn: self.resource_arn,
                event: self.event,
                topic_arn: self.topic_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type SubscribeToEventInputOperationOutputAlias = crate::operation::SubscribeToEvent;
#[doc(hidden)]
pub type SubscribeToEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubscribeToEventInput {
    /// Consumes the builder and constructs an Operation<[`SubscribeToEvent`](crate::operation::SubscribeToEvent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SubscribeToEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubscribeToEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubscribeToEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubscribeToEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.SubscribeToEvent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_subscribe_to_event(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SubscribeToEvent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SubscribeToEvent",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubscribeToEventInput`](crate::input::SubscribeToEventInput)
    pub fn builder() -> crate::input::subscribe_to_event_input::Builder {
        crate::input::subscribe_to_event_input::Builder::default()
    }
}

/// See [`UnsubscribeFromEventInput`](crate::input::UnsubscribeFromEventInput)
pub mod unsubscribe_from_event_input {
    /// A builder for [`UnsubscribeFromEventInput`](crate::input::UnsubscribeFromEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) event: std::option::Option<crate::model::InspectorEvent>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to stop receiving SNS notifications.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to stop receiving SNS notifications.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The event for which you want to stop receiving SNS notifications.</p>
        pub fn event(mut self, input: crate::model::InspectorEvent) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>The event for which you want to stop receiving SNS notifications.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.event = input;
            self
        }
        /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsubscribeFromEventInput`](crate::input::UnsubscribeFromEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnsubscribeFromEventInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnsubscribeFromEventInput {
                resource_arn: self.resource_arn,
                event: self.event,
                topic_arn: self.topic_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UnsubscribeFromEventInputOperationOutputAlias = crate::operation::UnsubscribeFromEvent;
#[doc(hidden)]
pub type UnsubscribeFromEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnsubscribeFromEventInput {
    /// Consumes the builder and constructs an Operation<[`UnsubscribeFromEvent`](crate::operation::UnsubscribeFromEvent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnsubscribeFromEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnsubscribeFromEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnsubscribeFromEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnsubscribeFromEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.UnsubscribeFromEvent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_unsubscribe_from_event(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnsubscribeFromEvent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnsubscribeFromEvent",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnsubscribeFromEventInput`](crate::input::UnsubscribeFromEventInput)
    pub fn builder() -> crate::input::unsubscribe_from_event_input::Builder {
        crate::input::unsubscribe_from_event_input::Builder::default()
    }
}

/// See [`UpdateAssessmentTargetInput`](crate::input::UpdateAssessmentTargetInput)
pub mod update_assessment_target_input {
    /// A builder for [`UpdateAssessmentTargetInput`](crate::input::UpdateAssessmentTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_target_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_target_name: std::option::Option<std::string::String>,
        pub(crate) resource_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the assessment target that you want to update.</p>
        pub fn assessment_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the assessment target that you want to update.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_target_arn = input;
            self
        }
        /// <p>The name of the assessment target that you want to update.</p>
        pub fn assessment_target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_target_name = Some(input.into());
            self
        }
        /// <p>The name of the assessment target that you want to update.</p>
        pub fn set_assessment_target_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_target_name = input;
            self
        }
        /// <p>The ARN of the resource group that is used to specify the new resource group to
        /// associate with the assessment target.</p>
        pub fn resource_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource group that is used to specify the new resource group to
        /// associate with the assessment target.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentTargetInput`](crate::input::UpdateAssessmentTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssessmentTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssessmentTargetInput {
                assessment_target_arn: self.assessment_target_arn,
                assessment_target_name: self.assessment_target_name,
                resource_group_arn: self.resource_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssessmentTargetInputOperationOutputAlias = crate::operation::UpdateAssessmentTarget;
#[doc(hidden)]
pub type UpdateAssessmentTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssessmentTargetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssessmentTarget`](crate::operation::UpdateAssessmentTarget)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssessmentTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssessmentTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssessmentTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssessmentTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "InspectorService.UpdateAssessmentTarget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_assessment_target(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssessmentTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssessmentTarget",
            "inspector",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentTargetInput`](crate::input::UpdateAssessmentTargetInput)
    pub fn builder() -> crate::input::update_assessment_target_input::Builder {
        crate::input::update_assessment_target_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentTargetInput {
    /// <p>The ARN of the assessment target that you want to update.</p>
    pub assessment_target_arn: std::option::Option<std::string::String>,
    /// <p>The name of the assessment target that you want to update.</p>
    pub assessment_target_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource group that is used to specify the new resource group to
    /// associate with the assessment target.</p>
    pub resource_group_arn: std::option::Option<std::string::String>,
}
impl UpdateAssessmentTargetInput {
    /// <p>The ARN of the assessment target that you want to update.</p>
    pub fn assessment_target_arn(&self) -> std::option::Option<&str> {
        self.assessment_target_arn.as_deref()
    }
    /// <p>The name of the assessment target that you want to update.</p>
    pub fn assessment_target_name(&self) -> std::option::Option<&str> {
        self.assessment_target_name.as_deref()
    }
    /// <p>The ARN of the resource group that is used to specify the new resource group to
    /// associate with the assessment target.</p>
    pub fn resource_group_arn(&self) -> std::option::Option<&str> {
        self.resource_group_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAssessmentTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentTargetInput");
        formatter.field("assessment_target_arn", &self.assessment_target_arn);
        formatter.field("assessment_target_name", &self.assessment_target_name);
        formatter.field("resource_group_arn", &self.resource_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsubscribeFromEventInput {
    /// <p>The ARN of the assessment template that is used during the event for which you want
    /// to stop receiving SNS notifications.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The event for which you want to stop receiving SNS notifications.</p>
    pub event: std::option::Option<crate::model::InspectorEvent>,
    /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl UnsubscribeFromEventInput {
    /// <p>The ARN of the assessment template that is used during the event for which you want
    /// to stop receiving SNS notifications.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The event for which you want to stop receiving SNS notifications.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::InspectorEvent> {
        self.event.as_ref()
    }
    /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for UnsubscribeFromEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsubscribeFromEventInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("event", &self.event);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscribeToEventInput {
    /// <p>The ARN of the assessment template that is used during the event for which you want
    /// to receive SNS notifications.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The event for which you want to receive SNS notifications.</p>
    pub event: std::option::Option<crate::model::InspectorEvent>,
    /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl SubscribeToEventInput {
    /// <p>The ARN of the assessment template that is used during the event for which you want
    /// to receive SNS notifications.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The event for which you want to receive SNS notifications.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::InspectorEvent> {
        self.event.as_ref()
    }
    /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for SubscribeToEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscribeToEventInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("event", &self.event);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopAssessmentRunInput {
    /// <p>The ARN of the assessment run that you want to stop.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
    /// START_EVALUATION (the default value), stops the AWS agent from collecting data and begins
    /// the results evaluation and the findings generation process. SKIP_EVALUATION cancels the
    /// assessment run immediately, after which no findings are generated.</p>
    pub stop_action: std::option::Option<crate::model::StopAction>,
}
impl StopAssessmentRunInput {
    /// <p>The ARN of the assessment run that you want to stop.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
    /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
    /// START_EVALUATION (the default value), stops the AWS agent from collecting data and begins
    /// the results evaluation and the findings generation process. SKIP_EVALUATION cancels the
    /// assessment run immediately, after which no findings are generated.</p>
    pub fn stop_action(&self) -> std::option::Option<&crate::model::StopAction> {
        self.stop_action.as_ref()
    }
}
impl std::fmt::Debug for StopAssessmentRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopAssessmentRunInput");
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.field("stop_action", &self.stop_action);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAssessmentRunInput {
    /// <p>The ARN of the assessment template of the assessment run that you want to
    /// start.</p>
    pub assessment_template_arn: std::option::Option<std::string::String>,
    /// <p>You can specify the name for the assessment run. The name must be unique for the
    /// assessment template whose ARN is used to start the assessment run.</p>
    pub assessment_run_name: std::option::Option<std::string::String>,
}
impl StartAssessmentRunInput {
    /// <p>The ARN of the assessment template of the assessment run that you want to
    /// start.</p>
    pub fn assessment_template_arn(&self) -> std::option::Option<&str> {
        self.assessment_template_arn.as_deref()
    }
    /// <p>You can specify the name for the assessment run. The name must be unique for the
    /// assessment template whose ARN is used to start the assessment run.</p>
    pub fn assessment_run_name(&self) -> std::option::Option<&str> {
        self.assessment_run_name.as_deref()
    }
}
impl std::fmt::Debug for StartAssessmentRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAssessmentRunInput");
        formatter.field("assessment_template_arn", &self.assessment_template_arn);
        formatter.field("assessment_run_name", &self.assessment_run_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTagsForResourceInput {
    /// <p>The ARN of the assessment template that you want to set tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A collection of key and value pairs that you want to set to the assessment
    /// template.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl SetTagsForResourceInput {
    /// <p>The ARN of the assessment template that you want to set tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A collection of key and value pairs that you want to set to the assessment
    /// template.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for SetTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAttributesFromFindingsInput {
    /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
    pub finding_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The array of attribute keys that you want to remove from specified
    /// findings.</p>
    pub attribute_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveAttributesFromFindingsInput {
    /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
    pub fn finding_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_arns.as_deref()
    }
    /// <p>The array of attribute keys that you want to remove from specified
    /// findings.</p>
    pub fn attribute_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_keys.as_deref()
    }
}
impl std::fmt::Debug for RemoveAttributesFromFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAttributesFromFindingsInput");
        formatter.field("finding_arns", &self.finding_arns);
        formatter.field("attribute_keys", &self.attribute_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterCrossAccountAccessRoleInput {
    /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to
    /// perform security assessments. </p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl RegisterCrossAccountAccessRoleInput {
    /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to
    /// perform security assessments. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for RegisterCrossAccountAccessRoleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterCrossAccountAccessRoleInput");
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreviewAgentsInput {
    /// <p>The ARN of the assessment target whose agents you want to preview.</p>
    pub preview_agents_arn: std::option::Option<std::string::String>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>PreviewAgents</b> action.
    /// Subsequent calls to the action fill <b>nextToken</b> in the
    /// request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl PreviewAgentsInput {
    /// <p>The ARN of the assessment target whose agents you want to preview.</p>
    pub fn preview_agents_arn(&self) -> std::option::Option<&str> {
        self.preview_agents_arn.as_deref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>PreviewAgents</b> action.
    /// Subsequent calls to the action fill <b>nextToken</b> in the
    /// request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for PreviewAgentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreviewAgentsInput");
        formatter.field("preview_agents_arn", &self.preview_agents_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesPackagesInput {
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListRulesPackages</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListRulesPackagesInput {
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListRulesPackages</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRulesPackagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesPackagesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsInput {
    /// <p>The ARNs of the assessment runs that generate the findings that you want to
    /// list.</p>
    pub assessment_run_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub filter: std::option::Option<crate::model::FindingFilter>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListFindings</b> action.
    /// Subsequent calls to the action fill <b>nextToken</b> in the
    /// request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListFindingsInput {
    /// <p>The ARNs of the assessment runs that generate the findings that you want to
    /// list.</p>
    pub fn assessment_run_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.assessment_run_arns.as_deref()
    }
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::FindingFilter> {
        self.filter.as_ref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListFindings</b> action.
    /// Subsequent calls to the action fill <b>nextToken</b> in the
    /// request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsInput");
        formatter.field("assessment_run_arns", &self.assessment_run_arns);
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExclusionsInput {
    /// <p>The ARN of the assessment run that generated the exclusions that you want to
    /// list.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the ListExclusionsRequest action. Subsequent calls to the
    /// action fill nextToken in the request with the value of nextToken from the previous response
    /// to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 100. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListExclusionsInput {
    /// <p>The ARN of the assessment run that generated the exclusions that you want to
    /// list.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the ListExclusionsRequest action. Subsequent calls to the
    /// action fill nextToken in the request with the value of nextToken from the previous response
    /// to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 100. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListExclusionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExclusionsInput");
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventSubscriptionsInput {
    /// <p>The ARN of the assessment template for which you want to list the existing event
    /// subscriptions.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListEventSubscriptions</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEventSubscriptionsInput {
    /// <p>The ARN of the assessment template for which you want to list the existing event
    /// subscriptions.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListEventSubscriptions</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEventSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventSubscriptionsInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentTemplatesInput {
    /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you
    /// want to list.</p>
    pub assessment_target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub filter: std::option::Option<crate::model::AssessmentTemplateFilter>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentTemplates</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssessmentTemplatesInput {
    /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you
    /// want to list.</p>
    pub fn assessment_target_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.assessment_target_arns.as_deref()
    }
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::AssessmentTemplateFilter> {
        self.filter.as_ref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentTemplates</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssessmentTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentTemplatesInput");
        formatter.field("assessment_target_arns", &self.assessment_target_arns);
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentTargetsInput {
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub filter: std::option::Option<crate::model::AssessmentTargetFilter>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentTargets</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssessmentTargetsInput {
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::AssessmentTargetFilter> {
        self.filter.as_ref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentTargets</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssessmentTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentTargetsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentRunsInput {
    /// <p>The ARNs that specify the assessment templates whose assessment runs you want to
    /// list.</p>
    pub assessment_template_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub filter: std::option::Option<crate::model::AssessmentRunFilter>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentRuns</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items that you want in
    /// the response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssessmentRunsInput {
    /// <p>The ARNs that specify the assessment templates whose assessment runs you want to
    /// list.</p>
    pub fn assessment_template_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.assessment_template_arns.as_deref()
    }
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::AssessmentRunFilter> {
        self.filter.as_ref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentRuns</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items that you want in
    /// the response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssessmentRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentRunsInput");
        formatter.field("assessment_template_arns", &self.assessment_template_arns);
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentRunAgentsInput {
    /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub filter: std::option::Option<crate::model::AgentFilter>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentRunAgents</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items that you want in
    /// the response. The default value is 10. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssessmentRunAgentsInput {
    /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
    /// <p>You can use this parameter to specify a subset of data to be included in the action's
    /// response.</p>
    /// <p>For a record to match a filter, all specified filter attributes must match. When
    /// multiple values are specified for a filter attribute, any of the values can
    /// match.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::AgentFilter> {
        self.filter.as_ref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the <b>ListAssessmentRunAgents</b>
    /// action. Subsequent calls to the action fill <b>nextToken</b> in
    /// the request with the value of <b>NextToken</b> from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items that you want in
    /// the response. The default value is 10. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssessmentRunAgentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentRunAgentsInput");
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTelemetryMetadataInput {
    /// <p>The ARN that specifies the assessment run that has the telemetry data that you want
    /// to obtain.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
}
impl GetTelemetryMetadataInput {
    /// <p>The ARN that specifies the assessment run that has the telemetry data that you want
    /// to obtain.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
}
impl std::fmt::Debug for GetTelemetryMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTelemetryMetadataInput");
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExclusionsPreviewInput {
    /// <p>The ARN that specifies the assessment template for which the exclusions preview was
    /// requested.</p>
    pub assessment_template_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier associated of the exclusions preview.</p>
    pub preview_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to
    /// the action fill nextToken in the request with the value of nextToken from the previous
    /// response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 100. The maximum value is 500.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The locale into which you want to translate the exclusion's title, description, and
    /// recommendation.</p>
    pub locale: std::option::Option<crate::model::Locale>,
}
impl GetExclusionsPreviewInput {
    /// <p>The ARN that specifies the assessment template for which the exclusions preview was
    /// requested.</p>
    pub fn assessment_template_arn(&self) -> std::option::Option<&str> {
        self.assessment_template_arn.as_deref()
    }
    /// <p>The unique identifier associated of the exclusions preview.</p>
    pub fn preview_token(&self) -> std::option::Option<&str> {
        self.preview_token.as_deref()
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter
    /// to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to
    /// the action fill nextToken in the request with the value of nextToken from the previous
    /// response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the
    /// response. The default value is 100. The maximum value is 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The locale into which you want to translate the exclusion's title, description, and
    /// recommendation.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
}
impl std::fmt::Debug for GetExclusionsPreviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExclusionsPreviewInput");
        formatter.field("assessment_template_arn", &self.assessment_template_arn);
        formatter.field("preview_token", &self.preview_token);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssessmentReportInput {
    /// <p>The ARN that specifies the assessment run for which you want to generate a
    /// report.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the file format (html or pdf) of the assessment report that you want to
    /// generate.</p>
    pub report_file_format: std::option::Option<crate::model::ReportFileFormat>,
    /// <p>Specifies the type of the assessment report that you want to generate. There are two
    /// types of assessment reports: a finding report and a full report. For more information, see
    /// <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
    pub report_type: std::option::Option<crate::model::ReportType>,
}
impl GetAssessmentReportInput {
    /// <p>The ARN that specifies the assessment run for which you want to generate a
    /// report.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
    /// <p>Specifies the file format (html or pdf) of the assessment report that you want to
    /// generate.</p>
    pub fn report_file_format(&self) -> std::option::Option<&crate::model::ReportFileFormat> {
        self.report_file_format.as_ref()
    }
    /// <p>Specifies the type of the assessment report that you want to generate. There are two
    /// types of assessment reports: a finding report and a full report. For more information, see
    /// <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
    pub fn report_type(&self) -> std::option::Option<&crate::model::ReportType> {
        self.report_type.as_ref()
    }
}
impl std::fmt::Debug for GetAssessmentReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssessmentReportInput");
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.field("report_file_format", &self.report_file_format);
        formatter.field("report_type", &self.report_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRulesPackagesInput {
    /// <p>The ARN that specifies the rules package that you want to describe.</p>
    pub rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The locale that you want to translate a rules package description into.</p>
    pub locale: std::option::Option<crate::model::Locale>,
}
impl DescribeRulesPackagesInput {
    /// <p>The ARN that specifies the rules package that you want to describe.</p>
    pub fn rules_package_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rules_package_arns.as_deref()
    }
    /// <p>The locale that you want to translate a rules package description into.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
}
impl std::fmt::Debug for DescribeRulesPackagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRulesPackagesInput");
        formatter.field("rules_package_arns", &self.rules_package_arns);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourceGroupsInput {
    /// <p>The ARN that specifies the resource group that you want to describe.</p>
    pub resource_group_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeResourceGroupsInput {
    /// <p>The ARN that specifies the resource group that you want to describe.</p>
    pub fn resource_group_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_group_arns.as_deref()
    }
}
impl std::fmt::Debug for DescribeResourceGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourceGroupsInput");
        formatter.field("resource_group_arns", &self.resource_group_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFindingsInput {
    /// <p>The ARN that specifies the finding that you want to describe.</p>
    pub finding_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The locale into which you want to translate a finding description, recommendation,
    /// and the short description that identifies the finding.</p>
    pub locale: std::option::Option<crate::model::Locale>,
}
impl DescribeFindingsInput {
    /// <p>The ARN that specifies the finding that you want to describe.</p>
    pub fn finding_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_arns.as_deref()
    }
    /// <p>The locale into which you want to translate a finding description, recommendation,
    /// and the short description that identifies the finding.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
}
impl std::fmt::Debug for DescribeFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFindingsInput");
        formatter.field("finding_arns", &self.finding_arns);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExclusionsInput {
    /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
    pub exclusion_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The locale into which you want to translate the exclusion's title, description, and
    /// recommendation.</p>
    pub locale: std::option::Option<crate::model::Locale>,
}
impl DescribeExclusionsInput {
    /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
    pub fn exclusion_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.exclusion_arns.as_deref()
    }
    /// <p>The locale into which you want to translate the exclusion's title, description, and
    /// recommendation.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
}
impl std::fmt::Debug for DescribeExclusionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExclusionsInput");
        formatter.field("exclusion_arns", &self.exclusion_arns);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCrossAccountAccessRoleInput {}
impl std::fmt::Debug for DescribeCrossAccountAccessRoleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCrossAccountAccessRoleInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssessmentTemplatesInput {
    #[allow(missing_docs)] // documentation missing in model
    pub assessment_template_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeAssessmentTemplatesInput {
    #[allow(missing_docs)] // documentation missing in model
    pub fn assessment_template_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.assessment_template_arns.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssessmentTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssessmentTemplatesInput");
        formatter.field("assessment_template_arns", &self.assessment_template_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssessmentTargetsInput {
    /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
    pub assessment_target_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeAssessmentTargetsInput {
    /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
    pub fn assessment_target_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.assessment_target_arns.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssessmentTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssessmentTargetsInput");
        formatter.field("assessment_target_arns", &self.assessment_target_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssessmentRunsInput {
    /// <p>The ARN that specifies the assessment run that you want to describe.</p>
    pub assessment_run_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeAssessmentRunsInput {
    /// <p>The ARN that specifies the assessment run that you want to describe.</p>
    pub fn assessment_run_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.assessment_run_arns.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssessmentRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssessmentRunsInput");
        formatter.field("assessment_run_arns", &self.assessment_run_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentTemplateInput {
    /// <p>The ARN that specifies the assessment template that you want to delete.</p>
    pub assessment_template_arn: std::option::Option<std::string::String>,
}
impl DeleteAssessmentTemplateInput {
    /// <p>The ARN that specifies the assessment template that you want to delete.</p>
    pub fn assessment_template_arn(&self) -> std::option::Option<&str> {
        self.assessment_template_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssessmentTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentTemplateInput");
        formatter.field("assessment_template_arn", &self.assessment_template_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentTargetInput {
    /// <p>The ARN that specifies the assessment target that you want to delete.</p>
    pub assessment_target_arn: std::option::Option<std::string::String>,
}
impl DeleteAssessmentTargetInput {
    /// <p>The ARN that specifies the assessment target that you want to delete.</p>
    pub fn assessment_target_arn(&self) -> std::option::Option<&str> {
        self.assessment_target_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssessmentTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentTargetInput");
        formatter.field("assessment_target_arn", &self.assessment_target_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentRunInput {
    /// <p>The ARN that specifies the assessment run that you want to delete.</p>
    pub assessment_run_arn: std::option::Option<std::string::String>,
}
impl DeleteAssessmentRunInput {
    /// <p>The ARN that specifies the assessment run that you want to delete.</p>
    pub fn assessment_run_arn(&self) -> std::option::Option<&str> {
        self.assessment_run_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAssessmentRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentRunInput");
        formatter.field("assessment_run_arn", &self.assessment_run_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceGroupInput {
    /// <p>A collection of keys and an array of possible values,
    /// '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
    /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
    pub resource_group_tags: std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
}
impl CreateResourceGroupInput {
    /// <p>A collection of keys and an array of possible values,
    /// '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
    /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
    pub fn resource_group_tags(&self) -> std::option::Option<&[crate::model::ResourceGroupTag]> {
        self.resource_group_tags.as_deref()
    }
}
impl std::fmt::Debug for CreateResourceGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceGroupInput");
        formatter.field("resource_group_tags", &self.resource_group_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExclusionsPreviewInput {
    /// <p>The ARN that specifies the assessment template for which you want to create an
    /// exclusions preview.</p>
    pub assessment_template_arn: std::option::Option<std::string::String>,
}
impl CreateExclusionsPreviewInput {
    /// <p>The ARN that specifies the assessment template for which you want to create an
    /// exclusions preview.</p>
    pub fn assessment_template_arn(&self) -> std::option::Option<&str> {
        self.assessment_template_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateExclusionsPreviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExclusionsPreviewInput");
        formatter.field("assessment_template_arn", &self.assessment_template_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentTemplateInput {
    /// <p>The ARN that specifies the assessment target for which you want to create the
    /// assessment template.</p>
    pub assessment_target_arn: std::option::Option<std::string::String>,
    /// <p>The user-defined name that identifies the assessment template that you want to
    /// create. You can create several assessment templates for an assessment target. The names of
    /// the assessment templates that correspond to a particular assessment target must be
    /// unique.</p>
    pub assessment_template_name: std::option::Option<std::string::String>,
    /// <p>The duration of the assessment run in seconds.</p>
    pub duration_in_seconds: i32,
    /// <p>The ARNs that specify the rules packages that you want to attach to the assessment
    /// template.</p>
    pub rules_package_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user-defined attributes that are assigned to every finding that is generated by
    /// the assessment run that uses this assessment template. An attribute is a key and value pair
    /// (an <a>Attribute</a> object). Within an assessment template, each key must be
    /// unique.</p>
    pub user_attributes_for_findings: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl CreateAssessmentTemplateInput {
    /// <p>The ARN that specifies the assessment target for which you want to create the
    /// assessment template.</p>
    pub fn assessment_target_arn(&self) -> std::option::Option<&str> {
        self.assessment_target_arn.as_deref()
    }
    /// <p>The user-defined name that identifies the assessment template that you want to
    /// create. You can create several assessment templates for an assessment target. The names of
    /// the assessment templates that correspond to a particular assessment target must be
    /// unique.</p>
    pub fn assessment_template_name(&self) -> std::option::Option<&str> {
        self.assessment_template_name.as_deref()
    }
    /// <p>The duration of the assessment run in seconds.</p>
    pub fn duration_in_seconds(&self) -> i32 {
        self.duration_in_seconds
    }
    /// <p>The ARNs that specify the rules packages that you want to attach to the assessment
    /// template.</p>
    pub fn rules_package_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.rules_package_arns.as_deref()
    }
    /// <p>The user-defined attributes that are assigned to every finding that is generated by
    /// the assessment run that uses this assessment template. An attribute is a key and value pair
    /// (an <a>Attribute</a> object). Within an assessment template, each key must be
    /// unique.</p>
    pub fn user_attributes_for_findings(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.user_attributes_for_findings.as_deref()
    }
}
impl std::fmt::Debug for CreateAssessmentTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentTemplateInput");
        formatter.field("assessment_target_arn", &self.assessment_target_arn);
        formatter.field("assessment_template_name", &self.assessment_template_name);
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.field("rules_package_arns", &self.rules_package_arns);
        formatter.field(
            "user_attributes_for_findings",
            &self.user_attributes_for_findings,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentTargetInput {
    /// <p>The user-defined name that identifies the assessment target that you want to create.
    /// The name must be unique within the AWS account.</p>
    pub assessment_target_name: std::option::Option<std::string::String>,
    /// <p>The ARN that specifies the resource group that is used to create the assessment
    /// target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
    /// and region are included in the assessment target.</p>
    pub resource_group_arn: std::option::Option<std::string::String>,
}
impl CreateAssessmentTargetInput {
    /// <p>The user-defined name that identifies the assessment target that you want to create.
    /// The name must be unique within the AWS account.</p>
    pub fn assessment_target_name(&self) -> std::option::Option<&str> {
        self.assessment_target_name.as_deref()
    }
    /// <p>The ARN that specifies the resource group that is used to create the assessment
    /// target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
    /// and region are included in the assessment target.</p>
    pub fn resource_group_arn(&self) -> std::option::Option<&str> {
        self.resource_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAssessmentTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentTargetInput");
        formatter.field("assessment_target_name", &self.assessment_target_name);
        formatter.field("resource_group_arn", &self.resource_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddAttributesToFindingsInput {
    /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
    pub finding_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The array of attributes that you want to assign to specified findings.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl AddAttributesToFindingsInput {
    /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
    pub fn finding_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_arns.as_deref()
    }
    /// <p>The array of attributes that you want to assign to specified findings.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for AddAttributesToFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddAttributesToFindingsInput");
        formatter.field("finding_arns", &self.finding_arns);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
