// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You started an assessment run, but one of the instances is already participating in
    /// another assessment run.</p>
    AgentsAlreadyRunningAssessmentException(crate::error::AgentsAlreadyRunningAssessmentException),
    /// <p>You cannot perform a specified action if an assessment run is currently in
    /// progress.</p>
    AssessmentRunInProgressException(crate::error::AssessmentRunInProgressException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>Amazon Inspector cannot assume the cross-account role that it needs to list your EC2
    /// instances during the assessment run.</p>
    InvalidCrossAccountRoleException(crate::error::InvalidCrossAccountRoleException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current
    /// AWS account limits. The error code describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request is rejected. The specified assessment template is currently generating an
    /// exclusions preview.</p>
    PreviewGenerationInProgressException(crate::error::PreviewGenerationInProgressException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// <p>Used by the <a>GetAssessmentReport</a> API. The request was rejected
    /// because you tried to generate a report for an assessment run that existed before reporting
    /// was supported in Amazon Inspector. You can only generate reports for assessment runs that
    /// took place or will take place after generating reports in Amazon Inspector became
    /// available.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AgentsAlreadyRunningAssessmentException(inner) => inner.fmt(f),
            Error::AssessmentRunInProgressException(inner) => inner.fmt(f),
            Error::InternalException(inner) => inner.fmt(f),
            Error::InvalidCrossAccountRoleException(inner) => inner.fmt(f),
            Error::InvalidInputException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::NoSuchEntityException(inner) => inner.fmt(f),
            Error::PreviewGenerationInProgressException(inner) => inner.fmt(f),
            Error::ServiceTemporarilyUnavailableException(inner) => inner.fmt(f),
            Error::UnsupportedFeatureException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddAttributesToFindingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddAttributesToFindingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AddAttributesToFindingsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AddAttributesToFindingsErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::AddAttributesToFindingsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::AddAttributesToFindingsErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::AddAttributesToFindingsErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::AddAttributesToFindingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTargetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTargetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateAssessmentTargetErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateAssessmentTargetErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::CreateAssessmentTargetErrorKind::InvalidCrossAccountRoleException(inner) => Error::InvalidCrossAccountRoleException(inner),
                crate::error::CreateAssessmentTargetErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateAssessmentTargetErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateAssessmentTargetErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::CreateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::CreateAssessmentTargetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTemplateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateAssessmentTemplateErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateAssessmentTemplateErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::CreateAssessmentTemplateErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateAssessmentTemplateErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateAssessmentTemplateErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::CreateAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::CreateAssessmentTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateExclusionsPreviewError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateExclusionsPreviewError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateExclusionsPreviewErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateExclusionsPreviewErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::CreateExclusionsPreviewErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateExclusionsPreviewErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::CreateExclusionsPreviewErrorKind::PreviewGenerationInProgressException(inner) => Error::PreviewGenerationInProgressException(inner),
                crate::error::CreateExclusionsPreviewErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::CreateExclusionsPreviewErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResourceGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateResourceGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateResourceGroupErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateResourceGroupErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::CreateResourceGroupErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateResourceGroupErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateResourceGroupErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::CreateResourceGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAssessmentRunErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteAssessmentRunErrorKind::AssessmentRunInProgressException(inner) => Error::AssessmentRunInProgressException(inner),
                crate::error::DeleteAssessmentRunErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::DeleteAssessmentRunErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteAssessmentRunErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::DeleteAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::DeleteAssessmentRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTargetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTargetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAssessmentTargetErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteAssessmentTargetErrorKind::AssessmentRunInProgressException(inner) => Error::AssessmentRunInProgressException(inner),
                crate::error::DeleteAssessmentTargetErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::DeleteAssessmentTargetErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteAssessmentTargetErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::DeleteAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::DeleteAssessmentTargetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTemplateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAssessmentTemplateErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteAssessmentTemplateErrorKind::AssessmentRunInProgressException(inner) => Error::AssessmentRunInProgressException(inner),
                crate::error::DeleteAssessmentTemplateErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::DeleteAssessmentTemplateErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteAssessmentTemplateErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::DeleteAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::DeleteAssessmentTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentRunsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentRunsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAssessmentRunsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeAssessmentRunsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeAssessmentRunsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAssessmentTargetsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeAssessmentTargetsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeAssessmentTargetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTemplatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTemplatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAssessmentTemplatesErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeAssessmentTemplatesErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::DescribeAssessmentTemplatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeCrossAccountAccessRoleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeCrossAccountAccessRoleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCrossAccountAccessRoleErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeCrossAccountAccessRoleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeExclusionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeExclusionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeExclusionsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeExclusionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeExclusionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFindingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFindingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeFindingsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeFindingsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeFindingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeResourceGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeResourceGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeResourceGroupsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeResourceGroupsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeResourceGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeRulesPackagesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeRulesPackagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeRulesPackagesErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::DescribeRulesPackagesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DescribeRulesPackagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAssessmentReportError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAssessmentReportError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAssessmentReportErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetAssessmentReportErrorKind::AssessmentRunInProgressException(inner) => Error::AssessmentRunInProgressException(inner),
                crate::error::GetAssessmentReportErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::GetAssessmentReportErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetAssessmentReportErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::GetAssessmentReportErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::GetAssessmentReportErrorKind::UnsupportedFeatureException(inner) => Error::UnsupportedFeatureException(inner),
                crate::error::GetAssessmentReportErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetExclusionsPreviewError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetExclusionsPreviewError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetExclusionsPreviewErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetExclusionsPreviewErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::GetExclusionsPreviewErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetExclusionsPreviewErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::GetExclusionsPreviewErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTelemetryMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTelemetryMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTelemetryMetadataErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetTelemetryMetadataErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::GetTelemetryMetadataErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTelemetryMetadataErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::GetTelemetryMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunAgentsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunAgentsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAssessmentRunAgentsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListAssessmentRunAgentsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListAssessmentRunAgentsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListAssessmentRunAgentsErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::ListAssessmentRunAgentsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAssessmentRunsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListAssessmentRunsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListAssessmentRunsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListAssessmentRunsErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::ListAssessmentRunsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAssessmentTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAssessmentTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAssessmentTargetsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListAssessmentTargetsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListAssessmentTargetsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListAssessmentTargetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAssessmentTemplatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAssessmentTemplatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAssessmentTemplatesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListAssessmentTemplatesErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListAssessmentTemplatesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListAssessmentTemplatesErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::ListAssessmentTemplatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListEventSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListEventSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListEventSubscriptionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListEventSubscriptionsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListEventSubscriptionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListEventSubscriptionsErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::ListEventSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListExclusionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListExclusionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListExclusionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListExclusionsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListExclusionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListExclusionsErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::ListExclusionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFindingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListFindingsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFindingsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFindingsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListFindingsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListFindingsErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::ListFindingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListRulesPackagesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListRulesPackagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListRulesPackagesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListRulesPackagesErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListRulesPackagesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListRulesPackagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PreviewAgentsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PreviewAgentsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PreviewAgentsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::PreviewAgentsErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::PreviewAgentsErrorKind::InvalidCrossAccountRoleException(inner) => {
                    Error::InvalidCrossAccountRoleException(inner)
                }
                crate::error::PreviewAgentsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::PreviewAgentsErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::PreviewAgentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RegisterCrossAccountAccessRoleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RegisterCrossAccountAccessRoleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterCrossAccountAccessRoleErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RegisterCrossAccountAccessRoleErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::RegisterCrossAccountAccessRoleErrorKind::InvalidCrossAccountRoleException(inner) => Error::InvalidCrossAccountRoleException(inner),
                crate::error::RegisterCrossAccountAccessRoleErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::RegisterCrossAccountAccessRoleErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::RegisterCrossAccountAccessRoleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveAttributesFromFindingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveAttributesFromFindingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveAttributesFromFindingsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RemoveAttributesFromFindingsErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::RemoveAttributesFromFindingsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::RemoveAttributesFromFindingsErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::RemoveAttributesFromFindingsErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::RemoveAttributesFromFindingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::SetTagsForResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::SetTagsForResourceErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::SetTagsForResourceErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::SetTagsForResourceErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::SetTagsForResourceErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::SetTagsForResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartAssessmentRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartAssessmentRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartAssessmentRunErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartAssessmentRunErrorKind::AgentsAlreadyRunningAssessmentException(inner) => Error::AgentsAlreadyRunningAssessmentException(inner),
                crate::error::StartAssessmentRunErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::StartAssessmentRunErrorKind::InvalidCrossAccountRoleException(inner) => Error::InvalidCrossAccountRoleException(inner),
                crate::error::StartAssessmentRunErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::StartAssessmentRunErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartAssessmentRunErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::StartAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::StartAssessmentRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopAssessmentRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopAssessmentRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopAssessmentRunErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StopAssessmentRunErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::StopAssessmentRunErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::StopAssessmentRunErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::StopAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::StopAssessmentRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SubscribeToEventError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SubscribeToEventError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SubscribeToEventErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SubscribeToEventErrorKind::InternalException(inner) => {
                    Error::InternalException(inner)
                }
                crate::error::SubscribeToEventErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::SubscribeToEventErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::SubscribeToEventErrorKind::NoSuchEntityException(inner) => {
                    Error::NoSuchEntityException(inner)
                }
                crate::error::SubscribeToEventErrorKind::ServiceTemporarilyUnavailableException(
                    inner,
                ) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::SubscribeToEventErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UnsubscribeFromEventError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UnsubscribeFromEventError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UnsubscribeFromEventErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UnsubscribeFromEventErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::UnsubscribeFromEventErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UnsubscribeFromEventErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::UnsubscribeFromEventErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::UnsubscribeFromEventErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentTargetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentTargetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateAssessmentTargetErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateAssessmentTargetErrorKind::InternalException(inner) => Error::InternalException(inner),
                crate::error::UpdateAssessmentTargetErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UpdateAssessmentTargetErrorKind::NoSuchEntityException(inner) => Error::NoSuchEntityException(inner),
                crate::error::UpdateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(inner) => Error::ServiceTemporarilyUnavailableException(inner),
                crate::error::UpdateAssessmentTargetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
