// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddAttributesToFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddAttributesToFindingsError {
    /// Kind of error that occurred.
    pub kind: AddAttributesToFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddAttributesToFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddAttributesToFindingsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddAttributesToFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddAttributesToFindingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AddAttributesToFindingsErrorKind::InternalException(_inner) => _inner.fmt(f),
            AddAttributesToFindingsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AddAttributesToFindingsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            AddAttributesToFindingsErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            AddAttributesToFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddAttributesToFindingsError {
    fn code(&self) -> Option<&str> {
        AddAttributesToFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddAttributesToFindingsError {
    /// Creates a new `AddAttributesToFindingsError`.
    pub fn new(kind: AddAttributesToFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddAttributesToFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddAttributesToFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddAttributesToFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddAttributesToFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddAttributesToFindingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddAttributesToFindingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AddAttributesToFindingsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddAttributesToFindingsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `AddAttributesToFindingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddAttributesToFindingsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AddAttributesToFindingsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddAttributesToFindingsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `AddAttributesToFindingsErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddAttributesToFindingsErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for AddAttributesToFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddAttributesToFindingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AddAttributesToFindingsErrorKind::InternalException(_inner) => Some(_inner),
            AddAttributesToFindingsErrorKind::InvalidInputException(_inner) => Some(_inner),
            AddAttributesToFindingsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            AddAttributesToFindingsErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            AddAttributesToFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAssessmentTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssessmentTargetError {
    /// Kind of error that occurred.
    pub kind: CreateAssessmentTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssessmentTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssessmentTargetErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>Amazon Inspector cannot assume the cross-account role that it needs to list your EC2
    /// instances during the assessment run.</p>
    InvalidCrossAccountRoleException(crate::error::InvalidCrossAccountRoleException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current
    /// AWS account limits. The error code describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssessmentTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssessmentTargetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAssessmentTargetErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateAssessmentTargetErrorKind::InvalidCrossAccountRoleException(_inner) => {
                _inner.fmt(f)
            }
            CreateAssessmentTargetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateAssessmentTargetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAssessmentTargetErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateAssessmentTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssessmentTargetError {
    fn code(&self) -> Option<&str> {
        CreateAssessmentTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssessmentTargetError {
    /// Creates a new `CreateAssessmentTargetError`.
    pub fn new(kind: CreateAssessmentTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssessmentTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssessmentTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssessmentTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssessmentTargetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssessmentTargetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTargetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTargetErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTargetErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTargetErrorKind::InvalidCrossAccountRoleException`.
    pub fn is_invalid_cross_account_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTargetErrorKind::InvalidCrossAccountRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTargetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTargetErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTargetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTargetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTargetErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTargetErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateAssessmentTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssessmentTargetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAssessmentTargetErrorKind::InternalException(_inner) => Some(_inner),
            CreateAssessmentTargetErrorKind::InvalidCrossAccountRoleException(_inner) => {
                Some(_inner)
            }
            CreateAssessmentTargetErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateAssessmentTargetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAssessmentTargetErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateAssessmentTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAssessmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssessmentTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateAssessmentTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssessmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssessmentTemplateErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current
    /// AWS account limits. The error code describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssessmentTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssessmentTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAssessmentTemplateErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateAssessmentTemplateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateAssessmentTemplateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAssessmentTemplateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateAssessmentTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssessmentTemplateError {
    fn code(&self) -> Option<&str> {
        CreateAssessmentTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssessmentTemplateError {
    /// Creates a new `CreateAssessmentTemplateError`.
    pub fn new(kind: CreateAssessmentTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssessmentTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssessmentTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssessmentTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssessmentTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssessmentTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTemplateErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTemplateErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTemplateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTemplateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTemplateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTemplateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTemplateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTemplateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateAssessmentTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssessmentTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAssessmentTemplateErrorKind::InternalException(_inner) => Some(_inner),
            CreateAssessmentTemplateErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateAssessmentTemplateErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAssessmentTemplateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateAssessmentTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExclusionsPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExclusionsPreviewError {
    /// Kind of error that occurred.
    pub kind: CreateExclusionsPreviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExclusionsPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExclusionsPreviewErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request is rejected. The specified assessment template is currently generating an
    /// exclusions preview.</p>
    PreviewGenerationInProgressException(crate::error::PreviewGenerationInProgressException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExclusionsPreviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExclusionsPreviewErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateExclusionsPreviewErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateExclusionsPreviewErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateExclusionsPreviewErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateExclusionsPreviewErrorKind::PreviewGenerationInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateExclusionsPreviewErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateExclusionsPreviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExclusionsPreviewError {
    fn code(&self) -> Option<&str> {
        CreateExclusionsPreviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExclusionsPreviewError {
    /// Creates a new `CreateExclusionsPreviewError`.
    pub fn new(kind: CreateExclusionsPreviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExclusionsPreviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExclusionsPreviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExclusionsPreviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExclusionsPreviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExclusionsPreviewErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExclusionsPreviewErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExclusionsPreviewErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExclusionsPreviewErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExclusionsPreviewErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExclusionsPreviewErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExclusionsPreviewErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExclusionsPreviewErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExclusionsPreviewErrorKind::PreviewGenerationInProgressException`.
    pub fn is_preview_generation_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExclusionsPreviewErrorKind::PreviewGenerationInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExclusionsPreviewErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExclusionsPreviewErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateExclusionsPreviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExclusionsPreviewErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateExclusionsPreviewErrorKind::InternalException(_inner) => Some(_inner),
            CreateExclusionsPreviewErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateExclusionsPreviewErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateExclusionsPreviewErrorKind::PreviewGenerationInProgressException(_inner) => {
                Some(_inner)
            }
            CreateExclusionsPreviewErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateExclusionsPreviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResourceGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceGroupError {
    /// Kind of error that occurred.
    pub kind: CreateResourceGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResourceGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceGroupErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current
    /// AWS account limits. The error code describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateResourceGroupErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateResourceGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateResourceGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateResourceGroupErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourceGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceGroupError {
    fn code(&self) -> Option<&str> {
        CreateResourceGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceGroupError {
    /// Creates a new `CreateResourceGroupError`.
    pub fn new(kind: CreateResourceGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourceGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceGroupErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceGroupErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceGroupErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceGroupErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateResourceGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateResourceGroupErrorKind::InternalException(_inner) => Some(_inner),
            CreateResourceGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateResourceGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateResourceGroupErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            CreateResourceGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssessmentRunError {
    /// Kind of error that occurred.
    pub kind: DeleteAssessmentRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssessmentRunErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You cannot perform a specified action if an assessment run is currently in
    /// progress.</p>
    AssessmentRunInProgressException(crate::error::AssessmentRunInProgressException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssessmentRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssessmentRunErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssessmentRunErrorKind::AssessmentRunInProgressException(_inner) => _inner.fmt(f),
            DeleteAssessmentRunErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteAssessmentRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteAssessmentRunErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAssessmentRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssessmentRunError {
    fn code(&self) -> Option<&str> {
        DeleteAssessmentRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssessmentRunError {
    /// Creates a new `DeleteAssessmentRunError`.
    pub fn new(kind: DeleteAssessmentRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssessmentRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssessmentRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssessmentRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssessmentRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssessmentRunErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentRunErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentRunErrorKind::AssessmentRunInProgressException`.
    pub fn is_assessment_run_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentRunErrorKind::AssessmentRunInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentRunErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentRunErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentRunErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentRunErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentRunErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteAssessmentRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssessmentRunErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssessmentRunErrorKind::AssessmentRunInProgressException(_inner) => Some(_inner),
            DeleteAssessmentRunErrorKind::InternalException(_inner) => Some(_inner),
            DeleteAssessmentRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteAssessmentRunErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteAssessmentRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssessmentTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssessmentTargetError {
    /// Kind of error that occurred.
    pub kind: DeleteAssessmentTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssessmentTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssessmentTargetErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You cannot perform a specified action if an assessment run is currently in
    /// progress.</p>
    AssessmentRunInProgressException(crate::error::AssessmentRunInProgressException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssessmentTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssessmentTargetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssessmentTargetErrorKind::AssessmentRunInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAssessmentTargetErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteAssessmentTargetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteAssessmentTargetErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAssessmentTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssessmentTargetError {
    fn code(&self) -> Option<&str> {
        DeleteAssessmentTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssessmentTargetError {
    /// Creates a new `DeleteAssessmentTargetError`.
    pub fn new(kind: DeleteAssessmentTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssessmentTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssessmentTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssessmentTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssessmentTargetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTargetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTargetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTargetErrorKind::AssessmentRunInProgressException`.
    pub fn is_assessment_run_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTargetErrorKind::AssessmentRunInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTargetErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTargetErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTargetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTargetErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTargetErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTargetErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteAssessmentTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssessmentTargetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssessmentTargetErrorKind::AssessmentRunInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteAssessmentTargetErrorKind::InternalException(_inner) => Some(_inner),
            DeleteAssessmentTargetErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteAssessmentTargetErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteAssessmentTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssessmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssessmentTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteAssessmentTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssessmentTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssessmentTemplateErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You cannot perform a specified action if an assessment run is currently in
    /// progress.</p>
    AssessmentRunInProgressException(crate::error::AssessmentRunInProgressException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssessmentTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssessmentTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssessmentTemplateErrorKind::AssessmentRunInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAssessmentTemplateErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteAssessmentTemplateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteAssessmentTemplateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAssessmentTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssessmentTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteAssessmentTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssessmentTemplateError {
    /// Creates a new `DeleteAssessmentTemplateError`.
    pub fn new(kind: DeleteAssessmentTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssessmentTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssessmentTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssessmentTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssessmentTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTemplateErrorKind::AssessmentRunInProgressException`.
    pub fn is_assessment_run_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTemplateErrorKind::AssessmentRunInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTemplateErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTemplateErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTemplateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTemplateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTemplateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTemplateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteAssessmentTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssessmentTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssessmentTemplateErrorKind::AssessmentRunInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteAssessmentTemplateErrorKind::InternalException(_inner) => Some(_inner),
            DeleteAssessmentTemplateErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteAssessmentTemplateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteAssessmentTemplateErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            DeleteAssessmentTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssessmentRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssessmentRunsError {
    /// Kind of error that occurred.
    pub kind: DescribeAssessmentRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssessmentRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssessmentRunsErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssessmentRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssessmentRunsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeAssessmentRunsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeAssessmentRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssessmentRunsError {
    fn code(&self) -> Option<&str> {
        DescribeAssessmentRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssessmentRunsError {
    /// Creates a new `DescribeAssessmentRunsError`.
    pub fn new(kind: DescribeAssessmentRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssessmentRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssessmentRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssessmentRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssessmentRunsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAssessmentRunsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssessmentRunsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssessmentRunsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssessmentRunsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeAssessmentRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssessmentRunsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeAssessmentRunsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeAssessmentRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssessmentTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssessmentTargetsError {
    /// Kind of error that occurred.
    pub kind: DescribeAssessmentTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssessmentTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssessmentTargetsErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssessmentTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssessmentTargetsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeAssessmentTargetsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeAssessmentTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssessmentTargetsError {
    fn code(&self) -> Option<&str> {
        DescribeAssessmentTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssessmentTargetsError {
    /// Creates a new `DescribeAssessmentTargetsError`.
    pub fn new(kind: DescribeAssessmentTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssessmentTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssessmentTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssessmentTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssessmentTargetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAssessmentTargetsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssessmentTargetsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssessmentTargetsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssessmentTargetsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeAssessmentTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssessmentTargetsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeAssessmentTargetsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeAssessmentTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssessmentTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssessmentTemplatesError {
    /// Kind of error that occurred.
    pub kind: DescribeAssessmentTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssessmentTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssessmentTemplatesErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssessmentTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssessmentTemplatesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeAssessmentTemplatesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeAssessmentTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssessmentTemplatesError {
    fn code(&self) -> Option<&str> {
        DescribeAssessmentTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssessmentTemplatesError {
    /// Creates a new `DescribeAssessmentTemplatesError`.
    pub fn new(kind: DescribeAssessmentTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssessmentTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssessmentTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssessmentTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssessmentTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAssessmentTemplatesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssessmentTemplatesErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssessmentTemplatesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssessmentTemplatesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeAssessmentTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssessmentTemplatesErrorKind::InternalException(_inner) => Some(_inner),
            DescribeAssessmentTemplatesErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeAssessmentTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCrossAccountAccessRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCrossAccountAccessRoleError {
    /// Kind of error that occurred.
    pub kind: DescribeCrossAccountAccessRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCrossAccountAccessRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCrossAccountAccessRoleErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCrossAccountAccessRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCrossAccountAccessRoleErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeCrossAccountAccessRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCrossAccountAccessRoleError {
    fn code(&self) -> Option<&str> {
        DescribeCrossAccountAccessRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCrossAccountAccessRoleError {
    /// Creates a new `DescribeCrossAccountAccessRoleError`.
    pub fn new(
        kind: DescribeCrossAccountAccessRoleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCrossAccountAccessRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCrossAccountAccessRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCrossAccountAccessRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCrossAccountAccessRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCrossAccountAccessRoleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCrossAccountAccessRoleErrorKind::InternalException(_)
        )
    }
}
impl std::error::Error for DescribeCrossAccountAccessRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCrossAccountAccessRoleErrorKind::InternalException(_inner) => Some(_inner),
            DescribeCrossAccountAccessRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExclusions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExclusionsError {
    /// Kind of error that occurred.
    pub kind: DescribeExclusionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExclusions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExclusionsErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExclusionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExclusionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeExclusionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeExclusionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExclusionsError {
    fn code(&self) -> Option<&str> {
        DescribeExclusionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExclusionsError {
    /// Creates a new `DescribeExclusionsError`.
    pub fn new(kind: DescribeExclusionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExclusionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExclusionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExclusionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExclusionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExclusionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExclusionsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExclusionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExclusionsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeExclusionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExclusionsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeExclusionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeExclusionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFindingsError {
    /// Kind of error that occurred.
    pub kind: DescribeFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFindingsErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFindingsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeFindingsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFindingsError {
    fn code(&self) -> Option<&str> {
        DescribeFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFindingsError {
    /// Creates a new `DescribeFindingsError`.
    pub fn new(kind: DescribeFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFindingsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeFindingsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeFindingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFindingsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFindingsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeFindingsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResourceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourceGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeResourceGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResourceGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourceGroupsErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourceGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourceGroupsErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeResourceGroupsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeResourceGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourceGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeResourceGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourceGroupsError {
    /// Creates a new `DescribeResourceGroupsError`.
    pub fn new(kind: DescribeResourceGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourceGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourceGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourceGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourceGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResourceGroupsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceGroupsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourceGroupsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourceGroupsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeResourceGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourceGroupsErrorKind::InternalException(_inner) => Some(_inner),
            DescribeResourceGroupsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeResourceGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRulesPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRulesPackagesError {
    /// Kind of error that occurred.
    pub kind: DescribeRulesPackagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRulesPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRulesPackagesErrorKind {
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRulesPackagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRulesPackagesErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeRulesPackagesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeRulesPackagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRulesPackagesError {
    fn code(&self) -> Option<&str> {
        DescribeRulesPackagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRulesPackagesError {
    /// Creates a new `DescribeRulesPackagesError`.
    pub fn new(kind: DescribeRulesPackagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRulesPackagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRulesPackagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRulesPackagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRulesPackagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRulesPackagesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRulesPackagesErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRulesPackagesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRulesPackagesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeRulesPackagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRulesPackagesErrorKind::InternalException(_inner) => Some(_inner),
            DescribeRulesPackagesErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeRulesPackagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssessmentReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssessmentReportError {
    /// Kind of error that occurred.
    pub kind: GetAssessmentReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssessmentReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssessmentReportErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You cannot perform a specified action if an assessment run is currently in
    /// progress.</p>
    AssessmentRunInProgressException(crate::error::AssessmentRunInProgressException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// <p>Used by the <a>GetAssessmentReport</a> API. The request was rejected
    /// because you tried to generate a report for an assessment run that existed before reporting
    /// was supported in Amazon Inspector. You can only generate reports for assessment runs that
    /// took place or will take place after generating reports in Amazon Inspector became
    /// available.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssessmentReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssessmentReportErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAssessmentReportErrorKind::AssessmentRunInProgressException(_inner) => _inner.fmt(f),
            GetAssessmentReportErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetAssessmentReportErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetAssessmentReportErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetAssessmentReportErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetAssessmentReportErrorKind::UnsupportedFeatureException(_inner) => _inner.fmt(f),
            GetAssessmentReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssessmentReportError {
    fn code(&self) -> Option<&str> {
        GetAssessmentReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssessmentReportError {
    /// Creates a new `GetAssessmentReportError`.
    pub fn new(kind: GetAssessmentReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssessmentReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssessmentReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssessmentReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssessmentReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAssessmentReportErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportErrorKind::AssessmentRunInProgressException`.
    pub fn is_assessment_run_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportErrorKind::AssessmentRunInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportErrorKind::UnsupportedFeatureException(_)
        )
    }
}
impl std::error::Error for GetAssessmentReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssessmentReportErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAssessmentReportErrorKind::AssessmentRunInProgressException(_inner) => Some(_inner),
            GetAssessmentReportErrorKind::InternalException(_inner) => Some(_inner),
            GetAssessmentReportErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetAssessmentReportErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetAssessmentReportErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            GetAssessmentReportErrorKind::UnsupportedFeatureException(_inner) => Some(_inner),
            GetAssessmentReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExclusionsPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExclusionsPreviewError {
    /// Kind of error that occurred.
    pub kind: GetExclusionsPreviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExclusionsPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExclusionsPreviewErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExclusionsPreviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExclusionsPreviewErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExclusionsPreviewErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetExclusionsPreviewErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetExclusionsPreviewErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetExclusionsPreviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExclusionsPreviewError {
    fn code(&self) -> Option<&str> {
        GetExclusionsPreviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExclusionsPreviewError {
    /// Creates a new `GetExclusionsPreviewError`.
    pub fn new(kind: GetExclusionsPreviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExclusionsPreviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExclusionsPreviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExclusionsPreviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExclusionsPreviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExclusionsPreviewErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExclusionsPreviewErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExclusionsPreviewErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExclusionsPreviewErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExclusionsPreviewErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExclusionsPreviewErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExclusionsPreviewErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExclusionsPreviewErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GetExclusionsPreviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExclusionsPreviewErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExclusionsPreviewErrorKind::InternalException(_inner) => Some(_inner),
            GetExclusionsPreviewErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetExclusionsPreviewErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetExclusionsPreviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTelemetryMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTelemetryMetadataError {
    /// Kind of error that occurred.
    pub kind: GetTelemetryMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTelemetryMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTelemetryMetadataErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTelemetryMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTelemetryMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetTelemetryMetadataErrorKind::InternalException(_inner) => _inner.fmt(f),
            GetTelemetryMetadataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTelemetryMetadataErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetTelemetryMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTelemetryMetadataError {
    fn code(&self) -> Option<&str> {
        GetTelemetryMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTelemetryMetadataError {
    /// Creates a new `GetTelemetryMetadataError`.
    pub fn new(kind: GetTelemetryMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTelemetryMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTelemetryMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTelemetryMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTelemetryMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTelemetryMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTelemetryMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTelemetryMetadataErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTelemetryMetadataErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTelemetryMetadataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTelemetryMetadataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTelemetryMetadataErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTelemetryMetadataErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GetTelemetryMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTelemetryMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetTelemetryMetadataErrorKind::InternalException(_inner) => Some(_inner),
            GetTelemetryMetadataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTelemetryMetadataErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetTelemetryMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssessmentRunAgents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentRunAgentsError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentRunAgentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentRunAgents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentRunAgentsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentRunAgentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentRunAgentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAssessmentRunAgentsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListAssessmentRunAgentsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAssessmentRunAgentsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListAssessmentRunAgentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentRunAgentsError {
    fn code(&self) -> Option<&str> {
        ListAssessmentRunAgentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentRunAgentsError {
    /// Creates a new `ListAssessmentRunAgentsError`.
    pub fn new(kind: ListAssessmentRunAgentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentRunAgentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentRunAgentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentRunAgentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentRunAgentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentRunAgentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunAgentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentRunAgentsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunAgentsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentRunAgentsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunAgentsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentRunAgentsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunAgentsErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListAssessmentRunAgentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentRunAgentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAssessmentRunAgentsErrorKind::InternalException(_inner) => Some(_inner),
            ListAssessmentRunAgentsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAssessmentRunAgentsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListAssessmentRunAgentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssessmentRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentRunsError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentRunsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentRunsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAssessmentRunsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListAssessmentRunsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAssessmentRunsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListAssessmentRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentRunsError {
    fn code(&self) -> Option<&str> {
        ListAssessmentRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentRunsError {
    /// Creates a new `ListAssessmentRunsError`.
    pub fn new(kind: ListAssessmentRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentRunsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentRunsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentRunsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentRunsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentRunsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentRunsErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListAssessmentRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentRunsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAssessmentRunsErrorKind::InternalException(_inner) => Some(_inner),
            ListAssessmentRunsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAssessmentRunsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListAssessmentRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssessmentTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentTargetsError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentTargetsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentTargetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAssessmentTargetsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListAssessmentTargetsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAssessmentTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentTargetsError {
    fn code(&self) -> Option<&str> {
        ListAssessmentTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentTargetsError {
    /// Creates a new `ListAssessmentTargetsError`.
    pub fn new(kind: ListAssessmentTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentTargetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentTargetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentTargetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentTargetsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentTargetsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentTargetsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentTargetsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListAssessmentTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentTargetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAssessmentTargetsErrorKind::InternalException(_inner) => Some(_inner),
            ListAssessmentTargetsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAssessmentTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssessmentTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentTemplatesErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentTemplatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAssessmentTemplatesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListAssessmentTemplatesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAssessmentTemplatesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListAssessmentTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentTemplatesError {
    fn code(&self) -> Option<&str> {
        ListAssessmentTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentTemplatesError {
    /// Creates a new `ListAssessmentTemplatesError`.
    pub fn new(kind: ListAssessmentTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentTemplatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentTemplatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentTemplatesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentTemplatesErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentTemplatesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentTemplatesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentTemplatesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentTemplatesErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListAssessmentTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentTemplatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAssessmentTemplatesErrorKind::InternalException(_inner) => Some(_inner),
            ListAssessmentTemplatesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAssessmentTemplatesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListAssessmentTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: ListEventSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventSubscriptionsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventSubscriptionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEventSubscriptionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListEventSubscriptionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListEventSubscriptionsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListEventSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventSubscriptionsError {
    fn code(&self) -> Option<&str> {
        ListEventSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventSubscriptionsError {
    /// Creates a new `ListEventSubscriptionsError`.
    pub fn new(kind: ListEventSubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventSubscriptionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSubscriptionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventSubscriptionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSubscriptionsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventSubscriptionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSubscriptionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventSubscriptionsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSubscriptionsErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListEventSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventSubscriptionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEventSubscriptionsErrorKind::InternalException(_inner) => Some(_inner),
            ListEventSubscriptionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListEventSubscriptionsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListEventSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExclusions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExclusionsError {
    /// Kind of error that occurred.
    pub kind: ListExclusionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExclusions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExclusionsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExclusionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExclusionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListExclusionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListExclusionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListExclusionsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListExclusionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExclusionsError {
    fn code(&self) -> Option<&str> {
        ListExclusionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExclusionsError {
    /// Creates a new `ListExclusionsError`.
    pub fn new(kind: ListExclusionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExclusionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExclusionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExclusionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExclusionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExclusionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExclusionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExclusionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListExclusionsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListExclusionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExclusionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExclusionsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExclusionsErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListExclusionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExclusionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListExclusionsErrorKind::InternalException(_inner) => Some(_inner),
            ListExclusionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListExclusionsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListExclusionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFindingsError {
    /// Kind of error that occurred.
    pub kind: ListFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFindingsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFindingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFindingsError {
    fn code(&self) -> Option<&str> {
        ListFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFindingsError {
    /// Creates a new `ListFindingsError`.
    pub fn new(kind: ListFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::NoSuchEntityException(_))
    }
}
impl std::error::Error for ListFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFindingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFindingsErrorKind::InternalException(_inner) => Some(_inner),
            ListFindingsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListFindingsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRulesPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRulesPackagesError {
    /// Kind of error that occurred.
    pub kind: ListRulesPackagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRulesPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRulesPackagesErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRulesPackagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRulesPackagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRulesPackagesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListRulesPackagesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListRulesPackagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRulesPackagesError {
    fn code(&self) -> Option<&str> {
        ListRulesPackagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRulesPackagesError {
    /// Creates a new `ListRulesPackagesError`.
    pub fn new(kind: ListRulesPackagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRulesPackagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRulesPackagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRulesPackagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRulesPackagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRulesPackagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRulesPackagesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRulesPackagesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListRulesPackagesErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListRulesPackagesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRulesPackagesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListRulesPackagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRulesPackagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRulesPackagesErrorKind::InternalException(_inner) => Some(_inner),
            ListRulesPackagesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListRulesPackagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PreviewAgents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PreviewAgentsError {
    /// Kind of error that occurred.
    pub kind: PreviewAgentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PreviewAgents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PreviewAgentsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>Amazon Inspector cannot assume the cross-account role that it needs to list your EC2
    /// instances during the assessment run.</p>
    InvalidCrossAccountRoleException(crate::error::InvalidCrossAccountRoleException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PreviewAgentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PreviewAgentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PreviewAgentsErrorKind::InternalException(_inner) => _inner.fmt(f),
            PreviewAgentsErrorKind::InvalidCrossAccountRoleException(_inner) => _inner.fmt(f),
            PreviewAgentsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PreviewAgentsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            PreviewAgentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PreviewAgentsError {
    fn code(&self) -> Option<&str> {
        PreviewAgentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PreviewAgentsError {
    /// Creates a new `PreviewAgentsError`.
    pub fn new(kind: PreviewAgentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PreviewAgentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PreviewAgentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PreviewAgentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PreviewAgentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PreviewAgentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PreviewAgentsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PreviewAgentsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, PreviewAgentsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `PreviewAgentsErrorKind::InvalidCrossAccountRoleException`.
    pub fn is_invalid_cross_account_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            PreviewAgentsErrorKind::InvalidCrossAccountRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `PreviewAgentsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, PreviewAgentsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `PreviewAgentsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, PreviewAgentsErrorKind::NoSuchEntityException(_))
    }
}
impl std::error::Error for PreviewAgentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PreviewAgentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PreviewAgentsErrorKind::InternalException(_inner) => Some(_inner),
            PreviewAgentsErrorKind::InvalidCrossAccountRoleException(_inner) => Some(_inner),
            PreviewAgentsErrorKind::InvalidInputException(_inner) => Some(_inner),
            PreviewAgentsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            PreviewAgentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterCrossAccountAccessRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterCrossAccountAccessRoleError {
    /// Kind of error that occurred.
    pub kind: RegisterCrossAccountAccessRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterCrossAccountAccessRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterCrossAccountAccessRoleErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>Amazon Inspector cannot assume the cross-account role that it needs to list your EC2
    /// instances during the assessment run.</p>
    InvalidCrossAccountRoleException(crate::error::InvalidCrossAccountRoleException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterCrossAccountAccessRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterCrossAccountAccessRoleErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterCrossAccountAccessRoleErrorKind::InternalException(_inner) => _inner.fmt(f),
            RegisterCrossAccountAccessRoleErrorKind::InvalidCrossAccountRoleException(_inner) => {
                _inner.fmt(f)
            }
            RegisterCrossAccountAccessRoleErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RegisterCrossAccountAccessRoleErrorKind::ServiceTemporarilyUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            RegisterCrossAccountAccessRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterCrossAccountAccessRoleError {
    fn code(&self) -> Option<&str> {
        RegisterCrossAccountAccessRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterCrossAccountAccessRoleError {
    /// Creates a new `RegisterCrossAccountAccessRoleError`.
    pub fn new(
        kind: RegisterCrossAccountAccessRoleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterCrossAccountAccessRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterCrossAccountAccessRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterCrossAccountAccessRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterCrossAccountAccessRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterCrossAccountAccessRoleErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCrossAccountAccessRoleErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCrossAccountAccessRoleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCrossAccountAccessRoleErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCrossAccountAccessRoleErrorKind::InvalidCrossAccountRoleException`.
    pub fn is_invalid_cross_account_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCrossAccountAccessRoleErrorKind::InvalidCrossAccountRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCrossAccountAccessRoleErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCrossAccountAccessRoleErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterCrossAccountAccessRoleErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterCrossAccountAccessRoleErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for RegisterCrossAccountAccessRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterCrossAccountAccessRoleErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterCrossAccountAccessRoleErrorKind::InternalException(_inner) => Some(_inner),
            RegisterCrossAccountAccessRoleErrorKind::InvalidCrossAccountRoleException(_inner) => {
                Some(_inner)
            }
            RegisterCrossAccountAccessRoleErrorKind::InvalidInputException(_inner) => Some(_inner),
            RegisterCrossAccountAccessRoleErrorKind::ServiceTemporarilyUnavailableException(
                _inner,
            ) => Some(_inner),
            RegisterCrossAccountAccessRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveAttributesFromFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveAttributesFromFindingsError {
    /// Kind of error that occurred.
    pub kind: RemoveAttributesFromFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveAttributesFromFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveAttributesFromFindingsErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveAttributesFromFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveAttributesFromFindingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveAttributesFromFindingsErrorKind::InternalException(_inner) => _inner.fmt(f),
            RemoveAttributesFromFindingsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RemoveAttributesFromFindingsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            RemoveAttributesFromFindingsErrorKind::ServiceTemporarilyUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            RemoveAttributesFromFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveAttributesFromFindingsError {
    fn code(&self) -> Option<&str> {
        RemoveAttributesFromFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveAttributesFromFindingsError {
    /// Creates a new `RemoveAttributesFromFindingsError`.
    pub fn new(kind: RemoveAttributesFromFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveAttributesFromFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveAttributesFromFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveAttributesFromFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveAttributesFromFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveAttributesFromFindingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesFromFindingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesFromFindingsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesFromFindingsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesFromFindingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesFromFindingsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesFromFindingsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesFromFindingsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveAttributesFromFindingsErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveAttributesFromFindingsErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for RemoveAttributesFromFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveAttributesFromFindingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveAttributesFromFindingsErrorKind::InternalException(_inner) => Some(_inner),
            RemoveAttributesFromFindingsErrorKind::InvalidInputException(_inner) => Some(_inner),
            RemoveAttributesFromFindingsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            RemoveAttributesFromFindingsErrorKind::ServiceTemporarilyUnavailableException(
                _inner,
            ) => Some(_inner),
            RemoveAttributesFromFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: SetTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetTagsForResourceErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SetTagsForResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            SetTagsForResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SetTagsForResourceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            SetTagsForResourceErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            SetTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetTagsForResourceError {
    fn code(&self) -> Option<&str> {
        SetTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetTagsForResourceError {
    /// Creates a new `SetTagsForResourceError`.
    pub fn new(kind: SetTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTagsForResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTagsForResourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTagsForResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTagsForResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTagsForResourceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTagsForResourceErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `SetTagsForResourceErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTagsForResourceErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for SetTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SetTagsForResourceErrorKind::InternalException(_inner) => Some(_inner),
            SetTagsForResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            SetTagsForResourceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            SetTagsForResourceErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            SetTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAssessmentRunError {
    /// Kind of error that occurred.
    pub kind: StartAssessmentRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAssessmentRunErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You started an assessment run, but one of the instances is already participating in
    /// another assessment run.</p>
    AgentsAlreadyRunningAssessmentException(crate::error::AgentsAlreadyRunningAssessmentException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>Amazon Inspector cannot assume the cross-account role that it needs to list your EC2
    /// instances during the assessment run.</p>
    InvalidCrossAccountRoleException(crate::error::InvalidCrossAccountRoleException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current
    /// AWS account limits. The error code describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAssessmentRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAssessmentRunErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartAssessmentRunErrorKind::AgentsAlreadyRunningAssessmentException(_inner) => {
                _inner.fmt(f)
            }
            StartAssessmentRunErrorKind::InternalException(_inner) => _inner.fmt(f),
            StartAssessmentRunErrorKind::InvalidCrossAccountRoleException(_inner) => _inner.fmt(f),
            StartAssessmentRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartAssessmentRunErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartAssessmentRunErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            StartAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            StartAssessmentRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAssessmentRunError {
    fn code(&self) -> Option<&str> {
        StartAssessmentRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAssessmentRunError {
    /// Creates a new `StartAssessmentRunError`.
    pub fn new(kind: StartAssessmentRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAssessmentRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAssessmentRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAssessmentRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAssessmentRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::AgentsAlreadyRunningAssessmentException`.
    pub fn is_agents_already_running_assessment_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::AgentsAlreadyRunningAssessmentException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::InvalidCrossAccountRoleException`.
    pub fn is_invalid_cross_account_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::InvalidCrossAccountRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentRunErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for StartAssessmentRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAssessmentRunErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartAssessmentRunErrorKind::AgentsAlreadyRunningAssessmentException(_inner) => {
                Some(_inner)
            }
            StartAssessmentRunErrorKind::InternalException(_inner) => Some(_inner),
            StartAssessmentRunErrorKind::InvalidCrossAccountRoleException(_inner) => Some(_inner),
            StartAssessmentRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartAssessmentRunErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartAssessmentRunErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            StartAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            StartAssessmentRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopAssessmentRunError {
    /// Kind of error that occurred.
    pub kind: StopAssessmentRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopAssessmentRunErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopAssessmentRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopAssessmentRunErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopAssessmentRunErrorKind::InternalException(_inner) => _inner.fmt(f),
            StopAssessmentRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopAssessmentRunErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            StopAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            StopAssessmentRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopAssessmentRunError {
    fn code(&self) -> Option<&str> {
        StopAssessmentRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopAssessmentRunError {
    /// Creates a new `StopAssessmentRunError`.
    pub fn new(kind: StopAssessmentRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopAssessmentRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopAssessmentRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopAssessmentRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopAssessmentRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopAssessmentRunErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAssessmentRunErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopAssessmentRunErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, StopAssessmentRunErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `StopAssessmentRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAssessmentRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StopAssessmentRunErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAssessmentRunErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `StopAssessmentRunErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for StopAssessmentRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopAssessmentRunErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopAssessmentRunErrorKind::InternalException(_inner) => Some(_inner),
            StopAssessmentRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopAssessmentRunErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            StopAssessmentRunErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            StopAssessmentRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SubscribeToEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubscribeToEventError {
    /// Kind of error that occurred.
    pub kind: SubscribeToEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SubscribeToEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubscribeToEventErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current
    /// AWS account limits. The error code describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubscribeToEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubscribeToEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SubscribeToEventErrorKind::InternalException(_inner) => _inner.fmt(f),
            SubscribeToEventErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SubscribeToEventErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            SubscribeToEventErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            SubscribeToEventErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            SubscribeToEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubscribeToEventError {
    fn code(&self) -> Option<&str> {
        SubscribeToEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SubscribeToEventError {
    /// Creates a new `SubscribeToEventError`.
    pub fn new(kind: SubscribeToEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubscribeToEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubscribeToEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubscribeToEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubscribeToEventErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SubscribeToEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeToEventErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SubscribeToEventErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, SubscribeToEventErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToEventErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeToEventErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `SubscribeToEventErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeToEventErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `SubscribeToEventErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeToEventErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `SubscribeToEventErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeToEventErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for SubscribeToEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubscribeToEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SubscribeToEventErrorKind::InternalException(_inner) => Some(_inner),
            SubscribeToEventErrorKind::InvalidInputException(_inner) => Some(_inner),
            SubscribeToEventErrorKind::LimitExceededException(_inner) => Some(_inner),
            SubscribeToEventErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            SubscribeToEventErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            SubscribeToEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UnsubscribeFromEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UnsubscribeFromEventError {
    /// Kind of error that occurred.
    pub kind: UnsubscribeFromEventErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UnsubscribeFromEvent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UnsubscribeFromEventErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UnsubscribeFromEventError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UnsubscribeFromEventErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UnsubscribeFromEventErrorKind::InternalException(_inner) => _inner.fmt(f),
            UnsubscribeFromEventErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UnsubscribeFromEventErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UnsubscribeFromEventErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UnsubscribeFromEventErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UnsubscribeFromEventError {
    fn code(&self) -> Option<&str> {
        UnsubscribeFromEventError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UnsubscribeFromEventError {
    /// Creates a new `UnsubscribeFromEventError`.
    pub fn new(kind: UnsubscribeFromEventErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UnsubscribeFromEventError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UnsubscribeFromEventErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UnsubscribeFromEventError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UnsubscribeFromEventErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UnsubscribeFromEventErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeFromEventErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UnsubscribeFromEventErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeFromEventErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UnsubscribeFromEventErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeFromEventErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UnsubscribeFromEventErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeFromEventErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UnsubscribeFromEventErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeFromEventErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for UnsubscribeFromEventError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UnsubscribeFromEventErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UnsubscribeFromEventErrorKind::InternalException(_inner) => Some(_inner),
            UnsubscribeFromEventErrorKind::InvalidInputException(_inner) => Some(_inner),
            UnsubscribeFromEventErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UnsubscribeFromEventErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            UnsubscribeFromEventErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssessmentTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssessmentTargetError {
    /// Kind of error that occurred.
    pub kind: UpdateAssessmentTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssessmentTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssessmentTargetErrorKind {
    /// <p>You do not have required permissions to access the requested resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Internal server error.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced an entity that does not exist. The
    /// error code describes the entity.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The serice is temporary unavailable.</p>
    ServiceTemporarilyUnavailableException(crate::error::ServiceTemporarilyUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssessmentTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssessmentTargetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAssessmentTargetErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateAssessmentTargetErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateAssessmentTargetErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAssessmentTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssessmentTargetError {
    fn code(&self) -> Option<&str> {
        UpdateAssessmentTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssessmentTargetError {
    /// Creates a new `UpdateAssessmentTargetError`.
    pub fn new(kind: UpdateAssessmentTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssessmentTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssessmentTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssessmentTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssessmentTargetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssessmentTargetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentTargetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentTargetErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentTargetErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentTargetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentTargetErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentTargetErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentTargetErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException`.
    pub fn is_service_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateAssessmentTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssessmentTargetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAssessmentTargetErrorKind::InternalException(_inner) => Some(_inner),
            UpdateAssessmentTargetErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateAssessmentTargetErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateAssessmentTargetErrorKind::ServiceTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateAssessmentTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The serice is temporary unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceTemporarilyUnavailableException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>You can wait and then retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl ServiceTemporarilyUnavailableException {
    /// <p>You can wait and then retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for ServiceTemporarilyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceTemporarilyUnavailableException");
        formatter.field("message", &self.message);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl ServiceTemporarilyUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceTemporarilyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceTemporarilyUnavailableException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceTemporarilyUnavailableException {}
/// See [`ServiceTemporarilyUnavailableException`](crate::error::ServiceTemporarilyUnavailableException)
pub mod service_temporarily_unavailable_exception {
    /// A builder for [`ServiceTemporarilyUnavailableException`](crate::error::ServiceTemporarilyUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>You can wait and then retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can wait and then retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceTemporarilyUnavailableException`](crate::error::ServiceTemporarilyUnavailableException)
        pub fn build(self) -> crate::error::ServiceTemporarilyUnavailableException {
            crate::error::ServiceTemporarilyUnavailableException {
                message: self.message,
                can_retry: self.can_retry,
            }
        }
    }
}
impl ServiceTemporarilyUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceTemporarilyUnavailableException`](crate::error::ServiceTemporarilyUnavailableException)
    pub fn builder() -> crate::error::service_temporarily_unavailable_exception::Builder {
        crate::error::service_temporarily_unavailable_exception::Builder::default()
    }
}

/// <p>The request was rejected because it referenced an entity that does not exist. The
/// error code describes the entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchEntityException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Code that indicates the type of error that is generated.</p>
    pub error_code: std::option::Option<crate::model::NoSuchEntityErrorCode>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl NoSuchEntityException {
    /// <p>Code that indicates the type of error that is generated.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::NoSuchEntityErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for NoSuchEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchEntityException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl NoSuchEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchEntityException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchEntityException {}
/// See [`NoSuchEntityException`](crate::error::NoSuchEntityException)
pub mod no_such_entity_exception {
    /// A builder for [`NoSuchEntityException`](crate::error::NoSuchEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::NoSuchEntityErrorCode>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn error_code(mut self, input: crate::model::NoSuchEntityErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::NoSuchEntityErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchEntityException`](crate::error::NoSuchEntityException)
        pub fn build(self) -> crate::error::NoSuchEntityException {
            crate::error::NoSuchEntityException {
                message: self.message,
                error_code: self.error_code,
                can_retry: self.can_retry,
            }
        }
    }
}
impl NoSuchEntityException {
    /// Creates a new builder-style object to manufacture [`NoSuchEntityException`](crate::error::NoSuchEntityException)
    pub fn builder() -> crate::error::no_such_entity_exception::Builder {
        crate::error::no_such_entity_exception::Builder::default()
    }
}

/// <p>The request was rejected because an invalid or out-of-range value was supplied for an
/// input parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Code that indicates the type of error that is generated.</p>
    pub error_code: std::option::Option<crate::model::InvalidInputErrorCode>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl InvalidInputException {
    /// <p>Code that indicates the type of error that is generated.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::InvalidInputErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::InvalidInputErrorCode>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn error_code(mut self, input: crate::model::InvalidInputErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::InvalidInputErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
                error_code: self.error_code,
                can_retry: self.can_retry,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>Internal server error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl InternalException {
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalException");
        formatter.field("message", &self.message);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl InternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalException {}
/// See [`InternalException`](crate::error::InternalException)
pub mod internal_exception {
    /// A builder for [`InternalException`](crate::error::InternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalException`](crate::error::InternalException)
        pub fn build(self) -> crate::error::InternalException {
            crate::error::InternalException {
                message: self.message,
                can_retry: self.can_retry,
            }
        }
    }
}
impl InternalException {
    /// Creates a new builder-style object to manufacture [`InternalException`](crate::error::InternalException)
    pub fn builder() -> crate::error::internal_exception::Builder {
        crate::error::internal_exception::Builder::default()
    }
}

/// <p>You do not have required permissions to access the requested resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Code that indicates the type of error that is generated.</p>
    pub error_code: std::option::Option<crate::model::AccessDeniedErrorCode>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl AccessDeniedException {
    /// <p>Code that indicates the type of error that is generated.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::AccessDeniedErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::AccessDeniedErrorCode>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn error_code(mut self, input: crate::model::AccessDeniedErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::AccessDeniedErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                error_code: self.error_code,
                can_retry: self.can_retry,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted to create resources beyond the current
/// AWS account limits. The error code describes the limit exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Code that indicates the type of error that is generated.</p>
    pub error_code: std::option::Option<crate::model::LimitExceededErrorCode>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl LimitExceededException {
    /// <p>Code that indicates the type of error that is generated.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::LimitExceededErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::LimitExceededErrorCode>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn error_code(mut self, input: crate::model::LimitExceededErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::LimitExceededErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
                error_code: self.error_code,
                can_retry: self.can_retry,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Amazon Inspector cannot assume the cross-account role that it needs to list your EC2
/// instances during the assessment run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCrossAccountRoleException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Code that indicates the type of error that is generated.</p>
    pub error_code: std::option::Option<crate::model::InvalidCrossAccountRoleErrorCode>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl InvalidCrossAccountRoleException {
    /// <p>Code that indicates the type of error that is generated.</p>
    pub fn error_code(
        &self,
    ) -> std::option::Option<&crate::model::InvalidCrossAccountRoleErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for InvalidCrossAccountRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCrossAccountRoleException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl InvalidCrossAccountRoleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCrossAccountRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCrossAccountRoleException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCrossAccountRoleException {}
/// See [`InvalidCrossAccountRoleException`](crate::error::InvalidCrossAccountRoleException)
pub mod invalid_cross_account_role_exception {
    /// A builder for [`InvalidCrossAccountRoleException`](crate::error::InvalidCrossAccountRoleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::InvalidCrossAccountRoleErrorCode>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn error_code(mut self, input: crate::model::InvalidCrossAccountRoleErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Code that indicates the type of error that is generated.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::InvalidCrossAccountRoleErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCrossAccountRoleException`](crate::error::InvalidCrossAccountRoleException)
        pub fn build(self) -> crate::error::InvalidCrossAccountRoleException {
            crate::error::InvalidCrossAccountRoleException {
                message: self.message,
                error_code: self.error_code,
                can_retry: self.can_retry,
            }
        }
    }
}
impl InvalidCrossAccountRoleException {
    /// Creates a new builder-style object to manufacture [`InvalidCrossAccountRoleException`](crate::error::InvalidCrossAccountRoleException)
    pub fn builder() -> crate::error::invalid_cross_account_role_exception::Builder {
        crate::error::invalid_cross_account_role_exception::Builder::default()
    }
}

/// <p>You started an assessment run, but one of the instances is already participating in
/// another assessment run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgentsAlreadyRunningAssessmentException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub agents: std::option::Option<std::vec::Vec<crate::model::AgentAlreadyRunningAssessment>>,
    /// <p></p>
    pub agents_truncated: std::option::Option<bool>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl AgentsAlreadyRunningAssessmentException {
    /// <p></p>
    pub fn agents(&self) -> std::option::Option<&[crate::model::AgentAlreadyRunningAssessment]> {
        self.agents.as_deref()
    }
    /// <p></p>
    pub fn agents_truncated(&self) -> std::option::Option<bool> {
        self.agents_truncated
    }
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for AgentsAlreadyRunningAssessmentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgentsAlreadyRunningAssessmentException");
        formatter.field("message", &self.message);
        formatter.field("agents", &self.agents);
        formatter.field("agents_truncated", &self.agents_truncated);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl AgentsAlreadyRunningAssessmentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AgentsAlreadyRunningAssessmentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AgentsAlreadyRunningAssessmentException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AgentsAlreadyRunningAssessmentException {}
/// See [`AgentsAlreadyRunningAssessmentException`](crate::error::AgentsAlreadyRunningAssessmentException)
pub mod agents_already_running_assessment_exception {
    /// A builder for [`AgentsAlreadyRunningAssessmentException`](crate::error::AgentsAlreadyRunningAssessmentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) agents:
            std::option::Option<std::vec::Vec<crate::model::AgentAlreadyRunningAssessment>>,
        pub(crate) agents_truncated: std::option::Option<bool>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `agents`.
        ///
        /// To override the contents of this collection use [`set_agents`](Self::set_agents).
        ///
        /// <p></p>
        pub fn agents(
            mut self,
            input: impl Into<crate::model::AgentAlreadyRunningAssessment>,
        ) -> Self {
            let mut v = self.agents.unwrap_or_default();
            v.push(input.into());
            self.agents = Some(v);
            self
        }
        /// <p></p>
        pub fn set_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentAlreadyRunningAssessment>>,
        ) -> Self {
            self.agents = input;
            self
        }
        /// <p></p>
        pub fn agents_truncated(mut self, input: bool) -> Self {
            self.agents_truncated = Some(input);
            self
        }
        /// <p></p>
        pub fn set_agents_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.agents_truncated = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`AgentsAlreadyRunningAssessmentException`](crate::error::AgentsAlreadyRunningAssessmentException)
        pub fn build(self) -> crate::error::AgentsAlreadyRunningAssessmentException {
            crate::error::AgentsAlreadyRunningAssessmentException {
                message: self.message,
                agents: self.agents,
                agents_truncated: self.agents_truncated,
                can_retry: self.can_retry,
            }
        }
    }
}
impl AgentsAlreadyRunningAssessmentException {
    /// Creates a new builder-style object to manufacture [`AgentsAlreadyRunningAssessmentException`](crate::error::AgentsAlreadyRunningAssessmentException)
    pub fn builder() -> crate::error::agents_already_running_assessment_exception::Builder {
        crate::error::agents_already_running_assessment_exception::Builder::default()
    }
}

/// <p>Used by the <a>GetAssessmentReport</a> API. The request was rejected
/// because you tried to generate a report for an assessment run that existed before reporting
/// was supported in Amazon Inspector. You can only generate reports for assessment runs that
/// took place or will take place after generating reports in Amazon Inspector became
/// available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedFeatureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub can_retry: std::option::Option<bool>,
}
impl UnsupportedFeatureException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for UnsupportedFeatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedFeatureException");
        formatter.field("message", &self.message);
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl UnsupportedFeatureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedFeatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedFeatureException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedFeatureException {}
/// See [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
pub mod unsupported_feature_exception {
    /// A builder for [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
        pub fn build(self) -> crate::error::UnsupportedFeatureException {
            crate::error::UnsupportedFeatureException {
                message: self.message,
                can_retry: self.can_retry,
            }
        }
    }
}
impl UnsupportedFeatureException {
    /// Creates a new builder-style object to manufacture [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
    pub fn builder() -> crate::error::unsupported_feature_exception::Builder {
        crate::error::unsupported_feature_exception::Builder::default()
    }
}

/// <p>You cannot perform a specified action if an assessment run is currently in
/// progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentRunInProgressException {
    /// <p>Details of the exception error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ARNs of the assessment runs that are currently in progress.</p>
    pub assessment_run_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Boolean value that indicates whether the ARN list of the assessment runs is
    /// truncated.</p>
    pub assessment_run_arns_truncated: std::option::Option<bool>,
    /// <p>You can immediately retry your request.</p>
    pub can_retry: std::option::Option<bool>,
}
impl AssessmentRunInProgressException {
    /// <p>The ARNs of the assessment runs that are currently in progress.</p>
    pub fn assessment_run_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.assessment_run_arns.as_deref()
    }
    /// <p>Boolean value that indicates whether the ARN list of the assessment runs is
    /// truncated.</p>
    pub fn assessment_run_arns_truncated(&self) -> std::option::Option<bool> {
        self.assessment_run_arns_truncated
    }
    /// <p>You can immediately retry your request.</p>
    pub fn can_retry(&self) -> std::option::Option<bool> {
        self.can_retry
    }
}
impl std::fmt::Debug for AssessmentRunInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentRunInProgressException");
        formatter.field("message", &self.message);
        formatter.field("assessment_run_arns", &self.assessment_run_arns);
        formatter.field(
            "assessment_run_arns_truncated",
            &self.assessment_run_arns_truncated,
        );
        formatter.field("can_retry", &self.can_retry);
        formatter.finish()
    }
}
impl AssessmentRunInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AssessmentRunInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AssessmentRunInProgressException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for AssessmentRunInProgressException {}
/// See [`AssessmentRunInProgressException`](crate::error::AssessmentRunInProgressException)
pub mod assessment_run_in_progress_exception {
    /// A builder for [`AssessmentRunInProgressException`](crate::error::AssessmentRunInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) assessment_run_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) assessment_run_arns_truncated: std::option::Option<bool>,
        pub(crate) can_retry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Details of the exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `assessment_run_arns`.
        ///
        /// To override the contents of this collection use [`set_assessment_run_arns`](Self::set_assessment_run_arns).
        ///
        /// <p>The ARNs of the assessment runs that are currently in progress.</p>
        pub fn assessment_run_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.assessment_run_arns.unwrap_or_default();
            v.push(input.into());
            self.assessment_run_arns = Some(v);
            self
        }
        /// <p>The ARNs of the assessment runs that are currently in progress.</p>
        pub fn set_assessment_run_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.assessment_run_arns = input;
            self
        }
        /// <p>Boolean value that indicates whether the ARN list of the assessment runs is
        /// truncated.</p>
        pub fn assessment_run_arns_truncated(mut self, input: bool) -> Self {
            self.assessment_run_arns_truncated = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the ARN list of the assessment runs is
        /// truncated.</p>
        pub fn set_assessment_run_arns_truncated(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.assessment_run_arns_truncated = input;
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn can_retry(mut self, input: bool) -> Self {
            self.can_retry = Some(input);
            self
        }
        /// <p>You can immediately retry your request.</p>
        pub fn set_can_retry(mut self, input: std::option::Option<bool>) -> Self {
            self.can_retry = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentRunInProgressException`](crate::error::AssessmentRunInProgressException)
        pub fn build(self) -> crate::error::AssessmentRunInProgressException {
            crate::error::AssessmentRunInProgressException {
                message: self.message,
                assessment_run_arns: self.assessment_run_arns,
                assessment_run_arns_truncated: self.assessment_run_arns_truncated,
                can_retry: self.can_retry,
            }
        }
    }
}
impl AssessmentRunInProgressException {
    /// Creates a new builder-style object to manufacture [`AssessmentRunInProgressException`](crate::error::AssessmentRunInProgressException)
    pub fn builder() -> crate::error::assessment_run_in_progress_exception::Builder {
        crate::error::assessment_run_in_progress_exception::Builder::default()
    }
}

/// <p>The request is rejected. The specified assessment template is currently generating an
/// exclusions preview.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreviewGenerationInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PreviewGenerationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreviewGenerationInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreviewGenerationInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreviewGenerationInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreviewGenerationInProgressException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreviewGenerationInProgressException {}
/// See [`PreviewGenerationInProgressException`](crate::error::PreviewGenerationInProgressException)
pub mod preview_generation_in_progress_exception {
    /// A builder for [`PreviewGenerationInProgressException`](crate::error::PreviewGenerationInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreviewGenerationInProgressException`](crate::error::PreviewGenerationInProgressException)
        pub fn build(self) -> crate::error::PreviewGenerationInProgressException {
            crate::error::PreviewGenerationInProgressException {
                message: self.message,
            }
        }
    }
}
impl PreviewGenerationInProgressException {
    /// Creates a new builder-style object to manufacture [`PreviewGenerationInProgressException`](crate::error::PreviewGenerationInProgressException)
    pub fn builder() -> crate::error::preview_generation_in_progress_exception::Builder {
        crate::error::preview_generation_in_progress_exception::Builder::default()
    }
}
